/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.apache.juli.AsyncFileHandler;
import org.apache.juli.DateFormatCache;

public class OneLineFormatter
extends Formatter {
    private static final String UNKNOWN_THREAD_NAME = "Unknown thread with ID ";
    private static final Object threadMxBeanLock = new Object();
    private static volatile ThreadMXBean threadMxBean = null;
    private static final int THREAD_NAME_CACHE_SIZE = 10000;
    private static final ThreadLocal<ThreadNameCache> threadNameCache = new ThreadLocal<ThreadNameCache>(){

        @Override
        protected ThreadNameCache initialValue() {
            return new ThreadNameCache(10000);
        }
    };
    private static final String DEFAULT_TIME_FORMAT = "dd-MMM-yyyy HH:mm:ss.SSS";
    private static final int globalCacheSize = 30;
    private static final int localCacheSize = 5;
    private ThreadLocal<DateFormatCache> localDateCache;
    private volatile MillisHandling millisHandling = MillisHandling.APPEND;

    public OneLineFormatter() {
        String string = LogManager.getLogManager().getProperty(OneLineFormatter.class.getName() + ".timeFormat");
        if (string == null) {
            string = DEFAULT_TIME_FORMAT;
        }
        this.setTimeFormat(string);
    }

    public void setTimeFormat(String string) {
        String string2;
        if (string.endsWith(".SSS")) {
            string2 = string.substring(0, string.length() - 4);
            this.millisHandling = MillisHandling.APPEND;
        } else if (string.contains("SSS")) {
            this.millisHandling = MillisHandling.REPLACE_SSS;
            string2 = string;
        } else if (string.contains("SS")) {
            this.millisHandling = MillisHandling.REPLACE_SS;
            string2 = string;
        } else if (string.contains("S")) {
            this.millisHandling = MillisHandling.REPLACE_S;
            string2 = string;
        } else {
            this.millisHandling = MillisHandling.NONE;
            string2 = string;
        }
        final DateFormatCache dateFormatCache = new DateFormatCache(30, string2, null);
        this.localDateCache = new ThreadLocal<DateFormatCache>(){

            @Override
            protected DateFormatCache initialValue() {
                return new DateFormatCache(5, string2, dateFormatCache);
            }
        };
    }

    public String getTimeFormat() {
        return this.localDateCache.get().getTimeFormat();
    }

    @Override
    public String format(LogRecord logRecord) {
        StringBuilder stringBuilder = new StringBuilder();
        this.addTimestamp(stringBuilder, logRecord.getMillis());
        stringBuilder.append(' ');
        stringBuilder.append(logRecord.getLevel().getLocalizedName());
        stringBuilder.append(' ');
        stringBuilder.append('[');
        if (Thread.currentThread() instanceof AsyncFileHandler.LoggerThread) {
            stringBuilder.append(OneLineFormatter.getThreadName(logRecord.getThreadID()));
        } else {
            stringBuilder.append(Thread.currentThread().getName());
        }
        stringBuilder.append(']');
        stringBuilder.append(' ');
        stringBuilder.append(logRecord.getSourceClassName());
        stringBuilder.append('.');
        stringBuilder.append(logRecord.getSourceMethodName());
        stringBuilder.append(' ');
        stringBuilder.append(this.formatMessage(logRecord));
        stringBuilder.append(System.lineSeparator());
        if (logRecord.getThrown() != null) {
            StringWriter stringWriter = new StringWriter();
            IndentingPrintWriter indentingPrintWriter = new IndentingPrintWriter(stringWriter);
            logRecord.getThrown().printStackTrace(indentingPrintWriter);
            indentingPrintWriter.close();
            stringBuilder.append(stringWriter.getBuffer());
        }
        return stringBuilder.toString();
    }

    protected void addTimestamp(StringBuilder stringBuilder, long l) {
        String string = this.localDateCache.get().getFormat(l);
        if (this.millisHandling == MillisHandling.NONE) {
            stringBuilder.append(string);
        } else if (this.millisHandling == MillisHandling.APPEND) {
            stringBuilder.append(string);
            long l2 = l % 1000L;
            stringBuilder.append('.');
            if (l2 < 100L) {
                if (l2 < 10L) {
                    stringBuilder.append('0');
                    stringBuilder.append('0');
                } else {
                    stringBuilder.append('0');
                }
            }
            stringBuilder.append(l2);
        } else {
            long l3 = l % 1000L;
            int n = string.indexOf(35);
            stringBuilder.append(string.subSequence(0, n));
            if (l3 < 100L && this.millisHandling == MillisHandling.REPLACE_SSS) {
                stringBuilder.append('0');
                if (l3 < 10L) {
                    stringBuilder.append('0');
                }
            } else if (l3 < 10L && this.millisHandling == MillisHandling.REPLACE_SS) {
                stringBuilder.append('0');
            }
            stringBuilder.append(l3);
            if (this.millisHandling == MillisHandling.REPLACE_SSS) {
                stringBuilder.append(string.substring(n + 3));
            } else if (this.millisHandling == MillisHandling.REPLACE_SS) {
                stringBuilder.append(string.substring(n + 2));
            } else {
                stringBuilder.append(string.substring(n + 1));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getThreadName(int n) {
        Map map = threadNameCache.get();
        String string = (String)map.get(n);
        if (string != null) {
            return string;
        }
        if (n > 0x3FFFFFFF) {
            string = UNKNOWN_THREAD_NAME + n;
        } else {
            Object object;
            if (threadMxBean == null) {
                object = threadMxBeanLock;
                synchronized (object) {
                    if (threadMxBean == null) {
                        threadMxBean = ManagementFactory.getThreadMXBean();
                    }
                }
            }
            if ((object = threadMxBean.getThreadInfo(n)) == null) {
                return Long.toString(n);
            }
            string = ((ThreadInfo)object).getThreadName();
        }
        map.put(n, string);
        return string;
    }

    private static enum MillisHandling {
        NONE,
        APPEND,
        REPLACE_S,
        REPLACE_SS,
        REPLACE_SSS;

    }

    private static class IndentingPrintWriter
    extends PrintWriter {
        public IndentingPrintWriter(Writer writer) {
            super(writer);
        }

        @Override
        public void println(Object object) {
            super.print('\t');
            super.println(object);
        }
    }

    private static class ThreadNameCache
    extends LinkedHashMap<Integer, String> {
        private static final long serialVersionUID = 1L;
        private final int cacheSize;

        public ThreadNameCache(int n) {
            this.cacheSize = n;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, String> entry) {
            return this.size() > this.cacheSize;
        }
    }
}

