# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
GeomLib module, see official documentation at
https://www.opencascade.com/doc/occt-7.4.0/refman/html/package_geomlib.html
"""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _GeomLib
else:
    import _GeomLib

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _GeomLib.delete_SwigPyIterator

    def value(self) -> "PyObject *":
        return _GeomLib.SwigPyIterator_value(self)

    def incr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _GeomLib.SwigPyIterator_incr(self, n)

    def decr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _GeomLib.SwigPyIterator_decr(self, n)

    def distance(self, x: "SwigPyIterator") -> "ptrdiff_t":
        return _GeomLib.SwigPyIterator_distance(self, x)

    def equal(self, x: "SwigPyIterator") -> "bool":
        return _GeomLib.SwigPyIterator_equal(self, x)

    def copy(self) -> "swig::SwigPyIterator *":
        return _GeomLib.SwigPyIterator_copy(self)

    def next(self) -> "PyObject *":
        return _GeomLib.SwigPyIterator_next(self)

    def __next__(self) -> "PyObject *":
        return _GeomLib.SwigPyIterator___next__(self)

    def previous(self) -> "PyObject *":
        return _GeomLib.SwigPyIterator_previous(self)

    def advance(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _GeomLib.SwigPyIterator_advance(self, n)

    def __eq__(self, x: "SwigPyIterator") -> "bool":
        return _GeomLib.SwigPyIterator___eq__(self, x)

    def __ne__(self, x: "SwigPyIterator") -> "bool":
        return _GeomLib.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _GeomLib.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _GeomLib.SwigPyIterator___isub__(self, n)

    def __add__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _GeomLib.SwigPyIterator___add__(self, n)

    def __sub__(self, *args) -> "ptrdiff_t":
        return _GeomLib.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _GeomLib:
_GeomLib.SwigPyIterator_swigregister(SwigPyIterator)


def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error: "Standard_Failure", method_name: "std::string", class_name: "std::string") -> "void":
    return _GeomLib.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.Geom
import OCC.Core.gp
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.GeomAbs
import OCC.Core.TColgp
import OCC.Core.Adaptor3d
import OCC.Core.TopAbs
import OCC.Core.Adaptor2d
import OCC.Core.Geom2d
import OCC.Core.math
import OCC.Core.Message
import OCC.Core.OSD
import OCC.Core.AdvApprox
import OCC.Core.PLib

from enum import IntEnum
from OCC.Core.Exception import *

GeomLib_NoError = _GeomLib.GeomLib_NoError
GeomLib_NotEnoughtPoints = _GeomLib.GeomLib_NotEnoughtPoints
GeomLib_DegreeSmallerThan3 = _GeomLib.GeomLib_DegreeSmallerThan3
GeomLib_InversionProblem = _GeomLib.GeomLib_InversionProblem


class GeomLib_InterpolationErrors(IntEnum):
	GeomLib_NoError = 0
	GeomLib_NotEnoughtPoints = 1
	GeomLib_DegreeSmallerThan3 = 2
	GeomLib_InversionProblem = 3
GeomLib_NoError = GeomLib_InterpolationErrors.GeomLib_NoError
GeomLib_NotEnoughtPoints = GeomLib_InterpolationErrors.GeomLib_NotEnoughtPoints
GeomLib_DegreeSmallerThan3 = GeomLib_InterpolationErrors.GeomLib_DegreeSmallerThan3
GeomLib_InversionProblem = GeomLib_InterpolationErrors.GeomLib_InversionProblem

class GeomLib_Array1OfMat(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self) -> "NCollection_Array1< gp_Mat >::iterator":
        return _GeomLib.GeomLib_Array1OfMat_begin(self)

    def end(self) -> "NCollection_Array1< gp_Mat >::iterator":
        return _GeomLib.GeomLib_Array1OfMat_end(self)

    def cbegin(self) -> "NCollection_Array1< gp_Mat >::const_iterator":
        return _GeomLib.GeomLib_Array1OfMat_cbegin(self)

    def cend(self) -> "NCollection_Array1< gp_Mat >::const_iterator":
        return _GeomLib.GeomLib_Array1OfMat_cend(self)

    def __init__(self, *args):
        _GeomLib.GeomLib_Array1OfMat_swiginit(self, _GeomLib.new_GeomLib_Array1OfMat(*args))

    def Init(self, theValue: "gp_Mat") -> "void":
        return _GeomLib.GeomLib_Array1OfMat_Init(self, theValue)

    def Size(self) -> "Standard_Integer":
        return _GeomLib.GeomLib_Array1OfMat_Size(self)

    def Length(self) -> "Standard_Integer":
        return _GeomLib.GeomLib_Array1OfMat_Length(self)

    def IsEmpty(self) -> "Standard_Boolean":
        return _GeomLib.GeomLib_Array1OfMat_IsEmpty(self)

    def Lower(self) -> "Standard_Integer":
        return _GeomLib.GeomLib_Array1OfMat_Lower(self)

    def Upper(self) -> "Standard_Integer":
        return _GeomLib.GeomLib_Array1OfMat_Upper(self)

    def IsDeletable(self) -> "Standard_Boolean":
        return _GeomLib.GeomLib_Array1OfMat_IsDeletable(self)

    def IsAllocated(self) -> "Standard_Boolean":
        return _GeomLib.GeomLib_Array1OfMat_IsAllocated(self)

    def Assign(self, theOther: "GeomLib_Array1OfMat") -> "NCollection_Array1< gp_Mat > &":
        return _GeomLib.GeomLib_Array1OfMat_Assign(self, theOther)

    def Move(self, theOther: "GeomLib_Array1OfMat") -> "NCollection_Array1< gp_Mat > &":
        return _GeomLib.GeomLib_Array1OfMat_Move(self, theOther)

    def Set(self, *args) -> "NCollection_Array1< gp_Mat > &":
        return _GeomLib.GeomLib_Array1OfMat_Set(self, *args)

    def First(self) -> "gp_Mat const &":
        return _GeomLib.GeomLib_Array1OfMat_First(self)

    def ChangeFirst(self) -> "gp_Mat &":
        return _GeomLib.GeomLib_Array1OfMat_ChangeFirst(self)

    def Last(self) -> "gp_Mat const &":
        return _GeomLib.GeomLib_Array1OfMat_Last(self)

    def ChangeLast(self) -> "gp_Mat &":
        return _GeomLib.GeomLib_Array1OfMat_ChangeLast(self)

    def Value(self, theIndex: "Standard_Integer const") -> "gp_Mat const &":
        return _GeomLib.GeomLib_Array1OfMat_Value(self, theIndex)

    def ChangeValue(self, theIndex: "Standard_Integer const") -> "gp_Mat &":
        return _GeomLib.GeomLib_Array1OfMat_ChangeValue(self, theIndex)

    def __call__(self, *args) -> "gp_Mat &":
        return _GeomLib.GeomLib_Array1OfMat___call__(self, *args)

    def SetValue(self, theIndex: "Standard_Integer const", theItem: "gp_Mat") -> "void":
        return _GeomLib.GeomLib_Array1OfMat_SetValue(self, theIndex, theItem)

    def Resize(self, theLower: "Standard_Integer const", theUpper: "Standard_Integer const", theToCopyData: "Standard_Boolean const") -> "void":
        return _GeomLib.GeomLib_Array1OfMat_Resize(self, theLower, theUpper, theToCopyData)
    __swig_destroy__ = _GeomLib.delete_GeomLib_Array1OfMat

    def __getitem__(self, index):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            return self.Value(index + self.Lower())

    def __setitem__(self, index, value):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            self.SetValue(index + self.Lower(), value)

    def __len__(self):
        return self.Length()

    def __iter__(self):
        self.low = self.Lower()
        self.up = self.Upper()
        self.current = self.Lower() - 1
        return self

    def next(self):
        if self.current >= self.Upper():
            raise StopIteration
        else:
            self.current += 1
        return self.Value(self.current)

    __next__ = next


# Register GeomLib_Array1OfMat in _GeomLib:
_GeomLib.GeomLib_Array1OfMat_swigregister(GeomLib_Array1OfMat)

class geomlib(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def AdjustExtremity(*args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        Curve: Geom_BoundedCurve
        P1: gp_Pnt
        P2: gp_Pnt
        T1: gp_Vec
        T2: gp_Vec

        Returns
        -------
        None

        """
        return _GeomLib.geomlib_AdjustExtremity(*args)

    @staticmethod
    def AxeOfInertia(*args) -> "Standard_Boolean &":
        r"""
        Compute axes of inertia, of some points -- -- -- <axe>.location() is the barycentre -- -- -- -- -- <axe>.xdirection is the axe of upper inertia -- -- -- -- <axe>.direction is the normal to the average plane -- -- -- issingular is true if points are on line -- tol is used to determine singular cases.

        Parameters
        ----------
        Points: TColgp_Array1OfPnt
        Axe: gp_Ax2
        Tol: float,optional
        	default value is 1.0e-7

        Returns
        -------
        IsSingular: bool

        """
        return _GeomLib.geomlib_AxeOfInertia(*args)

    @staticmethod
    def BuildCurve3d(*args) -> "Standard_Real &, Standard_Real &":
        r"""
        No available documentation.

        Parameters
        ----------
        Tolerance: float
        CurvePtr: Adaptor3d_CurveOnSurface
        FirstParameter: float
        LastParameter: float
        NewCurvePtr: Geom_Curve
        Continuity: GeomAbs_Shape,optional
        	default value is GeomAbs_C1
        MaxDegree: int,optional
        	default value is 14
        MaxSegment: int,optional
        	default value is 30

        Returns
        -------
        MaxDeviation: float
        AverageDeviation: float

        """
        return _GeomLib.geomlib_BuildCurve3d(*args)

    @staticmethod
    def CancelDenominatorDerivative(*args) -> "void":
        r"""
        Cancel,on the boudaries,the denominator first derivative in the directions wished by the user and set its value to 1.

        Parameters
        ----------
        BSurf: Geom_BSplineSurface
        UDirection: bool
        VDirection: bool

        Returns
        -------
        None

        """
        return _GeomLib.geomlib_CancelDenominatorDerivative(*args)

    @staticmethod
    def DensifyArray1OfReal(*args) -> "void":
        r"""
        This makes sure that there is at least minnumpoints in outparameters taking into account the parameters in the inparameters array provided those are in order, that is the sequence of real in the inparameter is strictly non decreasing.

        Parameters
        ----------
        MinNumPoints: int
        InParameters: TColStd_Array1OfReal
        OutParameters: TColStd_HArray1OfReal

        Returns
        -------
        None

        """
        return _GeomLib.geomlib_DensifyArray1OfReal(*args)

    @staticmethod
    def EvalMaxDistanceAlongParameter(*args) -> "Standard_Real &":
        r"""
        This will compute the maximum distancef at the parameters given in the parameters array by projecting from the curve to the reference curve and taking the minimum distance than the maximum will be taken on those minimas.

        Parameters
        ----------
        Curve: Adaptor3d_Curve
        AReferenceCurve: Adaptor3d_Curve
        Tolerance: float
        Parameters: TColStd_Array1OfReal

        Returns
        -------
        MaxDistance: float

        """
        return _GeomLib.geomlib_EvalMaxDistanceAlongParameter(*args)

    @staticmethod
    def EvalMaxParametricDistance(*args) -> "Standard_Real &":
        r"""
        This will compute the maximum distance at the parameters given in the parameters array by evaluating each parameter the two curves and taking the maximum of the evaluated distance.

        Parameters
        ----------
        Curve: Adaptor3d_Curve
        AReferenceCurve: Adaptor3d_Curve
        Tolerance: float
        Parameters: TColStd_Array1OfReal

        Returns
        -------
        MaxDistance: float

        """
        return _GeomLib.geomlib_EvalMaxParametricDistance(*args)

    @staticmethod
    def ExtendCurveToPoint(*args) -> "void":
        r"""
        Extends the bounded curve curve to the point point. the extension is built: - at the end of the curve if after equals true, or - at the beginning of the curve if after equals false. the extension is performed according to a degree of continuity equal to cont, which in its turn must be equal to 1, 2 or 3. this function converts the bounded curve curve into a bspline curve. warning - nothing is done, and curve is not modified if cont is not equal to 1, 2 or 3. - it is recommended that the extension should not be too large with respect to the size of the bounded curve curve: point must not be located too far from one of the extremities of curve.

        Parameters
        ----------
        Curve: Geom_BoundedCurve
        Point: gp_Pnt
        Cont: int
        After: bool

        Returns
        -------
        None

        """
        return _GeomLib.geomlib_ExtendCurveToPoint(*args)

    @staticmethod
    def ExtendSurfByLength(*args) -> "void":
        r"""
        Extends the bounded surface surf along one of its boundaries. the chord length of the extension is equal to length. the direction of the extension is given as: - the u parametric direction of surf, if inu equals true, or - the v parametric direction of surf, if inu equals false. in this parametric direction, the extension is built on the side of: - the last parameter of surf, if after equals true, or - the first parameter of surf, if after equals false. the extension is performed according to a degree of continuity equal to cont, which in its turn must be equal to 1, 2 or 3. this function converts the bounded surface surf into a bspline surface. warning - nothing is done, and surf is not modified if cont is not equal to 1, 2 or 3. - it is recommended that length, the size of the extension should not be too large with respect to the size of the bounded surface surf. - surf must not be a periodic bspline surface in the parametric direction corresponding to the direction of extension.

        Parameters
        ----------
        Surf: Geom_BoundedSurface
        Length: float
        Cont: int
        InU: bool
        After: bool

        Returns
        -------
        None

        """
        return _GeomLib.geomlib_ExtendSurfByLength(*args)

    @staticmethod
    def FuseIntervals(*args) -> "void":
        r"""
        This method fuse intervals interval1 and interval2 with specified confusion @param interval1 [in] first interval to fuse @param interval2 [in] second interval to fuse @param confision [in] tolerance to compare intervals @param isadjusttofirstinterval [in] flag to set method of fusion, if intervals are close  if false, intervals are fusing by half-division methdod  if true, intervals are fusing by selecting value from interval1 @param fusion [out] output interval .

        Parameters
        ----------
        Interval1: TColStd_Array1OfReal
        Interval2: TColStd_Array1OfReal
        Fusion: TColStd_SequenceOfReal
        Confusion: float,optional
        	default value is 1.0e-9
        IsAdjustToFirstInterval: bool,optional
        	default value is Standard_False

        Returns
        -------
        None

        """
        return _GeomLib.geomlib_FuseIntervals(*args)

    @staticmethod
    def GTransform(*args) -> "opencascade::handle< Geom2d_Curve >":
        r"""
        Computes the curve 3d from package geom corresponding to the curve 3d from package geom, transformed with the transformation <gtrsf> warning : this method may return a null handle if it's impossible to compute the transformation of a curve. it's not implemented when : 1) the curve is an infinite parabola or hyperbola 2) the curve is an offsetcurve.

        Parameters
        ----------
        Curve: Geom2d_Curve
        GTrsf: gp_GTrsf2d

        Returns
        -------
        opencascade::handle<Geom2d_Curve>

        """
        return _GeomLib.geomlib_GTransform(*args)

    @staticmethod
    def Inertia(*args) -> "Standard_Real &, Standard_Real &, Standard_Real &":
        r"""
        Compute principale axes of inertia, and dispertion value of some points.

        Parameters
        ----------
        Points: TColgp_Array1OfPnt
        Bary: gp_Pnt
        XDir: gp_Dir
        YDir: gp_Dir

        Returns
        -------
        Xgap: float
        YGap: float
        ZGap: float

        """
        return _GeomLib.geomlib_Inertia(*args)

    @staticmethod
    def IsBSplUClosed(*args) -> "Standard_Boolean":
        r"""
        Returns true if the poles of u1 isoline and the poles of u2 isoline of surface are identical according to tolerance criterion. for rational surfaces weights(i)*poles(i) are checked.

        Parameters
        ----------
        S: Geom_BSplineSurface
        U1: float
        U2: float
        Tol: float

        Returns
        -------
        bool

        """
        return _GeomLib.geomlib_IsBSplUClosed(*args)

    @staticmethod
    def IsBSplVClosed(*args) -> "Standard_Boolean":
        r"""
        Returns true if the poles of v1 isoline and the poles of v2 isoline of surface are identical according to tolerance criterion. for rational surfaces weights(i)*poles(i) are checked.

        Parameters
        ----------
        S: Geom_BSplineSurface
        V1: float
        V2: float
        Tol: float

        Returns
        -------
        bool

        """
        return _GeomLib.geomlib_IsBSplVClosed(*args)

    @staticmethod
    def IsBzUClosed(*args) -> "Standard_Boolean":
        r"""
        Returns true if the poles of u1 isoline and the poles of u2 isoline of surface are identical according to tolerance criterion.

        Parameters
        ----------
        S: Geom_BezierSurface
        U1: float
        U2: float
        Tol: float

        Returns
        -------
        bool

        """
        return _GeomLib.geomlib_IsBzUClosed(*args)

    @staticmethod
    def IsBzVClosed(*args) -> "Standard_Boolean":
        r"""
        Returns true if the poles of v1 isoline and the poles of v2 isoline of surface are identical according to tolerance criterion.

        Parameters
        ----------
        S: Geom_BezierSurface
        V1: float
        V2: float
        Tol: float

        Returns
        -------
        bool

        """
        return _GeomLib.geomlib_IsBzVClosed(*args)

    @staticmethod
    def IsClosed(*args) -> "Standard_Boolean &, Standard_Boolean &":
        r"""
        This method defines if opposite boundaries of surface coincide with given tolerance.

        Parameters
        ----------
        S: Geom_Surface
        Tol: float

        Returns
        -------
        isUClosed: bool
        isVClosed: bool

        """
        return _GeomLib.geomlib_IsClosed(*args)

    @staticmethod
    def NormEstim(*args) -> "Standard_Integer":
        r"""
        No available documentation.

        Parameters
        ----------
        S: Geom_Surface
        UV: gp_Pnt2d
        Tol: float
        N: gp_Dir

        Returns
        -------
        int

        """
        return _GeomLib.geomlib_NormEstim(*args)

    @staticmethod
    def RemovePointsFromArray(*args) -> "void":
        r"""
        Warning! this assume that the inparameter is an increasing sequence of real number and it will not check for that : unpredictable result can happen if this is not satisfied. it is the caller responsability to check for that property. //! this method makes uniform numpoints segments s1,...snumpoints out of the segment defined by the first parameter and the last parameter ofthe inparameter ; keeps only one point of the inparameters set of parameter in each of the uniform segments taking care of the first and the last parameters. for the ith segment the element of the inparameter is the one that is the first to exceed the midpoint of the segment and to fall before the midpoint of the next segment there will be at the end at most numpoints + 1 if numpoints > 2 in the outparameters array.

        Parameters
        ----------
        NumPoints: int
        InParameters: TColStd_Array1OfReal
        OutParameters: TColStd_HArray1OfReal

        Returns
        -------
        None

        """
        return _GeomLib.geomlib_RemovePointsFromArray(*args)

    @staticmethod
    def SameRange(*args) -> "void":
        r"""
        Make the curve curve2dptr have the imposed range first to list the most economic way, that is if it can change the range without changing the nature of the curve it will try to do that. otherwise it will produce a bspline curve that has the required range.

        Parameters
        ----------
        Tolerance: float
        Curve2dPtr: Geom2d_Curve
        First: float
        Last: float
        RequestedFirst: float
        RequestedLast: float
        NewCurve2dPtr: Geom2d_Curve

        Returns
        -------
        None

        """
        return _GeomLib.geomlib_SameRange(*args)

    @staticmethod
    def To3d(*args) -> "opencascade::handle< Geom_Curve >":
        r"""
        Computes the curve 3d from package geom corresponding to curve 2d from package geom2d, on the plan defined with the local coordinate system position.

        Parameters
        ----------
        Position: gp_Ax2
        Curve2d: Geom2d_Curve

        Returns
        -------
        opencascade::handle<Geom_Curve>

        """
        return _GeomLib.geomlib_To3d(*args)

    @staticmethod
    def buildC3dOnIsoLine(*args) -> "opencascade::handle< Geom_Curve >":
        r"""
        Builds 3d curve for a isoline. this method takes corresponding isoline from the input surface. @param thec2d trimmed curve to be approximated. @param theisu flag indicating that line is u const. @param theparam line parameter. @param theisforward flag indicating forward parameterization on a isoline. returns standard_true when 3d curve is built and standard_false otherwise.

        Parameters
        ----------
        theC2D: Adaptor2d_HCurve2d
        theSurf: Adaptor3d_HSurface
        theFirst: float
        theLast: float
        theTolerance: float
        theIsU: bool
        theParam: float
        theIsForward: bool

        Returns
        -------
        opencascade::handle<Geom_Curve>

        """
        return _GeomLib.geomlib_buildC3dOnIsoLine(*args)

    @staticmethod
    def isIsoLine(*args) -> "Standard_Boolean &, Standard_Real &, Standard_Boolean &":
        r"""
        Checks whether the 2d curve is a isoline. it can be represented by b-spline, bezier, or geometric line. this line should have natural parameterization. @param thec2d trimmed curve to be checked. @param theisu flag indicating that line is u const. @param theparam line parameter. @param theisforward flag indicating forward parameterization on a isoline. returns standard_true when 2d curve is a line and standard_false otherwise.

        Parameters
        ----------
        theC2D: Adaptor2d_HCurve2d

        Returns
        -------
        theIsU: bool
        theParam: float
        theIsForward: bool

        """
        return _GeomLib.geomlib_isIsoLine(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _GeomLib.geomlib_swiginit(self, _GeomLib.new_geomlib())
    __swig_destroy__ = _GeomLib.delete_geomlib

# Register geomlib in _GeomLib:
_GeomLib.geomlib_swigregister(geomlib)

def geomlib_AdjustExtremity(*args) -> "void":
    r"""
    No available documentation.

    Parameters
    ----------
    Curve: Geom_BoundedCurve
    P1: gp_Pnt
    P2: gp_Pnt
    T1: gp_Vec
    T2: gp_Vec

    Returns
    -------
    None

    """
    return _GeomLib.geomlib_AdjustExtremity(*args)

def geomlib_AxeOfInertia(*args) -> "Standard_Boolean &":
    r"""
    Compute axes of inertia, of some points -- -- -- <axe>.location() is the barycentre -- -- -- -- -- <axe>.xdirection is the axe of upper inertia -- -- -- -- <axe>.direction is the normal to the average plane -- -- -- issingular is true if points are on line -- tol is used to determine singular cases.

    Parameters
    ----------
    Points: TColgp_Array1OfPnt
    Axe: gp_Ax2
    Tol: float,optional
    	default value is 1.0e-7

    Returns
    -------
    IsSingular: bool

    """
    return _GeomLib.geomlib_AxeOfInertia(*args)

def geomlib_BuildCurve3d(*args) -> "Standard_Real &, Standard_Real &":
    r"""
    No available documentation.

    Parameters
    ----------
    Tolerance: float
    CurvePtr: Adaptor3d_CurveOnSurface
    FirstParameter: float
    LastParameter: float
    NewCurvePtr: Geom_Curve
    Continuity: GeomAbs_Shape,optional
    	default value is GeomAbs_C1
    MaxDegree: int,optional
    	default value is 14
    MaxSegment: int,optional
    	default value is 30

    Returns
    -------
    MaxDeviation: float
    AverageDeviation: float

    """
    return _GeomLib.geomlib_BuildCurve3d(*args)

def geomlib_CancelDenominatorDerivative(*args) -> "void":
    r"""
    Cancel,on the boudaries,the denominator first derivative in the directions wished by the user and set its value to 1.

    Parameters
    ----------
    BSurf: Geom_BSplineSurface
    UDirection: bool
    VDirection: bool

    Returns
    -------
    None

    """
    return _GeomLib.geomlib_CancelDenominatorDerivative(*args)

def geomlib_DensifyArray1OfReal(*args) -> "void":
    r"""
    This makes sure that there is at least minnumpoints in outparameters taking into account the parameters in the inparameters array provided those are in order, that is the sequence of real in the inparameter is strictly non decreasing.

    Parameters
    ----------
    MinNumPoints: int
    InParameters: TColStd_Array1OfReal
    OutParameters: TColStd_HArray1OfReal

    Returns
    -------
    None

    """
    return _GeomLib.geomlib_DensifyArray1OfReal(*args)

def geomlib_EvalMaxDistanceAlongParameter(*args) -> "Standard_Real &":
    r"""
    This will compute the maximum distancef at the parameters given in the parameters array by projecting from the curve to the reference curve and taking the minimum distance than the maximum will be taken on those minimas.

    Parameters
    ----------
    Curve: Adaptor3d_Curve
    AReferenceCurve: Adaptor3d_Curve
    Tolerance: float
    Parameters: TColStd_Array1OfReal

    Returns
    -------
    MaxDistance: float

    """
    return _GeomLib.geomlib_EvalMaxDistanceAlongParameter(*args)

def geomlib_EvalMaxParametricDistance(*args) -> "Standard_Real &":
    r"""
    This will compute the maximum distance at the parameters given in the parameters array by evaluating each parameter the two curves and taking the maximum of the evaluated distance.

    Parameters
    ----------
    Curve: Adaptor3d_Curve
    AReferenceCurve: Adaptor3d_Curve
    Tolerance: float
    Parameters: TColStd_Array1OfReal

    Returns
    -------
    MaxDistance: float

    """
    return _GeomLib.geomlib_EvalMaxParametricDistance(*args)

def geomlib_ExtendCurveToPoint(*args) -> "void":
    r"""
    Extends the bounded curve curve to the point point. the extension is built: - at the end of the curve if after equals true, or - at the beginning of the curve if after equals false. the extension is performed according to a degree of continuity equal to cont, which in its turn must be equal to 1, 2 or 3. this function converts the bounded curve curve into a bspline curve. warning - nothing is done, and curve is not modified if cont is not equal to 1, 2 or 3. - it is recommended that the extension should not be too large with respect to the size of the bounded curve curve: point must not be located too far from one of the extremities of curve.

    Parameters
    ----------
    Curve: Geom_BoundedCurve
    Point: gp_Pnt
    Cont: int
    After: bool

    Returns
    -------
    None

    """
    return _GeomLib.geomlib_ExtendCurveToPoint(*args)

def geomlib_ExtendSurfByLength(*args) -> "void":
    r"""
    Extends the bounded surface surf along one of its boundaries. the chord length of the extension is equal to length. the direction of the extension is given as: - the u parametric direction of surf, if inu equals true, or - the v parametric direction of surf, if inu equals false. in this parametric direction, the extension is built on the side of: - the last parameter of surf, if after equals true, or - the first parameter of surf, if after equals false. the extension is performed according to a degree of continuity equal to cont, which in its turn must be equal to 1, 2 or 3. this function converts the bounded surface surf into a bspline surface. warning - nothing is done, and surf is not modified if cont is not equal to 1, 2 or 3. - it is recommended that length, the size of the extension should not be too large with respect to the size of the bounded surface surf. - surf must not be a periodic bspline surface in the parametric direction corresponding to the direction of extension.

    Parameters
    ----------
    Surf: Geom_BoundedSurface
    Length: float
    Cont: int
    InU: bool
    After: bool

    Returns
    -------
    None

    """
    return _GeomLib.geomlib_ExtendSurfByLength(*args)

def geomlib_FuseIntervals(*args) -> "void":
    r"""
    This method fuse intervals interval1 and interval2 with specified confusion @param interval1 [in] first interval to fuse @param interval2 [in] second interval to fuse @param confision [in] tolerance to compare intervals @param isadjusttofirstinterval [in] flag to set method of fusion, if intervals are close  if false, intervals are fusing by half-division methdod  if true, intervals are fusing by selecting value from interval1 @param fusion [out] output interval .

    Parameters
    ----------
    Interval1: TColStd_Array1OfReal
    Interval2: TColStd_Array1OfReal
    Fusion: TColStd_SequenceOfReal
    Confusion: float,optional
    	default value is 1.0e-9
    IsAdjustToFirstInterval: bool,optional
    	default value is Standard_False

    Returns
    -------
    None

    """
    return _GeomLib.geomlib_FuseIntervals(*args)

def geomlib_GTransform(*args) -> "opencascade::handle< Geom2d_Curve >":
    r"""
    Computes the curve 3d from package geom corresponding to the curve 3d from package geom, transformed with the transformation <gtrsf> warning : this method may return a null handle if it's impossible to compute the transformation of a curve. it's not implemented when : 1) the curve is an infinite parabola or hyperbola 2) the curve is an offsetcurve.

    Parameters
    ----------
    Curve: Geom2d_Curve
    GTrsf: gp_GTrsf2d

    Returns
    -------
    opencascade::handle<Geom2d_Curve>

    """
    return _GeomLib.geomlib_GTransform(*args)

def geomlib_Inertia(*args) -> "Standard_Real &, Standard_Real &, Standard_Real &":
    r"""
    Compute principale axes of inertia, and dispertion value of some points.

    Parameters
    ----------
    Points: TColgp_Array1OfPnt
    Bary: gp_Pnt
    XDir: gp_Dir
    YDir: gp_Dir

    Returns
    -------
    Xgap: float
    YGap: float
    ZGap: float

    """
    return _GeomLib.geomlib_Inertia(*args)

def geomlib_IsBSplUClosed(*args) -> "Standard_Boolean":
    r"""
    Returns true if the poles of u1 isoline and the poles of u2 isoline of surface are identical according to tolerance criterion. for rational surfaces weights(i)*poles(i) are checked.

    Parameters
    ----------
    S: Geom_BSplineSurface
    U1: float
    U2: float
    Tol: float

    Returns
    -------
    bool

    """
    return _GeomLib.geomlib_IsBSplUClosed(*args)

def geomlib_IsBSplVClosed(*args) -> "Standard_Boolean":
    r"""
    Returns true if the poles of v1 isoline and the poles of v2 isoline of surface are identical according to tolerance criterion. for rational surfaces weights(i)*poles(i) are checked.

    Parameters
    ----------
    S: Geom_BSplineSurface
    V1: float
    V2: float
    Tol: float

    Returns
    -------
    bool

    """
    return _GeomLib.geomlib_IsBSplVClosed(*args)

def geomlib_IsBzUClosed(*args) -> "Standard_Boolean":
    r"""
    Returns true if the poles of u1 isoline and the poles of u2 isoline of surface are identical according to tolerance criterion.

    Parameters
    ----------
    S: Geom_BezierSurface
    U1: float
    U2: float
    Tol: float

    Returns
    -------
    bool

    """
    return _GeomLib.geomlib_IsBzUClosed(*args)

def geomlib_IsBzVClosed(*args) -> "Standard_Boolean":
    r"""
    Returns true if the poles of v1 isoline and the poles of v2 isoline of surface are identical according to tolerance criterion.

    Parameters
    ----------
    S: Geom_BezierSurface
    V1: float
    V2: float
    Tol: float

    Returns
    -------
    bool

    """
    return _GeomLib.geomlib_IsBzVClosed(*args)

def geomlib_IsClosed(*args) -> "Standard_Boolean &, Standard_Boolean &":
    r"""
    This method defines if opposite boundaries of surface coincide with given tolerance.

    Parameters
    ----------
    S: Geom_Surface
    Tol: float

    Returns
    -------
    isUClosed: bool
    isVClosed: bool

    """
    return _GeomLib.geomlib_IsClosed(*args)

def geomlib_NormEstim(*args) -> "Standard_Integer":
    r"""
    No available documentation.

    Parameters
    ----------
    S: Geom_Surface
    UV: gp_Pnt2d
    Tol: float
    N: gp_Dir

    Returns
    -------
    int

    """
    return _GeomLib.geomlib_NormEstim(*args)

def geomlib_RemovePointsFromArray(*args) -> "void":
    r"""
    Warning! this assume that the inparameter is an increasing sequence of real number and it will not check for that : unpredictable result can happen if this is not satisfied. it is the caller responsability to check for that property. //! this method makes uniform numpoints segments s1,...snumpoints out of the segment defined by the first parameter and the last parameter ofthe inparameter ; keeps only one point of the inparameters set of parameter in each of the uniform segments taking care of the first and the last parameters. for the ith segment the element of the inparameter is the one that is the first to exceed the midpoint of the segment and to fall before the midpoint of the next segment there will be at the end at most numpoints + 1 if numpoints > 2 in the outparameters array.

    Parameters
    ----------
    NumPoints: int
    InParameters: TColStd_Array1OfReal
    OutParameters: TColStd_HArray1OfReal

    Returns
    -------
    None

    """
    return _GeomLib.geomlib_RemovePointsFromArray(*args)

def geomlib_SameRange(*args) -> "void":
    r"""
    Make the curve curve2dptr have the imposed range first to list the most economic way, that is if it can change the range without changing the nature of the curve it will try to do that. otherwise it will produce a bspline curve that has the required range.

    Parameters
    ----------
    Tolerance: float
    Curve2dPtr: Geom2d_Curve
    First: float
    Last: float
    RequestedFirst: float
    RequestedLast: float
    NewCurve2dPtr: Geom2d_Curve

    Returns
    -------
    None

    """
    return _GeomLib.geomlib_SameRange(*args)

def geomlib_To3d(*args) -> "opencascade::handle< Geom_Curve >":
    r"""
    Computes the curve 3d from package geom corresponding to curve 2d from package geom2d, on the plan defined with the local coordinate system position.

    Parameters
    ----------
    Position: gp_Ax2
    Curve2d: Geom2d_Curve

    Returns
    -------
    opencascade::handle<Geom_Curve>

    """
    return _GeomLib.geomlib_To3d(*args)

def geomlib_buildC3dOnIsoLine(*args) -> "opencascade::handle< Geom_Curve >":
    r"""
    Builds 3d curve for a isoline. this method takes corresponding isoline from the input surface. @param thec2d trimmed curve to be approximated. @param theisu flag indicating that line is u const. @param theparam line parameter. @param theisforward flag indicating forward parameterization on a isoline. returns standard_true when 3d curve is built and standard_false otherwise.

    Parameters
    ----------
    theC2D: Adaptor2d_HCurve2d
    theSurf: Adaptor3d_HSurface
    theFirst: float
    theLast: float
    theTolerance: float
    theIsU: bool
    theParam: float
    theIsForward: bool

    Returns
    -------
    opencascade::handle<Geom_Curve>

    """
    return _GeomLib.geomlib_buildC3dOnIsoLine(*args)

def geomlib_isIsoLine(*args) -> "Standard_Boolean &, Standard_Real &, Standard_Boolean &":
    r"""
    Checks whether the 2d curve is a isoline. it can be represented by b-spline, bezier, or geometric line. this line should have natural parameterization. @param thec2d trimmed curve to be checked. @param theisu flag indicating that line is u const. @param theparam line parameter. @param theisforward flag indicating forward parameterization on a isoline. returns standard_true when 2d curve is a line and standard_false otherwise.

    Parameters
    ----------
    theC2D: Adaptor2d_HCurve2d

    Returns
    -------
    theIsU: bool
    theParam: float
    theIsForward: bool

    """
    return _GeomLib.geomlib_isIsoLine(*args)

class GeomLib_Check2dBSplineCurve(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        Curve: Geom2d_BSplineCurve
        Tolerance: float
        AngularTolerance: float

        Returns
        -------
        None

        """
        _GeomLib.GeomLib_Check2dBSplineCurve_swiginit(self, _GeomLib.new_GeomLib_Check2dBSplineCurve(*args))

    def FixTangent(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        FirstFlag: bool
        LastFlag: bool

        Returns
        -------
        None

        """
        return _GeomLib.GeomLib_Check2dBSplineCurve_FixTangent(self, *args)

    def FixedTangent(self, *args) -> "opencascade::handle< Geom2d_BSplineCurve >":
        r"""
        Modifies the curve by fixing the first or the last tangencies //! if index3d not in the range [1,nb3dspaces] if the approx is not done.

        Parameters
        ----------
        FirstFlag: bool
        LastFlag: bool

        Returns
        -------
        opencascade::handle<Geom2d_BSplineCurve>

        """
        return _GeomLib.GeomLib_Check2dBSplineCurve_FixedTangent(self, *args)

    def IsDone(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _GeomLib.GeomLib_Check2dBSplineCurve_IsDone(self, *args)

    def NeedTangentFix(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------

        Returns
        -------
        FirstFlag: bool
        SecondFlag: bool

        """
        return _GeomLib.GeomLib_Check2dBSplineCurve_NeedTangentFix(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GeomLib.delete_GeomLib_Check2dBSplineCurve

# Register GeomLib_Check2dBSplineCurve in _GeomLib:
_GeomLib.GeomLib_Check2dBSplineCurve_swigregister(GeomLib_Check2dBSplineCurve)

class GeomLib_CheckBSplineCurve(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        Curve: Geom_BSplineCurve
        Tolerance: float
        AngularTolerance: float

        Returns
        -------
        None

        """
        _GeomLib.GeomLib_CheckBSplineCurve_swiginit(self, _GeomLib.new_GeomLib_CheckBSplineCurve(*args))

    def FixTangent(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        FirstFlag: bool
        LastFlag: bool

        Returns
        -------
        None

        """
        return _GeomLib.GeomLib_CheckBSplineCurve_FixTangent(self, *args)

    def FixedTangent(self, *args) -> "opencascade::handle< Geom_BSplineCurve >":
        r"""
        Modifies the curve by fixing the first or the last tangencies //! if index3d not in the range [1,nb3dspaces] if the approx is not done.

        Parameters
        ----------
        FirstFlag: bool
        LastFlag: bool

        Returns
        -------
        opencascade::handle<Geom_BSplineCurve>

        """
        return _GeomLib.GeomLib_CheckBSplineCurve_FixedTangent(self, *args)

    def IsDone(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _GeomLib.GeomLib_CheckBSplineCurve_IsDone(self, *args)

    def NeedTangentFix(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------

        Returns
        -------
        FirstFlag: bool
        SecondFlag: bool

        """
        return _GeomLib.GeomLib_CheckBSplineCurve_NeedTangentFix(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GeomLib.delete_GeomLib_CheckBSplineCurve

# Register GeomLib_CheckBSplineCurve in _GeomLib:
_GeomLib.GeomLib_CheckBSplineCurve_swigregister(GeomLib_CheckBSplineCurve)

class GeomLib_CheckCurveOnSurface(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Default contructor.

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        theCurve: Geom_Curve
        theSurface: Geom_Surface
        theFirst: float
        theLast: float
        theTolRange: float,optional
        	default value is Precision::PConfusion()

        Returns
        -------
        None

        """
        _GeomLib.GeomLib_CheckCurveOnSurface_swiginit(self, _GeomLib.new_GeomLib_CheckCurveOnSurface(*args))

    def Curve(self, *args) -> "opencascade::handle< Geom_Curve > const &":
        r"""
        Returns my3dcurve.

        Returns
        -------
        opencascade::handle<Geom_Curve>

        """
        return _GeomLib.GeomLib_CheckCurveOnSurface_Curve(self, *args)

    def ErrorStatus(self, *args) -> "Standard_Integer":
        r"""
        Returns error status the possible values are: 0 - ok; 1 - null curve or surface or 2d curve; 2 - invalid parametric range; 3 - error in calculations.

        Returns
        -------
        int

        """
        return _GeomLib.GeomLib_CheckCurveOnSurface_ErrorStatus(self, *args)

    def Init(self, *args) -> "void":
        r"""
        Sets the data for the algorithm.

        Parameters
        ----------
        theCurve: Geom_Curve
        theSurface: Geom_Surface
        theFirst: float
        theLast: float
        theTolRange: float,optional
        	default value is Precision::PConfusion()

        Returns
        -------
        None
        Initializes all members by dafault values.

        Returns
        -------
        None

        """
        return _GeomLib.GeomLib_CheckCurveOnSurface_Init(self, *args)

    def IsDone(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the max distance has been found.

        Returns
        -------
        bool

        """
        return _GeomLib.GeomLib_CheckCurveOnSurface_IsDone(self, *args)

    def MaxDistance(self, *args) -> "Standard_Real":
        r"""
        Returns max distance.

        Returns
        -------
        float

        """
        return _GeomLib.GeomLib_CheckCurveOnSurface_MaxDistance(self, *args)

    def MaxParameter(self, *args) -> "Standard_Real":
        r"""
        Returns parameter in which the distance is maximal.

        Returns
        -------
        float

        """
        return _GeomLib.GeomLib_CheckCurveOnSurface_MaxParameter(self, *args)

    def Perform(self, *args) -> "void":
        r"""
        Computes the max distance for the 3d curve <mycurve> and 2d curve <thepcurve> if isthemultytheaddisabled == true then computation will be made without any parallelization.

        Parameters
        ----------
        thePCurve: Geom2d_Curve
        isTheMultyTheradDisabled: bool,optional
        	default value is Standard_False

        Returns
        -------
        None

        """
        return _GeomLib.GeomLib_CheckCurveOnSurface_Perform(self, *args)

    def Range(self, *args) -> "void":
        r"""
        Returns first and last parameter of the curves (2d- and 3d-curves are considered to have same range).

        Parameters
        ----------

        Returns
        -------
        theFirst: float
        theLast: float

        """
        return _GeomLib.GeomLib_CheckCurveOnSurface_Range(self, *args)

    def Surface(self, *args) -> "opencascade::handle< Geom_Surface > const &":
        r"""
        Returns mysurface.

        Returns
        -------
        opencascade::handle<Geom_Surface>

        """
        return _GeomLib.GeomLib_CheckCurveOnSurface_Surface(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GeomLib.delete_GeomLib_CheckCurveOnSurface

# Register GeomLib_CheckCurveOnSurface in _GeomLib:
_GeomLib.GeomLib_CheckCurveOnSurface_swigregister(GeomLib_CheckCurveOnSurface)

class GeomLib_DenominatorMultiplier(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        If the surface is rational this will define the evaluator of a real function of 2 variables a(u,v) such that if we define a new surface by : a(u,v) * n(u,v) newf(u,v) = ---------------- a(u,v) * d(u,v).

        Parameters
        ----------
        Surface: Geom_BSplineSurface
        KnotVector: TColStd_Array1OfReal

        Returns
        -------
        None

        """
        _GeomLib.GeomLib_DenominatorMultiplier_swiginit(self, _GeomLib.new_GeomLib_DenominatorMultiplier(*args))

    def Value(self, *args) -> "Standard_Real":
        r"""
        Returns the value of a(uparameter,vparameter)= //! h0(uparameter)/denominator(umin,vparameter) //! d denominator(umin,vparameter) - ------------------------------[h1(u)]/(denominator(umin,vparameter)^2) d u //! + h3(uparameter)/denominator(umax,vparameter) //! d denominator(umax,vparameter) - ------------------------------[h2(u)]/(denominator(umax,vparameter)^2) d u.

        Parameters
        ----------
        UParameter: float
        VParameter: float

        Returns
        -------
        float

        """
        return _GeomLib.GeomLib_DenominatorMultiplier_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GeomLib.delete_GeomLib_DenominatorMultiplier

# Register GeomLib_DenominatorMultiplier in _GeomLib:
_GeomLib.GeomLib_DenominatorMultiplier_swigregister(GeomLib_DenominatorMultiplier)

class GeomLib_Interpolate(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        Degree: int
        NumPoints: int
        Points: TColgp_Array1OfPnt
        Parameters: TColStd_Array1OfReal

        Returns
        -------
        None

        """
        _GeomLib.GeomLib_Interpolate_swiginit(self, _GeomLib.new_GeomLib_Interpolate(*args))

    def Curve(self, *args) -> "opencascade::handle< Geom_BSplineCurve >":
        r"""
        Returns the interpolated curve of the requested degree.

        Returns
        -------
        opencascade::handle<Geom_BSplineCurve>

        """
        return _GeomLib.GeomLib_Interpolate_Curve(self, *args)

    def Error(self, *args) -> "GeomLib_InterpolationErrors":
        r"""
        Returns the error type if any.

        Returns
        -------
        GeomLib_InterpolationErrors

        """
        return _GeomLib.GeomLib_Interpolate_Error(self, *args)

    def IsDone(self, *args) -> "Standard_Boolean":
        r"""
        Returns if everything went ok.

        Returns
        -------
        bool

        """
        return _GeomLib.GeomLib_Interpolate_IsDone(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GeomLib.delete_GeomLib_Interpolate

# Register GeomLib_Interpolate in _GeomLib:
_GeomLib.GeomLib_Interpolate_swigregister(GeomLib_Interpolate)

class GeomLib_IsPlanarSurface(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        S: Geom_Surface
        Tol: float,optional
        	default value is 1.0e-7

        Returns
        -------
        None

        """
        _GeomLib.GeomLib_IsPlanarSurface_swiginit(self, _GeomLib.new_GeomLib_IsPlanarSurface(*args))

    def IsPlanar(self, *args) -> "Standard_Boolean":
        r"""
        Return if the surface is a plan.

        Returns
        -------
        bool

        """
        return _GeomLib.GeomLib_IsPlanarSurface_IsPlanar(self, *args)

    def Plan(self, *args) -> "gp_Pln const":
        r"""
        Return the plan definition.

        Returns
        -------
        gp_Pln

        """
        return _GeomLib.GeomLib_IsPlanarSurface_Plan(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GeomLib.delete_GeomLib_IsPlanarSurface

# Register GeomLib_IsPlanarSurface in _GeomLib:
_GeomLib.GeomLib_IsPlanarSurface_swigregister(GeomLib_IsPlanarSurface)

class GeomLib_LogSample(OCC.Core.math.math_FunctionSample):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        A: float
        B: float
        N: int

        Returns
        -------
        None

        """
        _GeomLib.GeomLib_LogSample_swiginit(self, _GeomLib.new_GeomLib_LogSample(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _GeomLib.delete_GeomLib_LogSample

# Register GeomLib_LogSample in _GeomLib:
_GeomLib.GeomLib_LogSample_swigregister(GeomLib_LogSample)

class GeomLib_MakeCurvefromApprox(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        Approx: AdvApprox_ApproxAFunction

        Returns
        -------
        None

        """
        _GeomLib.GeomLib_MakeCurvefromApprox_swiginit(self, _GeomLib.new_GeomLib_MakeCurvefromApprox(*args))

    def Curve(self, *args) -> "opencascade::handle< Geom_BSplineCurve >":
        r"""
        Returns a polynomial curve whose poles correspond to the index3d 3d space if index3d not in the range [1,nb3dspaces] if the approx is not done.

        Parameters
        ----------
        Index3d: int

        Returns
        -------
        opencascade::handle<Geom_BSplineCurve>
        Returns a rational curve whose poles correspond to the index3d of the 3d space and whose weights correspond to the index1d 1d space. if index1d not in the range [1,nb1dspaces] if index3d not in the range [1,nb3dspaces] if the approx is not done.

        Parameters
        ----------
        Index1D: int
        Index3D: int

        Returns
        -------
        opencascade::handle<Geom_BSplineCurve>

        """
        return _GeomLib.GeomLib_MakeCurvefromApprox_Curve(self, *args)

    def Curve2d(self, *args) -> "opencascade::handle< Geom2d_BSplineCurve >":
        r"""
        Returns a polynomial curve whose poles correspond to the index2d 2d space if index2d not in the range [1,nb2dspaces] if the approx is not done.

        Parameters
        ----------
        Index2d: int

        Returns
        -------
        opencascade::handle<Geom2d_BSplineCurve>
        Returns a rational curve whose poles correspond to the index2d of the 2d space and whose weights correspond to one dimensional space of index 1d if index1d not in the range [1,nb1dspaces] if index2d not in the range [1,nb2dspaces] if the approx is not done.

        Parameters
        ----------
        Index1d: int
        Index2d: int

        Returns
        -------
        opencascade::handle<Geom2d_BSplineCurve>

        """
        return _GeomLib.GeomLib_MakeCurvefromApprox_Curve2d(self, *args)

    def Curve2dFromTwo1d(self, *args) -> "opencascade::handle< Geom2d_BSplineCurve >":
        r"""
        Returns a 2d curve building it from the 1d curve in x at index1d and y at index2d amongst the 1d curves if index1d not in the range [1,nb1dspaces] if index2d not in the range [1,nb1dspaces] if the approx is not done.

        Parameters
        ----------
        Index1d: int
        Index2d: int

        Returns
        -------
        opencascade::handle<Geom2d_BSplineCurve>

        """
        return _GeomLib.GeomLib_MakeCurvefromApprox_Curve2dFromTwo1d(self, *args)

    def IsDone(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _GeomLib.GeomLib_MakeCurvefromApprox_IsDone(self, *args)

    def Nb1DSpaces(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of 1d spaces of the approx.

        Returns
        -------
        int

        """
        return _GeomLib.GeomLib_MakeCurvefromApprox_Nb1DSpaces(self, *args)

    def Nb2DSpaces(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of 3d spaces of the approx.

        Returns
        -------
        int

        """
        return _GeomLib.GeomLib_MakeCurvefromApprox_Nb2DSpaces(self, *args)

    def Nb3DSpaces(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of 3d spaces of the approx.

        Returns
        -------
        int

        """
        return _GeomLib.GeomLib_MakeCurvefromApprox_Nb3DSpaces(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GeomLib.delete_GeomLib_MakeCurvefromApprox

# Register GeomLib_MakeCurvefromApprox in _GeomLib:
_GeomLib.GeomLib_MakeCurvefromApprox_swigregister(GeomLib_MakeCurvefromApprox)

class GeomLib_PolyFunc(OCC.Core.math.math_FunctionWithDerivative):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        Coeffs: math_Vector

        Returns
        -------
        None

        """
        _GeomLib.GeomLib_PolyFunc_swiginit(self, _GeomLib.new_GeomLib_PolyFunc(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _GeomLib.delete_GeomLib_PolyFunc

# Register GeomLib_PolyFunc in _GeomLib:
_GeomLib.GeomLib_PolyFunc_swigregister(GeomLib_PolyFunc)

class GeomLib_Tool(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Parameter(*args) -> "Standard_Real &":
        r"""
        Extracts the parameter of a 3d point lying on a 3d curve or at a distance less than the maxdist value.

        Parameters
        ----------
        Curve: Geom_Curve
        Point: gp_Pnt
        MaxDist: float

        Returns
        -------
        U: float
        Extracts the parameter of a 2d point lying on a 2d curve or at a distance less than the maxdist value.

        Parameters
        ----------
        Curve: Geom2d_Curve
        Point: gp_Pnt2d
        MaxDist: float

        Returns
        -------
        U: float

        """
        return _GeomLib.GeomLib_Tool_Parameter(*args)

    @staticmethod
    def Parameters(*args) -> "Standard_Real &, Standard_Real &":
        r"""
        Extracts the parameter of a 3d point lying on a surface or at a distance less than the maxdist value.

        Parameters
        ----------
        Surface: Geom_Surface
        Point: gp_Pnt
        MaxDist: float

        Returns
        -------
        U: float
        V: float

        """
        return _GeomLib.GeomLib_Tool_Parameters(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _GeomLib.GeomLib_Tool_swiginit(self, _GeomLib.new_GeomLib_Tool())
    __swig_destroy__ = _GeomLib.delete_GeomLib_Tool

# Register GeomLib_Tool in _GeomLib:
_GeomLib.GeomLib_Tool_swigregister(GeomLib_Tool)

def GeomLib_Tool_Parameter(*args) -> "Standard_Real &":
    r"""
    Extracts the parameter of a 3d point lying on a 3d curve or at a distance less than the maxdist value.

    Parameters
    ----------
    Curve: Geom_Curve
    Point: gp_Pnt
    MaxDist: float

    Returns
    -------
    U: float
    Extracts the parameter of a 2d point lying on a 2d curve or at a distance less than the maxdist value.

    Parameters
    ----------
    Curve: Geom2d_Curve
    Point: gp_Pnt2d
    MaxDist: float

    Returns
    -------
    U: float

    """
    return _GeomLib.GeomLib_Tool_Parameter(*args)

def GeomLib_Tool_Parameters(*args) -> "Standard_Real &, Standard_Real &":
    r"""
    Extracts the parameter of a 3d point lying on a surface or at a distance less than the maxdist value.

    Parameters
    ----------
    Surface: Geom_Surface
    Point: gp_Pnt
    MaxDist: float

    Returns
    -------
    U: float
    V: float

    """
    return _GeomLib.GeomLib_Tool_Parameters(*args)





