
// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
#include <qapp_macro.h>

QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyfalkon_python.h"

// main header
#include "webpage_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void WebPageWrapper::pysideInitQtMetaTypes()
{
    qRegisterMetaType< ::WebPage::JsWorld >("WebPage::JsWorld");
}

void WebPageWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

WebPageWrapper::WebPageWrapper(QObject * parent) : WebPage(parent)
{
    resetPyMethodCache();
    // ... middle
}

void WebPageWrapper::childEvent(QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void WebPageWrapper::connectNotify(const QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void WebPageWrapper::customEvent(QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void WebPageWrapper::disconnectNotify(const QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool WebPageWrapper::event(QEvent * arg__1)
{
    if (m_PyMethodCache[4])
        return this->::QWebEnginePage::event(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QWebEnginePage::event(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), arg__1)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "WebPage.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool WebPageWrapper::eventFilter(QObject * watched, QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "WebPage.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void WebPageWrapper::javaScriptAlert(const QUrl & securityOrigin, const QString & msg)
{
    if (m_PyMethodCache[6]) {
        return this->::WebPage::javaScriptAlert(securityOrigin, msg);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "javaScriptAlert";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::WebPage::javaScriptAlert(securityOrigin, msg);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &securityOrigin),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &msg)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool WebPageWrapper::javaScriptConfirm(const QUrl & securityOrigin, const QString & msg)
{
    if (m_PyMethodCache[7])
        return this->::WebPage::javaScriptConfirm(securityOrigin, msg);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "javaScriptConfirm";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::WebPage::javaScriptConfirm(securityOrigin, msg);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &securityOrigin),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &msg)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "WebPage.javaScriptConfirm", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void WebPageWrapper::javaScriptConsoleMessage(QWebEnginePage::JavaScriptConsoleMessageLevel level, const QString & message, int lineNumber, const QString & sourceID)
{
    if (m_PyMethodCache[8]) {
        return this->::WebPage::javaScriptConsoleMessage(level, message, lineNumber, sourceID);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "javaScriptConsoleMessage";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::WebPage::javaScriptConsoleMessage(level, message, lineNumber, sourceID);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNiN)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_JAVASCRIPTCONSOLEMESSAGELEVEL_IDX])->converter, &level),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &message),
    lineNumber,
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &sourceID)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool WebPageWrapper::javaScriptPrompt(const QUrl & securityOrigin, const QString & msg, const QString & defaultValue, QString * result)
{
    if (m_PyMethodCache[9])
        return this->::QWebEnginePage::javaScriptPrompt(securityOrigin, msg, defaultValue, result);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "javaScriptPrompt";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QWebEnginePage::javaScriptPrompt(securityOrigin, msg, defaultValue, result);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNNN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &securityOrigin),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &msg),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &defaultValue),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &result)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "WebPage.javaScriptPrompt", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void WebPageWrapper::timerEvent(QTimerEvent * event)
{
    if (m_PyMethodCache[11]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void WebPageWrapper::triggerAction(QWebEnginePage::WebAction action, bool checked)
{
    if (m_PyMethodCache[12]) {
        return this->::QWebEnginePage::triggerAction(action, checked);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "triggerAction";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[12] = true;
        return this->::QWebEnginePage::triggerAction(action, checked);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX])->converter, &action),
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &checked)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

const QMetaObject *WebPageWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return WebPage::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int WebPageWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = WebPage::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *WebPageWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< WebPageWrapper *>(this));
        return WebPage::qt_metacast(_clname);
}

WebPageWrapper::~WebPageWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_WebPage_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const char *argNames[] = {"parent"};
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::WebPage >()))
        return -1;

    ::WebPageWrapper *cptr{};
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:WebPage", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: WebPage::WebPage(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // WebPage(QObject*)
    } else if ((pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // WebPage(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_WebPage_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *keyName = nullptr;
            PyObject *value = nullptr;
            keyName = Py_BuildValue("s","parent");
            if (PyDict_Contains(kwds, keyName)) {
                value = PyDict_GetItem(kwds, keyName);
                if (value && pyArgs[0]) {
                    PyErr_SetString(PyExc_TypeError, "PyFalkon.WebPage(): got multiple values for keyword argument 'parent'.");
                    return -1;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_WebPage_Init_TypeError;
                }
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = 0;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // WebPage(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::WebPageWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::WebPageWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::WebPage >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto Sbk_WebPage_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (kwds && !PySide::fillQtProperties(self, metaObject, kwds, argNames, 1))
        return -1;


    return 1;

    Sbk_WebPage_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, "PyFalkon.WebPage");
        return -1;
}

static PyObject *Sbk_WebPageFunc_acceptNavigationRequest(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBPAGE_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "acceptNavigationRequest", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QWebEnginePage::acceptNavigationRequest(QUrl,QWebEnginePage::NavigationType,bool)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_NAVIGATIONTYPE_IDX])->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2])))) {
        overloadId = 0; // acceptNavigationRequest(QUrl,QWebEnginePage::NavigationType,bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_WebPageFunc_acceptNavigationRequest_TypeError;

    // Call function/method
    {
        PyErr_Format(PyExc_TypeError, "%s is a private method.", "acceptNavigationRequest(const QUrl & url, QWebEnginePage.NavigationType type, bool isMainFrame)");
        return {};
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_WebPageFunc_acceptNavigationRequest_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, "PyFalkon.WebPage.acceptNavigationRequest");
        return {};
}

static PyObject *Sbk_WebPageFunc_addSupportedScheme(PyObject *self, PyObject *pyArg)
{
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static WebPage::addSupportedScheme(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // addSupportedScheme(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_WebPageFunc_addSupportedScheme_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addSupportedScheme(QString)
            ::WebPage::addSupportedScheme(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_WebPageFunc_addSupportedScheme_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, "PyFalkon.WebPage.addSupportedScheme");
        return {};
}

static PyObject *Sbk_WebPageFunc_autoFillUsernames(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBPAGE_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // autoFillUsernames()const
            QStringList cppResult = const_cast<const ::WebPageWrapper *>(cppSelf)->autoFillUsernames();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_WebPageFunc_certificateError(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBPAGE_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEnginePage::certificateError(QWebEngineCertificateError)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_IDX]), (pyArg)))) {
        overloadId = 0; // certificateError(QWebEngineCertificateError)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_WebPageFunc_certificateError_TypeError;

    // Call function/method
    {
        PyErr_Format(PyExc_TypeError, "%s is a private method.", "certificateError(const QWebEngineCertificateError & error)");
        return {};
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_WebPageFunc_certificateError_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, "PyFalkon.WebPage.certificateError");
        return {};
}

static PyObject *Sbk_WebPageFunc_chooseFiles(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBPAGE_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "chooseFiles", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QWebEnginePage::chooseFiles(QWebEnginePage::FileSelectionMode,QStringList,QStringList)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FILESELECTIONMODE_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[2])))) {
        overloadId = 0; // chooseFiles(QWebEnginePage::FileSelectionMode,QStringList,QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_WebPageFunc_chooseFiles_TypeError;

    // Call function/method
    {
        PyErr_Format(PyExc_TypeError, "%s is a private method.", "chooseFiles(QWebEnginePage.FileSelectionMode mode, const QStringList & oldFiles, const QStringList & acceptedMimeTypes)");
        return {};
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_WebPageFunc_chooseFiles_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, "PyFalkon.WebPage.chooseFiles");
        return {};
}

static PyObject *Sbk_WebPageFunc_createWindow(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBPAGE_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEnginePage::createWindow(QWebEnginePage::WebWindowType)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBWINDOWTYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // createWindow(QWebEnginePage::WebWindowType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_WebPageFunc_createWindow_TypeError;

    // Call function/method
    {
        PyErr_Format(PyExc_TypeError, "%s is a private method.", "createWindow(QWebEnginePage.WebWindowType type)");
        return {};
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_WebPageFunc_createWindow_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, "PyFalkon.WebPage.createWindow");
        return {};
}

static PyObject *Sbk_WebPageFunc_execJavaScript(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBPAGE_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 3) {
        PyErr_SetString(PyExc_TypeError, "PyFalkon.WebPage.execJavaScript(): too many arguments");
        return {};
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "PyFalkon.WebPage.execJavaScript(): not enough arguments");
        return {};
    }

    if (!PyArg_ParseTuple(args, "|OOO:execJavaScript", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: WebPage::execJavaScript(QString,quint32,int)
    if ((pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // execJavaScript(QString,quint32,int)
        } else if ((pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // execJavaScript(QString,quint32,int)
            } else if ((pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                overloadId = 0; // execJavaScript(QString,quint32,int)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_WebPageFunc_execJavaScript_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *keyName = nullptr;
            PyObject *value = nullptr;
            keyName = Py_BuildValue("s","worldId");
            if (PyDict_Contains(kwds, keyName)) {
                value = PyDict_GetItem(kwds, keyName);
                if (value && pyArgs[1]) {
                    PyErr_SetString(PyExc_TypeError, "PyFalkon.WebPage.execJavaScript(): got multiple values for keyword argument 'worldId'.");
                    return {};
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), (pyArgs[1]))))
                        goto Sbk_WebPageFunc_execJavaScript_TypeError;
                }
            }
            keyName = Py_BuildValue("s","timeout");
            if (PyDict_Contains(kwds, keyName)) {
                value = PyDict_GetItem(kwds, keyName);
                if (value && pyArgs[2]) {
                    PyErr_SetString(PyExc_TypeError, "PyFalkon.WebPage.execJavaScript(): got multiple values for keyword argument 'timeout'.");
                    return {};
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                        goto Sbk_WebPageFunc_execJavaScript_TypeError;
                }
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        quint32 cppArg1 = WebPage::UnsafeJsWorld;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2 = 500;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // execJavaScript(QString,quint32,int)
            QVariant cppResult = cppSelf->execJavaScript(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_WebPageFunc_execJavaScript_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, "PyFalkon.WebPage.execJavaScript");
        return {};
}

static PyObject *Sbk_WebPageFunc_execPrintPage(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBPAGE_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs + numNamedArgs > 2) {
        PyErr_SetString(PyExc_TypeError, "PyFalkon.WebPage.execPrintPage(): too many arguments");
        return {};
    } else if (numArgs < 1) {
        PyErr_SetString(PyExc_TypeError, "PyFalkon.WebPage.execPrintPage(): not enough arguments");
        return {};
    }

    if (!PyArg_ParseTuple(args, "|OO:execPrintPage", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: WebPage::execPrintPage(QPrinter*,int)
    if ((pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // execPrintPage(QPrinter*,int)
        } else if ((pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // execPrintPage(QPrinter*,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_WebPageFunc_execPrintPage_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *keyName = nullptr;
            PyObject *value = nullptr;
            keyName = Py_BuildValue("s","timeout");
            if (PyDict_Contains(kwds, keyName)) {
                value = PyDict_GetItem(kwds, keyName);
                if (value && pyArgs[1]) {
                    PyErr_SetString(PyExc_TypeError, "PyFalkon.WebPage.execPrintPage(): got multiple values for keyword argument 'timeout'.");
                    return {};
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_WebPageFunc_execPrintPage_TypeError;
                }
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPrinter *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = 1000;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // execPrintPage(QPrinter*,int)
            bool cppResult = cppSelf->execPrintPage(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_WebPageFunc_execPrintPage_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, "PyFalkon.WebPage.execPrintPage");
        return {};
}

static PyObject *Sbk_WebPageFunc_featurePermissionRequested(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBPAGE_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "featurePermissionRequested", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QWebEnginePage::featurePermissionRequested(QUrl,QWebEnginePage::Feature)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FEATURE_IDX])->converter, (pyArgs[1])))) {
        overloadId = 0; // featurePermissionRequested(QUrl,QWebEnginePage::Feature)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_WebPageFunc_featurePermissionRequested_TypeError;

    // Call function/method
    {
        PyErr_Format(PyExc_TypeError, "%s is a private method.", "featurePermissionRequested(const QUrl & origin, const QWebEnginePage.Feature & feature)");
        return {};
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_WebPageFunc_featurePermissionRequested_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, "PyFalkon.WebPage.featurePermissionRequested");
        return {};
}

static PyObject *Sbk_WebPageFunc_finished(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBPAGE_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // finished()
            static_cast<::WebPageWrapper *>(cppSelf)->WebPageWrapper::finished_protected();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_WebPageFunc_fullScreenRequested(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBPAGE_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEnginePage::fullScreenRequested(QWebEngineFullScreenRequest)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEFULLSCREENREQUEST_IDX]), (pyArg)))) {
        overloadId = 0; // fullScreenRequested(QWebEngineFullScreenRequest)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_WebPageFunc_fullScreenRequested_TypeError;

    // Call function/method
    {
        PyErr_Format(PyExc_TypeError, "%s is a private method.", "fullScreenRequested(QWebEngineFullScreenRequest fullScreenRequest)");
        return {};
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_WebPageFunc_fullScreenRequested_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, "PyFalkon.WebPage.fullScreenRequested");
        return {};
}

static PyObject *Sbk_WebPageFunc_hitTestContent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBPAGE_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: WebPage::hitTestContent(QPoint)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArg)))) {
        overloadId = 0; // hitTestContent(QPoint)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_WebPageFunc_hitTestContent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPoint cppArg0_local;
        ::QPoint *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // hitTestContent(QPoint)const
            WebHitTestResult cppResult = const_cast<const ::WebPageWrapper *>(cppSelf)->hitTestContent(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_WEBHITTESTRESULT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_WebPageFunc_hitTestContent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, "PyFalkon.WebPage.hitTestContent");
        return {};
}

static PyObject *Sbk_WebPageFunc_internalSchemes(PyObject *self)
{
    PyObject *pyResult{};

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // internalSchemes()
            QStringList cppResult = ::WebPage::internalSchemes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_WebPageFunc_isLoading(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBPAGE_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isLoading()const
            bool cppResult = const_cast<const ::WebPageWrapper *>(cppSelf)->isLoading();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_WebPageFunc_isRunningLoop(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBPAGE_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isRunningLoop()
            bool cppResult = cppSelf->isRunningLoop();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_WebPageFunc_javaScriptAlert(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBPAGE_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "javaScriptAlert", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QWebEnginePage::javaScriptAlert(QUrl,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // javaScriptAlert(QUrl,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_WebPageFunc_javaScriptAlert_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // javaScriptAlert(QUrl,QString)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::WebPage::javaScriptAlert(*cppArg0, cppArg1)
                : cppSelf->javaScriptAlert(*cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_WebPageFunc_javaScriptAlert_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, "PyFalkon.WebPage.javaScriptAlert");
        return {};
}

static PyObject *Sbk_WebPageFunc_javaScriptConfirm(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBPAGE_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "javaScriptConfirm", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QWebEnginePage::javaScriptConfirm(QUrl,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // javaScriptConfirm(QUrl,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_WebPageFunc_javaScriptConfirm_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // javaScriptConfirm(QUrl,QString)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::WebPage::javaScriptConfirm(*cppArg0, cppArg1)
                : cppSelf->javaScriptConfirm(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_WebPageFunc_javaScriptConfirm_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, "PyFalkon.WebPage.javaScriptConfirm");
        return {};
}

static PyObject *Sbk_WebPageFunc_javaScriptConsoleMessage(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBPAGE_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "javaScriptConsoleMessage", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QWebEnginePage::javaScriptConsoleMessage(QWebEnginePage::JavaScriptConsoleMessageLevel,QString,int,QString)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_JAVASCRIPTCONSOLEMESSAGELEVEL_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3])))) {
        overloadId = 0; // javaScriptConsoleMessage(QWebEnginePage::JavaScriptConsoleMessageLevel,QString,int,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_WebPageFunc_javaScriptConsoleMessage_TypeError;

    // Call function/method
    {
        ::QWebEnginePage::JavaScriptConsoleMessageLevel cppArg0{QWebEnginePage::InfoMessageLevel};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // javaScriptConsoleMessage(QWebEnginePage::JavaScriptConsoleMessageLevel,QString,int,QString)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::WebPage::javaScriptConsoleMessage(cppArg0, cppArg1, cppArg2, cppArg3)
                : cppSelf->javaScriptConsoleMessage(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_WebPageFunc_javaScriptConsoleMessage_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, "PyFalkon.WebPage.javaScriptConsoleMessage");
        return {};
}

static PyObject *Sbk_WebPageFunc_mapToViewport(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBPAGE_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: WebPage::mapToViewport(QPointF)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArg)))) {
        overloadId = 0; // mapToViewport(QPointF)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_WebPageFunc_mapToViewport_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPointF cppArg0_local;
        ::QPointF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // mapToViewport(QPointF)const
            QPointF cppResult = const_cast<const ::WebPageWrapper *>(cppSelf)->mapToViewport(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_WebPageFunc_mapToViewport_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, "PyFalkon.WebPage.mapToViewport");
        return {};
}

static PyObject *Sbk_WebPageFunc_progress(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBPAGE_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: WebPage::progress(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // progress(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_WebPageFunc_progress_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // progress(int)
            static_cast<::WebPageWrapper *>(cppSelf)->WebPageWrapper::progress_protected(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_WebPageFunc_progress_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, "PyFalkon.WebPage.progress");
        return {};
}

static PyObject *Sbk_WebPageFunc_registerProtocolHandlerRequestScheme(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBPAGE_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // registerProtocolHandlerRequestScheme()const
            QString cppResult = const_cast<const ::WebPageWrapper *>(cppSelf)->registerProtocolHandlerRequestScheme();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_WebPageFunc_registerProtocolHandlerRequestUrl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBPAGE_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // registerProtocolHandlerRequestUrl()const
            QUrl cppResult = const_cast<const ::WebPageWrapper *>(cppSelf)->registerProtocolHandlerRequestUrl();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_WebPageFunc_removeSupportedScheme(PyObject *self, PyObject *pyArg)
{
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static WebPage::removeSupportedScheme(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // removeSupportedScheme(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_WebPageFunc_removeSupportedScheme_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeSupportedScheme(QString)
            ::WebPage::removeSupportedScheme(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_WebPageFunc_removeSupportedScheme_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, "PyFalkon.WebPage.removeSupportedScheme");
        return {};
}

static PyObject *Sbk_WebPageFunc_renderProcessTerminated(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBPAGE_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "renderProcessTerminated", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QWebEnginePage::renderProcessTerminated(QWebEnginePage::RenderProcessTerminationStatus,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_RENDERPROCESSTERMINATIONSTATUS_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // renderProcessTerminated(QWebEnginePage::RenderProcessTerminationStatus,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_WebPageFunc_renderProcessTerminated_TypeError;

    // Call function/method
    {
        PyErr_Format(PyExc_TypeError, "%s is a private method.", "renderProcessTerminated(QWebEnginePage.RenderProcessTerminationStatus terminationStatus, int exitCode)");
        return {};
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_WebPageFunc_renderProcessTerminated_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, "PyFalkon.WebPage.renderProcessTerminated");
        return {};
}

static PyObject *Sbk_WebPageFunc_scroll(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBPAGE_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "scroll", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: WebPage::scroll(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // scroll(int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_WebPageFunc_scroll_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // scroll(int,int)
            cppSelf->scroll(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_WebPageFunc_scroll_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, "PyFalkon.WebPage.scroll");
        return {};
}

static PyObject *Sbk_WebPageFunc_setScrollPosition(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBPAGE_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: WebPage::setScrollPosition(QPointF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArg)))) {
        overloadId = 0; // setScrollPosition(QPointF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_WebPageFunc_setScrollPosition_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPointF cppArg0_local;
        ::QPointF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setScrollPosition(QPointF)
            cppSelf->setScrollPosition(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_WebPageFunc_setScrollPosition_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, "PyFalkon.WebPage.setScrollPosition");
        return {};
}

static PyObject *Sbk_WebPageFunc_supportedSchemes(PyObject *self)
{
    PyObject *pyResult{};

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedSchemes()
            QStringList cppResult = ::WebPage::supportedSchemes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_WebPageFunc_urlChanged(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBPAGE_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEnginePage::urlChanged(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 0; // urlChanged(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_WebPageFunc_urlChanged_TypeError;

    // Call function/method
    {
        PyErr_Format(PyExc_TypeError, "%s is a private method.", "urlChanged(const QUrl & url)");
        return {};
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_WebPageFunc_urlChanged_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, "PyFalkon.WebPage.urlChanged");
        return {};
}

static PyObject *Sbk_WebPageFunc_view(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBPAGE_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // view()const
            WebView * cppResult = const_cast<const ::WebPageWrapper *>(cppSelf)->view();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_WEBVIEW_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_WebPageFunc_windowCloseRequested(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<WebPageWrapper *>(reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBPAGE_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)

    // Call function/method
    {
        PyErr_Format(PyExc_TypeError, "%s is a private method.", "windowCloseRequested()");
        return {};
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}


static const char *Sbk_WebPage_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_WebPage_methods[] = {
    {"acceptNavigationRequest", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_acceptNavigationRequest), METH_VARARGS},
    {"addSupportedScheme", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_addSupportedScheme), METH_O|METH_STATIC},
    {"autoFillUsernames", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_autoFillUsernames), METH_NOARGS},
    {"certificateError", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_certificateError), METH_O},
    {"chooseFiles", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_chooseFiles), METH_VARARGS},
    {"createWindow", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_createWindow), METH_O},
    {"execJavaScript", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_execJavaScript), METH_VARARGS|METH_KEYWORDS},
    {"execPrintPage", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_execPrintPage), METH_VARARGS|METH_KEYWORDS},
    {"featurePermissionRequested", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_featurePermissionRequested), METH_VARARGS},
    {"finished", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_finished), METH_NOARGS},
    {"fullScreenRequested", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_fullScreenRequested), METH_O},
    {"hitTestContent", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_hitTestContent), METH_O},
    {"internalSchemes", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_internalSchemes), METH_NOARGS|METH_STATIC},
    {"isLoading", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_isLoading), METH_NOARGS},
    {"isRunningLoop", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_isRunningLoop), METH_NOARGS},
    {"javaScriptAlert", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_javaScriptAlert), METH_VARARGS},
    {"javaScriptConfirm", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_javaScriptConfirm), METH_VARARGS},
    {"javaScriptConsoleMessage", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_javaScriptConsoleMessage), METH_VARARGS},
    {"mapToViewport", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_mapToViewport), METH_O},
    {"progress", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_progress), METH_O},
    {"registerProtocolHandlerRequestScheme", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_registerProtocolHandlerRequestScheme), METH_NOARGS},
    {"registerProtocolHandlerRequestUrl", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_registerProtocolHandlerRequestUrl), METH_NOARGS},
    {"removeSupportedScheme", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_removeSupportedScheme), METH_O|METH_STATIC},
    {"renderProcessTerminated", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_renderProcessTerminated), METH_VARARGS},
    {"scroll", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_scroll), METH_VARARGS},
    {"setScrollPosition", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_setScrollPosition), METH_O},
    {"supportedSchemes", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_supportedSchemes), METH_NOARGS|METH_STATIC},
    {"urlChanged", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_urlChanged), METH_O},
    {"view", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_view), METH_NOARGS},
    {"windowCloseRequested", reinterpret_cast<PyCFunction>(Sbk_WebPageFunc_windowCloseRequested), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_WebPage_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::WebPage *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_WEBPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<WebPageWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_WebPage_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_WebPage_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_WebPage_Type = nullptr;
static SbkObjectType *Sbk_WebPage_TypeF(void)
{
    return _Sbk_WebPage_Type;
}

static PyType_Slot Sbk_WebPage_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_WebPage_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_WebPage_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_WebPage_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_WebPage_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_WebPage_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_WebPage_spec = {
    "1:PyFalkon.WebPage",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_WebPage_slots
};

} //extern "C"

static void *Sbk_WebPage_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::WebPage *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void WebPage_JsWorld_PythonToCpp_WebPage_JsWorld(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::WebPage::JsWorld *>(cppOut) =
        static_cast<::WebPage::JsWorld>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_WebPage_JsWorld_PythonToCpp_WebPage_JsWorld_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPyFalkonTypes[SBK_WEBPAGE_JSWORLD_IDX]))
        return WebPage_JsWorld_PythonToCpp_WebPage_JsWorld;
    return {};
}
static PyObject *WebPage_JsWorld_CppToPython_WebPage_JsWorld(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::WebPage::JsWorld *>(cppIn));
    return Shiboken::Enum::newItem(SbkPyFalkonTypes[SBK_WEBPAGE_JSWORLD_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void WebPage_PythonToCpp_WebPage_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_WebPage_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_WebPage_PythonToCpp_WebPage_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_WebPage_TypeF())))
        return WebPage_PythonToCpp_WebPage_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *WebPage_PTR_CppToPython_WebPage(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::WebPage *>(const_cast<void *>(cppIn)), Sbk_WebPage_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *WebPage_SignatureStrings[] = {
    "PyFalkon.WebPage(self,parent:PySide2.QtCore.QObject=0)",
    "PyFalkon.WebPage.acceptNavigationRequest(self,url:PySide2.QtCore.QUrl,type:PySide2.QtWebEngineWidgets.QWebEnginePage.NavigationType,isMainFrame:bool)->bool",
    "PyFalkon.WebPage.addSupportedScheme(scheme:QString)",
    "PyFalkon.WebPage.autoFillUsernames(self)->QStringList",
    "PyFalkon.WebPage.certificateError(self,error:PySide2.QtWebEngineWidgets.QWebEngineCertificateError)->bool",
    "PyFalkon.WebPage.chooseFiles(self,mode:PySide2.QtWebEngineWidgets.QWebEnginePage.FileSelectionMode,oldFiles:QStringList,acceptedMimeTypes:QStringList)->QStringList",
    "PyFalkon.WebPage.createWindow(self,type:PySide2.QtWebEngineWidgets.QWebEnginePage.WebWindowType)->PySide2.QtWebEngineWidgets.QWebEnginePage",
    "PyFalkon.WebPage.execJavaScript(self,scriptSource:QString,worldId:quint32=WebPage.UnsafeJsWorld,timeout:int=500)->QVariant",
    "PyFalkon.WebPage.execPrintPage(self,printer:PySide2.QtPrintSupport.QPrinter,timeout:int=1000)->bool",
    "PyFalkon.WebPage.featurePermissionRequested(self,origin:PySide2.QtCore.QUrl,feature:PySide2.QtWebEngineWidgets.QWebEnginePage.Feature)",
    "PyFalkon.WebPage.finished(self)",
    "PyFalkon.WebPage.fullScreenRequested(self,fullScreenRequest:PySide2.QtWebEngineWidgets.QWebEngineFullScreenRequest)",
    "PyFalkon.WebPage.hitTestContent(self,pos:PySide2.QtCore.QPoint)->PyFalkon.WebHitTestResult",
    "PyFalkon.WebPage.internalSchemes()->QStringList",
    "PyFalkon.WebPage.isLoading(self)->bool",
    "PyFalkon.WebPage.isRunningLoop(self)->bool",
    "PyFalkon.WebPage.javaScriptAlert(self,securityOrigin:PySide2.QtCore.QUrl,msg:QString)",
    "PyFalkon.WebPage.javaScriptConfirm(self,securityOrigin:PySide2.QtCore.QUrl,msg:QString)->bool",
    "PyFalkon.WebPage.javaScriptConsoleMessage(self,level:PySide2.QtWebEngineWidgets.QWebEnginePage.JavaScriptConsoleMessageLevel,message:QString,lineNumber:int,sourceID:QString)",
    "PyFalkon.WebPage.mapToViewport(self,pos:PySide2.QtCore.QPointF)->PySide2.QtCore.QPointF",
    "PyFalkon.WebPage.progress(self,prog:int)",
    "PyFalkon.WebPage.registerProtocolHandlerRequestScheme(self)->QString",
    "PyFalkon.WebPage.registerProtocolHandlerRequestUrl(self)->PySide2.QtCore.QUrl",
    "PyFalkon.WebPage.removeSupportedScheme(scheme:QString)",
    "PyFalkon.WebPage.renderProcessTerminated(self,terminationStatus:PySide2.QtWebEngineWidgets.QWebEnginePage.RenderProcessTerminationStatus,exitCode:int)",
    "PyFalkon.WebPage.scroll(self,x:int,y:int)",
    "PyFalkon.WebPage.setScrollPosition(self,pos:PySide2.QtCore.QPointF)",
    "PyFalkon.WebPage.supportedSchemes()->QStringList",
    "PyFalkon.WebPage.urlChanged(self,url:PySide2.QtCore.QUrl)",
    "PyFalkon.WebPage.view(self)->PyFalkon.WebView",
    "PyFalkon.WebPage.windowCloseRequested(self)",
    nullptr}; // Sentinel

void init_WebPage(PyObject *module)
{
    _Sbk_WebPage_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "WebPage",
        "WebPage*",
        &Sbk_WebPage_spec,
        &Shiboken::callCppDestructor< ::WebPage >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_WebPage_Type);
    InitSignatureStrings(pyType, WebPage_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_WebPage_Type), Sbk_WebPage_PropertyStrings);
    SbkPyFalkonTypes[SBK_WEBPAGE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_WebPage_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_WebPage_TypeF(),
        WebPage_PythonToCpp_WebPage_PTR,
        is_WebPage_PythonToCpp_WebPage_PTR_Convertible,
        WebPage_PTR_CppToPython_WebPage);

    Shiboken::Conversions::registerConverterName(converter, "WebPage");
    Shiboken::Conversions::registerConverterName(converter, "WebPage*");
    Shiboken::Conversions::registerConverterName(converter, "WebPage&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::WebPage).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::WebPageWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_WebPage_TypeF(), &Sbk_WebPage_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'JsWorld'.
    SbkPyFalkonTypes[SBK_WEBPAGE_JSWORLD_IDX] = Shiboken::Enum::createScopedEnum(Sbk_WebPage_TypeF(),
        "JsWorld",
        "1:PyFalkon.WebPage.JsWorld",
        "WebPage::JsWorld");
    if (!SbkPyFalkonTypes[SBK_WEBPAGE_JSWORLD_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_WEBPAGE_JSWORLD_IDX],
        Sbk_WebPage_TypeF(), "UnsafeJsWorld", (long) WebPage::JsWorld::UnsafeJsWorld))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_WEBPAGE_JSWORLD_IDX],
        Sbk_WebPage_TypeF(), "SafeJsWorld", (long) WebPage::JsWorld::SafeJsWorld))
        return;
    // Register converter for enum 'WebPage::JsWorld'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPyFalkonTypes[SBK_WEBPAGE_JSWORLD_IDX],
            WebPage_JsWorld_CppToPython_WebPage_JsWorld);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            WebPage_JsWorld_PythonToCpp_WebPage_JsWorld,
            is_WebPage_JsWorld_PythonToCpp_WebPage_JsWorld_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPyFalkonTypes[SBK_WEBPAGE_JSWORLD_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "WebPage::JsWorld");
        Shiboken::Conversions::registerConverterName(converter, "JsWorld");
    }
    // End of 'JsWorld' enum.

    PySide::Signal::registerSignals(Sbk_WebPage_TypeF(), &::WebPage::staticMetaObject);

    WebPageWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_WebPage_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_WebPage_TypeF(), &::WebPage::staticMetaObject, sizeof(WebPageWrapper));
}
