/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "bluez.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.bluez.MediaTransport1
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:BluezMediaTransport1
 * @title: BluezMediaTransport1
 * @short_description: Generated C code for the org.bluez.MediaTransport1 D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-bluez-MediaTransport1.top_of_page">org.bluez.MediaTransport1</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.bluez.MediaTransport1 ---- */

static const _ExtendedGDBusArgInfo _bluez_media_transport1_method_info_acquire_OUT_ARG_fd =
{
  {
    -1,
    (gchar *) "fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _bluez_media_transport1_method_info_acquire_OUT_ARG_mtu_r =
{
  {
    -1,
    (gchar *) "mtu_r",
    (gchar *) "q",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _bluez_media_transport1_method_info_acquire_OUT_ARG_mtu_w =
{
  {
    -1,
    (gchar *) "mtu_w",
    (gchar *) "q",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _bluez_media_transport1_method_info_acquire_OUT_ARG_pointers[] =
{
  &_bluez_media_transport1_method_info_acquire_OUT_ARG_fd.parent_struct,
  &_bluez_media_transport1_method_info_acquire_OUT_ARG_mtu_r.parent_struct,
  &_bluez_media_transport1_method_info_acquire_OUT_ARG_mtu_w.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _bluez_media_transport1_method_info_acquire =
{
  {
    -1,
    (gchar *) "Acquire",
    NULL,
    (GDBusArgInfo **) &_bluez_media_transport1_method_info_acquire_OUT_ARG_pointers,
    NULL
  },
  "handle-acquire",
  TRUE
};

static const _ExtendedGDBusArgInfo _bluez_media_transport1_method_info_try_acquire_OUT_ARG_fd =
{
  {
    -1,
    (gchar *) "fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _bluez_media_transport1_method_info_try_acquire_OUT_ARG_mtu_r =
{
  {
    -1,
    (gchar *) "mtu_r",
    (gchar *) "q",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _bluez_media_transport1_method_info_try_acquire_OUT_ARG_mtu_w =
{
  {
    -1,
    (gchar *) "mtu_w",
    (gchar *) "q",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _bluez_media_transport1_method_info_try_acquire_OUT_ARG_pointers[] =
{
  &_bluez_media_transport1_method_info_try_acquire_OUT_ARG_fd.parent_struct,
  &_bluez_media_transport1_method_info_try_acquire_OUT_ARG_mtu_r.parent_struct,
  &_bluez_media_transport1_method_info_try_acquire_OUT_ARG_mtu_w.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _bluez_media_transport1_method_info_try_acquire =
{
  {
    -1,
    (gchar *) "TryAcquire",
    NULL,
    (GDBusArgInfo **) &_bluez_media_transport1_method_info_try_acquire_OUT_ARG_pointers,
    NULL
  },
  "handle-try-acquire",
  TRUE
};

static const _ExtendedGDBusMethodInfo _bluez_media_transport1_method_info_release =
{
  {
    -1,
    (gchar *) "Release",
    NULL,
    NULL,
    NULL
  },
  "handle-release",
  FALSE
};

static const GDBusMethodInfo * const _bluez_media_transport1_method_info_pointers[] =
{
  &_bluez_media_transport1_method_info_acquire.parent_struct,
  &_bluez_media_transport1_method_info_try_acquire.parent_struct,
  &_bluez_media_transport1_method_info_release.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _bluez_media_transport1_property_info_device =
{
  {
    -1,
    (gchar *) "Device",
    (gchar *) "o",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "device",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _bluez_media_transport1_property_info_uuid =
{
  {
    -1,
    (gchar *) "UUID",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "uuid",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _bluez_media_transport1_property_info_codec =
{
  {
    -1,
    (gchar *) "Codec",
    (gchar *) "y",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "codec",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _bluez_media_transport1_property_info_configuration =
{
  {
    -1,
    (gchar *) "Configuration",
    (gchar *) "ay",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "configuration",
  TRUE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _bluez_media_transport1_property_info_state =
{
  {
    -1,
    (gchar *) "State",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "state",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _bluez_media_transport1_property_info_delay =
{
  {
    -1,
    (gchar *) "Delay",
    (gchar *) "q",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "delay",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _bluez_media_transport1_property_info_volume =
{
  {
    -1,
    (gchar *) "Volume",
    (gchar *) "q",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "volume",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _bluez_media_transport1_property_info_pointers[] =
{
  &_bluez_media_transport1_property_info_device.parent_struct,
  &_bluez_media_transport1_property_info_uuid.parent_struct,
  &_bluez_media_transport1_property_info_codec.parent_struct,
  &_bluez_media_transport1_property_info_configuration.parent_struct,
  &_bluez_media_transport1_property_info_state.parent_struct,
  &_bluez_media_transport1_property_info_delay.parent_struct,
  &_bluez_media_transport1_property_info_volume.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _bluez_media_transport1_interface_info =
{
  {
    -1,
    (gchar *) "org.bluez.MediaTransport1",
    (GDBusMethodInfo **) &_bluez_media_transport1_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_bluez_media_transport1_property_info_pointers,
    NULL
  },
  "media-transport1",
};


/**
 * bluez_media_transport1_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-bluez-MediaTransport1.top_of_page">org.bluez.MediaTransport1</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
bluez_media_transport1_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_bluez_media_transport1_interface_info.parent_struct;
}

/**
 * bluez_media_transport1_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #BluezMediaTransport1 interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
bluez_media_transport1_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "device");
  g_object_class_override_property (klass, property_id_begin++, "uuid");
  g_object_class_override_property (klass, property_id_begin++, "codec");
  g_object_class_override_property (klass, property_id_begin++, "configuration");
  g_object_class_override_property (klass, property_id_begin++, "state");
  g_object_class_override_property (klass, property_id_begin++, "delay");
  g_object_class_override_property (klass, property_id_begin++, "volume");
  return property_id_begin - 1;
}



/**
 * BluezMediaTransport1:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-bluez-MediaTransport1.top_of_page">org.bluez.MediaTransport1</link>.
 */

/**
 * BluezMediaTransport1Iface:
 * @parent_iface: The parent interface.
 * @handle_acquire: Handler for the #BluezMediaTransport1::handle-acquire signal.
 * @handle_release: Handler for the #BluezMediaTransport1::handle-release signal.
 * @handle_try_acquire: Handler for the #BluezMediaTransport1::handle-try-acquire signal.
 * @get_codec: Getter for the #BluezMediaTransport1:codec property.
 * @get_configuration: Getter for the #BluezMediaTransport1:configuration property.
 * @get_delay: Getter for the #BluezMediaTransport1:delay property.
 * @get_device: Getter for the #BluezMediaTransport1:device property.
 * @get_state: Getter for the #BluezMediaTransport1:state property.
 * @get_uuid: Getter for the #BluezMediaTransport1:uuid property.
 * @get_volume: Getter for the #BluezMediaTransport1:volume property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-bluez-MediaTransport1.top_of_page">org.bluez.MediaTransport1</link>.
 */

typedef BluezMediaTransport1Iface BluezMediaTransport1Interface;
G_DEFINE_INTERFACE (BluezMediaTransport1, bluez_media_transport1, G_TYPE_OBJECT)

static void
bluez_media_transport1_default_init (BluezMediaTransport1Iface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * BluezMediaTransport1::handle-acquire:
   * @object: A #BluezMediaTransport1.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-bluez-MediaTransport1.Acquire">Acquire()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call bluez_media_transport1_complete_acquire() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-acquire",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (BluezMediaTransport1Iface, handle_acquire),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST);

  /**
   * BluezMediaTransport1::handle-try-acquire:
   * @object: A #BluezMediaTransport1.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-bluez-MediaTransport1.TryAcquire">TryAcquire()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call bluez_media_transport1_complete_try_acquire() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-try-acquire",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (BluezMediaTransport1Iface, handle_try_acquire),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST);

  /**
   * BluezMediaTransport1::handle-release:
   * @object: A #BluezMediaTransport1.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-bluez-MediaTransport1.Release">Release()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call bluez_media_transport1_complete_release() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-release",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (BluezMediaTransport1Iface, handle_release),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject properties for D-Bus properties: */
  /**
   * BluezMediaTransport1:device:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-MediaTransport1.Device">"Device"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("device", "Device", "Device", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * BluezMediaTransport1:uuid:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-MediaTransport1.UUID">"UUID"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("uuid", "UUID", "UUID", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * BluezMediaTransport1:codec:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-MediaTransport1.Codec">"Codec"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uchar ("codec", "Codec", "Codec", 0, 255, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * BluezMediaTransport1:configuration:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-MediaTransport1.Configuration">"Configuration"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("configuration", "Configuration", "Configuration", G_VARIANT_TYPE ("ay"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * BluezMediaTransport1:state:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-MediaTransport1.State">"State"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("state", "State", "State", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * BluezMediaTransport1:delay:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-MediaTransport1.Delay">"Delay"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("delay", "Delay", "Delay", 0, G_MAXUINT16, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * BluezMediaTransport1:volume:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-MediaTransport1.Volume">"Volume"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("volume", "Volume", "Volume", 0, G_MAXUINT16, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * bluez_media_transport1_get_device: (skip)
 * @object: A #BluezMediaTransport1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-MediaTransport1.Device">"Device"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use bluez_media_transport1_dup_device() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
bluez_media_transport1_get_device (BluezMediaTransport1 *object)
{
  return BLUEZ_MEDIA_TRANSPORT1_GET_IFACE (object)->get_device (object);
}

/**
 * bluez_media_transport1_dup_device: (skip)
 * @object: A #BluezMediaTransport1.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-bluez-MediaTransport1.Device">"Device"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
bluez_media_transport1_dup_device (BluezMediaTransport1 *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "device", &value, NULL);
  return value;
}

/**
 * bluez_media_transport1_set_device: (skip)
 * @object: A #BluezMediaTransport1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-MediaTransport1.Device">"Device"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez_media_transport1_set_device (BluezMediaTransport1 *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "device", value, NULL);
}

/**
 * bluez_media_transport1_get_uuid: (skip)
 * @object: A #BluezMediaTransport1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-MediaTransport1.UUID">"UUID"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use bluez_media_transport1_dup_uuid() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
bluez_media_transport1_get_uuid (BluezMediaTransport1 *object)
{
  return BLUEZ_MEDIA_TRANSPORT1_GET_IFACE (object)->get_uuid (object);
}

/**
 * bluez_media_transport1_dup_uuid: (skip)
 * @object: A #BluezMediaTransport1.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-bluez-MediaTransport1.UUID">"UUID"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
bluez_media_transport1_dup_uuid (BluezMediaTransport1 *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "uuid", &value, NULL);
  return value;
}

/**
 * bluez_media_transport1_set_uuid: (skip)
 * @object: A #BluezMediaTransport1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-MediaTransport1.UUID">"UUID"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez_media_transport1_set_uuid (BluezMediaTransport1 *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "uuid", value, NULL);
}

/**
 * bluez_media_transport1_get_codec: (skip)
 * @object: A #BluezMediaTransport1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-MediaTransport1.Codec">"Codec"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guchar 
bluez_media_transport1_get_codec (BluezMediaTransport1 *object)
{
  return BLUEZ_MEDIA_TRANSPORT1_GET_IFACE (object)->get_codec (object);
}

/**
 * bluez_media_transport1_set_codec: (skip)
 * @object: A #BluezMediaTransport1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-MediaTransport1.Codec">"Codec"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez_media_transport1_set_codec (BluezMediaTransport1 *object, guchar value)
{
  g_object_set (G_OBJECT (object), "codec", value, NULL);
}

/**
 * bluez_media_transport1_get_configuration: (skip)
 * @object: A #BluezMediaTransport1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-MediaTransport1.Configuration">"Configuration"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use bluez_media_transport1_dup_configuration() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
bluez_media_transport1_get_configuration (BluezMediaTransport1 *object)
{
  return BLUEZ_MEDIA_TRANSPORT1_GET_IFACE (object)->get_configuration (object);
}

/**
 * bluez_media_transport1_dup_configuration: (skip)
 * @object: A #BluezMediaTransport1.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-bluez-MediaTransport1.Configuration">"Configuration"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
bluez_media_transport1_dup_configuration (BluezMediaTransport1 *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "configuration", &value, NULL);
  return value;
}

/**
 * bluez_media_transport1_set_configuration: (skip)
 * @object: A #BluezMediaTransport1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-MediaTransport1.Configuration">"Configuration"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez_media_transport1_set_configuration (BluezMediaTransport1 *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "configuration", value, NULL);
}

/**
 * bluez_media_transport1_get_state: (skip)
 * @object: A #BluezMediaTransport1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-MediaTransport1.State">"State"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use bluez_media_transport1_dup_state() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
bluez_media_transport1_get_state (BluezMediaTransport1 *object)
{
  return BLUEZ_MEDIA_TRANSPORT1_GET_IFACE (object)->get_state (object);
}

/**
 * bluez_media_transport1_dup_state: (skip)
 * @object: A #BluezMediaTransport1.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-bluez-MediaTransport1.State">"State"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
bluez_media_transport1_dup_state (BluezMediaTransport1 *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "state", &value, NULL);
  return value;
}

/**
 * bluez_media_transport1_set_state: (skip)
 * @object: A #BluezMediaTransport1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-MediaTransport1.State">"State"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez_media_transport1_set_state (BluezMediaTransport1 *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "state", value, NULL);
}

/**
 * bluez_media_transport1_get_delay: (skip)
 * @object: A #BluezMediaTransport1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-MediaTransport1.Delay">"Delay"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint16 
bluez_media_transport1_get_delay (BluezMediaTransport1 *object)
{
  return BLUEZ_MEDIA_TRANSPORT1_GET_IFACE (object)->get_delay (object);
}

/**
 * bluez_media_transport1_set_delay: (skip)
 * @object: A #BluezMediaTransport1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-MediaTransport1.Delay">"Delay"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez_media_transport1_set_delay (BluezMediaTransport1 *object, guint16 value)
{
  g_object_set (G_OBJECT (object), "delay", value, NULL);
}

/**
 * bluez_media_transport1_get_volume: (skip)
 * @object: A #BluezMediaTransport1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-MediaTransport1.Volume">"Volume"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint16 
bluez_media_transport1_get_volume (BluezMediaTransport1 *object)
{
  return BLUEZ_MEDIA_TRANSPORT1_GET_IFACE (object)->get_volume (object);
}

/**
 * bluez_media_transport1_set_volume: (skip)
 * @object: A #BluezMediaTransport1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-MediaTransport1.Volume">"Volume"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
bluez_media_transport1_set_volume (BluezMediaTransport1 *object, guint16 value)
{
  g_object_set (G_OBJECT (object), "volume", value, NULL);
}

/**
 * bluez_media_transport1_call_acquire:
 * @proxy: A #BluezMediaTransport1Proxy.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-bluez-MediaTransport1.Acquire">Acquire()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez_media_transport1_call_acquire_finish() to get the result of the operation.
 *
 * See bluez_media_transport1_call_acquire_sync() for the synchronous, blocking version of this method.
 */
void
bluez_media_transport1_call_acquire (
    BluezMediaTransport1 *proxy,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "Acquire",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * bluez_media_transport1_call_acquire_finish:
 * @proxy: A #BluezMediaTransport1Proxy.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_mtu_r: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_mtu_w: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez_media_transport1_call_acquire().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with bluez_media_transport1_call_acquire().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
bluez_media_transport1_call_acquire_finish (
    BluezMediaTransport1 *proxy,
    GVariant **out_fd,
    guint16 *out_mtu_r,
    guint16 *out_mtu_w,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@hqq)",
                 out_fd,
                 out_mtu_r,
                 out_mtu_w);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * bluez_media_transport1_call_acquire_sync:
 * @proxy: A #BluezMediaTransport1Proxy.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_mtu_r: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_mtu_w: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-bluez-MediaTransport1.Acquire">Acquire()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See bluez_media_transport1_call_acquire() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
bluez_media_transport1_call_acquire_sync (
    BluezMediaTransport1 *proxy,
    GUnixFDList  *fd_list,
    GVariant **out_fd,
    guint16 *out_mtu_r,
    guint16 *out_mtu_w,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "Acquire",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@hqq)",
                 out_fd,
                 out_mtu_r,
                 out_mtu_w);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * bluez_media_transport1_call_try_acquire:
 * @proxy: A #BluezMediaTransport1Proxy.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-bluez-MediaTransport1.TryAcquire">TryAcquire()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez_media_transport1_call_try_acquire_finish() to get the result of the operation.
 *
 * See bluez_media_transport1_call_try_acquire_sync() for the synchronous, blocking version of this method.
 */
void
bluez_media_transport1_call_try_acquire (
    BluezMediaTransport1 *proxy,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "TryAcquire",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * bluez_media_transport1_call_try_acquire_finish:
 * @proxy: A #BluezMediaTransport1Proxy.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_mtu_r: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_mtu_w: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez_media_transport1_call_try_acquire().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with bluez_media_transport1_call_try_acquire().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
bluez_media_transport1_call_try_acquire_finish (
    BluezMediaTransport1 *proxy,
    GVariant **out_fd,
    guint16 *out_mtu_r,
    guint16 *out_mtu_w,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@hqq)",
                 out_fd,
                 out_mtu_r,
                 out_mtu_w);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * bluez_media_transport1_call_try_acquire_sync:
 * @proxy: A #BluezMediaTransport1Proxy.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_mtu_r: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_mtu_w: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-bluez-MediaTransport1.TryAcquire">TryAcquire()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See bluez_media_transport1_call_try_acquire() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
bluez_media_transport1_call_try_acquire_sync (
    BluezMediaTransport1 *proxy,
    GUnixFDList  *fd_list,
    GVariant **out_fd,
    guint16 *out_mtu_r,
    guint16 *out_mtu_w,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "TryAcquire",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@hqq)",
                 out_fd,
                 out_mtu_r,
                 out_mtu_w);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * bluez_media_transport1_call_release:
 * @proxy: A #BluezMediaTransport1Proxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-bluez-MediaTransport1.Release">Release()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez_media_transport1_call_release_finish() to get the result of the operation.
 *
 * See bluez_media_transport1_call_release_sync() for the synchronous, blocking version of this method.
 */
void
bluez_media_transport1_call_release (
    BluezMediaTransport1 *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Release",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * bluez_media_transport1_call_release_finish:
 * @proxy: A #BluezMediaTransport1Proxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez_media_transport1_call_release().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with bluez_media_transport1_call_release().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
bluez_media_transport1_call_release_finish (
    BluezMediaTransport1 *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * bluez_media_transport1_call_release_sync:
 * @proxy: A #BluezMediaTransport1Proxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-bluez-MediaTransport1.Release">Release()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See bluez_media_transport1_call_release() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
bluez_media_transport1_call_release_sync (
    BluezMediaTransport1 *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Release",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * bluez_media_transport1_complete_acquire:
 * @object: A #BluezMediaTransport1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @fd: Parameter to return.
 * @mtu_r: Parameter to return.
 * @mtu_w: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-bluez-MediaTransport1.Acquire">Acquire()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
bluez_media_transport1_complete_acquire (
    BluezMediaTransport1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    GVariant *fd,
    guint16 mtu_r,
    guint16 mtu_w)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(@hqq)",
                   fd,
                   mtu_r,
                   mtu_w),
    fd_list);
}

/**
 * bluez_media_transport1_complete_try_acquire:
 * @object: A #BluezMediaTransport1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @fd: Parameter to return.
 * @mtu_r: Parameter to return.
 * @mtu_w: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-bluez-MediaTransport1.TryAcquire">TryAcquire()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
bluez_media_transport1_complete_try_acquire (
    BluezMediaTransport1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    GVariant *fd,
    guint16 mtu_r,
    guint16 mtu_w)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(@hqq)",
                   fd,
                   mtu_r,
                   mtu_w),
    fd_list);
}

/**
 * bluez_media_transport1_complete_release:
 * @object: A #BluezMediaTransport1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-bluez-MediaTransport1.Release">Release()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
bluez_media_transport1_complete_release (
    BluezMediaTransport1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * BluezMediaTransport1Proxy:
 *
 * The #BluezMediaTransport1Proxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * BluezMediaTransport1ProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #BluezMediaTransport1Proxy.
 */

struct _BluezMediaTransport1ProxyPrivate
{
  GData *qdata;
};

static void bluez_media_transport1_proxy_iface_init (BluezMediaTransport1Iface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (BluezMediaTransport1Proxy, bluez_media_transport1_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (BluezMediaTransport1Proxy)
                         G_IMPLEMENT_INTERFACE (BLUEZ_TYPE_MEDIA_TRANSPORT1, bluez_media_transport1_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (BluezMediaTransport1Proxy, bluez_media_transport1_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (BLUEZ_TYPE_MEDIA_TRANSPORT1, bluez_media_transport1_proxy_iface_init))

#endif
static void
bluez_media_transport1_proxy_finalize (GObject *object)
{
  BluezMediaTransport1Proxy *proxy = BLUEZ_MEDIA_TRANSPORT1_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (bluez_media_transport1_proxy_parent_class)->finalize (object);
}

static void
bluez_media_transport1_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  info = (const _ExtendedGDBusPropertyInfo *) _bluez_media_transport1_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
bluez_media_transport1_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.bluez.MediaTransport1: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
bluez_media_transport1_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  info = (const _ExtendedGDBusPropertyInfo *) _bluez_media_transport1_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.bluez.MediaTransport1", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) bluez_media_transport1_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
bluez_media_transport1_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_bluez_media_transport1_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], BLUEZ_TYPE_MEDIA_TRANSPORT1);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, BLUEZ_TYPE_MEDIA_TRANSPORT1);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
bluez_media_transport1_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  BluezMediaTransport1Proxy *proxy = BLUEZ_MEDIA_TRANSPORT1_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_bluez_media_transport1_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_bluez_media_transport1_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
bluez_media_transport1_proxy_get_device (BluezMediaTransport1 *object)
{
  BluezMediaTransport1Proxy *proxy = BLUEZ_MEDIA_TRANSPORT1_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Device");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
bluez_media_transport1_proxy_get_uuid (BluezMediaTransport1 *object)
{
  BluezMediaTransport1Proxy *proxy = BLUEZ_MEDIA_TRANSPORT1_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "UUID");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guchar 
bluez_media_transport1_proxy_get_codec (BluezMediaTransport1 *object)
{
  BluezMediaTransport1Proxy *proxy = BLUEZ_MEDIA_TRANSPORT1_PROXY (object);
  GVariant *variant;
  guchar value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Codec");
  if (variant != NULL)
    {
      value = g_variant_get_byte (variant);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
bluez_media_transport1_proxy_get_configuration (BluezMediaTransport1 *object)
{
  BluezMediaTransport1Proxy *proxy = BLUEZ_MEDIA_TRANSPORT1_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Configuration");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static const gchar *
bluez_media_transport1_proxy_get_state (BluezMediaTransport1 *object)
{
  BluezMediaTransport1Proxy *proxy = BLUEZ_MEDIA_TRANSPORT1_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "State");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guint16 
bluez_media_transport1_proxy_get_delay (BluezMediaTransport1 *object)
{
  BluezMediaTransport1Proxy *proxy = BLUEZ_MEDIA_TRANSPORT1_PROXY (object);
  GVariant *variant;
  guint16 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Delay");
  if (variant != NULL)
    {
      value = g_variant_get_uint16 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint16 
bluez_media_transport1_proxy_get_volume (BluezMediaTransport1 *object)
{
  BluezMediaTransport1Proxy *proxy = BLUEZ_MEDIA_TRANSPORT1_PROXY (object);
  GVariant *variant;
  guint16 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Volume");
  if (variant != NULL)
    {
      value = g_variant_get_uint16 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
bluez_media_transport1_proxy_init (BluezMediaTransport1Proxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = bluez_media_transport1_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, BLUEZ_TYPE_MEDIA_TRANSPORT1_PROXY, BluezMediaTransport1ProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), bluez_media_transport1_interface_info ());
}

static void
bluez_media_transport1_proxy_class_init (BluezMediaTransport1ProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = bluez_media_transport1_proxy_finalize;
  gobject_class->get_property = bluez_media_transport1_proxy_get_property;
  gobject_class->set_property = bluez_media_transport1_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = bluez_media_transport1_proxy_g_signal;
  proxy_class->g_properties_changed = bluez_media_transport1_proxy_g_properties_changed;

  bluez_media_transport1_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (BluezMediaTransport1ProxyPrivate));
#endif
}

static void
bluez_media_transport1_proxy_iface_init (BluezMediaTransport1Iface *iface)
{
  iface->get_device = bluez_media_transport1_proxy_get_device;
  iface->get_uuid = bluez_media_transport1_proxy_get_uuid;
  iface->get_codec = bluez_media_transport1_proxy_get_codec;
  iface->get_configuration = bluez_media_transport1_proxy_get_configuration;
  iface->get_state = bluez_media_transport1_proxy_get_state;
  iface->get_delay = bluez_media_transport1_proxy_get_delay;
  iface->get_volume = bluez_media_transport1_proxy_get_volume;
}

/**
 * bluez_media_transport1_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-bluez-MediaTransport1.top_of_page">org.bluez.MediaTransport1</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez_media_transport1_proxy_new_finish() to get the result of the operation.
 *
 * See bluez_media_transport1_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
bluez_media_transport1_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (BLUEZ_TYPE_MEDIA_TRANSPORT1_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.bluez.MediaTransport1", NULL);
}

/**
 * bluez_media_transport1_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez_media_transport1_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with bluez_media_transport1_proxy_new().
 *
 * Returns: (transfer full) (type BluezMediaTransport1Proxy): The constructed proxy object or %NULL if @error is set.
 */
BluezMediaTransport1 *
bluez_media_transport1_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return BLUEZ_MEDIA_TRANSPORT1 (ret);
  else
    return NULL;
}

/**
 * bluez_media_transport1_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-bluez-MediaTransport1.top_of_page">org.bluez.MediaTransport1</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See bluez_media_transport1_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type BluezMediaTransport1Proxy): The constructed proxy object or %NULL if @error is set.
 */
BluezMediaTransport1 *
bluez_media_transport1_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (BLUEZ_TYPE_MEDIA_TRANSPORT1_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.bluez.MediaTransport1", NULL);
  if (ret != NULL)
    return BLUEZ_MEDIA_TRANSPORT1 (ret);
  else
    return NULL;
}


/**
 * bluez_media_transport1_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like bluez_media_transport1_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez_media_transport1_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See bluez_media_transport1_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
bluez_media_transport1_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (BLUEZ_TYPE_MEDIA_TRANSPORT1_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.bluez.MediaTransport1", NULL);
}

/**
 * bluez_media_transport1_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez_media_transport1_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with bluez_media_transport1_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type BluezMediaTransport1Proxy): The constructed proxy object or %NULL if @error is set.
 */
BluezMediaTransport1 *
bluez_media_transport1_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return BLUEZ_MEDIA_TRANSPORT1 (ret);
  else
    return NULL;
}

/**
 * bluez_media_transport1_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like bluez_media_transport1_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See bluez_media_transport1_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type BluezMediaTransport1Proxy): The constructed proxy object or %NULL if @error is set.
 */
BluezMediaTransport1 *
bluez_media_transport1_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (BLUEZ_TYPE_MEDIA_TRANSPORT1_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.bluez.MediaTransport1", NULL);
  if (ret != NULL)
    return BLUEZ_MEDIA_TRANSPORT1 (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * BluezMediaTransport1Skeleton:
 *
 * The #BluezMediaTransport1Skeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * BluezMediaTransport1SkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #BluezMediaTransport1Skeleton.
 */

struct _BluezMediaTransport1SkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_bluez_media_transport1_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  BluezMediaTransport1Skeleton *skeleton = BLUEZ_MEDIA_TRANSPORT1_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], BLUEZ_TYPE_MEDIA_TRANSPORT1);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, BLUEZ_TYPE_MEDIA_TRANSPORT1);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_bluez_media_transport1_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  BluezMediaTransport1Skeleton *skeleton = BLUEZ_MEDIA_TRANSPORT1_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_bluez_media_transport1_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_bluez_media_transport1_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  BluezMediaTransport1Skeleton *skeleton = BLUEZ_MEDIA_TRANSPORT1_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_bluez_media_transport1_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _bluez_media_transport1_skeleton_vtable =
{
  _bluez_media_transport1_skeleton_handle_method_call,
  _bluez_media_transport1_skeleton_handle_get_property,
  _bluez_media_transport1_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
bluez_media_transport1_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return bluez_media_transport1_interface_info ();
}

static GDBusInterfaceVTable *
bluez_media_transport1_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_bluez_media_transport1_skeleton_vtable;
}

static GVariant *
bluez_media_transport1_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  BluezMediaTransport1Skeleton *skeleton = BLUEZ_MEDIA_TRANSPORT1_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_bluez_media_transport1_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _bluez_media_transport1_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _bluez_media_transport1_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _bluez_media_transport1_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.bluez.MediaTransport1", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _bluez_media_transport1_emit_changed (gpointer user_data);

static void
bluez_media_transport1_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  BluezMediaTransport1Skeleton *skeleton = BLUEZ_MEDIA_TRANSPORT1_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _bluez_media_transport1_emit_changed (skeleton);
}

static void bluez_media_transport1_skeleton_iface_init (BluezMediaTransport1Iface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (BluezMediaTransport1Skeleton, bluez_media_transport1_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (BluezMediaTransport1Skeleton)
                         G_IMPLEMENT_INTERFACE (BLUEZ_TYPE_MEDIA_TRANSPORT1, bluez_media_transport1_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (BluezMediaTransport1Skeleton, bluez_media_transport1_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (BLUEZ_TYPE_MEDIA_TRANSPORT1, bluez_media_transport1_skeleton_iface_init))

#endif
static void
bluez_media_transport1_skeleton_finalize (GObject *object)
{
  BluezMediaTransport1Skeleton *skeleton = BLUEZ_MEDIA_TRANSPORT1_SKELETON (object);
  guint n;
  for (n = 0; n < 7; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (bluez_media_transport1_skeleton_parent_class)->finalize (object);
}

static void
bluez_media_transport1_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  BluezMediaTransport1Skeleton *skeleton = BLUEZ_MEDIA_TRANSPORT1_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_bluez_media_transport1_emit_changed (gpointer user_data)
{
  BluezMediaTransport1Skeleton *skeleton = BLUEZ_MEDIA_TRANSPORT1_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.bluez.MediaTransport1",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_bluez_media_transport1_schedule_emit_changed (BluezMediaTransport1Skeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
bluez_media_transport1_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  BluezMediaTransport1Skeleton *skeleton = BLUEZ_MEDIA_TRANSPORT1_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _bluez_media_transport1_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _bluez_media_transport1_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
bluez_media_transport1_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  BluezMediaTransport1Skeleton *skeleton = BLUEZ_MEDIA_TRANSPORT1_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  info = (const _ExtendedGDBusPropertyInfo *) _bluez_media_transport1_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _bluez_media_transport1_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
bluez_media_transport1_skeleton_init (BluezMediaTransport1Skeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = bluez_media_transport1_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, BLUEZ_TYPE_MEDIA_TRANSPORT1_SKELETON, BluezMediaTransport1SkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 7);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_UCHAR);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_UINT);
}

static const gchar *
bluez_media_transport1_skeleton_get_device (BluezMediaTransport1 *object)
{
  BluezMediaTransport1Skeleton *skeleton = BLUEZ_MEDIA_TRANSPORT1_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
bluez_media_transport1_skeleton_get_uuid (BluezMediaTransport1 *object)
{
  BluezMediaTransport1Skeleton *skeleton = BLUEZ_MEDIA_TRANSPORT1_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guchar 
bluez_media_transport1_skeleton_get_codec (BluezMediaTransport1 *object)
{
  BluezMediaTransport1Skeleton *skeleton = BLUEZ_MEDIA_TRANSPORT1_SKELETON (object);
  guchar value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uchar (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
bluez_media_transport1_skeleton_get_configuration (BluezMediaTransport1 *object)
{
  BluezMediaTransport1Skeleton *skeleton = BLUEZ_MEDIA_TRANSPORT1_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
bluez_media_transport1_skeleton_get_state (BluezMediaTransport1 *object)
{
  BluezMediaTransport1Skeleton *skeleton = BLUEZ_MEDIA_TRANSPORT1_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint16 
bluez_media_transport1_skeleton_get_delay (BluezMediaTransport1 *object)
{
  BluezMediaTransport1Skeleton *skeleton = BLUEZ_MEDIA_TRANSPORT1_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint16 
bluez_media_transport1_skeleton_get_volume (BluezMediaTransport1 *object)
{
  BluezMediaTransport1Skeleton *skeleton = BLUEZ_MEDIA_TRANSPORT1_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
bluez_media_transport1_skeleton_class_init (BluezMediaTransport1SkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = bluez_media_transport1_skeleton_finalize;
  gobject_class->get_property = bluez_media_transport1_skeleton_get_property;
  gobject_class->set_property = bluez_media_transport1_skeleton_set_property;
  gobject_class->notify       = bluez_media_transport1_skeleton_notify;


  bluez_media_transport1_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = bluez_media_transport1_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = bluez_media_transport1_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = bluez_media_transport1_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = bluez_media_transport1_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (BluezMediaTransport1SkeletonPrivate));
#endif
}

static void
bluez_media_transport1_skeleton_iface_init (BluezMediaTransport1Iface *iface)
{
  iface->get_device = bluez_media_transport1_skeleton_get_device;
  iface->get_uuid = bluez_media_transport1_skeleton_get_uuid;
  iface->get_codec = bluez_media_transport1_skeleton_get_codec;
  iface->get_configuration = bluez_media_transport1_skeleton_get_configuration;
  iface->get_state = bluez_media_transport1_skeleton_get_state;
  iface->get_delay = bluez_media_transport1_skeleton_get_delay;
  iface->get_volume = bluez_media_transport1_skeleton_get_volume;
}

/**
 * bluez_media_transport1_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-bluez-MediaTransport1.top_of_page">org.bluez.MediaTransport1</link>.
 *
 * Returns: (transfer full) (type BluezMediaTransport1Skeleton): The skeleton object.
 */
BluezMediaTransport1 *
bluez_media_transport1_skeleton_new (void)
{
  return BLUEZ_MEDIA_TRANSPORT1 (g_object_new (BLUEZ_TYPE_MEDIA_TRANSPORT1_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.bluez.MediaPlayer1
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:BluezMediaPlayer1
 * @title: BluezMediaPlayer1
 * @short_description: Generated C code for the org.bluez.MediaPlayer1 D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-bluez-MediaPlayer1.top_of_page">org.bluez.MediaPlayer1</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.bluez.MediaPlayer1 ---- */

static const _ExtendedGDBusMethodInfo _bluez_media_player1_method_info_play =
{
  {
    -1,
    (gchar *) "Play",
    NULL,
    NULL,
    NULL
  },
  "handle-play",
  FALSE
};

static const _ExtendedGDBusMethodInfo _bluez_media_player1_method_info_pause =
{
  {
    -1,
    (gchar *) "Pause",
    NULL,
    NULL,
    NULL
  },
  "handle-pause",
  FALSE
};

static const _ExtendedGDBusMethodInfo _bluez_media_player1_method_info_stop =
{
  {
    -1,
    (gchar *) "Stop",
    NULL,
    NULL,
    NULL
  },
  "handle-stop",
  FALSE
};

static const _ExtendedGDBusMethodInfo _bluez_media_player1_method_info_next =
{
  {
    -1,
    (gchar *) "Next",
    NULL,
    NULL,
    NULL
  },
  "handle-next",
  FALSE
};

static const _ExtendedGDBusMethodInfo _bluez_media_player1_method_info_previous =
{
  {
    -1,
    (gchar *) "Previous",
    NULL,
    NULL,
    NULL
  },
  "handle-previous",
  FALSE
};

static const _ExtendedGDBusMethodInfo _bluez_media_player1_method_info_fast_forward =
{
  {
    -1,
    (gchar *) "FastForward",
    NULL,
    NULL,
    NULL
  },
  "handle-fast-forward",
  FALSE
};

static const _ExtendedGDBusMethodInfo _bluez_media_player1_method_info_rewind =
{
  {
    -1,
    (gchar *) "Rewind",
    NULL,
    NULL,
    NULL
  },
  "handle-rewind",
  FALSE
};

static const GDBusMethodInfo * const _bluez_media_player1_method_info_pointers[] =
{
  &_bluez_media_player1_method_info_play.parent_struct,
  &_bluez_media_player1_method_info_pause.parent_struct,
  &_bluez_media_player1_method_info_stop.parent_struct,
  &_bluez_media_player1_method_info_next.parent_struct,
  &_bluez_media_player1_method_info_previous.parent_struct,
  &_bluez_media_player1_method_info_fast_forward.parent_struct,
  &_bluez_media_player1_method_info_rewind.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _bluez_media_player1_property_info_name =
{
  {
    -1,
    (gchar *) "Name",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _bluez_media_player1_property_info_type_ =
{
  {
    -1,
    (gchar *) "Type",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "type",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _bluez_media_player1_property_info_subtype =
{
  {
    -1,
    (gchar *) "Subtype",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "subtype",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _bluez_media_player1_property_info_position =
{
  {
    -1,
    (gchar *) "Position",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "position",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _bluez_media_player1_property_info_status =
{
  {
    -1,
    (gchar *) "Status",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "status",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _bluez_media_player1_property_info_equalizer =
{
  {
    -1,
    (gchar *) "Equalizer",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "equalizer",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _bluez_media_player1_property_info_repeat =
{
  {
    -1,
    (gchar *) "Repeat",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "repeat",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _bluez_media_player1_property_info_shuffle =
{
  {
    -1,
    (gchar *) "Shuffle",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "shuffle",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _bluez_media_player1_property_info_scan =
{
  {
    -1,
    (gchar *) "Scan",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "scan",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _bluez_media_player1_property_info_track =
{
  {
    -1,
    (gchar *) "Track",
    (gchar *) "a{sv}",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "track",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _bluez_media_player1_property_info_device =
{
  {
    -1,
    (gchar *) "Device",
    (gchar *) "o",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "device",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _bluez_media_player1_property_info_browsable =
{
  {
    -1,
    (gchar *) "Browsable",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "browsable",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _bluez_media_player1_property_info_searchable =
{
  {
    -1,
    (gchar *) "Searchable",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "searchable",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _bluez_media_player1_property_info_playlist =
{
  {
    -1,
    (gchar *) "Playlist",
    (gchar *) "o",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "playlist",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _bluez_media_player1_property_info_pointers[] =
{
  &_bluez_media_player1_property_info_name.parent_struct,
  &_bluez_media_player1_property_info_type_.parent_struct,
  &_bluez_media_player1_property_info_subtype.parent_struct,
  &_bluez_media_player1_property_info_position.parent_struct,
  &_bluez_media_player1_property_info_status.parent_struct,
  &_bluez_media_player1_property_info_equalizer.parent_struct,
  &_bluez_media_player1_property_info_repeat.parent_struct,
  &_bluez_media_player1_property_info_shuffle.parent_struct,
  &_bluez_media_player1_property_info_scan.parent_struct,
  &_bluez_media_player1_property_info_track.parent_struct,
  &_bluez_media_player1_property_info_device.parent_struct,
  &_bluez_media_player1_property_info_browsable.parent_struct,
  &_bluez_media_player1_property_info_searchable.parent_struct,
  &_bluez_media_player1_property_info_playlist.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _bluez_media_player1_interface_info =
{
  {
    -1,
    (gchar *) "org.bluez.MediaPlayer1",
    (GDBusMethodInfo **) &_bluez_media_player1_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_bluez_media_player1_property_info_pointers,
    NULL
  },
  "media-player1",
};


/**
 * bluez_media_player1_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-bluez-MediaPlayer1.top_of_page">org.bluez.MediaPlayer1</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
bluez_media_player1_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_bluez_media_player1_interface_info.parent_struct;
}

/**
 * bluez_media_player1_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #BluezMediaPlayer1 interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
bluez_media_player1_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "name");
  g_object_class_override_property (klass, property_id_begin++, "type");
  g_object_class_override_property (klass, property_id_begin++, "subtype");
  g_object_class_override_property (klass, property_id_begin++, "position");
  g_object_class_override_property (klass, property_id_begin++, "status");
  g_object_class_override_property (klass, property_id_begin++, "equalizer");
  g_object_class_override_property (klass, property_id_begin++, "repeat");
  g_object_class_override_property (klass, property_id_begin++, "shuffle");
  g_object_class_override_property (klass, property_id_begin++, "scan");
  g_object_class_override_property (klass, property_id_begin++, "track");
  g_object_class_override_property (klass, property_id_begin++, "device");
  g_object_class_override_property (klass, property_id_begin++, "browsable");
  g_object_class_override_property (klass, property_id_begin++, "searchable");
  g_object_class_override_property (klass, property_id_begin++, "playlist");
  return property_id_begin - 1;
}



/**
 * BluezMediaPlayer1:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-bluez-MediaPlayer1.top_of_page">org.bluez.MediaPlayer1</link>.
 */

/**
 * BluezMediaPlayer1Iface:
 * @parent_iface: The parent interface.
 * @handle_fast_forward: Handler for the #BluezMediaPlayer1::handle-fast-forward signal.
 * @handle_next: Handler for the #BluezMediaPlayer1::handle-next signal.
 * @handle_pause: Handler for the #BluezMediaPlayer1::handle-pause signal.
 * @handle_play: Handler for the #BluezMediaPlayer1::handle-play signal.
 * @handle_previous: Handler for the #BluezMediaPlayer1::handle-previous signal.
 * @handle_rewind: Handler for the #BluezMediaPlayer1::handle-rewind signal.
 * @handle_stop: Handler for the #BluezMediaPlayer1::handle-stop signal.
 * @get_browsable: Getter for the #BluezMediaPlayer1:browsable property.
 * @get_device: Getter for the #BluezMediaPlayer1:device property.
 * @get_equalizer: Getter for the #BluezMediaPlayer1:equalizer property.
 * @get_name: Getter for the #BluezMediaPlayer1:name property.
 * @get_playlist: Getter for the #BluezMediaPlayer1:playlist property.
 * @get_position: Getter for the #BluezMediaPlayer1:position property.
 * @get_repeat: Getter for the #BluezMediaPlayer1:repeat property.
 * @get_scan: Getter for the #BluezMediaPlayer1:scan property.
 * @get_searchable: Getter for the #BluezMediaPlayer1:searchable property.
 * @get_shuffle: Getter for the #BluezMediaPlayer1:shuffle property.
 * @get_status: Getter for the #BluezMediaPlayer1:status property.
 * @get_subtype: Getter for the #BluezMediaPlayer1:subtype property.
 * @get_track: Getter for the #BluezMediaPlayer1:track property.
 * @get_type_: Getter for the #BluezMediaPlayer1:type property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-bluez-MediaPlayer1.top_of_page">org.bluez.MediaPlayer1</link>.
 */

typedef BluezMediaPlayer1Iface BluezMediaPlayer1Interface;
G_DEFINE_INTERFACE (BluezMediaPlayer1, bluez_media_player1, G_TYPE_OBJECT)

static void
bluez_media_player1_default_init (BluezMediaPlayer1Iface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * BluezMediaPlayer1::handle-play:
   * @object: A #BluezMediaPlayer1.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-bluez-MediaPlayer1.Play">Play()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call bluez_media_player1_complete_play() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-play",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (BluezMediaPlayer1Iface, handle_play),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * BluezMediaPlayer1::handle-pause:
   * @object: A #BluezMediaPlayer1.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-bluez-MediaPlayer1.Pause">Pause()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call bluez_media_player1_complete_pause() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-pause",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (BluezMediaPlayer1Iface, handle_pause),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * BluezMediaPlayer1::handle-stop:
   * @object: A #BluezMediaPlayer1.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-bluez-MediaPlayer1.Stop">Stop()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call bluez_media_player1_complete_stop() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-stop",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (BluezMediaPlayer1Iface, handle_stop),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * BluezMediaPlayer1::handle-next:
   * @object: A #BluezMediaPlayer1.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-bluez-MediaPlayer1.Next">Next()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call bluez_media_player1_complete_next() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-next",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (BluezMediaPlayer1Iface, handle_next),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * BluezMediaPlayer1::handle-previous:
   * @object: A #BluezMediaPlayer1.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-bluez-MediaPlayer1.Previous">Previous()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call bluez_media_player1_complete_previous() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-previous",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (BluezMediaPlayer1Iface, handle_previous),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * BluezMediaPlayer1::handle-fast-forward:
   * @object: A #BluezMediaPlayer1.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-bluez-MediaPlayer1.FastForward">FastForward()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call bluez_media_player1_complete_fast_forward() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-fast-forward",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (BluezMediaPlayer1Iface, handle_fast_forward),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * BluezMediaPlayer1::handle-rewind:
   * @object: A #BluezMediaPlayer1.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-bluez-MediaPlayer1.Rewind">Rewind()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call bluez_media_player1_complete_rewind() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-rewind",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (BluezMediaPlayer1Iface, handle_rewind),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject properties for D-Bus properties: */
  /**
   * BluezMediaPlayer1:name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-MediaPlayer1.Name">"Name"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("name", "Name", "Name", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * BluezMediaPlayer1:type:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-MediaPlayer1.Type">"Type"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("type", "Type", "Type", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * BluezMediaPlayer1:subtype:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-MediaPlayer1.Subtype">"Subtype"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("subtype", "Subtype", "Subtype", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * BluezMediaPlayer1:position:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-MediaPlayer1.Position">"Position"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("position", "Position", "Position", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * BluezMediaPlayer1:status:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-MediaPlayer1.Status">"Status"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("status", "Status", "Status", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * BluezMediaPlayer1:equalizer:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-MediaPlayer1.Equalizer">"Equalizer"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("equalizer", "Equalizer", "Equalizer", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * BluezMediaPlayer1:repeat:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-MediaPlayer1.Repeat">"Repeat"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("repeat", "Repeat", "Repeat", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * BluezMediaPlayer1:shuffle:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-MediaPlayer1.Shuffle">"Shuffle"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("shuffle", "Shuffle", "Shuffle", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * BluezMediaPlayer1:scan:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-MediaPlayer1.Scan">"Scan"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("scan", "Scan", "Scan", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * BluezMediaPlayer1:track:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-MediaPlayer1.Track">"Track"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("track", "Track", "Track", G_VARIANT_TYPE ("a{sv}"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * BluezMediaPlayer1:device:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-MediaPlayer1.Device">"Device"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("device", "Device", "Device", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * BluezMediaPlayer1:browsable:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-MediaPlayer1.Browsable">"Browsable"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("browsable", "Browsable", "Browsable", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * BluezMediaPlayer1:searchable:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-MediaPlayer1.Searchable">"Searchable"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("searchable", "Searchable", "Searchable", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * BluezMediaPlayer1:playlist:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-bluez-MediaPlayer1.Playlist">"Playlist"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("playlist", "Playlist", "Playlist", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * bluez_media_player1_get_name: (skip)
 * @object: A #BluezMediaPlayer1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use bluez_media_player1_dup_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
bluez_media_player1_get_name (BluezMediaPlayer1 *object)
{
  return BLUEZ_MEDIA_PLAYER1_GET_IFACE (object)->get_name (object);
}

/**
 * bluez_media_player1_dup_name: (skip)
 * @object: A #BluezMediaPlayer1.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
bluez_media_player1_dup_name (BluezMediaPlayer1 *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "name", &value, NULL);
  return value;
}

/**
 * bluez_media_player1_set_name: (skip)
 * @object: A #BluezMediaPlayer1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Name">"Name"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez_media_player1_set_name (BluezMediaPlayer1 *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "name", value, NULL);
}

/**
 * bluez_media_player1_get_type_: (skip)
 * @object: A #BluezMediaPlayer1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Type">"Type"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use bluez_media_player1_dup_type_() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
bluez_media_player1_get_type_ (BluezMediaPlayer1 *object)
{
  return BLUEZ_MEDIA_PLAYER1_GET_IFACE (object)->get_type_ (object);
}

/**
 * bluez_media_player1_dup_type_: (skip)
 * @object: A #BluezMediaPlayer1.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Type">"Type"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
bluez_media_player1_dup_type_ (BluezMediaPlayer1 *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "type", &value, NULL);
  return value;
}

/**
 * bluez_media_player1_set_type_: (skip)
 * @object: A #BluezMediaPlayer1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Type">"Type"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez_media_player1_set_type_ (BluezMediaPlayer1 *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "type", value, NULL);
}

/**
 * bluez_media_player1_get_subtype: (skip)
 * @object: A #BluezMediaPlayer1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Subtype">"Subtype"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use bluez_media_player1_dup_subtype() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
bluez_media_player1_get_subtype (BluezMediaPlayer1 *object)
{
  return BLUEZ_MEDIA_PLAYER1_GET_IFACE (object)->get_subtype (object);
}

/**
 * bluez_media_player1_dup_subtype: (skip)
 * @object: A #BluezMediaPlayer1.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Subtype">"Subtype"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
bluez_media_player1_dup_subtype (BluezMediaPlayer1 *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "subtype", &value, NULL);
  return value;
}

/**
 * bluez_media_player1_set_subtype: (skip)
 * @object: A #BluezMediaPlayer1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Subtype">"Subtype"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez_media_player1_set_subtype (BluezMediaPlayer1 *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "subtype", value, NULL);
}

/**
 * bluez_media_player1_get_position: (skip)
 * @object: A #BluezMediaPlayer1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Position">"Position"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
bluez_media_player1_get_position (BluezMediaPlayer1 *object)
{
  return BLUEZ_MEDIA_PLAYER1_GET_IFACE (object)->get_position (object);
}

/**
 * bluez_media_player1_set_position: (skip)
 * @object: A #BluezMediaPlayer1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Position">"Position"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez_media_player1_set_position (BluezMediaPlayer1 *object, guint value)
{
  g_object_set (G_OBJECT (object), "position", value, NULL);
}

/**
 * bluez_media_player1_get_status: (skip)
 * @object: A #BluezMediaPlayer1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Status">"Status"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use bluez_media_player1_dup_status() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
bluez_media_player1_get_status (BluezMediaPlayer1 *object)
{
  return BLUEZ_MEDIA_PLAYER1_GET_IFACE (object)->get_status (object);
}

/**
 * bluez_media_player1_dup_status: (skip)
 * @object: A #BluezMediaPlayer1.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Status">"Status"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
bluez_media_player1_dup_status (BluezMediaPlayer1 *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "status", &value, NULL);
  return value;
}

/**
 * bluez_media_player1_set_status: (skip)
 * @object: A #BluezMediaPlayer1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Status">"Status"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez_media_player1_set_status (BluezMediaPlayer1 *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "status", value, NULL);
}

/**
 * bluez_media_player1_get_equalizer: (skip)
 * @object: A #BluezMediaPlayer1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Equalizer">"Equalizer"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use bluez_media_player1_dup_equalizer() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
bluez_media_player1_get_equalizer (BluezMediaPlayer1 *object)
{
  return BLUEZ_MEDIA_PLAYER1_GET_IFACE (object)->get_equalizer (object);
}

/**
 * bluez_media_player1_dup_equalizer: (skip)
 * @object: A #BluezMediaPlayer1.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Equalizer">"Equalizer"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
bluez_media_player1_dup_equalizer (BluezMediaPlayer1 *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "equalizer", &value, NULL);
  return value;
}

/**
 * bluez_media_player1_set_equalizer: (skip)
 * @object: A #BluezMediaPlayer1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Equalizer">"Equalizer"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
bluez_media_player1_set_equalizer (BluezMediaPlayer1 *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "equalizer", value, NULL);
}

/**
 * bluez_media_player1_get_repeat: (skip)
 * @object: A #BluezMediaPlayer1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Repeat">"Repeat"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use bluez_media_player1_dup_repeat() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
bluez_media_player1_get_repeat (BluezMediaPlayer1 *object)
{
  return BLUEZ_MEDIA_PLAYER1_GET_IFACE (object)->get_repeat (object);
}

/**
 * bluez_media_player1_dup_repeat: (skip)
 * @object: A #BluezMediaPlayer1.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Repeat">"Repeat"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
bluez_media_player1_dup_repeat (BluezMediaPlayer1 *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "repeat", &value, NULL);
  return value;
}

/**
 * bluez_media_player1_set_repeat: (skip)
 * @object: A #BluezMediaPlayer1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Repeat">"Repeat"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
bluez_media_player1_set_repeat (BluezMediaPlayer1 *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "repeat", value, NULL);
}

/**
 * bluez_media_player1_get_shuffle: (skip)
 * @object: A #BluezMediaPlayer1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Shuffle">"Shuffle"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use bluez_media_player1_dup_shuffle() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
bluez_media_player1_get_shuffle (BluezMediaPlayer1 *object)
{
  return BLUEZ_MEDIA_PLAYER1_GET_IFACE (object)->get_shuffle (object);
}

/**
 * bluez_media_player1_dup_shuffle: (skip)
 * @object: A #BluezMediaPlayer1.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Shuffle">"Shuffle"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
bluez_media_player1_dup_shuffle (BluezMediaPlayer1 *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "shuffle", &value, NULL);
  return value;
}

/**
 * bluez_media_player1_set_shuffle: (skip)
 * @object: A #BluezMediaPlayer1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Shuffle">"Shuffle"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
bluez_media_player1_set_shuffle (BluezMediaPlayer1 *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "shuffle", value, NULL);
}

/**
 * bluez_media_player1_get_scan: (skip)
 * @object: A #BluezMediaPlayer1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Scan">"Scan"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use bluez_media_player1_dup_scan() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
bluez_media_player1_get_scan (BluezMediaPlayer1 *object)
{
  return BLUEZ_MEDIA_PLAYER1_GET_IFACE (object)->get_scan (object);
}

/**
 * bluez_media_player1_dup_scan: (skip)
 * @object: A #BluezMediaPlayer1.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Scan">"Scan"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
bluez_media_player1_dup_scan (BluezMediaPlayer1 *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "scan", &value, NULL);
  return value;
}

/**
 * bluez_media_player1_set_scan: (skip)
 * @object: A #BluezMediaPlayer1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Scan">"Scan"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
bluez_media_player1_set_scan (BluezMediaPlayer1 *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "scan", value, NULL);
}

/**
 * bluez_media_player1_get_track: (skip)
 * @object: A #BluezMediaPlayer1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Track">"Track"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use bluez_media_player1_dup_track() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
bluez_media_player1_get_track (BluezMediaPlayer1 *object)
{
  return BLUEZ_MEDIA_PLAYER1_GET_IFACE (object)->get_track (object);
}

/**
 * bluez_media_player1_dup_track: (skip)
 * @object: A #BluezMediaPlayer1.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Track">"Track"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
bluez_media_player1_dup_track (BluezMediaPlayer1 *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "track", &value, NULL);
  return value;
}

/**
 * bluez_media_player1_set_track: (skip)
 * @object: A #BluezMediaPlayer1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Track">"Track"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez_media_player1_set_track (BluezMediaPlayer1 *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "track", value, NULL);
}

/**
 * bluez_media_player1_get_device: (skip)
 * @object: A #BluezMediaPlayer1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Device">"Device"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use bluez_media_player1_dup_device() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
bluez_media_player1_get_device (BluezMediaPlayer1 *object)
{
  return BLUEZ_MEDIA_PLAYER1_GET_IFACE (object)->get_device (object);
}

/**
 * bluez_media_player1_dup_device: (skip)
 * @object: A #BluezMediaPlayer1.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Device">"Device"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
bluez_media_player1_dup_device (BluezMediaPlayer1 *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "device", &value, NULL);
  return value;
}

/**
 * bluez_media_player1_set_device: (skip)
 * @object: A #BluezMediaPlayer1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Device">"Device"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez_media_player1_set_device (BluezMediaPlayer1 *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "device", value, NULL);
}

/**
 * bluez_media_player1_get_browsable: (skip)
 * @object: A #BluezMediaPlayer1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Browsable">"Browsable"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
bluez_media_player1_get_browsable (BluezMediaPlayer1 *object)
{
  return BLUEZ_MEDIA_PLAYER1_GET_IFACE (object)->get_browsable (object);
}

/**
 * bluez_media_player1_set_browsable: (skip)
 * @object: A #BluezMediaPlayer1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Browsable">"Browsable"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez_media_player1_set_browsable (BluezMediaPlayer1 *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "browsable", value, NULL);
}

/**
 * bluez_media_player1_get_searchable: (skip)
 * @object: A #BluezMediaPlayer1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Searchable">"Searchable"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
bluez_media_player1_get_searchable (BluezMediaPlayer1 *object)
{
  return BLUEZ_MEDIA_PLAYER1_GET_IFACE (object)->get_searchable (object);
}

/**
 * bluez_media_player1_set_searchable: (skip)
 * @object: A #BluezMediaPlayer1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Searchable">"Searchable"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez_media_player1_set_searchable (BluezMediaPlayer1 *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "searchable", value, NULL);
}

/**
 * bluez_media_player1_get_playlist: (skip)
 * @object: A #BluezMediaPlayer1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Playlist">"Playlist"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use bluez_media_player1_dup_playlist() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
bluez_media_player1_get_playlist (BluezMediaPlayer1 *object)
{
  return BLUEZ_MEDIA_PLAYER1_GET_IFACE (object)->get_playlist (object);
}

/**
 * bluez_media_player1_dup_playlist: (skip)
 * @object: A #BluezMediaPlayer1.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Playlist">"Playlist"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
bluez_media_player1_dup_playlist (BluezMediaPlayer1 *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "playlist", &value, NULL);
  return value;
}

/**
 * bluez_media_player1_set_playlist: (skip)
 * @object: A #BluezMediaPlayer1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-bluez-MediaPlayer1.Playlist">"Playlist"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
bluez_media_player1_set_playlist (BluezMediaPlayer1 *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "playlist", value, NULL);
}

/**
 * bluez_media_player1_call_play:
 * @proxy: A #BluezMediaPlayer1Proxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-bluez-MediaPlayer1.Play">Play()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez_media_player1_call_play_finish() to get the result of the operation.
 *
 * See bluez_media_player1_call_play_sync() for the synchronous, blocking version of this method.
 */
void
bluez_media_player1_call_play (
    BluezMediaPlayer1 *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Play",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * bluez_media_player1_call_play_finish:
 * @proxy: A #BluezMediaPlayer1Proxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez_media_player1_call_play().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with bluez_media_player1_call_play().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
bluez_media_player1_call_play_finish (
    BluezMediaPlayer1 *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * bluez_media_player1_call_play_sync:
 * @proxy: A #BluezMediaPlayer1Proxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-bluez-MediaPlayer1.Play">Play()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See bluez_media_player1_call_play() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
bluez_media_player1_call_play_sync (
    BluezMediaPlayer1 *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Play",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * bluez_media_player1_call_pause:
 * @proxy: A #BluezMediaPlayer1Proxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-bluez-MediaPlayer1.Pause">Pause()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez_media_player1_call_pause_finish() to get the result of the operation.
 *
 * See bluez_media_player1_call_pause_sync() for the synchronous, blocking version of this method.
 */
void
bluez_media_player1_call_pause (
    BluezMediaPlayer1 *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Pause",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * bluez_media_player1_call_pause_finish:
 * @proxy: A #BluezMediaPlayer1Proxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez_media_player1_call_pause().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with bluez_media_player1_call_pause().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
bluez_media_player1_call_pause_finish (
    BluezMediaPlayer1 *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * bluez_media_player1_call_pause_sync:
 * @proxy: A #BluezMediaPlayer1Proxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-bluez-MediaPlayer1.Pause">Pause()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See bluez_media_player1_call_pause() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
bluez_media_player1_call_pause_sync (
    BluezMediaPlayer1 *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Pause",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * bluez_media_player1_call_stop:
 * @proxy: A #BluezMediaPlayer1Proxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-bluez-MediaPlayer1.Stop">Stop()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez_media_player1_call_stop_finish() to get the result of the operation.
 *
 * See bluez_media_player1_call_stop_sync() for the synchronous, blocking version of this method.
 */
void
bluez_media_player1_call_stop (
    BluezMediaPlayer1 *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * bluez_media_player1_call_stop_finish:
 * @proxy: A #BluezMediaPlayer1Proxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez_media_player1_call_stop().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with bluez_media_player1_call_stop().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
bluez_media_player1_call_stop_finish (
    BluezMediaPlayer1 *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * bluez_media_player1_call_stop_sync:
 * @proxy: A #BluezMediaPlayer1Proxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-bluez-MediaPlayer1.Stop">Stop()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See bluez_media_player1_call_stop() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
bluez_media_player1_call_stop_sync (
    BluezMediaPlayer1 *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * bluez_media_player1_call_next:
 * @proxy: A #BluezMediaPlayer1Proxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-bluez-MediaPlayer1.Next">Next()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez_media_player1_call_next_finish() to get the result of the operation.
 *
 * See bluez_media_player1_call_next_sync() for the synchronous, blocking version of this method.
 */
void
bluez_media_player1_call_next (
    BluezMediaPlayer1 *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Next",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * bluez_media_player1_call_next_finish:
 * @proxy: A #BluezMediaPlayer1Proxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez_media_player1_call_next().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with bluez_media_player1_call_next().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
bluez_media_player1_call_next_finish (
    BluezMediaPlayer1 *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * bluez_media_player1_call_next_sync:
 * @proxy: A #BluezMediaPlayer1Proxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-bluez-MediaPlayer1.Next">Next()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See bluez_media_player1_call_next() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
bluez_media_player1_call_next_sync (
    BluezMediaPlayer1 *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Next",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * bluez_media_player1_call_previous:
 * @proxy: A #BluezMediaPlayer1Proxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-bluez-MediaPlayer1.Previous">Previous()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez_media_player1_call_previous_finish() to get the result of the operation.
 *
 * See bluez_media_player1_call_previous_sync() for the synchronous, blocking version of this method.
 */
void
bluez_media_player1_call_previous (
    BluezMediaPlayer1 *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Previous",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * bluez_media_player1_call_previous_finish:
 * @proxy: A #BluezMediaPlayer1Proxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez_media_player1_call_previous().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with bluez_media_player1_call_previous().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
bluez_media_player1_call_previous_finish (
    BluezMediaPlayer1 *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * bluez_media_player1_call_previous_sync:
 * @proxy: A #BluezMediaPlayer1Proxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-bluez-MediaPlayer1.Previous">Previous()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See bluez_media_player1_call_previous() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
bluez_media_player1_call_previous_sync (
    BluezMediaPlayer1 *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Previous",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * bluez_media_player1_call_fast_forward:
 * @proxy: A #BluezMediaPlayer1Proxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-bluez-MediaPlayer1.FastForward">FastForward()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez_media_player1_call_fast_forward_finish() to get the result of the operation.
 *
 * See bluez_media_player1_call_fast_forward_sync() for the synchronous, blocking version of this method.
 */
void
bluez_media_player1_call_fast_forward (
    BluezMediaPlayer1 *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "FastForward",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * bluez_media_player1_call_fast_forward_finish:
 * @proxy: A #BluezMediaPlayer1Proxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez_media_player1_call_fast_forward().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with bluez_media_player1_call_fast_forward().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
bluez_media_player1_call_fast_forward_finish (
    BluezMediaPlayer1 *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * bluez_media_player1_call_fast_forward_sync:
 * @proxy: A #BluezMediaPlayer1Proxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-bluez-MediaPlayer1.FastForward">FastForward()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See bluez_media_player1_call_fast_forward() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
bluez_media_player1_call_fast_forward_sync (
    BluezMediaPlayer1 *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "FastForward",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * bluez_media_player1_call_rewind:
 * @proxy: A #BluezMediaPlayer1Proxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-bluez-MediaPlayer1.Rewind">Rewind()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez_media_player1_call_rewind_finish() to get the result of the operation.
 *
 * See bluez_media_player1_call_rewind_sync() for the synchronous, blocking version of this method.
 */
void
bluez_media_player1_call_rewind (
    BluezMediaPlayer1 *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Rewind",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * bluez_media_player1_call_rewind_finish:
 * @proxy: A #BluezMediaPlayer1Proxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez_media_player1_call_rewind().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with bluez_media_player1_call_rewind().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
bluez_media_player1_call_rewind_finish (
    BluezMediaPlayer1 *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * bluez_media_player1_call_rewind_sync:
 * @proxy: A #BluezMediaPlayer1Proxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-bluez-MediaPlayer1.Rewind">Rewind()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See bluez_media_player1_call_rewind() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
bluez_media_player1_call_rewind_sync (
    BluezMediaPlayer1 *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Rewind",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * bluez_media_player1_complete_play:
 * @object: A #BluezMediaPlayer1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-bluez-MediaPlayer1.Play">Play()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
bluez_media_player1_complete_play (
    BluezMediaPlayer1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * bluez_media_player1_complete_pause:
 * @object: A #BluezMediaPlayer1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-bluez-MediaPlayer1.Pause">Pause()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
bluez_media_player1_complete_pause (
    BluezMediaPlayer1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * bluez_media_player1_complete_stop:
 * @object: A #BluezMediaPlayer1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-bluez-MediaPlayer1.Stop">Stop()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
bluez_media_player1_complete_stop (
    BluezMediaPlayer1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * bluez_media_player1_complete_next:
 * @object: A #BluezMediaPlayer1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-bluez-MediaPlayer1.Next">Next()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
bluez_media_player1_complete_next (
    BluezMediaPlayer1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * bluez_media_player1_complete_previous:
 * @object: A #BluezMediaPlayer1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-bluez-MediaPlayer1.Previous">Previous()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
bluez_media_player1_complete_previous (
    BluezMediaPlayer1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * bluez_media_player1_complete_fast_forward:
 * @object: A #BluezMediaPlayer1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-bluez-MediaPlayer1.FastForward">FastForward()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
bluez_media_player1_complete_fast_forward (
    BluezMediaPlayer1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * bluez_media_player1_complete_rewind:
 * @object: A #BluezMediaPlayer1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-bluez-MediaPlayer1.Rewind">Rewind()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
bluez_media_player1_complete_rewind (
    BluezMediaPlayer1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * BluezMediaPlayer1Proxy:
 *
 * The #BluezMediaPlayer1Proxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * BluezMediaPlayer1ProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #BluezMediaPlayer1Proxy.
 */

struct _BluezMediaPlayer1ProxyPrivate
{
  GData *qdata;
};

static void bluez_media_player1_proxy_iface_init (BluezMediaPlayer1Iface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (BluezMediaPlayer1Proxy, bluez_media_player1_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (BluezMediaPlayer1Proxy)
                         G_IMPLEMENT_INTERFACE (BLUEZ_TYPE_MEDIA_PLAYER1, bluez_media_player1_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (BluezMediaPlayer1Proxy, bluez_media_player1_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (BLUEZ_TYPE_MEDIA_PLAYER1, bluez_media_player1_proxy_iface_init))

#endif
static void
bluez_media_player1_proxy_finalize (GObject *object)
{
  BluezMediaPlayer1Proxy *proxy = BLUEZ_MEDIA_PLAYER1_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (bluez_media_player1_proxy_parent_class)->finalize (object);
}

static void
bluez_media_player1_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 14);
  info = (const _ExtendedGDBusPropertyInfo *) _bluez_media_player1_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
bluez_media_player1_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.bluez.MediaPlayer1: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
bluez_media_player1_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 14);
  info = (const _ExtendedGDBusPropertyInfo *) _bluez_media_player1_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.bluez.MediaPlayer1", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) bluez_media_player1_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
bluez_media_player1_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_bluez_media_player1_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], BLUEZ_TYPE_MEDIA_PLAYER1);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, BLUEZ_TYPE_MEDIA_PLAYER1);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
bluez_media_player1_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  BluezMediaPlayer1Proxy *proxy = BLUEZ_MEDIA_PLAYER1_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_bluez_media_player1_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_bluez_media_player1_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
bluez_media_player1_proxy_get_name (BluezMediaPlayer1 *object)
{
  BluezMediaPlayer1Proxy *proxy = BLUEZ_MEDIA_PLAYER1_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Name");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
bluez_media_player1_proxy_get_type_ (BluezMediaPlayer1 *object)
{
  BluezMediaPlayer1Proxy *proxy = BLUEZ_MEDIA_PLAYER1_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Type");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
bluez_media_player1_proxy_get_subtype (BluezMediaPlayer1 *object)
{
  BluezMediaPlayer1Proxy *proxy = BLUEZ_MEDIA_PLAYER1_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Subtype");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
bluez_media_player1_proxy_get_position (BluezMediaPlayer1 *object)
{
  BluezMediaPlayer1Proxy *proxy = BLUEZ_MEDIA_PLAYER1_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Position");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
bluez_media_player1_proxy_get_status (BluezMediaPlayer1 *object)
{
  BluezMediaPlayer1Proxy *proxy = BLUEZ_MEDIA_PLAYER1_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Status");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
bluez_media_player1_proxy_get_equalizer (BluezMediaPlayer1 *object)
{
  BluezMediaPlayer1Proxy *proxy = BLUEZ_MEDIA_PLAYER1_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Equalizer");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
bluez_media_player1_proxy_get_repeat (BluezMediaPlayer1 *object)
{
  BluezMediaPlayer1Proxy *proxy = BLUEZ_MEDIA_PLAYER1_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Repeat");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
bluez_media_player1_proxy_get_shuffle (BluezMediaPlayer1 *object)
{
  BluezMediaPlayer1Proxy *proxy = BLUEZ_MEDIA_PLAYER1_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Shuffle");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
bluez_media_player1_proxy_get_scan (BluezMediaPlayer1 *object)
{
  BluezMediaPlayer1Proxy *proxy = BLUEZ_MEDIA_PLAYER1_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Scan");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
bluez_media_player1_proxy_get_track (BluezMediaPlayer1 *object)
{
  BluezMediaPlayer1Proxy *proxy = BLUEZ_MEDIA_PLAYER1_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Track");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static const gchar *
bluez_media_player1_proxy_get_device (BluezMediaPlayer1 *object)
{
  BluezMediaPlayer1Proxy *proxy = BLUEZ_MEDIA_PLAYER1_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Device");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
bluez_media_player1_proxy_get_browsable (BluezMediaPlayer1 *object)
{
  BluezMediaPlayer1Proxy *proxy = BLUEZ_MEDIA_PLAYER1_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Browsable");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
bluez_media_player1_proxy_get_searchable (BluezMediaPlayer1 *object)
{
  BluezMediaPlayer1Proxy *proxy = BLUEZ_MEDIA_PLAYER1_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Searchable");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
bluez_media_player1_proxy_get_playlist (BluezMediaPlayer1 *object)
{
  BluezMediaPlayer1Proxy *proxy = BLUEZ_MEDIA_PLAYER1_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Playlist");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
bluez_media_player1_proxy_init (BluezMediaPlayer1Proxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = bluez_media_player1_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, BLUEZ_TYPE_MEDIA_PLAYER1_PROXY, BluezMediaPlayer1ProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), bluez_media_player1_interface_info ());
}

static void
bluez_media_player1_proxy_class_init (BluezMediaPlayer1ProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = bluez_media_player1_proxy_finalize;
  gobject_class->get_property = bluez_media_player1_proxy_get_property;
  gobject_class->set_property = bluez_media_player1_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = bluez_media_player1_proxy_g_signal;
  proxy_class->g_properties_changed = bluez_media_player1_proxy_g_properties_changed;

  bluez_media_player1_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (BluezMediaPlayer1ProxyPrivate));
#endif
}

static void
bluez_media_player1_proxy_iface_init (BluezMediaPlayer1Iface *iface)
{
  iface->get_name = bluez_media_player1_proxy_get_name;
  iface->get_type_ = bluez_media_player1_proxy_get_type_;
  iface->get_subtype = bluez_media_player1_proxy_get_subtype;
  iface->get_position = bluez_media_player1_proxy_get_position;
  iface->get_status = bluez_media_player1_proxy_get_status;
  iface->get_equalizer = bluez_media_player1_proxy_get_equalizer;
  iface->get_repeat = bluez_media_player1_proxy_get_repeat;
  iface->get_shuffle = bluez_media_player1_proxy_get_shuffle;
  iface->get_scan = bluez_media_player1_proxy_get_scan;
  iface->get_track = bluez_media_player1_proxy_get_track;
  iface->get_device = bluez_media_player1_proxy_get_device;
  iface->get_browsable = bluez_media_player1_proxy_get_browsable;
  iface->get_searchable = bluez_media_player1_proxy_get_searchable;
  iface->get_playlist = bluez_media_player1_proxy_get_playlist;
}

/**
 * bluez_media_player1_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-bluez-MediaPlayer1.top_of_page">org.bluez.MediaPlayer1</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez_media_player1_proxy_new_finish() to get the result of the operation.
 *
 * See bluez_media_player1_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
bluez_media_player1_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (BLUEZ_TYPE_MEDIA_PLAYER1_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.bluez.MediaPlayer1", NULL);
}

/**
 * bluez_media_player1_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez_media_player1_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with bluez_media_player1_proxy_new().
 *
 * Returns: (transfer full) (type BluezMediaPlayer1Proxy): The constructed proxy object or %NULL if @error is set.
 */
BluezMediaPlayer1 *
bluez_media_player1_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return BLUEZ_MEDIA_PLAYER1 (ret);
  else
    return NULL;
}

/**
 * bluez_media_player1_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-bluez-MediaPlayer1.top_of_page">org.bluez.MediaPlayer1</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See bluez_media_player1_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type BluezMediaPlayer1Proxy): The constructed proxy object or %NULL if @error is set.
 */
BluezMediaPlayer1 *
bluez_media_player1_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (BLUEZ_TYPE_MEDIA_PLAYER1_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.bluez.MediaPlayer1", NULL);
  if (ret != NULL)
    return BLUEZ_MEDIA_PLAYER1 (ret);
  else
    return NULL;
}


/**
 * bluez_media_player1_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like bluez_media_player1_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call bluez_media_player1_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See bluez_media_player1_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
bluez_media_player1_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (BLUEZ_TYPE_MEDIA_PLAYER1_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.bluez.MediaPlayer1", NULL);
}

/**
 * bluez_media_player1_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to bluez_media_player1_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with bluez_media_player1_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type BluezMediaPlayer1Proxy): The constructed proxy object or %NULL if @error is set.
 */
BluezMediaPlayer1 *
bluez_media_player1_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return BLUEZ_MEDIA_PLAYER1 (ret);
  else
    return NULL;
}

/**
 * bluez_media_player1_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like bluez_media_player1_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See bluez_media_player1_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type BluezMediaPlayer1Proxy): The constructed proxy object or %NULL if @error is set.
 */
BluezMediaPlayer1 *
bluez_media_player1_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (BLUEZ_TYPE_MEDIA_PLAYER1_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.bluez.MediaPlayer1", NULL);
  if (ret != NULL)
    return BLUEZ_MEDIA_PLAYER1 (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * BluezMediaPlayer1Skeleton:
 *
 * The #BluezMediaPlayer1Skeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * BluezMediaPlayer1SkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #BluezMediaPlayer1Skeleton.
 */

struct _BluezMediaPlayer1SkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_bluez_media_player1_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  BluezMediaPlayer1Skeleton *skeleton = BLUEZ_MEDIA_PLAYER1_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], BLUEZ_TYPE_MEDIA_PLAYER1);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, BLUEZ_TYPE_MEDIA_PLAYER1);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_bluez_media_player1_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  BluezMediaPlayer1Skeleton *skeleton = BLUEZ_MEDIA_PLAYER1_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_bluez_media_player1_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_bluez_media_player1_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  BluezMediaPlayer1Skeleton *skeleton = BLUEZ_MEDIA_PLAYER1_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_bluez_media_player1_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _bluez_media_player1_skeleton_vtable =
{
  _bluez_media_player1_skeleton_handle_method_call,
  _bluez_media_player1_skeleton_handle_get_property,
  _bluez_media_player1_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
bluez_media_player1_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return bluez_media_player1_interface_info ();
}

static GDBusInterfaceVTable *
bluez_media_player1_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_bluez_media_player1_skeleton_vtable;
}

static GVariant *
bluez_media_player1_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  BluezMediaPlayer1Skeleton *skeleton = BLUEZ_MEDIA_PLAYER1_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_bluez_media_player1_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _bluez_media_player1_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _bluez_media_player1_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _bluez_media_player1_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.bluez.MediaPlayer1", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _bluez_media_player1_emit_changed (gpointer user_data);

static void
bluez_media_player1_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  BluezMediaPlayer1Skeleton *skeleton = BLUEZ_MEDIA_PLAYER1_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _bluez_media_player1_emit_changed (skeleton);
}

static void bluez_media_player1_skeleton_iface_init (BluezMediaPlayer1Iface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (BluezMediaPlayer1Skeleton, bluez_media_player1_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (BluezMediaPlayer1Skeleton)
                         G_IMPLEMENT_INTERFACE (BLUEZ_TYPE_MEDIA_PLAYER1, bluez_media_player1_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (BluezMediaPlayer1Skeleton, bluez_media_player1_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (BLUEZ_TYPE_MEDIA_PLAYER1, bluez_media_player1_skeleton_iface_init))

#endif
static void
bluez_media_player1_skeleton_finalize (GObject *object)
{
  BluezMediaPlayer1Skeleton *skeleton = BLUEZ_MEDIA_PLAYER1_SKELETON (object);
  guint n;
  for (n = 0; n < 14; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (bluez_media_player1_skeleton_parent_class)->finalize (object);
}

static void
bluez_media_player1_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  BluezMediaPlayer1Skeleton *skeleton = BLUEZ_MEDIA_PLAYER1_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 14);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_bluez_media_player1_emit_changed (gpointer user_data)
{
  BluezMediaPlayer1Skeleton *skeleton = BLUEZ_MEDIA_PLAYER1_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.bluez.MediaPlayer1",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_bluez_media_player1_schedule_emit_changed (BluezMediaPlayer1Skeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
bluez_media_player1_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  BluezMediaPlayer1Skeleton *skeleton = BLUEZ_MEDIA_PLAYER1_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _bluez_media_player1_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _bluez_media_player1_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
bluez_media_player1_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  BluezMediaPlayer1Skeleton *skeleton = BLUEZ_MEDIA_PLAYER1_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 14);
  info = (const _ExtendedGDBusPropertyInfo *) _bluez_media_player1_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _bluez_media_player1_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
bluez_media_player1_skeleton_init (BluezMediaPlayer1Skeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = bluez_media_player1_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, BLUEZ_TYPE_MEDIA_PLAYER1_SKELETON, BluezMediaPlayer1SkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 14);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[8], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[9], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[10], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[11], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[12], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[13], G_TYPE_STRING);
}

static const gchar *
bluez_media_player1_skeleton_get_name (BluezMediaPlayer1 *object)
{
  BluezMediaPlayer1Skeleton *skeleton = BLUEZ_MEDIA_PLAYER1_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
bluez_media_player1_skeleton_get_type_ (BluezMediaPlayer1 *object)
{
  BluezMediaPlayer1Skeleton *skeleton = BLUEZ_MEDIA_PLAYER1_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
bluez_media_player1_skeleton_get_subtype (BluezMediaPlayer1 *object)
{
  BluezMediaPlayer1Skeleton *skeleton = BLUEZ_MEDIA_PLAYER1_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
bluez_media_player1_skeleton_get_position (BluezMediaPlayer1 *object)
{
  BluezMediaPlayer1Skeleton *skeleton = BLUEZ_MEDIA_PLAYER1_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
bluez_media_player1_skeleton_get_status (BluezMediaPlayer1 *object)
{
  BluezMediaPlayer1Skeleton *skeleton = BLUEZ_MEDIA_PLAYER1_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
bluez_media_player1_skeleton_get_equalizer (BluezMediaPlayer1 *object)
{
  BluezMediaPlayer1Skeleton *skeleton = BLUEZ_MEDIA_PLAYER1_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
bluez_media_player1_skeleton_get_repeat (BluezMediaPlayer1 *object)
{
  BluezMediaPlayer1Skeleton *skeleton = BLUEZ_MEDIA_PLAYER1_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
bluez_media_player1_skeleton_get_shuffle (BluezMediaPlayer1 *object)
{
  BluezMediaPlayer1Skeleton *skeleton = BLUEZ_MEDIA_PLAYER1_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
bluez_media_player1_skeleton_get_scan (BluezMediaPlayer1 *object)
{
  BluezMediaPlayer1Skeleton *skeleton = BLUEZ_MEDIA_PLAYER1_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[8]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
bluez_media_player1_skeleton_get_track (BluezMediaPlayer1 *object)
{
  BluezMediaPlayer1Skeleton *skeleton = BLUEZ_MEDIA_PLAYER1_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[9]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
bluez_media_player1_skeleton_get_device (BluezMediaPlayer1 *object)
{
  BluezMediaPlayer1Skeleton *skeleton = BLUEZ_MEDIA_PLAYER1_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[10]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
bluez_media_player1_skeleton_get_browsable (BluezMediaPlayer1 *object)
{
  BluezMediaPlayer1Skeleton *skeleton = BLUEZ_MEDIA_PLAYER1_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[11]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
bluez_media_player1_skeleton_get_searchable (BluezMediaPlayer1 *object)
{
  BluezMediaPlayer1Skeleton *skeleton = BLUEZ_MEDIA_PLAYER1_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[12]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
bluez_media_player1_skeleton_get_playlist (BluezMediaPlayer1 *object)
{
  BluezMediaPlayer1Skeleton *skeleton = BLUEZ_MEDIA_PLAYER1_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[13]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
bluez_media_player1_skeleton_class_init (BluezMediaPlayer1SkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = bluez_media_player1_skeleton_finalize;
  gobject_class->get_property = bluez_media_player1_skeleton_get_property;
  gobject_class->set_property = bluez_media_player1_skeleton_set_property;
  gobject_class->notify       = bluez_media_player1_skeleton_notify;


  bluez_media_player1_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = bluez_media_player1_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = bluez_media_player1_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = bluez_media_player1_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = bluez_media_player1_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (BluezMediaPlayer1SkeletonPrivate));
#endif
}

static void
bluez_media_player1_skeleton_iface_init (BluezMediaPlayer1Iface *iface)
{
  iface->get_name = bluez_media_player1_skeleton_get_name;
  iface->get_type_ = bluez_media_player1_skeleton_get_type_;
  iface->get_subtype = bluez_media_player1_skeleton_get_subtype;
  iface->get_position = bluez_media_player1_skeleton_get_position;
  iface->get_status = bluez_media_player1_skeleton_get_status;
  iface->get_equalizer = bluez_media_player1_skeleton_get_equalizer;
  iface->get_repeat = bluez_media_player1_skeleton_get_repeat;
  iface->get_shuffle = bluez_media_player1_skeleton_get_shuffle;
  iface->get_scan = bluez_media_player1_skeleton_get_scan;
  iface->get_track = bluez_media_player1_skeleton_get_track;
  iface->get_device = bluez_media_player1_skeleton_get_device;
  iface->get_browsable = bluez_media_player1_skeleton_get_browsable;
  iface->get_searchable = bluez_media_player1_skeleton_get_searchable;
  iface->get_playlist = bluez_media_player1_skeleton_get_playlist;
}

/**
 * bluez_media_player1_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-bluez-MediaPlayer1.top_of_page">org.bluez.MediaPlayer1</link>.
 *
 * Returns: (transfer full) (type BluezMediaPlayer1Skeleton): The skeleton object.
 */
BluezMediaPlayer1 *
bluez_media_player1_skeleton_new (void)
{
  return BLUEZ_MEDIA_PLAYER1 (g_object_new (BLUEZ_TYPE_MEDIA_PLAYER1_SKELETON, NULL));
}

