
#include "nir.h"
#include "nir_builder.h"
#include "nir_search.h"
#include "nir_search_helpers.h"

/* What follows is NIR algebraic transform code for the following 1911
 * transforms:
 *    ('imul', 'a', '#b(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b'))
 *    ('imul', 'a@8', 128) => ('ishl', 'a', 7)
 *    ('imul', 'a@16', 32768) => ('ishl', 'a', 15)
 *    ('imul', 'a@32', 2147483648) => ('ishl', 'a', 31)
 *    ('imul', 'a@64', 9223372036854775808) => ('ishl', 'a', 63)
 *    ('imul', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b'))))
 *    ('ishl', 'a', '#b') => ('imul', 'a', ('ishl', 1, 'b'))
 *    ('imul@64', 'a', '#b(is_bitcount2)') => ('iadd', ('ishl', 'a', ('ufind_msb', 'b')), ('ishl', 'a', ('find_lsb', 'b')))
 *    ('unpack_64_2x32_split_x', ('imul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b')
 *    ('unpack_64_2x32_split_x', ('umul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b')
 *    ('imul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('imul_high', 'a', 'b'))
 *    ('umul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('umul_high', 'a', 'b'))
 *    ('udiv', 'a', 1) => a
 *    ('idiv', 'a', 1) => a
 *    ('umod', 'a', 1) => 0
 *    ('imod', 'a', 1) => 0
 *    ('imod', 'a', -1) => 0
 *    ('irem', 'a', 1) => 0
 *    ('irem', 'a', -1) => 0
 *    ('udiv', 'a', '#b(is_pos_power_of_two)') => ('ushr', 'a', ('find_lsb', 'b'))
 *    ('idiv', 'a', '#b(is_pos_power_of_two)') => ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', 'b')))
 *    ('idiv', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', ('iabs', 'b')))))
 *    ('umod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1))
 *    ('imod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1))
 *    ('imod', 'a', '#b(is_neg_power_of_two)') => ('bcsel', ('ieq', ('ior', 'a', 'b'), 'b'), 0, ('ior', 'a', 'b'))
 *    ('irem', 'a', '#b(is_pos_power_of_two)') => ('isub', 'a', ('iand', ('bcsel', ('ilt', 'a', 0), ('iadd', 'a', ('isub', 'b', 1)), 'a'), ('ineg', 'b')))
 *    ('irem', 'a', '#b(is_neg_power_of_two)') => ('irem', 'a', ('iabs', 'b'))
 *    ('~fneg', ('fneg', 'a')) => a
 *    ('ineg', ('ineg', 'a')) => a
 *    ('fabs', ('fneg', 'a')) => ('fabs', 'a')
 *    ('fabs', ('u2f', 'a')) => ('u2f', 'a')
 *    ('iabs', ('iabs', 'a')) => ('iabs', 'a')
 *    ('iabs', ('ineg', 'a')) => ('iabs', 'a')
 *    ('f2b', ('fneg', 'a')) => ('f2b', 'a')
 *    ('i2b', ('ineg', 'a')) => ('i2b', 'a')
 *    ('~fadd', 'a', 0.0) => a
 *    ('fadd(is_only_used_as_float)', 'a@16', 0.0) => a
 *    ('fadd(is_only_used_as_float)', 'a@32', 0.0) => a
 *    ('iadd', 'a', 0) => a
 *    ('usadd_4x8_vc4', 'a', 0) => a
 *    ('usadd_4x8_vc4', 'a', -1) => -1
 *    ('~fadd', ('fmul', 'a', 'b'), ('fmul', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c'))
 *    ('~fadd', ('fmulz', 'a', 'b'), ('fmulz', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c'))
 *    ('~ffma', 'a', 'b', ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffma', 'a', 'b', ('fmul(is_used_once)', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c'))
 *    ('~fadd', ('fmul(is_used_once)', 'a', 'b'), ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffma', 'a', ('fmul(is_used_once)', 'b', 'c'), ('fmul(is_used_once)', 'b', 'd')) => ('fmul', 'b', ('ffma', 'a', 'c', 'd'))
 *    ('~ffmaz', 'a', 'b', ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffmaz', 'a', 'b', ('fmulz(is_used_once)', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c'))
 *    ('~fadd', ('fmulz(is_used_once)', 'a', 'b'), ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffmaz', 'a', ('fmulz(is_used_once)', 'b', 'c'), ('fmulz(is_used_once)', 'b', 'd')) => ('fmulz', 'b', ('ffmaz', 'a', 'c', 'd'))
 *    ('iadd', ('imul', 'a', 'b'), ('imul', 'a', 'c')) => ('imul', 'a', ('iadd', 'b', 'c'))
 *    ('iand', ('ior', 'a', 'b'), ('ior', 'a', 'c')) => ('ior', 'a', ('iand', 'b', 'c'))
 *    ('ior', ('iand', 'a', 'b'), ('iand', 'a', 'c')) => ('iand', 'a', ('ior', 'b', 'c'))
 *    ('~fadd', ('fneg', 'a'), 'a') => 0.0
 *    ('iadd', ('ineg', 'a'), 'a') => 0
 *    ('iadd', ('ineg', 'a'), ('iadd', 'a', 'b')) => b
 *    ('iadd', 'a', ('iadd', ('ineg', 'a'), 'b')) => b
 *    ('~fadd', ('fneg', 'a'), ('fadd', 'a', 'b')) => b
 *    ('~fadd', 'a', ('fadd', ('fneg', 'a'), 'b')) => b
 *    ('fadd', ('fsat', 'a'), ('fsat', ('fneg', 'a'))) => ('fsat', ('fabs', 'a'))
 *    ('~fmul', 'a', 0.0) => 0.0
 *    ('fmul', 'a@16', 0.0) => 0.0
 *    ('fmul', 'a@32', 0.0) => 0.0
 *    ('fmulz', 'a', 0.0) => 0.0
 *    ('fmulz', 'a', 'b(is_finite_not_zero)') => ('fmul', 'a', 'b')
 *    ('fmulz', 'a(is_finite)', 'b(is_finite)') => ('fmul', 'a', 'b')
 *    ('fmulz', 'a', 'a') => ('fmul', 'a', 'a')
 *    ('ffmaz', 'a', 'b(is_finite_not_zero)', 'c') => ('ffma', 'a', 'b', 'c')
 *    ('ffmaz', 'a(is_finite)', 'b(is_finite)', 'c') => ('ffma', 'a', 'b', 'c')
 *    ('ffmaz', 'a', 'a', 'b') => ('ffma', 'a', 'a', 'b')
 *    ('imul', 'a', 0) => 0
 *    ('umul_unorm_4x8_vc4', 'a', 0) => 0
 *    ('umul_unorm_4x8_vc4', 'a', -1) => a
 *    ('~fmul', 'a', 1.0) => a
 *    ('~fmulz', 'a', 1.0) => a
 *    ('fmul(is_only_used_as_float)', 'a', 1.0) => a
 *    ('imul', 'a', 1) => a
 *    ('fmul', 'a', -1.0) => ('fneg', 'a')
 *    ('imul', 'a', -1) => ('ineg', 'a')
 *    ('fmul', ('fsign', 'a'), ('fmul', 'a', 'a')) => ('fmul', ('fabs', 'a'), 'a')
 *    ('fmul', ('fmul', ('fsign', 'a'), 'a'), 'a') => ('fmul', ('fabs', 'a'), 'a')
 *    ('~ffma', 0.0, 'a', 'b') => b
 *    ('ffma@16(is_only_used_as_float)', 0.0, 'a', 'b') => b
 *    ('ffma@32(is_only_used_as_float)', 0.0, 'a', 'b') => b
 *    ('ffmaz', 0.0, 'a', 'b') => ('fadd', 0.0, 'b')
 *    ('~ffma', 'a', 'b', 0.0) => ('fmul', 'a', 'b')
 *    ('ffma@16', 'a', 'b', 0.0) => ('fmul', 'a', 'b')
 *    ('ffma@32', 'a', 'b', 0.0) => ('fmul', 'a', 'b')
 *    ('ffmaz', 'a', 'b', 0.0) => ('fmulz', 'a', 'b')
 *    ('ffma', 1.0, 'a', 'b') => ('fadd', 'a', 'b')
 *    ('ffmaz', 1.0, 'a', 'b') => ('fadd', 'a', 'b')
 *    ('ffma', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b')
 *    ('ffmaz', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b')
 *    ('~ffma', '#a', '#b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffmaz', '#a', '#b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c')
 *    ('~flrp', 'a', 'b', 0.0) => a
 *    ('~flrp', 'a', 'b', 1.0) => b
 *    ('~flrp', 'a', 'a', 'b') => a
 *    ('~flrp', 0.0, 'a', 'b') => ('fmul', 'a', 'b')
 *    ('~flrp', 'a', ('fadd(is_used_once)', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('sdot_4x8_iadd', 'a', 0, 'b') => b
 *    ('udot_4x8_uadd', 'a', 0, 'b') => b
 *    ('sdot_4x8_iadd_sat', 'a', 0, 'b') => b
 *    ('udot_4x8_uadd_sat', 'a', 0, 'b') => b
 *    ('sdot_2x16_iadd', 'a', 0, 'b') => b
 *    ('udot_2x16_uadd', 'a', 0, 'b') => b
 *    ('sdot_2x16_iadd_sat', 'a', 0, 'b') => b
 *    ('udot_2x16_uadd_sat', 'a', 0, 'b') => b
 *    ('sudot_4x8_iadd', 'a', 0, 'b') => b
 *    ('sudot_4x8_iadd', 0, 'a', 'b') => b
 *    ('sudot_4x8_iadd_sat', 'a', 0, 'b') => b
 *    ('sudot_4x8_iadd_sat', 0, 'a', 'b') => b
 *    ('iadd', ('sdot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('udot_4x8_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_4x8_uadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('sudot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sudot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('sdot_2x16_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_2x16_iadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('udot_2x16_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_2x16_uadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('sdot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_4x8_iadd', 'a', 'b', 'c')
 *    ('iadd', ('udot_4x8_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_4x8_uadd', 'a', 'b', 'c')
 *    ('iadd', ('sudot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c')
 *    ('iadd', ('sudot_4x8_iadd', 'a', 'b(is_not_const)', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c')
 *    ('iadd', ('sdot_2x16_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_2x16_iadd', 'a', 'b', 'c')
 *    ('iadd', ('udot_2x16_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_2x16_uadd', 'a', 'b', 'c')
 *    ('sdot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('udot_4x8_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_4x8_uadd', 'a', 'b', 0), 'c')
 *    ('sudot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sudot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('sdot_2x16_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_2x16_iadd', 'a', 'b', 0), 'c')
 *    ('udot_2x16_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_2x16_uadd', 'a', 'b', 0), 'c')
 *    ('sdot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('udot_4x8_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_4x8_uadd', 'a', 'b', 0), 'c')
 *    ('sudot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sudot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('sdot_2x16_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_2x16_iadd', 'a', 'b', 0), 'c')
 *    ('udot_2x16_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_2x16_uadd', 'a', 'b', 0), 'c')
 *    ('fmul@32', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', 'a', 'b')
 *    ('fmul@32', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', 'a', 'b')
 *    ('ffma@32', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', 'a', 'b', 'c')
 *    ('ffma@32', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', 'a', 'b', 'c')
 *    ('sdot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_i8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_i8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_i8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_i8', 'b', 3)))), 'c')
 *    ('udot_4x8_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_u8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_u8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_u8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_u8', 'a', 3), ('extract_u8', 'b', 3)))), 'c')
 *    ('sudot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_u8', 'b', 3)))), 'c')
 *    ('sdot_2x16_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c')
 *    ('udot_2x16_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c')
 *    ('udot_4x8_uadd_sat', 'a', 'b', '#c(is_ult_0xfffc07fc)') => ('udot_4x8_uadd', 'a', 'b', 'c')
 *    ('udot_4x8_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('iadd', ('iadd', ('imul', ('extract_u8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_u8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_u8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_u8', 'a', 3), ('extract_u8', 'b', 3)))), 'c')
 *    ('sdot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_i8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_i8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_i8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_i8', 'b', 3)))), 'c')
 *    ('sudot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_u8', 'b', 3)))), 'c')
 *    ('udot_2x16_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c')
 *    ('sdot_2x16_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c')
 *    ('~flrp@16', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a')
 *    ('~flrp@16', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@16', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@16', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@16', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@16', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@16', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b'))
 *    ('~fadd@16', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('~flrp@32', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a')
 *    ('~flrp@32', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@32', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@32', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@32', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@32', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@32', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b'))
 *    ('~fadd@32', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('~flrp@64', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a')
 *    ('~flrp@64', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@64', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@64', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@64', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@64', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@64', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b'))
 *    ('~fadd@64', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('~flrp', ('fmul(is_used_once)', 'a', 'b'), ('fmul(is_used_once)', 'a', 'c'), 'd') => ('fmul', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp', 'a', 0.0, 'c') => ('fadd', ('fmul', ('fneg', 'a'), 'c'), 'a')
 *    ('ftrunc', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a')))
 *    ('ffloor', 'a') => ('fsub', 'a', ('ffract', 'a'))
 *    ('fadd', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a')
 *    ('ffract', 'a') => ('fsub', 'a', ('ffloor', 'a'))
 *    ('fceil', 'a') => ('fneg', ('ffloor', ('fneg', 'a')))
 *    ('ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffmaz', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c')
 *    ('~ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffmaz', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c')
 *    ('~fmul', ('fadd', ('iand', ('ineg', ('b2i', 'a@bool')), ('fmul', 'b', 'c')), '#d'), '#e') => ('bcsel', 'a', ('fmul', ('fadd', ('fmul', 'b', 'c'), 'd'), 'e'), ('fmul', 'd', 'e'))
 *    ('fdph', 'a', 'b') => ('fdot4', ('vec4', 'a.x', 'a.y', 'a.z', 1.0), 'b')
 *    ('fdot4', ('vec4', 'a', 'b', 'c', 1.0), 'd') => ('fdph', ('vec3', 'a', 'b', 'c'), 'd')
 *    ('fdot4', ('vec4', 'a', 0.0, 0.0, 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot4', ('vec4', 'a', 'b', 0.0, 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c')
 *    ('fdot4', ('vec4', 'a', 'b', 'c', 0.0), 'd') => ('fdot3', ('vec3', 'a', 'b', 'c'), 'd')
 *    ('fdot3', ('vec3', 'a', 0.0, 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot3', ('vec3', 'a', 'b', 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c')
 *    ('fdot2', ('vec2', 'a', 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot2', 'a', 1.0) => ('fadd', 'a.x', 'a.y')
 *    ('fdot2', 'a', 'b') => ('fsum2', ('fmul', 'a', 'b'))
 *    ('fdot3', 'a', 'b') => ('fsum3', ('fmul', 'a', 'b'))
 *    ('fdot4', 'a', 'b') => ('fsum4', ('fmul', 'a', 'b'))
 *    ('fsum2', 'a') => ('fadd', 'a.x', 'a.y')
 *    ('~fadd', ('fneg(is_used_once)', ('fsat(is_used_once)', 'a(is_not_fmul)')), 1.0) => ('fsat', ('fadd', 1.0, ('fneg', 'a')))
 *    ('ishl', ('iadd', ('imul', 'a', '#b'), '#c'), '#d') => ('iadd', ('imul', 'a', ('ishl', 'b', 'd')), ('ishl', 'c', 'd'))
 *    ('ishl', ('imul', 'a', '#b'), '#c') => ('imul', 'a', ('ishl', 'b', 'c'))
 *    ('ishl@8', ('ishl@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 255), ('iand', 'c', 255)), 8), ('ishl@8', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@8', ('ushr@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 255), ('iand', 'c', 255)), 8), ('ushr@8', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@8', ('ishr@8', 'a', '#b'), '#c') => ('ishr@8', 'a', ('imin', ('iadd', ('iand', 'b', 255), ('iand', 'c', 255)), 7))
 *    ('ishl@16', ('ishl@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 65535), ('iand', 'c', 65535)), 16), ('ishl@16', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@16', ('ushr@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 65535), ('iand', 'c', 65535)), 16), ('ushr@16', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@16', ('ishr@16', 'a', '#b'), '#c') => ('ishr@16', 'a', ('imin', ('iadd', ('iand', 'b', 65535), ('iand', 'c', 65535)), 15))
 *    ('ishl@32', ('ishl@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 4294967295), ('iand', 'c', 4294967295)), 32), ('ishl@32', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@32', ('ushr@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 4294967295), ('iand', 'c', 4294967295)), 32), ('ushr@32', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@32', ('ishr@32', 'a', '#b'), '#c') => ('ishr@32', 'a', ('imin', ('iadd', ('iand', 'b', 4294967295), ('iand', 'c', 4294967295)), 31))
 *    ('ishl@64', ('ishl@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 18446744073709551615), ('iand', 'c', 18446744073709551615)), 64), ('ishl@64', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@64', ('ushr@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 18446744073709551615), ('iand', 'c', 18446744073709551615)), 64), ('ushr@64', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@64', ('ishr@64', 'a', '#b'), '#c') => ('ishr@64', 'a', ('imin', ('iadd', ('iand', 'b', 18446744073709551615), ('iand', 'c', 18446744073709551615)), 63))
 *    ('ishl', ('ushr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b'))
 *    ('ishl', ('ishr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b'))
 *    ('ushr', ('ishl', 'a@8', '#b'), 'b') => ('iand', 'a', ('ushr', 255, 'b'))
 *    ('ishl', ('ushr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b'))
 *    ('ishl', ('ishr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b'))
 *    ('ushr', ('ishl', 'a@16', '#b'), 'b') => ('iand', 'a', ('ushr', 65535, 'b'))
 *    ('ishl', ('ushr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b'))
 *    ('ishl', ('ishr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b'))
 *    ('ushr', ('ishl', 'a@32', '#b'), 'b') => ('iand', 'a', ('ushr', 4294967295, 'b'))
 *    ('ishl', ('ushr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b'))
 *    ('ishl', ('ishr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b'))
 *    ('ushr', ('ishl', 'a@64', '#b'), 'b') => ('iand', 'a', ('ushr', 18446744073709551615, 'b'))
 *    ('iand', ('ishl', 'a@32', '#b(is_first_5_bits_uge_2)'), -4) => ('ishl', 'a', 'b')
 *    ('iand', ('imul', 'a', '#b(is_unsigned_multiple_of_4)'), -4) => ('imul', 'a', 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_2)'), 4294967294) => ('iadd', ('iand', 'a', 4294967294), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_4)'), 4294967292) => ('iadd', ('iand', 'a', 4294967292), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_8)'), 4294967288) => ('iadd', ('iand', 'a', 4294967288), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_16)'), 4294967280) => ('iadd', ('iand', 'a', 4294967280), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_32)'), 4294967264) => ('iadd', ('iand', 'a', 4294967264), 'b')
 *    ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_64)'), 4294967232) => ('iadd', ('iand', 'a', 4294967232), 'b')
 *    ('ishl@32', ('iand', 'a@32', 2147483647), 1) => ('ishl', 'a', 1)
 *    ('iand', ('ishl', 'a@32', 1), 4294967294) => ('ishl', 'a', 1)
 *    ('iand', ('ushr', 'a@32', 1), 2147483647) => ('ushr', 'a', 1)
 *    ('ishl@32', ('iand', 'a@32', 1073741823), 2) => ('ishl', 'a', 2)
 *    ('iand', ('ishl', 'a@32', 2), 4294967292) => ('ishl', 'a', 2)
 *    ('iand', ('ushr', 'a@32', 2), 1073741823) => ('ushr', 'a', 2)
 *    ('ishl@32', ('iand', 'a@32', 65535), 16) => ('ishl', 'a', 16)
 *    ('iand', ('ishl', 'a@32', 16), 4294901760) => ('ishl', 'a', 16)
 *    ('iand', ('ushr', 'a@32', 16), 65535) => ('ushr', 'a', 16)
 *    ('ishl@32', ('iand', 'a@32', 255), 24) => ('ishl', 'a', 24)
 *    ('iand', ('ishl', 'a@32', 24), 4278190080) => ('ishl', 'a', 24)
 *    ('iand', ('ushr', 'a@32', 24), 255) => ('ushr', 'a', 24)
 *    ('ishl', ('iadd', 'a', '#b'), '#c') => ('iadd', ('ishl', 'a', 'c'), ('ishl', 'b', 'c'))
 *    ('imul', ('iadd(is_used_once)', 'a', '#b'), '#c') => ('iadd', ('imul', 'a', 'c'), ('imul', 'b', 'c'))
 *    ('imul', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('imul', ('iadd', 'a', 'c'), 'd'), ('imul', 'b', 'd'))
 *    ('ishl', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('ishl', ('iadd', 'a', 'c'), 'd'), ('ishl', 'b', 'd'))
 *    ('inot', ('flt(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('fge', 'a', 'b')
 *    ('inot', ('fge(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('flt', 'a', 'b')
 *    ('inot', ('feq(is_used_once)', 'a', 'b')) => ('fneu', 'a', 'b')
 *    ('inot', ('fneu(is_used_once)', 'a', 'b')) => ('feq', 'a', 'b')
 *    ('inot', ('ilt(is_used_once)', 'a', 'b')) => ('ige', 'a', 'b')
 *    ('inot', ('ult(is_used_once)', 'a', 'b')) => ('uge', 'a', 'b')
 *    ('inot', ('ige(is_used_once)', 'a', 'b')) => ('ilt', 'a', 'b')
 *    ('inot', ('uge(is_used_once)', 'a', 'b')) => ('ult', 'a', 'b')
 *    ('inot', ('ieq(is_used_once)', 'a', 'b')) => ('ine', 'a', 'b')
 *    ('inot', ('ine(is_used_once)', 'a', 'b')) => ('ieq', 'a', 'b')
 *    ('iand', ('feq', 'a', 'b'), ('fneu', 'a', 'b')) => False
 *    ('iand', ('flt', 'a', 'b'), ('flt', 'b', 'a')) => False
 *    ('iand', ('ieq', 'a', 'b'), ('ine', 'a', 'b')) => False
 *    ('iand', ('ilt', 'a', 'b'), ('ilt', 'b', 'a')) => False
 *    ('iand', ('ult', 'a', 'b'), ('ult', 'b', 'a')) => False
 *    ('flt', ('fneg', 'a'), ('fneg', 'b')) => ('flt', 'b', 'a')
 *    ('fge', ('fneg', 'a'), ('fneg', 'b')) => ('fge', 'b', 'a')
 *    ('feq', ('fneg', 'a'), ('fneg', 'b')) => ('feq', 'b', 'a')
 *    ('fneu', ('fneg', 'a'), ('fneg', 'b')) => ('fneu', 'b', 'a')
 *    ('flt', ('fneg', 'a'), -1.0) => ('flt', 1.0, 'a')
 *    ('flt', -1.0, ('fneg', 'a')) => ('flt', 'a', 1.0)
 *    ('fge', ('fneg', 'a'), -1.0) => ('fge', 1.0, 'a')
 *    ('fge', -1.0, ('fneg', 'a')) => ('fge', 'a', 1.0)
 *    ('fneu', ('fneg', 'a'), -1.0) => ('fneu', 1.0, 'a')
 *    ('feq', -1.0, ('fneg', 'a')) => ('feq', 'a', 1.0)
 *    ('flt', '#b(is_gt_0_and_lt_1)', ('fsat(is_used_once)', 'a')) => ('flt', 'b', 'a')
 *    ('fge', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fge', 'a', 'b')
 *    ('feq', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('feq', 'a', 'b')
 *    ('fneu', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fneu', 'a', 'b')
 *    ('fge', ('fsat(is_used_once)', 'a'), 1.0) => ('fge', 'a', 1.0)
 *    ('flt', 0.0, ('fsat(is_used_once)', 'a')) => ('flt', 0.0, 'a')
 *    ('fge', 0.0, ('b2f', 'a@1')) => ('inot', 'a')
 *    ('fge', ('fneg', ('b2f', 'a@1')), 0.0) => ('inot', 'a')
 *    ('fneu', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b')
 *    ('fneu', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b')
 *    ('fneu', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('ior', 'a', 'b')
 *    ('fneu', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('iand', 'a', 'b')
 *    ('fneu', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('iand', 'a', 'b')
 *    ('fneu', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ixor', 'a', 'b')
 *    ('fneu', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ixor', 'a', 'b')
 *    ('fneu', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ixor', 'a', 'b')
 *    ('feq', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('iand', 'a', 'b'))
 *    ('feq', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('inot', ('iand', 'a', 'b'))
 *    ('feq', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ieq', 'a', 'b')
 *    ('feq', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ieq', 'a', 'b')
 *    ('feq', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ieq', 'a', 'b')
 *    ('flt', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('ior', 'a', 'b')
 *    ('flt', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('ior', 'a', 'b')
 *    ('fge', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('fge', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b'))
 *    ('flt', 'a', ('fneg', 'a')) => ('flt', 'a', 0.0)
 *    ('fge', 'a', ('fneg', 'a')) => ('fge', 'a', 0.0)
 *    ('flt', ('fmin', 'c', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')))), 0.0) => ('ior', ('flt', 'c', 0.0), ('ior', 'a', 'b'))
 *    ('~flt', ('fadd', 'a', 'b'), 'a') => ('flt', 'b', 0.0)
 *    ('~fge', ('fadd', 'a', 'b'), 'a') => ('fge', 'b', 0.0)
 *    ('~feq', ('fadd', 'a', 'b'), 'a') => ('feq', 'b', 0.0)
 *    ('~fneu', ('fadd', 'a', 'b'), 'a') => ('fneu', 'b', 0.0)
 *    ('~flt', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('flt', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~flt', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('flt', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~fge', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fge', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~fge', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fge', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~feq', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('feq', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~feq', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('feq', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~fneu', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fneu', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~fneu', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fneu', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('ieq', ('iadd', 'a', 'b'), 'a') => ('ieq', 'b', 0)
 *    ('ine', ('iadd', 'a', 'b'), 'a') => ('ine', 'b', 0)
 *    ('feq', ('b2f', 'a@1'), 0.0) => ('inot', 'a')
 *    ('fneu', ('b2f', 'a@1'), 0.0) => a
 *    ('ieq', ('b2i', 'a@1'), 0) => ('inot', 'a')
 *    ('ine', ('b2i', 'a@1'), 0) => a
 *    ('fneu', ('u2f', 'a'), 0.0) => ('ine', 'a', 0)
 *    ('feq', ('u2f', 'a'), 0.0) => ('ieq', 'a', 0)
 *    ('fge', ('u2f', 'a'), 0.0) => True
 *    ('fge', 0.0, ('u2f', 'a')) => ('uge', 0, 'a')
 *    ('flt', ('u2f', 'a'), 0.0) => False
 *    ('flt', 0.0, ('u2f', 'a')) => ('ult', 0, 'a')
 *    ('fneu', ('i2f', 'a'), 0.0) => ('ine', 'a', 0)
 *    ('feq', ('i2f', 'a'), 0.0) => ('ieq', 'a', 0)
 *    ('fge', ('i2f', 'a'), 0.0) => ('ige', 'a', 0)
 *    ('fge', 0.0, ('i2f', 'a')) => ('ige', 0, 'a')
 *    ('flt', ('i2f', 'a'), 0.0) => ('ilt', 'a', 0)
 *    ('flt', 0.0, ('i2f', 'a')) => ('ilt', 0, 'a')
 *    ('~flt', 0.0, ('fabs', 'a')) => ('fneu', 'a', 0.0)
 *    ('~flt', ('fneg', ('fabs', 'a')), 0.0) => ('fneu', 'a', 0.0)
 *    ('fge', 0.0, ('fabs', 'a')) => ('feq', 'a', 0.0)
 *    ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0)
 *    ('iand', ('fge', 'a', 0.0), ('fge', 1.0, 'a')) => ('feq', 'a', ('fsat', 'a'))
 *    ('fmax', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('ior', 'a', 'b'))
 *    ('fmax', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('iand', 'a', 'b')))
 *    ('fmin', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b'))
 *    ('fmin', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('ior', 'a', 'b')))
 *    ('fmin', ('b2f', 'a@1'), '#b') => ('bcsel', 'a', ('fmin', 'b', 1.0), ('fmin', 'b', 0.0))
 *    ('flt', ('fadd(is_used_once)', 'a', ('fneg', 'b')), 0.0) => ('flt', 'a', 'b')
 *    ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0)
 *    ('~bcsel', ('flt', 'b', 'a'), 'b', 'a') => ('fmin', 'a', 'b')
 *    ('~bcsel', ('flt', 'a', 'b'), 'b', 'a') => ('fmax', 'a', 'b')
 *    ('~bcsel', ('fge', 'a', 'b'), 'b', 'a') => ('fmin', 'a', 'b')
 *    ('~bcsel', ('fge', 'b', 'a'), 'b', 'a') => ('fmax', 'a', 'b')
 *    ('bcsel', ('i2b', 'a'), 'b', 'c') => ('bcsel', ('ine', 'a', 0), 'b', 'c')
 *    ('bcsel', ('inot', 'a'), 'b', 'c') => ('bcsel', 'a', 'c', 'b')
 *    ('bcsel', 'a', ('bcsel', 'a', 'b', 'c'), 'd') => ('bcsel', 'a', 'b', 'd')
 *    ('bcsel', 'a', 'b', ('bcsel', 'a', 'c', 'd')) => ('bcsel', 'a', 'b', 'd')
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', True, 'b') => ('ior', 'a', 'b')
 *    ('bcsel', 'a', 'a', 'b') => ('ior', 'a', 'b')
 *    ('bcsel', 'a', 'b', False) => ('iand', 'a', 'b')
 *    ('bcsel', 'a', 'b', 'a') => ('iand', 'a', 'b')
 *    ('~fmin', 'a', 'a') => a
 *    ('~fmax', 'a', 'a') => a
 *    ('imin', 'a', 'a') => a
 *    ('imax', 'a', 'a') => a
 *    ('umin', 'a', 'a') => a
 *    ('umin', 'a', 0) => 0
 *    ('umin', 'a', -1) => a
 *    ('umax', 'a', 'a') => a
 *    ('umax', 'a', 0) => a
 *    ('umax', 'a', -1) => -1
 *    ('fmax', ('fmax', 'a', 'b'), 'b') => ('fmax', 'a', 'b')
 *    ('umax', ('umax', 'a', 'b'), 'b') => ('umax', 'a', 'b')
 *    ('imax', ('imax', 'a', 'b'), 'b') => ('imax', 'a', 'b')
 *    ('fmin', ('fmin', 'a', 'b'), 'b') => ('fmin', 'a', 'b')
 *    ('umin', ('umin', 'a', 'b'), 'b') => ('umin', 'a', 'b')
 *    ('imin', ('imin', 'a', 'b'), 'b') => ('imin', 'a', 'b')
 *    ('fmax', ('fmax', ('fmax', 'a', 'b'), 'c'), 'a') => ('fmax', ('fmax', 'a', 'b'), 'c')
 *    ('umax', ('umax', ('umax', 'a', 'b'), 'c'), 'a') => ('umax', ('umax', 'a', 'b'), 'c')
 *    ('imax', ('imax', ('imax', 'a', 'b'), 'c'), 'a') => ('imax', ('imax', 'a', 'b'), 'c')
 *    ('fmin', ('fmin', ('fmin', 'a', 'b'), 'c'), 'a') => ('fmin', ('fmin', 'a', 'b'), 'c')
 *    ('umin', ('umin', ('umin', 'a', 'b'), 'c'), 'a') => ('umin', ('umin', 'a', 'b'), 'c')
 *    ('imin', ('imin', ('imin', 'a', 'b'), 'c'), 'a') => ('imin', ('imin', 'a', 'b'), 'c')
 *    ('ieq', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ine', 'a', 'b')
 *    ('ieq', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ine', 'a', 'b')
 *    ('ieq', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ine', 'a', 'b')
 *    ('ieq', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ine', 'a', 'b')
 *    ('feq', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ieq', 'a', 'b')
 *    ('fneu', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ine', 'a', 'b')
 *    ('feq', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ieq', 'a', 'b')
 *    ('fneu', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ine', 'a', 'b')
 *    ('feq', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ieq', 'a', 'b')
 *    ('fneu', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ine', 'a', 'b')
 *    ('iand@8', 'a', ('inot', ('ishr', 'a', 7))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@8', 128), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@8', 128), 128) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@8', 128), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@8', 128), 128) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@8', 7), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@8', 7), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@8', 7), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@8', 7), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@8', 7), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@8', 7), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@8', 7), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@8', 7), -1) => ('ige', 'a', 0)
 *    ('iand@16', 'a', ('inot', ('ishr', 'a', 15))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@16', 32768), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@16', 32768), 32768) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@16', 32768), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@16', 32768), 32768) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@16', 15), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@16', 15), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@16', 15), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@16', 15), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@16', 15), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@16', 15), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@16', 15), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@16', 15), -1) => ('ige', 'a', 0)
 *    ('iand@32', 'a', ('inot', ('ishr', 'a', 31))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@32', 2147483648), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@32', 2147483648), 2147483648) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@32', 2147483648), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@32', 2147483648), 2147483648) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@32', 31), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@32', 31), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@32', 31), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@32', 31), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@32', 31), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@32', 31), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@32', 31), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@32', 31), -1) => ('ige', 'a', 0)
 *    ('iand@64', 'a', ('inot', ('ishr', 'a', 63))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@64', 9223372036854775808), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@64', 9223372036854775808), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@64', 63), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@64', 63), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@64', 63), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@64', 63), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@64', 63), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@64', 63), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@64', 63), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@64', 63), -1) => ('ige', 'a', 0)
 *    ('fmin', 'a', ('fneg', 'a')) => ('fneg', ('fabs', 'a'))
 *    ('imin', 'a', ('ineg', 'a')) => ('ineg', ('iabs', 'a'))
 *    ('fmin', 'a', ('fneg', ('fabs', 'a'))) => ('fneg', ('fabs', 'a'))
 *    ('imin', 'a', ('ineg', ('iabs', 'a'))) => ('ineg', ('iabs', 'a'))
 *    ('~fmin', 'a', ('fabs', 'a')) => a
 *    ('imin', 'a', ('iabs', 'a')) => a
 *    ('~fmax', 'a', ('fneg', ('fabs', 'a'))) => a
 *    ('imax', 'a', ('ineg', ('iabs', 'a'))) => a
 *    ('fmax', 'a', ('fabs', 'a')) => ('fabs', 'a')
 *    ('imax', 'a', ('iabs', 'a')) => ('iabs', 'a')
 *    ('fmax', 'a', ('fneg', 'a')) => ('fabs', 'a')
 *    ('imax', 'a', ('ineg', 'a')) => ('iabs', 'a')
 *    ('~fmax', ('fabs', 'a'), 0.0) => ('fabs', 'a')
 *    ('fmin', ('fmax', 'a', 0.0), 1.0) => ('fsat', 'a')
 *    ('~fmax', ('fmin', 'a', 1.0), 0.0) => ('fsat', 'a')
 *    ('~fmin', ('fmax', 'a', -1.0), 0.0) => ('fneg', ('fsat', ('fneg', 'a')))
 *    ('~fmax', ('fmin', 'a', 0.0), -1.0) => ('fneg', ('fsat', ('fneg', 'a')))
 *    ('fsat', ('fsign', 'a')) => ('b2f', ('!flt', 0.0, 'a'))
 *    ('fsat', ('b2f', 'a')) => ('b2f', 'a')
 *    ('fsat', 'a') => ('fmin', ('fmax', 'a', 0.0), 1.0)
 *    ('fsat', ('fsat', 'a')) => ('fsat', 'a')
 *    ('fsat', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', 'b'))) => ('fsat', ('fadd', ('fneg', 'a'), ('fneg', 'b')))
 *    ('fsat', ('fneg(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fneg', 'a'), 'b'))
 *    ('fsat', ('fneg(is_used_once)', ('fmulz(is_used_once)', 'a', 'b'))) => ('fsat', ('fmulz', ('fneg', 'a'), 'b'))
 *    ('fsat', ('fabs(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fabs', 'a'), ('fabs', 'b')))
 *    ('fmin', ('fmax', ('fmin', ('fmax', 'a', 'b'), 'c'), 'b'), 'c') => ('fmin', ('fmax', 'a', 'b'), 'c')
 *    ('imin', ('imax', ('imin', ('imax', 'a', 'b'), 'c'), 'b'), 'c') => ('imin', ('imax', 'a', 'b'), 'c')
 *    ('umin', ('umax', ('umin', ('umax', 'a', 'b'), 'c'), 'b'), 'c') => ('umin', ('umax', 'a', 'b'), 'c')
 *    ('fmax', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmax', 'a', 'b'))
 *    ('~fmin', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmin', 'a', 'b'))
 *    ('fmax', ('fneg', ('fmin', 'b', 'a')), 'b') => ('fmax', ('fabs', 'b'), ('fneg', 'a'))
 *    ('fmin', ('fneg', ('fmax', 'b', 'a')), 'b') => ('fmin', ('fneg', ('fabs', 'b')), ('fneg', 'a'))
 *    ('fmax', ('fadd(is_used_once)', ('fneg', 'a(is_not_negative)'), '#b(is_zero_to_one)'), 0.0) => ('fsat', ('fadd', ('fneg', 'a'), 'b'))
 *    ('extract_u8', ('imin', ('imax', 'a', 0), 255), 0) => ('imin', ('imax', 'a', 0), 255)
 *    ('ior', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('!fmax', 'b', 'c'))
 *    ('ior', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c')
 *    ('ior', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('!fmin', 'b', 'c'))
 *    ('ior', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c')
 *    ('ior', ('flt', 'a', '#b'), ('flt', 'a', '#c')) => ('flt', 'a', ('!fmax', 'b', 'c'))
 *    ('ior', ('flt', '#a', 'c'), ('flt', '#b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c')
 *    ('ior', ('fge', 'a', '#b'), ('fge', 'a', '#c')) => ('fge', 'a', ('!fmin', 'b', 'c'))
 *    ('ior', ('fge', '#a', 'c'), ('fge', '#b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c')
 *    ('~iand', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('fmin', 'b', 'c'))
 *    ('~iand', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c')
 *    ('~iand', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('fmax', 'b', 'c'))
 *    ('~iand', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c')
 *    ('iand', ('flt', 'a', '#b(is_a_number)'), ('flt', 'a', '#c(is_a_number)')) => ('flt', 'a', ('fmin', 'b', 'c'))
 *    ('iand', ('flt', '#a(is_a_number)', 'c'), ('flt', '#b(is_a_number)', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c')
 *    ('iand', ('fge', 'a', '#b(is_a_number)'), ('fge', 'a', '#c(is_a_number)')) => ('fge', 'a', ('fmax', 'b', 'c'))
 *    ('iand', ('fge', '#a(is_a_number)', 'c'), ('fge', '#b(is_a_number)', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c')
 *    ('ior', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imax', 'b', 'c'))
 *    ('ior', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imin', 'a', 'b'), 'c')
 *    ('ior', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imin', 'b', 'c'))
 *    ('ior', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imax', 'a', 'b'), 'c')
 *    ('ior', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umax', 'b', 'c'))
 *    ('ior', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umin', 'a', 'b'), 'c')
 *    ('ior', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umin', 'b', 'c'))
 *    ('ior', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umax', 'a', 'b'), 'c')
 *    ('iand', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imin', 'b', 'c'))
 *    ('iand', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imax', 'a', 'b'), 'c')
 *    ('iand', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imax', 'b', 'c'))
 *    ('iand', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imin', 'a', 'b'), 'c')
 *    ('iand', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umin', 'b', 'c'))
 *    ('iand', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umax', 'a', 'b'), 'c')
 *    ('iand', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umax', 'b', 'c'))
 *    ('iand', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umin', 'a', 'b'), 'c')
 *    ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'c'), 'd'), ('flt', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd')
 *    ('ior', ('ior(is_used_once)', ('flt', 'a', 'c'), 'd'), ('flt(is_used_once)', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd')
 *    ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'b'), 'd'), ('flt', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd')
 *    ('ior', ('ior(is_used_once)', ('flt', 'a', 'b'), 'd'), ('flt(is_used_once)', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd')
 *    ('ior', ('flt', 'a(is_a_number)', 'b(is_a_number)'), ('flt', 'b', 'a')) => ('fneu', 'a', 'b')
 *    ('ior', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('ior', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('bcsel@16', ('feq', 'a', 0.0), 1.0, ('i2f16', ('iadd', ('b2i16', ('flt', 0.0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0.0)))))) => ('i2f16', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0)))))
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@16'), ('b2f', 'c@16')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('~i2f16', ('f2i', 'a@16')) => ('ftrunc', 'a')
 *    ('~f2i16', ('i2f', 'a@16')) => a
 *    ('~f2i16', ('u2f', 'a@16')) => a
 *    ('~f2u16', ('i2f', 'a@16')) => a
 *    ('~f2u16', ('u2f', 'a@16')) => a
 *    ('fadd', ('b2f16', ('flt', 0.0, 'a@16')), ('fneg', ('b2f16', ('flt', 'a@16', 0.0)))) => ('fsign', 'a')
 *    ('iadd', ('b2i16', ('flt', 0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0)))) => ('f2i16', ('fsign', 'a'))
 *    ('f2f16', ('f2f32', 'a@16')) => a
 *    ('i2i16', ('i2i32', 'a@16')) => a
 *    ('u2u16', ('u2u32', 'a@16')) => a
 *    ('f2f16', ('b2f32', 'a@1')) => ('b2f16', 'a')
 *    ('i2i16', ('b2i32', 'a@1')) => ('b2i16', 'a')
 *    ('u2u16', ('b2i32', 'a@1')) => ('b2i16', 'a')
 *    ('f2u32', ('f2f32', 'a@16')) => ('f2u32', 'a')
 *    ('f2i32', ('f2f32', 'a@16')) => ('f2i32', 'a')
 *    ('f2f16', ('u2f32', 'a')) => ('u2f16', 'a')
 *    ('f2f16', ('i2f32', 'a')) => ('i2f16', 'a')
 *    ('u2f32', ('u2u32', 'a@16')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i32', 'a@16')) => ('i2f32', 'a')
 *    ('f2f16', ('f2f64', 'a@16')) => a
 *    ('i2i16', ('i2i64', 'a@16')) => a
 *    ('u2u16', ('u2u64', 'a@16')) => a
 *    ('f2f16', ('b2f64', 'a@1')) => ('b2f16', 'a')
 *    ('i2i16', ('b2i64', 'a@1')) => ('b2i16', 'a')
 *    ('u2u16', ('b2i64', 'a@1')) => ('b2i16', 'a')
 *    ('f2u64', ('f2f64', 'a@16')) => ('f2u64', 'a')
 *    ('f2i64', ('f2f64', 'a@16')) => ('f2i64', 'a')
 *    ('f2f16', ('u2f64', 'a')) => ('u2f16', 'a')
 *    ('f2f16', ('i2f64', 'a')) => ('i2f16', 'a')
 *    ('u2f64', ('u2u64', 'a@16')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i64', 'a@16')) => ('i2f64', 'a')
 *    ('ior', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('ior', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('bcsel@32', ('feq', 'a', 0.0), 1.0, ('i2f32', ('iadd', ('b2i32', ('flt', 0.0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0.0)))))) => ('i2f32', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0)))))
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@32'), ('b2f', 'c@32')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('~i2f32', ('f2i', 'a@32')) => ('ftrunc', 'a')
 *    ('~f2i32', ('i2f', 'a@32')) => a
 *    ('~f2i32', ('u2f', 'a@32')) => a
 *    ('~f2u32', ('i2f', 'a@32')) => a
 *    ('~f2u32', ('u2f', 'a@32')) => a
 *    ('fadd', ('b2f32', ('flt', 0.0, 'a@32')), ('fneg', ('b2f32', ('flt', 'a@32', 0.0)))) => ('fsign', 'a')
 *    ('iadd', ('b2i32', ('flt', 0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0)))) => ('f2i32', ('fsign', 'a'))
 *    ('f2f32', ('f2f64', 'a@32')) => a
 *    ('i2i32', ('i2i64', 'a@32')) => a
 *    ('u2u32', ('u2u64', 'a@32')) => a
 *    ('f2f32', ('b2f64', 'a@1')) => ('b2f32', 'a')
 *    ('i2i32', ('b2i64', 'a@1')) => ('b2i32', 'a')
 *    ('u2u32', ('b2i64', 'a@1')) => ('b2i32', 'a')
 *    ('f2u64', ('f2f64', 'a@32')) => ('f2u64', 'a')
 *    ('f2i64', ('f2f64', 'a@32')) => ('f2i64', 'a')
 *    ('f2f32', ('u2f64', 'a')) => ('u2f32', 'a')
 *    ('f2f32', ('i2f64', 'a')) => ('i2f32', 'a')
 *    ('u2f64', ('u2u64', 'a@32')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i64', 'a@32')) => ('i2f64', 'a')
 *    ('ior', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('ior', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('bcsel@64', ('feq', 'a', 0.0), 1.0, ('i2f64', ('iadd', ('b2i64', ('flt', 0.0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0.0)))))) => ('i2f64', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0)))))
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@64'), ('b2f', 'c@64')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('~i2f64', ('f2i', 'a@64')) => ('ftrunc', 'a')
 *    ('~f2i64', ('i2f', 'a@64')) => a
 *    ('~f2i64', ('u2f', 'a@64')) => a
 *    ('~f2u64', ('i2f', 'a@64')) => a
 *    ('~f2u64', ('u2f', 'a@64')) => a
 *    ('fadd', ('b2f64', ('flt', 0.0, 'a@64')), ('fneg', ('b2f64', ('flt', 'a@64', 0.0)))) => ('fsign', 'a')
 *    ('iadd', ('b2i64', ('flt', 0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0)))) => ('f2i64', ('fsign', 'a'))
 *    ('f2fmp', ('u2f32', 'a@32')) => ('u2fmp', 'a')
 *    ('f2fmp', ('i2f32', 'a@32')) => ('i2fmp', 'a')
 *    ('f2u16', ('f2fmp', 'a@32')) => ('f2u16', 'a')
 *    ('f2i16', ('f2fmp', 'a@32')) => ('f2i16', 'a')
 *    ('i2imp', ('f2u32', 'a@32')) => ('f2ump', 'a')
 *    ('i2imp', ('f2i32', 'a@32')) => ('f2imp', 'a')
 *    ('u2f16', ('i2imp', 'a@32')) => ('u2f16', 'a')
 *    ('i2f16', ('i2imp', 'a@32')) => ('i2f16', 'a')
 *    ('iand', ('u2u16', ('u2u8', 'a@16')), '#b') => ('iand', 'a', ('iand', 'b', 255))
 *    ('u2u16', ('u2u8(is_used_once)', ('iand', 'a@16', '#b'))) => ('iand', 'a', ('iand', 'b', 255))
 *    ('u2u8', ('iand', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('iand', 'a', 'b'))
 *    ('u2u8', ('iand', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('iand', 'a', 'b'))
 *    ('iand', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('iand', 'a', 'c'), 'b')
 *    ('u2u8', ('ior', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('ior', 'a', 'b'))
 *    ('u2u8', ('ior', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('ior', 'a', 'b'))
 *    ('ior', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('ior', 'a', 'c'), 'b')
 *    ('u2u8', ('ixor', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('ixor', 'a', 'b'))
 *    ('u2u8', ('ixor', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('ixor', 'a', 'b'))
 *    ('ixor', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('ixor', 'a', 'c'), 'b')
 *    ('iand', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('ineg', ('b2i8', 'a@8')) => a
 *    ('ishl', 'a@8', ('iand', 7, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@8', ('iand', 7, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@8', ('iand', 7, 'b')) => ('ushr', 'a', 'b')
 *    ('iand', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('ineg', ('b2i16', 'a@16')) => a
 *    ('ishl', 'a@16', ('iand', 15, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@16', ('iand', 15, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@16', ('iand', 15, 'b')) => ('ushr', 'a', 'b')
 *    ('iand', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('ineg', ('b2i32', 'a@32')) => a
 *    ('ishl', 'a@32', ('iand', 31, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@32', ('iand', 31, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@32', ('iand', 31, 'b')) => ('ushr', 'a', 'b')
 *    ('iand', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('ineg', ('b2i64', 'a@64')) => a
 *    ('ishl', 'a@64', ('iand', 63, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@64', ('iand', 63, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@64', ('iand', 63, 'b')) => ('ushr', 'a', 'b')
 *    ('ior', ('ieq', 'a', 0), ('ieq', 'a', 1)) => ('uge', 1, 'a')
 *    ('ior', ('uge', 1, 'a'), ('ieq', 'a', 2)) => ('uge', 2, 'a')
 *    ('ior', ('uge', 2, 'a'), ('ieq', 'a', 3)) => ('uge', 3, 'a')
 *    ('ior', 'a', ('ieq', 'a', False)) => True
 *    ('ior', 'a', ('inot', 'a')) => -1
 *    ('ine', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ine', 'a', 'b')
 *    ('b2i', ('ine', 'a@1', 'b@1')) => ('b2i', ('ixor', 'a', 'b'))
 *    ('iand', ('inot', ('iand', ('ior', ('ieq', 'a', 0), 'b'), 'c')), ('ilt', 'a', 0)) => ('iand', ('inot', ('iand', 'b', 'c')), ('ilt', 'a', 0))
 *    ('iand', ('inot', ('iand', ('ieq', ('umin', 'a', 'b'), 0), 'c')), ('ilt', 'a', 0)) => ('iand', ('inot', ('iand', ('ieq', 'b', 0), 'c')), ('ilt', 'a', 0))
 *    ('flt', 'a', ('fmax', 'b', 'a')) => ('flt', 'a', 'b')
 *    ('flt', ('fmin', 'a', 'b'), 'a') => ('flt', 'b', 'a')
 *    ('~fge', 'a', ('fmin', 'b', 'a')) => True
 *    ('~fge', ('fmax', 'a', 'b'), 'a') => True
 *    ('flt', 'a', ('fmin', 'b', 'a')) => False
 *    ('flt', ('fmax', 'a', 'b'), 'a') => False
 *    ('~fge', 'a', ('fmax', 'b', 'a')) => ('fge', 'a', 'b')
 *    ('~fge', ('fmin', 'a', 'b'), 'a') => ('fge', 'b', 'a')
 *    ('ilt', 'a', ('imax', 'b', 'a')) => ('ilt', 'a', 'b')
 *    ('ilt', ('imin', 'a', 'b'), 'a') => ('ilt', 'b', 'a')
 *    ('ige', 'a', ('imin', 'b', 'a')) => True
 *    ('ige', ('imax', 'a', 'b'), 'a') => True
 *    ('ult', 'a', ('umax', 'b', 'a')) => ('ult', 'a', 'b')
 *    ('ult', ('umin', 'a', 'b'), 'a') => ('ult', 'b', 'a')
 *    ('uge', 'a', ('umin', 'b', 'a')) => True
 *    ('uge', ('umax', 'a', 'b'), 'a') => True
 *    ('ilt', 'a', ('imin', 'b', 'a')) => False
 *    ('ilt', ('imax', 'a', 'b'), 'a') => False
 *    ('ige', 'a', ('imax', 'b', 'a')) => ('ige', 'a', 'b')
 *    ('ige', ('imin', 'a', 'b'), 'a') => ('ige', 'b', 'a')
 *    ('ult', 'a', ('umin', 'b', 'a')) => False
 *    ('ult', ('umax', 'a', 'b'), 'a') => False
 *    ('uge', 'a', ('umax', 'b', 'a')) => ('uge', 'a', 'b')
 *    ('uge', ('umin', 'a', 'b'), 'a') => ('uge', 'b', 'a')
 *    ('ult', 'a', ('iand', 'b', 'a')) => False
 *    ('ult', ('ior', 'a', 'b'), 'a') => False
 *    ('uge', 'a', ('iand', 'b', 'a')) => True
 *    ('uge', ('ior', 'a', 'b'), 'a') => True
 *    ('ilt', '#a', ('imax', '#b', 'c')) => ('ior', ('ilt', 'a', 'b'), ('ilt', 'a', 'c'))
 *    ('ilt', ('imin', '#a', 'b'), '#c') => ('ior', ('ilt', 'a', 'c'), ('ilt', 'b', 'c'))
 *    ('ige', '#a', ('imin', '#b', 'c')) => ('ior', ('ige', 'a', 'b'), ('ige', 'a', 'c'))
 *    ('ige', ('imax', '#a', 'b'), '#c') => ('ior', ('ige', 'a', 'c'), ('ige', 'b', 'c'))
 *    ('ult', '#a', ('umax', '#b', 'c')) => ('ior', ('ult', 'a', 'b'), ('ult', 'a', 'c'))
 *    ('ult', ('umin', '#a', 'b'), '#c') => ('ior', ('ult', 'a', 'c'), ('ult', 'b', 'c'))
 *    ('uge', '#a', ('umin', '#b', 'c')) => ('ior', ('uge', 'a', 'b'), ('uge', 'a', 'c'))
 *    ('uge', ('umax', '#a', 'b'), '#c') => ('ior', ('uge', 'a', 'c'), ('uge', 'b', 'c'))
 *    ('ilt', '#a', ('imin', '#b', 'c')) => ('iand', ('ilt', 'a', 'b'), ('ilt', 'a', 'c'))
 *    ('ilt', ('imax', '#a', 'b'), '#c') => ('iand', ('ilt', 'a', 'c'), ('ilt', 'b', 'c'))
 *    ('ige', '#a', ('imax', '#b', 'c')) => ('iand', ('ige', 'a', 'b'), ('ige', 'a', 'c'))
 *    ('ige', ('imin', '#a', 'b'), '#c') => ('iand', ('ige', 'a', 'c'), ('ige', 'b', 'c'))
 *    ('ult', '#a', ('umin', '#b', 'c')) => ('iand', ('ult', 'a', 'b'), ('ult', 'a', 'c'))
 *    ('ult', ('umax', '#a', 'b'), '#c') => ('iand', ('ult', 'a', 'c'), ('ult', 'b', 'c'))
 *    ('uge', '#a', ('umax', '#b', 'c')) => ('iand', ('uge', 'a', 'b'), ('uge', 'a', 'c'))
 *    ('uge', ('umin', '#a', 'b'), '#c') => ('iand', ('uge', 'a', 'c'), ('uge', 'b', 'c'))
 *    ('bcsel', ('ilt', 'a', 0), ('ineg', ('ishr', 'a', 'b')), ('ishr', 'a', 'b')) => ('iabs', ('ishr', 'a', 'b'))
 *    ('iabs', ('ishr', ('iabs', 'a'), 'b')) => ('ishr', ('iabs', 'a'), 'b')
 *    ('fabs', ('slt', 'a', 'b')) => ('slt', 'a', 'b')
 *    ('fabs', ('sge', 'a', 'b')) => ('sge', 'a', 'b')
 *    ('fabs', ('seq', 'a', 'b')) => ('seq', 'a', 'b')
 *    ('fabs', ('sne', 'a', 'b')) => ('sne', 'a', 'b')
 *    ('slt', 'a', 'b') => ('b2f', ('flt', 'a', 'b'))
 *    ('sge', 'a', 'b') => ('b2f', ('fge', 'a', 'b'))
 *    ('seq', 'a', 'b') => ('b2f', ('feq', 'a', 'b'))
 *    ('sne', 'a', 'b') => ('b2f', ('fneu', 'a', 'b'))
 *    ('seq', ('seq', 'a', 'b'), 1.0) => ('seq', 'a', 'b')
 *    ('seq', ('sne', 'a', 'b'), 1.0) => ('sne', 'a', 'b')
 *    ('seq', ('slt', 'a', 'b'), 1.0) => ('slt', 'a', 'b')
 *    ('seq', ('sge', 'a', 'b'), 1.0) => ('sge', 'a', 'b')
 *    ('sne', ('seq', 'a', 'b'), 0.0) => ('seq', 'a', 'b')
 *    ('sne', ('sne', 'a', 'b'), 0.0) => ('sne', 'a', 'b')
 *    ('sne', ('slt', 'a', 'b'), 0.0) => ('slt', 'a', 'b')
 *    ('sne', ('sge', 'a', 'b'), 0.0) => ('sge', 'a', 'b')
 *    ('seq', ('seq', 'a', 'b'), 0.0) => ('sne', 'a', 'b')
 *    ('seq', ('sne', 'a', 'b'), 0.0) => ('seq', 'a', 'b')
 *    ('seq', ('slt', 'a', 'b'), 0.0) => ('sge', 'a', 'b')
 *    ('seq', ('sge', 'a', 'b'), 0.0) => ('slt', 'a', 'b')
 *    ('sne', ('seq', 'a', 'b'), 1.0) => ('sne', 'a', 'b')
 *    ('sne', ('sne', 'a', 'b'), 1.0) => ('seq', 'a', 'b')
 *    ('sne', ('slt', 'a', 'b'), 1.0) => ('sge', 'a', 'b')
 *    ('sne', ('sge', 'a', 'b'), 1.0) => ('slt', 'a', 'b')
 *    ('fall_equal2', 'a', 'b') => ('fmin', ('seq', 'a.x', 'b.x'), ('seq', 'a.y', 'b.y'))
 *    ('fall_equal3', 'a', 'b') => ('seq', ('fany_nequal3', 'a', 'b'), 0.0)
 *    ('fall_equal4', 'a', 'b') => ('seq', ('fany_nequal4', 'a', 'b'), 0.0)
 *    ('fany_nequal2', 'a', 'b') => ('fmax', ('sne', 'a.x', 'b.x'), ('sne', 'a.y', 'b.y'))
 *    ('fany_nequal3', 'a', 'b') => ('fsat', ('fdot3', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('fany_nequal4', 'a', 'b') => ('fsat', ('fdot4', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('ball_iequal2', 'a', 'b') => ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y'))
 *    ('ball_iequal3', 'a', 'b') => ('iand', ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y')), ('ieq', 'a.z', 'b.z'))
 *    ('ball_iequal4', 'a', 'b') => ('iand', ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y')), ('iand', ('ieq', 'a.z', 'b.z'), ('ieq', 'a.w', 'b.w')))
 *    ('bany_inequal2', 'a', 'b') => ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y'))
 *    ('bany_inequal3', 'a', 'b') => ('ior', ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y')), ('ine', 'a.z', 'b.z'))
 *    ('bany_inequal4', 'a', 'b') => ('ior', ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y')), ('ior', ('ine', 'a.z', 'b.z'), ('ine', 'a.w', 'b.w')))
 *    ('ball_fequal2', 'a', 'b') => ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y'))
 *    ('ball_fequal3', 'a', 'b') => ('iand', ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y')), ('feq', 'a.z', 'b.z'))
 *    ('ball_fequal4', 'a', 'b') => ('iand', ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y')), ('iand', ('feq', 'a.z', 'b.z'), ('feq', 'a.w', 'b.w')))
 *    ('bany_fnequal2', 'a', 'b') => ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y'))
 *    ('bany_fnequal3', 'a', 'b') => ('ior', ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y')), ('fneu', 'a.z', 'b.z'))
 *    ('bany_fnequal4', 'a', 'b') => ('ior', ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y')), ('ior', ('fneu', 'a.z', 'b.z'), ('fneu', 'a.w', 'b.w')))
 *    ('fneu', ('fneg', 'a'), 'a') => ('fneu', 'a', 0.0)
 *    ('feq', ('fneg', 'a'), 'a') => ('feq', 'a', 0.0)
 *    ('imul', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b'))
 *    ('iand', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b'))
 *    ('ior', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('ior', 'a', 'b'))
 *    ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b'))
 *    ('fsat', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('b2f', ('ior', 'a', 'b'))
 *    ('iand', 'a@bool16', 1.0) => ('b2f', 'a')
 *    ('iand', 'a@bool32', 1.0) => ('b2f', 'a')
 *    ('flt', ('fneg', ('b2f', 'a@1')), 0) => a
 *    ('ilt', 'a', 'a') => False
 *    ('ige', 'a', 'a') => True
 *    ('ieq', 'a', 'a') => True
 *    ('ine', 'a', 'a') => False
 *    ('ult', 'a', 'a') => False
 *    ('uge', 'a', 'a') => True
 *    ('flt', 'a', 'a') => False
 *    ('fge', 'a(is_a_number)', 'a') => True
 *    ('feq', 'a(is_a_number)', 'a') => True
 *    ('fneu', 'a(is_a_number)', 'a') => False
 *    ('iand', 'a', 'a') => a
 *    ('iand', 'a', -1) => a
 *    ('iand', 'a', 0) => 0
 *    ('ior', 'a', 'a') => a
 *    ('ior', 'a', 0) => a
 *    ('ior', 'a', True) => True
 *    ('ixor', 'a', 'a') => 0
 *    ('ixor', 'a', 0) => a
 *    ('inot', ('inot', 'a')) => a
 *    ('ior', ('iand', 'a', 'b'), 'b') => b
 *    ('ior', ('ior', 'a', 'b'), 'b') => ('ior', 'a', 'b')
 *    ('iand', ('ior', 'a', 'b'), 'b') => b
 *    ('iand', ('iand', 'a', 'b'), 'b') => ('iand', 'a', 'b')
 *    ('iand', ('inot', 'a'), ('inot', 'b')) => ('inot', ('ior', 'a', 'b'))
 *    ('ior', ('inot', 'a'), ('inot', 'b')) => ('inot', ('iand', 'a', 'b'))
 *    ('ishl', 0, 'a') => 0
 *    ('ishl', 'a', 0) => a
 *    ('ishr', 0, 'a') => 0
 *    ('ishr', 'a', 0) => a
 *    ('ushr', 0, 'a') => 0
 *    ('ushr', 'a', 0) => a
 *    ('ior', ('ishl@16', 'a', 'b'), ('ushr@16', 'a', ('iadd', 16, ('ineg', 'b')))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@16', 'a', 'b'), ('ushr@16', 'a', ('isub', 16, 'b'))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@32', 'a', 'b'), ('ushr@32', 'a', ('iadd', 32, ('ineg', 'b')))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@32', 'a', 'b'), ('ushr@32', 'a', ('isub', 32, 'b'))) => ('urol', 'a', 'b')
 *    ('ior', ('ushr@16', 'a', 'b'), ('ishl@16', 'a', ('iadd', 16, ('ineg', 'b')))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@16', 'a', 'b'), ('ishl@16', 'a', ('isub', 16, 'b'))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@32', 'a', 'b'), ('ishl@32', 'a', ('iadd', 32, ('ineg', 'b')))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@32', 'a', 'b'), ('ishl@32', 'a', ('isub', 32, 'b'))) => ('uror', 'a', 'b')
 *    ('urol@16', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 16, 'b')))
 *    ('urol@32', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 32, 'b')))
 *    ('uror@16', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 16, 'b')))
 *    ('uror@32', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 32, 'b')))
 *    ('~fexp2', ('flog2', 'a')) => a
 *    ('~flog2', ('fexp2', 'a')) => a
 *    ('fpow', 'a', 'b') => ('fexp2', ('fmul', ('flog2', 'a'), 'b'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 'b')) => ('fpow', 'a', 'b')
 *    ('~fexp2', ('fadd', ('fmul', ('flog2', 'a'), 'b'), ('fmul', ('flog2', 'c'), 'd'))) => ('~fmul', ('fpow', 'a', 'b'), ('fpow', 'c', 'd'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 0.5)) => ('fsqrt', 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 2.0)) => ('fmul', 'a', 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 4.0)) => ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a'))
 *    ('~fpow', 'a', 1.0) => a
 *    ('~fpow', 'a', 2.0) => ('fmul', 'a', 'a')
 *    ('~fpow', 'a', 4.0) => ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a'))
 *    ('~fpow', 2.0, 'a') => ('fexp2', 'a')
 *    ('~fpow', ('fpow', 'a', 2.2), 0.454545) => a
 *    ('~fpow', ('fabs', ('fpow', 'a', 2.2)), 0.454545) => ('fabs', 'a')
 *    ('~fsqrt', ('fexp2', 'a')) => ('fexp2', ('fmul', 0.5, 'a'))
 *    ('~frcp', ('fexp2', 'a')) => ('fexp2', ('fneg', 'a'))
 *    ('~frsq', ('fexp2', 'a')) => ('fexp2', ('fmul', -0.5, 'a'))
 *    ('~flog2', ('fsqrt', 'a')) => ('fmul', 0.5, ('flog2', 'a'))
 *    ('~flog2', ('frcp', 'a')) => ('fneg', ('flog2', 'a'))
 *    ('~flog2', ('frsq', 'a')) => ('fmul', -0.5, ('flog2', 'a'))
 *    ('~flog2', ('fpow', 'a', 'b')) => ('fmul', 'b', ('flog2', 'a'))
 *    ('~fmul', ('fexp2(is_used_once)', 'a'), ('fexp2(is_used_once)', 'b')) => ('fexp2', ('fadd', 'a', 'b'))
 *    ('bcsel', ('flt', 'a', 0.0), 0.0, ('fsqrt', 'a')) => ('fsqrt', ('fmax', 'a', 0.0))
 *    ('~fmul', ('fsqrt', 'a'), ('fsqrt', 'a')) => ('fabs', 'a')
 *    ('~fmulz', ('fsqrt', 'a'), ('fsqrt', 'a')) => ('fabs', 'a')
 *    ('~fdiv', 1.0, 'a') => ('frcp', 'a')
 *    ('fdiv', 'a', 'b') => ('fmul', 'a', ('frcp', 'b'))
 *    ('~frcp', ('frcp', 'a')) => a
 *    ('~frcp', ('fsqrt', 'a')) => ('frsq', 'a')
 *    ('fsqrt', 'a') => ('frcp', ('frsq', 'a'))
 *    ('~frcp', ('frsq', 'a')) => ('fsqrt', 'a')
 *    ('fsin', 'a') => ('ffma', ('ffma', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0), ('fabs', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0)), ('fneg', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0))), 0.225, ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0))
 *    ('fcos', 'a') => ('ffma', ('ffma', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0), ('fabs', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0)), ('fneg', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0))), 0.225, ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0))
 *    ('i2b16(is_used_by_if)', 'a') => ('ine16', 'a', 0)
 *    ('i2b32(is_used_by_if)', 'a') => ('ine32', 'a', 0)
 *    ('i2b1(is_used_by_if)', 'a') => ('ine', 'a', 0)
 *    ('ieq', 'a', True) => a
 *    ('ine(is_not_used_by_if)', 'a', True) => ('inot', 'a')
 *    ('ine', 'a', False) => a
 *    ('ieq(is_not_used_by_if)', 'a', False) => ('inot', 'a')
 *    ('bcsel', 'a', True, False) => a
 *    ('bcsel', 'a', False, True) => ('inot', 'a')
 *    ('bcsel', True, 'b', 'c') => b
 *    ('bcsel', False, 'b', 'c') => c
 *    ('bcsel@16', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@16', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@16', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@16', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel@32', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@32', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@32', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@32', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel@64', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@64', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@64', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@64', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel', 'a', 'b', 'b') => b
 *    ('~fcsel', 'a', 'b', 'b') => b
 *    ('bcsel', 'a', -1, 0) => ('ineg', ('b2i', 'a@1'))
 *    ('bcsel', 'a', 0, -1) => ('ineg', ('b2i', ('inot', 'a')))
 *    ('bcsel', 'a', 1, 0) => ('b2i', 'a@1')
 *    ('bcsel', 'a', 0, 1) => ('b2i', ('inot', 'a'))
 *    ('iand', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b')))
 *    ('ior', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('ieq', ('ineg', ('b2i', 'a@1')), 0) => ('inot', 'a')
 *    ('ieq', ('ineg', ('b2i', 'a@1')), -1) => a
 *    ('ine', ('ineg', ('b2i', 'a@1')), 0) => a
 *    ('ine', ('ineg', ('b2i', 'a@1')), -1) => ('inot', 'a')
 *    ('ige', ('ineg', ('b2i', 'a@1')), 0) => ('inot', 'a')
 *    ('ilt', ('ineg', ('b2i', 'a@1')), 0) => a
 *    ('ult', 0, ('ineg', ('b2i', 'a@1'))) => a
 *    ('iand', ('ineg', ('b2i', 'a')), 1.0) => ('b2f', 'a')
 *    ('iand', ('ineg', ('b2i', 'a')), 1) => ('b2i', 'a')
 *    ('imax', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b')))
 *    ('imin', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('umax', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('umin', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b')))
 *    ('i2b16', ('b2i', 'a@16')) => a
 *    ('i2b32', ('b2i', 'a@32')) => a
 *    ('f2i', ('ftrunc', 'a')) => ('f2i', 'a')
 *    ('f2u', ('ftrunc', 'a')) => ('f2u', 'a')
 *    ('i2b', ('ineg', 'a')) => ('i2b', 'a')
 *    ('i2b', ('iabs', 'a')) => ('i2b', 'a')
 *    ('inot', ('f2b1', 'a')) => ('feq', 'a', 0.0)
 *    ('f2fmp', ('f2f32', 'a@16')) => a
 *    ('i2imp', ('i2i32', 'a@16')) => a
 *    ('i2imp', ('u2u32', 'a@16')) => a
 *    ('f2imp', ('f2f32', 'a@16')) => ('f2i16', 'a')
 *    ('f2ump', ('f2f32', 'a@16')) => ('f2u16', 'a')
 *    ('i2fmp', ('i2i32', 'a@16')) => ('i2f16', 'a')
 *    ('u2fmp', ('u2u32', 'a@16')) => ('u2f16', 'a')
 *    ('f2fmp', ('b2f32', 'a@1')) => ('b2f16', 'a')
 *    ('i2imp', ('b2i32', 'a@1')) => ('b2i16', 'a')
 *    ('i2imp', ('b2i32', 'a@1')) => ('b2i16', 'a')
 *    ('f2imp', ('b2f32', 'a@1')) => ('b2i16', 'a')
 *    ('f2ump', ('b2f32', 'a@1')) => ('b2i16', 'a')
 *    ('i2fmp', ('b2i32', 'a@1')) => ('b2f16', 'a')
 *    ('u2fmp', ('b2i32', 'a@1')) => ('b2f16', 'a')
 *    ('f2f32', ('f2fmp', 'a@32')) => a
 *    ('i2i32', ('i2imp', 'a@32')) => a
 *    ('u2u32', ('i2imp', 'a@32')) => a
 *    ('i2i32', ('f2imp', 'a@32')) => ('f2i32', 'a')
 *    ('u2u32', ('f2ump', 'a@32')) => ('f2u32', 'a')
 *    ('f2f32', ('i2fmp', 'a@32')) => ('i2f32', 'a')
 *    ('f2f32', ('u2fmp', 'a@32')) => ('u2f32', 'a')
 *    ('~f2f32', ('f2f64', 'a@32')) => a
 *    ('ffloor', 'a(is_integral)') => a
 *    ('fceil', 'a(is_integral)') => a
 *    ('ftrunc', 'a(is_integral)') => a
 *    ('~ffract', 'a(is_integral)') => 0.0
 *    ('fabs', 'a(is_not_negative)') => a
 *    ('iabs', 'a(is_not_negative)') => a
 *    ('fsat', 'a(is_not_positive)') => 0.0
 *    ('~fmin', 'a(is_not_negative)', 1.0) => ('fsat', 'a')
 *    ('flt', ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0), 0.0) => False
 *    ('flt', ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0), 0.0) => False
 *    ('fmax', ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0), 0.0) => ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0)
 *    ('fmax', ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0), 0.0) => ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0)
 *    ('fneu', 'a(is_not_zero)', 0.0) => True
 *    ('feq', 'a(is_not_zero)', 0.0) => False
 *    ('fge', 'a(is_a_number_not_negative)', 'b(is_a_number_not_positive)') => True
 *    ('fge', 'a(is_not_positive)', 'b(is_gt_zero)') => False
 *    ('fge', 'a(is_lt_zero)', 'b(is_not_negative)') => False
 *    ('flt', 'a(is_not_negative)', 'b(is_not_positive)') => False
 *    ('flt', 'a(is_a_number_not_positive)', 'b(is_a_number_gt_zero)') => True
 *    ('flt', 'a(is_a_number_lt_zero)', 'b(is_a_number_not_negative)') => True
 *    ('ine', 'a(is_not_zero)', 0) => True
 *    ('ieq', 'a(is_not_zero)', 0) => False
 *    ('ige', 'a(is_not_negative)', 'b(is_not_positive)') => True
 *    ('ige', 'a(is_not_positive)', 'b(is_gt_zero)') => False
 *    ('ige', 'a(is_lt_zero)', 'b(is_not_negative)') => False
 *    ('ilt', 'a(is_not_negative)', 'b(is_not_positive)') => False
 *    ('ilt', 'a(is_not_positive)', 'b(is_gt_zero)') => True
 *    ('ilt', 'a(is_lt_zero)', 'b(is_not_negative)') => True
 *    ('ult', 0, 'a(is_gt_zero)') => True
 *    ('ult', 'a', 0) => False
 *    ('unpack_64_2x32_split_x', ('pack_64_2x32_split', 'a', 'b')) => a
 *    ('unpack_64_2x32_split_y', ('pack_64_2x32_split', 'a', 'b')) => b
 *    ('unpack_64_2x32', ('pack_64_2x32_split', 'a', 'b')) => ('vec2', 'a', 'b')
 *    ('unpack_64_2x32', ('pack_64_2x32', 'a')) => a
 *    ('unpack_double_2x32_dxil', ('pack_double_2x32_dxil', 'a')) => a
 *    ('pack_64_2x32_split', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')) => a
 *    ('pack_64_2x32', ('vec2', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a'))) => a
 *    ('pack_64_2x32', ('unpack_64_2x32', 'a')) => a
 *    ('pack_double_2x32_dxil', ('unpack_double_2x32_dxil', 'a')) => a
 *    ('iand', ('ieq', ('unpack_32_2x16_split_x', 'a'), '#b'), ('ieq', ('unpack_32_2x16_split_y', 'a'), '#c')) => ('ieq', 'a', ('pack_32_2x16_split', 'b', 'c'))
 *    ('ushr', 'a@16', 8) => ('extract_u8', 'a', 1)
 *    ('ushr', 'a@32', 24) => ('extract_u8', 'a', 3)
 *    ('ushr', 'a@64', 56) => ('extract_u8', 'a', 7)
 *    ('ishr', 'a@16', 8) => ('extract_i8', 'a', 1)
 *    ('ishr', 'a@32', 24) => ('extract_i8', 'a', 3)
 *    ('ishr', 'a@64', 56) => ('extract_i8', 'a', 7)
 *    ('iand', 255, 'a') => ('extract_u8', 'a', 0)
 *    ('u2u8', ('extract_u16', 'a', 1)) => ('u2u8', ('extract_u8', 'a', 2))
 *    ('u2u8', ('ushr', 'a', 8)) => ('u2u8', ('extract_u8', 'a', 1))
 *    ('i2i16', ('u2u8', ('extract_u8', 'a', 'b'))) => ('i2i16', ('extract_i8', 'a', 'b'))
 *    ('u2u16', ('u2u8', ('extract_u8', 'a', 'b'))) => ('u2u16', ('extract_u8', 'a', 'b'))
 *    ('ubfe', 'a', 0, 8) => ('extract_u8', 'a', 0)
 *    ('ubfe', 'a', 8, 8) => ('extract_u8', 'a', 1)
 *    ('ubfe', 'a', 16, 8) => ('extract_u8', 'a', 2)
 *    ('ubfe', 'a', 24, 8) => ('extract_u8', 'a', 3)
 *    ('ibfe', 'a', 0, 8) => ('extract_i8', 'a', 0)
 *    ('ibfe', 'a', 8, 8) => ('extract_i8', 'a', 1)
 *    ('ibfe', 'a', 16, 8) => ('extract_i8', 'a', 2)
 *    ('ibfe', 'a', 24, 8) => ('extract_i8', 'a', 3)
 *    ('extract_u8', ('extract_i8', 'a', 'b'), 0) => ('extract_u8', 'a', 'b')
 *    ('extract_u8', ('extract_u8', 'a', 'b'), 0) => ('extract_u8', 'a', 'b')
 *    ('ushr', ('ishl', 'a@32', 16), 16) => ('extract_u16', 'a', 0)
 *    ('ushr', 'a@32', 16) => ('extract_u16', 'a', 1)
 *    ('ishr', ('ishl', 'a@32', 16), 16) => ('extract_i16', 'a', 0)
 *    ('ishr', 'a@32', 16) => ('extract_i16', 'a', 1)
 *    ('iand', 65535, 'a') => ('extract_u16', 'a', 0)
 *    ('ubfe', 'a', 0, 16) => ('extract_u16', 'a', 0)
 *    ('ubfe', 'a', 16, 16) => ('extract_u16', 'a', 1)
 *    ('ibfe', 'a', 0, 16) => ('extract_i16', 'a', 0)
 *    ('ibfe', 'a', 16, 16) => ('extract_i16', 'a', 1)
 *    ('ior', ('ishl', ('u2u32', 'a@8'), 24), ('ior', ('ishl', ('u2u32', 'b@8'), 16), ('ior', ('ishl', ('u2u32', 'c@8'), 8), ('u2u32', 'd@8')))) => ('pack_32_4x8', ('vec4', 'd', 'c', 'b', 'a'))
 *    ('extract_u16', ('extract_i16', 'a', 'b'), 0) => ('extract_u16', 'a', 'b')
 *    ('extract_u16', ('extract_u16', 'a', 'b'), 0) => ('extract_u16', 'a', 'b')
 *    ('pack_64_2x32_split', 'a', 'b') => ('ior', ('u2u64', 'a'), ('ishl', ('u2u64', 'b'), 32))
 *    ('pack_32_2x16_split', 'a', 'b') => ('ior', ('u2u32', 'a'), ('ishl', ('u2u32', 'b'), 16))
 *    ('unpack_64_2x32_split_x', 'a') => ('u2u32', 'a')
 *    ('unpack_64_2x32_split_y', 'a') => ('u2u32', ('ushr', 'a', 32))
 *    ('unpack_32_2x16_split_x', 'a') => ('u2u16', 'a')
 *    ('unpack_32_2x16_split_y', 'a') => ('u2u16', ('ushr', 'a', 16))
 *    ('unpack_half_2x16_split_x', ('iand', 'a', 65535)) => ('unpack_half_2x16_split_x', 'a')
 *    ('unpack_32_2x16_split_x', ('iand', 'a', 65535)) => ('unpack_32_2x16_split_x', 'a')
 *    ('unpack_64_2x32_split_x', ('iand', 'a', 4294967295)) => ('unpack_64_2x32_split_x', 'a')
 *    ('unpack_half_2x16_split_y', ('iand', 'a', 4294901760)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_32_2x16_split_y', ('iand', 'a', 4294901760)) => ('unpack_32_2x16_split_y', 'a')
 *    ('unpack_64_2x32_split_y', ('iand', 'a', 18446744069414584320)) => ('unpack_64_2x32_split_y', 'a')
 *    ('unpack_half_2x16_split_x', ('extract_u16', 'a', 0)) => ('unpack_half_2x16_split_x', 'a')
 *    ('unpack_half_2x16_split_x', ('extract_u16', 'a', 1)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_half_2x16_split_x', ('ushr', 'a', 16)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_32_2x16_split_x', ('extract_u16', 'a', 0)) => ('unpack_32_2x16_split_x', 'a')
 *    ('unpack_32_2x16_split_x', ('extract_u16', 'a', 1)) => ('unpack_32_2x16_split_y', 'a')
 *    ('ishl', ('pack_half_2x16', ('vec2', 'a', 0)), 16) => ('pack_half_2x16', ('vec2', 0, 'a'))
 *    ('ushr', ('pack_half_2x16', ('vec2', 0, 'a')), 16) => ('pack_half_2x16', ('vec2', 'a', 0))
 *    ('iadd', ('pack_half_2x16', ('vec2', 'a', 0)), ('pack_half_2x16', ('vec2', 0, 'b'))) => ('pack_half_2x16', ('vec2', 'a', 'b'))
 *    ('ior', ('pack_half_2x16', ('vec2', 'a', 0)), ('pack_half_2x16', ('vec2', 0, 'b'))) => ('pack_half_2x16', ('vec2', 'a', 'b'))
 *    ('ishl', ('pack_half_2x16_split', 'a', 0), 16) => ('pack_half_2x16_split', 0, 'a')
 *    ('ushr', ('pack_half_2x16_split', 0, 'a'), 16) => ('pack_half_2x16_split', 'a', 0)
 *    ('extract_u16', ('pack_half_2x16_split', 0, 'a'), 1) => ('pack_half_2x16_split', 'a', 0)
 *    ('iadd', ('pack_half_2x16_split', 'a', 0), ('pack_half_2x16_split', 0, 'b')) => ('pack_half_2x16_split', 'a', 'b')
 *    ('ior', ('pack_half_2x16_split', 'a', 0), ('pack_half_2x16_split', 0, 'b')) => ('pack_half_2x16_split', 'a', 'b')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 0) => ('i2i', 'a')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 1) => ('i2i', 'b')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 2) => ('i2i', 'c')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 3) => ('i2i', 'd')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 0) => ('u2u', 'a')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 1) => ('u2u', 'b')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 2) => ('u2u', 'c')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 3) => ('u2u', 'd')
 *    ('extract_u8', ('ushr', 'a@16', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@32', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@32', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ushr', 'a@32', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ushr', 'a@64', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@64', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ushr', 'a@64', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ushr', 'a@64', 32), 0) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ushr', 'a@64', 40), 0) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ushr', 'a@64', 48), 0) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ushr', 'a@64', 56), 0) => ('extract_u8', 'a', 7)
 *    ('extract_u8', ('ishr', 'a@16', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@32', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@32', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishr', 'a@32', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishr', 'a@64', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@64', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishr', 'a@64', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishr', 'a@64', 32), 0) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ishr', 'a@64', 40), 0) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ishr', 'a@64', 48), 0) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ishr', 'a@64', 56), 0) => ('extract_u8', 'a', 7)
 *    ('extract_u8', ('extract_u16', 'a', 1), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@16', 8), 1) => ('extract_u8', 'a', 0)
 *    ('extract_u8', ('ishl', 'a@32', 8), 3) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@32', 16), 3) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishl', 'a@32', 24), 3) => ('extract_u8', 'a', 0)
 *    ('extract_u8', ('ishl', 'a@64', 8), 7) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ishl', 'a@64', 16), 7) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ishl', 'a@64', 24), 7) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ishl', 'a@64', 32), 7) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishl', 'a@64', 40), 7) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@64', 48), 7) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishl', 'a@64', 56), 7) => ('extract_u8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@16', 8), 1) => ('extract_i8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@32', 8), 3) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('ishl', 'a@32', 16), 3) => ('extract_i8', 'a', 1)
 *    ('extract_i8', ('ishl', 'a@32', 24), 3) => ('extract_i8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@64', 8), 7) => ('extract_i8', 'a', 6)
 *    ('extract_i8', ('ishl', 'a@64', 16), 7) => ('extract_i8', 'a', 5)
 *    ('extract_i8', ('ishl', 'a@64', 24), 7) => ('extract_i8', 'a', 4)
 *    ('extract_i8', ('ishl', 'a@64', 32), 7) => ('extract_i8', 'a', 3)
 *    ('extract_i8', ('ishl', 'a@64', 40), 7) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('ishl', 'a@64', 48), 7) => ('extract_i8', 'a', 1)
 *    ('extract_i8', ('ishl', 'a@64', 56), 7) => ('extract_i8', 'a', 0)
 *    ('ussub_4x8_vc4', 'a', 0) => a
 *    ('ussub_4x8_vc4', 'a', -1) => 0
 *    ('fsub', 'a', 'b') => ('fadd', 'a', ('fneg', 'b'))
 *    ('isub', 'a', 'b') => ('iadd', 'a', ('ineg', 'b'))
 *    ('uabs_usub', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), ('ineg', ('isub', 'a', 'b')), ('isub', 'a', 'b'))
 *    ('uabs_isub', 'a', 'b') => ('bcsel', ('ilt', 'a', 'b'), ('ineg', ('isub', 'a', 'b')), ('isub', 'a', 'b'))
 *    ('fmul(is_used_by_non_fsat)', ('fneg', 'a'), 'b') => ('fneg', ('fmul', 'a', 'b'))
 *    ('fmulz(is_used_by_non_fsat)', ('fneg', 'a'), 'b') => ('fneg', ('fmulz', 'a', 'b'))
 *    ('ffma', ('fneg', 'a'), ('fneg', 'b'), 'c') => ('ffma', 'a', 'b', 'c')
 *    ('ffmaz', ('fneg', 'a'), ('fneg', 'b'), 'c') => ('ffmaz', 'a', 'b', 'c')
 *    ('imul', ('ineg', 'a'), 'b') => ('ineg', ('imul', 'a', 'b'))
 *    ('~fmul(is_used_once)', ('fmul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fmul', ('fmul', 'a', 'c'), 'b')
 *    ('~fmulz(is_used_once)', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fmulz', ('fmulz', 'a', 'c'), 'b')
 *    ('~fmul(is_used_once)', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c(is_finite_not_zero)') => ('fmulz', ('fmul', 'a', 'c'), 'b')
 *    ('imul(is_used_once)', ('imul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('imul', ('imul', 'a', 'c'), 'b')
 *    ('~ffma', ('fmul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c', 'd') => ('ffma', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('~ffmaz', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c', 'd') => ('ffmaz', ('fmulz', 'a', 'c'), 'b', 'd')
 *    ('~ffma', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c(is_finite_not_zero)', 'd') => ('ffmaz', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('~fadd(is_used_once)', ('fadd(is_used_once)', 'a(is_not_const)', 'b(is_fmul)'), '#c') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd(is_used_once)', ('fadd(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd(is_used_once)', ('ffma(is_used_once)', 'a(is_not_const)', 'b', 'c(is_not_const)'), '#d') => ('fadd', ('ffma', 'a', 'b', 'd'), 'c')
 *    ('~fadd(is_used_once)', ('ffmaz(is_used_once)', 'a(is_not_const)', 'b', 'c(is_not_const)'), '#d') => ('fadd', ('ffmaz', 'a', 'b', 'd'), 'c')
 *    ('iadd(is_used_once)', ('iadd(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('iadd', ('iadd', 'a', 'c'), 'b')
 *    ('~fmul', '#a', ('fmul', 'b(is_not_const)', '#c')) => ('fmul', ('fmul', 'a', 'c'), 'b')
 *    ('~fmulz', '#a', ('fmulz', 'b(is_not_const)', '#c')) => ('fmulz', ('fmulz', 'a', 'c'), 'b')
 *    ('~fmul', '#a(is_finite_not_zero)', ('fmulz', 'b(is_not_const)', '#c')) => ('fmulz', ('fmul', 'a', 'c'), 'b')
 *    ('~ffma', '#a', ('fmul', 'b(is_not_const)', '#c'), 'd') => ('ffma', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('~ffmaz', '#a', ('fmulz', 'b(is_not_const)', '#c'), 'd') => ('ffmaz', ('fmulz', 'a', 'c'), 'b', 'd')
 *    ('~ffmaz', '#a(is_finite_not_zero)', ('fmulz', 'b(is_not_const)', '#c'), 'd') => ('ffmaz', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('imul', '#a', ('imul', 'b(is_not_const)', '#c')) => ('imul', ('imul', 'a', 'c'), 'b')
 *    ('~fadd', '#a', ('fadd', 'b(is_not_const)', '#c')) => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd', '#a', ('fneg', ('fadd', 'b(is_not_const)', '#c'))) => ('fadd', ('fadd', 'a', ('fneg', 'c')), ('fneg', 'b'))
 *    ('~fadd', '#a', ('ffma', 'b(is_not_const)', 'c(is_not_const)', '#d')) => ('ffma', 'b', 'c', ('fadd', 'a', 'd'))
 *    ('~fadd', '#a', ('fneg', ('ffma', 'b(is_not_const)', 'c(is_not_const)', '#d'))) => ('ffma', ('fneg', 'b'), 'c', ('fadd', 'a', ('fneg', 'd')))
 *    ('~fadd', '#a', ('ffmaz', 'b(is_not_const)', 'c(is_not_const)', '#d')) => ('ffmaz', 'b', 'c', ('fadd', 'a', 'd'))
 *    ('~fadd', '#a', ('fneg', ('ffmaz', 'b(is_not_const)', 'c(is_not_const)', '#d'))) => ('ffmaz', ('fneg', 'b'), 'c', ('fadd', 'a', ('fneg', 'd')))
 *    ('iadd', '#a', ('iadd', 'b(is_not_const)', '#c')) => ('iadd', ('iadd', 'a', 'c'), 'b')
 *    ('iand', '#a', ('iand', 'b(is_not_const)', '#c')) => ('iand', ('iand', 'a', 'c'), 'b')
 *    ('ior', '#a', ('ior', 'b(is_not_const)', '#c')) => ('ior', ('ior', 'a', 'c'), 'b')
 *    ('ixor', '#a', ('ixor', 'b(is_not_const)', '#c')) => ('ixor', ('ixor', 'a', 'c'), 'b')
 *    ('~fadd', ('fadd(is_used_once)', 'a(is_fmul)', 'b(is_fmul)'), 'c(is_not_fmul)') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('idiv', ('imul(no_signed_wrap)', 'a', 'b'), 'b') => a
 *    ('bcsel', ('ige', ('find_lsb', 'a'), 0), ('find_lsb', 'a'), -1) => ('find_lsb', 'a')
 *    ('bcsel', ('ige', ('ifind_msb', 'a'), 0), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ige', ('ufind_msb', 'a'), 0), ('ufind_msb', 'a'), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('find_lsb', 'a'), -1) => ('find_lsb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ufind_msb', 'a'), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', 'a', -1), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('~fmul', ('bcsel(is_used_once)', 'c', -1.0, 1.0), 'b') => ('bcsel', 'c', ('fneg', 'b'), 'b')
 *    ('~fmul', ('bcsel(is_used_once)', 'c', 1.0, -1.0), 'b') => ('bcsel', 'c', 'b', ('fneg', 'b'))
 *    ('~fmulz', ('bcsel(is_used_once)', 'c', -1.0, 1.0), 'b') => ('bcsel', 'c', ('fneg', 'b'), 'b')
 *    ('~fmulz', ('bcsel(is_used_once)', 'c', 1.0, -1.0), 'b') => ('bcsel', 'c', 'b', ('fneg', 'b'))
 *    ('~bcsel', ('flt', 'a', 0.0), ('fneg', 'a'), 'a') => ('fabs', 'a')
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), 'd') => ('bcsel', ('iand', 'a', 'b'), 'c', 'd')
 *    ('bcsel', 'a', 'b', ('bcsel', 'c', 'b', 'd')) => ('bcsel', ('ior', 'a', 'c'), 'b', 'd')
 *    ('fmod', 'a', 'b') => ('fsub', 'a', ('fmul', 'b', ('ffloor', ('fdiv', 'a', 'b'))))
 *    ('frem', 'a', 'b') => ('fsub', 'a', ('fmul', 'b', ('ftrunc', ('fdiv', 'a', 'b'))))
 *    ('uadd_carry', 'a', 'b') => ('b2i', ('ult', ('iadd', 'a', 'b'), 'a'))
 *    ('usub_borrow@32', 'a', 'b') => ('b2i', ('ult', 'a', 'b'))
 *    ('bitfield_insert', 'base', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('bfi', ('bfm', 'bits', 'offset'), 'insert', 'base'))
 *    ('ihadd', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('uhadd', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('irhadd', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('urhadd', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('ihadd@64', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('uhadd@64', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('irhadd@64', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('urhadd@64', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('uadd_sat@64', 'a', 'b') => ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd', 'a', 'b'))
 *    ('uadd_sat', 'a', 'b') => ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd', 'a', 'b'))
 *    ('usub_sat', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), 0, ('isub', 'a', 'b'))
 *    ('usub_sat@64', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), 0, ('isub', 'a', 'b'))
 *    ('iadd_sat@64', 'a', 'b') => ('bcsel', ('iand', ('iand', ('ilt', 'a', 0), ('ilt', 'b', 0)), ('ige', ('iadd', 'a', 'b'), 0)), 9223372036854775808, ('bcsel', ('ior', ('ior', ('ilt', 'a', 0), ('ilt', 'b', 0)), ('ige', ('iadd', 'a', 'b'), 0)), ('iadd', 'a', 'b'), 9223372036854775807))
 *    ('isub_sat@64', 'a', 'b') => ('bcsel', ('iand', ('iand', ('ilt', 'a', 0), ('ige', 'b', 0)), ('ige', ('isub', 'a', 'b'), 0)), 9223372036854775808, ('bcsel', ('ior', ('ior', ('ilt', 'a', 0), ('ige', 'b', 0)), ('ige', ('isub', 'a', 'b'), 0)), ('isub', 'a', 'b'), 9223372036854775807))
 *    ('ilt', ('imax(is_used_once)', 'a@64', 'b@64'), 0) => ('ilt', ('imax', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ilt', ('imin(is_used_once)', 'a@64', 'b@64'), 0) => ('ilt', ('imin', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ige', ('imax(is_used_once)', 'a@64', 'b@64'), 0) => ('ige', ('imax', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ige', ('imin(is_used_once)', 'a@64', 'b@64'), 0) => ('ige', ('imin', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ilt', 'a@64', 0) => ('ilt', ('unpack_64_2x32_split_y', 'a'), 0)
 *    ('ige', 'a@64', 0) => ('ige', ('unpack_64_2x32_split_y', 'a'), 0)
 *    ('ine', 'a@64', 0) => ('ine', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('ieq', 'a@64', 0) => ('ieq', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('ult', 0, 'a@64') => ('ine', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('bitfield_insert', 'base', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('ior', ('iand', 'base', ('inot', ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))), ('iand', ('ishl', 'insert', 'offset'), ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))))
 *    ('bitfield_insert', 'base', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('bitfield_select', ('bfm', 'bits', 'offset'), ('ishl', 'insert', 'offset'), 'base'))
 *    ('ibitfield_extract', 'value', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'value', ('ibfe', 'value', 'offset', 'bits'))
 *    ('ubitfield_extract', 'value', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'value', ('ubfe', 'value', 'offset', 'bits'))
 *    ('bitfield_select', 'a', 'b', 0) => ('iand', 'a', 'b')
 *    ('bitfield_select', 'a', ('iand', 'a', 'b'), 'c') => ('bitfield_select', 'a', 'b', 'c')
 *    ('ubfe', 'value', 'offset', ('iand', 31, 'bits')) => ('ubfe', 'value', 'offset', 'bits')
 *    ('ubfe', 'value', ('iand', 31, 'offset'), 'bits') => ('ubfe', 'value', 'offset', 'bits')
 *    ('ibfe', 'value', 'offset', ('iand', 31, 'bits')) => ('ibfe', 'value', 'offset', 'bits')
 *    ('ibfe', 'value', ('iand', 31, 'offset'), 'bits') => ('ibfe', 'value', 'offset', 'bits')
 *    ('bfm', 'bits', ('iand', 31, 'offset')) => ('bfm', 'bits', 'offset')
 *    ('bfm', ('iand', 31, 'bits'), 'offset') => ('bfm', 'bits', 'offset')
 *    ('ubfe', 'a', 'b', 0) => 0
 *    ('ibfe', 'a', 'b', 0) => 0
 *    ('ubfe', 'a', 0, '#b') => ('iand', 'a', ('ushr', 4294967295, ('ineg', 'b')))
 *    ('b2i32', ('i2b', ('ubfe', 'a', 'b', 1))) => ('ubfe', 'a', 'b', 1)
 *    ('b2i32', ('i2b', ('ibfe', 'a', 'b', 1))) => ('ubfe', 'a', 'b', 1)
 *    ('ine', ('ibfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ine', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ieq', ('ibfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ieq', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ine', ('ubfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ine', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ieq', ('ubfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ieq', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ibitfield_extract', 'value', 'offset', 'bits') => ('bcsel', ('ieq', 0, 'bits'), 0, ('ishr', ('ishl', 'value', ('isub', ('isub', 32, 'bits'), 'offset')), ('isub', 32, 'bits')))
 *    ('ubitfield_extract', 'value', 'offset', 'bits') => ('iand', ('ushr', 'value', 'offset'), ('bcsel', ('ieq', 'bits', 32), 4294967295, ('isub', ('ishl', 1, 'bits'), 1)))
 *    ('ifind_msb', 'value') => ('ufind_msb', ('bcsel', ('ilt', 'value', 0), ('inot', 'value'), 'value'))
 *    ('ifind_msb', 'value') => ('bcsel', ('ige', ('ifind_msb_rev', 'value'), 0), ('isub', 31, ('ifind_msb_rev', 'value')), ('ifind_msb_rev', 'value'))
 *    ('ufind_msb', 'value') => ('bcsel', ('ige', ('ufind_msb_rev', 'value'), 0), ('isub', 31, ('ufind_msb_rev', 'value')), ('ufind_msb_rev', 'value'))
 *    ('find_lsb', 'value') => ('ufind_msb', ('iand', 'value', ('ineg', 'value')))
 *    ('extract_i8', 'a', 'b@32') => ('ishr', ('ishl', 'a', ('imul', ('isub', 3, 'b'), 8)), 24)
 *    ('extract_u8', 'a', 'b@32') => ('iand', ('ushr', 'a', ('imul', 'b', 8)), 255)
 *    ('extract_i16', 'a', 'b@32') => ('ishr', ('ishl', 'a', ('imul', ('isub', 1, 'b'), 16)), 16)
 *    ('extract_u16', 'a', 'b@32') => ('iand', ('ushr', 'a', ('imul', 'b', 16)), 65535)
 *    ('pack_unorm_2x16', 'v') => ('pack_uvec2_to_uint', ('f2u32', ('fround_even', ('fmul', ('fsat', 'v'), 65535.0))))
 *    ('pack_unorm_4x8', 'v') => ('pack_uvec4_to_uint', ('f2u32', ('fround_even', ('fmul', ('fsat', 'v'), 255.0))))
 *    ('pack_snorm_2x16', 'v') => ('pack_uvec2_to_uint', ('f2i32', ('fround_even', ('fmul', ('fmin', 1.0, ('fmax', -1.0, 'v')), 32767.0))))
 *    ('pack_snorm_4x8', 'v') => ('pack_uvec4_to_uint', ('f2i32', ('fround_even', ('fmul', ('fmin', 1.0, ('fmax', -1.0, 'v')), 127.0))))
 *    ('unpack_unorm_2x16', 'v') => ('fdiv', ('u2f32', ('vec2', ('extract_u16', 'v', 0), ('extract_u16', 'v', 1))), 65535.0)
 *    ('unpack_unorm_4x8', 'v') => ('fdiv', ('u2f32', ('vec4', ('extract_u8', 'v', 0), ('extract_u8', 'v', 1), ('extract_u8', 'v', 2), ('extract_u8', 'v', 3))), 255.0)
 *    ('unpack_snorm_2x16', 'v') => ('fmin', 1.0, ('fmax', -1.0, ('fdiv', ('i2f', ('vec2', ('extract_i16', 'v', 0), ('extract_i16', 'v', 1))), 32767.0)))
 *    ('unpack_snorm_4x8', 'v') => ('fmin', 1.0, ('fmax', -1.0, ('fdiv', ('i2f', ('vec4', ('extract_i8', 'v', 0), ('extract_i8', 'v', 1), ('extract_i8', 'v', 2), ('extract_i8', 'v', 3))), 127.0)))
 *    ('pack_half_2x16_split', 'a@32', 'b@32') => ('ior', ('ishl', ('u2u32', ('f2f16', 'b')), 16), ('u2u32', ('f2f16', 'a')))
 *    ('unpack_half_2x16_split_x', 'a@32') => ('f2f32', ('u2u16', 'a'))
 *    ('unpack_half_2x16_split_y', 'a@32') => ('f2f32', ('u2u16', ('ushr', 'a', 16)))
 *    ('pack_32_2x16_split', 'a@16', 'b@16') => ('ior', ('ishl', ('u2u32', 'b'), 16), ('u2u32', 'a'))
 *    ('unpack_32_2x16_split_x', 'a@32') => ('u2u16', 'a')
 *    ('unpack_32_2x16_split_y', 'a@32') => ('u2u16', ('ushr', 'a', 16))
 *    ('isign', 'a') => ('imin', ('imax', 'a', -1), 1)
 *    ('imin', ('imax', 'a', -1), 1) => ('isign', 'a')
 *    ('imax', ('imin', 'a', 1), -1) => ('isign', 'a')
 *    ('fsign', 'a') => ('fsub', ('b2f', ('!flt', 0.0, 'a')), ('b2f', ('!flt', 'a', 0.0)))
 *    ('amul', 'a', 'b') => ('imul', 'a', 'b')
 *    ('umul24', 'a', 'b') => ('imul', ('iand', 'a', 16777215), ('iand', 'b', 16777215))
 *    ('umad24', 'a', 'b', 'c') => ('iadd', ('imul', ('iand', 'a', 16777215), ('iand', 'b', 16777215)), 'c')
 *    ('imul24_relaxed', 'a', 'b') => ('imul24', 'a', 'b')
 *    ('imul24_relaxed', 'a', 'b') => ('imul', 'a', 'b')
 *    ('umad24_relaxed', 'a', 'b', 'c') => ('umad24', 'a', 'b', 'c')
 *    ('umad24_relaxed', 'a', 'b', 'c') => ('iadd', ('umul24_relaxed', 'a', 'b'), 'c')
 *    ('umul24_relaxed', 'a', 'b') => ('umul24', 'a', 'b')
 *    ('umul24_relaxed', 'a', 'b') => ('imul', 'a', 'b')
 *    ('imad24_ir3', 'a', 'b', 0) => ('imul24', 'a', 'b')
 *    ('imad24_ir3', 'a', 0, 'c') => c
 *    ('imad24_ir3', 'a', 1, 'c') => ('iadd', 'a', 'c')
 *    ('imad24_ir3', '#a', '#b', 'c') => ('iadd', ('imul', 'a', 'b'), 'c')
 *    ('imul24', 'a', '#b@32(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b'))
 *    ('imul24', 'a', '#b@32(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b'))))
 *    ('imul24', 'a', 0) => 0
 *    ('fcsel', ('slt', 0, 'a'), 'b', 'c') => ('fcsel_gt', 'a', 'b', 'c')
 *    ('fcsel', ('slt', 'a', 0), 'b', 'c') => ('fcsel_ge', 'a', 'c', 'b')
 *    ('fcsel', ('sge', 'a', 0), 'b', 'c') => ('fcsel_ge', 'a', 'b', 'c')
 *    ('fcsel', ('sge', 0, 'a'), 'b', 'c') => ('fcsel_gt', 'a', 'c', 'b')
 *    ('bcsel', ('ilt', 0, 'a@32'), 'b@32', 'c@32') => ('i32csel_gt', 'a', 'b', 'c')
 *    ('bcsel', ('ilt', 'a@32', 0), 'b@32', 'c@32') => ('i32csel_ge', 'a', 'c', 'b')
 *    ('bcsel', ('ige', 'a@32', 0), 'b@32', 'c@32') => ('i32csel_ge', 'a', 'b', 'c')
 *    ('bcsel', ('ige', 0, 'a@32'), 'b@32', 'c@32') => ('i32csel_gt', 'a', 'c', 'b')
 *    ('bcsel', ('flt', 0, 'a@32'), 'b@32', 'c@32') => ('fcsel_gt', 'a', 'b', 'c')
 *    ('bcsel', ('flt', 'a@32', 0), 'b@32', 'c@32') => ('fcsel_ge', 'a', 'c', 'b')
 *    ('bcsel', ('fge', 'a@32', 0), 'b@32', 'c@32') => ('fcsel_ge', 'a', 'b', 'c')
 *    ('bcsel', ('fge', 0, 'a@32'), 'b@32', 'c@32') => ('fcsel_gt', 'a', 'c', 'b')
 *    ('iadd_sat@8', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 127, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 128, ('iadd', 'a', 'b')))
 *    ('isub_sat@8', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 127, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 128, ('isub', 'a', 'b')))
 *    ('iadd_sat@16', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 32767, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 32768, ('iadd', 'a', 'b')))
 *    ('isub_sat@16', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 32767, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 32768, ('isub', 'a', 'b')))
 *    ('iadd_sat@32', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 2147483647, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 2147483648, ('iadd', 'a', 'b')))
 *    ('isub_sat@32', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 2147483647, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 2147483648, ('isub', 'a', 'b')))
 *    ('iadd_sat@64', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 9223372036854775807, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 9223372036854775808, ('iadd', 'a', 'b')))
 *    ('isub_sat@64', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 9223372036854775807, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 9223372036854775808, ('isub', 'a', 'b')))
 *    ('inot', ('ior(is_used_once)', ('feq', 'a', 'b'), ('feq', 'c', 'd'))) => ('iand', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('feq', 'a', 'b'), ('feq', 'c', 'd'))) => ('ior', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))
 *    ('inot', ('ior(is_used_once)', ('feq', 'a', 'b'), ('fneu', 'c', 'd'))) => ('iand', ('fneu', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('feq', 'a', 'b'), ('fneu', 'c', 'd'))) => ('ior', ('fneu', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('ior(is_used_once)', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))) => ('iand', ('feq', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))) => ('ior', ('feq', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('f2b1', ('b2f', 'a@1')) => a
 *    ('i2b1', ('b2i', 'a@1')) => a
 *    ('f2b8', ('b2f', 'a@8')) => a
 *    ('i2b8', ('b2i', 'a@8')) => a
 *    ('f2b16', ('b2f', 'a@16')) => a
 *    ('i2b16', ('b2i', 'a@16')) => a
 *    ('f2b32', ('b2f', 'a@32')) => a
 *    ('i2b32', ('b2i', 'a@32')) => a
 *    ('f2f', ('b2f', 'a')) => ('b2f', 'a')
 *    ('f2u', ('b2f', 'a')) => ('b2i', 'a')
 *    ('f2i', ('b2f', 'a')) => ('b2i', 'a')
 *    ('u2f', ('b2i', 'a')) => ('b2f', 'a')
 *    ('u2u', ('b2i', 'a')) => ('b2i', 'a')
 *    ('i2f', ('b2i', 'a')) => ('b2f', 'a')
 *    ('i2i', ('b2i', 'a')) => ('b2i', 'a')
 *    ('i2i1', 'a@1') => a
 *    ('i2i8', 'a@8') => a
 *    ('i2i16', 'a@16') => a
 *    ('i2i32', 'a@32') => a
 *    ('i2i64', 'a@64') => a
 *    ('u2u1', 'a@1') => a
 *    ('u2u8', 'a@8') => a
 *    ('u2u16', 'a@16') => a
 *    ('u2u32', 'a@32') => a
 *    ('u2u64', 'a@64') => a
 *    ('f2f16', 'a@16') => a
 *    ('f2f32', 'a@32') => a
 *    ('f2f64', 'a@64') => a
 *    ('b2b1', 'a@1') => a
 *    ('b2b8', 'a@8') => a
 *    ('b2b16', 'a@16') => a
 *    ('b2b32', 'a@32') => a
 *    ('i2i1', ('i2i8', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u8', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i8', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u8', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i16', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u16', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i16', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u16', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i32', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u32', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i32', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u32', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i64', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u64', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i64', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u64', 'a')) => ('u2u1', 'a')
 *    ('i2i8', ('i2i1', 'a@1')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u1', 'a@1')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i16', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u16', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i16', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u16', 'a')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i32', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u32', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i32', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u32', 'a')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i64', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u64', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i64', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u64', 'a')) => ('u2u8', 'a')
 *    ('i2i16', ('i2i1', 'a@1')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u1', 'a@1')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i8', 'a@1')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u8', 'a@1')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i8', 'a@8')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u8', 'a@8')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i32', 'a')) => ('i2i16', 'a')
 *    ('i2i16', ('u2u32', 'a')) => ('u2u16', 'a')
 *    ('u2u16', ('i2i32', 'a')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u32', 'a')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i64', 'a')) => ('i2i16', 'a')
 *    ('i2i16', ('u2u64', 'a')) => ('u2u16', 'a')
 *    ('u2u16', ('i2i64', 'a')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u64', 'a')) => ('u2u16', 'a')
 *    ('i2i32', ('i2i1', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u1', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i8', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u8', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i8', 'a@8')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u8', 'a@8')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@8')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@8')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@16')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@16')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i64', 'a')) => ('i2i32', 'a')
 *    ('i2i32', ('u2u64', 'a')) => ('u2u32', 'a')
 *    ('u2u32', ('i2i64', 'a')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u64', 'a')) => ('u2u32', 'a')
 *    ('i2i64', ('i2i1', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u1', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i8', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u8', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i8', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u8', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@16')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@16')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@16')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@16')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@32')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@32')) => ('u2u64', 'a')
 *    ('i2i8', ('pack_64_2x32_split', 'a', 'b')) => ('i2i8', 'a')
 *    ('i2i8', ('pack_64_2x32_split', 'a', 'b')) => ('i2i8', 'a')
 *    ('i2i16', ('pack_64_2x32_split', 'a', 'b')) => ('i2i16', 'a')
 *    ('i2i16', ('pack_64_2x32_split', 'a', 'b')) => ('i2i16', 'a')
 *    ('i2i32', ('pack_64_2x32_split', 'a', 'b')) => ('i2i32', 'a')
 *    ('i2i32', ('pack_64_2x32_split', 'a', 'b')) => ('i2i32', 'a')
 *    ('u2u8', ('pack_64_2x32_split', 'a', 'b')) => ('u2u8', 'a')
 *    ('u2u8', ('pack_64_2x32_split', 'a', 'b')) => ('u2u8', 'a')
 *    ('u2u16', ('pack_64_2x32_split', 'a', 'b')) => ('u2u16', 'a')
 *    ('u2u16', ('pack_64_2x32_split', 'a', 'b')) => ('u2u16', 'a')
 *    ('u2u32', ('pack_64_2x32_split', 'a', 'b')) => ('u2u32', 'a')
 *    ('u2u32', ('pack_64_2x32_split', 'a', 'b')) => ('u2u32', 'a')
 *    ('ieq', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i16', 'b@8'), ('i2i16', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i16', 'b@8'), ('i2i16', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i16', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i16', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i16', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i16', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i16', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i16', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i16', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i16', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i32', 'b@8'), ('i2i32', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@8'), ('i2i32', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i32', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i32', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i32', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i32', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i32', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i32', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i32', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i64', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i64', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'b@8'), ('i2i32', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@8'), ('i2i32', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'b@16'), ('i2i32', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@16'), ('i2i32', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('i2i16', 'b')), ('ieq', ('i2i32', ('i2i16', 'b')), 'b'))
 *    ('ine', ('i2i32', 'a@16'), '#b') => ('ior', ('ine', 'a', ('i2i16', 'b')), ('ine', ('i2i32', ('i2i16', 'b')), 'b'))
 *    ('ilt', ('i2i32', 'a@16'), '#b') => ('iand', ('ilt', -32768, 'b'), ('ior', ('ilt', 32767, 'b'), ('ilt', 'a', ('i2i16', 'b'))))
 *    ('ilt', '#a', ('i2i32', 'b@16')) => ('iand', ('ilt', 'a', 32767), ('ior', ('ilt', 'a', -32768), ('ilt', ('i2i16', 'a'), 'b')))
 *    ('ige', ('i2i32', 'a@16'), '#b') => ('iand', ('ige', 32767, 'b'), ('ior', ('ige', -32768, 'b'), ('ige', 'a', ('i2i16', 'b'))))
 *    ('ige', '#a', ('i2i32', 'b@16')) => ('iand', ('ige', 'a', -32768), ('ior', ('ige', 'a', 32767), ('ige', ('i2i16', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'b@16'), ('i2i64', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@16'), ('i2i64', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('i2i16', 'b')), ('ieq', ('i2i64', ('i2i16', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@16'), '#b') => ('ior', ('ine', 'a', ('i2i16', 'b')), ('ine', ('i2i64', ('i2i16', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@16'), '#b') => ('iand', ('ilt', -32768, 'b'), ('ior', ('ilt', 32767, 'b'), ('ilt', 'a', ('i2i16', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@16')) => ('iand', ('ilt', 'a', 32767), ('ior', ('ilt', 'a', -32768), ('ilt', ('i2i16', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@16'), '#b') => ('iand', ('ige', 32767, 'b'), ('ior', ('ige', -32768, 'b'), ('ige', 'a', ('i2i16', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@16')) => ('iand', ('ige', 'a', -32768), ('ior', ('ige', 'a', 32767), ('ige', ('i2i16', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@16'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@16'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@32'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@32'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), '#b') => ('iand', ('ieq', 'a', ('i2i32', 'b')), ('ieq', ('i2i64', ('i2i32', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@32'), '#b') => ('ior', ('ine', 'a', ('i2i32', 'b')), ('ine', ('i2i64', ('i2i32', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@32'), '#b') => ('iand', ('ilt', -2147483648, 'b'), ('ior', ('ilt', 2147483647, 'b'), ('ilt', 'a', ('i2i32', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@32')) => ('iand', ('ilt', 'a', 2147483647), ('ior', ('ilt', 'a', -2147483648), ('ilt', ('i2i32', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@32'), '#b') => ('iand', ('ige', 2147483647, 'b'), ('ior', ('ige', -2147483648, 'b'), ('ige', 'a', ('i2i32', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@32')) => ('iand', ('ige', 'a', -2147483648), ('ior', ('ige', 'a', 2147483647), ('ige', ('i2i32', 'a'), 'b')))
 *    ('ieq', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u16', 'b@8'), ('u2u16', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u16', 'b@8'), ('u2u16', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u16', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u16', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u16', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u16', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u16', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u16', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u16', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u16', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u32', 'b@8'), ('u2u32', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@8'), ('u2u32', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u32', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u32', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u32', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u32', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u32', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u32', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u32', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u64', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u64', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'b@8'), ('u2u32', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@8'), ('u2u32', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'b@16'), ('u2u32', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@16'), ('u2u32', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('u2u16', 'b')), ('ieq', ('u2u32', ('u2u16', 'b')), 'b'))
 *    ('ine', ('u2u32', 'a@16'), '#b') => ('ior', ('ine', 'a', ('u2u16', 'b')), ('ine', ('u2u32', ('u2u16', 'b')), 'b'))
 *    ('ult', ('u2u32', 'a@16'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 65535, 'b'), ('ult', 'a', ('u2u16', 'b'))))
 *    ('ult', '#a', ('u2u32', 'b@16')) => ('iand', ('ult', 'a', 65535), ('ior', ('ult', 'a', 0), ('ult', ('u2u16', 'a'), 'b')))
 *    ('uge', ('u2u32', 'a@16'), '#b') => ('iand', ('uge', 65535, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u16', 'b'))))
 *    ('uge', '#a', ('u2u32', 'b@16')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 65535), ('uge', ('u2u16', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'b@16'), ('u2u64', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@16'), ('u2u64', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('u2u16', 'b')), ('ieq', ('u2u64', ('u2u16', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@16'), '#b') => ('ior', ('ine', 'a', ('u2u16', 'b')), ('ine', ('u2u64', ('u2u16', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@16'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 65535, 'b'), ('ult', 'a', ('u2u16', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@16')) => ('iand', ('ult', 'a', 65535), ('ior', ('ult', 'a', 0), ('ult', ('u2u16', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@16'), '#b') => ('iand', ('uge', 65535, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u16', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@16')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 65535), ('uge', ('u2u16', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@16'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@16'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@32'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@32'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), '#b') => ('iand', ('ieq', 'a', ('u2u32', 'b')), ('ieq', ('u2u64', ('u2u32', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@32'), '#b') => ('ior', ('ine', 'a', ('u2u32', 'b')), ('ine', ('u2u64', ('u2u32', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@32'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 4294967295, 'b'), ('ult', 'a', ('u2u32', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@32')) => ('iand', ('ult', 'a', 4294967295), ('ior', ('ult', 'a', 0), ('ult', ('u2u32', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@32'), '#b') => ('iand', ('uge', 4294967295, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u32', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@32')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 4294967295), ('uge', ('u2u32', 'a'), 'b')))
 *    ('feq', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('feq', 'a', ('f2f16', 'b'))
 *    ('fneu', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('fneu', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('fge', 'a', ('f2f16', 'b'))
 *    ('flt', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('flt', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f32', 'b@16'), ('f2f32', 'a@16')) => ('fge', ('f2f16', 'b'), 'a')
 *    ('flt', ('f2f32', 'b@16'), ('f2f32', 'a@16')) => ('flt', ('f2f16', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('feq', 'a', ('f2f16', 'b'))
 *    ('fneu', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('fneu', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('fge', 'a', ('f2f16', 'b'))
 *    ('flt', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('flt', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f64', 'b@16'), ('f2f64', 'a@16')) => ('fge', ('f2f16', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@16'), ('f2f64', 'a@16')) => ('flt', ('f2f16', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('feq', 'a', ('f2f32', 'b'))
 *    ('fneu', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('fneu', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('fge', 'a', ('f2f32', 'b'))
 *    ('flt', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('flt', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'b@16'), ('f2f64', 'a@32')) => ('fge', ('f2f32', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@16'), ('f2f64', 'a@32')) => ('flt', ('f2f32', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('feq', 'a', ('f2f32', 'b'))
 *    ('fneu', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('fneu', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('fge', 'a', ('f2f32', 'b'))
 *    ('flt', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('flt', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'b@32'), ('f2f64', 'a@32')) => ('fge', ('f2f32', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@32'), ('f2f64', 'a@32')) => ('flt', ('f2f32', 'b'), 'a')
 *    ('i2i32', ('iand', 'a@64', 4294967295)) => ('u2u32', 'a')
 *    ('i2i16', ('iand', 'a@32', 65535)) => ('u2u16', 'a')
 *    ('i2i16', ('iand', 'a@64', 65535)) => ('u2u16', 'a')
 *    ('i2i8', ('iand', 'a@16', 255)) => ('u2u8', 'a')
 *    ('i2i8', ('iand', 'a@32', 255)) => ('u2u8', 'a')
 *    ('i2i8', ('iand', 'a@64', 255)) => ('u2u8', 'a')
 *    ('u2u16(only_lower_8_bits_used)', ('u2u8', 'a@16')) => a
 *    ('extract_u8(only_lower_8_bits_used)', 'a@16', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u16', ('u2u8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u16', ('i2i8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_u8', 'a@16', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('ixor', 'a', 'b')
 *    ('i2i16(only_lower_8_bits_used)', ('u2u8', 'a@16')) => a
 *    ('extract_i8(only_lower_8_bits_used)', 'a@16', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i16', ('u2u8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i16', ('i2i8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_i8', 'a@16', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('ixor', 'a', 'b')
 *    ('u2u32(only_lower_8_bits_used)', ('u2u8', 'a@32')) => a
 *    ('extract_u8(only_lower_8_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u32', ('u2u8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u32', ('i2i8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_u8', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('i2i32(only_lower_8_bits_used)', ('u2u8', 'a@32')) => a
 *    ('extract_i8(only_lower_8_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i32', ('u2u8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i32', ('i2i8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_i8', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('u2u32(only_lower_16_bits_used)', ('u2u16', 'a@32')) => a
 *    ('extract_u16(only_lower_16_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('u2u32', ('u2u16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('u2u32', ('i2i16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('extract_u16', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('i2i32(only_lower_16_bits_used)', ('u2u16', 'a@32')) => a
 *    ('extract_i16(only_lower_16_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('i2i32', ('u2u16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('i2i32', ('i2i16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('extract_i16', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('ldexp@16', 'x', 'exp') => ('fmul', ('fmul', 'x', ('i2i16', ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -30), 30), 1), 15), 10))), ('i2i16', ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -30), 30), ('ishr', ('imin', ('imax', 'exp', -30), 30), 1)), 15), 10)))
 *    ('ldexp@32', 'x', 'exp') => ('fmul', ('fmul', 'x', ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -254), 254), 1), 127), 23)), ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -254), 254), ('ishr', ('imin', ('imax', 'exp', -254), 254), 1)), 127), 23))
 *    ('ldexp@64', 'x', 'exp') => ('fmul', ('fmul', 'x', ('pack_64_2x32_split', 0, ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -2046), 2046), 1), 1023), 20))), ('pack_64_2x32_split', 0, ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -2046), 2046), ('ishr', ('imin', ('imax', 'exp', -2046), 2046), 1)), 1023), 20)))
 *    ('ior(many-comm-expr)', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 858993459), 2), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 3435973836), 2)), 1431655765), 1), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 858993459), 2), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 3435973836), 2)), 2863311530), 1)) => ('bitfield_reverse', 'x')
 *    ('ior(many-comm-expr)', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 4042322160), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 252645135)), 8), 4278255360), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 4042322160), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 252645135)), 8), 16711935)) => ('bitfield_reverse', 'x')
 *    ('ball_iequal2', ('ieq', 'a', 'b'), -1) => ('ball_iequal2', 'a', 'b')
 *    ('ball_iequal2', ('feq', 'a', 'b'), -1) => ('ball_fequal2', 'a', 'b')
 *    ('bany_inequal2', ('ine', 'a', 'b'), 0) => ('bany_inequal2', 'a', 'b')
 *    ('bany_inequal2', ('fneu', 'a', 'b'), 0) => ('bany_fnequal2', 'a', 'b')
 *    ('ball_iequal3', ('ieq', 'a', 'b'), -1) => ('ball_iequal3', 'a', 'b')
 *    ('ball_iequal3', ('feq', 'a', 'b'), -1) => ('ball_fequal3', 'a', 'b')
 *    ('bany_inequal3', ('ine', 'a', 'b'), 0) => ('bany_inequal3', 'a', 'b')
 *    ('bany_inequal3', ('fneu', 'a', 'b'), 0) => ('bany_fnequal3', 'a', 'b')
 *    ('ball_iequal4', ('ieq', 'a', 'b'), -1) => ('ball_iequal4', 'a', 'b')
 *    ('ball_iequal4', ('feq', 'a', 'b'), -1) => ('ball_fequal4', 'a', 'b')
 *    ('bany_inequal4', ('ine', 'a', 'b'), 0) => ('bany_inequal4', 'a', 'b')
 *    ('bany_inequal4', ('fneu', 'a', 'b'), 0) => ('bany_fnequal4', 'a', 'b')
 *    ('ball_iequal8', ('ieq', 'a', 'b'), -1) => ('ball_iequal8', 'a', 'b')
 *    ('ball_iequal8', ('feq', 'a', 'b'), -1) => ('ball_fequal8', 'a', 'b')
 *    ('bany_inequal8', ('ine', 'a', 'b'), 0) => ('bany_inequal8', 'a', 'b')
 *    ('bany_inequal8', ('fneu', 'a', 'b'), 0) => ('bany_fnequal8', 'a', 'b')
 *    ('ball_iequal16', ('ieq', 'a', 'b'), -1) => ('ball_iequal16', 'a', 'b')
 *    ('ball_iequal16', ('feq', 'a', 'b'), -1) => ('ball_fequal16', 'a', 'b')
 *    ('bany_inequal16', ('ine', 'a', 'b'), 0) => ('bany_inequal16', 'a', 'b')
 *    ('bany_inequal16', ('fneu', 'a', 'b'), 0) => ('bany_fnequal16', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('flt', 'a', 'b')) => ('!flt', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('flt', 'b', 'a')) => ('!flt', 'b', 'a')
 *    ('iand', ('feq', 'a', 'a'), ('fge', 'a', 'b')) => ('!fge', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('fge', 'b', 'a')) => ('!fge', 'b', 'a')
 *    ('iand', ('feq', 'a', 'a'), ('feq', 'a', 'b')) => ('!feq', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('feq', 'b', 'a')) => ('!feq', 'b', 'a')
 *    ('feq', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('feq', 'b', 'd'), ('feq', 'c', 'd'))
 *    ('fneu', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('fneu', 'b', 'd'), ('fneu', 'c', 'd'))
 *    ('ieq', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ieq', 'b', 'd'), ('ieq', 'c', 'd'))
 *    ('ine', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ine', 'b', 'd'), ('ine', 'c', 'd'))
 *    ('flt', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('flt', 'b', 'd'), ('flt', 'c', 'd'))
 *    ('flt', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('flt', 'd', 'b'), ('flt', 'd', 'c'))
 *    ('fge', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('fge', 'b', 'd'), ('fge', 'c', 'd'))
 *    ('fge', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('fge', 'd', 'b'), ('fge', 'd', 'c'))
 *    ('ilt', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ilt', 'b', 'd'), ('ilt', 'c', 'd'))
 *    ('ilt', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ilt', 'd', 'b'), ('ilt', 'd', 'c'))
 *    ('ige', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ige', 'b', 'd'), ('ige', 'c', 'd'))
 *    ('ige', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ige', 'd', 'b'), ('ige', 'd', 'c'))
 *    ('ult', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ult', 'b', 'd'), ('ult', 'c', 'd'))
 *    ('ult', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ult', 'd', 'b'), ('ult', 'd', 'c'))
 *    ('uge', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('uge', 'b', 'd'), ('uge', 'c', 'd'))
 *    ('uge', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('uge', 'd', 'b'), ('uge', 'd', 'c'))
 *    ('fadd', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fadd', 'b', 'd'), ('fadd', 'c', 'd'))
 *    ('fmul', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fmul', 'b', 'd'), ('fmul', 'c', 'd'))
 *    ('fmulz', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fmulz', 'b', 'd'), ('fmulz', 'c', 'd'))
 *    ('iadd', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('iadd', 'b', 'd'), ('iadd', 'c', 'd'))
 *    ('imul', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('imul', 'b', 'd'), ('imul', 'c', 'd'))
 *    ('fddx', 'a') => 0.0
 *    ('fddx_fine', 'a') => 0.0
 *    ('fddx_coarse', 'a') => 0.0
 *    ('fddy', 'a') => 0.0
 *    ('fddy_fine', 'a') => 0.0
 *    ('fddy_coarse', 'a') => 0.0
 *    ('umul_low', '#a(is_lower_half_zero)', 'b') => 0
 *    ('imadsh_mix16', '#a@32(is_lower_half_zero)', 'b@32', 'c@32') => c
 *    ('imadsh_mix16', 'a@32', '#b@32(is_upper_half_zero)', 'c@32') => c
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'b', 'c', 'e')) => ('flrp', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'b', 'c', 'e')) => ('flrp', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'b', 'e', 'd')) => ('flrp', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'b', 'e', 'd')) => ('flrp', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'e', 'c', 'd')) => ('flrp', ('bcsel', 'a', 'b', 'e'), 'c', 'd')
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'e', 'c', 'd')) => ('flrp', ('bcsel', 'a', 'b', 'e'), 'c', 'd')
 *    ('bcsel', 'a', ('fmulz(is_used_once)', 'b', 'c'), ('fmulz', 'b', 'd(is_not_const)')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmulz(is_used_once)', 'b', 'c(is_not_const)'), ('fmulz', 'b', 'd')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmulz', 'b', 'c(is_not_const)'), ('fmulz(is_used_once)', 'b', 'd')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmulz', 'b', 'c'), ('fmulz(is_used_once)', 'b', 'd(is_not_const)')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul(is_used_once)', 'b', 'c'), ('fmul', 'b', 'd(is_not_const)')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul(is_used_once)', 'b', 'c(is_not_const)'), ('fmul', 'b', 'd')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul', 'b', 'c(is_not_const)'), ('fmul(is_used_once)', 'b', 'd')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul', 'b', 'c'), ('fmul(is_used_once)', 'b', 'd(is_not_const)')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd(is_used_once)', 'b', 'c'), ('iadd', 'b', 'd(is_not_const)')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd(is_used_once)', 'b', 'c(is_not_const)'), ('iadd', 'b', 'd')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd', 'b', 'c(is_not_const)'), ('iadd(is_used_once)', 'b', 'd')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd', 'b', 'c'), ('iadd(is_used_once)', 'b', 'd(is_not_const)')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul(is_used_once)', 'b', 'c'), ('imul', 'b', 'd(is_not_const)')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul(is_used_once)', 'b', 'c(is_not_const)'), ('imul', 'b', 'd')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul', 'b', 'c(is_not_const)'), ('imul(is_used_once)', 'b', 'd')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul', 'b', 'c'), ('imul(is_used_once)', 'b', 'd(is_not_const)')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand(is_used_once)', 'b', 'c'), ('iand', 'b', 'd(is_not_const)')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand(is_used_once)', 'b', 'c(is_not_const)'), ('iand', 'b', 'd')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand', 'b', 'c(is_not_const)'), ('iand(is_used_once)', 'b', 'd')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand', 'b', 'c'), ('iand(is_used_once)', 'b', 'd(is_not_const)')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior(is_used_once)', 'b', 'c'), ('ior', 'b', 'd(is_not_const)')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior(is_used_once)', 'b', 'c(is_not_const)'), ('ior', 'b', 'd')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior', 'b', 'c(is_not_const)'), ('ior(is_used_once)', 'b', 'd')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior', 'b', 'c'), ('ior(is_used_once)', 'b', 'd(is_not_const)')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor(is_used_once)', 'b', 'c'), ('ixor', 'b', 'd(is_not_const)')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor(is_used_once)', 'b', 'c(is_not_const)'), ('ixor', 'b', 'd')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor', 'b', 'c(is_not_const)'), ('ixor(is_used_once)', 'b', 'd')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor', 'b', 'c'), ('ixor(is_used_once)', 'b', 'd(is_not_const)')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin(is_used_once)', 'b', 'c'), ('fmin', 'b', 'd(is_not_const)')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin(is_used_once)', 'b', 'c(is_not_const)'), ('fmin', 'b', 'd')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin', 'b', 'c(is_not_const)'), ('fmin(is_used_once)', 'b', 'd')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin', 'b', 'c'), ('fmin(is_used_once)', 'b', 'd(is_not_const)')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax(is_used_once)', 'b', 'c'), ('fmax', 'b', 'd(is_not_const)')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax(is_used_once)', 'b', 'c(is_not_const)'), ('fmax', 'b', 'd')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax', 'b', 'c(is_not_const)'), ('fmax(is_used_once)', 'b', 'd')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax', 'b', 'c'), ('fmax(is_used_once)', 'b', 'd(is_not_const)')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin(is_used_once)', 'b', 'c'), ('imin', 'b', 'd(is_not_const)')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin(is_used_once)', 'b', 'c(is_not_const)'), ('imin', 'b', 'd')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin', 'b', 'c(is_not_const)'), ('imin(is_used_once)', 'b', 'd')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin', 'b', 'c'), ('imin(is_used_once)', 'b', 'd(is_not_const)')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax(is_used_once)', 'b', 'c'), ('imax', 'b', 'd(is_not_const)')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax(is_used_once)', 'b', 'c(is_not_const)'), ('imax', 'b', 'd')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax', 'b', 'c(is_not_const)'), ('imax(is_used_once)', 'b', 'd')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax', 'b', 'c'), ('imax(is_used_once)', 'b', 'd(is_not_const)')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin(is_used_once)', 'b', 'c'), ('umin', 'b', 'd(is_not_const)')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin(is_used_once)', 'b', 'c(is_not_const)'), ('umin', 'b', 'd')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin', 'b', 'c(is_not_const)'), ('umin(is_used_once)', 'b', 'd')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin', 'b', 'c'), ('umin(is_used_once)', 'b', 'd(is_not_const)')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax(is_used_once)', 'b', 'c'), ('umax', 'b', 'd(is_not_const)')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax(is_used_once)', 'b', 'c(is_not_const)'), ('umax', 'b', 'd')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax', 'b', 'c(is_not_const)'), ('umax(is_used_once)', 'b', 'd')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax', 'b', 'c'), ('umax(is_used_once)', 'b', 'd(is_not_const)')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow(is_used_once)', 'b', 'c'), ('fpow', 'b', 'd')) => ('fpow', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow', 'b', 'c'), ('fpow(is_used_once)', 'b', 'd')) => ('fpow', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow(is_used_once)', 'b', 'c'), ('fpow', 'd', 'c')) => ('fpow', ('bcsel', 'a', 'b', 'd'), 'c')
 *    ('bcsel', 'a', ('fpow', 'b', 'c'), ('fpow(is_used_once)', 'd', 'c')) => ('fpow', ('bcsel', 'a', 'b', 'd'), 'c')
 *    ('bcsel', 'c', ('frcp(is_used_once)', 'a'), ('frcp(is_used_once)', 'b')) => ('frcp', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('frsq(is_used_once)', 'a'), ('frsq(is_used_once)', 'b')) => ('frsq', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsqrt(is_used_once)', 'a'), ('fsqrt(is_used_once)', 'b')) => ('fsqrt', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fexp2(is_used_once)', 'a'), ('fexp2(is_used_once)', 'b')) => ('fexp2', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('flog2(is_used_once)', 'a'), ('flog2(is_used_once)', 'b')) => ('flog2', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsign(is_used_once)', 'a'), ('fsign(is_used_once)', 'b')) => ('fsign', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsin(is_used_once)', 'a'), ('fsin(is_used_once)', 'b')) => ('fsin', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fcos(is_used_once)', 'a'), ('fcos(is_used_once)', 'b')) => ('fcos', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fneg(is_used_once)', 'a'), ('fneg(is_used_once)', 'b')) => ('fneg', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fabs(is_used_once)', 'a'), ('fabs(is_used_once)', 'b')) => ('fabs', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsign(is_used_once)', 'a'), ('fsign(is_used_once)', 'b')) => ('fsign', ('bcsel', 'c', 'a', 'b'))
 *    ('ineg', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('ineg', 'a'), ('ineg', 'b'))
 *    ('iabs', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('iabs', 'a'), ('iabs', 'b'))
 *    ('inot', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('inot', 'a'), ('inot', 'b'))
 *    ('isign', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('isign', 'a'), ('isign', 'b'))
 *    ('fisnormal', 'a@32') => ('ult', 33554431, ('iadd', ('ishl', 'a', 1), 16777216))
 *    ('f2f16', ('vec2', 'a@32', 'b@32')) => ('vec2', ('f2f16', 'a'), ('f2f16', 'b'))
 *    ('f2fmp', ('vec2', 'a@32', 'b@32')) => ('vec2', ('f2fmp', 'a'), ('f2fmp', 'b'))
 *    ('u2u16', ('vec2', 'a@32', 'b@32')) => ('vec2', ('u2u16', 'a'), ('u2u16', 'b'))
 *    ('i2i16', ('vec2', 'a@32', 'b@32')) => ('vec2', ('i2i16', 'a'), ('i2i16', 'b'))
 *    ('i2imp', ('vec2', 'a@32', 'b@32')) => ('vec2', ('i2imp', 'a'), ('i2imp', 'b'))
 *    ('f2f16', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('f2f16', 'a'), ('f2f16', 'b'), ('f2f16', 'c'))
 *    ('f2fmp', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('f2fmp', 'a'), ('f2fmp', 'b'), ('f2fmp', 'c'))
 *    ('u2u16', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('u2u16', 'a'), ('u2u16', 'b'), ('u2u16', 'c'))
 *    ('i2i16', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('i2i16', 'a'), ('i2i16', 'b'), ('i2i16', 'c'))
 *    ('i2imp', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('i2imp', 'a'), ('i2imp', 'b'), ('i2imp', 'c'))
 *    ('f2f16', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('f2f16', 'a'), ('f2f16', 'b'), ('f2f16', 'c'), ('f2f16', 'd'))
 *    ('f2fmp', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('f2fmp', 'a'), ('f2fmp', 'b'), ('f2fmp', 'c'), ('f2fmp', 'd'))
 *    ('u2u16', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('u2u16', 'a'), ('u2u16', 'b'), ('u2u16', 'c'), ('u2u16', 'd'))
 *    ('i2i16', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('i2i16', 'a'), ('i2i16', 'b'), ('i2i16', 'c'), ('i2i16', 'd'))
 *    ('i2imp', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('i2imp', 'a'), ('i2imp', 'b'), ('i2imp', 'c'), ('i2imp', 'd'))
 */


static const nir_search_value_union nir_opt_algebraic_values[] = {
   /* ('imul', 'a', '#b(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b')) */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      0,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* replace0_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_find_lsb,
      -1, 0,
      { 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 0, 4 },
      -1,
   } },

   /* ('imul', 'a@8', 128) => ('ishl', 'a', 7) */
   { .variable = {
      { nir_search_value_variable, 8 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0x80 /* 128 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 6, 7 },
      -1,
   } },

   /* replace1_0 -> 6 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x7 /* 7 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 6, 9 },
      -1,
   } },

   /* ('imul', 'a@16', 32768) => ('ishl', 'a', 15) */
   { .variable = {
      { nir_search_value_variable, 16 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0x8000 /* 32768 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 11, 12 },
      -1,
   } },

   /* replace2_0 -> 11 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xf /* 15 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 11, 14 },
      -1,
   } },

   /* ('imul', 'a@32', 2147483648) => ('ishl', 'a', 31) */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x80000000 /* 2147483648 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 16, 17 },
      -1,
   } },

   /* replace3_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x1f /* 31 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 19 },
      -1,
   } },

   /* ('imul', 'a@64', 9223372036854775808) => ('ishl', 'a', 63) */
   { .variable = {
      { nir_search_value_variable, 64 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0x8000000000000000 /* 9223372036854775808 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 21, 22 },
      -1,
   } },

   /* replace4_0 -> 21 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3f /* 63 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 21, 24 },
      -1,
   } },

   /* ('imul', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b')))) */
   /* search5_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 26 },
      -1,
   } },

   /* replace5_0_0 -> 0 in the cache */
   /* replace5_0_1_0_0 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_find_lsb,
      -1, 0,
      { 28 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 0, 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 30 },
      -1,
   } },

   /* ('ishl', 'a', '#b') => ('imul', 'a', ('ishl', 1, 'b')) */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 32, 33 },
      -1,
   } },

   /* replace6_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x1 /* 1 */ },
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 35, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 32, 37 },
      -1,
   } },

   /* ('imul@64', 'a', '#b(is_bitcount2)') => ('iadd', ('ishl', 'a', ('ufind_msb', 'b')), ('ishl', 'a', ('find_lsb', 'b'))) */
   /* search7_0 -> 21 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* b */
      true,
      nir_type_invalid,
      2,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 21, 39 },
      -1,
   } },

   /* replace7_0_0 -> 21 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ufind_msb,
      -1, 0,
      { 41 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 21, 42 },
      -1,
   } },
   /* replace7_1_0 -> 21 in the cache */
   /* replace7_1_1_0 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_find_lsb,
      -1, 0,
      { 41 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 21, 44 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 43, 45 },
      -1,
   } },

   /* ('unpack_64_2x32_split_x', ('imul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b') */
   /* search8_0_0 -> 16 in the cache */
   /* search8_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_imul_2x32_64,
      0, 1,
      { 16, 36 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_unpack_64_2x32_split_x,
      -1, 1,
      { 47 },
      -1,
   } },

   /* replace8_0 -> 16 in the cache */
   /* replace8_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* ('unpack_64_2x32_split_x', ('umul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b') */
   /* search9_0_0 -> 16 in the cache */
   /* search9_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_umul_2x32_64,
      0, 1,
      { 16, 36 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_unpack_64_2x32_split_x,
      -1, 1,
      { 50 },
      -1,
   } },

   /* replace9_0 -> 16 in the cache */
   /* replace9_1 -> 36 in the cache */
   /* replace9 -> 49 in the cache */

   /* ('imul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('imul_high', 'a', 'b')) */
   /* search10_0 -> 16 in the cache */
   /* search10_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_imul_2x32_64,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace10_0_0 -> 16 in the cache */
   /* replace10_0_1 -> 36 in the cache */
   /* replace10_0 -> 49 in the cache */
   /* replace10_1_0 -> 16 in the cache */
   /* replace10_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul_high,
      1, 1,
      { 16, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_pack_64_2x32_split,
      -1, 2,
      { 49, 53 },
      -1,
   } },

   /* ('umul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('umul_high', 'a', 'b')) */
   /* search11_0 -> 16 in the cache */
   /* search11_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_umul_2x32_64,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace11_0_0 -> 16 in the cache */
   /* replace11_0_1 -> 36 in the cache */
   /* replace11_0 -> 49 in the cache */
   /* replace11_1_0 -> 16 in the cache */
   /* replace11_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_umul_high,
      1, 1,
      { 16, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_pack_64_2x32_split,
      -1, 2,
      { 49, 56 },
      -1,
   } },

   /* ('udiv', 'a', 1) => a */
   /* search12_0 -> 32 in the cache */
   /* search12_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_udiv,
      -1, 0,
      { 32, 35 },
      -1,
   } },

   /* replace12 -> 32 in the cache */

   /* ('idiv', 'a', 1) => a */
   /* search13_0 -> 32 in the cache */
   /* search13_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_idiv,
      -1, 0,
      { 32, 35 },
      -1,
   } },

   /* replace13 -> 32 in the cache */

   /* ('umod', 'a', 1) => 0 */
   /* search14_0 -> 32 in the cache */
   /* search14_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umod,
      -1, 0,
      { 32, 35 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x0 /* 0 */ },
   } },

   /* ('imod', 'a', 1) => 0 */
   /* search15_0 -> 32 in the cache */
   /* search15_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imod,
      -1, 0,
      { 32, 35 },
      -1,
   } },

   /* replace15 -> 61 in the cache */

   /* ('imod', 'a', -1) => 0 */
   /* search16_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { -0x1 /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imod,
      -1, 0,
      { 32, 63 },
      -1,
   } },

   /* replace16 -> 61 in the cache */

   /* ('irem', 'a', 1) => 0 */
   /* search17_0 -> 32 in the cache */
   /* search17_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 32, 35 },
      -1,
   } },

   /* replace17 -> 61 in the cache */

   /* ('irem', 'a', -1) => 0 */
   /* search18_0 -> 32 in the cache */
   /* search18_1 -> 63 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 32, 63 },
      -1,
   } },

   /* replace18 -> 61 in the cache */

   /* ('udiv', 'a', '#b(is_pos_power_of_two)') => ('ushr', 'a', ('find_lsb', 'b')) */
   /* search19_0 -> 0 in the cache */
   /* search19_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_udiv,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace19_0 -> 0 in the cache */
   /* replace19_1_0 -> 3 in the cache */
   /* replace19_1 -> 4 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 0, 4 },
      -1,
   } },

   /* ('idiv', 'a', '#b(is_pos_power_of_two)') => ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', 'b'))) */
   /* search20_0 -> 0 in the cache */
   /* search20_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_idiv,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace20_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_isign,
      -1, 0,
      { 0 },
      -1,
   } },
   /* replace20_1_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 0 },
      -1,
   } },
   /* replace20_1_1_0 -> 3 in the cache */
   /* replace20_1_1 -> 4 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 71, 4 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 70, 72 },
      -1,
   } },

   /* ('idiv', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', ('iabs', 'b'))))) */
   /* search21_0 -> 0 in the cache */
   /* search21_1 -> 26 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_idiv,
      -1, 0,
      { 0, 26 },
      -1,
   } },

   /* replace21_0_0_0 -> 0 in the cache */
   /* replace21_0_0 -> 70 in the cache */
   /* replace21_0_1_0_0 -> 0 in the cache */
   /* replace21_0_1_0 -> 71 in the cache */
   /* replace21_0_1_1_0_0 -> 3 in the cache */
   /* replace21_0_1_1_0 -> 28 in the cache */
   /* replace21_0_1_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 71, 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 70, 75 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 1,
      { 76 },
      -1,
   } },

   /* ('umod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1)) */
   /* search22_0 -> 0 in the cache */
   /* search22_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umod,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace22_0 -> 0 in the cache */
   /* replace22_1_0 -> 3 in the cache */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_int, { 0x1 /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_isub,
      -1, 0,
      { 3, 79 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 0, 80 },
      -1,
   } },

   /* ('imod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1)) */
   /* search23_0 -> 0 in the cache */
   /* search23_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imod,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace23_0 -> 0 in the cache */
   /* replace23_1_0 -> 3 in the cache */
   /* replace23_1_1 -> 79 in the cache */
   /* replace23_1 -> 80 in the cache */
   /* replace23 -> 81 in the cache */

   /* ('imod', 'a', '#b(is_neg_power_of_two)') => ('bcsel', ('ieq', ('ior', 'a', 'b'), 'b'), 0, ('ior', 'a', 'b')) */
   /* search24_0 -> 0 in the cache */
   /* search24_1 -> 26 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imod,
      -1, 0,
      { 0, 26 },
      -1,
   } },

   /* replace24_0_0_0 -> 0 in the cache */
   /* replace24_0_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* replace24_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 84, 3 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_int, { 0x0 /* 0 */ },
   } },
   /* replace24_2_0 -> 0 in the cache */
   /* replace24_2_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      2, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 3,
      { 85, 86, 87 },
      -1,
   } },

   /* ('irem', 'a', '#b(is_pos_power_of_two)') => ('isub', 'a', ('iand', ('bcsel', ('ilt', 'a', 0), ('iadd', 'a', ('isub', 'b', 1)), 'a'), ('ineg', 'b'))) */
   /* search25_0 -> 0 in the cache */
   /* search25_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace25_0 -> 0 in the cache */
   /* replace25_1_0_0_0 -> 0 in the cache */
   /* replace25_1_0_0_1 -> 86 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 0, 86 },
      -1,
   } },
   /* replace25_1_0_1_0 -> 0 in the cache */
   /* replace25_1_0_1_1_0 -> 3 in the cache */
   /* replace25_1_0_1_1_1 -> 79 in the cache */
   /* replace25_1_0_1_1 -> 80 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 0, 80 },
      -1,
   } },
   /* replace25_1_0_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 90, 91, 0 },
      -1,
   } },
   /* replace25_1_1_0 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 92, 93 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_isub,
      -1, 2,
      { 0, 94 },
      -1,
   } },

   /* ('irem', 'a', '#b(is_neg_power_of_two)') => ('irem', 'a', ('iabs', 'b')) */
   /* search26_0 -> 0 in the cache */
   /* search26_1 -> 26 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 0, 26 },
      -1,
   } },

   /* replace26_0 -> 0 in the cache */
   /* replace26_1_0 -> 3 in the cache */
   /* replace26_1 -> 28 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_irem,
      -1, 0,
      { 0, 28 },
      -1,
   } },

   /* ('~fneg', ('fneg', 'a')) => a */
   /* search27_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 98 },
      -1,
   } },

   /* replace27 -> 32 in the cache */

   /* ('ineg', ('ineg', 'a')) => a */
   /* search28_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 100 },
      -1,
   } },

   /* replace28 -> 32 in the cache */

   /* ('fabs', ('fneg', 'a')) => ('fabs', 'a') */
   /* search29_0_0 -> 32 in the cache */
   /* search29_0 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 98 },
      -1,
   } },

   /* replace29_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('fabs', ('u2f', 'a')) => ('u2f', 'a') */
   /* search30_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_u2f,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 104 },
      -1,
   } },

   /* replace30_0 -> 32 in the cache */
   /* replace30 -> 104 in the cache */

   /* ('iabs', ('iabs', 'a')) => ('iabs', 'a') */
   /* search31_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 106 },
      -1,
   } },

   /* replace31_0 -> 32 in the cache */
   /* replace31 -> 106 in the cache */

   /* ('iabs', ('ineg', 'a')) => ('iabs', 'a') */
   /* search32_0_0 -> 32 in the cache */
   /* search32_0 -> 100 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 100 },
      -1,
   } },

   /* replace32_0 -> 32 in the cache */
   /* replace32 -> 106 in the cache */

   /* ('f2b', ('fneg', 'a')) => ('f2b', 'a') */
   /* search33_0_0 -> 32 in the cache */
   /* search33_0 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_f2b,
      -1, 0,
      { 98 },
      -1,
   } },

   /* replace33_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_f2b,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('i2b', ('ineg', 'a')) => ('i2b', 'a') */
   /* search34_0_0 -> 32 in the cache */
   /* search34_0 -> 100 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_i2b,
      -1, 0,
      { 100 },
      -1,
   } },

   /* replace34_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_i2b,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('~fadd', 'a', 0.0) => a */
   /* search35_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 32, 113 },
      -1,
   } },

   /* replace35 -> 32 in the cache */

   /* ('fadd(is_only_used_as_float)', 'a@16', 0.0) => a */
   /* search36_0 -> 11 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 11, 115 },
      1,
   } },

   /* replace36 -> 11 in the cache */

   /* ('fadd(is_only_used_as_float)', 'a@32', 0.0) => a */
   /* search37_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 16, 117 },
      1,
   } },

   /* replace37 -> 16 in the cache */

   /* ('iadd', 'a', 0) => a */
   /* search38_0 -> 32 in the cache */
   /* search38_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace38 -> 32 in the cache */

   /* ('usadd_4x8_vc4', 'a', 0) => a */
   /* search39_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x0 /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_usadd_4x8_vc4,
      0, 1,
      { 16, 120 },
      -1,
   } },

   /* replace39 -> 16 in the cache */

   /* ('usadd_4x8_vc4', 'a', -1) => -1 */
   /* search40_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { -0x1 /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_usadd_4x8_vc4,
      0, 1,
      { 16, 122 },
      -1,
   } },

   /* replace40 -> 122 in the cache */

   /* ('~fadd', ('fmul', 'a', 'b'), ('fmul', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c')) */
   { .variable = {
      { nir_search_value_variable, -3 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -3 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 124, 125 },
      -1,
   } },
   /* search41_1_0 -> 124 in the cache */
   { .variable = {
      { nir_search_value_variable, -3 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 124, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 126, 128 },
      -1,
   } },

   /* replace41_0 -> 124 in the cache */
   /* replace41_1_0 -> 125 in the cache */
   /* replace41_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 125, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 124, 130 },
      -1,
   } },

   /* ('~fadd', ('fmulz', 'a', 'b'), ('fmulz', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c')) */
   /* search42_0_0 -> 16 in the cache */
   /* search42_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* search42_1_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      2, 1,
      { 16, 133 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 132, 134 },
      -1,
   } },

   /* replace42_0 -> 16 in the cache */
   /* replace42_1_0 -> 36 in the cache */
   /* replace42_1_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 36, 133 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 2,
      { 16, 136 },
      -1,
   } },

   /* ('~ffma', 'a', 'b', ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd') */
   /* search43_0 -> 0 in the cache */
   /* search43_1 -> 3 in the cache */
   /* search43_2_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 0, 138, 139 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 0, 3, 140 },
      -1,
   } },

   /* replace43_0 -> 0 in the cache */
   /* replace43_1_0 -> 3 in the cache */
   /* replace43_1_1 -> 138 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 3, 138 },
      -1,
   } },
   /* replace43_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 0, 142, 139 },
      -1,
   } },

   /* ('~ffma', 'a', 'b', ('fmul(is_used_once)', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c')) */
   /* search44_0 -> 0 in the cache */
   /* search44_1 -> 3 in the cache */
   /* search44_2_0 -> 0 in the cache */
   /* search44_2_1 -> 138 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 0, 138 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 0, 3, 144 },
      -1,
   } },

   /* replace44_0 -> 0 in the cache */
   /* replace44_1_0 -> 3 in the cache */
   /* replace44_1_1 -> 138 in the cache */
   /* replace44_1 -> 142 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 0, 142 },
      -1,
   } },

   /* ('~fadd', ('fmul(is_used_once)', 'a', 'b'), ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd') */
   { .variable = {
      { nir_search_value_variable, -4 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 147, 148 },
      0,
   } },
   /* search45_1_0 -> 147 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_ffma,
      2, 1,
      { 147, 150, 151 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 149, 152 },
      -1,
   } },

   /* replace45_0 -> 147 in the cache */
   /* replace45_1_0 -> 148 in the cache */
   /* replace45_1_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 148, 150 },
      -1,
   } },
   /* replace45_2 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 147, 154, 151 },
      -1,
   } },

   /* ('~ffma', 'a', ('fmul(is_used_once)', 'b', 'c'), ('fmul(is_used_once)', 'b', 'd')) => ('fmul', 'b', ('ffma', 'a', 'c', 'd')) */
   /* search46_0 -> 147 in the cache */
   /* search46_1_0 -> 148 in the cache */
   /* search46_1_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 148, 150 },
      0,
   } },
   /* search46_2_0 -> 148 in the cache */
   /* search46_2_1 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 148, 151 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 147, 156, 157 },
      -1,
   } },

   /* replace46_0 -> 148 in the cache */
   /* replace46_1_0 -> 147 in the cache */
   /* replace46_1_1 -> 150 in the cache */
   /* replace46_1_2 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 147, 150, 151 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 148, 159 },
      -1,
   } },

   /* ('~ffmaz', 'a', 'b', ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd') */
   /* search47_0 -> 16 in the cache */
   /* search47_1 -> 36 in the cache */
   /* search47_2_0 -> 16 in the cache */
   /* search47_2_1 -> 133 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      1, 1,
      { 16, 133, 161 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 2,
      { 16, 36, 162 },
      -1,
   } },

   /* replace47_0 -> 16 in the cache */
   /* replace47_1_0 -> 36 in the cache */
   /* replace47_1_1 -> 133 in the cache */
   /* replace47_1 -> 136 in the cache */
   /* replace47_2 -> 161 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 2,
      { 16, 136, 161 },
      -1,
   } },

   /* ('~ffmaz', 'a', 'b', ('fmulz(is_used_once)', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c')) */
   /* search48_0 -> 16 in the cache */
   /* search48_1 -> 36 in the cache */
   /* search48_2_0 -> 16 in the cache */
   /* search48_2_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 16, 133 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 2,
      { 16, 36, 165 },
      -1,
   } },

   /* replace48_0 -> 16 in the cache */
   /* replace48_1_0 -> 36 in the cache */
   /* replace48_1_1 -> 133 in the cache */
   /* replace48_1 -> 136 in the cache */
   /* replace48 -> 137 in the cache */

   /* ('~fadd', ('fmulz(is_used_once)', 'a', 'b'), ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd') */
   /* search49_0_0 -> 16 in the cache */
   /* search49_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 16, 36 },
      0,
   } },
   /* search49_1_0 -> 16 in the cache */
   /* search49_1_1 -> 133 in the cache */
   /* search49_1_2 -> 161 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      2, 1,
      { 16, 133, 161 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 167, 168 },
      -1,
   } },

   /* replace49_0 -> 16 in the cache */
   /* replace49_1_0 -> 36 in the cache */
   /* replace49_1_1 -> 133 in the cache */
   /* replace49_1 -> 136 in the cache */
   /* replace49_2 -> 161 in the cache */
   /* replace49 -> 164 in the cache */

   /* ('~ffmaz', 'a', ('fmulz(is_used_once)', 'b', 'c'), ('fmulz(is_used_once)', 'b', 'd')) => ('fmulz', 'b', ('ffmaz', 'a', 'c', 'd')) */
   /* search50_0 -> 16 in the cache */
   /* search50_1_0 -> 36 in the cache */
   /* search50_1_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      1, 1,
      { 36, 133 },
      0,
   } },
   /* search50_2_0 -> 36 in the cache */
   /* search50_2_1 -> 161 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      2, 1,
      { 36, 161 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 3,
      { 16, 170, 171 },
      -1,
   } },

   /* replace50_0 -> 36 in the cache */
   /* replace50_1_0 -> 16 in the cache */
   /* replace50_1_1 -> 133 in the cache */
   /* replace50_1_2 -> 161 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      1, 1,
      { 16, 133, 161 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 2,
      { 36, 173 },
      -1,
   } },

   /* ('iadd', ('imul', 'a', 'b'), ('imul', 'a', 'c')) => ('imul', 'a', ('iadd', 'b', 'c')) */
   /* search51_0_0 -> 124 in the cache */
   /* search51_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 124, 125 },
      -1,
   } },
   /* search51_1_0 -> 124 in the cache */
   /* search51_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      2, 1,
      { 124, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 175, 176 },
      -1,
   } },

   /* replace51_0 -> 124 in the cache */
   /* replace51_1_0 -> 125 in the cache */
   /* replace51_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 125, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      0, 2,
      { 124, 178 },
      -1,
   } },

   /* ('iand', ('ior', 'a', 'b'), ('ior', 'a', 'c')) => ('ior', 'a', ('iand', 'b', 'c')) */
   /* search52_0_0 -> 124 in the cache */
   /* search52_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 124, 125 },
      -1,
   } },
   /* search52_1_0 -> 124 in the cache */
   /* search52_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      2, 1,
      { 124, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 180, 181 },
      -1,
   } },

   /* replace52_0 -> 124 in the cache */
   /* replace52_1_0 -> 125 in the cache */
   /* replace52_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 125, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 124, 183 },
      -1,
   } },

   /* ('ior', ('iand', 'a', 'b'), ('iand', 'a', 'c')) => ('iand', 'a', ('ior', 'b', 'c')) */
   /* search53_0_0 -> 124 in the cache */
   /* search53_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 124, 125 },
      -1,
   } },
   /* search53_1_0 -> 124 in the cache */
   /* search53_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 124, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 185, 186 },
      -1,
   } },

   /* replace53_0 -> 124 in the cache */
   /* replace53_1_0 -> 125 in the cache */
   /* replace53_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 125, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 124, 188 },
      -1,
   } },

   /* ('~fadd', ('fneg', 'a'), 'a') => 0.0 */
   /* search54_0_0 -> 32 in the cache */
   /* search54_0 -> 98 in the cache */
   /* search54_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 98, 32 },
      -1,
   } },

   /* replace54 -> 113 in the cache */

   /* ('iadd', ('ineg', 'a'), 'a') => 0 */
   /* search55_0_0 -> 32 in the cache */
   /* search55_0 -> 100 in the cache */
   /* search55_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 100, 32 },
      -1,
   } },

   /* replace55 -> 61 in the cache */

   /* ('iadd', ('ineg', 'a'), ('iadd', 'a', 'b')) => b */
   /* search56_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 0 },
      -1,
   } },
   /* search56_1_0 -> 0 in the cache */
   /* search56_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 192, 193 },
      -1,
   } },

   /* replace56 -> 3 in the cache */

   /* ('iadd', 'a', ('iadd', ('ineg', 'a'), 'b')) => b */
   /* search57_0 -> 0 in the cache */
   /* search57_1_0_0 -> 0 in the cache */
   /* search57_1_0 -> 192 in the cache */
   /* search57_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 192, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 0, 195 },
      -1,
   } },

   /* replace57 -> 3 in the cache */

   /* ('~fadd', ('fneg', 'a'), ('fadd', 'a', 'b')) => b */
   /* search58_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 0 },
      -1,
   } },
   /* search58_1_0 -> 0 in the cache */
   /* search58_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 197, 198 },
      -1,
   } },

   /* replace58 -> 3 in the cache */

   /* ('~fadd', 'a', ('fadd', ('fneg', 'a'), 'b')) => b */
   /* search59_0 -> 0 in the cache */
   /* search59_1_0_0 -> 0 in the cache */
   /* search59_1_0 -> 197 in the cache */
   /* search59_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 197, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 0, 200 },
      -1,
   } },

   /* replace59 -> 3 in the cache */

   /* ('fadd', ('fsat', 'a'), ('fsat', ('fneg', 'a'))) => ('fsat', ('fabs', 'a')) */
   /* search60_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 32 },
      -1,
   } },
   /* search60_1_0_0 -> 32 in the cache */
   /* search60_1_0 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 98 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 202, 203 },
      -1,
   } },

   /* replace60_0_0 -> 32 in the cache */
   /* replace60_0 -> 103 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 103 },
      -1,
   } },

   /* ('~fmul', 'a', 0.0) => 0.0 */
   /* search61_0 -> 32 in the cache */
   /* search61_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 32, 113 },
      -1,
   } },

   /* replace61 -> 113 in the cache */

   /* ('fmul', 'a@16', 0.0) => 0.0 */
   /* search62_0 -> 11 in the cache */
   /* search62_1 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 11, 115 },
      -1,
   } },

   /* replace62 -> 115 in the cache */

   /* ('fmul', 'a@32', 0.0) => 0.0 */
   /* search63_0 -> 16 in the cache */
   /* search63_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 16, 117 },
      -1,
   } },

   /* replace63 -> 117 in the cache */

   /* ('fmulz', 'a', 0.0) => 0.0 */
   /* search64_0 -> 16 in the cache */
   /* search64_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 16, 117 },
      -1,
   } },

   /* replace64 -> 117 in the cache */

   /* ('fmulz', 'a', 'b(is_finite_not_zero)') => ('fmul', 'a', 'b') */
   /* search65_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      3,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 16, 210 },
      -1,
   } },

   /* replace65_0 -> 16 in the cache */
   /* replace65_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* ('fmulz', 'a(is_finite)', 'b(is_finite)') => ('fmul', 'a', 'b') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      4,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      4,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 213, 214 },
      -1,
   } },

   /* replace66_0 -> 16 in the cache */
   /* replace66_1 -> 36 in the cache */
   /* replace66 -> 212 in the cache */

   /* ('fmulz', 'a', 'a') => ('fmul', 'a', 'a') */
   /* search67_0 -> 16 in the cache */
   /* search67_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      -1, 0,
      { 16, 16 },
      -1,
   } },

   /* replace67_0 -> 16 in the cache */
   /* replace67_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      -1, 0,
      { 16, 16 },
      -1,
   } },

   /* ('ffmaz', 'a', 'b(is_finite_not_zero)', 'c') => ('ffma', 'a', 'b', 'c') */
   /* search68_0 -> 16 in the cache */
   /* search68_1 -> 210 in the cache */
   /* search68_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 16, 210, 133 },
      -1,
   } },

   /* replace68_0 -> 16 in the cache */
   /* replace68_1 -> 36 in the cache */
   /* replace68_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 16, 36, 133 },
      -1,
   } },

   /* ('ffmaz', 'a(is_finite)', 'b(is_finite)', 'c') => ('ffma', 'a', 'b', 'c') */
   /* search69_0 -> 213 in the cache */
   /* search69_1 -> 214 in the cache */
   /* search69_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 213, 214, 133 },
      -1,
   } },

   /* replace69_0 -> 16 in the cache */
   /* replace69_1 -> 36 in the cache */
   /* replace69_2 -> 133 in the cache */
   /* replace69 -> 219 in the cache */

   /* ('ffmaz', 'a', 'a', 'b') => ('ffma', 'a', 'a', 'b') */
   /* search70_0 -> 16 in the cache */
   /* search70_1 -> 16 in the cache */
   /* search70_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      -1, 0,
      { 16, 16, 36 },
      -1,
   } },

   /* replace70_0 -> 16 in the cache */
   /* replace70_1 -> 16 in the cache */
   /* replace70_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      -1, 0,
      { 16, 16, 36 },
      -1,
   } },

   /* ('imul', 'a', 0) => 0 */
   /* search71_0 -> 32 in the cache */
   /* search71_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace71 -> 61 in the cache */

   /* ('umul_unorm_4x8_vc4', 'a', 0) => 0 */
   /* search72_0 -> 16 in the cache */
   /* search72_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_umul_unorm_4x8_vc4,
      0, 1,
      { 16, 120 },
      -1,
   } },

   /* replace72 -> 120 in the cache */

   /* ('umul_unorm_4x8_vc4', 'a', -1) => a */
   /* search73_0 -> 16 in the cache */
   /* search73_1 -> 122 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_umul_unorm_4x8_vc4,
      0, 1,
      { 16, 122 },
      -1,
   } },

   /* replace73 -> 16 in the cache */

   /* ('~fmul', 'a', 1.0) => a */
   /* search74_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 32, 226 },
      -1,
   } },

   /* replace74 -> 32 in the cache */

   /* ('~fmulz', 'a', 1.0) => a */
   /* search75_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 16, 228 },
      -1,
   } },

   /* replace75 -> 16 in the cache */

   /* ('fmul(is_only_used_as_float)', 'a', 1.0) => a */
   /* search76_0 -> 32 in the cache */
   /* search76_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 32, 226 },
      1,
   } },

   /* replace76 -> 32 in the cache */

   /* ('imul', 'a', 1) => a */
   /* search77_0 -> 32 in the cache */
   /* search77_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 32, 35 },
      -1,
   } },

   /* replace77 -> 32 in the cache */

   /* ('fmul', 'a', -1.0) => ('fneg', 'a') */
   /* search78_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0xbff0000000000000 /* -1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 32, 232 },
      -1,
   } },

   /* replace78_0 -> 32 in the cache */
   /* replace78 -> 98 in the cache */

   /* ('imul', 'a', -1) => ('ineg', 'a') */
   /* search79_0 -> 32 in the cache */
   /* search79_1 -> 63 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 32, 63 },
      -1,
   } },

   /* replace79_0 -> 32 in the cache */
   /* replace79 -> 100 in the cache */

   /* ('fmul', ('fsign', 'a'), ('fmul', 'a', 'a')) => ('fmul', ('fabs', 'a'), 'a') */
   /* search80_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsign,
      -1, 0,
      { 32 },
      -1,
   } },
   /* search80_1_0 -> 32 in the cache */
   /* search80_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      -1, 0,
      { 32, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 235, 236 },
      -1,
   } },

   /* replace80_0_0 -> 32 in the cache */
   /* replace80_0 -> 103 in the cache */
   /* replace80_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 103, 32 },
      -1,
   } },

   /* ('fmul', ('fmul', ('fsign', 'a'), 'a'), 'a') => ('fmul', ('fabs', 'a'), 'a') */
   /* search81_0_0_0 -> 32 in the cache */
   /* search81_0_0 -> 235 in the cache */
   /* search81_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 235, 32 },
      -1,
   } },
   /* search81_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 239, 32 },
      -1,
   } },

   /* replace81_0_0 -> 32 in the cache */
   /* replace81_0 -> 103 in the cache */
   /* replace81_1 -> 32 in the cache */
   /* replace81 -> 238 in the cache */

   /* ('~ffma', 0.0, 'a', 'b') => b */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   /* search82_1 -> 0 in the cache */
   /* search82_2 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 241, 0, 3 },
      -1,
   } },

   /* replace82 -> 3 in the cache */

   /* ('ffma@16(is_only_used_as_float)', 0.0, 'a', 'b') => b */
   /* search83_0 -> 115 in the cache */
   /* search83_1 -> 11 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 115, 11, 243 },
      1,
   } },

   /* replace83 -> 243 in the cache */

   /* ('ffma@32(is_only_used_as_float)', 0.0, 'a', 'b') => b */
   /* search84_0 -> 117 in the cache */
   /* search84_1 -> 16 in the cache */
   /* search84_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 117, 16, 36 },
      1,
   } },

   /* replace84 -> 36 in the cache */

   /* ('ffmaz', 0.0, 'a', 'b') => ('fadd', 0.0, 'b') */
   /* search85_0 -> 117 in the cache */
   /* search85_1 -> 16 in the cache */
   /* search85_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 117, 16, 36 },
      -1,
   } },

   /* replace85_0 -> 117 in the cache */
   /* replace85_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 117, 36 },
      -1,
   } },

   /* ('~ffma', 'a', 'b', 0.0) => ('fmul', 'a', 'b') */
   /* search86_0 -> 0 in the cache */
   /* search86_1 -> 3 in the cache */
   /* search86_2 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 0, 3, 241 },
      -1,
   } },

   /* replace86_0 -> 0 in the cache */
   /* replace86_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('ffma@16', 'a', 'b', 0.0) => ('fmul', 'a', 'b') */
   /* search87_0 -> 11 in the cache */
   /* search87_1 -> 243 in the cache */
   /* search87_2 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 11, 243, 115 },
      -1,
   } },

   /* replace87_0 -> 11 in the cache */
   /* replace87_1 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 11, 243 },
      -1,
   } },

   /* ('ffma@32', 'a', 'b', 0.0) => ('fmul', 'a', 'b') */
   /* search88_0 -> 16 in the cache */
   /* search88_1 -> 36 in the cache */
   /* search88_2 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 16, 36, 117 },
      -1,
   } },

   /* replace88_0 -> 16 in the cache */
   /* replace88_1 -> 36 in the cache */
   /* replace88 -> 212 in the cache */

   /* ('ffmaz', 'a', 'b', 0.0) => ('fmulz', 'a', 'b') */
   /* search89_0 -> 16 in the cache */
   /* search89_1 -> 36 in the cache */
   /* search89_2 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 16, 36, 117 },
      -1,
   } },

   /* replace89_0 -> 16 in the cache */
   /* replace89_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* ('ffma', 1.0, 'a', 'b') => ('fadd', 'a', 'b') */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
   } },
   /* search90_1 -> 0 in the cache */
   /* search90_2 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 255, 0, 3 },
      -1,
   } },

   /* replace90_0 -> 0 in the cache */
   /* replace90_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('ffmaz', 1.0, 'a', 'b') => ('fadd', 'a', 'b') */
   /* search91_0 -> 228 in the cache */
   /* search91_1 -> 16 in the cache */
   /* search91_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 228, 16, 36 },
      -1,
   } },

   /* replace91_0 -> 16 in the cache */
   /* replace91_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* ('ffma', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b') */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_float, { 0xbff0000000000000 /* -1.0 */ },
   } },
   /* search92_1 -> 0 in the cache */
   /* search92_2 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 260, 0, 3 },
      -1,
   } },

   /* replace92_0_0 -> 0 in the cache */
   /* replace92_0 -> 197 in the cache */
   /* replace92_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 197, 3 },
      -1,
   } },

   /* ('ffmaz', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b') */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_float, { 0xbff0000000000000 /* -1.0 */ },
   } },
   /* search93_1 -> 16 in the cache */
   /* search93_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 263, 16, 36 },
      -1,
   } },

   /* replace93_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 16 },
      -1,
   } },
   /* replace93_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 265, 36 },
      -1,
   } },

   /* ('~ffma', '#a', '#b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   { .variable = {
      { nir_search_value_variable, -3 },
      0, /* a */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -3 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search94_2 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 267, 268, 127 },
      -1,
   } },

   /* replace94_0_0 -> 124 in the cache */
   /* replace94_0_1 -> 125 in the cache */
   /* replace94_0 -> 126 in the cache */
   /* replace94_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 126, 127 },
      -1,
   } },

   /* ('~ffmaz', '#a', '#b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search95_1 -> 33 in the cache */
   /* search95_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 271, 33, 133 },
      -1,
   } },

   /* replace95_0_0 -> 16 in the cache */
   /* replace95_0_1 -> 36 in the cache */
   /* replace95_0 -> 132 in the cache */
   /* replace95_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 132, 133 },
      -1,
   } },

   /* ('~flrp', 'a', 'b', 0.0) => a */
   /* search96_0 -> 0 in the cache */
   /* search96_1 -> 3 in the cache */
   /* search96_2 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 0, 3, 241 },
      -1,
   } },

   /* replace96 -> 0 in the cache */

   /* ('~flrp', 'a', 'b', 1.0) => b */
   /* search97_0 -> 0 in the cache */
   /* search97_1 -> 3 in the cache */
   /* search97_2 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 0, 3, 255 },
      -1,
   } },

   /* replace97 -> 3 in the cache */

   /* ('~flrp', 'a', 'a', 'b') => a */
   /* search98_0 -> 0 in the cache */
   /* search98_1 -> 0 in the cache */
   /* search98_2 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 0, 0, 3 },
      -1,
   } },

   /* replace98 -> 0 in the cache */

   /* ('~flrp', 0.0, 'a', 'b') => ('fmul', 'a', 'b') */
   /* search99_0 -> 241 in the cache */
   /* search99_1 -> 0 in the cache */
   /* search99_2 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 241, 0, 3 },
      -1,
   } },

   /* replace99_0 -> 0 in the cache */
   /* replace99_1 -> 3 in the cache */
   /* replace99 -> 249 in the cache */

   /* ('~flrp', 'a', ('fadd(is_used_once)', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search100_0 -> 124 in the cache */
   /* search100_1_0 -> 124 in the cache */
   /* search100_1_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 124, 125 },
      0,
   } },
   /* search100_2 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 124, 278, 127 },
      -1,
   } },

   /* replace100_0_0 -> 125 in the cache */
   /* replace100_0_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 125, 127 },
      -1,
   } },
   /* replace100_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 280, 124 },
      -1,
   } },

   /* ('sdot_4x8_iadd', 'a', 0, 'b') => b */
   /* search101_0 -> 16 in the cache */
   /* search101_1 -> 120 in the cache */
   /* search101_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      0, 1,
      { 16, 120, 36 },
      -1,
   } },

   /* replace101 -> 36 in the cache */

   /* ('udot_4x8_uadd', 'a', 0, 'b') => b */
   /* search102_0 -> 16 in the cache */
   /* search102_1 -> 120 in the cache */
   /* search102_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      0, 1,
      { 16, 120, 36 },
      -1,
   } },

   /* replace102 -> 36 in the cache */

   /* ('sdot_4x8_iadd_sat', 'a', 0, 'b') => b */
   /* search103_0 -> 16 in the cache */
   /* search103_1 -> 120 in the cache */
   /* search103_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd_sat,
      0, 1,
      { 16, 120, 36 },
      -1,
   } },

   /* replace103 -> 36 in the cache */

   /* ('udot_4x8_uadd_sat', 'a', 0, 'b') => b */
   /* search104_0 -> 16 in the cache */
   /* search104_1 -> 120 in the cache */
   /* search104_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 16, 120, 36 },
      -1,
   } },

   /* replace104 -> 36 in the cache */

   /* ('sdot_2x16_iadd', 'a', 0, 'b') => b */
   /* search105_0 -> 16 in the cache */
   /* search105_1 -> 120 in the cache */
   /* search105_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      0, 1,
      { 16, 120, 36 },
      -1,
   } },

   /* replace105 -> 36 in the cache */

   /* ('udot_2x16_uadd', 'a', 0, 'b') => b */
   /* search106_0 -> 16 in the cache */
   /* search106_1 -> 120 in the cache */
   /* search106_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      0, 1,
      { 16, 120, 36 },
      -1,
   } },

   /* replace106 -> 36 in the cache */

   /* ('sdot_2x16_iadd_sat', 'a', 0, 'b') => b */
   /* search107_0 -> 16 in the cache */
   /* search107_1 -> 120 in the cache */
   /* search107_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd_sat,
      0, 1,
      { 16, 120, 36 },
      -1,
   } },

   /* replace107 -> 36 in the cache */

   /* ('udot_2x16_uadd_sat', 'a', 0, 'b') => b */
   /* search108_0 -> 16 in the cache */
   /* search108_1 -> 120 in the cache */
   /* search108_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd_sat,
      0, 1,
      { 16, 120, 36 },
      -1,
   } },

   /* replace108 -> 36 in the cache */

   /* ('sudot_4x8_iadd', 'a', 0, 'b') => b */
   /* search109_0 -> 16 in the cache */
   /* search109_1 -> 120 in the cache */
   /* search109_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 16, 120, 36 },
      -1,
   } },

   /* replace109 -> 36 in the cache */

   /* ('sudot_4x8_iadd', 0, 'a', 'b') => b */
   /* search110_0 -> 120 in the cache */
   /* search110_1 -> 16 in the cache */
   /* search110_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 120, 16, 36 },
      -1,
   } },

   /* replace110 -> 36 in the cache */

   /* ('sudot_4x8_iadd_sat', 'a', 0, 'b') => b */
   /* search111_0 -> 16 in the cache */
   /* search111_1 -> 120 in the cache */
   /* search111_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 16, 120, 36 },
      -1,
   } },

   /* replace111 -> 36 in the cache */

   /* ('sudot_4x8_iadd_sat', 0, 'a', 'b') => b */
   /* search112_0 -> 120 in the cache */
   /* search112_1 -> 16 in the cache */
   /* search112_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 120, 16, 36 },
      -1,
   } },

   /* replace112 -> 36 in the cache */

   /* ('iadd', ('sdot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search113_0_0 -> 16 in the cache */
   /* search113_0_1 -> 36 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      1, 1,
      { 16, 36, 294 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      3, /* d */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 295, 296 },
      -1,
   } },

   /* replace113_0 -> 16 in the cache */
   /* replace113_1 -> 36 in the cache */
   /* replace113_2_0 -> 133 in the cache */
   /* replace113_2_1 -> 161 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 133, 161 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      0, 2,
      { 16, 36, 298 },
      -1,
   } },

   /* ('iadd', ('udot_4x8_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_4x8_uadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search114_0_0 -> 16 in the cache */
   /* search114_0_1 -> 36 in the cache */
   /* search114_0_2 -> 294 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      1, 1,
      { 16, 36, 294 },
      0,
   } },
   /* search114_1 -> 296 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 300, 296 },
      -1,
   } },

   /* replace114_0 -> 16 in the cache */
   /* replace114_1 -> 36 in the cache */
   /* replace114_2_0 -> 133 in the cache */
   /* replace114_2_1 -> 161 in the cache */
   /* replace114_2 -> 298 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      0, 2,
      { 16, 36, 298 },
      -1,
   } },

   /* ('iadd', ('sudot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sudot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search115_0_0 -> 16 in the cache */
   /* search115_0_1 -> 36 in the cache */
   /* search115_0_2 -> 294 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 16, 36, 294 },
      0,
   } },
   /* search115_1 -> 296 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 303, 296 },
      -1,
   } },

   /* replace115_0 -> 16 in the cache */
   /* replace115_1 -> 36 in the cache */
   /* replace115_2_0 -> 133 in the cache */
   /* replace115_2_1 -> 161 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 133, 161 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 1,
      { 16, 36, 305 },
      -1,
   } },

   /* ('iadd', ('sdot_2x16_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_2x16_iadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search116_0_0 -> 16 in the cache */
   /* search116_0_1 -> 36 in the cache */
   /* search116_0_2 -> 294 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      1, 1,
      { 16, 36, 294 },
      0,
   } },
   /* search116_1 -> 296 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 307, 296 },
      -1,
   } },

   /* replace116_0 -> 16 in the cache */
   /* replace116_1 -> 36 in the cache */
   /* replace116_2_0 -> 133 in the cache */
   /* replace116_2_1 -> 161 in the cache */
   /* replace116_2 -> 298 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      0, 2,
      { 16, 36, 298 },
      -1,
   } },

   /* ('iadd', ('udot_2x16_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_2x16_uadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search117_0_0 -> 16 in the cache */
   /* search117_0_1 -> 36 in the cache */
   /* search117_0_2 -> 294 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      1, 1,
      { 16, 36, 294 },
      0,
   } },
   /* search117_1 -> 296 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 310, 296 },
      -1,
   } },

   /* replace117_0 -> 16 in the cache */
   /* replace117_1 -> 36 in the cache */
   /* replace117_2_0 -> 133 in the cache */
   /* replace117_2_1 -> 161 in the cache */
   /* replace117_2 -> 298 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      0, 2,
      { 16, 36, 298 },
      -1,
   } },

   /* ('iadd', ('sdot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_4x8_iadd', 'a', 'b', 'c') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      5,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search118_0_1 -> 36 in the cache */
   /* search118_0_2 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      1, 1,
      { 313, 36, 120 },
      -1,
   } },
   /* search118_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 314, 133 },
      -1,
   } },

   /* replace118_0 -> 16 in the cache */
   /* replace118_1 -> 36 in the cache */
   /* replace118_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      0, 1,
      { 16, 36, 133 },
      -1,
   } },

   /* ('iadd', ('udot_4x8_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_4x8_uadd', 'a', 'b', 'c') */
   /* search119_0_0 -> 313 in the cache */
   /* search119_0_1 -> 36 in the cache */
   /* search119_0_2 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      1, 1,
      { 313, 36, 120 },
      -1,
   } },
   /* search119_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 317, 133 },
      -1,
   } },

   /* replace119_0 -> 16 in the cache */
   /* replace119_1 -> 36 in the cache */
   /* replace119_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      0, 1,
      { 16, 36, 133 },
      -1,
   } },

   /* ('iadd', ('sudot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c') */
   /* search120_0_0 -> 313 in the cache */
   /* search120_0_1 -> 36 in the cache */
   /* search120_0_2 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 313, 36, 120 },
      -1,
   } },
   /* search120_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 320, 133 },
      -1,
   } },

   /* replace120_0 -> 16 in the cache */
   /* replace120_1 -> 36 in the cache */
   /* replace120_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 16, 36, 133 },
      -1,
   } },

   /* ('iadd', ('sudot_4x8_iadd', 'a', 'b(is_not_const)', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c') */
   /* search121_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      5,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search121_0_2 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 16, 323, 120 },
      -1,
   } },
   /* search121_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 324, 133 },
      -1,
   } },

   /* replace121_0 -> 16 in the cache */
   /* replace121_1 -> 36 in the cache */
   /* replace121_2 -> 133 in the cache */
   /* replace121 -> 322 in the cache */

   /* ('iadd', ('sdot_2x16_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_2x16_iadd', 'a', 'b', 'c') */
   /* search122_0_0 -> 313 in the cache */
   /* search122_0_1 -> 36 in the cache */
   /* search122_0_2 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      1, 1,
      { 313, 36, 120 },
      -1,
   } },
   /* search122_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 326, 133 },
      -1,
   } },

   /* replace122_0 -> 16 in the cache */
   /* replace122_1 -> 36 in the cache */
   /* replace122_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      0, 1,
      { 16, 36, 133 },
      -1,
   } },

   /* ('iadd', ('udot_2x16_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_2x16_uadd', 'a', 'b', 'c') */
   /* search123_0_0 -> 313 in the cache */
   /* search123_0_1 -> 36 in the cache */
   /* search123_0_2 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      1, 1,
      { 313, 36, 120 },
      -1,
   } },
   /* search123_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 329, 133 },
      -1,
   } },

   /* replace123_0 -> 16 in the cache */
   /* replace123_1 -> 36 in the cache */
   /* replace123_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      0, 1,
      { 16, 36, 133 },
      -1,
   } },

   /* ('sdot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search124_0 -> 271 in the cache */
   /* search124_1 -> 33 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      false,
      nir_type_invalid,
      5,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      0, 1,
      { 271, 33, 332 },
      -1,
   } },

   /* replace124_0_0 -> 16 in the cache */
   /* replace124_0_1 -> 36 in the cache */
   /* replace124_0_2 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd,
      1, 1,
      { 16, 36, 120 },
      -1,
   } },
   /* replace124_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 334, 133 },
      -1,
   } },

   /* ('udot_4x8_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_4x8_uadd', 'a', 'b', 0), 'c') */
   /* search125_0 -> 271 in the cache */
   /* search125_1 -> 33 in the cache */
   /* search125_2 -> 332 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      0, 1,
      { 271, 33, 332 },
      -1,
   } },

   /* replace125_0_0 -> 16 in the cache */
   /* replace125_0_1 -> 36 in the cache */
   /* replace125_0_2 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd,
      1, 1,
      { 16, 36, 120 },
      -1,
   } },
   /* replace125_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 337, 133 },
      -1,
   } },

   /* ('sudot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sudot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search126_0 -> 271 in the cache */
   /* search126_1 -> 33 in the cache */
   /* search126_2 -> 332 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 271, 33, 332 },
      -1,
   } },

   /* replace126_0_0 -> 16 in the cache */
   /* replace126_0_1 -> 36 in the cache */
   /* replace126_0_2 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 16, 36, 120 },
      -1,
   } },
   /* replace126_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 340, 133 },
      -1,
   } },

   /* ('sdot_2x16_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_2x16_iadd', 'a', 'b', 0), 'c') */
   /* search127_0 -> 271 in the cache */
   /* search127_1 -> 33 in the cache */
   /* search127_2 -> 332 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      0, 1,
      { 271, 33, 332 },
      -1,
   } },

   /* replace127_0_0 -> 16 in the cache */
   /* replace127_0_1 -> 36 in the cache */
   /* replace127_0_2 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd,
      1, 1,
      { 16, 36, 120 },
      -1,
   } },
   /* replace127_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 343, 133 },
      -1,
   } },

   /* ('udot_2x16_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_2x16_uadd', 'a', 'b', 0), 'c') */
   /* search128_0 -> 271 in the cache */
   /* search128_1 -> 33 in the cache */
   /* search128_2 -> 332 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      0, 1,
      { 271, 33, 332 },
      -1,
   } },

   /* replace128_0_0 -> 16 in the cache */
   /* replace128_0_1 -> 36 in the cache */
   /* replace128_0_2 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd,
      1, 1,
      { 16, 36, 120 },
      -1,
   } },
   /* replace128_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 346, 133 },
      -1,
   } },

   /* ('sdot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search129_0 -> 271 in the cache */
   /* search129_1 -> 33 in the cache */
   /* search129_2 -> 332 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd_sat,
      0, 1,
      { 271, 33, 332 },
      -1,
   } },

   /* replace129_0_0 -> 16 in the cache */
   /* replace129_0_1 -> 36 in the cache */
   /* replace129_0_2 -> 120 in the cache */
   /* replace129_0 -> 334 in the cache */
   /* replace129_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 2,
      { 334, 133 },
      -1,
   } },

   /* ('udot_4x8_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_4x8_uadd', 'a', 'b', 0), 'c') */
   /* search130_0 -> 271 in the cache */
   /* search130_1 -> 33 in the cache */
   /* search130_2 -> 332 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 271, 33, 332 },
      -1,
   } },

   /* replace130_0_0 -> 16 in the cache */
   /* replace130_0_1 -> 36 in the cache */
   /* replace130_0_2 -> 120 in the cache */
   /* replace130_0 -> 337 in the cache */
   /* replace130_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_uadd_sat,
      0, 2,
      { 337, 133 },
      -1,
   } },

   /* ('sudot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sudot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search131_0 -> 271 in the cache */
   /* search131_1 -> 33 in the cache */
   /* search131_2 -> 332 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 271, 33, 332 },
      -1,
   } },

   /* replace131_0_0 -> 16 in the cache */
   /* replace131_0_1 -> 36 in the cache */
   /* replace131_0_2 -> 120 in the cache */
   /* replace131_0 -> 340 in the cache */
   /* replace131_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 1,
      { 340, 133 },
      -1,
   } },

   /* ('sdot_2x16_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_2x16_iadd', 'a', 'b', 0), 'c') */
   /* search132_0 -> 271 in the cache */
   /* search132_1 -> 33 in the cache */
   /* search132_2 -> 332 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd_sat,
      0, 1,
      { 271, 33, 332 },
      -1,
   } },

   /* replace132_0_0 -> 16 in the cache */
   /* replace132_0_1 -> 36 in the cache */
   /* replace132_0_2 -> 120 in the cache */
   /* replace132_0 -> 343 in the cache */
   /* replace132_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 2,
      { 343, 133 },
      -1,
   } },

   /* ('udot_2x16_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_2x16_uadd', 'a', 'b', 0), 'c') */
   /* search133_0 -> 271 in the cache */
   /* search133_1 -> 33 in the cache */
   /* search133_2 -> 332 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd_sat,
      0, 1,
      { 271, 33, 332 },
      -1,
   } },

   /* replace133_0_0 -> 16 in the cache */
   /* replace133_0_1 -> 36 in the cache */
   /* replace133_0_2 -> 120 in the cache */
   /* replace133_0 -> 346 in the cache */
   /* replace133_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_uadd_sat,
      0, 2,
      { 346, 133 },
      -1,
   } },

   /* ('fmul@32', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', 'a', 'b') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search134_0_0_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      nir_op_feq,
      1, 1,
      { 358, 117 },
      -1,
   } },
   /* search134_0_1 -> 117 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 359, 117, 360 },
      -1,
   } },
   /* search134_1_0_0 -> 360 in the cache */
   /* search134_1_0_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      nir_op_feq,
      2, 1,
      { 360, 117 },
      -1,
   } },
   /* search134_1_1 -> 117 in the cache */
   /* search134_1_2 -> 358 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 362, 117, 358 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 361, 363 },
      -1,
   } },

   /* replace134_0 -> 360 in the cache */
   /* replace134_1 -> 358 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 360, 358 },
      -1,
   } },

   /* ('fmul@32', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', 'a', 'b') */
   /* search135_0 -> 16 in the cache */
   /* search135_1_0_0 -> 16 in the cache */
   /* search135_1_0_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      nir_op_feq,
      1, 1,
      { 16, 117 },
      -1,
   } },
   /* search135_1_1 -> 117 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      6,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 366, 117, 367 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 2,
      { 16, 368 },
      -1,
   } },

   /* replace135_0 -> 16 in the cache */
   /* replace135_1 -> 36 in the cache */
   /* replace135 -> 254 in the cache */

   /* ('ffma@32', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', 'a', 'b', 'c') */
   /* search136_0_0_0 -> 358 in the cache */
   /* search136_0_0_1 -> 117 in the cache */
   /* search136_0_0 -> 359 in the cache */
   /* search136_0_1 -> 117 in the cache */
   /* search136_0_2 -> 360 in the cache */
   /* search136_0 -> 361 in the cache */
   /* search136_1_0_0 -> 360 in the cache */
   /* search136_1_0_1 -> 117 in the cache */
   /* search136_1_0 -> 362 in the cache */
   /* search136_1_1 -> 117 in the cache */
   /* search136_1_2 -> 358 in the cache */
   /* search136_1 -> 363 in the cache */
   /* search136_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 361, 363, 133 },
      -1,
   } },

   /* replace136_0 -> 360 in the cache */
   /* replace136_1 -> 358 in the cache */
   /* replace136_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 360, 358, 133 },
      -1,
   } },

   /* ('ffma@32', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', 'a', 'b', 'c') */
   /* search137_0 -> 16 in the cache */
   /* search137_1_0_0 -> 16 in the cache */
   /* search137_1_0_1 -> 117 in the cache */
   /* search137_1_0 -> 366 in the cache */
   /* search137_1_1 -> 117 in the cache */
   /* search137_1_2 -> 367 in the cache */
   /* search137_1 -> 368 in the cache */
   /* search137_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 16, 368, 133 },
      -1,
   } },

   /* replace137_0 -> 16 in the cache */
   /* replace137_1 -> 36 in the cache */
   /* replace137_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 16, 36, 133 },
      -1,
   } },

   /* ('sdot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_i8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_i8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_i8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_i8', 'b', 3)))), 'c') */
   /* search138_0 -> 16 in the cache */
   /* search138_1 -> 36 in the cache */
   /* search138_2 -> 133 in the cache */
   /* search138 -> 316 in the cache */

   /* replace138_0_0_0_0_0 -> 16 in the cache */
   /* replace138_0_0_0_0_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 16, 120 },
      -1,
   } },
   /* replace138_0_0_0_1_0 -> 36 in the cache */
   /* replace138_0_0_0_1_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 36, 120 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 374, 375 },
      -1,
   } },
   /* replace138_0_0_1_0_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x1 /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 16, 377 },
      -1,
   } },
   /* replace138_0_0_1_1_0 -> 36 in the cache */
   /* replace138_0_0_1_1_1 -> 377 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 36, 377 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      4, 1,
      { 378, 379 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      2, 3,
      { 376, 380 },
      -1,
   } },
   /* replace138_0_1_0_0_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x2 /* 2 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 16, 382 },
      -1,
   } },
   /* replace138_0_1_0_1_0 -> 36 in the cache */
   /* replace138_0_1_0_1_1 -> 382 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 36, 382 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      6, 1,
      { 383, 384 },
      -1,
   } },
   /* replace138_0_1_1_0_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3 /* 3 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 16, 386 },
      -1,
   } },
   /* replace138_0_1_1_1_0 -> 36 in the cache */
   /* replace138_0_1_1_1_1 -> 386 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 36, 386 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      7, 1,
      { 387, 388 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      5, 3,
      { 385, 389 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 7,
      { 381, 390 },
      -1,
   } },
   /* replace138_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 8,
      { 391, 133 },
      -1,
   } },

   /* ('udot_4x8_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_u8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_u8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_u8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_u8', 'a', 3), ('extract_u8', 'b', 3)))), 'c') */
   /* search139_0 -> 16 in the cache */
   /* search139_1 -> 36 in the cache */
   /* search139_2 -> 133 in the cache */
   /* search139 -> 319 in the cache */

   /* replace139_0_0_0_0_0 -> 16 in the cache */
   /* replace139_0_0_0_0_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 16, 120 },
      -1,
   } },
   /* replace139_0_0_0_1_0 -> 36 in the cache */
   /* replace139_0_0_0_1_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 36, 120 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 393, 394 },
      -1,
   } },
   /* replace139_0_0_1_0_0 -> 16 in the cache */
   /* replace139_0_0_1_0_1 -> 377 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 16, 377 },
      -1,
   } },
   /* replace139_0_0_1_1_0 -> 36 in the cache */
   /* replace139_0_0_1_1_1 -> 377 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 36, 377 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      4, 1,
      { 396, 397 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      2, 3,
      { 395, 398 },
      -1,
   } },
   /* replace139_0_1_0_0_0 -> 16 in the cache */
   /* replace139_0_1_0_0_1 -> 382 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 16, 382 },
      -1,
   } },
   /* replace139_0_1_0_1_0 -> 36 in the cache */
   /* replace139_0_1_0_1_1 -> 382 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 36, 382 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      6, 1,
      { 400, 401 },
      -1,
   } },
   /* replace139_0_1_1_0_0 -> 16 in the cache */
   /* replace139_0_1_1_0_1 -> 386 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 16, 386 },
      -1,
   } },
   /* replace139_0_1_1_1_0 -> 36 in the cache */
   /* replace139_0_1_1_1_1 -> 386 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 36, 386 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      7, 1,
      { 403, 404 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      5, 3,
      { 402, 405 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 7,
      { 399, 406 },
      -1,
   } },
   /* replace139_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 8,
      { 407, 133 },
      -1,
   } },

   /* ('sudot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_u8', 'b', 3)))), 'c') */
   /* search140_0 -> 16 in the cache */
   /* search140_1 -> 36 in the cache */
   /* search140_2 -> 133 in the cache */
   /* search140 -> 322 in the cache */

   /* replace140_0_0_0_0_0 -> 16 in the cache */
   /* replace140_0_0_0_0_1 -> 120 in the cache */
   /* replace140_0_0_0_0 -> 374 in the cache */
   /* replace140_0_0_0_1_0 -> 36 in the cache */
   /* replace140_0_0_0_1_1 -> 120 in the cache */
   /* replace140_0_0_0_1 -> 394 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 374, 394 },
      -1,
   } },
   /* replace140_0_0_1_0_0 -> 16 in the cache */
   /* replace140_0_0_1_0_1 -> 377 in the cache */
   /* replace140_0_0_1_0 -> 378 in the cache */
   /* replace140_0_0_1_1_0 -> 36 in the cache */
   /* replace140_0_0_1_1_1 -> 377 in the cache */
   /* replace140_0_0_1_1 -> 397 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      4, 1,
      { 378, 397 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      2, 3,
      { 409, 410 },
      -1,
   } },
   /* replace140_0_1_0_0_0 -> 16 in the cache */
   /* replace140_0_1_0_0_1 -> 382 in the cache */
   /* replace140_0_1_0_0 -> 383 in the cache */
   /* replace140_0_1_0_1_0 -> 36 in the cache */
   /* replace140_0_1_0_1_1 -> 382 in the cache */
   /* replace140_0_1_0_1 -> 401 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      6, 1,
      { 383, 401 },
      -1,
   } },
   /* replace140_0_1_1_0_0 -> 16 in the cache */
   /* replace140_0_1_1_0_1 -> 386 in the cache */
   /* replace140_0_1_1_0 -> 387 in the cache */
   /* replace140_0_1_1_1_0 -> 36 in the cache */
   /* replace140_0_1_1_1_1 -> 386 in the cache */
   /* replace140_0_1_1_1 -> 404 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      7, 1,
      { 387, 404 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      5, 3,
      { 412, 413 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 7,
      { 411, 414 },
      -1,
   } },
   /* replace140_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 8,
      { 415, 133 },
      -1,
   } },

   /* ('sdot_2x16_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c') */
   /* search141_0 -> 16 in the cache */
   /* search141_1 -> 36 in the cache */
   /* search141_2 -> 133 in the cache */
   /* search141 -> 328 in the cache */

   /* replace141_0_0_0_0 -> 16 in the cache */
   /* replace141_0_0_0_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 16, 120 },
      -1,
   } },
   /* replace141_0_0_1_0 -> 36 in the cache */
   /* replace141_0_0_1_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 36, 120 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      2, 1,
      { 417, 418 },
      -1,
   } },
   /* replace141_0_1_0_0 -> 16 in the cache */
   /* replace141_0_1_0_1 -> 377 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 16, 377 },
      -1,
   } },
   /* replace141_0_1_1_0 -> 36 in the cache */
   /* replace141_0_1_1_1 -> 377 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 36, 377 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 420, 421 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 419, 422 },
      -1,
   } },
   /* replace141_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 4,
      { 423, 133 },
      -1,
   } },

   /* ('udot_2x16_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c') */
   /* search142_0 -> 16 in the cache */
   /* search142_1 -> 36 in the cache */
   /* search142_2 -> 133 in the cache */
   /* search142 -> 331 in the cache */

   /* replace142_0_0_0_0 -> 16 in the cache */
   /* replace142_0_0_0_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 16, 120 },
      -1,
   } },
   /* replace142_0_0_1_0 -> 36 in the cache */
   /* replace142_0_0_1_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 36, 120 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      2, 1,
      { 425, 426 },
      -1,
   } },
   /* replace142_0_1_0_0 -> 16 in the cache */
   /* replace142_0_1_0_1 -> 377 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 16, 377 },
      -1,
   } },
   /* replace142_0_1_1_0 -> 36 in the cache */
   /* replace142_0_1_1_1 -> 377 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 36, 377 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 428, 429 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 427, 430 },
      -1,
   } },
   /* replace142_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 4,
      { 431, 133 },
      -1,
   } },

   /* ('udot_4x8_uadd_sat', 'a', 'b', '#c(is_ult_0xfffc07fc)') => ('udot_4x8_uadd', 'a', 'b', 'c') */
   /* search143_0 -> 16 in the cache */
   /* search143_1 -> 36 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      true,
      nir_type_invalid,
      7,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 16, 36, 433 },
      -1,
   } },

   /* replace143_0 -> 16 in the cache */
   /* replace143_1 -> 36 in the cache */
   /* replace143_2 -> 133 in the cache */
   /* replace143 -> 319 in the cache */

   /* ('udot_4x8_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('iadd', ('iadd', ('imul', ('extract_u8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_u8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_u8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_u8', 'a', 3), ('extract_u8', 'b', 3)))), 'c') */
   /* search144_0 -> 16 in the cache */
   /* search144_1 -> 36 in the cache */
   /* search144_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 16, 36, 133 },
      -1,
   } },

   /* replace144_0_0_0_0_0 -> 16 in the cache */
   /* replace144_0_0_0_0_1 -> 120 in the cache */
   /* replace144_0_0_0_0 -> 393 in the cache */
   /* replace144_0_0_0_1_0 -> 36 in the cache */
   /* replace144_0_0_0_1_1 -> 120 in the cache */
   /* replace144_0_0_0_1 -> 394 in the cache */
   /* replace144_0_0_0 -> 395 in the cache */
   /* replace144_0_0_1_0_0 -> 16 in the cache */
   /* replace144_0_0_1_0_1 -> 377 in the cache */
   /* replace144_0_0_1_0 -> 396 in the cache */
   /* replace144_0_0_1_1_0 -> 36 in the cache */
   /* replace144_0_0_1_1_1 -> 377 in the cache */
   /* replace144_0_0_1_1 -> 397 in the cache */
   /* replace144_0_0_1 -> 398 in the cache */
   /* replace144_0_0 -> 399 in the cache */
   /* replace144_0_1_0_0_0 -> 16 in the cache */
   /* replace144_0_1_0_0_1 -> 382 in the cache */
   /* replace144_0_1_0_0 -> 400 in the cache */
   /* replace144_0_1_0_1_0 -> 36 in the cache */
   /* replace144_0_1_0_1_1 -> 382 in the cache */
   /* replace144_0_1_0_1 -> 401 in the cache */
   /* replace144_0_1_0 -> 402 in the cache */
   /* replace144_0_1_1_0_0 -> 16 in the cache */
   /* replace144_0_1_1_0_1 -> 386 in the cache */
   /* replace144_0_1_1_0 -> 403 in the cache */
   /* replace144_0_1_1_1_0 -> 36 in the cache */
   /* replace144_0_1_1_1_1 -> 386 in the cache */
   /* replace144_0_1_1_1 -> 404 in the cache */
   /* replace144_0_1_1 -> 405 in the cache */
   /* replace144_0_1 -> 406 in the cache */
   /* replace144_0 -> 407 in the cache */
   /* replace144_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_uadd_sat,
      0, 8,
      { 407, 133 },
      -1,
   } },

   /* ('sdot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_i8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_i8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_i8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_i8', 'b', 3)))), 'c') */
   /* search145_0 -> 16 in the cache */
   /* search145_1 -> 36 in the cache */
   /* search145_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_4x8_iadd_sat,
      0, 1,
      { 16, 36, 133 },
      -1,
   } },

   /* replace145_0_0_0_0_0 -> 16 in the cache */
   /* replace145_0_0_0_0_1 -> 120 in the cache */
   /* replace145_0_0_0_0 -> 374 in the cache */
   /* replace145_0_0_0_1_0 -> 36 in the cache */
   /* replace145_0_0_0_1_1 -> 120 in the cache */
   /* replace145_0_0_0_1 -> 375 in the cache */
   /* replace145_0_0_0 -> 376 in the cache */
   /* replace145_0_0_1_0_0 -> 16 in the cache */
   /* replace145_0_0_1_0_1 -> 377 in the cache */
   /* replace145_0_0_1_0 -> 378 in the cache */
   /* replace145_0_0_1_1_0 -> 36 in the cache */
   /* replace145_0_0_1_1_1 -> 377 in the cache */
   /* replace145_0_0_1_1 -> 379 in the cache */
   /* replace145_0_0_1 -> 380 in the cache */
   /* replace145_0_0 -> 381 in the cache */
   /* replace145_0_1_0_0_0 -> 16 in the cache */
   /* replace145_0_1_0_0_1 -> 382 in the cache */
   /* replace145_0_1_0_0 -> 383 in the cache */
   /* replace145_0_1_0_1_0 -> 36 in the cache */
   /* replace145_0_1_0_1_1 -> 382 in the cache */
   /* replace145_0_1_0_1 -> 384 in the cache */
   /* replace145_0_1_0 -> 385 in the cache */
   /* replace145_0_1_1_0_0 -> 16 in the cache */
   /* replace145_0_1_1_0_1 -> 386 in the cache */
   /* replace145_0_1_1_0 -> 387 in the cache */
   /* replace145_0_1_1_1_0 -> 36 in the cache */
   /* replace145_0_1_1_1_1 -> 386 in the cache */
   /* replace145_0_1_1_1 -> 388 in the cache */
   /* replace145_0_1_1 -> 389 in the cache */
   /* replace145_0_1 -> 390 in the cache */
   /* replace145_0 -> 391 in the cache */
   /* replace145_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 8,
      { 391, 133 },
      -1,
   } },

   /* ('sudot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_u8', 'b', 3)))), 'c') */
   /* search146_0 -> 16 in the cache */
   /* search146_1 -> 36 in the cache */
   /* search146_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 16, 36, 133 },
      -1,
   } },

   /* replace146_0_0_0_0_0 -> 16 in the cache */
   /* replace146_0_0_0_0_1 -> 120 in the cache */
   /* replace146_0_0_0_0 -> 374 in the cache */
   /* replace146_0_0_0_1_0 -> 36 in the cache */
   /* replace146_0_0_0_1_1 -> 120 in the cache */
   /* replace146_0_0_0_1 -> 394 in the cache */
   /* replace146_0_0_0 -> 409 in the cache */
   /* replace146_0_0_1_0_0 -> 16 in the cache */
   /* replace146_0_0_1_0_1 -> 377 in the cache */
   /* replace146_0_0_1_0 -> 378 in the cache */
   /* replace146_0_0_1_1_0 -> 36 in the cache */
   /* replace146_0_0_1_1_1 -> 377 in the cache */
   /* replace146_0_0_1_1 -> 397 in the cache */
   /* replace146_0_0_1 -> 410 in the cache */
   /* replace146_0_0 -> 411 in the cache */
   /* replace146_0_1_0_0_0 -> 16 in the cache */
   /* replace146_0_1_0_0_1 -> 382 in the cache */
   /* replace146_0_1_0_0 -> 383 in the cache */
   /* replace146_0_1_0_1_0 -> 36 in the cache */
   /* replace146_0_1_0_1_1 -> 382 in the cache */
   /* replace146_0_1_0_1 -> 401 in the cache */
   /* replace146_0_1_0 -> 412 in the cache */
   /* replace146_0_1_1_0_0 -> 16 in the cache */
   /* replace146_0_1_1_0_1 -> 386 in the cache */
   /* replace146_0_1_1_0 -> 387 in the cache */
   /* replace146_0_1_1_1_0 -> 36 in the cache */
   /* replace146_0_1_1_1_1 -> 386 in the cache */
   /* replace146_0_1_1_1 -> 404 in the cache */
   /* replace146_0_1_1 -> 413 in the cache */
   /* replace146_0_1 -> 414 in the cache */
   /* replace146_0 -> 415 in the cache */
   /* replace146_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 8,
      { 415, 133 },
      -1,
   } },

   /* ('udot_2x16_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c') */
   /* search147_0 -> 16 in the cache */
   /* search147_1 -> 36 in the cache */
   /* search147_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_udot_2x16_uadd_sat,
      0, 1,
      { 16, 36, 133 },
      -1,
   } },

   /* replace147_0_0_0_0 -> 16 in the cache */
   /* replace147_0_0_0_1 -> 120 in the cache */
   /* replace147_0_0_0 -> 425 in the cache */
   /* replace147_0_0_1_0 -> 36 in the cache */
   /* replace147_0_0_1_1 -> 120 in the cache */
   /* replace147_0_0_1 -> 426 in the cache */
   /* replace147_0_0 -> 427 in the cache */
   /* replace147_0_1_0_0 -> 16 in the cache */
   /* replace147_0_1_0_1 -> 377 in the cache */
   /* replace147_0_1_0 -> 428 in the cache */
   /* replace147_0_1_1_0 -> 36 in the cache */
   /* replace147_0_1_1_1 -> 377 in the cache */
   /* replace147_0_1_1 -> 429 in the cache */
   /* replace147_0_1 -> 430 in the cache */
   /* replace147_0 -> 431 in the cache */
   /* replace147_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_uadd_sat,
      0, 4,
      { 431, 133 },
      -1,
   } },

   /* ('sdot_2x16_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c') */
   /* search148_0 -> 16 in the cache */
   /* search148_1 -> 36 in the cache */
   /* search148_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sdot_2x16_iadd_sat,
      0, 1,
      { 16, 36, 133 },
      -1,
   } },

   /* replace148_0_0_0_0 -> 16 in the cache */
   /* replace148_0_0_0_1 -> 120 in the cache */
   /* replace148_0_0_0 -> 417 in the cache */
   /* replace148_0_0_1_0 -> 36 in the cache */
   /* replace148_0_0_1_1 -> 120 in the cache */
   /* replace148_0_0_1 -> 418 in the cache */
   /* replace148_0_0 -> 419 in the cache */
   /* replace148_0_1_0_0 -> 16 in the cache */
   /* replace148_0_1_0_1 -> 377 in the cache */
   /* replace148_0_1_0 -> 420 in the cache */
   /* replace148_0_1_1_0 -> 36 in the cache */
   /* replace148_0_1_1_1 -> 377 in the cache */
   /* replace148_0_1_1 -> 421 in the cache */
   /* replace148_0_1 -> 422 in the cache */
   /* replace148_0 -> 423 in the cache */
   /* replace148_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd_sat,
      0, 4,
      { 423, 133 },
      -1,
   } },

   /* ('~flrp@16', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a') */
   /* search149_0 -> 11 in the cache */
   /* search149_1 -> 243 in the cache */
   { .variable = {
      { nir_search_value_variable, 1 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 445 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 11, 243, 446 },
      -1,
   } },

   /* replace149_0 -> 445 in the cache */
   /* replace149_1 -> 243 in the cache */
   /* replace149_2 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 445, 243, 11 },
      -1,
   } },

   /* ('~flrp@16', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search150_0 -> 11 in the cache */
   /* search150_1_0 -> 11 in the cache */
   /* search150_1_1 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 11, 243 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 16 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 11, 449, 450 },
      -1,
   } },

   /* replace150_0_0 -> 243 in the cache */
   /* replace150_0_1 -> 450 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 243, 450 },
      -1,
   } },
   /* replace150_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 452, 11 },
      -1,
   } },

   /* ('~flrp@16', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search151_0_0 -> 11 in the cache */
   /* search151_0_1 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 11, 243 },
      0,
   } },
   /* search151_1_0 -> 11 in the cache */
   /* search151_1_1 -> 450 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 11, 450 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, 16 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 2,
      { 454, 455, 456 },
      -1,
   } },

   /* replace151_0_0 -> 243 in the cache */
   /* replace151_0_1 -> 450 in the cache */
   /* replace151_0_2 -> 456 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 243, 450, 456 },
      -1,
   } },
   /* replace151_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 458, 11 },
      -1,
   } },

   /* ('~flrp@16', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a') */
   /* search152_0 -> 11 in the cache */
   /* search152_1_0 -> 11 in the cache */
   /* search152_1_1 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 11, 243 },
      0,
   } },
   /* search152_2 -> 450 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 11, 460, 450 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
   } },
   /* replace152_0_1 -> 243 in the cache */
   /* replace152_0_2 -> 450 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 462, 243, 450 },
      -1,
   } },
   /* replace152_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 463, 11 },
      -1,
   } },

   /* ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c') */
   /* search153_0_0 -> 11 in the cache */
   /* search153_0_1_0 -> 462 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 465 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 462, 466 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 11, 467 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 16 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search153_1_1 -> 465 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 469, 465 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 468, 470 },
      -1,
   } },

   /* replace153_0 -> 11 in the cache */
   /* replace153_1 -> 469 in the cache */
   /* replace153_2 -> 465 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 11, 469, 465 },
      -1,
   } },

   /* ('~fadd@16', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c')) */
   /* search154_0_0 -> 11 in the cache */
   /* search154_0_1_0_0 -> 462 in the cache */
   /* search154_0_1_0_1_0 -> 465 in the cache */
   /* search154_0_1_0_1 -> 466 in the cache */
   /* search154_0_1_0 -> 467 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 467 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 11, 473 },
      -1,
   } },
   /* search154_1_0 -> 469 in the cache */
   /* search154_1_1_0 -> 465 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 465 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 469, 475 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 474, 476 },
      -1,
   } },

   /* replace154_0 -> 11 in the cache */
   /* replace154_1 -> 469 in the cache */
   /* replace154_2_0 -> 465 in the cache */
   /* replace154_2 -> 475 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 11, 469, 475 },
      -1,
   } },

   /* ('~fadd@16', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c') */
   /* search155_0 -> 11 in the cache */
   /* search155_1_0 -> 465 in the cache */
   /* search155_1_1_0 -> 469 in the cache */
   /* search155_1_1_1_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 469, 479 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 465, 480 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 11, 481 },
      -1,
   } },

   /* replace155_0 -> 11 in the cache */
   /* replace155_1 -> 469 in the cache */
   /* replace155_2 -> 465 in the cache */
   /* replace155 -> 472 in the cache */

   /* ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a') */
   /* search156_0_0 -> 11 in the cache */
   /* search156_0_1_0 -> 462 in the cache */
   { .variable = {
      { nir_search_value_variable, 1 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 483 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 484 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 462, 485 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 11, 486 },
      -1,
   } },
   /* search156_1_0 -> 469 in the cache */
   /* search156_1_1_0 -> 483 in the cache */
   /* search156_1_1 -> 484 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 469, 484 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 487, 488 },
      -1,
   } },

   /* replace156_0 -> 483 in the cache */
   /* replace156_1 -> 469 in the cache */
   /* replace156_2 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 483, 469, 11 },
      -1,
   } },

   /* ('~fadd@16', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a') */
   /* search157_0 -> 11 in the cache */
   /* search157_1_0_0 -> 483 in the cache */
   /* search157_1_0 -> 484 in the cache */
   /* search157_1_1_0 -> 469 in the cache */
   /* search157_1_1_1_0 -> 11 in the cache */
   /* search157_1_1_1 -> 479 in the cache */
   /* search157_1_1 -> 480 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 484, 480 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 11, 491 },
      -1,
   } },

   /* replace157_0 -> 483 in the cache */
   /* replace157_1 -> 469 in the cache */
   /* replace157_2 -> 11 in the cache */
   /* replace157 -> 490 in the cache */

   /* ('~ffma@16', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a') */
   /* search158_0 -> 11 in the cache */
   /* search158_1_0 -> 462 in the cache */
   /* search158_1_1_0_0 -> 483 in the cache */
   /* search158_1_1_0 -> 484 in the cache */
   /* search158_1_1 -> 485 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 462, 485 },
      -1,
   } },
   /* search158_2_0 -> 469 in the cache */
   /* search158_2_1_0 -> 483 in the cache */
   /* search158_2_1 -> 484 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 469, 484 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 11, 493, 494 },
      -1,
   } },

   /* replace158_0 -> 483 in the cache */
   /* replace158_1 -> 469 in the cache */
   /* replace158_2 -> 11 in the cache */
   /* replace158 -> 490 in the cache */

   /* ('~ffma@16', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, 16 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search159_1_0 -> 483 in the cache */
   /* search159_1 -> 484 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      2, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 497 },
      -1,
   } },
   /* search159_2_1_0 -> 483 in the cache */
   /* search159_2_1 -> 484 in the cache */
   /* search159_2_2 -> 497 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 498, 484, 497 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 496, 484, 499 },
      -1,
   } },

   /* replace159_0 -> 483 in the cache */
   /* replace159_1 -> 496 in the cache */
   /* replace159_2 -> 497 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 483, 496, 497 },
      -1,
   } },

   /* ('~ffma@16', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, 1 },
      0, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 502 },
      -1,
   } },
   /* search160_1_0 -> 243 in the cache */
   /* search160_1_1_0 -> 497 in the cache */
   /* search160_1_1 -> 498 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 243, 498 },
      -1,
   } },
   /* search160_2 -> 497 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 503, 504, 497 },
      -1,
   } },

   /* replace160_0 -> 502 in the cache */
   /* replace160_1 -> 243 in the cache */
   /* replace160_2 -> 497 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 502, 243, 497 },
      -1,
   } },

   /* ('~ffma@16', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b')) */
   /* search161_0_0 -> 502 in the cache */
   /* search161_0 -> 503 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 507 },
      -1,
   } },
   /* search161_1_1 -> 469 in the cache */
   /* search161_1_2 -> 456 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 508, 469, 456 },
      -1,
   } },
   /* search161_2_0 -> 507 in the cache */
   /* search161_2_1 -> 469 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 507, 469 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 503, 509, 510 },
      -1,
   } },

   /* replace161_0 -> 502 in the cache */
   /* replace161_1 -> 456 in the cache */
   /* replace161_2_0 -> 507 in the cache */
   /* replace161_2_1 -> 469 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 507, 469 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 502, 456, 512 },
      -1,
   } },

   /* ('~fadd@16', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a') */
   /* search162_0 -> 462 in the cache */
   /* search162_1_0_0_0 -> 462 in the cache */
   /* search162_1_0_0_1_0 -> 11 in the cache */
   /* search162_1_0_0_1 -> 479 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 462, 479 },
      -1,
   } },
   /* search162_1_0_1_0 -> 462 in the cache */
   /* search162_1_0_1_1_0 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 243 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      3, 1,
      { 462, 515 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 3,
      { 514, 516 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 3,
      { 517 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 462, 518 },
      -1,
   } },

   /* replace162_0 -> 243 in the cache */
   /* replace162_1 -> 462 in the cache */
   /* replace162_2 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 243, 462, 11 },
      -1,
   } },

   /* ('~flrp@32', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a') */
   /* search163_0 -> 16 in the cache */
   /* search163_1 -> 36 in the cache */
   /* search163_2_0 -> 445 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 445 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 16, 36, 521 },
      -1,
   } },

   /* replace163_0 -> 445 in the cache */
   /* replace163_1 -> 36 in the cache */
   /* replace163_2 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 445, 36, 16 },
      -1,
   } },

   /* ('~flrp@32', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search164_0 -> 16 in the cache */
   /* search164_1_0 -> 16 in the cache */
   /* search164_1_1 -> 36 in the cache */
   /* search164_1 -> 259 in the cache */
   /* search164_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 16, 259, 133 },
      -1,
   } },

   /* replace164_0_0 -> 36 in the cache */
   /* replace164_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 36, 133 },
      -1,
   } },
   /* replace164_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 525, 16 },
      -1,
   } },

   /* ('~flrp@32', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search165_0_0 -> 16 in the cache */
   /* search165_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 16, 36 },
      0,
   } },
   /* search165_1_0 -> 16 in the cache */
   /* search165_1_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 16, 133 },
      0,
   } },
   /* search165_2 -> 161 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 2,
      { 527, 528, 161 },
      -1,
   } },

   /* replace165_0_0 -> 36 in the cache */
   /* replace165_0_1 -> 133 in the cache */
   /* replace165_0_2 -> 161 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 36, 133, 161 },
      -1,
   } },
   /* replace165_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 530, 16 },
      -1,
   } },

   /* ('~flrp@32', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a') */
   /* search166_0 -> 16 in the cache */
   /* search166_1_0 -> 16 in the cache */
   /* search166_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 16, 36 },
      0,
   } },
   /* search166_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 16, 532, 133 },
      -1,
   } },

   /* replace166_0_0 -> 228 in the cache */
   /* replace166_0_1 -> 36 in the cache */
   /* replace166_0_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 228, 36, 133 },
      -1,
   } },
   /* replace166_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 534, 16 },
      -1,
   } },

   /* ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c') */
   /* search167_0_0 -> 16 in the cache */
   /* search167_0_1_0 -> 228 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 536 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 228, 537 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 16, 538 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search167_1_1 -> 536 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 540, 536 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 539, 541 },
      -1,
   } },

   /* replace167_0 -> 16 in the cache */
   /* replace167_1 -> 540 in the cache */
   /* replace167_2 -> 536 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 16, 540, 536 },
      -1,
   } },

   /* ('~fadd@32', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c')) */
   /* search168_0_0 -> 16 in the cache */
   /* search168_0_1_0_0 -> 228 in the cache */
   /* search168_0_1_0_1_0 -> 536 in the cache */
   /* search168_0_1_0_1 -> 537 in the cache */
   /* search168_0_1_0 -> 538 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 538 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 16, 544 },
      -1,
   } },
   /* search168_1_0 -> 540 in the cache */
   /* search168_1_1_0 -> 536 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 536 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 540, 546 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 545, 547 },
      -1,
   } },

   /* replace168_0 -> 16 in the cache */
   /* replace168_1 -> 540 in the cache */
   /* replace168_2_0 -> 536 in the cache */
   /* replace168_2 -> 546 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 16, 540, 546 },
      -1,
   } },

   /* ('~fadd@32', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c') */
   /* search169_0 -> 16 in the cache */
   /* search169_1_0 -> 536 in the cache */
   /* search169_1_1_0 -> 540 in the cache */
   /* search169_1_1_1_0 -> 16 in the cache */
   /* search169_1_1_1 -> 265 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 540, 265 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 536, 550 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 16, 551 },
      -1,
   } },

   /* replace169_0 -> 16 in the cache */
   /* replace169_1 -> 540 in the cache */
   /* replace169_2 -> 536 in the cache */
   /* replace169 -> 543 in the cache */

   /* ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a') */
   /* search170_0_0 -> 16 in the cache */
   /* search170_0_1_0 -> 228 in the cache */
   /* search170_0_1_1_0_0 -> 483 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 483 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 553 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 228, 554 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 16, 555 },
      -1,
   } },
   /* search170_1_0 -> 540 in the cache */
   /* search170_1_1_0 -> 483 in the cache */
   /* search170_1_1 -> 553 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 540, 553 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 556, 557 },
      -1,
   } },

   /* replace170_0 -> 483 in the cache */
   /* replace170_1 -> 540 in the cache */
   /* replace170_2 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 483, 540, 16 },
      -1,
   } },

   /* ('~fadd@32', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a') */
   /* search171_0 -> 16 in the cache */
   /* search171_1_0_0 -> 483 in the cache */
   /* search171_1_0 -> 553 in the cache */
   /* search171_1_1_0 -> 540 in the cache */
   /* search171_1_1_1_0 -> 16 in the cache */
   /* search171_1_1_1 -> 265 in the cache */
   /* search171_1_1 -> 550 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 553, 550 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 16, 560 },
      -1,
   } },

   /* replace171_0 -> 483 in the cache */
   /* replace171_1 -> 540 in the cache */
   /* replace171_2 -> 16 in the cache */
   /* replace171 -> 559 in the cache */

   /* ('~ffma@32', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a') */
   /* search172_0 -> 16 in the cache */
   /* search172_1_0 -> 228 in the cache */
   /* search172_1_1_0_0 -> 483 in the cache */
   /* search172_1_1_0 -> 553 in the cache */
   /* search172_1_1 -> 554 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 228, 554 },
      -1,
   } },
   /* search172_2_0 -> 540 in the cache */
   /* search172_2_1_0 -> 483 in the cache */
   /* search172_2_1 -> 553 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 540, 553 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 16, 562, 563 },
      -1,
   } },

   /* replace172_0 -> 483 in the cache */
   /* replace172_1 -> 540 in the cache */
   /* replace172_2 -> 16 in the cache */
   /* replace172 -> 559 in the cache */

   /* ('~ffma@32', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a') */
   /* search173_0 -> 358 in the cache */
   /* search173_1_0 -> 483 in the cache */
   /* search173_1 -> 553 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 565 },
      -1,
   } },
   /* search173_2_1_0 -> 483 in the cache */
   /* search173_2_1 -> 553 in the cache */
   /* search173_2_2 -> 565 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 566, 553, 565 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 358, 553, 567 },
      -1,
   } },

   /* replace173_0 -> 483 in the cache */
   /* replace173_1 -> 358 in the cache */
   /* replace173_2 -> 565 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 483, 358, 565 },
      -1,
   } },

   /* ('~ffma@32', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a') */
   /* search174_0_0 -> 502 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 502 },
      -1,
   } },
   /* search174_1_0 -> 36 in the cache */
   /* search174_1_1_0 -> 565 in the cache */
   /* search174_1_1 -> 566 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 36, 566 },
      -1,
   } },
   /* search174_2 -> 565 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 570, 571, 565 },
      -1,
   } },

   /* replace174_0 -> 502 in the cache */
   /* replace174_1 -> 36 in the cache */
   /* replace174_2 -> 565 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 502, 36, 565 },
      -1,
   } },

   /* ('~ffma@32', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b')) */
   /* search175_0_0 -> 502 in the cache */
   /* search175_0 -> 570 in the cache */
   /* search175_1_0_0 -> 360 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 360 },
      -1,
   } },
   /* search175_1_1 -> 540 in the cache */
   /* search175_1_2 -> 161 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 574, 540, 161 },
      -1,
   } },
   /* search175_2_0 -> 360 in the cache */
   /* search175_2_1 -> 540 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 360, 540 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 570, 575, 576 },
      -1,
   } },

   /* replace175_0 -> 502 in the cache */
   /* replace175_1 -> 161 in the cache */
   /* replace175_2_0 -> 360 in the cache */
   /* replace175_2_1 -> 540 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 360, 540 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 502, 161, 578 },
      -1,
   } },

   /* ('~fadd@32', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a') */
   /* search176_0 -> 228 in the cache */
   /* search176_1_0_0_0 -> 228 in the cache */
   /* search176_1_0_0_1_0 -> 16 in the cache */
   /* search176_1_0_0_1 -> 265 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 228, 265 },
      -1,
   } },
   /* search176_1_0_1_0 -> 228 in the cache */
   /* search176_1_0_1_1_0 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      3, 1,
      { 228, 581 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 3,
      { 580, 582 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 3,
      { 583 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 228, 584 },
      -1,
   } },

   /* replace176_0 -> 36 in the cache */
   /* replace176_1 -> 228 in the cache */
   /* replace176_2 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 36, 228, 16 },
      -1,
   } },

   /* ('~flrp@64', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a') */
   /* search177_0 -> 21 in the cache */
   /* search177_1 -> 41 in the cache */
   /* search177_2_0 -> 445 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 445 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 21, 41, 587 },
      -1,
   } },

   /* replace177_0 -> 445 in the cache */
   /* replace177_1 -> 41 in the cache */
   /* replace177_2 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 445, 41, 21 },
      -1,
   } },

   /* ('~flrp@64', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search178_0 -> 21 in the cache */
   /* search178_1_0 -> 21 in the cache */
   /* search178_1_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 21, 41 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 64 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 21, 590, 591 },
      -1,
   } },

   /* replace178_0_0 -> 41 in the cache */
   /* replace178_0_1 -> 591 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 41, 591 },
      -1,
   } },
   /* replace178_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 593, 21 },
      -1,
   } },

   /* ('~flrp@64', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search179_0_0 -> 21 in the cache */
   /* search179_0_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 21, 41 },
      0,
   } },
   /* search179_1_0 -> 21 in the cache */
   /* search179_1_1 -> 591 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 21, 591 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, 64 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 2,
      { 595, 596, 597 },
      -1,
   } },

   /* replace179_0_0 -> 41 in the cache */
   /* replace179_0_1 -> 591 in the cache */
   /* replace179_0_2 -> 597 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 41, 591, 597 },
      -1,
   } },
   /* replace179_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 599, 21 },
      -1,
   } },

   /* ('~flrp@64', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a') */
   /* search180_0 -> 21 in the cache */
   /* search180_1_0 -> 21 in the cache */
   /* search180_1_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 21, 41 },
      0,
   } },
   /* search180_2 -> 591 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 1,
      { 21, 601, 591 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
   } },
   /* replace180_0_1 -> 41 in the cache */
   /* replace180_0_2 -> 591 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 603, 41, 591 },
      -1,
   } },
   /* replace180_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 604, 21 },
      -1,
   } },

   /* ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c') */
   /* search181_0_0 -> 21 in the cache */
   /* search181_0_1_0 -> 603 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 606 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 603, 607 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 21, 608 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 64 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search181_1_1 -> 606 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 610, 606 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 609, 611 },
      -1,
   } },

   /* replace181_0 -> 21 in the cache */
   /* replace181_1 -> 610 in the cache */
   /* replace181_2 -> 606 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 21, 610, 606 },
      -1,
   } },

   /* ('~fadd@64', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c')) */
   /* search182_0_0 -> 21 in the cache */
   /* search182_0_1_0_0 -> 603 in the cache */
   /* search182_0_1_0_1_0 -> 606 in the cache */
   /* search182_0_1_0_1 -> 607 in the cache */
   /* search182_0_1_0 -> 608 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 608 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 21, 614 },
      -1,
   } },
   /* search182_1_0 -> 610 in the cache */
   /* search182_1_1_0 -> 606 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 606 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 610, 616 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 615, 617 },
      -1,
   } },

   /* replace182_0 -> 21 in the cache */
   /* replace182_1 -> 610 in the cache */
   /* replace182_2_0 -> 606 in the cache */
   /* replace182_2 -> 616 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 21, 610, 616 },
      -1,
   } },

   /* ('~fadd@64', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c') */
   /* search183_0 -> 21 in the cache */
   /* search183_1_0 -> 606 in the cache */
   /* search183_1_1_0 -> 610 in the cache */
   /* search183_1_1_1_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 610, 620 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 606, 621 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 21, 622 },
      -1,
   } },

   /* replace183_0 -> 21 in the cache */
   /* replace183_1 -> 610 in the cache */
   /* replace183_2 -> 606 in the cache */
   /* replace183 -> 613 in the cache */

   /* ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a') */
   /* search184_0_0 -> 21 in the cache */
   /* search184_0_1_0 -> 603 in the cache */
   /* search184_0_1_1_0_0 -> 483 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 483 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 624 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 603, 625 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 21, 626 },
      -1,
   } },
   /* search184_1_0 -> 610 in the cache */
   /* search184_1_1_0 -> 483 in the cache */
   /* search184_1_1 -> 624 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 610, 624 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 627, 628 },
      -1,
   } },

   /* replace184_0 -> 483 in the cache */
   /* replace184_1 -> 610 in the cache */
   /* replace184_2 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 483, 610, 21 },
      -1,
   } },

   /* ('~fadd@64', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a') */
   /* search185_0 -> 21 in the cache */
   /* search185_1_0_0 -> 483 in the cache */
   /* search185_1_0 -> 624 in the cache */
   /* search185_1_1_0 -> 610 in the cache */
   /* search185_1_1_1_0 -> 21 in the cache */
   /* search185_1_1_1 -> 620 in the cache */
   /* search185_1_1 -> 621 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 2,
      { 624, 621 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 21, 631 },
      -1,
   } },

   /* replace185_0 -> 483 in the cache */
   /* replace185_1 -> 610 in the cache */
   /* replace185_2 -> 21 in the cache */
   /* replace185 -> 630 in the cache */

   /* ('~ffma@64', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a') */
   /* search186_0 -> 21 in the cache */
   /* search186_1_0 -> 603 in the cache */
   /* search186_1_1_0_0 -> 483 in the cache */
   /* search186_1_1_0 -> 624 in the cache */
   /* search186_1_1 -> 625 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 603, 625 },
      -1,
   } },
   /* search186_2_0 -> 610 in the cache */
   /* search186_2_1_0 -> 483 in the cache */
   /* search186_2_1 -> 624 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 610, 624 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 21, 633, 634 },
      -1,
   } },

   /* replace186_0 -> 483 in the cache */
   /* replace186_1 -> 610 in the cache */
   /* replace186_2 -> 21 in the cache */
   /* replace186 -> 630 in the cache */

   /* ('~ffma@64', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, 64 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search187_1_0 -> 483 in the cache */
   /* search187_1 -> 624 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      2, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 637 },
      -1,
   } },
   /* search187_2_1_0 -> 483 in the cache */
   /* search187_2_1 -> 624 in the cache */
   /* search187_2_2 -> 637 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 638, 624, 637 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 636, 624, 639 },
      -1,
   } },

   /* replace187_0 -> 483 in the cache */
   /* replace187_1 -> 636 in the cache */
   /* replace187_2 -> 637 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 483, 636, 637 },
      -1,
   } },

   /* ('~ffma@64', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a') */
   /* search188_0_0 -> 502 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 502 },
      -1,
   } },
   /* search188_1_0 -> 41 in the cache */
   /* search188_1_1_0 -> 637 in the cache */
   /* search188_1_1 -> 638 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 41, 638 },
      -1,
   } },
   /* search188_2 -> 637 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 2,
      { 642, 643, 637 },
      -1,
   } },

   /* replace188_0 -> 502 in the cache */
   /* replace188_1 -> 41 in the cache */
   /* replace188_2 -> 637 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 502, 41, 637 },
      -1,
   } },

   /* ('~ffma@64', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b')) */
   /* search189_0_0 -> 502 in the cache */
   /* search189_0 -> 642 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 646 },
      -1,
   } },
   /* search189_1_1 -> 610 in the cache */
   /* search189_1_2 -> 597 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 1,
      { 647, 610, 597 },
      -1,
   } },
   /* search189_2_0 -> 646 in the cache */
   /* search189_2_1 -> 610 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 646, 610 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 3,
      { 642, 648, 649 },
      -1,
   } },

   /* replace189_0 -> 502 in the cache */
   /* replace189_1 -> 597 in the cache */
   /* replace189_2_0 -> 646 in the cache */
   /* replace189_2_1 -> 610 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 646, 610 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 502, 597, 651 },
      -1,
   } },

   /* ('~fadd@64', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a') */
   /* search190_0 -> 603 in the cache */
   /* search190_1_0_0_0 -> 603 in the cache */
   /* search190_1_0_0_1_0 -> 21 in the cache */
   /* search190_1_0_0_1 -> 620 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      2, 1,
      { 603, 620 },
      -1,
   } },
   /* search190_1_0_1_0 -> 603 in the cache */
   /* search190_1_0_1_1_0 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 41 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      3, 1,
      { 603, 654 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 3,
      { 653, 655 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 3,
      { 656 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 4,
      { 603, 657 },
      -1,
   } },

   /* replace190_0 -> 41 in the cache */
   /* replace190_1 -> 603 in the cache */
   /* replace190_2 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 41, 603, 21 },
      -1,
   } },

   /* ('~flrp', ('fmul(is_used_once)', 'a', 'b'), ('fmul(is_used_once)', 'a', 'c'), 'd') => ('fmul', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search191_0_0 -> 147 in the cache */
   /* search191_0_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 147, 148 },
      0,
   } },
   /* search191_1_0 -> 147 in the cache */
   /* search191_1_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 147, 150 },
      0,
   } },
   /* search191_2 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 2,
      { 660, 661, 151 },
      -1,
   } },

   /* replace191_0_0 -> 148 in the cache */
   /* replace191_0_1 -> 150 in the cache */
   /* replace191_0_2 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 148, 150, 151 },
      -1,
   } },
   /* replace191_1 -> 147 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 663, 147 },
      -1,
   } },

   /* ('~flrp', 'a', 0.0, 'c') => ('fadd', ('fmul', ('fneg', 'a'), 'c'), 'a') */
   /* search192_0 -> 0 in the cache */
   /* search192_1 -> 241 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_flrp,
      -1, 0,
      { 0, 241, 665 },
      -1,
   } },

   /* replace192_0_0_0 -> 0 in the cache */
   /* replace192_0_0 -> 197 in the cache */
   /* replace192_0_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 197, 665 },
      -1,
   } },
   /* replace192_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 667, 0 },
      -1,
   } },

   /* ('ftrunc', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a'))) */
   /* search193_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ftrunc,
      -1, 0,
      { 32 },
      -1,
   } },

   /* replace193_0_0 -> 32 in the cache */
   /* replace193_0_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 32, 113 },
      -1,
   } },
   /* replace193_1_0_0_0 -> 32 in the cache */
   /* replace193_1_0_0 -> 103 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 103 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 671 },
      -1,
   } },
   /* replace193_2_0_0 -> 32 in the cache */
   /* replace193_2_0 -> 103 in the cache */
   /* replace193_2 -> 671 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 670, 672, 671 },
      -1,
   } },

   /* ('ffloor', 'a') => ('fsub', 'a', ('ffract', 'a')) */
   /* search194_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 32 },
      -1,
   } },

   /* replace194_0 -> 32 in the cache */
   /* replace194_1_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 32, 675 },
      -1,
   } },

   /* ('fadd', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a') */
   /* search195_0 -> 32 in the cache */
   /* search195_1_0_0 -> 32 in the cache */
   /* search195_1_0 -> 675 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 675 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 32, 677 },
      -1,
   } },

   /* replace195_0 -> 32 in the cache */
   /* replace195 -> 674 in the cache */

   /* ('ffract', 'a') => ('fsub', 'a', ('ffloor', 'a')) */
   /* search196_0 -> 32 in the cache */
   /* search196 -> 675 in the cache */

   /* replace196_0 -> 32 in the cache */
   /* replace196_1_0 -> 32 in the cache */
   /* replace196_1 -> 674 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 0,
      { 32, 674 },
      -1,
   } },

   /* ('fceil', 'a') => ('fneg', ('ffloor', ('fneg', 'a'))) */
   /* search197_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fceil,
      -1, 0,
      { 32 },
      -1,
   } },

   /* replace197_0_0_0 -> 32 in the cache */
   /* replace197_0_0 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffloor,
      -1, 0,
      { 98 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 681 },
      -1,
   } },

   /* ('ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search198_0 -> 11 in the cache */
   /* search198_1 -> 243 in the cache */
   /* search198_2 -> 450 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 11, 243, 450 },
      -1,
   } },

   /* replace198_0_0 -> 11 in the cache */
   /* replace198_0_1 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 11, 243 },
      -1,
   } },
   /* replace198_1 -> 450 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 684, 450 },
      -1,
   } },

   /* ('ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search199_0 -> 16 in the cache */
   /* search199_1 -> 36 in the cache */
   /* search199_2 -> 133 in the cache */
   /* search199 -> 219 in the cache */

   /* replace199_0_0 -> 16 in the cache */
   /* replace199_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* replace199_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 686, 133 },
      -1,
   } },

   /* ('ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search200_0 -> 21 in the cache */
   /* search200_1 -> 41 in the cache */
   /* search200_2 -> 591 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 21, 41, 591 },
      -1,
   } },

   /* replace200_0_0 -> 21 in the cache */
   /* replace200_0_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 21, 41 },
      -1,
   } },
   /* replace200_1 -> 591 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 2,
      { 689, 591 },
      -1,
   } },

   /* ('ffmaz', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c') */
   /* search201_0 -> 16 in the cache */
   /* search201_1 -> 36 in the cache */
   /* search201_2 -> 133 in the cache */
   /* search201 -> 373 in the cache */

   /* replace201_0_0 -> 16 in the cache */
   /* replace201_0_1 -> 36 in the cache */
   /* replace201_0 -> 132 in the cache */
   /* replace201_1 -> 133 in the cache */
   /* replace201 -> 273 in the cache */

   /* ('~ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search202_0 -> 11 in the cache */
   /* search202_1 -> 243 in the cache */
   /* search202_2 -> 450 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 11, 243, 450 },
      -1,
   } },

   /* replace202_0_0 -> 11 in the cache */
   /* replace202_0_1 -> 243 in the cache */
   /* replace202_0 -> 684 in the cache */
   /* replace202_1 -> 450 in the cache */
   /* replace202 -> 685 in the cache */

   /* ('~ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search203_0 -> 16 in the cache */
   /* search203_1 -> 36 in the cache */
   /* search203_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 16, 36, 133 },
      -1,
   } },

   /* replace203_0_0 -> 16 in the cache */
   /* replace203_0_1 -> 36 in the cache */
   /* replace203_0 -> 686 in the cache */
   /* replace203_1 -> 133 in the cache */
   /* replace203 -> 687 in the cache */

   /* ('~ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search204_0 -> 21 in the cache */
   /* search204_1 -> 41 in the cache */
   /* search204_2 -> 591 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_ffma,
      0, 1,
      { 21, 41, 591 },
      -1,
   } },

   /* replace204_0_0 -> 21 in the cache */
   /* replace204_0_1 -> 41 in the cache */
   /* replace204_0 -> 689 in the cache */
   /* replace204_1 -> 591 in the cache */
   /* replace204 -> 690 in the cache */

   /* ('~ffmaz', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c') */
   /* search205_0 -> 16 in the cache */
   /* search205_1 -> 36 in the cache */
   /* search205_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_ffmaz,
      0, 1,
      { 16, 36, 133 },
      -1,
   } },

   /* replace205_0_0 -> 16 in the cache */
   /* replace205_0_1 -> 36 in the cache */
   /* replace205_0 -> 132 in the cache */
   /* replace205_1 -> 133 in the cache */
   /* replace205 -> 273 in the cache */

   /* ('~fmul', ('fadd', ('iand', ('ineg', ('b2i', 'a@bool')), ('fmul', 'b', 'c')), '#d'), '#e') => ('bcsel', 'a', ('fmul', ('fadd', ('fmul', 'b', 'c'), 'd'), 'e'), ('fmul', 'd', 'e')) */
   { .variable = {
      { nir_search_value_variable, 1 },
      0, /* a */
      false,
      nir_type_bool,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 0,
      { 695 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 696 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 698, 699 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_iand,
      2, 2,
      { 697, 700 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      3, /* d */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 3,
      { 701, 702 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      4, /* e */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      true,
      false,
      false,
      nir_op_fmul,
      0, 4,
      { 703, 704 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, 1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* replace206_1_0_0_0 -> 698 in the cache */
   /* replace206_1_0_0_1 -> 699 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 698, 699 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 2,
      { 707, 708 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      4, /* e */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 3,
      { 709, 710 },
      -1,
   } },
   /* replace206_2_0 -> 708 in the cache */
   /* replace206_2_1 -> 710 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 1,
      { 708, 710 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 706, 711, 712 },
      -1,
   } },

   /* ('fdph', 'a', 'b') => ('fdot4', ('vec4', 'a.x', 'a.y', 'a.z', 1.0), 'b') */
   /* search207_0 -> 0 in the cache */
   /* search207_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdph,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {1},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {2},
   } },
   /* replace207_0_3 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 715, 716, 717, 255 },
      -1,
   } },
   /* replace207_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 718, 3 },
      -1,
   } },

   /* ('fdot4', ('vec4', 'a', 'b', 'c', 1.0), 'd') => ('fdph', ('vec3', 'a', 'b', 'c'), 'd') */
   /* search208_0_0 -> 147 in the cache */
   /* search208_0_1 -> 148 in the cache */
   /* search208_0_2 -> 150 in the cache */
   { .constant = {
      { nir_search_value_constant, -4 },
      nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 147, 148, 150, 720 },
      -1,
   } },
   /* search208_1 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 721, 151 },
      -1,
   } },

   /* replace208_0_0 -> 147 in the cache */
   /* replace208_0_1 -> 148 in the cache */
   /* replace208_0_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_vec3,
      -1, 0,
      { 147, 148, 150 },
      -1,
   } },
   /* replace208_1 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fdph,
      -1, 0,
      { 723, 151 },
      -1,
   } },

   /* ('fdot4', ('vec4', 'a', 0.0, 0.0, 0.0), 'b') => ('fmul', 'a', 'b') */
   /* search209_0_0 -> 0 in the cache */
   /* search209_0_1 -> 241 in the cache */
   /* search209_0_2 -> 241 in the cache */
   /* search209_0_3 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 0, 241, 241, 241 },
      -1,
   } },
   /* search209_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 725, 3 },
      -1,
   } },

   /* replace209_0 -> 0 in the cache */
   /* replace209_1 -> 3 in the cache */
   /* replace209 -> 249 in the cache */

   /* ('fdot4', ('vec4', 'a', 'b', 0.0, 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c') */
   /* search210_0_0 -> 124 in the cache */
   /* search210_0_1 -> 125 in the cache */
   { .constant = {
      { nir_search_value_constant, -3 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   /* search210_0_3 -> 727 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 124, 125, 727, 727 },
      -1,
   } },
   /* search210_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 728, 127 },
      -1,
   } },

   /* replace210_0_0 -> 124 in the cache */
   /* replace210_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_vec2,
      -1, 0,
      { 124, 125 },
      -1,
   } },
   /* replace210_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fdot2,
      0, 1,
      { 730, 127 },
      -1,
   } },

   /* ('fdot4', ('vec4', 'a', 'b', 'c', 0.0), 'd') => ('fdot3', ('vec3', 'a', 'b', 'c'), 'd') */
   /* search211_0_0 -> 147 in the cache */
   /* search211_0_1 -> 148 in the cache */
   /* search211_0_2 -> 150 in the cache */
   { .constant = {
      { nir_search_value_constant, -4 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_vec4,
      -1, 0,
      { 147, 148, 150, 732 },
      -1,
   } },
   /* search211_1 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 733, 151 },
      -1,
   } },

   /* replace211_0_0 -> 147 in the cache */
   /* replace211_0_1 -> 148 in the cache */
   /* replace211_0_2 -> 150 in the cache */
   /* replace211_0 -> 723 in the cache */
   /* replace211_1 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fdot3,
      0, 1,
      { 723, 151 },
      -1,
   } },

   /* ('fdot3', ('vec3', 'a', 0.0, 0.0), 'b') => ('fmul', 'a', 'b') */
   /* search212_0_0 -> 0 in the cache */
   /* search212_0_1 -> 241 in the cache */
   /* search212_0_2 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_vec3,
      -1, 0,
      { 0, 241, 241 },
      -1,
   } },
   /* search212_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdot3,
      0, 1,
      { 736, 3 },
      -1,
   } },

   /* replace212_0 -> 0 in the cache */
   /* replace212_1 -> 3 in the cache */
   /* replace212 -> 249 in the cache */

   /* ('fdot3', ('vec3', 'a', 'b', 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c') */
   /* search213_0_0 -> 124 in the cache */
   /* search213_0_1 -> 125 in the cache */
   /* search213_0_2 -> 727 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_vec3,
      -1, 0,
      { 124, 125, 727 },
      -1,
   } },
   /* search213_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fdot3,
      0, 1,
      { 738, 127 },
      -1,
   } },

   /* replace213_0_0 -> 124 in the cache */
   /* replace213_0_1 -> 125 in the cache */
   /* replace213_0 -> 730 in the cache */
   /* replace213_1 -> 127 in the cache */
   /* replace213 -> 731 in the cache */

   /* ('fdot2', ('vec2', 'a', 0.0), 'b') => ('fmul', 'a', 'b') */
   /* search214_0_0 -> 0 in the cache */
   /* search214_0_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_vec2,
      -1, 0,
      { 0, 241 },
      -1,
   } },
   /* search214_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdot2,
      0, 1,
      { 740, 3 },
      -1,
   } },

   /* replace214_0 -> 0 in the cache */
   /* replace214_1 -> 3 in the cache */
   /* replace214 -> 249 in the cache */

   /* ('fdot2', 'a', 1.0) => ('fadd', 'a.x', 'a.y') */
   /* search215_0 -> 32 in the cache */
   /* search215_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fdot2,
      0, 1,
      { 32, 226 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0},
   } },
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {1},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      -1, 0,
      { 743, 744 },
      -1,
   } },

   /* ('fdot2', 'a', 'b') => ('fsum2', ('fmul', 'a', 'b')) */
   /* search216_0 -> 0 in the cache */
   /* search216_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdot2,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace216_0_0 -> 0 in the cache */
   /* replace216_0_1 -> 3 in the cache */
   /* replace216_0 -> 249 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsum2,
      -1, 1,
      { 249 },
      -1,
   } },

   /* ('fdot3', 'a', 'b') => ('fsum3', ('fmul', 'a', 'b')) */
   /* search217_0 -> 0 in the cache */
   /* search217_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdot3,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace217_0_0 -> 0 in the cache */
   /* replace217_0_1 -> 3 in the cache */
   /* replace217_0 -> 249 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsum3,
      -1, 1,
      { 249 },
      -1,
   } },

   /* ('fdot4', 'a', 'b') => ('fsum4', ('fmul', 'a', 'b')) */
   /* search218_0 -> 0 in the cache */
   /* search218_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdot4,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace218_0_0 -> 0 in the cache */
   /* replace218_0_1 -> 3 in the cache */
   /* replace218_0 -> 249 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsum4,
      -1, 1,
      { 249 },
      -1,
   } },

   /* ('fsum2', 'a') => ('fadd', 'a.x', 'a.y') */
   /* search219_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsum2,
      -1, 0,
      { 32 },
      -1,
   } },

   /* replace219_0 -> 743 in the cache */
   /* replace219_1 -> 744 in the cache */
   /* replace219 -> 745 in the cache */

   /* ('~fadd', ('fneg(is_used_once)', ('fsat(is_used_once)', 'a(is_not_fmul)')), 1.0) => ('fsat', ('fadd', 1.0, ('fneg', 'a'))) */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      8,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 753 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 754 },
      0,
   } },
   /* search220_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 755, 226 },
      -1,
   } },

   /* replace220_0_0 -> 226 in the cache */
   /* replace220_0_1_0 -> 32 in the cache */
   /* replace220_0_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 226, 98 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 757 },
      -1,
   } },

   /* ('ishl', ('iadd', ('imul', 'a', '#b'), '#c'), '#d') => ('iadd', ('imul', 'a', ('ishl', 'b', 'd')), ('ishl', 'c', 'd')) */
   /* search221_0_0_0 -> 124 in the cache */
   /* search221_0_0_1 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 124, 268 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -3 },
      2, /* c */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 759, 760 },
      -1,
   } },
   /* search221_1 -> 296 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 2,
      { 761, 296 },
      -1,
   } },

   /* replace221_0_0 -> 124 in the cache */
   /* replace221_0_1_0 -> 125 in the cache */
   /* replace221_0_1_1 -> 161 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 125, 161 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 124, 763 },
      -1,
   } },
   /* replace221_1_0 -> 127 in the cache */
   /* replace221_1_1 -> 161 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 127, 161 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 764, 765 },
      -1,
   } },

   /* ('ishl', ('imul', 'a', '#b'), '#c') => ('imul', 'a', ('ishl', 'b', 'c')) */
   /* search222_0_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 767 },
      -1,
   } },
   /* search222_1 -> 294 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 768, 294 },
      -1,
   } },

   /* replace222_0 -> 0 in the cache */
   /* replace222_1_0 -> 3 in the cache */
   /* replace222_1_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 3, 133 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 770 },
      -1,
   } },

   /* ('ishl@8', ('ishl@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 255), ('iand', 'c', 255)), 8), ('ishl@8', 'a', ('iadd', 'b', 'c')), 0) */
   /* search223_0_0 -> 6 in the cache */
   /* search223_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 6, 33 },
      -1,
   } },
   /* search223_1 -> 294 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 772, 294 },
      -1,
   } },

   /* replace223_0_0_0_0 -> 36 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xff /* 255 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 36, 774 },
      -1,
   } },
   /* replace223_0_0_1_0 -> 133 in the cache */
   /* replace223_0_0_1_1 -> 774 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 133, 774 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 775, 776 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x8 /* 8 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 3,
      { 777, 778 },
      -1,
   } },
   /* replace223_1_0 -> 6 in the cache */
   /* replace223_1_1_0 -> 36 in the cache */
   /* replace223_1_1_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      3, 1,
      { 36, 133 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 6, 780 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0x0 /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 779, 781, 782 },
      -1,
   } },

   /* ('ushr@8', ('ushr@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 255), ('iand', 'c', 255)), 8), ('ushr@8', 'a', ('iadd', 'b', 'c')), 0) */
   /* search224_0_0 -> 6 in the cache */
   /* search224_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 6, 33 },
      -1,
   } },
   /* search224_1 -> 294 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 784, 294 },
      -1,
   } },

   /* replace224_0_0_0_0 -> 36 in the cache */
   /* replace224_0_0_0_1 -> 774 in the cache */
   /* replace224_0_0_0 -> 775 in the cache */
   /* replace224_0_0_1_0 -> 133 in the cache */
   /* replace224_0_0_1_1 -> 774 in the cache */
   /* replace224_0_0_1 -> 776 in the cache */
   /* replace224_0_0 -> 777 in the cache */
   /* replace224_0_1 -> 778 in the cache */
   /* replace224_0 -> 779 in the cache */
   /* replace224_1_0 -> 6 in the cache */
   /* replace224_1_1_0 -> 36 in the cache */
   /* replace224_1_1_1 -> 133 in the cache */
   /* replace224_1_1 -> 780 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 6, 780 },
      -1,
   } },
   /* replace224_2 -> 782 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 779, 786, 782 },
      -1,
   } },

   /* ('ishr@8', ('ishr@8', 'a', '#b'), '#c') => ('ishr@8', 'a', ('imin', ('iadd', ('iand', 'b', 255), ('iand', 'c', 255)), 7)) */
   /* search225_0_0 -> 6 in the cache */
   /* search225_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 6, 33 },
      -1,
   } },
   /* search225_1 -> 294 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 788, 294 },
      -1,
   } },

   /* replace225_0 -> 6 in the cache */
   /* replace225_1_0_0_0 -> 36 in the cache */
   /* replace225_1_0_0_1 -> 774 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 36, 774 },
      -1,
   } },
   /* replace225_1_0_1_0 -> 133 in the cache */
   /* replace225_1_0_1_1 -> 774 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      3, 1,
      { 133, 774 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 790, 791 },
      -1,
   } },
   /* replace225_1_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 792, 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 4,
      { 6, 793 },
      -1,
   } },

   /* ('ishl@16', ('ishl@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 65535), ('iand', 'c', 65535)), 16), ('ishl@16', 'a', ('iadd', 'b', 'c')), 0) */
   /* search226_0_0 -> 11 in the cache */
   /* search226_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 11, 33 },
      -1,
   } },
   /* search226_1 -> 294 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 795, 294 },
      -1,
   } },

   /* replace226_0_0_0_0 -> 36 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffff /* 65535 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 36, 797 },
      -1,
   } },
   /* replace226_0_0_1_0 -> 133 in the cache */
   /* replace226_0_0_1_1 -> 797 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 133, 797 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 798, 799 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x10 /* 16 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 3,
      { 800, 801 },
      -1,
   } },
   /* replace226_1_0 -> 11 in the cache */
   /* replace226_1_1_0 -> 36 in the cache */
   /* replace226_1_1_1 -> 133 in the cache */
   /* replace226_1_1 -> 780 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 11, 780 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0x0 /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 802, 803, 804 },
      -1,
   } },

   /* ('ushr@16', ('ushr@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 65535), ('iand', 'c', 65535)), 16), ('ushr@16', 'a', ('iadd', 'b', 'c')), 0) */
   /* search227_0_0 -> 11 in the cache */
   /* search227_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 11, 33 },
      -1,
   } },
   /* search227_1 -> 294 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 806, 294 },
      -1,
   } },

   /* replace227_0_0_0_0 -> 36 in the cache */
   /* replace227_0_0_0_1 -> 797 in the cache */
   /* replace227_0_0_0 -> 798 in the cache */
   /* replace227_0_0_1_0 -> 133 in the cache */
   /* replace227_0_0_1_1 -> 797 in the cache */
   /* replace227_0_0_1 -> 799 in the cache */
   /* replace227_0_0 -> 800 in the cache */
   /* replace227_0_1 -> 801 in the cache */
   /* replace227_0 -> 802 in the cache */
   /* replace227_1_0 -> 11 in the cache */
   /* replace227_1_1_0 -> 36 in the cache */
   /* replace227_1_1_1 -> 133 in the cache */
   /* replace227_1_1 -> 780 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 11, 780 },
      -1,
   } },
   /* replace227_2 -> 804 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 802, 808, 804 },
      -1,
   } },

   /* ('ishr@16', ('ishr@16', 'a', '#b'), '#c') => ('ishr@16', 'a', ('imin', ('iadd', ('iand', 'b', 65535), ('iand', 'c', 65535)), 15)) */
   /* search228_0_0 -> 11 in the cache */
   /* search228_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 11, 33 },
      -1,
   } },
   /* search228_1 -> 294 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 810, 294 },
      -1,
   } },

   /* replace228_0 -> 11 in the cache */
   /* replace228_1_0_0_0 -> 36 in the cache */
   /* replace228_1_0_0_1 -> 797 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 36, 797 },
      -1,
   } },
   /* replace228_1_0_1_0 -> 133 in the cache */
   /* replace228_1_0_1_1 -> 797 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      3, 1,
      { 133, 797 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 812, 813 },
      -1,
   } },
   /* replace228_1_1 -> 14 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 814, 14 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 4,
      { 11, 815 },
      -1,
   } },

   /* ('ishl@32', ('ishl@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 4294967295), ('iand', 'c', 4294967295)), 32), ('ishl@32', 'a', ('iadd', 'b', 'c')), 0) */
   /* search229_0_0 -> 16 in the cache */
   /* search229_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 33 },
      -1,
   } },
   /* search229_1 -> 294 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 817, 294 },
      -1,
   } },

   /* replace229_0_0_0_0 -> 36 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffff /* 4294967295 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 36, 819 },
      -1,
   } },
   /* replace229_0_0_1_0 -> 133 in the cache */
   /* replace229_0_0_1_1 -> 819 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 133, 819 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 820, 821 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x20 /* 32 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 3,
      { 822, 823 },
      -1,
   } },
   /* replace229_1_0 -> 16 in the cache */
   /* replace229_1_1_0 -> 36 in the cache */
   /* replace229_1_1_1 -> 133 in the cache */
   /* replace229_1_1 -> 780 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 16, 780 },
      -1,
   } },
   /* replace229_2 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 824, 825, 120 },
      -1,
   } },

   /* ('ushr@32', ('ushr@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 4294967295), ('iand', 'c', 4294967295)), 32), ('ushr@32', 'a', ('iadd', 'b', 'c')), 0) */
   /* search230_0_0 -> 16 in the cache */
   /* search230_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 33 },
      -1,
   } },
   /* search230_1 -> 294 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 827, 294 },
      -1,
   } },

   /* replace230_0_0_0_0 -> 36 in the cache */
   /* replace230_0_0_0_1 -> 819 in the cache */
   /* replace230_0_0_0 -> 820 in the cache */
   /* replace230_0_0_1_0 -> 133 in the cache */
   /* replace230_0_0_1_1 -> 819 in the cache */
   /* replace230_0_0_1 -> 821 in the cache */
   /* replace230_0_0 -> 822 in the cache */
   /* replace230_0_1 -> 823 in the cache */
   /* replace230_0 -> 824 in the cache */
   /* replace230_1_0 -> 16 in the cache */
   /* replace230_1_1_0 -> 36 in the cache */
   /* replace230_1_1_1 -> 133 in the cache */
   /* replace230_1_1 -> 780 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 16, 780 },
      -1,
   } },
   /* replace230_2 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 824, 829, 120 },
      -1,
   } },

   /* ('ishr@32', ('ishr@32', 'a', '#b'), '#c') => ('ishr@32', 'a', ('imin', ('iadd', ('iand', 'b', 4294967295), ('iand', 'c', 4294967295)), 31)) */
   /* search231_0_0 -> 16 in the cache */
   /* search231_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 16, 33 },
      -1,
   } },
   /* search231_1 -> 294 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 831, 294 },
      -1,
   } },

   /* replace231_0 -> 16 in the cache */
   /* replace231_1_0_0_0 -> 36 in the cache */
   /* replace231_1_0_0_1 -> 819 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 36, 819 },
      -1,
   } },
   /* replace231_1_0_1_0 -> 133 in the cache */
   /* replace231_1_0_1_1 -> 819 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      3, 1,
      { 133, 819 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 833, 834 },
      -1,
   } },
   /* replace231_1_1 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 835, 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 4,
      { 16, 836 },
      -1,
   } },

   /* ('ishl@64', ('ishl@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 18446744073709551615), ('iand', 'c', 18446744073709551615)), 64), ('ishl@64', 'a', ('iadd', 'b', 'c')), 0) */
   /* search232_0_0 -> 21 in the cache */
   /* search232_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 21, 33 },
      -1,
   } },
   /* search232_1 -> 294 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 838, 294 },
      -1,
   } },

   /* replace232_0_0_0_0 -> 36 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffffffffffff /* 18446744073709551615 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 36, 840 },
      -1,
   } },
   /* replace232_0_0_1_0 -> 133 in the cache */
   /* replace232_0_0_1_1 -> 840 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 133, 840 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 841, 842 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x40 /* 64 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 3,
      { 843, 844 },
      -1,
   } },
   /* replace232_1_0 -> 21 in the cache */
   /* replace232_1_1_0 -> 36 in the cache */
   /* replace232_1_1_1 -> 133 in the cache */
   /* replace232_1_1 -> 780 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 21, 780 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0x0 /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 845, 846, 847 },
      -1,
   } },

   /* ('ushr@64', ('ushr@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 18446744073709551615), ('iand', 'c', 18446744073709551615)), 64), ('ushr@64', 'a', ('iadd', 'b', 'c')), 0) */
   /* search233_0_0 -> 21 in the cache */
   /* search233_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 21, 33 },
      -1,
   } },
   /* search233_1 -> 294 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 849, 294 },
      -1,
   } },

   /* replace233_0_0_0_0 -> 36 in the cache */
   /* replace233_0_0_0_1 -> 840 in the cache */
   /* replace233_0_0_0 -> 841 in the cache */
   /* replace233_0_0_1_0 -> 133 in the cache */
   /* replace233_0_0_1_1 -> 840 in the cache */
   /* replace233_0_0_1 -> 842 in the cache */
   /* replace233_0_0 -> 843 in the cache */
   /* replace233_0_1 -> 844 in the cache */
   /* replace233_0 -> 845 in the cache */
   /* replace233_1_0 -> 21 in the cache */
   /* replace233_1_1_0 -> 36 in the cache */
   /* replace233_1_1_1 -> 133 in the cache */
   /* replace233_1_1 -> 780 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 21, 780 },
      -1,
   } },
   /* replace233_2 -> 847 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 4,
      { 845, 851, 847 },
      -1,
   } },

   /* ('ishr@64', ('ishr@64', 'a', '#b'), '#c') => ('ishr@64', 'a', ('imin', ('iadd', ('iand', 'b', 18446744073709551615), ('iand', 'c', 18446744073709551615)), 63)) */
   /* search234_0_0 -> 21 in the cache */
   /* search234_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 21, 33 },
      -1,
   } },
   /* search234_1 -> 294 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 853, 294 },
      -1,
   } },

   /* replace234_0 -> 21 in the cache */
   /* replace234_1_0_0_0 -> 36 in the cache */
   /* replace234_1_0_0_1 -> 840 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      2, 1,
      { 36, 840 },
      -1,
   } },
   /* replace234_1_0_1_0 -> 133 in the cache */
   /* replace234_1_0_1_1 -> 840 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      3, 1,
      { 133, 840 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 3,
      { 855, 856 },
      -1,
   } },
   /* replace234_1_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 857, 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 4,
      { 21, 858 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b')) */
   /* search235_0_0 -> 6 in the cache */
   /* search235_0_1 -> 33 in the cache */
   /* search235_0 -> 784 in the cache */
   /* search235_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 784, 36 },
      -1,
   } },

   /* replace235_0 -> 6 in the cache */
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0xff /* 255 */ },
   } },
   /* replace235_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 861, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 6, 862 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b')) */
   /* search236_0_0 -> 6 in the cache */
   /* search236_0_1 -> 33 in the cache */
   /* search236_0 -> 788 in the cache */
   /* search236_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 788, 36 },
      -1,
   } },

   /* replace236_0 -> 6 in the cache */
   /* replace236_1_0 -> 861 in the cache */
   /* replace236_1_1 -> 36 in the cache */
   /* replace236_1 -> 862 in the cache */
   /* replace236 -> 863 in the cache */

   /* ('ushr', ('ishl', 'a@8', '#b'), 'b') => ('iand', 'a', ('ushr', 255, 'b')) */
   /* search237_0_0 -> 6 in the cache */
   /* search237_0_1 -> 33 in the cache */
   /* search237_0 -> 772 in the cache */
   /* search237_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 772, 36 },
      -1,
   } },

   /* replace237_0 -> 6 in the cache */
   /* replace237_1_0 -> 861 in the cache */
   /* replace237_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 861, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 6, 866 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b')) */
   /* search238_0_0 -> 11 in the cache */
   /* search238_0_1 -> 33 in the cache */
   /* search238_0 -> 806 in the cache */
   /* search238_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 806, 36 },
      -1,
   } },

   /* replace238_0 -> 11 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0xffff /* 65535 */ },
   } },
   /* replace238_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 869, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 11, 870 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b')) */
   /* search239_0_0 -> 11 in the cache */
   /* search239_0_1 -> 33 in the cache */
   /* search239_0 -> 810 in the cache */
   /* search239_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 810, 36 },
      -1,
   } },

   /* replace239_0 -> 11 in the cache */
   /* replace239_1_0 -> 869 in the cache */
   /* replace239_1_1 -> 36 in the cache */
   /* replace239_1 -> 870 in the cache */
   /* replace239 -> 871 in the cache */

   /* ('ushr', ('ishl', 'a@16', '#b'), 'b') => ('iand', 'a', ('ushr', 65535, 'b')) */
   /* search240_0_0 -> 11 in the cache */
   /* search240_0_1 -> 33 in the cache */
   /* search240_0 -> 795 in the cache */
   /* search240_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 795, 36 },
      -1,
   } },

   /* replace240_0 -> 11 in the cache */
   /* replace240_1_0 -> 869 in the cache */
   /* replace240_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 869, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 11, 874 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b')) */
   /* search241_0_0 -> 16 in the cache */
   /* search241_0_1 -> 33 in the cache */
   /* search241_0 -> 827 in the cache */
   /* search241_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 827, 36 },
      -1,
   } },

   /* replace241_0 -> 16 in the cache */
   /* replace241_1_0 -> 819 in the cache */
   /* replace241_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 819, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 877 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b')) */
   /* search242_0_0 -> 16 in the cache */
   /* search242_0_1 -> 33 in the cache */
   /* search242_0 -> 831 in the cache */
   /* search242_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 831, 36 },
      -1,
   } },

   /* replace242_0 -> 16 in the cache */
   /* replace242_1_0 -> 819 in the cache */
   /* replace242_1_1 -> 36 in the cache */
   /* replace242_1 -> 877 in the cache */
   /* replace242 -> 878 in the cache */

   /* ('ushr', ('ishl', 'a@32', '#b'), 'b') => ('iand', 'a', ('ushr', 4294967295, 'b')) */
   /* search243_0_0 -> 16 in the cache */
   /* search243_0_1 -> 33 in the cache */
   /* search243_0 -> 817 in the cache */
   /* search243_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 817, 36 },
      -1,
   } },

   /* replace243_0 -> 16 in the cache */
   /* replace243_1_0 -> 819 in the cache */
   /* replace243_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 819, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 881 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b')) */
   /* search244_0_0 -> 21 in the cache */
   /* search244_0_1 -> 33 in the cache */
   /* search244_0 -> 849 in the cache */
   /* search244_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 849, 36 },
      -1,
   } },

   /* replace244_0 -> 21 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0xffffffffffffffff /* 18446744073709551615 */ },
   } },
   /* replace244_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 884, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 21, 885 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b')) */
   /* search245_0_0 -> 21 in the cache */
   /* search245_0_1 -> 33 in the cache */
   /* search245_0 -> 853 in the cache */
   /* search245_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 853, 36 },
      -1,
   } },

   /* replace245_0 -> 21 in the cache */
   /* replace245_1_0 -> 884 in the cache */
   /* replace245_1_1 -> 36 in the cache */
   /* replace245_1 -> 885 in the cache */
   /* replace245 -> 886 in the cache */

   /* ('ushr', ('ishl', 'a@64', '#b'), 'b') => ('iand', 'a', ('ushr', 18446744073709551615, 'b')) */
   /* search246_0_0 -> 21 in the cache */
   /* search246_0_1 -> 33 in the cache */
   /* search246_0 -> 838 in the cache */
   /* search246_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 838, 36 },
      -1,
   } },

   /* replace246_0 -> 21 in the cache */
   /* replace246_1_0 -> 884 in the cache */
   /* replace246_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 884, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 21, 889 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', '#b(is_first_5_bits_uge_2)'), -4) => ('ishl', 'a', 'b') */
   /* search247_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      9,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 891 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { -0x4 /* -4 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 892, 893 },
      -1,
   } },

   /* replace247_0 -> 16 in the cache */
   /* replace247_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 36 },
      -1,
   } },

   /* ('iand', ('imul', 'a', '#b(is_unsigned_multiple_of_4)'), -4) => ('imul', 'a', 'b') */
   /* search248_0_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      10,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 0, 896 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_int, { -0x4 /* -4 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 897, 898 },
      -1,
   } },

   /* replace248_0 -> 0 in the cache */
   /* replace248_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_2)'), 4294967294) => ('iadd', ('iand', 'a', 4294967294), 'b') */
   /* search249_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      11,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 16, 901 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffffe /* 4294967294 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 902, 903 },
      -1,
   } },

   /* replace249_0_0 -> 16 in the cache */
   /* replace249_0_1 -> 903 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 903 },
      -1,
   } },
   /* replace249_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 905, 36 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_4)'), 4294967292) => ('iadd', ('iand', 'a', 4294967292), 'b') */
   /* search250_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      10,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 16, 907 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffffc /* 4294967292 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 908, 909 },
      -1,
   } },

   /* replace250_0_0 -> 16 in the cache */
   /* replace250_0_1 -> 909 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 909 },
      -1,
   } },
   /* replace250_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 911, 36 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_8)'), 4294967288) => ('iadd', ('iand', 'a', 4294967288), 'b') */
   /* search251_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      12,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 16, 913 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffff8 /* 4294967288 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 914, 915 },
      -1,
   } },

   /* replace251_0_0 -> 16 in the cache */
   /* replace251_0_1 -> 915 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 915 },
      -1,
   } },
   /* replace251_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 917, 36 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_16)'), 4294967280) => ('iadd', ('iand', 'a', 4294967280), 'b') */
   /* search252_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      13,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 16, 919 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffff0 /* 4294967280 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 920, 921 },
      -1,
   } },

   /* replace252_0_0 -> 16 in the cache */
   /* replace252_0_1 -> 921 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 921 },
      -1,
   } },
   /* replace252_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 923, 36 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_32)'), 4294967264) => ('iadd', ('iand', 'a', 4294967264), 'b') */
   /* search253_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      14,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 16, 925 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffe0 /* 4294967264 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 926, 927 },
      -1,
   } },

   /* replace253_0_0 -> 16 in the cache */
   /* replace253_0_1 -> 927 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 927 },
      -1,
   } },
   /* replace253_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 929, 36 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', '#b(is_unsigned_multiple_of_64)'), 4294967232) => ('iadd', ('iand', 'a', 4294967232), 'b') */
   /* search254_0_0 -> 16 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      15,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 16, 931 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffc0 /* 4294967232 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 932, 933 },
      -1,
   } },

   /* replace254_0_0 -> 16 in the cache */
   /* replace254_0_1 -> 933 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 933 },
      -1,
   } },
   /* replace254_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 935, 36 },
      -1,
   } },

   /* ('ishl@32', ('iand', 'a@32', 2147483647), 1) => ('ishl', 'a', 1) */
   /* search255_0_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x7fffffff /* 2147483647 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 937 },
      -1,
   } },
   /* search255_1 -> 377 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 938, 377 },
      -1,
   } },

   /* replace255_0 -> 16 in the cache */
   /* replace255_1 -> 377 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 377 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 1), 4294967294) => ('ishl', 'a', 1) */
   /* search256_0_0 -> 16 in the cache */
   /* search256_0_1 -> 377 in the cache */
   /* search256_0 -> 940 in the cache */
   /* search256_1 -> 903 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 940, 903 },
      -1,
   } },

   /* replace256_0 -> 16 in the cache */
   /* replace256_1 -> 377 in the cache */
   /* replace256 -> 940 in the cache */

   /* ('iand', ('ushr', 'a@32', 1), 2147483647) => ('ushr', 'a', 1) */
   /* search257_0_0 -> 16 in the cache */
   /* search257_0_1 -> 377 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 377 },
      -1,
   } },
   /* search257_1 -> 937 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 942, 937 },
      -1,
   } },

   /* replace257_0 -> 16 in the cache */
   /* replace257_1 -> 377 in the cache */
   /* replace257 -> 942 in the cache */

   /* ('ishl@32', ('iand', 'a@32', 1073741823), 2) => ('ishl', 'a', 2) */
   /* search258_0_0 -> 16 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3fffffff /* 1073741823 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 944 },
      -1,
   } },
   /* search258_1 -> 382 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 945, 382 },
      -1,
   } },

   /* replace258_0 -> 16 in the cache */
   /* replace258_1 -> 382 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 382 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 2), 4294967292) => ('ishl', 'a', 2) */
   /* search259_0_0 -> 16 in the cache */
   /* search259_0_1 -> 382 in the cache */
   /* search259_0 -> 947 in the cache */
   /* search259_1 -> 909 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 947, 909 },
      -1,
   } },

   /* replace259_0 -> 16 in the cache */
   /* replace259_1 -> 382 in the cache */
   /* replace259 -> 947 in the cache */

   /* ('iand', ('ushr', 'a@32', 2), 1073741823) => ('ushr', 'a', 2) */
   /* search260_0_0 -> 16 in the cache */
   /* search260_0_1 -> 382 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 382 },
      -1,
   } },
   /* search260_1 -> 944 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 949, 944 },
      -1,
   } },

   /* replace260_0 -> 16 in the cache */
   /* replace260_1 -> 382 in the cache */
   /* replace260 -> 949 in the cache */

   /* ('ishl@32', ('iand', 'a@32', 65535), 16) => ('ishl', 'a', 16) */
   /* search261_0_0 -> 16 in the cache */
   /* search261_0_1 -> 797 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 797 },
      -1,
   } },
   /* search261_1 -> 801 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 951, 801 },
      -1,
   } },

   /* replace261_0 -> 16 in the cache */
   /* replace261_1 -> 801 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 801 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 16), 4294901760) => ('ishl', 'a', 16) */
   /* search262_0_0 -> 16 in the cache */
   /* search262_0_1 -> 801 in the cache */
   /* search262_0 -> 953 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffff0000 /* 4294901760 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 953, 954 },
      -1,
   } },

   /* replace262_0 -> 16 in the cache */
   /* replace262_1 -> 801 in the cache */
   /* replace262 -> 953 in the cache */

   /* ('iand', ('ushr', 'a@32', 16), 65535) => ('ushr', 'a', 16) */
   /* search263_0_0 -> 16 in the cache */
   /* search263_0_1 -> 801 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 801 },
      -1,
   } },
   /* search263_1 -> 797 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 956, 797 },
      -1,
   } },

   /* replace263_0 -> 16 in the cache */
   /* replace263_1 -> 801 in the cache */
   /* replace263 -> 956 in the cache */

   /* ('ishl@32', ('iand', 'a@32', 255), 24) => ('ishl', 'a', 24) */
   /* search264_0_0 -> 16 in the cache */
   /* search264_0_1 -> 774 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 774 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x18 /* 24 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 958, 959 },
      -1,
   } },

   /* replace264_0 -> 16 in the cache */
   /* replace264_1 -> 959 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 959 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 24), 4278190080) => ('ishl', 'a', 24) */
   /* search265_0_0 -> 16 in the cache */
   /* search265_0_1 -> 959 in the cache */
   /* search265_0 -> 961 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xff000000 /* 4278190080 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 961, 962 },
      -1,
   } },

   /* replace265_0 -> 16 in the cache */
   /* replace265_1 -> 959 in the cache */
   /* replace265 -> 961 in the cache */

   /* ('iand', ('ushr', 'a@32', 24), 255) => ('ushr', 'a', 24) */
   /* search266_0_0 -> 16 in the cache */
   /* search266_0_1 -> 959 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 959 },
      -1,
   } },
   /* search266_1 -> 774 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 964, 774 },
      -1,
   } },

   /* replace266_0 -> 16 in the cache */
   /* replace266_1 -> 959 in the cache */
   /* replace266 -> 964 in the cache */

   /* ('ishl', ('iadd', 'a', '#b'), '#c') => ('iadd', ('ishl', 'a', 'c'), ('ishl', 'b', 'c')) */
   /* search267_0_0 -> 0 in the cache */
   /* search267_0_1 -> 767 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 0, 767 },
      -1,
   } },
   /* search267_1 -> 294 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 966, 294 },
      -1,
   } },

   /* replace267_0_0 -> 0 in the cache */
   /* replace267_0_1 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 0, 133 },
      -1,
   } },
   /* replace267_1_0 -> 3 in the cache */
   /* replace267_1_1 -> 133 in the cache */
   /* replace267_1 -> 770 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 968, 770 },
      -1,
   } },

   /* ('imul', ('iadd(is_used_once)', 'a', '#b'), '#c') => ('iadd', ('imul', 'a', 'c'), ('imul', 'b', 'c')) */
   /* search268_0_0 -> 124 in the cache */
   /* search268_0_1 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 124, 268 },
      0,
   } },
   /* search268_1 -> 760 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      0, 2,
      { 970, 760 },
      -1,
   } },

   /* replace268_0_0 -> 124 in the cache */
   /* replace268_0_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      1, 1,
      { 124, 127 },
      -1,
   } },
   /* replace268_1_0 -> 125 in the cache */
   /* replace268_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imul,
      2, 1,
      { 125, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 3,
      { 972, 973 },
      -1,
   } },

   /* ('imul', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('imul', ('iadd', 'a', 'c'), 'd'), ('imul', 'b', 'd')) */
   /* search269_0_0_0 -> 147 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_iadd,
      2, 1,
      { 147, 975 },
      0,
   } },
   /* search269_0_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 2,
      { 976, 150 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      3, /* d */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_imul,
      0, 3,
      { 977, 978 },
      -1,
   } },

   /* replace269_0_0_0 -> 147 in the cache */
   /* replace269_0_0_1 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_iadd,
      2, 1,
      { 147, 150 },
      -1,
   } },
   /* replace269_0_1 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_imul,
      1, 2,
      { 980, 151 },
      -1,
   } },
   /* replace269_1_0 -> 148 in the cache */
   /* replace269_1_1 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_imul,
      3, 1,
      { 148, 151 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 4,
      { 981, 982 },
      -1,
   } },

   /* ('ishl', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('ishl', ('iadd', 'a', 'c'), 'd'), ('ishl', 'b', 'd')) */
   /* search270_0_0_0 -> 124 in the cache */
   /* search270_0_0_1 -> 268 in the cache */
   /* search270_0_0 -> 970 in the cache */
   /* search270_0_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 970, 127 },
      0,
   } },
   /* search270_1 -> 296 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 2,
      { 984, 296 },
      -1,
   } },

   /* replace270_0_0_0 -> 124 in the cache */
   /* replace270_0_0_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 124, 127 },
      -1,
   } },
   /* replace270_0_1 -> 161 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 986, 161 },
      -1,
   } },
   /* replace270_1_0 -> 125 in the cache */
   /* replace270_1_1 -> 161 in the cache */
   /* replace270_1 -> 763 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 2,
      { 987, 763 },
      -1,
   } },

   /* ('inot', ('flt(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('fge', 'a', 'b') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 989, 990 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 991 },
      -1,
   } },

   /* replace271_0 -> 0 in the cache */
   /* replace271_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('fge(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('flt', 'a', 'b') */
   /* search272_0_0 -> 989 in the cache */
   /* search272_0_1 -> 990 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 989, 990 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 994 },
      -1,
   } },

   /* replace272_0 -> 0 in the cache */
   /* replace272_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('feq(is_used_once)', 'a', 'b')) => ('fneu', 'a', 'b') */
   /* search273_0_0 -> 0 in the cache */
   /* search273_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 997 },
      -1,
   } },

   /* replace273_0 -> 0 in the cache */
   /* replace273_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('fneu(is_used_once)', 'a', 'b')) => ('feq', 'a', 'b') */
   /* search274_0_0 -> 0 in the cache */
   /* search274_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1000 },
      -1,
   } },

   /* replace274_0 -> 0 in the cache */
   /* replace274_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('ilt(is_used_once)', 'a', 'b')) => ('ige', 'a', 'b') */
   /* search275_0_0 -> 0 in the cache */
   /* search275_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1003 },
      -1,
   } },

   /* replace275_0 -> 0 in the cache */
   /* replace275_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('ult(is_used_once)', 'a', 'b')) => ('uge', 'a', 'b') */
   /* search276_0_0 -> 0 in the cache */
   /* search276_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1006 },
      -1,
   } },

   /* replace276_0 -> 0 in the cache */
   /* replace276_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('ige(is_used_once)', 'a', 'b')) => ('ilt', 'a', 'b') */
   /* search277_0_0 -> 0 in the cache */
   /* search277_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1009 },
      -1,
   } },

   /* replace277_0 -> 0 in the cache */
   /* replace277_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('uge(is_used_once)', 'a', 'b')) => ('ult', 'a', 'b') */
   /* search278_0_0 -> 0 in the cache */
   /* search278_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1012 },
      -1,
   } },

   /* replace278_0 -> 0 in the cache */
   /* replace278_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('ieq(is_used_once)', 'a', 'b')) => ('ine', 'a', 'b') */
   /* search279_0_0 -> 0 in the cache */
   /* search279_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1015 },
      -1,
   } },

   /* replace279_0 -> 0 in the cache */
   /* replace279_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('inot', ('ine(is_used_once)', 'a', 'b')) => ('ieq', 'a', 'b') */
   /* search280_0_0 -> 0 in the cache */
   /* search280_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1018 },
      -1,
   } },

   /* replace280_0 -> 0 in the cache */
   /* replace280_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('iand', ('feq', 'a', 'b'), ('fneu', 'a', 'b')) => False */
   /* search281_0_0 -> 0 in the cache */
   /* search281_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search281_1_0 -> 0 in the cache */
   /* search281_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      2, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 1021, 1022 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, 1 },
      nir_type_bool, { NIR_FALSE /* False */ },
   } },

   /* ('iand', ('flt', 'a', 'b'), ('flt', 'b', 'a')) => False */
   /* search282_0_0 -> 0 in the cache */
   /* search282_0_1 -> 3 in the cache */
   /* search282_0 -> 996 in the cache */
   /* search282_1_0 -> 3 in the cache */
   /* search282_1_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 3, 0 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 996, 1025 },
      -1,
   } },

   /* replace282 -> 1024 in the cache */

   /* ('iand', ('ieq', 'a', 'b'), ('ine', 'a', 'b')) => False */
   /* search283_0_0 -> 0 in the cache */
   /* search283_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search283_1_0 -> 0 in the cache */
   /* search283_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      2, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 1027, 1028 },
      -1,
   } },

   /* replace283 -> 1024 in the cache */

   /* ('iand', ('ilt', 'a', 'b'), ('ilt', 'b', 'a')) => False */
   /* search284_0_0 -> 0 in the cache */
   /* search284_0_1 -> 3 in the cache */
   /* search284_0 -> 1011 in the cache */
   /* search284_1_0 -> 3 in the cache */
   /* search284_1_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 3, 0 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1011, 1030 },
      -1,
   } },

   /* replace284 -> 1024 in the cache */

   /* ('iand', ('ult', 'a', 'b'), ('ult', 'b', 'a')) => False */
   /* search285_0_0 -> 0 in the cache */
   /* search285_0_1 -> 3 in the cache */
   /* search285_0 -> 1014 in the cache */
   /* search285_1_0 -> 3 in the cache */
   /* search285_1_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 3, 0 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1014, 1032 },
      -1,
   } },

   /* replace285 -> 1024 in the cache */

   /* ('flt', ('fneg', 'a'), ('fneg', 'b')) => ('flt', 'b', 'a') */
   /* search286_0_0 -> 0 in the cache */
   /* search286_0 -> 197 in the cache */
   /* search286_1_0 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 197, 1034 },
      -1,
   } },

   /* replace286_0 -> 3 in the cache */
   /* replace286_1 -> 0 in the cache */
   /* replace286 -> 1025 in the cache */

   /* ('fge', ('fneg', 'a'), ('fneg', 'b')) => ('fge', 'b', 'a') */
   /* search287_0_0 -> 0 in the cache */
   /* search287_0 -> 197 in the cache */
   /* search287_1_0 -> 3 in the cache */
   /* search287_1 -> 1034 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 197, 1034 },
      -1,
   } },

   /* replace287_0 -> 3 in the cache */
   /* replace287_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 3, 0 },
      -1,
   } },

   /* ('feq', ('fneg', 'a'), ('fneg', 'b')) => ('feq', 'b', 'a') */
   /* search288_0_0 -> 0 in the cache */
   /* search288_0 -> 197 in the cache */
   /* search288_1_0 -> 3 in the cache */
   /* search288_1 -> 1034 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 197, 1034 },
      -1,
   } },

   /* replace288_0 -> 3 in the cache */
   /* replace288_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 3, 0 },
      -1,
   } },

   /* ('fneu', ('fneg', 'a'), ('fneg', 'b')) => ('fneu', 'b', 'a') */
   /* search289_0_0 -> 0 in the cache */
   /* search289_0 -> 197 in the cache */
   /* search289_1_0 -> 3 in the cache */
   /* search289_1 -> 1034 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 197, 1034 },
      -1,
   } },

   /* replace289_0 -> 3 in the cache */
   /* replace289_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 3, 0 },
      -1,
   } },

   /* ('flt', ('fneg', 'a'), -1.0) => ('flt', 1.0, 'a') */
   /* search290_0_0 -> 32 in the cache */
   /* search290_0 -> 98 in the cache */
   /* search290_1 -> 232 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 98, 232 },
      -1,
   } },

   /* replace290_0 -> 226 in the cache */
   /* replace290_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 226, 32 },
      -1,
   } },

   /* ('flt', -1.0, ('fneg', 'a')) => ('flt', 'a', 1.0) */
   /* search291_0 -> 232 in the cache */
   /* search291_1_0 -> 32 in the cache */
   /* search291_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 232, 98 },
      -1,
   } },

   /* replace291_0 -> 32 in the cache */
   /* replace291_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 32, 226 },
      -1,
   } },

   /* ('fge', ('fneg', 'a'), -1.0) => ('fge', 1.0, 'a') */
   /* search292_0_0 -> 32 in the cache */
   /* search292_0 -> 98 in the cache */
   /* search292_1 -> 232 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 98, 232 },
      -1,
   } },

   /* replace292_0 -> 226 in the cache */
   /* replace292_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 226, 32 },
      -1,
   } },

   /* ('fge', -1.0, ('fneg', 'a')) => ('fge', 'a', 1.0) */
   /* search293_0 -> 232 in the cache */
   /* search293_1_0 -> 32 in the cache */
   /* search293_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 232, 98 },
      -1,
   } },

   /* replace293_0 -> 32 in the cache */
   /* replace293_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 32, 226 },
      -1,
   } },

   /* ('fneu', ('fneg', 'a'), -1.0) => ('fneu', 1.0, 'a') */
   /* search294_0_0 -> 32 in the cache */
   /* search294_0 -> 98 in the cache */
   /* search294_1 -> 232 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 98, 232 },
      -1,
   } },

   /* replace294_0 -> 226 in the cache */
   /* replace294_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 226, 32 },
      -1,
   } },

   /* ('feq', -1.0, ('fneg', 'a')) => ('feq', 'a', 1.0) */
   /* search295_0 -> 232 in the cache */
   /* search295_1_0 -> 32 in the cache */
   /* search295_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 232, 98 },
      -1,
   } },

   /* replace295_0 -> 32 in the cache */
   /* replace295_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 32, 226 },
      -1,
   } },

   /* ('flt', '#b(is_gt_0_and_lt_1)', ('fsat(is_used_once)', 'a')) => ('flt', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* b */
      true,
      nir_type_invalid,
      17,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 1055 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1054, 1056 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* replace296_1 -> 1055 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1058, 1055 },
      -1,
   } },

   /* ('fge', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fge', 'a', 'b') */
   /* search297_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 0 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      17,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1060, 1061 },
      -1,
   } },

   /* replace297_0 -> 0 in the cache */
   /* replace297_1 -> 3 in the cache */
   /* replace297 -> 993 in the cache */

   /* ('feq', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('feq', 'a', 'b') */
   /* search298_0_0 -> 0 in the cache */
   /* search298_0 -> 1060 in the cache */
   /* search298_1 -> 1061 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1060, 1061 },
      -1,
   } },

   /* replace298_0 -> 0 in the cache */
   /* replace298_1 -> 3 in the cache */
   /* replace298 -> 1002 in the cache */

   /* ('fneu', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fneu', 'a', 'b') */
   /* search299_0_0 -> 0 in the cache */
   /* search299_0 -> 1060 in the cache */
   /* search299_1 -> 1061 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1060, 1061 },
      -1,
   } },

   /* replace299_0 -> 0 in the cache */
   /* replace299_1 -> 3 in the cache */
   /* replace299 -> 999 in the cache */

   /* ('fge', ('fsat(is_used_once)', 'a'), 1.0) => ('fge', 'a', 1.0) */
   /* search300_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 32 },
      0,
   } },
   /* search300_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1065, 226 },
      -1,
   } },

   /* replace300_0 -> 32 in the cache */
   /* replace300_1 -> 226 in the cache */
   /* replace300 -> 1049 in the cache */

   /* ('flt', 0.0, ('fsat(is_used_once)', 'a')) => ('flt', 0.0, 'a') */
   /* search301_0 -> 113 in the cache */
   /* search301_1_0 -> 32 in the cache */
   /* search301_1 -> 1065 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 113, 1065 },
      -1,
   } },

   /* replace301_0 -> 113 in the cache */
   /* replace301_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 113, 32 },
      -1,
   } },

   /* ('fge', 0.0, ('b2f', 'a@1')) => ('inot', 'a') */
   { .constant = {
      { nir_search_value_constant, 0 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   /* search302_1_0 -> 706 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 706 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1069, 1070 },
      -1,
   } },

   /* replace302_0 -> 706 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 706 },
      -1,
   } },

   /* ('fge', ('fneg', ('b2f', 'a@1')), 0.0) => ('inot', 'a') */
   /* search303_0_0_0 -> 706 in the cache */
   /* search303_0_0 -> 1070 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1070 },
      -1,
   } },
   /* search303_1 -> 1069 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1073, 1069 },
      -1,
   } },

   /* replace303_0 -> 706 in the cache */
   /* replace303 -> 1072 in the cache */

   /* ('fneu', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b') */
   /* search304_0_0_0 -> 706 in the cache */
   /* search304_0_0 -> 1070 in the cache */
   { .variable = {
      { nir_search_value_variable, 1 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1075 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 1070, 1076 },
      -1,
   } },
   /* search304_1 -> 1069 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1077, 1069 },
      -1,
   } },

   /* replace304_0 -> 706 in the cache */
   /* replace304_1 -> 1075 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 706, 1075 },
      -1,
   } },

   /* ('fneu', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b') */
   /* search305_0_0 -> 706 in the cache */
   { .constant = {
      { nir_search_value_constant, 0 },
      nir_type_float, { 0x3ff0000000000000 /* 1.0 */ },
   } },
   /* search305_0_2_0 -> 1075 in the cache */
   /* search305_0_2 -> 1076 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 1080, 1076 },
      -1,
   } },
   /* search305_1 -> 1069 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1081, 1069 },
      -1,
   } },

   /* replace305_0 -> 706 in the cache */
   /* replace305_1 -> 1075 in the cache */
   /* replace305 -> 1079 in the cache */

   /* ('fneu', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('ior', 'a', 'b') */
   /* search306_0_0 -> 706 in the cache */
   /* search306_0 -> 1070 in the cache */
   /* search306_1_0_0 -> 1075 in the cache */
   /* search306_1_0 -> 1076 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1076 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1070, 1083 },
      -1,
   } },

   /* replace306_0 -> 706 in the cache */
   /* replace306_1 -> 1075 in the cache */
   /* replace306 -> 1079 in the cache */

   /* ('fneu', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('iand', 'a', 'b') */
   /* search307_0_0_0 -> 706 in the cache */
   /* search307_0_0 -> 1070 in the cache */
   /* search307_0_1_0 -> 1075 in the cache */
   /* search307_0_1 -> 1076 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 1070, 1076 },
      -1,
   } },
   /* search307_1 -> 1069 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1085, 1069 },
      -1,
   } },

   /* replace307_0 -> 706 in the cache */
   /* replace307_1 -> 1075 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 706, 1075 },
      -1,
   } },

   /* ('fneu', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('iand', 'a', 'b') */
   /* search308_0_0 -> 706 in the cache */
   /* search308_0_1_0 -> 1075 in the cache */
   /* search308_0_1 -> 1076 in the cache */
   /* search308_0_2 -> 1069 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 1076, 1069 },
      -1,
   } },
   /* search308_1 -> 1069 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1088, 1069 },
      -1,
   } },

   /* replace308_0 -> 706 in the cache */
   /* replace308_1 -> 1075 in the cache */
   /* replace308 -> 1087 in the cache */

   /* ('fneu', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ixor', 'a', 'b') */
   /* search309_0_0_0 -> 706 in the cache */
   /* search309_0_0 -> 1070 in the cache */
   /* search309_0_1_0_0 -> 1075 in the cache */
   /* search309_0_1_0 -> 1076 in the cache */
   /* search309_0_1 -> 1083 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 1070, 1083 },
      -1,
   } },
   /* search309_1 -> 1069 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1090, 1069 },
      -1,
   } },

   /* replace309_0 -> 706 in the cache */
   /* replace309_1 -> 1075 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 706, 1075 },
      -1,
   } },

   /* ('fneu', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ixor', 'a', 'b') */
   /* search310_0_0 -> 706 in the cache */
   /* search310_0 -> 1070 in the cache */
   /* search310_1_0 -> 1075 in the cache */
   /* search310_1 -> 1076 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1070, 1076 },
      -1,
   } },

   /* replace310_0 -> 706 in the cache */
   /* replace310_1 -> 1075 in the cache */
   /* replace310 -> 1092 in the cache */

   /* ('fneu', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ixor', 'a', 'b') */
   /* search311_0_0_0 -> 706 in the cache */
   /* search311_0_0 -> 1070 in the cache */
   /* search311_0 -> 1073 in the cache */
   /* search311_1_0_0 -> 1075 in the cache */
   /* search311_1_0 -> 1076 in the cache */
   /* search311_1 -> 1083 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1073, 1083 },
      -1,
   } },

   /* replace311_0 -> 706 in the cache */
   /* replace311_1 -> 1075 in the cache */
   /* replace311 -> 1092 in the cache */

   /* ('feq', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b')) */
   /* search312_0_0_0 -> 706 in the cache */
   /* search312_0_0 -> 1070 in the cache */
   /* search312_0_1_0 -> 1075 in the cache */
   /* search312_0_1 -> 1076 in the cache */
   /* search312_0 -> 1077 in the cache */
   /* search312_1 -> 1069 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1077, 1069 },
      -1,
   } },

   /* replace312_0_0 -> 706 in the cache */
   /* replace312_0_1 -> 1075 in the cache */
   /* replace312_0 -> 1079 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1079 },
      -1,
   } },

   /* ('feq', ('bcsel', 'a', 1.0, ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b')) */
   /* search313_0_0 -> 706 in the cache */
   /* search313_0_1 -> 1080 in the cache */
   /* search313_0_2_0 -> 1075 in the cache */
   /* search313_0_2 -> 1076 in the cache */
   /* search313_0 -> 1081 in the cache */
   /* search313_1 -> 1069 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1081, 1069 },
      -1,
   } },

   /* replace313_0_0 -> 706 in the cache */
   /* replace313_0_1 -> 1075 in the cache */
   /* replace313_0 -> 1079 in the cache */
   /* replace313 -> 1096 in the cache */

   /* ('feq', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b')) */
   /* search314_0_0 -> 706 in the cache */
   /* search314_0 -> 1070 in the cache */
   /* search314_1_0_0 -> 1075 in the cache */
   /* search314_1_0 -> 1076 in the cache */
   /* search314_1 -> 1083 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1070, 1083 },
      -1,
   } },

   /* replace314_0_0 -> 706 in the cache */
   /* replace314_0_1 -> 1075 in the cache */
   /* replace314_0 -> 1079 in the cache */
   /* replace314 -> 1096 in the cache */

   /* ('feq', ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('iand', 'a', 'b')) */
   /* search315_0_0_0 -> 706 in the cache */
   /* search315_0_0 -> 1070 in the cache */
   /* search315_0_1_0 -> 1075 in the cache */
   /* search315_0_1 -> 1076 in the cache */
   /* search315_0 -> 1085 in the cache */
   /* search315_1 -> 1069 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1085, 1069 },
      -1,
   } },

   /* replace315_0_0 -> 706 in the cache */
   /* replace315_0_1 -> 1075 in the cache */
   /* replace315_0 -> 1087 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 1087 },
      -1,
   } },

   /* ('feq', ('bcsel', 'a', ('b2f', 'b@1'), 0.0), 0.0) => ('inot', ('iand', 'a', 'b')) */
   /* search316_0_0 -> 706 in the cache */
   /* search316_0_1_0 -> 1075 in the cache */
   /* search316_0_1 -> 1076 in the cache */
   /* search316_0_2 -> 1069 in the cache */
   /* search316_0 -> 1088 in the cache */
   /* search316_1 -> 1069 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1088, 1069 },
      -1,
   } },

   /* replace316_0_0 -> 706 in the cache */
   /* replace316_0_1 -> 1075 in the cache */
   /* replace316_0 -> 1087 in the cache */
   /* replace316 -> 1100 in the cache */

   /* ('feq', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ieq', 'a', 'b') */
   /* search317_0_0_0 -> 706 in the cache */
   /* search317_0_0 -> 1070 in the cache */
   /* search317_0_1_0_0 -> 1075 in the cache */
   /* search317_0_1_0 -> 1076 in the cache */
   /* search317_0_1 -> 1083 in the cache */
   /* search317_0 -> 1090 in the cache */
   /* search317_1 -> 1069 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1090, 1069 },
      -1,
   } },

   /* replace317_0 -> 706 in the cache */
   /* replace317_1 -> 1075 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 706, 1075 },
      -1,
   } },

   /* ('feq', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ieq', 'a', 'b') */
   /* search318_0_0 -> 706 in the cache */
   /* search318_0 -> 1070 in the cache */
   /* search318_1_0 -> 1075 in the cache */
   /* search318_1 -> 1076 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1070, 1076 },
      -1,
   } },

   /* replace318_0 -> 706 in the cache */
   /* replace318_1 -> 1075 in the cache */
   /* replace318 -> 1103 in the cache */

   /* ('feq', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ieq', 'a', 'b') */
   /* search319_0_0_0 -> 706 in the cache */
   /* search319_0_0 -> 1070 in the cache */
   /* search319_0 -> 1073 in the cache */
   /* search319_1_0_0 -> 1075 in the cache */
   /* search319_1_0 -> 1076 in the cache */
   /* search319_1 -> 1083 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1073, 1083 },
      -1,
   } },

   /* replace319_0 -> 706 in the cache */
   /* replace319_1 -> 1075 in the cache */
   /* replace319 -> 1103 in the cache */

   /* ('flt', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('ior', 'a', 'b') */
   /* search320_0_0_0_0 -> 706 in the cache */
   /* search320_0_0_0 -> 1070 in the cache */
   /* search320_0_0_1_0 -> 1075 in the cache */
   /* search320_0_0_1 -> 1076 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 1070, 1076 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1106 },
      -1,
   } },
   /* search320_1 -> 1069 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1107, 1069 },
      -1,
   } },

   /* replace320_0 -> 706 in the cache */
   /* replace320_1 -> 1075 in the cache */
   /* replace320 -> 1079 in the cache */

   /* ('flt', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('ior', 'a', 'b') */
   /* search321_0 -> 1069 in the cache */
   /* search321_1_0_0 -> 706 in the cache */
   /* search321_1_0 -> 1070 in the cache */
   /* search321_1_1_0 -> 1075 in the cache */
   /* search321_1_1 -> 1076 in the cache */
   /* search321_1 -> 1106 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1069, 1106 },
      -1,
   } },

   /* replace321_0 -> 706 in the cache */
   /* replace321_1 -> 1075 in the cache */
   /* replace321 -> 1079 in the cache */

   /* ('fge', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('inot', ('ior', 'a', 'b')) */
   /* search322_0_0_0_0 -> 706 in the cache */
   /* search322_0_0_0 -> 1070 in the cache */
   /* search322_0_0_1_0 -> 1075 in the cache */
   /* search322_0_0_1 -> 1076 in the cache */
   /* search322_0_0 -> 1106 in the cache */
   /* search322_0 -> 1107 in the cache */
   /* search322_1 -> 1069 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1107, 1069 },
      -1,
   } },

   /* replace322_0_0 -> 706 in the cache */
   /* replace322_0_1 -> 1075 in the cache */
   /* replace322_0 -> 1079 in the cache */
   /* replace322 -> 1096 in the cache */

   /* ('fge', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b')) */
   /* search323_0 -> 1069 in the cache */
   /* search323_1_0_0 -> 706 in the cache */
   /* search323_1_0 -> 1070 in the cache */
   /* search323_1_1_0 -> 1075 in the cache */
   /* search323_1_1 -> 1076 in the cache */
   /* search323_1 -> 1106 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1069, 1106 },
      -1,
   } },

   /* replace323_0_0 -> 706 in the cache */
   /* replace323_0_1 -> 1075 in the cache */
   /* replace323_0 -> 1079 in the cache */
   /* replace323 -> 1096 in the cache */

   /* ('flt', 'a', ('fneg', 'a')) => ('flt', 'a', 0.0) */
   /* search324_0 -> 32 in the cache */
   /* search324_1_0 -> 32 in the cache */
   /* search324_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 32, 98 },
      -1,
   } },

   /* replace324_0 -> 32 in the cache */
   /* replace324_1 -> 113 in the cache */
   /* replace324 -> 670 in the cache */

   /* ('fge', 'a', ('fneg', 'a')) => ('fge', 'a', 0.0) */
   /* search325_0 -> 32 in the cache */
   /* search325_1_0 -> 32 in the cache */
   /* search325_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 32, 98 },
      -1,
   } },

   /* replace325_0 -> 32 in the cache */
   /* replace325_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 32, 113 },
      -1,
   } },

   /* ('flt', ('fmin', 'c', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')))), 0.0) => ('ior', ('flt', 'c', 0.0), ('ior', 'a', 'b')) */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 1 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1116 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 1 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1118 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 1117, 1119 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1120 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1115, 1121 },
      -1,
   } },
   /* search326_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 2,
      { 1122, 113 },
      -1,
   } },

   /* replace326_0_0 -> 1115 in the cache */
   /* replace326_0_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1115, 113 },
      -1,
   } },
   /* replace326_1_0 -> 1116 in the cache */
   /* replace326_1_1 -> 1118 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1116, 1118 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1124, 1125 },
      -1,
   } },

   /* ('~flt', ('fadd', 'a', 'b'), 'a') => ('flt', 'b', 0.0) */
   /* search327_0_0 -> 0 in the cache */
   /* search327_0_1 -> 3 in the cache */
   /* search327_0 -> 257 in the cache */
   /* search327_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 257, 0 },
      -1,
   } },

   /* replace327_0 -> 3 in the cache */
   /* replace327_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 3, 241 },
      -1,
   } },

   /* ('~fge', ('fadd', 'a', 'b'), 'a') => ('fge', 'b', 0.0) */
   /* search328_0_0 -> 0 in the cache */
   /* search328_0_1 -> 3 in the cache */
   /* search328_0 -> 257 in the cache */
   /* search328_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 257, 0 },
      -1,
   } },

   /* replace328_0 -> 3 in the cache */
   /* replace328_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 3, 241 },
      -1,
   } },

   /* ('~feq', ('fadd', 'a', 'b'), 'a') => ('feq', 'b', 0.0) */
   /* search329_0_0 -> 0 in the cache */
   /* search329_0_1 -> 3 in the cache */
   /* search329_0 -> 198 in the cache */
   /* search329_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 198, 0 },
      -1,
   } },

   /* replace329_0 -> 3 in the cache */
   /* replace329_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 3, 241 },
      -1,
   } },

   /* ('~fneu', ('fadd', 'a', 'b'), 'a') => ('fneu', 'b', 0.0) */
   /* search330_0_0 -> 0 in the cache */
   /* search330_0_1 -> 3 in the cache */
   /* search330_0 -> 198 in the cache */
   /* search330_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 198, 0 },
      -1,
   } },

   /* replace330_0 -> 3 in the cache */
   /* replace330_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 3, 241 },
      -1,
   } },

   /* ('~flt', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('flt', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search331_0_0 -> 124 in the cache */
   /* search331_0_1 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 124, 268 },
      0,
   } },
   /* search331_1 -> 760 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1135, 760 },
      -1,
   } },

   /* replace331_0 -> 124 in the cache */
   /* replace331_1_0 -> 127 in the cache */
   /* replace331_1_1_0 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 125 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 127, 1137 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 124, 1138 },
      -1,
   } },

   /* ('~flt', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('flt', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search332_0_0_0 -> 124 in the cache */
   /* search332_0_0_1 -> 268 in the cache */
   /* search332_0_0 -> 1135 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1135 },
      0,
   } },
   /* search332_1 -> 760 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1140, 760 },
      -1,
   } },

   /* replace332_0_0_0 -> 127 in the cache */
   /* replace332_0_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 127, 125 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1142 },
      -1,
   } },
   /* replace332_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1143, 124 },
      -1,
   } },

   /* ('~fge', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fge', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search333_0_0 -> 124 in the cache */
   /* search333_0_1 -> 268 in the cache */
   /* search333_0 -> 1135 in the cache */
   /* search333_1 -> 760 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1135, 760 },
      -1,
   } },

   /* replace333_0 -> 124 in the cache */
   /* replace333_1_0 -> 127 in the cache */
   /* replace333_1_1_0 -> 125 in the cache */
   /* replace333_1_1 -> 1137 in the cache */
   /* replace333_1 -> 1138 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 124, 1138 },
      -1,
   } },

   /* ('~fge', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fge', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search334_0_0_0 -> 124 in the cache */
   /* search334_0_0_1 -> 268 in the cache */
   /* search334_0_0 -> 1135 in the cache */
   /* search334_0 -> 1140 in the cache */
   /* search334_1 -> 760 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1140, 760 },
      -1,
   } },

   /* replace334_0_0_0 -> 127 in the cache */
   /* replace334_0_0_1 -> 125 in the cache */
   /* replace334_0_0 -> 1142 in the cache */
   /* replace334_0 -> 1143 in the cache */
   /* replace334_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1143, 124 },
      -1,
   } },

   /* ('~feq', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('feq', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search335_0_0 -> 124 in the cache */
   /* search335_0_1 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 124, 268 },
      0,
   } },
   /* search335_1 -> 760 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1149, 760 },
      -1,
   } },

   /* replace335_0 -> 124 in the cache */
   /* replace335_1_0 -> 127 in the cache */
   /* replace335_1_1_0 -> 125 in the cache */
   /* replace335_1_1 -> 1137 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 127, 1137 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 124, 1151 },
      -1,
   } },

   /* ('~feq', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('feq', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search336_0_0_0 -> 124 in the cache */
   /* search336_0_0_1 -> 268 in the cache */
   /* search336_0_0 -> 1149 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1149 },
      0,
   } },
   /* search336_1 -> 760 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1153, 760 },
      -1,
   } },

   /* replace336_0_0_0 -> 127 in the cache */
   /* replace336_0_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 127, 125 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1155 },
      -1,
   } },
   /* replace336_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 2,
      { 1156, 124 },
      -1,
   } },

   /* ('~fneu', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fneu', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search337_0_0 -> 124 in the cache */
   /* search337_0_1 -> 268 in the cache */
   /* search337_0 -> 1149 in the cache */
   /* search337_1 -> 760 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1149, 760 },
      -1,
   } },

   /* replace337_0 -> 124 in the cache */
   /* replace337_1_0 -> 127 in the cache */
   /* replace337_1_1_0 -> 125 in the cache */
   /* replace337_1_1 -> 1137 in the cache */
   /* replace337_1 -> 1151 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 124, 1151 },
      -1,
   } },

   /* ('~fneu', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fneu', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search338_0_0_0 -> 124 in the cache */
   /* search338_0_0_1 -> 268 in the cache */
   /* search338_0_0 -> 1149 in the cache */
   /* search338_0 -> 1153 in the cache */
   /* search338_1 -> 760 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1153, 760 },
      -1,
   } },

   /* replace338_0_0_0 -> 127 in the cache */
   /* replace338_0_0_1 -> 125 in the cache */
   /* replace338_0_0 -> 1155 in the cache */
   /* replace338_0 -> 1156 in the cache */
   /* replace338_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 2,
      { 1156, 124 },
      -1,
   } },

   /* ('ieq', ('iadd', 'a', 'b'), 'a') => ('ieq', 'b', 0) */
   /* search339_0_0 -> 0 in the cache */
   /* search339_0_1 -> 3 in the cache */
   /* search339_0 -> 193 in the cache */
   /* search339_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 193, 0 },
      -1,
   } },

   /* replace339_0 -> 3 in the cache */
   /* replace339_1 -> 86 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 3, 86 },
      -1,
   } },

   /* ('ine', ('iadd', 'a', 'b'), 'a') => ('ine', 'b', 0) */
   /* search340_0_0 -> 0 in the cache */
   /* search340_0_1 -> 3 in the cache */
   /* search340_0 -> 193 in the cache */
   /* search340_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 193, 0 },
      -1,
   } },

   /* replace340_0 -> 3 in the cache */
   /* replace340_1 -> 86 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 3, 86 },
      -1,
   } },

   /* ('feq', ('b2f', 'a@1'), 0.0) => ('inot', 'a') */
   /* search341_0_0 -> 706 in the cache */
   /* search341_0 -> 1070 in the cache */
   /* search341_1 -> 1069 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1070, 1069 },
      -1,
   } },

   /* replace341_0 -> 706 in the cache */
   /* replace341 -> 1072 in the cache */

   /* ('fneu', ('b2f', 'a@1'), 0.0) => a */
   /* search342_0_0 -> 706 in the cache */
   /* search342_0 -> 1070 in the cache */
   /* search342_1 -> 1069 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1070, 1069 },
      -1,
   } },

   /* replace342 -> 706 in the cache */

   /* ('ieq', ('b2i', 'a@1'), 0) => ('inot', 'a') */
   /* search343_0_0 -> 706 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 0,
      { 706 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 0 },
      nir_type_int, { 0x0 /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1168, 1169 },
      -1,
   } },

   /* replace343_0 -> 706 in the cache */
   /* replace343 -> 1072 in the cache */

   /* ('ine', ('b2i', 'a@1'), 0) => a */
   /* search344_0_0 -> 706 in the cache */
   /* search344_0 -> 1168 in the cache */
   /* search344_1 -> 1169 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1168, 1169 },
      -1,
   } },

   /* replace344 -> 706 in the cache */

   /* ('fneu', ('u2f', 'a'), 0.0) => ('ine', 'a', 0) */
   /* search345_0_0 -> 32 in the cache */
   /* search345_0 -> 104 in the cache */
   /* search345_1 -> 1069 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 104, 1069 },
      -1,
   } },

   /* replace345_0 -> 32 in the cache */
   /* replace345_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* ('feq', ('u2f', 'a'), 0.0) => ('ieq', 'a', 0) */
   /* search346_0_0 -> 32 in the cache */
   /* search346_0 -> 104 in the cache */
   /* search346_1 -> 1069 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 104, 1069 },
      -1,
   } },

   /* replace346_0 -> 32 in the cache */
   /* replace346_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* ('fge', ('u2f', 'a'), 0.0) => True */
   /* search347_0_0 -> 32 in the cache */
   /* search347_0 -> 104 in the cache */
   /* search347_1 -> 1069 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 104, 1069 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, 1 },
      nir_type_bool, { NIR_TRUE /* True */ },
   } },

   /* ('fge', 0.0, ('u2f', 'a')) => ('uge', 0, 'a') */
   /* search348_0 -> 1069 in the cache */
   /* search348_1_0 -> 32 in the cache */
   /* search348_1 -> 104 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1069, 104 },
      -1,
   } },

   /* replace348_0 -> 61 in the cache */
   /* replace348_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 61, 32 },
      -1,
   } },

   /* ('flt', ('u2f', 'a'), 0.0) => False */
   /* search349_0_0 -> 32 in the cache */
   /* search349_0 -> 104 in the cache */
   /* search349_1 -> 1069 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 104, 1069 },
      -1,
   } },

   /* replace349 -> 1024 in the cache */

   /* ('flt', 0.0, ('u2f', 'a')) => ('ult', 0, 'a') */
   /* search350_0 -> 1069 in the cache */
   /* search350_1_0 -> 32 in the cache */
   /* search350_1 -> 104 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1069, 104 },
      -1,
   } },

   /* replace350_0 -> 61 in the cache */
   /* replace350_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 61, 32 },
      -1,
   } },

   /* ('fneu', ('i2f', 'a'), 0.0) => ('ine', 'a', 0) */
   /* search351_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_i2f,
      -1, 0,
      { 32 },
      -1,
   } },
   /* search351_1 -> 1069 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1183, 1069 },
      -1,
   } },

   /* replace351_0 -> 32 in the cache */
   /* replace351_1 -> 61 in the cache */
   /* replace351 -> 1173 in the cache */

   /* ('feq', ('i2f', 'a'), 0.0) => ('ieq', 'a', 0) */
   /* search352_0_0 -> 32 in the cache */
   /* search352_0 -> 1183 in the cache */
   /* search352_1 -> 1069 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1183, 1069 },
      -1,
   } },

   /* replace352_0 -> 32 in the cache */
   /* replace352_1 -> 61 in the cache */
   /* replace352 -> 1175 in the cache */

   /* ('fge', ('i2f', 'a'), 0.0) => ('ige', 'a', 0) */
   /* search353_0_0 -> 32 in the cache */
   /* search353_0 -> 1183 in the cache */
   /* search353_1 -> 1069 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1183, 1069 },
      -1,
   } },

   /* replace353_0 -> 32 in the cache */
   /* replace353_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 32, 61 },
      -1,
   } },

   /* ('fge', 0.0, ('i2f', 'a')) => ('ige', 0, 'a') */
   /* search354_0 -> 1069 in the cache */
   /* search354_1_0 -> 32 in the cache */
   /* search354_1 -> 1183 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1069, 1183 },
      -1,
   } },

   /* replace354_0 -> 61 in the cache */
   /* replace354_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 61, 32 },
      -1,
   } },

   /* ('flt', ('i2f', 'a'), 0.0) => ('ilt', 'a', 0) */
   /* search355_0_0 -> 32 in the cache */
   /* search355_0 -> 1183 in the cache */
   /* search355_1 -> 1069 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1183, 1069 },
      -1,
   } },

   /* replace355_0 -> 32 in the cache */
   /* replace355_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 32, 61 },
      -1,
   } },

   /* ('flt', 0.0, ('i2f', 'a')) => ('ilt', 0, 'a') */
   /* search356_0 -> 1069 in the cache */
   /* search356_1_0 -> 32 in the cache */
   /* search356_1 -> 1183 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1069, 1183 },
      -1,
   } },

   /* replace356_0 -> 61 in the cache */
   /* replace356_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 61, 32 },
      -1,
   } },

   /* ('~flt', 0.0, ('fabs', 'a')) => ('fneu', 'a', 0.0) */
   /* search357_0 -> 113 in the cache */
   /* search357_1_0 -> 32 in the cache */
   /* search357_1 -> 103 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 113, 103 },
      -1,
   } },

   /* replace357_0 -> 32 in the cache */
   /* replace357_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 32, 113 },
      -1,
   } },

   /* ('~flt', ('fneg', ('fabs', 'a')), 0.0) => ('fneu', 'a', 0.0) */
   /* search358_0_0_0 -> 32 in the cache */
   /* search358_0_0 -> 103 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 103 },
      -1,
   } },
   /* search358_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1196, 113 },
      -1,
   } },

   /* replace358_0 -> 32 in the cache */
   /* replace358_1 -> 113 in the cache */
   /* replace358 -> 1195 in the cache */

   /* ('fge', 0.0, ('fabs', 'a')) => ('feq', 'a', 0.0) */
   /* search359_0 -> 113 in the cache */
   /* search359_1_0 -> 32 in the cache */
   /* search359_1 -> 103 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 113, 103 },
      -1,
   } },

   /* replace359_0 -> 32 in the cache */
   /* replace359_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 32, 113 },
      -1,
   } },

   /* ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0) */
   /* search360_0_0_0 -> 32 in the cache */
   /* search360_0_0 -> 103 in the cache */
   /* search360_0 -> 1196 in the cache */
   /* search360_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1196, 113 },
      -1,
   } },

   /* replace360_0 -> 32 in the cache */
   /* replace360_1 -> 113 in the cache */
   /* replace360 -> 1199 in the cache */

   /* ('iand', ('fge', 'a', 0.0), ('fge', 1.0, 'a')) => ('feq', 'a', ('fsat', 'a')) */
   /* search361_0_0 -> 32 in the cache */
   /* search361_0_1 -> 113 in the cache */
   /* search361_0 -> 1114 in the cache */
   /* search361_1_0 -> 226 in the cache */
   /* search361_1_1 -> 32 in the cache */
   /* search361_1 -> 1047 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1114, 1047 },
      -1,
   } },

   /* replace361_0 -> 32 in the cache */
   /* replace361_1_0 -> 32 in the cache */
   /* replace361_1 -> 202 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 32, 202 },
      -1,
   } },

   /* ('fmax', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('ior', 'a', 'b')) */
   /* search362_0_0 -> 706 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 706 },
      0,
   } },
   /* search362_1_0 -> 1075 in the cache */
   /* search362_1 -> 1076 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1203, 1076 },
      -1,
   } },

   /* replace362_0_0 -> 706 in the cache */
   /* replace362_0_1 -> 1075 in the cache */
   /* replace362_0 -> 1079 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 1,
      { 1079 },
      -1,
   } },

   /* ('fmax', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('iand', 'a', 'b'))) */
   /* search363_0_0_0 -> 706 in the cache */
   /* search363_0_0 -> 1203 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1203 },
      0,
   } },
   /* search363_1_0_0 -> 1075 in the cache */
   /* search363_1_0 -> 1076 in the cache */
   /* search363_1 -> 1083 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1206, 1083 },
      -1,
   } },

   /* replace363_0_0_0 -> 706 in the cache */
   /* replace363_0_0_1 -> 1075 in the cache */
   /* replace363_0_0 -> 1087 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 1,
      { 1087 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1208 },
      -1,
   } },

   /* ('fmin', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b')) */
   /* search364_0_0 -> 706 in the cache */
   /* search364_0 -> 1203 in the cache */
   /* search364_1_0 -> 1075 in the cache */
   /* search364_1 -> 1076 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1203, 1076 },
      -1,
   } },

   /* replace364_0_0 -> 706 in the cache */
   /* replace364_0_1 -> 1075 in the cache */
   /* replace364_0 -> 1087 in the cache */
   /* replace364 -> 1208 in the cache */

   /* ('fmin', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('ior', 'a', 'b'))) */
   /* search365_0_0_0 -> 706 in the cache */
   /* search365_0_0 -> 1203 in the cache */
   /* search365_0 -> 1206 in the cache */
   /* search365_1_0_0 -> 1075 in the cache */
   /* search365_1_0 -> 1076 in the cache */
   /* search365_1 -> 1083 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1206, 1083 },
      -1,
   } },

   /* replace365_0_0_0 -> 706 in the cache */
   /* replace365_0_0_1 -> 1075 in the cache */
   /* replace365_0_0 -> 1079 in the cache */
   /* replace365_0 -> 1205 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1205 },
      -1,
   } },

   /* ('fmin', ('b2f', 'a@1'), '#b') => ('bcsel', 'a', ('fmin', 'b', 1.0), ('fmin', 'b', 0.0)) */
   /* search366_0_0 -> 706 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 706 },
      -1,
   } },
   /* search366_1 -> 767 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1213, 767 },
      -1,
   } },

   /* replace366_0 -> 706 in the cache */
   /* replace366_1_0 -> 3 in the cache */
   /* replace366_1_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 3, 255 },
      -1,
   } },
   /* replace366_2_0 -> 3 in the cache */
   /* replace366_2_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 3, 241 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 706, 1215, 1216 },
      -1,
   } },

   /* ('flt', ('fadd(is_used_once)', 'a', ('fneg', 'b')), 0.0) => ('flt', 'a', 'b') */
   /* search367_0_0 -> 0 in the cache */
   /* search367_0_1_0 -> 3 in the cache */
   /* search367_0_1 -> 1034 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 0, 1034 },
      0,
   } },
   /* search367_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1218, 241 },
      -1,
   } },

   /* replace367_0 -> 0 in the cache */
   /* replace367_1 -> 3 in the cache */
   /* replace367 -> 996 in the cache */

   /* ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0) */
   /* search368_0_0_0 -> 32 in the cache */
   /* search368_0_0 -> 103 in the cache */
   /* search368_0 -> 1196 in the cache */
   /* search368_1 -> 113 in the cache */
   /* search368 -> 1200 in the cache */

   /* replace368_0 -> 32 in the cache */
   /* replace368_1 -> 113 in the cache */
   /* replace368 -> 1199 in the cache */

   /* ('~bcsel', ('flt', 'b', 'a'), 'b', 'a') => ('fmin', 'a', 'b') */
   /* search369_0_0 -> 1058 in the cache */
   /* search369_0_1 -> 1055 in the cache */
   /* search369_0 -> 1059 in the cache */
   /* search369_1 -> 1058 in the cache */
   /* search369_2 -> 1055 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1059, 1058, 1055 },
      -1,
   } },

   /* replace369_0 -> 1055 in the cache */
   /* replace369_1 -> 1058 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1055, 1058 },
      -1,
   } },

   /* ('~bcsel', ('flt', 'a', 'b'), 'b', 'a') => ('fmax', 'a', 'b') */
   /* search370_0_0 -> 0 in the cache */
   /* search370_0_1 -> 3 in the cache */
   /* search370_0 -> 996 in the cache */
   /* search370_1 -> 3 in the cache */
   /* search370_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 996, 3, 0 },
      -1,
   } },

   /* replace370_0 -> 0 in the cache */
   /* replace370_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('~bcsel', ('fge', 'a', 'b'), 'b', 'a') => ('fmin', 'a', 'b') */
   /* search371_0_0 -> 0 in the cache */
   /* search371_0_1 -> 3 in the cache */
   /* search371_0 -> 993 in the cache */
   /* search371_1 -> 3 in the cache */
   /* search371_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 993, 3, 0 },
      -1,
   } },

   /* replace371_0 -> 0 in the cache */
   /* replace371_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('~bcsel', ('fge', 'b', 'a'), 'b', 'a') => ('fmax', 'a', 'b') */
   /* search372_0_0 -> 1058 in the cache */
   /* search372_0_1 -> 1055 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1058, 1055 },
      -1,
   } },
   /* search372_1 -> 1058 in the cache */
   /* search372_2 -> 1055 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1226, 1058, 1055 },
      -1,
   } },

   /* replace372_0 -> 1055 in the cache */
   /* replace372_1 -> 1058 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1055, 1058 },
      -1,
   } },

   /* ('bcsel', ('i2b', 'a'), 'b', 'c') => ('bcsel', ('ine', 'a', 0), 'b', 'c') */
   /* search373_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_search_op_i2b,
      -1, 0,
      { 32 },
      -1,
   } },
   /* search373_1 -> 125 in the cache */
   /* search373_2 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1229, 125, 127 },
      -1,
   } },

   /* replace373_0_0 -> 32 in the cache */
   /* replace373_0_1 -> 61 in the cache */
   /* replace373_0 -> 1173 in the cache */
   /* replace373_1 -> 125 in the cache */
   /* replace373_2 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 1,
      { 1173, 125, 127 },
      -1,
   } },

   /* ('bcsel', ('inot', 'a'), 'b', 'c') => ('bcsel', 'a', 'c', 'b') */
   /* search374_0_0 -> 706 in the cache */
   /* search374_0 -> 1072 in the cache */
   /* search374_1 -> 125 in the cache */
   /* search374_2 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1072, 125, 127 },
      -1,
   } },

   /* replace374_0 -> 706 in the cache */
   /* replace374_1 -> 127 in the cache */
   /* replace374_2 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 127, 125 },
      -1,
   } },

   /* ('bcsel', 'a', ('bcsel', 'a', 'b', 'c'), 'd') => ('bcsel', 'a', 'b', 'd') */
   /* search375_0 -> 706 in the cache */
   /* search375_1_0 -> 706 in the cache */
   /* search375_1_1 -> 148 in the cache */
   /* search375_1_2 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 148, 150 },
      -1,
   } },
   /* search375_2 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 1234, 151 },
      -1,
   } },

   /* replace375_0 -> 706 in the cache */
   /* replace375_1 -> 148 in the cache */
   /* replace375_2 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 148, 151 },
      -1,
   } },

   /* ('bcsel', 'a', 'b', ('bcsel', 'a', 'c', 'd')) => ('bcsel', 'a', 'b', 'd') */
   /* search376_0 -> 706 in the cache */
   /* search376_1 -> 148 in the cache */
   /* search376_2_0 -> 706 in the cache */
   /* search376_2_1 -> 150 in the cache */
   /* search376_2_2 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 150, 151 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 148, 1237 },
      -1,
   } },

   /* replace376_0 -> 706 in the cache */
   /* replace376_1 -> 148 in the cache */
   /* replace376_2 -> 151 in the cache */
   /* replace376 -> 1236 in the cache */

   /* ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e')) */
   /* search377_0 -> 706 in the cache */
   /* search377_1_0 -> 1075 in the cache */
   /* search377_1_1 -> 699 in the cache */
   /* search377_1_2 -> 708 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1075, 699, 708 },
      -1,
   } },
   /* search377_2_0 -> 1075 in the cache */
   /* search377_2_1 -> 699 in the cache */
   /* search377_2_2 -> 710 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1075, 699, 710 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 1239, 1240 },
      -1,
   } },

   /* replace377_0 -> 1075 in the cache */
   /* replace377_1 -> 699 in the cache */
   /* replace377_2_0 -> 706 in the cache */
   /* replace377_2_1 -> 708 in the cache */
   /* replace377_2_2 -> 710 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 708, 710 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1075, 699, 1242 },
      -1,
   } },

   /* ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e')) */
   /* search378_0 -> 706 in the cache */
   /* search378_1_0 -> 1075 in the cache */
   /* search378_1_1 -> 699 in the cache */
   /* search378_1_2 -> 708 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1075, 699, 708 },
      0,
   } },
   /* search378_2_0 -> 1075 in the cache */
   /* search378_2_1 -> 699 in the cache */
   /* search378_2_2 -> 710 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1075, 699, 710 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 1244, 1245 },
      -1,
   } },

   /* replace378_0 -> 1075 in the cache */
   /* replace378_1 -> 699 in the cache */
   /* replace378_2_0 -> 706 in the cache */
   /* replace378_2_1 -> 708 in the cache */
   /* replace378_2_2 -> 710 in the cache */
   /* replace378_2 -> 1242 in the cache */
   /* replace378 -> 1243 in the cache */

   /* ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd') */
   /* search379_0 -> 706 in the cache */
   /* search379_1_0 -> 1075 in the cache */
   /* search379_1_1 -> 150 in the cache */
   /* search379_1_2 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1075, 150, 151 },
      -1,
   } },
   /* search379_2_0 -> 1075 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      4, /* e */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search379_2_2 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1075, 1248, 151 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 1247, 1249 },
      -1,
   } },

   /* replace379_0 -> 1075 in the cache */
   /* replace379_1_0 -> 706 in the cache */
   /* replace379_1_1 -> 150 in the cache */
   /* replace379_1_2 -> 1248 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 150, 1248 },
      -1,
   } },
   /* replace379_2 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1075, 1251, 151 },
      -1,
   } },

   /* ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd') */
   /* search380_0 -> 706 in the cache */
   /* search380_1_0 -> 1075 in the cache */
   /* search380_1_1 -> 150 in the cache */
   /* search380_1_2 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1075, 150, 151 },
      0,
   } },
   /* search380_2_0 -> 1075 in the cache */
   /* search380_2_1 -> 1248 in the cache */
   /* search380_2_2 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1075, 1248, 151 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 1253, 1254 },
      -1,
   } },

   /* replace380_0 -> 1075 in the cache */
   /* replace380_1_0 -> 706 in the cache */
   /* replace380_1_1 -> 150 in the cache */
   /* replace380_1_2 -> 1248 in the cache */
   /* replace380_1 -> 1251 in the cache */
   /* replace380_2 -> 151 in the cache */
   /* replace380 -> 1252 in the cache */

   /* ('bcsel', 'a', True, 'b') => ('ior', 'a', 'b') */
   /* search381_0 -> 706 in the cache */
   /* search381_1 -> 1177 in the cache */
   /* search381_2 -> 1075 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 1177, 1075 },
      -1,
   } },

   /* replace381_0 -> 706 in the cache */
   /* replace381_1 -> 1075 in the cache */
   /* replace381 -> 1079 in the cache */

   /* ('bcsel', 'a', 'a', 'b') => ('ior', 'a', 'b') */
   /* search382_0 -> 706 in the cache */
   /* search382_1 -> 706 in the cache */
   /* search382_2 -> 1075 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 706, 1075 },
      -1,
   } },

   /* replace382_0 -> 706 in the cache */
   /* replace382_1 -> 1075 in the cache */
   /* replace382 -> 1079 in the cache */

   /* ('bcsel', 'a', 'b', False) => ('iand', 'a', 'b') */
   /* search383_0 -> 706 in the cache */
   /* search383_1 -> 1075 in the cache */
   /* search383_2 -> 1024 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 1075, 1024 },
      -1,
   } },

   /* replace383_0 -> 706 in the cache */
   /* replace383_1 -> 1075 in the cache */
   /* replace383 -> 1087 in the cache */

   /* ('bcsel', 'a', 'b', 'a') => ('iand', 'a', 'b') */
   /* search384_0 -> 706 in the cache */
   /* search384_1 -> 1075 in the cache */
   /* search384_2 -> 706 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 1075, 706 },
      -1,
   } },

   /* replace384_0 -> 706 in the cache */
   /* replace384_1 -> 1075 in the cache */
   /* replace384 -> 1087 in the cache */

   /* ('~fmin', 'a', 'a') => a */
   /* search385_0 -> 32 in the cache */
   /* search385_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmin,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace385 -> 32 in the cache */

   /* ('~fmax', 'a', 'a') => a */
   /* search386_0 -> 32 in the cache */
   /* search386_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmax,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace386 -> 32 in the cache */

   /* ('imin', 'a', 'a') => a */
   /* search387_0 -> 32 in the cache */
   /* search387_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imin,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace387 -> 32 in the cache */

   /* ('imax', 'a', 'a') => a */
   /* search388_0 -> 32 in the cache */
   /* search388_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imax,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace388 -> 32 in the cache */

   /* ('umin', 'a', 'a') => a */
   /* search389_0 -> 32 in the cache */
   /* search389_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umin,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace389 -> 32 in the cache */

   /* ('umin', 'a', 0) => 0 */
   /* search390_0 -> 32 in the cache */
   /* search390_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace390 -> 61 in the cache */

   /* ('umin', 'a', -1) => a */
   /* search391_0 -> 32 in the cache */
   /* search391_1 -> 63 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 32, 63 },
      -1,
   } },

   /* replace391 -> 32 in the cache */

   /* ('umax', 'a', 'a') => a */
   /* search392_0 -> 32 in the cache */
   /* search392_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umax,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace392 -> 32 in the cache */

   /* ('umax', 'a', 0) => a */
   /* search393_0 -> 32 in the cache */
   /* search393_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace393 -> 32 in the cache */

   /* ('umax', 'a', -1) => -1 */
   /* search394_0 -> 32 in the cache */
   /* search394_1 -> 63 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 32, 63 },
      -1,
   } },

   /* replace394 -> 63 in the cache */

   /* ('fmax', ('fmax', 'a', 'b'), 'b') => ('fmax', 'a', 'b') */
   /* search395_0_0 -> 0 in the cache */
   /* search395_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search395_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1270, 3 },
      -1,
   } },

   /* replace395_0 -> 0 in the cache */
   /* replace395_1 -> 3 in the cache */
   /* replace395 -> 1223 in the cache */

   /* ('umax', ('umax', 'a', 'b'), 'b') => ('umax', 'a', 'b') */
   /* search396_0_0 -> 0 in the cache */
   /* search396_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umax,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search396_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umax,
      0, 2,
      { 1272, 3 },
      -1,
   } },

   /* replace396_0 -> 0 in the cache */
   /* replace396_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('imax', ('imax', 'a', 'b'), 'b') => ('imax', 'a', 'b') */
   /* search397_0_0 -> 0 in the cache */
   /* search397_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imax,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search397_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imax,
      0, 2,
      { 1275, 3 },
      -1,
   } },

   /* replace397_0 -> 0 in the cache */
   /* replace397_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('fmin', ('fmin', 'a', 'b'), 'b') => ('fmin', 'a', 'b') */
   /* search398_0_0 -> 0 in the cache */
   /* search398_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search398_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1278, 3 },
      -1,
   } },

   /* replace398_0 -> 0 in the cache */
   /* replace398_1 -> 3 in the cache */
   /* replace398 -> 1225 in the cache */

   /* ('umin', ('umin', 'a', 'b'), 'b') => ('umin', 'a', 'b') */
   /* search399_0_0 -> 0 in the cache */
   /* search399_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umin,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search399_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umin,
      0, 2,
      { 1280, 3 },
      -1,
   } },

   /* replace399_0 -> 0 in the cache */
   /* replace399_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('imin', ('imin', 'a', 'b'), 'b') => ('imin', 'a', 'b') */
   /* search400_0_0 -> 0 in the cache */
   /* search400_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imin,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search400_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imin,
      0, 2,
      { 1283, 3 },
      -1,
   } },

   /* replace400_0 -> 0 in the cache */
   /* replace400_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('fmax', ('fmax', ('fmax', 'a', 'b'), 'c'), 'a') => ('fmax', ('fmax', 'a', 'b'), 'c') */
   /* search401_0_0_0 -> 124 in the cache */
   /* search401_0_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      2, 1,
      { 124, 125 },
      -1,
   } },
   /* search401_0_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      1, 2,
      { 1286, 127 },
      -1,
   } },
   /* search401_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 3,
      { 1287, 124 },
      -1,
   } },

   /* replace401_0_0 -> 124 in the cache */
   /* replace401_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 124, 125 },
      -1,
   } },
   /* replace401_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1289, 127 },
      -1,
   } },

   /* ('umax', ('umax', ('umax', 'a', 'b'), 'c'), 'a') => ('umax', ('umax', 'a', 'b'), 'c') */
   /* search402_0_0_0 -> 124 in the cache */
   /* search402_0_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      2, 1,
      { 124, 125 },
      -1,
   } },
   /* search402_0_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      1, 2,
      { 1291, 127 },
      -1,
   } },
   /* search402_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      0, 3,
      { 1292, 124 },
      -1,
   } },

   /* replace402_0_0 -> 124 in the cache */
   /* replace402_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      1, 1,
      { 124, 125 },
      -1,
   } },
   /* replace402_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      0, 2,
      { 1294, 127 },
      -1,
   } },

   /* ('imax', ('imax', ('imax', 'a', 'b'), 'c'), 'a') => ('imax', ('imax', 'a', 'b'), 'c') */
   /* search403_0_0_0 -> 124 in the cache */
   /* search403_0_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      2, 1,
      { 124, 125 },
      -1,
   } },
   /* search403_0_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      1, 2,
      { 1296, 127 },
      -1,
   } },
   /* search403_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      0, 3,
      { 1297, 124 },
      -1,
   } },

   /* replace403_0_0 -> 124 in the cache */
   /* replace403_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      1, 1,
      { 124, 125 },
      -1,
   } },
   /* replace403_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      0, 2,
      { 1299, 127 },
      -1,
   } },

   /* ('fmin', ('fmin', ('fmin', 'a', 'b'), 'c'), 'a') => ('fmin', ('fmin', 'a', 'b'), 'c') */
   /* search404_0_0_0 -> 124 in the cache */
   /* search404_0_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      2, 1,
      { 124, 125 },
      -1,
   } },
   /* search404_0_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 2,
      { 1301, 127 },
      -1,
   } },
   /* search404_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 3,
      { 1302, 124 },
      -1,
   } },

   /* replace404_0_0 -> 124 in the cache */
   /* replace404_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 124, 125 },
      -1,
   } },
   /* replace404_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1304, 127 },
      -1,
   } },

   /* ('umin', ('umin', ('umin', 'a', 'b'), 'c'), 'a') => ('umin', ('umin', 'a', 'b'), 'c') */
   /* search405_0_0_0 -> 124 in the cache */
   /* search405_0_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      2, 1,
      { 124, 125 },
      -1,
   } },
   /* search405_0_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      1, 2,
      { 1306, 127 },
      -1,
   } },
   /* search405_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      0, 3,
      { 1307, 124 },
      -1,
   } },

   /* replace405_0_0 -> 124 in the cache */
   /* replace405_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      1, 1,
      { 124, 125 },
      -1,
   } },
   /* replace405_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      0, 2,
      { 1309, 127 },
      -1,
   } },

   /* ('imin', ('imin', ('imin', 'a', 'b'), 'c'), 'a') => ('imin', ('imin', 'a', 'b'), 'c') */
   /* search406_0_0_0 -> 124 in the cache */
   /* search406_0_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      2, 1,
      { 124, 125 },
      -1,
   } },
   /* search406_0_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      1, 2,
      { 1311, 127 },
      -1,
   } },
   /* search406_1 -> 124 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      0, 3,
      { 1312, 124 },
      -1,
   } },

   /* replace406_0_0 -> 124 in the cache */
   /* replace406_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      1, 1,
      { 124, 125 },
      -1,
   } },
   /* replace406_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      0, 2,
      { 1314, 127 },
      -1,
   } },

   /* ('ieq', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ieq', 'a', 'b') */
   /* search407_0_0 -> 706 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_b2i8,
      -1, 0,
      { 706 },
      -1,
   } },
   /* search407_1_0 -> 1075 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_b2i8,
      -1, 0,
      { 1075 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1316, 1317 },
      -1,
   } },

   /* replace407_0 -> 706 in the cache */
   /* replace407_1 -> 1075 in the cache */
   /* replace407 -> 1103 in the cache */

   /* ('ine', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ine', 'a', 'b') */
   /* search408_0_0 -> 706 in the cache */
   /* search408_0 -> 1316 in the cache */
   /* search408_1_0 -> 1075 in the cache */
   /* search408_1 -> 1317 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1316, 1317 },
      -1,
   } },

   /* replace408_0 -> 706 in the cache */
   /* replace408_1 -> 1075 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 706, 1075 },
      -1,
   } },

   /* ('ieq', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ieq', 'a', 'b') */
   /* search409_0_0 -> 706 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 706 },
      -1,
   } },
   /* search409_1_0 -> 1075 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 1075 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1321, 1322 },
      -1,
   } },

   /* replace409_0 -> 706 in the cache */
   /* replace409_1 -> 1075 in the cache */
   /* replace409 -> 1103 in the cache */

   /* ('ine', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ine', 'a', 'b') */
   /* search410_0_0 -> 706 in the cache */
   /* search410_0 -> 1321 in the cache */
   /* search410_1_0 -> 1075 in the cache */
   /* search410_1 -> 1322 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1321, 1322 },
      -1,
   } },

   /* replace410_0 -> 706 in the cache */
   /* replace410_1 -> 1075 in the cache */
   /* replace410 -> 1320 in the cache */

   /* ('ieq', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ieq', 'a', 'b') */
   /* search411_0_0 -> 706 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 706 },
      -1,
   } },
   /* search411_1_0 -> 1075 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1075 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1325, 1326 },
      -1,
   } },

   /* replace411_0 -> 706 in the cache */
   /* replace411_1 -> 1075 in the cache */
   /* replace411 -> 1103 in the cache */

   /* ('ine', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ine', 'a', 'b') */
   /* search412_0_0 -> 706 in the cache */
   /* search412_0 -> 1325 in the cache */
   /* search412_1_0 -> 1075 in the cache */
   /* search412_1 -> 1326 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1325, 1326 },
      -1,
   } },

   /* replace412_0 -> 706 in the cache */
   /* replace412_1 -> 1075 in the cache */
   /* replace412 -> 1320 in the cache */

   /* ('ieq', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ieq', 'a', 'b') */
   /* search413_0_0 -> 706 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 706 },
      -1,
   } },
   /* search413_1_0 -> 1075 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 1075 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1329, 1330 },
      -1,
   } },

   /* replace413_0 -> 706 in the cache */
   /* replace413_1 -> 1075 in the cache */
   /* replace413 -> 1103 in the cache */

   /* ('ine', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ine', 'a', 'b') */
   /* search414_0_0 -> 706 in the cache */
   /* search414_0 -> 1329 in the cache */
   /* search414_1_0 -> 1075 in the cache */
   /* search414_1 -> 1330 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1329, 1330 },
      -1,
   } },

   /* replace414_0 -> 706 in the cache */
   /* replace414_1 -> 1075 in the cache */
   /* replace414 -> 1320 in the cache */

   /* ('feq', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ieq', 'a', 'b') */
   /* search415_0_0 -> 706 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2f16,
      -1, 0,
      { 706 },
      -1,
   } },
   /* search415_1_0 -> 1075 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2f16,
      -1, 0,
      { 1075 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1333, 1334 },
      -1,
   } },

   /* replace415_0 -> 706 in the cache */
   /* replace415_1 -> 1075 in the cache */
   /* replace415 -> 1103 in the cache */

   /* ('fneu', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ine', 'a', 'b') */
   /* search416_0_0 -> 706 in the cache */
   /* search416_0 -> 1333 in the cache */
   /* search416_1_0 -> 1075 in the cache */
   /* search416_1 -> 1334 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1333, 1334 },
      -1,
   } },

   /* replace416_0 -> 706 in the cache */
   /* replace416_1 -> 1075 in the cache */
   /* replace416 -> 1320 in the cache */

   /* ('feq', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ieq', 'a', 'b') */
   /* search417_0_0 -> 706 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2f32,
      -1, 0,
      { 706 },
      -1,
   } },
   /* search417_1_0 -> 1075 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2f32,
      -1, 0,
      { 1075 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1337, 1338 },
      -1,
   } },

   /* replace417_0 -> 706 in the cache */
   /* replace417_1 -> 1075 in the cache */
   /* replace417 -> 1103 in the cache */

   /* ('fneu', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ine', 'a', 'b') */
   /* search418_0_0 -> 706 in the cache */
   /* search418_0 -> 1337 in the cache */
   /* search418_1_0 -> 1075 in the cache */
   /* search418_1 -> 1338 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1337, 1338 },
      -1,
   } },

   /* replace418_0 -> 706 in the cache */
   /* replace418_1 -> 1075 in the cache */
   /* replace418 -> 1320 in the cache */

   /* ('feq', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ieq', 'a', 'b') */
   /* search419_0_0 -> 706 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2f64,
      -1, 0,
      { 706 },
      -1,
   } },
   /* search419_1_0 -> 1075 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2f64,
      -1, 0,
      { 1075 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 1341, 1342 },
      -1,
   } },

   /* replace419_0 -> 706 in the cache */
   /* replace419_1 -> 1075 in the cache */
   /* replace419 -> 1103 in the cache */

   /* ('fneu', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ine', 'a', 'b') */
   /* search420_0_0 -> 706 in the cache */
   /* search420_0 -> 1341 in the cache */
   /* search420_1_0 -> 1075 in the cache */
   /* search420_1 -> 1342 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 1341, 1342 },
      -1,
   } },

   /* replace420_0 -> 706 in the cache */
   /* replace420_1 -> 1075 in the cache */
   /* replace420 -> 1320 in the cache */

   /* ('iand@8', 'a', ('inot', ('ishr', 'a', 7))) => ('imax', 'a', 0) */
   /* search421_0 -> 6 in the cache */
   /* search421_1_0_0 -> 6 in the cache */
   /* search421_1_0_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 6, 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1345 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 6, 1346 },
      -1,
   } },

   /* replace421_0 -> 6 in the cache */
   /* replace421_1 -> 782 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 6, 782 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@8', 128), 0) => ('ige', 'a', 0) */
   /* search422_0_0 -> 6 in the cache */
   /* search422_0_1 -> 7 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 6, 7 },
      -1,
   } },
   /* search422_1 -> 782 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1349, 782 },
      -1,
   } },

   /* replace422_0 -> 6 in the cache */
   /* replace422_1 -> 782 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 6, 782 },
      -1,
   } },

   /* ('ine', ('iand', 'a@8', 128), 128) => ('ige', 'a', 0) */
   /* search423_0_0 -> 6 in the cache */
   /* search423_0_1 -> 7 in the cache */
   /* search423_0 -> 1349 in the cache */
   /* search423_1 -> 7 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1349, 7 },
      -1,
   } },

   /* replace423_0 -> 6 in the cache */
   /* replace423_1 -> 782 in the cache */
   /* replace423 -> 1351 in the cache */

   /* ('ine', ('iand', 'a@8', 128), 0) => ('ilt', 'a', 0) */
   /* search424_0_0 -> 6 in the cache */
   /* search424_0_1 -> 7 in the cache */
   /* search424_0 -> 1349 in the cache */
   /* search424_1 -> 782 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1349, 782 },
      -1,
   } },

   /* replace424_0 -> 6 in the cache */
   /* replace424_1 -> 782 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 6, 782 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@8', 128), 128) => ('ilt', 'a', 0) */
   /* search425_0_0 -> 6 in the cache */
   /* search425_0_1 -> 7 in the cache */
   /* search425_0 -> 1349 in the cache */
   /* search425_1 -> 7 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1349, 7 },
      -1,
   } },

   /* replace425_0 -> 6 in the cache */
   /* replace425_1 -> 782 in the cache */
   /* replace425 -> 1354 in the cache */

   /* ('ine', ('ushr', 'a@8', 7), 0) => ('ilt', 'a', 0) */
   /* search426_0_0 -> 6 in the cache */
   /* search426_0_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 6, 9 },
      -1,
   } },
   /* search426_1 -> 782 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1356, 782 },
      -1,
   } },

   /* replace426_0 -> 6 in the cache */
   /* replace426_1 -> 782 in the cache */
   /* replace426 -> 1354 in the cache */

   /* ('ieq', ('ushr', 'a@8', 7), 0) => ('ige', 'a', 0) */
   /* search427_0_0 -> 6 in the cache */
   /* search427_0_1 -> 9 in the cache */
   /* search427_0 -> 1356 in the cache */
   /* search427_1 -> 782 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1356, 782 },
      -1,
   } },

   /* replace427_0 -> 6 in the cache */
   /* replace427_1 -> 782 in the cache */
   /* replace427 -> 1351 in the cache */

   /* ('ieq', ('ushr', 'a@8', 7), 1) => ('ilt', 'a', 0) */
   /* search428_0_0 -> 6 in the cache */
   /* search428_0_1 -> 9 in the cache */
   /* search428_0 -> 1356 in the cache */
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0x1 /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1356, 1359 },
      -1,
   } },

   /* replace428_0 -> 6 in the cache */
   /* replace428_1 -> 782 in the cache */
   /* replace428 -> 1354 in the cache */

   /* ('ine', ('ushr', 'a@8', 7), 1) => ('ige', 'a', 0) */
   /* search429_0_0 -> 6 in the cache */
   /* search429_0_1 -> 9 in the cache */
   /* search429_0 -> 1356 in the cache */
   /* search429_1 -> 1359 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1356, 1359 },
      -1,
   } },

   /* replace429_0 -> 6 in the cache */
   /* replace429_1 -> 782 in the cache */
   /* replace429 -> 1351 in the cache */

   /* ('ine', ('ishr', 'a@8', 7), 0) => ('ilt', 'a', 0) */
   /* search430_0_0 -> 6 in the cache */
   /* search430_0_1 -> 9 in the cache */
   /* search430_0 -> 1345 in the cache */
   /* search430_1 -> 782 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1345, 782 },
      -1,
   } },

   /* replace430_0 -> 6 in the cache */
   /* replace430_1 -> 782 in the cache */
   /* replace430 -> 1354 in the cache */

   /* ('ieq', ('ishr', 'a@8', 7), 0) => ('ige', 'a', 0) */
   /* search431_0_0 -> 6 in the cache */
   /* search431_0_1 -> 9 in the cache */
   /* search431_0 -> 1345 in the cache */
   /* search431_1 -> 782 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1345, 782 },
      -1,
   } },

   /* replace431_0 -> 6 in the cache */
   /* replace431_1 -> 782 in the cache */
   /* replace431 -> 1351 in the cache */

   /* ('ieq', ('ishr', 'a@8', 7), -1) => ('ilt', 'a', 0) */
   /* search432_0_0 -> 6 in the cache */
   /* search432_0_1 -> 9 in the cache */
   /* search432_0 -> 1345 in the cache */
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { -0x1 /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1345, 1364 },
      -1,
   } },

   /* replace432_0 -> 6 in the cache */
   /* replace432_1 -> 782 in the cache */
   /* replace432 -> 1354 in the cache */

   /* ('ine', ('ishr', 'a@8', 7), -1) => ('ige', 'a', 0) */
   /* search433_0_0 -> 6 in the cache */
   /* search433_0_1 -> 9 in the cache */
   /* search433_0 -> 1345 in the cache */
   /* search433_1 -> 1364 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1345, 1364 },
      -1,
   } },

   /* replace433_0 -> 6 in the cache */
   /* replace433_1 -> 782 in the cache */
   /* replace433 -> 1351 in the cache */

   /* ('iand@16', 'a', ('inot', ('ishr', 'a', 15))) => ('imax', 'a', 0) */
   /* search434_0 -> 11 in the cache */
   /* search434_1_0_0 -> 11 in the cache */
   /* search434_1_0_1 -> 14 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 11, 14 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1367 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 11, 1368 },
      -1,
   } },

   /* replace434_0 -> 11 in the cache */
   /* replace434_1 -> 804 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 11, 804 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@16', 32768), 0) => ('ige', 'a', 0) */
   /* search435_0_0 -> 11 in the cache */
   /* search435_0_1 -> 12 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 11, 12 },
      -1,
   } },
   /* search435_1 -> 804 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1371, 804 },
      -1,
   } },

   /* replace435_0 -> 11 in the cache */
   /* replace435_1 -> 804 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 11, 804 },
      -1,
   } },

   /* ('ine', ('iand', 'a@16', 32768), 32768) => ('ige', 'a', 0) */
   /* search436_0_0 -> 11 in the cache */
   /* search436_0_1 -> 12 in the cache */
   /* search436_0 -> 1371 in the cache */
   /* search436_1 -> 12 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1371, 12 },
      -1,
   } },

   /* replace436_0 -> 11 in the cache */
   /* replace436_1 -> 804 in the cache */
   /* replace436 -> 1373 in the cache */

   /* ('ine', ('iand', 'a@16', 32768), 0) => ('ilt', 'a', 0) */
   /* search437_0_0 -> 11 in the cache */
   /* search437_0_1 -> 12 in the cache */
   /* search437_0 -> 1371 in the cache */
   /* search437_1 -> 804 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1371, 804 },
      -1,
   } },

   /* replace437_0 -> 11 in the cache */
   /* replace437_1 -> 804 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 11, 804 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@16', 32768), 32768) => ('ilt', 'a', 0) */
   /* search438_0_0 -> 11 in the cache */
   /* search438_0_1 -> 12 in the cache */
   /* search438_0 -> 1371 in the cache */
   /* search438_1 -> 12 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1371, 12 },
      -1,
   } },

   /* replace438_0 -> 11 in the cache */
   /* replace438_1 -> 804 in the cache */
   /* replace438 -> 1376 in the cache */

   /* ('ine', ('ushr', 'a@16', 15), 0) => ('ilt', 'a', 0) */
   /* search439_0_0 -> 11 in the cache */
   /* search439_0_1 -> 14 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 11, 14 },
      -1,
   } },
   /* search439_1 -> 804 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1378, 804 },
      -1,
   } },

   /* replace439_0 -> 11 in the cache */
   /* replace439_1 -> 804 in the cache */
   /* replace439 -> 1376 in the cache */

   /* ('ieq', ('ushr', 'a@16', 15), 0) => ('ige', 'a', 0) */
   /* search440_0_0 -> 11 in the cache */
   /* search440_0_1 -> 14 in the cache */
   /* search440_0 -> 1378 in the cache */
   /* search440_1 -> 804 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1378, 804 },
      -1,
   } },

   /* replace440_0 -> 11 in the cache */
   /* replace440_1 -> 804 in the cache */
   /* replace440 -> 1373 in the cache */

   /* ('ieq', ('ushr', 'a@16', 15), 1) => ('ilt', 'a', 0) */
   /* search441_0_0 -> 11 in the cache */
   /* search441_0_1 -> 14 in the cache */
   /* search441_0 -> 1378 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0x1 /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1378, 1381 },
      -1,
   } },

   /* replace441_0 -> 11 in the cache */
   /* replace441_1 -> 804 in the cache */
   /* replace441 -> 1376 in the cache */

   /* ('ine', ('ushr', 'a@16', 15), 1) => ('ige', 'a', 0) */
   /* search442_0_0 -> 11 in the cache */
   /* search442_0_1 -> 14 in the cache */
   /* search442_0 -> 1378 in the cache */
   /* search442_1 -> 1381 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1378, 1381 },
      -1,
   } },

   /* replace442_0 -> 11 in the cache */
   /* replace442_1 -> 804 in the cache */
   /* replace442 -> 1373 in the cache */

   /* ('ine', ('ishr', 'a@16', 15), 0) => ('ilt', 'a', 0) */
   /* search443_0_0 -> 11 in the cache */
   /* search443_0_1 -> 14 in the cache */
   /* search443_0 -> 1367 in the cache */
   /* search443_1 -> 804 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1367, 804 },
      -1,
   } },

   /* replace443_0 -> 11 in the cache */
   /* replace443_1 -> 804 in the cache */
   /* replace443 -> 1376 in the cache */

   /* ('ieq', ('ishr', 'a@16', 15), 0) => ('ige', 'a', 0) */
   /* search444_0_0 -> 11 in the cache */
   /* search444_0_1 -> 14 in the cache */
   /* search444_0 -> 1367 in the cache */
   /* search444_1 -> 804 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1367, 804 },
      -1,
   } },

   /* replace444_0 -> 11 in the cache */
   /* replace444_1 -> 804 in the cache */
   /* replace444 -> 1373 in the cache */

   /* ('ieq', ('ishr', 'a@16', 15), -1) => ('ilt', 'a', 0) */
   /* search445_0_0 -> 11 in the cache */
   /* search445_0_1 -> 14 in the cache */
   /* search445_0 -> 1367 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { -0x1 /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1367, 1386 },
      -1,
   } },

   /* replace445_0 -> 11 in the cache */
   /* replace445_1 -> 804 in the cache */
   /* replace445 -> 1376 in the cache */

   /* ('ine', ('ishr', 'a@16', 15), -1) => ('ige', 'a', 0) */
   /* search446_0_0 -> 11 in the cache */
   /* search446_0_1 -> 14 in the cache */
   /* search446_0 -> 1367 in the cache */
   /* search446_1 -> 1386 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1367, 1386 },
      -1,
   } },

   /* replace446_0 -> 11 in the cache */
   /* replace446_1 -> 804 in the cache */
   /* replace446 -> 1373 in the cache */

   /* ('iand@32', 'a', ('inot', ('ishr', 'a', 31))) => ('imax', 'a', 0) */
   /* search447_0 -> 16 in the cache */
   /* search447_1_0_0 -> 16 in the cache */
   /* search447_1_0_1 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 16, 19 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1389 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 1390 },
      -1,
   } },

   /* replace447_0 -> 16 in the cache */
   /* replace447_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 16, 120 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@32', 2147483648), 0) => ('ige', 'a', 0) */
   /* search448_0_0 -> 16 in the cache */
   /* search448_0_1 -> 17 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 16, 17 },
      -1,
   } },
   /* search448_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1393, 120 },
      -1,
   } },

   /* replace448_0 -> 16 in the cache */
   /* replace448_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 16, 120 },
      -1,
   } },

   /* ('ine', ('iand', 'a@32', 2147483648), 2147483648) => ('ige', 'a', 0) */
   /* search449_0_0 -> 16 in the cache */
   /* search449_0_1 -> 17 in the cache */
   /* search449_0 -> 1393 in the cache */
   /* search449_1 -> 17 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1393, 17 },
      -1,
   } },

   /* replace449_0 -> 16 in the cache */
   /* replace449_1 -> 120 in the cache */
   /* replace449 -> 1395 in the cache */

   /* ('ine', ('iand', 'a@32', 2147483648), 0) => ('ilt', 'a', 0) */
   /* search450_0_0 -> 16 in the cache */
   /* search450_0_1 -> 17 in the cache */
   /* search450_0 -> 1393 in the cache */
   /* search450_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1393, 120 },
      -1,
   } },

   /* replace450_0 -> 16 in the cache */
   /* replace450_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 16, 120 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@32', 2147483648), 2147483648) => ('ilt', 'a', 0) */
   /* search451_0_0 -> 16 in the cache */
   /* search451_0_1 -> 17 in the cache */
   /* search451_0 -> 1393 in the cache */
   /* search451_1 -> 17 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1393, 17 },
      -1,
   } },

   /* replace451_0 -> 16 in the cache */
   /* replace451_1 -> 120 in the cache */
   /* replace451 -> 1398 in the cache */

   /* ('ine', ('ushr', 'a@32', 31), 0) => ('ilt', 'a', 0) */
   /* search452_0_0 -> 16 in the cache */
   /* search452_0_1 -> 19 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 19 },
      -1,
   } },
   /* search452_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1400, 120 },
      -1,
   } },

   /* replace452_0 -> 16 in the cache */
   /* replace452_1 -> 120 in the cache */
   /* replace452 -> 1398 in the cache */

   /* ('ieq', ('ushr', 'a@32', 31), 0) => ('ige', 'a', 0) */
   /* search453_0_0 -> 16 in the cache */
   /* search453_0_1 -> 19 in the cache */
   /* search453_0 -> 1400 in the cache */
   /* search453_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1400, 120 },
      -1,
   } },

   /* replace453_0 -> 16 in the cache */
   /* replace453_1 -> 120 in the cache */
   /* replace453 -> 1395 in the cache */

   /* ('ieq', ('ushr', 'a@32', 31), 1) => ('ilt', 'a', 0) */
   /* search454_0_0 -> 16 in the cache */
   /* search454_0_1 -> 19 in the cache */
   /* search454_0 -> 1400 in the cache */
   /* search454_1 -> 377 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1400, 377 },
      -1,
   } },

   /* replace454_0 -> 16 in the cache */
   /* replace454_1 -> 120 in the cache */
   /* replace454 -> 1398 in the cache */

   /* ('ine', ('ushr', 'a@32', 31), 1) => ('ige', 'a', 0) */
   /* search455_0_0 -> 16 in the cache */
   /* search455_0_1 -> 19 in the cache */
   /* search455_0 -> 1400 in the cache */
   /* search455_1 -> 377 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1400, 377 },
      -1,
   } },

   /* replace455_0 -> 16 in the cache */
   /* replace455_1 -> 120 in the cache */
   /* replace455 -> 1395 in the cache */

   /* ('ine', ('ishr', 'a@32', 31), 0) => ('ilt', 'a', 0) */
   /* search456_0_0 -> 16 in the cache */
   /* search456_0_1 -> 19 in the cache */
   /* search456_0 -> 1389 in the cache */
   /* search456_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1389, 120 },
      -1,
   } },

   /* replace456_0 -> 16 in the cache */
   /* replace456_1 -> 120 in the cache */
   /* replace456 -> 1398 in the cache */

   /* ('ieq', ('ishr', 'a@32', 31), 0) => ('ige', 'a', 0) */
   /* search457_0_0 -> 16 in the cache */
   /* search457_0_1 -> 19 in the cache */
   /* search457_0 -> 1389 in the cache */
   /* search457_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1389, 120 },
      -1,
   } },

   /* replace457_0 -> 16 in the cache */
   /* replace457_1 -> 120 in the cache */
   /* replace457 -> 1395 in the cache */

   /* ('ieq', ('ishr', 'a@32', 31), -1) => ('ilt', 'a', 0) */
   /* search458_0_0 -> 16 in the cache */
   /* search458_0_1 -> 19 in the cache */
   /* search458_0 -> 1389 in the cache */
   /* search458_1 -> 122 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1389, 122 },
      -1,
   } },

   /* replace458_0 -> 16 in the cache */
   /* replace458_1 -> 120 in the cache */
   /* replace458 -> 1398 in the cache */

   /* ('ine', ('ishr', 'a@32', 31), -1) => ('ige', 'a', 0) */
   /* search459_0_0 -> 16 in the cache */
   /* search459_0_1 -> 19 in the cache */
   /* search459_0 -> 1389 in the cache */
   /* search459_1 -> 122 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1389, 122 },
      -1,
   } },

   /* replace459_0 -> 16 in the cache */
   /* replace459_1 -> 120 in the cache */
   /* replace459 -> 1395 in the cache */

   /* ('iand@64', 'a', ('inot', ('ishr', 'a', 63))) => ('imax', 'a', 0) */
   /* search460_0 -> 21 in the cache */
   /* search460_1_0_0 -> 21 in the cache */
   /* search460_1_0_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 21, 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 1409 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 21, 1410 },
      -1,
   } },

   /* replace460_0 -> 21 in the cache */
   /* replace460_1 -> 847 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 21, 847 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@64', 9223372036854775808), 0) => ('ige', 'a', 0) */
   /* search461_0_0 -> 21 in the cache */
   /* search461_0_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 21, 22 },
      -1,
   } },
   /* search461_1 -> 847 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1413, 847 },
      -1,
   } },

   /* replace461_0 -> 21 in the cache */
   /* replace461_1 -> 847 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 21, 847 },
      -1,
   } },

   /* ('ine', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ige', 'a', 0) */
   /* search462_0_0 -> 21 in the cache */
   /* search462_0_1 -> 22 in the cache */
   /* search462_0 -> 1413 in the cache */
   /* search462_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1413, 22 },
      -1,
   } },

   /* replace462_0 -> 21 in the cache */
   /* replace462_1 -> 847 in the cache */
   /* replace462 -> 1415 in the cache */

   /* ('ine', ('iand', 'a@64', 9223372036854775808), 0) => ('ilt', 'a', 0) */
   /* search463_0_0 -> 21 in the cache */
   /* search463_0_1 -> 22 in the cache */
   /* search463_0 -> 1413 in the cache */
   /* search463_1 -> 847 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 1413, 847 },
      -1,
   } },

   /* replace463_0 -> 21 in the cache */
   /* replace463_1 -> 847 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 21, 847 },
      -1,
   } },

   /* ('ieq', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ilt', 'a', 0) */
   /* search464_0_0 -> 21 in the cache */
   /* search464_0_1 -> 22 in the cache */
   /* search464_0 -> 1413 in the cache */
   /* search464_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 1413, 22 },
      -1,
   } },

   /* replace464_0 -> 21 in the cache */
   /* replace464_1 -> 847 in the cache */
   /* replace464 -> 1418 in the cache */

   /* ('ine', ('ushr', 'a@64', 63), 0) => ('ilt', 'a', 0) */
   /* search465_0_0 -> 21 in the cache */
   /* search465_0_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 21, 24 },
      -1,
   } },
   /* search465_1 -> 847 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1420, 847 },
      -1,
   } },

   /* replace465_0 -> 21 in the cache */
   /* replace465_1 -> 847 in the cache */
   /* replace465 -> 1418 in the cache */

   /* ('ieq', ('ushr', 'a@64', 63), 0) => ('ige', 'a', 0) */
   /* search466_0_0 -> 21 in the cache */
   /* search466_0_1 -> 24 in the cache */
   /* search466_0 -> 1420 in the cache */
   /* search466_1 -> 847 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1420, 847 },
      -1,
   } },

   /* replace466_0 -> 21 in the cache */
   /* replace466_1 -> 847 in the cache */
   /* replace466 -> 1415 in the cache */

   /* ('ieq', ('ushr', 'a@64', 63), 1) => ('ilt', 'a', 0) */
   /* search467_0_0 -> 21 in the cache */
   /* search467_0_1 -> 24 in the cache */
   /* search467_0 -> 1420 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0x1 /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1420, 1423 },
      -1,
   } },

   /* replace467_0 -> 21 in the cache */
   /* replace467_1 -> 847 in the cache */
   /* replace467 -> 1418 in the cache */

   /* ('ine', ('ushr', 'a@64', 63), 1) => ('ige', 'a', 0) */
   /* search468_0_0 -> 21 in the cache */
   /* search468_0_1 -> 24 in the cache */
   /* search468_0 -> 1420 in the cache */
   /* search468_1 -> 1423 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1420, 1423 },
      -1,
   } },

   /* replace468_0 -> 21 in the cache */
   /* replace468_1 -> 847 in the cache */
   /* replace468 -> 1415 in the cache */

   /* ('ine', ('ishr', 'a@64', 63), 0) => ('ilt', 'a', 0) */
   /* search469_0_0 -> 21 in the cache */
   /* search469_0_1 -> 24 in the cache */
   /* search469_0 -> 1409 in the cache */
   /* search469_1 -> 847 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1409, 847 },
      -1,
   } },

   /* replace469_0 -> 21 in the cache */
   /* replace469_1 -> 847 in the cache */
   /* replace469 -> 1418 in the cache */

   /* ('ieq', ('ishr', 'a@64', 63), 0) => ('ige', 'a', 0) */
   /* search470_0_0 -> 21 in the cache */
   /* search470_0_1 -> 24 in the cache */
   /* search470_0 -> 1409 in the cache */
   /* search470_1 -> 847 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1409, 847 },
      -1,
   } },

   /* replace470_0 -> 21 in the cache */
   /* replace470_1 -> 847 in the cache */
   /* replace470 -> 1415 in the cache */

   /* ('ieq', ('ishr', 'a@64', 63), -1) => ('ilt', 'a', 0) */
   /* search471_0_0 -> 21 in the cache */
   /* search471_0_1 -> 24 in the cache */
   /* search471_0 -> 1409 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { -0x1 /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 1409, 1428 },
      -1,
   } },

   /* replace471_0 -> 21 in the cache */
   /* replace471_1 -> 847 in the cache */
   /* replace471 -> 1418 in the cache */

   /* ('ine', ('ishr', 'a@64', 63), -1) => ('ige', 'a', 0) */
   /* search472_0_0 -> 21 in the cache */
   /* search472_0_1 -> 24 in the cache */
   /* search472_0 -> 1409 in the cache */
   /* search472_1 -> 1428 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 1409, 1428 },
      -1,
   } },

   /* replace472_0 -> 21 in the cache */
   /* replace472_1 -> 847 in the cache */
   /* replace472 -> 1415 in the cache */

   /* ('fmin', 'a', ('fneg', 'a')) => ('fneg', ('fabs', 'a')) */
   /* search473_0 -> 32 in the cache */
   /* search473_1_0 -> 32 in the cache */
   /* search473_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 32, 98 },
      -1,
   } },

   /* replace473_0_0 -> 32 in the cache */
   /* replace473_0 -> 103 in the cache */
   /* replace473 -> 1196 in the cache */

   /* ('imin', 'a', ('ineg', 'a')) => ('ineg', ('iabs', 'a')) */
   /* search474_0 -> 32 in the cache */
   /* search474_1_0 -> 32 in the cache */
   /* search474_1 -> 100 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 32, 100 },
      -1,
   } },

   /* replace474_0_0 -> 32 in the cache */
   /* replace474_0 -> 106 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 106 },
      -1,
   } },

   /* ('fmin', 'a', ('fneg', ('fabs', 'a'))) => ('fneg', ('fabs', 'a')) */
   /* search475_0 -> 32 in the cache */
   /* search475_1_0_0 -> 32 in the cache */
   /* search475_1_0 -> 103 in the cache */
   /* search475_1 -> 1196 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 32, 1196 },
      -1,
   } },

   /* replace475_0_0 -> 32 in the cache */
   /* replace475_0 -> 103 in the cache */
   /* replace475 -> 1196 in the cache */

   /* ('imin', 'a', ('ineg', ('iabs', 'a'))) => ('ineg', ('iabs', 'a')) */
   /* search476_0 -> 32 in the cache */
   /* search476_1_0_0 -> 32 in the cache */
   /* search476_1_0 -> 106 in the cache */
   /* search476_1 -> 1433 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 32, 1433 },
      -1,
   } },

   /* replace476_0_0 -> 32 in the cache */
   /* replace476_0 -> 106 in the cache */
   /* replace476 -> 1433 in the cache */

   /* ('~fmin', 'a', ('fabs', 'a')) => a */
   /* search477_0 -> 32 in the cache */
   /* search477_1_0 -> 32 in the cache */
   /* search477_1 -> 103 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 32, 103 },
      -1,
   } },

   /* replace477 -> 32 in the cache */

   /* ('imin', 'a', ('iabs', 'a')) => a */
   /* search478_0 -> 32 in the cache */
   /* search478_1_0 -> 32 in the cache */
   /* search478_1 -> 106 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 32, 106 },
      -1,
   } },

   /* replace478 -> 32 in the cache */

   /* ('~fmax', 'a', ('fneg', ('fabs', 'a'))) => a */
   /* search479_0 -> 32 in the cache */
   /* search479_1_0_0 -> 32 in the cache */
   /* search479_1_0 -> 103 in the cache */
   /* search479_1 -> 1196 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 32, 1196 },
      -1,
   } },

   /* replace479 -> 32 in the cache */

   /* ('imax', 'a', ('ineg', ('iabs', 'a'))) => a */
   /* search480_0 -> 32 in the cache */
   /* search480_1_0_0 -> 32 in the cache */
   /* search480_1_0 -> 106 in the cache */
   /* search480_1 -> 1433 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 32, 1433 },
      -1,
   } },

   /* replace480 -> 32 in the cache */

   /* ('fmax', 'a', ('fabs', 'a')) => ('fabs', 'a') */
   /* search481_0 -> 32 in the cache */
   /* search481_1_0 -> 32 in the cache */
   /* search481_1 -> 103 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 32, 103 },
      -1,
   } },

   /* replace481_0 -> 32 in the cache */
   /* replace481 -> 103 in the cache */

   /* ('imax', 'a', ('iabs', 'a')) => ('iabs', 'a') */
   /* search482_0 -> 32 in the cache */
   /* search482_1_0 -> 32 in the cache */
   /* search482_1 -> 106 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 32, 106 },
      -1,
   } },

   /* replace482_0 -> 32 in the cache */
   /* replace482 -> 106 in the cache */

   /* ('fmax', 'a', ('fneg', 'a')) => ('fabs', 'a') */
   /* search483_0 -> 32 in the cache */
   /* search483_1_0 -> 32 in the cache */
   /* search483_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 32, 98 },
      -1,
   } },

   /* replace483_0 -> 32 in the cache */
   /* replace483 -> 103 in the cache */

   /* ('imax', 'a', ('ineg', 'a')) => ('iabs', 'a') */
   /* search484_0 -> 32 in the cache */
   /* search484_1_0 -> 32 in the cache */
   /* search484_1 -> 100 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 32, 100 },
      -1,
   } },

   /* replace484_0 -> 32 in the cache */
   /* replace484 -> 106 in the cache */

   /* ('~fmax', ('fabs', 'a'), 0.0) => ('fabs', 'a') */
   /* search485_0_0 -> 32 in the cache */
   /* search485_0 -> 103 in the cache */
   /* search485_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 103, 113 },
      -1,
   } },

   /* replace485_0 -> 32 in the cache */
   /* replace485 -> 103 in the cache */

   /* ('fmin', ('fmax', 'a', 0.0), 1.0) => ('fsat', 'a') */
   /* search486_0_0 -> 32 in the cache */
   /* search486_0_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 32, 113 },
      -1,
   } },
   /* search486_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1445, 226 },
      -1,
   } },

   /* replace486_0 -> 32 in the cache */
   /* replace486 -> 202 in the cache */

   /* ('~fmax', ('fmin', 'a', 1.0), 0.0) => ('fsat', 'a') */
   /* search487_0_0 -> 32 in the cache */
   /* search487_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 32, 226 },
      -1,
   } },
   /* search487_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1447, 113 },
      -1,
   } },

   /* replace487_0 -> 32 in the cache */
   /* replace487 -> 202 in the cache */

   /* ('~fmin', ('fmax', 'a', -1.0), 0.0) => ('fneg', ('fsat', ('fneg', 'a'))) */
   /* search488_0_0 -> 32 in the cache */
   /* search488_0_1 -> 232 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 32, 232 },
      -1,
   } },
   /* search488_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1449, 113 },
      -1,
   } },

   /* replace488_0_0_0 -> 32 in the cache */
   /* replace488_0_0 -> 98 in the cache */
   /* replace488_0 -> 203 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 203 },
      -1,
   } },

   /* ('~fmax', ('fmin', 'a', 0.0), -1.0) => ('fneg', ('fsat', ('fneg', 'a'))) */
   /* search489_0_0 -> 32 in the cache */
   /* search489_0_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 32, 113 },
      -1,
   } },
   /* search489_1 -> 232 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1452, 232 },
      -1,
   } },

   /* replace489_0_0_0 -> 32 in the cache */
   /* replace489_0_0 -> 98 in the cache */
   /* replace489_0 -> 203 in the cache */
   /* replace489 -> 1451 in the cache */

   /* ('fsat', ('fsign', 'a')) => ('b2f', ('!flt', 0.0, 'a')) */
   /* search490_0_0 -> 32 in the cache */
   /* search490_0 -> 235 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 235 },
      -1,
   } },

   /* replace490_0_0 -> 113 in the cache */
   /* replace490_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      nir_op_flt,
      -1, 0,
      { 113, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1455 },
      -1,
   } },

   /* ('fsat', ('b2f', 'a')) => ('b2f', 'a') */
   /* search491_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 1457 },
      -1,
   } },

   /* replace491_0 -> 32 in the cache */
   /* replace491 -> 1457 in the cache */

   /* ('fsat', 'a') => ('fmin', ('fmax', 'a', 0.0), 1.0) */
   /* search492_0 -> 32 in the cache */
   /* search492 -> 202 in the cache */

   /* replace492_0_0 -> 32 in the cache */
   /* replace492_0_1 -> 113 in the cache */
   /* replace492_0 -> 1445 in the cache */
   /* replace492_1 -> 226 in the cache */
   /* replace492 -> 1446 in the cache */

   /* ('fsat', ('fsat', 'a')) => ('fsat', 'a') */
   /* search493_0_0 -> 32 in the cache */
   /* search493_0 -> 202 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 202 },
      -1,
   } },

   /* replace493_0 -> 32 in the cache */
   /* replace493 -> 202 in the cache */

   /* ('fsat', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', 'b'))) => ('fsat', ('fadd', ('fneg', 'a'), ('fneg', 'b'))) */
   /* search494_0_0_0 -> 0 in the cache */
   /* search494_0_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1460 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1461 },
      -1,
   } },

   /* replace494_0_0_0 -> 0 in the cache */
   /* replace494_0_0 -> 197 in the cache */
   /* replace494_0_1_0 -> 3 in the cache */
   /* replace494_0_1 -> 1034 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 197, 1034 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1463 },
      -1,
   } },

   /* ('fsat', ('fneg(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fneg', 'a'), 'b')) */
   /* search495_0_0_0 -> 0 in the cache */
   /* search495_0_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 0, 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1465 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1466 },
      -1,
   } },

   /* replace495_0_0_0 -> 0 in the cache */
   /* replace495_0_0 -> 197 in the cache */
   /* replace495_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 197, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1468 },
      -1,
   } },

   /* ('fsat', ('fneg(is_used_once)', ('fmulz(is_used_once)', 'a', 'b'))) => ('fsat', ('fmulz', ('fneg', 'a'), 'b')) */
   /* search496_0_0_0 -> 16 in the cache */
   /* search496_0_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 16, 36 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1470 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1471 },
      -1,
   } },

   /* replace496_0_0_0 -> 16 in the cache */
   /* replace496_0_0 -> 265 in the cache */
   /* replace496_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmulz,
      0, 1,
      { 265, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1473 },
      -1,
   } },

   /* ('fsat', ('fabs(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fabs', 'a'), ('fabs', 'b'))) */
   /* search497_0_0_0 -> 0 in the cache */
   /* search497_0_0_1 -> 3 in the cache */
   /* search497_0_0 -> 1465 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 1,
      { 1465 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1475 },
      -1,
   } },

   /* replace497_0_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 0 },
      -1,
   } },
   /* replace497_0_1_0 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 1477, 1478 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1479 },
      -1,
   } },

   /* ('fmin', ('fmax', ('fmin', ('fmax', 'a', 'b'), 'c'), 'b'), 'c') => ('fmin', ('fmax', 'a', 'b'), 'c') */
   /* search498_0_0_0_0 -> 124 in the cache */
   /* search498_0_0_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      3, 1,
      { 124, 125 },
      -1,
   } },
   /* search498_0_0_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      2, 2,
      { 1481, 127 },
      -1,
   } },
   /* search498_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      1, 3,
      { 1482, 125 },
      -1,
   } },
   /* search498_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 4,
      { 1483, 127 },
      -1,
   } },

   /* replace498_0_0 -> 124 in the cache */
   /* replace498_0_1 -> 125 in the cache */
   /* replace498_0 -> 1289 in the cache */
   /* replace498_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1289, 127 },
      -1,
   } },

   /* ('imin', ('imax', ('imin', ('imax', 'a', 'b'), 'c'), 'b'), 'c') => ('imin', ('imax', 'a', 'b'), 'c') */
   /* search499_0_0_0_0 -> 124 in the cache */
   /* search499_0_0_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      3, 1,
      { 124, 125 },
      -1,
   } },
   /* search499_0_0_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      2, 2,
      { 1486, 127 },
      -1,
   } },
   /* search499_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      1, 3,
      { 1487, 125 },
      -1,
   } },
   /* search499_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      0, 4,
      { 1488, 127 },
      -1,
   } },

   /* replace499_0_0 -> 124 in the cache */
   /* replace499_0_1 -> 125 in the cache */
   /* replace499_0 -> 1299 in the cache */
   /* replace499_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      0, 2,
      { 1299, 127 },
      -1,
   } },

   /* ('umin', ('umax', ('umin', ('umax', 'a', 'b'), 'c'), 'b'), 'c') => ('umin', ('umax', 'a', 'b'), 'c') */
   /* search500_0_0_0_0 -> 124 in the cache */
   /* search500_0_0_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      3, 1,
      { 124, 125 },
      -1,
   } },
   /* search500_0_0_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      2, 2,
      { 1491, 127 },
      -1,
   } },
   /* search500_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      1, 3,
      { 1492, 125 },
      -1,
   } },
   /* search500_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      0, 4,
      { 1493, 127 },
      -1,
   } },

   /* replace500_0_0 -> 124 in the cache */
   /* replace500_0_1 -> 125 in the cache */
   /* replace500_0 -> 1294 in the cache */
   /* replace500_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      0, 2,
      { 1294, 127 },
      -1,
   } },

   /* ('fmax', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmax', 'a', 'b')) */
   /* search501_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 0,
      { 0 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      18,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1496, 1497 },
      -1,
   } },

   /* replace501_0_0 -> 0 in the cache */
   /* replace501_0_1 -> 3 in the cache */
   /* replace501_0 -> 1223 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1223 },
      -1,
   } },

   /* ('~fmin', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmin', 'a', 'b')) */
   /* search502_0_0 -> 0 in the cache */
   /* search502_0 -> 1496 in the cache */
   /* search502_1 -> 1497 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1496, 1497 },
      -1,
   } },

   /* replace502_0_0 -> 0 in the cache */
   /* replace502_0_1 -> 3 in the cache */
   /* replace502_0 -> 1225 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1225 },
      -1,
   } },

   /* ('fmax', ('fneg', ('fmin', 'b', 'a')), 'b') => ('fmax', ('fabs', 'b'), ('fneg', 'a')) */
   /* search503_0_0_0 -> 1058 in the cache */
   /* search503_0_0_1 -> 1055 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      1, 1,
      { 1058, 1055 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1502 },
      -1,
   } },
   /* search503_1 -> 1058 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1503, 1058 },
      -1,
   } },

   /* replace503_0_0 -> 1058 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 1058 },
      -1,
   } },
   /* replace503_1_0 -> 1055 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1055 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 1505, 1506 },
      -1,
   } },

   /* ('fmin', ('fneg', ('fmax', 'b', 'a')), 'b') => ('fmin', ('fneg', ('fabs', 'b')), ('fneg', 'a')) */
   /* search504_0_0_0 -> 1058 in the cache */
   /* search504_0_0_1 -> 1055 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      1, 1,
      { 1058, 1055 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 1,
      { 1508 },
      -1,
   } },
   /* search504_1 -> 1058 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 2,
      { 1509, 1058 },
      -1,
   } },

   /* replace504_0_0_0 -> 1058 in the cache */
   /* replace504_0_0 -> 1505 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1505 },
      -1,
   } },
   /* replace504_1_0 -> 1055 in the cache */
   /* replace504_1 -> 1506 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 1511, 1506 },
      -1,
   } },

   /* ('fmax', ('fadd(is_used_once)', ('fneg', 'a(is_not_negative)'), '#b(is_zero_to_one)'), 0.0) => ('fsat', ('fadd', ('fneg', 'a'), 'b')) */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      19,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1513 },
      -1,
   } },
   /* search505_0_1 -> 1497 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fadd,
      1, 1,
      { 1514, 1497 },
      0,
   } },
   /* search505_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 2,
      { 1515, 241 },
      -1,
   } },

   /* replace505_0_0_0 -> 0 in the cache */
   /* replace505_0_0 -> 197 in the cache */
   /* replace505_0_1 -> 3 in the cache */
   /* replace505_0 -> 262 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 262 },
      -1,
   } },

   /* ('extract_u8', ('imin', ('imax', 'a', 0), 255), 0) => ('imin', ('imax', 'a', 0), 255) */
   /* search506_0_0_0 -> 32 in the cache */
   /* search506_0_0_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imax,
      1, 1,
      { 32, 61 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0xff /* 255 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imin,
      0, 2,
      { 1518, 1519 },
      -1,
   } },
   /* search506_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 2,
      { 1520, 61 },
      -1,
   } },

   /* replace506_0_0 -> 32 in the cache */
   /* replace506_0_1 -> 61 in the cache */
   /* replace506_0 -> 1518 in the cache */
   /* replace506_1 -> 1519 in the cache */
   /* replace506 -> 1520 in the cache */

   /* ('ior', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('!fmax', 'b', 'c')) */
   /* search507_0_0 -> 124 in the cache */
   /* search507_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 124, 125 },
      0,
   } },
   /* search507_1_0 -> 124 in the cache */
   /* search507_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 124, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1522, 1523 },
      -1,
   } },

   /* replace507_0 -> 124 in the cache */
   /* replace507_1_0 -> 125 in the cache */
   /* replace507_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      true,
      false,
      nir_op_fmax,
      0, 1,
      { 125, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 124, 1525 },
      -1,
   } },

   /* ('ior', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c') */
   /* search508_0_0 -> 0 in the cache */
   /* search508_0_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 0, 665 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search508_1_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1528, 665 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1527, 1529 },
      -1,
   } },

   /* replace508_0_0 -> 0 in the cache */
   /* replace508_0_1 -> 1528 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      true,
      false,
      nir_op_fmin,
      0, 1,
      { 0, 1528 },
      -1,
   } },
   /* replace508_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1531, 665 },
      -1,
   } },

   /* ('ior', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('!fmin', 'b', 'c')) */
   /* search509_0_0 -> 124 in the cache */
   /* search509_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 124, 125 },
      0,
   } },
   /* search509_1_0 -> 124 in the cache */
   /* search509_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 124, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1533, 1534 },
      -1,
   } },

   /* replace509_0 -> 124 in the cache */
   /* replace509_1_0 -> 125 in the cache */
   /* replace509_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      true,
      false,
      nir_op_fmin,
      0, 1,
      { 125, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 124, 1536 },
      -1,
   } },

   /* ('ior', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c') */
   /* search510_0_0 -> 0 in the cache */
   /* search510_0_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 0, 665 },
      0,
   } },
   /* search510_1_0 -> 1528 in the cache */
   /* search510_1_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1528, 665 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1538, 1539 },
      -1,
   } },

   /* replace510_0_0 -> 0 in the cache */
   /* replace510_0_1 -> 1528 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      true,
      false,
      nir_op_fmax,
      0, 1,
      { 0, 1528 },
      -1,
   } },
   /* replace510_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1541, 665 },
      -1,
   } },

   /* ('ior', ('flt', 'a', '#b'), ('flt', 'a', '#c')) => ('flt', 'a', ('!fmax', 'b', 'c')) */
   /* search511_0_0 -> 124 in the cache */
   /* search511_0_1 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 124, 268 },
      -1,
   } },
   /* search511_1_0 -> 124 in the cache */
   /* search511_1_1 -> 760 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 124, 760 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1543, 1544 },
      -1,
   } },

   /* replace511_0 -> 124 in the cache */
   /* replace511_1_0 -> 125 in the cache */
   /* replace511_1_1 -> 127 in the cache */
   /* replace511_1 -> 1525 in the cache */
   /* replace511 -> 1526 in the cache */

   /* ('ior', ('flt', '#a', 'c'), ('flt', '#b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search512_0_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1546, 665 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      2, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search512_1_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1548, 665 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1547, 1549 },
      -1,
   } },

   /* replace512_0_0 -> 0 in the cache */
   /* replace512_0_1 -> 1528 in the cache */
   /* replace512_0 -> 1531 in the cache */
   /* replace512_1 -> 665 in the cache */
   /* replace512 -> 1532 in the cache */

   /* ('ior', ('fge', 'a', '#b'), ('fge', 'a', '#c')) => ('fge', 'a', ('!fmin', 'b', 'c')) */
   /* search513_0_0 -> 124 in the cache */
   /* search513_0_1 -> 268 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 124, 268 },
      -1,
   } },
   /* search513_1_0 -> 124 in the cache */
   /* search513_1_1 -> 760 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 124, 760 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1551, 1552 },
      -1,
   } },

   /* replace513_0 -> 124 in the cache */
   /* replace513_1_0 -> 125 in the cache */
   /* replace513_1_1 -> 127 in the cache */
   /* replace513_1 -> 1536 in the cache */
   /* replace513 -> 1537 in the cache */

   /* ('ior', ('fge', '#a', 'c'), ('fge', '#b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c') */
   /* search514_0_0 -> 1546 in the cache */
   /* search514_0_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1546, 665 },
      -1,
   } },
   /* search514_1_0 -> 1548 in the cache */
   /* search514_1_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1548, 665 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1554, 1555 },
      -1,
   } },

   /* replace514_0_0 -> 0 in the cache */
   /* replace514_0_1 -> 1528 in the cache */
   /* replace514_0 -> 1541 in the cache */
   /* replace514_1 -> 665 in the cache */
   /* replace514 -> 1542 in the cache */

   /* ('~iand', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('fmin', 'b', 'c')) */
   /* search515_0_0 -> 124 in the cache */
   /* search515_0_1 -> 125 in the cache */
   /* search515_0 -> 1522 in the cache */
   /* search515_1_0 -> 124 in the cache */
   /* search515_1_1 -> 127 in the cache */
   /* search515_1 -> 1523 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1522, 1523 },
      -1,
   } },

   /* replace515_0 -> 124 in the cache */
   /* replace515_1_0 -> 125 in the cache */
   /* replace515_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 125, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 124, 1558 },
      -1,
   } },

   /* ('~iand', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c') */
   /* search516_0_0 -> 0 in the cache */
   /* search516_0_1 -> 665 in the cache */
   /* search516_0 -> 1527 in the cache */
   /* search516_1_0 -> 1528 in the cache */
   /* search516_1_1 -> 665 in the cache */
   /* search516_1 -> 1529 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1527, 1529 },
      -1,
   } },

   /* replace516_0_0 -> 0 in the cache */
   /* replace516_0_1 -> 1528 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 0, 1528 },
      -1,
   } },
   /* replace516_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1561, 665 },
      -1,
   } },

   /* ('~iand', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('fmax', 'b', 'c')) */
   /* search517_0_0 -> 124 in the cache */
   /* search517_0_1 -> 125 in the cache */
   /* search517_0 -> 1533 in the cache */
   /* search517_1_0 -> 124 in the cache */
   /* search517_1_1 -> 127 in the cache */
   /* search517_1 -> 1534 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1533, 1534 },
      -1,
   } },

   /* replace517_0 -> 124 in the cache */
   /* replace517_1_0 -> 125 in the cache */
   /* replace517_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 125, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 124, 1564 },
      -1,
   } },

   /* ('~iand', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c') */
   /* search518_0_0 -> 0 in the cache */
   /* search518_0_1 -> 665 in the cache */
   /* search518_0 -> 1538 in the cache */
   /* search518_1_0 -> 1528 in the cache */
   /* search518_1_1 -> 665 in the cache */
   /* search518_1 -> 1539 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1538, 1539 },
      -1,
   } },

   /* replace518_0_0 -> 0 in the cache */
   /* replace518_0_1 -> 1528 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 0, 1528 },
      -1,
   } },
   /* replace518_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1567, 665 },
      -1,
   } },

   /* ('iand', ('flt', 'a', '#b(is_a_number)'), ('flt', 'a', '#c(is_a_number)')) => ('flt', 'a', ('fmin', 'b', 'c')) */
   /* search519_0_0 -> 124 in the cache */
   { .variable = {
      { nir_search_value_variable, -3 },
      1, /* b */
      true,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 124, 1569 },
      -1,
   } },
   /* search519_1_0 -> 124 in the cache */
   { .variable = {
      { nir_search_value_variable, -3 },
      2, /* c */
      true,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 124, 1571 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1570, 1572 },
      -1,
   } },

   /* replace519_0 -> 124 in the cache */
   /* replace519_1_0 -> 125 in the cache */
   /* replace519_1_1 -> 127 in the cache */
   /* replace519_1 -> 1558 in the cache */
   /* replace519 -> 1559 in the cache */

   /* ('iand', ('flt', '#a(is_a_number)', 'c'), ('flt', '#b(is_a_number)', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      true,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search520_0_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1574, 665 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      2, /* b */
      true,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search520_1_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1576, 665 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1575, 1577 },
      -1,
   } },

   /* replace520_0_0 -> 0 in the cache */
   /* replace520_0_1 -> 1528 in the cache */
   /* replace520_0 -> 1561 in the cache */
   /* replace520_1 -> 665 in the cache */
   /* replace520 -> 1562 in the cache */

   /* ('iand', ('fge', 'a', '#b(is_a_number)'), ('fge', 'a', '#c(is_a_number)')) => ('fge', 'a', ('fmax', 'b', 'c')) */
   /* search521_0_0 -> 124 in the cache */
   /* search521_0_1 -> 1569 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 124, 1569 },
      -1,
   } },
   /* search521_1_0 -> 124 in the cache */
   /* search521_1_1 -> 1571 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 124, 1571 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1579, 1580 },
      -1,
   } },

   /* replace521_0 -> 124 in the cache */
   /* replace521_1_0 -> 125 in the cache */
   /* replace521_1_1 -> 127 in the cache */
   /* replace521_1 -> 1564 in the cache */
   /* replace521 -> 1565 in the cache */

   /* ('iand', ('fge', '#a(is_a_number)', 'c'), ('fge', '#b(is_a_number)', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c') */
   /* search522_0_0 -> 1574 in the cache */
   /* search522_0_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1574, 665 },
      -1,
   } },
   /* search522_1_0 -> 1576 in the cache */
   /* search522_1_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1576, 665 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1582, 1583 },
      -1,
   } },

   /* replace522_0_0 -> 0 in the cache */
   /* replace522_0_1 -> 1528 in the cache */
   /* replace522_0 -> 1567 in the cache */
   /* replace522_1 -> 665 in the cache */
   /* replace522 -> 1568 in the cache */

   /* ('ior', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imax', 'b', 'c')) */
   /* search523_0_0 -> 124 in the cache */
   /* search523_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 124, 125 },
      0,
   } },
   /* search523_1_0 -> 124 in the cache */
   /* search523_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 124, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1585, 1586 },
      -1,
   } },

   /* replace523_0 -> 124 in the cache */
   /* replace523_1_0 -> 125 in the cache */
   /* replace523_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 125, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 124, 1588 },
      -1,
   } },

   /* ('ior', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imin', 'a', 'b'), 'c') */
   /* search524_0_0 -> 0 in the cache */
   /* search524_0_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 0, 665 },
      0,
   } },
   /* search524_1_0 -> 1528 in the cache */
   /* search524_1_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 1528, 665 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1590, 1591 },
      -1,
   } },

   /* replace524_0_0 -> 0 in the cache */
   /* replace524_0_1 -> 1528 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 0, 1528 },
      -1,
   } },
   /* replace524_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 1593, 665 },
      -1,
   } },

   /* ('ior', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imin', 'b', 'c')) */
   /* search525_0_0 -> 124 in the cache */
   /* search525_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 124, 125 },
      0,
   } },
   /* search525_1_0 -> 124 in the cache */
   /* search525_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 124, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1595, 1596 },
      -1,
   } },

   /* replace525_0 -> 124 in the cache */
   /* replace525_1_0 -> 125 in the cache */
   /* replace525_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 125, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 124, 1598 },
      -1,
   } },

   /* ('ior', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imax', 'a', 'b'), 'c') */
   /* search526_0_0 -> 0 in the cache */
   /* search526_0_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 0, 665 },
      0,
   } },
   /* search526_1_0 -> 1528 in the cache */
   /* search526_1_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 1528, 665 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1600, 1601 },
      -1,
   } },

   /* replace526_0_0 -> 0 in the cache */
   /* replace526_0_1 -> 1528 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 0, 1528 },
      -1,
   } },
   /* replace526_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 1603, 665 },
      -1,
   } },

   /* ('ior', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umax', 'b', 'c')) */
   /* search527_0_0 -> 124 in the cache */
   /* search527_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 124, 125 },
      0,
   } },
   /* search527_1_0 -> 124 in the cache */
   /* search527_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 124, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1605, 1606 },
      -1,
   } },

   /* replace527_0 -> 124 in the cache */
   /* replace527_1_0 -> 125 in the cache */
   /* replace527_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 125, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 124, 1608 },
      -1,
   } },

   /* ('ior', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umin', 'a', 'b'), 'c') */
   /* search528_0_0 -> 0 in the cache */
   /* search528_0_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 0, 665 },
      0,
   } },
   /* search528_1_0 -> 1528 in the cache */
   /* search528_1_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 1528, 665 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1610, 1611 },
      -1,
   } },

   /* replace528_0_0 -> 0 in the cache */
   /* replace528_0_1 -> 1528 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 0, 1528 },
      -1,
   } },
   /* replace528_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 1613, 665 },
      -1,
   } },

   /* ('ior', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umin', 'b', 'c')) */
   /* search529_0_0 -> 124 in the cache */
   /* search529_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 124, 125 },
      0,
   } },
   /* search529_1_0 -> 124 in the cache */
   /* search529_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 124, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1615, 1616 },
      -1,
   } },

   /* replace529_0 -> 124 in the cache */
   /* replace529_1_0 -> 125 in the cache */
   /* replace529_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 125, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 124, 1618 },
      -1,
   } },

   /* ('ior', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umax', 'a', 'b'), 'c') */
   /* search530_0_0 -> 0 in the cache */
   /* search530_0_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 0, 665 },
      0,
   } },
   /* search530_1_0 -> 1528 in the cache */
   /* search530_1_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 1528, 665 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1620, 1621 },
      -1,
   } },

   /* replace530_0_0 -> 0 in the cache */
   /* replace530_0_1 -> 1528 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 0, 1528 },
      -1,
   } },
   /* replace530_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 1623, 665 },
      -1,
   } },

   /* ('iand', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imin', 'b', 'c')) */
   /* search531_0_0 -> 124 in the cache */
   /* search531_0_1 -> 125 in the cache */
   /* search531_0 -> 1585 in the cache */
   /* search531_1_0 -> 124 in the cache */
   /* search531_1_1 -> 127 in the cache */
   /* search531_1 -> 1586 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1585, 1586 },
      -1,
   } },

   /* replace531_0 -> 124 in the cache */
   /* replace531_1_0 -> 125 in the cache */
   /* replace531_1_1 -> 127 in the cache */
   /* replace531_1 -> 1598 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 124, 1598 },
      -1,
   } },

   /* ('iand', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imax', 'a', 'b'), 'c') */
   /* search532_0_0 -> 0 in the cache */
   /* search532_0_1 -> 665 in the cache */
   /* search532_0 -> 1590 in the cache */
   /* search532_1_0 -> 1528 in the cache */
   /* search532_1_1 -> 665 in the cache */
   /* search532_1 -> 1591 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1590, 1591 },
      -1,
   } },

   /* replace532_0_0 -> 0 in the cache */
   /* replace532_0_1 -> 1528 in the cache */
   /* replace532_0 -> 1603 in the cache */
   /* replace532_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 1603, 665 },
      -1,
   } },

   /* ('iand', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imax', 'b', 'c')) */
   /* search533_0_0 -> 124 in the cache */
   /* search533_0_1 -> 125 in the cache */
   /* search533_0 -> 1595 in the cache */
   /* search533_1_0 -> 124 in the cache */
   /* search533_1_1 -> 127 in the cache */
   /* search533_1 -> 1596 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1595, 1596 },
      -1,
   } },

   /* replace533_0 -> 124 in the cache */
   /* replace533_1_0 -> 125 in the cache */
   /* replace533_1_1 -> 127 in the cache */
   /* replace533_1 -> 1588 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 124, 1588 },
      -1,
   } },

   /* ('iand', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imin', 'a', 'b'), 'c') */
   /* search534_0_0 -> 0 in the cache */
   /* search534_0_1 -> 665 in the cache */
   /* search534_0 -> 1600 in the cache */
   /* search534_1_0 -> 1528 in the cache */
   /* search534_1_1 -> 665 in the cache */
   /* search534_1 -> 1601 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1600, 1601 },
      -1,
   } },

   /* replace534_0_0 -> 0 in the cache */
   /* replace534_0_1 -> 1528 in the cache */
   /* replace534_0 -> 1593 in the cache */
   /* replace534_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 1593, 665 },
      -1,
   } },

   /* ('iand', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umin', 'b', 'c')) */
   /* search535_0_0 -> 124 in the cache */
   /* search535_0_1 -> 125 in the cache */
   /* search535_0 -> 1605 in the cache */
   /* search535_1_0 -> 124 in the cache */
   /* search535_1_1 -> 127 in the cache */
   /* search535_1 -> 1606 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1605, 1606 },
      -1,
   } },

   /* replace535_0 -> 124 in the cache */
   /* replace535_1_0 -> 125 in the cache */
   /* replace535_1_1 -> 127 in the cache */
   /* replace535_1 -> 1618 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 124, 1618 },
      -1,
   } },

   /* ('iand', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umax', 'a', 'b'), 'c') */
   /* search536_0_0 -> 0 in the cache */
   /* search536_0_1 -> 665 in the cache */
   /* search536_0 -> 1610 in the cache */
   /* search536_1_0 -> 1528 in the cache */
   /* search536_1_1 -> 665 in the cache */
   /* search536_1 -> 1611 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1610, 1611 },
      -1,
   } },

   /* replace536_0_0 -> 0 in the cache */
   /* replace536_0_1 -> 1528 in the cache */
   /* replace536_0 -> 1623 in the cache */
   /* replace536_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 1623, 665 },
      -1,
   } },

   /* ('iand', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umax', 'b', 'c')) */
   /* search537_0_0 -> 124 in the cache */
   /* search537_0_1 -> 125 in the cache */
   /* search537_0 -> 1615 in the cache */
   /* search537_1_0 -> 124 in the cache */
   /* search537_1_1 -> 127 in the cache */
   /* search537_1 -> 1616 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1615, 1616 },
      -1,
   } },

   /* replace537_0 -> 124 in the cache */
   /* replace537_1_0 -> 125 in the cache */
   /* replace537_1_1 -> 127 in the cache */
   /* replace537_1 -> 1608 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 124, 1608 },
      -1,
   } },

   /* ('iand', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umin', 'a', 'b'), 'c') */
   /* search538_0_0 -> 0 in the cache */
   /* search538_0_1 -> 665 in the cache */
   /* search538_0 -> 1620 in the cache */
   /* search538_1_0 -> 1528 in the cache */
   /* search538_1_1 -> 665 in the cache */
   /* search538_1 -> 1621 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1620, 1621 },
      -1,
   } },

   /* replace538_0_0 -> 0 in the cache */
   /* replace538_0_1 -> 1528 in the cache */
   /* replace538_0 -> 1613 in the cache */
   /* replace538_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 1613, 665 },
      -1,
   } },

   /* ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'c'), 'd'), ('flt', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd') */
   /* search539_0_0_0 -> 0 in the cache */
   /* search539_0_0_1 -> 665 in the cache */
   /* search539_0_0 -> 1527 in the cache */
   { .variable = {
      { nir_search_value_variable, 1 },
      2, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1527, 1641 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      3, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search539_1_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1643, 665 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1642, 1644 },
      -1,
   } },

   /* replace539_0_0_0 -> 0 in the cache */
   /* replace539_0_0_1 -> 1643 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      true,
      false,
      nir_op_fmin,
      1, 1,
      { 0, 1643 },
      -1,
   } },
   /* replace539_0_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1646, 665 },
      -1,
   } },
   /* replace539_1 -> 1641 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1647, 1641 },
      -1,
   } },

   /* ('ior', ('ior(is_used_once)', ('flt', 'a', 'c'), 'd'), ('flt(is_used_once)', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd') */
   /* search540_0_0_0 -> 0 in the cache */
   /* search540_0_0_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 0, 665 },
      -1,
   } },
   /* search540_0_1 -> 1641 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1649, 1641 },
      0,
   } },
   /* search540_1_0 -> 1643 in the cache */
   /* search540_1_1 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1643, 665 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1650, 1651 },
      -1,
   } },

   /* replace540_0_0_0 -> 0 in the cache */
   /* replace540_0_0_1 -> 1643 in the cache */
   /* replace540_0_0 -> 1646 in the cache */
   /* replace540_0_1 -> 665 in the cache */
   /* replace540_0 -> 1647 in the cache */
   /* replace540_1 -> 1641 in the cache */
   /* replace540 -> 1648 in the cache */

   /* ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'b'), 'd'), ('flt', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd') */
   /* search541_0_0_0 -> 147 in the cache */
   /* search541_0_0_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 147, 148 },
      0,
   } },
   /* search541_0_1 -> 1641 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1653, 1641 },
      0,
   } },
   /* search541_1_0 -> 147 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      3, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 147, 1655 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1654, 1656 },
      -1,
   } },

   /* replace541_0_0 -> 147 in the cache */
   /* replace541_0_1_0 -> 148 in the cache */
   /* replace541_0_1_1 -> 1655 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      true,
      false,
      nir_op_fmax,
      1, 1,
      { 148, 1655 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 147, 1658 },
      -1,
   } },
   /* replace541_1 -> 1641 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1659, 1641 },
      -1,
   } },

   /* ('ior', ('ior(is_used_once)', ('flt', 'a', 'b'), 'd'), ('flt(is_used_once)', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd') */
   /* search542_0_0_0 -> 147 in the cache */
   /* search542_0_0_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 147, 148 },
      -1,
   } },
   /* search542_0_1 -> 1641 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 1661, 1641 },
      0,
   } },
   /* search542_1_0 -> 147 in the cache */
   /* search542_1_1 -> 1655 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 147, 1655 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 1662, 1663 },
      -1,
   } },

   /* replace542_0_0 -> 147 in the cache */
   /* replace542_0_1_0 -> 148 in the cache */
   /* replace542_0_1_1 -> 1655 in the cache */
   /* replace542_0_1 -> 1658 in the cache */
   /* replace542_0 -> 1659 in the cache */
   /* replace542_1 -> 1641 in the cache */
   /* replace542 -> 1660 in the cache */

   /* ('ior', ('flt', 'a(is_a_number)', 'b(is_a_number)'), ('flt', 'b', 'a')) => ('fneu', 'a', 'b') */
   /* search543_0_0 -> 989 in the cache */
   /* search543_0_1 -> 990 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 989, 990 },
      -1,
   } },
   /* search543_1_0 -> 3 in the cache */
   /* search543_1_1 -> 0 in the cache */
   /* search543_1 -> 1025 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1665, 1025 },
      -1,
   } },

   /* replace543_0 -> 0 in the cache */
   /* replace543_1 -> 3 in the cache */
   /* replace543 -> 999 in the cache */

   /* ('ior', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search544_0_0 -> 115 in the cache */
   /* search544_0_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 115, 11 },
      0,
   } },
   /* search544_1_0 -> 243 in the cache */
   /* search544_1_1 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 243, 115 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1667, 1668 },
      -1,
   } },

   /* replace544_0 -> 115 in the cache */
   /* replace544_1_0 -> 11 in the cache */
   /* replace544_1_1_0 -> 243 in the cache */
   /* replace544_1_1 -> 515 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 11, 515 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 115, 1670 },
      -1,
   } },

   /* ('ior', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search545_0_0 -> 115 in the cache */
   /* search545_0_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 115, 11 },
      -1,
   } },
   /* search545_1_0 -> 243 in the cache */
   /* search545_1_1 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 243, 115 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1672, 1673 },
      -1,
   } },

   /* replace545_0 -> 115 in the cache */
   /* replace545_1_0 -> 11 in the cache */
   /* replace545_1_1_0 -> 243 in the cache */
   /* replace545_1_1 -> 515 in the cache */
   /* replace545_1 -> 1670 in the cache */
   /* replace545 -> 1671 in the cache */

   /* ('ior', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search546_0_0 -> 115 in the cache */
   /* search546_0_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 115, 11 },
      0,
   } },
   /* search546_1_0 -> 243 in the cache */
   /* search546_1_1 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 243, 115 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1675, 1676 },
      -1,
   } },

   /* replace546_0 -> 115 in the cache */
   /* replace546_1_0 -> 11 in the cache */
   /* replace546_1_1_0 -> 243 in the cache */
   /* replace546_1_1 -> 515 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 11, 515 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 115, 1678 },
      -1,
   } },

   /* ('ior', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search547_0_0 -> 115 in the cache */
   /* search547_0_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 115, 11 },
      -1,
   } },
   /* search547_1_0 -> 243 in the cache */
   /* search547_1_1 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 243, 115 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1680, 1681 },
      -1,
   } },

   /* replace547_0 -> 115 in the cache */
   /* replace547_1_0 -> 11 in the cache */
   /* replace547_1_1_0 -> 243 in the cache */
   /* replace547_1_1 -> 515 in the cache */
   /* replace547_1 -> 1678 in the cache */
   /* replace547 -> 1679 in the cache */

   /* ('~iand', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search548_0_0 -> 115 in the cache */
   /* search548_0_1 -> 11 in the cache */
   /* search548_0 -> 1667 in the cache */
   /* search548_1_0 -> 243 in the cache */
   /* search548_1_1 -> 115 in the cache */
   /* search548_1 -> 1668 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1667, 1668 },
      -1,
   } },

   /* replace548_0 -> 115 in the cache */
   /* replace548_1_0 -> 11 in the cache */
   /* replace548_1_1_0 -> 243 in the cache */
   /* replace548_1_1 -> 515 in the cache */
   /* replace548_1 -> 1678 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 115, 1678 },
      -1,
   } },

   /* ('~iand', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search549_0_0 -> 115 in the cache */
   /* search549_0_1 -> 11 in the cache */
   /* search549_0 -> 1672 in the cache */
   /* search549_1_0 -> 243 in the cache */
   /* search549_1_1 -> 115 in the cache */
   /* search549_1 -> 1673 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1672, 1673 },
      -1,
   } },

   /* replace549_0 -> 115 in the cache */
   /* replace549_1_0 -> 11 in the cache */
   /* replace549_1_1_0 -> 243 in the cache */
   /* replace549_1_1 -> 515 in the cache */
   /* replace549_1 -> 1678 in the cache */
   /* replace549 -> 1684 in the cache */

   /* ('~iand', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search550_0_0 -> 115 in the cache */
   /* search550_0_1 -> 11 in the cache */
   /* search550_0 -> 1675 in the cache */
   /* search550_1_0 -> 243 in the cache */
   /* search550_1_1 -> 115 in the cache */
   /* search550_1 -> 1676 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1675, 1676 },
      -1,
   } },

   /* replace550_0 -> 115 in the cache */
   /* replace550_1_0 -> 11 in the cache */
   /* replace550_1_1_0 -> 243 in the cache */
   /* replace550_1_1 -> 515 in the cache */
   /* replace550_1 -> 1670 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 115, 1670 },
      -1,
   } },

   /* ('~iand', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search551_0_0 -> 115 in the cache */
   /* search551_0_1 -> 11 in the cache */
   /* search551_0 -> 1680 in the cache */
   /* search551_1_0 -> 243 in the cache */
   /* search551_1_1 -> 115 in the cache */
   /* search551_1 -> 1681 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1680, 1681 },
      -1,
   } },

   /* replace551_0 -> 115 in the cache */
   /* replace551_1_0 -> 11 in the cache */
   /* replace551_1_1_0 -> 243 in the cache */
   /* replace551_1_1 -> 515 in the cache */
   /* replace551_1 -> 1670 in the cache */
   /* replace551 -> 1687 in the cache */

   /* ('bcsel@16', ('feq', 'a', 0.0), 1.0, ('i2f16', ('iadd', ('b2i16', ('flt', 0.0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0.0)))))) => ('i2f16', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0))))) */
   /* search552_0_0 -> 11 in the cache */
   /* search552_0_1 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 11, 115 },
      -1,
   } },
   /* search552_1 -> 462 in the cache */
   /* search552_2_0_0_0_0 -> 115 in the cache */
   /* search552_2_0_0_0_1 -> 11 in the cache */
   /* search552_2_0_0_0 -> 1672 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 1672 },
      -1,
   } },
   /* search552_2_0_1_0_0_0 -> 11 in the cache */
   /* search552_2_0_1_0_0_1 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 11, 115 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 1691 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1692 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 1690, 1693 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 1,
      { 1694 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 1689, 462, 1695 },
      -1,
   } },

   /* replace552_0_0_0_0 -> 11 in the cache */
   /* replace552_0_0_0_1 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      nir_op_fge,
      -1, 0,
      { 11, 115 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1697 },
      -1,
   } },
   /* replace552_0_1_0_0_0 -> 11 in the cache */
   /* replace552_0_1_0_0_1 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      nir_op_flt,
      -1, 0,
      { 11, 115 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1699 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1700 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1698, 1701 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 1,
      { 1702 },
      -1,
   } },

   /* ('bcsel', 'a', ('b2f(is_used_once)', 'b@16'), ('b2f', 'c@16')) => ('b2f', ('bcsel', 'a', 'b', 'c')) */
   /* search553_0 -> 706 in the cache */
   /* search553_1_0 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 243 },
      0,
   } },
   /* search553_2_0 -> 450 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 450 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 1704, 1705 },
      -1,
   } },

   /* replace553_0_0 -> 706 in the cache */
   /* replace553_0_1 -> 243 in the cache */
   /* replace553_0_2 -> 450 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 243, 450 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1707 },
      -1,
   } },

   /* ('~i2f16', ('f2i', 'a@16')) => ('ftrunc', 'a') */
   /* search554_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 1709 },
      -1,
   } },

   /* replace554_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ftrunc,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('~f2i16', ('i2f', 'a@16')) => a */
   /* search555_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_i2f,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 1712 },
      -1,
   } },

   /* replace555 -> 11 in the cache */

   /* ('~f2i16', ('u2f', 'a@16')) => a */
   /* search556_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_u2f,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 1714 },
      -1,
   } },

   /* replace556 -> 11 in the cache */

   /* ('~f2u16', ('i2f', 'a@16')) => a */
   /* search557_0_0 -> 11 in the cache */
   /* search557_0 -> 1712 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 1712 },
      -1,
   } },

   /* replace557 -> 11 in the cache */

   /* ('~f2u16', ('u2f', 'a@16')) => a */
   /* search558_0_0 -> 11 in the cache */
   /* search558_0 -> 1714 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 1714 },
      -1,
   } },

   /* replace558 -> 11 in the cache */

   /* ('fadd', ('b2f16', ('flt', 0.0, 'a@16')), ('fneg', ('b2f16', ('flt', 'a@16', 0.0)))) => ('fsign', 'a') */
   /* search559_0_0_0 -> 115 in the cache */
   /* search559_0_0_1 -> 11 in the cache */
   /* search559_0_0 -> 1672 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2f16,
      -1, 0,
      { 1672 },
      -1,
   } },
   /* search559_1_0_0_0 -> 11 in the cache */
   /* search559_1_0_0_1 -> 115 in the cache */
   /* search559_1_0_0 -> 1691 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2f16,
      -1, 0,
      { 1691 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1719 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 1718, 1720 },
      -1,
   } },

   /* replace559_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fsign,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('iadd', ('b2i16', ('flt', 0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0)))) => ('f2i16', ('fsign', 'a')) */
   /* search560_0_0_0 -> 804 in the cache */
   /* search560_0_0_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 804, 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 1723 },
      -1,
   } },
   /* search560_1_0_0_0 -> 11 in the cache */
   /* search560_1_0_0_1 -> 804 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 11, 804 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 1725 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1726 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1724, 1727 },
      -1,
   } },

   /* replace560_0_0 -> 11 in the cache */
   /* replace560_0 -> 1722 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 1722 },
      -1,
   } },

   /* ('f2f16', ('f2f32', 'a@16')) => a */
   /* search561_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1730 },
      -1,
   } },

   /* replace561 -> 11 in the cache */

   /* ('i2i16', ('i2i32', 'a@16')) => a */
   /* search562_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2i32,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2i16,
      -1, 0,
      { 1732 },
      -1,
   } },

   /* replace562 -> 11 in the cache */

   /* ('u2u16', ('u2u32', 'a@16')) => a */
   /* search563_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2u32,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 1734 },
      -1,
   } },

   /* replace563 -> 11 in the cache */

   /* ('f2f16', ('b2f32', 'a@1')) => ('b2f16', 'a') */
   /* search564_0_0 -> 706 in the cache */
   /* search564_0 -> 1337 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1337 },
      -1,
   } },

   /* replace564_0 -> 706 in the cache */
   /* replace564 -> 1333 in the cache */

   /* ('i2i16', ('b2i32', 'a@1')) => ('b2i16', 'a') */
   /* search565_0_0 -> 706 in the cache */
   /* search565_0 -> 1325 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2i16,
      -1, 0,
      { 1325 },
      -1,
   } },

   /* replace565_0 -> 706 in the cache */
   /* replace565 -> 1321 in the cache */

   /* ('u2u16', ('b2i32', 'a@1')) => ('b2i16', 'a') */
   /* search566_0_0 -> 706 in the cache */
   /* search566_0 -> 1325 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 1325 },
      -1,
   } },

   /* replace566_0 -> 706 in the cache */
   /* replace566 -> 1321 in the cache */

   /* ('f2u32', ('f2f32', 'a@16')) => ('f2u32', 'a') */
   /* search567_0_0 -> 11 in the cache */
   /* search567_0 -> 1730 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 1730 },
      -1,
   } },

   /* replace567_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('f2i32', ('f2f32', 'a@16')) => ('f2i32', 'a') */
   /* search568_0_0 -> 11 in the cache */
   /* search568_0 -> 1730 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 1730 },
      -1,
   } },

   /* replace568_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('f2f16', ('u2f32', 'a')) => ('u2f16', 'a') */
   /* search569_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1743 },
      -1,
   } },

   /* replace569_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('f2f16', ('i2f32', 'a')) => ('i2f16', 'a') */
   /* search570_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1746 },
      -1,
   } },

   /* replace570_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('u2f32', ('u2u32', 'a@16')) => ('u2f32', 'a') */
   /* search571_0_0 -> 11 in the cache */
   /* search571_0 -> 1734 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 1734 },
      -1,
   } },

   /* replace571_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('i2f32', ('i2i32', 'a@16')) => ('i2f32', 'a') */
   /* search572_0_0 -> 11 in the cache */
   /* search572_0 -> 1732 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 1732 },
      -1,
   } },

   /* replace572_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('f2f16', ('f2f64', 'a@16')) => a */
   /* search573_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2f64,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1753 },
      -1,
   } },

   /* replace573 -> 11 in the cache */

   /* ('i2i16', ('i2i64', 'a@16')) => a */
   /* search574_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2i64,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2i16,
      -1, 0,
      { 1755 },
      -1,
   } },

   /* replace574 -> 11 in the cache */

   /* ('u2u16', ('u2u64', 'a@16')) => a */
   /* search575_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2u64,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 1757 },
      -1,
   } },

   /* replace575 -> 11 in the cache */

   /* ('f2f16', ('b2f64', 'a@1')) => ('b2f16', 'a') */
   /* search576_0_0 -> 706 in the cache */
   /* search576_0 -> 1341 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1341 },
      -1,
   } },

   /* replace576_0 -> 706 in the cache */
   /* replace576 -> 1333 in the cache */

   /* ('i2i16', ('b2i64', 'a@1')) => ('b2i16', 'a') */
   /* search577_0_0 -> 706 in the cache */
   /* search577_0 -> 1329 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2i16,
      -1, 0,
      { 1329 },
      -1,
   } },

   /* replace577_0 -> 706 in the cache */
   /* replace577 -> 1321 in the cache */

   /* ('u2u16', ('b2i64', 'a@1')) => ('b2i16', 'a') */
   /* search578_0_0 -> 706 in the cache */
   /* search578_0 -> 1329 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 1329 },
      -1,
   } },

   /* replace578_0 -> 706 in the cache */
   /* replace578 -> 1321 in the cache */

   /* ('f2u64', ('f2f64', 'a@16')) => ('f2u64', 'a') */
   /* search579_0_0 -> 11 in the cache */
   /* search579_0 -> 1753 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 1753 },
      -1,
   } },

   /* replace579_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('f2i64', ('f2f64', 'a@16')) => ('f2i64', 'a') */
   /* search580_0_0 -> 11 in the cache */
   /* search580_0 -> 1753 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 1753 },
      -1,
   } },

   /* replace580_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('f2f16', ('u2f64', 'a')) => ('u2f16', 'a') */
   /* search581_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1766 },
      -1,
   } },

   /* replace581_0 -> 32 in the cache */
   /* replace581 -> 1745 in the cache */

   /* ('f2f16', ('i2f64', 'a')) => ('i2f16', 'a') */
   /* search582_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2f16,
      -1, 0,
      { 1768 },
      -1,
   } },

   /* replace582_0 -> 32 in the cache */
   /* replace582 -> 1748 in the cache */

   /* ('u2f64', ('u2u64', 'a@16')) => ('u2f64', 'a') */
   /* search583_0_0 -> 11 in the cache */
   /* search583_0 -> 1757 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 1757 },
      -1,
   } },

   /* replace583_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('i2f64', ('i2i64', 'a@16')) => ('i2f64', 'a') */
   /* search584_0_0 -> 11 in the cache */
   /* search584_0 -> 1755 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 1755 },
      -1,
   } },

   /* replace584_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('ior', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search585_0_0 -> 117 in the cache */
   /* search585_0_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 117, 16 },
      0,
   } },
   /* search585_1_0 -> 36 in the cache */
   /* search585_1_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 36, 117 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1774, 1775 },
      -1,
   } },

   /* replace585_0 -> 117 in the cache */
   /* replace585_1_0 -> 16 in the cache */
   /* replace585_1_1_0 -> 36 in the cache */
   /* replace585_1_1 -> 581 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 16, 581 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 117, 1777 },
      -1,
   } },

   /* ('ior', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search586_0_0 -> 117 in the cache */
   /* search586_0_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 117, 16 },
      -1,
   } },
   /* search586_1_0 -> 36 in the cache */
   /* search586_1_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 36, 117 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1779, 1780 },
      -1,
   } },

   /* replace586_0 -> 117 in the cache */
   /* replace586_1_0 -> 16 in the cache */
   /* replace586_1_1_0 -> 36 in the cache */
   /* replace586_1_1 -> 581 in the cache */
   /* replace586_1 -> 1777 in the cache */
   /* replace586 -> 1778 in the cache */

   /* ('ior', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search587_0_0 -> 117 in the cache */
   /* search587_0_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 117, 16 },
      0,
   } },
   /* search587_1_0 -> 36 in the cache */
   /* search587_1_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 36, 117 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1782, 1783 },
      -1,
   } },

   /* replace587_0 -> 117 in the cache */
   /* replace587_1_0 -> 16 in the cache */
   /* replace587_1_1_0 -> 36 in the cache */
   /* replace587_1_1 -> 581 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 16, 581 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 117, 1785 },
      -1,
   } },

   /* ('ior', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search588_0_0 -> 117 in the cache */
   /* search588_0_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 117, 16 },
      -1,
   } },
   /* search588_1_0 -> 36 in the cache */
   /* search588_1_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 36, 117 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1787, 1788 },
      -1,
   } },

   /* replace588_0 -> 117 in the cache */
   /* replace588_1_0 -> 16 in the cache */
   /* replace588_1_1_0 -> 36 in the cache */
   /* replace588_1_1 -> 581 in the cache */
   /* replace588_1 -> 1785 in the cache */
   /* replace588 -> 1786 in the cache */

   /* ('~iand', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search589_0_0 -> 117 in the cache */
   /* search589_0_1 -> 16 in the cache */
   /* search589_0 -> 1774 in the cache */
   /* search589_1_0 -> 36 in the cache */
   /* search589_1_1 -> 117 in the cache */
   /* search589_1 -> 1775 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1774, 1775 },
      -1,
   } },

   /* replace589_0 -> 117 in the cache */
   /* replace589_1_0 -> 16 in the cache */
   /* replace589_1_1_0 -> 36 in the cache */
   /* replace589_1_1 -> 581 in the cache */
   /* replace589_1 -> 1785 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 117, 1785 },
      -1,
   } },

   /* ('~iand', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search590_0_0 -> 117 in the cache */
   /* search590_0_1 -> 16 in the cache */
   /* search590_0 -> 1779 in the cache */
   /* search590_1_0 -> 36 in the cache */
   /* search590_1_1 -> 117 in the cache */
   /* search590_1 -> 1780 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1779, 1780 },
      -1,
   } },

   /* replace590_0 -> 117 in the cache */
   /* replace590_1_0 -> 16 in the cache */
   /* replace590_1_1_0 -> 36 in the cache */
   /* replace590_1_1 -> 581 in the cache */
   /* replace590_1 -> 1785 in the cache */
   /* replace590 -> 1791 in the cache */

   /* ('~iand', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search591_0_0 -> 117 in the cache */
   /* search591_0_1 -> 16 in the cache */
   /* search591_0 -> 1782 in the cache */
   /* search591_1_0 -> 36 in the cache */
   /* search591_1_1 -> 117 in the cache */
   /* search591_1 -> 1783 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1782, 1783 },
      -1,
   } },

   /* replace591_0 -> 117 in the cache */
   /* replace591_1_0 -> 16 in the cache */
   /* replace591_1_1_0 -> 36 in the cache */
   /* replace591_1_1 -> 581 in the cache */
   /* replace591_1 -> 1777 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 117, 1777 },
      -1,
   } },

   /* ('~iand', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search592_0_0 -> 117 in the cache */
   /* search592_0_1 -> 16 in the cache */
   /* search592_0 -> 1787 in the cache */
   /* search592_1_0 -> 36 in the cache */
   /* search592_1_1 -> 117 in the cache */
   /* search592_1 -> 1788 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1787, 1788 },
      -1,
   } },

   /* replace592_0 -> 117 in the cache */
   /* replace592_1_0 -> 16 in the cache */
   /* replace592_1_1_0 -> 36 in the cache */
   /* replace592_1_1 -> 581 in the cache */
   /* replace592_1 -> 1777 in the cache */
   /* replace592 -> 1794 in the cache */

   /* ('bcsel@32', ('feq', 'a', 0.0), 1.0, ('i2f32', ('iadd', ('b2i32', ('flt', 0.0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0.0)))))) => ('i2f32', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0))))) */
   /* search593_0_0 -> 16 in the cache */
   /* search593_0_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 16, 117 },
      -1,
   } },
   /* search593_1 -> 228 in the cache */
   /* search593_2_0_0_0_0 -> 117 in the cache */
   /* search593_2_0_0_0_1 -> 16 in the cache */
   /* search593_2_0_0_0 -> 1779 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1779 },
      -1,
   } },
   /* search593_2_0_1_0_0_0 -> 16 in the cache */
   /* search593_2_0_1_0_0_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 16, 117 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1798 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1799 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 1797, 1800 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 1,
      { 1801 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 1796, 228, 1802 },
      -1,
   } },

   /* replace593_0_0_0_0 -> 16 in the cache */
   /* replace593_0_0_0_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      nir_op_fge,
      -1, 0,
      { 16, 117 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1804 },
      -1,
   } },
   /* replace593_0_1_0_0_0 -> 16 in the cache */
   /* replace593_0_1_0_0_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      nir_op_flt,
      -1, 0,
      { 16, 117 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1806 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1807 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1805, 1808 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 1,
      { 1809 },
      -1,
   } },

   /* ('bcsel', 'a', ('b2f(is_used_once)', 'b@32'), ('b2f', 'c@32')) => ('b2f', ('bcsel', 'a', 'b', 'c')) */
   /* search594_0 -> 706 in the cache */
   /* search594_1_0 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 36 },
      0,
   } },
   /* search594_2_0 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 133 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 1811, 1812 },
      -1,
   } },

   /* replace594_0_0 -> 706 in the cache */
   /* replace594_0_1 -> 36 in the cache */
   /* replace594_0_2 -> 133 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 36, 133 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1814 },
      -1,
   } },

   /* ('~i2f32', ('f2i', 'a@32')) => ('ftrunc', 'a') */
   /* search595_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 1816 },
      -1,
   } },

   /* replace595_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ftrunc,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('~f2i32', ('i2f', 'a@32')) => a */
   /* search596_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_i2f,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 1819 },
      -1,
   } },

   /* replace596 -> 16 in the cache */

   /* ('~f2i32', ('u2f', 'a@32')) => a */
   /* search597_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_u2f,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 1821 },
      -1,
   } },

   /* replace597 -> 16 in the cache */

   /* ('~f2u32', ('i2f', 'a@32')) => a */
   /* search598_0_0 -> 16 in the cache */
   /* search598_0 -> 1819 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 1819 },
      -1,
   } },

   /* replace598 -> 16 in the cache */

   /* ('~f2u32', ('u2f', 'a@32')) => a */
   /* search599_0_0 -> 16 in the cache */
   /* search599_0 -> 1821 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 1821 },
      -1,
   } },

   /* replace599 -> 16 in the cache */

   /* ('fadd', ('b2f32', ('flt', 0.0, 'a@32')), ('fneg', ('b2f32', ('flt', 'a@32', 0.0)))) => ('fsign', 'a') */
   /* search600_0_0_0 -> 117 in the cache */
   /* search600_0_0_1 -> 16 in the cache */
   /* search600_0_0 -> 1779 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2f32,
      -1, 0,
      { 1779 },
      -1,
   } },
   /* search600_1_0_0_0 -> 16 in the cache */
   /* search600_1_0_0_1 -> 117 in the cache */
   /* search600_1_0_0 -> 1798 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2f32,
      -1, 0,
      { 1798 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1826 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 1825, 1827 },
      -1,
   } },

   /* replace600_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsign,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('iadd', ('b2i32', ('flt', 0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0)))) => ('f2i32', ('fsign', 'a')) */
   /* search601_0_0_0 -> 120 in the cache */
   /* search601_0_0_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 120, 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1830 },
      -1,
   } },
   /* search601_1_0_0_0 -> 16 in the cache */
   /* search601_1_0_0_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 16, 120 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1832 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1833 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1831, 1834 },
      -1,
   } },

   /* replace601_0_0 -> 16 in the cache */
   /* replace601_0 -> 1829 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 1829 },
      -1,
   } },

   /* ('f2f32', ('f2f64', 'a@32')) => a */
   /* search602_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2f64,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 1837 },
      -1,
   } },

   /* replace602 -> 16 in the cache */

   /* ('i2i32', ('i2i64', 'a@32')) => a */
   /* search603_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2i64,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2i32,
      -1, 0,
      { 1839 },
      -1,
   } },

   /* replace603 -> 16 in the cache */

   /* ('u2u32', ('u2u64', 'a@32')) => a */
   /* search604_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2u64,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2u32,
      -1, 0,
      { 1841 },
      -1,
   } },

   /* replace604 -> 16 in the cache */

   /* ('f2f32', ('b2f64', 'a@1')) => ('b2f32', 'a') */
   /* search605_0_0 -> 706 in the cache */
   /* search605_0 -> 1341 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 1341 },
      -1,
   } },

   /* replace605_0 -> 706 in the cache */
   /* replace605 -> 1337 in the cache */

   /* ('i2i32', ('b2i64', 'a@1')) => ('b2i32', 'a') */
   /* search606_0_0 -> 706 in the cache */
   /* search606_0 -> 1329 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2i32,
      -1, 0,
      { 1329 },
      -1,
   } },

   /* replace606_0 -> 706 in the cache */
   /* replace606 -> 1325 in the cache */

   /* ('u2u32', ('b2i64', 'a@1')) => ('b2i32', 'a') */
   /* search607_0_0 -> 706 in the cache */
   /* search607_0 -> 1329 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2u32,
      -1, 0,
      { 1329 },
      -1,
   } },

   /* replace607_0 -> 706 in the cache */
   /* replace607 -> 1325 in the cache */

   /* ('f2u64', ('f2f64', 'a@32')) => ('f2u64', 'a') */
   /* search608_0_0 -> 16 in the cache */
   /* search608_0 -> 1837 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 1837 },
      -1,
   } },

   /* replace608_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('f2i64', ('f2f64', 'a@32')) => ('f2i64', 'a') */
   /* search609_0_0 -> 16 in the cache */
   /* search609_0 -> 1837 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 1837 },
      -1,
   } },

   /* replace609_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('f2f32', ('u2f64', 'a')) => ('u2f32', 'a') */
   /* search610_0_0 -> 32 in the cache */
   /* search610_0 -> 1766 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 1766 },
      -1,
   } },

   /* replace610_0 -> 32 in the cache */
   /* replace610 -> 1743 in the cache */

   /* ('f2f32', ('i2f64', 'a')) => ('i2f32', 'a') */
   /* search611_0_0 -> 32 in the cache */
   /* search611_0 -> 1768 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 1768 },
      -1,
   } },

   /* replace611_0 -> 32 in the cache */
   /* replace611 -> 1746 in the cache */

   /* ('u2f64', ('u2u64', 'a@32')) => ('u2f64', 'a') */
   /* search612_0_0 -> 16 in the cache */
   /* search612_0 -> 1841 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 1841 },
      -1,
   } },

   /* replace612_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_u2f64,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('i2f64', ('i2i64', 'a@32')) => ('i2f64', 'a') */
   /* search613_0_0 -> 16 in the cache */
   /* search613_0 -> 1839 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 1839 },
      -1,
   } },

   /* replace613_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('ior', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_float, { 0x0 /* 0.0 */ },
   } },
   /* search614_0_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1856, 21 },
      0,
   } },
   /* search614_1_0 -> 41 in the cache */
   /* search614_1_1 -> 1856 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 41, 1856 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1857, 1858 },
      -1,
   } },

   /* replace614_0 -> 1856 in the cache */
   /* replace614_1_0 -> 21 in the cache */
   /* replace614_1_1_0 -> 41 in the cache */
   /* replace614_1_1 -> 654 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 21, 654 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1856, 1860 },
      -1,
   } },

   /* ('ior', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search615_0_0 -> 1856 in the cache */
   /* search615_0_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1856, 21 },
      -1,
   } },
   /* search615_1_0 -> 41 in the cache */
   /* search615_1_1 -> 1856 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 41, 1856 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1862, 1863 },
      -1,
   } },

   /* replace615_0 -> 1856 in the cache */
   /* replace615_1_0 -> 21 in the cache */
   /* replace615_1_1_0 -> 41 in the cache */
   /* replace615_1_1 -> 654 in the cache */
   /* replace615_1 -> 1860 in the cache */
   /* replace615 -> 1861 in the cache */

   /* ('ior', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search616_0_0 -> 1856 in the cache */
   /* search616_0_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1856, 21 },
      0,
   } },
   /* search616_1_0 -> 41 in the cache */
   /* search616_1_1 -> 1856 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 41, 1856 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1865, 1866 },
      -1,
   } },

   /* replace616_0 -> 1856 in the cache */
   /* replace616_1_0 -> 21 in the cache */
   /* replace616_1_1_0 -> 41 in the cache */
   /* replace616_1_1 -> 654 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 21, 654 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1856, 1868 },
      -1,
   } },

   /* ('ior', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search617_0_0 -> 1856 in the cache */
   /* search617_0_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 1856, 21 },
      -1,
   } },
   /* search617_1_0 -> 41 in the cache */
   /* search617_1_1 -> 1856 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 41, 1856 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1870, 1871 },
      -1,
   } },

   /* replace617_0 -> 1856 in the cache */
   /* replace617_1_0 -> 21 in the cache */
   /* replace617_1_1_0 -> 41 in the cache */
   /* replace617_1_1 -> 654 in the cache */
   /* replace617_1 -> 1868 in the cache */
   /* replace617 -> 1869 in the cache */

   /* ('~iand', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search618_0_0 -> 1856 in the cache */
   /* search618_0_1 -> 21 in the cache */
   /* search618_0 -> 1857 in the cache */
   /* search618_1_0 -> 41 in the cache */
   /* search618_1_1 -> 1856 in the cache */
   /* search618_1 -> 1858 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1857, 1858 },
      -1,
   } },

   /* replace618_0 -> 1856 in the cache */
   /* replace618_1_0 -> 21 in the cache */
   /* replace618_1_1_0 -> 41 in the cache */
   /* replace618_1_1 -> 654 in the cache */
   /* replace618_1 -> 1868 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1856, 1868 },
      -1,
   } },

   /* ('~iand', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b'))) */
   /* search619_0_0 -> 1856 in the cache */
   /* search619_0_1 -> 21 in the cache */
   /* search619_0 -> 1862 in the cache */
   /* search619_1_0 -> 41 in the cache */
   /* search619_1_1 -> 1856 in the cache */
   /* search619_1 -> 1863 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1862, 1863 },
      -1,
   } },

   /* replace619_0 -> 1856 in the cache */
   /* replace619_1_0 -> 21 in the cache */
   /* replace619_1_1_0 -> 41 in the cache */
   /* replace619_1_1 -> 654 in the cache */
   /* replace619_1 -> 1868 in the cache */
   /* replace619 -> 1874 in the cache */

   /* ('~iand', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search620_0_0 -> 1856 in the cache */
   /* search620_0_1 -> 21 in the cache */
   /* search620_0 -> 1865 in the cache */
   /* search620_1_0 -> 41 in the cache */
   /* search620_1_1 -> 1856 in the cache */
   /* search620_1 -> 1866 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1865, 1866 },
      -1,
   } },

   /* replace620_0 -> 1856 in the cache */
   /* replace620_1_0 -> 21 in the cache */
   /* replace620_1_1_0 -> 41 in the cache */
   /* replace620_1_1 -> 654 in the cache */
   /* replace620_1 -> 1860 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1856, 1860 },
      -1,
   } },

   /* ('~iand', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b'))) */
   /* search621_0_0 -> 1856 in the cache */
   /* search621_0_1 -> 21 in the cache */
   /* search621_0 -> 1870 in the cache */
   /* search621_1_0 -> 41 in the cache */
   /* search621_1_1 -> 1856 in the cache */
   /* search621_1 -> 1871 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1870, 1871 },
      -1,
   } },

   /* replace621_0 -> 1856 in the cache */
   /* replace621_1_0 -> 21 in the cache */
   /* replace621_1_1_0 -> 41 in the cache */
   /* replace621_1_1 -> 654 in the cache */
   /* replace621_1 -> 1860 in the cache */
   /* replace621 -> 1877 in the cache */

   /* ('bcsel@64', ('feq', 'a', 0.0), 1.0, ('i2f64', ('iadd', ('b2i64', ('flt', 0.0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0.0)))))) => ('i2f64', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0))))) */
   /* search622_0_0 -> 21 in the cache */
   /* search622_0_1 -> 1856 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 21, 1856 },
      -1,
   } },
   /* search622_1 -> 603 in the cache */
   /* search622_2_0_0_0_0 -> 1856 in the cache */
   /* search622_2_0_0_0_1 -> 21 in the cache */
   /* search622_2_0_0_0 -> 1862 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 1862 },
      -1,
   } },
   /* search622_2_0_1_0_0_0 -> 21 in the cache */
   /* search622_2_0_1_0_0_1 -> 1856 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 21, 1856 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 1881 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1882 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 1880, 1883 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 1,
      { 1884 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 2,
      { 1879, 603, 1885 },
      -1,
   } },

   /* replace622_0_0_0_0 -> 21 in the cache */
   /* replace622_0_0_0_1 -> 1856 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      nir_op_fge,
      -1, 0,
      { 21, 1856 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1887 },
      -1,
   } },
   /* replace622_0_1_0_0_0 -> 21 in the cache */
   /* replace622_0_1_0_0_1 -> 1856 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      true,
      false,
      nir_op_flt,
      -1, 0,
      { 21, 1856 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 1889 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1890 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1888, 1891 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_i2f64,
      -1, 1,
      { 1892 },
      -1,
   } },

   /* ('bcsel', 'a', ('b2f(is_used_once)', 'b@64'), ('b2f', 'c@64')) => ('b2f', ('bcsel', 'a', 'b', 'c')) */
   /* search623_0 -> 706 in the cache */
   /* search623_1_0 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 41 },
      0,
   } },
   /* search623_2_0 -> 591 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 591 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 1894, 1895 },
      -1,
   } },

   /* replace623_0_0 -> 706 in the cache */
   /* replace623_0_1 -> 41 in the cache */
   /* replace623_0_2 -> 591 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 41, 591 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1897 },
      -1,
   } },

   /* ('~i2f64', ('f2i', 'a@64')) => ('ftrunc', 'a') */
   /* search624_0_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_i2f64,
      -1, 0,
      { 1899 },
      -1,
   } },

   /* replace624_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ftrunc,
      -1, 0,
      { 21 },
      -1,
   } },

   /* ('~f2i64', ('i2f', 'a@64')) => a */
   /* search625_0_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_i2f,
      -1, 0,
      { 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 1902 },
      -1,
   } },

   /* replace625 -> 21 in the cache */

   /* ('~f2i64', ('u2f', 'a@64')) => a */
   /* search626_0_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_u2f,
      -1, 0,
      { 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 1904 },
      -1,
   } },

   /* replace626 -> 21 in the cache */

   /* ('~f2u64', ('i2f', 'a@64')) => a */
   /* search627_0_0 -> 21 in the cache */
   /* search627_0 -> 1902 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 1902 },
      -1,
   } },

   /* replace627 -> 21 in the cache */

   /* ('~f2u64', ('u2f', 'a@64')) => a */
   /* search628_0_0 -> 21 in the cache */
   /* search628_0 -> 1904 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      nir_op_f2u64,
      -1, 0,
      { 1904 },
      -1,
   } },

   /* replace628 -> 21 in the cache */

   /* ('fadd', ('b2f64', ('flt', 0.0, 'a@64')), ('fneg', ('b2f64', ('flt', 'a@64', 0.0)))) => ('fsign', 'a') */
   /* search629_0_0_0 -> 1856 in the cache */
   /* search629_0_0_1 -> 21 in the cache */
   /* search629_0_0 -> 1862 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2f64,
      -1, 0,
      { 1862 },
      -1,
   } },
   /* search629_1_0_0_0 -> 21 in the cache */
   /* search629_1_0_0_1 -> 1856 in the cache */
   /* search629_1_0_0 -> 1881 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2f64,
      -1, 0,
      { 1881 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 1909 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 1,
      { 1908, 1910 },
      -1,
   } },

   /* replace629_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fsign,
      -1, 0,
      { 21 },
      -1,
   } },

   /* ('iadd', ('b2i64', ('flt', 0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0)))) => ('f2i64', ('fsign', 'a')) */
   /* search630_0_0_0 -> 847 in the cache */
   /* search630_0_0_1 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 847, 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 1913 },
      -1,
   } },
   /* search630_1_0_0_0 -> 21 in the cache */
   /* search630_1_0_0_1 -> 847 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 21, 847 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 1915 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1916 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 1914, 1917 },
      -1,
   } },

   /* replace630_0_0 -> 21 in the cache */
   /* replace630_0 -> 1912 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_f2i64,
      -1, 0,
      { 1912 },
      -1,
   } },

   /* ('f2fmp', ('u2f32', 'a@32')) => ('u2fmp', 'a') */
   /* search631_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2f32,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2fmp,
      -1, 0,
      { 1920 },
      -1,
   } },

   /* replace631_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2fmp,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('f2fmp', ('i2f32', 'a@32')) => ('i2fmp', 'a') */
   /* search632_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2f32,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2fmp,
      -1, 0,
      { 1923 },
      -1,
   } },

   /* replace632_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2fmp,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('f2u16', ('f2fmp', 'a@32')) => ('f2u16', 'a') */
   /* search633_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2fmp,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 1926 },
      -1,
   } },

   /* replace633_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('f2i16', ('f2fmp', 'a@32')) => ('f2i16', 'a') */
   /* search634_0_0 -> 16 in the cache */
   /* search634_0 -> 1926 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 1926 },
      -1,
   } },

   /* replace634_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('i2imp', ('f2u32', 'a@32')) => ('f2ump', 'a') */
   /* search635_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2u32,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2imp,
      -1, 0,
      { 1931 },
      -1,
   } },

   /* replace635_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2ump,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('i2imp', ('f2i32', 'a@32')) => ('f2imp', 'a') */
   /* search636_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2i32,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2imp,
      -1, 0,
      { 1934 },
      -1,
   } },

   /* replace636_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2imp,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('u2f16', ('i2imp', 'a@32')) => ('u2f16', 'a') */
   /* search637_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2imp,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 1937 },
      -1,
   } },

   /* replace637_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('i2f16', ('i2imp', 'a@32')) => ('i2f16', 'a') */
   /* search638_0_0 -> 16 in the cache */
   /* search638_0 -> 1937 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 1937 },
      -1,
   } },

   /* replace638_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('iand', ('u2u16', ('u2u8', 'a@16')), '#b') => ('iand', 'a', ('iand', 'b', 255)) */
   /* search639_0_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 1942 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 16 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1943, 1944 },
      -1,
   } },

   /* replace639_0 -> 11 in the cache */
   /* replace639_1_0 -> 243 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0xff /* 255 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 243, 1946 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 11, 1947 },
      -1,
   } },

   /* ('u2u16', ('u2u8(is_used_once)', ('iand', 'a@16', '#b'))) => ('iand', 'a', ('iand', 'b', 255)) */
   /* search640_0_0_0 -> 11 in the cache */
   /* search640_0_0_1 -> 1944 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 11, 1944 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 1949 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 1,
      { 1950 },
      -1,
   } },

   /* replace640_0 -> 11 in the cache */
   /* replace640_1_0 -> 243 in the cache */
   /* replace640_1_1 -> 1946 in the cache */
   /* replace640_1 -> 1947 in the cache */
   /* replace640 -> 1948 in the cache */

   /* ('u2u8', ('iand', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('iand', 'a', 'b')) */
   /* search641_0_0_0_0 -> 11 in the cache */
   /* search641_0_0_0 -> 1942 in the cache */
   /* search641_0_0 -> 1943 in the cache */
   /* search641_0_1_0_0 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 243 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 1952 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1943, 1953 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 1954 },
      -1,
   } },

   /* replace641_0_0 -> 11 in the cache */
   /* replace641_0_1 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 11, 243 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 1956 },
      -1,
   } },

   /* ('u2u8', ('iand', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('iand', 'a', 'b')) */
   /* search642_0_0_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 1958 },
      -1,
   } },
   /* search642_0_1_0_0 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 0,
      { 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2u16,
      -1, 0,
      { 1960 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1959, 1961 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 1962 },
      -1,
   } },

   /* replace642_0_0 -> 16 in the cache */
   /* replace642_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 16, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 1964 },
      -1,
   } },

   /* ('iand', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('iand', 'a', 'c'), 'b') */
   /* search643_0_0 -> 0 in the cache */
   /* search643_0_1 -> 767 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 0, 767 },
      -1,
   } },
   /* search643_1_0 -> 138 in the cache */
   /* search643_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 0,
      { 138, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1966, 1967 },
      -1,
   } },

   /* replace643_0_0 -> 0 in the cache */
   /* replace643_0_1 -> 138 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 0, 138 },
      -1,
   } },
   /* replace643_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 1,
      { 1969, 3 },
      -1,
   } },

   /* ('iand', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('iand', 'a', 'c'), 'b') */
   /* search644_0_0 -> 0 in the cache */
   /* search644_0_1 -> 767 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 0, 767 },
      -1,
   } },
   /* search644_1_0 -> 138 in the cache */
   /* search644_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 0,
      { 138, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1971, 1972 },
      -1,
   } },

   /* replace644_0_0 -> 0 in the cache */
   /* replace644_0_1 -> 138 in the cache */
   /* replace644_0 -> 1969 in the cache */
   /* replace644_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 1,
      { 1969, 3 },
      -1,
   } },

   /* ('iand', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('iand', 'a', 'c'), 'b') */
   /* search645_0_0 -> 0 in the cache */
   /* search645_0_1 -> 767 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 0, 767 },
      -1,
   } },
   /* search645_1_0 -> 138 in the cache */
   /* search645_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 0,
      { 138, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1975, 1976 },
      -1,
   } },

   /* replace645_0_0 -> 0 in the cache */
   /* replace645_0_1 -> 138 in the cache */
   /* replace645_0 -> 1969 in the cache */
   /* replace645_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 1,
      { 1969, 3 },
      -1,
   } },

   /* ('iand', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('iand', 'a', 'c'), 'b') */
   /* search646_0_0 -> 0 in the cache */
   /* search646_0_1 -> 767 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 0, 767 },
      -1,
   } },
   /* search646_1_0 -> 138 in the cache */
   /* search646_1_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 0,
      { 138, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1979, 1980 },
      -1,
   } },

   /* replace646_0_0 -> 0 in the cache */
   /* replace646_0_1 -> 138 in the cache */
   /* replace646_0 -> 1969 in the cache */
   /* replace646_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 1,
      { 1969, 3 },
      -1,
   } },

   /* ('iand', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('iand', 'a', 'c'), 'b') */
   /* search647_0_0 -> 124 in the cache */
   /* search647_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 124, 33 },
      0,
   } },
   /* search647_1_0 -> 127 in the cache */
   /* search647_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 127, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1983, 1984 },
      -1,
   } },

   /* replace647_0_0 -> 124 in the cache */
   /* replace647_0_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 124, 127 },
      -1,
   } },
   /* replace647_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 1986, 36 },
      -1,
   } },

   /* ('iand', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('iand', 'a', 'c'), 'b') */
   /* search648_0_0 -> 124 in the cache */
   /* search648_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 124, 33 },
      0,
   } },
   /* search648_1_0 -> 127 in the cache */
   /* search648_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 127, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1988, 1989 },
      -1,
   } },

   /* replace648_0_0 -> 124 in the cache */
   /* replace648_0_1 -> 127 in the cache */
   /* replace648_0 -> 1986 in the cache */
   /* replace648_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 1,
      { 1986, 36 },
      -1,
   } },

   /* ('iand', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('iand', 'a', 'c'), 'b') */
   /* search649_0_0 -> 124 in the cache */
   /* search649_0_1 -> 33 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 124, 33 },
      0,
   } },
   /* search649_1_0 -> 127 in the cache */
   /* search649_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 127, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1992, 1993 },
      -1,
   } },

   /* replace649_0_0 -> 124 in the cache */
   /* replace649_0_1 -> 127 in the cache */
   /* replace649_0 -> 1986 in the cache */
   /* replace649_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 1986, 36 },
      -1,
   } },

   /* ('u2u8', ('ior', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('ior', 'a', 'b')) */
   /* search650_0_0_0_0 -> 11 in the cache */
   /* search650_0_0_0 -> 1942 in the cache */
   /* search650_0_0 -> 1943 in the cache */
   /* search650_0_1_0_0 -> 243 in the cache */
   /* search650_0_1_0 -> 1952 in the cache */
   /* search650_0_1 -> 1953 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1943, 1953 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 1996 },
      -1,
   } },

   /* replace650_0_0 -> 11 in the cache */
   /* replace650_0_1 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 11, 243 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 1998 },
      -1,
   } },

   /* ('u2u8', ('ior', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('ior', 'a', 'b')) */
   /* search651_0_0_0_0 -> 16 in the cache */
   /* search651_0_0_0 -> 1958 in the cache */
   /* search651_0_0 -> 1959 in the cache */
   /* search651_0_1_0_0 -> 36 in the cache */
   /* search651_0_1_0 -> 1960 in the cache */
   /* search651_0_1 -> 1961 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1959, 1961 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2000 },
      -1,
   } },

   /* replace651_0_0 -> 16 in the cache */
   /* replace651_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 16, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2002 },
      -1,
   } },

   /* ('ior', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('ior', 'a', 'c'), 'b') */
   /* search652_0_0 -> 0 in the cache */
   /* search652_0_1 -> 767 in the cache */
   /* search652_0 -> 1966 in the cache */
   /* search652_1_0 -> 138 in the cache */
   /* search652_1_1 -> 3 in the cache */
   /* search652_1 -> 1967 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1966, 1967 },
      -1,
   } },

   /* replace652_0_0 -> 0 in the cache */
   /* replace652_0_1 -> 138 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 0, 138 },
      -1,
   } },
   /* replace652_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 1,
      { 2005, 3 },
      -1,
   } },

   /* ('ior', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('ior', 'a', 'c'), 'b') */
   /* search653_0_0 -> 0 in the cache */
   /* search653_0_1 -> 767 in the cache */
   /* search653_0 -> 1971 in the cache */
   /* search653_1_0 -> 138 in the cache */
   /* search653_1_1 -> 3 in the cache */
   /* search653_1 -> 1972 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1971, 1972 },
      -1,
   } },

   /* replace653_0_0 -> 0 in the cache */
   /* replace653_0_1 -> 138 in the cache */
   /* replace653_0 -> 2005 in the cache */
   /* replace653_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 1,
      { 2005, 3 },
      -1,
   } },

   /* ('ior', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('ior', 'a', 'c'), 'b') */
   /* search654_0_0 -> 0 in the cache */
   /* search654_0_1 -> 767 in the cache */
   /* search654_0 -> 1975 in the cache */
   /* search654_1_0 -> 138 in the cache */
   /* search654_1_1 -> 3 in the cache */
   /* search654_1 -> 1976 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1975, 1976 },
      -1,
   } },

   /* replace654_0_0 -> 0 in the cache */
   /* replace654_0_1 -> 138 in the cache */
   /* replace654_0 -> 2005 in the cache */
   /* replace654_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 1,
      { 2005, 3 },
      -1,
   } },

   /* ('ior', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('ior', 'a', 'c'), 'b') */
   /* search655_0_0 -> 0 in the cache */
   /* search655_0_1 -> 767 in the cache */
   /* search655_0 -> 1979 in the cache */
   /* search655_1_0 -> 138 in the cache */
   /* search655_1_1 -> 3 in the cache */
   /* search655_1 -> 1980 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1979, 1980 },
      -1,
   } },

   /* replace655_0_0 -> 0 in the cache */
   /* replace655_0_1 -> 138 in the cache */
   /* replace655_0 -> 2005 in the cache */
   /* replace655_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 1,
      { 2005, 3 },
      -1,
   } },

   /* ('ior', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('ior', 'a', 'c'), 'b') */
   /* search656_0_0 -> 124 in the cache */
   /* search656_0_1 -> 33 in the cache */
   /* search656_0 -> 1983 in the cache */
   /* search656_1_0 -> 127 in the cache */
   /* search656_1_1 -> 36 in the cache */
   /* search656_1 -> 1984 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1983, 1984 },
      -1,
   } },

   /* replace656_0_0 -> 124 in the cache */
   /* replace656_0_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 124, 127 },
      -1,
   } },
   /* replace656_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 2014, 36 },
      -1,
   } },

   /* ('ior', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('ior', 'a', 'c'), 'b') */
   /* search657_0_0 -> 124 in the cache */
   /* search657_0_1 -> 33 in the cache */
   /* search657_0 -> 1988 in the cache */
   /* search657_1_0 -> 127 in the cache */
   /* search657_1_1 -> 36 in the cache */
   /* search657_1 -> 1989 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1988, 1989 },
      -1,
   } },

   /* replace657_0_0 -> 124 in the cache */
   /* replace657_0_1 -> 127 in the cache */
   /* replace657_0 -> 2014 in the cache */
   /* replace657_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 1,
      { 2014, 36 },
      -1,
   } },

   /* ('ior', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('ior', 'a', 'c'), 'b') */
   /* search658_0_0 -> 124 in the cache */
   /* search658_0_1 -> 33 in the cache */
   /* search658_0 -> 1992 in the cache */
   /* search658_1_0 -> 127 in the cache */
   /* search658_1_1 -> 36 in the cache */
   /* search658_1 -> 1993 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1992, 1993 },
      -1,
   } },

   /* replace658_0_0 -> 124 in the cache */
   /* replace658_0_1 -> 127 in the cache */
   /* replace658_0 -> 2014 in the cache */
   /* replace658_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 2014, 36 },
      -1,
   } },

   /* ('u2u8', ('ixor', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('ixor', 'a', 'b')) */
   /* search659_0_0_0_0 -> 11 in the cache */
   /* search659_0_0_0 -> 1942 in the cache */
   /* search659_0_0 -> 1943 in the cache */
   /* search659_0_1_0_0 -> 243 in the cache */
   /* search659_0_1_0 -> 1952 in the cache */
   /* search659_0_1 -> 1953 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 1943, 1953 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2020 },
      -1,
   } },

   /* replace659_0_0 -> 11 in the cache */
   /* replace659_0_1 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 11, 243 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2022 },
      -1,
   } },

   /* ('u2u8', ('ixor', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('ixor', 'a', 'b')) */
   /* search660_0_0_0_0 -> 16 in the cache */
   /* search660_0_0_0 -> 1958 in the cache */
   /* search660_0_0 -> 1959 in the cache */
   /* search660_0_1_0_0 -> 36 in the cache */
   /* search660_0_1_0 -> 1960 in the cache */
   /* search660_0_1 -> 1961 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 1959, 1961 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2024 },
      -1,
   } },

   /* replace660_0_0 -> 16 in the cache */
   /* replace660_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 16, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_u2u8,
      -1, 1,
      { 2026 },
      -1,
   } },

   /* ('ixor', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('ixor', 'a', 'c'), 'b') */
   /* search661_0_0 -> 0 in the cache */
   /* search661_0_1 -> 767 in the cache */
   /* search661_0 -> 1966 in the cache */
   /* search661_1_0 -> 138 in the cache */
   /* search661_1_1 -> 3 in the cache */
   /* search661_1 -> 1967 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 1966, 1967 },
      -1,
   } },

   /* replace661_0_0 -> 0 in the cache */
   /* replace661_0_1 -> 138 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 0, 138 },
      -1,
   } },
   /* replace661_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i8,
      -1, 1,
      { 2029, 3 },
      -1,
   } },

   /* ('ixor', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('ixor', 'a', 'c'), 'b') */
   /* search662_0_0 -> 0 in the cache */
   /* search662_0_1 -> 767 in the cache */
   /* search662_0 -> 1971 in the cache */
   /* search662_1_0 -> 138 in the cache */
   /* search662_1_1 -> 3 in the cache */
   /* search662_1 -> 1972 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 1971, 1972 },
      -1,
   } },

   /* replace662_0_0 -> 0 in the cache */
   /* replace662_0_1 -> 138 in the cache */
   /* replace662_0 -> 2029 in the cache */
   /* replace662_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u8,
      -1, 1,
      { 2029, 3 },
      -1,
   } },

   /* ('ixor', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('ixor', 'a', 'c'), 'b') */
   /* search663_0_0 -> 0 in the cache */
   /* search663_0_1 -> 767 in the cache */
   /* search663_0 -> 1975 in the cache */
   /* search663_1_0 -> 138 in the cache */
   /* search663_1_1 -> 3 in the cache */
   /* search663_1 -> 1976 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 1975, 1976 },
      -1,
   } },

   /* replace663_0_0 -> 0 in the cache */
   /* replace663_0_1 -> 138 in the cache */
   /* replace663_0 -> 2029 in the cache */
   /* replace663_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_i16,
      -1, 1,
      { 2029, 3 },
      -1,
   } },

   /* ('ixor', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('ixor', 'a', 'c'), 'b') */
   /* search664_0_0 -> 0 in the cache */
   /* search664_0_1 -> 767 in the cache */
   /* search664_0 -> 1979 in the cache */
   /* search664_1_0 -> 138 in the cache */
   /* search664_1_1 -> 3 in the cache */
   /* search664_1 -> 1980 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 1979, 1980 },
      -1,
   } },

   /* replace664_0_0 -> 0 in the cache */
   /* replace664_0_1 -> 138 in the cache */
   /* replace664_0 -> 2029 in the cache */
   /* replace664_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_extract_u16,
      -1, 1,
      { 2029, 3 },
      -1,
   } },

   /* ('ixor', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('ixor', 'a', 'c'), 'b') */
   /* search665_0_0 -> 124 in the cache */
   /* search665_0_1 -> 33 in the cache */
   /* search665_0 -> 1983 in the cache */
   /* search665_1_0 -> 127 in the cache */
   /* search665_1_1 -> 36 in the cache */
   /* search665_1 -> 1984 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 1983, 1984 },
      -1,
   } },

   /* replace665_0_0 -> 124 in the cache */
   /* replace665_0_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 124, 127 },
      -1,
   } },
   /* replace665_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 2038, 36 },
      -1,
   } },

   /* ('ixor', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('ixor', 'a', 'c'), 'b') */
   /* search666_0_0 -> 124 in the cache */
   /* search666_0_1 -> 33 in the cache */
   /* search666_0 -> 1988 in the cache */
   /* search666_1_0 -> 127 in the cache */
   /* search666_1_1 -> 36 in the cache */
   /* search666_1 -> 1989 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 1988, 1989 },
      -1,
   } },

   /* replace666_0_0 -> 124 in the cache */
   /* replace666_0_1 -> 127 in the cache */
   /* replace666_0 -> 2038 in the cache */
   /* replace666_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 1,
      { 2038, 36 },
      -1,
   } },

   /* ('ixor', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('ixor', 'a', 'c'), 'b') */
   /* search667_0_0 -> 124 in the cache */
   /* search667_0_1 -> 33 in the cache */
   /* search667_0 -> 1992 in the cache */
   /* search667_1_0 -> 127 in the cache */
   /* search667_1_1 -> 36 in the cache */
   /* search667_1 -> 1993 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 1992, 1993 },
      -1,
   } },

   /* replace667_0_0 -> 124 in the cache */
   /* replace667_0_1 -> 127 in the cache */
   /* replace667_0 -> 2038 in the cache */
   /* replace667_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 2038, 36 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('ior', 'a', 'b'), 0) */
   /* search668_0_0 -> 6 in the cache */
   /* search668_0_1 -> 782 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 6, 782 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 8 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search668_1_1 -> 782 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 2045, 782 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2044, 2046 },
      -1,
   } },

   /* replace668_0_0 -> 6 in the cache */
   /* replace668_0_1 -> 2045 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 6, 2045 },
      -1,
   } },
   /* replace668_1 -> 782 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2048, 782 },
      -1,
   } },

   /* ('ior', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('ior', 'a', 'b'), 0) */
   /* search669_0_0 -> 6 in the cache */
   /* search669_0_1 -> 782 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      1, 1,
      { 6, 782 },
      -1,
   } },
   /* search669_1_0 -> 2045 in the cache */
   /* search669_1_1 -> 782 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      2, 1,
      { 2045, 782 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2050, 2051 },
      -1,
   } },

   /* replace669_0_0 -> 6 in the cache */
   /* replace669_0_1 -> 2045 in the cache */
   /* replace669_0 -> 2048 in the cache */
   /* replace669_1 -> 782 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2048, 782 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('umax', 'a', 'b'), 0) */
   /* search670_0_0 -> 6 in the cache */
   /* search670_0_1 -> 782 in the cache */
   /* search670_0 -> 2044 in the cache */
   /* search670_1_0 -> 2045 in the cache */
   /* search670_1_1 -> 782 in the cache */
   /* search670_1 -> 2046 in the cache */
   /* search670 -> 2047 in the cache */

   /* replace670_0_0 -> 6 in the cache */
   /* replace670_0_1 -> 2045 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_umax,
      1, 1,
      { 6, 2045 },
      -1,
   } },
   /* replace670_1 -> 782 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2054, 782 },
      -1,
   } },

   /* ('ior', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('umin', 'a', 'b'), 0) */
   /* search671_0_0 -> 6 in the cache */
   /* search671_0_1 -> 782 in the cache */
   /* search671_0 -> 2044 in the cache */
   /* search671_1_0 -> 2045 in the cache */
   /* search671_1_1 -> 782 in the cache */
   /* search671_1 -> 2046 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2044, 2046 },
      -1,
   } },

   /* replace671_0_0 -> 6 in the cache */
   /* replace671_0_1 -> 2045 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_umin,
      1, 1,
      { 6, 2045 },
      -1,
   } },
   /* replace671_1 -> 782 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2057, 782 },
      -1,
   } },

   /* ('iand', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('umin', 'a', 'b'), 0) */
   /* search672_0_0 -> 6 in the cache */
   /* search672_0_1 -> 782 in the cache */
   /* search672_0 -> 2050 in the cache */
   /* search672_1_0 -> 2045 in the cache */
   /* search672_1_1 -> 782 in the cache */
   /* search672_1 -> 2051 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2050, 2051 },
      -1,
   } },

   /* replace672_0_0 -> 6 in the cache */
   /* replace672_0_1 -> 2045 in the cache */
   /* replace672_0 -> 2057 in the cache */
   /* replace672_1 -> 782 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2057, 782 },
      -1,
   } },

   /* ('ior', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('umax', 'a', 'b'), 0) */
   /* search673_0_0 -> 6 in the cache */
   /* search673_0_1 -> 782 in the cache */
   /* search673_0 -> 2050 in the cache */
   /* search673_1_0 -> 2045 in the cache */
   /* search673_1_1 -> 782 in the cache */
   /* search673_1 -> 2051 in the cache */
   /* search673 -> 2052 in the cache */

   /* replace673_0_0 -> 6 in the cache */
   /* replace673_0_1 -> 2045 in the cache */
   /* replace673_0 -> 2054 in the cache */
   /* replace673_1 -> 782 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2054, 782 },
      -1,
   } },

   /* ('ineg', ('b2i8', 'a@8')) => a */
   /* search674_0_0 -> 6 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_b2i8,
      -1, 0,
      { 6 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2062 },
      -1,
   } },

   /* replace674 -> 6 in the cache */

   /* ('ishl', 'a@8', ('iand', 7, 'b')) => ('ishl', 'a', 'b') */
   /* search675_0 -> 6 in the cache */
   /* search675_1_0 -> 9 in the cache */
   /* search675_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 9, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 6, 2064 },
      -1,
   } },

   /* replace675_0 -> 6 in the cache */
   /* replace675_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 6, 36 },
      -1,
   } },

   /* ('ishr', 'a@8', ('iand', 7, 'b')) => ('ishr', 'a', 'b') */
   /* search676_0 -> 6 in the cache */
   /* search676_1_0 -> 9 in the cache */
   /* search676_1_1 -> 36 in the cache */
   /* search676_1 -> 2064 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 1,
      { 6, 2064 },
      -1,
   } },

   /* replace676_0 -> 6 in the cache */
   /* replace676_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 6, 36 },
      -1,
   } },

   /* ('ushr', 'a@8', ('iand', 7, 'b')) => ('ushr', 'a', 'b') */
   /* search677_0 -> 6 in the cache */
   /* search677_1_0 -> 9 in the cache */
   /* search677_1_1 -> 36 in the cache */
   /* search677_1 -> 2064 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 6, 2064 },
      -1,
   } },

   /* replace677_0 -> 6 in the cache */
   /* replace677_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 6, 36 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('ior', 'a', 'b'), 0) */
   /* search678_0_0 -> 11 in the cache */
   /* search678_0_1 -> 804 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 11, 804 },
      -1,
   } },
   /* search678_1_0 -> 243 in the cache */
   /* search678_1_1 -> 804 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 243, 804 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2071, 2072 },
      -1,
   } },

   /* replace678_0_0 -> 11 in the cache */
   /* replace678_0_1 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 11, 243 },
      -1,
   } },
   /* replace678_1 -> 804 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2074, 804 },
      -1,
   } },

   /* ('ior', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('ior', 'a', 'b'), 0) */
   /* search679_0_0 -> 11 in the cache */
   /* search679_0_1 -> 804 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      1, 1,
      { 11, 804 },
      -1,
   } },
   /* search679_1_0 -> 243 in the cache */
   /* search679_1_1 -> 804 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      2, 1,
      { 243, 804 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2076, 2077 },
      -1,
   } },

   /* replace679_0_0 -> 11 in the cache */
   /* replace679_0_1 -> 243 in the cache */
   /* replace679_0 -> 2074 in the cache */
   /* replace679_1 -> 804 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2074, 804 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('umax', 'a', 'b'), 0) */
   /* search680_0_0 -> 11 in the cache */
   /* search680_0_1 -> 804 in the cache */
   /* search680_0 -> 2071 in the cache */
   /* search680_1_0 -> 243 in the cache */
   /* search680_1_1 -> 804 in the cache */
   /* search680_1 -> 2072 in the cache */
   /* search680 -> 2073 in the cache */

   /* replace680_0_0 -> 11 in the cache */
   /* replace680_0_1 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_umax,
      1, 1,
      { 11, 243 },
      -1,
   } },
   /* replace680_1 -> 804 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2080, 804 },
      -1,
   } },

   /* ('ior', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('umin', 'a', 'b'), 0) */
   /* search681_0_0 -> 11 in the cache */
   /* search681_0_1 -> 804 in the cache */
   /* search681_0 -> 2071 in the cache */
   /* search681_1_0 -> 243 in the cache */
   /* search681_1_1 -> 804 in the cache */
   /* search681_1 -> 2072 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2071, 2072 },
      -1,
   } },

   /* replace681_0_0 -> 11 in the cache */
   /* replace681_0_1 -> 243 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_umin,
      1, 1,
      { 11, 243 },
      -1,
   } },
   /* replace681_1 -> 804 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2083, 804 },
      -1,
   } },

   /* ('iand', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('umin', 'a', 'b'), 0) */
   /* search682_0_0 -> 11 in the cache */
   /* search682_0_1 -> 804 in the cache */
   /* search682_0 -> 2076 in the cache */
   /* search682_1_0 -> 243 in the cache */
   /* search682_1_1 -> 804 in the cache */
   /* search682_1 -> 2077 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2076, 2077 },
      -1,
   } },

   /* replace682_0_0 -> 11 in the cache */
   /* replace682_0_1 -> 243 in the cache */
   /* replace682_0 -> 2083 in the cache */
   /* replace682_1 -> 804 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2083, 804 },
      -1,
   } },

   /* ('ior', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('umax', 'a', 'b'), 0) */
   /* search683_0_0 -> 11 in the cache */
   /* search683_0_1 -> 804 in the cache */
   /* search683_0 -> 2076 in the cache */
   /* search683_1_0 -> 243 in the cache */
   /* search683_1_1 -> 804 in the cache */
   /* search683_1 -> 2077 in the cache */
   /* search683 -> 2078 in the cache */

   /* replace683_0_0 -> 11 in the cache */
   /* replace683_0_1 -> 243 in the cache */
   /* replace683_0 -> 2080 in the cache */
   /* replace683_1 -> 804 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2080, 804 },
      -1,
   } },

   /* ('ineg', ('b2i16', 'a@16')) => a */
   /* search684_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_b2i16,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2088 },
      -1,
   } },

   /* replace684 -> 11 in the cache */

   /* ('ishl', 'a@16', ('iand', 15, 'b')) => ('ishl', 'a', 'b') */
   /* search685_0 -> 11 in the cache */
   /* search685_1_0 -> 14 in the cache */
   /* search685_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 14, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 11, 2090 },
      -1,
   } },

   /* replace685_0 -> 11 in the cache */
   /* replace685_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 11, 36 },
      -1,
   } },

   /* ('ishr', 'a@16', ('iand', 15, 'b')) => ('ishr', 'a', 'b') */
   /* search686_0 -> 11 in the cache */
   /* search686_1_0 -> 14 in the cache */
   /* search686_1_1 -> 36 in the cache */
   /* search686_1 -> 2090 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 1,
      { 11, 2090 },
      -1,
   } },

   /* replace686_0 -> 11 in the cache */
   /* replace686_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 11, 36 },
      -1,
   } },

   /* ('ushr', 'a@16', ('iand', 15, 'b')) => ('ushr', 'a', 'b') */
   /* search687_0 -> 11 in the cache */
   /* search687_1_0 -> 14 in the cache */
   /* search687_1_1 -> 36 in the cache */
   /* search687_1 -> 2090 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 11, 2090 },
      -1,
   } },

   /* replace687_0 -> 11 in the cache */
   /* replace687_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 11, 36 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('ior', 'a', 'b'), 0) */
   /* search688_0_0 -> 16 in the cache */
   /* search688_0_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 16, 120 },
      -1,
   } },
   /* search688_1_0 -> 36 in the cache */
   /* search688_1_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 36, 120 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2097, 2098 },
      -1,
   } },

   /* replace688_0_0 -> 16 in the cache */
   /* replace688_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* replace688_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2100, 120 },
      -1,
   } },

   /* ('ior', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('ior', 'a', 'b'), 0) */
   /* search689_0_0 -> 16 in the cache */
   /* search689_0_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      1, 1,
      { 16, 120 },
      -1,
   } },
   /* search689_1_0 -> 36 in the cache */
   /* search689_1_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      2, 1,
      { 36, 120 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2102, 2103 },
      -1,
   } },

   /* replace689_0_0 -> 16 in the cache */
   /* replace689_0_1 -> 36 in the cache */
   /* replace689_0 -> 2100 in the cache */
   /* replace689_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2100, 120 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('umax', 'a', 'b'), 0) */
   /* search690_0_0 -> 16 in the cache */
   /* search690_0_1 -> 120 in the cache */
   /* search690_0 -> 2097 in the cache */
   /* search690_1_0 -> 36 in the cache */
   /* search690_1_1 -> 120 in the cache */
   /* search690_1 -> 2098 in the cache */
   /* search690 -> 2099 in the cache */

   /* replace690_0_0 -> 16 in the cache */
   /* replace690_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_umax,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* replace690_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2106, 120 },
      -1,
   } },

   /* ('ior', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('umin', 'a', 'b'), 0) */
   /* search691_0_0 -> 16 in the cache */
   /* search691_0_1 -> 120 in the cache */
   /* search691_0 -> 2097 in the cache */
   /* search691_1_0 -> 36 in the cache */
   /* search691_1_1 -> 120 in the cache */
   /* search691_1 -> 2098 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2097, 2098 },
      -1,
   } },

   /* replace691_0_0 -> 16 in the cache */
   /* replace691_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_umin,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* replace691_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2109, 120 },
      -1,
   } },

   /* ('iand', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('umin', 'a', 'b'), 0) */
   /* search692_0_0 -> 16 in the cache */
   /* search692_0_1 -> 120 in the cache */
   /* search692_0 -> 2102 in the cache */
   /* search692_1_0 -> 36 in the cache */
   /* search692_1_1 -> 120 in the cache */
   /* search692_1 -> 2103 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2102, 2103 },
      -1,
   } },

   /* replace692_0_0 -> 16 in the cache */
   /* replace692_0_1 -> 36 in the cache */
   /* replace692_0 -> 2109 in the cache */
   /* replace692_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2109, 120 },
      -1,
   } },

   /* ('ior', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('umax', 'a', 'b'), 0) */
   /* search693_0_0 -> 16 in the cache */
   /* search693_0_1 -> 120 in the cache */
   /* search693_0 -> 2102 in the cache */
   /* search693_1_0 -> 36 in the cache */
   /* search693_1_1 -> 120 in the cache */
   /* search693_1 -> 2103 in the cache */
   /* search693 -> 2104 in the cache */

   /* replace693_0_0 -> 16 in the cache */
   /* replace693_0_1 -> 36 in the cache */
   /* replace693_0 -> 2106 in the cache */
   /* replace693_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2106, 120 },
      -1,
   } },

   /* ('ineg', ('b2i32', 'a@32')) => a */
   /* search694_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_b2i32,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2114 },
      -1,
   } },

   /* replace694 -> 16 in the cache */

   /* ('ishl', 'a@32', ('iand', 31, 'b')) => ('ishl', 'a', 'b') */
   /* search695_0 -> 16 in the cache */
   /* search695_1_0 -> 19 in the cache */
   /* search695_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 19, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 16, 2116 },
      -1,
   } },

   /* replace695_0 -> 16 in the cache */
   /* replace695_1 -> 36 in the cache */
   /* replace695 -> 895 in the cache */

   /* ('ishr', 'a@32', ('iand', 31, 'b')) => ('ishr', 'a', 'b') */
   /* search696_0 -> 16 in the cache */
   /* search696_1_0 -> 19 in the cache */
   /* search696_1_1 -> 36 in the cache */
   /* search696_1 -> 2116 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 1,
      { 16, 2116 },
      -1,
   } },

   /* replace696_0 -> 16 in the cache */
   /* replace696_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 16, 36 },
      -1,
   } },

   /* ('ushr', 'a@32', ('iand', 31, 'b')) => ('ushr', 'a', 'b') */
   /* search697_0 -> 16 in the cache */
   /* search697_1_0 -> 19 in the cache */
   /* search697_1_1 -> 36 in the cache */
   /* search697_1 -> 2116 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 16, 2116 },
      -1,
   } },

   /* replace697_0 -> 16 in the cache */
   /* replace697_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 36 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('ior', 'a', 'b'), 0) */
   /* search698_0_0 -> 21 in the cache */
   /* search698_0_1 -> 847 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 21, 847 },
      -1,
   } },
   /* search698_1_0 -> 41 in the cache */
   /* search698_1_1 -> 847 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 41, 847 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2122, 2123 },
      -1,
   } },

   /* replace698_0_0 -> 21 in the cache */
   /* replace698_0_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ior,
      1, 1,
      { 21, 41 },
      -1,
   } },
   /* replace698_1 -> 847 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2125, 847 },
      -1,
   } },

   /* ('ior', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('ior', 'a', 'b'), 0) */
   /* search699_0_0 -> 21 in the cache */
   /* search699_0_1 -> 847 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      1, 1,
      { 21, 847 },
      -1,
   } },
   /* search699_1_0 -> 41 in the cache */
   /* search699_1_1 -> 847 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      2, 1,
      { 41, 847 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2127, 2128 },
      -1,
   } },

   /* replace699_0_0 -> 21 in the cache */
   /* replace699_0_1 -> 41 in the cache */
   /* replace699_0 -> 2125 in the cache */
   /* replace699_1 -> 847 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2125, 847 },
      -1,
   } },

   /* ('iand', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('umax', 'a', 'b'), 0) */
   /* search700_0_0 -> 21 in the cache */
   /* search700_0_1 -> 847 in the cache */
   /* search700_0 -> 2122 in the cache */
   /* search700_1_0 -> 41 in the cache */
   /* search700_1_1 -> 847 in the cache */
   /* search700_1 -> 2123 in the cache */
   /* search700 -> 2124 in the cache */

   /* replace700_0_0 -> 21 in the cache */
   /* replace700_0_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_umax,
      1, 1,
      { 21, 41 },
      -1,
   } },
   /* replace700_1 -> 847 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2131, 847 },
      -1,
   } },

   /* ('ior', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('umin', 'a', 'b'), 0) */
   /* search701_0_0 -> 21 in the cache */
   /* search701_0_1 -> 847 in the cache */
   /* search701_0 -> 2122 in the cache */
   /* search701_1_0 -> 41 in the cache */
   /* search701_1_1 -> 847 in the cache */
   /* search701_1 -> 2123 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2122, 2123 },
      -1,
   } },

   /* replace701_0_0 -> 21 in the cache */
   /* replace701_0_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_umin,
      1, 1,
      { 21, 41 },
      -1,
   } },
   /* replace701_1 -> 847 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 2,
      { 2134, 847 },
      -1,
   } },

   /* ('iand', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('umin', 'a', 'b'), 0) */
   /* search702_0_0 -> 21 in the cache */
   /* search702_0_1 -> 847 in the cache */
   /* search702_0 -> 2127 in the cache */
   /* search702_1_0 -> 41 in the cache */
   /* search702_1_1 -> 847 in the cache */
   /* search702_1 -> 2128 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2127, 2128 },
      -1,
   } },

   /* replace702_0_0 -> 21 in the cache */
   /* replace702_0_1 -> 41 in the cache */
   /* replace702_0 -> 2134 in the cache */
   /* replace702_1 -> 847 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2134, 847 },
      -1,
   } },

   /* ('ior', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('umax', 'a', 'b'), 0) */
   /* search703_0_0 -> 21 in the cache */
   /* search703_0_1 -> 847 in the cache */
   /* search703_0 -> 2127 in the cache */
   /* search703_1_0 -> 41 in the cache */
   /* search703_1_1 -> 847 in the cache */
   /* search703_1 -> 2128 in the cache */
   /* search703 -> 2129 in the cache */

   /* replace703_0_0 -> 21 in the cache */
   /* replace703_0_1 -> 41 in the cache */
   /* replace703_0 -> 2131 in the cache */
   /* replace703_1 -> 847 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 2,
      { 2131, 847 },
      -1,
   } },

   /* ('ineg', ('b2i64', 'a@64')) => a */
   /* search704_0_0 -> 21 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_b2i64,
      -1, 0,
      { 21 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2139 },
      -1,
   } },

   /* replace704 -> 21 in the cache */

   /* ('ishl', 'a@64', ('iand', 63, 'b')) => ('ishl', 'a', 'b') */
   /* search705_0 -> 21 in the cache */
   /* search705_1_0 -> 24 in the cache */
   /* search705_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 24, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 21, 2141 },
      -1,
   } },

   /* replace705_0 -> 21 in the cache */
   /* replace705_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 21, 36 },
      -1,
   } },

   /* ('ishr', 'a@64', ('iand', 63, 'b')) => ('ishr', 'a', 'b') */
   /* search706_0 -> 21 in the cache */
   /* search706_1_0 -> 24 in the cache */
   /* search706_1_1 -> 36 in the cache */
   /* search706_1 -> 2141 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 1,
      { 21, 2141 },
      -1,
   } },

   /* replace706_0 -> 21 in the cache */
   /* replace706_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 21, 36 },
      -1,
   } },

   /* ('ushr', 'a@64', ('iand', 63, 'b')) => ('ushr', 'a', 'b') */
   /* search707_0 -> 21 in the cache */
   /* search707_1_0 -> 24 in the cache */
   /* search707_1_1 -> 36 in the cache */
   /* search707_1 -> 2141 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 21, 2141 },
      -1,
   } },

   /* replace707_0 -> 21 in the cache */
   /* replace707_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 21, 36 },
      -1,
   } },

   /* ('ior', ('ieq', 'a', 0), ('ieq', 'a', 1)) => ('uge', 1, 'a') */
   /* search708_0_0 -> 32 in the cache */
   /* search708_0_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 32, 61 },
      -1,
   } },
   /* search708_1_0 -> 32 in the cache */
   /* search708_1_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 32, 35 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 3,
      { 2148, 2149 },
      -1,
   } },

   /* replace708_0 -> 35 in the cache */
   /* replace708_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 35, 32 },
      -1,
   } },

   /* ('ior', ('uge', 1, 'a'), ('ieq', 'a', 2)) => ('uge', 2, 'a') */
   /* search709_0_0 -> 35 in the cache */
   /* search709_0_1 -> 32 in the cache */
   /* search709_0 -> 2151 in the cache */
   /* search709_1_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x2 /* 2 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 32, 2152 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 2151, 2153 },
      -1,
   } },

   /* replace709_0 -> 2152 in the cache */
   /* replace709_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 2152, 32 },
      -1,
   } },

   /* ('ior', ('uge', 2, 'a'), ('ieq', 'a', 3)) => ('uge', 3, 'a') */
   /* search710_0_0 -> 2152 in the cache */
   /* search710_0_1 -> 32 in the cache */
   /* search710_0 -> 2155 in the cache */
   /* search710_1_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x3 /* 3 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 32, 2156 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 2155, 2157 },
      -1,
   } },

   /* replace710_0 -> 2156 in the cache */
   /* replace710_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 2156, 32 },
      -1,
   } },

   /* ('ior', 'a', ('ieq', 'a', False)) => True */
   /* search711_0 -> 706 in the cache */
   /* search711_1_0 -> 706 in the cache */
   /* search711_1_1 -> 1024 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 706, 1024 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 706, 2160 },
      -1,
   } },

   /* replace711 -> 1177 in the cache */

   /* ('ior', 'a', ('inot', 'a')) => -1 */
   /* search712_0 -> 32 in the cache */
   /* search712_1_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 32, 2162 },
      -1,
   } },

   /* replace712 -> 63 in the cache */

   /* ('ine', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ine', 'a', 'b') */
   /* search713_0_0_0 -> 706 in the cache */
   /* search713_0_0 -> 1168 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 1168 },
      -1,
   } },
   /* search713_1_0_0 -> 1075 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 0,
      { 1075 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2165 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 2164, 2166 },
      -1,
   } },

   /* replace713_0 -> 706 in the cache */
   /* replace713_1 -> 1075 in the cache */
   /* replace713 -> 1320 in the cache */

   /* ('b2i', ('ine', 'a@1', 'b@1')) => ('b2i', ('ixor', 'a', 'b')) */
   /* search714_0_0 -> 706 in the cache */
   /* search714_0_1 -> 1075 in the cache */
   /* search714_0 -> 1320 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 1,
      { 1320 },
      -1,
   } },

   /* replace714_0_0 -> 706 in the cache */
   /* replace714_0_1 -> 1075 in the cache */
   /* replace714_0 -> 1092 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 1,
      { 1092 },
      -1,
   } },

   /* ('iand', ('inot', ('iand', ('ior', ('ieq', 'a', 0), 'b'), 'c')), ('ilt', 'a', 0)) => ('iand', ('inot', ('iand', 'b', 'c')), ('ilt', 'a', 0)) */
   /* search715_0_0_0_0_0 -> 32 in the cache */
   /* search715_0_0_0_0_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      3, 1,
      { 32, 61 },
      -1,
   } },
   /* search715_0_0_0_1 -> 1075 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      2, 2,
      { 2170, 1075 },
      -1,
   } },
   /* search715_0_0_1 -> 445 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      1, 3,
      { 2171, 445 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 3,
      { 2172 },
      -1,
   } },
   /* search715_1_0 -> 32 in the cache */
   /* search715_1_1 -> 61 in the cache */
   /* search715_1 -> 1191 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 4,
      { 2173, 1191 },
      -1,
   } },

   /* replace715_0_0_0 -> 1075 in the cache */
   /* replace715_0_0_1 -> 445 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 1075, 445 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 2175 },
      -1,
   } },
   /* replace715_1_0 -> 32 in the cache */
   /* replace715_1_1 -> 61 in the cache */
   /* replace715_1 -> 1191 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 2176, 1191 },
      -1,
   } },

   /* ('iand', ('inot', ('iand', ('ieq', ('umin', 'a', 'b'), 0), 'c')), ('ilt', 'a', 0)) => ('iand', ('inot', ('iand', ('ieq', 'b', 0), 'c')), ('ilt', 'a', 0)) */
   /* search716_0_0_0_0_0 -> 0 in the cache */
   /* search716_0_0_0_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_umin,
      3, 1,
      { 0, 3 },
      -1,
   } },
   /* search716_0_0_0_1 -> 86 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 2,
      { 2178, 86 },
      -1,
   } },
   /* search716_0_0_1 -> 445 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      1, 3,
      { 2179, 445 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 3,
      { 2180 },
      -1,
   } },
   /* search716_1_0 -> 0 in the cache */
   /* search716_1_1 -> 86 in the cache */
   /* search716_1 -> 90 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 4,
      { 2181, 90 },
      -1,
   } },

   /* replace716_0_0_0_0 -> 3 in the cache */
   /* replace716_0_0_0_1 -> 86 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 3, 86 },
      -1,
   } },
   /* replace716_0_0_1 -> 445 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      1, 2,
      { 2183, 445 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 2,
      { 2184 },
      -1,
   } },
   /* replace716_1_0 -> 0 in the cache */
   /* replace716_1_1 -> 86 in the cache */
   /* replace716_1 -> 90 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 3,
      { 2185, 90 },
      -1,
   } },

   /* ('flt', 'a', ('fmax', 'b', 'a')) => ('flt', 'a', 'b') */
   /* search717_0 -> 32 in the cache */
   { .variable = {
      { nir_search_value_variable, -1 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search717_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 2187, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 32, 2188 },
      -1,
   } },

   /* replace717_0 -> 32 in the cache */
   /* replace717_1 -> 2187 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 32, 2187 },
      -1,
   } },

   /* ('flt', ('fmin', 'a', 'b'), 'a') => ('flt', 'b', 'a') */
   /* search718_0_0 -> 0 in the cache */
   /* search718_0_1 -> 3 in the cache */
   /* search718_0 -> 1225 in the cache */
   /* search718_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1225, 0 },
      -1,
   } },

   /* replace718_0 -> 3 in the cache */
   /* replace718_1 -> 0 in the cache */
   /* replace718 -> 1025 in the cache */

   /* ('~fge', 'a', ('fmin', 'b', 'a')) => True */
   /* search719_0 -> 32 in the cache */
   /* search719_1_0 -> 2187 in the cache */
   /* search719_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmin,
      0, 1,
      { 2187, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 32, 2192 },
      -1,
   } },

   /* replace719 -> 1177 in the cache */

   /* ('~fge', ('fmax', 'a', 'b'), 'a') => True */
   /* search720_0_0 -> 0 in the cache */
   /* search720_0_1 -> 3 in the cache */
   /* search720_0 -> 1223 in the cache */
   /* search720_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1223, 0 },
      -1,
   } },

   /* replace720 -> 1177 in the cache */

   /* ('flt', 'a', ('fmin', 'b', 'a')) => False */
   /* search721_0 -> 32 in the cache */
   /* search721_1_0 -> 2187 in the cache */
   /* search721_1_1 -> 32 in the cache */
   /* search721_1 -> 2192 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 32, 2192 },
      -1,
   } },

   /* replace721 -> 1024 in the cache */

   /* ('flt', ('fmax', 'a', 'b'), 'a') => False */
   /* search722_0_0 -> 0 in the cache */
   /* search722_0_1 -> 3 in the cache */
   /* search722_0 -> 1223 in the cache */
   /* search722_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 1,
      { 1223, 0 },
      -1,
   } },

   /* replace722 -> 1024 in the cache */

   /* ('~fge', 'a', ('fmax', 'b', 'a')) => ('fge', 'a', 'b') */
   /* search723_0 -> 32 in the cache */
   /* search723_1_0 -> 2187 in the cache */
   /* search723_1_1 -> 32 in the cache */
   /* search723_1 -> 2188 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 32, 2188 },
      -1,
   } },

   /* replace723_0 -> 32 in the cache */
   /* replace723_1 -> 2187 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 32, 2187 },
      -1,
   } },

   /* ('~fge', ('fmin', 'a', 'b'), 'a') => ('fge', 'b', 'a') */
   /* search724_0_0 -> 0 in the cache */
   /* search724_0_1 -> 3 in the cache */
   /* search724_0 -> 1225 in the cache */
   /* search724_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      nir_op_fge,
      -1, 1,
      { 1225, 0 },
      -1,
   } },

   /* replace724_0 -> 3 in the cache */
   /* replace724_1 -> 0 in the cache */
   /* replace724 -> 1037 in the cache */

   /* ('ilt', 'a', ('imax', 'b', 'a')) => ('ilt', 'a', 'b') */
   /* search725_0 -> 32 in the cache */
   /* search725_1_0 -> 2187 in the cache */
   /* search725_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 2187, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 32, 2200 },
      -1,
   } },

   /* replace725_0 -> 32 in the cache */
   /* replace725_1 -> 2187 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 32, 2187 },
      -1,
   } },

   /* ('ilt', ('imin', 'a', 'b'), 'a') => ('ilt', 'b', 'a') */
   /* search726_0_0 -> 0 in the cache */
   /* search726_0_1 -> 3 in the cache */
   /* search726_0 -> 1285 in the cache */
   /* search726_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 1285, 0 },
      -1,
   } },

   /* replace726_0 -> 3 in the cache */
   /* replace726_1 -> 0 in the cache */
   /* replace726 -> 1030 in the cache */

   /* ('ige', 'a', ('imin', 'b', 'a')) => True */
   /* search727_0 -> 32 in the cache */
   /* search727_1_0 -> 2187 in the cache */
   /* search727_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 2187, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 32, 2204 },
      -1,
   } },

   /* replace727 -> 1177 in the cache */

   /* ('ige', ('imax', 'a', 'b'), 'a') => True */
   /* search728_0_0 -> 0 in the cache */
   /* search728_0_1 -> 3 in the cache */
   /* search728_0 -> 1277 in the cache */
   /* search728_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 1277, 0 },
      -1,
   } },

   /* replace728 -> 1177 in the cache */

   /* ('ult', 'a', ('umax', 'b', 'a')) => ('ult', 'a', 'b') */
   /* search729_0 -> 32 in the cache */
   /* search729_1_0 -> 2187 in the cache */
   /* search729_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 2187, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 32, 2207 },
      -1,
   } },

   /* replace729_0 -> 32 in the cache */
   /* replace729_1 -> 2187 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 32, 2187 },
      -1,
   } },

   /* ('ult', ('umin', 'a', 'b'), 'a') => ('ult', 'b', 'a') */
   /* search730_0_0 -> 0 in the cache */
   /* search730_0_1 -> 3 in the cache */
   /* search730_0 -> 1282 in the cache */
   /* search730_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 1282, 0 },
      -1,
   } },

   /* replace730_0 -> 3 in the cache */
   /* replace730_1 -> 0 in the cache */
   /* replace730 -> 1032 in the cache */

   /* ('uge', 'a', ('umin', 'b', 'a')) => True */
   /* search731_0 -> 32 in the cache */
   /* search731_1_0 -> 2187 in the cache */
   /* search731_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 2187, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 32, 2211 },
      -1,
   } },

   /* replace731 -> 1177 in the cache */

   /* ('uge', ('umax', 'a', 'b'), 'a') => True */
   /* search732_0_0 -> 0 in the cache */
   /* search732_0_1 -> 3 in the cache */
   /* search732_0 -> 1274 in the cache */
   /* search732_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 1274, 0 },
      -1,
   } },

   /* replace732 -> 1177 in the cache */

   /* ('ilt', 'a', ('imin', 'b', 'a')) => False */
   /* search733_0 -> 32 in the cache */
   /* search733_1_0 -> 2187 in the cache */
   /* search733_1_1 -> 32 in the cache */
   /* search733_1 -> 2204 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 32, 2204 },
      -1,
   } },

   /* replace733 -> 1024 in the cache */

   /* ('ilt', ('imax', 'a', 'b'), 'a') => False */
   /* search734_0_0 -> 0 in the cache */
   /* search734_0_1 -> 3 in the cache */
   /* search734_0 -> 1277 in the cache */
   /* search734_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 1277, 0 },
      -1,
   } },

   /* replace734 -> 1024 in the cache */

   /* ('ige', 'a', ('imax', 'b', 'a')) => ('ige', 'a', 'b') */
   /* search735_0 -> 32 in the cache */
   /* search735_1_0 -> 2187 in the cache */
   /* search735_1_1 -> 32 in the cache */
   /* search735_1 -> 2200 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 32, 2200 },
      -1,
   } },

   /* replace735_0 -> 32 in the cache */
   /* replace735_1 -> 2187 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 32, 2187 },
      -1,
   } },

   /* ('ige', ('imin', 'a', 'b'), 'a') => ('ige', 'b', 'a') */
   /* search736_0_0 -> 0 in the cache */
   /* search736_0_1 -> 3 in the cache */
   /* search736_0 -> 1285 in the cache */
   /* search736_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 1285, 0 },
      -1,
   } },

   /* replace736_0 -> 3 in the cache */
   /* replace736_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 3, 0 },
      -1,
   } },

   /* ('ult', 'a', ('umin', 'b', 'a')) => False */
   /* search737_0 -> 32 in the cache */
   /* search737_1_0 -> 2187 in the cache */
   /* search737_1_1 -> 32 in the cache */
   /* search737_1 -> 2211 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 32, 2211 },
      -1,
   } },

   /* replace737 -> 1024 in the cache */

   /* ('ult', ('umax', 'a', 'b'), 'a') => False */
   /* search738_0_0 -> 0 in the cache */
   /* search738_0_1 -> 3 in the cache */
   /* search738_0 -> 1274 in the cache */
   /* search738_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 1274, 0 },
      -1,
   } },

   /* replace738 -> 1024 in the cache */

   /* ('uge', 'a', ('umax', 'b', 'a')) => ('uge', 'a', 'b') */
   /* search739_0 -> 32 in the cache */
   /* search739_1_0 -> 2187 in the cache */
   /* search739_1_1 -> 32 in the cache */
   /* search739_1 -> 2207 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 32, 2207 },
      -1,
   } },

   /* replace739_0 -> 32 in the cache */
   /* replace739_1 -> 2187 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 32, 2187 },
      -1,
   } },

   /* ('uge', ('umin', 'a', 'b'), 'a') => ('uge', 'b', 'a') */
   /* search740_0_0 -> 0 in the cache */
   /* search740_0_1 -> 3 in the cache */
   /* search740_0 -> 1282 in the cache */
   /* search740_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 1282, 0 },
      -1,
   } },

   /* replace740_0 -> 3 in the cache */
   /* replace740_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 3, 0 },
      -1,
   } },

   /* ('ult', 'a', ('iand', 'b', 'a')) => False */
   /* search741_0 -> 32 in the cache */
   /* search741_1_0 -> 2187 in the cache */
   /* search741_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2187, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 32, 2226 },
      -1,
   } },

   /* replace741 -> 1024 in the cache */

   /* ('ult', ('ior', 'a', 'b'), 'a') => False */
   /* search742_0_0 -> 0 in the cache */
   /* search742_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 0, 3 },
      -1,
   } },
   /* search742_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 2228, 0 },
      -1,
   } },

   /* replace742 -> 1024 in the cache */

   /* ('uge', 'a', ('iand', 'b', 'a')) => True */
   /* search743_0 -> 32 in the cache */
   /* search743_1_0 -> 2187 in the cache */
   /* search743_1_1 -> 32 in the cache */
   /* search743_1 -> 2226 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 32, 2226 },
      -1,
   } },

   /* replace743 -> 1177 in the cache */

   /* ('uge', ('ior', 'a', 'b'), 'a') => True */
   /* search744_0_0 -> 0 in the cache */
   /* search744_0_1 -> 3 in the cache */
   /* search744_0 -> 2228 in the cache */
   /* search744_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 2228, 0 },
      -1,
   } },

   /* replace744 -> 1177 in the cache */

   /* ('ilt', '#a', ('imax', '#b', 'c')) => ('ior', ('ilt', 'a', 'b'), ('ilt', 'a', 'c')) */
   /* search745_0 -> 267 in the cache */
   /* search745_1_0 -> 268 in the cache */
   /* search745_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 268, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 267, 2232 },
      -1,
   } },

   /* replace745_0_0 -> 124 in the cache */
   /* replace745_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 124, 125 },
      -1,
   } },
   /* replace745_1_0 -> 124 in the cache */
   /* replace745_1_1 -> 127 in the cache */
   /* replace745_1 -> 1586 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2234, 1586 },
      -1,
   } },

   /* ('ilt', ('imin', '#a', 'b'), '#c') => ('ior', ('ilt', 'a', 'c'), ('ilt', 'b', 'c')) */
   /* search746_0_0 -> 267 in the cache */
   /* search746_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 267, 125 },
      -1,
   } },
   /* search746_1 -> 760 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 2236, 760 },
      -1,
   } },

   /* replace746_0_0 -> 124 in the cache */
   /* replace746_0_1 -> 127 in the cache */
   /* replace746_0 -> 1586 in the cache */
   /* replace746_1_0 -> 125 in the cache */
   /* replace746_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 125, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1586, 2238 },
      -1,
   } },

   /* ('ige', '#a', ('imin', '#b', 'c')) => ('ior', ('ige', 'a', 'b'), ('ige', 'a', 'c')) */
   /* search747_0 -> 267 in the cache */
   /* search747_1_0 -> 268 in the cache */
   /* search747_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 268, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 267, 2240 },
      -1,
   } },

   /* replace747_0_0 -> 124 in the cache */
   /* replace747_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 124, 125 },
      -1,
   } },
   /* replace747_1_0 -> 124 in the cache */
   /* replace747_1_1 -> 127 in the cache */
   /* replace747_1 -> 1596 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2242, 1596 },
      -1,
   } },

   /* ('ige', ('imax', '#a', 'b'), '#c') => ('ior', ('ige', 'a', 'c'), ('ige', 'b', 'c')) */
   /* search748_0_0 -> 267 in the cache */
   /* search748_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 267, 125 },
      -1,
   } },
   /* search748_1 -> 760 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 2244, 760 },
      -1,
   } },

   /* replace748_0_0 -> 124 in the cache */
   /* replace748_0_1 -> 127 in the cache */
   /* replace748_0 -> 1596 in the cache */
   /* replace748_1_0 -> 125 in the cache */
   /* replace748_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 125, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1596, 2246 },
      -1,
   } },

   /* ('ult', '#a', ('umax', '#b', 'c')) => ('ior', ('ult', 'a', 'b'), ('ult', 'a', 'c')) */
   /* search749_0 -> 267 in the cache */
   /* search749_1_0 -> 268 in the cache */
   /* search749_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 268, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 267, 2248 },
      -1,
   } },

   /* replace749_0_0 -> 124 in the cache */
   /* replace749_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 124, 125 },
      -1,
   } },
   /* replace749_1_0 -> 124 in the cache */
   /* replace749_1_1 -> 127 in the cache */
   /* replace749_1 -> 1606 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2250, 1606 },
      -1,
   } },

   /* ('ult', ('umin', '#a', 'b'), '#c') => ('ior', ('ult', 'a', 'c'), ('ult', 'b', 'c')) */
   /* search750_0_0 -> 267 in the cache */
   /* search750_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 267, 125 },
      -1,
   } },
   /* search750_1 -> 760 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 2252, 760 },
      -1,
   } },

   /* replace750_0_0 -> 124 in the cache */
   /* replace750_0_1 -> 127 in the cache */
   /* replace750_0 -> 1606 in the cache */
   /* replace750_1_0 -> 125 in the cache */
   /* replace750_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 125, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1606, 2254 },
      -1,
   } },

   /* ('uge', '#a', ('umin', '#b', 'c')) => ('ior', ('uge', 'a', 'b'), ('uge', 'a', 'c')) */
   /* search751_0 -> 267 in the cache */
   /* search751_1_0 -> 268 in the cache */
   /* search751_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 268, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 267, 2256 },
      -1,
   } },

   /* replace751_0_0 -> 124 in the cache */
   /* replace751_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 124, 125 },
      -1,
   } },
   /* replace751_1_0 -> 124 in the cache */
   /* replace751_1_1 -> 127 in the cache */
   /* replace751_1 -> 1616 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2258, 1616 },
      -1,
   } },

   /* ('uge', ('umax', '#a', 'b'), '#c') => ('ior', ('uge', 'a', 'c'), ('uge', 'b', 'c')) */
   /* search752_0_0 -> 267 in the cache */
   /* search752_0_1 -> 125 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 267, 125 },
      -1,
   } },
   /* search752_1 -> 760 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 2260, 760 },
      -1,
   } },

   /* replace752_0_0 -> 124 in the cache */
   /* replace752_0_1 -> 127 in the cache */
   /* replace752_0 -> 1616 in the cache */
   /* replace752_1_0 -> 125 in the cache */
   /* replace752_1_1 -> 127 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 125, 127 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1616, 2262 },
      -1,
   } },

   /* ('ilt', '#a', ('imin', '#b', 'c')) => ('iand', ('ilt', 'a', 'b'), ('ilt', 'a', 'c')) */
   /* search753_0 -> 267 in the cache */
   /* search753_1_0 -> 268 in the cache */
   /* search753_1_1 -> 127 in the cache */
   /* search753_1 -> 2240 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 267, 2240 },
      -1,
   } },

   /* replace753_0_0 -> 124 in the cache */
   /* replace753_0_1 -> 125 in the cache */
   /* replace753_0 -> 2234 in the cache */
   /* replace753_1_0 -> 124 in the cache */
   /* replace753_1_1 -> 127 in the cache */
   /* replace753_1 -> 1586 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2234, 1586 },
      -1,
   } },

   /* ('ilt', ('imax', '#a', 'b'), '#c') => ('iand', ('ilt', 'a', 'c'), ('ilt', 'b', 'c')) */
   /* search754_0_0 -> 267 in the cache */
   /* search754_0_1 -> 125 in the cache */
   /* search754_0 -> 2244 in the cache */
   /* search754_1 -> 760 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 1,
      { 2244, 760 },
      -1,
   } },

   /* replace754_0_0 -> 124 in the cache */
   /* replace754_0_1 -> 127 in the cache */
   /* replace754_0 -> 1586 in the cache */
   /* replace754_1_0 -> 125 in the cache */
   /* replace754_1_1 -> 127 in the cache */
   /* replace754_1 -> 2238 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1586, 2238 },
      -1,
   } },

   /* ('ige', '#a', ('imax', '#b', 'c')) => ('iand', ('ige', 'a', 'b'), ('ige', 'a', 'c')) */
   /* search755_0 -> 267 in the cache */
   /* search755_1_0 -> 268 in the cache */
   /* search755_1_1 -> 127 in the cache */
   /* search755_1 -> 2232 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 267, 2232 },
      -1,
   } },

   /* replace755_0_0 -> 124 in the cache */
   /* replace755_0_1 -> 125 in the cache */
   /* replace755_0 -> 2242 in the cache */
   /* replace755_1_0 -> 124 in the cache */
   /* replace755_1_1 -> 127 in the cache */
   /* replace755_1 -> 1596 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2242, 1596 },
      -1,
   } },

   /* ('ige', ('imin', '#a', 'b'), '#c') => ('iand', ('ige', 'a', 'c'), ('ige', 'b', 'c')) */
   /* search756_0_0 -> 267 in the cache */
   /* search756_0_1 -> 125 in the cache */
   /* search756_0 -> 2236 in the cache */
   /* search756_1 -> 760 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 1,
      { 2236, 760 },
      -1,
   } },

   /* replace756_0_0 -> 124 in the cache */
   /* replace756_0_1 -> 127 in the cache */
   /* replace756_0 -> 1596 in the cache */
   /* replace756_1_0 -> 125 in the cache */
   /* replace756_1_1 -> 127 in the cache */
   /* replace756_1 -> 2246 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1596, 2246 },
      -1,
   } },

   /* ('ult', '#a', ('umin', '#b', 'c')) => ('iand', ('ult', 'a', 'b'), ('ult', 'a', 'c')) */
   /* search757_0 -> 267 in the cache */
   /* search757_1_0 -> 268 in the cache */
   /* search757_1_1 -> 127 in the cache */
   /* search757_1 -> 2256 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 267, 2256 },
      -1,
   } },

   /* replace757_0_0 -> 124 in the cache */
   /* replace757_0_1 -> 125 in the cache */
   /* replace757_0 -> 2250 in the cache */
   /* replace757_1_0 -> 124 in the cache */
   /* replace757_1_1 -> 127 in the cache */
   /* replace757_1 -> 1606 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2250, 1606 },
      -1,
   } },

   /* ('ult', ('umax', '#a', 'b'), '#c') => ('iand', ('ult', 'a', 'c'), ('ult', 'b', 'c')) */
   /* search758_0_0 -> 267 in the cache */
   /* search758_0_1 -> 125 in the cache */
   /* search758_0 -> 2260 in the cache */
   /* search758_1 -> 760 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 1,
      { 2260, 760 },
      -1,
   } },

   /* replace758_0_0 -> 124 in the cache */
   /* replace758_0_1 -> 127 in the cache */
   /* replace758_0 -> 1606 in the cache */
   /* replace758_1_0 -> 125 in the cache */
   /* replace758_1_1 -> 127 in the cache */
   /* replace758_1 -> 2254 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1606, 2254 },
      -1,
   } },

   /* ('uge', '#a', ('umax', '#b', 'c')) => ('iand', ('uge', 'a', 'b'), ('uge', 'a', 'c')) */
   /* search759_0 -> 267 in the cache */
   /* search759_1_0 -> 268 in the cache */
   /* search759_1_1 -> 127 in the cache */
   /* search759_1 -> 2248 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 267, 2248 },
      -1,
   } },

   /* replace759_0_0 -> 124 in the cache */
   /* replace759_0_1 -> 125 in the cache */
   /* replace759_0 -> 2258 in the cache */
   /* replace759_1_0 -> 124 in the cache */
   /* replace759_1_1 -> 127 in the cache */
   /* replace759_1 -> 1616 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2258, 1616 },
      -1,
   } },

   /* ('uge', ('umin', '#a', 'b'), '#c') => ('iand', ('uge', 'a', 'c'), ('uge', 'b', 'c')) */
   /* search760_0_0 -> 267 in the cache */
   /* search760_0_1 -> 125 in the cache */
   /* search760_0 -> 2252 in the cache */
   /* search760_1 -> 760 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 1,
      { 2252, 760 },
      -1,
   } },

   /* replace760_0_0 -> 124 in the cache */
   /* replace760_0_1 -> 127 in the cache */
   /* replace760_0 -> 1616 in the cache */
   /* replace760_1_0 -> 125 in the cache */
   /* replace760_1_1 -> 127 in the cache */
   /* replace760_1 -> 2262 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1616, 2262 },
      -1,
   } },

   /* ('bcsel', ('ilt', 'a', 0), ('ineg', ('ishr', 'a', 'b')), ('ishr', 'a', 'b')) => ('iabs', ('ishr', 'a', 'b')) */
   /* search761_0_0 -> 32 in the cache */
   /* search761_0_1 -> 61 in the cache */
   /* search761_0 -> 1191 in the cache */
   /* search761_1_0_0 -> 32 in the cache */
   /* search761_1_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 32, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2280 },
      -1,
   } },
   /* search761_2_0 -> 32 in the cache */
   /* search761_2_1 -> 36 in the cache */
   /* search761_2 -> 2280 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1191, 2281, 2280 },
      -1,
   } },

   /* replace761_0_0 -> 32 in the cache */
   /* replace761_0_1 -> 36 in the cache */
   /* replace761_0 -> 2280 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 2280 },
      -1,
   } },

   /* ('iabs', ('ishr', ('iabs', 'a'), 'b')) => ('ishr', ('iabs', 'a'), 'b') */
   /* search762_0_0_0 -> 32 in the cache */
   /* search762_0_0 -> 106 in the cache */
   /* search762_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 106, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iabs,
      -1, 0,
      { 2284 },
      -1,
   } },

   /* replace762_0_0 -> 32 in the cache */
   /* replace762_0 -> 106 in the cache */
   /* replace762_1 -> 36 in the cache */
   /* replace762 -> 2284 in the cache */

   /* ('fabs', ('slt', 'a', 'b')) => ('slt', 'a', 'b') */
   /* search763_0_0 -> 0 in the cache */
   /* search763_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_slt,
      -1, 0,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 2286 },
      -1,
   } },

   /* replace763_0 -> 0 in the cache */
   /* replace763_1 -> 3 in the cache */
   /* replace763 -> 2286 in the cache */

   /* ('fabs', ('sge', 'a', 'b')) => ('sge', 'a', 'b') */
   /* search764_0_0 -> 0 in the cache */
   /* search764_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sge,
      -1, 0,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 2288 },
      -1,
   } },

   /* replace764_0 -> 0 in the cache */
   /* replace764_1 -> 3 in the cache */
   /* replace764 -> 2288 in the cache */

   /* ('fabs', ('seq', 'a', 'b')) => ('seq', 'a', 'b') */
   /* search765_0_0 -> 0 in the cache */
   /* search765_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 1,
      { 2290 },
      -1,
   } },

   /* replace765_0 -> 0 in the cache */
   /* replace765_1 -> 3 in the cache */
   /* replace765 -> 2290 in the cache */

   /* ('fabs', ('sne', 'a', 'b')) => ('sne', 'a', 'b') */
   /* search766_0_0 -> 0 in the cache */
   /* search766_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 1,
      { 0, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 1,
      { 2292 },
      -1,
   } },

   /* replace766_0 -> 0 in the cache */
   /* replace766_1 -> 3 in the cache */
   /* replace766 -> 2292 in the cache */

   /* ('slt', 'a', 'b') => ('b2f', ('flt', 'a', 'b')) */
   /* search767_0 -> 0 in the cache */
   /* search767_1 -> 3 in the cache */
   /* search767 -> 2286 in the cache */

   /* replace767_0_0 -> 0 in the cache */
   /* replace767_0_1 -> 3 in the cache */
   /* replace767_0 -> 996 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 996 },
      -1,
   } },

   /* ('sge', 'a', 'b') => ('b2f', ('fge', 'a', 'b')) */
   /* search768_0 -> 0 in the cache */
   /* search768_1 -> 3 in the cache */
   /* search768 -> 2288 in the cache */

   /* replace768_0_0 -> 0 in the cache */
   /* replace768_0_1 -> 3 in the cache */
   /* replace768_0 -> 993 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 993 },
      -1,
   } },

   /* ('seq', 'a', 'b') => ('b2f', ('feq', 'a', 'b')) */
   /* search769_0 -> 0 in the cache */
   /* search769_1 -> 3 in the cache */
   /* search769 -> 2290 in the cache */

   /* replace769_0_0 -> 0 in the cache */
   /* replace769_0_1 -> 3 in the cache */
   /* replace769_0 -> 1002 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 1,
      { 1002 },
      -1,
   } },

   /* ('sne', 'a', 'b') => ('b2f', ('fneu', 'a', 'b')) */
   /* search770_0 -> 0 in the cache */
   /* search770_1 -> 3 in the cache */
   /* search770 -> 2292 in the cache */

   /* replace770_0_0 -> 0 in the cache */
   /* replace770_0_1 -> 3 in the cache */
   /* replace770_0 -> 999 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 1,
      { 999 },
      -1,
   } },

   /* ('seq', ('seq', 'a', 'b'), 1.0) => ('seq', 'a', 'b') */
   /* search771_0_0 -> 0 in the cache */
   /* search771_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search771_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 2,
      { 2298, 255 },
      -1,
   } },

   /* replace771_0 -> 0 in the cache */
   /* replace771_1 -> 3 in the cache */
   /* replace771 -> 2290 in the cache */

   /* ('seq', ('sne', 'a', 'b'), 1.0) => ('sne', 'a', 'b') */
   /* search772_0_0 -> 0 in the cache */
   /* search772_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search772_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 2,
      { 2300, 255 },
      -1,
   } },

   /* replace772_0 -> 0 in the cache */
   /* replace772_1 -> 3 in the cache */
   /* replace772 -> 2292 in the cache */

   /* ('seq', ('slt', 'a', 'b'), 1.0) => ('slt', 'a', 'b') */
   /* search773_0_0 -> 0 in the cache */
   /* search773_0_1 -> 3 in the cache */
   /* search773_0 -> 2286 in the cache */
   /* search773_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 1,
      { 2286, 255 },
      -1,
   } },

   /* replace773_0 -> 0 in the cache */
   /* replace773_1 -> 3 in the cache */
   /* replace773 -> 2286 in the cache */

   /* ('seq', ('sge', 'a', 'b'), 1.0) => ('sge', 'a', 'b') */
   /* search774_0_0 -> 0 in the cache */
   /* search774_0_1 -> 3 in the cache */
   /* search774_0 -> 2288 in the cache */
   /* search774_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 1,
      { 2288, 255 },
      -1,
   } },

   /* replace774_0 -> 0 in the cache */
   /* replace774_1 -> 3 in the cache */
   /* replace774 -> 2288 in the cache */

   /* ('sne', ('seq', 'a', 'b'), 0.0) => ('seq', 'a', 'b') */
   /* search775_0_0 -> 0 in the cache */
   /* search775_0_1 -> 3 in the cache */
   /* search775_0 -> 2298 in the cache */
   /* search775_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 2,
      { 2298, 241 },
      -1,
   } },

   /* replace775_0 -> 0 in the cache */
   /* replace775_1 -> 3 in the cache */
   /* replace775 -> 2290 in the cache */

   /* ('sne', ('sne', 'a', 'b'), 0.0) => ('sne', 'a', 'b') */
   /* search776_0_0 -> 0 in the cache */
   /* search776_0_1 -> 3 in the cache */
   /* search776_0 -> 2300 in the cache */
   /* search776_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 2,
      { 2300, 241 },
      -1,
   } },

   /* replace776_0 -> 0 in the cache */
   /* replace776_1 -> 3 in the cache */
   /* replace776 -> 2292 in the cache */

   /* ('sne', ('slt', 'a', 'b'), 0.0) => ('slt', 'a', 'b') */
   /* search777_0_0 -> 0 in the cache */
   /* search777_0_1 -> 3 in the cache */
   /* search777_0 -> 2286 in the cache */
   /* search777_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 1,
      { 2286, 241 },
      -1,
   } },

   /* replace777_0 -> 0 in the cache */
   /* replace777_1 -> 3 in the cache */
   /* replace777 -> 2286 in the cache */

   /* ('sne', ('sge', 'a', 'b'), 0.0) => ('sge', 'a', 'b') */
   /* search778_0_0 -> 0 in the cache */
   /* search778_0_1 -> 3 in the cache */
   /* search778_0 -> 2288 in the cache */
   /* search778_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 1,
      { 2288, 241 },
      -1,
   } },

   /* replace778_0 -> 0 in the cache */
   /* replace778_1 -> 3 in the cache */
   /* replace778 -> 2288 in the cache */

   /* ('seq', ('seq', 'a', 'b'), 0.0) => ('sne', 'a', 'b') */
   /* search779_0_0 -> 0 in the cache */
   /* search779_0_1 -> 3 in the cache */
   /* search779_0 -> 2298 in the cache */
   /* search779_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 2,
      { 2298, 241 },
      -1,
   } },

   /* replace779_0 -> 0 in the cache */
   /* replace779_1 -> 3 in the cache */
   /* replace779 -> 2292 in the cache */

   /* ('seq', ('sne', 'a', 'b'), 0.0) => ('seq', 'a', 'b') */
   /* search780_0_0 -> 0 in the cache */
   /* search780_0_1 -> 3 in the cache */
   /* search780_0 -> 2300 in the cache */
   /* search780_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 2,
      { 2300, 241 },
      -1,
   } },

   /* replace780_0 -> 0 in the cache */
   /* replace780_1 -> 3 in the cache */
   /* replace780 -> 2290 in the cache */

   /* ('seq', ('slt', 'a', 'b'), 0.0) => ('sge', 'a', 'b') */
   /* search781_0_0 -> 0 in the cache */
   /* search781_0_1 -> 3 in the cache */
   /* search781_0 -> 2286 in the cache */
   /* search781_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 1,
      { 2286, 241 },
      -1,
   } },

   /* replace781_0 -> 0 in the cache */
   /* replace781_1 -> 3 in the cache */
   /* replace781 -> 2288 in the cache */

   /* ('seq', ('sge', 'a', 'b'), 0.0) => ('slt', 'a', 'b') */
   /* search782_0_0 -> 0 in the cache */
   /* search782_0_1 -> 3 in the cache */
   /* search782_0 -> 2288 in the cache */
   /* search782_1 -> 241 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_seq,
      0, 1,
      { 2288, 241 },
      -1,
   } },

   /* replace782_0 -> 0 in the cache */
   /* replace782_1 -> 3 in the cache */
   /* replace782 -> 2286 in the cache */

   /* ('sne', ('seq', 'a', 'b'), 1.0) => ('sne', 'a', 'b') */
   /* search783_0_0 -> 0 in the cache */
   /* search783_0_1 -> 3 in the cache */
   /* search783_0 -> 2298 in the cache */
   /* search783_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 2,
      { 2298, 255 },
      -1,
   } },

   /* replace783_0 -> 0 in the cache */
   /* replace783_1 -> 3 in the cache */
   /* replace783 -> 2292 in the cache */

   /* ('sne', ('sne', 'a', 'b'), 1.0) => ('seq', 'a', 'b') */
   /* search784_0_0 -> 0 in the cache */
   /* search784_0_1 -> 3 in the cache */
   /* search784_0 -> 2300 in the cache */
   /* search784_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 2,
      { 2300, 255 },
      -1,
   } },

   /* replace784_0 -> 0 in the cache */
   /* replace784_1 -> 3 in the cache */
   /* replace784 -> 2290 in the cache */

   /* ('sne', ('slt', 'a', 'b'), 1.0) => ('sge', 'a', 'b') */
   /* search785_0_0 -> 0 in the cache */
   /* search785_0_1 -> 3 in the cache */
   /* search785_0 -> 2286 in the cache */
   /* search785_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 1,
      { 2286, 255 },
      -1,
   } },

   /* replace785_0 -> 0 in the cache */
   /* replace785_1 -> 3 in the cache */
   /* replace785 -> 2288 in the cache */

   /* ('sne', ('sge', 'a', 'b'), 1.0) => ('slt', 'a', 'b') */
   /* search786_0_0 -> 0 in the cache */
   /* search786_0_1 -> 3 in the cache */
   /* search786_0 -> 2288 in the cache */
   /* search786_1 -> 255 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_sne,
      0, 1,
      { 2288, 255 },
      -1,
   } },

   /* replace786_0 -> 0 in the cache */
   /* replace786_1 -> 3 in the cache */
   /* replace786 -> 2286 in the cache */

   /* ('fall_equal2', 'a', 'b') => ('fmin', ('seq', 'a.x', 'b.x'), ('seq', 'a.y', 'b.y')) */
   /* search787_0 -> 16 in the cache */
   /* search787_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fall_equal2,
      0, 1,
      { 16, 36 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_seq,
      0, 1,
      { 2317, 2318 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {1},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {1},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_seq,
      1, 1,
      { 2320, 2321 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmin,
      -1, 2,
      { 2319, 2322 },
      -1,
   } },

   /* ('fall_equal3', 'a', 'b') => ('seq', ('fany_nequal3', 'a', 'b'), 0.0) */
   /* search788_0 -> 16 in the cache */
   /* search788_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fall_equal3,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace788_0_0 -> 16 in the cache */
   /* replace788_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fany_nequal3,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* replace788_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_seq,
      0, 2,
      { 2325, 117 },
      -1,
   } },

   /* ('fall_equal4', 'a', 'b') => ('seq', ('fany_nequal4', 'a', 'b'), 0.0) */
   /* search789_0 -> 16 in the cache */
   /* search789_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fall_equal4,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace789_0_0 -> 16 in the cache */
   /* replace789_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fany_nequal4,
      1, 1,
      { 16, 36 },
      -1,
   } },
   /* replace789_1 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_seq,
      0, 2,
      { 2328, 117 },
      -1,
   } },

   /* ('fany_nequal2', 'a', 'b') => ('fmax', ('sne', 'a.x', 'b.x'), ('sne', 'a.y', 'b.y')) */
   /* search790_0 -> 16 in the cache */
   /* search790_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fany_nequal2,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace790_0_0 -> 2317 in the cache */
   /* replace790_0_1 -> 2318 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sne,
      0, 1,
      { 2317, 2318 },
      -1,
   } },
   /* replace790_1_0 -> 2320 in the cache */
   /* replace790_1_1 -> 2321 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sne,
      1, 1,
      { 2320, 2321 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fmax,
      -1, 2,
      { 2331, 2332 },
      -1,
   } },

   /* ('fany_nequal3', 'a', 'b') => ('fsat', ('fdot3', ('sne', 'a', 'b'), ('sne', 'a', 'b'))) */
   /* search791_0 -> 16 in the cache */
   /* search791_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fany_nequal3,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace791_0_0_0 -> 16 in the cache */
   /* replace791_0_0_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sne,
      0, 1,
      { 16, 36 },
      -1,
   } },
   /* replace791_0_1_0 -> 16 in the cache */
   /* replace791_0_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_sne,
      1, 1,
      { 16, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fdot3,
      -1, 2,
      { 2335, 2336 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 2,
      { 2337 },
      -1,
   } },

   /* ('fany_nequal4', 'a', 'b') => ('fsat', ('fdot4', ('sne', 'a', 'b'), ('sne', 'a', 'b'))) */
   /* search792_0 -> 16 in the cache */
   /* search792_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fany_nequal4,
      0, 1,
      { 16, 36 },
      -1,
   } },

   /* replace792_0_0_0 -> 16 in the cache */
   /* replace792_0_0_1 -> 36 in the cache */
   /* replace792_0_0 -> 2335 in the cache */
   /* replace792_0_1_0 -> 16 in the cache */
   /* replace792_0_1_1 -> 36 in the cache */
   /* replace792_0_1 -> 2336 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fdot4,
      -1, 2,
      { 2335, 2336 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 2,
      { 2340 },
      -1,
   } },

   /* ('ball_iequal2', 'a', 'b') => ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y')) */
   /* search793_0 -> 0 in the cache */
   /* search793_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ball_iequal2,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace793_0_0 -> 715 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 715, 2343 },
      -1,
   } },
   /* replace793_1_0 -> 716 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {1},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 716, 2345 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 2,
      { 2344, 2346 },
      -1,
   } },

   /* ('ball_iequal3', 'a', 'b') => ('iand', ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y')), ('ieq', 'a.z', 'b.z')) */
   /* search794_0 -> 0 in the cache */
   /* search794_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ball_iequal3,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace794_0_0_0 -> 715 in the cache */
   /* replace794_0_0_1 -> 2343 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      1, 1,
      { 715, 2343 },
      -1,
   } },
   /* replace794_0_1_0 -> 716 in the cache */
   /* replace794_0_1_1 -> 2345 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 716, 2345 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 2,
      { 2349, 2350 },
      -1,
   } },
   /* replace794_1_0 -> 717 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {2},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      3, 1,
      { 717, 2352 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 4,
      { 2351, 2353 },
      -1,
   } },

   /* ('ball_iequal4', 'a', 'b') => ('iand', ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y')), ('iand', ('ieq', 'a.z', 'b.z'), ('ieq', 'a.w', 'b.w'))) */
   /* search795_0 -> 0 in the cache */
   /* search795_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ball_iequal4,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace795_0_0_0 -> 715 in the cache */
   /* replace795_0_0_1 -> 2343 in the cache */
   /* replace795_0_0 -> 2344 in the cache */
   /* replace795_0_1_0 -> 716 in the cache */
   /* replace795_0_1_1 -> 2345 in the cache */
   /* replace795_0_1 -> 2346 in the cache */
   /* replace795_0 -> 2347 in the cache */
   /* replace795_1_0_0 -> 717 in the cache */
   /* replace795_1_0_1 -> 2352 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      2, 1,
      { 717, 2352 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {3},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {3},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      3, 1,
      { 2357, 2358 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 2,
      { 2356, 2359 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 4,
      { 2347, 2360 },
      -1,
   } },

   /* ('bany_inequal2', 'a', 'b') => ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y')) */
   /* search796_0 -> 0 in the cache */
   /* search796_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bany_inequal2,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace796_0_0 -> 715 in the cache */
   /* replace796_0_1 -> 2343 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 715, 2343 },
      -1,
   } },
   /* replace796_1_0 -> 716 in the cache */
   /* replace796_1_1 -> 2345 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      1, 1,
      { 716, 2345 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 2,
      { 2363, 2364 },
      -1,
   } },

   /* ('bany_inequal3', 'a', 'b') => ('ior', ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y')), ('ine', 'a.z', 'b.z')) */
   /* search797_0 -> 0 in the cache */
   /* search797_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bany_inequal3,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace797_0_0_0 -> 715 in the cache */
   /* replace797_0_0_1 -> 2343 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      1, 1,
      { 715, 2343 },
      -1,
   } },
   /* replace797_0_1_0 -> 716 in the cache */
   /* replace797_0_1_1 -> 2345 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      2, 1,
      { 716, 2345 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 2,
      { 2367, 2368 },
      -1,
   } },
   /* replace797_1_0 -> 717 in the cache */
   /* replace797_1_1 -> 2352 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      3, 1,
      { 717, 2352 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 4,
      { 2369, 2370 },
      -1,
   } },

   /* ('bany_inequal4', 'a', 'b') => ('ior', ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y')), ('ior', ('ine', 'a.z', 'b.z'), ('ine', 'a.w', 'b.w'))) */
   /* search798_0 -> 0 in the cache */
   /* search798_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bany_inequal4,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace798_0_0_0 -> 715 in the cache */
   /* replace798_0_0_1 -> 2343 in the cache */
   /* replace798_0_0 -> 2363 in the cache */
   /* replace798_0_1_0 -> 716 in the cache */
   /* replace798_0_1_1 -> 2345 in the cache */
   /* replace798_0_1 -> 2364 in the cache */
   /* replace798_0 -> 2365 in the cache */
   /* replace798_1_0_0 -> 717 in the cache */
   /* replace798_1_0_1 -> 2352 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      2, 1,
      { 717, 2352 },
      -1,
   } },
   /* replace798_1_1_0 -> 2357 in the cache */
   /* replace798_1_1_1 -> 2358 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      3, 1,
      { 2357, 2358 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 2,
      { 2373, 2374 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 4,
      { 2365, 2375 },
      -1,
   } },

   /* ('ball_fequal2', 'a', 'b') => ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y')) */
   /* search799_0 -> 0 in the cache */
   /* search799_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ball_fequal2,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace799_0_0 -> 715 in the cache */
   /* replace799_0_1 -> 2343 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 715, 2343 },
      -1,
   } },
   /* replace799_1_0 -> 716 in the cache */
   /* replace799_1_1 -> 2345 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      1, 1,
      { 716, 2345 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 2,
      { 2378, 2379 },
      -1,
   } },

   /* ('ball_fequal3', 'a', 'b') => ('iand', ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y')), ('feq', 'a.z', 'b.z')) */
   /* search800_0 -> 0 in the cache */
   /* search800_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ball_fequal3,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace800_0_0_0 -> 715 in the cache */
   /* replace800_0_0_1 -> 2343 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      1, 1,
      { 715, 2343 },
      -1,
   } },
   /* replace800_0_1_0 -> 716 in the cache */
   /* replace800_0_1_1 -> 2345 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      2, 1,
      { 716, 2345 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 2,
      { 2382, 2383 },
      -1,
   } },
   /* replace800_1_0 -> 717 in the cache */
   /* replace800_1_1 -> 2352 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      3, 1,
      { 717, 2352 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 4,
      { 2384, 2385 },
      -1,
   } },

   /* ('ball_fequal4', 'a', 'b') => ('iand', ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y')), ('iand', ('feq', 'a.z', 'b.z'), ('feq', 'a.w', 'b.w'))) */
   /* search801_0 -> 0 in the cache */
   /* search801_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ball_fequal4,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace801_0_0_0 -> 715 in the cache */
   /* replace801_0_0_1 -> 2343 in the cache */
   /* replace801_0_0 -> 2378 in the cache */
   /* replace801_0_1_0 -> 716 in the cache */
   /* replace801_0_1_1 -> 2345 in the cache */
   /* replace801_0_1 -> 2379 in the cache */
   /* replace801_0 -> 2380 in the cache */
   /* replace801_1_0_0 -> 717 in the cache */
   /* replace801_1_0_1 -> 2352 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      2, 1,
      { 717, 2352 },
      -1,
   } },
   /* replace801_1_1_0 -> 2357 in the cache */
   /* replace801_1_1_1 -> 2358 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      3, 1,
      { 2357, 2358 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 2,
      { 2388, 2389 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 4,
      { 2380, 2390 },
      -1,
   } },

   /* ('bany_fnequal2', 'a', 'b') => ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y')) */
   /* search802_0 -> 0 in the cache */
   /* search802_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bany_fnequal2,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace802_0_0 -> 715 in the cache */
   /* replace802_0_1 -> 2343 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 715, 2343 },
      -1,
   } },
   /* replace802_1_0 -> 716 in the cache */
   /* replace802_1_1 -> 2345 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      1, 1,
      { 716, 2345 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 2,
      { 2393, 2394 },
      -1,
   } },

   /* ('bany_fnequal3', 'a', 'b') => ('ior', ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y')), ('fneu', 'a.z', 'b.z')) */
   /* search803_0 -> 0 in the cache */
   /* search803_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bany_fnequal3,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace803_0_0_0 -> 715 in the cache */
   /* replace803_0_0_1 -> 2343 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      1, 1,
      { 715, 2343 },
      -1,
   } },
   /* replace803_0_1_0 -> 716 in the cache */
   /* replace803_0_1_1 -> 2345 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      2, 1,
      { 716, 2345 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 2,
      { 2397, 2398 },
      -1,
   } },
   /* replace803_1_0 -> 717 in the cache */
   /* replace803_1_1 -> 2352 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      3, 1,
      { 717, 2352 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 4,
      { 2399, 2400 },
      -1,
   } },

   /* ('bany_fnequal4', 'a', 'b') => ('ior', ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y')), ('ior', ('fneu', 'a.z', 'b.z'), ('fneu', 'a.w', 'b.w'))) */
   /* search804_0 -> 0 in the cache */
   /* search804_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bany_fnequal4,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* replace804_0_0_0 -> 715 in the cache */
   /* replace804_0_0_1 -> 2343 in the cache */
   /* replace804_0_0 -> 2393 in the cache */
   /* replace804_0_1_0 -> 716 in the cache */
   /* replace804_0_1_1 -> 2345 in the cache */
   /* replace804_0_1 -> 2394 in the cache */
   /* replace804_0 -> 2395 in the cache */
   /* replace804_1_0_0 -> 717 in the cache */
   /* replace804_1_0_1 -> 2352 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      2, 1,
      { 717, 2352 },
      -1,
   } },
   /* replace804_1_1_0 -> 2357 in the cache */
   /* replace804_1_1_1 -> 2358 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      3, 1,
      { 2357, 2358 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 2,
      { 2403, 2404 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 4,
      { 2395, 2405 },
      -1,
   } },

   /* ('fneu', ('fneg', 'a'), 'a') => ('fneu', 'a', 0.0) */
   /* search805_0_0 -> 32 in the cache */
   /* search805_0 -> 98 in the cache */
   /* search805_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      0, 1,
      { 98, 32 },
      -1,
   } },

   /* replace805_0 -> 32 in the cache */
   /* replace805_1 -> 113 in the cache */
   /* replace805 -> 1195 in the cache */

   /* ('feq', ('fneg', 'a'), 'a') => ('feq', 'a', 0.0) */
   /* search806_0_0 -> 32 in the cache */
   /* search806_0 -> 98 in the cache */
   /* search806_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      0, 1,
      { 98, 32 },
      -1,
   } },

   /* replace806_0 -> 32 in the cache */
   /* replace806_1 -> 113 in the cache */
   /* replace806 -> 1199 in the cache */

   /* ('imul', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b')) */
   /* search807_0_0 -> 706 in the cache */
   /* search807_0 -> 1168 in the cache */
   /* search807_1_0 -> 1075 in the cache */
   /* search807_1 -> 2165 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_imul,
      0, 1,
      { 1168, 2165 },
      -1,
   } },

   /* replace807_0_0 -> 706 in the cache */
   /* replace807_0_1 -> 1075 in the cache */
   /* replace807_0 -> 1087 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 1,
      { 1087 },
      -1,
   } },

   /* ('iand', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b')) */
   /* search808_0_0 -> 706 in the cache */
   /* search808_0 -> 1168 in the cache */
   /* search808_1_0 -> 1075 in the cache */
   /* search808_1 -> 2165 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 1168, 2165 },
      -1,
   } },

   /* replace808_0_0 -> 706 in the cache */
   /* replace808_0_1 -> 1075 in the cache */
   /* replace808_0 -> 1087 in the cache */
   /* replace808 -> 2410 in the cache */

   /* ('ior', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('ior', 'a', 'b')) */
   /* search809_0_0 -> 706 in the cache */
   /* search809_0 -> 1168 in the cache */
   /* search809_1_0 -> 1075 in the cache */
   /* search809_1 -> 2165 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 1168, 2165 },
      -1,
   } },

   /* replace809_0_0 -> 706 in the cache */
   /* replace809_0_1 -> 1075 in the cache */
   /* replace809_0 -> 1079 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 1,
      { 1079 },
      -1,
   } },

   /* ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b')) */
   /* search810_0_0 -> 706 in the cache */
   /* search810_0 -> 1070 in the cache */
   /* search810_1_0 -> 1075 in the cache */
   /* search810_1 -> 1076 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 1070, 1076 },
      -1,
   } },

   /* replace810_0_0 -> 706 in the cache */
   /* replace810_0_1 -> 1075 in the cache */
   /* replace810_0 -> 1087 in the cache */
   /* replace810 -> 1208 in the cache */

   /* ('fsat', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('b2f', ('ior', 'a', 'b')) */
   /* search811_0_0_0 -> 706 in the cache */
   /* search811_0_0 -> 1070 in the cache */
   /* search811_0_1_0 -> 1075 in the cache */
   /* search811_0_1 -> 1076 in the cache */
   /* search811_0 -> 1106 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_fsat,
      -1, 1,
      { 1106 },
      -1,
   } },

   /* replace811_0_0 -> 706 in the cache */
   /* replace811_0_1 -> 1075 in the cache */
   /* replace811_0 -> 1079 in the cache */
   /* replace811 -> 1205 in the cache */

   /* ('iand', 'a@bool16', 1.0) => ('b2f', 'a') */
   { .variable = {
      { nir_search_value_variable, 16 },
      0, /* a */
      false,
      nir_type_bool,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search812_1 -> 462 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2416, 462 },
      -1,
   } },

   /* replace812_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('iand', 'a@bool32', 1.0) => ('b2f', 'a') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_bool,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search813_1 -> 228 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2419, 228 },
      -1,
   } },

   /* replace813_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('flt', ('fneg', ('b2f', 'a@1')), 0) => a */
   /* search814_0_0_0 -> 706 in the cache */
   /* search814_0_0 -> 1070 in the cache */
   /* search814_0 -> 1073 in the cache */
   /* search814_1 -> 1169 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 1073, 1169 },
      -1,
   } },

   /* replace814 -> 706 in the cache */

   /* ('ilt', 'a', 'a') => False */
   /* search815_0 -> 32 in the cache */
   /* search815_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace815 -> 1024 in the cache */

   /* ('ige', 'a', 'a') => True */
   /* search816_0 -> 32 in the cache */
   /* search816_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace816 -> 1177 in the cache */

   /* ('ieq', 'a', 'a') => True */
   /* search817_0 -> 32 in the cache */
   /* search817_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace817 -> 1177 in the cache */

   /* ('ine', 'a', 'a') => False */
   /* search818_0 -> 32 in the cache */
   /* search818_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace818 -> 1024 in the cache */

   /* ('ult', 'a', 'a') => False */
   /* search819_0 -> 32 in the cache */
   /* search819_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace819 -> 1024 in the cache */

   /* ('uge', 'a', 'a') => True */
   /* search820_0 -> 32 in the cache */
   /* search820_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_uge,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace820 -> 1177 in the cache */

   /* ('flt', 'a', 'a') => False */
   /* search821_0 -> 32 in the cache */
   /* search821_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_flt,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace821 -> 1024 in the cache */

   /* ('fge', 'a(is_a_number)', 'a') => True */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search822_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fge,
      -1, 0,
      { 2430, 32 },
      -1,
   } },

   /* replace822 -> 1177 in the cache */

   /* ('feq', 'a(is_a_number)', 'a') => True */
   /* search823_0 -> 2430 in the cache */
   /* search823_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_feq,
      -1, 0,
      { 2430, 32 },
      -1,
   } },

   /* replace823 -> 1177 in the cache */

   /* ('fneu', 'a(is_a_number)', 'a') => False */
   /* search824_0 -> 2430 in the cache */
   /* search824_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_fneu,
      -1, 0,
      { 2430, 32 },
      -1,
   } },

   /* replace824 -> 1024 in the cache */

   /* ('iand', 'a', 'a') => a */
   /* search825_0 -> 32 in the cache */
   /* search825_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iand,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace825 -> 32 in the cache */

   /* ('iand', 'a', -1) => a */
   /* search826_0 -> 32 in the cache */
   /* search826_1 -> 63 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 32, 63 },
      -1,
   } },

   /* replace826 -> 32 in the cache */

   /* ('iand', 'a', 0) => 0 */
   /* search827_0 -> 32 in the cache */
   /* search827_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace827 -> 61 in the cache */

   /* ('ior', 'a', 'a') => a */
   /* search828_0 -> 32 in the cache */
   /* search828_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ior,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace828 -> 32 in the cache */

   /* ('ior', 'a', 0) => a */
   /* search829_0 -> 32 in the cache */
   /* search829_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace829 -> 32 in the cache */

   /* ('ior', 'a', True) => True */
   /* search830_0 -> 706 in the cache */
   /* search830_1 -> 1177 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 706, 1177 },
      -1,
   } },

   /* replace830 -> 1177 in the cache */

   /* ('ixor', 'a', 'a') => 0 */
   /* search831_0 -> 32 in the cache */
   /* search831_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ixor,
      -1, 0,
      { 32, 32 },
      -1,
   } },

   /* replace831 -> 61 in the cache */

   /* ('ixor', 'a', 0) => a */
   /* search832_0 -> 32 in the cache */
   /* search832_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ixor,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* replace832 -> 32 in the cache */

   /* ('inot', ('inot', 'a')) => a */
   /* search833_0_0 -> 32 in the cache */
   /* search833_0 -> 2162 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 2162 },
      -1,
   } },

   /* replace833 -> 32 in the cache */

   /* ('ior', ('iand', 'a', 'b'), 'b') => b */
   /* search834_0_0 -> 0 in the cache */
   /* search834_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      1, 1,
      { 0, 3 },
      -1,
   } },
   /* search834_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 2443, 3 },
      -1,
   } },

   /* replace834 -> 3 in the cache */

   /* ('ior', ('ior', 'a', 'b'), 'b') => ('ior', 'a', 'b') */
   /* search835_0_0 -> 0 in the cache */
   /* search835_0_1 -> 3 in the cache */
   /* search835_0 -> 84 in the cache */
   /* search835_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 84, 3 },
      -1,
   } },

   /* replace835_0 -> 0 in the cache */
   /* replace835_1 -> 3 in the cache */
   /* replace835 -> 2228 in the cache */

   /* ('iand', ('ior', 'a', 'b'), 'b') => b */
   /* search836_0_0 -> 0 in the cache */
   /* search836_0_1 -> 3 in the cache */
   /* search836_0 -> 84 in the cache */
   /* search836_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 84, 3 },
      -1,
   } },

   /* replace836 -> 3 in the cache */

   /* ('iand', ('iand', 'a', 'b'), 'b') => ('iand', 'a', 'b') */
   /* search837_0_0 -> 0 in the cache */
   /* search837_0_1 -> 3 in the cache */
   /* search837_0 -> 2443 in the cache */
   /* search837_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 2,
      { 2443, 3 },
      -1,
   } },

   /* replace837_0 -> 0 in the cache */
   /* replace837_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 0, 3 },
      -1,
   } },

   /* ('iand', ('inot', 'a'), ('inot', 'b')) => ('inot', ('ior', 'a', 'b')) */
   /* search838_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 0 },
      -1,
   } },
   /* search838_1_0 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2449, 2450 },
      -1,
   } },

   /* replace838_0_0 -> 0 in the cache */
   /* replace838_0_1 -> 3 in the cache */
   /* replace838_0 -> 2228 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 2228 },
      -1,
   } },

   /* ('ior', ('inot', 'a'), ('inot', 'b')) => ('inot', ('iand', 'a', 'b')) */
   /* search839_0_0 -> 0 in the cache */
   /* search839_0 -> 2449 in the cache */
   /* search839_1_0 -> 3 in the cache */
   /* search839_1 -> 2450 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2449, 2450 },
      -1,
   } },

   /* replace839_0_0 -> 0 in the cache */
   /* replace839_0_1 -> 3 in the cache */
   /* replace839_0 -> 2448 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 1,
      { 2448 },
      -1,
   } },

   /* ('ishl', 0, 'a') => 0 */
   /* search840_0 -> 1169 in the cache */
   /* search840_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 1169, 16 },
      -1,
   } },

   /* replace840 -> 1169 in the cache */

   /* ('ishl', 'a', 0) => a */
   /* search841_0 -> 32 in the cache */
   /* search841_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 32, 120 },
      -1,
   } },

   /* replace841 -> 32 in the cache */

   /* ('ishr', 0, 'a') => 0 */
   /* search842_0 -> 1169 in the cache */
   /* search842_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 1169, 16 },
      -1,
   } },

   /* replace842 -> 1169 in the cache */

   /* ('ishr', 'a', 0) => a */
   /* search843_0 -> 32 in the cache */
   /* search843_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ishr,
      -1, 0,
      { 32, 120 },
      -1,
   } },

   /* replace843 -> 32 in the cache */

   /* ('ushr', 0, 'a') => 0 */
   /* search844_0 -> 1169 in the cache */
   /* search844_1 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 1169, 16 },
      -1,
   } },

   /* replace844 -> 1169 in the cache */

   /* ('ushr', 'a', 0) => a */
   /* search845_0 -> 32 in the cache */
   /* search845_1 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 32, 120 },
      -1,
   } },

   /* replace845 -> 32 in the cache */

   /* ('ior', ('ishl@16', 'a', 'b'), ('ushr@16', 'a', ('iadd', 16, ('ineg', 'b')))) => ('urol', 'a', 'b') */
   /* search846_0_0 -> 11 in the cache */
   /* search846_0_1 -> 36 in the cache */
   /* search846_0 -> 2092 in the cache */
   /* search846_1_0 -> 11 in the cache */
   /* search846_1_1_0 -> 801 in the cache */
   /* search846_1_1_1_0 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 801, 2461 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 11, 2462 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 2092, 2463 },
      -1,
   } },

   /* replace846_0 -> 11 in the cache */
   /* replace846_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_urol,
      -1, 0,
      { 11, 36 },
      -1,
   } },

   /* ('ior', ('ishl@16', 'a', 'b'), ('ushr@16', 'a', ('isub', 16, 'b'))) => ('urol', 'a', 'b') */
   /* search847_0_0 -> 11 in the cache */
   /* search847_0_1 -> 36 in the cache */
   /* search847_0 -> 2092 in the cache */
   /* search847_1_0 -> 11 in the cache */
   /* search847_1_1_0 -> 801 in the cache */
   /* search847_1_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_isub,
      -1, 0,
      { 801, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 11, 2466 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2092, 2467 },
      -1,
   } },

   /* replace847_0 -> 11 in the cache */
   /* replace847_1 -> 36 in the cache */
   /* replace847 -> 2465 in the cache */

   /* ('ior', ('ishl@32', 'a', 'b'), ('ushr@32', 'a', ('iadd', 32, ('ineg', 'b')))) => ('urol', 'a', 'b') */
   /* search848_0_0 -> 16 in the cache */
   /* search848_0_1 -> 36 in the cache */
   /* search848_0 -> 895 in the cache */
   /* search848_1_0 -> 16 in the cache */
   /* search848_1_1_0 -> 823 in the cache */
   /* search848_1_1_1_0 -> 36 in the cache */
   /* search848_1_1_1 -> 2461 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_iadd,
      1, 1,
      { 823, 2461 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 1,
      { 16, 2469 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 895, 2470 },
      -1,
   } },

   /* replace848_0 -> 16 in the cache */
   /* replace848_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_urol,
      -1, 0,
      { 16, 36 },
      -1,
   } },

   /* ('ior', ('ishl@32', 'a', 'b'), ('ushr@32', 'a', ('isub', 32, 'b'))) => ('urol', 'a', 'b') */
   /* search849_0_0 -> 16 in the cache */
   /* search849_0_1 -> 36 in the cache */
   /* search849_0 -> 895 in the cache */
   /* search849_1_0 -> 16 in the cache */
   /* search849_1_1_0 -> 823 in the cache */
   /* search849_1_1_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_isub,
      -1, 0,
      { 823, 36 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ushr,
      -1, 0,
      { 16, 2473 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 895, 2474 },
      -1,
   } },

   /* replace849_0 -> 16 in the cache */
   /* replace849_1 -> 36 in the cache */
   /* replace849 -> 2472 in the cache */

   /* ('ior', ('ushr@16', 'a', 'b'), ('ishl@16', 'a', ('iadd', 16, ('ineg', 'b')))) => ('uror', 'a', 'b') */
   /* search850_0_0 -> 11 in the cache */
   /* search850_0_1 -> 36 in the cache */
   /* search850_0 -> 2096 in the cache */
   /* search850_1_0 -> 11 in the cache */
   /* search850_1_1_0 -> 801 in the cache */
   /* search850_1_1_1_0 -> 36 in the cache */
   /* search850_1_1_1 -> 2461 in the cache */
   /* search850_1_1 -> 2462 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 11, 2462 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 2096, 2476 },
      -1,
   } },

   /* replace850_0 -> 11 in the cache */
   /* replace850_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_uror,
      -1, 0,
      { 11, 36 },
      -1,
   } },

   /* ('ior', ('ushr@16', 'a', 'b'), ('ishl@16', 'a', ('isub', 16, 'b'))) => ('uror', 'a', 'b') */
   /* search851_0_0 -> 11 in the cache */
   /* search851_0_1 -> 36 in the cache */
   /* search851_0 -> 2096 in the cache */
   /* search851_1_0 -> 11 in the cache */
   /* search851_1_1_0 -> 801 in the cache */
   /* search851_1_1_1 -> 36 in the cache */
   /* search851_1_1 -> 2466 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 11, 2466 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2096, 2479 },
      -1,
   } },

   /* replace851_0 -> 11 in the cache */
   /* replace851_1 -> 36 in the cache */
   /* replace851 -> 2478 in the cache */

   /* ('ior', ('ushr@32', 'a', 'b'), ('ishl@32', 'a', ('iadd', 32, ('ineg', 'b')))) => ('uror', 'a', 'b') */
   /* search852_0_0 -> 16 in the cache */
   /* search852_0_1 -> 36 in the cache */
   /* search852_0 -> 2121 in the cache */
   /* search852_1_0 -> 16 in the cache */
   /* search852_1_1_0 -> 823 in the cache */
   /* search852_1_1_1_0 -> 36 in the cache */
   /* search852_1_1_1 -> 2461 in the cache */
   /* search852_1_1 -> 2469 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 1,
      { 16, 2469 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ior,
      0, 2,
      { 2121, 2481 },
      -1,
   } },

   /* replace852_0 -> 16 in the cache */
   /* replace852_1 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_uror,
      -1, 0,
      { 16, 36 },
      -1,
   } },

   /* ('ior', ('ushr@32', 'a', 'b'), ('ishl@32', 'a', ('isub', 32, 'b'))) => ('uror', 'a', 'b') */
   /* search853_0_0 -> 16 in the cache */
   /* search853_0_1 -> 36 in the cache */
   /* search853_0 -> 2121 in the cache */
   /* search853_1_0 -> 16 in the cache */
   /* search853_1_1_0 -> 823 in the cache */
   /* search853_1_1_1 -> 36 in the cache */
   /* search853_1_1 -> 2473 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ishl,
      -1, 0,
      { 16, 2473 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2121, 2484 },
      -1,
   } },

   /* replace853_0 -> 16 in the cache */
   /* replace853_1 -> 36 in the cache */
   /* replace853 -> 2483 in the cache */

   /* ('urol@16', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 16, 'b'))) */
   /* search854_0 -> 11 in the cache */
   /* search854_1 -> 36 in the cache */
   /* search854 -> 2465 in the cache */

   /* replace854_0_0 -> 11 in the cache */
   /* replace854_0_1 -> 36 in the cache */
   /* replace854_0 -> 2092 in the cache */
   /* replace854_1_0 -> 11 in the cache */
   /* replace854_1_1_0 -> 801 in the cache */
   /* replace854_1_1_1 -> 36 in the cache */
   /* replace854_1_1 -> 2466 in the cache */
   /* replace854_1 -> 2467 in the cache */
   /* replace854 -> 2468 in the cache */

   /* ('urol@32', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 32, 'b'))) */
   /* search855_0 -> 16 in the cache */
   /* search855_1 -> 36 in the cache */
   /* search855 -> 2472 in the cache */

   /* replace855_0_0 -> 16 in the cache */
   /* replace855_0_1 -> 36 in the cache */
   /* replace855_0 -> 895 in the cache */
   /* replace855_1_0 -> 16 in the cache */
   /* replace855_1_1_0 -> 823 in the cache */
   /* replace855_1_1_1 -> 36 in the cache */
   /* replace855_1_1 -> 2473 in the cache */
   /* replace855_1 -> 2474 in the cache */
   /* replace855 -> 2475 in the cache */

   /* ('uror@16', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 16, 'b'))) */
   /* search856_0 -> 11 in the cache */
   /* search856_1 -> 36 in the cache */
   /* search856 -> 2478 in the cache */

   /* replace856_0_0 -> 11 in the cache */
   /* replace856_0_1 -> 36 in the cache */
   /* replace856_0 -> 2096 in the cache */
   /* replace856_1_0 -> 11 in the cache */
   /* replace856_1_1_0 -> 801 in the cache */
   /* replace856_1_1_1 -> 36 in the cache */
   /* replace856_1_1 -> 2466 in the cache */
   /* replace856_1 -> 2479 in the cache */
   /* replace856 -> 2480 in the cache */

   /* ('uror@32', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 32, 'b'))) */
   /* search857_0 -> 16 in the cache */
   /* search857_1 -> 36 in the cache */
   /* search857 -> 2483 in the cache */

   /* replace857_0_0 -> 16 in the cache */
   /* replace857_0_1 -> 36 in the cache */
   /* replace857_0 -> 2121 in the cache */
   /* replace857_1_0 -> 16 in the cache */
   /* replace857_1_1_0 -> 823 in the cache */
   /* replace857_1_1_1 -> 36 in the cache */
   /* replace857_1_1 -> 2473 in the cache */
   /* replace857_1 -> 2484 in the cache */
   /* replace857 -> 2485 in the cache */

   /* ('~fexp2', ('flog2', 'a')) => a */
   /* search858_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_flog2,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fexp2,
      -1, 0,
      { 2486 },
      -1,
   } },

   /* replace858 -> 32 in the cache */

   /* ('~flog2', ('fexp2', 'a')) => a */
   /* search859_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_flog2,
      -1, 0,
      { 2488 },
      -1,
   } },

   /* replace859 -> 32 in the cache */

   /* ('fpow', 'a', 'b') => ('fexp2', ('fmul', ('flog2', 'a'), 'b')) */
   /* search860_0 -> 0 in the cache */
   /* search860_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fpow,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* replace860_0_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_flog2,
      -1, 0,
      { 0 },
      -1,
   } },
   /* replace860_0_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 2491, 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 2492 },
      -1,
   } },

   /* ('~fexp2', ('fmul', ('flog2', 'a'), 'b')) => ('fpow', 'a', 'b') */
   /* search861_0_0_0 -> 0 in the cache */
   /* search861_0_0 -> 2491 in the cache */
   /* search861_0_1 -> 3 in the cache */
   /* search861_0 -> 2492 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 2492 },
      -1,
   } },

   /* replace861_0 -> 0 in the cache */
   /* replace861_1 -> 3 in the cache */
   /* replace861 -> 2490 in the cache */

   /* ('~fexp2', ('fadd', ('fmul', ('flog2', 'a'), 'b'), ('fmul', ('flog2', 'c'), 'd'))) => ('~fmul', ('fpow', 'a', 'b'), ('fpow', 'c', 'd')) */
   /* search862_0_0_0_0 -> 147 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_flog2,
      -1, 0,
      { 147 },
      -1,
   } },
   /* search862_0_0_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      1, 1,
      { 2495, 148 },
      -1,
   } },
   /* search862_0_1_0_0 -> 150 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_flog2,
      -1, 0,
      { 150 },
      -1,
   } },
   /* search862_0_1_1 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 1,
      { 2497, 151 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fadd,
      0, 3,
      { 2496, 2498 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      nir_op_fexp2,
      -1, 3,
      { 2499 },
      -1,
   } },

   /* replace862_0_0 -> 147 in the cache */
   /* replace862_0_1 -> 148 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fpow,
      -1, 0,
      { 147, 148 },
      -1,
   } },
   /* replace862_1_0 -> 150 in the cache */
   /* replace862_1_1 -> 151 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      nir_op_fpow,
      -1, 0,
      { 150, 151 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 2501, 2502 },
      -1,
   } },

   /* ('~fexp2', ('fmul', ('flog2', 'a'), 0.5)) => ('fsqrt', 'a') */
   /* search863_0_0_0 -> 32 in the cache */
   /* search863_0_0 -> 2486 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x3fe0000000000000 /* 0.5 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 2486, 2504 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 2505 },
      -1,
   } },

   /* replace863_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsqrt,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('~fexp2', ('fmul', ('flog2', 'a'), 2.0)) => ('fmul', 'a', 'a') */
   /* search864_0_0_0 -> 32 in the cache */
   /* search864_0_0 -> 2486 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x4000000000000000 /* 2.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 2486, 2508 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 2509 },
      -1,
   } },

   /* replace864_0 -> 32 in the cache */
   /* replace864_1 -> 32 in the cache */
   /* replace864 -> 236 in the cache */

   /* ('~fexp2', ('fmul', ('flog2', 'a'), 4.0)) => ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a')) */
   /* search865_0_0_0 -> 32 in the cache */
   /* search865_0_0 -> 2486 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x4010000000000000 /* 4.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 2486, 2511 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 2512 },
      -1,
   } },

   /* replace865_0_0 -> 32 in the cache */
   /* replace865_0_1 -> 32 in the cache */
   /* replace865_0 -> 236 in the cache */
   /* replace865_1_0 -> 32 in the cache */
   /* replace865_1_1 -> 32 in the cache */
   /* replace865_1 -> 236 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      -1, 0,
      { 236, 236 },
      -1,
   } },

   /* ('~fpow', 'a', 1.0) => a */
   /* search866_0 -> 32 in the cache */
   /* search866_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fpow,
      -1, 0,
      { 32, 226 },
      -1,
   } },

   /* replace866 -> 32 in the cache */

   /* ('~fpow', 'a', 2.0) => ('fmul', 'a', 'a') */
   /* search867_0 -> 32 in the cache */
   /* search867_1 -> 2508 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fpow,
      -1, 0,
      { 32, 2508 },
      -1,
   } },

   /* replace867_0 -> 32 in the cache */
   /* replace867_1 -> 32 in the cache */
   /* replace867 -> 236 in the cache */

   /* ('~fpow', 'a', 4.0) => ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a')) */
   /* search868_0 -> 32 in the cache */
   /* search868_1 -> 2511 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fpow,
      -1, 0,
      { 32, 2511 },
      -1,
   } },

   /* replace868_0_0 -> 32 in the cache */
   /* replace868_0_1 -> 32 in the cache */
   /* replace868_0 -> 236 in the cache */
   /* replace868_1_0 -> 32 in the cache */
   /* replace868_1_1 -> 32 in the cache */
   /* replace868_1 -> 236 in the cache */
   /* replace868 -> 2514 in the cache */

   /* ('~fpow', 2.0, 'a') => ('fexp2', 'a') */
   /* search869_0 -> 2508 in the cache */
   /* search869_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fpow,
      -1, 0,
      { 2508, 32 },
      -1,
   } },

   /* replace869_0 -> 32 in the cache */
   /* replace869 -> 2488 in the cache */

   /* ('~fpow', ('fpow', 'a', 2.2), 0.454545) => a */
   /* search870_0_0 -> 32 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x400199999999999a /* 2.2 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fpow,
      -1, 0,
      { 32, 2519 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x3fdd1743e963dc48 /* 0.454545 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fpow,
      -1, 0,
      { 2520, 2521 },
      -1,
   } },

   /* replace870 -> 32 in the cache */

   /* ('~fpow', ('fabs', ('fpow', 'a', 2.2)), 0.454545) => ('fabs', 'a') */
   /* search871_0_0_0 -> 32 in the cache */
   /* search871_0_0_1 -> 2519 in the cache */
   /* search871_0_0 -> 2520 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 2520 },
      -1,
   } },
   /* search871_1 -> 2521 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fpow,
      -1, 0,
      { 2523, 2521 },
      -1,
   } },

   /* replace871_0 -> 32 in the cache */
   /* replace871 -> 103 in the cache */

   /* ('~fsqrt', ('fexp2', 'a')) => ('fexp2', ('fmul', 0.5, 'a')) */
   /* search872_0_0 -> 32 in the cache */
   /* search872_0 -> 2488 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fsqrt,
      -1, 0,
      { 2488 },
      -1,
   } },

   /* replace872_0_0 -> 2504 in the cache */
   /* replace872_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 2504, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 2526 },
      -1,
   } },

   /* ('~frcp', ('fexp2', 'a')) => ('fexp2', ('fneg', 'a')) */
   /* search873_0_0 -> 32 in the cache */
   /* search873_0 -> 2488 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_frcp,
      -1, 0,
      { 2488 },
      -1,
   } },

   /* replace873_0_0 -> 32 in the cache */
   /* replace873_0 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 0,
      { 98 },
      -1,
   } },

   /* ('~frsq', ('fexp2', 'a')) => ('fexp2', ('fmul', -0.5, 'a')) */
   /* search874_0_0 -> 32 in the cache */
   /* search874_0 -> 2488 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_frsq,
      -1, 0,
      { 2488 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0xbfe0000000000000 /* -0.5 */ },
   } },
   /* replace874_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 2531, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 2532 },
      -1,
   } },

   /* ('~flog2', ('fsqrt', 'a')) => ('fmul', 0.5, ('flog2', 'a')) */
   /* search875_0_0 -> 32 in the cache */
   /* search875_0 -> 2507 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_flog2,
      -1, 0,
      { 2507 },
      -1,
   } },

   /* replace875_0 -> 2504 in the cache */
   /* replace875_1_0 -> 32 in the cache */
   /* replace875_1 -> 2486 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 2504, 2486 },
      -1,
   } },

   /* ('~flog2', ('frcp', 'a')) => ('fneg', ('flog2', 'a')) */
   /* search876_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_frcp,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_flog2,
      -1, 0,
      { 2536 },
      -1,
   } },

   /* replace876_0_0 -> 32 in the cache */
   /* replace876_0 -> 2486 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 2486 },
      -1,
   } },

   /* ('~flog2', ('frsq', 'a')) => ('fmul', -0.5, ('flog2', 'a')) */
   /* search877_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_frsq,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_flog2,
      -1, 0,
      { 2539 },
      -1,
   } },

   /* replace877_0 -> 2531 in the cache */
   /* replace877_1_0 -> 32 in the cache */
   /* replace877_1 -> 2486 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 2531, 2486 },
      -1,
   } },

   /* ('~flog2', ('fpow', 'a', 'b')) => ('fmul', 'b', ('flog2', 'a')) */
   /* search878_0_0 -> 0 in the cache */
   /* search878_0_1 -> 3 in the cache */
   /* search878_0 -> 2490 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_flog2,
      -1, 0,
      { 2490 },
      -1,
   } },

   /* replace878_0 -> 3 in the cache */
   /* replace878_1_0 -> 0 in the cache */
   /* replace878_1 -> 2491 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 3, 2491 },
      -1,
   } },

   /* ('~fmul', ('fexp2(is_used_once)', 'a'), ('fexp2(is_used_once)', 'b')) => ('fexp2', ('fadd', 'a', 'b')) */
   /* search879_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 0,
      { 0 },
      0,
   } },
   /* search879_1_0 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 0,
      { 3 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 2544, 2545 },
      -1,
   } },

   /* replace879_0_0 -> 0 in the cache */
   /* replace879_0_1 -> 3 in the cache */
   /* replace879_0 -> 257 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fexp2,
      -1, 1,
      { 257 },
      -1,
   } },

   /* ('bcsel', ('flt', 'a', 0.0), 0.0, ('fsqrt', 'a')) => ('fsqrt', ('fmax', 'a', 0.0)) */
   /* search880_0_0 -> 32 in the cache */
   /* search880_0_1 -> 113 in the cache */
   /* search880_0 -> 670 in the cache */
   /* search880_1 -> 113 in the cache */
   /* search880_2_0 -> 32 in the cache */
   /* search880_2 -> 2507 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 670, 113, 2507 },
      -1,
   } },

   /* replace880_0_0 -> 32 in the cache */
   /* replace880_0_1 -> 113 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmax,
      0, 1,
      { 32, 113 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsqrt,
      -1, 1,
      { 2549 },
      -1,
   } },

   /* ('~fmul', ('fsqrt', 'a'), ('fsqrt', 'a')) => ('fabs', 'a') */
   /* search881_0_0 -> 32 in the cache */
   /* search881_0 -> 2507 in the cache */
   /* search881_1_0 -> 32 in the cache */
   /* search881_1 -> 2507 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fmul,
      -1, 0,
      { 2507, 2507 },
      -1,
   } },

   /* replace881_0 -> 32 in the cache */
   /* replace881 -> 103 in the cache */

   /* ('~fmulz', ('fsqrt', 'a'), ('fsqrt', 'a')) => ('fabs', 'a') */
   /* search882_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fsqrt,
      -1, 0,
      { 16 },
      -1,
   } },
   /* search882_1_0 -> 16 in the cache */
   /* search882_1 -> 2552 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fmulz,
      -1, 0,
      { 2552, 2552 },
      -1,
   } },

   /* replace882_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 0,
      { 16 },
      -1,
   } },

   /* ('~fdiv', 1.0, 'a') => ('frcp', 'a') */
   /* search883_0 -> 226 in the cache */
   /* search883_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_fdiv,
      -1, 0,
      { 226, 32 },
      -1,
   } },

   /* replace883_0 -> 32 in the cache */
   /* replace883 -> 2536 in the cache */

   /* ('fdiv', 'a', 'b') => ('fmul', 'a', ('frcp', 'b')) */
   /* search884_0 -> 0 in the cache */
   /* search884_1 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fdiv,
      -1, 0,
      { 0, 3 },
      -1,
   } },

   /* replace884_0 -> 0 in the cache */
   /* replace884_1_0 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_frcp,
      -1, 0,
      { 3 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_fmul,
      0, 1,
      { 0, 2557 },
      -1,
   } },

   /* ('~frcp', ('frcp', 'a')) => a */
   /* search885_0_0 -> 32 in the cache */
   /* search885_0 -> 2536 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_frcp,
      -1, 0,
      { 2536 },
      -1,
   } },

   /* replace885 -> 32 in the cache */

   /* ('~frcp', ('fsqrt', 'a')) => ('frsq', 'a') */
   /* search886_0_0 -> 32 in the cache */
   /* search886_0 -> 2507 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_frcp,
      -1, 0,
      { 2507 },
      -1,
   } },

   /* replace886_0 -> 32 in the cache */
   /* replace886 -> 2539 in the cache */

   /* ('fsqrt', 'a') => ('frcp', ('frsq', 'a')) */
   /* search887_0 -> 32 in the cache */
   /* search887 -> 2507 in the cache */

   /* replace887_0_0 -> 32 in the cache */
   /* replace887_0 -> 2539 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_frcp,
      -1, 0,
      { 2539 },
      -1,
   } },

   /* ('~frcp', ('frsq', 'a')) => ('fsqrt', 'a') */
   /* search888_0_0 -> 32 in the cache */
   /* search888_0 -> 2539 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      nir_op_frcp,
      -1, 0,
      { 2539 },
      -1,
   } },

   /* replace888_0 -> 32 in the cache */
   /* replace888 -> 2507 in the cache */

   /* ('fsin', 'a') => ('ffma', ('ffma', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0), ('fabs', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0)), ('fneg', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0))), 0.225, ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0)) */
   /* search889_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsin,
      -1, 0,
      { 32 },
      -1,
   } },

   /* replace889_0_0_0_0_0_0 -> 2508 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x3fc45f306dc9c883 /* 0.15915494309189535 */ },
   } },
   /* replace889_0_0_0_0_0_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      5, 1,
      { 2564, 32 },
      -1,
   } },
   /* replace889_0_0_0_0_0_1_0_1 -> 2504 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      4, 2,
      { 2565, 2504 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2566 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 3,
      { 2508, 2567 },
      -1,
   } },
   /* replace889_0_0_0_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2568, 226 },
      -1,
   } },
   /* replace889_0_0_0_1_0_0_0 -> 2508 in the cache */
   /* replace889_0_0_0_1_0_0_1_0_0_0 -> 2564 in the cache */
   /* replace889_0_0_0_1_0_0_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      9, 1,
      { 2564, 32 },
      -1,
   } },
   /* replace889_0_0_0_1_0_0_1_0_1 -> 2504 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      8, 2,
      { 2570, 2504 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2571 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      7, 3,
      { 2508, 2572 },
      -1,
   } },
   /* replace889_0_0_0_1_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2573, 226 },
      -1,
   } },
   /* replace889_0_0_0_1_1_0_0_0 -> 2508 in the cache */
   /* replace889_0_0_0_1_1_0_0_1_0_0_0 -> 2564 in the cache */
   /* replace889_0_0_0_1_1_0_0_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      12, 1,
      { 2564, 32 },
      -1,
   } },
   /* replace889_0_0_0_1_1_0_0_1_0_1 -> 2504 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      11, 2,
      { 2575, 2504 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2576 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      10, 3,
      { 2508, 2577 },
      -1,
   } },
   /* replace889_0_0_0_1_1_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2578, 226 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 3,
      { 2579 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      6, 7,
      { 2574, 2580 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 10,
      { 2569, 2581 },
      -1,
   } },
   /* replace889_0_0_1 -> 2511 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 11,
      { 2582, 2511 },
      -1,
   } },
   /* replace889_0_1_0_0_0_0_0 -> 2508 in the cache */
   /* replace889_0_1_0_0_0_0_1_0_0_0 -> 2564 in the cache */
   /* replace889_0_1_0_0_0_0_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      16, 1,
      { 2564, 32 },
      -1,
   } },
   /* replace889_0_1_0_0_0_0_1_0_1 -> 2504 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      15, 2,
      { 2584, 2504 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2585 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      14, 3,
      { 2508, 2586 },
      -1,
   } },
   /* replace889_0_1_0_0_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2587, 226 },
      -1,
   } },
   /* replace889_0_1_0_0_1_0_0_0 -> 2508 in the cache */
   /* replace889_0_1_0_0_1_0_0_1_0_0_0 -> 2564 in the cache */
   /* replace889_0_1_0_0_1_0_0_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      20, 1,
      { 2564, 32 },
      -1,
   } },
   /* replace889_0_1_0_0_1_0_0_1_0_1 -> 2504 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      19, 2,
      { 2589, 2504 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2590 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      18, 3,
      { 2508, 2591 },
      -1,
   } },
   /* replace889_0_1_0_0_1_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2592, 226 },
      -1,
   } },
   /* replace889_0_1_0_0_1_1_0_0_0 -> 2508 in the cache */
   /* replace889_0_1_0_0_1_1_0_0_1_0_0_0 -> 2564 in the cache */
   /* replace889_0_1_0_0_1_1_0_0_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      23, 1,
      { 2564, 32 },
      -1,
   } },
   /* replace889_0_1_0_0_1_1_0_0_1_0_1 -> 2504 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      22, 2,
      { 2594, 2504 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2595 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      21, 3,
      { 2508, 2596 },
      -1,
   } },
   /* replace889_0_1_0_0_1_1_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2597, 226 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 3,
      { 2598 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      17, 7,
      { 2593, 2599 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 10,
      { 2588, 2600 },
      -1,
   } },
   /* replace889_0_1_0_1 -> 2511 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      13, 11,
      { 2601, 2511 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 11,
      { 2602 },
      -1,
   } },
   /* replace889_0_2_0_0_0_0_0 -> 2508 in the cache */
   /* replace889_0_2_0_0_0_0_1_0_0_0 -> 2564 in the cache */
   /* replace889_0_2_0_0_0_0_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      27, 1,
      { 2564, 32 },
      -1,
   } },
   /* replace889_0_2_0_0_0_0_1_0_1 -> 2504 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      26, 2,
      { 2604, 2504 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2605 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      25, 3,
      { 2508, 2606 },
      -1,
   } },
   /* replace889_0_2_0_0_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2607, 226 },
      -1,
   } },
   /* replace889_0_2_0_0_1_0_0_0 -> 2508 in the cache */
   /* replace889_0_2_0_0_1_0_0_1_0_0_0 -> 2564 in the cache */
   /* replace889_0_2_0_0_1_0_0_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      31, 1,
      { 2564, 32 },
      -1,
   } },
   /* replace889_0_2_0_0_1_0_0_1_0_1 -> 2504 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      30, 2,
      { 2609, 2504 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2610 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      29, 3,
      { 2508, 2611 },
      -1,
   } },
   /* replace889_0_2_0_0_1_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2612, 226 },
      -1,
   } },
   /* replace889_0_2_0_0_1_1_0_0_0 -> 2508 in the cache */
   /* replace889_0_2_0_0_1_1_0_0_1_0_0_0 -> 2564 in the cache */
   /* replace889_0_2_0_0_1_1_0_0_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      34, 1,
      { 2564, 32 },
      -1,
   } },
   /* replace889_0_2_0_0_1_1_0_0_1_0_1 -> 2504 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      33, 2,
      { 2614, 2504 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2615 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      32, 3,
      { 2508, 2616 },
      -1,
   } },
   /* replace889_0_2_0_0_1_1_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2617, 226 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 3,
      { 2618 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      28, 7,
      { 2613, 2619 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 10,
      { 2608, 2620 },
      -1,
   } },
   /* replace889_0_2_0_1 -> 2511 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      24, 11,
      { 2621, 2511 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 11,
      { 2622 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 34,
      { 2583, 2603, 2623 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x3fcccccccccccccd /* 0.225 */ },
   } },
   /* replace889_2_0_0_0_0 -> 2508 in the cache */
   /* replace889_2_0_0_0_1_0_0_0 -> 2564 in the cache */
   /* replace889_2_0_0_0_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      38, 1,
      { 2564, 32 },
      -1,
   } },
   /* replace889_2_0_0_0_1_0_1 -> 2504 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      37, 2,
      { 2626, 2504 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2627 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      36, 3,
      { 2508, 2628 },
      -1,
   } },
   /* replace889_2_0_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2629, 226 },
      -1,
   } },
   /* replace889_2_0_1_0_0_0 -> 2508 in the cache */
   /* replace889_2_0_1_0_0_1_0_0_0 -> 2564 in the cache */
   /* replace889_2_0_1_0_0_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      42, 1,
      { 2564, 32 },
      -1,
   } },
   /* replace889_2_0_1_0_0_1_0_1 -> 2504 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      41, 2,
      { 2631, 2504 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2632 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      40, 3,
      { 2508, 2633 },
      -1,
   } },
   /* replace889_2_0_1_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2634, 226 },
      -1,
   } },
   /* replace889_2_0_1_1_0_0_0 -> 2508 in the cache */
   /* replace889_2_0_1_1_0_0_1_0_0_0 -> 2564 in the cache */
   /* replace889_2_0_1_1_0_0_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      45, 1,
      { 2564, 32 },
      -1,
   } },
   /* replace889_2_0_1_1_0_0_1_0_1 -> 2504 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      44, 2,
      { 2636, 2504 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2637 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      43, 3,
      { 2508, 2638 },
      -1,
   } },
   /* replace889_2_0_1_1_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2639, 226 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 3,
      { 2640 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      39, 7,
      { 2635, 2641 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 10,
      { 2630, 2642 },
      -1,
   } },
   /* replace889_2_1 -> 2511 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      35, 11,
      { 2643, 2511 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 46,
      { 2624, 2625, 2644 },
      -1,
   } },

   /* ('fcos', 'a') => ('ffma', ('ffma', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0), ('fabs', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0)), ('fneg', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0))), 0.225, ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0)) */
   /* search890_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fcos,
      -1, 0,
      { 32 },
      -1,
   } },

   /* replace890_0_0_0_0_0_0 -> 2508 in the cache */
   /* replace890_0_0_0_0_0_1_0_0_0 -> 2564 in the cache */
   /* replace890_0_0_0_0_0_1_0_0_1 -> 32 in the cache */
   /* replace890_0_0_0_0_0_1_0_0 -> 2565 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x3fe8000000000000 /* 0.75 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      4, 2,
      { 2565, 2647 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2648 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      3, 3,
      { 2508, 2649 },
      -1,
   } },
   /* replace890_0_0_0_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2650, 226 },
      -1,
   } },
   /* replace890_0_0_0_1_0_0_0 -> 2508 in the cache */
   /* replace890_0_0_0_1_0_0_1_0_0_0 -> 2564 in the cache */
   /* replace890_0_0_0_1_0_0_1_0_0_1 -> 32 in the cache */
   /* replace890_0_0_0_1_0_0_1_0_0 -> 2570 in the cache */
   /* replace890_0_0_0_1_0_0_1_0_1 -> 2647 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      8, 2,
      { 2570, 2647 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2652 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      7, 3,
      { 2508, 2653 },
      -1,
   } },
   /* replace890_0_0_0_1_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2654, 226 },
      -1,
   } },
   /* replace890_0_0_0_1_1_0_0_0 -> 2508 in the cache */
   /* replace890_0_0_0_1_1_0_0_1_0_0_0 -> 2564 in the cache */
   /* replace890_0_0_0_1_1_0_0_1_0_0_1 -> 32 in the cache */
   /* replace890_0_0_0_1_1_0_0_1_0_0 -> 2575 in the cache */
   /* replace890_0_0_0_1_1_0_0_1_0_1 -> 2647 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      11, 2,
      { 2575, 2647 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2656 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      10, 3,
      { 2508, 2657 },
      -1,
   } },
   /* replace890_0_0_0_1_1_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2658, 226 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 3,
      { 2659 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      6, 7,
      { 2655, 2660 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 10,
      { 2651, 2661 },
      -1,
   } },
   /* replace890_0_0_1 -> 2511 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      2, 11,
      { 2662, 2511 },
      -1,
   } },
   /* replace890_0_1_0_0_0_0_0 -> 2508 in the cache */
   /* replace890_0_1_0_0_0_0_1_0_0_0 -> 2564 in the cache */
   /* replace890_0_1_0_0_0_0_1_0_0_1 -> 32 in the cache */
   /* replace890_0_1_0_0_0_0_1_0_0 -> 2584 in the cache */
   /* replace890_0_1_0_0_0_0_1_0_1 -> 2647 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      15, 2,
      { 2584, 2647 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2664 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      14, 3,
      { 2508, 2665 },
      -1,
   } },
   /* replace890_0_1_0_0_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2666, 226 },
      -1,
   } },
   /* replace890_0_1_0_0_1_0_0_0 -> 2508 in the cache */
   /* replace890_0_1_0_0_1_0_0_1_0_0_0 -> 2564 in the cache */
   /* replace890_0_1_0_0_1_0_0_1_0_0_1 -> 32 in the cache */
   /* replace890_0_1_0_0_1_0_0_1_0_0 -> 2589 in the cache */
   /* replace890_0_1_0_0_1_0_0_1_0_1 -> 2647 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      19, 2,
      { 2589, 2647 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2668 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      18, 3,
      { 2508, 2669 },
      -1,
   } },
   /* replace890_0_1_0_0_1_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2670, 226 },
      -1,
   } },
   /* replace890_0_1_0_0_1_1_0_0_0 -> 2508 in the cache */
   /* replace890_0_1_0_0_1_1_0_0_1_0_0_0 -> 2564 in the cache */
   /* replace890_0_1_0_0_1_1_0_0_1_0_0_1 -> 32 in the cache */
   /* replace890_0_1_0_0_1_1_0_0_1_0_0 -> 2594 in the cache */
   /* replace890_0_1_0_0_1_1_0_0_1_0_1 -> 2647 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      22, 2,
      { 2594, 2647 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2672 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      21, 3,
      { 2508, 2673 },
      -1,
   } },
   /* replace890_0_1_0_0_1_1_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2674, 226 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 3,
      { 2675 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      17, 7,
      { 2671, 2676 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 10,
      { 2667, 2677 },
      -1,
   } },
   /* replace890_0_1_0_1 -> 2511 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      13, 11,
      { 2678, 2511 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 11,
      { 2679 },
      -1,
   } },
   /* replace890_0_2_0_0_0_0_0 -> 2508 in the cache */
   /* replace890_0_2_0_0_0_0_1_0_0_0 -> 2564 in the cache */
   /* replace890_0_2_0_0_0_0_1_0_0_1 -> 32 in the cache */
   /* replace890_0_2_0_0_0_0_1_0_0 -> 2604 in the cache */
   /* replace890_0_2_0_0_0_0_1_0_1 -> 2647 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      26, 2,
      { 2604, 2647 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2681 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      25, 3,
      { 2508, 2682 },
      -1,
   } },
   /* replace890_0_2_0_0_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2683, 226 },
      -1,
   } },
   /* replace890_0_2_0_0_1_0_0_0 -> 2508 in the cache */
   /* replace890_0_2_0_0_1_0_0_1_0_0_0 -> 2564 in the cache */
   /* replace890_0_2_0_0_1_0_0_1_0_0_1 -> 32 in the cache */
   /* replace890_0_2_0_0_1_0_0_1_0_0 -> 2609 in the cache */
   /* replace890_0_2_0_0_1_0_0_1_0_1 -> 2647 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      30, 2,
      { 2609, 2647 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2685 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      29, 3,
      { 2508, 2686 },
      -1,
   } },
   /* replace890_0_2_0_0_1_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2687, 226 },
      -1,
   } },
   /* replace890_0_2_0_0_1_1_0_0_0 -> 2508 in the cache */
   /* replace890_0_2_0_0_1_1_0_0_1_0_0_0 -> 2564 in the cache */
   /* replace890_0_2_0_0_1_1_0_0_1_0_0_1 -> 32 in the cache */
   /* replace890_0_2_0_0_1_1_0_0_1_0_0 -> 2614 in the cache */
   /* replace890_0_2_0_0_1_1_0_0_1_0_1 -> 2647 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      33, 2,
      { 2614, 2647 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2689 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      32, 3,
      { 2508, 2690 },
      -1,
   } },
   /* replace890_0_2_0_0_1_1_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2691, 226 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 3,
      { 2692 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      28, 7,
      { 2688, 2693 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 10,
      { 2684, 2694 },
      -1,
   } },
   /* replace890_0_2_0_1 -> 2511 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      24, 11,
      { 2695, 2511 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 11,
      { 2696 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffma,
      1, 34,
      { 2663, 2680, 2697 },
      -1,
   } },
   /* replace890_1 -> 2625 in the cache */
   /* replace890_2_0_0_0_0 -> 2508 in the cache */
   /* replace890_2_0_0_0_1_0_0_0 -> 2564 in the cache */
   /* replace890_2_0_0_0_1_0_0_1 -> 32 in the cache */
   /* replace890_2_0_0_0_1_0_0 -> 2626 in the cache */
   /* replace890_2_0_0_0_1_0_1 -> 2647 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      37, 2,
      { 2626, 2647 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2699 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      36, 3,
      { 2508, 2700 },
      -1,
   } },
   /* replace890_2_0_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2701, 226 },
      -1,
   } },
   /* replace890_2_0_1_0_0_0 -> 2508 in the cache */
   /* replace890_2_0_1_0_0_1_0_0_0 -> 2564 in the cache */
   /* replace890_2_0_1_0_0_1_0_0_1 -> 32 in the cache */
   /* replace890_2_0_1_0_0_1_0_0 -> 2631 in the cache */
   /* replace890_2_0_1_0_0_1_0_1 -> 2647 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      41, 2,
      { 2631, 2647 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2703 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      40, 3,
      { 2508, 2704 },
      -1,
   } },
   /* replace890_2_0_1_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2705, 226 },
      -1,
   } },
   /* replace890_2_0_1_1_0_0_0 -> 2508 in the cache */
   /* replace890_2_0_1_1_0_0_1_0_0_0 -> 2564 in the cache */
   /* replace890_2_0_1_1_0_0_1_0_0_1 -> 32 in the cache */
   /* replace890_2_0_1_1_0_0_1_0_0 -> 2636 in the cache */
   /* replace890_2_0_1_1_0_0_1_0_1 -> 2647 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fadd,
      44, 2,
      { 2636, 2647 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffract,
      -1, 2,
      { 2707 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      43, 3,
      { 2508, 2708 },
      -1,
   } },
   /* replace890_2_0_1_1_0_1 -> 226 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 3,
      { 2709, 226 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fabs,
      -1, 3,
      { 2710 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      39, 7,
      { 2706, 2711 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fsub,
      -1, 10,
      { 2702, 2712 },
      -1,
   } },
   /* replace890_2_1 -> 2511 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_fmul,
      35, 11,
      { 2713, 2511 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      nir_op_ffma,
      0, 46,
      { 2698, 2625, 2714 },
      -1,
   } },

   /* ('i2b16(is_used_by_if)', 'a') => ('ine16', 'a', 0) */
   /* search891_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2b16,
      -1, 0,
      { 32 },
      2,
   } },

   /* replace891_0 -> 32 in the cache */
   /* replace891_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_ine16,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* ('i2b32(is_used_by_if)', 'a') => ('ine32', 'a', 0) */
   /* search892_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2b32,
      -1, 0,
      { 32 },
      2,
   } },

   /* replace892_0 -> 32 in the cache */
   /* replace892_1 -> 61 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_ine32,
      0, 1,
      { 32, 61 },
      -1,
   } },

   /* ('i2b1(is_used_by_if)', 'a') => ('ine', 'a', 0) */
   /* search893_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_i2b1,
      -1, 0,
      { 32 },
      2,
   } },

   /* replace893_0 -> 32 in the cache */
   /* replace893_1 -> 61 in the cache */
   /* replace893 -> 1173 in the cache */

   /* ('ieq', 'a', True) => a */
   /* search894_0 -> 706 in the cache */
   /* search894_1 -> 1177 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 706, 1177 },
      -1,
   } },

   /* replace894 -> 706 in the cache */

   /* ('ine(is_not_used_by_if)', 'a', True) => ('inot', 'a') */
   /* search895_0 -> 706 in the cache */
   /* search895_1 -> 1177 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 706, 1177 },
      3,
   } },

   /* replace895_0 -> 706 in the cache */
   /* replace895 -> 1072 in the cache */

   /* ('ine', 'a', False) => a */
   /* search896_0 -> 706 in the cache */
   /* search896_1 -> 1024 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 706, 1024 },
      -1,
   } },

   /* replace896 -> 706 in the cache */

   /* ('ieq(is_not_used_by_if)', 'a', False) => ('inot', 'a') */
   /* search897_0 -> 706 in the cache */
   /* search897_1 -> 1024 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 706, 1024 },
      3,
   } },

   /* replace897_0 -> 706 in the cache */
   /* replace897 -> 1072 in the cache */

   /* ('bcsel', 'a', True, False) => a */
   /* search898_0 -> 706 in the cache */
   /* search898_1 -> 1177 in the cache */
   /* search898_2 -> 1024 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 1177, 1024 },
      -1,
   } },

   /* replace898 -> 706 in the cache */

   /* ('bcsel', 'a', False, True) => ('inot', 'a') */
   /* search899_0 -> 706 in the cache */
   /* search899_1 -> 1024 in the cache */
   /* search899_2 -> 1177 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 1024, 1177 },
      -1,
   } },

   /* replace899_0 -> 706 in the cache */
   /* replace899 -> 1072 in the cache */

   /* ('bcsel', True, 'b', 'c') => b */
   /* search900_0 -> 1177 in the cache */
   /* search900_1 -> 1058 in the cache */
   /* search900_2 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1177, 1058, 665 },
      -1,
   } },

   /* replace900 -> 1058 in the cache */

   /* ('bcsel', False, 'b', 'c') => c */
   /* search901_0 -> 1024 in the cache */
   /* search901_1 -> 1058 in the cache */
   /* search901_2 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 1024, 1058, 665 },
      -1,
   } },

   /* replace901 -> 665 in the cache */

   /* ('bcsel@16', 'a', 1.0, 0.0) => ('b2f', 'a') */
   /* search902_0 -> 706 in the cache */
   /* search902_1 -> 462 in the cache */
   /* search902_2 -> 115 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 462, 115 },
      -1,
   } },

   /* replace902_0 -> 706 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 706 },
      -1,
   } },

   /* ('bcsel@16', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a')) */
   /* search903_0 -> 706 in the cache */
   /* search903_1 -> 115 in the cache */
   /* search903_2 -> 462 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 115, 462 },
      -1,
   } },

   /* replace903_0_0 -> 706 in the cache */
   /* replace903_0 -> 1072 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1072 },
      -1,
   } },

   /* ('bcsel@16', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a')) */
   /* search904_0 -> 706 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_float, { 0xbff0000000000000 /* -1.0 */ },
   } },
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_float, { 0x8000000000000000 /* -0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 2733, 2734 },
      -1,
   } },

   /* replace904_0_0 -> 706 in the cache */
   /* replace904_0 -> 2730 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 2730 },
      -1,
   } },

   /* ('bcsel@16', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a'))) */
   /* search905_0 -> 706 in the cache */
   /* search905_1 -> 2734 in the cache */
   /* search905_2 -> 2733 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 2734, 2733 },
      -1,
   } },

   /* replace905_0_0_0 -> 706 in the cache */
   /* replace905_0_0 -> 1072 in the cache */
   /* replace905_0 -> 2732 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 2732 },
      -1,
   } },

   /* ('bcsel@32', 'a', 1.0, 0.0) => ('b2f', 'a') */
   /* search906_0 -> 706 in the cache */
   /* search906_1 -> 228 in the cache */
   /* search906_2 -> 117 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 228, 117 },
      -1,
   } },

   /* replace906_0 -> 706 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 706 },
      -1,
   } },

   /* ('bcsel@32', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a')) */
   /* search907_0 -> 706 in the cache */
   /* search907_1 -> 117 in the cache */
   /* search907_2 -> 228 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 117, 228 },
      -1,
   } },

   /* replace907_0_0 -> 706 in the cache */
   /* replace907_0 -> 1072 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1072 },
      -1,
   } },

   /* ('bcsel@32', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a')) */
   /* search908_0 -> 706 in the cache */
   /* search908_1 -> 263 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_float, { 0x8000000000000000 /* -0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 263, 2743 },
      -1,
   } },

   /* replace908_0_0 -> 706 in the cache */
   /* replace908_0 -> 2740 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 2740 },
      -1,
   } },

   /* ('bcsel@32', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a'))) */
   /* search909_0 -> 706 in the cache */
   /* search909_1 -> 2743 in the cache */
   /* search909_2 -> 263 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 2743, 263 },
      -1,
   } },

   /* replace909_0_0_0 -> 706 in the cache */
   /* replace909_0_0 -> 1072 in the cache */
   /* replace909_0 -> 2742 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 2742 },
      -1,
   } },

   /* ('bcsel@64', 'a', 1.0, 0.0) => ('b2f', 'a') */
   /* search910_0 -> 706 in the cache */
   /* search910_1 -> 603 in the cache */
   /* search910_2 -> 1856 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 603, 1856 },
      -1,
   } },

   /* replace910_0 -> 706 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 706 },
      -1,
   } },

   /* ('bcsel@64', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a')) */
   /* search911_0 -> 706 in the cache */
   /* search911_1 -> 1856 in the cache */
   /* search911_2 -> 603 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 1856, 603 },
      -1,
   } },

   /* replace911_0_0 -> 706 in the cache */
   /* replace911_0 -> 1072 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_search_op_b2f,
      -1, 0,
      { 1072 },
      -1,
   } },

   /* ('bcsel@64', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a')) */
   /* search912_0 -> 706 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_float, { 0xbff0000000000000 /* -1.0 */ },
   } },
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_float, { 0x8000000000000000 /* -0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 2752, 2753 },
      -1,
   } },

   /* replace912_0_0 -> 706 in the cache */
   /* replace912_0 -> 2749 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 2749 },
      -1,
   } },

   /* ('bcsel@64', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a'))) */
   /* search913_0 -> 706 in the cache */
   /* search913_1 -> 2753 in the cache */
   /* search913_2 -> 2752 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 2753, 2752 },
      -1,
   } },

   /* replace913_0_0_0 -> 706 in the cache */
   /* replace913_0_0 -> 1072 in the cache */
   /* replace913_0 -> 2751 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      nir_op_fneg,
      -1, 0,
      { 2751 },
      -1,
   } },

   /* ('bcsel', 'a', 'b', 'b') => b */
   /* search914_0 -> 706 in the cache */
   /* search914_1 -> 3 in the cache */
   /* search914_2 -> 3 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 3, 3 },
      -1,
   } },

   /* replace914 -> 3 in the cache */

   /* ('~fcsel', 'a', 'b', 'b') => b */
   /* search915_0 -> 16 in the cache */
   /* search915_1 -> 36 in the cache */
   /* search915_2 -> 36 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      nir_op_fcsel,
      -1, 0,
      { 16, 36, 36 },
      -1,
   } },

   /* replace915 -> 36 in the cache */

   /* ('bcsel', 'a', -1, 0) => ('ineg', ('b2i', 'a@1')) */
   /* search916_0 -> 706 in the cache */
   { .constant = {
      { nir_search_value_constant, 0 },
      nir_type_int, { -0x1 /* -1 */ },
   } },
   /* search916_2 -> 1169 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 2760, 1169 },
      -1,
   } },

   /* replace916_0_0 -> 706 in the cache */
   /* replace916_0 -> 1168 in the cache */
   /* replace916 -> 2164 in the cache */

   /* ('bcsel', 'a', 0, -1) => ('ineg', ('b2i', ('inot', 'a'))) */
   /* search917_0 -> 706 in the cache */
   /* search917_1 -> 1169 in the cache */
   /* search917_2 -> 2760 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 1169, 2760 },
      -1,
   } },

   /* replace917_0_0_0 -> 706 in the cache */
   /* replace917_0_0 -> 1072 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 0,
      { 1072 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2763 },
      -1,
   } },

   /* ('bcsel', 'a', 1, 0) => ('b2i', 'a@1') */
   /* search918_0 -> 706 in the cache */
   { .constant = {
      { nir_search_value_constant, 0 },
      nir_type_int, { 0x1 /* 1 */ },
   } },
   /* search918_2 -> 1169 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 2765, 1169 },
      -1,
   } },

   /* replace918_0 -> 706 in the cache */
   /* replace918 -> 1168 in the cache */

   /* ('bcsel', 'a', 0, 1) => ('b2i', ('inot', 'a')) */
   /* search919_0 -> 706 in the cache */
   /* search919_1 -> 1169 in the cache */
   /* search919_2 -> 2765 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 706, 1169, 2765 },
      -1,
   } },

   /* replace919_0_0 -> 706 in the cache */
   /* replace919_0 -> 1072 in the cache */
   /* replace919 -> 2763 in the cache */

   /* ('iand', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b'))) */
   /* search920_0_0_0 -> 706 in the cache */
   /* search920_0_0 -> 1168 in the cache */
   /* search920_0 -> 2164 in the cache */
   /* search920_1_0_0 -> 1075 in the cache */
   /* search920_1_0 -> 2165 in the cache */
   /* search920_1 -> 2166 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2164, 2166 },
      -1,
   } },

   /* replace920_0_0_0 -> 706 in the cache */
   /* replace920_0_0_1 -> 1075 in the cache */
   /* replace920_0_0 -> 1087 in the cache */
   /* replace920_0 -> 2410 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 1,
      { 2410 },
      -1,
   } },

   /* ('ior', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b'))) */
   /* search921_0_0_0 -> 706 in the cache */
   /* search921_0_0 -> 1168 in the cache */
   /* search921_0 -> 2164 in the cache */
   /* search921_1_0_0 -> 1075 in the cache */
   /* search921_1_0 -> 2165 in the cache */
   /* search921_1 -> 2166 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ior,
      0, 1,
      { 2164, 2166 },
      -1,
   } },

   /* replace921_0_0_0 -> 706 in the cache */
   /* replace921_0_0_1 -> 1075 in the cache */
   /* replace921_0_0 -> 1079 in the cache */
   /* replace921_0 -> 2413 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 1,
      { 2413 },
      -1,
   } },

   /* ('ieq', ('ineg', ('b2i', 'a@1')), 0) => ('inot', 'a') */
   /* search922_0_0_0 -> 706 in the cache */
   /* search922_0_0 -> 1168 in the cache */
   /* search922_0 -> 2164 in the cache */
   /* search922_1 -> 1169 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 2164, 1169 },
      -1,
   } },

   /* replace922_0 -> 706 in the cache */
   /* replace922 -> 1072 in the cache */

   /* ('ieq', ('ineg', ('b2i', 'a@1')), -1) => a */
   /* search923_0_0_0 -> 706 in the cache */
   /* search923_0_0 -> 1168 in the cache */
   /* search923_0 -> 2164 in the cache */
   /* search923_1 -> 2760 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ieq,
      0, 1,
      { 2164, 2760 },
      -1,
   } },

   /* replace923 -> 706 in the cache */

   /* ('ine', ('ineg', ('b2i', 'a@1')), 0) => a */
   /* search924_0_0_0 -> 706 in the cache */
   /* search924_0_0 -> 1168 in the cache */
   /* search924_0 -> 2164 in the cache */
   /* search924_1 -> 1169 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 2164, 1169 },
      -1,
   } },

   /* replace924 -> 706 in the cache */

   /* ('ine', ('ineg', ('b2i', 'a@1')), -1) => ('inot', 'a') */
   /* search925_0_0_0 -> 706 in the cache */
   /* search925_0_0 -> 1168 in the cache */
   /* search925_0 -> 2164 in the cache */
   /* search925_1 -> 2760 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ine,
      0, 1,
      { 2164, 2760 },
      -1,
   } },

   /* replace925_0 -> 706 in the cache */
   /* replace925 -> 1072 in the cache */

   /* ('ige', ('ineg', ('b2i', 'a@1')), 0) => ('inot', 'a') */
   /* search926_0_0_0 -> 706 in the cache */
   /* search926_0_0 -> 1168 in the cache */
   /* search926_0 -> 2164 in the cache */
   /* search926_1 -> 1169 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ige,
      -1, 0,
      { 2164, 1169 },
      -1,
   } },

   /* replace926_0 -> 706 in the cache */
   /* replace926 -> 1072 in the cache */

   /* ('ilt', ('ineg', ('b2i', 'a@1')), 0) => a */
   /* search927_0_0_0 -> 706 in the cache */
   /* search927_0_0 -> 1168 in the cache */
   /* search927_0 -> 2164 in the cache */
   /* search927_1 -> 1169 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 2164, 1169 },
      -1,
   } },

   /* replace927 -> 706 in the cache */

   /* ('ult', 0, ('ineg', ('b2i', 'a@1'))) => a */
   /* search928_0 -> 1169 in the cache */
   /* search928_1_0_0 -> 706 in the cache */
   /* search928_1_0 -> 1168 in the cache */
   /* search928_1 -> 2164 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 1169, 2164 },
      -1,
   } },

   /* replace928 -> 706 in the cache */

   /* ('iand', ('ineg', ('b2i', 'a')), 1.0) => ('b2f', 'a') */
   /* search929_0_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 2779 },
      -1,
   } },
   /* search929_1 -> 1080 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2780, 1080 },
      -1,
   } },

   /* replace929_0 -> 32 in the cache */
   /* replace929 -> 1457 in the cache */

   /* ('iand', ('ineg', ('b2i', 'a')), 1) => ('b2i', 'a') */
   /* search930_0_0_0 -> 32 in the cache */
   /* search930_0_0 -> 2779 in the cache */
   /* search930_0 -> 2780 in the cache */
   /* search930_1 -> 2765 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_iand,
      0, 1,
      { 2780, 2765 },
      -1,
   } },

   /* replace930_0 -> 32 in the cache */
   /* replace930 -> 2779 in the cache */

   /* ('imax', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b'))) */
   /* search931_0_0_0 -> 706 in the cache */
   /* search931_0_0 -> 1168 in the cache */
   /* search931_0 -> 2164 in the cache */
   /* search931_1_0_0 -> 1075 in the cache */
   /* search931_1_0 -> 2165 in the cache */
   /* search931_1 -> 2166 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 2164, 2166 },
      -1,
   } },

   /* replace931_0_0_0 -> 706 in the cache */
   /* replace931_0_0_1 -> 1075 in the cache */
   /* replace931_0_0 -> 1087 in the cache */
   /* replace931_0 -> 2410 in the cache */
   /* replace931 -> 2769 in the cache */

   /* ('imin', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b'))) */
   /* search932_0_0_0 -> 706 in the cache */
   /* search932_0_0 -> 1168 in the cache */
   /* search932_0 -> 2164 in the cache */
   /* search932_1_0_0 -> 1075 in the cache */
   /* search932_1_0 -> 2165 in the cache */
   /* search932_1 -> 2166 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 2164, 2166 },
      -1,
   } },

   /* replace932_0_0_0 -> 706 in the cache */
   /* replace932_0_0_1 -> 1075 in the cache */
   /* replace932_0_0 -> 1079 in the cache */
   /* replace932_0 -> 2413 in the cache */
   /* replace932 -> 2771 in the cache */

   /* ('umax', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b'))) */
   /* search933_0_0_0 -> 706 in the cache */
   /* search933_0_0 -> 1168 in the cache */
   /* search933_0 -> 2164 in the cache */
   /* search933_1_0_0 -> 1075 in the cache */
   /* search933_1_0 -> 2165 in the cache */
   /* search933_1 -> 2166 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 2164, 2166 },
      -1,
   } },

   /* replace933_0_0_0 -> 706 in the cache */
   /* replace933_0_0_1 -> 1075 in the cache */
   /* replace933_0_0 -> 1079 in the cache */
   /* replace933_0 -> 2413 in the cache */
   /* replace933 -> 2771 in the cache */

   /* ('umin', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b'))) */
   /* search934_0_0_0 -> 706 in the cache */
   /* search934_0_0 -> 1168 in the cache */
   /* search934_0 -> 2164 in the cache */
   /* search934_1_0_0 -> 1075 in the cache */
   /* search934_1_0 -> 2165 in the cache */
   /* search934_1 -> 2166 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 2164, 2166 },
      -1,
   } },

   /* replace934_0_0_0 -> 706 in the cache */
   /* replace934_0_0_1 -> 1075 in the cache */
   /* replace934_0_0 -> 1087 in the cache */
   /* replace934_0 -> 2410 in the cache */
   /* replace934 -> 2769 in the cache */

   /* ('i2b16', ('b2i', 'a@16')) => a */
   /* search935_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 0,
      { 11 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2b16,
      -1, 0,
      { 2787 },
      -1,
   } },

   /* replace935 -> 11 in the cache */

   /* ('i2b32', ('b2i', 'a@32')) => a */
   /* search936_0_0 -> 16 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_b2i,
      -1, 0,
      { 16 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2b32,
      -1, 0,
      { 2789 },
      -1,
   } },

   /* replace936 -> 16 in the cache */

   /* ('f2i', ('ftrunc', 'a')) => ('f2i', 'a') */
   /* search937_0_0 -> 32 in the cache */
   /* search937_0 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 669 },
      -1,
   } },

   /* replace937_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_f2i,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('f2u', ('ftrunc', 'a')) => ('f2u', 'a') */
   /* search938_0_0 -> 32 in the cache */
   /* search938_0 -> 669 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_f2u,
      -1, 0,
      { 669 },
      -1,
   } },

   /* replace938_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_f2u,
      -1, 0,
      { 32 },
      -1,
   } },

   /* ('i2b', ('ineg', 'a')) => ('i2b', 'a') */
   /* search939_0_0 -> 32 in the cache */
   /* search939_0 -> 100 in the cache */
   /* search939 -> 111 in the cache */

   /* replace939_0 -> 32 in the cache */
   /* replace939 -> 112 in the cache */

   /* ('i2b', ('iabs', 'a')) => ('i2b', 'a') */
   /* search940_0_0 -> 32 in the cache */
   /* search940_0 -> 106 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      nir_search_op_i2b,
      -1, 0,
      { 106 },
      -1,
   } },

   /* replace940_0 -> 32 in the cache */
   /* replace940 -> 112 in the cache */

   /* ('inot', ('f2b1', 'a')) => ('feq', 'a', 0.0) */
   /* search941_0_0 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_f2b1,
      -1, 0,
      { 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      nir_op_inot,
      -1, 0,
      { 2796 },
      -1,
   } },

   /* replace941_0 -> 32 in the cache */
   /* replace941_1 -> 113 in the cache */
   /* replace941 -> 1199 in the cache */

   /* ('f2fmp', ('f2f32', 'a@16')) => a */
   /* search942_0_0 -> 11 in the cache */
   /* search942_0 -> 1730 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2fmp,
      -1, 0,
      { 1730 },
      -1,
   } },

   /* replace942 -> 11 in the cache */

   /* ('i2imp', ('i2i32', 'a@16')) => a */
   /* search943_0_0 -> 11 in the cache */
   /* search943_0 -> 1732 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2imp,
      -1, 0,
      { 1732 },
      -1,
   } },

   /* replace943 -> 11 in the cache */

   /* ('i2imp', ('u2u32', 'a@16')) => a */
   /* search944_0_0 -> 11 in the cache */
   /* search944_0 -> 1734 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2imp,
      -1, 0,
      { 1734 },
      -1,
   } },

   /* replace944 -> 11 in the cache */

   /* ('f2imp', ('f2f32', 'a@16')) => ('f2i16', 'a') */
   /* search945_0_0 -> 11 in the cache */
   /* search945_0 -> 1730 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2imp,
      -1, 0,
      { 1730 },
      -1,
   } },

   /* replace945_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2i16,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('f2ump', ('f2f32', 'a@16')) => ('f2u16', 'a') */
   /* search946_0_0 -> 11 in the cache */
   /* search946_0 -> 1730 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2ump,
      -1, 0,
      { 1730 },
      -1,
   } },

   /* replace946_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2u16,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('i2fmp', ('i2i32', 'a@16')) => ('i2f16', 'a') */
   /* search947_0_0 -> 11 in the cache */
   /* search947_0 -> 1732 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2fmp,
      -1, 0,
      { 1732 },
      -1,
   } },

   /* replace947_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2f16,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('u2fmp', ('u2u32', 'a@16')) => ('u2f16', 'a') */
   /* search948_0_0 -> 11 in the cache */
   /* search948_0 -> 1734 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2fmp,
      -1, 0,
      { 1734 },
      -1,
   } },

   /* replace948_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2f16,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('f2fmp', ('b2f32', 'a@1')) => ('b2f16', 'a') */
   /* search949_0_0 -> 706 in the cache */
   /* search949_0 -> 1337 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2fmp,
      -1, 0,
      { 1337 },
      -1,
   } },

   /* replace949_0 -> 706 in the cache */
   /* replace949 -> 1333 in the cache */

   /* ('i2imp', ('b2i32', 'a@1')) => ('b2i16', 'a') */
   /* search950_0_0 -> 706 in the cache */
   /* search950_0 -> 1325 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2imp,
      -1, 0,
      { 1325 },
      -1,
   } },

   /* replace950_0 -> 706 in the cache */
   /* replace950 -> 1321 in the cache */

   /* ('i2imp', ('b2i32', 'a@1')) => ('b2i16', 'a') */
   /* search951_0_0 -> 706 in the cache */
   /* search951_0 -> 1325 in the cache */
   /* search951 -> 2810 in the cache */

   /* replace951_0 -> 706 in the cache */
   /* replace951 -> 1321 in the cache */

   /* ('f2imp', ('b2f32', 'a@1')) => ('b2i16', 'a') */
   /* search952_0_0 -> 706 in the cache */
   /* search952_0 -> 1337 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2imp,
      -1, 0,
      { 1337 },
      -1,
   } },

   /* replace952_0 -> 706 in the cache */
   /* replace952 -> 1321 in the cache */

   /* ('f2ump', ('b2f32', 'a@1')) => ('b2i16', 'a') */
   /* search953_0_0 -> 706 in the cache */
   /* search953_0 -> 1337 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_f2ump,
      -1, 0,
      { 1337 },
      -1,
   } },

   /* replace953_0 -> 706 in the cache */
   /* replace953 -> 1321 in the cache */

   /* ('i2fmp', ('b2i32', 'a@1')) => ('b2f16', 'a') */
   /* search954_0_0 -> 706 in the cache */
   /* search954_0 -> 1325 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_i2fmp,
      -1, 0,
      { 1325 },
      -1,
   } },

   /* replace954_0 -> 706 in the cache */
   /* replace954 -> 1333 in the cache */

   /* ('u2fmp', ('b2i32', 'a@1')) => ('b2f16', 'a') */
   /* search955_0_0 -> 706 in the cache */
   /* search955_0 -> 1325 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      nir_op_u2fmp,
      -1, 0,
      { 1325 },
      -1,
   } },

   /* replace955_0 -> 706 in the cache */
   /* replace955 -> 1333 in the cache */

   /* ('f2f32', ('f2fmp', 'a@32')) => a */
   /* search956_0_0 -> 16 in the cache */
   /* search956_0 -> 1926 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 1926 },
      -1,
   } },

   /* replace956 -> 16 in the cache */

   /* ('i2i32', ('i2imp', 'a@32')) => a */
   /* search957_0_0 -> 16 in the cache */
   /* search957_0 -> 1937 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2i32,
      -1, 0,
      { 1937 },
      -1,
   } },

   /* replace957 -> 16 in the cache */

   /* ('u2u32', ('i2imp', 'a@32')) => a */
   /* search958_0_0 -> 16 in the cache */
   /* search958_0 -> 1937 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2u32,
      -1, 0,
      { 1937 },
      -1,
   } },

   /* replace958 -> 16 in the cache */

   /* ('i2i32', ('f2imp', 'a@32')) => ('f2i32', 'a') */
   /* search959_0_0 -> 16 in the cache */
   /* search959_0 -> 1936 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_i2i32,
      -1, 0,
      { 1936 },
      -1,
   } },

   /* replace959_0 -> 16 in the cache */
   /* replace959 -> 1934 in the cache */

   /* ('u2u32', ('f2ump', 'a@32')) => ('f2u32', 'a') */
   /* search960_0_0 -> 16 in the cache */
   /* search960_0 -> 1933 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_u2u32,
      -1, 0,
      { 1933 },
      -1,
   } },

   /* replace960_0 -> 16 in the cache */
   /* replace960 -> 1931 in the cache */

   /* ('f2f32', ('i2fmp', 'a@32')) => ('i2f32', 'a') */
   /* search961_0_0 -> 16 in the cache */
   /* search961_0 -> 1925 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      nir_op_f2f32,
      -1, 0,
      { 1925 },
      -1,
   } },

   /* replace961_0 -> 16 in the cache */
   /* replace961 -> 1923 in the cache */

   /* ('f2f32', ('u2fmp', 'a@32')) => ('u2f32', 'a') */
   /* search962_0_0 -> 16 in the cache */
   /* search962_0 -> 1922 in the cache */
   { .expression = {
      { nir