/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "org.freedesktop.NetworkManager.Device.Wireless.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.NetworkManager.Device.Wireless
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:NMDBusDeviceWifi
 * @title: NMDBusDeviceWifi
 * @short_description: Generated C code for the org.freedesktop.NetworkManager.Device.Wireless D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-NetworkManager-Device-Wireless.top_of_page">org.freedesktop.NetworkManager.Device.Wireless</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.NetworkManager.Device.Wireless ---- */

static const _ExtendedGDBusArgInfo _nmdbus_device_wifi_method_info_get_access_points_OUT_ARG_access_points =
{
  {
    -1,
    (gchar *) "access_points",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_device_wifi_method_info_get_access_points_OUT_ARG_pointers[] =
{
  &_nmdbus_device_wifi_method_info_get_access_points_OUT_ARG_access_points.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_device_wifi_method_info_get_access_points =
{
  {
    -1,
    (gchar *) "GetAccessPoints",
    NULL,
    (GDBusArgInfo **) &_nmdbus_device_wifi_method_info_get_access_points_OUT_ARG_pointers,
    NULL
  },
  "handle-get-access-points",
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_device_wifi_method_info_get_all_access_points_OUT_ARG_access_points =
{
  {
    -1,
    (gchar *) "access_points",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_device_wifi_method_info_get_all_access_points_OUT_ARG_pointers[] =
{
  &_nmdbus_device_wifi_method_info_get_all_access_points_OUT_ARG_access_points.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_device_wifi_method_info_get_all_access_points =
{
  {
    -1,
    (gchar *) "GetAllAccessPoints",
    NULL,
    (GDBusArgInfo **) &_nmdbus_device_wifi_method_info_get_all_access_points_OUT_ARG_pointers,
    NULL
  },
  "handle-get-all-access-points",
  FALSE
};

static const _ExtendedGDBusArgInfo _nmdbus_device_wifi_method_info_request_scan_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_device_wifi_method_info_request_scan_IN_ARG_pointers[] =
{
  &_nmdbus_device_wifi_method_info_request_scan_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _nmdbus_device_wifi_method_info_request_scan =
{
  {
    -1,
    (gchar *) "RequestScan",
    (GDBusArgInfo **) &_nmdbus_device_wifi_method_info_request_scan_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-request-scan",
  FALSE
};

static const GDBusMethodInfo * const _nmdbus_device_wifi_method_info_pointers[] =
{
  &_nmdbus_device_wifi_method_info_get_access_points.parent_struct,
  &_nmdbus_device_wifi_method_info_get_all_access_points.parent_struct,
  &_nmdbus_device_wifi_method_info_request_scan.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _nmdbus_device_wifi_signal_info_access_point_added_ARG_access_point =
{
  {
    -1,
    (gchar *) "access_point",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_device_wifi_signal_info_access_point_added_ARG_pointers[] =
{
  &_nmdbus_device_wifi_signal_info_access_point_added_ARG_access_point.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _nmdbus_device_wifi_signal_info_access_point_added =
{
  {
    -1,
    (gchar *) "AccessPointAdded",
    (GDBusArgInfo **) &_nmdbus_device_wifi_signal_info_access_point_added_ARG_pointers,
    NULL
  },
  "access-point-added"
};

static const _ExtendedGDBusArgInfo _nmdbus_device_wifi_signal_info_access_point_removed_ARG_access_point =
{
  {
    -1,
    (gchar *) "access_point",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _nmdbus_device_wifi_signal_info_access_point_removed_ARG_pointers[] =
{
  &_nmdbus_device_wifi_signal_info_access_point_removed_ARG_access_point.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _nmdbus_device_wifi_signal_info_access_point_removed =
{
  {
    -1,
    (gchar *) "AccessPointRemoved",
    (GDBusArgInfo **) &_nmdbus_device_wifi_signal_info_access_point_removed_ARG_pointers,
    NULL
  },
  "access-point-removed"
};

static const GDBusSignalInfo * const _nmdbus_device_wifi_signal_info_pointers[] =
{
  &_nmdbus_device_wifi_signal_info_access_point_added.parent_struct,
  &_nmdbus_device_wifi_signal_info_access_point_removed.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_wifi_property_info_hw_address =
{
  {
    -1,
    (gchar *) "HwAddress",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "hw-address",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_wifi_property_info_perm_hw_address =
{
  {
    -1,
    (gchar *) "PermHwAddress",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "perm-hw-address",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_wifi_property_info_mode =
{
  {
    -1,
    (gchar *) "Mode",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "mode",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_wifi_property_info_bitrate =
{
  {
    -1,
    (gchar *) "Bitrate",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "bitrate",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_wifi_property_info_access_points =
{
  {
    -1,
    (gchar *) "AccessPoints",
    (gchar *) "ao",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "access-points",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_wifi_property_info_active_access_point =
{
  {
    -1,
    (gchar *) "ActiveAccessPoint",
    (gchar *) "o",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "active-access-point",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_wifi_property_info_wireless_capabilities =
{
  {
    -1,
    (gchar *) "WirelessCapabilities",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "wireless-capabilities",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_device_wifi_property_info_last_scan =
{
  {
    -1,
    (gchar *) "LastScan",
    (gchar *) "x",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "last-scan",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _nmdbus_device_wifi_property_info_pointers[] =
{
  &_nmdbus_device_wifi_property_info_hw_address.parent_struct,
  &_nmdbus_device_wifi_property_info_perm_hw_address.parent_struct,
  &_nmdbus_device_wifi_property_info_mode.parent_struct,
  &_nmdbus_device_wifi_property_info_bitrate.parent_struct,
  &_nmdbus_device_wifi_property_info_access_points.parent_struct,
  &_nmdbus_device_wifi_property_info_active_access_point.parent_struct,
  &_nmdbus_device_wifi_property_info_wireless_capabilities.parent_struct,
  &_nmdbus_device_wifi_property_info_last_scan.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _nmdbus_device_wifi_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.NetworkManager.Device.Wireless",
    (GDBusMethodInfo **) &_nmdbus_device_wifi_method_info_pointers,
    (GDBusSignalInfo **) &_nmdbus_device_wifi_signal_info_pointers,
    (GDBusPropertyInfo **) &_nmdbus_device_wifi_property_info_pointers,
    NULL
  },
  "device-wifi",
};


/**
 * nmdbus_device_wifi_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-NetworkManager-Device-Wireless.top_of_page">org.freedesktop.NetworkManager.Device.Wireless</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
nmdbus_device_wifi_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_nmdbus_device_wifi_interface_info.parent_struct;
}

/**
 * nmdbus_device_wifi_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #NMDBusDeviceWifi interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
nmdbus_device_wifi_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "hw-address");
  g_object_class_override_property (klass, property_id_begin++, "perm-hw-address");
  g_object_class_override_property (klass, property_id_begin++, "mode");
  g_object_class_override_property (klass, property_id_begin++, "bitrate");
  g_object_class_override_property (klass, property_id_begin++, "access-points");
  g_object_class_override_property (klass, property_id_begin++, "active-access-point");
  g_object_class_override_property (klass, property_id_begin++, "wireless-capabilities");
  g_object_class_override_property (klass, property_id_begin++, "last-scan");
  return property_id_begin - 1;
}



/**
 * NMDBusDeviceWifi:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager-Device-Wireless.top_of_page">org.freedesktop.NetworkManager.Device.Wireless</link>.
 */

/**
 * NMDBusDeviceWifiIface:
 * @parent_iface: The parent interface.
 * @handle_get_access_points: Handler for the #NMDBusDeviceWifi::handle-get-access-points signal.
 * @handle_get_all_access_points: Handler for the #NMDBusDeviceWifi::handle-get-all-access-points signal.
 * @handle_request_scan: Handler for the #NMDBusDeviceWifi::handle-request-scan signal.
 * @get_access_points: Getter for the #NMDBusDeviceWifi:access-points property.
 * @get_active_access_point: Getter for the #NMDBusDeviceWifi:active-access-point property.
 * @get_bitrate: Getter for the #NMDBusDeviceWifi:bitrate property.
 * @get_hw_address: Getter for the #NMDBusDeviceWifi:hw-address property.
 * @get_last_scan: Getter for the #NMDBusDeviceWifi:last-scan property.
 * @get_mode: Getter for the #NMDBusDeviceWifi:mode property.
 * @get_perm_hw_address: Getter for the #NMDBusDeviceWifi:perm-hw-address property.
 * @get_wireless_capabilities: Getter for the #NMDBusDeviceWifi:wireless-capabilities property.
 * @access_point_added: Handler for the #NMDBusDeviceWifi::access-point-added signal.
 * @access_point_removed: Handler for the #NMDBusDeviceWifi::access-point-removed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager-Device-Wireless.top_of_page">org.freedesktop.NetworkManager.Device.Wireless</link>.
 */

typedef NMDBusDeviceWifiIface NMDBusDeviceWifiInterface;
G_DEFINE_INTERFACE (NMDBusDeviceWifi, nmdbus_device_wifi, G_TYPE_OBJECT)

static void
nmdbus_device_wifi_default_init (NMDBusDeviceWifiIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * NMDBusDeviceWifi::handle-get-access-points:
   * @object: A #NMDBusDeviceWifi.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Device-Wireless.GetAccessPoints">GetAccessPoints()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_device_wifi_complete_get_access_points() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-access-points",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusDeviceWifiIface, handle_get_access_points),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * NMDBusDeviceWifi::handle-get-all-access-points:
   * @object: A #NMDBusDeviceWifi.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Device-Wireless.GetAllAccessPoints">GetAllAccessPoints()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_device_wifi_complete_get_all_access_points() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-all-access-points",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusDeviceWifiIface, handle_get_all_access_points),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * NMDBusDeviceWifi::handle-request-scan:
   * @object: A #NMDBusDeviceWifi.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Device-Wireless.RequestScan">RequestScan()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call nmdbus_device_wifi_complete_request_scan() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-request-scan",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusDeviceWifiIface, handle_request_scan),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /* GObject signals for received D-Bus signals: */
  /**
   * NMDBusDeviceWifi::access-point-added:
   * @object: A #NMDBusDeviceWifi.
   * @arg_access_point: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-NetworkManager-Device-Wireless.AccessPointAdded">"AccessPointAdded"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("access-point-added",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusDeviceWifiIface, access_point_added),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_STRING);

  /**
   * NMDBusDeviceWifi::access-point-removed:
   * @object: A #NMDBusDeviceWifi.
   * @arg_access_point: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-NetworkManager-Device-Wireless.AccessPointRemoved">"AccessPointRemoved"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("access-point-removed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (NMDBusDeviceWifiIface, access_point_removed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_STRING);

  /* GObject properties for D-Bus properties: */
  /**
   * NMDBusDeviceWifi:hw-address:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-Wireless.HwAddress">"HwAddress"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("hw-address", "HwAddress", "HwAddress", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDeviceWifi:perm-hw-address:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-Wireless.PermHwAddress">"PermHwAddress"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("perm-hw-address", "PermHwAddress", "PermHwAddress", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDeviceWifi:mode:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-Wireless.Mode">"Mode"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("mode", "Mode", "Mode", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDeviceWifi:bitrate:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-Wireless.Bitrate">"Bitrate"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("bitrate", "Bitrate", "Bitrate", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDeviceWifi:access-points:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-Wireless.AccessPoints">"AccessPoints"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("access-points", "AccessPoints", "AccessPoints", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDeviceWifi:active-access-point:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-Wireless.ActiveAccessPoint">"ActiveAccessPoint"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("active-access-point", "ActiveAccessPoint", "ActiveAccessPoint", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDeviceWifi:wireless-capabilities:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-Wireless.WirelessCapabilities">"WirelessCapabilities"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("wireless-capabilities", "WirelessCapabilities", "WirelessCapabilities", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusDeviceWifi:last-scan:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-Wireless.LastScan">"LastScan"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int64 ("last-scan", "LastScan", "LastScan", G_MININT64, G_MAXINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * nmdbus_device_wifi_get_hw_address: (skip)
 * @object: A #NMDBusDeviceWifi.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-Wireless.HwAddress">"HwAddress"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_device_wifi_dup_hw_address() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
nmdbus_device_wifi_get_hw_address (NMDBusDeviceWifi *object)
{
  return NMDBUS_DEVICE_WIFI_GET_IFACE (object)->get_hw_address (object);
}

/**
 * nmdbus_device_wifi_dup_hw_address: (skip)
 * @object: A #NMDBusDeviceWifi.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-Wireless.HwAddress">"HwAddress"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
nmdbus_device_wifi_dup_hw_address (NMDBusDeviceWifi *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "hw-address", &value, NULL);
  return value;
}

/**
 * nmdbus_device_wifi_set_hw_address: (skip)
 * @object: A #NMDBusDeviceWifi.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-Wireless.HwAddress">"HwAddress"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_wifi_set_hw_address (NMDBusDeviceWifi *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "hw-address", value, NULL);
}

/**
 * nmdbus_device_wifi_get_perm_hw_address: (skip)
 * @object: A #NMDBusDeviceWifi.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-Wireless.PermHwAddress">"PermHwAddress"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_device_wifi_dup_perm_hw_address() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
nmdbus_device_wifi_get_perm_hw_address (NMDBusDeviceWifi *object)
{
  return NMDBUS_DEVICE_WIFI_GET_IFACE (object)->get_perm_hw_address (object);
}

/**
 * nmdbus_device_wifi_dup_perm_hw_address: (skip)
 * @object: A #NMDBusDeviceWifi.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-Wireless.PermHwAddress">"PermHwAddress"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
nmdbus_device_wifi_dup_perm_hw_address (NMDBusDeviceWifi *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "perm-hw-address", &value, NULL);
  return value;
}

/**
 * nmdbus_device_wifi_set_perm_hw_address: (skip)
 * @object: A #NMDBusDeviceWifi.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-Wireless.PermHwAddress">"PermHwAddress"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_wifi_set_perm_hw_address (NMDBusDeviceWifi *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "perm-hw-address", value, NULL);
}

/**
 * nmdbus_device_wifi_get_mode: (skip)
 * @object: A #NMDBusDeviceWifi.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-Wireless.Mode">"Mode"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
nmdbus_device_wifi_get_mode (NMDBusDeviceWifi *object)
{
  return NMDBUS_DEVICE_WIFI_GET_IFACE (object)->get_mode (object);
}

/**
 * nmdbus_device_wifi_set_mode: (skip)
 * @object: A #NMDBusDeviceWifi.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-Wireless.Mode">"Mode"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_wifi_set_mode (NMDBusDeviceWifi *object, guint value)
{
  g_object_set (G_OBJECT (object), "mode", value, NULL);
}

/**
 * nmdbus_device_wifi_get_bitrate: (skip)
 * @object: A #NMDBusDeviceWifi.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-Wireless.Bitrate">"Bitrate"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
nmdbus_device_wifi_get_bitrate (NMDBusDeviceWifi *object)
{
  return NMDBUS_DEVICE_WIFI_GET_IFACE (object)->get_bitrate (object);
}

/**
 * nmdbus_device_wifi_set_bitrate: (skip)
 * @object: A #NMDBusDeviceWifi.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-Wireless.Bitrate">"Bitrate"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_wifi_set_bitrate (NMDBusDeviceWifi *object, guint value)
{
  g_object_set (G_OBJECT (object), "bitrate", value, NULL);
}

/**
 * nmdbus_device_wifi_get_access_points: (skip)
 * @object: A #NMDBusDeviceWifi.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-Wireless.AccessPoints">"AccessPoints"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_device_wifi_dup_access_points() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
nmdbus_device_wifi_get_access_points (NMDBusDeviceWifi *object)
{
  return NMDBUS_DEVICE_WIFI_GET_IFACE (object)->get_access_points (object);
}

/**
 * nmdbus_device_wifi_dup_access_points: (skip)
 * @object: A #NMDBusDeviceWifi.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-Wireless.AccessPoints">"AccessPoints"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
nmdbus_device_wifi_dup_access_points (NMDBusDeviceWifi *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "access-points", &value, NULL);
  return value;
}

/**
 * nmdbus_device_wifi_set_access_points: (skip)
 * @object: A #NMDBusDeviceWifi.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-Wireless.AccessPoints">"AccessPoints"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_wifi_set_access_points (NMDBusDeviceWifi *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "access-points", value, NULL);
}

/**
 * nmdbus_device_wifi_get_active_access_point: (skip)
 * @object: A #NMDBusDeviceWifi.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-Wireless.ActiveAccessPoint">"ActiveAccessPoint"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_device_wifi_dup_active_access_point() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
nmdbus_device_wifi_get_active_access_point (NMDBusDeviceWifi *object)
{
  return NMDBUS_DEVICE_WIFI_GET_IFACE (object)->get_active_access_point (object);
}

/**
 * nmdbus_device_wifi_dup_active_access_point: (skip)
 * @object: A #NMDBusDeviceWifi.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-Wireless.ActiveAccessPoint">"ActiveAccessPoint"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
nmdbus_device_wifi_dup_active_access_point (NMDBusDeviceWifi *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "active-access-point", &value, NULL);
  return value;
}

/**
 * nmdbus_device_wifi_set_active_access_point: (skip)
 * @object: A #NMDBusDeviceWifi.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-Wireless.ActiveAccessPoint">"ActiveAccessPoint"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_wifi_set_active_access_point (NMDBusDeviceWifi *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "active-access-point", value, NULL);
}

/**
 * nmdbus_device_wifi_get_wireless_capabilities: (skip)
 * @object: A #NMDBusDeviceWifi.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-Wireless.WirelessCapabilities">"WirelessCapabilities"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
nmdbus_device_wifi_get_wireless_capabilities (NMDBusDeviceWifi *object)
{
  return NMDBUS_DEVICE_WIFI_GET_IFACE (object)->get_wireless_capabilities (object);
}

/**
 * nmdbus_device_wifi_set_wireless_capabilities: (skip)
 * @object: A #NMDBusDeviceWifi.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-Wireless.WirelessCapabilities">"WirelessCapabilities"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_wifi_set_wireless_capabilities (NMDBusDeviceWifi *object, guint value)
{
  g_object_set (G_OBJECT (object), "wireless-capabilities", value, NULL);
}

/**
 * nmdbus_device_wifi_get_last_scan: (skip)
 * @object: A #NMDBusDeviceWifi.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-Wireless.LastScan">"LastScan"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint64 
nmdbus_device_wifi_get_last_scan (NMDBusDeviceWifi *object)
{
  return NMDBUS_DEVICE_WIFI_GET_IFACE (object)->get_last_scan (object);
}

/**
 * nmdbus_device_wifi_set_last_scan: (skip)
 * @object: A #NMDBusDeviceWifi.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-Device-Wireless.LastScan">"LastScan"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_device_wifi_set_last_scan (NMDBusDeviceWifi *object, gint64 value)
{
  g_object_set (G_OBJECT (object), "last-scan", value, NULL);
}

/**
 * nmdbus_device_wifi_emit_access_point_added:
 * @object: A #NMDBusDeviceWifi.
 * @arg_access_point: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-NetworkManager-Device-Wireless.AccessPointAdded">"AccessPointAdded"</link> D-Bus signal.
 */
void
nmdbus_device_wifi_emit_access_point_added (
    NMDBusDeviceWifi *object,
    const gchar *arg_access_point)
{
  g_signal_emit_by_name (object, "access-point-added", arg_access_point);
}

/**
 * nmdbus_device_wifi_emit_access_point_removed:
 * @object: A #NMDBusDeviceWifi.
 * @arg_access_point: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-NetworkManager-Device-Wireless.AccessPointRemoved">"AccessPointRemoved"</link> D-Bus signal.
 */
void
nmdbus_device_wifi_emit_access_point_removed (
    NMDBusDeviceWifi *object,
    const gchar *arg_access_point)
{
  g_signal_emit_by_name (object, "access-point-removed", arg_access_point);
}

/**
 * nmdbus_device_wifi_call_get_access_points:
 * @proxy: A #NMDBusDeviceWifiProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Device-Wireless.GetAccessPoints">GetAccessPoints()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_device_wifi_call_get_access_points_finish() to get the result of the operation.
 *
 * See nmdbus_device_wifi_call_get_access_points_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_device_wifi_call_get_access_points (
    NMDBusDeviceWifi *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetAccessPoints",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_device_wifi_call_get_access_points_finish:
 * @proxy: A #NMDBusDeviceWifiProxy.
 * @out_access_points: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_device_wifi_call_get_access_points().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_device_wifi_call_get_access_points().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_device_wifi_call_get_access_points_finish (
    NMDBusDeviceWifi *proxy,
    gchar ***out_access_points,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_access_points);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_device_wifi_call_get_access_points_sync:
 * @proxy: A #NMDBusDeviceWifiProxy.
 * @out_access_points: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Device-Wireless.GetAccessPoints">GetAccessPoints()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_device_wifi_call_get_access_points() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_device_wifi_call_get_access_points_sync (
    NMDBusDeviceWifi *proxy,
    gchar ***out_access_points,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetAccessPoints",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_access_points);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_device_wifi_call_get_all_access_points:
 * @proxy: A #NMDBusDeviceWifiProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Device-Wireless.GetAllAccessPoints">GetAllAccessPoints()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_device_wifi_call_get_all_access_points_finish() to get the result of the operation.
 *
 * See nmdbus_device_wifi_call_get_all_access_points_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_device_wifi_call_get_all_access_points (
    NMDBusDeviceWifi *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetAllAccessPoints",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_device_wifi_call_get_all_access_points_finish:
 * @proxy: A #NMDBusDeviceWifiProxy.
 * @out_access_points: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_device_wifi_call_get_all_access_points().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_device_wifi_call_get_all_access_points().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_device_wifi_call_get_all_access_points_finish (
    NMDBusDeviceWifi *proxy,
    gchar ***out_access_points,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_access_points);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_device_wifi_call_get_all_access_points_sync:
 * @proxy: A #NMDBusDeviceWifiProxy.
 * @out_access_points: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Device-Wireless.GetAllAccessPoints">GetAllAccessPoints()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_device_wifi_call_get_all_access_points() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_device_wifi_call_get_all_access_points_sync (
    NMDBusDeviceWifi *proxy,
    gchar ***out_access_points,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetAllAccessPoints",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_access_points);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_device_wifi_call_request_scan:
 * @proxy: A #NMDBusDeviceWifiProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Device-Wireless.RequestScan">RequestScan()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_device_wifi_call_request_scan_finish() to get the result of the operation.
 *
 * See nmdbus_device_wifi_call_request_scan_sync() for the synchronous, blocking version of this method.
 */
void
nmdbus_device_wifi_call_request_scan (
    NMDBusDeviceWifi *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RequestScan",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * nmdbus_device_wifi_call_request_scan_finish:
 * @proxy: A #NMDBusDeviceWifiProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_device_wifi_call_request_scan().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with nmdbus_device_wifi_call_request_scan().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_device_wifi_call_request_scan_finish (
    NMDBusDeviceWifi *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_device_wifi_call_request_scan_sync:
 * @proxy: A #NMDBusDeviceWifiProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Device-Wireless.RequestScan">RequestScan()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See nmdbus_device_wifi_call_request_scan() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
nmdbus_device_wifi_call_request_scan_sync (
    NMDBusDeviceWifi *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RequestScan",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * nmdbus_device_wifi_complete_get_access_points:
 * @object: A #NMDBusDeviceWifi.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @access_points: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Device-Wireless.GetAccessPoints">GetAccessPoints()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_device_wifi_complete_get_access_points (
    NMDBusDeviceWifi *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *access_points)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^ao)",
                   access_points));
}

/**
 * nmdbus_device_wifi_complete_get_all_access_points:
 * @object: A #NMDBusDeviceWifi.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @access_points: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Device-Wireless.GetAllAccessPoints">GetAllAccessPoints()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_device_wifi_complete_get_all_access_points (
    NMDBusDeviceWifi *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *access_points)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^ao)",
                   access_points));
}

/**
 * nmdbus_device_wifi_complete_request_scan:
 * @object: A #NMDBusDeviceWifi.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-NetworkManager-Device-Wireless.RequestScan">RequestScan()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
nmdbus_device_wifi_complete_request_scan (
    NMDBusDeviceWifi *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * NMDBusDeviceWifiProxy:
 *
 * The #NMDBusDeviceWifiProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NMDBusDeviceWifiProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NMDBusDeviceWifiProxy.
 */

struct _NMDBusDeviceWifiProxyPrivate
{
  GData *qdata;
};

static void nmdbus_device_wifi_proxy_iface_init (NMDBusDeviceWifiIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (NMDBusDeviceWifiProxy, nmdbus_device_wifi_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (NMDBusDeviceWifiProxy)
                         G_IMPLEMENT_INTERFACE (NMDBUS_TYPE_DEVICE_WIFI, nmdbus_device_wifi_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (NMDBusDeviceWifiProxy, nmdbus_device_wifi_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (NMDBUS_TYPE_DEVICE_WIFI, nmdbus_device_wifi_proxy_iface_init))

#endif
static void
nmdbus_device_wifi_proxy_finalize (GObject *object)
{
  NMDBusDeviceWifiProxy *proxy = NMDBUS_DEVICE_WIFI_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (nmdbus_device_wifi_proxy_parent_class)->finalize (object);
}

static void
nmdbus_device_wifi_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 8);
  info = (const _ExtendedGDBusPropertyInfo *) _nmdbus_device_wifi_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
nmdbus_device_wifi_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.NetworkManager.Device.Wireless: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
nmdbus_device_wifi_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 8);
  info = (const _ExtendedGDBusPropertyInfo *) _nmdbus_device_wifi_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.NetworkManager.Device.Wireless", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) nmdbus_device_wifi_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
nmdbus_device_wifi_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_nmdbus_device_wifi_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], NMDBUS_TYPE_DEVICE_WIFI);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, NMDBUS_TYPE_DEVICE_WIFI);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
nmdbus_device_wifi_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  NMDBusDeviceWifiProxy *proxy = NMDBUS_DEVICE_WIFI_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nmdbus_device_wifi_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nmdbus_device_wifi_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
nmdbus_device_wifi_proxy_get_hw_address (NMDBusDeviceWifi *object)
{
  NMDBusDeviceWifiProxy *proxy = NMDBUS_DEVICE_WIFI_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "HwAddress");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
nmdbus_device_wifi_proxy_get_perm_hw_address (NMDBusDeviceWifi *object)
{
  NMDBusDeviceWifiProxy *proxy = NMDBUS_DEVICE_WIFI_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "PermHwAddress");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
nmdbus_device_wifi_proxy_get_mode (NMDBusDeviceWifi *object)
{
  NMDBusDeviceWifiProxy *proxy = NMDBUS_DEVICE_WIFI_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Mode");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
nmdbus_device_wifi_proxy_get_bitrate (NMDBusDeviceWifi *object)
{
  NMDBusDeviceWifiProxy *proxy = NMDBUS_DEVICE_WIFI_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Bitrate");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
nmdbus_device_wifi_proxy_get_access_points (NMDBusDeviceWifi *object)
{
  NMDBusDeviceWifiProxy *proxy = NMDBUS_DEVICE_WIFI_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "AccessPoints");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "AccessPoints");
  if (variant != NULL)
    {
      value = g_variant_get_objv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "AccessPoints", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
nmdbus_device_wifi_proxy_get_active_access_point (NMDBusDeviceWifi *object)
{
  NMDBusDeviceWifiProxy *proxy = NMDBUS_DEVICE_WIFI_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ActiveAccessPoint");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
nmdbus_device_wifi_proxy_get_wireless_capabilities (NMDBusDeviceWifi *object)
{
  NMDBusDeviceWifiProxy *proxy = NMDBUS_DEVICE_WIFI_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "WirelessCapabilities");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gint64 
nmdbus_device_wifi_proxy_get_last_scan (NMDBusDeviceWifi *object)
{
  NMDBusDeviceWifiProxy *proxy = NMDBUS_DEVICE_WIFI_PROXY (object);
  GVariant *variant;
  gint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "LastScan");
  if (variant != NULL)
    {
      value = g_variant_get_int64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
nmdbus_device_wifi_proxy_init (NMDBusDeviceWifiProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = nmdbus_device_wifi_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, NMDBUS_TYPE_DEVICE_WIFI_PROXY, NMDBusDeviceWifiProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), nmdbus_device_wifi_interface_info ());
}

static void
nmdbus_device_wifi_proxy_class_init (NMDBusDeviceWifiProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = nmdbus_device_wifi_proxy_finalize;
  gobject_class->get_property = nmdbus_device_wifi_proxy_get_property;
  gobject_class->set_property = nmdbus_device_wifi_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = nmdbus_device_wifi_proxy_g_signal;
  proxy_class->g_properties_changed = nmdbus_device_wifi_proxy_g_properties_changed;

  nmdbus_device_wifi_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (NMDBusDeviceWifiProxyPrivate));
#endif
}

static void
nmdbus_device_wifi_proxy_iface_init (NMDBusDeviceWifiIface *iface)
{
  iface->get_hw_address = nmdbus_device_wifi_proxy_get_hw_address;
  iface->get_perm_hw_address = nmdbus_device_wifi_proxy_get_perm_hw_address;
  iface->get_mode = nmdbus_device_wifi_proxy_get_mode;
  iface->get_bitrate = nmdbus_device_wifi_proxy_get_bitrate;
  iface->get_access_points = nmdbus_device_wifi_proxy_get_access_points;
  iface->get_active_access_point = nmdbus_device_wifi_proxy_get_active_access_point;
  iface->get_wireless_capabilities = nmdbus_device_wifi_proxy_get_wireless_capabilities;
  iface->get_last_scan = nmdbus_device_wifi_proxy_get_last_scan;
}

/**
 * nmdbus_device_wifi_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager-Device-Wireless.top_of_page">org.freedesktop.NetworkManager.Device.Wireless</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_device_wifi_proxy_new_finish() to get the result of the operation.
 *
 * See nmdbus_device_wifi_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
nmdbus_device_wifi_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (NMDBUS_TYPE_DEVICE_WIFI_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.NetworkManager.Device.Wireless", NULL);
}

/**
 * nmdbus_device_wifi_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_device_wifi_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with nmdbus_device_wifi_proxy_new().
 *
 * Returns: (transfer full) (type NMDBusDeviceWifiProxy): The constructed proxy object or %NULL if @error is set.
 */
NMDBusDeviceWifi *
nmdbus_device_wifi_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return NMDBUS_DEVICE_WIFI (ret);
  else
    return NULL;
}

/**
 * nmdbus_device_wifi_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager-Device-Wireless.top_of_page">org.freedesktop.NetworkManager.Device.Wireless</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See nmdbus_device_wifi_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NMDBusDeviceWifiProxy): The constructed proxy object or %NULL if @error is set.
 */
NMDBusDeviceWifi *
nmdbus_device_wifi_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (NMDBUS_TYPE_DEVICE_WIFI_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.NetworkManager.Device.Wireless", NULL);
  if (ret != NULL)
    return NMDBUS_DEVICE_WIFI (ret);
  else
    return NULL;
}


/**
 * nmdbus_device_wifi_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like nmdbus_device_wifi_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_device_wifi_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See nmdbus_device_wifi_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
nmdbus_device_wifi_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (NMDBUS_TYPE_DEVICE_WIFI_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.NetworkManager.Device.Wireless", NULL);
}

/**
 * nmdbus_device_wifi_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_device_wifi_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with nmdbus_device_wifi_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type NMDBusDeviceWifiProxy): The constructed proxy object or %NULL if @error is set.
 */
NMDBusDeviceWifi *
nmdbus_device_wifi_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return NMDBUS_DEVICE_WIFI (ret);
  else
    return NULL;
}

/**
 * nmdbus_device_wifi_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like nmdbus_device_wifi_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See nmdbus_device_wifi_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NMDBusDeviceWifiProxy): The constructed proxy object or %NULL if @error is set.
 */
NMDBusDeviceWifi *
nmdbus_device_wifi_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (NMDBUS_TYPE_DEVICE_WIFI_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.NetworkManager.Device.Wireless", NULL);
  if (ret != NULL)
    return NMDBUS_DEVICE_WIFI (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * NMDBusDeviceWifiSkeleton:
 *
 * The #NMDBusDeviceWifiSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NMDBusDeviceWifiSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NMDBusDeviceWifiSkeleton.
 */

struct _NMDBusDeviceWifiSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_nmdbus_device_wifi_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  NMDBusDeviceWifiSkeleton *skeleton = NMDBUS_DEVICE_WIFI_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], NMDBUS_TYPE_DEVICE_WIFI);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, NMDBUS_TYPE_DEVICE_WIFI);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_nmdbus_device_wifi_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  NMDBusDeviceWifiSkeleton *skeleton = NMDBUS_DEVICE_WIFI_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nmdbus_device_wifi_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_nmdbus_device_wifi_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  NMDBusDeviceWifiSkeleton *skeleton = NMDBUS_DEVICE_WIFI_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nmdbus_device_wifi_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _nmdbus_device_wifi_skeleton_vtable =
{
  _nmdbus_device_wifi_skeleton_handle_method_call,
  _nmdbus_device_wifi_skeleton_handle_get_property,
  _nmdbus_device_wifi_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
nmdbus_device_wifi_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return nmdbus_device_wifi_interface_info ();
}

static GDBusInterfaceVTable *
nmdbus_device_wifi_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_nmdbus_device_wifi_skeleton_vtable;
}

static GVariant *
nmdbus_device_wifi_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  NMDBusDeviceWifiSkeleton *skeleton = NMDBUS_DEVICE_WIFI_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_nmdbus_device_wifi_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _nmdbus_device_wifi_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _nmdbus_device_wifi_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _nmdbus_device_wifi_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.NetworkManager.Device.Wireless", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _nmdbus_device_wifi_emit_changed (gpointer user_data);

static void
nmdbus_device_wifi_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  NMDBusDeviceWifiSkeleton *skeleton = NMDBUS_DEVICE_WIFI_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _nmdbus_device_wifi_emit_changed (skeleton);
}

static void
_nmdbus_device_wifi_on_signal_access_point_added (
    NMDBusDeviceWifi *object,
    const gchar *arg_access_point)
{
  NMDBusDeviceWifiSkeleton *skeleton = NMDBUS_DEVICE_WIFI_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o)",
                   arg_access_point));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.NetworkManager.Device.Wireless", "AccessPointAdded",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_nmdbus_device_wifi_on_signal_access_point_removed (
    NMDBusDeviceWifi *object,
    const gchar *arg_access_point)
{
  NMDBusDeviceWifiSkeleton *skeleton = NMDBUS_DEVICE_WIFI_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o)",
                   arg_access_point));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.NetworkManager.Device.Wireless", "AccessPointRemoved",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void nmdbus_device_wifi_skeleton_iface_init (NMDBusDeviceWifiIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (NMDBusDeviceWifiSkeleton, nmdbus_device_wifi_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (NMDBusDeviceWifiSkeleton)
                         G_IMPLEMENT_INTERFACE (NMDBUS_TYPE_DEVICE_WIFI, nmdbus_device_wifi_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (NMDBusDeviceWifiSkeleton, nmdbus_device_wifi_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (NMDBUS_TYPE_DEVICE_WIFI, nmdbus_device_wifi_skeleton_iface_init))

#endif
static void
nmdbus_device_wifi_skeleton_finalize (GObject *object)
{
  NMDBusDeviceWifiSkeleton *skeleton = NMDBUS_DEVICE_WIFI_SKELETON (object);
  guint n;
  for (n = 0; n < 8; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (nmdbus_device_wifi_skeleton_parent_class)->finalize (object);
}

static void
nmdbus_device_wifi_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  NMDBusDeviceWifiSkeleton *skeleton = NMDBUS_DEVICE_WIFI_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 8);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_nmdbus_device_wifi_emit_changed (gpointer user_data)
{
  NMDBusDeviceWifiSkeleton *skeleton = NMDBUS_DEVICE_WIFI_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.NetworkManager.Device.Wireless",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_nmdbus_device_wifi_schedule_emit_changed (NMDBusDeviceWifiSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
nmdbus_device_wifi_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  NMDBusDeviceWifiSkeleton *skeleton = NMDBUS_DEVICE_WIFI_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _nmdbus_device_wifi_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _nmdbus_device_wifi_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
nmdbus_device_wifi_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  NMDBusDeviceWifiSkeleton *skeleton = NMDBUS_DEVICE_WIFI_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 8);
  info = (const _ExtendedGDBusPropertyInfo *) _nmdbus_device_wifi_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _nmdbus_device_wifi_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
nmdbus_device_wifi_skeleton_init (NMDBusDeviceWifiSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = nmdbus_device_wifi_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, NMDBUS_TYPE_DEVICE_WIFI_SKELETON, NMDBusDeviceWifiSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 8);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_INT64);
}

static const gchar *
nmdbus_device_wifi_skeleton_get_hw_address (NMDBusDeviceWifi *object)
{
  NMDBusDeviceWifiSkeleton *skeleton = NMDBUS_DEVICE_WIFI_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
nmdbus_device_wifi_skeleton_get_perm_hw_address (NMDBusDeviceWifi *object)
{
  NMDBusDeviceWifiSkeleton *skeleton = NMDBUS_DEVICE_WIFI_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
nmdbus_device_wifi_skeleton_get_mode (NMDBusDeviceWifi *object)
{
  NMDBusDeviceWifiSkeleton *skeleton = NMDBUS_DEVICE_WIFI_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
nmdbus_device_wifi_skeleton_get_bitrate (NMDBusDeviceWifi *object)
{
  NMDBusDeviceWifiSkeleton *skeleton = NMDBUS_DEVICE_WIFI_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
nmdbus_device_wifi_skeleton_get_access_points (NMDBusDeviceWifi *object)
{
  NMDBusDeviceWifiSkeleton *skeleton = NMDBUS_DEVICE_WIFI_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
nmdbus_device_wifi_skeleton_get_active_access_point (NMDBusDeviceWifi *object)
{
  NMDBusDeviceWifiSkeleton *skeleton = NMDBUS_DEVICE_WIFI_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
nmdbus_device_wifi_skeleton_get_wireless_capabilities (NMDBusDeviceWifi *object)
{
  NMDBusDeviceWifiSkeleton *skeleton = NMDBUS_DEVICE_WIFI_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint64 
nmdbus_device_wifi_skeleton_get_last_scan (NMDBusDeviceWifi *object)
{
  NMDBusDeviceWifiSkeleton *skeleton = NMDBUS_DEVICE_WIFI_SKELETON (object);
  gint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_int64 (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
nmdbus_device_wifi_skeleton_class_init (NMDBusDeviceWifiSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = nmdbus_device_wifi_skeleton_finalize;
  gobject_class->get_property = nmdbus_device_wifi_skeleton_get_property;
  gobject_class->set_property = nmdbus_device_wifi_skeleton_set_property;
  gobject_class->notify       = nmdbus_device_wifi_skeleton_notify;


  nmdbus_device_wifi_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = nmdbus_device_wifi_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = nmdbus_device_wifi_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = nmdbus_device_wifi_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = nmdbus_device_wifi_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (NMDBusDeviceWifiSkeletonPrivate));
#endif
}

static void
nmdbus_device_wifi_skeleton_iface_init (NMDBusDeviceWifiIface *iface)
{
  iface->access_point_added = _nmdbus_device_wifi_on_signal_access_point_added;
  iface->access_point_removed = _nmdbus_device_wifi_on_signal_access_point_removed;
  iface->get_hw_address = nmdbus_device_wifi_skeleton_get_hw_address;
  iface->get_perm_hw_address = nmdbus_device_wifi_skeleton_get_perm_hw_address;
  iface->get_mode = nmdbus_device_wifi_skeleton_get_mode;
  iface->get_bitrate = nmdbus_device_wifi_skeleton_get_bitrate;
  iface->get_access_points = nmdbus_device_wifi_skeleton_get_access_points;
  iface->get_active_access_point = nmdbus_device_wifi_skeleton_get_active_access_point;
  iface->get_wireless_capabilities = nmdbus_device_wifi_skeleton_get_wireless_capabilities;
  iface->get_last_scan = nmdbus_device_wifi_skeleton_get_last_scan;
}

/**
 * nmdbus_device_wifi_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager-Device-Wireless.top_of_page">org.freedesktop.NetworkManager.Device.Wireless</link>.
 *
 * Returns: (transfer full) (type NMDBusDeviceWifiSkeleton): The skeleton object.
 */
NMDBusDeviceWifi *
nmdbus_device_wifi_skeleton_new (void)
{
  return NMDBUS_DEVICE_WIFI (g_object_new (NMDBUS_TYPE_DEVICE_WIFI_SKELETON, NULL));
}

