/* MenuDaemon.c generated by valac 0.56.0, the Vala compiler
 * generated from MenuDaemon.vala, do not modify */

/**/
/*  Copyright 2018-2020 elementary, Inc. (https://elementary.io)*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include "gala.h"
#include <granite.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>

#define GALA_DBUS_NAME "org.pantheon.gala"
#define GALA_DBUS_OBJECT_PATH "/org/pantheon/gala"
#define GALA_DAEMON_DBUS_NAME "org.pantheon.gala.daemon"
#define GALA_DAEMON_DBUS_OBJECT_PATH "/org/pantheon/gala/daemon"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_WMD_BUS (gala_wmd_bus_get_type ())
#define GALA_WMD_BUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WMD_BUS, GalaWMDBus))
#define GALA_IS_WMD_BUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WMD_BUS))
#define GALA_WMD_BUS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_TYPE_WMD_BUS, GalaWMDBusIface))

typedef struct _GalaWMDBus GalaWMDBus;
typedef struct _GalaWMDBusIface GalaWMDBusIface;

#define GALA_TYPE_WMD_BUS_PROXY (gala_wmd_bus_proxy_get_type ())
typedef GDBusProxy GalaWMDBusProxy;
typedef GDBusProxyClass GalaWMDBusProxyClass;

#define GALA_TYPE_MENU_DAEMON (gala_menu_daemon_get_type ())
#define GALA_MENU_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_MENU_DAEMON, GalaMenuDaemon))
#define GALA_MENU_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_MENU_DAEMON, GalaMenuDaemonClass))
#define GALA_IS_MENU_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_MENU_DAEMON))
#define GALA_IS_MENU_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_MENU_DAEMON))
#define GALA_MENU_DAEMON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_MENU_DAEMON, GalaMenuDaemonClass))

typedef struct _GalaMenuDaemon GalaMenuDaemon;
typedef struct _GalaMenuDaemonClass GalaMenuDaemonClass;
typedef struct _GalaMenuDaemonPrivate GalaMenuDaemonPrivate;
enum  {
	GALA_MENU_DAEMON_0_PROPERTY,
	GALA_MENU_DAEMON_NUM_PROPERTIES
};
static GParamSpec* gala_menu_daemon_properties[GALA_MENU_DAEMON_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;

struct _GalaWMDBusIface {
	GTypeInterface parent_iface;
	void (*perform_action) (GalaWMDBus* self, GalaActionType type, GError** error);
};

struct _GalaMenuDaemon {
	GObject parent_instance;
	GalaMenuDaemonPrivate * priv;
};

struct _GalaMenuDaemonClass {
	GObjectClass parent_class;
};

struct _GalaMenuDaemonPrivate {
	GraniteAccelLabel* always_on_top_accellabel;
	GraniteAccelLabel* close_accellabel;
	GraniteAccelLabel* hide_accellabel;
	GraniteAccelLabel* move_accellabel;
	GraniteAccelLabel* move_left_accellabel;
	GraniteAccelLabel* move_right_accellabel;
	GraniteAccelLabel* on_visible_workspace_accellabel;
	GraniteAccelLabel* resize_accellabel;
	GraniteAccelLabel* screenshot_accellabel;
	GtkMenu* window_menu;
	GtkMenuItem* hide;
	GtkMenuItem* maximize;
	GtkMenuItem* move;
	GtkMenuItem* resize;
	GtkCheckMenuItem* always_on_top;
	GtkCheckMenuItem* on_visible_workspace;
	GtkMenuItem* move_left;
	GtkMenuItem* move_right;
	GtkMenuItem* close;
	GtkMenuItem* screenshot;
	GtkMenu* desktop_menu;
	GalaWMDBus* wm_proxy;
	gulong always_on_top_sid;
	gulong on_visible_workspace_sid;
};

struct _Block2Data {
	int _ref_count_;
	GalaMenuDaemon* self;
	gint x;
	gint y;
};

struct _Block3Data {
	int _ref_count_;
	GalaMenuDaemon* self;
	gint x;
	gint y;
};

static gint GalaMenuDaemon_private_offset;
static gpointer gala_menu_daemon_parent_class = NULL;
static GSettings* gala_menu_daemon_keybind_settings;
static GSettings* gala_menu_daemon_keybind_settings = NULL;
static GSettings* gala_menu_daemon_media_keys_settings;
static GSettings* gala_menu_daemon_media_keys_settings = NULL;

VALA_EXTERN GType gala_wmd_bus_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint gala_wmd_bus_register_object (void* object,
                                    GDBusConnection* connection,
                                    const gchar* path,
                                    GError** error);
VALA_EXTERN GType gala_wmd_bus_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWMDBus, g_object_unref)
VALA_EXTERN void gala_wmd_bus_perform_action (GalaWMDBus* self,
                                  GalaActionType type,
                                  GError** error);
static GType gala_wmd_bus_get_type_once (void);
static void gala_wmd_bus_proxy_g_signal (GDBusProxy* proxy,
                                  const gchar* sender_name,
                                  const gchar* signal_name,
                                  GVariant* parameters);
static void gala_wmd_bus_proxy_perform_action (GalaWMDBus* self,
                                        GalaActionType type,
                                        GError** error);
static void gala_wmd_bus_proxy_gala_wmd_bus_interface_init (GalaWMDBusIface* iface);
static void _dbus_gala_wmd_bus_perform_action (GalaWMDBus* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation);
static void gala_wmd_bus_dbus_interface_method_call (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* method_name,
                                              GVariant* parameters,
                                              GDBusMethodInvocation* invocation,
                                              gpointer user_data);
static GVariant* gala_wmd_bus_dbus_interface_get_property (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* property_name,
                                                    GError** error,
                                                    gpointer user_data);
static gboolean gala_wmd_bus_dbus_interface_set_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GVariant* value,
                                                   GError** error,
                                                   gpointer user_data);
static void _gala_wmd_bus_unregister_object (gpointer user_data);
VALA_EXTERN GType gala_menu_daemon_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaMenuDaemon, g_object_unref)
VALA_EXTERN guint gala_menu_daemon_register_object (void* object,
                                        GDBusConnection* connection,
                                        const gchar* path,
                                        GError** error);
VALA_EXTERN void gala_menu_daemon_setup_dbus (GalaMenuDaemon* self);
static void gala_menu_daemon_on_bus_acquired (GalaMenuDaemon* self,
                                       GDBusConnection* conn);
static void _gala_menu_daemon_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection,
                                                               const gchar* name,
                                                               gpointer self);
static void __lambda9_ (GalaMenuDaemon* self);
static void ___lambda9__gbus_name_acquired_callback (GDBusConnection* connection,
                                              const gchar* name,
                                              gpointer self);
static void gala_menu_daemon_gala_appeared (GalaMenuDaemon* self);
static void _gala_menu_daemon_gala_appeared_gbus_name_appeared_callback (GDBusConnection* connection,
                                                                  const gchar* name,
                                                                  const gchar* name_owner,
                                                                  gpointer self);
static void gala_menu_daemon_lost_gala (GalaMenuDaemon* self);
static void _gala_menu_daemon_lost_gala_gbus_name_vanished_callback (GDBusConnection* connection,
                                                              const gchar* name,
                                                              gpointer self);
static void gala_menu_daemon_on_gala_get (GalaMenuDaemon* self,
                                   GObject* o,
                                   GAsyncResult* res);
static void _gala_menu_daemon_on_gala_get_gasync_ready_callback (GObject* source_object,
                                                          GAsyncResult* res,
                                                          gpointer self);
static void gala_menu_daemon_perform_action (GalaMenuDaemon* self,
                                      GalaActionType type);
static void gala_menu_daemon_init_window_menu (GalaMenuDaemon* self);
static void __lambda10_ (GalaMenuDaemon* self);
static void ___lambda10__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void __lambda11_ (GalaMenuDaemon* self);
static void ___lambda11__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void __lambda12_ (GalaMenuDaemon* self);
static void ___lambda12__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void __lambda13_ (GalaMenuDaemon* self);
static void ___lambda13__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void __lambda14_ (GalaMenuDaemon* self);
static void ___lambda14__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void __lambda15_ (GalaMenuDaemon* self);
static void ___lambda15__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void __lambda16_ (GalaMenuDaemon* self);
static void ___lambda16__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void __lambda17_ (GalaMenuDaemon* self);
static void ___lambda17__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void __lambda18_ (GalaMenuDaemon* self);
static void ___lambda18__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void __lambda19_ (GalaMenuDaemon* self);
static void ___lambda19__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
VALA_EXTERN void gala_menu_daemon_show_window_menu (GalaMenuDaemon* self,
                                        GalaWindowFlags flags,
                                        gint x,
                                        gint y,
                                        GError** error);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda20_ (Block2Data* _data2_,
                  GtkMenu* m,
                  gint* px,
                  gint* py,
                  gboolean* push_in);
static void ___lambda20__gtk_menu_position_func (GtkMenu* menu,
                                          gint* x,
                                          gint* y,
                                          gboolean* push_in,
                                          gpointer self);
VALA_EXTERN void gala_menu_daemon_show_desktop_menu (GalaMenuDaemon* self,
                                         gint x,
                                         gint y,
                                         GError** error);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void ___lambda21_ (GalaMenuDaemon* self);
static void ____lambda21__gtk_menu_item_activate (GtkMenuItem* _sender,
                                           gpointer self);
static void ___lambda22_ (GalaMenuDaemon* self);
static void ____lambda22__gtk_menu_item_activate (GtkMenuItem* _sender,
                                           gpointer self);
static void ___lambda23_ (GalaMenuDaemon* self);
static void ____lambda23__gtk_menu_item_activate (GtkMenuItem* _sender,
                                           gpointer self);
static void __lambda24_ (Block3Data* _data3_,
                  GtkMenu* m,
                  gint* px,
                  gint* py,
                  gboolean* push_in);
static void ___lambda24__gtk_menu_position_func (GtkMenu* menu,
                                          gint* x,
                                          gint* y,
                                          gboolean* push_in,
                                          gpointer self);
VALA_EXTERN GalaMenuDaemon* gala_menu_daemon_new (void);
VALA_EXTERN GalaMenuDaemon* gala_menu_daemon_construct (GType object_type);
static void gala_menu_daemon_finalize (GObject * obj);
static GType gala_menu_daemon_get_type_once (void);
static void _dbus_gala_menu_daemon_show_window_menu (GalaMenuDaemon* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation);
static void _dbus_gala_menu_daemon_show_desktop_menu (GalaMenuDaemon* self,
                                               GVariant* _parameters_,
                                               GDBusMethodInvocation* invocation);
static void gala_menu_daemon_dbus_interface_method_call (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* method_name,
                                                  GVariant* parameters,
                                                  GDBusMethodInvocation* invocation,
                                                  gpointer user_data);
static GVariant* gala_menu_daemon_dbus_interface_get_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GError** error,
                                                        gpointer user_data);
static gboolean gala_menu_daemon_dbus_interface_set_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GVariant* value,
                                                       GError** error,
                                                       gpointer user_data);
static void _gala_menu_daemon_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GDBusArgInfo _gala_wmd_bus_dbus_arg_info_perform_action_type = {-1, "type", "i", NULL};
static const GDBusArgInfo * const _gala_wmd_bus_dbus_arg_info_perform_action_in[] = {&_gala_wmd_bus_dbus_arg_info_perform_action_type, NULL};
static const GDBusArgInfo * const _gala_wmd_bus_dbus_arg_info_perform_action_out[] = {NULL};
static const GDBusMethodInfo _gala_wmd_bus_dbus_method_info_perform_action = {-1, "PerformAction", (GDBusArgInfo **) (&_gala_wmd_bus_dbus_arg_info_perform_action_in), (GDBusArgInfo **) (&_gala_wmd_bus_dbus_arg_info_perform_action_out), NULL};
static const GDBusMethodInfo * const _gala_wmd_bus_dbus_method_info[] = {&_gala_wmd_bus_dbus_method_info_perform_action, NULL};
static const GDBusSignalInfo * const _gala_wmd_bus_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _gala_wmd_bus_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _gala_wmd_bus_dbus_interface_info = {-1, "org.pantheon.gala", (GDBusMethodInfo **) (&_gala_wmd_bus_dbus_method_info), (GDBusSignalInfo **) (&_gala_wmd_bus_dbus_signal_info), (GDBusPropertyInfo **) (&_gala_wmd_bus_dbus_property_info), NULL};
static const GDBusInterfaceVTable _gala_wmd_bus_dbus_interface_vtable = {gala_wmd_bus_dbus_interface_method_call, gala_wmd_bus_dbus_interface_get_property, gala_wmd_bus_dbus_interface_set_property};
static const GDBusArgInfo _gala_menu_daemon_dbus_arg_info_show_window_menu_flags = {-1, "flags", "u", NULL};
static const GDBusArgInfo _gala_menu_daemon_dbus_arg_info_show_window_menu_x = {-1, "x", "i", NULL};
static const GDBusArgInfo _gala_menu_daemon_dbus_arg_info_show_window_menu_y = {-1, "y", "i", NULL};
static const GDBusArgInfo * const _gala_menu_daemon_dbus_arg_info_show_window_menu_in[] = {&_gala_menu_daemon_dbus_arg_info_show_window_menu_flags, &_gala_menu_daemon_dbus_arg_info_show_window_menu_x, &_gala_menu_daemon_dbus_arg_info_show_window_menu_y, NULL};
static const GDBusArgInfo * const _gala_menu_daemon_dbus_arg_info_show_window_menu_out[] = {NULL};
static const GDBusMethodInfo _gala_menu_daemon_dbus_method_info_show_window_menu = {-1, "ShowWindowMenu", (GDBusArgInfo **) (&_gala_menu_daemon_dbus_arg_info_show_window_menu_in), (GDBusArgInfo **) (&_gala_menu_daemon_dbus_arg_info_show_window_menu_out), NULL};
static const GDBusArgInfo _gala_menu_daemon_dbus_arg_info_show_desktop_menu_x = {-1, "x", "i", NULL};
static const GDBusArgInfo _gala_menu_daemon_dbus_arg_info_show_desktop_menu_y = {-1, "y", "i", NULL};
static const GDBusArgInfo * const _gala_menu_daemon_dbus_arg_info_show_desktop_menu_in[] = {&_gala_menu_daemon_dbus_arg_info_show_desktop_menu_x, &_gala_menu_daemon_dbus_arg_info_show_desktop_menu_y, NULL};
static const GDBusArgInfo * const _gala_menu_daemon_dbus_arg_info_show_desktop_menu_out[] = {NULL};
static const GDBusMethodInfo _gala_menu_daemon_dbus_method_info_show_desktop_menu = {-1, "ShowDesktopMenu", (GDBusArgInfo **) (&_gala_menu_daemon_dbus_arg_info_show_desktop_menu_in), (GDBusArgInfo **) (&_gala_menu_daemon_dbus_arg_info_show_desktop_menu_out), NULL};
static const GDBusMethodInfo * const _gala_menu_daemon_dbus_method_info[] = {&_gala_menu_daemon_dbus_method_info_show_window_menu, &_gala_menu_daemon_dbus_method_info_show_desktop_menu, NULL};
static const GDBusSignalInfo * const _gala_menu_daemon_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _gala_menu_daemon_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _gala_menu_daemon_dbus_interface_info = {-1, "org.pantheon.gala.daemon", (GDBusMethodInfo **) (&_gala_menu_daemon_dbus_method_info), (GDBusSignalInfo **) (&_gala_menu_daemon_dbus_signal_info), (GDBusPropertyInfo **) (&_gala_menu_daemon_dbus_property_info), NULL};
static const GDBusInterfaceVTable _gala_menu_daemon_dbus_interface_vtable = {gala_menu_daemon_dbus_interface_method_call, gala_menu_daemon_dbus_interface_get_property, gala_menu_daemon_dbus_interface_set_property};

void
gala_wmd_bus_perform_action (GalaWMDBus* self,
                             GalaActionType type,
                             GError** error)
{
	GalaWMDBusIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GALA_WMD_BUS_GET_INTERFACE (self);
	if (_iface_->perform_action) {
		_iface_->perform_action (self, type, error);
	}
}

static void
gala_wmd_bus_default_init (GalaWMDBusIface * iface,
                           gpointer iface_data)
{
}

static GType
gala_wmd_bus_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWMDBusIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_wmd_bus_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gala_wmd_bus_type_id;
	gala_wmd_bus_type_id = g_type_register_static (G_TYPE_INTERFACE, "GalaWMDBus", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gala_wmd_bus_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (gala_wmd_bus_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) gala_wmd_bus_proxy_get_type);
	g_type_set_qdata (gala_wmd_bus_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.pantheon.gala");
	g_type_set_qdata (gala_wmd_bus_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_gala_wmd_bus_dbus_interface_info));
	g_type_set_qdata (gala_wmd_bus_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) gala_wmd_bus_register_object);
	return gala_wmd_bus_type_id;
}

GType
gala_wmd_bus_get_type (void)
{
	static volatile gsize gala_wmd_bus_type_id__once = 0;
	if (g_once_init_enter (&gala_wmd_bus_type_id__once)) {
		GType gala_wmd_bus_type_id;
		gala_wmd_bus_type_id = gala_wmd_bus_get_type_once ();
		g_once_init_leave (&gala_wmd_bus_type_id__once, gala_wmd_bus_type_id);
	}
	return gala_wmd_bus_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (GalaWMDBusProxy, gala_wmd_bus_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (GALA_TYPE_WMD_BUS, gala_wmd_bus_proxy_gala_wmd_bus_interface_init) )
static void
gala_wmd_bus_proxy_class_init (GalaWMDBusProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = gala_wmd_bus_proxy_g_signal;
}

static void
gala_wmd_bus_proxy_g_signal (GDBusProxy* proxy,
                             const gchar* sender_name,
                             const gchar* signal_name,
                             GVariant* parameters)
{
}

static void
gala_wmd_bus_proxy_init (GalaWMDBusProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_gala_wmd_bus_dbus_interface_info));
}

static void
gala_wmd_bus_proxy_perform_action (GalaWMDBus* self,
                                   GalaActionType type,
                                   GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.pantheon.gala", "PerformAction");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (type));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
gala_wmd_bus_proxy_gala_wmd_bus_interface_init (GalaWMDBusIface* iface)
{
	iface->perform_action = gala_wmd_bus_proxy_perform_action;
}

static void
_dbus_gala_wmd_bus_perform_action (GalaWMDBus* self,
                                   GVariant* _parameters_,
                                   GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GalaActionType type = 0;
	GVariant* _tmp7_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	type = g_variant_get_int32 (_tmp7_);
	g_variant_unref (_tmp7_);
	gala_wmd_bus_perform_action (self, type, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
gala_wmd_bus_dbus_interface_method_call (GDBusConnection* connection,
                                         const gchar* sender,
                                         const gchar* object_path,
                                         const gchar* interface_name,
                                         const gchar* method_name,
                                         GVariant* parameters,
                                         GDBusMethodInvocation* invocation,
                                         gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "PerformAction") == 0) {
		_dbus_gala_wmd_bus_perform_action (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
gala_wmd_bus_dbus_interface_get_property (GDBusConnection* connection,
                                          const gchar* sender,
                                          const gchar* object_path,
                                          const gchar* interface_name,
                                          const gchar* property_name,
                                          GError** error,
                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
gala_wmd_bus_dbus_interface_set_property (GDBusConnection* connection,
                                          const gchar* sender,
                                          const gchar* object_path,
                                          const gchar* interface_name,
                                          const gchar* property_name,
                                          GVariant* value,
                                          GError** error,
                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
gala_wmd_bus_register_object (gpointer object,
                              GDBusConnection* connection,
                              const gchar* path,
                              GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_gala_wmd_bus_dbus_interface_info), &_gala_wmd_bus_dbus_interface_vtable, data, _gala_wmd_bus_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_gala_wmd_bus_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
gala_menu_daemon_get_instance_private (GalaMenuDaemon* self)
{
	return G_STRUCT_MEMBER_P (self, GalaMenuDaemon_private_offset);
}

static void
_gala_menu_daemon_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection,
                                                          const gchar* name,
                                                          gpointer self)
{
	gala_menu_daemon_on_bus_acquired ((GalaMenuDaemon*) self, connection);
}

static void
__lambda9_ (GalaMenuDaemon* self)
{
}

static void
___lambda9__gbus_name_acquired_callback (GDBusConnection* connection,
                                         const gchar* name,
                                         gpointer self)
{
	__lambda9_ ((GalaMenuDaemon*) self);
}

static void
_gala_menu_daemon_gala_appeared_gbus_name_appeared_callback (GDBusConnection* connection,
                                                             const gchar* name,
                                                             const gchar* name_owner,
                                                             gpointer self)
{
	gala_menu_daemon_gala_appeared ((GalaMenuDaemon*) self);
}

static void
_gala_menu_daemon_lost_gala_gbus_name_vanished_callback (GDBusConnection* connection,
                                                         const gchar* name,
                                                         gpointer self)
{
	gala_menu_daemon_lost_gala ((GalaMenuDaemon*) self);
}

void
gala_menu_daemon_setup_dbus (GalaMenuDaemon* self)
{
	GBusNameOwnerFlags flags = 0U;
	g_return_if_fail (self != NULL);
	flags = G_BUS_NAME_OWNER_FLAGS_ALLOW_REPLACEMENT | G_BUS_NAME_OWNER_FLAGS_REPLACE;
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, GALA_DAEMON_DBUS_NAME, flags, (GClosure*) ((_gala_menu_daemon_on_bus_acquired_gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _gala_menu_daemon_on_bus_acquired_gbus_acquired_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((___lambda9__gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda9__gbus_name_acquired_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	g_bus_watch_name_with_closures (G_BUS_TYPE_SESSION, GALA_DBUS_NAME, G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((_gala_menu_daemon_gala_appeared_gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _gala_menu_daemon_gala_appeared_gbus_name_appeared_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((_gala_menu_daemon_lost_gala_gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _gala_menu_daemon_lost_gala_gbus_name_vanished_callback, g_object_ref (self), (GClosureNotify) g_object_unref)));
}

static void
gala_menu_daemon_on_gala_get (GalaMenuDaemon* self,
                              GObject* o,
                              GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GalaWMDBus* _tmp0_ = NULL;
		GalaWMDBus* _tmp1_;
		GalaWMDBus* _tmp2_;
		GalaWMDBus* _tmp3_;
		_tmp1_ = g_async_result_get_source_object (res);
		_tmp2_ = (GalaWMDBus*) g_async_initable_new_finish ((GAsyncInitable *) _tmp1_, res, &_inner_error0_);
		g_object_unref (_tmp1_);
		_tmp0_ = (GalaWMDBus*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->wm_proxy);
		self->priv->wm_proxy = _tmp3_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("MenuDaemon.vala:82: Failed to get Gala proxy: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
gala_menu_daemon_lost_gala (GalaMenuDaemon* self)
{
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->wm_proxy);
	self->priv->wm_proxy = NULL;
}

static void
_gala_menu_daemon_on_gala_get_gasync_ready_callback (GObject* source_object,
                                                     GAsyncResult* res,
                                                     gpointer self)
{
	gala_menu_daemon_on_gala_get ((GalaMenuDaemon*) self, source_object, res);
	g_object_unref (self);
}

static void
gala_menu_daemon_gala_appeared (GalaMenuDaemon* self)
{
	GalaWMDBus* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->wm_proxy;
	if (_tmp0_ == NULL) {
		g_async_initable_new_async (GALA_TYPE_WMD_BUS_PROXY, 0, NULL, _gala_menu_daemon_on_gala_get_gasync_ready_callback, g_object_ref (self), "g-flags", 0, "g-name", GALA_DBUS_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", GALA_DBUS_OBJECT_PATH, "g-interface-name", "org.pantheon.gala", NULL);
	}
}

static void
gala_menu_daemon_on_bus_acquired (GalaMenuDaemon* self,
                                  GDBusConnection* conn)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	{
		gala_menu_daemon_register_object (self, conn, GALA_DAEMON_DBUS_OBJECT_PATH, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp0_;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = stderr;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		fprintf (_tmp0_, "Error registering MenuDaemon: %s\n", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
gala_menu_daemon_perform_action (GalaMenuDaemon* self,
                                 GalaActionType type)
{
	GalaWMDBus* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->wm_proxy;
	if (_tmp0_ != NULL) {
		{
			GalaWMDBus* _tmp1_;
			_tmp1_ = self->priv->wm_proxy;
			gala_wmd_bus_perform_action (_tmp1_, type, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp2_;
			const gchar* _tmp3_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp2_ = e;
			_tmp3_ = _tmp2_->message;
			g_warning ("MenuDaemon.vala:109: Failed to perform Gala action over DBus: %s", _tmp3_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
__lambda10_ (GalaMenuDaemon* self)
{
	gala_menu_daemon_perform_action (self, GALA_ACTION_TYPE_HIDE_CURRENT);
}

static void
___lambda10__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda10_ ((GalaMenuDaemon*) self);
}

static void
__lambda11_ (GalaMenuDaemon* self)
{
	gala_menu_daemon_perform_action (self, GALA_ACTION_TYPE_MAXIMIZE_CURRENT);
}

static void
___lambda11__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda11_ ((GalaMenuDaemon*) self);
}

static void
__lambda12_ (GalaMenuDaemon* self)
{
	gala_menu_daemon_perform_action (self, GALA_ACTION_TYPE_START_MOVE_CURRENT);
}

static void
___lambda12__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda12_ ((GalaMenuDaemon*) self);
}

static void
__lambda13_ (GalaMenuDaemon* self)
{
	gala_menu_daemon_perform_action (self, GALA_ACTION_TYPE_START_RESIZE_CURRENT);
}

static void
___lambda13__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda13_ ((GalaMenuDaemon*) self);
}

static void
__lambda14_ (GalaMenuDaemon* self)
{
	gala_menu_daemon_perform_action (self, GALA_ACTION_TYPE_TOGGLE_ALWAYS_ON_TOP_CURRENT);
}

static void
___lambda14__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda14_ ((GalaMenuDaemon*) self);
}

static void
__lambda15_ (GalaMenuDaemon* self)
{
	gala_menu_daemon_perform_action (self, GALA_ACTION_TYPE_TOGGLE_ALWAYS_ON_VISIBLE_WORKSPACE_CURRENT);
}

static void
___lambda15__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda15_ ((GalaMenuDaemon*) self);
}

static void
__lambda16_ (GalaMenuDaemon* self)
{
	gala_menu_daemon_perform_action (self, GALA_ACTION_TYPE_MOVE_CURRENT_WORKSPACE_LEFT);
}

static void
___lambda16__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda16_ ((GalaMenuDaemon*) self);
}

static void
__lambda17_ (GalaMenuDaemon* self)
{
	gala_menu_daemon_perform_action (self, GALA_ACTION_TYPE_MOVE_CURRENT_WORKSPACE_RIGHT);
}

static void
___lambda17__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda17_ ((GalaMenuDaemon*) self);
}

static void
__lambda18_ (GalaMenuDaemon* self)
{
	gala_menu_daemon_perform_action (self, GALA_ACTION_TYPE_SCREENSHOT_CURRENT);
}

static void
___lambda18__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda18_ ((GalaMenuDaemon*) self);
}

static void
__lambda19_ (GalaMenuDaemon* self)
{
	gala_menu_daemon_perform_action (self, GALA_ACTION_TYPE_CLOSE_CURRENT);
}

static void
___lambda19__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda19_ ((GalaMenuDaemon*) self);
}

static void
gala_menu_daemon_init_window_menu (GalaMenuDaemon* self)
{
	GraniteAccelLabel* _tmp0_;
	GtkMenuItem* _tmp1_;
	GtkMenuItem* _tmp2_;
	GraniteAccelLabel* _tmp3_;
	GtkMenuItem* _tmp4_;
	GtkMenuItem* _tmp5_;
	GtkMenuItem* _tmp6_;
	GraniteAccelLabel* _tmp7_;
	GtkMenuItem* _tmp8_;
	GtkMenuItem* _tmp9_;
	GraniteAccelLabel* _tmp10_;
	GtkMenuItem* _tmp11_;
	GraniteAccelLabel* _tmp12_;
	GtkMenuItem* _tmp13_;
	GtkMenuItem* _tmp14_;
	GraniteAccelLabel* _tmp15_;
	GtkMenuItem* _tmp16_;
	GraniteAccelLabel* _tmp17_;
	GtkCheckMenuItem* _tmp18_;
	GtkCheckMenuItem* _tmp19_;
	GraniteAccelLabel* _tmp20_;
	GtkCheckMenuItem* _tmp21_;
	gulong _tmp22_;
	GraniteAccelLabel* _tmp23_;
	GtkCheckMenuItem* _tmp24_;
	GtkCheckMenuItem* _tmp25_;
	GraniteAccelLabel* _tmp26_;
	GtkCheckMenuItem* _tmp27_;
	gulong _tmp28_;
	GraniteAccelLabel* _tmp29_;
	GtkMenuItem* _tmp30_;
	GtkMenuItem* _tmp31_;
	GraniteAccelLabel* _tmp32_;
	GtkMenuItem* _tmp33_;
	GraniteAccelLabel* _tmp34_;
	GtkMenuItem* _tmp35_;
	GtkMenuItem* _tmp36_;
	GraniteAccelLabel* _tmp37_;
	GtkMenuItem* _tmp38_;
	GraniteAccelLabel* _tmp39_;
	GtkMenuItem* _tmp40_;
	GtkMenuItem* _tmp41_;
	GraniteAccelLabel* _tmp42_;
	GtkMenuItem* _tmp43_;
	GraniteAccelLabel* _tmp44_;
	GtkMenuItem* _tmp45_;
	GtkMenuItem* _tmp46_;
	GraniteAccelLabel* _tmp47_;
	GtkMenuItem* _tmp48_;
	GtkMenu* _tmp49_;
	GtkMenu* _tmp50_;
	GtkMenuItem* _tmp51_;
	GtkMenu* _tmp52_;
	GtkSeparatorMenuItem* _tmp53_;
	GtkSeparatorMenuItem* _tmp54_;
	GtkMenu* _tmp55_;
	GtkCheckMenuItem* _tmp56_;
	GtkMenu* _tmp57_;
	GtkCheckMenuItem* _tmp58_;
	GtkMenu* _tmp59_;
	GtkMenuItem* _tmp60_;
	GtkMenu* _tmp61_;
	GtkMenuItem* _tmp62_;
	GtkMenu* _tmp63_;
	GtkSeparatorMenuItem* _tmp64_;
	GtkSeparatorMenuItem* _tmp65_;
	GtkMenu* _tmp66_;
	GtkMenuItem* _tmp67_;
	GtkMenu* _tmp68_;
	GtkMenuItem* _tmp69_;
	GtkMenu* _tmp70_;
	GtkMenuItem* _tmp71_;
	GtkMenu* _tmp72_;
	GtkSeparatorMenuItem* _tmp73_;
	GtkSeparatorMenuItem* _tmp74_;
	GtkMenu* _tmp75_;
	GtkMenuItem* _tmp76_;
	GtkMenu* _tmp77_;
	GtkMenuItem* _tmp78_;
	GtkMenu* _tmp79_;
	g_return_if_fail (self != NULL);
	_tmp0_ = granite_accel_label_new (_ ("Hide"), NULL);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->hide_accellabel);
	self->priv->hide_accellabel = _tmp0_;
	_tmp1_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->hide);
	self->priv->hide = _tmp1_;
	_tmp2_ = self->priv->hide;
	_tmp3_ = self->priv->hide_accellabel;
	gtk_container_add ((GtkContainer*) _tmp2_, (GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->hide;
	g_signal_connect_object (_tmp4_, "activate", (GCallback) ___lambda10__gtk_menu_item_activate, self, 0);
	_tmp5_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->maximize);
	self->priv->maximize = _tmp5_;
	_tmp6_ = self->priv->maximize;
	g_signal_connect_object (_tmp6_, "activate", (GCallback) ___lambda11__gtk_menu_item_activate, self, 0);
	_tmp7_ = granite_accel_label_new (_ ("Move"), NULL);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->move_accellabel);
	self->priv->move_accellabel = _tmp7_;
	_tmp8_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->move);
	self->priv->move = _tmp8_;
	_tmp9_ = self->priv->move;
	_tmp10_ = self->priv->move_accellabel;
	gtk_container_add ((GtkContainer*) _tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = self->priv->move;
	g_signal_connect_object (_tmp11_, "activate", (GCallback) ___lambda12__gtk_menu_item_activate, self, 0);
	_tmp12_ = granite_accel_label_new (_ ("Resize"), NULL);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->resize_accellabel);
	self->priv->resize_accellabel = _tmp12_;
	_tmp13_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->resize);
	self->priv->resize = _tmp13_;
	_tmp14_ = self->priv->resize;
	_tmp15_ = self->priv->resize_accellabel;
	gtk_container_add ((GtkContainer*) _tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = self->priv->resize;
	g_signal_connect_object (_tmp16_, "activate", (GCallback) ___lambda13__gtk_menu_item_activate, self, 0);
	_tmp17_ = granite_accel_label_new (_ ("Always on Top"), NULL);
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->always_on_top_accellabel);
	self->priv->always_on_top_accellabel = _tmp17_;
	_tmp18_ = (GtkCheckMenuItem*) gtk_check_menu_item_new ();
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->always_on_top);
	self->priv->always_on_top = _tmp18_;
	_tmp19_ = self->priv->always_on_top;
	_tmp20_ = self->priv->always_on_top_accellabel;
	gtk_container_add ((GtkContainer*) _tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = self->priv->always_on_top;
	_tmp22_ = g_signal_connect_object ((GtkMenuItem*) _tmp21_, "activate", (GCallback) ___lambda14__gtk_menu_item_activate, self, 0);
	self->priv->always_on_top_sid = _tmp22_;
	_tmp23_ = granite_accel_label_new (_ ("Always on Visible Workspace"), NULL);
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->on_visible_workspace_accellabel);
	self->priv->on_visible_workspace_accellabel = _tmp23_;
	_tmp24_ = (GtkCheckMenuItem*) gtk_check_menu_item_new ();
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->on_visible_workspace);
	self->priv->on_visible_workspace = _tmp24_;
	_tmp25_ = self->priv->on_visible_workspace;
	_tmp26_ = self->priv->on_visible_workspace_accellabel;
	gtk_container_add ((GtkContainer*) _tmp25_, (GtkWidget*) _tmp26_);
	_tmp27_ = self->priv->on_visible_workspace;
	_tmp28_ = g_signal_connect_object ((GtkMenuItem*) _tmp27_, "activate", (GCallback) ___lambda15__gtk_menu_item_activate, self, 0);
	self->priv->on_visible_workspace_sid = _tmp28_;
	_tmp29_ = granite_accel_label_new (_ ("Move to Workspace Left"), NULL);
	g_object_ref_sink (_tmp29_);
	_g_object_unref0 (self->priv->move_left_accellabel);
	self->priv->move_left_accellabel = _tmp29_;
	_tmp30_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp30_);
	_g_object_unref0 (self->priv->move_left);
	self->priv->move_left = _tmp30_;
	_tmp31_ = self->priv->move_left;
	_tmp32_ = self->priv->move_left_accellabel;
	gtk_container_add ((GtkContainer*) _tmp31_, (GtkWidget*) _tmp32_);
	_tmp33_ = self->priv->move_left;
	g_signal_connect_object (_tmp33_, "activate", (GCallback) ___lambda16__gtk_menu_item_activate, self, 0);
	_tmp34_ = granite_accel_label_new (_ ("Move to Workspace Right"), NULL);
	g_object_ref_sink (_tmp34_);
	_g_object_unref0 (self->priv->move_right_accellabel);
	self->priv->move_right_accellabel = _tmp34_;
	_tmp35_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp35_);
	_g_object_unref0 (self->priv->move_right);
	self->priv->move_right = _tmp35_;
	_tmp36_ = self->priv->move_right;
	_tmp37_ = self->priv->move_right_accellabel;
	gtk_container_add ((GtkContainer*) _tmp36_, (GtkWidget*) _tmp37_);
	_tmp38_ = self->priv->move_right;
	g_signal_connect_object (_tmp38_, "activate", (GCallback) ___lambda17__gtk_menu_item_activate, self, 0);
	_tmp39_ = granite_accel_label_new (_ ("Take Screenshot"), NULL);
	g_object_ref_sink (_tmp39_);
	_g_object_unref0 (self->priv->screenshot_accellabel);
	self->priv->screenshot_accellabel = _tmp39_;
	_tmp40_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp40_);
	_g_object_unref0 (self->priv->screenshot);
	self->priv->screenshot = _tmp40_;
	_tmp41_ = self->priv->screenshot;
	_tmp42_ = self->priv->screenshot_accellabel;
	gtk_container_add ((GtkContainer*) _tmp41_, (GtkWidget*) _tmp42_);
	_tmp43_ = self->priv->screenshot;
	g_signal_connect_object (_tmp43_, "activate", (GCallback) ___lambda18__gtk_menu_item_activate, self, 0);
	_tmp44_ = granite_accel_label_new (_ ("Close"), NULL);
	g_object_ref_sink (_tmp44_);
	_g_object_unref0 (self->priv->close_accellabel);
	self->priv->close_accellabel = _tmp44_;
	_tmp45_ = (GtkMenuItem*) gtk_menu_item_new ();
	g_object_ref_sink (_tmp45_);
	_g_object_unref0 (self->priv->close);
	self->priv->close = _tmp45_;
	_tmp46_ = self->priv->close;
	_tmp47_ = self->priv->close_accellabel;
	gtk_container_add ((GtkContainer*) _tmp46_, (GtkWidget*) _tmp47_);
	_tmp48_ = self->priv->close;
	g_signal_connect_object (_tmp48_, "activate", (GCallback) ___lambda19__gtk_menu_item_activate, self, 0);
	_tmp49_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp49_);
	_g_object_unref0 (self->priv->window_menu);
	self->priv->window_menu = _tmp49_;
	_tmp50_ = self->priv->window_menu;
	_tmp51_ = self->priv->screenshot;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp50_, _tmp51_);
	_tmp52_ = self->priv->window_menu;
	_tmp53_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp53_);
	_tmp54_ = _tmp53_;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp52_, (GtkMenuItem*) _tmp54_);
	_g_object_unref0 (_tmp54_);
	_tmp55_ = self->priv->window_menu;
	_tmp56_ = self->priv->always_on_top;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp55_, (GtkMenuItem*) _tmp56_);
	_tmp57_ = self->priv->window_menu;
	_tmp58_ = self->priv->on_visible_workspace;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp57_, (GtkMenuItem*) _tmp58_);
	_tmp59_ = self->priv->window_menu;
	_tmp60_ = self->priv->move_left;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp59_, _tmp60_);
	_tmp61_ = self->priv->window_menu;
	_tmp62_ = self->priv->move_right;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp61_, _tmp62_);
	_tmp63_ = self->priv->window_menu;
	_tmp64_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp64_);
	_tmp65_ = _tmp64_;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp63_, (GtkMenuItem*) _tmp65_);
	_g_object_unref0 (_tmp65_);
	_tmp66_ = self->priv->window_menu;
	_tmp67_ = self->priv->move;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp66_, _tmp67_);
	_tmp68_ = self->priv->window_menu;
	_tmp69_ = self->priv->resize;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp68_, _tmp69_);
	_tmp70_ = self->priv->window_menu;
	_tmp71_ = self->priv->maximize;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp70_, _tmp71_);
	_tmp72_ = self->priv->window_menu;
	_tmp73_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp73_);
	_tmp74_ = _tmp73_;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp72_, (GtkMenuItem*) _tmp74_);
	_g_object_unref0 (_tmp74_);
	_tmp75_ = self->priv->window_menu;
	_tmp76_ = self->priv->hide;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp75_, _tmp76_);
	_tmp77_ = self->priv->window_menu;
	_tmp78_ = self->priv->close;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp77_, _tmp78_);
	_tmp79_ = self->priv->window_menu;
	gtk_widget_show_all ((GtkWidget*) _tmp79_);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		GalaMenuDaemon* self;
		self = _data2_->self;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda20_ (Block2Data* _data2_,
             GtkMenu* m,
             gint* px,
             gint* py,
             gboolean* push_in)
{
	GalaMenuDaemon* self;
	gboolean _vala_push_in = FALSE;
	gint scale = 0;
	gint _tmp0_;
	gint _tmp1_;
	self = _data2_->self;
	g_return_if_fail (m != NULL);
	_tmp0_ = gtk_widget_get_scale_factor ((GtkWidget*) m);
	_tmp1_ = _tmp0_;
	scale = _tmp1_;
	*px = _data2_->x / scale;
	*py = (_data2_->y / scale) + 1;
	_vala_push_in = TRUE;
	if (push_in) {
		*push_in = _vala_push_in;
	}
}

static void
___lambda20__gtk_menu_position_func (GtkMenu* menu,
                                     gint* x,
                                     gint* y,
                                     gboolean* push_in,
                                     gpointer self)
{
	__lambda20_ (self, menu, x, y, push_in);
	block2_data_unref (self);
}

void
gala_menu_daemon_show_window_menu (GalaMenuDaemon* self,
                                   GalaWindowFlags flags,
                                   gint x,
                                   gint y,
                                   GError** error)
{
	Block2Data* _data2_;
	GtkMenu* _tmp0_;
	GtkMenuItem* _tmp1_;
	GtkMenuItem* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GtkMenuItem* _tmp11_;
	GtkMenuItem* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	GtkMenuItem* _tmp27_;
	GtkMenuItem* _tmp28_;
	gboolean _tmp29_;
	gboolean _tmp30_;
	GtkMenuItem* _tmp37_;
	GtkMenuItem* _tmp38_;
	gboolean _tmp39_;
	gboolean _tmp40_;
	GtkCheckMenuItem* _tmp47_;
	GtkCheckMenuItem* _tmp48_;
	GtkCheckMenuItem* _tmp49_;
	GraniteAccelLabel* _tmp50_;
	GSettings* _tmp51_;
	gchar** _tmp52_;
	gchar** _tmp53_;
	gchar** _tmp54_;
	gint _tmp54__length1;
	const gchar* _tmp55_;
	GtkCheckMenuItem* _tmp56_;
	GraniteAccelLabel* _tmp57_;
	GSettings* _tmp58_;
	gchar** _tmp59_;
	gchar** _tmp60_;
	gchar** _tmp61_;
	gint _tmp61__length1;
	const gchar* _tmp62_;
	GtkCheckMenuItem* _tmp63_;
	GtkCheckMenuItem* _tmp64_;
	GtkMenuItem* _tmp65_;
	GtkCheckMenuItem* _tmp66_;
	gboolean _tmp67_;
	gboolean _tmp68_;
	GtkMenuItem* _tmp69_;
	gboolean _tmp70_;
	gboolean _tmp71_;
	GtkMenuItem* _tmp78_;
	GtkCheckMenuItem* _tmp79_;
	gboolean _tmp80_;
	gboolean _tmp81_;
	GtkMenuItem* _tmp82_;
	gboolean _tmp83_;
	gboolean _tmp84_;
	GraniteAccelLabel* _tmp91_;
	GSettings* _tmp92_;
	gchar** _tmp93_;
	gchar** _tmp94_;
	gchar** _tmp95_;
	gint _tmp95__length1;
	const gchar* _tmp96_;
	GtkMenuItem* _tmp97_;
	GtkMenuItem* _tmp98_;
	gboolean _tmp99_;
	gboolean _tmp100_;
	GtkMenu* _tmp107_;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_data2_->x = x;
	_data2_->y = y;
	_tmp0_ = self->priv->window_menu;
	if (_tmp0_ == NULL) {
		gala_menu_daemon_init_window_menu (self);
	}
	_tmp1_ = self->priv->hide;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, (flags & GALA_WINDOW_FLAGS_CAN_HIDE) == GALA_WINDOW_FLAGS_CAN_HIDE);
	_tmp2_ = self->priv->hide;
	_tmp3_ = gtk_widget_get_visible ((GtkWidget*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		GraniteAccelLabel* _tmp5_;
		GSettings* _tmp6_;
		gchar** _tmp7_;
		gchar** _tmp8_;
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		_tmp5_ = self->priv->hide_accellabel;
		_tmp6_ = gala_menu_daemon_keybind_settings;
		_tmp8_ = _tmp7_ = g_settings_get_strv (_tmp6_, "minimize");
		_tmp9_ = _tmp8_;
		_tmp9__length1 = _vala_array_length (_tmp7_);
		_tmp10_ = _tmp9_[0];
		granite_accel_label_set_accel_string (_tmp5_, _tmp10_);
		_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp11_ = self->priv->maximize;
	gtk_widget_set_visible ((GtkWidget*) _tmp11_, (flags & GALA_WINDOW_FLAGS_CAN_MAXIMIZE) == GALA_WINDOW_FLAGS_CAN_MAXIMIZE);
	_tmp12_ = self->priv->maximize;
	_tmp13_ = gtk_widget_get_visible ((GtkWidget*) _tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp14_) {
		const gchar* maximize_label = NULL;
		GtkMenuItem* _tmp16_;
		GtkWidget* _tmp17_;
		GtkMenuItem* _tmp18_;
		const gchar* _tmp19_;
		GSettings* _tmp20_;
		gchar** _tmp21_;
		gchar** _tmp22_;
		gchar** _tmp23_;
		gint _tmp23__length1;
		const gchar* _tmp24_;
		GraniteAccelLabel* _tmp25_;
		GraniteAccelLabel* _tmp26_;
		if ((flags & GALA_WINDOW_FLAGS_IS_MAXIMIZED) == GALA_WINDOW_FLAGS_IS_MAXIMIZED) {
			const gchar* _tmp15_ = NULL;
			if ((flags & GALA_WINDOW_FLAGS_IS_TILED) == GALA_WINDOW_FLAGS_IS_TILED) {
				_tmp15_ = _ ("Untile");
			} else {
				_tmp15_ = _ ("Unmaximize");
			}
			maximize_label = _tmp15_;
		} else {
			maximize_label = _ ("Maximize");
		}
		_tmp16_ = self->priv->maximize;
		_tmp17_ = gtk_bin_get_child ((GtkBin*) _tmp16_);
		gtk_widget_destroy (_tmp17_);
		_tmp18_ = self->priv->maximize;
		_tmp19_ = maximize_label;
		_tmp20_ = gala_menu_daemon_keybind_settings;
		_tmp22_ = _tmp21_ = g_settings_get_strv (_tmp20_, "toggle-maximized");
		_tmp23_ = _tmp22_;
		_tmp23__length1 = _vala_array_length (_tmp21_);
		_tmp24_ = _tmp23_[0];
		_tmp25_ = granite_accel_label_new (_tmp19_, _tmp24_);
		g_object_ref_sink (_tmp25_);
		_tmp26_ = _tmp25_;
		gtk_container_add ((GtkContainer*) _tmp18_, (GtkWidget*) _tmp26_);
		_g_object_unref0 (_tmp26_);
		_tmp23_ = (_vala_array_free (_tmp23_, _tmp23__length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp27_ = self->priv->move;
	gtk_widget_set_visible ((GtkWidget*) _tmp27_, (flags & GALA_WINDOW_FLAGS_ALLOWS_MOVE) == GALA_WINDOW_FLAGS_ALLOWS_MOVE);
	_tmp28_ = self->priv->move;
	_tmp29_ = gtk_widget_get_visible ((GtkWidget*) _tmp28_);
	_tmp30_ = _tmp29_;
	if (_tmp30_) {
		GraniteAccelLabel* _tmp31_;
		GSettings* _tmp32_;
		gchar** _tmp33_;
		gchar** _tmp34_;
		gchar** _tmp35_;
		gint _tmp35__length1;
		const gchar* _tmp36_;
		_tmp31_ = self->priv->move_accellabel;
		_tmp32_ = gala_menu_daemon_keybind_settings;
		_tmp34_ = _tmp33_ = g_settings_get_strv (_tmp32_, "begin-move");
		_tmp35_ = _tmp34_;
		_tmp35__length1 = _vala_array_length (_tmp33_);
		_tmp36_ = _tmp35_[0];
		granite_accel_label_set_accel_string (_tmp31_, _tmp36_);
		_tmp35_ = (_vala_array_free (_tmp35_, _tmp35__length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp37_ = self->priv->resize;
	gtk_widget_set_visible ((GtkWidget*) _tmp37_, (flags & GALA_WINDOW_FLAGS_ALLOWS_RESIZE) == GALA_WINDOW_FLAGS_ALLOWS_RESIZE);
	_tmp38_ = self->priv->resize;
	_tmp39_ = gtk_widget_get_visible ((GtkWidget*) _tmp38_);
	_tmp40_ = _tmp39_;
	if (_tmp40_) {
		GraniteAccelLabel* _tmp41_;
		GSettings* _tmp42_;
		gchar** _tmp43_;
		gchar** _tmp44_;
		gchar** _tmp45_;
		gint _tmp45__length1;
		const gchar* _tmp46_;
		_tmp41_ = self->priv->resize_accellabel;
		_tmp42_ = gala_menu_daemon_keybind_settings;
		_tmp44_ = _tmp43_ = g_settings_get_strv (_tmp42_, "begin-resize");
		_tmp45_ = _tmp44_;
		_tmp45__length1 = _vala_array_length (_tmp43_);
		_tmp46_ = _tmp45_[0];
		granite_accel_label_set_accel_string (_tmp41_, _tmp46_);
		_tmp45_ = (_vala_array_free (_tmp45_, _tmp45__length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp47_ = self->priv->always_on_top;
	g_signal_handler_block (_tmp47_, self->priv->always_on_top_sid);
	_tmp48_ = self->priv->on_visible_workspace;
	g_signal_handler_block (_tmp48_, self->priv->on_visible_workspace_sid);
	_tmp49_ = self->priv->always_on_top;
	gtk_check_menu_item_set_active (_tmp49_, (flags & GALA_WINDOW_FLAGS_ALWAYS_ON_TOP) == GALA_WINDOW_FLAGS_ALWAYS_ON_TOP);
	_tmp50_ = self->priv->always_on_top_accellabel;
	_tmp51_ = gala_menu_daemon_keybind_settings;
	_tmp53_ = _tmp52_ = g_settings_get_strv (_tmp51_, "always-on-top");
	_tmp54_ = _tmp53_;
	_tmp54__length1 = _vala_array_length (_tmp52_);
	_tmp55_ = _tmp54_[0];
	granite_accel_label_set_accel_string (_tmp50_, _tmp55_);
	_tmp54_ = (_vala_array_free (_tmp54_, _tmp54__length1, (GDestroyNotify) g_free), NULL);
	_tmp56_ = self->priv->on_visible_workspace;
	gtk_check_menu_item_set_active (_tmp56_, (flags & GALA_WINDOW_FLAGS_ON_ALL_WORKSPACES) == GALA_WINDOW_FLAGS_ON_ALL_WORKSPACES);
	_tmp57_ = self->priv->on_visible_workspace_accellabel;
	_tmp58_ = gala_menu_daemon_keybind_settings;
	_tmp60_ = _tmp59_ = g_settings_get_strv (_tmp58_, "toggle-on-all-workspaces");
	_tmp61_ = _tmp60_;
	_tmp61__length1 = _vala_array_length (_tmp59_);
	_tmp62_ = _tmp61_[0];
	granite_accel_label_set_accel_string (_tmp57_, _tmp62_);
	_tmp61_ = (_vala_array_free (_tmp61_, _tmp61__length1, (GDestroyNotify) g_free), NULL);
	_tmp63_ = self->priv->always_on_top;
	g_signal_handler_unblock (_tmp63_, self->priv->always_on_top_sid);
	_tmp64_ = self->priv->on_visible_workspace;
	g_signal_handler_unblock (_tmp64_, self->priv->on_visible_workspace_sid);
	_tmp65_ = self->priv->move_right;
	_tmp66_ = self->priv->on_visible_workspace;
	_tmp67_ = gtk_check_menu_item_get_active (_tmp66_);
	_tmp68_ = _tmp67_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp65_, !_tmp68_);
	_tmp69_ = self->priv->move_right;
	_tmp70_ = gtk_widget_get_sensitive ((GtkWidget*) _tmp69_);
	_tmp71_ = _tmp70_;
	if (_tmp71_) {
		GraniteAccelLabel* _tmp72_;
		GSettings* _tmp73_;
		gchar** _tmp74_;
		gchar** _tmp75_;
		gchar** _tmp76_;
		gint _tmp76__length1;
		const gchar* _tmp77_;
		_tmp72_ = self->priv->move_right_accellabel;
		_tmp73_ = gala_menu_daemon_keybind_settings;
		_tmp75_ = _tmp74_ = g_settings_get_strv (_tmp73_, "move-to-workspace-right");
		_tmp76_ = _tmp75_;
		_tmp76__length1 = _vala_array_length (_tmp74_);
		_tmp77_ = _tmp76_[0];
		granite_accel_label_set_accel_string (_tmp72_, _tmp77_);
		_tmp76_ = (_vala_array_free (_tmp76_, _tmp76__length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp78_ = self->priv->move_left;
	_tmp79_ = self->priv->on_visible_workspace;
	_tmp80_ = gtk_check_menu_item_get_active (_tmp79_);
	_tmp81_ = _tmp80_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp78_, !_tmp81_);
	_tmp82_ = self->priv->move_left;
	_tmp83_ = gtk_widget_get_sensitive ((GtkWidget*) _tmp82_);
	_tmp84_ = _tmp83_;
	if (_tmp84_) {
		GraniteAccelLabel* _tmp85_;
		GSettings* _tmp86_;
		gchar** _tmp87_;
		gchar** _tmp88_;
		gchar** _tmp89_;
		gint _tmp89__length1;
		const gchar* _tmp90_;
		_tmp85_ = self->priv->move_left_accellabel;
		_tmp86_ = gala_menu_daemon_keybind_settings;
		_tmp88_ = _tmp87_ = g_settings_get_strv (_tmp86_, "move-to-workspace-left");
		_tmp89_ = _tmp88_;
		_tmp89__length1 = _vala_array_length (_tmp87_);
		_tmp90_ = _tmp89_[0];
		granite_accel_label_set_accel_string (_tmp85_, _tmp90_);
		_tmp89_ = (_vala_array_free (_tmp89_, _tmp89__length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp91_ = self->priv->screenshot_accellabel;
	_tmp92_ = gala_menu_daemon_media_keys_settings;
	_tmp94_ = _tmp93_ = g_settings_get_strv (_tmp92_, "window-screenshot");
	_tmp95_ = _tmp94_;
	_tmp95__length1 = _vala_array_length (_tmp93_);
	_tmp96_ = _tmp95_[0];
	granite_accel_label_set_accel_string (_tmp91_, _tmp96_);
	_tmp95_ = (_vala_array_free (_tmp95_, _tmp95__length1, (GDestroyNotify) g_free), NULL);
	_tmp97_ = self->priv->close;
	gtk_widget_set_visible ((GtkWidget*) _tmp97_, (flags & GALA_WINDOW_FLAGS_CAN_CLOSE) == GALA_WINDOW_FLAGS_CAN_CLOSE);
	_tmp98_ = self->priv->close;
	_tmp99_ = gtk_widget_get_visible ((GtkWidget*) _tmp98_);
	_tmp100_ = _tmp99_;
	if (_tmp100_) {
		GraniteAccelLabel* _tmp101_;
		GSettings* _tmp102_;
		gchar** _tmp103_;
		gchar** _tmp104_;
		gchar** _tmp105_;
		gint _tmp105__length1;
		const gchar* _tmp106_;
		_tmp101_ = self->priv->close_accellabel;
		_tmp102_ = gala_menu_daemon_keybind_settings;
		_tmp104_ = _tmp103_ = g_settings_get_strv (_tmp102_, "close");
		_tmp105_ = _tmp104_;
		_tmp105__length1 = _vala_array_length (_tmp103_);
		_tmp106_ = _tmp105_[0];
		granite_accel_label_set_accel_string (_tmp101_, _tmp106_);
		_tmp105_ = (_vala_array_free (_tmp105_, _tmp105__length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp107_ = self->priv->window_menu;
	gtk_menu_popup (_tmp107_, NULL, NULL, ___lambda20__gtk_menu_position_func, block2_data_ref (_data2_), (guint) 3, (guint32) GDK_CURRENT_TIME);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		GalaMenuDaemon* self;
		self = _data3_->self;
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
___lambda21_ (GalaMenuDaemon* self)
{
	GError* _inner_error0_ = NULL;
	{
		g_app_info_launch_default_for_uri ("settings://desktop/appearance/wallpaper", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GraniteMessageDialog* message_dialog = NULL;
		GraniteMessageDialog* _tmp0_;
		GraniteMessageDialog* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		GraniteMessageDialog* _tmp4_;
		GraniteMessageDialog* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = granite_message_dialog_new_with_image_from_icon_name ("Failed to Open Wallpaper Settings", "Unable to open System Settings. A handler for the `settings://` URI sc" \
"heme must be installed.", "dialog-error", GTK_BUTTONS_CLOSE);
		g_object_ref_sink (_tmp0_);
		message_dialog = _tmp0_;
		_tmp1_ = message_dialog;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		granite_message_dialog_show_error_details (_tmp1_, _tmp3_);
		_tmp4_ = message_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp4_);
		_tmp5_ = message_dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp5_);
		_g_object_unref0 (message_dialog);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda21__gtk_menu_item_activate (GtkMenuItem* _sender,
                                      gpointer self)
{
	___lambda21_ ((GalaMenuDaemon*) self);
}

static void
___lambda22_ (GalaMenuDaemon* self)
{
	GError* _inner_error0_ = NULL;
	{
		g_app_info_launch_default_for_uri ("settings://display", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GraniteMessageDialog* message_dialog = NULL;
		GraniteMessageDialog* _tmp0_;
		GraniteMessageDialog* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		GraniteMessageDialog* _tmp4_;
		GraniteMessageDialog* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = granite_message_dialog_new_with_image_from_icon_name ("Failed to Open Display Settings", "Unable to open System Settings. A handler for the `settings://` URI sc" \
"heme must be installed.", "dialog-warning", GTK_BUTTONS_CLOSE);
		g_object_ref_sink (_tmp0_);
		message_dialog = _tmp0_;
		_tmp1_ = message_dialog;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		granite_message_dialog_show_error_details (_tmp1_, _tmp3_);
		_tmp4_ = message_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp4_);
		_tmp5_ = message_dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp5_);
		_g_object_unref0 (message_dialog);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda22__gtk_menu_item_activate (GtkMenuItem* _sender,
                                      gpointer self)
{
	___lambda22_ ((GalaMenuDaemon*) self);
}

static void
___lambda23_ (GalaMenuDaemon* self)
{
	GError* _inner_error0_ = NULL;
	{
		g_app_info_launch_default_for_uri ("settings://", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GraniteMessageDialog* message_dialog = NULL;
		GraniteMessageDialog* _tmp0_;
		GraniteMessageDialog* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		GraniteMessageDialog* _tmp4_;
		GraniteMessageDialog* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = granite_message_dialog_new_with_image_from_icon_name ("Failed to Open System Settings", "Unable to open System Settings. A handler for the `settings://` URI sc" \
"heme must be installed.", "dialog-warning", GTK_BUTTONS_CLOSE);
		g_object_ref_sink (_tmp0_);
		message_dialog = _tmp0_;
		_tmp1_ = message_dialog;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		granite_message_dialog_show_error_details (_tmp1_, _tmp3_);
		_tmp4_ = message_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp4_);
		_tmp5_ = message_dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp5_);
		_g_object_unref0 (message_dialog);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda23__gtk_menu_item_activate (GtkMenuItem* _sender,
                                      gpointer self)
{
	___lambda23_ ((GalaMenuDaemon*) self);
}

static void
__lambda24_ (Block3Data* _data3_,
             GtkMenu* m,
             gint* px,
             gint* py,
             gboolean* push_in)
{
	GalaMenuDaemon* self;
	gboolean _vala_push_in = FALSE;
	gint scale = 0;
	gint _tmp0_;
	gint _tmp1_;
	self = _data3_->self;
	g_return_if_fail (m != NULL);
	_tmp0_ = gtk_widget_get_scale_factor ((GtkWidget*) m);
	_tmp1_ = _tmp0_;
	scale = _tmp1_;
	*px = _data3_->x / scale;
	*py = (_data3_->y / scale) + 1;
	_vala_push_in = FALSE;
	if (push_in) {
		*push_in = _vala_push_in;
	}
}

static void
___lambda24__gtk_menu_position_func (GtkMenu* menu,
                                     gint* x,
                                     gint* y,
                                     gboolean* push_in,
                                     gpointer self)
{
	__lambda24_ (self, menu, x, y, push_in);
	block3_data_unref (self);
}

void
gala_menu_daemon_show_desktop_menu (GalaMenuDaemon* self,
                                    gint x,
                                    gint y,
                                    GError** error)
{
	Block3Data* _data3_;
	GtkMenu* _tmp0_;
	GtkMenu* _tmp18_;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_data3_->x = x;
	_data3_->y = y;
	_tmp0_ = self->priv->desktop_menu;
	if (_tmp0_ == NULL) {
		GtkMenuItem* change_wallpaper = NULL;
		GtkMenuItem* _tmp1_;
		GtkMenuItem* _tmp2_;
		GtkMenuItem* display_settings = NULL;
		GtkMenuItem* _tmp3_;
		GtkMenuItem* _tmp4_;
		GtkMenuItem* system_settings = NULL;
		GtkMenuItem* _tmp5_;
		GtkMenuItem* _tmp6_;
		GtkMenu* _tmp7_;
		GtkMenu* _tmp8_;
		GtkMenuItem* _tmp9_;
		GtkMenu* _tmp10_;
		GtkMenuItem* _tmp11_;
		GtkMenu* _tmp12_;
		GtkSeparatorMenuItem* _tmp13_;
		GtkSeparatorMenuItem* _tmp14_;
		GtkMenu* _tmp15_;
		GtkMenuItem* _tmp16_;
		GtkMenu* _tmp17_;
		_tmp1_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Change Wallpaper…"));
		g_object_ref_sink (_tmp1_);
		change_wallpaper = _tmp1_;
		_tmp2_ = change_wallpaper;
		g_signal_connect_object (_tmp2_, "activate", (GCallback) ____lambda21__gtk_menu_item_activate, self, 0);
		_tmp3_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Display Settings…"));
		g_object_ref_sink (_tmp3_);
		display_settings = _tmp3_;
		_tmp4_ = display_settings;
		g_signal_connect_object (_tmp4_, "activate", (GCallback) ____lambda22__gtk_menu_item_activate, self, 0);
		_tmp5_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("System Settings…"));
		g_object_ref_sink (_tmp5_);
		system_settings = _tmp5_;
		_tmp6_ = system_settings;
		g_signal_connect_object (_tmp6_, "activate", (GCallback) ____lambda23__gtk_menu_item_activate, self, 0);
		_tmp7_ = (GtkMenu*) gtk_menu_new ();
		g_object_ref_sink (_tmp7_);
		_g_object_unref0 (self->priv->desktop_menu);
		self->priv->desktop_menu = _tmp7_;
		_tmp8_ = self->priv->desktop_menu;
		_tmp9_ = change_wallpaper;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp8_, _tmp9_);
		_tmp10_ = self->priv->desktop_menu;
		_tmp11_ = display_settings;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp10_, _tmp11_);
		_tmp12_ = self->priv->desktop_menu;
		_tmp13_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
		g_object_ref_sink (_tmp13_);
		_tmp14_ = _tmp13_;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp12_, (GtkMenuItem*) _tmp14_);
		_g_object_unref0 (_tmp14_);
		_tmp15_ = self->priv->desktop_menu;
		_tmp16_ = system_settings;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp15_, _tmp16_);
		_tmp17_ = self->priv->desktop_menu;
		gtk_widget_show_all ((GtkWidget*) _tmp17_);
		_g_object_unref0 (system_settings);
		_g_object_unref0 (display_settings);
		_g_object_unref0 (change_wallpaper);
	}
	_tmp18_ = self->priv->desktop_menu;
	gtk_menu_popup (_tmp18_, NULL, NULL, ___lambda24__gtk_menu_position_func, block3_data_ref (_data3_), (guint) 3, (guint32) GDK_CURRENT_TIME);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

GalaMenuDaemon*
gala_menu_daemon_construct (GType object_type)
{
	GalaMenuDaemon * self = NULL;
	self = (GalaMenuDaemon*) g_object_new (object_type, NULL);
	return self;
}

GalaMenuDaemon*
gala_menu_daemon_new (void)
{
	return gala_menu_daemon_construct (GALA_TYPE_MENU_DAEMON);
}

static void
gala_menu_daemon_class_init (GalaMenuDaemonClass * klass,
                             gpointer klass_data)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gala_menu_daemon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaMenuDaemon_private_offset);
	G_OBJECT_CLASS (klass)->finalize = gala_menu_daemon_finalize;
	_tmp0_ = g_settings_new ("org.gnome.desktop.wm.keybindings");
	_g_object_unref0 (gala_menu_daemon_keybind_settings);
	gala_menu_daemon_keybind_settings = _tmp0_;
	_tmp1_ = g_settings_new ("org.gnome.settings-daemon.plugins.media-keys");
	_g_object_unref0 (gala_menu_daemon_media_keys_settings);
	gala_menu_daemon_media_keys_settings = _tmp1_;
}

static void
gala_menu_daemon_instance_init (GalaMenuDaemon * self,
                                gpointer klass)
{
	self->priv = gala_menu_daemon_get_instance_private (self);
	self->priv->window_menu = NULL;
	self->priv->desktop_menu = NULL;
	self->priv->wm_proxy = NULL;
	self->priv->always_on_top_sid = (gulong) 0U;
	self->priv->on_visible_workspace_sid = (gulong) 0U;
}

static void
gala_menu_daemon_finalize (GObject * obj)
{
	GalaMenuDaemon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_MENU_DAEMON, GalaMenuDaemon);
	_g_object_unref0 (self->priv->always_on_top_accellabel);
	_g_object_unref0 (self->priv->close_accellabel);
	_g_object_unref0 (self->priv->hide_accellabel);
	_g_object_unref0 (self->priv->move_accellabel);
	_g_object_unref0 (self->priv->move_left_accellabel);
	_g_object_unref0 (self->priv->move_right_accellabel);
	_g_object_unref0 (self->priv->on_visible_workspace_accellabel);
	_g_object_unref0 (self->priv->resize_accellabel);
	_g_object_unref0 (self->priv->screenshot_accellabel);
	_g_object_unref0 (self->priv->window_menu);
	_g_object_unref0 (self->priv->hide);
	_g_object_unref0 (self->priv->maximize);
	_g_object_unref0 (self->priv->move);
	_g_object_unref0 (self->priv->resize);
	_g_object_unref0 (self->priv->always_on_top);
	_g_object_unref0 (self->priv->on_visible_workspace);
	_g_object_unref0 (self->priv->move_left);
	_g_object_unref0 (self->priv->move_right);
	_g_object_unref0 (self->priv->close);
	_g_object_unref0 (self->priv->screenshot);
	_g_object_unref0 (self->priv->desktop_menu);
	_g_object_unref0 (self->priv->wm_proxy);
	G_OBJECT_CLASS (gala_menu_daemon_parent_class)->finalize (obj);
}

static GType
gala_menu_daemon_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaMenuDaemonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_menu_daemon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaMenuDaemon), 0, (GInstanceInitFunc) gala_menu_daemon_instance_init, NULL };
	GType gala_menu_daemon_type_id;
	gala_menu_daemon_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaMenuDaemon", &g_define_type_info, 0);
	g_type_set_qdata (gala_menu_daemon_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) gala_menu_daemon_register_object);
	GalaMenuDaemon_private_offset = g_type_add_instance_private (gala_menu_daemon_type_id, sizeof (GalaMenuDaemonPrivate));
	return gala_menu_daemon_type_id;
}

GType
gala_menu_daemon_get_type (void)
{
	static volatile gsize gala_menu_daemon_type_id__once = 0;
	if (g_once_init_enter (&gala_menu_daemon_type_id__once)) {
		GType gala_menu_daemon_type_id;
		gala_menu_daemon_type_id = gala_menu_daemon_get_type_once ();
		g_once_init_leave (&gala_menu_daemon_type_id__once, gala_menu_daemon_type_id);
	}
	return gala_menu_daemon_type_id__once;
}

static void
_dbus_gala_menu_daemon_show_window_menu (GalaMenuDaemon* self,
                                         GVariant* _parameters_,
                                         GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GalaWindowFlags flags = 0U;
	GVariant* _tmp8_;
	gint x = 0;
	GVariant* _tmp9_;
	gint y = 0;
	GVariant* _tmp10_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp8_ = g_variant_iter_next_value (&_arguments_iter);
	flags = g_variant_get_uint32 (_tmp8_);
	g_variant_unref (_tmp8_);
	_tmp9_ = g_variant_iter_next_value (&_arguments_iter);
	x = g_variant_get_int32 (_tmp9_);
	g_variant_unref (_tmp9_);
	_tmp10_ = g_variant_iter_next_value (&_arguments_iter);
	y = g_variant_get_int32 (_tmp10_);
	g_variant_unref (_tmp10_);
	gala_menu_daemon_show_window_menu (self, flags, x, y, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_gala_menu_daemon_show_desktop_menu (GalaMenuDaemon* self,
                                          GVariant* _parameters_,
                                          GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gint x = 0;
	GVariant* _tmp11_;
	gint y = 0;
	GVariant* _tmp12_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp11_ = g_variant_iter_next_value (&_arguments_iter);
	x = g_variant_get_int32 (_tmp11_);
	g_variant_unref (_tmp11_);
	_tmp12_ = g_variant_iter_next_value (&_arguments_iter);
	y = g_variant_get_int32 (_tmp12_);
	g_variant_unref (_tmp12_);
	gala_menu_daemon_show_desktop_menu (self, x, y, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
gala_menu_daemon_dbus_interface_method_call (GDBusConnection* connection,
                                             const gchar* sender,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* method_name,
                                             GVariant* parameters,
                                             GDBusMethodInvocation* invocation,
                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ShowWindowMenu") == 0) {
		_dbus_gala_menu_daemon_show_window_menu (object, parameters, invocation);
	} else if (strcmp (method_name, "ShowDesktopMenu") == 0) {
		_dbus_gala_menu_daemon_show_desktop_menu (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
gala_menu_daemon_dbus_interface_get_property (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* property_name,
                                              GError** error,
                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
gala_menu_daemon_dbus_interface_set_property (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* property_name,
                                              GVariant* value,
                                              GError** error,
                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
gala_menu_daemon_register_object (gpointer object,
                                  GDBusConnection* connection,
                                  const gchar* path,
                                  GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_gala_menu_daemon_dbus_interface_info), &_gala_menu_daemon_dbus_interface_vtable, data, _gala_menu_daemon_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_gala_menu_daemon_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

