/* ActivatableComponent.c generated by valac 0.56.0, the Vala compiler
 * generated from ActivatableComponent.vala, do not modify */

/**/
/*  Copyright (C) 2014 Tom Beckmann*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "gala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

static GType gala_activatable_component_get_type_once (void);

/**
         * The component was requested to be opened.
         *
         * @param hints The hashmap may contain special parameters that are useful
         *              to the component. Currently, the only one implemented is the
         *              'all-windows' hint to the windowoverview.
         */
void
gala_activatable_component_open (GalaActivatableComponent* self,
                                 GHashTable* hints)
{
	GalaActivatableComponentIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GALA_ACTIVATABLE_COMPONENT_GET_INTERFACE (self);
	if (_iface_->open) {
		_iface_->open (self, hints);
	}
}

/**
         * The component was requested to be closed.
         *
         * @param hints The hashmap may contain special parameters that are useful
         *              to the component.
         */
void
gala_activatable_component_close (GalaActivatableComponent* self,
                                  GHashTable* hints)
{
	GalaActivatableComponentIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GALA_ACTIVATABLE_COMPONENT_GET_INTERFACE (self);
	if (_iface_->close) {
		_iface_->close (self, hints);
	}
}

/**
         * Should return whether the component is currently opened. Used mainly for
         * toggling by the window manager.
         *
         * @return Return true if the component is opened.
         */
gboolean
gala_activatable_component_is_opened (GalaActivatableComponent* self)
{
	GalaActivatableComponentIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GALA_ACTIVATABLE_COMPONENT_GET_INTERFACE (self);
	if (_iface_->is_opened) {
		return _iface_->is_opened (self);
	}
	return FALSE;
}

static void
gala_activatable_component_default_init (GalaActivatableComponentIface * iface,
                                         gpointer iface_data)
{
}

/**
     * Implement this interface on your {@link Plugin} class if you want to
     * replace a component like the window overview or the multitasking view.
     * It allows gala to hook up functionality like hotcorners and dbus
     * invocation of your component.
     */
static GType
gala_activatable_component_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaActivatableComponentIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_activatable_component_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gala_activatable_component_type_id;
	gala_activatable_component_type_id = g_type_register_static (G_TYPE_INTERFACE, "GalaActivatableComponent", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gala_activatable_component_type_id, G_TYPE_OBJECT);
	return gala_activatable_component_type_id;
}

GType
gala_activatable_component_get_type (void)
{
	static volatile gsize gala_activatable_component_type_id__once = 0;
	if (g_once_init_enter (&gala_activatable_component_type_id__once)) {
		GType gala_activatable_component_type_id;
		gala_activatable_component_type_id = gala_activatable_component_get_type_once ();
		g_once_init_leave (&gala_activatable_component_type_id__once, gala_activatable_component_type_id);
	}
	return gala_activatable_component_type_id__once;
}

