/* DragDropAction.c generated by valac 0.56.0, the Vala compiler
 * generated from DragDropAction.vala, do not modify */

/**/
/*  Copyright (C) 2013 Tom Beckmann*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "gala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <glib-object.h>

enum  {
	GALA_DRAG_DROP_ACTION_0_PROPERTY,
	GALA_DRAG_DROP_ACTION_DRAG_TYPE_PROPERTY,
	GALA_DRAG_DROP_ACTION_DRAG_ID_PROPERTY,
	GALA_DRAG_DROP_ACTION_HANDLE_PROPERTY,
	GALA_DRAG_DROP_ACTION_DRAGGING_PROPERTY,
	GALA_DRAG_DROP_ACTION_ALLOW_BUBBLING_PROPERTY,
	GALA_DRAG_DROP_ACTION_HOVERED_PROPERTY,
	GALA_DRAG_DROP_ACTION_NUM_PROPERTIES
};
static GParamSpec* gala_drag_drop_action_properties[GALA_DRAG_DROP_ACTION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	GALA_DRAG_DROP_ACTION_DRAG_BEGIN_SIGNAL,
	GALA_DRAG_DROP_ACTION_DRAG_CANCELED_SIGNAL,
	GALA_DRAG_DROP_ACTION_DRAG_END_SIGNAL,
	GALA_DRAG_DROP_ACTION_CROSSED_SIGNAL,
	GALA_DRAG_DROP_ACTION_DESTINATION_CROSSED_SIGNAL,
	GALA_DRAG_DROP_ACTION_ACTOR_CLICKED_SIGNAL,
	GALA_DRAG_DROP_ACTION_NUM_SIGNALS
};
static guint gala_drag_drop_action_signals[GALA_DRAG_DROP_ACTION_NUM_SIGNALS] = {0};

struct _GalaDragDropActionPrivate {
	GalaDragDropActionType _drag_type;
	gchar* _drag_id;
	ClutterActor* _handle;
	gboolean _dragging;
	gboolean _allow_bubbling;
	ClutterActor* _hovered;
	gboolean clicked;
	gfloat last_x;
	gfloat last_y;
};

static gint GalaDragDropAction_private_offset;
static gpointer gala_drag_drop_action_parent_class = NULL;
static GeeHashMap* gala_drag_drop_action_sources;
static GeeHashMap* gala_drag_drop_action_sources = NULL;
static GeeHashMap* gala_drag_drop_action_destinations;
static GeeHashMap* gala_drag_drop_action_destinations = NULL;

static void gala_drag_drop_action_release_actor (GalaDragDropAction* self,
                                          ClutterActor* actor);
static void gala_drag_drop_action_real_set_actor (ClutterActorMeta* base,
                                           ClutterActor* new_actor);
static void gala_drag_drop_action_connect_actor (GalaDragDropAction* self,
                                          ClutterActor* actor);
static gboolean gala_drag_drop_action_source_clicked (GalaDragDropAction* self,
                                               ClutterButtonEvent* event);
static gboolean _gala_drag_drop_action_source_clicked_clutter_actor_button_press_event (ClutterActor* _sender,
                                                                                 ClutterButtonEvent* event,
                                                                                 gpointer self);
static void gala_drag_drop_action_emit_crossed (GalaDragDropAction* self,
                                         ClutterActor* destination,
                                         gboolean is_hovered);
static GalaDragDropAction* gala_drag_drop_action_get_drag_drop_action (GalaDragDropAction* self,
                                                                ClutterActor* actor);
static gboolean gala_drag_drop_action_follow_move (GalaDragDropAction* self,
                                            ClutterEvent* event);
static gboolean _gala_drag_drop_action_follow_move_clutter_actor_captured_event (ClutterActor* _sender,
                                                                          ClutterEvent* event,
                                                                          gpointer self);
static void gala_drag_drop_action_set_handle (GalaDragDropAction* self,
                                       ClutterActor* value);
static void gala_drag_drop_action_set_dragging (GalaDragDropAction* self,
                                         gboolean value);
static ClutterActor* gala_drag_drop_action_get_hovered (GalaDragDropAction* self);
static void gala_drag_drop_action_finish (GalaDragDropAction* self);
static void gala_drag_drop_action_cleanup (GalaDragDropAction* self);
static void g_cclosure_user_marshal_OBJECT__FLOAT_FLOAT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static void gala_drag_drop_action_finalize (GObject * obj);
static GType gala_drag_drop_action_get_type_once (void);
static void _vala_gala_drag_drop_action_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_gala_drag_drop_action_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

static GType
gala_drag_drop_action_type_get_type_once (void)
{
	static const GFlagsValue values[] = {{GALA_DRAG_DROP_ACTION_TYPE_SOURCE, "GALA_DRAG_DROP_ACTION_TYPE_SOURCE", "source"}, {GALA_DRAG_DROP_ACTION_TYPE_DESTINATION, "GALA_DRAG_DROP_ACTION_TYPE_DESTINATION", "destination"}, {0, NULL, NULL}};
	GType gala_drag_drop_action_type_type_id;
	gala_drag_drop_action_type_type_id = g_flags_register_static ("GalaDragDropActionType", values);
	return gala_drag_drop_action_type_type_id;
}

GType
gala_drag_drop_action_type_get_type (void)
{
	static volatile gsize gala_drag_drop_action_type_type_id__once = 0;
	if (g_once_init_enter (&gala_drag_drop_action_type_type_id__once)) {
		GType gala_drag_drop_action_type_type_id;
		gala_drag_drop_action_type_type_id = gala_drag_drop_action_type_get_type_once ();
		g_once_init_leave (&gala_drag_drop_action_type_type_id__once, gala_drag_drop_action_type_type_id);
	}
	return gala_drag_drop_action_type_type_id__once;
}

static inline gpointer
gala_drag_drop_action_get_instance_private (GalaDragDropAction* self)
{
	return G_STRUCT_MEMBER_P (self, GalaDragDropAction_private_offset);
}

/**
         * Create a new DragDropAction
         *
         * @param type The type of this actor
         * @param id   An ID that marks which sources can be dragged on
         *             which destinations. It has to be the same for all actors that
         *             should be compatible with each other.
         */
GalaDragDropAction*
gala_drag_drop_action_construct (GType object_type,
                                 GalaDragDropActionType type,
                                 const gchar* id)
{
	GalaDragDropAction * self = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp2_;
	g_return_val_if_fail (id != NULL, NULL);
	self = (GalaDragDropAction*) g_object_new (object_type, "drag-type", type, "drag-id", id, NULL);
	_tmp0_ = gala_drag_drop_action_sources;
	if (_tmp0_ == NULL) {
		GeeHashMap* _tmp1_;
		_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_LINKED_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (gala_drag_drop_action_sources);
		gala_drag_drop_action_sources = _tmp1_;
	}
	_tmp2_ = gala_drag_drop_action_destinations;
	if (_tmp2_ == NULL) {
		GeeHashMap* _tmp3_;
		_tmp3_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_LINKED_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (gala_drag_drop_action_destinations);
		gala_drag_drop_action_destinations = _tmp3_;
	}
	return self;
}

GalaDragDropAction*
gala_drag_drop_action_new (GalaDragDropActionType type,
                           const gchar* id)
{
	return gala_drag_drop_action_construct (GALA_TYPE_DRAG_DROP_ACTION, type, id);
}

static void
gala_drag_drop_action_real_set_actor (ClutterActorMeta* base,
                                      ClutterActor* new_actor)
{
	GalaDragDropAction * self;
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	self = (GalaDragDropAction*) base;
	_tmp0_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ClutterActor* _tmp2_;
		ClutterActor* _tmp3_;
		_tmp2_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
		_tmp3_ = _tmp2_;
		gala_drag_drop_action_release_actor (self, _tmp3_);
	}
	if (new_actor != NULL) {
		gala_drag_drop_action_connect_actor (self, new_actor);
	}
	CLUTTER_ACTOR_META_CLASS (gala_drag_drop_action_parent_class)->set_actor ((ClutterActorMeta*) G_TYPE_CHECK_INSTANCE_CAST (self, clutter_action_get_type (), ClutterAction), new_actor);
}

static gboolean
_gala_drag_drop_action_source_clicked_clutter_actor_button_press_event (ClutterActor* _sender,
                                                                        ClutterButtonEvent* event,
                                                                        gpointer self)
{
	gboolean result;
	result = gala_drag_drop_action_source_clicked ((GalaDragDropAction*) self, event);
	return result;
}

static void
gala_drag_drop_action_release_actor (GalaDragDropAction* self,
                                     ClutterActor* actor)
{
	GalaDragDropActionType _tmp0_;
	GalaDragDropActionType _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (actor != NULL);
	_tmp0_ = self->priv->_drag_type;
	if ((_tmp0_ & GALA_DRAG_DROP_ACTION_TYPE_SOURCE) == GALA_DRAG_DROP_ACTION_TYPE_SOURCE) {
		guint _tmp1_;
		GeeLinkedList* source_list = NULL;
		GeeHashMap* _tmp2_;
		const gchar* _tmp3_;
		gpointer _tmp4_;
		GeeLinkedList* _tmp5_;
		g_signal_parse_name ("button-press-event", clutter_actor_get_type (), &_tmp1_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (actor, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _gala_drag_drop_action_source_clicked_clutter_actor_button_press_event, self);
		_tmp2_ = gala_drag_drop_action_sources;
		_tmp3_ = self->priv->_drag_id;
		_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, _tmp3_);
		source_list = (GeeLinkedList*) _tmp4_;
		_tmp5_ = source_list;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp5_, actor);
		_g_object_unref0 (source_list);
	}
	_tmp6_ = self->priv->_drag_type;
	if ((_tmp6_ & GALA_DRAG_DROP_ACTION_TYPE_DESTINATION) == GALA_DRAG_DROP_ACTION_TYPE_DESTINATION) {
		GeeLinkedList* dest_list = NULL;
		GeeHashMap* _tmp7_;
		const gchar* _tmp8_;
		gpointer _tmp9_;
		GeeLinkedList* _tmp10_;
		_tmp7_ = gala_drag_drop_action_destinations;
		_tmp8_ = self->priv->_drag_id;
		_tmp9_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp7_, _tmp8_);
		dest_list = (GeeLinkedList*) _tmp9_;
		_tmp10_ = dest_list;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp10_, actor);
		_g_object_unref0 (dest_list);
	}
}

static void
gala_drag_drop_action_connect_actor (GalaDragDropAction* self,
                                     ClutterActor* actor)
{
	GalaDragDropActionType _tmp0_;
	GalaDragDropActionType _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (actor != NULL);
	_tmp0_ = self->priv->_drag_type;
	if ((_tmp0_ & GALA_DRAG_DROP_ACTION_TYPE_SOURCE) == GALA_DRAG_DROP_ACTION_TYPE_SOURCE) {
		GeeLinkedList* source_list = NULL;
		GeeHashMap* _tmp1_;
		const gchar* _tmp2_;
		gpointer _tmp3_;
		GeeLinkedList* _tmp4_;
		GeeLinkedList* _tmp9_;
		g_signal_connect_object (actor, "button-press-event", (GCallback) _gala_drag_drop_action_source_clicked_clutter_actor_button_press_event, self, 0);
		_tmp1_ = gala_drag_drop_action_sources;
		_tmp2_ = self->priv->_drag_id;
		_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, _tmp2_);
		source_list = (GeeLinkedList*) _tmp3_;
		_tmp4_ = source_list;
		if (_tmp4_ == NULL) {
			GeeLinkedList* _tmp5_;
			GeeHashMap* _tmp6_;
			const gchar* _tmp7_;
			GeeLinkedList* _tmp8_;
			_tmp5_ = gee_linked_list_new (clutter_actor_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
			_g_object_unref0 (source_list);
			source_list = _tmp5_;
			_tmp6_ = gala_drag_drop_action_sources;
			_tmp7_ = self->priv->_drag_id;
			_tmp8_ = source_list;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp6_, _tmp7_, _tmp8_);
		}
		_tmp9_ = source_list;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, actor);
		_g_object_unref0 (source_list);
	}
	_tmp10_ = self->priv->_drag_type;
	if ((_tmp10_ & GALA_DRAG_DROP_ACTION_TYPE_DESTINATION) == GALA_DRAG_DROP_ACTION_TYPE_DESTINATION) {
		GeeLinkedList* dest_list = NULL;
		GeeHashMap* _tmp11_;
		const gchar* _tmp12_;
		gpointer _tmp13_;
		GeeLinkedList* _tmp14_;
		GeeLinkedList* _tmp19_;
		_tmp11_ = gala_drag_drop_action_destinations;
		_tmp12_ = self->priv->_drag_id;
		_tmp13_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp11_, _tmp12_);
		dest_list = (GeeLinkedList*) _tmp13_;
		_tmp14_ = dest_list;
		if (_tmp14_ == NULL) {
			GeeLinkedList* _tmp15_;
			GeeHashMap* _tmp16_;
			const gchar* _tmp17_;
			GeeLinkedList* _tmp18_;
			_tmp15_ = gee_linked_list_new (clutter_actor_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
			_g_object_unref0 (dest_list);
			dest_list = _tmp15_;
			_tmp16_ = gala_drag_drop_action_destinations;
			_tmp17_ = self->priv->_drag_id;
			_tmp18_ = dest_list;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp16_, _tmp17_, _tmp18_);
		}
		_tmp19_ = dest_list;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, actor);
		_g_object_unref0 (dest_list);
	}
}

static void
gala_drag_drop_action_emit_crossed (GalaDragDropAction* self,
                                    ClutterActor* destination,
                                    gboolean is_hovered)
{
	GalaDragDropAction* _tmp0_;
	GalaDragDropAction* _tmp1_;
	ClutterActor* _tmp2_;
	ClutterActor* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (destination != NULL);
	_tmp0_ = gala_drag_drop_action_get_drag_drop_action (self, destination);
	_tmp1_ = _tmp0_;
	_tmp2_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
	_tmp3_ = _tmp2_;
	g_signal_emit (_tmp1_, gala_drag_drop_action_signals[GALA_DRAG_DROP_ACTION_CROSSED_SIGNAL], 0, _tmp3_, is_hovered);
	_g_object_unref0 (_tmp1_);
	g_signal_emit (self, gala_drag_drop_action_signals[GALA_DRAG_DROP_ACTION_DESTINATION_CROSSED_SIGNAL], 0, destination, is_hovered);
}

static gboolean
_gala_drag_drop_action_follow_move_clutter_actor_captured_event (ClutterActor* _sender,
                                                                 ClutterEvent* event,
                                                                 gpointer self)
{
	gboolean result;
	result = gala_drag_drop_action_follow_move ((GalaDragDropAction*) self, event);
	return result;
}

static gboolean
gala_drag_drop_action_source_clicked (GalaDragDropAction* self,
                                      ClutterButtonEvent* event)
{
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	ClutterStage* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->button != ((guint32) 1)) {
		g_signal_emit (self, gala_drag_drop_action_signals[GALA_DRAG_DROP_ACTION_ACTOR_CLICKED_SIGNAL], 0, event->button);
		result = FALSE;
		return result;
	}
	_tmp0_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = clutter_actor_get_stage (_tmp1_);
	g_signal_connect_object ((ClutterActor*) _tmp2_, "captured-event", (GCallback) _gala_drag_drop_action_follow_move_clutter_actor_captured_event, self, 0);
	self->priv->clicked = TRUE;
	self->priv->last_x = event->x;
	self->priv->last_y = event->y;
	result = TRUE;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
gala_drag_drop_action_follow_move (GalaDragDropAction* self,
                                   ClutterEvent* event)
{
	gboolean _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->_dragging;
	if (!_tmp0_) {
		switch (clutter_event_type (event)) {
			case CLUTTER_MOTION:
			{
				gfloat x = 0.0F;
				gfloat y = 0.0F;
				gfloat _tmp1_ = 0.0F;
				gfloat _tmp2_ = 0.0F;
				gint drag_threshold = 0;
				ClutterSettings* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				gboolean _tmp6_ = FALSE;
				clutter_event_get_coords (event, &_tmp1_, &_tmp2_);
				x = _tmp1_;
				y = _tmp2_;
				_tmp3_ = clutter_settings_get_default ();
				g_object_get (_tmp3_, "dnd-drag-threshold", &_tmp4_, NULL);
				_tmp5_ = _tmp4_;
				drag_threshold = _tmp5_;
				if (fabsf (self->priv->last_x - x) > ((gfloat) drag_threshold)) {
					_tmp6_ = TRUE;
				} else {
					_tmp6_ = fabsf (self->priv->last_y - y) > ((gfloat) drag_threshold);
				}
				if (_tmp6_) {
					ClutterActor* _tmp7_ = NULL;
					ClutterActor* _tmp8_;
					ClutterActor* _tmp9_;
					ClutterActor* _tmp14_;
					GeeLinkedList* source_list = NULL;
					GeeHashMap* _tmp15_;
					const gchar* _tmp16_;
					gpointer _tmp17_;
					GeeLinkedList* _tmp18_;
					g_signal_emit (self, gala_drag_drop_action_signals[GALA_DRAG_DROP_ACTION_DRAG_BEGIN_SIGNAL], 0, x, y, &_tmp7_);
					_tmp8_ = _tmp7_;
					gala_drag_drop_action_set_handle (self, _tmp8_);
					_g_object_unref0 (_tmp8_);
					_tmp9_ = self->priv->_handle;
					if (_tmp9_ == NULL) {
						ClutterActor* _tmp10_;
						ClutterActor* _tmp11_;
						ClutterStage* _tmp12_;
						guint _tmp13_;
						_tmp10_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
						_tmp11_ = _tmp10_;
						_tmp12_ = clutter_actor_get_stage (_tmp11_);
						g_signal_parse_name ("captured-event", clutter_actor_get_type (), &_tmp13_, NULL, FALSE);
						g_signal_handlers_disconnect_matched ((ClutterActor*) _tmp12_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp13_, 0, NULL, (GCallback) _gala_drag_drop_action_follow_move_clutter_actor_captured_event, self);
						g_critical ("DragDropAction.vala:212: No handle has been returned by the started si" \
"gnal, aborting drag.");
						result = FALSE;
						return result;
					}
					_tmp14_ = self->priv->_handle;
					clutter_actor_set_reactive (_tmp14_, FALSE);
					self->priv->clicked = FALSE;
					gala_drag_drop_action_set_dragging (self, TRUE);
					_tmp15_ = gala_drag_drop_action_sources;
					_tmp16_ = self->priv->_drag_id;
					_tmp17_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp15_, _tmp16_);
					source_list = (GeeLinkedList*) _tmp17_;
					_tmp18_ = source_list;
					if (_tmp18_ != NULL) {
						GeeLinkedList* dest_list = NULL;
						GeeHashMap* _tmp19_;
						const gchar* _tmp20_;
						gpointer _tmp21_;
						_tmp19_ = gala_drag_drop_action_destinations;
						_tmp20_ = self->priv->_drag_id;
						_tmp21_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp19_, _tmp20_);
						dest_list = (GeeLinkedList*) _tmp21_;
						{
							GeeLinkedList* _actor_list = NULL;
							GeeLinkedList* _tmp22_;
							gint _actor_size = 0;
							GeeLinkedList* _tmp23_;
							gint _tmp24_;
							gint _tmp25_;
							gint _actor_index = 0;
							_tmp22_ = source_list;
							_actor_list = _tmp22_;
							_tmp23_ = _actor_list;
							_tmp24_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp23_);
							_tmp25_ = _tmp24_;
							_actor_size = _tmp25_;
							_actor_index = -1;
							while (TRUE) {
								gint _tmp26_;
								gint _tmp27_;
								ClutterActor* actor = NULL;
								GeeLinkedList* _tmp28_;
								gpointer _tmp29_;
								gboolean _tmp30_ = FALSE;
								GeeLinkedList* _tmp31_;
								ClutterActor* _tmp34_;
								_actor_index = _actor_index + 1;
								_tmp26_ = _actor_index;
								_tmp27_ = _actor_size;
								if (!(_tmp26_ < _tmp27_)) {
									break;
								}
								_tmp28_ = _actor_list;
								_tmp29_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, _actor_index);
								actor = (ClutterActor*) _tmp29_;
								_tmp31_ = dest_list;
								if (_tmp31_ == NULL) {
									_tmp30_ = TRUE;
								} else {
									GeeLinkedList* _tmp32_;
									ClutterActor* _tmp33_;
									_tmp32_ = dest_list;
									_tmp33_ = actor;
									_tmp30_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp32_, _tmp33_);
								}
								if (_tmp30_) {
									_g_object_unref0 (actor);
									continue;
								}
								_tmp34_ = actor;
								clutter_actor_set_reactive (_tmp34_, FALSE);
								_g_object_unref0 (actor);
							}
						}
						_g_object_unref0 (dest_list);
					}
					_g_object_unref0 (source_list);
				}
				result = TRUE;
				return result;
			}
			case CLUTTER_BUTTON_RELEASE:
			{
				gfloat x = 0.0F;
				gfloat y = 0.0F;
				gfloat ex = 0.0F;
				gfloat ey = 0.0F;
				gfloat _tmp35_ = 0.0F;
				gfloat _tmp36_ = 0.0F;
				ClutterActor* _tmp37_;
				ClutterActor* _tmp38_;
				gfloat _tmp39_ = 0.0F;
				gfloat _tmp40_ = 0.0F;
				gboolean _tmp41_ = FALSE;
				gboolean _tmp42_ = FALSE;
				gboolean _tmp43_ = FALSE;
				ClutterActor* _tmp52_;
				ClutterActor* _tmp53_;
				ClutterStage* _tmp54_;
				guint _tmp55_;
				clutter_event_get_coords (event, &_tmp35_, &_tmp36_);
				ex = _tmp35_;
				ey = _tmp36_;
				_tmp37_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
				_tmp38_ = _tmp37_;
				clutter_actor_get_transformed_position (_tmp38_, &_tmp39_, &_tmp40_);
				x = _tmp39_;
				y = _tmp40_;
				if (x < ex) {
					ClutterActor* _tmp44_;
					ClutterActor* _tmp45_;
					gfloat _tmp46_;
					gfloat _tmp47_;
					_tmp44_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
					_tmp45_ = _tmp44_;
					_tmp46_ = clutter_actor_get_width (_tmp45_);
					_tmp47_ = _tmp46_;
					_tmp43_ = (x + _tmp47_) > ex;
				} else {
					_tmp43_ = FALSE;
				}
				if (_tmp43_) {
					_tmp42_ = y < ey;
				} else {
					_tmp42_ = FALSE;
				}
				if (_tmp42_) {
					ClutterActor* _tmp48_;
					ClutterActor* _tmp49_;
					gfloat _tmp50_;
					gfloat _tmp51_;
					_tmp48_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
					_tmp49_ = _tmp48_;
					_tmp50_ = clutter_actor_get_height (_tmp49_);
					_tmp51_ = _tmp50_;
					_tmp41_ = (y + _tmp51_) > ey;
				} else {
					_tmp41_ = FALSE;
				}
				if (_tmp41_) {
					g_signal_emit (self, gala_drag_drop_action_signals[GALA_DRAG_DROP_ACTION_ACTOR_CLICKED_SIGNAL], 0, clutter_event_get_button (event));
				}
				_tmp52_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
				_tmp53_ = _tmp52_;
				_tmp54_ = clutter_actor_get_stage (_tmp53_);
				g_signal_parse_name ("captured-event", clutter_actor_get_type (), &_tmp55_, NULL, FALSE);
				g_signal_handlers_disconnect_matched ((ClutterActor*) _tmp54_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp55_, 0, NULL, (GCallback) _gala_drag_drop_action_follow_move_clutter_actor_captured_event, self);
				self->priv->clicked = FALSE;
				gala_drag_drop_action_set_dragging (self, FALSE);
				result = TRUE;
				return result;
			}
			default:
			{
				result = TRUE;
				return result;
			}
		}
	}
	switch (clutter_event_type (event)) {
		case CLUTTER_KEY_PRESS:
		{
			if (((guint) clutter_event_get_key_code (event)) == CLUTTER_KEY_Escape) {
				gala_drag_drop_action_cancel (self);
			}
			result = TRUE;
			return result;
		}
		case CLUTTER_MOTION:
		{
			gfloat x = 0.0F;
			gfloat y = 0.0F;
			gfloat _tmp56_ = 0.0F;
			gfloat _tmp57_ = 0.0F;
			ClutterActor* _tmp58_;
			ClutterActor* _tmp59_;
			gfloat _tmp60_;
			gfloat _tmp61_;
			ClutterActor* _tmp62_;
			ClutterActor* _tmp63_;
			gfloat _tmp64_;
			gfloat _tmp65_;
			ClutterStage* stage = NULL;
			ClutterActor* _tmp66_;
			ClutterActor* _tmp67_;
			ClutterStage* _tmp68_;
			ClutterStage* _tmp69_;
			ClutterActor* actor = NULL;
			ClutterStage* _tmp70_;
			ClutterActor* _tmp71_;
			ClutterActor* _tmp72_;
			GalaDragDropAction* action = NULL;
			gboolean _tmp73_ = FALSE;
			gboolean _tmp74_ = FALSE;
			ClutterActor* _tmp75_;
			ClutterActor* _tmp88_;
			ClutterActor* _tmp89_;
			GalaDragDropAction* _tmp90_;
			ClutterActor* _tmp93_;
			ClutterActor* _tmp95_;
			ClutterActor* _tmp96_;
			clutter_event_get_coords (event, &_tmp56_, &_tmp57_);
			x = _tmp56_;
			y = _tmp57_;
			_tmp58_ = self->priv->_handle;
			_tmp59_ = self->priv->_handle;
			_tmp60_ = clutter_actor_get_x (_tmp59_);
			_tmp61_ = _tmp60_;
			clutter_actor_set_x (_tmp59_, _tmp61_ - (self->priv->last_x - x));
			_tmp62_ = self->priv->_handle;
			_tmp63_ = self->priv->_handle;
			_tmp64_ = clutter_actor_get_y (_tmp63_);
			_tmp65_ = _tmp64_;
			clutter_actor_set_y (_tmp63_, _tmp65_ - (self->priv->last_y - y));
			self->priv->last_x = x;
			self->priv->last_y = y;
			_tmp66_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
			_tmp67_ = _tmp66_;
			_tmp68_ = clutter_actor_get_stage (_tmp67_);
			_tmp69_ = _g_object_ref0 (_tmp68_);
			stage = _tmp69_;
			_tmp70_ = stage;
			_tmp71_ = clutter_stage_get_actor_at_pos (_tmp70_, CLUTTER_PICK_REACTIVE, (gfloat) ((gint) x), (gfloat) ((gint) y));
			_tmp72_ = _g_object_ref0 (_tmp71_);
			actor = _tmp72_;
			action = NULL;
			_tmp75_ = actor;
			if (_tmp75_ != NULL) {
				ClutterActor* _tmp76_;
				GalaDragDropAction* _tmp77_;
				GalaDragDropAction* _tmp78_;
				_tmp76_ = actor;
				_tmp77_ = gala_drag_drop_action_get_drag_drop_action (self, _tmp76_);
				_g_object_unref0 (action);
				action = _tmp77_;
				_tmp78_ = action;
				_tmp74_ = _tmp78_ == NULL;
			} else {
				_tmp74_ = FALSE;
			}
			if (_tmp74_) {
				gboolean _tmp79_;
				_tmp79_ = self->priv->_allow_bubbling;
				_tmp73_ = _tmp79_;
			} else {
				_tmp73_ = FALSE;
			}
			if (_tmp73_) {
				while (TRUE) {
					ClutterActor* _tmp80_;
					ClutterActor* _tmp81_;
					ClutterActor* _tmp82_;
					ClutterActor* _tmp83_;
					ClutterStage* _tmp84_;
					ClutterActor* _tmp85_;
					GalaDragDropAction* _tmp86_;
					GalaDragDropAction* _tmp87_;
					_tmp80_ = actor;
					_tmp81_ = clutter_actor_get_parent (_tmp80_);
					_tmp82_ = _g_object_ref0 (_tmp81_);
					_g_object_unref0 (actor);
					actor = _tmp82_;
					_tmp83_ = actor;
					_tmp84_ = stage;
					if (!(_tmp83_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp84_, clutter_actor_get_type (), ClutterActor))) {
						break;
					}
					_tmp85_ = actor;
					_tmp86_ = gala_drag_drop_action_get_drag_drop_action (self, _tmp85_);
					_g_object_unref0 (action);
					action = _tmp86_;
					_tmp87_ = action;
					if (_tmp87_ != NULL) {
						break;
					}
				}
			}
			_tmp88_ = actor;
			_tmp89_ = self->priv->_hovered;
			if (_tmp88_ == _tmp89_) {
				result = TRUE;
				_g_object_unref0 (action);
				_g_object_unref0 (actor);
				_g_object_unref0 (stage);
				return result;
			}
			_tmp90_ = action;
			if (_tmp90_ == NULL) {
				ClutterActor* _tmp91_;
				_tmp91_ = self->priv->_hovered;
				if (_tmp91_ != NULL) {
					ClutterActor* _tmp92_;
					_tmp92_ = self->priv->_hovered;
					gala_drag_drop_action_emit_crossed (self, _tmp92_, FALSE);
					gala_drag_drop_action_set_hovered (self, NULL);
				}
				result = TRUE;
				_g_object_unref0 (action);
				_g_object_unref0 (actor);
				_g_object_unref0 (stage);
				return result;
			}
			_tmp93_ = self->priv->_hovered;
			if (_tmp93_ != NULL) {
				ClutterActor* _tmp94_;
				_tmp94_ = self->priv->_hovered;
				gala_drag_drop_action_emit_crossed (self, _tmp94_, FALSE);
			}
			_tmp95_ = actor;
			gala_drag_drop_action_set_hovered (self, _tmp95_);
			_tmp96_ = self->priv->_hovered;
			gala_drag_drop_action_emit_crossed (self, _tmp96_, TRUE);
			result = TRUE;
			_g_object_unref0 (action);
			_g_object_unref0 (actor);
			_g_object_unref0 (stage);
			return result;
		}
		case CLUTTER_BUTTON_RELEASE:
		{
			ClutterActor* _tmp97_;
			_tmp97_ = self->priv->_hovered;
			if (_tmp97_ != NULL) {
				gala_drag_drop_action_finish (self);
			} else {
				gala_drag_drop_action_cancel (self);
			}
			result = TRUE;
			return result;
		}
		case CLUTTER_ENTER:
		case CLUTTER_LEAVE:
		{
			result = TRUE;
			return result;
		}
		default:
		break;
	}
	result = FALSE;
	return result;
}

/**
         * Looks for a DragDropAction instance if this actor has one or NULL.
         * It also checks if it is a DESTINATION and if the id matches
         *
         * @return the DragDropAction instance on this actor or NULL
         */
static GalaDragDropAction*
gala_drag_drop_action_get_drag_drop_action (GalaDragDropAction* self,
                                            ClutterActor* actor)
{
	GalaDragDropAction* drop_action = NULL;
	GList* _tmp0_;
	GalaDragDropAction* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (actor != NULL, NULL);
	drop_action = NULL;
	_tmp0_ = clutter_actor_get_actions (actor);
	{
		GList* action_collection = NULL;
		GList* action_it = NULL;
		action_collection = _tmp0_;
		for (action_it = action_collection; action_it != NULL; action_it = action_it->next) {
			ClutterAction* action = NULL;
			action = (ClutterAction*) action_it->data;
			{
				ClutterAction* _tmp1_;
				GalaDragDropAction* _tmp2_;
				gboolean _tmp3_ = FALSE;
				gboolean _tmp4_ = FALSE;
				GalaDragDropAction* _tmp5_;
				_tmp1_ = action;
				_tmp2_ = _g_object_ref0 (GALA_IS_DRAG_DROP_ACTION (_tmp1_) ? ((GalaDragDropAction*) _tmp1_) : NULL);
				_g_object_unref0 (drop_action);
				drop_action = _tmp2_;
				_tmp5_ = drop_action;
				if (_tmp5_ == NULL) {
					_tmp4_ = TRUE;
				} else {
					GalaDragDropAction* _tmp6_;
					GalaDragDropActionType _tmp7_;
					_tmp6_ = drop_action;
					_tmp7_ = _tmp6_->priv->_drag_type;
					_tmp4_ = !((_tmp7_ & GALA_DRAG_DROP_ACTION_TYPE_DESTINATION) == GALA_DRAG_DROP_ACTION_TYPE_DESTINATION);
				}
				if (_tmp4_) {
					_tmp3_ = TRUE;
				} else {
					GalaDragDropAction* _tmp8_;
					const gchar* _tmp9_;
					const gchar* _tmp10_;
					_tmp8_ = drop_action;
					_tmp9_ = _tmp8_->priv->_drag_id;
					_tmp10_ = self->priv->_drag_id;
					_tmp3_ = g_strcmp0 (_tmp9_, _tmp10_) != 0;
				}
				if (_tmp3_) {
					continue;
				}
				result = drop_action;
				(action_collection == NULL) ? NULL : (action_collection = (g_list_free (action_collection), NULL));
				return result;
			}
		}
		(action_collection == NULL) ? NULL : (action_collection = (g_list_free (action_collection), NULL));
	}
	result = NULL;
	_g_object_unref0 (drop_action);
	return result;
}

/**
         * Abort the drag
         */
void
gala_drag_drop_action_cancel (GalaDragDropAction* self)
{
	g_return_if_fail (self != NULL);
	gala_drag_drop_action_cleanup (self);
	g_signal_emit (self, gala_drag_drop_action_signals[GALA_DRAG_DROP_ACTION_DRAG_CANCELED_SIGNAL], 0);
}

/**
         * Allows you to abort all drags currently running for a given drag-id
         */
void
gala_drag_drop_action_cancel_all_by_id (const gchar* id)
{
	GeeLinkedList* actors = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GeeLinkedList* _tmp2_;
	g_return_if_fail (id != NULL);
	_tmp0_ = gala_drag_drop_action_sources;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, id);
	actors = (GeeLinkedList*) _tmp1_;
	_tmp2_ = actors;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (actors);
		return;
	}
	{
		GeeLinkedList* _actor_list = NULL;
		GeeLinkedList* _tmp3_;
		gint _actor_size = 0;
		GeeLinkedList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _actor_index = 0;
		_tmp3_ = actors;
		_actor_list = _tmp3_;
		_tmp4_ = _actor_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_actor_size = _tmp6_;
		_actor_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			ClutterActor* actor = NULL;
			GeeLinkedList* _tmp9_;
			gpointer _tmp10_;
			ClutterActor* _tmp11_;
			GList* _tmp12_;
			_actor_index = _actor_index + 1;
			_tmp7_ = _actor_index;
			_tmp8_ = _actor_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _actor_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _actor_index);
			actor = (ClutterActor*) _tmp10_;
			_tmp11_ = actor;
			_tmp12_ = clutter_actor_get_actions (_tmp11_);
			{
				GList* action_collection = NULL;
				GList* action_it = NULL;
				action_collection = _tmp12_;
				for (action_it = action_collection; action_it != NULL; action_it = action_it->next) {
					ClutterAction* action = NULL;
					action = (ClutterAction*) action_it->data;
					{
						GalaDragDropAction* drag_action = NULL;
						ClutterAction* _tmp13_;
						GalaDragDropAction* _tmp14_;
						gboolean _tmp15_ = FALSE;
						GalaDragDropAction* _tmp16_;
						_tmp13_ = action;
						_tmp14_ = _g_object_ref0 (GALA_IS_DRAG_DROP_ACTION (_tmp13_) ? ((GalaDragDropAction*) _tmp13_) : NULL);
						drag_action = _tmp14_;
						_tmp16_ = drag_action;
						if (_tmp16_ != NULL) {
							GalaDragDropAction* _tmp17_;
							gboolean _tmp18_;
							_tmp17_ = drag_action;
							_tmp18_ = _tmp17_->priv->_dragging;
							_tmp15_ = _tmp18_;
						} else {
							_tmp15_ = FALSE;
						}
						if (_tmp15_) {
							GalaDragDropAction* _tmp19_;
							_tmp19_ = drag_action;
							gala_drag_drop_action_cancel (_tmp19_);
							_g_object_unref0 (drag_action);
							break;
						}
						_g_object_unref0 (drag_action);
					}
				}
				(action_collection == NULL) ? NULL : (action_collection = (g_list_free (action_collection), NULL));
			}
			_g_object_unref0 (actor);
		}
	}
	_g_object_unref0 (actors);
}

static void
gala_drag_drop_action_finish (GalaDragDropAction* self)
{
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_hovered;
	gala_drag_drop_action_emit_crossed (self, _tmp0_, FALSE);
	gala_drag_drop_action_cleanup (self);
	_tmp1_ = self->priv->_hovered;
	g_signal_emit (self, gala_drag_drop_action_signals[GALA_DRAG_DROP_ACTION_DRAG_END_SIGNAL], 0, _tmp1_);
}

static void
gala_drag_drop_action_cleanup (GalaDragDropAction* self)
{
	GeeLinkedList* source_list = NULL;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_;
	GeeLinkedList* _tmp3_;
	gboolean _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gala_drag_drop_action_sources;
	_tmp1_ = self->priv->_drag_id;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
	source_list = (GeeLinkedList*) _tmp2_;
	_tmp3_ = source_list;
	if (_tmp3_ != NULL) {
		{
			GeeLinkedList* _actor_list = NULL;
			GeeLinkedList* _tmp4_;
			gint _actor_size = 0;
			GeeLinkedList* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gint _actor_index = 0;
			_tmp4_ = source_list;
			_actor_list = _tmp4_;
			_tmp5_ = _actor_list;
			_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
			_tmp7_ = _tmp6_;
			_actor_size = _tmp7_;
			_actor_index = -1;
			while (TRUE) {
				gint _tmp8_;
				gint _tmp9_;
				ClutterActor* actor = NULL;
				GeeLinkedList* _tmp10_;
				gpointer _tmp11_;
				ClutterActor* _tmp12_;
				_actor_index = _actor_index + 1;
				_tmp8_ = _actor_index;
				_tmp9_ = _actor_size;
				if (!(_tmp8_ < _tmp9_)) {
					break;
				}
				_tmp10_ = _actor_list;
				_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _actor_index);
				actor = (ClutterActor*) _tmp11_;
				_tmp12_ = actor;
				clutter_actor_set_reactive (_tmp12_, TRUE);
				_g_object_unref0 (actor);
			}
		}
	}
	_tmp13_ = self->priv->_dragging;
	if (_tmp13_) {
		ClutterActor* _tmp14_;
		ClutterActor* _tmp15_;
		ClutterStage* _tmp16_;
		guint _tmp17_;
		_tmp14_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
		_tmp15_ = _tmp14_;
		_tmp16_ = clutter_actor_get_stage (_tmp15_);
		g_signal_parse_name ("captured-event", clutter_actor_get_type (), &_tmp17_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((ClutterActor*) _tmp16_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp17_, 0, NULL, (GCallback) _gala_drag_drop_action_follow_move_clutter_actor_captured_event, self);
	}
	gala_drag_drop_action_set_dragging (self, FALSE);
	_g_object_unref0 (source_list);
}

GalaDragDropActionType
gala_drag_drop_action_get_drag_type (GalaDragDropAction* self)
{
	GalaDragDropActionType result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_drag_type;
	return result;
}

static void
gala_drag_drop_action_set_drag_type (GalaDragDropAction* self,
                                     GalaDragDropActionType value)
{
	GalaDragDropActionType old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_drag_drop_action_get_drag_type (self);
	if (old_value != value) {
		self->priv->_drag_type = value;
		g_object_notify_by_pspec ((GObject *) self, gala_drag_drop_action_properties[GALA_DRAG_DROP_ACTION_DRAG_TYPE_PROPERTY]);
	}
}

const gchar*
gala_drag_drop_action_get_drag_id (GalaDragDropAction* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_drag_id;
	result = _tmp0_;
	return result;
}

static void
gala_drag_drop_action_set_drag_id (GalaDragDropAction* self,
                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_drag_drop_action_get_drag_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_drag_id);
		self->priv->_drag_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_drag_drop_action_properties[GALA_DRAG_DROP_ACTION_DRAG_ID_PROPERTY]);
	}
}

ClutterActor*
gala_drag_drop_action_get_handle (GalaDragDropAction* self)
{
	ClutterActor* result;
	ClutterActor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_handle;
	result = _tmp0_;
	return result;
}

static void
gala_drag_drop_action_set_handle (GalaDragDropAction* self,
                                  ClutterActor* value)
{
	ClutterActor* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_drag_drop_action_get_handle (self);
	if (old_value != value) {
		ClutterActor* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_handle);
		self->priv->_handle = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_drag_drop_action_properties[GALA_DRAG_DROP_ACTION_HANDLE_PROPERTY]);
	}
}

gboolean
gala_drag_drop_action_get_dragging (GalaDragDropAction* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_dragging;
	return result;
}

static void
gala_drag_drop_action_set_dragging (GalaDragDropAction* self,
                                    gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_drag_drop_action_get_dragging (self);
	if (old_value != value) {
		self->priv->_dragging = value;
		g_object_notify_by_pspec ((GObject *) self, gala_drag_drop_action_properties[GALA_DRAG_DROP_ACTION_DRAGGING_PROPERTY]);
	}
}

gboolean
gala_drag_drop_action_get_allow_bubbling (GalaDragDropAction* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_allow_bubbling;
	return result;
}

void
gala_drag_drop_action_set_allow_bubbling (GalaDragDropAction* self,
                                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_drag_drop_action_get_allow_bubbling (self);
	if (old_value != value) {
		self->priv->_allow_bubbling = value;
		g_object_notify_by_pspec ((GObject *) self, gala_drag_drop_action_properties[GALA_DRAG_DROP_ACTION_ALLOW_BUBBLING_PROPERTY]);
	}
}

static ClutterActor*
gala_drag_drop_action_get_hovered (GalaDragDropAction* self)
{
	ClutterActor* result;
	ClutterActor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_hovered;
	result = _tmp0_;
	return result;
}

void
gala_drag_drop_action_set_hovered (GalaDragDropAction* self,
                                   ClutterActor* value)
{
	ClutterActor* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_drag_drop_action_get_hovered (self);
	if (old_value != value) {
		ClutterActor* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_hovered);
		self->priv->_hovered = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_drag_drop_action_properties[GALA_DRAG_DROP_ACTION_HOVERED_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_OBJECT__FLOAT_FLOAT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef gpointer (*GMarshalFunc_OBJECT__FLOAT_FLOAT) (gpointer data1, gfloat arg_1, gfloat arg_2, gpointer data2);
	register GMarshalFunc_OBJECT__FLOAT_FLOAT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gpointer v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_OBJECT__FLOAT_FLOAT) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_float (param_values + 1), g_value_get_float (param_values + 2), data2);
	g_value_take_object (return_value, v_return);
}

static void
g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_BOOLEAN) (gpointer data1, gpointer arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}

static void
gala_drag_drop_action_class_init (GalaDragDropActionClass * klass,
                                  gpointer klass_data)
{
	gala_drag_drop_action_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaDragDropAction_private_offset);
	((ClutterActorMetaClass *) klass)->set_actor = (void (*) (ClutterActorMeta*, ClutterActor*)) gala_drag_drop_action_real_set_actor;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_drag_drop_action_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_drag_drop_action_set_property;
	G_OBJECT_CLASS (klass)->finalize = gala_drag_drop_action_finalize;
	/**
	         * The type of the action
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_DRAG_DROP_ACTION_DRAG_TYPE_PROPERTY, gala_drag_drop_action_properties[GALA_DRAG_DROP_ACTION_DRAG_TYPE_PROPERTY] = g_param_spec_flags ("drag-type", "drag-type", "drag-type", GALA_TYPE_DRAG_DROP_ACTION_TYPE, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	         * The unique id given to this drag-drop-group
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_DRAG_DROP_ACTION_DRAG_ID_PROPERTY, gala_drag_drop_action_properties[GALA_DRAG_DROP_ACTION_DRAG_ID_PROPERTY] = g_param_spec_string ("drag-id", "drag-id", "drag-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_DRAG_DROP_ACTION_HANDLE_PROPERTY, gala_drag_drop_action_properties[GALA_DRAG_DROP_ACTION_HANDLE_PROPERTY] = g_param_spec_object ("handle", "handle", "handle", clutter_actor_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	         * Indicates whether a drag action is currently active
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_DRAG_DROP_ACTION_DRAGGING_PROPERTY, gala_drag_drop_action_properties[GALA_DRAG_DROP_ACTION_DRAGGING_PROPERTY] = g_param_spec_boolean ("dragging", "dragging", "dragging", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	         * Allow checking the parents of reactive children if they are valid destinations
	         * if the child is none
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_DRAG_DROP_ACTION_ALLOW_BUBBLING_PROPERTY, gala_drag_drop_action_properties[GALA_DRAG_DROP_ACTION_ALLOW_BUBBLING_PROPERTY] = g_param_spec_boolean ("allow-bubbling", "allow-bubbling", "allow-bubbling", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_DRAG_DROP_ACTION_HOVERED_PROPERTY, gala_drag_drop_action_properties[GALA_DRAG_DROP_ACTION_HOVERED_PROPERTY] = g_param_spec_object ("hovered", "hovered", "hovered", clutter_actor_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	/**
	         * A drag has been started. You have to connect to this signal and
	         * return an actor that is transformed during the drag operation.
	         *
	         * @param x The global x coordinate where the action was activated
	         * @param y The global y coordinate where the action was activated
	         * @return  A ClutterActor that serves as handle
	         */
	gala_drag_drop_action_signals[GALA_DRAG_DROP_ACTION_DRAG_BEGIN_SIGNAL] = g_signal_new ("drag-begin", GALA_TYPE_DRAG_DROP_ACTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_OBJECT__FLOAT_FLOAT, clutter_actor_get_type (), 2, G_TYPE_FLOAT, G_TYPE_FLOAT);
	/**
	         * A drag has been canceled. You may want to consider cleaning up
	         * your handle.
	         */
	gala_drag_drop_action_signals[GALA_DRAG_DROP_ACTION_DRAG_CANCELED_SIGNAL] = g_signal_new ("drag-canceled", GALA_TYPE_DRAG_DROP_ACTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/**
	         * A drag action has successfully been finished.
	         *
	         * @param actor The actor on which the drag finished
	         */
	gala_drag_drop_action_signals[GALA_DRAG_DROP_ACTION_DRAG_END_SIGNAL] = g_signal_new ("drag-end", GALA_TYPE_DRAG_DROP_ACTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, clutter_actor_get_type ());
	/**
	         * The destination has been crossed
	         *
	         * @param target the target actor that is crossing the destination
	         * @param hovered indicates whether the actor is now hovered or not
	         */
	gala_drag_drop_action_signals[GALA_DRAG_DROP_ACTION_CROSSED_SIGNAL] = g_signal_new ("crossed", GALA_TYPE_DRAG_DROP_ACTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN, G_TYPE_NONE, 2, clutter_actor_get_type (), G_TYPE_BOOLEAN);
	/**
	         * Emitted on the source when a destination is crossed.
	         *
	         * @param destination The destination actor that has been crossed
	         * @param hovered     Whether the actor is now hovered or has just been left
	         */
	gala_drag_drop_action_signals[GALA_DRAG_DROP_ACTION_DESTINATION_CROSSED_SIGNAL] = g_signal_new ("destination-crossed", GALA_TYPE_DRAG_DROP_ACTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN, G_TYPE_NONE, 2, clutter_actor_get_type (), G_TYPE_BOOLEAN);
	/**
	         * The source has been clicked, but the movement was not larger than
	         * the drag threshold. Useful if the source is also activable.
	         *
	         * @param button The button which was pressed
	         */
	gala_drag_drop_action_signals[GALA_DRAG_DROP_ACTION_ACTOR_CLICKED_SIGNAL] = g_signal_new ("actor-clicked", GALA_TYPE_DRAG_DROP_ACTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
}

static void
gala_drag_drop_action_instance_init (GalaDragDropAction * self,
                                     gpointer klass)
{
	self->priv = gala_drag_drop_action_get_instance_private (self);
	self->priv->_dragging = FALSE;
	self->priv->_allow_bubbling = TRUE;
	self->priv->_hovered = NULL;
	self->priv->clicked = FALSE;
}

static void
gala_drag_drop_action_finalize (GObject * obj)
{
	GalaDragDropAction * self;
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_DRAG_DROP_ACTION, GalaDragDropAction);
	_tmp0_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ClutterActor* _tmp2_;
		ClutterActor* _tmp3_;
		_tmp2_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
		_tmp3_ = _tmp2_;
		gala_drag_drop_action_release_actor (self, _tmp3_);
	}
	_g_free0 (self->priv->_drag_id);
	_g_object_unref0 (self->priv->_handle);
	_g_object_unref0 (self->priv->_hovered);
	G_OBJECT_CLASS (gala_drag_drop_action_parent_class)->finalize (obj);
}

static GType
gala_drag_drop_action_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaDragDropActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_drag_drop_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaDragDropAction), 0, (GInstanceInitFunc) gala_drag_drop_action_instance_init, NULL };
	GType gala_drag_drop_action_type_id;
	gala_drag_drop_action_type_id = g_type_register_static (clutter_action_get_type (), "GalaDragDropAction", &g_define_type_info, 0);
	GalaDragDropAction_private_offset = g_type_add_instance_private (gala_drag_drop_action_type_id, sizeof (GalaDragDropActionPrivate));
	return gala_drag_drop_action_type_id;
}

GType
gala_drag_drop_action_get_type (void)
{
	static volatile gsize gala_drag_drop_action_type_id__once = 0;
	if (g_once_init_enter (&gala_drag_drop_action_type_id__once)) {
		GType gala_drag_drop_action_type_id;
		gala_drag_drop_action_type_id = gala_drag_drop_action_get_type_once ();
		g_once_init_leave (&gala_drag_drop_action_type_id__once, gala_drag_drop_action_type_id);
	}
	return gala_drag_drop_action_type_id__once;
}

static void
_vala_gala_drag_drop_action_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	GalaDragDropAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_DRAG_DROP_ACTION, GalaDragDropAction);
	switch (property_id) {
		case GALA_DRAG_DROP_ACTION_DRAG_TYPE_PROPERTY:
		g_value_set_flags (value, gala_drag_drop_action_get_drag_type (self));
		break;
		case GALA_DRAG_DROP_ACTION_DRAG_ID_PROPERTY:
		g_value_set_string (value, gala_drag_drop_action_get_drag_id (self));
		break;
		case GALA_DRAG_DROP_ACTION_HANDLE_PROPERTY:
		g_value_set_object (value, gala_drag_drop_action_get_handle (self));
		break;
		case GALA_DRAG_DROP_ACTION_DRAGGING_PROPERTY:
		g_value_set_boolean (value, gala_drag_drop_action_get_dragging (self));
		break;
		case GALA_DRAG_DROP_ACTION_ALLOW_BUBBLING_PROPERTY:
		g_value_set_boolean (value, gala_drag_drop_action_get_allow_bubbling (self));
		break;
		case GALA_DRAG_DROP_ACTION_HOVERED_PROPERTY:
		g_value_set_object (value, gala_drag_drop_action_get_hovered (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_drag_drop_action_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	GalaDragDropAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_DRAG_DROP_ACTION, GalaDragDropAction);
	switch (property_id) {
		case GALA_DRAG_DROP_ACTION_DRAG_TYPE_PROPERTY:
		gala_drag_drop_action_set_drag_type (self, g_value_get_flags (value));
		break;
		case GALA_DRAG_DROP_ACTION_DRAG_ID_PROPERTY:
		gala_drag_drop_action_set_drag_id (self, g_value_get_string (value));
		break;
		case GALA_DRAG_DROP_ACTION_HANDLE_PROPERTY:
		gala_drag_drop_action_set_handle (self, g_value_get_object (value));
		break;
		case GALA_DRAG_DROP_ACTION_DRAGGING_PROPERTY:
		gala_drag_drop_action_set_dragging (self, g_value_get_boolean (value));
		break;
		case GALA_DRAG_DROP_ACTION_ALLOW_BUBBLING_PROPERTY:
		gala_drag_drop_action_set_allow_bubbling (self, g_value_get_boolean (value));
		break;
		case GALA_DRAG_DROP_ACTION_HOVERED_PROPERTY:
		gala_drag_drop_action_set_hovered (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

