/* PopupWindow.c generated by valac 0.56.0, the Vala compiler
 * generated from PopupWindow.vala, do not modify */

/**/
/*  Copyright (C) 2017 Adam Bieńkowski*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "gala-pip.h"
#include <glib.h>
#include "gala.h"
#include <meta/meta-window-actor.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <meta/window.h>
#include <gdk/gdk.h>
#include <glib-object.h>
#include <graphene-gobject.h>
#include <meta/meta-plugin.h>
#include <meta/display.h>
#include <meta/boxes.h>

#define GALA_PLUGINS_PIP_POPUP_WINDOW_SHADOW_SIZE 100
#define GALA_PLUGINS_PIP_POPUP_WINDOW_FADE_OUT_TIMEOUT ((guint) 200)
#define GALA_PLUGINS_PIP_POPUP_WINDOW_MINIMUM_SCALE 0.1f
#define GALA_PLUGINS_PIP_POPUP_WINDOW_MAXIMUM_SCALE 1.0f
#define GALA_PLUGINS_PIP_POPUP_WINDOW_SCREEN_MARGIN 0
#define GALA_PLUGINS_PIP_POPUP_WINDOW_OFF_SCREEN_PERCENT 0.5f
#define GALA_PLUGINS_PIP_POPUP_WINDOW_OFF_SCREEN_VISIBLE_PIXELS 80

enum  {
	GALA_PLUGINS_PIP_POPUP_WINDOW_0_PROPERTY,
	GALA_PLUGINS_PIP_POPUP_WINDOW_WM_PROPERTY,
	GALA_PLUGINS_PIP_POPUP_WINDOW_WINDOW_ACTOR_PROPERTY,
	GALA_PLUGINS_PIP_POPUP_WINDOW_NUM_PROPERTIES
};
static GParamSpec* gala_plugins_pip_popup_window_properties[GALA_PLUGINS_PIP_POPUP_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _clutter_grab_unref0(var) ((var == NULL) ? NULL : (var = (clutter_grab_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
enum  {
	GALA_PLUGINS_PIP_POPUP_WINDOW_CLOSED_SIGNAL,
	GALA_PLUGINS_PIP_POPUP_WINDOW_NUM_SIGNALS
};
static guint gala_plugins_pip_popup_window_signals[GALA_PLUGINS_PIP_POPUP_WINDOW_NUM_SIGNALS] = {0};

struct _GalaPluginsPIPPopupWindowPrivate {
	gint button_size;
	gint container_margin;
	GalaWindowManager* _wm;
	MetaWindowActor* _window_actor;
	gboolean dynamic_container;
	ClutterActor* clone;
	ClutterActor* container;
	ClutterActor* close_button;
	ClutterActor* resize_button;
	ClutterClickAction* close_action;
	GalaDragDropAction* move_action;
	gfloat begin_resize_width;
	gfloat begin_resize_height;
	gfloat resize_start_x;
	gfloat resize_start_y;
	gboolean resizing;
	gboolean off_screen;
	ClutterGrab* grab;
};

struct _Block4Data {
	int _ref_count_;
	GalaPluginsPIPPopupWindow* self;
	gulong completed_id;
};

static gint GalaPluginsPIPPopupWindow_private_offset;
static gpointer gala_plugins_pip_popup_window_parent_class = NULL;
static MetaWindow* gala_plugins_pip_popup_window_previous_focus;
static MetaWindow* gala_plugins_pip_popup_window_previous_focus = NULL;

static void gala_plugins_pip_popup_window_calculate_aspect_ratio_size_fit (gfloat src_width,
                                                                    gfloat src_height,
                                                                    gfloat max_width,
                                                                    gfloat max_height,
                                                                    gfloat* width,
                                                                    gfloat* height);
static gboolean gala_plugins_pip_popup_window_get_window_is_normal (MetaWindow* window);
static void gala_plugins_pip_popup_window_get_current_cursor_position (gint* x,
                                                                gint* y);
static void gala_plugins_pip_popup_window_real_show (ClutterActor* base);
static void gala_plugins_pip_popup_window_real_hide (ClutterActor* base);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda4_ (Block4Data* _data4_);
static void ___lambda4__clutter_actor_transitions_completed (ClutterActor* _sender,
                                                      gpointer self);
static gboolean gala_plugins_pip_popup_window_real_enter_event (ClutterActor* base,
                                                         ClutterCrossingEvent* event);
static gboolean gala_plugins_pip_popup_window_real_leave_event (ClutterActor* base,
                                                         ClutterCrossingEvent* event);
static void gala_plugins_pip_popup_window_update_container_scale (GalaPluginsPIPPopupWindow* self);
static void gala_plugins_pip_popup_window_on_allocation_changed (GalaPluginsPIPPopupWindow* self);
static ClutterActor* gala_plugins_pip_popup_window_on_move_begin (GalaPluginsPIPPopupWindow* self);
static void gala_plugins_pip_popup_window_on_move_end (GalaPluginsPIPPopupWindow* self);
static void gala_plugins_pip_popup_window_update_screen_position (GalaPluginsPIPPopupWindow* self);
static gboolean gala_plugins_pip_popup_window_on_resize_button_press (GalaPluginsPIPPopupWindow* self,
                                                               ClutterButtonEvent* event);
static gboolean gala_plugins_pip_popup_window_on_resize_event (GalaPluginsPIPPopupWindow* self,
                                                        ClutterEvent* event);
static gboolean _gala_plugins_pip_popup_window_on_resize_event_clutter_actor_captured_event (ClutterActor* _sender,
                                                                                      ClutterEvent* event,
                                                                                      gpointer self);
static gboolean gala_plugins_pip_popup_window_stop_resizing (GalaPluginsPIPPopupWindow* self);
static void gala_plugins_pip_popup_window_update_size (GalaPluginsPIPPopupWindow* self);
static void gala_plugins_pip_popup_window_reposition_resize_button (GalaPluginsPIPPopupWindow* self);
static void gala_plugins_pip_popup_window_update_clone_clip (GalaPluginsPIPPopupWindow* self);
static void gala_plugins_pip_popup_window_on_close_click_clicked (GalaPluginsPIPPopupWindow* self);
static gboolean __lambda5_ (GalaPluginsPIPPopupWindow* self);
static gboolean ___lambda5__gsource_func (gpointer self);
static void gala_plugins_pip_popup_window_update_window_focus (GalaPluginsPIPPopupWindow* self);
static void gala_plugins_pip_popup_window_get_target_window_size (GalaPluginsPIPPopupWindow* self,
                                                           gfloat* width,
                                                           gfloat* height);
static void gala_plugins_pip_popup_window_update_container_position (GalaPluginsPIPPopupWindow* self);
static gboolean gala_plugins_pip_popup_window_place_window_off_screen (GalaPluginsPIPPopupWindow* self);
static void gala_plugins_pip_popup_window_place_window_in_screen (GalaPluginsPIPPopupWindow* self);
static void gala_plugins_pip_popup_window_get_current_monitor_rect (GalaPluginsPIPPopupWindow* self,
                                                             MetaRectangle* rect);
static gboolean gala_plugins_pip_popup_window_coord_is_in_other_monitor (GalaPluginsPIPPopupWindow* self,
                                                                  gfloat coord,
                                                                  ClutterOrientation axis);
static void gala_plugins_pip_popup_window_activate (GalaPluginsPIPPopupWindow* self);
static GObject * gala_plugins_pip_popup_window_constructor (GType type,
                                                     guint n_construct_properties,
                                                     GObjectConstructParam * construct_properties);
static void _gala_plugins_pip_popup_window_on_close_click_clicked_meta_window_unmanaged (MetaWindow* _sender,
                                                                                  gpointer self);
static void _gala_plugins_pip_popup_window___lambda6_ (GalaPluginsPIPPopupWindow* self);
static gboolean __lambda7_ (GalaPluginsPIPPopupWindow* self);
static gboolean ___lambda7__gsource_func (gpointer self);
static void __gala_plugins_pip_popup_window___lambda6__g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self);
static ClutterActor* _gala_plugins_pip_popup_window_on_move_begin_gala_drag_drop_action_drag_begin (GalaDragDropAction* _sender,
                                                                                             gfloat x,
                                                                                             gfloat y,
                                                                                             gpointer self);
static void _gala_plugins_pip_popup_window_on_move_end_gala_drag_drop_action_drag_canceled (GalaDragDropAction* _sender,
                                                                                     gpointer self);
static void _gala_plugins_pip_popup_window_activate_gala_drag_drop_action_actor_clicked (GalaDragDropAction* _sender,
                                                                                  guint32 button,
                                                                                  gpointer self);
static void _gala_plugins_pip_popup_window_on_close_click_clicked_clutter_click_action_clicked (ClutterClickAction* _sender,
                                                                                         ClutterActor* actor,
                                                                                         gpointer self);
static gboolean _gala_plugins_pip_popup_window_on_resize_button_press_clutter_actor_button_press_event (ClutterActor* _sender,
                                                                                                 ClutterButtonEvent* event,
                                                                                                 gpointer self);
static void _gala_plugins_pip_popup_window_on_allocation_changed_g_object_notify (GObject* _sender,
                                                                           GParamSpec* pspec,
                                                                           gpointer self);
static void gala_plugins_pip_popup_window_finalize (GObject * obj);
static GType gala_plugins_pip_popup_window_get_type_once (void);
static void _vala_gala_plugins_pip_popup_window_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_gala_plugins_pip_popup_window_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);

static inline gpointer
gala_plugins_pip_popup_window_get_instance_private (GalaPluginsPIPPopupWindow* self)
{
	return G_STRUCT_MEMBER_P (self, GalaPluginsPIPPopupWindow_private_offset);
}

static void
gala_plugins_pip_popup_window_calculate_aspect_ratio_size_fit (gfloat src_width,
                                                               gfloat src_height,
                                                               gfloat max_width,
                                                               gfloat max_height,
                                                               gfloat* width,
                                                               gfloat* height)
{
	gfloat _vala_width = 0.0F;
	gfloat _vala_height = 0.0F;
	gfloat ratio = 0.0F;
	ratio = MIN (max_width / src_width, max_height / src_height);
	_vala_width = src_width * ratio;
	_vala_height = src_height * ratio;
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
}

static gboolean
gala_plugins_pip_popup_window_get_window_is_normal (MetaWindow* window)
{
	MetaWindowType window_type = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (window != NULL, FALSE);
	window_type = meta_window_get_window_type (window);
	if (window_type == META_WINDOW_NORMAL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = window_type == META_WINDOW_DIALOG;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = window_type == META_WINDOW_MODAL_DIALOG;
	}
	result = _tmp0_;
	return result;
}

static void
gala_plugins_pip_popup_window_get_current_cursor_position (gint* x,
                                                           gint* y)
{
	gint _vala_x = 0;
	gint _vala_y = 0;
	GdkDisplay* _tmp0_;
	GdkSeat* _tmp1_;
	GdkDevice* _tmp2_;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = gdk_display_get_default_seat (_tmp0_);
	_tmp2_ = gdk_seat_get_pointer (_tmp1_);
	gdk_device_get_position (_tmp2_, NULL, &_tmp3_, &_tmp4_);
	_vala_x = _tmp3_;
	_vala_y = _tmp4_;
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
}

GalaPluginsPIPPopupWindow*
gala_plugins_pip_popup_window_construct (GType object_type,
                                         GalaWindowManager* wm,
                                         MetaWindowActor* window_actor)
{
	GalaPluginsPIPPopupWindow * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	g_return_val_if_fail (window_actor != NULL, NULL);
	self = (GalaPluginsPIPPopupWindow*) g_object_new (object_type, "wm", wm, "window-actor", window_actor, NULL);
	return self;
}

GalaPluginsPIPPopupWindow*
gala_plugins_pip_popup_window_new (GalaWindowManager* wm,
                                   MetaWindowActor* window_actor)
{
	return gala_plugins_pip_popup_window_construct (GALA_PLUGINS_PIP_TYPE_POPUP_WINDOW, wm, window_actor);
}

static void
gala_plugins_pip_popup_window_real_show (ClutterActor* base)
{
	GalaPluginsPIPPopupWindow * self;
	self = (GalaPluginsPIPPopupWindow*) base;
	CLUTTER_ACTOR_CLASS (gala_plugins_pip_popup_window_parent_class)->show (G_TYPE_CHECK_INSTANCE_CAST (self, clutter_actor_get_type (), ClutterActor));
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 0);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) 200);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 255);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) 0);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		GalaPluginsPIPPopupWindow* self;
		self = _data4_->self;
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
__lambda4_ (Block4Data* _data4_)
{
	GalaPluginsPIPPopupWindow* self;
	self = _data4_->self;
	g_signal_handler_disconnect ((GObject*) self, _data4_->completed_id);
	CLUTTER_ACTOR_CLASS (gala_plugins_pip_popup_window_parent_class)->hide (G_TYPE_CHECK_INSTANCE_CAST (self, clutter_actor_get_type (), ClutterActor));
}

static void
___lambda4__clutter_actor_transitions_completed (ClutterActor* _sender,
                                                 gpointer self)
{
	__lambda4_ (self);
}

static void
gala_plugins_pip_popup_window_real_hide (ClutterActor* base)
{
	GalaPluginsPIPPopupWindow * self;
	Block4Data* _data4_;
	gulong _tmp0_;
	self = (GalaPluginsPIPPopupWindow*) base;
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 255);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) 200);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 0);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) 0);
	_data4_->completed_id = 0UL;
	_tmp0_ = g_signal_connect_data ((ClutterActor*) self, "transitions-completed", (GCallback) ___lambda4__clutter_actor_transitions_completed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_data4_->completed_id = _tmp0_;
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static gboolean
gala_plugins_pip_popup_window_real_enter_event (ClutterActor* base,
                                                ClutterCrossingEvent* event)
{
	GalaPluginsPIPPopupWindow * self;
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	ClutterActor* _tmp2_;
	ClutterActor* _tmp3_;
	gboolean result;
	self = (GalaPluginsPIPPopupWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->close_button;
	clutter_actor_set_opacity (_tmp0_, (guint) 255);
	_tmp1_ = self->priv->resize_button;
	clutter_actor_set_easing_duration (_tmp1_, (guint) 300);
	_tmp2_ = self->priv->resize_button;
	clutter_actor_set_opacity (_tmp2_, (guint) 255);
	_tmp3_ = self->priv->resize_button;
	clutter_actor_set_easing_duration (_tmp3_, (guint) 0);
	result = TRUE;
	return result;
}

static gboolean
gala_plugins_pip_popup_window_real_leave_event (ClutterActor* base,
                                                ClutterCrossingEvent* event)
{
	GalaPluginsPIPPopupWindow * self;
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	ClutterActor* _tmp2_;
	ClutterActor* _tmp3_;
	gboolean result;
	self = (GalaPluginsPIPPopupWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->close_button;
	clutter_actor_set_opacity (_tmp0_, (guint) 0);
	_tmp1_ = self->priv->resize_button;
	clutter_actor_set_easing_duration (_tmp1_, (guint) 300);
	_tmp2_ = self->priv->resize_button;
	clutter_actor_set_opacity (_tmp2_, (guint) 0);
	_tmp3_ = self->priv->resize_button;
	clutter_actor_set_easing_duration (_tmp3_, (guint) 0);
	result = TRUE;
	return result;
}

void
gala_plugins_pip_popup_window_set_container_clip (GalaPluginsPIPPopupWindow* self,
                                                  graphene_rect_t* container_clip)
{
	ClutterActor* _tmp0_;
	graphene_rect_t _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->container;
	_tmp1_ = *container_clip;
	g_object_set (_tmp0_, "clip-rect", &_tmp1_, NULL);
	self->priv->dynamic_container = TRUE;
	gala_plugins_pip_popup_window_update_container_scale (self);
	gala_plugins_pip_popup_window_on_allocation_changed (self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static ClutterActor*
gala_plugins_pip_popup_window_on_move_begin (GalaPluginsPIPPopupWindow* self)
{
	ClutterActor* _tmp0_;
	ClutterActor* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _g_object_ref0 ((ClutterActor*) self);
	result = _tmp0_;
	return result;
}

static void
gala_plugins_pip_popup_window_on_move_end (GalaPluginsPIPPopupWindow* self)
{
	g_return_if_fail (self != NULL);
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
	gala_plugins_pip_popup_window_update_screen_position (self);
}

static gpointer
_clutter_grab_ref0 (gpointer self)
{
	return self ? clutter_grab_ref (self) : NULL;
}

static gboolean
_gala_plugins_pip_popup_window_on_resize_event_clutter_actor_captured_event (ClutterActor* _sender,
                                                                             ClutterEvent* event,
                                                                             gpointer self)
{
	gboolean result;
	result = gala_plugins_pip_popup_window_on_resize_event ((GalaPluginsPIPPopupWindow*) self, event);
	return result;
}

static gboolean
gala_plugins_pip_popup_window_on_resize_button_press (GalaPluginsPIPPopupWindow* self,
                                                      ClutterButtonEvent* event)
{
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gfloat _tmp3_;
	gfloat _tmp4_;
	gfloat _tmp5_;
	gfloat _tmp6_;
	ClutterActor* _tmp7_;
	ClutterStage* _tmp8_;
	ClutterGrab* _tmp9_;
	ClutterGrab* _tmp10_;
	ClutterActor* _tmp11_;
	ClutterStage* _tmp12_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (self->priv->resizing) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = event->button != ((guint32) 1);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	self->priv->resizing = TRUE;
	gala_plugins_pip_popup_window_get_current_cursor_position (&_tmp1_, &_tmp2_);
	self->priv->resize_start_x = (gfloat) _tmp1_;
	self->priv->resize_start_y = (gfloat) _tmp2_;
	_tmp3_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp4_ = _tmp3_;
	self->priv->begin_resize_width = _tmp4_;
	_tmp5_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp6_ = _tmp5_;
	self->priv->begin_resize_height = _tmp6_;
	_tmp7_ = self->priv->resize_button;
	_tmp8_ = clutter_actor_get_stage (_tmp7_);
	_tmp9_ = clutter_stage_grab (_tmp8_, (ClutterActor*) self);
	_tmp10_ = _clutter_grab_ref0 (_tmp9_);
	_clutter_grab_unref0 (self->priv->grab);
	self->priv->grab = _tmp10_;
	_tmp11_ = self->priv->resize_button;
	_tmp12_ = clutter_actor_get_stage (_tmp11_);
	g_signal_connect_object ((ClutterActor*) _tmp12_, "captured-event", (GCallback) _gala_plugins_pip_popup_window_on_resize_event_clutter_actor_captured_event, self, 0);
	result = TRUE;
	return result;
}

static gboolean
gala_plugins_pip_popup_window_on_resize_event (GalaPluginsPIPPopupWindow* self,
                                               ClutterEvent* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (!self->priv->resizing) {
		result = FALSE;
		return result;
	}
	switch (clutter_event_type (event)) {
		case CLUTTER_MOTION:
		{
			ClutterModifierType mods = 0U;
			gint motion_x = 0;
			gint motion_y = 0;
			gint _tmp0_ = 0;
			gint _tmp1_ = 0;
			gfloat diff_x = 0.0F;
			gfloat diff_y = 0.0F;
			mods = clutter_event_get_state (event);
			if (!((mods & CLUTTER_BUTTON1_MASK) == CLUTTER_BUTTON1_MASK)) {
				gala_plugins_pip_popup_window_stop_resizing (self);
				break;
			}
			gala_plugins_pip_popup_window_get_current_cursor_position (&_tmp0_, &_tmp1_);
			motion_x = _tmp0_;
			motion_y = _tmp1_;
			diff_x = motion_x - self->priv->resize_start_x;
			diff_y = motion_y - self->priv->resize_start_y;
			clutter_actor_set_width ((ClutterActor*) self, self->priv->begin_resize_width + diff_x);
			clutter_actor_set_height ((ClutterActor*) self, self->priv->begin_resize_height + diff_y);
			gala_plugins_pip_popup_window_update_container_scale (self);
			gala_plugins_pip_popup_window_update_size (self);
			gala_plugins_pip_popup_window_reposition_resize_button (self);
			break;
		}
		case CLUTTER_BUTTON_RELEASE:
		{
			if (clutter_event_get_button (event) == ((guint32) 1)) {
				gala_plugins_pip_popup_window_stop_resizing (self);
			}
			break;
		}
		case CLUTTER_LEAVE:
		case CLUTTER_ENTER:
		{
			result = TRUE;
			return result;
		}
		default:
		{
			break;
		}
	}
	result = FALSE;
	return result;
}

static gboolean
gala_plugins_pip_popup_window_stop_resizing (GalaPluginsPIPPopupWindow* self)
{
	ClutterActor* _tmp0_;
	ClutterStage* _tmp1_;
	guint _tmp2_;
	ClutterGrab* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->priv->resizing) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->priv->resize_button;
	_tmp1_ = clutter_actor_get_stage (_tmp0_);
	g_signal_parse_name ("captured-event", clutter_actor_get_type (), &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((ClutterActor*) _tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _gala_plugins_pip_popup_window_on_resize_event_clutter_actor_captured_event, self);
	_tmp3_ = self->priv->grab;
	if (_tmp3_ != NULL) {
		ClutterGrab* _tmp4_;
		_tmp4_ = self->priv->grab;
		clutter_grab_dismiss (_tmp4_);
		_clutter_grab_unref0 (self->priv->grab);
		self->priv->grab = NULL;
	}
	self->priv->resizing = FALSE;
	gala_plugins_pip_popup_window_update_screen_position (self);
	result = TRUE;
	return result;
}

static void
gala_plugins_pip_popup_window_on_allocation_changed (GalaPluginsPIPPopupWindow* self)
{
	g_return_if_fail (self != NULL);
	gala_plugins_pip_popup_window_update_clone_clip (self);
	gala_plugins_pip_popup_window_update_size (self);
	gala_plugins_pip_popup_window_reposition_resize_button (self);
}

static gboolean
__lambda5_ (GalaPluginsPIPPopupWindow* self)
{
	gboolean result;
	g_signal_emit (self, gala_plugins_pip_popup_window_signals[GALA_PLUGINS_PIP_POPUP_WINDOW_CLOSED_SIGNAL], 0);
	result = FALSE;
	return result;
}

static gboolean
___lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda5_ ((GalaPluginsPIPPopupWindow*) self);
	return result;
}

static void
gala_plugins_pip_popup_window_on_close_click_clicked (GalaPluginsPIPPopupWindow* self)
{
	g_return_if_fail (self != NULL);
	clutter_actor_set_easing_duration ((ClutterActor*) self, GALA_PLUGINS_PIP_POPUP_WINDOW_FADE_OUT_TIMEOUT);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 0);
	clutter_threads_add_timeout (GALA_PLUGINS_PIP_POPUP_WINDOW_FADE_OUT_TIMEOUT, ___lambda5__gsource_func, self);
}

static void
gala_plugins_pip_popup_window_update_window_focus (GalaPluginsPIPPopupWindow* self)
{
	MetaWindow* focus_window = NULL;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaWindow* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	MetaWindow* _tmp5_;
	MetaWindow* window = NULL;
	MetaWindowActor* _tmp11_;
	MetaWindow* _tmp12_;
	MetaWindow* _tmp13_;
	MetaWindow* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	MetaWindow* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = meta_display_get_focus_window (_tmp1_);
	focus_window = _tmp2_;
	_tmp5_ = focus_window;
	if (_tmp5_ != NULL) {
		MetaWindow* _tmp6_;
		_tmp6_ = focus_window;
		_tmp4_ = !gala_plugins_pip_popup_window_get_window_is_normal (_tmp6_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp7_ = FALSE;
		MetaWindow* _tmp8_;
		_tmp8_ = gala_plugins_pip_popup_window_previous_focus;
		if (_tmp8_ != NULL) {
			MetaWindow* _tmp9_;
			_tmp9_ = gala_plugins_pip_popup_window_previous_focus;
			_tmp7_ = !gala_plugins_pip_popup_window_get_window_is_normal (_tmp9_);
		} else {
			_tmp7_ = FALSE;
		}
		_tmp3_ = _tmp7_;
	}
	if (_tmp3_) {
		MetaWindow* _tmp10_;
		_tmp10_ = focus_window;
		gala_plugins_pip_popup_window_previous_focus = _tmp10_;
		return;
	}
	_tmp11_ = self->priv->_window_actor;
	_tmp12_ = meta_window_actor_get_meta_window (_tmp11_);
	_tmp13_ = _g_object_ref0 (_tmp12_);
	window = _tmp13_;
	_tmp14_ = window;
	g_object_get (_tmp14_, "appears-focused", &_tmp15_, NULL);
	_tmp16_ = _tmp15_;
	if (_tmp16_) {
		clutter_actor_hide ((ClutterActor*) self);
	} else {
		MetaWindowActor* _tmp17_;
		_tmp17_ = self->priv->_window_actor;
		if (!meta_window_actor_is_destroyed (_tmp17_)) {
			clutter_actor_show ((ClutterActor*) self);
		}
	}
	_tmp18_ = focus_window;
	gala_plugins_pip_popup_window_previous_focus = _tmp18_;
	_g_object_unref0 (window);
}

static void
gala_plugins_pip_popup_window_update_size (GalaPluginsPIPPopupWindow* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->dynamic_container) {
		gfloat src_width = 0.0F;
		gfloat src_height = 0.0F;
		ClutterActor* _tmp0_;
		gfloat _tmp1_ = 0.0F;
		gfloat _tmp2_ = 0.0F;
		ClutterActor* _tmp3_;
		gdouble _tmp4_;
		gdouble _tmp5_;
		ClutterActor* _tmp6_;
		gdouble _tmp7_;
		gdouble _tmp8_;
		src_width = 0.0f;
		src_height = 0.0f;
		_tmp0_ = self->priv->container;
		clutter_actor_get_clip (_tmp0_, NULL, NULL, &_tmp1_, &_tmp2_);
		src_width = _tmp1_;
		src_height = _tmp2_;
		_tmp3_ = self->priv->container;
		g_object_get (_tmp3_, "scale-x", &_tmp4_, NULL);
		_tmp5_ = _tmp4_;
		clutter_actor_set_width ((ClutterActor*) self, (gfloat) ((gint) ((src_width * _tmp5_) + self->priv->button_size)));
		_tmp6_ = self->priv->container;
		g_object_get (_tmp6_, "scale-y", &_tmp7_, NULL);
		_tmp8_ = _tmp7_;
		clutter_actor_set_height ((ClutterActor*) self, (gfloat) ((gint) ((src_height * _tmp8_) + self->priv->button_size)));
	} else {
		ClutterActor* _tmp9_;
		gfloat _tmp10_;
		gfloat _tmp11_;
		ClutterActor* _tmp12_;
		gdouble _tmp13_;
		gdouble _tmp14_;
		ClutterActor* _tmp15_;
		gfloat _tmp16_;
		gfloat _tmp17_;
		ClutterActor* _tmp18_;
		gdouble _tmp19_;
		gdouble _tmp20_;
		_tmp9_ = self->priv->container;
		_tmp10_ = clutter_actor_get_width (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = self->priv->container;
		g_object_get (_tmp12_, "scale-x", &_tmp13_, NULL);
		_tmp14_ = _tmp13_;
		clutter_actor_set_width ((ClutterActor*) self, (gfloat) ((gint) ((_tmp11_ * _tmp14_) + self->priv->button_size)));
		_tmp15_ = self->priv->container;
		_tmp16_ = clutter_actor_get_height (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = self->priv->container;
		g_object_get (_tmp18_, "scale-y", &_tmp19_, NULL);
		_tmp20_ = _tmp19_;
		clutter_actor_set_height ((ClutterActor*) self, (gfloat) ((gint) ((_tmp17_ * _tmp20_) + self->priv->button_size)));
	}
}

static void
gala_plugins_pip_popup_window_update_clone_clip (GalaPluginsPIPPopupWindow* self)
{
	MetaRectangle rect = {0};
	MetaWindowActor* _tmp0_;
	MetaWindow* _tmp1_;
	MetaRectangle _tmp2_ = {0};
	gfloat x_offset = 0.0F;
	MetaRectangle _tmp3_;
	MetaWindowActor* _tmp4_;
	gfloat _tmp5_;
	gfloat _tmp6_;
	gfloat y_offset = 0.0F;
	MetaRectangle _tmp7_;
	MetaWindowActor* _tmp8_;
	gfloat _tmp9_;
	gfloat _tmp10_;
	ClutterActor* _tmp11_;
	MetaRectangle _tmp12_;
	MetaRectangle _tmp13_;
	ClutterActor* _tmp14_;
	ClutterActor* _tmp15_;
	MetaRectangle _tmp16_;
	MetaRectangle _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_window_actor;
	_tmp1_ = meta_window_actor_get_meta_window (_tmp0_);
	meta_window_get_frame_rect (_tmp1_, &_tmp2_);
	rect = _tmp2_;
	_tmp3_ = rect;
	_tmp4_ = self->priv->_window_actor;
	_tmp5_ = clutter_actor_get_x ((ClutterActor*) _tmp4_);
	_tmp6_ = _tmp5_;
	x_offset = _tmp3_.x - _tmp6_;
	_tmp7_ = rect;
	_tmp8_ = self->priv->_window_actor;
	_tmp9_ = clutter_actor_get_y ((ClutterActor*) _tmp8_);
	_tmp10_ = _tmp9_;
	y_offset = _tmp7_.y - _tmp10_;
	_tmp11_ = self->priv->clone;
	_tmp12_ = rect;
	_tmp13_ = rect;
	clutter_actor_set_clip (_tmp11_, x_offset, y_offset, (gfloat) _tmp12_.width, (gfloat) _tmp13_.height);
	_tmp14_ = self->priv->clone;
	clutter_actor_set_position (_tmp14_, -x_offset, -y_offset);
	_tmp15_ = self->priv->container;
	_tmp16_ = rect;
	_tmp17_ = rect;
	clutter_actor_set_size (_tmp15_, (gfloat) _tmp16_.width, (gfloat) _tmp17_.height);
}

static void
gala_plugins_pip_popup_window_update_container_scale (GalaPluginsPIPPopupWindow* self)
{
	gfloat src_width = 0.0F;
	gfloat src_height = 0.0F;
	gfloat max_width = 0.0F;
	gfloat _tmp9_;
	gfloat _tmp10_;
	gfloat max_height = 0.0F;
	gfloat _tmp11_;
	gfloat _tmp12_;
	gfloat new_width = 0.0F;
	gfloat new_height = 0.0F;
	gfloat _tmp13_ = 0.0F;
	gfloat _tmp14_ = 0.0F;
	gfloat window_width = 0.0F;
	gfloat window_height = 0.0F;
	gfloat _tmp15_ = 0.0F;
	gfloat _tmp16_ = 0.0F;
	gfloat new_scale_x = 0.0F;
	gfloat new_scale_y = 0.0F;
	ClutterActor* _tmp17_;
	ClutterActor* _tmp18_;
	g_return_if_fail (self != NULL);
	src_width = 1.0f;
	src_height = 1.0f;
	if (self->priv->dynamic_container) {
		ClutterActor* _tmp0_;
		gfloat _tmp1_ = 0.0F;
		gfloat _tmp2_ = 0.0F;
		_tmp0_ = self->priv->container;
		clutter_actor_get_clip (_tmp0_, NULL, NULL, &_tmp1_, &_tmp2_);
		src_width = _tmp1_;
		src_height = _tmp2_;
	} else {
		ClutterActor* _tmp3_;
		gfloat _tmp4_;
		gfloat _tmp5_;
		ClutterActor* _tmp6_;
		gfloat _tmp7_;
		gfloat _tmp8_;
		_tmp3_ = self->priv->container;
		_tmp4_ = clutter_actor_get_width (_tmp3_);
		_tmp5_ = _tmp4_;
		src_width = _tmp5_;
		_tmp6_ = self->priv->container;
		_tmp7_ = clutter_actor_get_height (_tmp6_);
		_tmp8_ = _tmp7_;
		src_height = _tmp8_;
	}
	_tmp9_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp10_ = _tmp9_;
	max_width = _tmp10_ - self->priv->button_size;
	_tmp11_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp12_ = _tmp11_;
	max_height = _tmp12_ - self->priv->button_size;
	gala_plugins_pip_popup_window_calculate_aspect_ratio_size_fit (src_width, src_height, max_width, max_height, &_tmp13_, &_tmp14_);
	new_width = _tmp13_;
	new_height = _tmp14_;
	window_width = 1.0f;
	window_height = 1.0f;
	gala_plugins_pip_popup_window_get_target_window_size (self, &_tmp15_, &_tmp16_);
	window_width = _tmp15_;
	window_height = _tmp16_;
	new_scale_x = new_width / window_width;
	new_scale_y = new_height / window_height;
	_tmp17_ = self->priv->container;
	g_object_set (_tmp17_, "scale-x", (gdouble) CLAMP (new_scale_x, GALA_PLUGINS_PIP_POPUP_WINDOW_MINIMUM_SCALE, GALA_PLUGINS_PIP_POPUP_WINDOW_MAXIMUM_SCALE), NULL);
	_tmp18_ = self->priv->container;
	g_object_set (_tmp18_, "scale-y", (gdouble) CLAMP (new_scale_y, GALA_PLUGINS_PIP_POPUP_WINDOW_MINIMUM_SCALE, GALA_PLUGINS_PIP_POPUP_WINDOW_MAXIMUM_SCALE), NULL);
	gala_plugins_pip_popup_window_update_container_position (self);
}

static void
gala_plugins_pip_popup_window_update_container_position (GalaPluginsPIPPopupWindow* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->dynamic_container) {
		gfloat clip_x = 0.0F;
		gfloat clip_y = 0.0F;
		ClutterActor* _tmp0_;
		gfloat _tmp1_ = 0.0F;
		gfloat _tmp2_ = 0.0F;
		ClutterActor* _tmp3_;
		ClutterActor* _tmp4_;
		gdouble _tmp5_;
		gdouble _tmp6_;
		ClutterActor* _tmp7_;
		ClutterActor* _tmp8_;
		gdouble _tmp9_;
		gdouble _tmp10_;
		clip_x = 0.0f;
		clip_y = 0.0f;
		_tmp0_ = self->priv->container;
		clutter_actor_get_clip (_tmp0_, &_tmp1_, &_tmp2_, NULL, NULL);
		clip_x = _tmp1_;
		clip_y = _tmp2_;
		_tmp3_ = self->priv->container;
		_tmp4_ = self->priv->container;
		g_object_get (_tmp4_, "scale-x", &_tmp5_, NULL);
		_tmp6_ = _tmp5_;
		clutter_actor_set_x (_tmp3_, (gfloat) (((-clip_x) * _tmp6_) + self->priv->container_margin));
		_tmp7_ = self->priv->container;
		_tmp8_ = self->priv->container;
		g_object_get (_tmp8_, "scale-y", &_tmp9_, NULL);
		_tmp10_ = _tmp9_;
		clutter_actor_set_y (_tmp7_, (gfloat) (((-clip_y) * _tmp10_) + self->priv->container_margin));
	}
}

static void
gala_plugins_pip_popup_window_update_screen_position (GalaPluginsPIPPopupWindow* self)
{
	g_return_if_fail (self != NULL);
	if (!gala_plugins_pip_popup_window_place_window_off_screen (self)) {
		gala_plugins_pip_popup_window_place_window_in_screen (self);
	}
}

static void
gala_plugins_pip_popup_window_place_window_in_screen (GalaPluginsPIPPopupWindow* self)
{
	MetaRectangle monitor_rect = {0};
	MetaRectangle _tmp0_ = {0};
	gint monitor_x = 0;
	MetaRectangle _tmp1_;
	gint monitor_y = 0;
	MetaRectangle _tmp2_;
	gint monitor_width = 0;
	MetaRectangle _tmp3_;
	gint monitor_height = 0;
	MetaRectangle _tmp4_;
	gint screen_limit_start = 0;
	gfloat screen_limit_end = 0.0F;
	gfloat _tmp5_;
	gfloat _tmp6_;
	gfloat _tmp7_;
	gfloat _tmp8_;
	gfloat _tmp9_;
	gfloat _tmp10_;
	gfloat _tmp11_;
	gfloat _tmp12_;
	g_return_if_fail (self != NULL);
	self->priv->off_screen = FALSE;
	gala_plugins_pip_popup_window_get_current_monitor_rect (self, &_tmp0_);
	monitor_rect = _tmp0_;
	_tmp1_ = monitor_rect;
	monitor_x = _tmp1_.x;
	_tmp2_ = monitor_rect;
	monitor_y = _tmp2_.y;
	_tmp3_ = monitor_rect;
	monitor_width = _tmp3_.width;
	_tmp4_ = monitor_rect;
	monitor_height = _tmp4_.height;
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) 300);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_BACK);
	screen_limit_start = GALA_PLUGINS_PIP_POPUP_WINDOW_SCREEN_MARGIN + monitor_x;
	_tmp5_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp6_ = _tmp5_;
	screen_limit_end = ((monitor_width + monitor_x) - GALA_PLUGINS_PIP_POPUP_WINDOW_SCREEN_MARGIN) - _tmp6_;
	_tmp7_ = clutter_actor_get_x ((ClutterActor*) self);
	_tmp8_ = _tmp7_;
	clutter_actor_set_x ((ClutterActor*) self, CLAMP (_tmp8_, (gfloat) screen_limit_start, screen_limit_end));
	screen_limit_start = GALA_PLUGINS_PIP_POPUP_WINDOW_SCREEN_MARGIN + monitor_y;
	_tmp9_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp10_ = _tmp9_;
	screen_limit_end = ((monitor_height + monitor_y) - GALA_PLUGINS_PIP_POPUP_WINDOW_SCREEN_MARGIN) - _tmp10_;
	_tmp11_ = clutter_actor_get_y ((ClutterActor*) self);
	_tmp12_ = _tmp11_;
	clutter_actor_set_y ((ClutterActor*) self, CLAMP (_tmp12_, (gfloat) screen_limit_start, screen_limit_end));
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_IN_QUAD);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) 0);
}

static gboolean
gala_plugins_pip_popup_window_place_window_off_screen (GalaPluginsPIPPopupWindow* self)
{
	MetaRectangle monitor_rect = {0};
	MetaRectangle _tmp0_ = {0};
	gint monitor_x = 0;
	MetaRectangle _tmp1_;
	gint monitor_y = 0;
	MetaRectangle _tmp2_;
	gint monitor_width = 0;
	MetaRectangle _tmp3_;
	gint monitor_height = 0;
	MetaRectangle _tmp4_;
	gfloat off_screen_x_threshold = 0.0F;
	gfloat _tmp5_;
	gfloat _tmp6_;
	gboolean off_screen_x = FALSE;
	gfloat _tmp7_;
	gfloat _tmp8_;
	gboolean _tmp9_ = FALSE;
	gboolean off_screen_w = FALSE;
	gfloat _tmp14_;
	gfloat _tmp15_;
	gfloat _tmp16_;
	gfloat _tmp17_;
	gboolean _tmp18_ = FALSE;
	gfloat off_screen_y_threshold = 0.0F;
	gfloat _tmp23_;
	gfloat _tmp24_;
	gboolean off_screen_y = FALSE;
	gfloat _tmp25_;
	gfloat _tmp26_;
	gboolean _tmp27_ = FALSE;
	gboolean off_screen_h = FALSE;
	gfloat _tmp32_;
	gfloat _tmp33_;
	gfloat _tmp34_;
	gfloat _tmp35_;
	gboolean _tmp36_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->off_screen = FALSE;
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) 300);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_BACK);
	gala_plugins_pip_popup_window_get_current_monitor_rect (self, &_tmp0_);
	monitor_rect = _tmp0_;
	_tmp1_ = monitor_rect;
	monitor_x = _tmp1_.x;
	_tmp2_ = monitor_rect;
	monitor_y = _tmp2_.y;
	_tmp3_ = monitor_rect;
	monitor_width = _tmp3_.width;
	_tmp4_ = monitor_rect;
	monitor_height = _tmp4_.height;
	_tmp5_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp6_ = _tmp5_;
	off_screen_x_threshold = _tmp6_ * GALA_PLUGINS_PIP_POPUP_WINDOW_OFF_SCREEN_PERCENT;
	_tmp7_ = clutter_actor_get_x ((ClutterActor*) self);
	_tmp8_ = _tmp7_;
	off_screen_x = (_tmp8_ - monitor_x) < (-off_screen_x_threshold);
	if (off_screen_x) {
		gfloat _tmp10_;
		gfloat _tmp11_;
		_tmp10_ = clutter_actor_get_x ((ClutterActor*) self);
		_tmp11_ = _tmp10_;
		_tmp9_ = !gala_plugins_pip_popup_window_coord_is_in_other_monitor (self, _tmp11_, CLUTTER_ORIENTATION_HORIZONTAL);
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gfloat _tmp12_;
		gfloat _tmp13_;
		self->priv->off_screen = TRUE;
		_tmp12_ = clutter_actor_get_width ((ClutterActor*) self);
		_tmp13_ = _tmp12_;
		clutter_actor_set_x ((ClutterActor*) self, (monitor_x - _tmp13_) + GALA_PLUGINS_PIP_POPUP_WINDOW_OFF_SCREEN_VISIBLE_PIXELS);
	}
	_tmp14_ = clutter_actor_get_x ((ClutterActor*) self);
	_tmp15_ = _tmp14_;
	_tmp16_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp17_ = _tmp16_;
	off_screen_w = (_tmp15_ + _tmp17_) > ((monitor_x + monitor_width) + off_screen_x_threshold);
	if (off_screen_w) {
		gfloat _tmp19_;
		gfloat _tmp20_;
		gfloat _tmp21_;
		gfloat _tmp22_;
		_tmp19_ = clutter_actor_get_x ((ClutterActor*) self);
		_tmp20_ = _tmp19_;
		_tmp21_ = clutter_actor_get_width ((ClutterActor*) self);
		_tmp22_ = _tmp21_;
		_tmp18_ = !gala_plugins_pip_popup_window_coord_is_in_other_monitor (self, _tmp20_ + _tmp22_, CLUTTER_ORIENTATION_HORIZONTAL);
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		self->priv->off_screen = TRUE;
		clutter_actor_set_x ((ClutterActor*) self, (gfloat) ((monitor_x + monitor_width) - GALA_PLUGINS_PIP_POPUP_WINDOW_OFF_SCREEN_VISIBLE_PIXELS));
	}
	_tmp23_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp24_ = _tmp23_;
	off_screen_y_threshold = _tmp24_ * GALA_PLUGINS_PIP_POPUP_WINDOW_OFF_SCREEN_PERCENT;
	_tmp25_ = clutter_actor_get_y ((ClutterActor*) self);
	_tmp26_ = _tmp25_;
	off_screen_y = (_tmp26_ - monitor_y) < (-off_screen_y_threshold);
	if (off_screen_y) {
		gfloat _tmp28_;
		gfloat _tmp29_;
		_tmp28_ = clutter_actor_get_y ((ClutterActor*) self);
		_tmp29_ = _tmp28_;
		_tmp27_ = !gala_plugins_pip_popup_window_coord_is_in_other_monitor (self, _tmp29_, CLUTTER_ORIENTATION_VERTICAL);
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		gfloat _tmp30_;
		gfloat _tmp31_;
		self->priv->off_screen = TRUE;
		_tmp30_ = clutter_actor_get_height ((ClutterActor*) self);
		_tmp31_ = _tmp30_;
		clutter_actor_set_y ((ClutterActor*) self, (monitor_y - _tmp31_) + GALA_PLUGINS_PIP_POPUP_WINDOW_OFF_SCREEN_VISIBLE_PIXELS);
	}
	_tmp32_ = clutter_actor_get_y ((ClutterActor*) self);
	_tmp33_ = _tmp32_;
	_tmp34_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp35_ = _tmp34_;
	off_screen_h = (_tmp33_ + _tmp35_) > ((monitor_y + monitor_height) + off_screen_y_threshold);
	if (off_screen_h) {
		gfloat _tmp37_;
		gfloat _tmp38_;
		gfloat _tmp39_;
		gfloat _tmp40_;
		_tmp37_ = clutter_actor_get_y ((ClutterActor*) self);
		_tmp38_ = _tmp37_;
		_tmp39_ = clutter_actor_get_height ((ClutterActor*) self);
		_tmp40_ = _tmp39_;
		_tmp36_ = !gala_plugins_pip_popup_window_coord_is_in_other_monitor (self, _tmp38_ + _tmp40_, CLUTTER_ORIENTATION_VERTICAL);
	} else {
		_tmp36_ = FALSE;
	}
	if (_tmp36_) {
		self->priv->off_screen = TRUE;
		clutter_actor_set_y ((ClutterActor*) self, (gfloat) ((monitor_y + monitor_height) - GALA_PLUGINS_PIP_POPUP_WINDOW_OFF_SCREEN_VISIBLE_PIXELS));
	}
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_IN_QUAD);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) 0);
	result = self->priv->off_screen;
	return result;
}

static gboolean
gala_plugins_pip_popup_window_coord_is_in_other_monitor (GalaPluginsPIPPopupWindow* self,
                                                         gfloat coord,
                                                         ClutterOrientation axis)
{
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaDisplay* _tmp2_;
	gint n_monitors = 0;
	MetaDisplay* _tmp3_;
	gint current = 0;
	MetaDisplay* _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	display = _tmp2_;
	_tmp3_ = display;
	n_monitors = meta_display_get_n_monitors (_tmp3_);
	if (n_monitors == 1) {
		result = FALSE;
		_g_object_unref0 (display);
		return result;
	}
	_tmp4_ = display;
	current = meta_display_get_current_monitor (_tmp4_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				if (!(i < n_monitors)) {
					break;
				}
				if (i != current) {
					MetaRectangle monitor_rect = {0};
					MetaDisplay* _tmp7_;
					MetaRectangle _tmp8_ = {0};
					gboolean in_monitor = FALSE;
					_tmp7_ = display;
					meta_display_get_monitor_geometry (_tmp7_, i, &_tmp8_);
					monitor_rect = _tmp8_;
					in_monitor = FALSE;
					if (axis == CLUTTER_ORIENTATION_HORIZONTAL) {
						gboolean _tmp9_ = FALSE;
						MetaRectangle _tmp10_;
						_tmp10_ = monitor_rect;
						if (coord >= ((gfloat) _tmp10_.x)) {
							MetaRectangle _tmp11_;
							MetaRectangle _tmp12_;
							_tmp11_ = monitor_rect;
							_tmp12_ = monitor_rect;
							_tmp9_ = coord <= ((gfloat) (_tmp11_.x + _tmp12_.width));
						} else {
							_tmp9_ = FALSE;
						}
						in_monitor = _tmp9_;
					} else {
						gboolean _tmp13_ = FALSE;
						MetaRectangle _tmp14_;
						_tmp14_ = monitor_rect;
						if (coord >= ((gfloat) _tmp14_.y)) {
							MetaRectangle _tmp15_;
							MetaRectangle _tmp16_;
							_tmp15_ = monitor_rect;
							_tmp16_ = monitor_rect;
							_tmp13_ = coord <= ((gfloat) (_tmp15_.y + _tmp16_.height));
						} else {
							_tmp13_ = FALSE;
						}
						in_monitor = _tmp13_;
					}
					if (in_monitor) {
						result = TRUE;
						_g_object_unref0 (display);
						return result;
					}
				}
			}
		}
	}
	result = FALSE;
	_g_object_unref0 (display);
	return result;
}

static void
gala_plugins_pip_popup_window_reposition_resize_button (GalaPluginsPIPPopupWindow* self)
{
	ClutterActor* _tmp0_;
	gfloat _tmp1_;
	gfloat _tmp2_;
	gfloat _tmp3_;
	gfloat _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->resize_button;
	_tmp1_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp4_ = _tmp3_;
	clutter_actor_set_position (_tmp0_, _tmp2_ - self->priv->button_size, _tmp4_ - self->priv->button_size);
}

static void
gala_plugins_pip_popup_window_get_current_monitor_rect (GalaPluginsPIPPopupWindow* self,
                                                        MetaRectangle* rect)
{
	MetaRectangle _vala_rect = {0};
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaDisplay* _tmp2_;
	MetaRectangle _tmp3_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	display = _tmp2_;
	meta_display_get_monitor_geometry (display, meta_display_get_current_monitor (display), &_tmp3_);
	_vala_rect = _tmp3_;
	_g_object_unref0 (display);
	if (rect) {
		*rect = _vala_rect;
	}
}

static void
gala_plugins_pip_popup_window_get_target_window_size (GalaPluginsPIPPopupWindow* self,
                                                      gfloat* width,
                                                      gfloat* height)
{
	gfloat _vala_width = 0.0F;
	gfloat _vala_height = 0.0F;
	g_return_if_fail (self != NULL);
	if (self->priv->dynamic_container) {
		ClutterActor* _tmp0_;
		gfloat _tmp1_ = 0.0F;
		gfloat _tmp2_ = 0.0F;
		_tmp0_ = self->priv->container;
		clutter_actor_get_clip (_tmp0_, NULL, NULL, &_tmp1_, &_tmp2_);
		_vala_width = _tmp1_;
		_vala_height = _tmp2_;
	} else {
		ClutterActor* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = self->priv->clone;
		g_object_get (_tmp3_, "has-clip", &_tmp4_, NULL);
		_tmp5_ = _tmp4_;
		if (_tmp5_) {
			ClutterActor* _tmp6_;
			gfloat _tmp7_ = 0.0F;
			gfloat _tmp8_ = 0.0F;
			_tmp6_ = self->priv->clone;
			clutter_actor_get_clip (_tmp6_, NULL, NULL, &_tmp7_, &_tmp8_);
			_vala_width = _tmp7_;
			_vala_height = _tmp8_;
		} else {
			ClutterActor* _tmp9_;
			gfloat _tmp10_;
			gfloat _tmp11_;
			ClutterActor* _tmp12_;
			gfloat _tmp13_;
			gfloat _tmp14_;
			_tmp9_ = self->priv->clone;
			_tmp10_ = clutter_actor_get_width (_tmp9_);
			_tmp11_ = _tmp10_;
			_vala_width = _tmp11_;
			_tmp12_ = self->priv->clone;
			_tmp13_ = clutter_actor_get_height (_tmp12_);
			_tmp14_ = _tmp13_;
			_vala_height = _tmp14_;
		}
	}
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
}

static void
gala_plugins_pip_popup_window_activate (GalaPluginsPIPPopupWindow* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->off_screen) {
		gala_plugins_pip_popup_window_place_window_in_screen (self);
	} else {
		MetaWindow* window = NULL;
		MetaWindowActor* _tmp0_;
		MetaWindow* _tmp1_;
		MetaWindow* _tmp2_;
		MetaWindow* _tmp3_;
		_tmp0_ = self->priv->_window_actor;
		_tmp1_ = meta_window_actor_get_meta_window (_tmp0_);
		_tmp2_ = _g_object_ref0 (_tmp1_);
		window = _tmp2_;
		_tmp3_ = window;
		meta_window_activate (_tmp3_, clutter_get_current_event_time ());
		_g_object_unref0 (window);
	}
}

GalaWindowManager*
gala_plugins_pip_popup_window_get_wm (GalaPluginsPIPPopupWindow* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static void
gala_plugins_pip_popup_window_set_wm (GalaPluginsPIPPopupWindow* self,
                                      GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_plugins_pip_popup_window_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_plugins_pip_popup_window_properties[GALA_PLUGINS_PIP_POPUP_WINDOW_WM_PROPERTY]);
	}
}

MetaWindowActor*
gala_plugins_pip_popup_window_get_window_actor (GalaPluginsPIPPopupWindow* self)
{
	MetaWindowActor* result;
	MetaWindowActor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window_actor;
	result = _tmp0_;
	return result;
}

static void
gala_plugins_pip_popup_window_set_window_actor (GalaPluginsPIPPopupWindow* self,
                                                MetaWindowActor* value)
{
	MetaWindowActor* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_plugins_pip_popup_window_get_window_actor (self);
	if (old_value != value) {
		MetaWindowActor* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_window_actor);
		self->priv->_window_actor = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_plugins_pip_popup_window_properties[GALA_PLUGINS_PIP_POPUP_WINDOW_WINDOW_ACTOR_PROPERTY]);
	}
}

static void
_gala_plugins_pip_popup_window_on_close_click_clicked_meta_window_unmanaged (MetaWindow* _sender,
                                                                             gpointer self)
{
	gala_plugins_pip_popup_window_on_close_click_clicked ((GalaPluginsPIPPopupWindow*) self);
}

static gboolean
__lambda7_ (GalaPluginsPIPPopupWindow* self)
{
	gboolean result;
	gala_plugins_pip_popup_window_update_window_focus (self);
	result = FALSE;
	return result;
}

static gboolean
___lambda7__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda7_ ((GalaPluginsPIPPopupWindow*) self);
	return result;
}

static void
_gala_plugins_pip_popup_window___lambda6_ (GalaPluginsPIPPopupWindow* self)
{
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda7__gsource_func, g_object_ref (self), g_object_unref);
}

static void
__gala_plugins_pip_popup_window___lambda6__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self)
{
	_gala_plugins_pip_popup_window___lambda6_ ((GalaPluginsPIPPopupWindow*) self);
}

static ClutterActor*
_gala_plugins_pip_popup_window_on_move_begin_gala_drag_drop_action_drag_begin (GalaDragDropAction* _sender,
                                                                               gfloat x,
                                                                               gfloat y,
                                                                               gpointer self)
{
	ClutterActor* result;
	result = gala_plugins_pip_popup_window_on_move_begin ((GalaPluginsPIPPopupWindow*) self);
	return result;
}

static void
_gala_plugins_pip_popup_window_on_move_end_gala_drag_drop_action_drag_canceled (GalaDragDropAction* _sender,
                                                                                gpointer self)
{
	gala_plugins_pip_popup_window_on_move_end ((GalaPluginsPIPPopupWindow*) self);
}

static void
_gala_plugins_pip_popup_window_activate_gala_drag_drop_action_actor_clicked (GalaDragDropAction* _sender,
                                                                             guint32 button,
                                                                             gpointer self)
{
	gala_plugins_pip_popup_window_activate ((GalaPluginsPIPPopupWindow*) self);
}

static void
_gala_plugins_pip_popup_window_on_close_click_clicked_clutter_click_action_clicked (ClutterClickAction* _sender,
                                                                                    ClutterActor* actor,
                                                                                    gpointer self)
{
	gala_plugins_pip_popup_window_on_close_click_clicked ((GalaPluginsPIPPopupWindow*) self);
}

static gboolean
_gala_plugins_pip_popup_window_on_resize_button_press_clutter_actor_button_press_event (ClutterActor* _sender,
                                                                                        ClutterButtonEvent* event,
                                                                                        gpointer self)
{
	gboolean result;
	result = gala_plugins_pip_popup_window_on_resize_button_press ((GalaPluginsPIPPopupWindow*) self, event);
	return result;
}

static void
_gala_plugins_pip_popup_window_on_allocation_changed_g_object_notify (GObject* _sender,
                                                                      GParamSpec* pspec,
                                                                      gpointer self)
{
	gala_plugins_pip_popup_window_on_allocation_changed ((GalaPluginsPIPPopupWindow*) self);
}

static GObject *
gala_plugins_pip_popup_window_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaPluginsPIPPopupWindow * self;
	gint scale = 0;
	MetaWindow* window = NULL;
	MetaWindowActor* _tmp0_;
	MetaWindow* _tmp1_;
	MetaWindow* _tmp2_;
	MetaWindow* _tmp3_;
	MetaWindow* _tmp4_;
	MetaWindowActor* _tmp5_;
	ClutterClone* _tmp6_;
	GalaDragDropAction* _tmp7_;
	GalaDragDropAction* _tmp8_;
	GalaDragDropAction* _tmp9_;
	GalaDragDropAction* _tmp10_;
	ClutterActor* _tmp11_;
	ClutterActor* _tmp12_;
	ClutterActor* _tmp13_;
	ClutterActor* _tmp14_;
	GalaPluginsPIPShadowEffect* _tmp15_;
	GalaPluginsPIPShadowEffect* _tmp16_;
	ClutterActor* _tmp17_;
	ClutterActor* _tmp18_;
	ClutterActor* _tmp19_;
	GalaDragDropAction* _tmp20_;
	MetaRectangle monitor_rect = {0};
	MetaRectangle _tmp21_ = {0};
	gfloat x_position = 0.0F;
	gfloat y_position = 0.0F;
	MetaRectangle _tmp27_;
	MetaRectangle _tmp28_;
	gfloat _tmp29_;
	gfloat _tmp30_;
	ClutterClickAction* _tmp31_;
	ClutterClickAction* _tmp32_;
	ClutterActor* _tmp33_;
	ClutterActor* _tmp34_;
	ClutterActor* _tmp35_;
	ClutterActor* _tmp36_;
	ClutterActor* _tmp37_;
	ClutterClickAction* _tmp38_;
	ClutterActor* _tmp39_;
	ClutterActor* _tmp40_;
	ClutterActor* _tmp41_;
	gfloat _tmp42_;
	gfloat _tmp43_;
	gfloat _tmp44_;
	gfloat _tmp45_;
	ClutterActor* _tmp46_;
	ClutterActor* _tmp47_;
	ClutterActor* _tmp48_;
	ClutterActor* _tmp49_;
	ClutterActor* _tmp50_;
	ClutterActor* _tmp51_;
	MetaWindowActor* _tmp52_;
	ClutterActor* _tmp53_;
	parent_class = G_OBJECT_CLASS (gala_plugins_pip_popup_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_PLUGINS_PIP_TYPE_POPUP_WINDOW, GalaPluginsPIPPopupWindow);
	scale = gala_utils_get_ui_scaling_factor ();
	self->priv->button_size = 36 * scale;
	self->priv->container_margin = self->priv->button_size / 2;
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
	clutter_actor_set_pivot_point ((ClutterActor*) self, 0.5f, 0.5f);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_IN_QUAD);
	_tmp0_ = self->priv->_window_actor;
	_tmp1_ = meta_window_actor_get_meta_window (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	window = _tmp2_;
	_tmp3_ = window;
	g_signal_connect_object (_tmp3_, "unmanaged", (GCallback) _gala_plugins_pip_popup_window_on_close_click_clicked_meta_window_unmanaged, self, 0);
	_tmp4_ = window;
	g_signal_connect_object ((GObject*) _tmp4_, "notify::appears-focused", (GCallback) __gala_plugins_pip_popup_window___lambda6__g_object_notify, self, 0);
	_tmp5_ = self->priv->_window_actor;
	_tmp6_ = (ClutterClone*) clutter_clone_new ((ClutterActor*) _tmp5_);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->clone);
	self->priv->clone = (ClutterActor*) _tmp6_;
	_tmp7_ = gala_drag_drop_action_new (GALA_DRAG_DROP_ACTION_TYPE_SOURCE, "pip");
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->move_action);
	self->priv->move_action = _tmp7_;
	_tmp8_ = self->priv->move_action;
	g_signal_connect_object (_tmp8_, "drag-begin", (GCallback) _gala_plugins_pip_popup_window_on_move_begin_gala_drag_drop_action_drag_begin, self, 0);
	_tmp9_ = self->priv->move_action;
	g_signal_connect_object (_tmp9_, "drag-canceled", (GCallback) _gala_plugins_pip_popup_window_on_move_end_gala_drag_drop_action_drag_canceled, self, 0);
	_tmp10_ = self->priv->move_action;
	g_signal_connect_object (_tmp10_, "actor-clicked", (GCallback) _gala_plugins_pip_popup_window_activate_gala_drag_drop_action_actor_clicked, self, 0);
	_tmp11_ = clutter_actor_new ();
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->container);
	self->priv->container = _tmp11_;
	_tmp12_ = self->priv->container;
	clutter_actor_set_reactive (_tmp12_, TRUE);
	_tmp13_ = self->priv->container;
	clutter_actor_set_scale (_tmp13_, (gdouble) 0.35f, (gdouble) 0.35f);
	_tmp14_ = self->priv->container;
	_tmp15_ = gala_plugins_pip_shadow_effect_new (GALA_PLUGINS_PIP_POPUP_WINDOW_SHADOW_SIZE, 2);
	g_object_ref_sink (_tmp15_);
	_tmp16_ = _tmp15_;
	clutter_actor_add_effect (_tmp14_, (ClutterEffect*) _tmp16_);
	_g_object_unref0 (_tmp16_);
	_tmp17_ = self->priv->container;
	_tmp18_ = self->priv->clone;
	clutter_actor_add_child (_tmp17_, _tmp18_);
	_tmp19_ = self->priv->container;
	_tmp20_ = self->priv->move_action;
	clutter_actor_add_action (_tmp19_, (ClutterAction*) _tmp20_);
	gala_plugins_pip_popup_window_update_size (self);
	gala_plugins_pip_popup_window_update_container_position (self);
	gala_plugins_pip_popup_window_get_current_monitor_rect (self, &_tmp21_);
	monitor_rect = _tmp21_;
	if (clutter_get_default_text_direction () == CLUTTER_TEXT_DIRECTION_RTL) {
		MetaRectangle _tmp22_;
		_tmp22_ = monitor_rect;
		x_position = (gfloat) (GALA_PLUGINS_PIP_POPUP_WINDOW_SCREEN_MARGIN + _tmp22_.x);
	} else {
		MetaRectangle _tmp23_;
		MetaRectangle _tmp24_;
		gfloat _tmp25_;
		gfloat _tmp26_;
		_tmp23_ = monitor_rect;
		_tmp24_ = monitor_rect;
		_tmp25_ = clutter_actor_get_width ((ClutterActor*) self);
		_tmp26_ = _tmp25_;
		x_position = ((_tmp23_.width + _tmp24_.x) - GALA_PLUGINS_PIP_POPUP_WINDOW_SCREEN_MARGIN) - _tmp26_;
	}
	_tmp27_ = monitor_rect;
	_tmp28_ = monitor_rect;
	_tmp29_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp30_ = _tmp29_;
	y_position = ((_tmp27_.height + _tmp28_.y) - GALA_PLUGINS_PIP_POPUP_WINDOW_SCREEN_MARGIN) - _tmp30_;
	clutter_actor_set_position ((ClutterActor*) self, x_position, y_position);
	_tmp31_ = (ClutterClickAction*) clutter_click_action_new ();
	g_object_ref_sink (_tmp31_);
	_g_object_unref0 (self->priv->close_action);
	self->priv->close_action = _tmp31_;
	_tmp32_ = self->priv->close_action;
	g_signal_connect_object (_tmp32_, "clicked", (GCallback) _gala_plugins_pip_popup_window_on_close_click_clicked_clutter_click_action_clicked, self, 0);
	_tmp33_ = gala_utils_create_close_button ();
	_g_object_unref0 (self->priv->close_button);
	self->priv->close_button = _tmp33_;
	_tmp34_ = self->priv->close_button;
	clutter_actor_set_opacity (_tmp34_, (guint) 0);
	_tmp35_ = self->priv->close_button;
	clutter_actor_set_reactive (_tmp35_, TRUE);
	_tmp36_ = self->priv->close_button;
	clutter_actor_set_easing_duration (_tmp36_, (guint) 300);
	_tmp37_ = self->priv->close_button;
	_tmp38_ = self->priv->close_action;
	clutter_actor_add_action (_tmp37_, (ClutterAction*) _tmp38_);
	_tmp39_ = gala_utils_create_resize_button ();
	_g_object_unref0 (self->priv->resize_button);
	self->priv->resize_button = _tmp39_;
	_tmp40_ = self->priv->resize_button;
	clutter_actor_set_pivot_point (_tmp40_, 0.5f, 0.5f);
	_tmp41_ = self->priv->resize_button;
	_tmp42_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp43_ = _tmp42_;
	_tmp44_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp45_ = _tmp44_;
	clutter_actor_set_position (_tmp41_, _tmp43_ - self->priv->button_size, _tmp45_ - self->priv->button_size);
	_tmp46_ = self->priv->resize_button;
	clutter_actor_set_opacity (_tmp46_, (guint) 0);
	_tmp47_ = self->priv->resize_button;
	g_signal_connect_object (_tmp47_, "button-press-event", (GCallback) _gala_plugins_pip_popup_window_on_resize_button_press_clutter_actor_button_press_event, self, 0);
	_tmp48_ = self->priv->resize_button;
	clutter_actor_set_reactive (_tmp48_, TRUE);
	_tmp49_ = self->priv->container;
	clutter_actor_add_child ((ClutterActor*) self, _tmp49_);
	_tmp50_ = self->priv->close_button;
	clutter_actor_add_child ((ClutterActor*) self, _tmp50_);
	_tmp51_ = self->priv->resize_button;
	clutter_actor_add_child ((ClutterActor*) self, _tmp51_);
	_tmp52_ = self->priv->_window_actor;
	g_signal_connect_object ((GObject*) _tmp52_, "notify::allocation", (GCallback) _gala_plugins_pip_popup_window_on_allocation_changed_g_object_notify, self, 0);
	_tmp53_ = self->priv->container;
	clutter_actor_set_position (_tmp53_, (gfloat) self->priv->container_margin, (gfloat) self->priv->container_margin);
	gala_plugins_pip_popup_window_update_clone_clip (self);
	_g_object_unref0 (window);
	return obj;
}

static void
gala_plugins_pip_popup_window_class_init (GalaPluginsPIPPopupWindowClass * klass,
                                          gpointer klass_data)
{
	gala_plugins_pip_popup_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaPluginsPIPPopupWindow_private_offset);
	((ClutterActorClass *) klass)->show = (void (*) (ClutterActor*)) gala_plugins_pip_popup_window_real_show;
	((ClutterActorClass *) klass)->hide = (void (*) (ClutterActor*)) gala_plugins_pip_popup_window_real_hide;
	((ClutterActorClass *) klass)->enter_event = (gboolean (*) (ClutterActor*, ClutterCrossingEvent*)) gala_plugins_pip_popup_window_real_enter_event;
	((ClutterActorClass *) klass)->leave_event = (gboolean (*) (ClutterActor*, ClutterCrossingEvent*)) gala_plugins_pip_popup_window_real_leave_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_plugins_pip_popup_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_plugins_pip_popup_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_plugins_pip_popup_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_plugins_pip_popup_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_PLUGINS_PIP_POPUP_WINDOW_WM_PROPERTY, gala_plugins_pip_popup_window_properties[GALA_PLUGINS_PIP_POPUP_WINDOW_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_PLUGINS_PIP_POPUP_WINDOW_WINDOW_ACTOR_PROPERTY, gala_plugins_pip_popup_window_properties[GALA_PLUGINS_PIP_POPUP_WINDOW_WINDOW_ACTOR_PROPERTY] = g_param_spec_object ("window-actor", "window-actor", "window-actor", meta_window_actor_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	gala_plugins_pip_popup_window_signals[GALA_PLUGINS_PIP_POPUP_WINDOW_CLOSED_SIGNAL] = g_signal_new ("closed", GALA_PLUGINS_PIP_TYPE_POPUP_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
gala_plugins_pip_popup_window_instance_init (GalaPluginsPIPPopupWindow * self,
                                             gpointer klass)
{
	self->priv = gala_plugins_pip_popup_window_get_instance_private (self);
	self->priv->dynamic_container = FALSE;
	self->priv->begin_resize_width = 0.0f;
	self->priv->begin_resize_height = 0.0f;
	self->priv->resize_start_x = 0.0f;
	self->priv->resize_start_y = 0.0f;
	self->priv->resizing = FALSE;
	self->priv->off_screen = FALSE;
	self->priv->grab = NULL;
}

static void
gala_plugins_pip_popup_window_finalize (GObject * obj)
{
	GalaPluginsPIPPopupWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_PLUGINS_PIP_TYPE_POPUP_WINDOW, GalaPluginsPIPPopupWindow);
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->_window_actor);
	_g_object_unref0 (self->priv->clone);
	_g_object_unref0 (self->priv->container);
	_g_object_unref0 (self->priv->close_button);
	_g_object_unref0 (self->priv->resize_button);
	_g_object_unref0 (self->priv->close_action);
	_g_object_unref0 (self->priv->move_action);
	_clutter_grab_unref0 (self->priv->grab);
	G_OBJECT_CLASS (gala_plugins_pip_popup_window_parent_class)->finalize (obj);
}

static GType
gala_plugins_pip_popup_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaPluginsPIPPopupWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_plugins_pip_popup_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaPluginsPIPPopupWindow), 0, (GInstanceInitFunc) gala_plugins_pip_popup_window_instance_init, NULL };
	GType gala_plugins_pip_popup_window_type_id;
	gala_plugins_pip_popup_window_type_id = g_type_register_static (clutter_actor_get_type (), "GalaPluginsPIPPopupWindow", &g_define_type_info, 0);
	GalaPluginsPIPPopupWindow_private_offset = g_type_add_instance_private (gala_plugins_pip_popup_window_type_id, sizeof (GalaPluginsPIPPopupWindowPrivate));
	return gala_plugins_pip_popup_window_type_id;
}

GType
gala_plugins_pip_popup_window_get_type (void)
{
	static volatile gsize gala_plugins_pip_popup_window_type_id__once = 0;
	if (g_once_init_enter (&gala_plugins_pip_popup_window_type_id__once)) {
		GType gala_plugins_pip_popup_window_type_id;
		gala_plugins_pip_popup_window_type_id = gala_plugins_pip_popup_window_get_type_once ();
		g_once_init_leave (&gala_plugins_pip_popup_window_type_id__once, gala_plugins_pip_popup_window_type_id);
	}
	return gala_plugins_pip_popup_window_type_id__once;
}

static void
_vala_gala_plugins_pip_popup_window_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	GalaPluginsPIPPopupWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_PLUGINS_PIP_TYPE_POPUP_WINDOW, GalaPluginsPIPPopupWindow);
	switch (property_id) {
		case GALA_PLUGINS_PIP_POPUP_WINDOW_WM_PROPERTY:
		g_value_set_object (value, gala_plugins_pip_popup_window_get_wm (self));
		break;
		case GALA_PLUGINS_PIP_POPUP_WINDOW_WINDOW_ACTOR_PROPERTY:
		g_value_set_object (value, gala_plugins_pip_popup_window_get_window_actor (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_plugins_pip_popup_window_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	GalaPluginsPIPPopupWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_PLUGINS_PIP_TYPE_POPUP_WINDOW, GalaPluginsPIPPopupWindow);
	switch (property_id) {
		case GALA_PLUGINS_PIP_POPUP_WINDOW_WM_PROPERTY:
		gala_plugins_pip_popup_window_set_wm (self, g_value_get_object (value));
		break;
		case GALA_PLUGINS_PIP_POPUP_WINDOW_WINDOW_ACTOR_PROPERTY:
		gala_plugins_pip_popup_window_set_window_actor (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

