/* AccentColorManager.c generated by valac 0.56.0, the Vala compiler
 * generated from AccentColorManager.vala, do not modify */

/*
 * Copyright 2021 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 *
 * Authored by: Marius Meisenzahl <mariusmeisenzahl@gmail.com>
 */

#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gexiv2/gexiv2.h>
#include <gee.h>
#include <granite.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#define GALA_ACCENT_COLOR_MANAGER_INTERFACE_SCHEMA "org.gnome.desktop.interface"
#define GALA_ACCENT_COLOR_MANAGER_STYLESHEET_KEY "gtk-theme"
#define GALA_ACCENT_COLOR_MANAGER_TAG_ACCENT_COLOR "Xmp.xmp.io.elementary.AccentColor"
#define GALA_ACCENT_COLOR_MANAGER_THEME_BLUE "io.elementary.stylesheet.blueberry"
#define GALA_ACCENT_COLOR_MANAGER_THEME_MINT "io.elementary.stylesheet.mint"
#define GALA_ACCENT_COLOR_MANAGER_THEME_GREEN "io.elementary.stylesheet.lime"
#define GALA_ACCENT_COLOR_MANAGER_THEME_YELLOW "io.elementary.stylesheet.banana"
#define GALA_ACCENT_COLOR_MANAGER_THEME_ORANGE "io.elementary.stylesheet.orange"
#define GALA_ACCENT_COLOR_MANAGER_THEME_RED "io.elementary.stylesheet.strawberry"
#define GALA_ACCENT_COLOR_MANAGER_THEME_PINK "io.elementary.stylesheet.bubblegum"
#define GALA_ACCENT_COLOR_MANAGER_THEME_PURPLE "io.elementary.stylesheet.grape"
#define GALA_ACCENT_COLOR_MANAGER_THEME_BROWN "io.elementary.stylesheet.cocoa"
#define GALA_ACCENT_COLOR_MANAGER_THEME_GRAY "io.elementary.stylesheet.slate"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_ACCENT_COLOR_MANAGER (gala_accent_color_manager_get_type ())
#define GALA_ACCENT_COLOR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ACCENT_COLOR_MANAGER, GalaAccentColorManager))
#define GALA_ACCENT_COLOR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_ACCENT_COLOR_MANAGER, GalaAccentColorManagerClass))
#define GALA_IS_ACCENT_COLOR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ACCENT_COLOR_MANAGER))
#define GALA_IS_ACCENT_COLOR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_ACCENT_COLOR_MANAGER))
#define GALA_ACCENT_COLOR_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_ACCENT_COLOR_MANAGER, GalaAccentColorManagerClass))

typedef struct _GalaAccentColorManager GalaAccentColorManager;
typedef struct _GalaAccentColorManagerClass GalaAccentColorManagerClass;
typedef struct _GalaAccentColorManagerPrivate GalaAccentColorManagerPrivate;

#define GALA_TYPE_ACCOUNTS_SERVICE (gala_accounts_service_get_type ())
#define GALA_ACCOUNTS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ACCOUNTS_SERVICE, GalaAccountsService))
#define GALA_IS_ACCOUNTS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ACCOUNTS_SERVICE))
#define GALA_ACCOUNTS_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_TYPE_ACCOUNTS_SERVICE, GalaAccountsServiceIface))

typedef struct _GalaAccountsService GalaAccountsService;
typedef struct _GalaAccountsServiceIface GalaAccountsServiceIface;

#define GALA_TYPE_ACCOUNTS_SERVICE_PROXY (gala_accounts_service_proxy_get_type ())

#define GALA_TYPE_NAMED_COLOR (gala_named_color_get_type ())
#define GALA_NAMED_COLOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_NAMED_COLOR, GalaNamedColor))
#define GALA_NAMED_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_NAMED_COLOR, GalaNamedColorClass))
#define GALA_IS_NAMED_COLOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_NAMED_COLOR))
#define GALA_IS_NAMED_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_NAMED_COLOR))
#define GALA_NAMED_COLOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_NAMED_COLOR, GalaNamedColorClass))

typedef struct _GalaNamedColor GalaNamedColor;
typedef struct _GalaNamedColorClass GalaNamedColorClass;
enum  {
	GALA_ACCENT_COLOR_MANAGER_0_PROPERTY,
	GALA_ACCENT_COLOR_MANAGER_NUM_PROPERTIES
};
static GParamSpec* gala_accent_color_manager_properties[GALA_ACCENT_COLOR_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define GALA_TYPE_COLOR_EXTRACTOR (gala_color_extractor_get_type ())
#define GALA_COLOR_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_COLOR_EXTRACTOR, GalaColorExtractor))
#define GALA_COLOR_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_COLOR_EXTRACTOR, GalaColorExtractorClass))
#define GALA_IS_COLOR_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_COLOR_EXTRACTOR))
#define GALA_IS_COLOR_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_COLOR_EXTRACTOR))
#define GALA_COLOR_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_COLOR_EXTRACTOR, GalaColorExtractorClass))

typedef struct _GalaColorExtractor GalaColorExtractor;
typedef struct _GalaColorExtractorClass GalaColorExtractorClass;

#define GALA_FDO_TYPE_ACCOUNTS (gala_fdo_accounts_get_type ())
#define GALA_FDO_ACCOUNTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_FDO_TYPE_ACCOUNTS, GalaFDOAccounts))
#define GALA_FDO_IS_ACCOUNTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_FDO_TYPE_ACCOUNTS))
#define GALA_FDO_ACCOUNTS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_FDO_TYPE_ACCOUNTS, GalaFDOAccountsIface))

typedef struct _GalaFDOAccounts GalaFDOAccounts;
typedef struct _GalaFDOAccountsIface GalaFDOAccountsIface;

#define GALA_FDO_TYPE_ACCOUNTS_PROXY (gala_fdo_accounts_proxy_get_type ())

struct _GalaAccentColorManager {
	GObject parent_instance;
	GalaAccentColorManagerPrivate * priv;
};

struct _GalaAccentColorManagerClass {
	GObjectClass parent_class;
};

struct _GalaAccountsServiceIface {
	GTypeInterface parent_iface;
	gint (*get_prefers_accent_color) (GalaAccountsService* self);
};

struct _GalaAccentColorManagerPrivate {
	GalaAccountsService* gala_accounts_service;
	GSettings* background_settings;
	GSettings* interface_settings;
	GalaNamedColor** theme_colors;
	gint theme_colors_length1;
	gint _theme_colors_size_;
};

struct _GalaFDOAccountsIface {
	GTypeInterface parent_iface;
	gchar* (*find_user_by_name) (GalaFDOAccounts* self, const gchar* username, GError** error);
};

static gint GalaAccentColorManager_private_offset;
static gpointer gala_accent_color_manager_parent_class = NULL;

VALA_EXTERN GType gala_accent_color_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaAccentColorManager, g_object_unref)
 G_GNUC_INTERNAL GType gala_accounts_service_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaAccountsService, g_object_unref)
VALA_EXTERN GType gala_accounts_service_proxy_get_type (void) G_GNUC_CONST ;
 G_GNUC_INTERNAL guint gala_accounts_service_register_object (void* object,
                                             GDBusConnection* connection,
                                             const gchar* path,
                                             GError** error);
VALA_EXTERN GType gala_named_color_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaNamedColor, g_object_unref)
VALA_EXTERN GalaNamedColor* gala_named_color_new (const gchar* name,
                                      const gchar* theme);
VALA_EXTERN GalaNamedColor* gala_named_color_construct (GType object_type,
                                            const gchar* name,
                                            const gchar* theme);
static void gala_accent_color_manager_update_accent_color (GalaAccentColorManager* self);
 G_GNUC_INTERNAL gint gala_accounts_service_get_prefers_accent_color (GalaAccountsService* self);
static GalaNamedColor* gala_accent_color_manager_get_accent_color_based_on_primary_color (GalaAccentColorManager* self,
                                                                                   const gchar* primary_color);
static gchar* gala_accent_color_manager_read_accent_color_name_from_exif (GalaAccentColorManager* self,
                                                                   const gchar* picture_uri);
VALA_EXTERN const gchar* gala_named_color_get_name (GalaNamedColor* self);
static GalaNamedColor* gala_accent_color_manager_get_accent_color_of_picture_simple (GalaAccentColorManager* self,
                                                                              const gchar* picture_uri);
VALA_EXTERN const gchar* gala_named_color_get_theme (GalaNamedColor* self);
VALA_EXTERN GType gala_color_extractor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaColorExtractor, g_object_unref)
static GalaNamedColor* gala_accent_color_manager_get_accent_color (GalaAccentColorManager* self,
                                                            GalaColorExtractor* color_extractor);
VALA_EXTERN GraniteDrawingColor* gala_named_color_get_color (GalaNamedColor* self);
VALA_EXTERN gint gala_color_extractor_get_dominant_color_index (GalaColorExtractor* self,
                                                    GeeList* palette);
VALA_EXTERN GalaColorExtractor* gala_color_extractor_new_from_pixbuf (GdkPixbuf* pixbuf);
VALA_EXTERN GalaColorExtractor* gala_color_extractor_construct_from_pixbuf (GType object_type,
                                                                GdkPixbuf* pixbuf);
VALA_EXTERN GalaColorExtractor* gala_color_extractor_new_from_primary_color (GraniteDrawingColor* primary_color);
VALA_EXTERN GalaColorExtractor* gala_color_extractor_construct_from_primary_color (GType object_type,
                                                                       GraniteDrawingColor* primary_color);
VALA_EXTERN GalaAccentColorManager* gala_accent_color_manager_new (void);
VALA_EXTERN GalaAccentColorManager* gala_accent_color_manager_construct (GType object_type);
static GObject * gala_accent_color_manager_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
VALA_EXTERN GType gala_fdo_accounts_proxy_get_type (void) G_GNUC_CONST ;
 G_GNUC_INTERNAL guint gala_fdo_accounts_register_object (void* object,
                                         GDBusConnection* connection,
                                         const gchar* path,
                                         GError** error);
 G_GNUC_INTERNAL GType gala_fdo_accounts_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaFDOAccounts, g_object_unref)
 G_GNUC_INTERNAL gchar* gala_fdo_accounts_find_user_by_name (GalaFDOAccounts* self,
                                            const gchar* username,
                                            GError** error);
static void _gala_accent_color_manager_____lambda61_ (GalaAccentColorManager* self);
static void __gala_accent_color_manager_____lambda61__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                                  GVariant* changed_properties,
                                                                                  gchar** invalidated_properties,
                                                                                  gpointer self);
static void _gala_accent_color_manager_update_accent_color_g_settings_changed (GSettings* _sender,
                                                                        const gchar* key,
                                                                        gpointer self);
static void gala_accent_color_manager_finalize (GObject * obj);
static GType gala_accent_color_manager_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gala_accent_color_manager_get_instance_private (GalaAccentColorManager* self)
{
	return G_STRUCT_MEMBER_P (self, GalaAccentColorManager_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gala_accent_color_manager_update_accent_color (GalaAccentColorManager* self)
{
	gboolean set_accent_color_auto = FALSE;
	GalaAccountsService* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean set_accent_color_based_on_primary_color = FALSE;
	GSettings* _tmp3_;
	gchar* current_stylesheet = NULL;
	GSettings* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	GalaNamedColor* new_color = NULL;
	gboolean _tmp31_ = FALSE;
	GalaNamedColor* _tmp32_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->gala_accounts_service;
	_tmp1_ = gala_accounts_service_get_prefers_accent_color (_tmp0_);
	_tmp2_ = _tmp1_;
	set_accent_color_auto = _tmp2_ == 0;
	if (!set_accent_color_auto) {
		return;
	}
	_tmp3_ = self->priv->background_settings;
	set_accent_color_based_on_primary_color = g_settings_get_enum (_tmp3_, "picture-options") == 0;
	_tmp4_ = self->priv->interface_settings;
	_tmp5_ = g_settings_get_string (_tmp4_, GALA_ACCENT_COLOR_MANAGER_STYLESHEET_KEY);
	current_stylesheet = _tmp5_;
	_tmp6_ = current_stylesheet;
	g_debug ("AccentColorManager.vala:107: Current stylesheet: %s", _tmp6_);
	new_color = NULL;
	if (set_accent_color_based_on_primary_color) {
		gchar* primary_color = NULL;
		GSettings* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		GalaNamedColor* _tmp11_;
		_tmp7_ = self->priv->background_settings;
		_tmp8_ = g_settings_get_string (_tmp7_, "primary-color");
		primary_color = _tmp8_;
		_tmp9_ = primary_color;
		g_debug ("AccentColorManager.vala:112: Current primary color: %s", _tmp9_);
		_tmp10_ = primary_color;
		_tmp11_ = gala_accent_color_manager_get_accent_color_based_on_primary_color (self, _tmp10_);
		_g_object_unref0 (new_color);
		new_color = _tmp11_;
		_g_free0 (primary_color);
	} else {
		gchar* picture_uri = NULL;
		GSettings* _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* accent_color_name = NULL;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		_tmp12_ = self->priv->background_settings;
		_tmp13_ = g_settings_get_string (_tmp12_, "picture-uri");
		picture_uri = _tmp13_;
		_tmp14_ = picture_uri;
		g_debug ("AccentColorManager.vala:117: Current wallpaper: %s", _tmp14_);
		_tmp15_ = picture_uri;
		_tmp16_ = gala_accent_color_manager_read_accent_color_name_from_exif (self, _tmp15_);
		accent_color_name = _tmp16_;
		_tmp17_ = accent_color_name;
		if (_tmp17_ != NULL) {
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp18_ = FALSE;
					_tmp18_ = TRUE;
					while (TRUE) {
						GalaNamedColor** _tmp20_;
						gint _tmp20__length1;
						GalaNamedColor** _tmp21_;
						gint _tmp21__length1;
						GalaNamedColor* _tmp22_;
						const gchar* _tmp23_;
						const gchar* _tmp24_;
						const gchar* _tmp25_;
						if (!_tmp18_) {
							gint _tmp19_;
							_tmp19_ = i;
							i = _tmp19_ + 1;
						}
						_tmp18_ = FALSE;
						_tmp20_ = self->priv->theme_colors;
						_tmp20__length1 = self->priv->theme_colors_length1;
						if (!(i < _tmp20__length1)) {
							break;
						}
						_tmp21_ = self->priv->theme_colors;
						_tmp21__length1 = self->priv->theme_colors_length1;
						_tmp22_ = _tmp21_[i];
						_tmp23_ = gala_named_color_get_name (_tmp22_);
						_tmp24_ = _tmp23_;
						_tmp25_ = accent_color_name;
						if (g_strcmp0 (_tmp24_, _tmp25_) == 0) {
							GalaNamedColor** _tmp26_;
							gint _tmp26__length1;
							GalaNamedColor* _tmp27_;
							GalaNamedColor* _tmp28_;
							_tmp26_ = self->priv->theme_colors;
							_tmp26__length1 = self->priv->theme_colors_length1;
							_tmp27_ = _tmp26_[i];
							_tmp28_ = _g_object_ref0 (_tmp27_);
							_g_object_unref0 (new_color);
							new_color = _tmp28_;
							break;
						}
					}
				}
			}
		} else {
			const gchar* _tmp29_;
			GalaNamedColor* _tmp30_;
			_tmp29_ = picture_uri;
			_tmp30_ = gala_accent_color_manager_get_accent_color_of_picture_simple (self, _tmp29_);
			_g_object_unref0 (new_color);
			new_color = _tmp30_;
		}
		_g_free0 (accent_color_name);
		_g_free0 (picture_uri);
	}
	_tmp32_ = new_color;
	if (_tmp32_ != NULL) {
		GalaNamedColor* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		_tmp33_ = new_color;
		_tmp34_ = gala_named_color_get_theme (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = current_stylesheet;
		_tmp31_ = g_strcmp0 (_tmp35_, _tmp36_) != 0;
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		GalaNamedColor* _tmp37_;
		const gchar* _tmp38_;
		const gchar* _tmp39_;
		GSettings* _tmp40_;
		GalaNamedColor* _tmp41_;
		const gchar* _tmp42_;
		const gchar* _tmp43_;
		_tmp37_ = new_color;
		_tmp38_ = gala_named_color_get_theme (_tmp37_);
		_tmp39_ = _tmp38_;
		g_debug ("AccentColorManager.vala:133: New stylesheet: %s", _tmp39_);
		_tmp40_ = self->priv->interface_settings;
		_tmp41_ = new_color;
		_tmp42_ = gala_named_color_get_theme (_tmp41_);
		_tmp43_ = _tmp42_;
		g_settings_set_string (_tmp40_, GALA_ACCENT_COLOR_MANAGER_STYLESHEET_KEY, _tmp43_);
	}
	_g_object_unref0 (new_color);
	_g_free0 (current_stylesheet);
}

static gchar*
gala_accent_color_manager_read_accent_color_name_from_exif (GalaAccentColorManager* self,
                                                            const gchar* picture_uri)
{
	gchar* path = NULL;
	gchar* _tmp0_;
	GExiv2Metadata* metadata = NULL;
	GExiv2Metadata* _tmp10_;
	gchar* _tmp11_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (picture_uri != NULL, NULL);
	_tmp0_ = g_strdup ("");
	path = _tmp0_;
	{
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GExiv2Metadata* _tmp4_;
		GExiv2Metadata* _tmp5_;
		const gchar* _tmp6_;
		_tmp2_ = g_filename_from_uri (picture_uri, NULL, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_free0 (path);
		path = _tmp3_;
		_tmp4_ = gexiv2_metadata_new ();
		_g_object_unref0 (metadata);
		metadata = _tmp4_;
		_tmp5_ = metadata;
		_tmp6_ = path;
		gexiv2_metadata_open_path (_tmp5_, _tmp6_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp1_);
			goto __catch0_g_error;
		}
		_g_free0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = path;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("AccentColorManager.vala:150: Error parsing exif metadata of \"%s\": %s", _tmp7_, _tmp9_);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (metadata);
		_g_free0 (path);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (metadata);
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp10_ = metadata;
	_tmp11_ = gexiv2_metadata_get_tag_string (_tmp10_, GALA_ACCENT_COLOR_MANAGER_TAG_ACCENT_COLOR);
	result = _tmp11_;
	_g_object_unref0 (metadata);
	_g_free0 (path);
	return result;
}

static GalaNamedColor*
gala_accent_color_manager_get_accent_color (GalaAccentColorManager* self,
                                            GalaColorExtractor* color_extractor)
{
	GeeArrayList* palette = NULL;
	GeeArrayList* _tmp0_;
	gint index = 0;
	GeeArrayList* _tmp9_;
	GalaNamedColor** _tmp10_;
	gint _tmp10__length1;
	GalaNamedColor* _tmp11_;
	GalaNamedColor* _tmp12_;
	GalaNamedColor* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (color_extractor != NULL, NULL);
	_tmp0_ = gee_array_list_new (GRANITE_DRAWING_TYPE_COLOR, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	palette = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GalaNamedColor** _tmp3_;
				gint _tmp3__length1;
				GeeArrayList* _tmp4_;
				GalaNamedColor** _tmp5_;
				gint _tmp5__length1;
				GalaNamedColor* _tmp6_;
				GraniteDrawingColor* _tmp7_;
				GraniteDrawingColor* _tmp8_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = self->priv->theme_colors;
				_tmp3__length1 = self->priv->theme_colors_length1;
				if (!(i < _tmp3__length1)) {
					break;
				}
				_tmp4_ = palette;
				_tmp5_ = self->priv->theme_colors;
				_tmp5__length1 = self->priv->theme_colors_length1;
				_tmp6_ = _tmp5_[i];
				_tmp7_ = gala_named_color_get_color (_tmp6_);
				_tmp8_ = _tmp7_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, _tmp8_);
			}
		}
	}
	_tmp9_ = palette;
	index = gala_color_extractor_get_dominant_color_index (color_extractor, (GeeList*) _tmp9_);
	_tmp10_ = self->priv->theme_colors;
	_tmp10__length1 = self->priv->theme_colors_length1;
	_tmp11_ = _tmp10_[index];
	_tmp12_ = _g_object_ref0 (_tmp11_);
	result = _tmp12_;
	_g_object_unref0 (palette);
	return result;
}

static GalaNamedColor*
gala_accent_color_manager_get_accent_color_of_picture_simple (GalaAccentColorManager* self,
                                                              const gchar* picture_uri)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GError* _inner_error0_ = NULL;
	GalaNamedColor* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (picture_uri != NULL, NULL);
	_tmp0_ = g_file_new_for_uri (picture_uri);
	file = _tmp0_;
	{
		GdkPixbuf* pixbuf = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_;
		GalaColorExtractor* color_extractor = NULL;
		GalaColorExtractor* _tmp5_;
		GalaColorExtractor* _tmp6_;
		GalaNamedColor* _tmp7_;
		_tmp1_ = g_file_get_path (file);
		_tmp2_ = _tmp1_;
		_tmp3_ = gdk_pixbuf_new_from_file (_tmp2_, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		pixbuf = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = gala_color_extractor_new_from_pixbuf (pixbuf);
		color_extractor = _tmp5_;
		_tmp6_ = color_extractor;
		_tmp7_ = gala_accent_color_manager_get_accent_color (self, _tmp6_);
		result = _tmp7_;
		_g_object_unref0 (color_extractor);
		_g_object_unref0 (pixbuf);
		_g_object_unref0 (file);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("AccentColorManager.vala:176: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (file);
	return result;
}

static GalaNamedColor*
gala_accent_color_manager_get_accent_color_based_on_primary_color (GalaAccentColorManager* self,
                                                                   const gchar* primary_color)
{
	GraniteDrawingColor* granite_primary_color = NULL;
	GraniteDrawingColor* _tmp0_;
	GalaColorExtractor* color_extractor = NULL;
	GalaColorExtractor* _tmp1_;
	GalaNamedColor* _tmp2_;
	GalaNamedColor* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (primary_color != NULL, NULL);
	_tmp0_ = granite_drawing_color_new_from_string (primary_color);
	granite_primary_color = _tmp0_;
	_tmp1_ = gala_color_extractor_new_from_primary_color (granite_primary_color);
	color_extractor = _tmp1_;
	_tmp2_ = gala_accent_color_manager_get_accent_color (self, color_extractor);
	result = _tmp2_;
	_g_object_unref0 (color_extractor);
	_g_object_unref0 (granite_primary_color);
	return result;
}

GalaAccentColorManager*
gala_accent_color_manager_construct (GType object_type)
{
	GalaAccentColorManager * self = NULL;
	self = (GalaAccentColorManager*) g_object_new (object_type, NULL);
	return self;
}

GalaAccentColorManager*
gala_accent_color_manager_new (void)
{
	return gala_accent_color_manager_construct (GALA_TYPE_ACCENT_COLOR_MANAGER);
}

static void
_gala_accent_color_manager_____lambda61_ (GalaAccentColorManager* self)
{
	gala_accent_color_manager_update_accent_color (self);
}

static void
__gala_accent_color_manager_____lambda61__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                             GVariant* changed_properties,
                                                                             gchar** invalidated_properties,
                                                                             gpointer self)
{
	_gala_accent_color_manager_____lambda61_ ((GalaAccentColorManager*) self);
}

static void
_gala_accent_color_manager_update_accent_color_g_settings_changed (GSettings* _sender,
                                                                   const gchar* key,
                                                                   gpointer self)
{
	gala_accent_color_manager_update_accent_color ((GalaAccentColorManager*) self);
}

static GObject *
gala_accent_color_manager_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaAccentColorManager * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gchar* user_path = NULL;
	const gchar* _tmp10_;
	GSettings* _tmp16_;
	GSettings* _tmp17_;
	GSettings* _tmp18_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (gala_accent_color_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_ACCENT_COLOR_MANAGER, GalaAccentColorManager);
	_tmp0_ = g_settings_new ("org.gnome.desktop.background");
	_g_object_unref0 (self->priv->background_settings);
	self->priv->background_settings = _tmp0_;
	_tmp1_ = g_settings_new (GALA_ACCENT_COLOR_MANAGER_INTERFACE_SCHEMA);
	_g_object_unref0 (self->priv->interface_settings);
	self->priv->interface_settings = _tmp1_;
	user_path = NULL;
	{
		GalaFDOAccounts* accounts_service = NULL;
		GalaFDOAccounts* _tmp2_;
		gchar* _tmp3_ = NULL;
		GalaFDOAccounts* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp2_ = (GalaFDOAccounts*) g_initable_new (GALA_FDO_TYPE_ACCOUNTS_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.freedesktop.Accounts", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/freedesktop/Accounts", "g-interface-name", "org.freedesktop.Accounts", NULL);
		accounts_service = (GalaFDOAccounts*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = accounts_service;
		_tmp5_ = g_get_user_name ();
		_tmp6_ = gala_fdo_accounts_find_user_by_name (_tmp4_, _tmp5_, &_inner_error0_);
		_tmp3_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (accounts_service);
			goto __catch0_g_error;
		}
		_tmp7_ = _tmp3_;
		_tmp3_ = NULL;
		_g_free0 (user_path);
		user_path = _tmp7_;
		_g_free0 (_tmp3_);
		_g_object_unref0 (accounts_service);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_critical ("AccentColorManager.vala:70: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (user_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp10_ = user_path;
	if (_tmp10_ != NULL) {
		{
			GalaAccountsService* _tmp11_ = NULL;
			const gchar* _tmp12_;
			GalaAccountsService* _tmp13_;
			GalaAccountsService* _tmp14_;
			GalaAccountsService* _tmp15_;
			_tmp12_ = user_path;
			_tmp13_ = (GalaAccountsService*) g_initable_new (GALA_TYPE_ACCOUNTS_SERVICE_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.freedesktop.Accounts", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", _tmp12_, "g-interface-name", "io.elementary.pantheon.AccountsService", NULL);
			_tmp11_ = (GalaAccountsService*) _tmp13_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp14_ = _tmp11_;
			_tmp11_ = NULL;
			_g_object_unref0 (self->priv->gala_accounts_service);
			self->priv->gala_accounts_service = _tmp14_;
			_tmp15_ = self->priv->gala_accounts_service;
			g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, g_dbus_proxy_get_type (), GDBusProxy), "g-properties-changed", (GCallback) __gala_accent_color_manager_____lambda61__g_dbus_proxy_g_properties_changed, self, 0);
			_g_object_unref0 (_tmp11_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			g_clear_error (&_inner_error0_);
			g_warning ("AccentColorManager.vala:85: Unable to get AccountsService proxy, accen" \
"t color preference may be incorrect");
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (user_path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
	}
	_tmp16_ = self->priv->background_settings;
	g_signal_connect_object (_tmp16_, "changed::picture-options", (GCallback) _gala_accent_color_manager_update_accent_color_g_settings_changed, self, 0);
	_tmp17_ = self->priv->background_settings;
	g_signal_connect_object (_tmp17_, "changed::picture-uri", (GCallback) _gala_accent_color_manager_update_accent_color_g_settings_changed, self, 0);
	_tmp18_ = self->priv->background_settings;
	g_signal_connect_object (_tmp18_, "changed::primary-color", (GCallback) _gala_accent_color_manager_update_accent_color_g_settings_changed, self, 0);
	gala_accent_color_manager_update_accent_color (self);
	_g_free0 (user_path);
	return obj;
}

static void
gala_accent_color_manager_class_init (GalaAccentColorManagerClass * klass,
                                      gpointer klass_data)
{
	gala_accent_color_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaAccentColorManager_private_offset);
	G_OBJECT_CLASS (klass)->constructor = gala_accent_color_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_accent_color_manager_finalize;
}

static void
gala_accent_color_manager_instance_init (GalaAccentColorManager * self,
                                         gpointer klass)
{
	GalaNamedColor* _tmp0_;
	GalaNamedColor* _tmp1_;
	GalaNamedColor* _tmp2_;
	GalaNamedColor* _tmp3_;
	GalaNamedColor* _tmp4_;
	GalaNamedColor* _tmp5_;
	GalaNamedColor* _tmp6_;
	GalaNamedColor* _tmp7_;
	GalaNamedColor* _tmp8_;
	GalaNamedColor* _tmp9_;
	GalaNamedColor** _tmp10_;
	self->priv = gala_accent_color_manager_get_instance_private (self);
	self->priv->gala_accounts_service = NULL;
	_tmp0_ = gala_named_color_new ("Blue", GALA_ACCENT_COLOR_MANAGER_THEME_BLUE);
	_tmp1_ = gala_named_color_new ("Mint", GALA_ACCENT_COLOR_MANAGER_THEME_MINT);
	_tmp2_ = gala_named_color_new ("Green", GALA_ACCENT_COLOR_MANAGER_THEME_GREEN);
	_tmp3_ = gala_named_color_new ("Yellow", GALA_ACCENT_COLOR_MANAGER_THEME_YELLOW);
	_tmp4_ = gala_named_color_new ("Orange", GALA_ACCENT_COLOR_MANAGER_THEME_ORANGE);
	_tmp5_ = gala_named_color_new ("Red", GALA_ACCENT_COLOR_MANAGER_THEME_RED);
	_tmp6_ = gala_named_color_new ("Pink", GALA_ACCENT_COLOR_MANAGER_THEME_PINK);
	_tmp7_ = gala_named_color_new ("Purple", GALA_ACCENT_COLOR_MANAGER_THEME_PURPLE);
	_tmp8_ = gala_named_color_new ("Brown", GALA_ACCENT_COLOR_MANAGER_THEME_BROWN);
	_tmp9_ = gala_named_color_new ("Gray", GALA_ACCENT_COLOR_MANAGER_THEME_GRAY);
	_tmp10_ = g_new0 (GalaNamedColor*, 10 + 1);
	_tmp10_[0] = _tmp0_;
	_tmp10_[1] = _tmp1_;
	_tmp10_[2] = _tmp2_;
	_tmp10_[3] = _tmp3_;
	_tmp10_[4] = _tmp4_;
	_tmp10_[5] = _tmp5_;
	_tmp10_[6] = _tmp6_;
	_tmp10_[7] = _tmp7_;
	_tmp10_[8] = _tmp8_;
	_tmp10_[9] = _tmp9_;
	self->priv->theme_colors = _tmp10_;
	self->priv->theme_colors_length1 = 10;
	self->priv->_theme_colors_size_ = self->priv->theme_colors_length1;
}

static void
gala_accent_color_manager_finalize (GObject * obj)
{
	GalaAccentColorManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_ACCENT_COLOR_MANAGER, GalaAccentColorManager);
	_g_object_unref0 (self->priv->gala_accounts_service);
	_g_object_unref0 (self->priv->background_settings);
	_g_object_unref0 (self->priv->interface_settings);
	self->priv->theme_colors = (_vala_array_free (self->priv->theme_colors, self->priv->theme_colors_length1, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (gala_accent_color_manager_parent_class)->finalize (obj);
}

static GType
gala_accent_color_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaAccentColorManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_accent_color_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaAccentColorManager), 0, (GInstanceInitFunc) gala_accent_color_manager_instance_init, NULL };
	GType gala_accent_color_manager_type_id;
	gala_accent_color_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaAccentColorManager", &g_define_type_info, 0);
	GalaAccentColorManager_private_offset = g_type_add_instance_private (gala_accent_color_manager_type_id, sizeof (GalaAccentColorManagerPrivate));
	return gala_accent_color_manager_type_id;
}

GType
gala_accent_color_manager_get_type (void)
{
	static volatile gsize gala_accent_color_manager_type_id__once = 0;
	if (g_once_init_enter (&gala_accent_color_manager_type_id__once)) {
		GType gala_accent_color_manager_type_id;
		gala_accent_color_manager_type_id = gala_accent_color_manager_get_type_once ();
		g_once_init_leave (&gala_accent_color_manager_type_id__once, gala_accent_color_manager_type_id);
	}
	return gala_accent_color_manager_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

