/* ColorExtractor.c generated by valac 0.56.0, the Vala compiler
 * generated from ColorExtractor.vala, do not modify */

/*
 * Copyright 2021 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 *
 * Authored by: Marius Meisenzahl <mariusmeisenzahl@gmail.com>
 */

#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <granite.h>
#include <gee.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <string.h>

#define GALA_COLOR_EXTRACTOR_PERCENTAGE_SAMPLE_PIXELS 0.01
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_COLOR_EXTRACTOR (gala_color_extractor_get_type ())
#define GALA_COLOR_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_COLOR_EXTRACTOR, GalaColorExtractor))
#define GALA_COLOR_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_COLOR_EXTRACTOR, GalaColorExtractorClass))
#define GALA_IS_COLOR_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_COLOR_EXTRACTOR))
#define GALA_IS_COLOR_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_COLOR_EXTRACTOR))
#define GALA_COLOR_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_COLOR_EXTRACTOR, GalaColorExtractorClass))

typedef struct _GalaColorExtractor GalaColorExtractor;
typedef struct _GalaColorExtractorClass GalaColorExtractorClass;
typedef struct _GalaColorExtractorPrivate GalaColorExtractorPrivate;
enum  {
	GALA_COLOR_EXTRACTOR_0_PROPERTY,
	GALA_COLOR_EXTRACTOR_PIXBUF_PROPERTY,
	GALA_COLOR_EXTRACTOR_PRIMARY_COLOR_PROPERTY,
	GALA_COLOR_EXTRACTOR_NUM_PROPERTIES
};
static GParamSpec* gala_color_extractor_properties[GALA_COLOR_EXTRACTOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block36Data Block36Data;

struct _GalaColorExtractor {
	GObject parent_instance;
	GalaColorExtractorPrivate * priv;
};

struct _GalaColorExtractorClass {
	GObjectClass parent_class;
};

struct _GalaColorExtractorPrivate {
	GdkPixbuf* _pixbuf;
	GraniteDrawingColor* _primary_color;
	GeeList* pixels;
};

struct _Block36Data {
	int _ref_count_;
	GalaColorExtractor* self;
	gdouble* matches;
	gint matches_length1;
	gint _matches_size_;
	GeeList* palette;
};

static gint GalaColorExtractor_private_offset;
static gpointer gala_color_extractor_parent_class = NULL;

VALA_EXTERN GType gala_color_extractor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaColorExtractor, g_object_unref)
VALA_EXTERN GalaColorExtractor* gala_color_extractor_new_from_pixbuf (GdkPixbuf* pixbuf);
VALA_EXTERN GalaColorExtractor* gala_color_extractor_construct_from_pixbuf (GType object_type,
                                                                GdkPixbuf* pixbuf);
static GeeArrayList* gala_color_extractor_convert_pixels_to_rgb (GalaColorExtractor* self,
                                                          guint8* pixels,
                                                          gint pixels_length1,
                                                          gboolean has_alpha);
VALA_EXTERN GalaColorExtractor* gala_color_extractor_new_from_primary_color (GraniteDrawingColor* primary_color);
VALA_EXTERN GalaColorExtractor* gala_color_extractor_construct_from_primary_color (GType object_type,
                                                                       GraniteDrawingColor* primary_color);
VALA_EXTERN gint gala_color_extractor_get_dominant_color_index (GalaColorExtractor* self,
                                                    GeeList* palette);
static Block36Data* block36_data_ref (Block36Data* _data36_);
static void block36_data_unref (void * _userdata_);
static gboolean __lambda60_ (Block36Data* _data36_,
                      GraniteDrawingColor* pixel);
static gboolean ___lambda60__gee_forall_func (gpointer g,
                                       gpointer self);
VALA_EXTERN GalaColorExtractor* gala_color_extractor_new (void);
VALA_EXTERN GalaColorExtractor* gala_color_extractor_construct (GType object_type);
VALA_EXTERN GdkPixbuf* gala_color_extractor_get_pixbuf (GalaColorExtractor* self);
VALA_EXTERN void gala_color_extractor_set_pixbuf (GalaColorExtractor* self,
                                      GdkPixbuf* value);
VALA_EXTERN GraniteDrawingColor* gala_color_extractor_get_primary_color (GalaColorExtractor* self);
VALA_EXTERN void gala_color_extractor_set_primary_color (GalaColorExtractor* self,
                                             GraniteDrawingColor* value);
static void gala_color_extractor_finalize (GObject * obj);
static GType gala_color_extractor_get_type_once (void);
static void _vala_gala_color_extractor_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_gala_color_extractor_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gala_color_extractor_get_instance_private (GalaColorExtractor* self)
{
	return G_STRUCT_MEMBER_P (self, GalaColorExtractor_private_offset);
}

GalaColorExtractor*
gala_color_extractor_construct_from_pixbuf (GType object_type,
                                            GdkPixbuf* pixbuf)
{
	GalaColorExtractor * self = NULL;
	guint _tmp0_ = 0;
	guint8* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GeeArrayList* _tmp4_;
	g_return_val_if_fail (pixbuf != NULL, NULL);
	self = (GalaColorExtractor*) g_object_new (object_type, "pixbuf", pixbuf, NULL);
	_tmp1_ = gdk_pixbuf_get_pixels_with_length (pixbuf, &_tmp0_);
	_tmp2_ = gdk_pixbuf_get_has_alpha (pixbuf);
	_tmp3_ = _tmp2_;
	_tmp4_ = gala_color_extractor_convert_pixels_to_rgb (self, _tmp1_, (gint) _tmp0_, _tmp3_);
	_g_object_unref0 (self->priv->pixels);
	self->priv->pixels = (GeeList*) _tmp4_;
	return self;
}

GalaColorExtractor*
gala_color_extractor_new_from_pixbuf (GdkPixbuf* pixbuf)
{
	return gala_color_extractor_construct_from_pixbuf (GALA_TYPE_COLOR_EXTRACTOR, pixbuf);
}

GalaColorExtractor*
gala_color_extractor_construct_from_primary_color (GType object_type,
                                                   GraniteDrawingColor* primary_color)
{
	GalaColorExtractor * self = NULL;
	GeeArrayList* _tmp0_;
	GeeList* _tmp1_;
	g_return_val_if_fail (primary_color != NULL, NULL);
	self = (GalaColorExtractor*) g_object_new (object_type, "primary-color", primary_color, NULL);
	_tmp0_ = gee_array_list_new (GRANITE_DRAWING_TYPE_COLOR, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->pixels);
	self->priv->pixels = (GeeList*) _tmp0_;
	_tmp1_ = self->priv->pixels;
	gee_collection_add ((GeeCollection*) _tmp1_, primary_color);
	return self;
}

GalaColorExtractor*
gala_color_extractor_new_from_primary_color (GraniteDrawingColor* primary_color)
{
	return gala_color_extractor_construct_from_primary_color (GALA_TYPE_COLOR_EXTRACTOR, primary_color);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block36Data*
block36_data_ref (Block36Data* _data36_)
{
	g_atomic_int_inc (&_data36_->_ref_count_);
	return _data36_;
}

static void
block36_data_unref (void * _userdata_)
{
	Block36Data* _data36_;
	_data36_ = (Block36Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data36_->_ref_count_)) {
		GalaColorExtractor* self;
		self = _data36_->self;
		_data36_->matches = (g_free (_data36_->matches), NULL);
		_g_object_unref0 (_data36_->palette);
		_g_object_unref0 (self);
		g_slice_free (Block36Data, _data36_);
	}
}

static gboolean
__lambda60_ (Block36Data* _data36_,
             GraniteDrawingColor* pixel)
{
	GalaColorExtractor* self;
	gboolean result;
	self = _data36_->self;
	g_return_val_if_fail (pixel != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				GraniteDrawingColor* color = NULL;
				gpointer _tmp4_;
				gdouble distance = 0.0;
				GraniteDrawingColor* _tmp5_;
				GraniteDrawingColor* _tmp6_;
				GraniteDrawingColor* _tmp7_;
				gdouble* _tmp8_;
				gint _tmp8__length1;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = gee_collection_get_size ((GeeCollection*) _data36_->palette);
				_tmp3_ = _tmp2_;
				if (!(i < _tmp3_)) {
					break;
				}
				_tmp4_ = gee_list_get (_data36_->palette, i);
				color = (GraniteDrawingColor*) _tmp4_;
				_tmp5_ = color;
				_tmp6_ = color;
				_tmp7_ = color;
				distance = sqrt ((pow (pixel->R - _tmp5_->R, (gdouble) 2) + pow (pixel->G - _tmp6_->G, (gdouble) 2)) + pow (pixel->B - _tmp7_->B, (gdouble) 2));
				if (distance > 0.25) {
					_g_object_unref0 (color);
					continue;
				}
				_tmp8_ = _data36_->matches;
				_tmp8__length1 = _data36_->matches_length1;
				_tmp8_[i] += 1.0 - distance;
				_g_object_unref0 (color);
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (pixel);
	return result;
}

static gboolean
___lambda60__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = __lambda60_ (self, (GraniteDrawingColor*) g);
	return result;
}

gint
gala_color_extractor_get_dominant_color_index (GalaColorExtractor* self,
                                               GeeList* palette)
{
	Block36Data* _data36_;
	GeeList* _tmp0_;
	gint index = 0;
	gint _tmp1_;
	gint _tmp2_;
	gdouble* _tmp3_;
	GeeList* _tmp4_;
	gdouble best_match = 0.0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (palette != NULL, 0);
	_data36_ = g_slice_new0 (Block36Data);
	_data36_->_ref_count_ = 1;
	_data36_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (palette);
	_g_object_unref0 (_data36_->palette);
	_data36_->palette = _tmp0_;
	index = 0;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _data36_->palette);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_new0 (gdouble, _tmp2_);
	_data36_->matches = _tmp3_;
	_data36_->matches_length1 = _tmp2_;
	_data36_->_matches_size_ = _data36_->matches_length1;
	_tmp4_ = self->priv->pixels;
	gee_traversable_foreach ((GeeTraversable*) _tmp4_, ___lambda60__gee_forall_func, _data36_);
	best_match = DBL_MIN;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gdouble* _tmp7_;
				gint _tmp7__length1;
				gdouble* _tmp8_;
				gint _tmp8__length1;
				gdouble _tmp9_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = _data36_->matches;
				_tmp7__length1 = _data36_->matches_length1;
				if (!(i < _tmp7__length1)) {
					break;
				}
				_tmp8_ = _data36_->matches;
				_tmp8__length1 = _data36_->matches_length1;
				_tmp9_ = _tmp8_[i];
				if (_tmp9_ > best_match) {
					gdouble* _tmp10_;
					gint _tmp10__length1;
					gdouble _tmp11_;
					_tmp10_ = _data36_->matches;
					_tmp10__length1 = _data36_->matches_length1;
					_tmp11_ = _tmp10_[i];
					best_match = _tmp11_;
					index = i;
				}
			}
		}
	}
	result = index;
	block36_data_unref (_data36_);
	_data36_ = NULL;
	return result;
}

static GeeArrayList*
gala_color_extractor_convert_pixels_to_rgb (GalaColorExtractor* self,
                                            guint8* pixels,
                                            gint pixels_length1,
                                            gboolean has_alpha)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	gint factor = 0;
	gint step_size = 0;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (GRANITE_DRAWING_TYPE_COLOR, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = _tmp0_;
	factor = 3 + ((gint) has_alpha);
	step_size = (gint) ((pixels_length1 / factor) * GALA_COLOR_EXTRACTOR_PERCENTAGE_SAMPLE_PIXELS);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint offset = 0;
				gdouble red = 0.0;
				guint8 _tmp2_;
				gdouble green = 0.0;
				guint8 _tmp3_;
				gdouble blue = 0.0;
				guint8 _tmp4_;
				GeeArrayList* _tmp5_;
				GraniteDrawingColor* _tmp6_;
				GraniteDrawingColor* _tmp7_;
				if (!_tmp1_) {
					i += step_size;
				}
				_tmp1_ = FALSE;
				if (!(i < (pixels_length1 / factor))) {
					break;
				}
				offset = i * factor;
				_tmp2_ = pixels[offset];
				red = _tmp2_ / 255.0;
				_tmp3_ = pixels[offset + 1];
				green = _tmp3_ / 255.0;
				_tmp4_ = pixels[offset + 2];
				blue = _tmp4_ / 255.0;
				_tmp5_ = list;
				_tmp6_ = granite_drawing_color_new (red, green, blue, 0.0);
				_tmp7_ = _tmp6_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, _tmp7_);
				_g_object_unref0 (_tmp7_);
			}
		}
	}
	result = list;
	return result;
}

GalaColorExtractor*
gala_color_extractor_construct (GType object_type)
{
	GalaColorExtractor * self = NULL;
	self = (GalaColorExtractor*) g_object_new (object_type, NULL);
	return self;
}

GalaColorExtractor*
gala_color_extractor_new (void)
{
	return gala_color_extractor_construct (GALA_TYPE_COLOR_EXTRACTOR);
}

GdkPixbuf*
gala_color_extractor_get_pixbuf (GalaColorExtractor* self)
{
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_pixbuf;
	result = _tmp0_;
	return result;
}

void
gala_color_extractor_set_pixbuf (GalaColorExtractor* self,
                                 GdkPixbuf* value)
{
	GdkPixbuf* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_color_extractor_get_pixbuf (self);
	if (old_value != value) {
		GdkPixbuf* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_pixbuf);
		self->priv->_pixbuf = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_color_extractor_properties[GALA_COLOR_EXTRACTOR_PIXBUF_PROPERTY]);
	}
}

GraniteDrawingColor*
gala_color_extractor_get_primary_color (GalaColorExtractor* self)
{
	GraniteDrawingColor* result;
	GraniteDrawingColor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_primary_color;
	result = _tmp0_;
	return result;
}

void
gala_color_extractor_set_primary_color (GalaColorExtractor* self,
                                        GraniteDrawingColor* value)
{
	GraniteDrawingColor* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_color_extractor_get_primary_color (self);
	if (old_value != value) {
		GraniteDrawingColor* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_primary_color);
		self->priv->_primary_color = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_color_extractor_properties[GALA_COLOR_EXTRACTOR_PRIMARY_COLOR_PROPERTY]);
	}
}

static void
gala_color_extractor_class_init (GalaColorExtractorClass * klass,
                                 gpointer klass_data)
{
	gala_color_extractor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaColorExtractor_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_color_extractor_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_color_extractor_set_property;
	G_OBJECT_CLASS (klass)->finalize = gala_color_extractor_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_COLOR_EXTRACTOR_PIXBUF_PROPERTY, gala_color_extractor_properties[GALA_COLOR_EXTRACTOR_PIXBUF_PROPERTY] = g_param_spec_object ("pixbuf", "pixbuf", "pixbuf", gdk_pixbuf_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_COLOR_EXTRACTOR_PRIMARY_COLOR_PROPERTY, gala_color_extractor_properties[GALA_COLOR_EXTRACTOR_PRIMARY_COLOR_PROPERTY] = g_param_spec_object ("primary-color", "primary-color", "primary-color", GRANITE_DRAWING_TYPE_COLOR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
gala_color_extractor_instance_init (GalaColorExtractor * self,
                                    gpointer klass)
{
	self->priv = gala_color_extractor_get_instance_private (self);
}

static void
gala_color_extractor_finalize (GObject * obj)
{
	GalaColorExtractor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_COLOR_EXTRACTOR, GalaColorExtractor);
	_g_object_unref0 (self->priv->_pixbuf);
	_g_object_unref0 (self->priv->_primary_color);
	_g_object_unref0 (self->priv->pixels);
	G_OBJECT_CLASS (gala_color_extractor_parent_class)->finalize (obj);
}

static GType
gala_color_extractor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaColorExtractorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_color_extractor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaColorExtractor), 0, (GInstanceInitFunc) gala_color_extractor_instance_init, NULL };
	GType gala_color_extractor_type_id;
	gala_color_extractor_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaColorExtractor", &g_define_type_info, 0);
	GalaColorExtractor_private_offset = g_type_add_instance_private (gala_color_extractor_type_id, sizeof (GalaColorExtractorPrivate));
	return gala_color_extractor_type_id;
}

GType
gala_color_extractor_get_type (void)
{
	static volatile gsize gala_color_extractor_type_id__once = 0;
	if (g_once_init_enter (&gala_color_extractor_type_id__once)) {
		GType gala_color_extractor_type_id;
		gala_color_extractor_type_id = gala_color_extractor_get_type_once ();
		g_once_init_leave (&gala_color_extractor_type_id__once, gala_color_extractor_type_id);
	}
	return gala_color_extractor_type_id__once;
}

static void
_vala_gala_color_extractor_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	GalaColorExtractor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_COLOR_EXTRACTOR, GalaColorExtractor);
	switch (property_id) {
		case GALA_COLOR_EXTRACTOR_PIXBUF_PROPERTY:
		g_value_set_object (value, gala_color_extractor_get_pixbuf (self));
		break;
		case GALA_COLOR_EXTRACTOR_PRIMARY_COLOR_PROPERTY:
		g_value_set_object (value, gala_color_extractor_get_primary_color (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_color_extractor_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	GalaColorExtractor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_COLOR_EXTRACTOR, GalaColorExtractor);
	switch (property_id) {
		case GALA_COLOR_EXTRACTOR_PIXBUF_PROPERTY:
		gala_color_extractor_set_pixbuf (self, g_value_get_object (value));
		break;
		case GALA_COLOR_EXTRACTOR_PRIMARY_COLOR_PROPERTY:
		gala_color_extractor_set_primary_color (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

