/* Animation.c generated by valac 0.56.0, the Vala compiler
 * generated from Animation.vala, do not modify */

/**/
/*  Copyright (C) 2014 Tom Beckmann*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <libgnome-desktop/gnome-bg-slide-show.h>
#include <gio/gio.h>
#include <meta/boxes.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_ANIMATION (gala_animation_get_type ())
#define GALA_ANIMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ANIMATION, GalaAnimation))
#define GALA_ANIMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_ANIMATION, GalaAnimationClass))
#define GALA_IS_ANIMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ANIMATION))
#define GALA_IS_ANIMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_ANIMATION))
#define GALA_ANIMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_ANIMATION, GalaAnimationClass))

typedef struct _GalaAnimation GalaAnimation;
typedef struct _GalaAnimationClass GalaAnimationClass;
typedef struct _GalaAnimationPrivate GalaAnimationPrivate;
enum  {
	GALA_ANIMATION_0_PROPERTY,
	GALA_ANIMATION_FILENAME_PROPERTY,
	GALA_ANIMATION_KEY_FRAME_FILES_PROPERTY,
	GALA_ANIMATION_TRANSITION_PROGRESS_PROPERTY,
	GALA_ANIMATION_TRANSITION_DURATION_PROPERTY,
	GALA_ANIMATION_LOADED_PROPERTY,
	GALA_ANIMATION_NUM_PROPERTIES
};
static GParamSpec* gala_animation_properties[GALA_ANIMATION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block37Data Block37Data;
typedef struct _GalaAnimationLoadData GalaAnimationLoadData;

struct _GalaAnimation {
	GObject parent_instance;
	GalaAnimationPrivate * priv;
};

struct _GalaAnimationClass {
	GObjectClass parent_class;
};

struct _GalaAnimationPrivate {
	gchar* _filename;
	gchar** _key_frame_files;
	gint _key_frame_files_length1;
	gint __key_frame_files_size_;
	gdouble _transition_progress;
	gdouble _transition_duration;
	gboolean _loaded;
	GnomeBGSlideShow* show;
};

struct _Block37Data {
	int _ref_count_;
	GalaAnimation* self;
	gpointer _async_data_;
};

struct _GalaAnimationLoadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GalaAnimation* self;
	Block37Data* _data37_;
	const gchar* _tmp0_;
	GnomeBGSlideShow* _tmp1_;
	GnomeBGSlideShow* _tmp2_;
};

static gint GalaAnimation_private_offset;
static gpointer gala_animation_parent_class = NULL;

VALA_EXTERN GType gala_animation_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaAnimation, g_object_unref)
VALA_EXTERN GalaAnimation* gala_animation_new (const gchar* filename);
VALA_EXTERN GalaAnimation* gala_animation_construct (GType object_type,
                                         const gchar* filename);
static void gala_animation_load_data_free (gpointer _data);
VALA_EXTERN void gala_animation_load (GalaAnimation* self,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_);
VALA_EXTERN void gala_animation_load_finish (GalaAnimation* self,
                                 GAsyncResult* _res_);
static gboolean gala_animation_load_co (GalaAnimationLoadData* _data_);
static Block37Data* block37_data_ref (Block37Data* _data37_);
static void block37_data_unref (void * _userdata_);
VALA_EXTERN const gchar* gala_animation_get_filename (GalaAnimation* self);
static void __lambda65_ (Block37Data* _data37_,
                  GObject* obj,
                  GAsyncResult* res);
static void gala_animation_set_loaded (GalaAnimation* self,
                                gboolean value);
static void ___lambda65__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN void gala_animation_update (GalaAnimation* self,
                            MetaRectangle* monitor);
static void gala_animation_set_transition_duration (GalaAnimation* self,
                                             gdouble value);
static void gala_animation_set_transition_progress (GalaAnimation* self,
                                             gdouble value);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add5 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void gala_animation_set_key_frame_files (GalaAnimation* self,
                                         gchar** value,
                                         gint value_length1);
static void gala_animation_set_filename (GalaAnimation* self,
                                  const gchar* value);
VALA_EXTERN gchar** gala_animation_get_key_frame_files (GalaAnimation* self,
                                            gint* result_length1);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
VALA_EXTERN gdouble gala_animation_get_transition_progress (GalaAnimation* self);
VALA_EXTERN gdouble gala_animation_get_transition_duration (GalaAnimation* self);
VALA_EXTERN gboolean gala_animation_get_loaded (GalaAnimation* self);
static void gala_animation_finalize (GObject * obj);
static GType gala_animation_get_type_once (void);
static void _vala_gala_animation_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_gala_animation_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gala_animation_get_instance_private (GalaAnimation* self)
{
	return G_STRUCT_MEMBER_P (self, GalaAnimation_private_offset);
}

GalaAnimation*
gala_animation_construct (GType object_type,
                          const gchar* filename)
{
	GalaAnimation * self = NULL;
	g_return_val_if_fail (filename != NULL, NULL);
	self = (GalaAnimation*) g_object_new (object_type, "filename", filename, NULL);
	return self;
}

GalaAnimation*
gala_animation_new (const gchar* filename)
{
	return gala_animation_construct (GALA_TYPE_ANIMATION, filename);
}

static void
gala_animation_load_data_free (gpointer _data)
{
	GalaAnimationLoadData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GalaAnimationLoadData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
gala_animation_load (GalaAnimation* self,
                     GAsyncReadyCallback _callback_,
                     gpointer _user_data_)
{
	GalaAnimationLoadData* _data_;
	GalaAnimation* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GalaAnimationLoadData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gala_animation_load_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	gala_animation_load_co (_data_);
}

void
gala_animation_load_finish (GalaAnimation* self,
                            GAsyncResult* _res_)
{
	GalaAnimationLoadData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block37Data*
block37_data_ref (Block37Data* _data37_)
{
	g_atomic_int_inc (&_data37_->_ref_count_);
	return _data37_;
}

static void
block37_data_unref (void * _userdata_)
{
	Block37Data* _data37_;
	_data37_ = (Block37Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data37_->_ref_count_)) {
		GalaAnimation* self;
		self = _data37_->self;
		_g_object_unref0 (self);
		g_slice_free (Block37Data, _data37_);
	}
}

static void
__lambda65_ (Block37Data* _data37_,
             GObject* obj,
             GAsyncResult* res)
{
	GalaAnimation* self;
	self = _data37_->self;
	g_return_if_fail (res != NULL);
	gala_animation_set_loaded (self, TRUE);
	gala_animation_load_co (_data37_->_async_data_);
}

static void
___lambda65__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda65_ (self, source_object, res);
}

static gboolean
gala_animation_load_co (GalaAnimationLoadData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data37_ = g_slice_new0 (Block37Data);
	_data_->_data37_->_ref_count_ = 1;
	_data_->_data37_->self = g_object_ref (_data_->self);
	_data_->_data37_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->_filename;
	_data_->_tmp1_ = gnome_bg_slide_show_new (_data_->_tmp0_);
	_g_object_unref0 (_data_->self->priv->show);
	_data_->self->priv->show = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->self->priv->show;
	gnome_bg_slide_show_load_async (_data_->_tmp2_, NULL, ___lambda65__gasync_ready_callback, _data_->_data37_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block37_data_unref (_data_->_data37_);
	_data_->_data37_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add5 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
gala_animation_update (GalaAnimation* self,
                       MetaRectangle* monitor)
{
	gchar** key_frame_files = NULL;
	gchar** _tmp0_;
	gint key_frame_files_length1;
	gint _key_frame_files_size_;
	GnomeBGSlideShow* _tmp1_;
	GnomeBGSlideShow* _tmp2_;
	gdouble progress = 0.0;
	gdouble duration = 0.0;
	gboolean is_fixed = FALSE;
	gchar* file1 = NULL;
	gchar* file2 = NULL;
	GnomeBGSlideShow* _tmp3_;
	MetaRectangle _tmp4_;
	MetaRectangle _tmp5_;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp16_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor != NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	key_frame_files = _tmp0_;
	key_frame_files_length1 = 0;
	_key_frame_files_size_ = key_frame_files_length1;
	_tmp1_ = self->priv->show;
	if (_tmp1_ == NULL) {
		key_frame_files = (_vala_array_free (key_frame_files, key_frame_files_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp2_ = self->priv->show;
	if (gnome_bg_slide_show_get_num_slides (_tmp2_) < 1) {
		key_frame_files = (_vala_array_free (key_frame_files, key_frame_files_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp3_ = self->priv->show;
	_tmp4_ = *monitor;
	_tmp5_ = *monitor;
	gnome_bg_slide_show_get_current_slide (_tmp3_, _tmp4_.width, _tmp5_.height, &_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_, &_tmp10_);
	progress = _tmp6_;
	duration = _tmp7_;
	is_fixed = _tmp8_;
	_g_free0 (file1);
	_tmp11_ = g_strdup (_tmp9_);
	file1 = _tmp11_;
	_g_free0 (file2);
	_tmp12_ = g_strdup (_tmp10_);
	file2 = _tmp12_;
	gala_animation_set_transition_duration (self, duration);
	gala_animation_set_transition_progress (self, progress);
	_tmp13_ = file1;
	if (_tmp13_ != NULL) {
		const gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp14_ = file1;
		_tmp15_ = g_strdup (_tmp14_);
		_vala_array_add4 (&key_frame_files, &key_frame_files_length1, &_key_frame_files_size_, _tmp15_);
	}
	_tmp16_ = file2;
	if (_tmp16_ != NULL) {
		const gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp17_ = file2;
		_tmp18_ = g_strdup (_tmp17_);
		_vala_array_add5 (&key_frame_files, &key_frame_files_length1, &_key_frame_files_size_, _tmp18_);
	}
	_tmp19_ = key_frame_files;
	_tmp19__length1 = key_frame_files_length1;
	gala_animation_set_key_frame_files (self, _tmp19_, _tmp19__length1);
	_g_free0 (file2);
	_g_free0 (file1);
	key_frame_files = (_vala_array_free (key_frame_files, key_frame_files_length1, (GDestroyNotify) g_free), NULL);
}

const gchar*
gala_animation_get_filename (GalaAnimation* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_filename;
	result = _tmp0_;
	return result;
}

static void
gala_animation_set_filename (GalaAnimation* self,
                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_animation_get_filename (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_filename);
		self->priv->_filename = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_animation_properties[GALA_ANIMATION_FILENAME_PROPERTY]);
	}
}

gchar**
gala_animation_get_key_frame_files (GalaAnimation* self,
                                    gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_key_frame_files;
	_tmp0__length1 = self->priv->_key_frame_files_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
gala_animation_set_key_frame_files (GalaAnimation* self,
                                    gchar** value,
                                    gint value_length1)
{
	gchar** old_value;
	gint old_value_length;
	g_return_if_fail (self != NULL);
	old_value = gala_animation_get_key_frame_files (self, &old_value_length);
	if (old_value != value) {
		gchar** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = (value != NULL) ? _vala_array_dup2 (value, value_length1) : value;
		_tmp0__length1 = value_length1;
		self->priv->_key_frame_files = (_vala_array_free (self->priv->_key_frame_files, self->priv->_key_frame_files_length1, (GDestroyNotify) g_free), NULL);
		self->priv->_key_frame_files = _tmp0_;
		self->priv->_key_frame_files_length1 = _tmp0__length1;
		self->priv->__key_frame_files_size_ = self->priv->_key_frame_files_length1;
		g_object_notify_by_pspec ((GObject *) self, gala_animation_properties[GALA_ANIMATION_KEY_FRAME_FILES_PROPERTY]);
	}
}

gdouble
gala_animation_get_transition_progress (GalaAnimation* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_transition_progress;
	return result;
}

static void
gala_animation_set_transition_progress (GalaAnimation* self,
                                        gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_animation_get_transition_progress (self);
	if (old_value != value) {
		self->priv->_transition_progress = value;
		g_object_notify_by_pspec ((GObject *) self, gala_animation_properties[GALA_ANIMATION_TRANSITION_PROGRESS_PROPERTY]);
	}
}

gdouble
gala_animation_get_transition_duration (GalaAnimation* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_transition_duration;
	return result;
}

static void
gala_animation_set_transition_duration (GalaAnimation* self,
                                        gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_animation_get_transition_duration (self);
	if (old_value != value) {
		self->priv->_transition_duration = value;
		g_object_notify_by_pspec ((GObject *) self, gala_animation_properties[GALA_ANIMATION_TRANSITION_DURATION_PROPERTY]);
	}
}

gboolean
gala_animation_get_loaded (GalaAnimation* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_loaded;
	return result;
}

static void
gala_animation_set_loaded (GalaAnimation* self,
                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_animation_get_loaded (self);
	if (old_value != value) {
		self->priv->_loaded = value;
		g_object_notify_by_pspec ((GObject *) self, gala_animation_properties[GALA_ANIMATION_LOADED_PROPERTY]);
	}
}

static void
gala_animation_class_init (GalaAnimationClass * klass,
                           gpointer klass_data)
{
	gala_animation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaAnimation_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_animation_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_animation_set_property;
	G_OBJECT_CLASS (klass)->finalize = gala_animation_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_ANIMATION_FILENAME_PROPERTY, gala_animation_properties[GALA_ANIMATION_FILENAME_PROPERTY] = g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_ANIMATION_KEY_FRAME_FILES_PROPERTY, gala_animation_properties[GALA_ANIMATION_KEY_FRAME_FILES_PROPERTY] = g_param_spec_boxed ("key-frame-files", "key-frame-files", "key-frame-files", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_ANIMATION_TRANSITION_PROGRESS_PROPERTY, gala_animation_properties[GALA_ANIMATION_TRANSITION_PROGRESS_PROPERTY] = g_param_spec_double ("transition-progress", "transition-progress", "transition-progress", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_ANIMATION_TRANSITION_DURATION_PROPERTY, gala_animation_properties[GALA_ANIMATION_TRANSITION_DURATION_PROPERTY] = g_param_spec_double ("transition-duration", "transition-duration", "transition-duration", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_ANIMATION_LOADED_PROPERTY, gala_animation_properties[GALA_ANIMATION_LOADED_PROPERTY] = g_param_spec_boolean ("loaded", "loaded", "loaded", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gala_animation_instance_init (GalaAnimation * self,
                              gpointer klass)
{
	gchar** _tmp0_;
	self->priv = gala_animation_get_instance_private (self);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	self->priv->_key_frame_files = _tmp0_;
	self->priv->_key_frame_files_length1 = 0;
	self->priv->__key_frame_files_size_ = self->priv->_key_frame_files_length1;
	self->priv->_transition_progress = 0.0;
	self->priv->_transition_duration = 0.0;
	self->priv->_loaded = FALSE;
	self->priv->show = NULL;
}

static void
gala_animation_finalize (GObject * obj)
{
	GalaAnimation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_ANIMATION, GalaAnimation);
	_g_free0 (self->priv->_filename);
	self->priv->_key_frame_files = (_vala_array_free (self->priv->_key_frame_files, self->priv->_key_frame_files_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->show);
	G_OBJECT_CLASS (gala_animation_parent_class)->finalize (obj);
}

static GType
gala_animation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaAnimationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_animation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaAnimation), 0, (GInstanceInitFunc) gala_animation_instance_init, NULL };
	GType gala_animation_type_id;
	gala_animation_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaAnimation", &g_define_type_info, 0);
	GalaAnimation_private_offset = g_type_add_instance_private (gala_animation_type_id, sizeof (GalaAnimationPrivate));
	return gala_animation_type_id;
}

GType
gala_animation_get_type (void)
{
	static volatile gsize gala_animation_type_id__once = 0;
	if (g_once_init_enter (&gala_animation_type_id__once)) {
		GType gala_animation_type_id;
		gala_animation_type_id = gala_animation_get_type_once ();
		g_once_init_leave (&gala_animation_type_id__once, gala_animation_type_id);
	}
	return gala_animation_type_id__once;
}

static void
_vala_gala_animation_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	GalaAnimation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_ANIMATION, GalaAnimation);
	switch (property_id) {
		case GALA_ANIMATION_FILENAME_PROPERTY:
		g_value_set_string (value, gala_animation_get_filename (self));
		break;
		case GALA_ANIMATION_KEY_FRAME_FILES_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, gala_animation_get_key_frame_files (self, &length));
		}
		break;
		case GALA_ANIMATION_TRANSITION_PROGRESS_PROPERTY:
		g_value_set_double (value, gala_animation_get_transition_progress (self));
		break;
		case GALA_ANIMATION_TRANSITION_DURATION_PROPERTY:
		g_value_set_double (value, gala_animation_get_transition_duration (self));
		break;
		case GALA_ANIMATION_LOADED_PROPERTY:
		g_value_set_boolean (value, gala_animation_get_loaded (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_animation_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	GalaAnimation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_ANIMATION, GalaAnimation);
	switch (property_id) {
		case GALA_ANIMATION_FILENAME_PROPERTY:
		gala_animation_set_filename (self, g_value_get_string (value));
		break;
		case GALA_ANIMATION_KEY_FRAME_FILES_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			gala_animation_set_key_frame_files (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case GALA_ANIMATION_TRANSITION_PROGRESS_PROPERTY:
		gala_animation_set_transition_progress (self, g_value_get_double (value));
		break;
		case GALA_ANIMATION_TRANSITION_DURATION_PROPERTY:
		gala_animation_set_transition_duration (self, g_value_get_double (value));
		break;
		case GALA_ANIMATION_LOADED_PROPERTY:
		gala_animation_set_loaded (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

