/* BackgroundCache.c generated by valac 0.56.0, the Vala compiler
 * generated from BackgroundCache.vala, do not modify */

/**/
/*  Copyright (C) 2014 Tom Beckmann*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <meta/display.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_BACKGROUND_CACHE (gala_background_cache_get_type ())
#define GALA_BACKGROUND_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND_CACHE, GalaBackgroundCache))
#define GALA_BACKGROUND_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND_CACHE, GalaBackgroundCacheClass))
#define GALA_IS_BACKGROUND_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND_CACHE))
#define GALA_IS_BACKGROUND_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND_CACHE))
#define GALA_BACKGROUND_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND_CACHE, GalaBackgroundCacheClass))

typedef struct _GalaBackgroundCache GalaBackgroundCache;
typedef struct _GalaBackgroundCacheClass GalaBackgroundCacheClass;
typedef struct _GalaBackgroundCachePrivate GalaBackgroundCachePrivate;

#define GALA_TYPE_BACKGROUND_SOURCE (gala_background_source_get_type ())
#define GALA_BACKGROUND_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND_SOURCE, GalaBackgroundSource))
#define GALA_BACKGROUND_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND_SOURCE, GalaBackgroundSourceClass))
#define GALA_IS_BACKGROUND_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND_SOURCE))
#define GALA_IS_BACKGROUND_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND_SOURCE))
#define GALA_BACKGROUND_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND_SOURCE, GalaBackgroundSourceClass))

typedef struct _GalaBackgroundSource GalaBackgroundSource;
typedef struct _GalaBackgroundSourceClass GalaBackgroundSourceClass;

#define GALA_TYPE_ANIMATION (gala_animation_get_type ())
#define GALA_ANIMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ANIMATION, GalaAnimation))
#define GALA_ANIMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_ANIMATION, GalaAnimationClass))
#define GALA_IS_ANIMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ANIMATION))
#define GALA_IS_ANIMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_ANIMATION))
#define GALA_ANIMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_ANIMATION, GalaAnimationClass))

typedef struct _GalaAnimation GalaAnimation;
typedef struct _GalaAnimationClass GalaAnimationClass;
enum  {
	GALA_BACKGROUND_CACHE_0_PROPERTY,
	GALA_BACKGROUND_CACHE_NUM_PROPERTIES
};
static GParamSpec* gala_background_cache_properties[GALA_BACKGROUND_CACHE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block44Data Block44Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block45Data Block45Data;
typedef struct _GalaBackgroundCacheGetAnimationData GalaBackgroundCacheGetAnimationData;
enum  {
	GALA_BACKGROUND_CACHE_FILE_CHANGED_SIGNAL,
	GALA_BACKGROUND_CACHE_NUM_SIGNALS
};
static guint gala_background_cache_signals[GALA_BACKGROUND_CACHE_NUM_SIGNALS] = {0};

struct _GalaBackgroundCache {
	GObject parent_instance;
	GalaBackgroundCachePrivate * priv;
};

struct _GalaBackgroundCacheClass {
	GObjectClass parent_class;
};

struct _GalaBackgroundCachePrivate {
	GeeHashMap* file_monitors;
	GeeHashMap* background_sources;
	GalaAnimation* animation;
	gchar* animation_filename;
};

struct _Block44Data {
	int _ref_count_;
	GalaBackgroundCache* self;
	gchar* filename;
};

struct _Block45Data {
	int _ref_count_;
	GalaBackgroundCache* self;
	gpointer _async_data_;
};

struct _GalaBackgroundCacheGetAnimationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GalaBackgroundCache* self;
	gchar* filename;
	GalaAnimation* result;
	Block45Data* _data45_;
	const gchar* _tmp0_;
	GalaAnimation* _tmp1_;
	GalaAnimation* _tmp2_;
	GalaAnimation* animation;
	GalaAnimation* _tmp3_;
	GalaAnimation* _tmp4_;
};

static gint GalaBackgroundCache_private_offset;
static gpointer gala_background_cache_parent_class = NULL;
static GalaBackgroundCache* gala_background_cache_instance;
static GalaBackgroundCache* gala_background_cache_instance = NULL;

VALA_EXTERN GType gala_background_cache_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackgroundCache, g_object_unref)
VALA_EXTERN GType gala_background_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackgroundSource, g_object_unref)
VALA_EXTERN GType gala_animation_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaAnimation, g_object_unref)
VALA_EXTERN GalaBackgroundCache* gala_background_cache_get_default (void);
VALA_EXTERN GalaBackgroundCache* gala_background_cache_new (void);
VALA_EXTERN GalaBackgroundCache* gala_background_cache_construct (GType object_type);
VALA_EXTERN void gala_background_cache_monitor_file (GalaBackgroundCache* self,
                                         const gchar* filename);
static Block44Data* block44_data_ref (Block44Data* _data44_);
static void block44_data_unref (void * _userdata_);
static void ___lambda66_ (Block44Data* _data44_);
static void ____lambda66__g_file_monitor_changed (GFileMonitor* _sender,
                                           GFile* file,
                                           GFile* other_file,
                                           GFileMonitorEvent event_type,
                                           gpointer self);
static void gala_background_cache_get_animation_data_free (gpointer _data);
VALA_EXTERN void gala_background_cache_get_animation (GalaBackgroundCache* self,
                                          const gchar* filename,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
VALA_EXTERN GalaAnimation* gala_background_cache_get_animation_finish (GalaBackgroundCache* self,
                                                           GAsyncResult* _res_);
static gboolean gala_background_cache_get_animation_co (GalaBackgroundCacheGetAnimationData* _data_);
static Block45Data* block45_data_ref (Block45Data* _data45_);
static void block45_data_unref (void * _userdata_);
static gboolean ___lambda67_ (Block45Data* _data45_);
static gboolean ____lambda67__gsource_func (gpointer self);
VALA_EXTERN GalaAnimation* gala_animation_new (const gchar* filename);
VALA_EXTERN GalaAnimation* gala_animation_construct (GType object_type,
                                         const gchar* filename);
VALA_EXTERN void gala_animation_load (GalaAnimation* self,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_);
VALA_EXTERN void gala_animation_load_finish (GalaAnimation* self,
                                 GAsyncResult* _res_);
static void gala_background_cache_get_animation_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static gboolean __lambda68_ (Block45Data* _data45_);
static gboolean ___lambda68__gsource_func (gpointer self);
VALA_EXTERN GalaBackgroundSource* gala_background_cache_get_background_source (GalaBackgroundCache* self,
                                                                   MetaDisplay* display,
                                                                   const gchar* settings_schema);
VALA_EXTERN GalaBackgroundSource* gala_background_source_new (MetaDisplay* display,
                                                  const gchar* settings_schema);
VALA_EXTERN GalaBackgroundSource* gala_background_source_construct (GType object_type,
                                                        MetaDisplay* display,
                                                        const gchar* settings_schema);
 G_GNUC_INTERNAL void gala_background_source_set_use_count (GalaBackgroundSource* self,
                                           gint value);
 G_GNUC_INTERNAL gint gala_background_source_get_use_count (GalaBackgroundSource* self);
VALA_EXTERN void gala_background_cache_release_background_source (GalaBackgroundCache* self,
                                                      const gchar* settings_schema);
VALA_EXTERN void gala_background_source_destroy (GalaBackgroundSource* self);
static GObject * gala_background_cache_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void gala_background_cache_finalize (GObject * obj);
static GType gala_background_cache_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gala_background_cache_get_instance_private (GalaBackgroundCache* self)
{
	return G_STRUCT_MEMBER_P (self, GalaBackgroundCache_private_offset);
}

GalaBackgroundCache*
gala_background_cache_get_default (void)
{
	GalaBackgroundCache* _tmp0_;
	GalaBackgroundCache* _tmp2_;
	GalaBackgroundCache* result;
	_tmp0_ = gala_background_cache_instance;
	if (_tmp0_ == NULL) {
		GalaBackgroundCache* _tmp1_;
		_tmp1_ = gala_background_cache_new ();
		_g_object_unref0 (gala_background_cache_instance);
		gala_background_cache_instance = _tmp1_;
	}
	_tmp2_ = gala_background_cache_instance;
	result = _tmp2_;
	return result;
}

GalaBackgroundCache*
gala_background_cache_construct (GType object_type)
{
	GalaBackgroundCache * self = NULL;
	self = (GalaBackgroundCache*) g_object_new (object_type, NULL);
	return self;
}

GalaBackgroundCache*
gala_background_cache_new (void)
{
	return gala_background_cache_construct (GALA_TYPE_BACKGROUND_CACHE);
}

static Block44Data*
block44_data_ref (Block44Data* _data44_)
{
	g_atomic_int_inc (&_data44_->_ref_count_);
	return _data44_;
}

static void
block44_data_unref (void * _userdata_)
{
	Block44Data* _data44_;
	_data44_ = (Block44Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data44_->_ref_count_)) {
		GalaBackgroundCache* self;
		self = _data44_->self;
		_g_free0 (_data44_->filename);
		_g_object_unref0 (self);
		g_slice_free (Block44Data, _data44_);
	}
}

static void
___lambda66_ (Block44Data* _data44_)
{
	GalaBackgroundCache* self;
	self = _data44_->self;
	g_signal_emit (self, gala_background_cache_signals[GALA_BACKGROUND_CACHE_FILE_CHANGED_SIGNAL], 0, _data44_->filename);
}

static void
____lambda66__g_file_monitor_changed (GFileMonitor* _sender,
                                      GFile* file,
                                      GFile* other_file,
                                      GFileMonitorEvent event_type,
                                      gpointer self)
{
	___lambda66_ (self);
}

void
gala_background_cache_monitor_file (GalaBackgroundCache* self,
                                    const gchar* filename)
{
	Block44Data* _data44_;
	gchar* _tmp0_;
	GeeHashMap* _tmp1_;
	GFile* file = NULL;
	GFile* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_data44_ = g_slice_new0 (Block44Data);
	_data44_->_ref_count_ = 1;
	_data44_->self = g_object_ref (self);
	_tmp0_ = g_strdup (filename);
	_g_free0 (_data44_->filename);
	_data44_->filename = _tmp0_;
	_tmp1_ = self->priv->file_monitors;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, _data44_->filename)) {
		block44_data_unref (_data44_);
		_data44_ = NULL;
		return;
	}
	_tmp2_ = g_file_new_for_path (_data44_->filename);
	file = _tmp2_;
	{
		GFileMonitor* monitor = NULL;
		GFile* _tmp3_;
		GFileMonitor* _tmp4_;
		GFileMonitor* _tmp5_;
		GeeHashMap* _tmp6_;
		GFileMonitor* _tmp7_;
		_tmp3_ = file;
		_tmp4_ = g_file_monitor (_tmp3_, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
		monitor = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = monitor;
		g_signal_connect_data (_tmp5_, "changed", (GCallback) ____lambda66__g_file_monitor_changed, block44_data_ref (_data44_), (GClosureNotify) block44_data_unref, 0);
		_tmp6_ = self->priv->file_monitors;
		_tmp7_ = monitor;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp6_, _data44_->filename, _tmp7_);
		_g_object_unref0 (monitor);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("BackgroundCache.vala:59: Failed to monitor %s: %s", _data44_->filename, _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file);
		block44_data_unref (_data44_);
		_data44_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (file);
	block44_data_unref (_data44_);
	_data44_ = NULL;
}

static void
gala_background_cache_get_animation_data_free (gpointer _data)
{
	GalaBackgroundCacheGetAnimationData* _data_;
	_data_ = _data;
	_g_free0 (_data_->filename);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GalaBackgroundCacheGetAnimationData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
gala_background_cache_get_animation (GalaBackgroundCache* self,
                                     const gchar* filename,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	GalaBackgroundCacheGetAnimationData* _data_;
	GalaBackgroundCache* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_data_ = g_slice_new0 (GalaBackgroundCacheGetAnimationData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gala_background_cache_get_animation_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (filename);
	_g_free0 (_data_->filename);
	_data_->filename = _tmp1_;
	gala_background_cache_get_animation_co (_data_);
}

GalaAnimation*
gala_background_cache_get_animation_finish (GalaBackgroundCache* self,
                                            GAsyncResult* _res_)
{
	GalaAnimation* result;
	GalaBackgroundCacheGetAnimationData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block45Data*
block45_data_ref (Block45Data* _data45_)
{
	g_atomic_int_inc (&_data45_->_ref_count_);
	return _data45_;
}

static void
block45_data_unref (void * _userdata_)
{
	Block45Data* _data45_;
	_data45_ = (Block45Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data45_->_ref_count_)) {
		GalaBackgroundCache* self;
		self = _data45_->self;
		_g_object_unref0 (self);
		g_slice_free (Block45Data, _data45_);
	}
}

static gboolean
___lambda67_ (Block45Data* _data45_)
{
	GalaBackgroundCache* self;
	gboolean result;
	self = _data45_->self;
	gala_background_cache_get_animation_co (_data45_->_async_data_);
	result = FALSE;
	return result;
}

static gboolean
____lambda67__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda67_ (self);
	return result;
}

static void
gala_background_cache_get_animation_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	GalaBackgroundCacheGetAnimationData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gala_background_cache_get_animation_co (_data_);
}

static gboolean
__lambda68_ (Block45Data* _data45_)
{
	GalaBackgroundCache* self;
	gboolean result;
	self = _data45_->self;
	gala_background_cache_get_animation_co (_data45_->_async_data_);
	result = FALSE;
	return result;
}

static gboolean
___lambda68__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda68_ (self);
	return result;
}

static gboolean
gala_background_cache_get_animation_co (GalaBackgroundCacheGetAnimationData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data45_ = g_slice_new0 (Block45Data);
	_data_->_data45_->_ref_count_ = 1;
	_data_->_data45_->self = g_object_ref (_data_->self);
	_data_->_data45_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->animation_filename;
	if (g_strcmp0 (_data_->_tmp0_, _data_->filename) == 0) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda67__gsource_func, block45_data_ref (_data_->_data45_), block45_data_unref);
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		_data_->_tmp1_ = _data_->self->priv->animation;
		_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
		_data_->result = _data_->_tmp2_;
		block45_data_unref (_data_->_data45_);
		_data_->_data45_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = gala_animation_new (_data_->filename);
	_data_->animation = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->animation;
	_data_->_state_ = 2;
	gala_animation_load (_data_->_tmp4_, gala_background_cache_get_animation_ready, _data_);
	return FALSE;
	_state_2:
	gala_animation_load_finish (_data_->_tmp4_, _data_->_res_);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda68__gsource_func, block45_data_ref (_data_->_data45_), block45_data_unref);
	_data_->_state_ = 3;
	return FALSE;
	_state_3:
	;
	_data_->result = _data_->animation;
	block45_data_unref (_data_->_data45_);
	_data_->_data45_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

GalaBackgroundSource*
gala_background_cache_get_background_source (GalaBackgroundCache* self,
                                             MetaDisplay* display,
                                             const gchar* settings_schema)
{
	GalaBackgroundSource* background_source = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GalaBackgroundSource* _tmp2_;
	GalaBackgroundSource* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (display != NULL, NULL);
	g_return_val_if_fail (settings_schema != NULL, NULL);
	_tmp0_ = self->priv->background_sources;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, settings_schema);
	background_source = (GalaBackgroundSource*) _tmp1_;
	_tmp2_ = background_source;
	if (_tmp2_ == NULL) {
		GalaBackgroundSource* _tmp3_;
		GalaBackgroundSource* _tmp4_;
		GeeHashMap* _tmp5_;
		GalaBackgroundSource* _tmp6_;
		_tmp3_ = gala_background_source_new (display, settings_schema);
		_g_object_unref0 (background_source);
		background_source = _tmp3_;
		_tmp4_ = background_source;
		gala_background_source_set_use_count (_tmp4_, 1);
		_tmp5_ = self->priv->background_sources;
		_tmp6_ = background_source;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp5_, settings_schema, _tmp6_);
	} else {
		GalaBackgroundSource* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		_tmp7_ = background_source;
		_tmp8_ = gala_background_source_get_use_count (_tmp7_);
		_tmp9_ = _tmp8_;
		gala_background_source_set_use_count (_tmp7_, _tmp9_ + 1);
	}
	result = background_source;
	return result;
}

void
gala_background_cache_release_background_source (GalaBackgroundCache* self,
                                                 const gchar* settings_schema)
{
	GeeHashMap* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings_schema != NULL);
	_tmp0_ = self->priv->background_sources;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, settings_schema)) {
		GalaBackgroundSource* source = NULL;
		GeeHashMap* _tmp1_;
		gpointer _tmp2_;
		GalaBackgroundSource* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp1_ = self->priv->background_sources;
		_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, settings_schema);
		source = (GalaBackgroundSource*) _tmp2_;
		_tmp3_ = source;
		_tmp4_ = gala_background_source_get_use_count (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp5_ = _tmp5_ - 1;
		_tmp6_ = _tmp5_;
		gala_background_source_set_use_count (_tmp3_, _tmp6_);
		if (_tmp6_ == 0) {
			GeeHashMap* _tmp7_;
			GalaBackgroundSource* _tmp8_;
			_tmp7_ = self->priv->background_sources;
			gee_abstract_map_unset ((GeeAbstractMap*) _tmp7_, settings_schema, NULL);
			_tmp8_ = source;
			gala_background_source_destroy (_tmp8_);
		}
		_g_object_unref0 (source);
	}
}

static GObject *
gala_background_cache_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaBackgroundCache * self;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	parent_class = G_OBJECT_CLASS (gala_background_cache_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_BACKGROUND_CACHE, GalaBackgroundCache);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, g_file_monitor_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->file_monitors);
	self->priv->file_monitors = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GALA_TYPE_BACKGROUND_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->background_sources);
	self->priv->background_sources = _tmp1_;
	return obj;
}

static void
gala_background_cache_class_init (GalaBackgroundCacheClass * klass,
                                  gpointer klass_data)
{
	gala_background_cache_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaBackgroundCache_private_offset);
	G_OBJECT_CLASS (klass)->constructor = gala_background_cache_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_background_cache_finalize;
	gala_background_cache_signals[GALA_BACKGROUND_CACHE_FILE_CHANGED_SIGNAL] = g_signal_new ("file-changed", GALA_TYPE_BACKGROUND_CACHE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
gala_background_cache_instance_init (GalaBackgroundCache * self,
                                     gpointer klass)
{
	self->priv = gala_background_cache_get_instance_private (self);
}

static void
gala_background_cache_finalize (GObject * obj)
{
	GalaBackgroundCache * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_BACKGROUND_CACHE, GalaBackgroundCache);
	_g_object_unref0 (self->priv->file_monitors);
	_g_object_unref0 (self->priv->background_sources);
	_g_object_unref0 (self->priv->animation);
	_g_free0 (self->priv->animation_filename);
	G_OBJECT_CLASS (gala_background_cache_parent_class)->finalize (obj);
}

static GType
gala_background_cache_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaBackgroundCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_background_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaBackgroundCache), 0, (GInstanceInitFunc) gala_background_cache_instance_init, NULL };
	GType gala_background_cache_type_id;
	gala_background_cache_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaBackgroundCache", &g_define_type_info, 0);
	GalaBackgroundCache_private_offset = g_type_add_instance_private (gala_background_cache_type_id, sizeof (GalaBackgroundCachePrivate));
	return gala_background_cache_type_id;
}

GType
gala_background_cache_get_type (void)
{
	static volatile gsize gala_background_cache_type_id__once = 0;
	if (g_once_init_enter (&gala_background_cache_type_id__once)) {
		GType gala_background_cache_type_id;
		gala_background_cache_type_id = gala_background_cache_get_type_once ();
		g_once_init_leave (&gala_background_cache_type_id__once, gala_background_cache_type_id);
	}
	return gala_background_cache_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

