/* DBusAccelerator.c generated by valac 0.56.0, the Vala compiler
 * generated from DBusAccelerator.vala, do not modify */

/**/
/*  Copyright (C) 2015 Nicolas Bruguier, Corentin Noël*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <meta/prefs.h>
#include <gio/gio.h>
#include "gala.h"
#include <meta/meta-plugin.h>
#include <meta/display.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_ACCELERATOR (gala_accelerator_get_type ())
typedef struct _GalaAccelerator GalaAccelerator;
#define _g_free0(var) (var = (g_free (var), NULL))

#define GALA_TYPE_DBUS_ACCELERATOR (gala_dbus_accelerator_get_type ())
#define GALA_DBUS_ACCELERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_DBUS_ACCELERATOR, GalaDBusAccelerator))
#define GALA_DBUS_ACCELERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_DBUS_ACCELERATOR, GalaDBusAcceleratorClass))
#define GALA_IS_DBUS_ACCELERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_DBUS_ACCELERATOR))
#define GALA_IS_DBUS_ACCELERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_DBUS_ACCELERATOR))
#define GALA_DBUS_ACCELERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_DBUS_ACCELERATOR, GalaDBusAcceleratorClass))

typedef struct _GalaDBusAccelerator GalaDBusAccelerator;
typedef struct _GalaDBusAcceleratorClass GalaDBusAcceleratorClass;
typedef struct _GalaDBusAcceleratorPrivate GalaDBusAcceleratorPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _gala_dbus_accelerator_unref0(var) ((var == NULL) ? NULL : (var = (gala_dbus_accelerator_unref (var), NULL)))
typedef struct _GalaParamSpecDBusAccelerator GalaParamSpecDBusAccelerator;
enum  {
	GALA_DBUS_ACCELERATOR_ACCELERATOR_ACTIVATED_SIGNAL,
	GALA_DBUS_ACCELERATOR_NUM_SIGNALS
};
static guint gala_dbus_accelerator_signals[GALA_DBUS_ACCELERATOR_NUM_SIGNALS] = {0};

struct _GalaAccelerator {
	gchar* name;
	guint flags;
	MetaKeyBindingFlags grab_flags;
};

struct _GalaDBusAccelerator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GalaDBusAcceleratorPrivate * priv;
};

struct _GalaDBusAcceleratorClass {
	GTypeClass parent_class;
	void (*finalize) (GalaDBusAccelerator *self);
};

struct _GalaDBusAcceleratorPrivate {
	GalaWindowManager* wm;
	GHashTable* grabbed_accelerators;
};

struct _GalaParamSpecDBusAccelerator {
	GParamSpec parent_instance;
};

static gint GalaDBusAccelerator_private_offset;
static gpointer gala_dbus_accelerator_parent_class = NULL;
static GalaDBusAccelerator* gala_dbus_accelerator_instance;
static GalaDBusAccelerator* gala_dbus_accelerator_instance = NULL;

VALA_EXTERN GType gala_accelerator_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GalaAccelerator* gala_accelerator_dup (const GalaAccelerator* self);
VALA_EXTERN void gala_accelerator_free (GalaAccelerator* self);
VALA_EXTERN void gala_accelerator_copy (const GalaAccelerator* self,
                            GalaAccelerator* dest);
VALA_EXTERN void gala_accelerator_destroy (GalaAccelerator* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (GalaAccelerator, gala_accelerator_destroy)
VALA_EXTERN gpointer gala_dbus_accelerator_ref (gpointer instance);
VALA_EXTERN void gala_dbus_accelerator_unref (gpointer instance);
VALA_EXTERN GParamSpec* gala_param_spec_dbus_accelerator (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
VALA_EXTERN void gala_value_set_dbus_accelerator (GValue* value,
                                      gpointer v_object);
VALA_EXTERN void gala_value_take_dbus_accelerator (GValue* value,
                                       gpointer v_object);
VALA_EXTERN gpointer gala_value_get_dbus_accelerator (const GValue* value);
VALA_EXTERN GType gala_dbus_accelerator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaDBusAccelerator, gala_dbus_accelerator_unref)
VALA_EXTERN guint gala_dbus_accelerator_register_object (void* object,
                                             GDBusConnection* connection,
                                             const gchar* path,
                                             GError** error);
VALA_EXTERN GalaDBusAccelerator* gala_dbus_accelerator_init (GalaWindowManager* wm);
static GalaDBusAccelerator* gala_dbus_accelerator_new (GalaWindowManager* _wm);
static GalaDBusAccelerator* gala_dbus_accelerator_construct (GType object_type,
                                                      GalaWindowManager* _wm);
static void _g_free0_ (gpointer var);
static void gala_dbus_accelerator_on_accelerator_activated (GalaDBusAccelerator* self,
                                                     guint action,
                                                     ClutterInputDevice* device,
                                                     guint timestamp);
static void _gala_dbus_accelerator_on_accelerator_activated_meta_display_accelerator_activated (MetaDisplay* _sender,
                                                                                         guint object,
                                                                                         ClutterInputDevice* p0,
                                                                                         guint p1,
                                                                                         gpointer self);
static gboolean _uint_equal (const guint * s1,
                      const guint * s2);
static void _g_variant_unref0_ (gpointer var);
VALA_EXTERN guint gala_dbus_accelerator_grab_accelerator (GalaDBusAccelerator* self,
                                              const gchar* accelerator,
                                              guint flags,
                                              MetaKeyBindingFlags grab_flags,
                                              GError** error);
static guint* _uint_dup (guint* self);
VALA_EXTERN guint* gala_dbus_accelerator_grab_accelerators (GalaDBusAccelerator* self,
                                                GalaAccelerator* accelerators,
                                                gint accelerators_length1,
                                                gint* result_length1,
                                                GError** error);
static void _vala_array_add1 (guint* * array,
                       gint* length,
                       gint* size,
                       guint value);
VALA_EXTERN gboolean gala_dbus_accelerator_ungrab_accelerator (GalaDBusAccelerator* self,
                                                   guint action,
                                                   GError** error);
VALA_EXTERN gboolean gala_dbus_accelerator_ungrab_accelerators (GalaDBusAccelerator* self,
                                                    guint* actions,
                                                    gint actions_length1,
                                                    GError** error);
VALA_EXTERN void gala_dbus_accelerator_show_osd (GalaDBusAccelerator* self,
                                     GHashTable* parameters,
                                     GError** error);
VALA_EXTERN void gala_media_feedback_send (const gchar* icon,
                               gint val);
static void g_cclosure_user_marshal_VOID__UINT_BOXED (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data);
static void gala_dbus_accelerator_finalize (GalaDBusAccelerator * obj);
static GType gala_dbus_accelerator_get_type_once (void);
static void _dbus_gala_dbus_accelerator_grab_accelerator (GalaDBusAccelerator* self,
                                                   GVariant* _parameters_,
                                                   GDBusMethodInvocation* invocation);
static void _vala_GalaAccelerator_array_free (GalaAccelerator * array,
                                       gssize array_length);
static void _dbus_gala_dbus_accelerator_grab_accelerators (GalaDBusAccelerator* self,
                                                    GVariant* _parameters_,
                                                    GDBusMethodInvocation* invocation);
static void _dbus_gala_dbus_accelerator_ungrab_accelerator (GalaDBusAccelerator* self,
                                                     GVariant* _parameters_,
                                                     GDBusMethodInvocation* invocation);
static void _dbus_gala_dbus_accelerator_ungrab_accelerators (GalaDBusAccelerator* self,
                                                      GVariant* _parameters_,
                                                      GDBusMethodInvocation* invocation);
static void _dbus_gala_dbus_accelerator_show_osd (GalaDBusAccelerator* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation);
static void gala_dbus_accelerator_dbus_interface_method_call (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* method_name,
                                                       GVariant* parameters,
                                                       GDBusMethodInvocation* invocation,
                                                       gpointer user_data);
static GVariant* gala_dbus_accelerator_dbus_interface_get_property (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* property_name,
                                                             GError** error,
                                                             gpointer user_data);
static gboolean gala_dbus_accelerator_dbus_interface_set_property (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* property_name,
                                                            GVariant* value,
                                                            GError** error,
                                                            gpointer user_data);
static void _dbus_gala_dbus_accelerator_accelerator_activated (GObject* _sender,
                                                        guint action,
                                                        GHashTable* parameters,
                                                        gpointer* _data);
static void _gala_dbus_accelerator_unregister_object (gpointer user_data);

static const GDBusArgInfo _gala_dbus_accelerator_dbus_arg_info_grab_accelerator_accelerator = {-1, "accelerator", "s", NULL};
static const GDBusArgInfo _gala_dbus_accelerator_dbus_arg_info_grab_accelerator_flags = {-1, "flags", "u", NULL};
static const GDBusArgInfo _gala_dbus_accelerator_dbus_arg_info_grab_accelerator_grab_flags = {-1, "grab_flags", "u", NULL};
static const GDBusArgInfo _gala_dbus_accelerator_dbus_arg_info_grab_accelerator_result = {-1, "result", "u", NULL};
static const GDBusArgInfo * const _gala_dbus_accelerator_dbus_arg_info_grab_accelerator_in[] = {&_gala_dbus_accelerator_dbus_arg_info_grab_accelerator_accelerator, &_gala_dbus_accelerator_dbus_arg_info_grab_accelerator_flags, &_gala_dbus_accelerator_dbus_arg_info_grab_accelerator_grab_flags, NULL};
static const GDBusArgInfo * const _gala_dbus_accelerator_dbus_arg_info_grab_accelerator_out[] = {&_gala_dbus_accelerator_dbus_arg_info_grab_accelerator_result, NULL};
static const GDBusMethodInfo _gala_dbus_accelerator_dbus_method_info_grab_accelerator = {-1, "GrabAccelerator", (GDBusArgInfo **) (&_gala_dbus_accelerator_dbus_arg_info_grab_accelerator_in), (GDBusArgInfo **) (&_gala_dbus_accelerator_dbus_arg_info_grab_accelerator_out), NULL};
static const GDBusArgInfo _gala_dbus_accelerator_dbus_arg_info_grab_accelerators_accelerators = {-1, "accelerators", "a(suu)", NULL};
static const GDBusArgInfo _gala_dbus_accelerator_dbus_arg_info_grab_accelerators_result = {-1, "result", "au", NULL};
static const GDBusArgInfo * const _gala_dbus_accelerator_dbus_arg_info_grab_accelerators_in[] = {&_gala_dbus_accelerator_dbus_arg_info_grab_accelerators_accelerators, NULL};
static const GDBusArgInfo * const _gala_dbus_accelerator_dbus_arg_info_grab_accelerators_out[] = {&_gala_dbus_accelerator_dbus_arg_info_grab_accelerators_result, NULL};
static const GDBusMethodInfo _gala_dbus_accelerator_dbus_method_info_grab_accelerators = {-1, "GrabAccelerators", (GDBusArgInfo **) (&_gala_dbus_accelerator_dbus_arg_info_grab_accelerators_in), (GDBusArgInfo **) (&_gala_dbus_accelerator_dbus_arg_info_grab_accelerators_out), NULL};
static const GDBusArgInfo _gala_dbus_accelerator_dbus_arg_info_ungrab_accelerator_action = {-1, "action", "u", NULL};
static const GDBusArgInfo _gala_dbus_accelerator_dbus_arg_info_ungrab_accelerator_result = {-1, "result", "b", NULL};
static const GDBusArgInfo * const _gala_dbus_accelerator_dbus_arg_info_ungrab_accelerator_in[] = {&_gala_dbus_accelerator_dbus_arg_info_ungrab_accelerator_action, NULL};
static const GDBusArgInfo * const _gala_dbus_accelerator_dbus_arg_info_ungrab_accelerator_out[] = {&_gala_dbus_accelerator_dbus_arg_info_ungrab_accelerator_result, NULL};
static const GDBusMethodInfo _gala_dbus_accelerator_dbus_method_info_ungrab_accelerator = {-1, "UngrabAccelerator", (GDBusArgInfo **) (&_gala_dbus_accelerator_dbus_arg_info_ungrab_accelerator_in), (GDBusArgInfo **) (&_gala_dbus_accelerator_dbus_arg_info_ungrab_accelerator_out), NULL};
static const GDBusArgInfo _gala_dbus_accelerator_dbus_arg_info_ungrab_accelerators_actions = {-1, "actions", "au", NULL};
static const GDBusArgInfo _gala_dbus_accelerator_dbus_arg_info_ungrab_accelerators_result = {-1, "result", "b", NULL};
static const GDBusArgInfo * const _gala_dbus_accelerator_dbus_arg_info_ungrab_accelerators_in[] = {&_gala_dbus_accelerator_dbus_arg_info_ungrab_accelerators_actions, NULL};
static const GDBusArgInfo * const _gala_dbus_accelerator_dbus_arg_info_ungrab_accelerators_out[] = {&_gala_dbus_accelerator_dbus_arg_info_ungrab_accelerators_result, NULL};
static const GDBusMethodInfo _gala_dbus_accelerator_dbus_method_info_ungrab_accelerators = {-1, "UngrabAccelerators", (GDBusArgInfo **) (&_gala_dbus_accelerator_dbus_arg_info_ungrab_accelerators_in), (GDBusArgInfo **) (&_gala_dbus_accelerator_dbus_arg_info_ungrab_accelerators_out), NULL};
static const GDBusArgInfo _gala_dbus_accelerator_dbus_arg_info_show_osd_parameters = {-1, "parameters", "a{sv}", NULL};
static const GDBusArgInfo * const _gala_dbus_accelerator_dbus_arg_info_show_osd_in[] = {&_gala_dbus_accelerator_dbus_arg_info_show_osd_parameters, NULL};
static const GDBusArgInfo * const _gala_dbus_accelerator_dbus_arg_info_show_osd_out[] = {NULL};
static const GDBusMethodInfo _gala_dbus_accelerator_dbus_method_info_show_osd = {-1, "ShowOSD", (GDBusArgInfo **) (&_gala_dbus_accelerator_dbus_arg_info_show_osd_in), (GDBusArgInfo **) (&_gala_dbus_accelerator_dbus_arg_info_show_osd_out), NULL};
static const GDBusMethodInfo * const _gala_dbus_accelerator_dbus_method_info[] = {&_gala_dbus_accelerator_dbus_method_info_grab_accelerator, &_gala_dbus_accelerator_dbus_method_info_grab_accelerators, &_gala_dbus_accelerator_dbus_method_info_ungrab_accelerator, &_gala_dbus_accelerator_dbus_method_info_ungrab_accelerators, &_gala_dbus_accelerator_dbus_method_info_show_osd, NULL};
static const GDBusArgInfo _gala_dbus_accelerator_dbus_arg_info_accelerator_activated_action = {-1, "action", "u", NULL};
static const GDBusArgInfo _gala_dbus_accelerator_dbus_arg_info_accelerator_activated_parameters = {-1, "parameters", "a{sv}", NULL};
static const GDBusArgInfo * const _gala_dbus_accelerator_dbus_arg_info_accelerator_activated[] = {&_gala_dbus_accelerator_dbus_arg_info_accelerator_activated_action, &_gala_dbus_accelerator_dbus_arg_info_accelerator_activated_parameters, NULL};
static const GDBusSignalInfo _gala_dbus_accelerator_dbus_signal_info_accelerator_activated = {-1, "AcceleratorActivated", (GDBusArgInfo **) (&_gala_dbus_accelerator_dbus_arg_info_accelerator_activated), NULL};
static const GDBusSignalInfo * const _gala_dbus_accelerator_dbus_signal_info[] = {&_gala_dbus_accelerator_dbus_signal_info_accelerator_activated, NULL};
static const GDBusPropertyInfo * const _gala_dbus_accelerator_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _gala_dbus_accelerator_dbus_interface_info = {-1, "org.gnome.Shell", (GDBusMethodInfo **) (&_gala_dbus_accelerator_dbus_method_info), (GDBusSignalInfo **) (&_gala_dbus_accelerator_dbus_signal_info), (GDBusPropertyInfo **) (&_gala_dbus_accelerator_dbus_property_info), NULL};
static const GDBusInterfaceVTable _gala_dbus_accelerator_dbus_interface_vtable = {gala_dbus_accelerator_dbus_interface_method_call, gala_dbus_accelerator_dbus_interface_get_property, gala_dbus_accelerator_dbus_interface_set_property};

void
gala_accelerator_copy (const GalaAccelerator* self,
                       GalaAccelerator* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	(*dest).flags = (*self).flags;
	(*dest).grab_flags = (*self).grab_flags;
}

void
gala_accelerator_destroy (GalaAccelerator* self)
{
	_g_free0 ((*self).name);
}

GalaAccelerator*
gala_accelerator_dup (const GalaAccelerator* self)
{
	GalaAccelerator* dup;
	dup = g_new0 (GalaAccelerator, 1);
	gala_accelerator_copy (self, dup);
	return dup;
}

void
gala_accelerator_free (GalaAccelerator* self)
{
	gala_accelerator_destroy (self);
	g_free (self);
}

static GType
gala_accelerator_get_type_once (void)
{
	GType gala_accelerator_type_id;
	gala_accelerator_type_id = g_boxed_type_register_static ("GalaAccelerator", (GBoxedCopyFunc) gala_accelerator_dup, (GBoxedFreeFunc) gala_accelerator_free);
	return gala_accelerator_type_id;
}

GType
gala_accelerator_get_type (void)
{
	static volatile gsize gala_accelerator_type_id__once = 0;
	if (g_once_init_enter (&gala_accelerator_type_id__once)) {
		GType gala_accelerator_type_id;
		gala_accelerator_type_id = gala_accelerator_get_type_once ();
		g_once_init_leave (&gala_accelerator_type_id__once, gala_accelerator_type_id);
	}
	return gala_accelerator_type_id__once;
}

static inline gpointer
gala_dbus_accelerator_get_instance_private (GalaDBusAccelerator* self)
{
	return G_STRUCT_MEMBER_P (self, GalaDBusAccelerator_private_offset);
}

GalaDBusAccelerator*
gala_dbus_accelerator_init (GalaWindowManager* wm)
{
	GalaDBusAccelerator* _tmp0_;
	GalaDBusAccelerator* _tmp2_;
	GalaDBusAccelerator* result;
	g_return_val_if_fail (wm != NULL, NULL);
	_tmp0_ = gala_dbus_accelerator_instance;
	if (_tmp0_ == NULL) {
		GalaDBusAccelerator* _tmp1_;
		_tmp1_ = gala_dbus_accelerator_new (wm);
		_gala_dbus_accelerator_unref0 (gala_dbus_accelerator_instance);
		gala_dbus_accelerator_instance = _tmp1_;
	}
	_tmp2_ = gala_dbus_accelerator_instance;
	result = _tmp2_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_gala_dbus_accelerator_on_accelerator_activated_meta_display_accelerator_activated (MetaDisplay* _sender,
                                                                                    guint object,
                                                                                    ClutterInputDevice* p0,
                                                                                    guint p1,
                                                                                    gpointer self)
{
	gala_dbus_accelerator_on_accelerator_activated ((GalaDBusAccelerator*) self, object, p0, p1);
}

static GalaDBusAccelerator*
gala_dbus_accelerator_construct (GType object_type,
                                 GalaWindowManager* _wm)
{
	GalaDBusAccelerator* self = NULL;
	GalaWindowManager* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	GalaWindowManager* _tmp4_;
	MetaDisplay* _tmp5_;
	g_return_val_if_fail (_wm != NULL, NULL);
	self = (GalaDBusAccelerator*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (_wm);
	_g_object_unref0 (self->priv->wm);
	self->priv->wm = _tmp0_;
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->grabbed_accelerators);
	self->priv->grabbed_accelerators = _tmp3_;
	_tmp4_ = self->priv->wm;
	_tmp5_ = meta_plugin_get_display ((MetaPlugin*) _tmp4_);
	g_signal_connect (_tmp5_, "accelerator-activated", (GCallback) _gala_dbus_accelerator_on_accelerator_activated_meta_display_accelerator_activated, self);
	return self;
}

static GalaDBusAccelerator*
gala_dbus_accelerator_new (GalaWindowManager* _wm)
{
	return gala_dbus_accelerator_construct (GALA_TYPE_DBUS_ACCELERATOR, _wm);
}

static gboolean
_uint_equal (const guint * s1,
             const guint * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

static void
_g_variant_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}

static void
gala_dbus_accelerator_on_accelerator_activated (GalaDBusAccelerator* self,
                                                guint action,
                                                ClutterInputDevice* device,
                                                guint timestamp)
{
	GHashTable* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = self->priv->grabbed_accelerators;
	_tmp1_ = g_hash_table_get_keys (_tmp0_);
	{
		GList* accelerator_collection = NULL;
		GList* accelerator_it = NULL;
		accelerator_collection = _tmp1_;
		for (accelerator_it = accelerator_collection; accelerator_it != NULL; accelerator_it = accelerator_it->next) {
			gchar* _tmp2_;
			gchar* accelerator = NULL;
			_tmp2_ = g_strdup ((const gchar*) accelerator_it->data);
			accelerator = _tmp2_;
			{
				GHashTable* _tmp3_;
				const gchar* _tmp4_;
				gconstpointer _tmp5_;
				_tmp3_ = self->priv->grabbed_accelerators;
				_tmp4_ = accelerator;
				_tmp5_ = g_hash_table_lookup (_tmp3_, _tmp4_);
				if (_uint_equal ((guint*) _tmp5_, &action) == TRUE) {
					GHashTable* parameters = NULL;
					GHashTable* _tmp6_;
					GHashTable* _tmp7_;
					gchar* _tmp8_;
					GVariant* _tmp9_;
					const gchar* _tmp10_;
					const gchar* _tmp11_;
					GHashTable* _tmp17_;
					_tmp6_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_variant_unref0_);
					parameters = _tmp6_;
					_tmp7_ = parameters;
					_tmp8_ = g_strdup ("timestamp");
					_tmp9_ = g_variant_new_uint32 ((guint32) timestamp);
					g_variant_ref_sink (_tmp9_);
					g_hash_table_insert (_tmp7_, _tmp8_, _tmp9_);
					_tmp10_ = clutter_input_device_get_device_node (device);
					_tmp11_ = _tmp10_;
					if (_tmp11_ != NULL) {
						GHashTable* _tmp12_;
						gchar* _tmp13_;
						const gchar* _tmp14_;
						const gchar* _tmp15_;
						GVariant* _tmp16_;
						_tmp12_ = parameters;
						_tmp13_ = g_strdup ("device-node");
						_tmp14_ = clutter_input_device_get_device_node (device);
						_tmp15_ = _tmp14_;
						_tmp16_ = g_variant_new_string (_tmp15_);
						g_variant_ref_sink (_tmp16_);
						g_hash_table_insert (_tmp12_, _tmp13_, _tmp16_);
					}
					_tmp17_ = parameters;
					g_signal_emit (self, gala_dbus_accelerator_signals[GALA_DBUS_ACCELERATOR_ACCELERATOR_ACTIVATED_SIGNAL], 0, action, _tmp17_);
					_g_hash_table_unref0 (parameters);
				}
				_g_free0 (accelerator);
			}
		}
		(accelerator_collection == NULL) ? NULL : (accelerator_collection = (g_list_free (accelerator_collection), NULL));
	}
}

static guint*
_uint_dup (guint* self)
{
	guint* dup;
	dup = g_new0 (guint, 1);
	memcpy (dup, self, sizeof (guint));
	return dup;
}

static gpointer
__uint_dup0 (gpointer self)
{
	return self ? _uint_dup (self) : NULL;
}

guint
gala_dbus_accelerator_grab_accelerator (GalaDBusAccelerator* self,
                                        const gchar* accelerator,
                                        guint flags,
                                        MetaKeyBindingFlags grab_flags,
                                        GError** error)
{
	guint* action = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	guint* _tmp2_;
	guint* _tmp3_;
	guint* _tmp13_;
	guint _tmp14_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (accelerator != NULL, 0U);
	_tmp0_ = self->priv->grabbed_accelerators;
	_tmp1_ = g_hash_table_lookup (_tmp0_, accelerator);
	_tmp2_ = __uint_dup0 ((guint*) _tmp1_);
	action = _tmp2_;
	_tmp3_ = action;
	if (_tmp3_ == NULL) {
		GalaWindowManager* _tmp4_;
		MetaDisplay* _tmp5_;
		guint _tmp6_;
		guint* _tmp7_;
		guint* _tmp8_;
		_tmp4_ = self->priv->wm;
		_tmp5_ = meta_plugin_get_display ((MetaPlugin*) _tmp4_);
		_tmp6_ = meta_display_grab_accelerator (_tmp5_, accelerator, grab_flags);
		_tmp7_ = __uint_dup0 (&_tmp6_);
		_g_free0 (action);
		action = _tmp7_;
		_tmp8_ = action;
		if ((*_tmp8_) > ((guint) 0)) {
			GHashTable* _tmp9_;
			gchar* _tmp10_;
			guint* _tmp11_;
			guint* _tmp12_;
			_tmp9_ = self->priv->grabbed_accelerators;
			_tmp10_ = g_strdup (accelerator);
			_tmp11_ = action;
			_tmp12_ = __uint_dup0 (_tmp11_);
			g_hash_table_insert (_tmp9_, _tmp10_, _tmp12_);
		}
	}
	_tmp13_ = action;
	_tmp14_ = *_tmp13_;
	_g_free0 (_tmp13_);
	result = _tmp14_;
	return result;
}

static void
_vala_array_add1 (guint* * array,
                  gint* length,
                  gint* size,
                  guint value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint, *array, *size);
	}
	(*array)[(*length)++] = value;
}

guint*
gala_dbus_accelerator_grab_accelerators (GalaDBusAccelerator* self,
                                         GalaAccelerator* accelerators,
                                         gint accelerators_length1,
                                         gint* result_length1,
                                         GError** error)
{
	guint* actions = NULL;
	guint* _tmp0_;
	gint actions_length1;
	gint _actions_size_;
	guint* _tmp6_;
	gint _tmp6__length1;
	GError* _inner_error0_ = NULL;
	guint* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (guint, 0);
	actions = _tmp0_;
	actions_length1 = 0;
	_actions_size_ = actions_length1;
	{
		GalaAccelerator* accelerator_collection = NULL;
		gint accelerator_collection_length1 = 0;
		gint _accelerator_collection_size_ = 0;
		gint accelerator_it = 0;
		accelerator_collection = accelerators;
		accelerator_collection_length1 = accelerators_length1;
		for (accelerator_it = 0; accelerator_it < accelerator_collection_length1; accelerator_it = accelerator_it + 1) {
			GalaAccelerator* accelerator = NULL;
			accelerator = &accelerator_collection[accelerator_it];
			{
				guint _tmp1_ = 0U;
				GalaAccelerator* _tmp2_;
				const gchar* _tmp3_;
				GalaAccelerator* _tmp4_;
				GalaAccelerator* _tmp5_;
				_tmp2_ = accelerator;
				_tmp3_ = (*_tmp2_).name;
				_tmp4_ = accelerator;
				_tmp5_ = accelerator;
				_tmp1_ = gala_dbus_accelerator_grab_accelerator (self, _tmp3_, (*_tmp4_).flags, (*_tmp5_).grab_flags, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if ((_inner_error0_->domain == G_DBUS_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
						g_propagate_error (error, _inner_error0_);
						actions = (g_free (actions), NULL);
						return NULL;
					} else {
						actions = (g_free (actions), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_vala_array_add1 (&actions, &actions_length1, &_actions_size_, _tmp1_);
			}
		}
	}
	_tmp6_ = actions;
	_tmp6__length1 = actions_length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

gboolean
gala_dbus_accelerator_ungrab_accelerator (GalaDBusAccelerator* self,
                                          guint action,
                                          GError** error)
{
	gboolean ret = FALSE;
	GHashTable* _tmp0_;
	GList* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	ret = FALSE;
	_tmp0_ = self->priv->grabbed_accelerators;
	_tmp1_ = g_hash_table_get_keys (_tmp0_);
	{
		GList* accelerator_collection = NULL;
		GList* accelerator_it = NULL;
		accelerator_collection = _tmp1_;
		for (accelerator_it = accelerator_collection; accelerator_it != NULL; accelerator_it = accelerator_it->next) {
			const gchar* accelerator = NULL;
			accelerator = (const gchar*) accelerator_it->data;
			{
				GHashTable* _tmp2_;
				const gchar* _tmp3_;
				gconstpointer _tmp4_;
				_tmp2_ = self->priv->grabbed_accelerators;
				_tmp3_ = accelerator;
				_tmp4_ = g_hash_table_lookup (_tmp2_, _tmp3_);
				if (_uint_equal ((guint*) _tmp4_, &action) == TRUE) {
					GalaWindowManager* _tmp5_;
					MetaDisplay* _tmp6_;
					GHashTable* _tmp7_;
					const gchar* _tmp8_;
					_tmp5_ = self->priv->wm;
					_tmp6_ = meta_plugin_get_display ((MetaPlugin*) _tmp5_);
					ret = meta_display_ungrab_accelerator (_tmp6_, action);
					_tmp7_ = self->priv->grabbed_accelerators;
					_tmp8_ = accelerator;
					g_hash_table_remove (_tmp7_, _tmp8_);
					break;
				}
			}
		}
		(accelerator_collection == NULL) ? NULL : (accelerator_collection = (g_list_free (accelerator_collection), NULL));
	}
	result = ret;
	return result;
}

gboolean
gala_dbus_accelerator_ungrab_accelerators (GalaDBusAccelerator* self,
                                           guint* actions,
                                           gint actions_length1,
                                           GError** error)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		guint* action_collection = NULL;
		gint action_collection_length1 = 0;
		gint _action_collection_size_ = 0;
		gint action_it = 0;
		action_collection = actions;
		action_collection_length1 = actions_length1;
		for (action_it = 0; action_it < action_collection_length1; action_it = action_it + 1) {
			guint action = 0U;
			action = action_collection[action_it];
			{
				gala_dbus_accelerator_ungrab_accelerator (self, action, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if ((_inner_error0_->domain == G_DBUS_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
						gboolean _tmp0_ = FALSE;
						g_propagate_error (error, _inner_error0_);
						return _tmp0_;
					} else {
						gboolean _tmp1_ = FALSE;
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return _tmp1_;
					}
				}
			}
		}
	}
	result = TRUE;
	return result;
}

void
gala_dbus_accelerator_show_osd (GalaDBusAccelerator* self,
                                GHashTable* parameters,
                                GError** error)
{
	gint32 monitor_index = 0;
	gchar* icon = NULL;
	gchar* _tmp1_;
	gchar* label = NULL;
	gchar* _tmp5_;
	gint32 level = 0;
	const gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parameters != NULL);
	monitor_index = (gint32) -1;
	if (g_hash_table_contains (parameters, "monitor")) {
		gconstpointer _tmp0_;
		_tmp0_ = g_hash_table_lookup (parameters, "monitor");
		monitor_index = g_variant_get_int32 ((GVariant*) _tmp0_);
	}
	_tmp1_ = g_strdup ("");
	icon = _tmp1_;
	if (g_hash_table_contains (parameters, "icon")) {
		gconstpointer _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = g_hash_table_lookup (parameters, "icon");
		_tmp3_ = g_variant_get_string ((GVariant*) _tmp2_, NULL);
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (icon);
		icon = _tmp4_;
	}
	_tmp5_ = g_strdup ("");
	label = _tmp5_;
	if (g_hash_table_contains (parameters, "label")) {
		gconstpointer _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = g_hash_table_lookup (parameters, "label");
		_tmp7_ = g_variant_get_string ((GVariant*) _tmp6_, NULL);
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (label);
		label = _tmp8_;
	}
	level = (gint32) 0;
	if (g_hash_table_contains (parameters, "level")) {
		gdouble double_level = 0.0;
		gconstpointer _tmp9_;
		_tmp9_ = g_hash_table_lookup (parameters, "level");
		double_level = g_variant_get_double ((GVariant*) _tmp9_);
		level = (gint32) ((gint) (double_level * 100));
	}
	_tmp10_ = icon;
	gala_media_feedback_send (_tmp10_, (gint) level);
	_g_free0 (label);
	_g_free0 (icon);
}

static void
g_cclosure_user_marshal_VOID__UINT_BOXED (GClosure * closure,
                                          GValue * return_value,
                                          guint n_param_values,
                                          const GValue * param_values,
                                          gpointer invocation_hint,
                                          gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__UINT_BOXED) (gpointer data1, guint arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_boxed (param_values + 2), data2);
}

static void
gala_value_dbus_accelerator_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gala_value_dbus_accelerator_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gala_dbus_accelerator_unref (value->data[0].v_pointer);
	}
}

static void
gala_value_dbus_accelerator_copy_value (const GValue* src_value,
                                        GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gala_dbus_accelerator_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gala_value_dbus_accelerator_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gala_value_dbus_accelerator_collect_value (GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GalaDBusAccelerator * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gala_dbus_accelerator_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gala_value_dbus_accelerator_lcopy_value (const GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	GalaDBusAccelerator ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gala_dbus_accelerator_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
gala_param_spec_dbus_accelerator (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags)
{
	GalaParamSpecDBusAccelerator* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GALA_TYPE_DBUS_ACCELERATOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
gala_value_get_dbus_accelerator (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GALA_TYPE_DBUS_ACCELERATOR), NULL);
	return value->data[0].v_pointer;
}

void
gala_value_set_dbus_accelerator (GValue* value,
                                 gpointer v_object)
{
	GalaDBusAccelerator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GALA_TYPE_DBUS_ACCELERATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GALA_TYPE_DBUS_ACCELERATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gala_dbus_accelerator_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gala_dbus_accelerator_unref (old);
	}
}

void
gala_value_take_dbus_accelerator (GValue* value,
                                  gpointer v_object)
{
	GalaDBusAccelerator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GALA_TYPE_DBUS_ACCELERATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GALA_TYPE_DBUS_ACCELERATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gala_dbus_accelerator_unref (old);
	}
}

static void
gala_dbus_accelerator_class_init (GalaDBusAcceleratorClass * klass,
                                  gpointer klass_data)
{
	gala_dbus_accelerator_parent_class = g_type_class_peek_parent (klass);
	((GalaDBusAcceleratorClass *) klass)->finalize = gala_dbus_accelerator_finalize;
	g_type_class_adjust_private_offset (klass, &GalaDBusAccelerator_private_offset);
	gala_dbus_accelerator_signals[GALA_DBUS_ACCELERATOR_ACCELERATOR_ACTIVATED_SIGNAL] = g_signal_new ("accelerator-activated", GALA_TYPE_DBUS_ACCELERATOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_BOXED, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_HASH_TABLE);
}

static void
gala_dbus_accelerator_instance_init (GalaDBusAccelerator * self,
                                     gpointer klass)
{
	self->priv = gala_dbus_accelerator_get_instance_private (self);
	self->ref_count = 1;
}

static void
gala_dbus_accelerator_finalize (GalaDBusAccelerator * obj)
{
	GalaDBusAccelerator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_DBUS_ACCELERATOR, GalaDBusAccelerator);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->wm);
	_g_hash_table_unref0 (self->priv->grabbed_accelerators);
}

static GType
gala_dbus_accelerator_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { gala_value_dbus_accelerator_init, gala_value_dbus_accelerator_free_value, gala_value_dbus_accelerator_copy_value, gala_value_dbus_accelerator_peek_pointer, "p", gala_value_dbus_accelerator_collect_value, "p", gala_value_dbus_accelerator_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GalaDBusAcceleratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_dbus_accelerator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaDBusAccelerator), 0, (GInstanceInitFunc) gala_dbus_accelerator_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType gala_dbus_accelerator_type_id;
	gala_dbus_accelerator_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GalaDBusAccelerator", &g_define_type_info, &g_define_type_fundamental_info, 0);
	g_type_set_qdata (gala_dbus_accelerator_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) gala_dbus_accelerator_register_object);
	GalaDBusAccelerator_private_offset = g_type_add_instance_private (gala_dbus_accelerator_type_id, sizeof (GalaDBusAcceleratorPrivate));
	return gala_dbus_accelerator_type_id;
}

GType
gala_dbus_accelerator_get_type (void)
{
	static volatile gsize gala_dbus_accelerator_type_id__once = 0;
	if (g_once_init_enter (&gala_dbus_accelerator_type_id__once)) {
		GType gala_dbus_accelerator_type_id;
		gala_dbus_accelerator_type_id = gala_dbus_accelerator_get_type_once ();
		g_once_init_leave (&gala_dbus_accelerator_type_id__once, gala_dbus_accelerator_type_id);
	}
	return gala_dbus_accelerator_type_id__once;
}

gpointer
gala_dbus_accelerator_ref (gpointer instance)
{
	GalaDBusAccelerator * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
gala_dbus_accelerator_unref (gpointer instance)
{
	GalaDBusAccelerator * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GALA_DBUS_ACCELERATOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_dbus_gala_dbus_accelerator_grab_accelerator (GalaDBusAccelerator* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* accelerator = NULL;
	GVariant* _tmp7_;
	guint flags = 0U;
	GVariant* _tmp8_;
	MetaKeyBindingFlags grab_flags = 0U;
	GVariant* _tmp9_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	accelerator = g_variant_dup_string (_tmp7_, NULL);
	g_variant_unref (_tmp7_);
	_tmp8_ = g_variant_iter_next_value (&_arguments_iter);
	flags = g_variant_get_uint32 (_tmp8_);
	g_variant_unref (_tmp8_);
	_tmp9_ = g_variant_iter_next_value (&_arguments_iter);
	grab_flags = g_variant_get_uint32 (_tmp9_);
	g_variant_unref (_tmp9_);
	result = gala_dbus_accelerator_grab_accelerator (self, accelerator, flags, grab_flags, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (accelerator);
	;
}

static void
_vala_GalaAccelerator_array_free (GalaAccelerator * array,
                                  gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			gala_accelerator_destroy (&array[i]);
		}
	}
	g_free (array);
}

static void
_dbus_gala_dbus_accelerator_grab_accelerators (GalaDBusAccelerator* self,
                                               GVariant* _parameters_,
                                               GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GalaAccelerator* accelerators = NULL;
	gint accelerators_length1 = 0;
	GVariant* _tmp10_;
	GalaAccelerator* _tmp11_;
	gint _tmp11__length;
	gint _tmp11__size;
	gint _tmp11__length1;
	GVariantIter _tmp12_;
	GVariant* _tmp13_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint* result;
	gint result_length1 = 0;
	guint* _tmp19_;
	GVariantBuilder _tmp20_;
	gint _tmp21_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp10_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp11_ = g_new (GalaAccelerator, 5);
	_tmp11__length = 0;
	_tmp11__size = 4;
	_tmp11__length1 = 0;
	g_variant_iter_init (&_tmp12_, _tmp10_);
	for (; (_tmp13_ = g_variant_iter_next_value (&_tmp12_)) != NULL; _tmp11__length1++) {
		GalaAccelerator _tmp14_;
		GVariantIter _tmp15_;
		GVariant* _tmp16_;
		GVariant* _tmp17_;
		GVariant* _tmp18_;
		if (_tmp11__size == _tmp11__length) {
			_tmp11__size = 2 * _tmp11__size;
			_tmp11_ = g_renew (GalaAccelerator, _tmp11_, _tmp11__size + 1);
		}
		g_variant_iter_init (&_tmp15_, _tmp13_);
		_tmp16_ = g_variant_iter_next_value (&_tmp15_);
		_tmp14_.name = g_variant_dup_string (_tmp16_, NULL);
		g_variant_unref (_tmp16_);
		_tmp17_ = g_variant_iter_next_value (&_tmp15_);
		_tmp14_.flags = g_variant_get_uint32 (_tmp17_);
		g_variant_unref (_tmp17_);
		_tmp18_ = g_variant_iter_next_value (&_tmp15_);
		_tmp14_.grab_flags = g_variant_get_uint32 (_tmp18_);
		g_variant_unref (_tmp18_);
		_tmp11_[_tmp11__length++] = _tmp14_;
		g_variant_unref (_tmp13_);
	}
	accelerators_length1 = _tmp11__length1;
	accelerators = _tmp11_;
	g_variant_unref (_tmp10_);
	result = gala_dbus_accelerator_grab_accelerators (self, accelerators, accelerators_length1, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp19_ = result;
	g_variant_builder_init (&_tmp20_, G_VARIANT_TYPE ("au"));
	for (_tmp21_ = 0; _tmp21_ < result_length1; _tmp21_++) {
		g_variant_builder_add_value (&_tmp20_, g_variant_new_uint32 (*_tmp19_));
		_tmp19_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp20_));
	result = (g_free (result), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	accelerators = (_vala_GalaAccelerator_array_free (accelerators, accelerators_length1), NULL);
	;
}

static void
_dbus_gala_dbus_accelerator_ungrab_accelerator (GalaDBusAccelerator* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint action = 0U;
	GVariant* _tmp22_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp22_ = g_variant_iter_next_value (&_arguments_iter);
	action = g_variant_get_uint32 (_tmp22_);
	g_variant_unref (_tmp22_);
	result = gala_dbus_accelerator_ungrab_accelerator (self, action, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_gala_dbus_accelerator_ungrab_accelerators (GalaDBusAccelerator* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint* actions = NULL;
	gint actions_length1 = 0;
	GVariant* _tmp23_;
	guint* _tmp24_;
	gint _tmp24__length;
	gint _tmp24__size;
	gint _tmp24__length1;
	GVariantIter _tmp25_;
	GVariant* _tmp26_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp23_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp24_ = g_new (guint, 5);
	_tmp24__length = 0;
	_tmp24__size = 4;
	_tmp24__length1 = 0;
	g_variant_iter_init (&_tmp25_, _tmp23_);
	for (; (_tmp26_ = g_variant_iter_next_value (&_tmp25_)) != NULL; _tmp24__length1++) {
		if (_tmp24__size == _tmp24__length) {
			_tmp24__size = 2 * _tmp24__size;
			_tmp24_ = g_renew (guint, _tmp24_, _tmp24__size + 1);
		}
		_tmp24_[_tmp24__length++] = g_variant_get_uint32 (_tmp26_);
		g_variant_unref (_tmp26_);
	}
	actions_length1 = _tmp24__length1;
	actions = _tmp24_;
	g_variant_unref (_tmp23_);
	result = gala_dbus_accelerator_ungrab_accelerators (self, actions, actions_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	actions = (g_free (actions), NULL);
	;
}

static void
_dbus_gala_dbus_accelerator_show_osd (GalaDBusAccelerator* self,
                                      GVariant* _parameters_,
                                      GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GHashTable* parameters = NULL;
	GVariant* _tmp27_;
	GHashTable* _tmp28_;
	GVariantIter _tmp29_;
	GVariant* _tmp30_;
	GVariant* _tmp31_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp27_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp28_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp29_, _tmp27_);
	while (g_variant_iter_loop (&_tmp29_, "{?*}", &_tmp30_, &_tmp31_)) {
		g_hash_table_insert (_tmp28_, g_variant_dup_string (_tmp30_, NULL), g_variant_get_variant (_tmp31_));
	}
	parameters = _tmp28_;
	g_variant_unref (_tmp27_);
	gala_dbus_accelerator_show_osd (self, parameters, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_hash_table_unref0 (parameters);
	;
}

static void
gala_dbus_accelerator_dbus_interface_method_call (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* method_name,
                                                  GVariant* parameters,
                                                  GDBusMethodInvocation* invocation,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GrabAccelerator") == 0) {
		_dbus_gala_dbus_accelerator_grab_accelerator (object, parameters, invocation);
	} else if (strcmp (method_name, "GrabAccelerators") == 0) {
		_dbus_gala_dbus_accelerator_grab_accelerators (object, parameters, invocation);
	} else if (strcmp (method_name, "UngrabAccelerator") == 0) {
		_dbus_gala_dbus_accelerator_ungrab_accelerator (object, parameters, invocation);
	} else if (strcmp (method_name, "UngrabAccelerators") == 0) {
		_dbus_gala_dbus_accelerator_ungrab_accelerators (object, parameters, invocation);
	} else if (strcmp (method_name, "ShowOSD") == 0) {
		_dbus_gala_dbus_accelerator_show_osd (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
gala_dbus_accelerator_dbus_interface_get_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GError** error,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
gala_dbus_accelerator_dbus_interface_set_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GVariant* value,
                                                   GError** error,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_gala_dbus_accelerator_accelerator_activated (GObject* _sender,
                                                   guint action,
                                                   GHashTable* parameters,
                                                   gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp32_;
	GHashTableIter _tmp33_;
	gpointer _tmp34_;
	gpointer _tmp35_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (action));
	g_hash_table_iter_init (&_tmp33_, parameters);
	g_variant_builder_init (&_tmp32_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp33_, &_tmp34_, &_tmp35_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp34_;
		_value = (GVariant*) _tmp35_;
		g_variant_builder_add (&_tmp32_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp32_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.Shell", "AcceleratorActivated", _arguments, NULL);
}

guint
gala_dbus_accelerator_register_object (gpointer object,
                                       GDBusConnection* connection,
                                       const gchar* path,
                                       GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = gala_dbus_accelerator_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_gala_dbus_accelerator_dbus_interface_info), &_gala_dbus_accelerator_dbus_interface_vtable, data, _gala_dbus_accelerator_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "accelerator-activated", (GCallback) _dbus_gala_dbus_accelerator_accelerator_activated, data);
	return result;
}

static void
_gala_dbus_accelerator_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_gala_dbus_accelerator_accelerator_activated, data);
	gala_dbus_accelerator_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

