/* HotCornerManager.c generated by valac 0.56.0, the Vala compiler
 * generated from HotCornerManager.vala, do not modify */

/*
 * Copyright 2021 elementary, Inc (https://elementary.io)
 *           2021 José Expósito <jose.exposito89@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include "gala.h"
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <meta/meta-monitor-manager.h>
#include <meta/display.h>
#include <meta/meta-plugin.h>
#include <meta/boxes.h>
#include <float.h>
#include <math.h>

#define GALA_HOT_CORNER_POSITION_TOP_LEFT "hotcorner-topleft"
#define GALA_HOT_CORNER_POSITION_TOP_RIGHT "hotcorner-topright"
#define GALA_HOT_CORNER_POSITION_BOTTOM_LEFT "hotcorner-bottomleft"
#define GALA_HOT_CORNER_POSITION_BOTTOM_RIGHT "hotcorner-bottomright"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_HOT_CORNER_MANAGER (gala_hot_corner_manager_get_type ())
#define GALA_HOT_CORNER_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_HOT_CORNER_MANAGER, GalaHotCornerManager))
#define GALA_HOT_CORNER_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_HOT_CORNER_MANAGER, GalaHotCornerManagerClass))
#define GALA_IS_HOT_CORNER_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_HOT_CORNER_MANAGER))
#define GALA_IS_HOT_CORNER_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_HOT_CORNER_MANAGER))
#define GALA_HOT_CORNER_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_HOT_CORNER_MANAGER, GalaHotCornerManagerClass))

typedef struct _GalaHotCornerManager GalaHotCornerManager;
typedef struct _GalaHotCornerManagerClass GalaHotCornerManagerClass;
typedef struct _GalaHotCornerManagerPrivate GalaHotCornerManagerPrivate;

#define GALA_TYPE_HOT_CORNER (gala_hot_corner_get_type ())
#define GALA_HOT_CORNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_HOT_CORNER, GalaHotCorner))
#define GALA_HOT_CORNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_HOT_CORNER, GalaHotCornerClass))
#define GALA_IS_HOT_CORNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_HOT_CORNER))
#define GALA_IS_HOT_CORNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_HOT_CORNER))
#define GALA_HOT_CORNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_HOT_CORNER, GalaHotCornerClass))

typedef struct _GalaHotCorner GalaHotCorner;
typedef struct _GalaHotCornerClass GalaHotCornerClass;
enum  {
	GALA_HOT_CORNER_MANAGER_0_PROPERTY,
	GALA_HOT_CORNER_MANAGER_WM_PROPERTY,
	GALA_HOT_CORNER_MANAGER_BEHAVIOR_SETTINGS_PROPERTY,
	GALA_HOT_CORNER_MANAGER_NUM_PROPERTIES
};
static GParamSpec* gala_hot_corner_manager_properties[GALA_HOT_CORNER_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block53Data Block53Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	GALA_HOT_CORNER_MANAGER_ON_CONFIGURED_SIGNAL,
	GALA_HOT_CORNER_MANAGER_NUM_SIGNALS
};
static guint gala_hot_corner_manager_signals[GALA_HOT_CORNER_MANAGER_NUM_SIGNALS] = {0};

struct _GalaHotCornerManager {
	GObject parent_instance;
	GalaHotCornerManagerPrivate * priv;
};

struct _GalaHotCornerManagerClass {
	GObjectClass parent_class;
};

struct _GalaHotCornerManagerPrivate {
	GalaWindowManager* _wm;
	GSettings* _behavior_settings;
	GPtrArray* hot_corners;
};

struct _Block53Data {
	int _ref_count_;
	GalaHotCornerManager* self;
	GalaActionType action_type;
	gchar* hot_corner_position;
};

static gint GalaHotCornerManager_private_offset;
static gpointer gala_hot_corner_manager_parent_class = NULL;

VALA_EXTERN GType gala_hot_corner_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaHotCornerManager, g_object_unref)
VALA_EXTERN GType gala_hot_corner_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaHotCorner, g_object_unref)
VALA_EXTERN GalaHotCornerManager* gala_hot_corner_manager_new (GalaWindowManager* wm,
                                                   GSettings* behavior_settings);
VALA_EXTERN GalaHotCornerManager* gala_hot_corner_manager_construct (GType object_type,
                                                         GalaWindowManager* wm,
                                                         GSettings* behavior_settings);
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN void gala_hot_corner_manager_configure (GalaHotCornerManager* self);
static void _gala_hot_corner_manager_configure_g_settings_changed (GSettings* _sender,
                                                            const gchar* key,
                                                            gpointer self);
static void _gala_hot_corner_manager_configure_meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                               gpointer self);
VALA_EXTERN GalaWindowManager* gala_hot_corner_manager_get_wm (GalaHotCornerManager* self);
static void gala_hot_corner_manager_remove_all_hot_corners (GalaHotCornerManager* self);
static void gala_hot_corner_manager_add_hotcorner (GalaHotCornerManager* self,
                                            gfloat x,
                                            gfloat y,
                                            const gchar* hot_corner_position);
static void __lambda48_ (GalaHotCornerManager* self,
                  GalaHotCorner* hot_corner);
VALA_EXTERN void gala_hot_corner_destroy_barriers (GalaHotCorner* self);
static void ___lambda48__gfunc (gconstpointer data,
                         gpointer self);
static Block53Data* block53_data_ref (Block53Data* _data53_);
static void block53_data_unref (void * _userdata_);
VALA_EXTERN GSettings* gala_hot_corner_manager_get_behavior_settings (GalaHotCornerManager* self);
VALA_EXTERN GalaHotCorner* gala_hot_corner_new (MetaDisplay* display,
                                    gfloat x,
                                    gfloat y,
                                    const gchar* hot_corner_position);
VALA_EXTERN GalaHotCorner* gala_hot_corner_construct (GType object_type,
                                          MetaDisplay* display,
                                          gfloat x,
                                          gfloat y,
                                          const gchar* hot_corner_position);
static void __lambda49_ (Block53Data* _data53_);
static void gala_hot_corner_manager_run_custom_action (GalaHotCornerManager* self,
                                                const gchar* hot_corner_position);
static void ___lambda49__gala_hot_corner_trigger (GalaHotCorner* _sender,
                                           gpointer self);
static void gala_hot_corner_manager_set_wm (GalaHotCornerManager* self,
                                     GalaWindowManager* value);
static void gala_hot_corner_manager_set_behavior_settings (GalaHotCornerManager* self,
                                                    GSettings* value);
static void gala_hot_corner_manager_finalize (GObject * obj);
static GType gala_hot_corner_manager_get_type_once (void);
static void _vala_gala_hot_corner_manager_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_gala_hot_corner_manager_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gala_hot_corner_manager_get_instance_private (GalaHotCornerManager* self)
{
	return G_STRUCT_MEMBER_P (self, GalaHotCornerManager_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_gala_hot_corner_manager_configure_g_settings_changed (GSettings* _sender,
                                                       const gchar* key,
                                                       gpointer self)
{
	gala_hot_corner_manager_configure ((GalaHotCornerManager*) self);
}

static void
_gala_hot_corner_manager_configure_meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                          gpointer self)
{
	gala_hot_corner_manager_configure ((GalaHotCornerManager*) self);
}

GalaHotCornerManager*
gala_hot_corner_manager_construct (GType object_type,
                                   GalaWindowManager* wm,
                                   GSettings* behavior_settings)
{
	GalaHotCornerManager * self = NULL;
	GPtrArray* _tmp0_;
	MetaMonitorManager* _tmp1_;
	g_return_val_if_fail (wm != NULL, NULL);
	g_return_val_if_fail (behavior_settings != NULL, NULL);
	self = (GalaHotCornerManager*) g_object_new (object_type, "wm", wm, "behavior-settings", behavior_settings, NULL);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_g_ptr_array_unref0 (self->priv->hot_corners);
	self->priv->hot_corners = _tmp0_;
	g_signal_connect_object (behavior_settings, "changed", (GCallback) _gala_hot_corner_manager_configure_g_settings_changed, self, 0);
	_tmp1_ = meta_monitor_manager_get ();
	g_signal_connect_object (_tmp1_, "monitors-changed", (GCallback) _gala_hot_corner_manager_configure_meta_monitor_manager_monitors_changed, self, 0);
	return self;
}

GalaHotCornerManager*
gala_hot_corner_manager_new (GalaWindowManager* wm,
                             GSettings* behavior_settings)
{
	return gala_hot_corner_manager_construct (GALA_TYPE_HOT_CORNER_MANAGER, wm, behavior_settings);
}

void
gala_hot_corner_manager_configure (GalaHotCornerManager* self)
{
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaRectangle geometry = {0};
	MetaRectangle _tmp2_ = {0};
	MetaRectangle _tmp3_;
	MetaRectangle _tmp4_;
	MetaRectangle _tmp5_;
	MetaRectangle _tmp6_;
	MetaRectangle _tmp7_;
	MetaRectangle _tmp8_;
	MetaRectangle _tmp9_;
	MetaRectangle _tmp10_;
	MetaRectangle _tmp11_;
	MetaRectangle _tmp12_;
	MetaRectangle _tmp13_;
	MetaRectangle _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	display = _tmp1_;
	meta_display_get_monitor_geometry (display, meta_display_get_primary_monitor (display), &_tmp2_);
	geometry = _tmp2_;
	gala_hot_corner_manager_remove_all_hot_corners (self);
	_tmp3_ = geometry;
	_tmp4_ = geometry;
	gala_hot_corner_manager_add_hotcorner (self, (gfloat) _tmp3_.x, (gfloat) _tmp4_.y, GALA_HOT_CORNER_POSITION_TOP_LEFT);
	_tmp5_ = geometry;
	_tmp6_ = geometry;
	_tmp7_ = geometry;
	gala_hot_corner_manager_add_hotcorner (self, (gfloat) (_tmp5_.x + _tmp6_.width), (gfloat) _tmp7_.y, GALA_HOT_CORNER_POSITION_TOP_RIGHT);
	_tmp8_ = geometry;
	_tmp9_ = geometry;
	_tmp10_ = geometry;
	gala_hot_corner_manager_add_hotcorner (self, (gfloat) _tmp8_.x, (gfloat) (_tmp9_.y + _tmp10_.height), GALA_HOT_CORNER_POSITION_BOTTOM_LEFT);
	_tmp11_ = geometry;
	_tmp12_ = geometry;
	_tmp13_ = geometry;
	_tmp14_ = geometry;
	gala_hot_corner_manager_add_hotcorner (self, (gfloat) (_tmp11_.x + _tmp12_.width), (gfloat) (_tmp13_.y + _tmp14_.height), GALA_HOT_CORNER_POSITION_BOTTOM_RIGHT);
	g_signal_emit (self, gala_hot_corner_manager_signals[GALA_HOT_CORNER_MANAGER_ON_CONFIGURED_SIGNAL], 0);
}

static void
__lambda48_ (GalaHotCornerManager* self,
             GalaHotCorner* hot_corner)
{
	g_return_if_fail (hot_corner != NULL);
	gala_hot_corner_destroy_barriers (hot_corner);
}

static void
___lambda48__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda48_ ((GalaHotCornerManager*) self, (GalaHotCorner*) data);
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static void
gala_hot_corner_manager_remove_all_hot_corners (GalaHotCornerManager* self)
{
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	GPtrArray* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->hot_corners;
	g_ptr_array_foreach (_tmp0_, ___lambda48__gfunc, self);
	_tmp1_ = self->priv->hot_corners;
	_tmp2_ = self->priv->hot_corners;
	_tmp3_ = vala_g_ptr_array_get_length (_tmp2_);
	_tmp4_ = _tmp3_;
	g_ptr_array_remove_range (_tmp1_, (guint) 0, (guint) _tmp4_);
}

static Block53Data*
block53_data_ref (Block53Data* _data53_)
{
	g_atomic_int_inc (&_data53_->_ref_count_);
	return _data53_;
}

static void
block53_data_unref (void * _userdata_)
{
	Block53Data* _data53_;
	_data53_ = (Block53Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data53_->_ref_count_)) {
		GalaHotCornerManager* self;
		self = _data53_->self;
		_g_free0 (_data53_->hot_corner_position);
		_g_object_unref0 (self);
		g_slice_free (Block53Data, _data53_);
	}
}

static void
__lambda49_ (Block53Data* _data53_)
{
	GalaHotCornerManager* self;
	self = _data53_->self;
	if (_data53_->action_type == GALA_ACTION_TYPE_CUSTOM_COMMAND) {
		gala_hot_corner_manager_run_custom_action (self, _data53_->hot_corner_position);
	} else {
		GalaWindowManager* _tmp0_;
		_tmp0_ = self->priv->_wm;
		gala_window_manager_perform_action (_tmp0_, _data53_->action_type);
	}
}

static void
___lambda49__gala_hot_corner_trigger (GalaHotCorner* _sender,
                                      gpointer self)
{
	__lambda49_ (self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gala_hot_corner_manager_add_hotcorner (GalaHotCornerManager* self,
                                       gfloat x,
                                       gfloat y,
                                       const gchar* hot_corner_position)
{
	Block53Data* _data53_;
	gchar* _tmp0_;
	GSettings* _tmp1_;
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp2_;
	MetaDisplay* _tmp3_;
	GalaHotCorner* hot_corner = NULL;
	MetaDisplay* _tmp4_;
	GalaHotCorner* _tmp5_;
	GalaHotCorner* _tmp6_;
	GPtrArray* _tmp7_;
	GalaHotCorner* _tmp8_;
	GalaHotCorner* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (hot_corner_position != NULL);
	_data53_ = g_slice_new0 (Block53Data);
	_data53_->_ref_count_ = 1;
	_data53_->self = g_object_ref (self);
	_tmp0_ = g_strdup (hot_corner_position);
	_g_free0 (_data53_->hot_corner_position);
	_data53_->hot_corner_position = _tmp0_;
	_tmp1_ = self->priv->_behavior_settings;
	_data53_->action_type = (GalaActionType) g_settings_get_enum (_tmp1_, _data53_->hot_corner_position);
	if (_data53_->action_type == GALA_ACTION_TYPE_NONE) {
		block53_data_unref (_data53_);
		_data53_ = NULL;
		return;
	}
	_tmp2_ = self->priv->_wm;
	_tmp3_ = meta_plugin_get_display ((MetaPlugin*) _tmp2_);
	display = _tmp3_;
	_tmp4_ = display;
	_tmp5_ = gala_hot_corner_new (_tmp4_, (gfloat) ((gint) x), (gfloat) ((gint) y), _data53_->hot_corner_position);
	hot_corner = _tmp5_;
	_tmp6_ = hot_corner;
	g_signal_connect_data (_tmp6_, "trigger", (GCallback) ___lambda49__gala_hot_corner_trigger, block53_data_ref (_data53_), (GClosureNotify) block53_data_unref, 0);
	_tmp7_ = self->priv->hot_corners;
	_tmp8_ = hot_corner;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	g_ptr_array_add (_tmp7_, _tmp9_);
	_g_object_unref0 (hot_corner);
	block53_data_unref (_data53_);
	_data53_ = NULL;
}

static void
gala_hot_corner_manager_run_custom_action (GalaHotCornerManager* self,
                                           const gchar* hot_corner_position)
{
	gchar* command = NULL;
	gchar* _tmp0_;
	gchar* line = NULL;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar** parts = NULL;
	const gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint parts_length1;
	gint _parts_size_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (hot_corner_position != NULL);
	_tmp0_ = g_strdup ("");
	command = _tmp0_;
	_tmp1_ = self->priv->_behavior_settings;
	_tmp2_ = g_settings_get_string (_tmp1_, "hotcorner-custom-command");
	line = _tmp2_;
	_tmp3_ = line;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		_g_free0 (line);
		_g_free0 (command);
		return;
	}
	_tmp4_ = line;
	_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, ";;", 0);
	parts = _tmp6_;
	parts_length1 = _vala_array_length (_tmp5_);
	_parts_size_ = parts_length1;
	_tmp7_ = parts;
	_tmp7__length1 = parts_length1;
	if (_tmp7__length1 == 1) {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = line;
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (command);
		command = _tmp9_;
	} else {
		gchar** _tmp10_;
		gint _tmp10__length1;
		_tmp10_ = parts;
		_tmp10__length1 = parts_length1;
		{
			gchar** part_collection = NULL;
			gint part_collection_length1 = 0;
			gint _part_collection_size_ = 0;
			gint part_it = 0;
			part_collection = _tmp10_;
			part_collection_length1 = _tmp10__length1;
			for (part_it = 0; part_it < part_collection_length1; part_it = part_it + 1) {
				const gchar* part = NULL;
				part = part_collection[part_it];
				{
					gchar** details = NULL;
					const gchar* _tmp11_;
					gchar** _tmp12_;
					gchar** _tmp13_;
					gint details_length1;
					gint _details_size_;
					gchar** _tmp14_;
					gint _tmp14__length1;
					const gchar* _tmp15_;
					_tmp11_ = part;
					_tmp13_ = _tmp12_ = g_strsplit (_tmp11_, ":", 0);
					details = _tmp13_;
					details_length1 = _vala_array_length (_tmp12_);
					_details_size_ = details_length1;
					_tmp14_ = details;
					_tmp14__length1 = details_length1;
					_tmp15_ = _tmp14_[0];
					if (g_strcmp0 (_tmp15_, hot_corner_position) == 0) {
						gchar** _tmp16_;
						gint _tmp16__length1;
						const gchar* _tmp17_;
						gchar* _tmp18_;
						_tmp16_ = details;
						_tmp16__length1 = details_length1;
						_tmp17_ = _tmp16_[1];
						_tmp18_ = g_strdup (_tmp17_);
						_g_free0 (command);
						command = _tmp18_;
					}
					details = (_vala_array_free (details, details_length1, (GDestroyNotify) g_free), NULL);
				}
			}
		}
	}
	{
		const gchar* _tmp19_;
		_tmp19_ = command;
		g_spawn_command_line_async (_tmp19_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp20_;
		const gchar* _tmp21_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp20_ = e;
		_tmp21_ = _tmp20_->message;
		g_warning ("HotCornerManager.vala:99: %s", _tmp21_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (line);
		_g_free0 (command);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (line);
	_g_free0 (command);
}

GalaWindowManager*
gala_hot_corner_manager_get_wm (GalaHotCornerManager* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static void
gala_hot_corner_manager_set_wm (GalaHotCornerManager* self,
                                GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_hot_corner_manager_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_hot_corner_manager_properties[GALA_HOT_CORNER_MANAGER_WM_PROPERTY]);
	}
}

GSettings*
gala_hot_corner_manager_get_behavior_settings (GalaHotCornerManager* self)
{
	GSettings* result;
	GSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_behavior_settings;
	result = _tmp0_;
	return result;
}

static void
gala_hot_corner_manager_set_behavior_settings (GalaHotCornerManager* self,
                                               GSettings* value)
{
	GSettings* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_hot_corner_manager_get_behavior_settings (self);
	if (old_value != value) {
		GSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_behavior_settings);
		self->priv->_behavior_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_hot_corner_manager_properties[GALA_HOT_CORNER_MANAGER_BEHAVIOR_SETTINGS_PROPERTY]);
	}
}

static void
gala_hot_corner_manager_class_init (GalaHotCornerManagerClass * klass,
                                    gpointer klass_data)
{
	gala_hot_corner_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaHotCornerManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_hot_corner_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_hot_corner_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = gala_hot_corner_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_HOT_CORNER_MANAGER_WM_PROPERTY, gala_hot_corner_manager_properties[GALA_HOT_CORNER_MANAGER_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_HOT_CORNER_MANAGER_BEHAVIOR_SETTINGS_PROPERTY, gala_hot_corner_manager_properties[GALA_HOT_CORNER_MANAGER_BEHAVIOR_SETTINGS_PROPERTY] = g_param_spec_object ("behavior-settings", "behavior-settings", "behavior-settings", g_settings_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	gala_hot_corner_manager_signals[GALA_HOT_CORNER_MANAGER_ON_CONFIGURED_SIGNAL] = g_signal_new ("on-configured", GALA_TYPE_HOT_CORNER_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
gala_hot_corner_manager_instance_init (GalaHotCornerManager * self,
                                       gpointer klass)
{
	self->priv = gala_hot_corner_manager_get_instance_private (self);
}

static void
gala_hot_corner_manager_finalize (GObject * obj)
{
	GalaHotCornerManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_HOT_CORNER_MANAGER, GalaHotCornerManager);
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->_behavior_settings);
	_g_ptr_array_unref0 (self->priv->hot_corners);
	G_OBJECT_CLASS (gala_hot_corner_manager_parent_class)->finalize (obj);
}

static GType
gala_hot_corner_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaHotCornerManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_hot_corner_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaHotCornerManager), 0, (GInstanceInitFunc) gala_hot_corner_manager_instance_init, NULL };
	GType gala_hot_corner_manager_type_id;
	gala_hot_corner_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaHotCornerManager", &g_define_type_info, 0);
	GalaHotCornerManager_private_offset = g_type_add_instance_private (gala_hot_corner_manager_type_id, sizeof (GalaHotCornerManagerPrivate));
	return gala_hot_corner_manager_type_id;
}

GType
gala_hot_corner_manager_get_type (void)
{
	static volatile gsize gala_hot_corner_manager_type_id__once = 0;
	if (g_once_init_enter (&gala_hot_corner_manager_type_id__once)) {
		GType gala_hot_corner_manager_type_id;
		gala_hot_corner_manager_type_id = gala_hot_corner_manager_get_type_once ();
		g_once_init_leave (&gala_hot_corner_manager_type_id__once, gala_hot_corner_manager_type_id);
	}
	return gala_hot_corner_manager_type_id__once;
}

static void
_vala_gala_hot_corner_manager_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	GalaHotCornerManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_HOT_CORNER_MANAGER, GalaHotCornerManager);
	switch (property_id) {
		case GALA_HOT_CORNER_MANAGER_WM_PROPERTY:
		g_value_set_object (value, gala_hot_corner_manager_get_wm (self));
		break;
		case GALA_HOT_CORNER_MANAGER_BEHAVIOR_SETTINGS_PROPERTY:
		g_value_set_object (value, gala_hot_corner_manager_get_behavior_settings (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_hot_corner_manager_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	GalaHotCornerManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_HOT_CORNER_MANAGER, GalaHotCornerManager);
	switch (property_id) {
		case GALA_HOT_CORNER_MANAGER_WM_PROPERTY:
		gala_hot_corner_manager_set_wm (self, g_value_get_object (value));
		break;
		case GALA_HOT_CORNER_MANAGER_BEHAVIOR_SETTINGS_PROPERTY:
		gala_hot_corner_manager_set_behavior_settings (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

