/* InternalUtils.c generated by valac 0.56.0, the Vala compiler
 * generated from InternalUtils.vala, do not modify */

/**/
/*  Copyright (C) 2012 Tom Beckmann, Rico Tzschichholz*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <meta/prefs.h>
#include "config.h"
#include <meta/meta-shadow-factory.h>
#include <stdlib.h>
#include <string.h>
#include <meta/display.h>
#include <meta/util.h>
#include <X11/Xlib.h>
#include <meta/boxes.h>
#include "gala.h"
#include <meta/meta-x11-display.h>
#include <X11/extensions/Xfixes.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <meta/window.h>
#include <meta/meta-window-actor.h>
#include <meta/compositor-mutter.h>
#include <meta/workspace.h>
#include <gdk/gdk.h>
#include <math.h>
#include <float.h>
#include <meta/meta-backend.h>
#include <meta/meta-settings.h>
#include <granite.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	GALA_INPUT_AREA_NONE,
	GALA_INPUT_AREA_FULLSCREEN,
	GALA_INPUT_AREA_DEFAULT
} GalaInputArea;

#define GALA_TYPE_INPUT_AREA (gala_input_area_get_type ())

#define GALA_TYPE_INTERNAL_UTILS (gala_internal_utils_get_type ())
#define GALA_INTERNAL_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_INTERNAL_UTILS, GalaInternalUtils))
#define GALA_INTERNAL_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_INTERNAL_UTILS, GalaInternalUtilsClass))
#define GALA_IS_INTERNAL_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_INTERNAL_UTILS))
#define GALA_IS_INTERNAL_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_INTERNAL_UTILS))
#define GALA_INTERNAL_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_INTERNAL_UTILS, GalaInternalUtilsClass))

typedef struct _GalaInternalUtils GalaInternalUtils;
typedef struct _GalaInternalUtilsClass GalaInternalUtilsClass;
typedef struct _GalaInternalUtilsPrivate GalaInternalUtilsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GALA_TYPE_PLUGIN_MANAGER (gala_plugin_manager_get_type ())
#define GALA_PLUGIN_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_PLUGIN_MANAGER, GalaPluginManager))
#define GALA_PLUGIN_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_PLUGIN_MANAGER, GalaPluginManagerClass))
#define GALA_IS_PLUGIN_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_PLUGIN_MANAGER))
#define GALA_IS_PLUGIN_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_PLUGIN_MANAGER))
#define GALA_PLUGIN_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_PLUGIN_MANAGER, GalaPluginManagerClass))

typedef struct _GalaPluginManager GalaPluginManager;
typedef struct _GalaPluginManagerClass GalaPluginManagerClass;

#define GALA_TYPE_WORKSPACE_MANAGER (gala_workspace_manager_get_type ())
#define GALA_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WORKSPACE_MANAGER, GalaWorkspaceManager))
#define GALA_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WORKSPACE_MANAGER, GalaWorkspaceManagerClass))
#define GALA_IS_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WORKSPACE_MANAGER))
#define GALA_IS_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WORKSPACE_MANAGER))
#define GALA_WORKSPACE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WORKSPACE_MANAGER, GalaWorkspaceManagerClass))

typedef struct _GalaWorkspaceManager GalaWorkspaceManager;
typedef struct _GalaWorkspaceManagerClass GalaWorkspaceManagerClass;

#define GALA_INTERNAL_UTILS_TYPE_TILABLE_WINDOW (gala_internal_utils_tilable_window_get_type ())
typedef struct _GalaInternalUtilsTilableWindow GalaInternalUtilsTilableWindow;
#define _gala_internal_utils_tilable_window_free0(var) ((var == NULL) ? NULL : (var = (gala_internal_utils_tilable_window_free (var), NULL)))
#define _gtk_widget_path_unref0(var) ((var == NULL) ? NULL : (var = (gtk_widget_path_unref (var), NULL)))
typedef struct _GalaParamSpecInternalUtils GalaParamSpecInternalUtils;

struct _GalaInternalUtils {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GalaInternalUtilsPrivate * priv;
};

struct _GalaInternalUtilsClass {
	GTypeClass parent_class;
	void (*finalize) (GalaInternalUtils *self);
};

struct _GalaInternalUtilsTilableWindow {
	MetaRectangle rect;
	void* id;
};

struct _GalaParamSpecInternalUtils {
	GParamSpec parent_instance;
};

static gpointer gala_internal_utils_parent_class = NULL;
static GSettings* gala_internal_utils_shadow_settings;
static GSettings* gala_internal_utils_shadow_settings = NULL;
static GtkStyleContext* gala_internal_utils_selection_style_context;
static GtkStyleContext* gala_internal_utils_selection_style_context = NULL;

VALA_EXTERN GType gala_input_area_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer gala_internal_utils_ref (gpointer instance);
VALA_EXTERN void gala_internal_utils_unref (gpointer instance);
VALA_EXTERN GParamSpec* gala_param_spec_internal_utils (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
VALA_EXTERN void gala_value_set_internal_utils (GValue* value,
                                    gpointer v_object);
VALA_EXTERN void gala_value_take_internal_utils (GValue* value,
                                     gpointer v_object);
VALA_EXTERN gpointer gala_value_get_internal_utils (const GValue* value);
VALA_EXTERN GType gala_internal_utils_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaInternalUtils, gala_internal_utils_unref)
VALA_EXTERN gboolean gala_internal_utils_workspaces_only_on_primary (void);
VALA_EXTERN void gala_internal_utils_reload_shadow (void);
static void gala_internal_utils_get_shadowparams (const gchar* class_name,
                                           MetaShadowParams* result);
VALA_EXTERN void gala_internal_utils_set_input_area (MetaDisplay* display,
                                         GalaInputArea area);
VALA_EXTERN GType gala_plugin_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaPluginManager, g_object_unref)
VALA_EXTERN GalaPluginManager* gala_plugin_manager_get_default (void);
VALA_EXTERN XRectangle* gala_plugin_manager_get_regions (GalaPluginManager* self,
                                             gint* result_length1);
static void _vala_array_add2 (XRectangle* * array,
                       gint* length,
                       gint* size,
                       XRectangle value);
VALA_EXTERN void gala_internal_utils_insert_workspace_with_window (gint index,
                                                       MetaWindow* new_window);
VALA_EXTERN GType gala_workspace_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWorkspaceManager, g_object_unref)
VALA_EXTERN GalaWorkspaceManager* gala_workspace_manager_get_default (void);
VALA_EXTERN void gala_workspace_manager_freeze_remove (GalaWorkspaceManager* self);
VALA_EXTERN void gala_workspace_manager_thaw_remove (GalaWorkspaceManager* self);
VALA_EXTERN void gala_workspace_manager_cleanup (GalaWorkspaceManager* self);
static gint gala_internal_utils_squared_distance (GdkPoint* a,
                                           GdkPoint* b);
static void gala_internal_utils_rect_adjusted (MetaRectangle* rect,
                                        gint dx1,
                                        gint dy1,
                                        gint dx2,
                                        gint dy2,
                                        MetaRectangle* result);
static void gala_internal_utils_rect_center (MetaRectangle* rect,
                                      GdkPoint* result);
VALA_EXTERN GType gala_internal_utils_tilable_window_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GalaInternalUtilsTilableWindow* gala_internal_utils_tilable_window_dup (const GalaInternalUtilsTilableWindow* self);
VALA_EXTERN void gala_internal_utils_tilable_window_free (GalaInternalUtilsTilableWindow* self);
VALA_EXTERN GList* gala_internal_utils_calculate_grid_placement (MetaRectangle* area,
                                                     GList* windows);
static gboolean _meta_rectangle_equal (const MetaRectangle * s1,
                                const MetaRectangle * s2);
static gboolean _gala_internal_utils_tilable_window_equal (const GalaInternalUtilsTilableWindow * s1,
                                                    const GalaInternalUtilsTilableWindow * s2);
VALA_EXTERN gboolean gala_internal_utils_get_window_is_normal (MetaWindow* window);
VALA_EXTERN gint gala_internal_utils_get_ui_scaling_factor (void);
VALA_EXTERN gint gala_internal_utils_pixel_align (gfloat value);
VALA_EXTERN void gala_internal_utils_get_theme_accent_color (GdkRGBA* result);
VALA_EXTERN GraniteDrawingColor* gala_internal_utils_get_accent_color_by_theme_name (const gchar* theme_name);
VALA_EXTERN void gala_internal_utils_get_workspaces_geometry (MetaDisplay* display,
                                                  MetaRectangle* result);
VALA_EXTERN GalaInternalUtils* gala_internal_utils_new (void);
VALA_EXTERN GalaInternalUtils* gala_internal_utils_construct (GType object_type);
static void gala_internal_utils_finalize (GalaInternalUtils * obj);
static GType gala_internal_utils_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static GType
gala_input_area_get_type_once (void)
{
	static const GEnumValue values[] = {{GALA_INPUT_AREA_NONE, "GALA_INPUT_AREA_NONE", "none"}, {GALA_INPUT_AREA_FULLSCREEN, "GALA_INPUT_AREA_FULLSCREEN", "fullscreen"}, {GALA_INPUT_AREA_DEFAULT, "GALA_INPUT_AREA_DEFAULT", "default"}, {0, NULL, NULL}};
	GType gala_input_area_type_id;
	gala_input_area_type_id = g_enum_register_static ("GalaInputArea", values);
	return gala_input_area_type_id;
}

GType
gala_input_area_get_type (void)
{
	static volatile gsize gala_input_area_type_id__once = 0;
	if (g_once_init_enter (&gala_input_area_type_id__once)) {
		GType gala_input_area_type_id;
		gala_input_area_type_id = gala_input_area_get_type_once ();
		g_once_init_leave (&gala_input_area_type_id__once, gala_input_area_type_id);
	}
	return gala_input_area_type_id__once;
}

gboolean
gala_internal_utils_workspaces_only_on_primary (void)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	if (meta_prefs_get_dynamic_workspaces ()) {
		_tmp0_ = meta_prefs_get_workspaces_only_on_primary ();
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
gala_internal_utils_reload_shadow (void)
{
	GSettings* _tmp0_;
	MetaShadowFactory* factory = NULL;
	MetaShadowFactory* _tmp2_;
	MetaShadowFactory* _tmp3_;
	MetaShadowParams shadow = {0};
	MetaShadowParams _tmp4_ = {0};
	MetaShadowParams _tmp5_;
	MetaShadowParams _tmp6_ = {0};
	MetaShadowParams _tmp7_;
	MetaShadowParams _tmp8_ = {0};
	MetaShadowParams _tmp9_;
	MetaShadowParams _tmp10_;
	MetaShadowParams _tmp11_;
	MetaShadowParams _tmp12_ = {0};
	MetaShadowParams _tmp13_;
	MetaShadowParams _tmp14_;
	MetaShadowParams _tmp15_ = {0};
	MetaShadowParams _tmp16_;
	MetaShadowParams _tmp17_;
	_tmp0_ = gala_internal_utils_shadow_settings;
	if (_tmp0_ == NULL) {
		GSettings* _tmp1_;
		_tmp1_ = g_settings_new (SCHEMA ".shadows");
		_g_object_unref0 (gala_internal_utils_shadow_settings);
		gala_internal_utils_shadow_settings = _tmp1_;
	}
	_tmp2_ = meta_shadow_factory_get_default ();
	_tmp3_ = _g_object_ref0 (_tmp2_);
	factory = _tmp3_;
	gala_internal_utils_get_shadowparams ("normal-focused", &_tmp4_);
	shadow = _tmp4_;
	_tmp5_ = shadow;
	meta_shadow_factory_set_params (factory, "normal", TRUE, &_tmp5_);
	gala_internal_utils_get_shadowparams ("normal-unfocused", &_tmp6_);
	shadow = _tmp6_;
	_tmp7_ = shadow;
	meta_shadow_factory_set_params (factory, "normal", FALSE, &_tmp7_);
	gala_internal_utils_get_shadowparams ("menu", &_tmp8_);
	shadow = _tmp8_;
	_tmp9_ = shadow;
	meta_shadow_factory_set_params (factory, "menu", FALSE, &_tmp9_);
	_tmp10_ = shadow;
	meta_shadow_factory_set_params (factory, "dropdown-menu", FALSE, &_tmp10_);
	_tmp11_ = shadow;
	meta_shadow_factory_set_params (factory, "popup-menu", FALSE, &_tmp11_);
	gala_internal_utils_get_shadowparams ("dialog-focused", &_tmp12_);
	shadow = _tmp12_;
	_tmp13_ = shadow;
	meta_shadow_factory_set_params (factory, "dialog", TRUE, &_tmp13_);
	_tmp14_ = shadow;
	meta_shadow_factory_set_params (factory, "modal_dialog", FALSE, &_tmp14_);
	gala_internal_utils_get_shadowparams ("dialog-unfocused", &_tmp15_);
	shadow = _tmp15_;
	_tmp16_ = shadow;
	meta_shadow_factory_set_params (factory, "dialog", FALSE, &_tmp16_);
	_tmp17_ = shadow;
	meta_shadow_factory_set_params (factory, "modal_dialog", FALSE, &_tmp17_);
	_g_object_unref0 (factory);
}

static void
gala_internal_utils_get_shadowparams (const gchar* class_name,
                                      MetaShadowParams* result)
{
	gchar** val = NULL;
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint val_length1;
	gint _val_size_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp10_;
	gint _tmp10__length1;
	const gchar* _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	const gchar* _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	const gchar* _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	const gchar* _tmp19_;
	MetaShadowParams _tmp20_ = {0};
	g_return_if_fail (class_name != NULL);
	_tmp0_ = gala_internal_utils_shadow_settings;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, class_name);
	val = _tmp2_;
	val_length1 = _vala_array_length (_tmp1_);
	_val_size_ = val_length1;
	_tmp5_ = val;
	_tmp5__length1 = val_length1;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		gchar** _tmp6_;
		gint _tmp6__length1;
		_tmp6_ = val;
		_tmp6__length1 = val_length1;
		_tmp4_ = _tmp6__length1 != 5;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		gchar** _tmp7_;
		gint _tmp7__length1;
		const gchar* _tmp8_;
		_tmp7_ = val;
		_tmp7__length1 = val_length1;
		_tmp8_ = _tmp7_[0];
		_tmp3_ = atoi (_tmp8_) < 1;
	}
	if (_tmp3_) {
		MetaShadowParams _tmp9_ = {0};
		g_warning ("InternalUtils.vala:72: Invalid shadow settings");
		memset (&_tmp9_, 0, sizeof (MetaShadowParams));
		_tmp9_.radius = 1;
		_tmp9_.top_fade = 0;
		_tmp9_.x_offset = 0;
		_tmp9_.y_offset = 0;
		_tmp9_.opacity = (guint8) 0;
		*result = _tmp9_;
		val = (_vala_array_free (val, val_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp10_ = val;
	_tmp10__length1 = val_length1;
	_tmp11_ = _tmp10_[0];
	_tmp12_ = val;
	_tmp12__length1 = val_length1;
	_tmp13_ = _tmp12_[1];
	_tmp14_ = val;
	_tmp14__length1 = val_length1;
	_tmp15_ = _tmp14_[2];
	_tmp16_ = val;
	_tmp16__length1 = val_length1;
	_tmp17_ = _tmp16_[3];
	_tmp18_ = val;
	_tmp18__length1 = val_length1;
	_tmp19_ = _tmp18_[4];
	memset (&_tmp20_, 0, sizeof (MetaShadowParams));
	_tmp20_.radius = atoi (_tmp11_);
	_tmp20_.top_fade = atoi (_tmp13_);
	_tmp20_.x_offset = atoi (_tmp15_);
	_tmp20_.y_offset = atoi (_tmp17_);
	_tmp20_.opacity = (guint8) atoi (_tmp19_);
	*result = _tmp20_;
	val = (_vala_array_free (val, val_length1, (GDestroyNotify) g_free), NULL);
	return;
}

/**
         * set the area where clutter can receive events
         **/
static void
_vala_array_add2 (XRectangle* * array,
                  gint* length,
                  gint* size,
                  XRectangle value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (XRectangle, *array, *size);
	}
	(*array)[(*length)++] = value;
}

void
gala_internal_utils_set_input_area (MetaDisplay* display,
                                    GalaInputArea area)
{
	XRectangle* rects = NULL;
	XRectangle* _tmp0_;
	gint rects_length1;
	gint _rects_size_;
	gint width = 0;
	gint height = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	MetaRectangle geometry = {0};
	MetaRectangle _tmp3_ = {0};
	MetaX11Display* x11display = NULL;
	MetaX11Display* _tmp39_;
	XserverRegion xregion = {0};
	MetaX11Display* _tmp40_;
	Display* _tmp41_;
	XRectangle* _tmp42_;
	gint _tmp42__length1;
	MetaX11Display* _tmp43_;
	g_return_if_fail (display != NULL);
	if (meta_is_wayland_compositor ()) {
		return;
	}
	_tmp0_ = g_new0 (XRectangle, 0);
	rects = _tmp0_;
	rects_length1 = 0;
	_rects_size_ = rects_length1;
	meta_display_get_size (display, &_tmp1_, &_tmp2_);
	width = _tmp1_;
	height = _tmp2_;
	meta_display_get_monitor_geometry (display, meta_display_get_primary_monitor (display), &_tmp3_);
	geometry = _tmp3_;
	switch (area) {
		case GALA_INPUT_AREA_FULLSCREEN:
		{
			XRectangle rect = {0};
			XRectangle _tmp4_ = {0};
			XRectangle* _tmp5_;
			_tmp4_.x = (gshort) 0;
			_tmp4_.y = (gshort) 0;
			_tmp4_.width = (gushort) width;
			_tmp4_.height = (gushort) height;
			rect = _tmp4_;
			_tmp5_ = g_new0 (XRectangle, 1);
			_tmp5_[0] = rect;
			rects = (g_free (rects), NULL);
			rects = _tmp5_;
			rects_length1 = 1;
			_rects_size_ = rects_length1;
			break;
		}
		case GALA_INPUT_AREA_DEFAULT:
		{
			GSettings* settings = NULL;
			GSettings* _tmp6_;
			gint _tmp7_ = 0;
			GSettings* _tmp8_;
			gushort tl_size = 0U;
			gint _tmp9_ = 0;
			GSettings* _tmp10_;
			gushort tr_size = 0U;
			gint _tmp11_ = 0;
			GSettings* _tmp12_;
			gushort bl_size = 0U;
			gint _tmp13_ = 0;
			GSettings* _tmp14_;
			gushort br_size = 0U;
			XRectangle topleft = {0};
			MetaRectangle _tmp15_;
			MetaRectangle _tmp16_;
			XRectangle _tmp17_ = {0};
			XRectangle topright = {0};
			MetaRectangle _tmp18_;
			MetaRectangle _tmp19_;
			MetaRectangle _tmp20_;
			XRectangle _tmp21_ = {0};
			XRectangle bottomleft = {0};
			MetaRectangle _tmp22_;
			MetaRectangle _tmp23_;
			MetaRectangle _tmp24_;
			XRectangle _tmp25_ = {0};
			XRectangle bottomright = {0};
			MetaRectangle _tmp26_;
			MetaRectangle _tmp27_;
			MetaRectangle _tmp28_;
			MetaRectangle _tmp29_;
			XRectangle _tmp30_ = {0};
			XRectangle* _tmp31_;
			gboolean _tmp32_ = FALSE;
			_tmp6_ = g_settings_new (SCHEMA ".behavior");
			settings = _tmp6_;
			_tmp8_ = settings;
			if (g_settings_get_enum (_tmp8_, "hotcorner-topleft") != ((gint) GALA_ACTION_TYPE_NONE)) {
				_tmp7_ = 1;
			} else {
				_tmp7_ = 0;
			}
			tl_size = (gushort) _tmp7_;
			_tmp10_ = settings;
			if (g_settings_get_enum (_tmp10_, "hotcorner-topright") != ((gint) GALA_ACTION_TYPE_NONE)) {
				_tmp9_ = 1;
			} else {
				_tmp9_ = 0;
			}
			tr_size = (gushort) _tmp9_;
			_tmp12_ = settings;
			if (g_settings_get_enum (_tmp12_, "hotcorner-bottomleft") != ((gint) GALA_ACTION_TYPE_NONE)) {
				_tmp11_ = 1;
			} else {
				_tmp11_ = 0;
			}
			bl_size = (gushort) _tmp11_;
			_tmp14_ = settings;
			if (g_settings_get_enum (_tmp14_, "hotcorner-bottomright") != ((gint) GALA_ACTION_TYPE_NONE)) {
				_tmp13_ = 1;
			} else {
				_tmp13_ = 0;
			}
			br_size = (gushort) _tmp13_;
			_tmp15_ = geometry;
			_tmp16_ = geometry;
			_tmp17_.x = (gshort) _tmp15_.x;
			_tmp17_.y = (gshort) _tmp16_.y;
			_tmp17_.width = tl_size;
			_tmp17_.height = tl_size;
			topleft = _tmp17_;
			_tmp18_ = geometry;
			_tmp19_ = geometry;
			_tmp20_ = geometry;
			_tmp21_.x = (gshort) ((_tmp18_.x + _tmp19_.width) - 1);
			_tmp21_.y = (gshort) _tmp20_.y;
			_tmp21_.width = tr_size;
			_tmp21_.height = tr_size;
			topright = _tmp21_;
			_tmp22_ = geometry;
			_tmp23_ = geometry;
			_tmp24_ = geometry;
			_tmp25_.x = (gshort) _tmp22_.x;
			_tmp25_.y = (gshort) ((_tmp23_.y + _tmp24_.height) - 1);
			_tmp25_.width = bl_size;
			_tmp25_.height = bl_size;
			bottomleft = _tmp25_;
			_tmp26_ = geometry;
			_tmp27_ = geometry;
			_tmp28_ = geometry;
			_tmp29_ = geometry;
			_tmp30_.x = (gshort) ((_tmp26_.x + _tmp27_.width) - 1);
			_tmp30_.y = (gshort) ((_tmp28_.y + _tmp29_.height) - 1);
			_tmp30_.width = br_size;
			_tmp30_.height = br_size;
			bottomright = _tmp30_;
			_tmp31_ = g_new0 (XRectangle, 4);
			_tmp31_[0] = topleft;
			_tmp31_[1] = topright;
			_tmp31_[2] = bottomleft;
			_tmp31_[3] = bottomright;
			rects = (g_free (rects), NULL);
			rects = _tmp31_;
			rects_length1 = 4;
			_rects_size_ = rects_length1;
			if (area == GALA_INPUT_AREA_FULLSCREEN) {
				_tmp32_ = TRUE;
			} else {
				_tmp32_ = area == GALA_INPUT_AREA_DEFAULT;
			}
			if (_tmp32_) {
				GalaPluginManager* _tmp33_;
				XRectangle* _tmp34_;
				gint _tmp34__length1;
				gint _tmp35_ = 0;
				XRectangle* _tmp36_;
				gint _tmp36__length1;
				_tmp33_ = gala_plugin_manager_get_default ();
				_tmp34_ = gala_plugin_manager_get_regions (_tmp33_, &_tmp35_);
				_tmp34__length1 = _tmp35_;
				_tmp36_ = _tmp34_;
				_tmp36__length1 = _tmp34__length1;
				{
					XRectangle* rect_collection = NULL;
					gint rect_collection_length1 = 0;
					gint _rect_collection_size_ = 0;
					gint rect_it = 0;
					rect_collection = _tmp36_;
					rect_collection_length1 = _tmp36__length1;
					for (rect_it = 0; rect_it < rect_collection_length1; rect_it = rect_it + 1) {
						XRectangle rect = {0};
						rect = rect_collection[rect_it];
						{
							_vala_array_add2 (&rects, &rects_length1, &_rects_size_, rect);
						}
					}
				}
			}
			_g_object_unref0 (settings);
			break;
		}
		default:
		case GALA_INPUT_AREA_NONE:
		{
			MetaX11Display* x11display = NULL;
			MetaX11Display* _tmp37_;
			MetaX11Display* _tmp38_;
			_tmp37_ = meta_display_get_x11_display (display);
			x11display = _tmp37_;
			_tmp38_ = x11display;
			meta_x11_display_clear_stage_input_region (_tmp38_);
			rects = (g_free (rects), NULL);
			return;
		}
	}
	_tmp39_ = meta_display_get_x11_display (display);
	x11display = _tmp39_;
	_tmp40_ = x11display;
	_tmp41_ = meta_x11_display_get_xdisplay (_tmp40_);
	_tmp42_ = rects;
	_tmp42__length1 = rects_length1;
	xregion = XFixesCreateRegion (_tmp41_, _tmp42_, (gint) _tmp42__length1);
	_tmp43_ = x11display;
	meta_x11_display_set_stage_input_region (_tmp43_, xregion);
	rects = (g_free (rects), NULL);
}

/**
         * Inserts a workspace at the given index. To ensure the workspace is not immediately
         * removed again when in dynamic workspaces, the window is first placed on it.
         *
         * @param index  The index at which to insert the workspace
         * @param new_window A window that should be moved to the new workspace
         */
void
gala_internal_utils_insert_workspace_with_window (gint index,
                                                  MetaWindow* new_window)
{
	GalaWorkspaceManager* workspace_manager = NULL;
	GalaWorkspaceManager* _tmp0_;
	GalaWorkspaceManager* _tmp1_;
	GList* actors = NULL;
	MetaDisplay* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	GalaWorkspaceManager* _tmp16_;
	GalaWorkspaceManager* _tmp17_;
	g_return_if_fail (new_window != NULL);
	_tmp0_ = gala_workspace_manager_get_default ();
	workspace_manager = _tmp0_;
	_tmp1_ = workspace_manager;
	gala_workspace_manager_freeze_remove (_tmp1_);
	meta_window_change_workspace_by_index (new_window, index, FALSE);
	_tmp2_ = meta_window_get_display (new_window);
	_tmp3_ = meta_get_window_actors (_tmp2_);
	actors = _tmp3_;
	_tmp4_ = actors;
	{
		GList* actor_collection = NULL;
		GList* actor_it = NULL;
		actor_collection = _tmp4_;
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
			MetaWindowActor* actor = NULL;
			actor = (MetaWindowActor*) actor_it->data;
			{
				MetaWindowActor* _tmp5_;
				MetaWindow* window = NULL;
				MetaWindowActor* _tmp6_;
				MetaWindow* _tmp7_;
				MetaWindow* _tmp8_;
				gint current_index = 0;
				MetaWindow* _tmp9_;
				MetaWorkspace* _tmp10_;
				gboolean _tmp11_ = FALSE;
				_tmp5_ = actor;
				if (meta_window_actor_is_destroyed (_tmp5_)) {
					continue;
				}
				_tmp6_ = actor;
				_tmp7_ = meta_window_actor_get_meta_window (_tmp6_);
				window = _tmp7_;
				_tmp8_ = window;
				if (_tmp8_ == new_window) {
					continue;
				}
				_tmp9_ = window;
				_tmp10_ = meta_window_get_workspace (_tmp9_);
				current_index = meta_workspace_index (_tmp10_);
				if (current_index >= index) {
					MetaWindow* _tmp12_;
					gboolean _tmp13_;
					gboolean _tmp14_;
					_tmp12_ = window;
					g_object_get (_tmp12_, "on-all-workspaces", &_tmp13_, NULL);
					_tmp14_ = _tmp13_;
					_tmp11_ = !_tmp14_;
				} else {
					_tmp11_ = FALSE;
				}
				if (_tmp11_) {
					MetaWindow* _tmp15_;
					_tmp15_ = window;
					meta_window_change_workspace_by_index (_tmp15_, current_index + 1, TRUE);
				}
			}
		}
	}
	_tmp16_ = workspace_manager;
	gala_workspace_manager_thaw_remove (_tmp16_);
	_tmp17_ = workspace_manager;
	gala_workspace_manager_cleanup (_tmp17_);
}

static gint
gala_internal_utils_squared_distance (GdkPoint* a,
                                      GdkPoint* b)
{
	gint k1 = 0;
	GdkPoint _tmp0_;
	GdkPoint _tmp1_;
	gint k2 = 0;
	GdkPoint _tmp2_;
	GdkPoint _tmp3_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = *b;
	_tmp1_ = *a;
	k1 = _tmp0_.x - _tmp1_.x;
	_tmp2_ = *b;
	_tmp3_ = *a;
	k2 = _tmp2_.y - _tmp3_.y;
	result = (k1 * k1) + (k2 * k2);
	return result;
}

static void
gala_internal_utils_rect_adjusted (MetaRectangle* rect,
                                   gint dx1,
                                   gint dy1,
                                   gint dx2,
                                   gint dy2,
                                   MetaRectangle* result)
{
	MetaRectangle _tmp0_;
	MetaRectangle _tmp1_;
	MetaRectangle _tmp2_;
	MetaRectangle _tmp3_;
	MetaRectangle _tmp4_ = {0};
	g_return_if_fail (rect != NULL);
	_tmp0_ = *rect;
	_tmp1_ = *rect;
	_tmp2_ = *rect;
	_tmp3_ = *rect;
	_tmp4_.x = _tmp0_.x + dx1;
	_tmp4_.y = _tmp1_.y + dy1;
	_tmp4_.width = _tmp2_.width + ((-dx1) + dx2);
	_tmp4_.height = _tmp3_.height + ((-dy1) + dy2);
	*result = _tmp4_;
	return;
}

static void
gala_internal_utils_rect_center (MetaRectangle* rect,
                                 GdkPoint* result)
{
	MetaRectangle _tmp0_;
	MetaRectangle _tmp1_;
	MetaRectangle _tmp2_;
	MetaRectangle _tmp3_;
	GdkPoint _tmp4_ = {0};
	g_return_if_fail (rect != NULL);
	_tmp0_ = *rect;
	_tmp1_ = *rect;
	_tmp2_ = *rect;
	_tmp3_ = *rect;
	_tmp4_.x = _tmp0_.x + (_tmp1_.width / 2);
	_tmp4_.y = _tmp2_.y + (_tmp3_.height / 2);
	*result = _tmp4_;
	return;
}

static gpointer
_gala_internal_utils_tilable_window_dup0 (gpointer self)
{
	return self ? gala_internal_utils_tilable_window_dup (self) : NULL;
}

static gboolean
_meta_rectangle_equal (const MetaRectangle * s1,
                       const MetaRectangle * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->x != s2->x) {
		return FALSE;
	}
	if (s1->y != s2->y) {
		return FALSE;
	}
	if (s1->width != s2->width) {
		return FALSE;
	}
	if (s1->height != s2->height) {
		return FALSE;
	}
	return TRUE;
}

static gboolean
_gala_internal_utils_tilable_window_equal (const GalaInternalUtilsTilableWindow * s1,
                                           const GalaInternalUtilsTilableWindow * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (!_meta_rectangle_equal (&s1->rect, &s2->rect)) {
		return FALSE;
	}
	if (s1->id != s2->id) {
		return FALSE;
	}
	return TRUE;
}

GList*
gala_internal_utils_calculate_grid_placement (MetaRectangle* area,
                                              GList* windows)
{
	guint window_count = 0U;
	gint columns = 0;
	gint rows = 0;
	gint slot_width = 0;
	MetaRectangle _tmp0_;
	gint slot_height = 0;
	MetaRectangle _tmp1_;
	GalaInternalUtilsTilableWindow** taken_slots = NULL;
	GalaInternalUtilsTilableWindow** _tmp2_;
	gint taken_slots_length1;
	gint _taken_slots_size_;
	gint _tmp3_;
	GdkPoint* slot_centers = NULL;
	GdkPoint* _tmp4_;
	gint slot_centers_length1;
	gint _slot_centers_size_;
	gint _tmp5_;
	GList* tmplist = NULL;
	GList* _tmp14_;
	GList* _result_ = NULL;
	gint left_over = 0;
	GList* result;
	g_return_val_if_fail (area != NULL, NULL);
	window_count = g_list_length (windows);
	columns = (gint) ceil (sqrt ((gdouble) window_count));
	rows = (gint) ceil (window_count / ((gdouble) columns));
	_tmp0_ = *area;
	slot_width = _tmp0_.width / columns;
	_tmp1_ = *area;
	slot_height = _tmp1_.height / rows;
	_tmp2_ = g_new0 (GalaInternalUtilsTilableWindow*, 0);
	taken_slots = _tmp2_;
	taken_slots_length1 = 0;
	_taken_slots_size_ = taken_slots_length1;
	_tmp3_ = rows * columns;
	taken_slots = g_renew (GalaInternalUtilsTilableWindow*, taken_slots, rows * columns);
	(_tmp3_ > taken_slots_length1) ? memset (taken_slots + taken_slots_length1, 0, sizeof (GalaInternalUtilsTilableWindow*) * (_tmp3_ - taken_slots_length1)) : NULL;
	taken_slots_length1 = _tmp3_;
	_taken_slots_size_ = _tmp3_;
	_tmp4_ = g_new0 (GdkPoint, 0);
	slot_centers = _tmp4_;
	slot_centers_length1 = 0;
	_slot_centers_size_ = slot_centers_length1;
	_tmp5_ = rows * columns;
	slot_centers = g_renew (GdkPoint, slot_centers, rows * columns);
	(_tmp5_ > slot_centers_length1) ? memset (slot_centers + slot_centers_length1, 0, sizeof (GdkPoint) * (_tmp5_ - slot_centers_length1)) : NULL;
	slot_centers_length1 = _tmp5_;
	_slot_centers_size_ = _tmp5_;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = x;
					x = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				if (!(x < columns)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp8_ = FALSE;
						_tmp8_ = TRUE;
						while (TRUE) {
							GdkPoint* _tmp10_;
							gint _tmp10__length1;
							MetaRectangle _tmp11_;
							MetaRectangle _tmp12_;
							GdkPoint _tmp13_ = {0};
							if (!_tmp8_) {
								gint _tmp9_;
								_tmp9_ = y;
								y = _tmp9_ + 1;
							}
							_tmp8_ = FALSE;
							if (!(y < rows)) {
								break;
							}
							_tmp10_ = slot_centers;
							_tmp10__length1 = slot_centers_length1;
							_tmp11_ = *area;
							_tmp12_ = *area;
							_tmp13_.x = (_tmp11_.x + (slot_width * x)) + (slot_width / 2);
							_tmp13_.y = (_tmp12_.y + (slot_height * y)) + (slot_height / 2);
							_tmp10_[x + (y * columns)] = _tmp13_;
						}
					}
				}
			}
		}
	}
	_tmp14_ = g_list_copy (windows);
	tmplist = _tmp14_;
	while (TRUE) {
		GList* _tmp15_;
		GList* link = NULL;
		GList* _tmp16_;
		GList* _tmp17_;
		GalaInternalUtilsTilableWindow* window = NULL;
		GList* _tmp18_;
		gconstpointer _tmp19_;
		GalaInternalUtilsTilableWindow* _tmp20_;
		MetaRectangle rect = {0};
		GalaInternalUtilsTilableWindow* _tmp21_;
		MetaRectangle _tmp22_;
		gint slot_candidate = 0;
		gint slot_candidate_distance = 0;
		GdkPoint pos = {0};
		MetaRectangle _tmp23_;
		GdkPoint _tmp24_ = {0};
		GalaInternalUtilsTilableWindow** _tmp42_;
		gint _tmp42__length1;
		GalaInternalUtilsTilableWindow* _tmp43_;
		GList* _tmp46_;
		GalaInternalUtilsTilableWindow** _tmp47_;
		gint _tmp47__length1;
		GalaInternalUtilsTilableWindow* _tmp48_;
		GalaInternalUtilsTilableWindow* _tmp49_;
		_tmp15_ = tmplist;
		if (!(g_list_length (_tmp15_) > ((guint) 0))) {
			break;
		}
		_tmp16_ = tmplist;
		_tmp17_ = g_list_nth (_tmp16_, (guint) 0);
		link = _tmp17_;
		_tmp18_ = link;
		_tmp19_ = _tmp18_->data;
		_tmp20_ = _gala_internal_utils_tilable_window_dup0 ((GalaInternalUtilsTilableWindow*) _tmp19_);
		window = _tmp20_;
		_tmp21_ = window;
		_tmp22_ = (*_tmp21_).rect;
		rect = _tmp22_;
		slot_candidate = -1;
		slot_candidate_distance = G_MAXINT;
		_tmp23_ = rect;
		gala_internal_utils_rect_center (&_tmp23_, &_tmp24_);
		pos = _tmp24_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp25_ = FALSE;
				_tmp25_ = TRUE;
				while (TRUE) {
					gint dist = 0;
					GdkPoint _tmp27_;
					GdkPoint* _tmp28_;
					gint _tmp28__length1;
					GdkPoint _tmp29_;
					if (!_tmp25_) {
						gint _tmp26_;
						_tmp26_ = i;
						i = _tmp26_ + 1;
					}
					_tmp25_ = FALSE;
					if (!(i < (columns * rows))) {
						break;
					}
					if (((guint) i) > (window_count - 1)) {
						break;
					}
					_tmp27_ = pos;
					_tmp28_ = slot_centers;
					_tmp28__length1 = slot_centers_length1;
					_tmp29_ = _tmp28_[i];
					dist = gala_internal_utils_squared_distance (&_tmp27_, &_tmp29_);
					if (dist < slot_candidate_distance) {
						GalaInternalUtilsTilableWindow* occupier = NULL;
						GalaInternalUtilsTilableWindow** _tmp30_;
						gint _tmp30__length1;
						GalaInternalUtilsTilableWindow* _tmp31_;
						GalaInternalUtilsTilableWindow* _tmp32_;
						GalaInternalUtilsTilableWindow* _tmp33_;
						GalaInternalUtilsTilableWindow* _tmp34_;
						gboolean _tmp35_ = FALSE;
						GalaInternalUtilsTilableWindow* _tmp36_;
						_tmp30_ = taken_slots;
						_tmp30__length1 = taken_slots_length1;
						_tmp31_ = _tmp30_[i];
						_tmp32_ = _gala_internal_utils_tilable_window_dup0 (_tmp31_);
						occupier = _tmp32_;
						_tmp33_ = occupier;
						_tmp34_ = window;
						if (_gala_internal_utils_tilable_window_equal (_tmp33_, _tmp34_) == TRUE) {
							_gala_internal_utils_tilable_window_free0 (occupier);
							continue;
						}
						_tmp36_ = occupier;
						if (_tmp36_ == NULL) {
							_tmp35_ = TRUE;
						} else {
							GalaInternalUtilsTilableWindow* _tmp37_;
							MetaRectangle _tmp38_;
							GdkPoint _tmp39_ = {0};
							GdkPoint* _tmp40_;
							gint _tmp40__length1;
							GdkPoint _tmp41_;
							_tmp37_ = occupier;
							_tmp38_ = (*_tmp37_).rect;
							gala_internal_utils_rect_center (&_tmp38_, &_tmp39_);
							_tmp40_ = slot_centers;
							_tmp40__length1 = slot_centers_length1;
							_tmp41_ = _tmp40_[i];
							_tmp35_ = dist < gala_internal_utils_squared_distance (&_tmp39_, &_tmp41_);
						}
						if (_tmp35_) {
							slot_candidate = i;
							slot_candidate_distance = dist;
						}
						_gala_internal_utils_tilable_window_free0 (occupier);
					}
				}
			}
		}
		if (slot_candidate == -1) {
			_gala_internal_utils_tilable_window_free0 (window);
			continue;
		}
		_tmp42_ = taken_slots;
		_tmp42__length1 = taken_slots_length1;
		_tmp43_ = _tmp42_[slot_candidate];
		if (_tmp43_ != NULL) {
			GalaInternalUtilsTilableWindow** _tmp44_;
			gint _tmp44__length1;
			GalaInternalUtilsTilableWindow* _tmp45_;
			_tmp44_ = taken_slots;
			_tmp44__length1 = taken_slots_length1;
			_tmp45_ = _tmp44_[slot_candidate];
			tmplist = g_list_prepend (tmplist, _tmp45_);
		}
		_tmp46_ = link;
		tmplist = g_list_remove_link (tmplist, _tmp46_);
		_tmp47_ = taken_slots;
		_tmp47__length1 = taken_slots_length1;
		_tmp48_ = window;
		_tmp49_ = _gala_internal_utils_tilable_window_dup0 (_tmp48_);
		_gala_internal_utils_tilable_window_free0 (_tmp47_[slot_candidate]);
		_tmp47_[slot_candidate] = _tmp49_;
		_gala_internal_utils_tilable_window_free0 (window);
	}
	_result_ = NULL;
	left_over = ((gint) window_count) - (columns * (rows - 1));
	{
		gint slot = 0;
		slot = 0;
		{
			gboolean _tmp50_ = FALSE;
			_tmp50_ = TRUE;
			while (TRUE) {
				GalaInternalUtilsTilableWindow* window = NULL;
				GalaInternalUtilsTilableWindow** _tmp52_;
				gint _tmp52__length1;
				GalaInternalUtilsTilableWindow* _tmp53_;
				GalaInternalUtilsTilableWindow* _tmp54_;
				GalaInternalUtilsTilableWindow* _tmp55_;
				MetaRectangle rect = {0};
				GalaInternalUtilsTilableWindow* _tmp56_;
				MetaRectangle _tmp57_;
				MetaRectangle target = {0};
				MetaRectangle _tmp58_;
				MetaRectangle _tmp59_;
				MetaRectangle _tmp60_ = {0};
				MetaRectangle _tmp61_;
				MetaRectangle _tmp62_ = {0};
				gfloat scale = 0.0F;
				MetaRectangle _tmp63_;
				MetaRectangle _tmp64_;
				MetaRectangle _tmp65_;
				MetaRectangle _tmp66_;
				gboolean _tmp86_ = FALSE;
				MetaRectangle _tmp87_;
				GalaInternalUtilsTilableWindow* _tmp88_;
				void* _tmp89_;
				GalaInternalUtilsTilableWindow _tmp90_ = {0};
				GalaInternalUtilsTilableWindow* _tmp91_;
				if (!_tmp50_) {
					gint _tmp51_;
					_tmp51_ = slot;
					slot = _tmp51_ + 1;
				}
				_tmp50_ = FALSE;
				if (!(slot < (columns * rows))) {
					break;
				}
				_tmp52_ = taken_slots;
				_tmp52__length1 = taken_slots_length1;
				_tmp53_ = _tmp52_[slot];
				_tmp54_ = _gala_internal_utils_tilable_window_dup0 (_tmp53_);
				window = _tmp54_;
				_tmp55_ = window;
				if (_tmp55_ == NULL) {
					_gala_internal_utils_tilable_window_free0 (window);
					continue;
				}
				_tmp56_ = window;
				_tmp57_ = (*_tmp56_).rect;
				rect = _tmp57_;
				_tmp58_ = *area;
				_tmp59_ = *area;
				_tmp60_.x = _tmp58_.x + ((slot % columns) * slot_width);
				_tmp60_.y = _tmp59_.y + ((slot / columns) * slot_height);
				_tmp60_.width = slot_width;
				_tmp60_.height = slot_height;
				target = _tmp60_;
				_tmp61_ = target;
				gala_internal_utils_rect_adjusted (&_tmp61_, 10, 10, -10, -10, &_tmp62_);
				target = _tmp62_;
				_tmp63_ = target;
				_tmp64_ = rect;
				_tmp65_ = target;
				_tmp66_ = rect;
				if ((_tmp63_.width / ((gdouble) _tmp64_.width)) < (_tmp65_.height / ((gdouble) _tmp66_.height))) {
					MetaRectangle _tmp67_;
					MetaRectangle _tmp68_;
					MetaRectangle _tmp69_;
					MetaRectangle _tmp70_;
					MetaRectangle _tmp71_;
					_tmp67_ = target;
					_tmp68_ = rect;
					scale = _tmp67_.width / ((gfloat) _tmp68_.width);
					_tmp69_ = target;
					_tmp70_ = rect;
					target.y = target.y + ((_tmp69_.height - ((gint) (_tmp70_.height * scale))) / 2);
					_tmp71_ = rect;
					target.height = (gint) floorf (_tmp71_.height * scale);
				} else {
					MetaRectangle _tmp72_;
					MetaRectangle _tmp73_;
					MetaRectangle _tmp74_;
					MetaRectangle _tmp75_;
					MetaRectangle _tmp76_;
					_tmp72_ = target;
					_tmp73_ = rect;
					scale = _tmp72_.height / ((gfloat) _tmp73_.height);
					_tmp74_ = target;
					_tmp75_ = rect;
					target.x = target.x + ((_tmp74_.width - ((gint) (_tmp75_.width * scale))) / 2);
					_tmp76_ = rect;
					target.width = (gint) floorf (_tmp76_.width * scale);
				}
				if (((gdouble) scale) > 1.0) {
					MetaRectangle _tmp77_;
					GdkPoint _tmp78_ = {0};
					MetaRectangle _tmp79_;
					MetaRectangle _tmp80_;
					GdkPoint _tmp81_ = {0};
					MetaRectangle _tmp82_;
					MetaRectangle _tmp83_;
					MetaRectangle _tmp84_;
					MetaRectangle _tmp85_ = {0};
					scale = 1.0f;
					_tmp77_ = target;
					gala_internal_utils_rect_center (&_tmp77_, &_tmp78_);
					_tmp79_ = rect;
					_tmp80_ = target;
					gala_internal_utils_rect_center (&_tmp80_, &_tmp81_);
					_tmp82_ = rect;
					_tmp83_ = rect;
					_tmp84_ = rect;
					_tmp85_.x = _tmp78_.x - (((gint) floorf (_tmp79_.width * scale)) / 2);
					_tmp85_.y = _tmp81_.y - (((gint) floorf (_tmp82_.height * scale)) / 2);
					_tmp85_.width = (gint) floorf (scale * _tmp83_.width);
					_tmp85_.height = (gint) floorf (scale * _tmp84_.height);
					target = _tmp85_;
				}
				if (left_over != columns) {
					_tmp86_ = slot >= (columns * (rows - 1));
				} else {
					_tmp86_ = FALSE;
				}
				if (_tmp86_) {
					target.x = target.x + (((columns - left_over) * slot_width) / 2);
				}
				_tmp87_ = target;
				_tmp88_ = window;
				_tmp89_ = (*_tmp88_).id;
				_tmp90_.rect = _tmp87_;
				_tmp90_.id = _tmp89_;
				_tmp91_ = _gala_internal_utils_tilable_window_dup0 (&_tmp90_);
				_result_ = g_list_prepend (_result_, _tmp91_);
				_gala_internal_utils_tilable_window_free0 (window);
			}
		}
	}
	_result_ = g_list_reverse (_result_);
	result = _result_;
	(tmplist == NULL) ? NULL : (tmplist = (g_list_free (tmplist), NULL));
	slot_centers = (g_free (slot_centers), NULL);
	taken_slots = (_vala_array_free (taken_slots, taken_slots_length1, (GDestroyNotify) gala_internal_utils_tilable_window_free), NULL);
	return result;
}

inline gboolean
gala_internal_utils_get_window_is_normal (MetaWindow* window)
{
	gboolean result;
	g_return_val_if_fail (window != NULL, FALSE);
	switch (meta_window_get_window_type (window)) {
		case META_WINDOW_NORMAL:
		case META_WINDOW_DIALOG:
		case META_WINDOW_MODAL_DIALOG:
		{
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

gint
gala_internal_utils_get_ui_scaling_factor (void)
{
	MetaBackend* _tmp0_;
	MetaSettings* _tmp1_;
	gint result;
	_tmp0_ = meta_get_backend ();
	_tmp1_ = meta_backend_get_settings (_tmp0_);
	result = meta_settings_get_ui_scaling_factor (_tmp1_);
	return result;
}

/**
         * Round the value to match physical pixels.
         */
gint
gala_internal_utils_pixel_align (gfloat value)
{
	gint scale_factor = 0;
	gint result;
	scale_factor = gala_internal_utils_get_ui_scaling_factor ();
	result = ((gint) round ((gdouble) (value * scale_factor))) / scale_factor;
	return result;
}

void
gala_internal_utils_get_theme_accent_color (GdkRGBA* result)
{
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp7_;
	GValue _tmp8_ = {0};
	GValue _tmp9_;
	GdkRGBA* _tmp10_;
	GdkRGBA _tmp11_ = {0};
	GdkRGBA _tmp12_;
	_tmp0_ = gala_internal_utils_selection_style_context;
	if (_tmp0_ == NULL) {
		GtkWidgetPath* label_widget_path = NULL;
		GtkWidgetPath* _tmp1_;
		GtkWidgetPath* _tmp2_;
		GtkWidgetPath* _tmp3_;
		GtkStyleContext* _tmp4_;
		GtkStyleContext* _tmp5_;
		GtkWidgetPath* _tmp6_;
		_tmp1_ = gtk_widget_path_new ();
		label_widget_path = _tmp1_;
		_tmp2_ = label_widget_path;
		gtk_widget_path_append_type (_tmp2_, g_type_from_name ("label"));
		_tmp3_ = label_widget_path;
		gtk_widget_path_iter_set_object_name (_tmp3_, -1, "selection");
		_tmp4_ = gtk_style_context_new ();
		_g_object_unref0 (gala_internal_utils_selection_style_context);
		gala_internal_utils_selection_style_context = _tmp4_;
		_tmp5_ = gala_internal_utils_selection_style_context;
		_tmp6_ = label_widget_path;
		gtk_style_context_set_path (_tmp5_, _tmp6_);
		_gtk_widget_path_unref0 (label_widget_path);
	}
	_tmp7_ = gala_internal_utils_selection_style_context;
	gtk_style_context_get_property (_tmp7_, GTK_STYLE_PROPERTY_BACKGROUND_COLOR, GTK_STATE_FLAG_NORMAL, &_tmp8_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_value_get_boxed (&_tmp8_);
	_tmp12_ = (G_VALUE_HOLDS (&_tmp8_, gdk_rgba_get_type ()) && _tmp10_) ? (*_tmp10_) : (g_warning ("Invalid GValue unboxing (wrong type or NULL)"), _tmp11_);
	G_IS_VALUE (&_tmp9_) ? (g_value_unset (&_tmp9_), NULL) : NULL;
	*result = _tmp12_;
	return;
}

GraniteDrawingColor*
gala_internal_utils_get_accent_color_by_theme_name (const gchar* theme_name)
{
	GtkWidgetPath* label_widget_path = NULL;
	GtkWidgetPath* _tmp0_;
	GtkStyleContext* selection_style_context = NULL;
	GtkStyleContext* _tmp1_;
	GtkCssProvider* theme_provider = NULL;
	GtkCssProvider* _tmp2_;
	GdkRGBA rgba = {0};
	GValue _tmp3_ = {0};
	GValue _tmp4_;
	GdkRGBA* _tmp5_;
	GdkRGBA _tmp6_ = {0};
	GdkRGBA _tmp7_;
	GdkRGBA _tmp8_;
	GraniteDrawingColor* _tmp9_;
	GraniteDrawingColor* result;
	g_return_val_if_fail (theme_name != NULL, NULL);
	_tmp0_ = gtk_widget_path_new ();
	label_widget_path = _tmp0_;
	gtk_widget_path_append_type (label_widget_path, g_type_from_name ("label"));
	gtk_widget_path_iter_set_object_name (label_widget_path, -1, "selection");
	_tmp1_ = gtk_style_context_new ();
	selection_style_context = _tmp1_;
	_tmp2_ = gtk_css_provider_get_named (theme_name, NULL);
	theme_provider = _tmp2_;
	gtk_style_context_add_provider (selection_style_context, (GtkStyleProvider*) theme_provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_USER);
	gtk_style_context_set_path (selection_style_context, label_widget_path);
	gtk_style_context_get_property (selection_style_context, GTK_STYLE_PROPERTY_BACKGROUND_COLOR, GTK_STATE_FLAG_NORMAL, &_tmp3_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_value_get_boxed (&_tmp3_);
	_tmp7_ = (G_VALUE_HOLDS (&_tmp3_, gdk_rgba_get_type ()) && _tmp5_) ? (*_tmp5_) : (g_warning ("Invalid GValue unboxing (wrong type or NULL)"), _tmp6_);
	G_IS_VALUE (&_tmp4_) ? (g_value_unset (&_tmp4_), NULL) : NULL;
	rgba = _tmp7_;
	_tmp8_ = rgba;
	_tmp9_ = granite_drawing_color_new_from_rgba (&_tmp8_);
	result = _tmp9_;
	_g_object_unref0 (selection_style_context);
	_gtk_widget_path_unref0 (label_widget_path);
	return result;
}

/**
         * Returns the workspaces geometry following the only_on_primary settings.
         */
void
gala_internal_utils_get_workspaces_geometry (MetaDisplay* display,
                                             MetaRectangle* result)
{
	g_return_if_fail (display != NULL);
	if (gala_internal_utils_workspaces_only_on_primary ()) {
		gint primary = 0;
		MetaRectangle _tmp0_ = {0};
		primary = meta_display_get_primary_monitor (display);
		meta_display_get_monitor_geometry (display, primary, &_tmp0_);
		*result = _tmp0_;
		return;
	} else {
		gfloat screen_width = 0.0F;
		gfloat screen_height = 0.0F;
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		MetaRectangle _tmp3_ = {0};
		meta_display_get_size (display, &_tmp1_, &_tmp2_);
		screen_width = (gfloat) _tmp1_;
		screen_height = (gfloat) _tmp2_;
		_tmp3_.x = 0;
		_tmp3_.y = 0;
		_tmp3_.width = (gint) screen_width;
		_tmp3_.height = (gint) screen_height;
		*result = _tmp3_;
		return;
	}
}

GalaInternalUtils*
gala_internal_utils_construct (GType object_type)
{
	GalaInternalUtils* self = NULL;
	self = (GalaInternalUtils*) g_type_create_instance (object_type);
	return self;
}

GalaInternalUtils*
gala_internal_utils_new (void)
{
	return gala_internal_utils_construct (GALA_TYPE_INTERNAL_UTILS);
}

GalaInternalUtilsTilableWindow*
gala_internal_utils_tilable_window_dup (const GalaInternalUtilsTilableWindow* self)
{
	GalaInternalUtilsTilableWindow* dup;
	dup = g_new0 (GalaInternalUtilsTilableWindow, 1);
	memcpy (dup, self, sizeof (GalaInternalUtilsTilableWindow));
	return dup;
}

void
gala_internal_utils_tilable_window_free (GalaInternalUtilsTilableWindow* self)
{
	g_free (self);
}

static GType
gala_internal_utils_tilable_window_get_type_once (void)
{
	GType gala_internal_utils_tilable_window_type_id;
	gala_internal_utils_tilable_window_type_id = g_boxed_type_register_static ("GalaInternalUtilsTilableWindow", (GBoxedCopyFunc) gala_internal_utils_tilable_window_dup, (GBoxedFreeFunc) gala_internal_utils_tilable_window_free);
	return gala_internal_utils_tilable_window_type_id;
}

GType
gala_internal_utils_tilable_window_get_type (void)
{
	static volatile gsize gala_internal_utils_tilable_window_type_id__once = 0;
	if (g_once_init_enter (&gala_internal_utils_tilable_window_type_id__once)) {
		GType gala_internal_utils_tilable_window_type_id;
		gala_internal_utils_tilable_window_type_id = gala_internal_utils_tilable_window_get_type_once ();
		g_once_init_leave (&gala_internal_utils_tilable_window_type_id__once, gala_internal_utils_tilable_window_type_id);
	}
	return gala_internal_utils_tilable_window_type_id__once;
}

static void
gala_value_internal_utils_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gala_value_internal_utils_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gala_internal_utils_unref (value->data[0].v_pointer);
	}
}

static void
gala_value_internal_utils_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gala_internal_utils_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gala_value_internal_utils_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gala_value_internal_utils_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GalaInternalUtils * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gala_internal_utils_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gala_value_internal_utils_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	GalaInternalUtils ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gala_internal_utils_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
gala_param_spec_internal_utils (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	GalaParamSpecInternalUtils* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GALA_TYPE_INTERNAL_UTILS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
gala_value_get_internal_utils (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GALA_TYPE_INTERNAL_UTILS), NULL);
	return value->data[0].v_pointer;
}

void
gala_value_set_internal_utils (GValue* value,
                               gpointer v_object)
{
	GalaInternalUtils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GALA_TYPE_INTERNAL_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GALA_TYPE_INTERNAL_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gala_internal_utils_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gala_internal_utils_unref (old);
	}
}

void
gala_value_take_internal_utils (GValue* value,
                                gpointer v_object)
{
	GalaInternalUtils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GALA_TYPE_INTERNAL_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GALA_TYPE_INTERNAL_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gala_internal_utils_unref (old);
	}
}

static void
gala_internal_utils_class_init (GalaInternalUtilsClass * klass,
                                gpointer klass_data)
{
	gala_internal_utils_parent_class = g_type_class_peek_parent (klass);
	((GalaInternalUtilsClass *) klass)->finalize = gala_internal_utils_finalize;
}

static void
gala_internal_utils_instance_init (GalaInternalUtils * self,
                                   gpointer klass)
{
	self->ref_count = 1;
}

static void
gala_internal_utils_finalize (GalaInternalUtils * obj)
{
	GalaInternalUtils * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_INTERNAL_UTILS, GalaInternalUtils);
	g_signal_handlers_destroy (self);
}

static GType
gala_internal_utils_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { gala_value_internal_utils_init, gala_value_internal_utils_free_value, gala_value_internal_utils_copy_value, gala_value_internal_utils_peek_pointer, "p", gala_value_internal_utils_collect_value, "p", gala_value_internal_utils_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GalaInternalUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_internal_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaInternalUtils), 0, (GInstanceInitFunc) gala_internal_utils_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType gala_internal_utils_type_id;
	gala_internal_utils_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GalaInternalUtils", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return gala_internal_utils_type_id;
}

GType
gala_internal_utils_get_type (void)
{
	static volatile gsize gala_internal_utils_type_id__once = 0;
	if (g_once_init_enter (&gala_internal_utils_type_id__once)) {
		GType gala_internal_utils_type_id;
		gala_internal_utils_type_id = gala_internal_utils_get_type_once ();
		g_once_init_leave (&gala_internal_utils_type_id__once, gala_internal_utils_type_id);
	}
	return gala_internal_utils_type_id__once;
}

gpointer
gala_internal_utils_ref (gpointer instance)
{
	GalaInternalUtils * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
gala_internal_utils_unref (gpointer instance)
{
	GalaInternalUtils * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GALA_INTERNAL_UTILS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

