/* NotificationStack.c generated by valac 0.56.0, the Vala compiler
 * generated from NotificationStack.vala, do not modify */

/*
 * Copyright 2020 elementary, Inc (https://elementary.io)
 *           2014 Tom Beckmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <glib.h>
#include <meta/display.h>
#include <gee.h>
#include <meta/meta-window-actor.h>
#include <stdlib.h>
#include <string.h>
#include <clutter/clutter.h>
#include <meta/window.h>
#include <meta/boxes.h>
#include "gala.h"
#include <float.h>
#include <math.h>
#include <meta/meta-workspace-manager.h>
#include <meta/workspace.h>
#include <meta/meta-monitor-manager.h>

#define GALA_NOTIFICATION_STACK_TRANSITION_ENTRY_NAME "entry"
#define GALA_NOTIFICATION_STACK_TRANSITION_MOVE_STACK_ID "move-stack"
#define GALA_NOTIFICATION_STACK_TOP_OFFSET 2
#define GALA_NOTIFICATION_STACK_ADDITIONAL_MARGIN 12
#define GALA_NOTIFICATION_STACK_MARGIN 12
#define GALA_NOTIFICATION_STACK_WIDTH 300
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_NOTIFICATION_STACK (gala_notification_stack_get_type ())
#define GALA_NOTIFICATION_STACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_NOTIFICATION_STACK, GalaNotificationStack))
#define GALA_NOTIFICATION_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_NOTIFICATION_STACK, GalaNotificationStackClass))
#define GALA_IS_NOTIFICATION_STACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_NOTIFICATION_STACK))
#define GALA_IS_NOTIFICATION_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_NOTIFICATION_STACK))
#define GALA_NOTIFICATION_STACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_NOTIFICATION_STACK, GalaNotificationStackClass))

typedef struct _GalaNotificationStack GalaNotificationStack;
typedef struct _GalaNotificationStackClass GalaNotificationStackClass;
typedef struct _GalaNotificationStackPrivate GalaNotificationStackPrivate;
enum  {
	GALA_NOTIFICATION_STACK_0_PROPERTY,
	GALA_NOTIFICATION_STACK_DISPLAY_PROPERTY,
	GALA_NOTIFICATION_STACK_NUM_PROPERTIES
};
static GParamSpec* gala_notification_stack_properties[GALA_NOTIFICATION_STACK_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block4Data Block4Data;

struct _GalaNotificationStack {
	GObject parent_instance;
	GalaNotificationStackPrivate * priv;
};

struct _GalaNotificationStackClass {
	GObjectClass parent_class;
};

struct _GalaNotificationStackPrivate {
	gint stack_y;
	gint stack_width;
	MetaDisplay* _display;
	GeeArrayList* notifications;
};

struct _Block4Data {
	int _ref_count_;
	GalaNotificationStack* self;
	MetaWindowActor* notification;
};

static gint GalaNotificationStack_private_offset;
static gpointer gala_notification_stack_parent_class = NULL;

VALA_EXTERN GType gala_notification_stack_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaNotificationStack, g_object_unref)
VALA_EXTERN GalaNotificationStack* gala_notification_stack_new (MetaDisplay* display);
VALA_EXTERN GalaNotificationStack* gala_notification_stack_construct (GType object_type,
                                                          MetaDisplay* display);
VALA_EXTERN void gala_notification_stack_show_notification (GalaNotificationStack* self,
                                                MetaWindowActor* notification,
                                                gboolean animate);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void _vala_GValue_array_free (GValue * array,
                              gssize array_length);
static void ___lambda62_ (Block4Data* _data4_);
static void ____lambda62__clutter_actor_transitions_completed (ClutterActor* _sender,
                                                        gpointer self);
static void gala_notification_stack_update_positions (GalaNotificationStack* self,
                                               gboolean animate,
                                               gfloat add_y);
VALA_EXTERN MetaDisplay* gala_notification_stack_get_display (GalaNotificationStack* self);
static void gala_notification_stack_move_window (MetaWindowActor* actor,
                                          gint x,
                                          gint y);
static void gala_notification_stack_update_stack_allocation (GalaNotificationStack* self);
VALA_EXTERN void gala_notification_stack_destroy_notification (GalaNotificationStack* self,
                                                   MetaWindowActor* notification,
                                                   gboolean animate);
static void gala_notification_stack_set_display (GalaNotificationStack* self,
                                          MetaDisplay* value);
static GObject * gala_notification_stack_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void _gala_notification_stack_update_stack_allocation_meta_monitor_manager_monitors_changed_internal (MetaMonitorManager* _sender,
                                                                                                      gpointer self);
static void _gala_notification_stack_update_stack_allocation_meta_display_workareas_changed (MetaDisplay* _sender,
                                                                                      gpointer self);
static void gala_notification_stack_finalize (GObject * obj);
static GType gala_notification_stack_get_type_once (void);
static void _vala_gala_notification_stack_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_gala_notification_stack_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);

static inline gpointer
gala_notification_stack_get_instance_private (GalaNotificationStack* self)
{
	return G_STRUCT_MEMBER_P (self, GalaNotificationStack_private_offset);
}

GalaNotificationStack*
gala_notification_stack_construct (GType object_type,
                                   MetaDisplay* display)
{
	GalaNotificationStack * self = NULL;
	g_return_val_if_fail (display != NULL, NULL);
	self = (GalaNotificationStack*) g_object_new (object_type, "display", display, NULL);
	return self;
}

GalaNotificationStack*
gala_notification_stack_new (MetaDisplay* display)
{
	return gala_notification_stack_construct (GALA_TYPE_NOTIFICATION_STACK, display);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		GalaNotificationStack* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->notification);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
_vala_GValue_array_free (GValue * array,
                         gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			g_value_unset (&array[i]);
		}
	}
	g_free (array);
}

static void
___lambda62_ (Block4Data* _data4_)
{
	GalaNotificationStack* self;
	self = _data4_->self;
	clutter_actor_remove_all_transitions ((ClutterActor*) _data4_->notification);
}

static void
____lambda62__clutter_actor_transitions_completed (ClutterActor* _sender,
                                                   gpointer self)
{
	___lambda62_ (self);
}

void
gala_notification_stack_show_notification (GalaNotificationStack* self,
                                           MetaWindowActor* notification,
                                           gboolean animate)
{
	Block4Data* _data4_;
	MetaWindowActor* _tmp0_;
	MetaWindow* window = NULL;
	MetaWindow* _tmp1_;
	MetaRectangle window_rect = {0};
	MetaWindow* _tmp2_;
	MetaRectangle _tmp3_ = {0};
	MetaWindow* _tmp4_;
	gint scale = 0;
	MetaRectangle _tmp28_;
	gint primary = 0;
	MetaDisplay* _tmp29_;
	MetaRectangle area = {0};
	MetaDisplay* _tmp30_;
	MetaWorkspaceManager* _tmp31_;
	MetaWorkspace* _tmp32_;
	MetaRectangle _tmp33_ = {0};
	gint notification_x_pos = 0;
	MetaRectangle _tmp34_;
	MetaRectangle _tmp35_;
	MetaRectangle _tmp36_;
	GeeArrayList* _tmp37_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (notification != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (notification);
	_g_object_unref0 (_data4_->notification);
	_data4_->notification = _tmp0_;
	clutter_actor_set_pivot_point ((ClutterActor*) _data4_->notification, 0.5f, 0.5f);
	_tmp1_ = meta_window_actor_get_meta_window (_data4_->notification);
	window = _tmp1_;
	_tmp2_ = window;
	meta_window_get_frame_rect (_tmp2_, &_tmp3_);
	window_rect = _tmp3_;
	_tmp4_ = window;
	meta_window_stick (_tmp4_);
	scale = gala_utils_get_ui_scaling_factor ();
	if (animate) {
		ClutterPropertyTransition* opacity_transition = NULL;
		ClutterPropertyTransition* _tmp5_;
		ClutterPropertyTransition* _tmp6_;
		GValue _tmp7_ = {0};
		ClutterPropertyTransition* _tmp8_;
		GValue _tmp9_ = {0};
		ClutterKeyframeTransition* flip_transition = NULL;
		ClutterKeyframeTransition* _tmp10_;
		ClutterKeyframeTransition* _tmp11_;
		GValue _tmp12_ = {0};
		ClutterKeyframeTransition* _tmp13_;
		GValue _tmp14_ = {0};
		ClutterKeyframeTransition* _tmp15_;
		gdouble* _tmp16_;
		gdouble* _tmp17_;
		gint _tmp17__length1;
		ClutterKeyframeTransition* _tmp18_;
		GValue _tmp19_ = {0};
		GValue* _tmp20_;
		GValue* _tmp21_;
		gint _tmp21__length1;
		ClutterTransitionGroup* entry = NULL;
		ClutterTransitionGroup* _tmp22_ = NULL;
		ClutterTransitionGroup* _tmp23_;
		ClutterPropertyTransition* _tmp24_;
		ClutterTransitionGroup* _tmp25_;
		ClutterKeyframeTransition* _tmp26_;
		ClutterTransitionGroup* _tmp27_;
		_tmp5_ = (ClutterPropertyTransition*) clutter_property_transition_new ("opacity");
		opacity_transition = _tmp5_;
		_tmp6_ = opacity_transition;
		g_value_init (&_tmp7_, G_TYPE_INT);
		g_value_set_int (&_tmp7_, 0);
		clutter_transition_set_from_value ((ClutterTransition*) _tmp6_, &_tmp7_);
		G_IS_VALUE (&_tmp7_) ? (g_value_unset (&_tmp7_), NULL) : NULL;
		_tmp8_ = opacity_transition;
		g_value_init (&_tmp9_, G_TYPE_INT);
		g_value_set_int (&_tmp9_, 255);
		clutter_transition_set_to_value ((ClutterTransition*) _tmp8_, &_tmp9_);
		G_IS_VALUE (&_tmp9_) ? (g_value_unset (&_tmp9_), NULL) : NULL;
		_tmp10_ = (ClutterKeyframeTransition*) clutter_keyframe_transition_new ("rotation-angle-x");
		flip_transition = _tmp10_;
		_tmp11_ = flip_transition;
		g_value_init (&_tmp12_, G_TYPE_DOUBLE);
		g_value_set_double (&_tmp12_, 90.0);
		clutter_transition_set_from_value ((ClutterTransition*) _tmp11_, &_tmp12_);
		G_IS_VALUE (&_tmp12_) ? (g_value_unset (&_tmp12_), NULL) : NULL;
		_tmp13_ = flip_transition;
		g_value_init (&_tmp14_, G_TYPE_DOUBLE);
		g_value_set_double (&_tmp14_, 0.0);
		clutter_transition_set_to_value ((ClutterTransition*) _tmp13_, &_tmp14_);
		G_IS_VALUE (&_tmp14_) ? (g_value_unset (&_tmp14_), NULL) : NULL;
		_tmp15_ = flip_transition;
		_tmp16_ = g_new0 (gdouble, 1);
		_tmp16_[0] = 0.6;
		_tmp17_ = _tmp16_;
		_tmp17__length1 = 1;
		clutter_keyframe_transition_set_key_frames (_tmp15_, (guint) 1, _tmp17_);
		_tmp17_ = (g_free (_tmp17_), NULL);
		_tmp18_ = flip_transition;
		g_value_init (&_tmp19_, G_TYPE_DOUBLE);
		g_value_set_double (&_tmp19_, -10.0);
		_tmp20_ = g_new0 (GValue, 1);
		_tmp20_[0] = _tmp19_;
		_tmp21_ = _tmp20_;
		_tmp21__length1 = 1;
		clutter_keyframe_transition_set_values (_tmp18_, (guint) 1, _tmp21_);
		_tmp21_ = (_vala_GValue_array_free (_tmp21_, _tmp21__length1), NULL);
		_tmp22_ = (ClutterTransitionGroup*) clutter_transition_group_new ();
		clutter_timeline_set_duration ((ClutterTimeline*) _tmp22_, (guint) 400);
		entry = _tmp22_;
		_tmp23_ = entry;
		_tmp24_ = opacity_transition;
		clutter_transition_group_add_transition (_tmp23_, (ClutterTransition*) _tmp24_);
		_tmp25_ = entry;
		_tmp26_ = flip_transition;
		clutter_transition_group_add_transition (_tmp25_, (ClutterTransition*) _tmp26_);
		g_signal_connect_data ((ClutterActor*) _data4_->notification, "transitions-completed", (GCallback) ____lambda62__clutter_actor_transitions_completed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
		_tmp27_ = entry;
		clutter_actor_add_transition ((ClutterActor*) _data4_->notification, GALA_NOTIFICATION_STACK_TRANSITION_ENTRY_NAME, (ClutterTransition*) _tmp27_);
		_g_object_unref0 (entry);
		_g_object_unref0 (flip_transition);
		_g_object_unref0 (opacity_transition);
	}
	_tmp28_ = window_rect;
	gala_notification_stack_update_positions (self, animate, (gfloat) _tmp28_.height);
	_tmp29_ = self->priv->_display;
	primary = meta_display_get_primary_monitor (_tmp29_);
	_tmp30_ = self->priv->_display;
	_tmp31_ = meta_display_get_workspace_manager (_tmp30_);
	_tmp32_ = meta_workspace_manager_get_active_workspace (_tmp31_);
	meta_workspace_get_work_area_for_monitor (_tmp32_, primary, &_tmp33_);
	area = _tmp33_;
	_tmp34_ = area;
	_tmp35_ = area;
	_tmp36_ = window_rect;
	notification_x_pos = (_tmp34_.x + _tmp35_.width) - _tmp36_.width;
	gala_notification_stack_move_window (_data4_->notification, notification_x_pos, (self->priv->stack_y + GALA_NOTIFICATION_STACK_TOP_OFFSET) + (GALA_NOTIFICATION_STACK_ADDITIONAL_MARGIN * scale));
	_tmp37_ = self->priv->notifications;
	gee_abstract_list_insert ((GeeAbstractList*) _tmp37_, 0, _data4_->notification);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
gala_notification_stack_update_stack_allocation (GalaNotificationStack* self)
{
	gint primary = 0;
	MetaDisplay* _tmp0_;
	MetaRectangle area = {0};
	MetaDisplay* _tmp1_;
	MetaWorkspaceManager* _tmp2_;
	MetaWorkspace* _tmp3_;
	MetaRectangle _tmp4_ = {0};
	gint scale = 0;
	MetaRectangle _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_display;
	primary = meta_display_get_primary_monitor (_tmp0_);
	_tmp1_ = self->priv->_display;
	_tmp2_ = meta_display_get_workspace_manager (_tmp1_);
	_tmp3_ = meta_workspace_manager_get_active_workspace (_tmp2_);
	meta_workspace_get_work_area_for_monitor (_tmp3_, primary, &_tmp4_);
	area = _tmp4_;
	scale = gala_utils_get_ui_scaling_factor ();
	self->priv->stack_width = (GALA_NOTIFICATION_STACK_WIDTH + GALA_NOTIFICATION_STACK_MARGIN) * scale;
	_tmp5_ = area;
	self->priv->stack_y = _tmp5_.y;
}

static void
gala_notification_stack_update_positions (GalaNotificationStack* self,
                                          gboolean animate,
                                          gfloat add_y)
{
	gint scale = 0;
	gfloat y = 0.0F;
	gint i = 0;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_ = 0;
	gint delay_step = 0;
	g_return_if_fail (self != NULL);
	scale = gala_utils_get_ui_scaling_factor ();
	y = ((self->priv->stack_y + GALA_NOTIFICATION_STACK_TOP_OFFSET) + add_y) + (GALA_NOTIFICATION_STACK_ADDITIONAL_MARGIN * scale);
	_tmp0_ = self->priv->notifications;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	i = _tmp2_;
	if (i > 0) {
		_tmp3_ = 150 / i;
	} else {
		_tmp3_ = 0;
	}
	delay_step = _tmp3_;
	{
		GeeArrayList* _actor_list = NULL;
		GeeArrayList* _tmp4_;
		gint _actor_size = 0;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _actor_index = 0;
		_tmp4_ = self->priv->notifications;
		_actor_list = _tmp4_;
		_tmp5_ = _actor_list;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_actor_size = _tmp7_;
		_actor_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			MetaWindowActor* actor = NULL;
			GeeArrayList* _tmp10_;
			gpointer _tmp11_;
			MetaWindowActor* _tmp12_;
			MetaWindowActor* _tmp19_;
			ClutterTransition* transition = NULL;
			MetaWindowActor* _tmp21_;
			ClutterTransition* _tmp22_;
			MetaWindowActor* _tmp23_;
			ClutterTransition* _tmp24_;
			ClutterTransition* _tmp25_;
			MetaWindow* window = NULL;
			MetaWindowActor* _tmp26_;
			MetaWindow* _tmp27_;
			MetaWindow* _tmp28_;
			MetaRectangle _tmp29_ = {0};
			_actor_index = _actor_index + 1;
			_tmp8_ = _actor_index;
			_tmp9_ = _actor_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _actor_list;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _actor_index);
			_tmp12_ = _g_object_ref0 ((MetaWindowActor*) _tmp11_);
			actor = _tmp12_;
			if (animate) {
				MetaWindowActor* _tmp13_;
				MetaWindowActor* _tmp14_;
				MetaWindowActor* _tmp15_;
				MetaWindowActor* _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				_tmp13_ = actor;
				clutter_actor_save_easing_state ((ClutterActor*) _tmp13_);
				_tmp14_ = actor;
				clutter_actor_set_easing_mode ((ClutterActor*) _tmp14_, CLUTTER_EASE_OUT_BACK);
				_tmp15_ = actor;
				clutter_actor_set_easing_duration ((ClutterActor*) _tmp15_, (guint) 200);
				_tmp16_ = actor;
				_tmp17_ = i;
				i = _tmp17_ - 1;
				_tmp18_ = delay_step;
				clutter_actor_set_easing_delay ((ClutterActor*) _tmp16_, (guint) (_tmp17_ * _tmp18_));
			}
			_tmp19_ = actor;
			gala_notification_stack_move_window (_tmp19_, -1, (gint) y);
			if (animate) {
				MetaWindowActor* _tmp20_;
				_tmp20_ = actor;
				clutter_actor_restore_easing_state ((ClutterActor*) _tmp20_);
			}
			_tmp21_ = actor;
			_tmp22_ = clutter_actor_get_transition ((ClutterActor*) _tmp21_, "position");
			transition = _tmp22_;
			_tmp23_ = actor;
			_tmp24_ = transition;
			_tmp25_ = _g_object_ref0 (_tmp24_);
			g_object_set_data_full ((GObject*) _tmp23_, GALA_NOTIFICATION_STACK_TRANSITION_MOVE_STACK_ID, _tmp25_, g_object_unref);
			_tmp26_ = actor;
			_tmp27_ = meta_window_actor_get_meta_window (_tmp26_);
			window = _tmp27_;
			_tmp28_ = window;
			meta_window_get_frame_rect (_tmp28_, &_tmp29_);
			y += (gfloat) _tmp29_.height;
			_g_object_unref0 (actor);
		}
	}
}

void
gala_notification_stack_destroy_notification (GalaNotificationStack* self,
                                              MetaWindowActor* notification,
                                              gboolean animate)
{
	GeeArrayList* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (notification != NULL);
	if (animate) {
		gfloat _tmp0_;
		gfloat _tmp1_;
		clutter_actor_save_easing_state ((ClutterActor*) notification);
		clutter_actor_set_easing_duration ((ClutterActor*) notification, (guint) 100);
		clutter_actor_set_easing_mode ((ClutterActor*) notification, CLUTTER_EASE_IN_QUAD);
		clutter_actor_set_opacity ((ClutterActor*) notification, (guint) 0);
		_tmp0_ = clutter_actor_get_x ((ClutterActor*) notification);
		_tmp1_ = _tmp0_;
		clutter_actor_set_x ((ClutterActor*) notification, _tmp1_ + self->priv->stack_width);
		clutter_actor_restore_easing_state ((ClutterActor*) notification);
	} else {
		gfloat _tmp2_;
		gfloat _tmp3_;
		clutter_actor_set_opacity ((ClutterActor*) notification, (guint) 0);
		_tmp2_ = clutter_actor_get_x ((ClutterActor*) notification);
		_tmp3_ = _tmp2_;
		clutter_actor_set_x ((ClutterActor*) notification, _tmp3_ + self->priv->stack_width);
	}
	_tmp4_ = self->priv->notifications;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp4_, notification);
	gala_notification_stack_update_positions (self, animate, 0.0f);
}

/**
     * This function takes care of properly updating both the actor
     * position and the actual window position.
     *
     * To enable animations for a window we first need to move it's frame
     * in the compositor and then calculate & apply the coordinates for the window
     * actor.
     */
static void
gala_notification_stack_move_window (MetaWindowActor* actor,
                                     gint x,
                                     gint y)
{
	MetaWindow* window = NULL;
	MetaWindow* _tmp0_;
	MetaWindow* _tmp1_;
	MetaRectangle rect = {0};
	MetaWindow* _tmp2_;
	MetaRectangle _tmp3_ = {0};
	gint _tmp4_ = 0;
	gint _tmp6_ = 0;
	MetaWindow* _tmp8_;
	MetaWindow* _tmp9_;
	MetaRectangle _tmp10_ = {0};
	MetaRectangle _tmp11_;
	gfloat _tmp12_;
	gfloat _tmp13_;
	MetaRectangle _tmp14_;
	MetaRectangle _tmp15_;
	gfloat _tmp16_;
	gfloat _tmp17_;
	MetaRectangle _tmp18_;
	g_return_if_fail (actor != NULL);
	if (meta_window_actor_is_destroyed (actor)) {
		return;
	}
	_tmp0_ = meta_window_actor_get_meta_window (actor);
	window = _tmp0_;
	_tmp1_ = window;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = window;
	meta_window_get_frame_rect (_tmp2_, &_tmp3_);
	rect = _tmp3_;
	if (x != -1) {
		_tmp4_ = x;
	} else {
		MetaRectangle _tmp5_;
		_tmp5_ = rect;
		_tmp4_ = _tmp5_.x;
	}
	if (y != -1) {
		_tmp6_ = y;
	} else {
		MetaRectangle _tmp7_;
		_tmp7_ = rect;
		_tmp6_ = _tmp7_.y;
	}
	_tmp8_ = window;
	meta_window_move_frame (_tmp8_, FALSE, _tmp4_, _tmp6_);
	_tmp9_ = window;
	meta_window_get_buffer_rect (_tmp9_, &_tmp10_);
	rect = _tmp10_;
	_tmp11_ = rect;
	_tmp12_ = clutter_actor_get_width ((ClutterActor*) actor);
	_tmp13_ = _tmp12_;
	_tmp14_ = rect;
	_tmp15_ = rect;
	_tmp16_ = clutter_actor_get_height ((ClutterActor*) actor);
	_tmp17_ = _tmp16_;
	_tmp18_ = rect;
	clutter_actor_set_position ((ClutterActor*) actor, _tmp11_.x - ((_tmp13_ - _tmp14_.width) / 2), _tmp15_.y - ((_tmp17_ - _tmp18_.height) / 2));
}

MetaDisplay*
gala_notification_stack_get_display (GalaNotificationStack* self)
{
	MetaDisplay* result;
	MetaDisplay* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	result = _tmp0_;
	return result;
}

static void
gala_notification_stack_set_display (GalaNotificationStack* self,
                                     MetaDisplay* value)
{
	MetaDisplay* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_notification_stack_get_display (self);
	if (old_value != value) {
		MetaDisplay* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_display);
		self->priv->_display = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_notification_stack_properties[GALA_NOTIFICATION_STACK_DISPLAY_PROPERTY]);
	}
}

static void
_gala_notification_stack_update_stack_allocation_meta_monitor_manager_monitors_changed_internal (MetaMonitorManager* _sender,
                                                                                                 gpointer self)
{
	gala_notification_stack_update_stack_allocation ((GalaNotificationStack*) self);
}

static void
_gala_notification_stack_update_stack_allocation_meta_display_workareas_changed (MetaDisplay* _sender,
                                                                                 gpointer self)
{
	gala_notification_stack_update_stack_allocation ((GalaNotificationStack*) self);
}

static GObject *
gala_notification_stack_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaNotificationStack * self;
	GeeArrayList* _tmp0_;
	MetaMonitorManager* _tmp1_;
	MetaDisplay* _tmp2_;
	parent_class = G_OBJECT_CLASS (gala_notification_stack_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_NOTIFICATION_STACK, GalaNotificationStack);
	_tmp0_ = gee_array_list_new (meta_window_actor_get_type (), NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->notifications);
	self->priv->notifications = _tmp0_;
	_tmp1_ = meta_monitor_manager_get ();
	g_signal_connect_object (_tmp1_, "monitors-changed-internal", (GCallback) _gala_notification_stack_update_stack_allocation_meta_monitor_manager_monitors_changed_internal, self, 0);
	_tmp2_ = self->priv->_display;
	g_signal_connect_object (_tmp2_, "workareas-changed", (GCallback) _gala_notification_stack_update_stack_allocation_meta_display_workareas_changed, self, 0);
	gala_notification_stack_update_stack_allocation (self);
	return obj;
}

static void
gala_notification_stack_class_init (GalaNotificationStackClass * klass,
                                    gpointer klass_data)
{
	gala_notification_stack_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaNotificationStack_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_notification_stack_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_notification_stack_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_notification_stack_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_notification_stack_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_NOTIFICATION_STACK_DISPLAY_PROPERTY, gala_notification_stack_properties[GALA_NOTIFICATION_STACK_DISPLAY_PROPERTY] = g_param_spec_object ("display", "display", "display", meta_display_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
gala_notification_stack_instance_init (GalaNotificationStack * self,
                                       gpointer klass)
{
	self->priv = gala_notification_stack_get_instance_private (self);
}

static void
gala_notification_stack_finalize (GObject * obj)
{
	GalaNotificationStack * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_NOTIFICATION_STACK, GalaNotificationStack);
	_g_object_unref0 (self->priv->_display);
	_g_object_unref0 (self->priv->notifications);
	G_OBJECT_CLASS (gala_notification_stack_parent_class)->finalize (obj);
}

static GType
gala_notification_stack_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaNotificationStackClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_notification_stack_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaNotificationStack), 0, (GInstanceInitFunc) gala_notification_stack_instance_init, NULL };
	GType gala_notification_stack_type_id;
	gala_notification_stack_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaNotificationStack", &g_define_type_info, 0);
	GalaNotificationStack_private_offset = g_type_add_instance_private (gala_notification_stack_type_id, sizeof (GalaNotificationStackPrivate));
	return gala_notification_stack_type_id;
}

GType
gala_notification_stack_get_type (void)
{
	static volatile gsize gala_notification_stack_type_id__once = 0;
	if (g_once_init_enter (&gala_notification_stack_type_id__once)) {
		GType gala_notification_stack_type_id;
		gala_notification_stack_type_id = gala_notification_stack_get_type_once ();
		g_once_init_leave (&gala_notification_stack_type_id__once, gala_notification_stack_type_id);
	}
	return gala_notification_stack_type_id__once;
}

static void
_vala_gala_notification_stack_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	GalaNotificationStack * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_NOTIFICATION_STACK, GalaNotificationStack);
	switch (property_id) {
		case GALA_NOTIFICATION_STACK_DISPLAY_PROPERTY:
		g_value_set_object (value, gala_notification_stack_get_display (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_notification_stack_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	GalaNotificationStack * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_NOTIFICATION_STACK, GalaNotificationStack);
	switch (property_id) {
		case GALA_NOTIFICATION_STACK_DISPLAY_PROPERTY:
		gala_notification_stack_set_display (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

