/* SafeWindowClone.c generated by valac 0.56.0, the Vala compiler
 * generated from SafeWindowClone.vala, do not modify */

/**/
/*  Copyright (C) 2014 Tom Beckmann*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <clutter/clutter.h>
#include <glib-object.h>
#include <meta/window.h>
#include <glib.h>
#include <meta/meta-window-actor.h>
#include <string.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_SAFE_WINDOW_CLONE (gala_safe_window_clone_get_type ())
#define GALA_SAFE_WINDOW_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_SAFE_WINDOW_CLONE, GalaSafeWindowClone))
#define GALA_SAFE_WINDOW_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_SAFE_WINDOW_CLONE, GalaSafeWindowCloneClass))
#define GALA_IS_SAFE_WINDOW_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_SAFE_WINDOW_CLONE))
#define GALA_IS_SAFE_WINDOW_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_SAFE_WINDOW_CLONE))
#define GALA_SAFE_WINDOW_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_SAFE_WINDOW_CLONE, GalaSafeWindowCloneClass))

typedef struct _GalaSafeWindowClone GalaSafeWindowClone;
typedef struct _GalaSafeWindowCloneClass GalaSafeWindowCloneClass;
typedef struct _GalaSafeWindowClonePrivate GalaSafeWindowClonePrivate;
enum  {
	GALA_SAFE_WINDOW_CLONE_0_PROPERTY,
	GALA_SAFE_WINDOW_CLONE_WINDOW_PROPERTY,
	GALA_SAFE_WINDOW_CLONE_DESTROY_ON_UNMANAGED_PROPERTY,
	GALA_SAFE_WINDOW_CLONE_NUM_PROPERTIES
};
static GParamSpec* gala_safe_window_clone_properties[GALA_SAFE_WINDOW_CLONE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GalaSafeWindowClone {
	ClutterClone parent_instance;
	GalaSafeWindowClonePrivate * priv;
};

struct _GalaSafeWindowCloneClass {
	ClutterCloneClass parent_class;
};

struct _GalaSafeWindowClonePrivate {
	MetaWindow* _window;
	gboolean _destroy_on_unmanaged;
};

static gint GalaSafeWindowClone_private_offset;
static gpointer gala_safe_window_clone_parent_class = NULL;

VALA_EXTERN GType gala_safe_window_clone_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaSafeWindowClone, g_object_unref)
VALA_EXTERN MetaWindow* gala_safe_window_clone_get_window (GalaSafeWindowClone* self);
static void gala_safe_window_clone_reset_source (GalaSafeWindowClone* self);
static void _gala_safe_window_clone_reset_source_meta_window_unmanaged (MetaWindow* _sender,
                                                                 gpointer self);
VALA_EXTERN GalaSafeWindowClone* gala_safe_window_clone_new (MetaWindow* window,
                                                 gboolean destroy_on_unmanaged);
VALA_EXTERN GalaSafeWindowClone* gala_safe_window_clone_construct (GType object_type,
                                                       MetaWindow* window,
                                                       gboolean destroy_on_unmanaged);
VALA_EXTERN gboolean gala_safe_window_clone_get_destroy_on_unmanaged (GalaSafeWindowClone* self);
static void gala_safe_window_clone_set_window (GalaSafeWindowClone* self,
                                        MetaWindow* value);
VALA_EXTERN void gala_safe_window_clone_set_destroy_on_unmanaged (GalaSafeWindowClone* self,
                                                      gboolean value);
static GObject * gala_safe_window_clone_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void gala_safe_window_clone_finalize (GObject * obj);
static GType gala_safe_window_clone_get_type_once (void);
static void _vala_gala_safe_window_clone_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_gala_safe_window_clone_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gala_safe_window_clone_get_instance_private (GalaSafeWindowClone* self)
{
	return G_STRUCT_MEMBER_P (self, GalaSafeWindowClone_private_offset);
}

static void
_gala_safe_window_clone_reset_source_meta_window_unmanaged (MetaWindow* _sender,
                                                            gpointer self)
{
	gala_safe_window_clone_reset_source ((GalaSafeWindowClone*) self);
}

/**
         * Creates a new SafeWindowClone
         *
         * @param window               The window to clone from
         * @param destroy_on_unmanaged see destroy_on_unmanaged property
         */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GalaSafeWindowClone*
gala_safe_window_clone_construct (GType object_type,
                                  MetaWindow* window,
                                  gboolean destroy_on_unmanaged)
{
	GalaSafeWindowClone * self = NULL;
	MetaWindowActor* actor = NULL;
	GObject* _tmp0_;
	MetaWindowActor* _tmp1_;
	g_return_val_if_fail (window != NULL, NULL);
	_tmp0_ = meta_window_get_compositor_private (window);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, meta_window_actor_get_type (), MetaWindowActor));
	actor = _tmp1_;
	self = (GalaSafeWindowClone*) g_object_new (object_type, "window", window, "source", actor, "destroy-on-unmanaged", destroy_on_unmanaged, NULL);
	_g_object_unref0 (actor);
	return self;
}

GalaSafeWindowClone*
gala_safe_window_clone_new (MetaWindow* window,
                            gboolean destroy_on_unmanaged)
{
	return gala_safe_window_clone_construct (GALA_TYPE_SAFE_WINDOW_CLONE, window, destroy_on_unmanaged);
}

static void
gala_safe_window_clone_reset_source (GalaSafeWindowClone* self)
{
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	clutter_clone_set_source ((ClutterClone*) self, NULL);
	_tmp0_ = self->priv->_destroy_on_unmanaged;
	if (_tmp0_) {
		clutter_actor_destroy ((ClutterActor*) self);
	}
}

MetaWindow*
gala_safe_window_clone_get_window (GalaSafeWindowClone* self)
{
	MetaWindow* result;
	MetaWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window;
	result = _tmp0_;
	return result;
}

static void
gala_safe_window_clone_set_window (GalaSafeWindowClone* self,
                                   MetaWindow* value)
{
	MetaWindow* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_safe_window_clone_get_window (self);
	if (old_value != value) {
		MetaWindow* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_window);
		self->priv->_window = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_safe_window_clone_properties[GALA_SAFE_WINDOW_CLONE_WINDOW_PROPERTY]);
	}
}

gboolean
gala_safe_window_clone_get_destroy_on_unmanaged (GalaSafeWindowClone* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_destroy_on_unmanaged;
	return result;
}

void
gala_safe_window_clone_set_destroy_on_unmanaged (GalaSafeWindowClone* self,
                                                 gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_safe_window_clone_get_destroy_on_unmanaged (self);
	if (old_value != value) {
		self->priv->_destroy_on_unmanaged = value;
		g_object_notify_by_pspec ((GObject *) self, gala_safe_window_clone_properties[GALA_SAFE_WINDOW_CLONE_DESTROY_ON_UNMANAGED_PROPERTY]);
	}
}

static GObject *
gala_safe_window_clone_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaSafeWindowClone * self;
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	parent_class = G_OBJECT_CLASS (gala_safe_window_clone_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_SAFE_WINDOW_CLONE, GalaSafeWindowClone);
	_tmp0_ = clutter_clone_get_source ((ClutterClone*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		MetaWindow* _tmp2_;
		_tmp2_ = self->priv->_window;
		g_signal_connect_object (_tmp2_, "unmanaged", (GCallback) _gala_safe_window_clone_reset_source_meta_window_unmanaged, self, 0);
	}
	return obj;
}

static void
gala_safe_window_clone_class_init (GalaSafeWindowCloneClass * klass,
                                   gpointer klass_data)
{
	gala_safe_window_clone_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaSafeWindowClone_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_safe_window_clone_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_safe_window_clone_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_safe_window_clone_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_safe_window_clone_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_SAFE_WINDOW_CLONE_WINDOW_PROPERTY, gala_safe_window_clone_properties[GALA_SAFE_WINDOW_CLONE_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", meta_window_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	         * If set to true, the SafeWindowClone will destroy itself when the connected
	         * window is unmanaged
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_SAFE_WINDOW_CLONE_DESTROY_ON_UNMANAGED_PROPERTY, gala_safe_window_clone_properties[GALA_SAFE_WINDOW_CLONE_DESTROY_ON_UNMANAGED_PROPERTY] = g_param_spec_boolean ("destroy-on-unmanaged", "destroy-on-unmanaged", "destroy-on-unmanaged", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
gala_safe_window_clone_instance_init (GalaSafeWindowClone * self,
                                      gpointer klass)
{
	self->priv = gala_safe_window_clone_get_instance_private (self);
	self->priv->_destroy_on_unmanaged = FALSE;
}

static void
gala_safe_window_clone_finalize (GObject * obj)
{
	GalaSafeWindowClone * self;
	MetaWindow* _tmp0_;
	guint _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_SAFE_WINDOW_CLONE, GalaSafeWindowClone);
	_tmp0_ = self->priv->_window;
	g_signal_parse_name ("unmanaged", meta_window_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _gala_safe_window_clone_reset_source_meta_window_unmanaged, self);
	_g_object_unref0 (self->priv->_window);
	G_OBJECT_CLASS (gala_safe_window_clone_parent_class)->finalize (obj);
}

/**
     * A clone for a MetaWindowActor that will guard against the
     * meta_window_appears_focused crash by disabling painting the clone
     * as soon as it gets unavailable.
     */
static GType
gala_safe_window_clone_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaSafeWindowCloneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_safe_window_clone_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaSafeWindowClone), 0, (GInstanceInitFunc) gala_safe_window_clone_instance_init, NULL };
	GType gala_safe_window_clone_type_id;
	gala_safe_window_clone_type_id = g_type_register_static (clutter_clone_get_type (), "GalaSafeWindowClone", &g_define_type_info, 0);
	GalaSafeWindowClone_private_offset = g_type_add_instance_private (gala_safe_window_clone_type_id, sizeof (GalaSafeWindowClonePrivate));
	return gala_safe_window_clone_type_id;
}

GType
gala_safe_window_clone_get_type (void)
{
	static volatile gsize gala_safe_window_clone_type_id__once = 0;
	if (g_once_init_enter (&gala_safe_window_clone_type_id__once)) {
		GType gala_safe_window_clone_type_id;
		gala_safe_window_clone_type_id = gala_safe_window_clone_get_type_once ();
		g_once_init_leave (&gala_safe_window_clone_type_id__once, gala_safe_window_clone_type_id);
	}
	return gala_safe_window_clone_type_id__once;
}

static void
_vala_gala_safe_window_clone_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	GalaSafeWindowClone * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_SAFE_WINDOW_CLONE, GalaSafeWindowClone);
	switch (property_id) {
		case GALA_SAFE_WINDOW_CLONE_WINDOW_PROPERTY:
		g_value_set_object (value, gala_safe_window_clone_get_window (self));
		break;
		case GALA_SAFE_WINDOW_CLONE_DESTROY_ON_UNMANAGED_PROPERTY:
		g_value_set_boolean (value, gala_safe_window_clone_get_destroy_on_unmanaged (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_safe_window_clone_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	GalaSafeWindowClone * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_SAFE_WINDOW_CLONE, GalaSafeWindowClone);
	switch (property_id) {
		case GALA_SAFE_WINDOW_CLONE_WINDOW_PROPERTY:
		gala_safe_window_clone_set_window (self, g_value_get_object (value));
		break;
		case GALA_SAFE_WINDOW_CLONE_DESTROY_ON_UNMANAGED_PROPERTY:
		gala_safe_window_clone_set_destroy_on_unmanaged (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

