/* ScreenShield.c generated by valac 0.56.0, the Vala compiler
 * generated from ScreenShield.vala, do not modify */

/**/
/*  Copyright 2020 elementary, Inc. (https://elementary.io)*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gunixinputstream.h>
#include <gio/gunixfdlist.h>
#include <clutter/clutter.h>
#include "gala.h"
#include <meta/meta-plugin.h>
#include <meta/display.h>
#include <float.h>
#include <math.h>
#include <meta/meta-cursor-tracker.h>

#define GALA_SCREEN_SHIELD_LONG_ANIMATION_TIME ((guint) 3000)
#define GALA_SCREEN_SHIELD_SHORT_ANIMATION_TIME ((guint) 300)
#define GALA_SCREEN_SHIELD_LOCK_ENABLED_KEY "lock-enabled"
#define GALA_SCREEN_SHIELD_LOCK_PROHIBITED_KEY "disable-lock-screen"
#define GALA_SCREEN_SHIELD_LOCK_ON_SUSPEND_KEY "lock-on-suspend"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_LOGIN_MANAGER (gala_login_manager_get_type ())
#define GALA_LOGIN_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_LOGIN_MANAGER, GalaLoginManager))
#define GALA_IS_LOGIN_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_LOGIN_MANAGER))
#define GALA_LOGIN_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_TYPE_LOGIN_MANAGER, GalaLoginManagerIface))

typedef struct _GalaLoginManager GalaLoginManager;
typedef struct _GalaLoginManagerIface GalaLoginManagerIface;

#define GALA_TYPE_LOGIN_MANAGER_PROXY (gala_login_manager_proxy_get_type ())
enum  {
	GALA_LOGIN_MANAGER_PREPARE_FOR_SLEEP_SIGNAL,
	GALA_LOGIN_MANAGER_NUM_SIGNALS
};
static guint gala_login_manager_signals[GALA_LOGIN_MANAGER_NUM_SIGNALS] = {0};
typedef GDBusProxy GalaLoginManagerProxy;
typedef GDBusProxyClass GalaLoginManagerProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GALA_TYPE_LOGIN_SESSION_MANAGER (gala_login_session_manager_get_type ())
#define GALA_LOGIN_SESSION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_LOGIN_SESSION_MANAGER, GalaLoginSessionManager))
#define GALA_IS_LOGIN_SESSION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_LOGIN_SESSION_MANAGER))
#define GALA_LOGIN_SESSION_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_TYPE_LOGIN_SESSION_MANAGER, GalaLoginSessionManagerIface))

typedef struct _GalaLoginSessionManager GalaLoginSessionManager;
typedef struct _GalaLoginSessionManagerIface GalaLoginSessionManagerIface;

#define GALA_TYPE_LOGIN_SESSION_MANAGER_PROXY (gala_login_session_manager_proxy_get_type ())
enum  {
	GALA_LOGIN_SESSION_MANAGER_LOCK_SIGNAL,
	GALA_LOGIN_SESSION_MANAGER_UNLOCK_SIGNAL,
	GALA_LOGIN_SESSION_MANAGER_NUM_SIGNALS
};
static guint gala_login_session_manager_signals[GALA_LOGIN_SESSION_MANAGER_NUM_SIGNALS] = {0};
typedef GDBusProxy GalaLoginSessionManagerProxy;
typedef GDBusProxyClass GalaLoginSessionManagerProxyClass;

#define GALA_TYPE_LOGIN_DISPLAY (gala_login_display_get_type ())
typedef struct _GalaLoginDisplay GalaLoginDisplay;

#define GALA_TYPE_LOGIN_USER_MANAGER (gala_login_user_manager_get_type ())
#define GALA_LOGIN_USER_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_LOGIN_USER_MANAGER, GalaLoginUserManager))
#define GALA_IS_LOGIN_USER_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_LOGIN_USER_MANAGER))
#define GALA_LOGIN_USER_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_TYPE_LOGIN_USER_MANAGER, GalaLoginUserManagerIface))

typedef struct _GalaLoginUserManager GalaLoginUserManager;
typedef struct _GalaLoginUserManagerIface GalaLoginUserManagerIface;

#define GALA_TYPE_LOGIN_USER_MANAGER_PROXY (gala_login_user_manager_proxy_get_type ())
typedef GDBusProxy GalaLoginUserManagerProxy;
typedef GDBusProxyClass GalaLoginUserManagerProxyClass;
#define _gala_login_display_free0(var) ((var == NULL) ? NULL : (var = (gala_login_display_free (var), NULL)))
typedef enum  {
	GALA_PRESENCE_STATUS_AVAILABLE = 0,
	GALA_PRESENCE_STATUS_INVISIBLE = 1,
	GALA_PRESENCE_STATUS_BUSY = 2,
	GALA_PRESENCE_STATUS_IDLE = 3
} GalaPresenceStatus;

#define GALA_TYPE_PRESENCE_STATUS (gala_presence_status_get_type ())

#define GALA_TYPE_SESSION_PRESENCE (gala_session_presence_get_type ())
#define GALA_SESSION_PRESENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_SESSION_PRESENCE, GalaSessionPresence))
#define GALA_IS_SESSION_PRESENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_SESSION_PRESENCE))
#define GALA_SESSION_PRESENCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_TYPE_SESSION_PRESENCE, GalaSessionPresenceIface))

typedef struct _GalaSessionPresence GalaSessionPresence;
typedef struct _GalaSessionPresenceIface GalaSessionPresenceIface;

#define GALA_TYPE_SESSION_PRESENCE_PROXY (gala_session_presence_proxy_get_type ())
enum  {
	GALA_SESSION_PRESENCE_STATUS_CHANGED_SIGNAL,
	GALA_SESSION_PRESENCE_NUM_SIGNALS
};
static guint gala_session_presence_signals[GALA_SESSION_PRESENCE_NUM_SIGNALS] = {0};
typedef GDBusProxy GalaSessionPresenceProxy;
typedef GDBusProxyClass GalaSessionPresenceProxyClass;

#define GALA_TYPE_DISPLAY_MANAGER_SEAT (gala_display_manager_seat_get_type ())
#define GALA_DISPLAY_MANAGER_SEAT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_DISPLAY_MANAGER_SEAT, GalaDisplayManagerSeat))
#define GALA_IS_DISPLAY_MANAGER_SEAT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_DISPLAY_MANAGER_SEAT))
#define GALA_DISPLAY_MANAGER_SEAT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_TYPE_DISPLAY_MANAGER_SEAT, GalaDisplayManagerSeatIface))

typedef struct _GalaDisplayManagerSeat GalaDisplayManagerSeat;
typedef struct _GalaDisplayManagerSeatIface GalaDisplayManagerSeatIface;

#define GALA_TYPE_DISPLAY_MANAGER_SEAT_PROXY (gala_display_manager_seat_proxy_get_type ())
typedef GDBusProxy GalaDisplayManagerSeatProxy;
typedef GDBusProxyClass GalaDisplayManagerSeatProxyClass;

#define GALA_TYPE_SCREEN_SHIELD (gala_screen_shield_get_type ())
#define GALA_SCREEN_SHIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_SCREEN_SHIELD, GalaScreenShield))
#define GALA_SCREEN_SHIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_SCREEN_SHIELD, GalaScreenShieldClass))
#define GALA_IS_SCREEN_SHIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_SCREEN_SHIELD))
#define GALA_IS_SCREEN_SHIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_SCREEN_SHIELD))
#define GALA_SCREEN_SHIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_SCREEN_SHIELD, GalaScreenShieldClass))

typedef struct _GalaScreenShield GalaScreenShield;
typedef struct _GalaScreenShieldClass GalaScreenShieldClass;
typedef struct _GalaScreenShieldPrivate GalaScreenShieldPrivate;
enum  {
	GALA_SCREEN_SHIELD_0_PROPERTY,
	GALA_SCREEN_SHIELD_ACTIVE_PROPERTY,
	GALA_SCREEN_SHIELD_IS_LOCKED_PROPERTY,
	GALA_SCREEN_SHIELD_IN_GREETER_PROPERTY,
	GALA_SCREEN_SHIELD_ACTIVATION_TIME_PROPERTY,
	GALA_SCREEN_SHIELD_WM_PROPERTY,
	GALA_SCREEN_SHIELD_NUM_PROPERTIES
};
static GParamSpec* gala_screen_shield_properties[GALA_SCREEN_SHIELD_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GalaScreenShieldInitDbusInterfacesData GalaScreenShieldInitDbusInterfacesData;
#define __vala_ClutterColor_free0(var) ((var == NULL) ? NULL : (var = (_vala_ClutterColor_free (var), NULL)))
enum  {
	GALA_SCREEN_SHIELD_ACTIVE_CHANGED_SIGNAL,
	GALA_SCREEN_SHIELD_WAKE_UP_SCREEN_SIGNAL,
	GALA_SCREEN_SHIELD_NUM_SIGNALS
};
static guint gala_screen_shield_signals[GALA_SCREEN_SHIELD_NUM_SIGNALS] = {0};

struct _GalaLoginManagerIface {
	GTypeInterface parent_iface;
	char* (*get_session) (GalaLoginManager* self, const gchar* session_id, GError** error);
	GUnixInputStream* (*inhibit) (GalaLoginManager* self, const gchar* what, const gchar* who, const gchar* why, const gchar* mode, GError** error);
};

struct _GalaLoginSessionManagerIface {
	GTypeInterface parent_iface;
	void (*set_locked_hint) (GalaLoginSessionManager* self, gboolean locked, GError** error);
	gboolean (*get_active) (GalaLoginSessionManager* self);
};

struct _GalaLoginDisplay {
	gchar* session;
	char* objectpath;
};

struct _GalaLoginUserManagerIface {
	GTypeInterface parent_iface;
	GalaLoginDisplay* (*get_display) (GalaLoginUserManager* self);
};

struct _GalaSessionPresenceIface {
	GTypeInterface parent_iface;
	GalaPresenceStatus (*get_status) (GalaSessionPresence* self);
};

struct _GalaDisplayManagerSeatIface {
	GTypeInterface parent_iface;
	void (*switch_to_greeter) (GalaDisplayManagerSeat* self, GError** error);
};

struct _GalaScreenShield {
	ClutterActor parent_instance;
	GalaScreenShieldPrivate * priv;
};

struct _GalaScreenShieldClass {
	ClutterActorClass parent_class;
};

struct _GalaScreenShieldPrivate {
	gboolean _active;
	gboolean _is_locked;
	gboolean _in_greeter;
	gint64 _activation_time;
	GalaWindowManager* _wm;
	GalaModalProxy* modal_proxy;
	GalaLoginManager* login_manager;
	GalaLoginUserManager* login_user_manager;
	GalaLoginSessionManager* login_session;
	GalaSessionPresence* session_presence;
	GalaDisplayManagerSeat* display_manager;
	guint animate_id;
	GUnixInputStream* inhibitor;
	GSettings* screensaver_settings;
	GSettings* lockdown_settings;
	GSettings* gala_settings;
	gboolean connected_to_buses;
};

struct _GalaScreenShieldInitDbusInterfacesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GalaScreenShield* self;
	gboolean success;
	GalaLoginManager* _tmp0_;
	GalaLoginManager* _tmp1_;
	GalaLoginManager* _tmp2_;
	GalaLoginUserManager* _tmp3_;
	GalaLoginUserManager* _tmp4_;
	GalaLoginUserManager* _tmp5_;
	GalaLoginManager* _tmp6_;
	GalaLoginSessionManager* _tmp7_;
	GalaLoginSessionManager* _tmp8_;
	GalaLoginSessionManager* _tmp9_;
	GalaLoginSessionManager* _tmp10_;
	GalaLoginSessionManager* _tmp11_;
	GalaLoginSessionManager* _tmp12_;
	GalaLoginSessionManager* _tmp13_;
	GError* e;
	GError* _tmp14_;
	const gchar* _tmp15_;
	GalaSessionPresence* _tmp16_;
	GalaSessionPresence* _tmp17_;
	GalaSessionPresence* _tmp18_;
	GalaSessionPresence* _tmp19_;
	GalaPresenceStatus _tmp20_;
	GalaPresenceStatus _tmp21_;
	GalaSessionPresence* _tmp22_;
	GError* _vala1_e;
	GError* _tmp23_;
	const gchar* _tmp24_;
	gchar* seat_path;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	GalaDisplayManagerSeat* _tmp28_;
	const gchar* _tmp29_;
	GalaDisplayManagerSeat* _tmp30_;
	GalaDisplayManagerSeat* _tmp31_;
	GError* _inner_error0_;
};

static gint GalaScreenShield_private_offset;
static gpointer gala_screen_shield_parent_class = NULL;

VALA_EXTERN GType gala_login_manager_proxy_get_type (void) G_GNUC_CONST ;
 G_GNUC_INTERNAL guint gala_login_manager_register_object (void* object,
                                          GDBusConnection* connection,
                                          const gchar* path,
                                          GError** error);
 G_GNUC_INTERNAL GType gala_login_manager_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaLoginManager, g_object_unref)
 G_GNUC_INTERNAL char* gala_login_manager_get_session (GalaLoginManager* self,
                                      const gchar* session_id,
                                      GError** error);
 G_GNUC_INTERNAL GUnixInputStream* gala_login_manager_inhibit (GalaLoginManager* self,
                                              const gchar* what,
                                              const gchar* who,
                                              const gchar* why,
                                              const gchar* mode,
                                              GError** error);
static GType gala_login_manager_get_type_once (void);
static void gala_login_manager_proxy_g_signal (GDBusProxy* proxy,
                                        const gchar* sender_name,
                                        const gchar* signal_name,
                                        GVariant* parameters);
static void _dbus_handle_gala_login_manager_prepare_for_sleep (GalaLoginManager* self,
                                                        GVariant* parameters);
static char* gala_login_manager_proxy_get_session (GalaLoginManager* self,
                                            const gchar* session_id,
                                            GError** error);
static GUnixInputStream* gala_login_manager_proxy_inhibit (GalaLoginManager* self,
                                                    const gchar* what,
                                                    const gchar* who,
                                                    const gchar* why,
                                                    const gchar* mode,
                                                    GError** error);
static void gala_login_manager_proxy_gala_login_manager_interface_init (GalaLoginManagerIface* iface);
static void _dbus_gala_login_manager_get_session (GalaLoginManager* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation);
static void _dbus_gala_login_manager_inhibit (GalaLoginManager* self,
                                       GVariant* _parameters_,
                                       GDBusMethodInvocation* invocation);
static void gala_login_manager_dbus_interface_method_call (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* method_name,
                                                    GVariant* parameters,
                                                    GDBusMethodInvocation* invocation,
                                                    gpointer user_data);
static GVariant* gala_login_manager_dbus_interface_get_property (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* property_name,
                                                          GError** error,
                                                          gpointer user_data);
static gboolean gala_login_manager_dbus_interface_set_property (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* property_name,
                                                         GVariant* value,
                                                         GError** error,
                                                         gpointer user_data);
static void _dbus_gala_login_manager_prepare_for_sleep (GObject* _sender,
                                                 gboolean about_to_suspend,
                                                 gpointer* _data);
static void _gala_login_manager_unregister_object (gpointer user_data);
VALA_EXTERN GType gala_login_session_manager_proxy_get_type (void) G_GNUC_CONST ;
 G_GNUC_INTERNAL guint gala_login_session_manager_register_object (void* object,
                                                  GDBusConnection* connection,
                                                  const gchar* path,
                                                  GError** error);
 G_GNUC_INTERNAL GType gala_login_session_manager_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaLoginSessionManager, g_object_unref)
 G_GNUC_INTERNAL void gala_login_session_manager_set_locked_hint (GalaLoginSessionManager* self,
                                                 gboolean locked,
                                                 GError** error);
 G_GNUC_INTERNAL gboolean gala_login_session_manager_get_active (GalaLoginSessionManager* self);
static GType gala_login_session_manager_get_type_once (void);
static void gala_login_session_manager_proxy_g_signal (GDBusProxy* proxy,
                                                const gchar* sender_name,
                                                const gchar* signal_name,
                                                GVariant* parameters);
static void _dbus_handle_gala_login_session_manager_lock (GalaLoginSessionManager* self,
                                                   GVariant* parameters);
static void _dbus_handle_gala_login_session_manager_unlock (GalaLoginSessionManager* self,
                                                     GVariant* parameters);
static void gala_login_session_manager_proxy_set_locked_hint (GalaLoginSessionManager* self,
                                                       gboolean locked,
                                                       GError** error);
static gboolean gala_login_session_manager_dbus_proxy_get_active (GalaLoginSessionManager* self);
static void gala_login_session_manager_proxy_gala_login_session_manager_interface_init (GalaLoginSessionManagerIface* iface);
static void _dbus_gala_login_session_manager_set_locked_hint (GalaLoginSessionManager* self,
                                                       GVariant* _parameters_,
                                                       GDBusMethodInvocation* invocation);
static void gala_login_session_manager_dbus_interface_method_call (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* method_name,
                                                            GVariant* parameters,
                                                            GDBusMethodInvocation* invocation,
                                                            gpointer user_data);
static GVariant* gala_login_session_manager_dbus_interface_get_property (GDBusConnection* connection,
                                                                  const gchar* sender,
                                                                  const gchar* object_path,
                                                                  const gchar* interface_name,
                                                                  const gchar* property_name,
                                                                  GError** error,
                                                                  gpointer user_data);
static GVariant* _dbus_gala_login_session_manager_get_active (GalaLoginSessionManager* self);
static gboolean gala_login_session_manager_dbus_interface_set_property (GDBusConnection* connection,
                                                                 const gchar* sender,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name,
                                                                 const gchar* property_name,
                                                                 GVariant* value,
                                                                 GError** error,
                                                                 gpointer user_data);
static void _dbus_gala_login_session_manager_lock (GObject* _sender,
                                            gpointer* _data);
static void _dbus_gala_login_session_manager_unlock (GObject* _sender,
                                              gpointer* _data);
static void _gala_login_session_manager_unregister_object (gpointer user_data);
VALA_EXTERN GType gala_login_display_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GalaLoginDisplay* gala_login_display_dup (const GalaLoginDisplay* self);
VALA_EXTERN void gala_login_display_free (GalaLoginDisplay* self);
VALA_EXTERN void gala_login_display_copy (const GalaLoginDisplay* self,
                              GalaLoginDisplay* dest);
VALA_EXTERN void gala_login_display_destroy (GalaLoginDisplay* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (GalaLoginDisplay, gala_login_display_destroy)
 G_GNUC_INTERNAL GType gala_login_user_manager_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaLoginUserManager, g_object_unref)
VALA_EXTERN GType gala_login_user_manager_proxy_get_type (void) G_GNUC_CONST ;
 G_GNUC_INTERNAL guint gala_login_user_manager_register_object (void* object,
                                               GDBusConnection* connection,
                                               const gchar* path,
                                               GError** error);
 G_GNUC_INTERNAL GalaLoginDisplay* gala_login_user_manager_get_display (GalaLoginUserManager* self);
static GType gala_login_user_manager_get_type_once (void);
static void gala_login_user_manager_proxy_g_signal (GDBusProxy* proxy,
                                             const gchar* sender_name,
                                             const gchar* signal_name,
                                             GVariant* parameters);
static GalaLoginDisplay* gala_login_user_manager_dbus_proxy_get_display (GalaLoginUserManager* self);
static void gala_login_user_manager_proxy_gala_login_user_manager_interface_init (GalaLoginUserManagerIface* iface);
static void gala_login_user_manager_dbus_interface_method_call (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* method_name,
                                                         GVariant* parameters,
                                                         GDBusMethodInvocation* invocation,
                                                         gpointer user_data);
static GVariant* gala_login_user_manager_dbus_interface_get_property (GDBusConnection* connection,
                                                               const gchar* sender,
                                                               const gchar* object_path,
                                                               const gchar* interface_name,
                                                               const gchar* property_name,
                                                               GError** error,
                                                               gpointer user_data);
static GVariant* _dbus_gala_login_user_manager_get_display (GalaLoginUserManager* self);
static gboolean gala_login_user_manager_dbus_interface_set_property (GDBusConnection* connection,
                                                              const gchar* sender,
                                                              const gchar* object_path,
                                                              const gchar* interface_name,
                                                              const gchar* property_name,
                                                              GVariant* value,
                                                              GError** error,
                                                              gpointer user_data);
static void _gala_login_user_manager_unregister_object (gpointer user_data);
 G_GNUC_INTERNAL GType gala_presence_status_get_type (void) G_GNUC_CONST ;
 G_GNUC_INTERNAL GType gala_session_presence_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaSessionPresence, g_object_unref)
VALA_EXTERN GType gala_session_presence_proxy_get_type (void) G_GNUC_CONST ;
 G_GNUC_INTERNAL guint gala_session_presence_register_object (void* object,
                                             GDBusConnection* connection,
                                             const gchar* path,
                                             GError** error);
 G_GNUC_INTERNAL GalaPresenceStatus gala_session_presence_get_status (GalaSessionPresence* self);
static GType gala_session_presence_get_type_once (void);
static void gala_session_presence_proxy_g_signal (GDBusProxy* proxy,
                                           const gchar* sender_name,
                                           const gchar* signal_name,
                                           GVariant* parameters);
static void _dbus_handle_gala_session_presence_status_changed (GalaSessionPresence* self,
                                                        GVariant* parameters);
static GalaPresenceStatus gala_session_presence_dbus_proxy_get_status (GalaSessionPresence* self);
static void gala_session_presence_proxy_gala_session_presence_interface_init (GalaSessionPresenceIface* iface);
static void gala_session_presence_dbus_interface_method_call (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* method_name,
                                                       GVariant* parameters,
                                                       GDBusMethodInvocation* invocation,
                                                       gpointer user_data);
static GVariant* gala_session_presence_dbus_interface_get_property (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* property_name,
                                                             GError** error,
                                                             gpointer user_data);
static GVariant* _dbus_gala_session_presence_get_status (GalaSessionPresence* self);
static gboolean gala_session_presence_dbus_interface_set_property (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* property_name,
                                                            GVariant* value,
                                                            GError** error,
                                                            gpointer user_data);
static void _dbus_gala_session_presence_status_changed (GObject* _sender,
                                                 GalaPresenceStatus new_status,
                                                 gpointer* _data);
static void _gala_session_presence_unregister_object (gpointer user_data);
VALA_EXTERN GType gala_display_manager_seat_proxy_get_type (void) G_GNUC_CONST ;
 G_GNUC_INTERNAL guint gala_display_manager_seat_register_object (void* object,
                                                 GDBusConnection* connection,
                                                 const gchar* path,
                                                 GError** error);
 G_GNUC_INTERNAL GType gala_display_manager_seat_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaDisplayManagerSeat, g_object_unref)
 G_GNUC_INTERNAL void gala_display_manager_seat_switch_to_greeter (GalaDisplayManagerSeat* self,
                                                  GError** error);
static GType gala_display_manager_seat_get_type_once (void);
static void gala_display_manager_seat_proxy_g_signal (GDBusProxy* proxy,
                                               const gchar* sender_name,
                                               const gchar* signal_name,
                                               GVariant* parameters);
static void gala_display_manager_seat_proxy_switch_to_greeter (GalaDisplayManagerSeat* self,
                                                        GError** error);
static void gala_display_manager_seat_proxy_gala_display_manager_seat_interface_init (GalaDisplayManagerSeatIface* iface);
static void _dbus_gala_display_manager_seat_switch_to_greeter (GalaDisplayManagerSeat* self,
                                                        GVariant* _parameters_,
                                                        GDBusMethodInvocation* invocation);
static void gala_display_manager_seat_dbus_interface_method_call (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* method_name,
                                                           GVariant* parameters,
                                                           GDBusMethodInvocation* invocation,
                                                           gpointer user_data);
static GVariant* gala_display_manager_seat_dbus_interface_get_property (GDBusConnection* connection,
                                                                 const gchar* sender,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name,
                                                                 const gchar* property_name,
                                                                 GError** error,
                                                                 gpointer user_data);
static gboolean gala_display_manager_seat_dbus_interface_set_property (GDBusConnection* connection,
                                                                const gchar* sender,
                                                                const gchar* object_path,
                                                                const gchar* interface_name,
                                                                const gchar* property_name,
                                                                GVariant* value,
                                                                GError** error,
                                                                gpointer user_data);
static void _gala_display_manager_seat_unregister_object (gpointer user_data);
VALA_EXTERN GType gala_screen_shield_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaScreenShield, g_object_unref)
VALA_EXTERN GalaScreenShield* gala_screen_shield_new (GalaWindowManager* wm);
VALA_EXTERN GalaScreenShield* gala_screen_shield_construct (GType object_type,
                                                GalaWindowManager* wm);
static void gala_screen_shield_init_dbus_interfaces_data_free (gpointer _data);
static void gala_screen_shield_init_dbus_interfaces (GalaScreenShield* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static void gala_screen_shield_init_dbus_interfaces_finish (GalaScreenShield* self,
                                                     GAsyncResult* _res_);
static gboolean gala_screen_shield_init_dbus_interfaces_co (GalaScreenShieldInitDbusInterfacesData* _data_);
static void gala_screen_shield_init_dbus_interfaces_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static void gala_screen_shield_prepare_for_sleep (GalaScreenShield* self,
                                           gboolean about_to_suspend);
static void _gala_screen_shield_prepare_for_sleep_gala_login_manager_prepare_for_sleep (GalaLoginManager* _sender,
                                                                                 gboolean about_to_suspend,
                                                                                 gpointer self);
static GalaLoginSessionManager* gala_screen_shield_get_current_session_manager (GalaScreenShield* self,
                                                                         GError** error);
static void ____lambda30_ (GalaScreenShield* self);
VALA_EXTERN void gala_screen_shield_lock (GalaScreenShield* self,
                              gboolean animate);
static void _____lambda30__gala_login_session_manager_lock (GalaLoginSessionManager* _sender,
                                                     gpointer self);
static void ____lambda31_ (GalaScreenShield* self);
VALA_EXTERN void gala_screen_shield_deactivate (GalaScreenShield* self,
                                    gboolean animate);
static void gala_screen_shield_set_in_greeter (GalaScreenShield* self,
                                        gboolean value);
static void _____lambda31__gala_login_session_manager_unlock (GalaLoginSessionManager* _sender,
                                                       gpointer self);
static void gala_screen_shield_sync_inhibitor (GalaScreenShield* self);
static void _gala_screen_shield_sync_inhibitor_g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                           GVariant* changed_properties,
                                                                           gchar** invalidated_properties,
                                                                           gpointer self);
static void gala_screen_shield_on_status_changed (GalaScreenShield* self,
                                           GalaPresenceStatus status);
static void ___lambda32_ (GalaScreenShield* self,
                   GalaPresenceStatus status);
static void ____lambda32__gala_session_presence_status_changed (GalaSessionPresence* _sender,
                                                         GalaPresenceStatus new_status,
                                                         gpointer self);
VALA_EXTERN void gala_screen_shield_expand_to_screen_size (GalaScreenShield* self);
VALA_EXTERN GalaWindowManager* gala_screen_shield_get_wm (GalaScreenShield* self);
static void gala_screen_shield_on_user_became_active (GalaScreenShield* self);
VALA_EXTERN void gala_screen_shield_activate (GalaScreenShield* self,
                                  gboolean animate,
                                  guint animation_time);
VALA_EXTERN gboolean gala_screen_shield_get_active (GalaScreenShield* self);
VALA_EXTERN gboolean gala_screen_shield_get_is_locked (GalaScreenShield* self);
VALA_EXTERN gboolean gala_screen_shield_get_in_greeter (GalaScreenShield* self);
static void gala_screen_shield_cancel_animation (GalaScreenShield* self);
static void gala_screen_shield_set_is_locked (GalaScreenShield* self,
                                       gboolean value);
VALA_EXTERN gint64 gala_screen_shield_get_activation_time (GalaScreenShield* self);
static void gala_screen_shield_set_activation_time (GalaScreenShield* self,
                                             gint64 value);
static void gala_screen_shield_animate_and_lock (GalaScreenShield* self,
                                          guint animation_time);
static void _gala_screen_shield_set_active (GalaScreenShield* self,
                                     gboolean new_active);
static gboolean __lambda29_ (GalaScreenShield* self);
static gboolean ___lambda29__gsource_func (gpointer self);
static void gala_screen_shield_set_active (GalaScreenShield* self,
                                    gboolean value);
static void gala_screen_shield_set_wm (GalaScreenShield* self,
                                GalaWindowManager* value);
static GObject * gala_screen_shield_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static gboolean _gala_screen_shield___lambda33_ (GalaScreenShield* self,
                                          ClutterKeyEvent* event);
static gboolean __gala_screen_shield___lambda33__clutter_actor_key_press_event (ClutterActor* _sender,
                                                                         ClutterKeyEvent* event,
                                                                         gpointer self);
static gboolean _gala_screen_shield___lambda34_ (GalaScreenShield* self,
                                          ClutterMotionEvent* event);
static gboolean __gala_screen_shield___lambda34__clutter_actor_motion_event (ClutterActor* _sender,
                                                                      ClutterMotionEvent* event,
                                                                      gpointer self);
static void _vala_ClutterColor_free (ClutterColor* self);
static void gala_screen_shield_finalize (GObject * obj);
static GType gala_screen_shield_get_type_once (void);
static void _vala_gala_screen_shield_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_gala_screen_shield_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GDBusArgInfo _gala_login_manager_dbus_arg_info_get_session_session_id = {-1, "session_id", "s", NULL};
static const GDBusArgInfo _gala_login_manager_dbus_arg_info_get_session_result = {-1, "result", "o", NULL};
static const GDBusArgInfo * const _gala_login_manager_dbus_arg_info_get_session_in[] = {&_gala_login_manager_dbus_arg_info_get_session_session_id, NULL};
static const GDBusArgInfo * const _gala_login_manager_dbus_arg_info_get_session_out[] = {&_gala_login_manager_dbus_arg_info_get_session_result, NULL};
static const GDBusMethodInfo _gala_login_manager_dbus_method_info_get_session = {-1, "GetSession", (GDBusArgInfo **) (&_gala_login_manager_dbus_arg_info_get_session_in), (GDBusArgInfo **) (&_gala_login_manager_dbus_arg_info_get_session_out), NULL};
static const GDBusArgInfo _gala_login_manager_dbus_arg_info_inhibit_what = {-1, "what", "s", NULL};
static const GDBusArgInfo _gala_login_manager_dbus_arg_info_inhibit_who = {-1, "who", "s", NULL};
static const GDBusArgInfo _gala_login_manager_dbus_arg_info_inhibit_why = {-1, "why", "s", NULL};
static const GDBusArgInfo _gala_login_manager_dbus_arg_info_inhibit_mode = {-1, "mode", "s", NULL};
static const GDBusArgInfo _gala_login_manager_dbus_arg_info_inhibit_result = {-1, "result", "h", NULL};
static const GDBusArgInfo * const _gala_login_manager_dbus_arg_info_inhibit_in[] = {&_gala_login_manager_dbus_arg_info_inhibit_what, &_gala_login_manager_dbus_arg_info_inhibit_who, &_gala_login_manager_dbus_arg_info_inhibit_why, &_gala_login_manager_dbus_arg_info_inhibit_mode, NULL};
static const GDBusArgInfo * const _gala_login_manager_dbus_arg_info_inhibit_out[] = {&_gala_login_manager_dbus_arg_info_inhibit_result, NULL};
static const GDBusMethodInfo _gala_login_manager_dbus_method_info_inhibit = {-1, "Inhibit", (GDBusArgInfo **) (&_gala_login_manager_dbus_arg_info_inhibit_in), (GDBusArgInfo **) (&_gala_login_manager_dbus_arg_info_inhibit_out), NULL};
static const GDBusMethodInfo * const _gala_login_manager_dbus_method_info[] = {&_gala_login_manager_dbus_method_info_get_session, &_gala_login_manager_dbus_method_info_inhibit, NULL};
static const GDBusArgInfo _gala_login_manager_dbus_arg_info_prepare_for_sleep_about_to_suspend = {-1, "about_to_suspend", "b", NULL};
static const GDBusArgInfo * const _gala_login_manager_dbus_arg_info_prepare_for_sleep[] = {&_gala_login_manager_dbus_arg_info_prepare_for_sleep_about_to_suspend, NULL};
static const GDBusSignalInfo _gala_login_manager_dbus_signal_info_prepare_for_sleep = {-1, "PrepareForSleep", (GDBusArgInfo **) (&_gala_login_manager_dbus_arg_info_prepare_for_sleep), NULL};
static const GDBusSignalInfo * const _gala_login_manager_dbus_signal_info[] = {&_gala_login_manager_dbus_signal_info_prepare_for_sleep, NULL};
static const GDBusPropertyInfo * const _gala_login_manager_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _gala_login_manager_dbus_interface_info = {-1, "org.freedesktop.login1.Manager", (GDBusMethodInfo **) (&_gala_login_manager_dbus_method_info), (GDBusSignalInfo **) (&_gala_login_manager_dbus_signal_info), (GDBusPropertyInfo **) (&_gala_login_manager_dbus_property_info), NULL};
static const GDBusInterfaceVTable _gala_login_manager_dbus_interface_vtable = {gala_login_manager_dbus_interface_method_call, gala_login_manager_dbus_interface_get_property, gala_login_manager_dbus_interface_set_property};
static const GDBusArgInfo _gala_login_session_manager_dbus_arg_info_set_locked_hint_locked = {-1, "locked", "b", NULL};
static const GDBusArgInfo * const _gala_login_session_manager_dbus_arg_info_set_locked_hint_in[] = {&_gala_login_session_manager_dbus_arg_info_set_locked_hint_locked, NULL};
static const GDBusArgInfo * const _gala_login_session_manager_dbus_arg_info_set_locked_hint_out[] = {NULL};
static const GDBusMethodInfo _gala_login_session_manager_dbus_method_info_set_locked_hint = {-1, "SetLockedHint", (GDBusArgInfo **) (&_gala_login_session_manager_dbus_arg_info_set_locked_hint_in), (GDBusArgInfo **) (&_gala_login_session_manager_dbus_arg_info_set_locked_hint_out), NULL};
static const GDBusMethodInfo * const _gala_login_session_manager_dbus_method_info[] = {&_gala_login_session_manager_dbus_method_info_set_locked_hint, NULL};
static const GDBusArgInfo * const _gala_login_session_manager_dbus_arg_info_lock[] = {NULL};
static const GDBusSignalInfo _gala_login_session_manager_dbus_signal_info_lock = {-1, "Lock", (GDBusArgInfo **) (&_gala_login_session_manager_dbus_arg_info_lock), NULL};
static const GDBusArgInfo * const _gala_login_session_manager_dbus_arg_info_unlock[] = {NULL};
static const GDBusSignalInfo _gala_login_session_manager_dbus_signal_info_unlock = {-1, "Unlock", (GDBusArgInfo **) (&_gala_login_session_manager_dbus_arg_info_unlock), NULL};
static const GDBusSignalInfo * const _gala_login_session_manager_dbus_signal_info[] = {&_gala_login_session_manager_dbus_signal_info_lock, &_gala_login_session_manager_dbus_signal_info_unlock, NULL};
static const GDBusPropertyInfo _gala_login_session_manager_dbus_property_info_active = {-1, "Active", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _gala_login_session_manager_dbus_property_info[] = {&_gala_login_session_manager_dbus_property_info_active, NULL};
static const GDBusInterfaceInfo _gala_login_session_manager_dbus_interface_info = {-1, "org.freedesktop.login1.Session", (GDBusMethodInfo **) (&_gala_login_session_manager_dbus_method_info), (GDBusSignalInfo **) (&_gala_login_session_manager_dbus_signal_info), (GDBusPropertyInfo **) (&_gala_login_session_manager_dbus_property_info), NULL};
static const GDBusInterfaceVTable _gala_login_session_manager_dbus_interface_vtable = {gala_login_session_manager_dbus_interface_method_call, gala_login_session_manager_dbus_interface_get_property, gala_login_session_manager_dbus_interface_set_property};
static const GDBusMethodInfo * const _gala_login_user_manager_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _gala_login_user_manager_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _gala_login_user_manager_dbus_property_info_display = {-1, "Display", "(so)", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _gala_login_user_manager_dbus_property_info[] = {&_gala_login_user_manager_dbus_property_info_display, NULL};
static const GDBusInterfaceInfo _gala_login_user_manager_dbus_interface_info = {-1, "org.freedesktop.login1.User", (GDBusMethodInfo **) (&_gala_login_user_manager_dbus_method_info), (GDBusSignalInfo **) (&_gala_login_user_manager_dbus_signal_info), (GDBusPropertyInfo **) (&_gala_login_user_manager_dbus_property_info), NULL};
static const GDBusInterfaceVTable _gala_login_user_manager_dbus_interface_vtable = {gala_login_user_manager_dbus_interface_method_call, gala_login_user_manager_dbus_interface_get_property, gala_login_user_manager_dbus_interface_set_property};
static const GDBusMethodInfo * const _gala_session_presence_dbus_method_info[] = {NULL};
static const GDBusArgInfo _gala_session_presence_dbus_arg_info_status_changed_new_status = {-1, "new_status", "u", NULL};
static const GDBusArgInfo * const _gala_session_presence_dbus_arg_info_status_changed[] = {&_gala_session_presence_dbus_arg_info_status_changed_new_status, NULL};
static const GDBusSignalInfo _gala_session_presence_dbus_signal_info_status_changed = {-1, "StatusChanged", (GDBusArgInfo **) (&_gala_session_presence_dbus_arg_info_status_changed), NULL};
static const GDBusSignalInfo * const _gala_session_presence_dbus_signal_info[] = {&_gala_session_presence_dbus_signal_info_status_changed, NULL};
static const GDBusPropertyInfo _gala_session_presence_dbus_property_info_status = {-1, "Status", "u", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _gala_session_presence_dbus_property_info[] = {&_gala_session_presence_dbus_property_info_status, NULL};
static const GDBusInterfaceInfo _gala_session_presence_dbus_interface_info = {-1, "org.gnome.SessionManager.Presence", (GDBusMethodInfo **) (&_gala_session_presence_dbus_method_info), (GDBusSignalInfo **) (&_gala_session_presence_dbus_signal_info), (GDBusPropertyInfo **) (&_gala_session_presence_dbus_property_info), NULL};
static const GDBusInterfaceVTable _gala_session_presence_dbus_interface_vtable = {gala_session_presence_dbus_interface_method_call, gala_session_presence_dbus_interface_get_property, gala_session_presence_dbus_interface_set_property};
static const GDBusArgInfo * const _gala_display_manager_seat_dbus_arg_info_switch_to_greeter_in[] = {NULL};
static const GDBusArgInfo * const _gala_display_manager_seat_dbus_arg_info_switch_to_greeter_out[] = {NULL};
static const GDBusMethodInfo _gala_display_manager_seat_dbus_method_info_switch_to_greeter = {-1, "SwitchToGreeter", (GDBusArgInfo **) (&_gala_display_manager_seat_dbus_arg_info_switch_to_greeter_in), (GDBusArgInfo **) (&_gala_display_manager_seat_dbus_arg_info_switch_to_greeter_out), NULL};
static const GDBusMethodInfo * const _gala_display_manager_seat_dbus_method_info[] = {&_gala_display_manager_seat_dbus_method_info_switch_to_greeter, NULL};
static const GDBusSignalInfo * const _gala_display_manager_seat_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _gala_display_manager_seat_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _gala_display_manager_seat_dbus_interface_info = {-1, "org.freedesktop.DisplayManager.Seat", (GDBusMethodInfo **) (&_gala_display_manager_seat_dbus_method_info), (GDBusSignalInfo **) (&_gala_display_manager_seat_dbus_signal_info), (GDBusPropertyInfo **) (&_gala_display_manager_seat_dbus_property_info), NULL};
static const GDBusInterfaceVTable _gala_display_manager_seat_dbus_interface_vtable = {gala_display_manager_seat_dbus_interface_method_call, gala_display_manager_seat_dbus_interface_get_property, gala_display_manager_seat_dbus_interface_set_property};

char*
gala_login_manager_get_session (GalaLoginManager* self,
                                const gchar* session_id,
                                GError** error)
{
	GalaLoginManagerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GALA_LOGIN_MANAGER_GET_INTERFACE (self);
	if (_iface_->get_session) {
		return _iface_->get_session (self, session_id, error);
	}
	return NULL;
}

GUnixInputStream*
gala_login_manager_inhibit (GalaLoginManager* self,
                            const gchar* what,
                            const gchar* who,
                            const gchar* why,
                            const gchar* mode,
                            GError** error)
{
	GalaLoginManagerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GALA_LOGIN_MANAGER_GET_INTERFACE (self);
	if (_iface_->inhibit) {
		return _iface_->inhibit (self, what, who, why, mode, error);
	}
	return NULL;
}

static void
gala_login_manager_default_init (GalaLoginManagerIface * iface,
                                 gpointer iface_data)
{
	gala_login_manager_signals[GALA_LOGIN_MANAGER_PREPARE_FOR_SLEEP_SIGNAL] = g_signal_new ("prepare-for-sleep", GALA_TYPE_LOGIN_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}

static GType
gala_login_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaLoginManagerIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_login_manager_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gala_login_manager_type_id;
	gala_login_manager_type_id = g_type_register_static (G_TYPE_INTERFACE, "GalaLoginManager", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gala_login_manager_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (gala_login_manager_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) gala_login_manager_proxy_get_type);
	g_type_set_qdata (gala_login_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.login1.Manager");
	g_type_set_qdata (gala_login_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_gala_login_manager_dbus_interface_info));
	g_type_set_qdata (gala_login_manager_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) gala_login_manager_register_object);
	return gala_login_manager_type_id;
}

 G_GNUC_INTERNAL GType
gala_login_manager_get_type (void)
{
	static volatile gsize gala_login_manager_type_id__once = 0;
	if (g_once_init_enter (&gala_login_manager_type_id__once)) {
		GType gala_login_manager_type_id;
		gala_login_manager_type_id = gala_login_manager_get_type_once ();
		g_once_init_leave (&gala_login_manager_type_id__once, gala_login_manager_type_id);
	}
	return gala_login_manager_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (GalaLoginManagerProxy, gala_login_manager_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (GALA_TYPE_LOGIN_MANAGER, gala_login_manager_proxy_gala_login_manager_interface_init) )
static void
gala_login_manager_proxy_class_init (GalaLoginManagerProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = gala_login_manager_proxy_g_signal;
}

static void
_dbus_handle_gala_login_manager_prepare_for_sleep (GalaLoginManager* self,
                                                   GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gboolean about_to_suspend = FALSE;
	GVariant* _tmp115_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp115_ = g_variant_iter_next_value (&_arguments_iter);
	about_to_suspend = g_variant_get_boolean (_tmp115_);
	g_variant_unref (_tmp115_);
	g_signal_emit_by_name (self, "prepare-for-sleep", about_to_suspend);
}

static void
gala_login_manager_proxy_g_signal (GDBusProxy* proxy,
                                   const gchar* sender_name,
                                   const gchar* signal_name,
                                   GVariant* parameters)
{
	if (strcmp (signal_name, "PrepareForSleep") == 0) {
		_dbus_handle_gala_login_manager_prepare_for_sleep ((GalaLoginManager*) proxy, parameters);
	}
}

static void
gala_login_manager_proxy_init (GalaLoginManagerProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_gala_login_manager_dbus_interface_info));
}

static char*
gala_login_manager_proxy_get_session (GalaLoginManager* self,
                                      const gchar* session_id,
                                      GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	char* _result = NULL;
	GVariant* _tmp116_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.login1.Manager", "GetSession");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (session_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp116_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp116_, NULL);
	g_variant_unref (_tmp116_);
	g_object_unref (_reply_message);
	return _result;
}

static GUnixInputStream*
gala_login_manager_proxy_inhibit (GalaLoginManager* self,
                                  const gchar* what,
                                  const gchar* who,
                                  const gchar* why,
                                  const gchar* mode,
                                  GError** error)
{
	GUnixFDList* _fd_list;
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	gint _fd_index = 0;
	gint _fd;
	GVariant *_reply;
	GVariantIter _reply_iter;
	GUnixInputStream* _result = NULL;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.login1.Manager", "Inhibit");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_fd_list = g_unix_fd_list_new ();
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (what));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (who));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (why));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (mode));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_message_set_unix_fd_list (_message, _fd_list);
	g_object_unref (_fd_list);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_fd_list = g_dbus_message_get_unix_fd_list (_reply_message);
	if (_fd_list) {
		g_variant_iter_next (&_reply_iter, "h", &_fd_index);
		_fd = g_unix_fd_list_get (_fd_list, _fd_index, error);
		if (_fd >= 0) {
			_result = (GUnixInputStream *) g_unix_input_stream_new (_fd, TRUE);
		}
	} else {
		g_set_error_literal (error, G_IO_ERROR, G_IO_ERROR_FAILED, "FD List is NULL");
	}
	if (error && (*error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	g_object_unref (_reply_message);
	return _result;
}

static void
gala_login_manager_proxy_gala_login_manager_interface_init (GalaLoginManagerIface* iface)
{
	iface->get_session = gala_login_manager_proxy_get_session;
	iface->inhibit = gala_login_manager_proxy_inhibit;
}

static void
_dbus_gala_login_manager_get_session (GalaLoginManager* self,
                                      GVariant* _parameters_,
                                      GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* session_id = NULL;
	GVariant* _tmp117_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	char* result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp117_ = g_variant_iter_next_value (&_arguments_iter);
	session_id = g_variant_dup_string (_tmp117_, NULL);
	g_variant_unref (_tmp117_);
	result = gala_login_manager_get_session (self, session_id, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_object_path (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (session_id);
	;
}

static void
_dbus_gala_login_manager_inhibit (GalaLoginManager* self,
                                  GVariant* _parameters_,
                                  GDBusMethodInvocation* invocation)
{
	GUnixFDList* _fd_list;
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gint _fd_index = 0;
	gint _fd;
	gchar* what = NULL;
	GVariant* _tmp118_;
	gchar* who = NULL;
	GVariant* _tmp119_;
	gchar* why = NULL;
	GVariant* _tmp120_;
	gchar* mode = NULL;
	GVariant* _tmp121_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GUnixInputStream* result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp118_ = g_variant_iter_next_value (&_arguments_iter);
	what = g_variant_dup_string (_tmp118_, NULL);
	g_variant_unref (_tmp118_);
	_tmp119_ = g_variant_iter_next_value (&_arguments_iter);
	who = g_variant_dup_string (_tmp119_, NULL);
	g_variant_unref (_tmp119_);
	_tmp120_ = g_variant_iter_next_value (&_arguments_iter);
	why = g_variant_dup_string (_tmp120_, NULL);
	g_variant_unref (_tmp120_);
	_tmp121_ = g_variant_iter_next_value (&_arguments_iter);
	mode = g_variant_dup_string (_tmp121_, NULL);
	g_variant_unref (_tmp121_);
	result = gala_login_manager_inhibit (self, what, who, why, mode, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_fd_list = g_unix_fd_list_new ();
	g_variant_builder_add (&_reply_builder, "h", g_unix_fd_list_append (_fd_list, g_unix_input_stream_get_fd (result), NULL));
	_g_object_unref0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_message_set_unix_fd_list (_reply_message, _fd_list);
	g_object_unref (_fd_list);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (what);
	_g_free0 (who);
	_g_free0 (why);
	_g_free0 (mode);
	;
}

static void
gala_login_manager_dbus_interface_method_call (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* method_name,
                                               GVariant* parameters,
                                               GDBusMethodInvocation* invocation,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetSession") == 0) {
		_dbus_gala_login_manager_get_session (object, parameters, invocation);
	} else if (strcmp (method_name, "Inhibit") == 0) {
		_dbus_gala_login_manager_inhibit (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
gala_login_manager_dbus_interface_get_property (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* property_name,
                                                GError** error,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
gala_login_manager_dbus_interface_set_property (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* property_name,
                                                GVariant* value,
                                                GError** error,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_gala_login_manager_prepare_for_sleep (GObject* _sender,
                                            gboolean about_to_suspend,
                                            gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (about_to_suspend));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.login1.Manager", "PrepareForSleep", _arguments, NULL);
}

 G_GNUC_INTERNAL guint
gala_login_manager_register_object (gpointer object,
                                    GDBusConnection* connection,
                                    const gchar* path,
                                    GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_gala_login_manager_dbus_interface_info), &_gala_login_manager_dbus_interface_vtable, data, _gala_login_manager_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "prepare-for-sleep", (GCallback) _dbus_gala_login_manager_prepare_for_sleep, data);
	return result;
}

static void
_gala_login_manager_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_gala_login_manager_prepare_for_sleep, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
gala_login_session_manager_set_locked_hint (GalaLoginSessionManager* self,
                                            gboolean locked,
                                            GError** error)
{
	GalaLoginSessionManagerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GALA_LOGIN_SESSION_MANAGER_GET_INTERFACE (self);
	if (_iface_->set_locked_hint) {
		_iface_->set_locked_hint (self, locked, error);
	}
}

 G_GNUC_INTERNAL gboolean
gala_login_session_manager_get_active (GalaLoginSessionManager* self)
{
	GalaLoginSessionManagerIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GALA_LOGIN_SESSION_MANAGER_GET_INTERFACE (self);
	if (_iface_->get_active) {
		return _iface_->get_active (self);
	}
	return FALSE;
}

static void
gala_login_session_manager_default_init (GalaLoginSessionManagerIface * iface,
                                         gpointer iface_data)
{
	gala_login_session_manager_signals[GALA_LOGIN_SESSION_MANAGER_LOCK_SIGNAL] = g_signal_new ("lock", GALA_TYPE_LOGIN_SESSION_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gala_login_session_manager_signals[GALA_LOGIN_SESSION_MANAGER_UNLOCK_SIGNAL] = g_signal_new ("unlock", GALA_TYPE_LOGIN_SESSION_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static GType
gala_login_session_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaLoginSessionManagerIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_login_session_manager_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gala_login_session_manager_type_id;
	gala_login_session_manager_type_id = g_type_register_static (G_TYPE_INTERFACE, "GalaLoginSessionManager", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gala_login_session_manager_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (gala_login_session_manager_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) gala_login_session_manager_proxy_get_type);
	g_type_set_qdata (gala_login_session_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.login1.Session");
	g_type_set_qdata (gala_login_session_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_gala_login_session_manager_dbus_interface_info));
	g_type_set_qdata (gala_login_session_manager_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) gala_login_session_manager_register_object);
	return gala_login_session_manager_type_id;
}

 G_GNUC_INTERNAL GType
gala_login_session_manager_get_type (void)
{
	static volatile gsize gala_login_session_manager_type_id__once = 0;
	if (g_once_init_enter (&gala_login_session_manager_type_id__once)) {
		GType gala_login_session_manager_type_id;
		gala_login_session_manager_type_id = gala_login_session_manager_get_type_once ();
		g_once_init_leave (&gala_login_session_manager_type_id__once, gala_login_session_manager_type_id);
	}
	return gala_login_session_manager_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (GalaLoginSessionManagerProxy, gala_login_session_manager_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (GALA_TYPE_LOGIN_SESSION_MANAGER, gala_login_session_manager_proxy_gala_login_session_manager_interface_init) )
static void
gala_login_session_manager_proxy_class_init (GalaLoginSessionManagerProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = gala_login_session_manager_proxy_g_signal;
}

static void
_dbus_handle_gala_login_session_manager_lock (GalaLoginSessionManager* self,
                                              GVariant* parameters)
{
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "lock");
}

static void
_dbus_handle_gala_login_session_manager_unlock (GalaLoginSessionManager* self,
                                                GVariant* parameters)
{
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "unlock");
}

static void
gala_login_session_manager_proxy_g_signal (GDBusProxy* proxy,
                                           const gchar* sender_name,
                                           const gchar* signal_name,
                                           GVariant* parameters)
{
	if (strcmp (signal_name, "Lock") == 0) {
		_dbus_handle_gala_login_session_manager_lock ((GalaLoginSessionManager*) proxy, parameters);
	} else if (strcmp (signal_name, "Unlock") == 0) {
		_dbus_handle_gala_login_session_manager_unlock ((GalaLoginSessionManager*) proxy, parameters);
	}
}

static void
gala_login_session_manager_proxy_init (GalaLoginSessionManagerProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_gala_login_session_manager_dbus_interface_info));
}

static void
gala_login_session_manager_proxy_set_locked_hint (GalaLoginSessionManager* self,
                                                  gboolean locked,
                                                  GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.login1.Session", "SetLockedHint");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (locked));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static gboolean
gala_login_session_manager_dbus_proxy_get_active (GalaLoginSessionManager* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Active");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.login1.Session"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Active"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp122_ = FALSE;
			return _tmp122_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
gala_login_session_manager_proxy_gala_login_session_manager_interface_init (GalaLoginSessionManagerIface* iface)
{
	iface->set_locked_hint = gala_login_session_manager_proxy_set_locked_hint;
	iface->get_active = gala_login_session_manager_dbus_proxy_get_active;
}

static void
_dbus_gala_login_session_manager_set_locked_hint (GalaLoginSessionManager* self,
                                                  GVariant* _parameters_,
                                                  GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gboolean locked = FALSE;
	GVariant* _tmp123_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp123_ = g_variant_iter_next_value (&_arguments_iter);
	locked = g_variant_get_boolean (_tmp123_);
	g_variant_unref (_tmp123_);
	gala_login_session_manager_set_locked_hint (self, locked, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
gala_login_session_manager_dbus_interface_method_call (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* method_name,
                                                       GVariant* parameters,
                                                       GDBusMethodInvocation* invocation,
                                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "SetLockedHint") == 0) {
		_dbus_gala_login_session_manager_set_locked_hint (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
_dbus_gala_login_session_manager_get_active (GalaLoginSessionManager* self)
{
	gboolean result;
	GVariant* _reply;
	result = gala_login_session_manager_get_active (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
gala_login_session_manager_dbus_interface_get_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GError** error,
                                                        gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Active") == 0) {
		return _dbus_gala_login_session_manager_get_active (object);
	}
	return NULL;
}

static gboolean
gala_login_session_manager_dbus_interface_set_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GVariant* value,
                                                        GError** error,
                                                        gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_gala_login_session_manager_lock (GObject* _sender,
                                       gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.login1.Session", "Lock", _arguments, NULL);
}

static void
_dbus_gala_login_session_manager_unlock (GObject* _sender,
                                         gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.login1.Session", "Unlock", _arguments, NULL);
}

 G_GNUC_INTERNAL guint
gala_login_session_manager_register_object (gpointer object,
                                            GDBusConnection* connection,
                                            const gchar* path,
                                            GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_gala_login_session_manager_dbus_interface_info), &_gala_login_session_manager_dbus_interface_vtable, data, _gala_login_session_manager_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "lock", (GCallback) _dbus_gala_login_session_manager_lock, data);
	g_signal_connect (object, "unlock", (GCallback) _dbus_gala_login_session_manager_unlock, data);
	return result;
}

static void
_gala_login_session_manager_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_gala_login_session_manager_lock, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_gala_login_session_manager_unlock, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
gala_login_display_copy (const GalaLoginDisplay* self,
                         GalaLoginDisplay* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const char* _tmp2_;
	char* _tmp3_;
	_tmp0_ = (*self).session;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).session);
	(*dest).session = _tmp1_;
	_tmp2_ = (*self).objectpath;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).objectpath);
	(*dest).objectpath = _tmp3_;
}

void
gala_login_display_destroy (GalaLoginDisplay* self)
{
	_g_free0 ((*self).session);
	_g_free0 ((*self).objectpath);
}

GalaLoginDisplay*
gala_login_display_dup (const GalaLoginDisplay* self)
{
	GalaLoginDisplay* dup;
	dup = g_new0 (GalaLoginDisplay, 1);
	gala_login_display_copy (self, dup);
	return dup;
}

void
gala_login_display_free (GalaLoginDisplay* self)
{
	gala_login_display_destroy (self);
	g_free (self);
}

static GType
gala_login_display_get_type_once (void)
{
	GType gala_login_display_type_id;
	gala_login_display_type_id = g_boxed_type_register_static ("GalaLoginDisplay", (GBoxedCopyFunc) gala_login_display_dup, (GBoxedFreeFunc) gala_login_display_free);
	return gala_login_display_type_id;
}

GType
gala_login_display_get_type (void)
{
	static volatile gsize gala_login_display_type_id__once = 0;
	if (g_once_init_enter (&gala_login_display_type_id__once)) {
		GType gala_login_display_type_id;
		gala_login_display_type_id = gala_login_display_get_type_once ();
		g_once_init_leave (&gala_login_display_type_id__once, gala_login_display_type_id);
	}
	return gala_login_display_type_id__once;
}

 G_GNUC_INTERNAL GalaLoginDisplay*
gala_login_user_manager_get_display (GalaLoginUserManager* self)
{
	GalaLoginUserManagerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GALA_LOGIN_USER_MANAGER_GET_INTERFACE (self);
	if (_iface_->get_display) {
		return _iface_->get_display (self);
	}
	return NULL;
}

static void
gala_login_user_manager_default_init (GalaLoginUserManagerIface * iface,
                                      gpointer iface_data)
{
}

static GType
gala_login_user_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaLoginUserManagerIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_login_user_manager_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gala_login_user_manager_type_id;
	gala_login_user_manager_type_id = g_type_register_static (G_TYPE_INTERFACE, "GalaLoginUserManager", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gala_login_user_manager_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (gala_login_user_manager_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) gala_login_user_manager_proxy_get_type);
	g_type_set_qdata (gala_login_user_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.login1.User");
	g_type_set_qdata (gala_login_user_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_gala_login_user_manager_dbus_interface_info));
	g_type_set_qdata (gala_login_user_manager_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) gala_login_user_manager_register_object);
	return gala_login_user_manager_type_id;
}

 G_GNUC_INTERNAL GType
gala_login_user_manager_get_type (void)
{
	static volatile gsize gala_login_user_manager_type_id__once = 0;
	if (g_once_init_enter (&gala_login_user_manager_type_id__once)) {
		GType gala_login_user_manager_type_id;
		gala_login_user_manager_type_id = gala_login_user_manager_get_type_once ();
		g_once_init_leave (&gala_login_user_manager_type_id__once, gala_login_user_manager_type_id);
	}
	return gala_login_user_manager_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (GalaLoginUserManagerProxy, gala_login_user_manager_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (GALA_TYPE_LOGIN_USER_MANAGER, gala_login_user_manager_proxy_gala_login_user_manager_interface_init) )
static void
gala_login_user_manager_proxy_class_init (GalaLoginUserManagerProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = gala_login_user_manager_proxy_g_signal;
}

static void
gala_login_user_manager_proxy_g_signal (GDBusProxy* proxy,
                                        const gchar* sender_name,
                                        const gchar* signal_name,
                                        GVariant* parameters)
{
}

static void
gala_login_user_manager_proxy_init (GalaLoginUserManagerProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_gala_login_user_manager_dbus_interface_info));
}

static GalaLoginDisplay*
gala_login_user_manager_dbus_proxy_get_display (GalaLoginUserManager* self)
{
	GVariant *_inner_reply;
	GalaLoginDisplay* _result;
	GalaLoginDisplay _tmp124_;
	GVariantIter _tmp125_;
	GVariant* _tmp126_;
	GVariant* _tmp127_;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Display");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.login1.User"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Display"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	g_variant_iter_init (&_tmp125_, _inner_reply);
	_tmp126_ = g_variant_iter_next_value (&_tmp125_);
	_tmp124_.session = g_variant_dup_string (_tmp126_, NULL);
	g_variant_unref (_tmp126_);
	_tmp127_ = g_variant_iter_next_value (&_tmp125_);
	_tmp124_.objectpath = g_variant_dup_string (_tmp127_, NULL);
	g_variant_unref (_tmp127_);
	_result = _vala_memdup2 (&_tmp124_, sizeof (GalaLoginDisplay));
	g_variant_unref (_inner_reply);
	return _result;
}

static void
gala_login_user_manager_proxy_gala_login_user_manager_interface_init (GalaLoginUserManagerIface* iface)
{
	iface->get_display = gala_login_user_manager_dbus_proxy_get_display;
}

static void
gala_login_user_manager_dbus_interface_method_call (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* method_name,
                                                    GVariant* parameters,
                                                    GDBusMethodInvocation* invocation,
                                                    gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
_dbus_gala_login_user_manager_get_display (GalaLoginUserManager* self)
{
	GalaLoginDisplay* result;
	GVariant* _reply;
	GVariantBuilder _tmp128_;
	result = gala_login_user_manager_get_display (self);
	g_variant_builder_init (&_tmp128_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp128_, g_variant_new_string ((*result).session));
	g_variant_builder_add_value (&_tmp128_, g_variant_new_object_path ((*result).objectpath));
	_reply = g_variant_builder_end (&_tmp128_);
	_gala_login_display_free0 (result);
	return _reply;
}

static GVariant*
gala_login_user_manager_dbus_interface_get_property (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* property_name,
                                                     GError** error,
                                                     gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Display") == 0) {
		return _dbus_gala_login_user_manager_get_display (object);
	}
	return NULL;
}

static gboolean
gala_login_user_manager_dbus_interface_set_property (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* property_name,
                                                     GVariant* value,
                                                     GError** error,
                                                     gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

 G_GNUC_INTERNAL guint
gala_login_user_manager_register_object (gpointer object,
                                         GDBusConnection* connection,
                                         const gchar* path,
                                         GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_gala_login_user_manager_dbus_interface_info), &_gala_login_user_manager_dbus_interface_vtable, data, _gala_login_user_manager_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_gala_login_user_manager_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static GType
gala_presence_status_get_type_once (void)
{
	static const GEnumValue values[] = {{GALA_PRESENCE_STATUS_AVAILABLE, "GALA_PRESENCE_STATUS_AVAILABLE", "available"}, {GALA_PRESENCE_STATUS_INVISIBLE, "GALA_PRESENCE_STATUS_INVISIBLE", "invisible"}, {GALA_PRESENCE_STATUS_BUSY, "GALA_PRESENCE_STATUS_BUSY", "busy"}, {GALA_PRESENCE_STATUS_IDLE, "GALA_PRESENCE_STATUS_IDLE", "idle"}, {0, NULL, NULL}};
	GType gala_presence_status_type_id;
	gala_presence_status_type_id = g_enum_register_static ("GalaPresenceStatus", values);
	return gala_presence_status_type_id;
}

 G_GNUC_INTERNAL GType
gala_presence_status_get_type (void)
{
	static volatile gsize gala_presence_status_type_id__once = 0;
	if (g_once_init_enter (&gala_presence_status_type_id__once)) {
		GType gala_presence_status_type_id;
		gala_presence_status_type_id = gala_presence_status_get_type_once ();
		g_once_init_leave (&gala_presence_status_type_id__once, gala_presence_status_type_id);
	}
	return gala_presence_status_type_id__once;
}

 G_GNUC_INTERNAL GalaPresenceStatus
gala_session_presence_get_status (GalaSessionPresence* self)
{
	GalaSessionPresenceIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = GALA_SESSION_PRESENCE_GET_INTERFACE (self);
	if (_iface_->get_status) {
		return _iface_->get_status (self);
	}
	return 0;
}

static void
gala_session_presence_default_init (GalaSessionPresenceIface * iface,
                                    gpointer iface_data)
{
	gala_session_presence_signals[GALA_SESSION_PRESENCE_STATUS_CHANGED_SIGNAL] = g_signal_new ("status-changed", GALA_TYPE_SESSION_PRESENCE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__ENUM, G_TYPE_NONE, 1, GALA_TYPE_PRESENCE_STATUS);
}

static GType
gala_session_presence_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaSessionPresenceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_session_presence_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gala_session_presence_type_id;
	gala_session_presence_type_id = g_type_register_static (G_TYPE_INTERFACE, "GalaSessionPresence", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gala_session_presence_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (gala_session_presence_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) gala_session_presence_proxy_get_type);
	g_type_set_qdata (gala_session_presence_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.SessionManager.Presence");
	g_type_set_qdata (gala_session_presence_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_gala_session_presence_dbus_interface_info));
	g_type_set_qdata (gala_session_presence_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) gala_session_presence_register_object);
	return gala_session_presence_type_id;
}

 G_GNUC_INTERNAL GType
gala_session_presence_get_type (void)
{
	static volatile gsize gala_session_presence_type_id__once = 0;
	if (g_once_init_enter (&gala_session_presence_type_id__once)) {
		GType gala_session_presence_type_id;
		gala_session_presence_type_id = gala_session_presence_get_type_once ();
		g_once_init_leave (&gala_session_presence_type_id__once, gala_session_presence_type_id);
	}
	return gala_session_presence_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (GalaSessionPresenceProxy, gala_session_presence_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (GALA_TYPE_SESSION_PRESENCE, gala_session_presence_proxy_gala_session_presence_interface_init) )
static void
gala_session_presence_proxy_class_init (GalaSessionPresenceProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = gala_session_presence_proxy_g_signal;
}

static void
_dbus_handle_gala_session_presence_status_changed (GalaSessionPresence* self,
                                                   GVariant* parameters)
{
	GVariantIter _arguments_iter;
	GalaPresenceStatus new_status = 0;
	GVariant* _tmp129_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp129_ = g_variant_iter_next_value (&_arguments_iter);
	new_status = g_variant_get_uint32 (_tmp129_);
	g_variant_unref (_tmp129_);
	g_signal_emit_by_name (self, "status-changed", new_status);
}

static void
gala_session_presence_proxy_g_signal (GDBusProxy* proxy,
                                      const gchar* sender_name,
                                      const gchar* signal_name,
                                      GVariant* parameters)
{
	if (strcmp (signal_name, "StatusChanged") == 0) {
		_dbus_handle_gala_session_presence_status_changed ((GalaSessionPresence*) proxy, parameters);
	}
}

static void
gala_session_presence_proxy_init (GalaSessionPresenceProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_gala_session_presence_dbus_interface_info));
}

static GalaPresenceStatus
gala_session_presence_dbus_proxy_get_status (GalaSessionPresence* self)
{
	GVariant *_inner_reply;
	GalaPresenceStatus _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Status");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.gnome.SessionManager.Presence"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Status"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return 0;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_uint32 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
gala_session_presence_proxy_gala_session_presence_interface_init (GalaSessionPresenceIface* iface)
{
	iface->get_status = gala_session_presence_dbus_proxy_get_status;
}

static void
gala_session_presence_dbus_interface_method_call (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* method_name,
                                                  GVariant* parameters,
                                                  GDBusMethodInvocation* invocation,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
_dbus_gala_session_presence_get_status (GalaSessionPresence* self)
{
	GalaPresenceStatus result;
	GVariant* _reply;
	result = gala_session_presence_get_status (self);
	_reply = g_variant_new_uint32 (result);
	return _reply;
}

static GVariant*
gala_session_presence_dbus_interface_get_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GError** error,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Status") == 0) {
		return _dbus_gala_session_presence_get_status (object);
	}
	return NULL;
}

static gboolean
gala_session_presence_dbus_interface_set_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GVariant* value,
                                                   GError** error,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_gala_session_presence_status_changed (GObject* _sender,
                                            GalaPresenceStatus new_status,
                                            gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (new_status));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.SessionManager.Presence", "StatusChanged", _arguments, NULL);
}

 G_GNUC_INTERNAL guint
gala_session_presence_register_object (gpointer object,
                                       GDBusConnection* connection,
                                       const gchar* path,
                                       GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_gala_session_presence_dbus_interface_info), &_gala_session_presence_dbus_interface_vtable, data, _gala_session_presence_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "status-changed", (GCallback) _dbus_gala_session_presence_status_changed, data);
	return result;
}

static void
_gala_session_presence_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_gala_session_presence_status_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
gala_display_manager_seat_switch_to_greeter (GalaDisplayManagerSeat* self,
                                             GError** error)
{
	GalaDisplayManagerSeatIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GALA_DISPLAY_MANAGER_SEAT_GET_INTERFACE (self);
	if (_iface_->switch_to_greeter) {
		_iface_->switch_to_greeter (self, error);
	}
}

static void
gala_display_manager_seat_default_init (GalaDisplayManagerSeatIface * iface,
                                        gpointer iface_data)
{
}

static GType
gala_display_manager_seat_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaDisplayManagerSeatIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_display_manager_seat_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gala_display_manager_seat_type_id;
	gala_display_manager_seat_type_id = g_type_register_static (G_TYPE_INTERFACE, "GalaDisplayManagerSeat", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gala_display_manager_seat_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (gala_display_manager_seat_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) gala_display_manager_seat_proxy_get_type);
	g_type_set_qdata (gala_display_manager_seat_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.DisplayManager.Seat");
	g_type_set_qdata (gala_display_manager_seat_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_gala_display_manager_seat_dbus_interface_info));
	g_type_set_qdata (gala_display_manager_seat_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) gala_display_manager_seat_register_object);
	return gala_display_manager_seat_type_id;
}

 G_GNUC_INTERNAL GType
gala_display_manager_seat_get_type (void)
{
	static volatile gsize gala_display_manager_seat_type_id__once = 0;
	if (g_once_init_enter (&gala_display_manager_seat_type_id__once)) {
		GType gala_display_manager_seat_type_id;
		gala_display_manager_seat_type_id = gala_display_manager_seat_get_type_once ();
		g_once_init_leave (&gala_display_manager_seat_type_id__once, gala_display_manager_seat_type_id);
	}
	return gala_display_manager_seat_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (GalaDisplayManagerSeatProxy, gala_display_manager_seat_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (GALA_TYPE_DISPLAY_MANAGER_SEAT, gala_display_manager_seat_proxy_gala_display_manager_seat_interface_init) )
static void
gala_display_manager_seat_proxy_class_init (GalaDisplayManagerSeatProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = gala_display_manager_seat_proxy_g_signal;
}

static void
gala_display_manager_seat_proxy_g_signal (GDBusProxy* proxy,
                                          const gchar* sender_name,
                                          const gchar* signal_name,
                                          GVariant* parameters)
{
}

static void
gala_display_manager_seat_proxy_init (GalaDisplayManagerSeatProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_gala_display_manager_seat_dbus_interface_info));
}

static void
gala_display_manager_seat_proxy_switch_to_greeter (GalaDisplayManagerSeat* self,
                                                   GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.DisplayManager.Seat", "SwitchToGreeter");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
gala_display_manager_seat_proxy_gala_display_manager_seat_interface_init (GalaDisplayManagerSeatIface* iface)
{
	iface->switch_to_greeter = gala_display_manager_seat_proxy_switch_to_greeter;
}

static void
_dbus_gala_display_manager_seat_switch_to_greeter (GalaDisplayManagerSeat* self,
                                                   GVariant* _parameters_,
                                                   GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	gala_display_manager_seat_switch_to_greeter (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
gala_display_manager_seat_dbus_interface_method_call (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* method_name,
                                                      GVariant* parameters,
                                                      GDBusMethodInvocation* invocation,
                                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "SwitchToGreeter") == 0) {
		_dbus_gala_display_manager_seat_switch_to_greeter (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
gala_display_manager_seat_dbus_interface_get_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GError** error,
                                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
gala_display_manager_seat_dbus_interface_set_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GVariant* value,
                                                       GError** error,
                                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

 G_GNUC_INTERNAL guint
gala_display_manager_seat_register_object (gpointer object,
                                           GDBusConnection* connection,
                                           const gchar* path,
                                           GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_gala_display_manager_seat_dbus_interface_info), &_gala_display_manager_seat_dbus_interface_vtable, data, _gala_display_manager_seat_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_gala_display_manager_seat_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
gala_screen_shield_get_instance_private (GalaScreenShield* self)
{
	return G_STRUCT_MEMBER_P (self, GalaScreenShield_private_offset);
}

GalaScreenShield*
gala_screen_shield_construct (GType object_type,
                              GalaWindowManager* wm)
{
	GalaScreenShield * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	self = (GalaScreenShield*) g_object_new (object_type, "wm", wm, NULL);
	return self;
}

GalaScreenShield*
gala_screen_shield_new (GalaWindowManager* wm)
{
	return gala_screen_shield_construct (GALA_TYPE_SCREEN_SHIELD, wm);
}

static void
gala_screen_shield_init_dbus_interfaces_data_free (gpointer _data)
{
	GalaScreenShieldInitDbusInterfacesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GalaScreenShieldInitDbusInterfacesData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gala_screen_shield_init_dbus_interfaces (GalaScreenShield* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	GalaScreenShieldInitDbusInterfacesData* _data_;
	GalaScreenShield* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GalaScreenShieldInitDbusInterfacesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gala_screen_shield_init_dbus_interfaces_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	gala_screen_shield_init_dbus_interfaces_co (_data_);
}

static void
gala_screen_shield_init_dbus_interfaces_finish (GalaScreenShield* self,
                                                GAsyncResult* _res_)
{
	GalaScreenShieldInitDbusInterfacesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
gala_screen_shield_init_dbus_interfaces_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	GalaScreenShieldInitDbusInterfacesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gala_screen_shield_init_dbus_interfaces_co (_data_);
}

static void
_gala_screen_shield_prepare_for_sleep_gala_login_manager_prepare_for_sleep (GalaLoginManager* _sender,
                                                                            gboolean about_to_suspend,
                                                                            gpointer self)
{
	gala_screen_shield_prepare_for_sleep ((GalaScreenShield*) self, about_to_suspend);
}

static void
____lambda30_ (GalaScreenShield* self)
{
	gala_screen_shield_lock (self, FALSE);
}

static void
_____lambda30__gala_login_session_manager_lock (GalaLoginSessionManager* _sender,
                                                gpointer self)
{
	____lambda30_ ((GalaScreenShield*) self);
}

static void
____lambda31_ (GalaScreenShield* self)
{
	gala_screen_shield_deactivate (self, FALSE);
	gala_screen_shield_set_in_greeter (self, FALSE);
}

static void
_____lambda31__gala_login_session_manager_unlock (GalaLoginSessionManager* _sender,
                                                  gpointer self)
{
	____lambda31_ ((GalaScreenShield*) self);
}

static void
_gala_screen_shield_sync_inhibitor_g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                      GVariant* changed_properties,
                                                                      gchar** invalidated_properties,
                                                                      gpointer self)
{
	gala_screen_shield_sync_inhibitor ((GalaScreenShield*) self);
}

static void
___lambda32_ (GalaScreenShield* self,
              GalaPresenceStatus status)
{
	gala_screen_shield_on_status_changed (self, status);
}

static void
____lambda32__gala_session_presence_status_changed (GalaSessionPresence* _sender,
                                                    GalaPresenceStatus new_status,
                                                    gpointer self)
{
	___lambda32_ ((GalaScreenShield*) self, new_status);
}

static gboolean
gala_screen_shield_init_dbus_interfaces_co (GalaScreenShieldInitDbusInterfacesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->success = TRUE;
	{
		_data_->_state_ = 1;
		g_async_initable_new_async (GALA_TYPE_LOGIN_MANAGER_PROXY, 0, NULL, gala_screen_shield_init_dbus_interfaces_ready, _data_, "g-flags", 0, "g-name", "org.freedesktop.login1", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/freedesktop/login1", "g-interface-name", "org.freedesktop.login1.Manager", NULL);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = (GalaLoginManager*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = (GalaLoginManager*) _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->self->priv->login_manager);
		_data_->self->priv->login_manager = _data_->_tmp2_;
		_data_->_state_ = 2;
		g_async_initable_new_async (GALA_TYPE_LOGIN_USER_MANAGER_PROXY, 0, NULL, gala_screen_shield_init_dbus_interfaces_ready, _data_, "g-flags", 0, "g-name", "org.freedesktop.login1", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/freedesktop/login1/user/self", "g-interface-name", "org.freedesktop.login1.User", NULL);
		return FALSE;
		_state_2:
		_data_->_tmp4_ = (GalaLoginUserManager*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp3_ = (GalaLoginUserManager*) _data_->_tmp4_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->_tmp0_);
			goto __catch0_g_error;
		}
		_data_->_tmp5_ = _data_->_tmp3_;
		_data_->_tmp3_ = NULL;
		_g_object_unref0 (_data_->self->priv->login_user_manager);
		_data_->self->priv->login_user_manager = _data_->_tmp5_;
		_data_->_tmp6_ = _data_->self->priv->login_manager;
		g_signal_connect_object (_data_->_tmp6_, "prepare-for-sleep", (GCallback) _gala_screen_shield_prepare_for_sleep_gala_login_manager_prepare_for_sleep, _data_->self, 0);
		_data_->_tmp8_ = gala_screen_shield_get_current_session_manager (_data_->self, &_data_->_inner_error0_);
		_data_->_tmp7_ = _data_->_tmp8_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->_tmp3_);
			_g_object_unref0 (_data_->_tmp0_);
			goto __catch0_g_error;
		}
		_data_->_tmp9_ = _data_->_tmp7_;
		_data_->_tmp7_ = NULL;
		_g_object_unref0 (_data_->self->priv->login_session);
		_data_->self->priv->login_session = _data_->_tmp9_;
		_data_->_tmp10_ = _data_->self->priv->login_session;
		if (_data_->_tmp10_ != NULL) {
			_data_->_tmp11_ = _data_->self->priv->login_session;
			g_signal_connect_object (_data_->_tmp11_, "lock", (GCallback) _____lambda30__gala_login_session_manager_lock, _data_->self, 0);
			_data_->_tmp12_ = _data_->self->priv->login_session;
			g_signal_connect_object (_data_->_tmp12_, "unlock", (GCallback) _____lambda31__gala_login_session_manager_unlock, _data_->self, 0);
			_data_->_tmp13_ = _data_->self->priv->login_session;
			g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp13_, g_dbus_proxy_get_type (), GDBusProxy), "g-properties-changed", (GCallback) _gala_screen_shield_sync_inhibitor_g_dbus_proxy_g_properties_changed, _data_->self, 0);
			gala_screen_shield_sync_inhibitor (_data_->self);
		}
		_g_object_unref0 (_data_->_tmp7_);
		_g_object_unref0 (_data_->_tmp3_);
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->success = FALSE;
		_data_->_tmp14_ = _data_->e;
		_data_->_tmp15_ = _data_->_tmp14_->message;
		g_critical ("ScreenShield.vala:165: Unable to connect to logind bus, screen locking" \
" disabled: %s", _data_->_tmp15_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_state_ = 3;
		g_async_initable_new_async (GALA_TYPE_SESSION_PRESENCE_PROXY, 0, NULL, gala_screen_shield_init_dbus_interfaces_ready, _data_, "g-flags", 0, "g-name", "org.gnome.SessionManager", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/gnome/SessionManager/Presence", "g-interface-name", "org.gnome.SessionManager.Presence", NULL);
		return FALSE;
		_state_3:
		_data_->_tmp17_ = (GalaSessionPresence*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp16_ = (GalaSessionPresence*) _data_->_tmp17_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_data_->_tmp18_ = _data_->_tmp16_;
		_data_->_tmp16_ = NULL;
		_g_object_unref0 (_data_->self->priv->session_presence);
		_data_->self->priv->session_presence = _data_->_tmp18_;
		_data_->_tmp19_ = _data_->self->priv->session_presence;
		_data_->_tmp20_ = gala_session_presence_get_status (_data_->_tmp19_);
		_data_->_tmp21_ = _data_->_tmp20_;
		gala_screen_shield_on_status_changed (_data_->self, _data_->_tmp21_);
		_data_->_tmp22_ = _data_->self->priv->session_presence;
		g_signal_connect_object (_data_->_tmp22_, "status-changed", (GCallback) ____lambda32__gala_session_presence_status_changed, _data_->self, 0);
		_g_object_unref0 (_data_->_tmp16_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->success = FALSE;
		_data_->_tmp23_ = _data_->_vala1_e;
		_data_->_tmp24_ = _data_->_tmp23_->message;
		g_critical ("ScreenShield.vala:174: Unable to connect to session presence bus, scre" \
"en locking disabled: %s", _data_->_tmp24_);
		_g_error_free0 (_data_->_vala1_e);
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp25_ = g_getenv ("XDG_SEAT_PATH");
	_data_->_tmp26_ = g_strdup (_data_->_tmp25_);
	_data_->seat_path = _data_->_tmp26_;
	_data_->_tmp27_ = _data_->seat_path;
	if (_data_->_tmp27_ != NULL) {
		{
			_data_->_tmp29_ = _data_->seat_path;
			_data_->_state_ = 4;
			g_async_initable_new_async (GALA_TYPE_DISPLAY_MANAGER_SEAT_PROXY, 0, NULL, gala_screen_shield_init_dbus_interfaces_ready, _data_, "g-flags", 0, "g-name", "org.freedesktop.DisplayManager", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", _data_->_tmp29_, "g-interface-name", "org.freedesktop.DisplayManager.Seat", NULL);
			return FALSE;
			_state_4:
			_data_->_tmp30_ = (GalaDisplayManagerSeat*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp28_ = (GalaDisplayManagerSeat*) _data_->_tmp30_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch2_g_error;
			}
			_data_->_tmp31_ = _data_->_tmp28_;
			_data_->_tmp28_ = NULL;
			_g_object_unref0 (_data_->self->priv->display_manager);
			_data_->self->priv->display_manager = _data_->_tmp31_;
			_g_object_unref0 (_data_->_tmp28_);
		}
		goto __finally2;
		__catch2_g_error:
		{
			g_clear_error (&_data_->_inner_error0_);
			_data_->success = FALSE;
			g_critical ("ScreenShield.vala:184: Unable to connect to display manager bus, scree" \
"n locking disabled");
		}
		__finally2:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->seat_path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	} else {
		_data_->success = FALSE;
		g_critical ("ScreenShield.vala:188: XDG_SEAT_PATH unset, screen locking disabled");
	}
	_data_->self->priv->connected_to_buses = _data_->success;
	_g_free0 (_data_->seat_path);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
gala_screen_shield_expand_to_screen_size (GalaScreenShield* self)
{
	gint screen_width = 0;
	gint screen_height = 0;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	meta_display_get_size (_tmp1_, &_tmp2_, &_tmp3_);
	screen_width = _tmp2_;
	screen_height = _tmp3_;
	clutter_actor_set_width ((ClutterActor*) self, (gfloat) screen_width);
	clutter_actor_set_height ((ClutterActor*) self, (gfloat) screen_height);
}

static void
gala_screen_shield_prepare_for_sleep (GalaScreenShield* self,
                                      gboolean about_to_suspend)
{
	g_return_if_fail (self != NULL);
	if (!self->priv->connected_to_buses) {
		return;
	}
	if (about_to_suspend) {
		GSettings* _tmp0_;
		_tmp0_ = self->priv->gala_settings;
		if (g_settings_get_boolean (_tmp0_, GALA_SCREEN_SHIELD_LOCK_ON_SUSPEND_KEY)) {
			g_debug ("ScreenShield.vala:208: about to sleep, locking screen");
			gala_screen_shield_lock (self, FALSE);
		}
	} else {
		g_debug ("ScreenShield.vala:212: resumed from suspend, waking screen");
		gala_screen_shield_on_user_became_active (self);
		g_signal_emit (self, gala_screen_shield_signals[GALA_SCREEN_SHIELD_WAKE_UP_SCREEN_SIGNAL], 0);
		gala_screen_shield_expand_to_screen_size (self);
	}
}

static void
gala_screen_shield_on_status_changed (GalaScreenShield* self,
                                      GalaPresenceStatus status)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (status != GALA_PRESENCE_STATUS_IDLE) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !self->priv->connected_to_buses;
	}
	if (_tmp0_) {
		return;
	}
	g_debug ("ScreenShield.vala:225: session became idle, activating screensaver");
	gala_screen_shield_activate (self, TRUE, GALA_SCREEN_SHIELD_LONG_ANIMATION_TIME);
}

static void
gala_screen_shield_sync_inhibitor (GalaScreenShield* self)
{
	gboolean lock_enabled = FALSE;
	GSettings* _tmp0_;
	gboolean lock_prohibited = FALSE;
	GSettings* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	GalaLoginSessionManager* _tmp6_;
	gboolean inhibit = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (!self->priv->connected_to_buses) {
		return;
	}
	_tmp0_ = self->priv->gala_settings;
	lock_enabled = g_settings_get_boolean (_tmp0_, GALA_SCREEN_SHIELD_LOCK_ON_SUSPEND_KEY);
	_tmp1_ = self->priv->lockdown_settings;
	lock_prohibited = g_settings_get_boolean (_tmp1_, GALA_SCREEN_SHIELD_LOCK_PROHIBITED_KEY);
	_tmp6_ = self->priv->login_session;
	if (_tmp6_ != NULL) {
		GalaLoginSessionManager* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp7_ = self->priv->login_session;
		_tmp8_ = gala_login_session_manager_get_active (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp5_ = _tmp9_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		gboolean _tmp10_;
		_tmp10_ = self->priv->_active;
		_tmp4_ = !_tmp10_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = lock_enabled;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = !lock_prohibited;
	} else {
		_tmp2_ = FALSE;
	}
	inhibit = _tmp2_;
	if (inhibit) {
		{
			GUnixInputStream* new_inhibitor = NULL;
			GalaLoginManager* _tmp11_;
			GUnixInputStream* _tmp12_;
			GUnixInputStream* _tmp13_;
			GUnixInputStream* _tmp15_;
			GUnixInputStream* _tmp16_;
			_tmp11_ = self->priv->login_manager;
			_tmp12_ = gala_login_manager_inhibit (_tmp11_, "sleep", "Pantheon", "Pantheon needs to lock the screen", "delay", &_inner_error0_);
			new_inhibitor = _tmp12_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp13_ = self->priv->inhibitor;
			if (_tmp13_ != NULL) {
				GUnixInputStream* _tmp14_;
				_tmp14_ = self->priv->inhibitor;
				g_input_stream_close ((GInputStream*) _tmp14_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (new_inhibitor);
					goto __catch0_g_error;
				}
				_g_object_unref0 (self->priv->inhibitor);
				self->priv->inhibitor = NULL;
			}
			_tmp15_ = new_inhibitor;
			_tmp16_ = _g_object_ref0 (_tmp15_);
			_g_object_unref0 (self->priv->inhibitor);
			self->priv->inhibitor = _tmp16_;
			_g_object_unref0 (new_inhibitor);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp17_;
			const gchar* _tmp18_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp17_ = e;
			_tmp18_ = _tmp17_->message;
			g_warning ("ScreenShield.vala:250: Unable to inhibit sleep, may be unable to lock " \
"before sleep starts: %s", _tmp18_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		GUnixInputStream* _tmp19_;
		_tmp19_ = self->priv->inhibitor;
		if (_tmp19_ != NULL) {
			{
				GUnixInputStream* _tmp20_;
				_tmp20_ = self->priv->inhibitor;
				g_input_stream_close ((GInputStream*) _tmp20_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GError* _tmp21_;
				const gchar* _tmp22_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp21_ = e;
				_tmp22_ = _tmp21_->message;
				g_warning ("ScreenShield.vala:257: Unable to remove sleep inhibitor: %s", _tmp22_);
				_g_error_free0 (e);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_g_object_unref0 (self->priv->inhibitor);
			self->priv->inhibitor = NULL;
		}
	}
}

static void
gala_screen_shield_on_user_became_active (GalaScreenShield* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (!self->priv->connected_to_buses) {
		return;
	}
	_tmp1_ = self->priv->_is_locked;
	if (_tmp1_) {
		gboolean _tmp2_;
		_tmp2_ = self->priv->_in_greeter;
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_debug ("ScreenShield.vala:272: user became active, switching to greeter");
		gala_screen_shield_cancel_animation (self);
		{
			GalaDisplayManagerSeat* _tmp3_;
			_tmp3_ = self->priv->display_manager;
			gala_display_manager_seat_switch_to_greeter (_tmp3_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			gala_screen_shield_set_in_greeter (self, TRUE);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp4_;
			const gchar* _tmp5_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			g_critical ("ScreenShield.vala:278: Unable to switch to greeter to unlock: %s", _tmp5_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		gboolean _tmp6_;
		_tmp6_ = self->priv->_is_locked;
		if (!_tmp6_) {
			g_debug ("ScreenShield.vala:282: user became active in unlocked session, closing" \
" screensaver");
			gala_screen_shield_deactivate (self, FALSE);
		}
	}
}

static GalaLoginSessionManager*
gala_screen_shield_get_current_session_manager (GalaScreenShield* self,
                                                GError** error)
{
	gchar* session_id = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp10_;
	char* session_path = NULL;
	GalaLoginManager* _tmp11_;
	const gchar* _tmp12_;
	char* _tmp13_;
	GalaLoginSessionManager* session = NULL;
	const char* _tmp14_;
	GalaLoginSessionManager* _tmp15_;
	GError* _inner_error0_ = NULL;
	GalaLoginSessionManager* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_getenv ("XDG_SESSION_ID");
	_tmp1_ = g_strdup (_tmp0_);
	session_id = _tmp1_;
	_tmp2_ = session_id;
	if (_tmp2_ == NULL) {
		GalaLoginUserManager* _tmp3_;
		GalaLoginUserManager* _tmp4_;
		GalaLoginDisplay* _tmp5_;
		GalaLoginDisplay* _tmp6_;
		GalaLoginDisplay* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		g_debug ("ScreenShield.vala:290: Unset XDG_SESSION_ID, asking logind");
		_tmp3_ = self->priv->login_user_manager;
		if (_tmp3_ == NULL) {
			result = NULL;
			_g_free0 (session_id);
			return result;
		}
		_tmp4_ = self->priv->login_user_manager;
		_tmp5_ = gala_login_user_manager_get_display (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = (*_tmp7_).session;
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (session_id);
		session_id = _tmp9_;
		_gala_login_display_free0 (_tmp7_);
	}
	_tmp10_ = session_id;
	if (_tmp10_ == NULL) {
		result = NULL;
		_g_free0 (session_id);
		return result;
	}
	_tmp11_ = self->priv->login_manager;
	_tmp12_ = session_id;
	_tmp13_ = gala_login_manager_get_session (_tmp11_, _tmp12_, &_inner_error0_);
	session_path = _tmp13_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (session_id);
		return NULL;
	}
	_tmp14_ = session_path;
	_tmp15_ = (GalaLoginSessionManager*) g_initable_new (GALA_TYPE_LOGIN_SESSION_MANAGER_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.freedesktop.login1", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", (const gchar*) _tmp14_, "g-interface-name", "org.freedesktop.login1.Session", NULL);
	session = (GalaLoginSessionManager*) _tmp15_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (session_path);
		_g_free0 (session_id);
		return NULL;
	}
	result = session;
	_g_free0 (session_path);
	_g_free0 (session_id);
	return result;
}

void
gala_screen_shield_lock (GalaScreenShield* self,
                         gboolean animate)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GSettings* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_is_locked;
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !self->priv->connected_to_buses;
	}
	if (_tmp0_) {
		return;
	}
	_tmp2_ = self->priv->lockdown_settings;
	if (g_settings_get_boolean (_tmp2_, GALA_SCREEN_SHIELD_LOCK_PROHIBITED_KEY)) {
		g_debug ("ScreenShield.vala:314: Lock prohibited, ignoring lock request");
		return;
	}
	gala_screen_shield_set_is_locked (self, TRUE);
	gala_screen_shield_activate (self, animate, GALA_SCREEN_SHIELD_SHORT_ANIMATION_TIME);
}

void
gala_screen_shield_activate (GalaScreenShield* self,
                             gboolean animate,
                             guint animation_time)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gint64 _tmp3_;
	GalaWindowManager* _tmp4_;
	MetaDisplay* _tmp5_;
	MetaCursorTracker* _tmp6_;
	GalaWindowManager* _tmp7_;
	GalaModalProxy* _tmp8_;
	g_return_if_fail (self != NULL);
	g_object_get ((ClutterActor*) self, "visible", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !self->priv->connected_to_buses;
	}
	if (_tmp0_) {
		return;
	}
	gala_screen_shield_expand_to_screen_size (self);
	_tmp3_ = self->priv->_activation_time;
	if (_tmp3_ == ((gint64) 0)) {
		gala_screen_shield_set_activation_time (self, g_get_monotonic_time ());
	}
	_tmp4_ = self->priv->_wm;
	_tmp5_ = meta_plugin_get_display ((MetaPlugin*) _tmp4_);
	_tmp6_ = meta_cursor_tracker_get_for_display (_tmp5_);
	meta_cursor_tracker_set_pointer_visible (_tmp6_, FALSE);
	g_object_set ((ClutterActor*) self, "visible", TRUE, NULL);
	clutter_actor_grab_key_focus ((ClutterActor*) self);
	_tmp7_ = self->priv->_wm;
	_tmp8_ = gala_window_manager_push_modal (_tmp7_);
	_g_object_unref0 (self->priv->modal_proxy);
	self->priv->modal_proxy = _tmp8_;
	if (animate) {
		gala_screen_shield_animate_and_lock (self, animation_time);
	} else {
		GSettings* _tmp9_;
		_gala_screen_shield_set_active (self, TRUE);
		clutter_actor_set_opacity ((ClutterActor*) self, (guint) 255);
		_tmp9_ = self->priv->screensaver_settings;
		if (g_settings_get_boolean (_tmp9_, GALA_SCREEN_SHIELD_LOCK_ENABLED_KEY)) {
			gala_screen_shield_lock (self, FALSE);
		}
	}
}

static gboolean
__lambda29_ (GalaScreenShield* self)
{
	GSettings* _tmp0_;
	gboolean result;
	self->priv->animate_id = (guint) 0;
	clutter_actor_restore_easing_state ((ClutterActor*) self);
	_gala_screen_shield_set_active (self, TRUE);
	_tmp0_ = self->priv->screensaver_settings;
	if (g_settings_get_boolean (_tmp0_, GALA_SCREEN_SHIELD_LOCK_ENABLED_KEY)) {
		gala_screen_shield_lock (self, FALSE);
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda29__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda29_ ((GalaScreenShield*) self);
	return result;
}

static void
gala_screen_shield_animate_and_lock (GalaScreenShield* self,
                                     guint animation_time)
{
	g_return_if_fail (self != NULL);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 0);
	clutter_actor_save_easing_state ((ClutterActor*) self);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_QUAD);
	clutter_actor_set_easing_duration ((ClutterActor*) self, animation_time);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 255);
	self->priv->animate_id = g_timeout_add_full (G_PRIORITY_DEFAULT, animation_time, ___lambda29__gsource_func, g_object_ref (self), g_object_unref);
}

static void
gala_screen_shield_cancel_animation (GalaScreenShield* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->animate_id != ((guint) 0)) {
		g_source_remove (self->priv->animate_id);
		self->priv->animate_id = (guint) 0;
		clutter_actor_restore_easing_state ((ClutterActor*) self);
	}
}

void
gala_screen_shield_deactivate (GalaScreenShield* self,
                               gboolean animate)
{
	GalaModalProxy* _tmp0_;
	GalaWindowManager* _tmp3_;
	MetaDisplay* _tmp4_;
	MetaCursorTracker* _tmp5_;
	g_return_if_fail (self != NULL);
	if (!self->priv->connected_to_buses) {
		return;
	}
	gala_screen_shield_cancel_animation (self);
	gala_screen_shield_set_is_locked (self, FALSE);
	_tmp0_ = self->priv->modal_proxy;
	if (_tmp0_ != NULL) {
		GalaWindowManager* _tmp1_;
		GalaModalProxy* _tmp2_;
		_tmp1_ = self->priv->_wm;
		_tmp2_ = self->priv->modal_proxy;
		gala_window_manager_pop_modal (_tmp1_, _tmp2_);
		_g_object_unref0 (self->priv->modal_proxy);
		self->priv->modal_proxy = NULL;
	}
	_tmp3_ = self->priv->_wm;
	_tmp4_ = meta_plugin_get_display ((MetaPlugin*) _tmp3_);
	_tmp5_ = meta_cursor_tracker_get_for_display (_tmp4_);
	meta_cursor_tracker_set_pointer_visible (_tmp5_, TRUE);
	g_object_set ((ClutterActor*) self, "visible", FALSE, NULL);
	g_signal_emit (self, gala_screen_shield_signals[GALA_SCREEN_SHIELD_WAKE_UP_SCREEN_SIGNAL], 0);
	gala_screen_shield_set_activation_time (self, (gint64) 0);
	_gala_screen_shield_set_active (self, FALSE);
}

static void
_gala_screen_shield_set_active (GalaScreenShield* self,
                                gboolean new_active)
{
	gboolean prev_is_active = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (!self->priv->connected_to_buses) {
		return;
	}
	_tmp0_ = self->priv->_active;
	prev_is_active = _tmp0_;
	gala_screen_shield_set_active (self, new_active);
	_tmp1_ = self->priv->_active;
	if (prev_is_active != _tmp1_) {
		g_signal_emit (self, gala_screen_shield_signals[GALA_SCREEN_SHIELD_ACTIVE_CHANGED_SIGNAL], 0);
	}
	{
		GalaLoginSessionManager* _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = self->priv->login_session;
		_tmp3_ = self->priv->_active;
		gala_login_session_manager_set_locked_hint (_tmp2_, _tmp3_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("ScreenShield.vala:421: Unable to set locked hint on login session: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	gala_screen_shield_sync_inhibitor (self);
}

gboolean
gala_screen_shield_get_active (GalaScreenShield* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_active;
	return result;
}

static void
gala_screen_shield_set_active (GalaScreenShield* self,
                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_screen_shield_get_active (self);
	if (old_value != value) {
		self->priv->_active = value;
		g_object_notify_by_pspec ((GObject *) self, gala_screen_shield_properties[GALA_SCREEN_SHIELD_ACTIVE_PROPERTY]);
	}
}

gboolean
gala_screen_shield_get_is_locked (GalaScreenShield* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_locked;
	return result;
}

static void
gala_screen_shield_set_is_locked (GalaScreenShield* self,
                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_screen_shield_get_is_locked (self);
	if (old_value != value) {
		self->priv->_is_locked = value;
		g_object_notify_by_pspec ((GObject *) self, gala_screen_shield_properties[GALA_SCREEN_SHIELD_IS_LOCKED_PROPERTY]);
	}
}

gboolean
gala_screen_shield_get_in_greeter (GalaScreenShield* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_in_greeter;
	return result;
}

static void
gala_screen_shield_set_in_greeter (GalaScreenShield* self,
                                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_screen_shield_get_in_greeter (self);
	if (old_value != value) {
		self->priv->_in_greeter = value;
		g_object_notify_by_pspec ((GObject *) self, gala_screen_shield_properties[GALA_SCREEN_SHIELD_IN_GREETER_PROPERTY]);
	}
}

gint64
gala_screen_shield_get_activation_time (GalaScreenShield* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_activation_time;
	return result;
}

static void
gala_screen_shield_set_activation_time (GalaScreenShield* self,
                                        gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_screen_shield_get_activation_time (self);
	if (old_value != value) {
		self->priv->_activation_time = value;
		g_object_notify_by_pspec ((GObject *) self, gala_screen_shield_properties[GALA_SCREEN_SHIELD_ACTIVATION_TIME_PROPERTY]);
	}
}

GalaWindowManager*
gala_screen_shield_get_wm (GalaScreenShield* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static void
gala_screen_shield_set_wm (GalaScreenShield* self,
                           GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_screen_shield_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_screen_shield_properties[GALA_SCREEN_SHIELD_WM_PROPERTY]);
	}
}

static gboolean
_gala_screen_shield___lambda33_ (GalaScreenShield* self,
                                 ClutterKeyEvent* event)
{
	g_return_val_if_fail (event != NULL, FALSE);
	gala_screen_shield_on_user_became_active (self);
}

static gboolean
__gala_screen_shield___lambda33__clutter_actor_key_press_event (ClutterActor* _sender,
                                                                ClutterKeyEvent* event,
                                                                gpointer self)
{
	gboolean result;
	result = _gala_screen_shield___lambda33_ ((GalaScreenShield*) self, event);
	return result;
}

static gboolean
_gala_screen_shield___lambda34_ (GalaScreenShield* self,
                                 ClutterMotionEvent* event)
{
	g_return_val_if_fail (event != NULL, FALSE);
	gala_screen_shield_on_user_became_active (self);
}

static gboolean
__gala_screen_shield___lambda34__clutter_actor_motion_event (ClutterActor* _sender,
                                                             ClutterMotionEvent* event,
                                                             gpointer self)
{
	gboolean result;
	result = _gala_screen_shield___lambda34_ ((GalaScreenShield*) self, event);
	return result;
}

static ClutterColor*
_vala_clutter_color_from_string (const gchar* str)
{
	ClutterColor* color = NULL;
	ClutterColor* _tmp0_;
	ClutterColor* result;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = clutter_color_alloc ();
	color = _tmp0_;
	clutter_color_from_string (color, str);
	result = color;
	return result;
}

static void
_vala_ClutterColor_free (ClutterColor* self)
{
	g_boxed_free (clutter_color_get_type (), self);
}

static GObject *
gala_screen_shield_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaScreenShield * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	ClutterColor* _tmp3_;
	ClutterColor* _tmp4_;
	ClutterColor _tmp5_;
	parent_class = G_OBJECT_CLASS (gala_screen_shield_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_SCREEN_SHIELD, GalaScreenShield);
	_tmp0_ = g_settings_new ("org.gnome.desktop.screensaver");
	_g_object_unref0 (self->priv->screensaver_settings);
	self->priv->screensaver_settings = _tmp0_;
	_tmp1_ = g_settings_new ("io.elementary.desktop.screensaver");
	_g_object_unref0 (self->priv->gala_settings);
	self->priv->gala_settings = _tmp1_;
	_tmp2_ = g_settings_new ("org.gnome.desktop.lockdown");
	_g_object_unref0 (self->priv->lockdown_settings);
	self->priv->lockdown_settings = _tmp2_;
	g_object_set ((ClutterActor*) self, "visible", FALSE, NULL);
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
	g_signal_connect_object ((ClutterActor*) self, "key-press-event", (GCallback) __gala_screen_shield___lambda33__clutter_actor_key_press_event, self, 0);
	g_signal_connect_object ((ClutterActor*) self, "motion-event", (GCallback) __gala_screen_shield___lambda34__clutter_actor_motion_event, self, 0);
	_tmp3_ = _vala_clutter_color_from_string ("black");
	_tmp4_ = _tmp3_;
	_tmp5_ = *_tmp4_;
	clutter_actor_set_background_color ((ClutterActor*) self, &_tmp5_);
	__vala_ClutterColor_free0 (_tmp4_);
	gala_screen_shield_expand_to_screen_size (self);
	gala_screen_shield_init_dbus_interfaces (self, NULL, NULL);
	return obj;
}

static void
gala_screen_shield_class_init (GalaScreenShieldClass * klass,
                               gpointer klass_data)
{
	gala_screen_shield_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaScreenShield_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_screen_shield_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_screen_shield_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_screen_shield_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_screen_shield_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_SCREEN_SHIELD_ACTIVE_PROPERTY, gala_screen_shield_properties[GALA_SCREEN_SHIELD_ACTIVE_PROPERTY] = g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_SCREEN_SHIELD_IS_LOCKED_PROPERTY, gala_screen_shield_properties[GALA_SCREEN_SHIELD_IS_LOCKED_PROPERTY] = g_param_spec_boolean ("is-locked", "is-locked", "is-locked", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_SCREEN_SHIELD_IN_GREETER_PROPERTY, gala_screen_shield_properties[GALA_SCREEN_SHIELD_IN_GREETER_PROPERTY] = g_param_spec_boolean ("in-greeter", "in-greeter", "in-greeter", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_SCREEN_SHIELD_ACTIVATION_TIME_PROPERTY, gala_screen_shield_properties[GALA_SCREEN_SHIELD_ACTIVATION_TIME_PROPERTY] = g_param_spec_int64 ("activation-time", "activation-time", "activation-time", G_MININT64, G_MAXINT64, (gint64) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_SCREEN_SHIELD_WM_PROPERTY, gala_screen_shield_properties[GALA_SCREEN_SHIELD_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	gala_screen_shield_signals[GALA_SCREEN_SHIELD_ACTIVE_CHANGED_SIGNAL] = g_signal_new ("active-changed", GALA_TYPE_SCREEN_SHIELD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gala_screen_shield_signals[GALA_SCREEN_SHIELD_WAKE_UP_SCREEN_SIGNAL] = g_signal_new ("wake-up-screen", GALA_TYPE_SCREEN_SHIELD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
gala_screen_shield_instance_init (GalaScreenShield * self,
                                  gpointer klass)
{
	self->priv = gala_screen_shield_get_instance_private (self);
	self->priv->_active = FALSE;
	self->priv->_is_locked = FALSE;
	self->priv->_in_greeter = FALSE;
	self->priv->_activation_time = (gint64) 0;
	self->priv->animate_id = (guint) 0;
	self->priv->connected_to_buses = FALSE;
}

static void
gala_screen_shield_finalize (GObject * obj)
{
	GalaScreenShield * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_SCREEN_SHIELD, GalaScreenShield);
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->modal_proxy);
	_g_object_unref0 (self->priv->login_manager);
	_g_object_unref0 (self->priv->login_user_manager);
	_g_object_unref0 (self->priv->login_session);
	_g_object_unref0 (self->priv->session_presence);
	_g_object_unref0 (self->priv->display_manager);
	_g_object_unref0 (self->priv->inhibitor);
	_g_object_unref0 (self->priv->screensaver_settings);
	_g_object_unref0 (self->priv->lockdown_settings);
	_g_object_unref0 (self->priv->gala_settings);
	G_OBJECT_CLASS (gala_screen_shield_parent_class)->finalize (obj);
}

static GType
gala_screen_shield_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaScreenShieldClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_screen_shield_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaScreenShield), 0, (GInstanceInitFunc) gala_screen_shield_instance_init, NULL };
	GType gala_screen_shield_type_id;
	gala_screen_shield_type_id = g_type_register_static (clutter_actor_get_type (), "GalaScreenShield", &g_define_type_info, 0);
	GalaScreenShield_private_offset = g_type_add_instance_private (gala_screen_shield_type_id, sizeof (GalaScreenShieldPrivate));
	return gala_screen_shield_type_id;
}

GType
gala_screen_shield_get_type (void)
{
	static volatile gsize gala_screen_shield_type_id__once = 0;
	if (g_once_init_enter (&gala_screen_shield_type_id__once)) {
		GType gala_screen_shield_type_id;
		gala_screen_shield_type_id = gala_screen_shield_get_type_once ();
		g_once_init_leave (&gala_screen_shield_type_id__once, gala_screen_shield_type_id);
	}
	return gala_screen_shield_type_id__once;
}

static void
_vala_gala_screen_shield_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	GalaScreenShield * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_SCREEN_SHIELD, GalaScreenShield);
	switch (property_id) {
		case GALA_SCREEN_SHIELD_ACTIVE_PROPERTY:
		g_value_set_boolean (value, gala_screen_shield_get_active (self));
		break;
		case GALA_SCREEN_SHIELD_IS_LOCKED_PROPERTY:
		g_value_set_boolean (value, gala_screen_shield_get_is_locked (self));
		break;
		case GALA_SCREEN_SHIELD_IN_GREETER_PROPERTY:
		g_value_set_boolean (value, gala_screen_shield_get_in_greeter (self));
		break;
		case GALA_SCREEN_SHIELD_ACTIVATION_TIME_PROPERTY:
		g_value_set_int64 (value, gala_screen_shield_get_activation_time (self));
		break;
		case GALA_SCREEN_SHIELD_WM_PROPERTY:
		g_value_set_object (value, gala_screen_shield_get_wm (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_screen_shield_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	GalaScreenShield * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_SCREEN_SHIELD, GalaScreenShield);
	switch (property_id) {
		case GALA_SCREEN_SHIELD_ACTIVE_PROPERTY:
		gala_screen_shield_set_active (self, g_value_get_boolean (value));
		break;
		case GALA_SCREEN_SHIELD_IS_LOCKED_PROPERTY:
		gala_screen_shield_set_is_locked (self, g_value_get_boolean (value));
		break;
		case GALA_SCREEN_SHIELD_IN_GREETER_PROPERTY:
		gala_screen_shield_set_in_greeter (self, g_value_get_boolean (value));
		break;
		case GALA_SCREEN_SHIELD_ACTIVATION_TIME_PROPERTY:
		gala_screen_shield_set_activation_time (self, g_value_get_int64 (value));
		break;
		case GALA_SCREEN_SHIELD_WM_PROPERTY:
		gala_screen_shield_set_wm (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

