/* Tooltip.c generated by valac 0.56.0, the Vala compiler
 * generated from Tooltip.vala, do not modify */

/*
 * Copyright 2021 elementary, Inc (https://elementary.io)
 *           2021 José Expósito <jose.exposito89@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <clutter/clutter.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <pango/pango.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_TOOLTIP (gala_tooltip_get_type ())
#define GALA_TOOLTIP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_TOOLTIP, GalaTooltip))
#define GALA_TOOLTIP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_TOOLTIP, GalaTooltipClass))
#define GALA_IS_TOOLTIP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_TOOLTIP))
#define GALA_IS_TOOLTIP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_TOOLTIP))
#define GALA_TOOLTIP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_TOOLTIP, GalaTooltipClass))

typedef struct _GalaTooltip GalaTooltip;
typedef struct _GalaTooltipClass GalaTooltipClass;
typedef struct _GalaTooltipPrivate GalaTooltipPrivate;
enum  {
	GALA_TOOLTIP_0_PROPERTY,
	GALA_TOOLTIP_NUM_PROPERTIES
};
static GParamSpec* gala_tooltip_properties[GALA_TOOLTIP_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gtk_widget_path_unref0(var) ((var == NULL) ? NULL : (var = (gtk_widget_path_unref (var), NULL)))

struct _GalaTooltip {
	ClutterActor parent_instance;
	GalaTooltipPrivate * priv;
	gfloat max_width;
};

struct _GalaTooltipClass {
	ClutterActorClass parent_class;
};

struct _GalaTooltipPrivate {
	ClutterCanvas* background_canvas;
	ClutterText* text_actor;
	gchar* text;
};

static gint GalaTooltip_private_offset;
static gpointer gala_tooltip_parent_class = NULL;
static ClutterColor gala_tooltip_text_color;
static ClutterColor gala_tooltip_text_color = {0};
static GtkBorder gala_tooltip_padding;
static GtkBorder gala_tooltip_padding = {0};
static GtkStyleContext* gala_tooltip_style_context;
static GtkStyleContext* gala_tooltip_style_context = NULL;

VALA_EXTERN GType gala_tooltip_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaTooltip, g_object_unref)
VALA_EXTERN void gala_tooltip_set_text (GalaTooltip* self,
                            const gchar* new_text,
                            gboolean redraw);
static void gala_tooltip_draw (GalaTooltip* self);
VALA_EXTERN void gala_tooltip_set_max_width (GalaTooltip* self,
                                 gfloat new_max_width,
                                 gboolean redraw);
static gboolean gala_tooltip_draw_background (cairo_t* ctx,
                                       gint width,
                                       gint height);
VALA_EXTERN GalaTooltip* gala_tooltip_new (void);
VALA_EXTERN GalaTooltip* gala_tooltip_construct (GType object_type);
static GObject * gala_tooltip_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties);
static gboolean _gala_tooltip_draw_background_clutter_canvas_draw (ClutterCanvas* _sender,
                                                            cairo_t* cr,
                                                            gint width,
                                                            gint height,
                                                            gpointer self);
static void gala_tooltip_finalize (GObject * obj);
static GType gala_tooltip_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gala_tooltip_get_instance_private (GalaTooltip* self)
{
	return G_STRUCT_MEMBER_P (self, GalaTooltip_private_offset);
}

void
gala_tooltip_set_text (GalaTooltip* self,
                       const gchar* new_text,
                       gboolean redraw)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_text != NULL);
	_tmp0_ = g_strdup (new_text);
	_g_free0 (self->priv->text);
	self->priv->text = _tmp0_;
	if (redraw) {
		gala_tooltip_draw (self);
	}
}

void
gala_tooltip_set_max_width (GalaTooltip* self,
                            gfloat new_max_width,
                            gboolean redraw)
{
	g_return_if_fail (self != NULL);
	self->max_width = new_max_width;
	if (redraw) {
		gala_tooltip_draw (self);
	}
}

static void
gala_tooltip_draw (GalaTooltip* self)
{
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	ClutterText* _tmp5_;
	ClutterColor _tmp7_;
	GtkBorder _tmp8_;
	GtkBorder _tmp9_;
	ClutterText* _tmp10_ = NULL;
	ClutterText* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	ClutterText* _tmp15_;
	gfloat _tmp16_;
	gfloat _tmp17_;
	GtkBorder _tmp18_;
	GtkBorder _tmp19_;
	ClutterText* _tmp23_;
	ClutterText* _tmp24_;
	gfloat _tmp25_;
	gfloat _tmp26_;
	GtkBorder _tmp27_;
	GtkBorder _tmp28_;
	ClutterText* _tmp29_;
	gfloat _tmp30_;
	gfloat _tmp31_;
	GtkBorder _tmp32_;
	GtkBorder _tmp33_;
	ClutterCanvas* _tmp34_;
	gfloat _tmp35_;
	gfloat _tmp36_;
	gfloat _tmp37_;
	gfloat _tmp38_;
	ClutterCanvas* _tmp39_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->text;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	g_object_set ((ClutterActor*) self, "visible", _tmp2_ != 0, NULL);
	g_object_get ((ClutterActor*) self, "visible", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	if (!_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->text_actor;
	if (_tmp5_ != NULL) {
		ClutterText* _tmp6_;
		_tmp6_ = self->priv->text_actor;
		clutter_actor_remove_child ((ClutterActor*) self, (ClutterActor*) _tmp6_);
	}
	_tmp7_ = gala_tooltip_text_color;
	_tmp8_ = gala_tooltip_padding;
	_tmp9_ = gala_tooltip_padding;
	_tmp10_ = (ClutterText*) clutter_text_new ();
	clutter_text_set_color (_tmp10_, &_tmp7_);
	clutter_actor_set_x ((ClutterActor*) _tmp10_, (gfloat) _tmp8_.left);
	clutter_actor_set_y ((ClutterActor*) _tmp10_, (gfloat) _tmp9_.top);
	clutter_text_set_ellipsize (_tmp10_, PANGO_ELLIPSIZE_MIDDLE);
	clutter_text_set_use_markup (_tmp10_, TRUE);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->text_actor);
	self->priv->text_actor = _tmp10_;
	_tmp11_ = self->priv->text_actor;
	_tmp12_ = self->priv->text;
	_tmp13_ = g_markup_printf_escaped ("<span size='large'>%s</span>", _tmp12_);
	_tmp14_ = _tmp13_;
	clutter_text_set_markup (_tmp11_, _tmp14_);
	_g_free0 (_tmp14_);
	_tmp15_ = self->priv->text_actor;
	_tmp16_ = clutter_actor_get_width ((ClutterActor*) _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = gala_tooltip_padding;
	_tmp19_ = gala_tooltip_padding;
	if (((_tmp17_ + _tmp18_.left) + _tmp19_.right) > self->max_width) {
		ClutterText* _tmp20_;
		GtkBorder _tmp21_;
		GtkBorder _tmp22_;
		_tmp20_ = self->priv->text_actor;
		_tmp21_ = gala_tooltip_padding;
		_tmp22_ = gala_tooltip_padding;
		clutter_actor_set_width ((ClutterActor*) _tmp20_, (self->max_width - _tmp21_.left) - _tmp22_.right);
	}
	_tmp23_ = self->priv->text_actor;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp23_);
	_tmp24_ = self->priv->text_actor;
	_tmp25_ = clutter_actor_get_width ((ClutterActor*) _tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = gala_tooltip_padding;
	_tmp28_ = gala_tooltip_padding;
	clutter_actor_set_width ((ClutterActor*) self, (_tmp26_ + _tmp27_.left) + _tmp28_.right);
	_tmp29_ = self->priv->text_actor;
	_tmp30_ = clutter_actor_get_height ((ClutterActor*) _tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = gala_tooltip_padding;
	_tmp33_ = gala_tooltip_padding;
	clutter_actor_set_height ((ClutterActor*) self, (_tmp31_ + _tmp32_.top) + _tmp33_.bottom);
	_tmp34_ = self->priv->background_canvas;
	_tmp35_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp36_ = _tmp35_;
	_tmp37_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp38_ = _tmp37_;
	clutter_canvas_set_size (_tmp34_, (gint) _tmp36_, (gint) _tmp38_);
	_tmp39_ = self->priv->background_canvas;
	clutter_content_invalidate ((ClutterContent*) _tmp39_);
}

static gboolean
gala_tooltip_draw_background (cairo_t* ctx,
                              gint width,
                              gint height)
{
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	gboolean result;
	g_return_val_if_fail (ctx != NULL, FALSE);
	cairo_save (ctx);
	_tmp0_ = gala_tooltip_style_context;
	gtk_render_background (_tmp0_, ctx, (gdouble) 0, (gdouble) 0, (gdouble) width, (gdouble) height);
	_tmp1_ = gala_tooltip_style_context;
	gtk_render_frame (_tmp1_, ctx, (gdouble) 0, (gdouble) 0, (gdouble) width, (gdouble) height);
	cairo_restore (ctx);
	result = FALSE;
	return result;
}

GalaTooltip*
gala_tooltip_construct (GType object_type)
{
	GalaTooltip * self = NULL;
	self = (GalaTooltip*) g_object_new (object_type, NULL);
	return self;
}

GalaTooltip*
gala_tooltip_new (void)
{
	return gala_tooltip_construct (GALA_TYPE_TOOLTIP);
}

static gboolean
_gala_tooltip_draw_background_clutter_canvas_draw (ClutterCanvas* _sender,
                                                   cairo_t* cr,
                                                   gint width,
                                                   gint height,
                                                   gpointer self)
{
	gboolean result;
	result = gala_tooltip_draw_background (cr, width, height);
	return result;
}

static GObject *
gala_tooltip_constructor (GType type,
                          guint n_construct_properties,
                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaTooltip * self;
	gchar* _tmp0_;
	ClutterCanvas* _tmp1_;
	ClutterCanvas* _tmp2_;
	ClutterCanvas* _tmp3_;
	parent_class = G_OBJECT_CLASS (gala_tooltip_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_TOOLTIP, GalaTooltip);
	_tmp0_ = g_strdup ("");
	_g_free0 (self->priv->text);
	self->priv->text = _tmp0_;
	self->max_width = (gfloat) 200;
	_tmp1_ = (ClutterCanvas*) clutter_canvas_new ();
	_g_object_unref0 (self->priv->background_canvas);
	self->priv->background_canvas = _tmp1_;
	_tmp2_ = self->priv->background_canvas;
	g_signal_connect (_tmp2_, "draw", (GCallback) _gala_tooltip_draw_background_clutter_canvas_draw, NULL);
	_tmp3_ = self->priv->background_canvas;
	clutter_actor_set_content ((ClutterActor*) self, (ClutterContent*) _tmp3_);
	gala_tooltip_draw (self);
	return obj;
}

static void
gala_tooltip_class_init (GalaTooltipClass * klass,
                         gpointer klass_data)
{
	GtkWidgetPath* tooltip_widget_path = NULL;
	GtkWidgetPath* _tmp0_;
	gint pos = 0;
	GtkWidgetPath* _tmp1_;
	GtkWidgetPath* _tmp2_;
	GtkWidgetPath* _tmp3_;
	GtkWidgetPath* _tmp4_;
	GtkStyleContext* _tmp5_;
	GtkStyleContext* _tmp6_;
	GtkWidgetPath* _tmp7_;
	GtkStyleContext* _tmp8_;
	GtkBorder _tmp9_ = {0};
	GtkWidgetPath* _tmp10_;
	GtkStyleContext* label_style_context = NULL;
	GtkStyleContext* _tmp11_;
	GtkStyleContext* _tmp12_;
	GtkWidgetPath* _tmp13_;
	GdkRGBA text_rgba = {0};
	GtkStyleContext* _tmp14_;
	GValue _tmp15_ = {0};
	GValue _tmp16_;
	GdkRGBA* _tmp17_;
	GdkRGBA _tmp18_ = {0};
	GdkRGBA _tmp19_;
	GdkRGBA _tmp20_;
	GdkRGBA _tmp21_;
	GdkRGBA _tmp22_;
	GdkRGBA _tmp23_;
	ClutterColor _tmp24_ = {0};
	gala_tooltip_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaTooltip_private_offset);
	G_OBJECT_CLASS (klass)->constructor = gala_tooltip_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_tooltip_finalize;
	_tmp0_ = gtk_widget_path_new ();
	tooltip_widget_path = _tmp0_;
	_tmp1_ = tooltip_widget_path;
	pos = gtk_widget_path_append_type (_tmp1_, gtk_window_get_type ());
	_tmp2_ = tooltip_widget_path;
	gtk_widget_path_iter_set_object_name (_tmp2_, pos, "tooltip");
	_tmp3_ = tooltip_widget_path;
	gtk_widget_path_iter_add_class (_tmp3_, pos, GTK_STYLE_CLASS_CSD);
	_tmp4_ = tooltip_widget_path;
	gtk_widget_path_iter_add_class (_tmp4_, pos, GTK_STYLE_CLASS_BACKGROUND);
	_tmp5_ = gtk_style_context_new ();
	_g_object_unref0 (gala_tooltip_style_context);
	gala_tooltip_style_context = _tmp5_;
	_tmp6_ = gala_tooltip_style_context;
	_tmp7_ = tooltip_widget_path;
	gtk_style_context_set_path (_tmp6_, _tmp7_);
	_tmp8_ = gala_tooltip_style_context;
	gtk_style_context_get_padding (_tmp8_, GTK_STATE_FLAG_NORMAL, &_tmp9_);
	gala_tooltip_padding = _tmp9_;
	_tmp10_ = tooltip_widget_path;
	gtk_widget_path_append_type (_tmp10_, gtk_label_get_type ());
	_tmp11_ = gtk_style_context_new ();
	label_style_context = _tmp11_;
	_tmp12_ = label_style_context;
	_tmp13_ = tooltip_widget_path;
	gtk_style_context_set_path (_tmp12_, _tmp13_);
	_tmp14_ = label_style_context;
	gtk_style_context_get_property (_tmp14_, GTK_STYLE_PROPERTY_COLOR, GTK_STATE_FLAG_NORMAL, &_tmp15_);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_value_get_boxed (&_tmp15_);
	_tmp19_ = (G_VALUE_HOLDS (&_tmp15_, gdk_rgba_get_type ()) && _tmp17_) ? (*_tmp17_) : (g_warning ("Invalid GValue unboxing (wrong type or NULL)"), _tmp18_);
	G_IS_VALUE (&_tmp16_) ? (g_value_unset (&_tmp16_), NULL) : NULL;
	text_rgba = _tmp19_;
	_tmp20_ = text_rgba;
	_tmp21_ = text_rgba;
	_tmp22_ = text_rgba;
	_tmp23_ = text_rgba;
	memset (&_tmp24_, 0, sizeof (ClutterColor));
	_tmp24_.red = ((guint8) _tmp20_.red) * G_MAXUINT8;
	_tmp24_.green = ((guint8) _tmp21_.green) * G_MAXUINT8;
	_tmp24_.blue = ((guint8) _tmp22_.blue) * G_MAXUINT8;
	_tmp24_.alpha = ((guint8) _tmp23_.alpha) * G_MAXUINT8;
	gala_tooltip_text_color = _tmp24_;
	_g_object_unref0 (label_style_context);
	_gtk_widget_path_unref0 (tooltip_widget_path);
}

static void
gala_tooltip_instance_init (GalaTooltip * self,
                            gpointer klass)
{
	self->priv = gala_tooltip_get_instance_private (self);
	self->priv->text_actor = NULL;
}

static void
gala_tooltip_finalize (GObject * obj)
{
	GalaTooltip * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_TOOLTIP, GalaTooltip);
	_g_object_unref0 (self->priv->background_canvas);
	_g_object_unref0 (self->priv->text_actor);
	_g_free0 (self->priv->text);
	G_OBJECT_CLASS (gala_tooltip_parent_class)->finalize (obj);
}

/**
 * Clutter actor to display text in a tooltip-like component.
 */
static GType
gala_tooltip_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaTooltipClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_tooltip_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaTooltip), 0, (GInstanceInitFunc) gala_tooltip_instance_init, NULL };
	GType gala_tooltip_type_id;
	gala_tooltip_type_id = g_type_register_static (clutter_actor_get_type (), "GalaTooltip", &g_define_type_info, 0);
	GalaTooltip_private_offset = g_type_add_instance_private (gala_tooltip_type_id, sizeof (GalaTooltipPrivate));
	return gala_tooltip_type_id;
}

GType
gala_tooltip_get_type (void)
{
	static volatile gsize gala_tooltip_type_id__once = 0;
	if (g_once_init_enter (&gala_tooltip_type_id__once)) {
		GType gala_tooltip_type_id;
		gala_tooltip_type_id = gala_tooltip_get_type_once ();
		g_once_init_leave (&gala_tooltip_type_id__once, gala_tooltip_type_id);
	}
	return gala_tooltip_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

