/* WindowSwitcher.c generated by valac 0.56.0, the Vala compiler
 * generated from WindowSwitcher.vala, do not modify */

/*
 * Copyright 2021 Aral Balkan <mail@ar.al>
 * Copyright 2020 Mark Story <mark@mark-story.com>
 * Copyright 2017 Popye <sailor3101@gmail.com>
 * Copyright 2014 Tom Beckmann
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <clutter/clutter.h>
#include <glib-object.h>
#include <glib.h>
#include "gala.h"
#include <granite.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <cairo-gobject.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <pango/pango.h>
#include <meta/display.h>
#include <meta/window.h>
#include <meta/keybindings.h>
#include <meta/workspace.h>
#include <meta/meta-workspace-manager.h>
#include <meta/meta-plugin.h>
#include <meta/boxes.h>
#include <meta/meta-monitor-manager.h>

#define GALA_WINDOW_SWITCHER_ICON_SIZE 64
#define GALA_WINDOW_SWITCHER_WRAPPER_BORDER_RADIUS 3
#define GALA_WINDOW_SWITCHER_WRAPPER_PADDING 12
#define GALA_WINDOW_SWITCHER_CAPTION_FONT_NAME "Inter"
#define GALA_WINDOW_SWITCHER_MIN_OFFSET 64
#define GALA_WINDOW_SWITCHER_FIX_TIMEOUT_INTERVAL 100
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_WINDOW_SWITCHER (gala_window_switcher_get_type ())
#define GALA_WINDOW_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_SWITCHER, GalaWindowSwitcher))
#define GALA_WINDOW_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_SWITCHER, GalaWindowSwitcherClass))
#define GALA_IS_WINDOW_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_SWITCHER))
#define GALA_IS_WINDOW_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_SWITCHER))
#define GALA_WINDOW_SWITCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_SWITCHER, GalaWindowSwitcherClass))

typedef struct _GalaWindowSwitcher GalaWindowSwitcher;
typedef struct _GalaWindowSwitcherClass GalaWindowSwitcherClass;
typedef struct _GalaWindowSwitcherPrivate GalaWindowSwitcherPrivate;
enum  {
	GALA_WINDOW_SWITCHER_0_PROPERTY,
	GALA_WINDOW_SWITCHER_OPENED_PROPERTY,
	GALA_WINDOW_SWITCHER_WM_PROPERTY,
	GALA_WINDOW_SWITCHER_NUM_PROPERTIES
};
static GParamSpec* gala_window_switcher_properties[GALA_WINDOW_SWITCHER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gtk_widget_path_unref0(var) ((var == NULL) ? NULL : (var = (gtk_widget_path_unref (var), NULL)))
typedef struct _Block67Data Block67Data;
#define __vala_ClutterColor_free0(var) ((var == NULL) ? NULL : (var = (_vala_ClutterColor_free (var), NULL)))
typedef struct _Block68Data Block68Data;
#define __vala_ClutterActorBox_free0(var) ((var == NULL) ? NULL : (var = (_vala_ClutterActorBox_free (var), NULL)))

#define GALA_TYPE_SHADOW_EFFECT (gala_shadow_effect_get_type ())
#define GALA_SHADOW_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_SHADOW_EFFECT, GalaShadowEffect))
#define GALA_SHADOW_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_SHADOW_EFFECT, GalaShadowEffectClass))
#define GALA_IS_SHADOW_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_SHADOW_EFFECT))
#define GALA_IS_SHADOW_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_SHADOW_EFFECT))
#define GALA_SHADOW_EFFECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_SHADOW_EFFECT, GalaShadowEffectClass))

typedef struct _GalaShadowEffect GalaShadowEffect;
typedef struct _GalaShadowEffectClass GalaShadowEffectClass;

struct _GalaWindowSwitcher {
	ClutterActor parent_instance;
	GalaWindowSwitcherPrivate * priv;
};

struct _GalaWindowSwitcherClass {
	ClutterActorClass parent_class;
};

struct _GalaWindowSwitcherPrivate {
	gboolean _opened;
	GalaWindowManager* _wm;
	GalaModalProxy* modal_proxy;
	GraniteSettings* granite_settings;
	ClutterCanvas* canvas;
	ClutterActor* container;
	ClutterActor* indicator;
	ClutterText* caption;
	gint modifier_mask;
	GalaWindowIcon* cur_icon;
	gint scaling_factor;
	gfloat caption_height;
};

struct _Block67Data {
	int _ref_count_;
	GalaWindowSwitcher* self;
	ClutterColor accent_color;
	gint rect_radius;
};

struct _Block68Data {
	int _ref_count_;
	GalaWindowSwitcher* self;
	gboolean initial;
};

static gint GalaWindowSwitcher_private_offset;
static gpointer gala_window_switcher_parent_class = NULL;

VALA_EXTERN GType gala_window_switcher_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowSwitcher, g_object_unref)
VALA_EXTERN GalaWindowSwitcher* gala_window_switcher_new (GalaWindowManager* wm);
VALA_EXTERN GalaWindowSwitcher* gala_window_switcher_construct (GType object_type,
                                                    GalaWindowManager* wm);
static gboolean gala_window_switcher_draw (GalaWindowSwitcher* self,
                                    cairo_t* ctx,
                                    gint width,
                                    gint height);
static void gala_window_switcher_create_components (GalaWindowSwitcher* self);
static Block67Data* block67_data_ref (Block67Data* _data67_);
static void block67_data_unref (void * _userdata_);
static gboolean gala_window_switcher_container_mouse_press (GalaWindowSwitcher* self,
                                                     ClutterButtonEvent* event);
static gboolean _gala_window_switcher_container_mouse_press_clutter_actor_button_press_event (ClutterActor* _sender,
                                                                                       ClutterButtonEvent* event,
                                                                                       gpointer self);
static gboolean gala_window_switcher_container_motion_event (GalaWindowSwitcher* self,
                                                      ClutterMotionEvent* event);
static gboolean _gala_window_switcher_container_motion_event_clutter_actor_motion_event (ClutterActor* _sender,
                                                                                  ClutterMotionEvent* event,
                                                                                  gpointer self);
VALA_EXTERN void gala_internal_utils_get_theme_accent_color (GdkRGBA* result);
static gboolean __lambda39_ (Block67Data* _data67_,
                      cairo_t* ctx,
                      gint width,
                      gint height);
static gboolean ___lambda39__clutter_canvas_draw (ClutterCanvas* _sender,
                                           cairo_t* cr,
                                           gint width,
                                           gint height,
                                           gpointer self);
static void _vala_ClutterColor_free (ClutterColor* self);
VALA_EXTERN void gala_window_switcher_handle_switch_windows (MetaDisplay* display,
                                                 MetaWindow* window,
                                                 ClutterKeyEvent* event,
                                                 MetaKeyBinding* binding,
                                                 GalaWindowSwitcher* self);
VALA_EXTERN gboolean gala_window_switcher_get_opened (GalaWindowSwitcher* self);
static gboolean gala_window_switcher_collect_windows (GalaWindowSwitcher* self,
                                               MetaDisplay* display,
                                               MetaWorkspace* workspace);
static void gala_window_switcher_open_switcher (GalaWindowSwitcher* self);
static void gala_window_switcher_update_indicator_position (GalaWindowSwitcher* self,
                                                     gboolean initial);
static void gala_window_switcher_next_window (GalaWindowSwitcher* self,
                                       MetaDisplay* display,
                                       MetaWorkspace* workspace,
                                       gboolean backward);
VALA_EXTERN GalaWindowManager* gala_window_switcher_get_wm (GalaWindowSwitcher* self);
static gboolean __lambda40_ (GalaWindowSwitcher* self,
                      MetaKeyBinding* binding);
static gboolean ___lambda40__gala_keybinding_filter (MetaKeyBinding* binding,
                                              gpointer self);
static void gala_window_switcher_set_opened (GalaWindowSwitcher* self,
                                      gboolean value);
static GdkModifierType gala_window_switcher_get_current_modifiers (GalaWindowSwitcher* self);
static void gala_window_switcher_close_switcher (GalaWindowSwitcher* self,
                                          guint32 time,
                                          gboolean cancel);
static void gala_window_switcher_update_caption_text (GalaWindowSwitcher* self);
static Block68Data* block68_data_ref (Block68Data* _data68_);
static void block68_data_unref (void * _userdata_);
static void _vala_ClutterActorBox_free (ClutterActorBox* self);
static gboolean ___lambda38_ (Block68Data* _data68_);
static gboolean ____lambda38__gsource_func (gpointer self);
static void gala_window_switcher_real_key_focus_out (ClutterActor* base);
static gboolean gala_window_switcher_real_key_release_event (ClutterActor* base,
                                                      ClutterKeyEvent* event);
static void gala_window_switcher_set_wm (GalaWindowSwitcher* self,
                                  GalaWindowManager* value);
static GObject * gala_window_switcher_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
VALA_EXTERN gint gala_internal_utils_get_ui_scaling_factor (void);
VALA_EXTERN GType gala_shadow_effect_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaShadowEffect, g_object_unref)
VALA_EXTERN GalaShadowEffect* gala_shadow_effect_new (gint shadow_size,
                                          gint shadow_spread);
VALA_EXTERN GalaShadowEffect* gala_shadow_effect_construct (GType object_type,
                                                gint shadow_size,
                                                gint shadow_spread);
VALA_EXTERN void gala_shadow_effect_set_shadow_opacity (GalaShadowEffect* self,
                                            guint8 value);
VALA_EXTERN void gala_shadow_effect_set_css_class (GalaShadowEffect* self,
                                       const gchar* value);
static void _gala_window_switcher___lambda41_ (GalaWindowSwitcher* self);
static void __gala_window_switcher___lambda41__g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self);
static void _gala_window_switcher___lambda42_ (GalaWindowSwitcher* self);
static void __gala_window_switcher___lambda42__meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                               gpointer self);
static gboolean _gala_window_switcher_draw_clutter_canvas_draw (ClutterCanvas* _sender,
                                                         cairo_t* cr,
                                                         gint width,
                                                         gint height,
                                                         gpointer self);
static void gala_window_switcher_finalize (GObject * obj);
static GType gala_window_switcher_get_type_once (void);
static void _vala_gala_window_switcher_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_gala_window_switcher_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gala_window_switcher_get_instance_private (GalaWindowSwitcher* self)
{
	return G_STRUCT_MEMBER_P (self, GalaWindowSwitcher_private_offset);
}

GalaWindowSwitcher*
gala_window_switcher_construct (GType object_type,
                                GalaWindowManager* wm)
{
	GalaWindowSwitcher * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	self = (GalaWindowSwitcher*) g_object_new (object_type, "wm", wm, NULL);
	return self;
}

GalaWindowSwitcher*
gala_window_switcher_new (GalaWindowManager* wm)
{
	return gala_window_switcher_construct (GALA_TYPE_WINDOW_SWITCHER, wm);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
gala_window_switcher_draw (GalaWindowSwitcher* self,
                           cairo_t* ctx,
                           gint width,
                           gint height)
{
	GtkWidgetPath* widget_path = NULL;
	GtkWidgetPath* _tmp0_;
	GtkWidgetPath* _tmp1_;
	GtkWidgetPath* _tmp2_;
	GtkStyleContext* style_context = NULL;
	GtkStyleContext* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkStyleContext* _tmp5_;
	GtkWidgetPath* _tmp6_;
	GtkStyleContext* _tmp7_;
	GtkStyleContext* _tmp8_;
	GtkStyleContext* _tmp9_;
	GraniteSettings* _tmp10_;
	GraniteSettingsColorScheme _tmp11_;
	GraniteSettingsColorScheme _tmp12_;
	GtkStyleContext* _tmp24_;
	GtkStyleContext* _tmp25_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ctx != NULL, FALSE);
	cairo_save (ctx);
	_tmp0_ = gtk_widget_path_new ();
	widget_path = _tmp0_;
	_tmp1_ = widget_path;
	gtk_widget_path_append_type (_tmp1_, gtk_window_get_type ());
	_tmp2_ = widget_path;
	gtk_widget_path_iter_set_object_name (_tmp2_, -1, "window");
	_tmp3_ = gtk_style_context_new ();
	style_context = _tmp3_;
	_tmp4_ = style_context;
	gtk_style_context_set_scale (_tmp4_, self->priv->scaling_factor);
	_tmp5_ = style_context;
	_tmp6_ = widget_path;
	gtk_style_context_set_path (_tmp5_, _tmp6_);
	_tmp7_ = style_context;
	gtk_style_context_add_class (_tmp7_, "background");
	_tmp8_ = style_context;
	gtk_style_context_add_class (_tmp8_, "csd");
	_tmp9_ = style_context;
	gtk_style_context_add_class (_tmp9_, "unified");
	_tmp10_ = self->priv->granite_settings;
	_tmp11_ = granite_settings_get_prefers_color_scheme (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ == GRANITE_SETTINGS_COLOR_SCHEME_DARK) {
		GtkSettings* gtksettings = NULL;
		GtkSettings* _tmp13_;
		GtkSettings* _tmp14_;
		GtkCssProvider* css_provider = NULL;
		GtkSettings* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		GtkCssProvider* _tmp19_;
		GtkCssProvider* _tmp20_;
		GtkCssProvider* _tmp21_;
		GtkStyleContext* _tmp22_;
		GtkCssProvider* _tmp23_;
		_tmp13_ = gtk_settings_get_default ();
		_tmp14_ = _g_object_ref0 (_tmp13_);
		gtksettings = _tmp14_;
		_tmp15_ = gtksettings;
		g_object_get (_tmp15_, "gtk-theme-name", &_tmp16_, NULL);
		_tmp17_ = _tmp16_;
		_tmp18_ = _tmp17_;
		_tmp19_ = gtk_css_provider_get_named (_tmp18_, "dark");
		_tmp20_ = _g_object_ref0 (_tmp19_);
		_tmp21_ = _tmp20_;
		_g_free0 (_tmp18_);
		css_provider = _tmp21_;
		_tmp22_ = style_context;
		_tmp23_ = css_provider;
		gtk_style_context_add_provider (_tmp22_, (GtkStyleProvider*) _tmp23_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
		_g_object_unref0 (css_provider);
		_g_object_unref0 (gtksettings);
	}
	_tmp24_ = style_context;
	gtk_render_background (_tmp24_, ctx, (gdouble) 0, (gdouble) 0, (gdouble) width, (gdouble) height);
	_tmp25_ = style_context;
	gtk_render_frame (_tmp25_, ctx, (gdouble) 0, (gdouble) 0, (gdouble) width, (gdouble) height);
	cairo_restore (ctx);
	result = TRUE;
	_g_object_unref0 (style_context);
	_gtk_widget_path_unref0 (widget_path);
	return result;
}

static Block67Data*
block67_data_ref (Block67Data* _data67_)
{
	g_atomic_int_inc (&_data67_->_ref_count_);
	return _data67_;
}

static void
block67_data_unref (void * _userdata_)
{
	Block67Data* _data67_;
	_data67_ = (Block67Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data67_->_ref_count_)) {
		GalaWindowSwitcher* self;
		self = _data67_->self;
		_g_object_unref0 (self);
		g_slice_free (Block67Data, _data67_);
	}
}

static gboolean
_gala_window_switcher_container_mouse_press_clutter_actor_button_press_event (ClutterActor* _sender,
                                                                              ClutterButtonEvent* event,
                                                                              gpointer self)
{
	gboolean result;
	result = gala_window_switcher_container_mouse_press ((GalaWindowSwitcher*) self, event);
	return result;
}

static gboolean
_gala_window_switcher_container_motion_event_clutter_actor_motion_event (ClutterActor* _sender,
                                                                         ClutterMotionEvent* event,
                                                                         gpointer self)
{
	gboolean result;
	result = gala_window_switcher_container_motion_event ((GalaWindowSwitcher*) self, event);
	return result;
}

static gboolean
__lambda39_ (Block67Data* _data67_,
             cairo_t* ctx,
             gint width,
             gint height)
{
	GalaWindowSwitcher* self;
	ClutterColor _tmp0_;
	gboolean result;
	self = _data67_->self;
	g_return_val_if_fail (ctx != NULL, FALSE);
	cairo_save (ctx);
	cairo_clip (ctx);
	cairo_reset_clip (ctx);
	_tmp0_ = _data67_->accent_color;
	clutter_cairo_set_source_color (ctx, &_tmp0_);
	granite_drawing_utilities_cairo_rounded_rectangle (ctx, (gdouble) 0, (gdouble) 0, (gdouble) width, (gdouble) height, (gdouble) _data67_->rect_radius);
	cairo_fill (ctx);
	cairo_restore (ctx);
	result = TRUE;
	return result;
}

static gboolean
___lambda39__clutter_canvas_draw (ClutterCanvas* _sender,
                                  cairo_t* cr,
                                  gint width,
                                  gint height,
                                  gpointer self)
{
	gboolean result;
	result = __lambda39_ (self, cr, width, height);
	return result;
}

static ClutterColor*
_vala_clutter_color_from_string (const gchar* str)
{
	ClutterColor* color = NULL;
	ClutterColor* _tmp0_;
	ClutterColor* result;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = clutter_color_alloc ();
	color = _tmp0_;
	clutter_color_from_string (color, str);
	result = color;
	return result;
}

static void
_vala_ClutterColor_free (ClutterColor* self)
{
	g_boxed_free (clutter_color_get_type (), self);
}

static void
gala_window_switcher_create_components (GalaWindowSwitcher* self)
{
	Block67Data* _data67_;
	ClutterActor* _tmp0_;
	ClutterFlowLayout* layout = NULL;
	ClutterFlowLayout* _tmp1_;
	ClutterActor* _tmp2_;
	ClutterActor* _tmp3_;
	ClutterFlowLayout* _tmp4_;
	ClutterActor* _tmp5_;
	ClutterActor* _tmp6_;
	ClutterActor* _tmp7_;
	GdkRGBA rgba = {0};
	GdkRGBA _tmp8_ = {0};
	GdkRGBA _tmp9_;
	GdkRGBA _tmp10_;
	GdkRGBA _tmp11_;
	GdkRGBA _tmp12_;
	ClutterActor* _tmp13_;
	ClutterActor* _tmp14_;
	ClutterActor* _tmp15_;
	ClutterActor* _tmp16_;
	ClutterActor* _tmp17_;
	ClutterActor* _tmp18_;
	ClutterCanvas* indicator_canvas = NULL;
	ClutterCanvas* _tmp19_;
	ClutterActor* _tmp20_;
	ClutterCanvas* _tmp21_;
	ClutterCanvas* _tmp22_;
	ClutterCanvas* _tmp23_;
	gchar* caption_color = NULL;
	gchar* _tmp24_;
	GraniteSettings* _tmp25_;
	GraniteSettingsColorScheme _tmp26_;
	GraniteSettingsColorScheme _tmp27_;
	const gchar* _tmp29_;
	ClutterColor* _tmp30_;
	ClutterColor* _tmp31_;
	ClutterColor _tmp32_;
	ClutterText* _tmp33_;
	ClutterText* _tmp34_;
	ClutterText* _tmp35_;
	ClutterText* _tmp36_;
	ClutterActor* _tmp37_;
	ClutterActor* _tmp38_;
	ClutterText* _tmp39_;
	g_return_if_fail (self != NULL);
	_data67_ = g_slice_new0 (Block67Data);
	_data67_->_ref_count_ = 1;
	_data67_->self = g_object_ref (self);
	_tmp0_ = self->priv->container;
	if (_tmp0_ != NULL) {
		self->priv->caption_height = -1.0f;
		clutter_actor_destroy_all_children ((ClutterActor*) self);
	}
	_tmp1_ = (ClutterFlowLayout*) clutter_flow_layout_new (CLUTTER_FLOW_HORIZONTAL);
	g_object_ref_sink (_tmp1_);
	layout = _tmp1_;
	_tmp2_ = clutter_actor_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->container);
	self->priv->container = _tmp2_;
	_tmp3_ = self->priv->container;
	_tmp4_ = layout;
	clutter_actor_set_layout_manager (_tmp3_, (ClutterLayoutManager*) _tmp4_);
	_tmp5_ = self->priv->container;
	clutter_actor_set_reactive (_tmp5_, TRUE);
	_tmp6_ = self->priv->container;
	g_signal_connect_object (_tmp6_, "button-press-event", (GCallback) _gala_window_switcher_container_mouse_press_clutter_actor_button_press_event, self, 0);
	_tmp7_ = self->priv->container;
	g_signal_connect_object (_tmp7_, "motion-event", (GCallback) _gala_window_switcher_container_motion_event_clutter_actor_motion_event, self, 0);
	gala_internal_utils_get_theme_accent_color (&_tmp8_);
	rgba = _tmp8_;
	memset (&_data67_->accent_color, 0, sizeof (ClutterColor));
	_tmp9_ = rgba;
	_tmp10_ = rgba;
	_tmp11_ = rgba;
	_tmp12_ = rgba;
	clutter_color_init (&_data67_->accent_color, (guint8) (_tmp9_.red * 255), (guint8) (_tmp10_.green * 255), (guint8) (_tmp11_.blue * 255), (guint8) (_tmp12_.alpha * 255));
	_data67_->rect_radius = GALA_WINDOW_SWITCHER_WRAPPER_BORDER_RADIUS * self->priv->scaling_factor;
	_tmp13_ = clutter_actor_new ();
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->indicator);
	self->priv->indicator = _tmp13_;
	_tmp14_ = self->priv->indicator;
	_tmp15_ = self->priv->indicator;
	_tmp16_ = self->priv->indicator;
	_tmp17_ = self->priv->indicator;
	clutter_actor_set_margin_bottom (_tmp17_, (gfloat) 0);
	clutter_actor_set_margin_right (_tmp16_, (gfloat) 0);
	clutter_actor_set_margin_top (_tmp15_, (gfloat) 0);
	clutter_actor_set_margin_left (_tmp14_, (gfloat) 0);
	_tmp18_ = self->priv->indicator;
	clutter_actor_set_pivot_point (_tmp18_, 0.5f, 0.5f);
	_tmp19_ = (ClutterCanvas*) clutter_canvas_new ();
	indicator_canvas = _tmp19_;
	_tmp20_ = self->priv->indicator;
	_tmp21_ = indicator_canvas;
	clutter_actor_set_content (_tmp20_, (ClutterContent*) _tmp21_);
	_tmp22_ = indicator_canvas;
	clutter_canvas_set_scale_factor (_tmp22_, (gfloat) self->priv->scaling_factor);
	_tmp23_ = indicator_canvas;
	g_signal_connect_data (_tmp23_, "draw", (GCallback) ___lambda39__clutter_canvas_draw, block67_data_ref (_data67_), (GClosureNotify) block67_data_unref, 0);
	_tmp24_ = g_strdup ("#2e2e31");
	caption_color = _tmp24_;
	_tmp25_ = self->priv->granite_settings;
	_tmp26_ = granite_settings_get_prefers_color_scheme (_tmp25_);
	_tmp27_ = _tmp26_;
	if (_tmp27_ == GRANITE_SETTINGS_COLOR_SCHEME_DARK) {
		gchar* _tmp28_;
		_tmp28_ = g_strdup ("#fafafa");
		_g_free0 (caption_color);
		caption_color = _tmp28_;
	}
	_tmp29_ = caption_color;
	_tmp30_ = _vala_clutter_color_from_string (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = *_tmp31_;
	_tmp33_ = (ClutterText*) clutter_text_new_full (GALA_WINDOW_SWITCHER_CAPTION_FONT_NAME, "", &_tmp32_);
	g_object_ref_sink (_tmp33_);
	_g_object_unref0 (self->priv->caption);
	self->priv->caption = _tmp33_;
	__vala_ClutterColor_free0 (_tmp31_);
	_tmp34_ = self->priv->caption;
	clutter_actor_set_pivot_point ((ClutterActor*) _tmp34_, 0.5f, 0.5f);
	_tmp35_ = self->priv->caption;
	clutter_text_set_ellipsize (_tmp35_, PANGO_ELLIPSIZE_END);
	_tmp36_ = self->priv->caption;
	clutter_text_set_line_alignment (_tmp36_, PANGO_ALIGN_CENTER);
	_tmp37_ = self->priv->indicator;
	clutter_actor_add_child ((ClutterActor*) self, _tmp37_);
	_tmp38_ = self->priv->container;
	clutter_actor_add_child ((ClutterActor*) self, _tmp38_);
	_tmp39_ = self->priv->caption;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp39_);
	_g_free0 (caption_color);
	_g_object_unref0 (indicator_canvas);
	_g_object_unref0 (layout);
	block67_data_unref (_data67_);
	_data67_ = NULL;
}

void
gala_window_switcher_handle_switch_windows (MetaDisplay* display,
                                            MetaWindow* window,
                                            ClutterKeyEvent* event,
                                            MetaKeyBinding* binding,
                                            GalaWindowSwitcher* self)
{
	MetaWorkspace* workspace = NULL;
	MetaWorkspaceManager* _tmp0_;
	MetaWorkspace* _tmp1_;
	MetaWorkspace* _tmp2_;
	guint mask = 0U;
	gboolean _tmp3_;
	gchar* binding_name = NULL;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean backward = FALSE;
	const gchar* _tmp7_;
	MetaWorkspace* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	g_return_if_fail (event != NULL);
	g_return_if_fail (binding != NULL);
	_tmp0_ = meta_display_get_workspace_manager (display);
	_tmp1_ = meta_workspace_manager_get_active_workspace (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	workspace = _tmp2_;
	mask = meta_key_binding_get_mask (binding);
	if (mask == ((guint) 0)) {
		self->priv->modifier_mask = 0;
	} else {
		self->priv->modifier_mask = 1;
		while (TRUE) {
			if (!(mask > ((guint) 1))) {
				break;
			}
			mask >>= (guint) 1;
			self->priv->modifier_mask = self->priv->modifier_mask << 1;
		}
	}
	_tmp3_ = self->priv->_opened;
	if (!_tmp3_) {
		gboolean windows_exist = FALSE;
		MetaWorkspace* _tmp4_;
		_tmp4_ = workspace;
		windows_exist = gala_window_switcher_collect_windows (self, display, _tmp4_);
		if (!windows_exist) {
			_g_object_unref0 (workspace);
			return;
		}
		gala_window_switcher_open_switcher (self);
		gala_window_switcher_update_indicator_position (self, TRUE);
	}
	_tmp5_ = meta_key_binding_get_name (binding);
	_tmp6_ = g_strdup (_tmp5_);
	binding_name = _tmp6_;
	_tmp7_ = binding_name;
	backward = g_str_has_suffix (_tmp7_, "-backward");
	_tmp8_ = workspace;
	gala_window_switcher_next_window (self, display, _tmp8_, backward);
	_g_free0 (binding_name);
	_g_object_unref0 (workspace);
}

static gboolean
gala_window_switcher_collect_windows (GalaWindowSwitcher* self,
                                      MetaDisplay* display,
                                      MetaWorkspace* workspace)
{
	GList* windows = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	MetaWindow* current_window = NULL;
	MetaWindow* _tmp2_;
	MetaWindow* _tmp3_;
	ClutterActor* _tmp4_;
	ClutterActor* _tmp5_;
	GList* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (display != NULL, FALSE);
	_tmp0_ = meta_display_get_tab_list (display, META_TAB_LIST_NORMAL, workspace);
	windows = _tmp0_;
	_tmp1_ = windows;
	if (_tmp1_ == NULL) {
		result = FALSE;
		(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
		return result;
	}
	_tmp2_ = meta_display_get_tab_current (display, META_TAB_LIST_NORMAL, workspace);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	current_window = _tmp3_;
	_tmp4_ = self->priv->container;
	clutter_actor_set_width (_tmp4_, (gfloat) -1);
	_tmp5_ = self->priv->container;
	clutter_actor_destroy_all_children (_tmp5_);
	_tmp6_ = windows;
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp6_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				GalaWindowIcon* icon = NULL;
				MetaWindow* _tmp7_;
				GalaWindowIcon* _tmp8_;
				MetaWindow* _tmp9_;
				MetaWindow* _tmp10_;
				GalaWindowIcon* _tmp13_;
				ClutterActor* _tmp14_;
				GalaWindowIcon* _tmp15_;
				_tmp7_ = window;
				_tmp8_ = gala_window_icon_new (_tmp7_, GALA_WINDOW_SWITCHER_ICON_SIZE * self->priv->scaling_factor, 1, FALSE);
				g_object_ref_sink (_tmp8_);
				icon = _tmp8_;
				_tmp9_ = window;
				_tmp10_ = current_window;
				if (_tmp9_ == _tmp10_) {
					GalaWindowIcon* _tmp11_;
					GalaWindowIcon* _tmp12_;
					_tmp11_ = icon;
					_tmp12_ = _g_object_ref0 (_tmp11_);
					_g_object_unref0 (self->priv->cur_icon);
					self->priv->cur_icon = _tmp12_;
				}
				_tmp13_ = icon;
				clutter_actor_set_pivot_point ((ClutterActor*) _tmp13_, 0.5f, 0.5f);
				_tmp14_ = self->priv->container;
				_tmp15_ = icon;
				clutter_actor_add_child (_tmp14_, (ClutterActor*) _tmp15_);
				_g_object_unref0 (icon);
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (current_window);
	(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
	return result;
}

static gboolean
__lambda40_ (GalaWindowSwitcher* self,
             MetaKeyBinding* binding)
{
	gchar* name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gboolean result;
	g_return_val_if_fail (binding != NULL, FALSE);
	if (!meta_key_binding_is_builtin (binding)) {
		result = TRUE;
		return result;
	}
	_tmp0_ = meta_key_binding_get_name (binding);
	_tmp1_ = g_strdup (_tmp0_);
	name = _tmp1_;
	_tmp5_ = name;
	if (g_strcmp0 (_tmp5_, "switch-applications") == 0) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp6_;
		_tmp6_ = name;
		_tmp4_ = g_strcmp0 (_tmp6_, "switch-applications-backward") == 0;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp7_;
		_tmp7_ = name;
		_tmp3_ = g_strcmp0 (_tmp7_, "switch-windows") == 0;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp8_;
		_tmp8_ = name;
		_tmp2_ = g_strcmp0 (_tmp8_, "switch-windows-backward") == 0;
	}
	result = !_tmp2_;
	_g_free0 (name);
	return result;
}

static gboolean
___lambda40__gala_keybinding_filter (MetaKeyBinding* binding,
                                     gpointer self)
{
	gboolean result;
	result = __lambda40_ ((GalaWindowSwitcher*) self, binding);
	return result;
}

static void
gala_window_switcher_open_switcher (GalaWindowSwitcher* self)
{
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaDisplay* _tmp2_;
	ClutterActor* _tmp3_;
	gboolean _tmp5_;
	ClutterActor* _tmp6_;
	ClutterActor* _tmp7_;
	ClutterActor* _tmp8_;
	ClutterActor* _tmp9_;
	ClutterFlowLayout* l = NULL;
	ClutterActor* _tmp10_;
	ClutterLayoutManager* _tmp11_;
	ClutterLayoutManager* _tmp12_;
	ClutterFlowLayout* _tmp13_;
	ClutterFlowLayout* _tmp14_;
	ClutterFlowLayout* _tmp15_;
	ClutterActor* _tmp16_;
	gint indicator_size = 0;
	ClutterActor* _tmp17_;
	ClutterActor* _tmp18_;
	ClutterContent* _tmp19_;
	ClutterContent* _tmp20_;
	ClutterText* _tmp21_;
	ClutterText* _tmp22_;
	ClutterText* _tmp23_;
	gint monitor = 0;
	MetaDisplay* _tmp24_;
	MetaRectangle geom = {0};
	MetaDisplay* _tmp25_;
	MetaRectangle _tmp26_ = {0};
	gfloat container_width = 0.0F;
	ClutterActor* _tmp27_;
	ClutterActor* _tmp28_;
	gfloat _tmp29_;
	gfloat _tmp30_;
	ClutterActor* _tmp31_;
	gfloat _tmp32_;
	gfloat _tmp33_;
	gfloat _tmp34_ = 0.0F;
	MetaRectangle _tmp35_;
	gfloat nat_width = 0.0F;
	gfloat nat_height = 0.0F;
	ClutterActor* _tmp38_;
	gfloat _tmp39_ = 0.0F;
	ClutterActor* _tmp40_;
	ClutterActor* _tmp41_;
	gfloat _tmp42_ = 0.0F;
	gint switcher_height = 0;
	ClutterActor* _tmp46_;
	gfloat _tmp47_;
	gfloat _tmp48_;
	ClutterCanvas* _tmp49_;
	ClutterCanvas* _tmp50_;
	MetaRectangle _tmp51_;
	MetaRectangle _tmp52_;
	gfloat _tmp53_;
	gfloat _tmp54_;
	MetaRectangle _tmp55_;
	MetaRectangle _tmp56_;
	gfloat _tmp57_;
	gfloat _tmp58_;
	GalaWindowManager* _tmp59_;
	GalaModalProxy* _tmp60_;
	GalaModalProxy* _tmp61_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	display = _tmp2_;
	_tmp3_ = self->priv->container;
	if (clutter_actor_get_n_children (_tmp3_) == 0) {
		MetaDisplay* _tmp4_;
		_tmp4_ = display;
		gala_utils_bell (_tmp4_);
		_g_object_unref0 (display);
		return;
	}
	_tmp5_ = self->priv->_opened;
	if (_tmp5_) {
		_g_object_unref0 (display);
		return;
	}
	_tmp6_ = self->priv->container;
	_tmp7_ = self->priv->container;
	_tmp8_ = self->priv->container;
	_tmp9_ = self->priv->container;
	clutter_actor_set_margin_bottom (_tmp9_, (gfloat) ((GALA_WINDOW_SWITCHER_WRAPPER_PADDING * 2) * self->priv->scaling_factor));
	clutter_actor_set_margin_right (_tmp8_, (gfloat) ((GALA_WINDOW_SWITCHER_WRAPPER_PADDING * 2) * self->priv->scaling_factor));
	clutter_actor_set_margin_top (_tmp7_, (gfloat) ((GALA_WINDOW_SWITCHER_WRAPPER_PADDING * 2) * self->priv->scaling_factor));
	clutter_actor_set_margin_left (_tmp6_, (gfloat) ((GALA_WINDOW_SWITCHER_WRAPPER_PADDING * 2) * self->priv->scaling_factor));
	_tmp10_ = self->priv->container;
	_tmp11_ = clutter_actor_get_layout_manager (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, clutter_flow_layout_get_type ()) ? ((ClutterFlowLayout*) _tmp12_) : NULL);
	l = _tmp13_;
	_tmp14_ = l;
	_tmp15_ = l;
	clutter_flow_layout_set_row_spacing (_tmp15_, (gfloat) (GALA_WINDOW_SWITCHER_WRAPPER_PADDING * self->priv->scaling_factor));
	clutter_flow_layout_set_column_spacing (_tmp14_, (gfloat) (GALA_WINDOW_SWITCHER_WRAPPER_PADDING * self->priv->scaling_factor));
	_tmp16_ = self->priv->indicator;
	g_object_set (_tmp16_, "visible", FALSE, NULL);
	indicator_size = (GALA_WINDOW_SWITCHER_ICON_SIZE + (GALA_WINDOW_SWITCHER_WRAPPER_PADDING * 2)) * self->priv->scaling_factor;
	_tmp17_ = self->priv->indicator;
	clutter_actor_set_size (_tmp17_, (gfloat) indicator_size, (gfloat) indicator_size);
	_tmp18_ = self->priv->indicator;
	_tmp19_ = clutter_actor_get_content (_tmp18_);
	_tmp20_ = _tmp19_;
	clutter_canvas_set_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, clutter_canvas_get_type (), ClutterCanvas), indicator_size, indicator_size);
	_tmp21_ = self->priv->caption;
	g_object_set ((ClutterActor*) _tmp21_, "visible", FALSE, NULL);
	_tmp22_ = self->priv->caption;
	_tmp23_ = self->priv->caption;
	clutter_actor_set_margin_top ((ClutterActor*) _tmp23_, (gfloat) (GALA_WINDOW_SWITCHER_WRAPPER_PADDING * self->priv->scaling_factor));
	clutter_actor_set_margin_bottom ((ClutterActor*) _tmp22_, (gfloat) (GALA_WINDOW_SWITCHER_WRAPPER_PADDING * self->priv->scaling_factor));
	_tmp24_ = display;
	monitor = meta_display_get_current_monitor (_tmp24_);
	_tmp25_ = display;
	meta_display_get_monitor_geometry (_tmp25_, monitor, &_tmp26_);
	geom = _tmp26_;
	_tmp27_ = self->priv->container;
	_tmp28_ = self->priv->container;
	_tmp29_ = clutter_actor_get_margin_left (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = self->priv->container;
	_tmp32_ = clutter_actor_get_margin_right (_tmp31_);
	_tmp33_ = _tmp32_;
	clutter_actor_get_preferred_width (_tmp27_, ((GALA_WINDOW_SWITCHER_ICON_SIZE * self->priv->scaling_factor) + _tmp30_) + _tmp33_, NULL, &_tmp34_);
	container_width = _tmp34_;
	_tmp35_ = geom;
	if ((container_width + ((GALA_WINDOW_SWITCHER_MIN_OFFSET * self->priv->scaling_factor) * 2)) > ((gfloat) _tmp35_.width)) {
		ClutterActor* _tmp36_;
		MetaRectangle _tmp37_;
		_tmp36_ = self->priv->container;
		_tmp37_ = geom;
		clutter_actor_set_width (_tmp36_, (gfloat) (_tmp37_.width - ((GALA_WINDOW_SWITCHER_MIN_OFFSET * self->priv->scaling_factor) * 2)));
	}
	_tmp38_ = self->priv->container;
	clutter_actor_get_preferred_size (_tmp38_, NULL, NULL, &_tmp39_, NULL);
	nat_width = _tmp39_;
	_tmp40_ = self->priv->container;
	if (clutter_actor_get_n_children (_tmp40_) == 1) {
		nat_width -= (gfloat) (GALA_WINDOW_SWITCHER_WRAPPER_PADDING * self->priv->scaling_factor);
	}
	_tmp41_ = self->priv->container;
	clutter_actor_get_preferred_size (_tmp41_, NULL, NULL, NULL, &_tmp42_);
	nat_height = _tmp42_;
	if (self->priv->caption_height == (-1.0f)) {
		ClutterText* _tmp43_;
		gfloat _tmp44_;
		gfloat _tmp45_;
		_tmp43_ = self->priv->caption;
		_tmp44_ = clutter_actor_get_height ((ClutterActor*) _tmp43_);
		_tmp45_ = _tmp44_;
		self->priv->caption_height = _tmp45_;
	}
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 0);
	_tmp46_ = self->priv->container;
	_tmp47_ = clutter_actor_get_margin_bottom (_tmp46_);
	_tmp48_ = _tmp47_;
	switcher_height = (gint) (((nat_height + (self->priv->caption_height / 2)) - _tmp48_) + ((GALA_WINDOW_SWITCHER_WRAPPER_PADDING * 3) * self->priv->scaling_factor));
	clutter_actor_set_size ((ClutterActor*) self, (gfloat) ((gint) nat_width), (gfloat) switcher_height);
	_tmp49_ = self->priv->canvas;
	clutter_canvas_set_size (_tmp49_, (gint) nat_width, switcher_height);
	_tmp50_ = self->priv->canvas;
	clutter_content_invalidate ((ClutterContent*) _tmp50_);
	_tmp51_ = geom;
	_tmp52_ = geom;
	_tmp53_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp54_ = _tmp53_;
	_tmp55_ = geom;
	_tmp56_ = geom;
	_tmp57_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp58_ = _tmp57_;
	clutter_actor_set_position ((ClutterActor*) self, (gfloat) ((gint) (_tmp51_.x + ((_tmp52_.width - _tmp54_) / 2))), (gfloat) ((gint) (_tmp55_.y + ((_tmp56_.height - _tmp58_) / 2))));
	clutter_actor_save_easing_state ((ClutterActor*) self);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) 200);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 255);
	clutter_actor_restore_easing_state ((ClutterActor*) self);
	_tmp59_ = self->priv->_wm;
	_tmp60_ = gala_window_manager_push_modal (_tmp59_);
	_g_object_unref0 (self->priv->modal_proxy);
	self->priv->modal_proxy = _tmp60_;
	_tmp61_ = self->priv->modal_proxy;
	gala_modal_proxy_set_keybinding_filter (_tmp61_, ___lambda40__gala_keybinding_filter, g_object_ref (self), g_object_unref);
	gala_window_switcher_set_opened (self, TRUE);
	clutter_actor_grab_key_focus ((ClutterActor*) self);
	if ((gala_window_switcher_get_current_modifiers (self) & self->priv->modifier_mask) == 0) {
		GalaWindowManager* _tmp62_;
		MetaDisplay* _tmp63_;
		_tmp62_ = self->priv->_wm;
		_tmp63_ = meta_plugin_get_display ((MetaPlugin*) _tmp62_);
		gala_window_switcher_close_switcher (self, meta_display_get_current_time (_tmp63_), FALSE);
	}
	_g_object_unref0 (l);
	_g_object_unref0 (display);
}

static void
gala_window_switcher_close_switcher (GalaWindowSwitcher* self,
                                     guint32 time,
                                     gboolean cancel)
{
	gboolean _tmp0_;
	GalaWindowManager* _tmp1_;
	GalaModalProxy* _tmp2_;
	MetaWindow* window = NULL;
	GalaWindowIcon* _tmp3_;
	MetaWindow* _tmp4_;
	MetaWindow* _tmp5_;
	MetaWindow* _tmp6_;
	MetaWindow* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_opened;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->_wm;
	_tmp2_ = self->priv->modal_proxy;
	gala_window_manager_pop_modal (_tmp1_, _tmp2_);
	gala_window_switcher_set_opened (self, FALSE);
	_tmp3_ = self->priv->cur_icon;
	_tmp4_ = gala_window_icon_get_window (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	window = _tmp6_;
	_tmp7_ = window;
	if (_tmp7_ == NULL) {
		_g_object_unref0 (window);
		return;
	}
	if (!cancel) {
		MetaWorkspace* workspace = NULL;
		MetaWindow* _tmp8_;
		MetaWorkspace* _tmp9_;
		MetaWorkspace* _tmp10_;
		MetaWorkspace* _tmp11_;
		GalaWindowManager* _tmp12_;
		MetaDisplay* _tmp13_;
		MetaWorkspaceManager* _tmp14_;
		MetaWorkspace* _tmp15_;
		_tmp8_ = window;
		_tmp9_ = meta_window_get_workspace (_tmp8_);
		_tmp10_ = _g_object_ref0 (_tmp9_);
		workspace = _tmp10_;
		_tmp11_ = workspace;
		_tmp12_ = self->priv->_wm;
		_tmp13_ = meta_plugin_get_display ((MetaPlugin*) _tmp12_);
		_tmp14_ = meta_display_get_workspace_manager (_tmp13_);
		_tmp15_ = meta_workspace_manager_get_active_workspace (_tmp14_);
		if (_tmp11_ != _tmp15_) {
			MetaWorkspace* _tmp16_;
			MetaWindow* _tmp17_;
			_tmp16_ = workspace;
			_tmp17_ = window;
			meta_workspace_activate_with_focus (_tmp16_, _tmp17_, time);
		} else {
			MetaWindow* _tmp18_;
			_tmp18_ = window;
			meta_window_activate (_tmp18_, time);
		}
		_g_object_unref0 (workspace);
	}
	clutter_actor_save_easing_state ((ClutterActor*) self);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) 100);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 0);
	clutter_actor_restore_easing_state ((ClutterActor*) self);
	_g_object_unref0 (window);
}

static void
gala_window_switcher_next_window (GalaWindowSwitcher* self,
                                  MetaDisplay* display,
                                  MetaWorkspace* workspace,
                                  gboolean backward)
{
	ClutterActor* actor = NULL;
	GalaWindowIcon* current = NULL;
	GalaWindowIcon* _tmp0_;
	GalaWindowIcon* _tmp1_;
	ClutterActor* _tmp2_;
	ClutterActor* _tmp17_;
	GalaWindowIcon* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	_tmp0_ = self->priv->cur_icon;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	current = _tmp1_;
	_tmp2_ = self->priv->container;
	if (clutter_actor_get_n_children (_tmp2_) == 1) {
		gala_utils_bell (display);
		_g_object_unref0 (current);
		_g_object_unref0 (actor);
		return;
	}
	if (!backward) {
		GalaWindowIcon* _tmp3_;
		ClutterActor* _tmp4_;
		ClutterActor* _tmp5_;
		ClutterActor* _tmp6_;
		_tmp3_ = current;
		_tmp4_ = clutter_actor_get_next_sibling ((ClutterActor*) _tmp3_);
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_g_object_unref0 (actor);
		actor = _tmp5_;
		_tmp6_ = actor;
		if (_tmp6_ == NULL) {
			ClutterActor* _tmp7_;
			ClutterActor* _tmp8_;
			ClutterActor* _tmp9_;
			_tmp7_ = self->priv->container;
			_tmp8_ = clutter_actor_get_first_child (_tmp7_);
			_tmp9_ = _g_object_ref0 (_tmp8_);
			_g_object_unref0 (actor);
			actor = _tmp9_;
		}
	} else {
		GalaWindowIcon* _tmp10_;
		ClutterActor* _tmp11_;
		ClutterActor* _tmp12_;
		ClutterActor* _tmp13_;
		_tmp10_ = current;
		_tmp11_ = clutter_actor_get_previous_sibling ((ClutterActor*) _tmp10_);
		_tmp12_ = _g_object_ref0 (_tmp11_);
		_g_object_unref0 (actor);
		actor = _tmp12_;
		_tmp13_ = actor;
		if (_tmp13_ == NULL) {
			ClutterActor* _tmp14_;
			ClutterActor* _tmp15_;
			ClutterActor* _tmp16_;
			_tmp14_ = self->priv->container;
			_tmp15_ = clutter_actor_get_last_child (_tmp14_);
			_tmp16_ = _g_object_ref0 (_tmp15_);
			_g_object_unref0 (actor);
			actor = _tmp16_;
		}
	}
	_tmp17_ = actor;
	_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GALA_TYPE_WINDOW_ICON, GalaWindowIcon));
	_g_object_unref0 (self->priv->cur_icon);
	self->priv->cur_icon = _tmp18_;
	gala_window_switcher_update_indicator_position (self, FALSE);
	_g_object_unref0 (current);
	_g_object_unref0 (actor);
}

static void
gala_window_switcher_update_caption_text (GalaWindowSwitcher* self)
{
	MetaWindow* current_window = NULL;
	GalaWindowIcon* _tmp0_;
	MetaWindow* _tmp1_;
	MetaWindow* _tmp2_;
	MetaWindow* _tmp3_;
	gchar* current_caption = NULL;
	gchar* _tmp4_;
	MetaWindow* _tmp5_;
	ClutterText* _tmp9_;
	const gchar* _tmp10_;
	ClutterText* _tmp11_;
	ClutterText* _tmp12_;
	gfloat _tmp13_;
	gfloat _tmp14_;
	ClutterText* _tmp15_;
	gfloat _tmp16_;
	gfloat _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cur_icon;
	_tmp1_ = gala_window_icon_get_window (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	current_window = _tmp3_;
	_tmp4_ = g_strdup ("n/a");
	current_caption = _tmp4_;
	_tmp5_ = current_window;
	if (_tmp5_ != NULL) {
		MetaWindow* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = current_window;
		_tmp7_ = meta_window_get_title (_tmp6_);
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (current_caption);
		current_caption = _tmp8_;
	}
	_tmp9_ = self->priv->caption;
	_tmp10_ = current_caption;
	clutter_text_set_text (_tmp9_, _tmp10_);
	_tmp11_ = self->priv->caption;
	g_object_set ((ClutterActor*) _tmp11_, "visible", TRUE, NULL);
	_tmp12_ = self->priv->caption;
	_tmp13_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp14_ = _tmp13_;
	clutter_actor_set_width ((ClutterActor*) _tmp12_, _tmp14_ - ((GALA_WINDOW_SWITCHER_WRAPPER_PADDING * 2) * self->priv->scaling_factor));
	_tmp15_ = self->priv->caption;
	_tmp16_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp17_ = _tmp16_;
	clutter_actor_set_position ((ClutterActor*) _tmp15_, (gfloat) (GALA_WINDOW_SWITCHER_WRAPPER_PADDING * self->priv->scaling_factor), (gfloat) ((gint) ((_tmp17_ - (self->priv->caption_height / 2)) - ((GALA_WINDOW_SWITCHER_WRAPPER_PADDING * self->priv->scaling_factor) * 2))));
	_g_free0 (current_caption);
	_g_object_unref0 (current_window);
}

static Block68Data*
block68_data_ref (Block68Data* _data68_)
{
	g_atomic_int_inc (&_data68_->_ref_count_);
	return _data68_;
}

static void
block68_data_unref (void * _userdata_)
{
	Block68Data* _data68_;
	_data68_ = (Block68Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data68_->_ref_count_)) {
		GalaWindowSwitcher* self;
		self = _data68_->self;
		_g_object_unref0 (self);
		g_slice_free (Block68Data, _data68_);
	}
}

static void
_vala_ClutterActorBox_free (ClutterActorBox* self)
{
	g_boxed_free (clutter_actor_box_get_type (), self);
}

static gboolean
___lambda38_ (Block68Data* _data68_)
{
	GalaWindowSwitcher* self;
	gboolean result;
	self = _data68_->self;
	gala_window_switcher_update_indicator_position (self, _data68_->initial);
	result = FALSE;
	return result;
}

static gboolean
____lambda38__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda38_ (self);
	return result;
}

static void
gala_window_switcher_update_indicator_position (GalaWindowSwitcher* self,
                                                gboolean initial)
{
	Block68Data* _data68_;
	gboolean _tmp0_ = FALSE;
	ClutterActor* _tmp1_;
	gfloat x = 0.0F;
	gfloat y = 0.0F;
	GalaWindowIcon* _tmp7_;
	ClutterActorBox* _tmp8_;
	ClutterActorBox* _tmp9_;
	ClutterActorBox* _tmp10_;
	gfloat _tmp11_ = 0.0F;
	gfloat _tmp12_ = 0.0F;
	gfloat _tmp14_ = 0.0F;
	ClutterActor* _tmp15_;
	ClutterActor* _tmp16_;
	ClutterActor* _tmp17_;
	gfloat _tmp18_;
	gfloat _tmp19_;
	ClutterActor* _tmp20_;
	ClutterActor* _tmp21_;
	gfloat _tmp22_;
	gfloat _tmp23_;
	g_return_if_fail (self != NULL);
	_data68_ = g_slice_new0 (Block68Data);
	_data68_->_ref_count_ = 1;
	_data68_->self = g_object_ref (self);
	_data68_->initial = initial;
	_tmp1_ = self->priv->container;
	if (clutter_actor_get_n_children (_tmp1_) > 1) {
		ClutterActor* _tmp2_;
		ClutterActor* _tmp3_;
		ClutterActorBox* _tmp4_;
		ClutterActorBox* _tmp5_;
		ClutterActorBox* _tmp6_;
		_tmp2_ = self->priv->container;
		_tmp3_ = clutter_actor_get_child_at_index (_tmp2_, 1);
		g_object_get (_tmp3_, "allocation", &_tmp4_, NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_;
		_tmp0_ = (*_tmp6_).x1 < ((gfloat) 1);
		__vala_ClutterActorBox_free0 (_tmp6_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) GALA_WINDOW_SWITCHER_FIX_TIMEOUT_INTERVAL, ____lambda38__gsource_func, block68_data_ref (_data68_), block68_data_unref);
		block68_data_unref (_data68_);
		_data68_ = NULL;
		return;
	}
	_tmp7_ = self->priv->cur_icon;
	g_object_get ((ClutterActor*) _tmp7_, "allocation", &_tmp8_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_;
	clutter_actor_box_get_origin (_tmp10_, &_tmp11_, &_tmp12_);
	x = _tmp11_;
	y = _tmp12_;
	__vala_ClutterActorBox_free0 (_tmp10_);
	if (_data68_->initial) {
		ClutterActor* _tmp13_;
		_tmp13_ = self->priv->indicator;
		g_object_set (_tmp13_, "visible", TRUE, NULL);
	}
	_tmp15_ = self->priv->container;
	if (clutter_actor_get_n_children (_tmp15_) > 1) {
		_tmp14_ = x;
	} else {
		_tmp14_ = (gfloat) 0;
	}
	_tmp16_ = self->priv->indicator;
	_tmp17_ = self->priv->container;
	_tmp18_ = clutter_actor_get_margin_left (_tmp17_);
	_tmp19_ = _tmp18_;
	clutter_actor_set_x (_tmp16_, (_tmp19_ + _tmp14_) - (GALA_WINDOW_SWITCHER_WRAPPER_PADDING * self->priv->scaling_factor));
	_tmp20_ = self->priv->indicator;
	_tmp21_ = self->priv->container;
	_tmp22_ = clutter_actor_get_margin_top (_tmp21_);
	_tmp23_ = _tmp22_;
	clutter_actor_set_y (_tmp20_, (_tmp23_ + y) - (GALA_WINDOW_SWITCHER_WRAPPER_PADDING * self->priv->scaling_factor));
	gala_window_switcher_update_caption_text (self);
	block68_data_unref (_data68_);
	_data68_ = NULL;
}

static void
gala_window_switcher_real_key_focus_out (ClutterActor* base)
{
	GalaWindowSwitcher * self;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	self = (GalaWindowSwitcher*) base;
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	gala_window_switcher_close_switcher (self, meta_display_get_current_time (_tmp1_), FALSE);
}

static gboolean
gala_window_switcher_container_motion_event (GalaWindowSwitcher* self,
                                             ClutterMotionEvent* event)
{
	ClutterActor* actor = NULL;
	ClutterStage* _tmp0_;
	ClutterActor* _tmp1_;
	ClutterActor* _tmp2_;
	ClutterActor* _tmp3_;
	GalaWindowIcon* selected = NULL;
	ClutterActor* _tmp4_;
	GalaWindowIcon* _tmp5_;
	GalaWindowIcon* _tmp6_;
	GalaWindowIcon* _tmp7_;
	GalaWindowIcon* _tmp8_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event->stage;
	_tmp1_ = clutter_stage_get_actor_at_pos (_tmp0_, CLUTTER_PICK_ALL, (gfloat) ((gint) event->x), (gfloat) ((gint) event->y));
	_tmp2_ = _g_object_ref0 (_tmp1_);
	actor = _tmp2_;
	_tmp3_ = actor;
	if (_tmp3_ == NULL) {
		result = TRUE;
		_g_object_unref0 (actor);
		return result;
	}
	_tmp4_ = actor;
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, GALA_TYPE_WINDOW_ICON) ? ((GalaWindowIcon*) _tmp4_) : NULL);
	selected = _tmp5_;
	_tmp6_ = selected;
	if (_tmp6_ == NULL) {
		result = TRUE;
		_g_object_unref0 (selected);
		_g_object_unref0 (actor);
		return result;
	}
	_tmp7_ = self->priv->cur_icon;
	_tmp8_ = selected;
	if (_tmp7_ != _tmp8_) {
		GalaWindowIcon* _tmp9_;
		GalaWindowIcon* _tmp10_;
		_tmp9_ = selected;
		_tmp10_ = _g_object_ref0 (_tmp9_);
		_g_object_unref0 (self->priv->cur_icon);
		self->priv->cur_icon = _tmp10_;
		gala_window_switcher_update_indicator_position (self, FALSE);
	}
	result = TRUE;
	_g_object_unref0 (selected);
	_g_object_unref0 (actor);
	return result;
}

static gboolean
gala_window_switcher_container_mouse_press (GalaWindowSwitcher* self,
                                            ClutterButtonEvent* event)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = self->priv->_opened;
	if (_tmp1_) {
		_tmp0_ = event->button == ((guint32) GDK_BUTTON_PRIMARY);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gala_window_switcher_close_switcher (self, event->time, FALSE);
	}
	result = TRUE;
	return result;
}

static gboolean
gala_window_switcher_real_key_release_event (ClutterActor* base,
                                             ClutterKeyEvent* event)
{
	GalaWindowSwitcher * self;
	gboolean result;
	self = (GalaWindowSwitcher*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if ((gala_window_switcher_get_current_modifiers (self) & self->priv->modifier_mask) == 0) {
		gala_window_switcher_close_switcher (self, event->time, FALSE);
		result = TRUE;
		return result;
	}
	switch (event->keyval) {
		case CLUTTER_KEY_Escape:
		{
			gala_window_switcher_close_switcher (self, event->time, TRUE);
			result = TRUE;
			return result;
		}
		default:
		break;
	}
	result = FALSE;
	return result;
}

static GdkModifierType
gala_window_switcher_get_current_modifiers (GalaWindowSwitcher* self)
{
	GdkModifierType modifiers = 0U;
	gdouble* axes = NULL;
	gdouble* _tmp0_;
	gint axes_length1;
	gint _axes_size_;
	GdkDisplay* _tmp1_;
	GdkDeviceManager* _tmp2_;
	GdkDevice* _tmp3_;
	GdkWindow* _tmp4_;
	GdkModifierType _tmp5_ = 0U;
	GdkModifierType result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = g_new0 (gdouble, 0);
	axes = _tmp0_;
	axes_length1 = 0;
	_axes_size_ = axes_length1;
	_tmp1_ = gdk_display_get_default ();
	_tmp2_ = gdk_display_get_device_manager (_tmp1_);
	_tmp3_ = gdk_device_manager_get_client_pointer (_tmp2_);
	_tmp4_ = gdk_get_default_root_window ();
	gdk_device_get_state (_tmp3_, _tmp4_, axes, &_tmp5_);
	modifiers = _tmp5_;
	result = modifiers;
	axes = (g_free (axes), NULL);
	return result;
}

gboolean
gala_window_switcher_get_opened (GalaWindowSwitcher* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_opened;
	return result;
}

static void
gala_window_switcher_set_opened (GalaWindowSwitcher* self,
                                 gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_switcher_get_opened (self);
	if (old_value != value) {
		self->priv->_opened = value;
		g_object_notify_by_pspec ((GObject *) self, gala_window_switcher_properties[GALA_WINDOW_SWITCHER_OPENED_PROPERTY]);
	}
}

GalaWindowManager*
gala_window_switcher_get_wm (GalaWindowSwitcher* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static void
gala_window_switcher_set_wm (GalaWindowSwitcher* self,
                             GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_switcher_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_window_switcher_properties[GALA_WINDOW_SWITCHER_WM_PROPERTY]);
	}
}

static void
_gala_window_switcher___lambda41_ (GalaWindowSwitcher* self)
{
	ClutterCanvas* _tmp0_;
	_tmp0_ = self->priv->canvas;
	clutter_content_invalidate ((ClutterContent*) _tmp0_);
	gala_window_switcher_create_components (self);
}

static void
__gala_window_switcher___lambda41__g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self)
{
	_gala_window_switcher___lambda41_ ((GalaWindowSwitcher*) self);
}

static void
_gala_window_switcher___lambda42_ (GalaWindowSwitcher* self)
{
	gint cur_scale = 0;
	cur_scale = gala_internal_utils_get_ui_scaling_factor ();
	if (cur_scale != self->priv->scaling_factor) {
		ClutterCanvas* _tmp0_;
		self->priv->scaling_factor = cur_scale;
		_tmp0_ = self->priv->canvas;
		clutter_canvas_set_scale_factor (_tmp0_, (gfloat) self->priv->scaling_factor);
		gala_window_switcher_create_components (self);
	}
}

static void
__gala_window_switcher___lambda42__meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                          gpointer self)
{
	_gala_window_switcher___lambda42_ ((GalaWindowSwitcher*) self);
}

static gboolean
_gala_window_switcher_draw_clutter_canvas_draw (ClutterCanvas* _sender,
                                                cairo_t* cr,
                                                gint width,
                                                gint height,
                                                gpointer self)
{
	gboolean result;
	result = gala_window_switcher_draw ((GalaWindowSwitcher*) self, cr, width, height);
	return result;
}

static GObject *
gala_window_switcher_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaWindowSwitcher * self;
	GraniteSettings* _tmp0_;
	GraniteSettings* _tmp1_;
	ClutterCanvas* _tmp2_;
	ClutterCanvas* _tmp3_;
	ClutterCanvas* _tmp4_;
	GalaShadowEffect* effect = NULL;
	gchar* _tmp5_;
	GalaShadowEffect* _tmp6_ = NULL;
	GalaShadowEffect* _tmp7_;
	GraniteSettings* _tmp8_;
	MetaMonitorManager* _tmp9_;
	ClutterCanvas* _tmp10_;
	parent_class = G_OBJECT_CLASS (gala_window_switcher_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_SWITCHER, GalaWindowSwitcher);
	_tmp0_ = granite_settings_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->granite_settings);
	self->priv->granite_settings = _tmp1_;
	self->priv->scaling_factor = gala_internal_utils_get_ui_scaling_factor ();
	_tmp2_ = (ClutterCanvas*) clutter_canvas_new ();
	_g_object_unref0 (self->priv->canvas);
	self->priv->canvas = _tmp2_;
	_tmp3_ = self->priv->canvas;
	clutter_canvas_set_scale_factor (_tmp3_, (gfloat) self->priv->scaling_factor);
	_tmp4_ = self->priv->canvas;
	clutter_actor_set_content ((ClutterActor*) self, (ClutterContent*) _tmp4_);
	gala_window_switcher_create_components (self);
	_tmp5_ = g_strdup ("workspace");
	_tmp6_ = gala_shadow_effect_new (30, 1);
	gala_shadow_effect_set_shadow_opacity (_tmp6_, (guint8) 200);
	gala_shadow_effect_set_css_class (_tmp6_, _tmp5_);
	_g_free0 (_tmp5_);
	g_object_ref_sink (_tmp6_);
	effect = _tmp6_;
	_tmp7_ = effect;
	clutter_actor_add_effect ((ClutterActor*) self, (ClutterEffect*) _tmp7_);
	_tmp8_ = self->priv->granite_settings;
	g_signal_connect_object ((GObject*) _tmp8_, "notify::prefers-color-scheme", (GCallback) __gala_window_switcher___lambda41__g_object_notify, self, 0);
	_tmp9_ = meta_monitor_manager_get ();
	g_signal_connect_object (_tmp9_, "monitors-changed", (GCallback) __gala_window_switcher___lambda42__meta_monitor_manager_monitors_changed, self, 0);
	_tmp10_ = self->priv->canvas;
	g_signal_connect_object (_tmp10_, "draw", (GCallback) _gala_window_switcher_draw_clutter_canvas_draw, self, 0);
	_g_object_unref0 (effect);
	return obj;
}

static void
gala_window_switcher_class_init (GalaWindowSwitcherClass * klass,
                                 gpointer klass_data)
{
	gala_window_switcher_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaWindowSwitcher_private_offset);
	((ClutterActorClass *) klass)->key_focus_out = (void (*) (ClutterActor*)) gala_window_switcher_real_key_focus_out;
	((ClutterActorClass *) klass)->key_release_event = (gboolean (*) (ClutterActor*, ClutterKeyEvent*)) gala_window_switcher_real_key_release_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_window_switcher_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_window_switcher_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_window_switcher_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_window_switcher_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_SWITCHER_OPENED_PROPERTY, gala_window_switcher_properties[GALA_WINDOW_SWITCHER_OPENED_PROPERTY] = g_param_spec_boolean ("opened", "opened", "opened", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_SWITCHER_WM_PROPERTY, gala_window_switcher_properties[GALA_WINDOW_SWITCHER_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
gala_window_switcher_instance_init (GalaWindowSwitcher * self,
                                    gpointer klass)
{
	self->priv = gala_window_switcher_get_instance_private (self);
	self->priv->_opened = FALSE;
	self->priv->modal_proxy = NULL;
	self->priv->cur_icon = NULL;
	self->priv->scaling_factor = 1;
	self->priv->caption_height = -1.0f;
}

static void
gala_window_switcher_finalize (GObject * obj)
{
	GalaWindowSwitcher * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_SWITCHER, GalaWindowSwitcher);
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->modal_proxy);
	_g_object_unref0 (self->priv->granite_settings);
	_g_object_unref0 (self->priv->canvas);
	_g_object_unref0 (self->priv->container);
	_g_object_unref0 (self->priv->indicator);
	_g_object_unref0 (self->priv->caption);
	_g_object_unref0 (self->priv->cur_icon);
	G_OBJECT_CLASS (gala_window_switcher_parent_class)->finalize (obj);
}

static GType
gala_window_switcher_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWindowSwitcherClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_window_switcher_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaWindowSwitcher), 0, (GInstanceInitFunc) gala_window_switcher_instance_init, NULL };
	GType gala_window_switcher_type_id;
	gala_window_switcher_type_id = g_type_register_static (clutter_actor_get_type (), "GalaWindowSwitcher", &g_define_type_info, 0);
	GalaWindowSwitcher_private_offset = g_type_add_instance_private (gala_window_switcher_type_id, sizeof (GalaWindowSwitcherPrivate));
	return gala_window_switcher_type_id;
}

GType
gala_window_switcher_get_type (void)
{
	static volatile gsize gala_window_switcher_type_id__once = 0;
	if (g_once_init_enter (&gala_window_switcher_type_id__once)) {
		GType gala_window_switcher_type_id;
		gala_window_switcher_type_id = gala_window_switcher_get_type_once ();
		g_once_init_leave (&gala_window_switcher_type_id__once, gala_window_switcher_type_id);
	}
	return gala_window_switcher_type_id__once;
}

static void
_vala_gala_window_switcher_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	GalaWindowSwitcher * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_SWITCHER, GalaWindowSwitcher);
	switch (property_id) {
		case GALA_WINDOW_SWITCHER_OPENED_PROPERTY:
		g_value_set_boolean (value, gala_window_switcher_get_opened (self));
		break;
		case GALA_WINDOW_SWITCHER_WM_PROPERTY:
		g_value_set_object (value, gala_window_switcher_get_wm (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_window_switcher_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	GalaWindowSwitcher * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_SWITCHER, GalaWindowSwitcher);
	switch (property_id) {
		case GALA_WINDOW_SWITCHER_OPENED_PROPERTY:
		gala_window_switcher_set_opened (self, g_value_get_boolean (value));
		break;
		case GALA_WINDOW_SWITCHER_WM_PROPERTY:
		gala_window_switcher_set_wm (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

