/* WorkspaceClone.c generated by valac 0.56.0, the Vala compiler
 * generated from WorkspaceClone.vala, do not modify */

/**/
/*  Copyright (C) 2014 Tom Beckmann*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <meta/meta-background-group.h>
#include <glib-object.h>
#include <cogl/cogl.h>
#include <clutter/clutter.h>
#include <meta/display.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <meta/boxes.h>
#include <stdlib.h>
#include <string.h>
#include <meta/workspace.h>
#include <meta/window.h>
#include <meta/meta-workspace-manager.h>
#include "gala.h"

#define GALA_WORKSPACE_CLONE_BOTTOM_OFFSET 100
#define GALA_WORKSPACE_CLONE_TOP_OFFSET 20
#define GALA_WORKSPACE_CLONE_HOVER_ACTIVATE_DELAY 400
#define GALA_WORKSPACE_CLONE_X_OFFSET 150
#define GALA_WINDOW_MANAGER_GALA_WORKSPACE_GAP 24
#define GALA_MULTITASKING_VIEW_ANIMATION_DURATION 250
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_BACKGROUND_MANAGER (gala_background_manager_get_type ())
#define GALA_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManager))
#define GALA_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManagerClass))
#define GALA_IS_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND_MANAGER))
#define GALA_IS_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND_MANAGER))
#define GALA_BACKGROUND_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManagerClass))

typedef struct _GalaBackgroundManager GalaBackgroundManager;
typedef struct _GalaBackgroundManagerClass GalaBackgroundManagerClass;
typedef struct _GalaBackgroundManagerPrivate GalaBackgroundManagerPrivate;

#define GALA_TYPE_FRAMED_BACKGROUND (gala_framed_background_get_type ())
#define GALA_FRAMED_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_FRAMED_BACKGROUND, GalaFramedBackground))
#define GALA_FRAMED_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_FRAMED_BACKGROUND, GalaFramedBackgroundClass))
#define GALA_IS_FRAMED_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_FRAMED_BACKGROUND))
#define GALA_IS_FRAMED_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_FRAMED_BACKGROUND))
#define GALA_FRAMED_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_FRAMED_BACKGROUND, GalaFramedBackgroundClass))

typedef struct _GalaFramedBackground GalaFramedBackground;
typedef struct _GalaFramedBackgroundClass GalaFramedBackgroundClass;
typedef struct _GalaFramedBackgroundPrivate GalaFramedBackgroundPrivate;
enum  {
	GALA_FRAMED_BACKGROUND_0_PROPERTY,
	GALA_FRAMED_BACKGROUND_NUM_PROPERTIES
};
static GParamSpec* gala_framed_background_properties[GALA_FRAMED_BACKGROUND_NUM_PROPERTIES];
#define _cogl_object_unref0(var) ((var == NULL) ? NULL : (var = (cogl_object_unref (var), NULL)))

#define GALA_TYPE_SHADOW_EFFECT (gala_shadow_effect_get_type ())
#define GALA_SHADOW_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_SHADOW_EFFECT, GalaShadowEffect))
#define GALA_SHADOW_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_SHADOW_EFFECT, GalaShadowEffectClass))
#define GALA_IS_SHADOW_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_SHADOW_EFFECT))
#define GALA_IS_SHADOW_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_SHADOW_EFFECT))
#define GALA_SHADOW_EFFECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_SHADOW_EFFECT, GalaShadowEffectClass))

typedef struct _GalaShadowEffect GalaShadowEffect;
typedef struct _GalaShadowEffectClass GalaShadowEffectClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GALA_TYPE_WORKSPACE_CLONE (gala_workspace_clone_get_type ())
#define GALA_WORKSPACE_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone))
#define GALA_WORKSPACE_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceCloneClass))
#define GALA_IS_WORKSPACE_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WORKSPACE_CLONE))
#define GALA_IS_WORKSPACE_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WORKSPACE_CLONE))
#define GALA_WORKSPACE_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceCloneClass))

typedef struct _GalaWorkspaceClone GalaWorkspaceClone;
typedef struct _GalaWorkspaceCloneClass GalaWorkspaceCloneClass;
typedef struct _GalaWorkspaceClonePrivate GalaWorkspaceClonePrivate;

#define GALA_TYPE_GESTURE_TRACKER (gala_gesture_tracker_get_type ())
#define GALA_GESTURE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE_TRACKER, GalaGestureTracker))
#define GALA_GESTURE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_GESTURE_TRACKER, GalaGestureTrackerClass))
#define GALA_IS_GESTURE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE_TRACKER))
#define GALA_IS_GESTURE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_GESTURE_TRACKER))
#define GALA_GESTURE_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_GESTURE_TRACKER, GalaGestureTrackerClass))

typedef struct _GalaGestureTracker GalaGestureTracker;
typedef struct _GalaGestureTrackerClass GalaGestureTrackerClass;

#define GALA_TYPE_ICON_GROUP (gala_icon_group_get_type ())
#define GALA_ICON_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ICON_GROUP, GalaIconGroup))
#define GALA_ICON_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_ICON_GROUP, GalaIconGroupClass))
#define GALA_IS_ICON_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ICON_GROUP))
#define GALA_IS_ICON_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_ICON_GROUP))
#define GALA_ICON_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_ICON_GROUP, GalaIconGroupClass))

typedef struct _GalaIconGroup GalaIconGroup;
typedef struct _GalaIconGroupClass GalaIconGroupClass;

#define GALA_TYPE_WINDOW_CLONE_CONTAINER (gala_window_clone_container_get_type ())
#define GALA_WINDOW_CLONE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer))
#define GALA_WINDOW_CLONE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainerClass))
#define GALA_IS_WINDOW_CLONE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER))
#define GALA_IS_WINDOW_CLONE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_CLONE_CONTAINER))
#define GALA_WINDOW_CLONE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainerClass))

typedef struct _GalaWindowCloneContainer GalaWindowCloneContainer;
typedef struct _GalaWindowCloneContainerClass GalaWindowCloneContainerClass;
enum  {
	GALA_WORKSPACE_CLONE_0_PROPERTY,
	GALA_WORKSPACE_CLONE_WORKSPACE_PROPERTY,
	GALA_WORKSPACE_CLONE_GESTURE_TRACKER_PROPERTY,
	GALA_WORKSPACE_CLONE_ICON_GROUP_PROPERTY,
	GALA_WORKSPACE_CLONE_WINDOW_CONTAINER_PROPERTY,
	GALA_WORKSPACE_CLONE_ACTIVE_PROPERTY,
	GALA_WORKSPACE_CLONE_NUM_PROPERTIES
};
static GParamSpec* gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_NUM_PROPERTIES];

#define GALA_TYPE_WINDOW_LISTENER (gala_window_listener_get_type ())
#define GALA_WINDOW_LISTENER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_LISTENER, GalaWindowListener))
#define GALA_WINDOW_LISTENER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_LISTENER, GalaWindowListenerClass))
#define GALA_IS_WINDOW_LISTENER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_LISTENER))
#define GALA_IS_WINDOW_LISTENER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_LISTENER))
#define GALA_WINDOW_LISTENER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_LISTENER, GalaWindowListenerClass))

typedef struct _GalaWindowListener GalaWindowListener;
typedef struct _GalaWindowListenerClass GalaWindowListenerClass;

#define GALA_TYPE_WINDOW_CLONE (gala_window_clone_get_type ())
#define GALA_WINDOW_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_CLONE, GalaWindowClone))
#define GALA_WINDOW_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_CLONE, GalaWindowCloneClass))
#define GALA_IS_WINDOW_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_CLONE))
#define GALA_IS_WINDOW_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_CLONE))
#define GALA_WINDOW_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_CLONE, GalaWindowCloneClass))

typedef struct _GalaWindowClone GalaWindowClone;
typedef struct _GalaWindowCloneClass GalaWindowCloneClass;
typedef struct _Block69Data Block69Data;
typedef void (*GalaGestureTrackerOnBegin) (gdouble percentage, gpointer user_data);
typedef void (*GalaGestureTrackerOnUpdate) (gdouble percentage, gpointer user_data);
typedef void (*GalaGestureTrackerOnEnd) (gdouble percentage, gboolean cancel_action, gint calculated_duration, gpointer user_data);
typedef struct _Block70Data Block70Data;
enum  {
	GALA_WORKSPACE_CLONE_WINDOW_SELECTED_SIGNAL,
	GALA_WORKSPACE_CLONE_SELECTED_SIGNAL,
	GALA_WORKSPACE_CLONE_NUM_SIGNALS
};
static guint gala_workspace_clone_signals[GALA_WORKSPACE_CLONE_NUM_SIGNALS] = {0};

struct _GalaBackgroundManager {
	MetaBackgroundGroup parent_instance;
	GalaBackgroundManagerPrivate * priv;
};

struct _GalaBackgroundManagerClass {
	MetaBackgroundGroupClass parent_class;
};

struct _GalaFramedBackground {
	GalaBackgroundManager parent_instance;
	GalaFramedBackgroundPrivate * priv;
};

struct _GalaFramedBackgroundClass {
	GalaBackgroundManagerClass parent_class;
};

struct _GalaFramedBackgroundPrivate {
	CoglPipeline* pipeline;
};

struct _GalaWorkspaceClone {
	ClutterActor parent_instance;
	GalaWorkspaceClonePrivate * priv;
};

struct _GalaWorkspaceCloneClass {
	ClutterActorClass parent_class;
};

struct _GalaWorkspaceClonePrivate {
	MetaWorkspace* _workspace;
	GalaGestureTracker* _gesture_tracker;
	GalaIconGroup* _icon_group;
	GalaWindowCloneContainer* _window_container;
	gboolean _active;
	GalaBackgroundManager* background;
	gboolean opened;
	guint hover_activate_timeout;
};

struct _Block69Data {
	int _ref_count_;
	GalaWorkspaceClone* self;
	gfloat initial_x;
	gfloat target_x;
	gfloat scale;
	gfloat pivot_y;
};

struct _Block70Data {
	int _ref_count_;
	GalaWorkspaceClone* self;
	gfloat initial_x;
	gfloat target_x;
	gdouble initial_scale_x;
	gdouble initial_scale_y;
};

static gint GalaFramedBackground_private_offset;
static gpointer gala_framed_background_parent_class = NULL;
static gint GalaWorkspaceClone_private_offset;
static gpointer gala_workspace_clone_parent_class = NULL;

VALA_EXTERN GType gala_background_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackgroundManager, g_object_unref)
 G_GNUC_INTERNAL GType gala_framed_background_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaFramedBackground, g_object_unref)
 G_GNUC_INTERNAL GalaFramedBackground* gala_framed_background_new (MetaDisplay* display);
 G_GNUC_INTERNAL GalaFramedBackground* gala_framed_background_construct (GType object_type,
                                                        MetaDisplay* display);
static void gala_framed_background_real_paint (ClutterActor* base,
                                        ClutterPaintContext* context);
static GObject * gala_framed_background_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
VALA_EXTERN MetaDisplay* gala_background_manager_get_display (GalaBackgroundManager* self);
VALA_EXTERN GType gala_shadow_effect_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaShadowEffect, g_object_unref)
VALA_EXTERN GalaShadowEffect* gala_shadow_effect_new (gint shadow_size,
                                          gint shadow_spread);
VALA_EXTERN GalaShadowEffect* gala_shadow_effect_construct (GType object_type,
                                                gint shadow_size,
                                                gint shadow_spread);
VALA_EXTERN void gala_shadow_effect_set_css_class (GalaShadowEffect* self,
                                       const gchar* value);
static void gala_framed_background_finalize (GObject * obj);
static GType gala_framed_background_get_type_once (void);
VALA_EXTERN GType gala_workspace_clone_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWorkspaceClone, g_object_unref)
VALA_EXTERN GType gala_gesture_tracker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGestureTracker, g_object_unref)
VALA_EXTERN GType gala_icon_group_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaIconGroup, g_object_unref)
VALA_EXTERN GType gala_window_clone_container_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowCloneContainer, g_object_unref)
VALA_EXTERN MetaWorkspace* gala_workspace_clone_get_workspace (GalaWorkspaceClone* self);
VALA_EXTERN GalaWindowCloneContainer* gala_workspace_clone_get_window_container (GalaWorkspaceClone* self);
VALA_EXTERN void gala_window_clone_container_restack_windows (GalaWindowCloneContainer* self,
                                                  MetaDisplay* display);
static void _gala_window_clone_container_restack_windows_meta_display_restacked (MetaDisplay* _sender,
                                                                          gpointer self);
static void gala_workspace_clone_window_entered_monitor (GalaWorkspaceClone* self,
                                                  MetaDisplay* display,
                                                  gint monitor,
                                                  MetaWindow* window);
static void _gala_workspace_clone_window_entered_monitor_meta_display_window_entered_monitor (MetaDisplay* _sender,
                                                                                       gint object,
                                                                                       MetaWindow* p0,
                                                                                       gpointer self);
static void gala_workspace_clone_window_left_monitor (GalaWorkspaceClone* self,
                                               MetaDisplay* display,
                                               gint monitor,
                                               MetaWindow* window);
static void _gala_workspace_clone_window_left_monitor_meta_display_window_left_monitor (MetaDisplay* _sender,
                                                                                 gint object,
                                                                                 MetaWindow* p0,
                                                                                 gpointer self);
static void gala_workspace_clone_add_window (GalaWorkspaceClone* self,
                                      MetaWindow* window);
static void _gala_workspace_clone_add_window_meta_workspace_window_added (MetaWorkspace* _sender,
                                                                   MetaWindow* object,
                                                                   gpointer self);
static void gala_workspace_clone_remove_window (GalaWorkspaceClone* self,
                                         MetaWindow* window);
static void _gala_workspace_clone_remove_window_meta_workspace_window_removed (MetaWorkspace* _sender,
                                                                        MetaWindow* object,
                                                                        gpointer self);
VALA_EXTERN GType gala_window_listener_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowListener, g_object_unref)
VALA_EXTERN GalaWindowListener* gala_window_listener_get_default (void);
static void _gala_workspace_clone_add_window_gala_window_listener_window_no_longer_on_all_workspaces (GalaWindowListener* _sender,
                                                                                               MetaWindow* window,
                                                                                               gpointer self);
VALA_EXTERN GalaWorkspaceClone* gala_workspace_clone_new (MetaWorkspace* workspace,
                                              GalaGestureTracker* gesture_tracker);
VALA_EXTERN GalaWorkspaceClone* gala_workspace_clone_construct (GType object_type,
                                                    MetaWorkspace* workspace,
                                                    GalaGestureTracker* gesture_tracker);
VALA_EXTERN GType gala_window_clone_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowClone, g_object_unref)
VALA_EXTERN MetaWindow* gala_window_clone_get_window (GalaWindowClone* self);
VALA_EXTERN void gala_window_clone_container_add_window (GalaWindowCloneContainer* self,
                                             MetaWindow* window);
VALA_EXTERN GalaIconGroup* gala_workspace_clone_get_icon_group (GalaWorkspaceClone* self);
VALA_EXTERN void gala_icon_group_add_window (GalaIconGroup* self,
                                 MetaWindow* window,
                                 gboolean no_redraw,
                                 gboolean temporary);
VALA_EXTERN void gala_window_clone_container_remove_window (GalaWindowCloneContainer* self,
                                                MetaWindow* window);
VALA_EXTERN void gala_icon_group_remove_window (GalaIconGroup* self,
                                    MetaWindow* window,
                                    gboolean animate);
static void gala_workspace_clone_update_size (GalaWorkspaceClone* self,
                                       MetaRectangle* monitor_geometry);
VALA_EXTERN void gala_background_manager_set_size (GalaBackgroundManager* self,
                                       gfloat width,
                                       gfloat height);
VALA_EXTERN gfloat gala_workspace_clone_multitasking_view_x (GalaWorkspaceClone* self);
VALA_EXTERN gint gala_internal_utils_get_ui_scaling_factor (void);
static gfloat gala_workspace_clone_current_x_overlap (GalaWorkspaceClone* self);
static inline void gala_workspace_clone_shrink_rectangle (MetaRectangle* rect,
                                            gint amount);
VALA_EXTERN void gala_workspace_clone_open (GalaWorkspaceClone* self,
                                gboolean with_gesture,
                                gboolean is_cancel_animation);
static Block69Data* block69_data_ref (Block69Data* _data69_);
static void block69_data_unref (void * _userdata_);
static void __lambda106_ (Block69Data* _data69_);
static void ___lambda106__gala_gesture_tracker_on_begin (gdouble percentage,
                                                  gpointer self);
static void __lambda107_ (Block69Data* _data69_,
                   gdouble percentage);
VALA_EXTERN gfloat gala_gesture_tracker_animation_value (gfloat initial_value,
                                             gfloat target_value,
                                             gdouble percentage,
                                             gboolean rounded);
static void ___lambda107__gala_gesture_tracker_on_update (gdouble percentage,
                                                   gpointer self);
static void __lambda108_ (Block69Data* _data69_,
                   gdouble percentage,
                   gboolean cancel_action);
static void ___lambda108__gala_gesture_tracker_on_end (gdouble percentage,
                                                gboolean cancel_action,
                                                gint calculated_duration,
                                                gpointer self);
VALA_EXTERN GalaGestureTracker* gala_workspace_clone_get_gesture_tracker (GalaWorkspaceClone* self);
VALA_EXTERN void gala_gesture_tracker_connect_handlers (GalaGestureTracker* self,
                                            GalaGestureTrackerOnBegin on_begin_handler,
                                            gpointer on_begin_handler_target,
                                            GDestroyNotify on_begin_handler_target_destroy_notify,
                                            GalaGestureTrackerOnUpdate on_update_handler,
                                            gpointer on_update_handler_target,
                                            GDestroyNotify on_update_handler_target_destroy_notify,
                                            GalaGestureTrackerOnEnd on_end_handler,
                                            gpointer on_end_handler_target,
                                            GDestroyNotify on_end_handler_target_destroy_notify);
VALA_EXTERN void gala_window_clone_container_set_padding_top (GalaWindowCloneContainer* self,
                                                  gint value);
VALA_EXTERN void gala_window_clone_container_set_padding_right (GalaWindowCloneContainer* self,
                                                    gint value);
VALA_EXTERN void gala_window_clone_container_set_padding_left (GalaWindowCloneContainer* self,
                                                   gint value);
VALA_EXTERN void gala_window_clone_container_set_padding_bottom (GalaWindowCloneContainer* self,
                                                     gint value);
VALA_EXTERN void gala_icon_group_redraw (GalaIconGroup* self);
VALA_EXTERN void gala_window_clone_container_open (GalaWindowCloneContainer* self,
                                       MetaWindow* selected_window,
                                       gboolean with_gesture,
                                       gboolean is_cancel_animation);
VALA_EXTERN void gala_workspace_clone_close (GalaWorkspaceClone* self,
                                 gboolean with_gesture,
                                 gboolean is_cancel_animation);
static Block70Data* block70_data_ref (Block70Data* _data70_);
static void block70_data_unref (void * _userdata_);
static void __lambda109_ (Block70Data* _data70_,
                   gdouble percentage);
static void ___lambda109__gala_gesture_tracker_on_update (gdouble percentage,
                                                   gpointer self);
static void __lambda110_ (Block70Data* _data70_,
                   gdouble percentage,
                   gboolean cancel_action);
static void ___lambda110__gala_gesture_tracker_on_end (gdouble percentage,
                                                gboolean cancel_action,
                                                gint calculated_duration,
                                                gpointer self);
VALA_EXTERN void gala_window_clone_container_close (GalaWindowCloneContainer* self,
                                        gboolean with_gesture,
                                        gboolean is_cancel_animation);
static void gala_workspace_clone_set_workspace (GalaWorkspaceClone* self,
                                         MetaWorkspace* value);
static void gala_workspace_clone_set_gesture_tracker (GalaWorkspaceClone* self,
                                               GalaGestureTracker* value);
static void gala_workspace_clone_set_icon_group (GalaWorkspaceClone* self,
                                          GalaIconGroup* value);
static void gala_workspace_clone_set_window_container (GalaWorkspaceClone* self,
                                                GalaWindowCloneContainer* value);
VALA_EXTERN gboolean gala_workspace_clone_get_active (GalaWorkspaceClone* self);
VALA_EXTERN void gala_workspace_clone_set_active (GalaWorkspaceClone* self,
                                      gboolean value);
VALA_EXTERN void gala_icon_group_set_active (GalaIconGroup* self,
                                 gboolean value);
static GObject * gala_workspace_clone_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static gboolean _gala_workspace_clone___lambda111_ (GalaWorkspaceClone* self);
static gboolean __gala_workspace_clone___lambda111__clutter_actor_button_press_event (ClutterActor* _sender,
                                                                               ClutterButtonEvent* event,
                                                                               gpointer self);
VALA_EXTERN GalaWindowCloneContainer* gala_window_clone_container_new (GalaGestureTracker* gesture_tracker,
                                                           gboolean overview_mode);
VALA_EXTERN GalaWindowCloneContainer* gala_window_clone_container_construct (GType object_type,
                                                                 GalaGestureTracker* gesture_tracker,
                                                                 gboolean overview_mode);
static void _gala_workspace_clone___lambda112_ (GalaWorkspaceClone* self,
                                         MetaWindow* w);
static void __gala_workspace_clone___lambda112__gala_window_clone_container_window_selected (GalaWindowCloneContainer* _sender,
                                                                                      MetaWindow* window,
                                                                                      gpointer self);
VALA_EXTERN GalaIconGroup* gala_icon_group_new (MetaWorkspace* workspace);
VALA_EXTERN GalaIconGroup* gala_icon_group_construct (GType object_type,
                                          MetaWorkspace* workspace);
static void _gala_workspace_clone___lambda113_ (GalaWorkspaceClone* self);
static void __gala_workspace_clone___lambda113__gala_icon_group_selected (GalaIconGroup* _sender,
                                                                   gpointer self);
static void _gala_workspace_clone___lambda114_ (GalaWorkspaceClone* self,
                                         ClutterActor* target,
                                         gboolean hovered);
static gboolean ___lambda115_ (GalaWorkspaceClone* self);
static gboolean ____lambda115__gsource_func (gpointer self);
static void __gala_workspace_clone___lambda114__gala_drag_drop_action_crossed (GalaDragDropAction* _sender,
                                                                        ClutterActor* target,
                                                                        gboolean hovered,
                                                                        gpointer self);
static void gala_workspace_clone_finalize (GObject * obj);
static GType gala_workspace_clone_get_type_once (void);
static void _vala_gala_workspace_clone_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_gala_workspace_clone_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gala_framed_background_get_instance_private (GalaFramedBackground* self)
{
	return G_STRUCT_MEMBER_P (self, GalaFramedBackground_private_offset);
}

 G_GNUC_INTERNAL GalaFramedBackground*
gala_framed_background_construct (GType object_type,
                                  MetaDisplay* display)
{
	GalaFramedBackground * self = NULL;
	g_return_val_if_fail (display != NULL, NULL);
	self = (GalaFramedBackground*) g_object_new (object_type, "display", display, "monitor-index", meta_display_get_primary_monitor (display), "control-position", FALSE, NULL);
	return self;
}

 G_GNUC_INTERNAL GalaFramedBackground*
gala_framed_background_new (MetaDisplay* display)
{
	return gala_framed_background_construct (GALA_TYPE_FRAMED_BACKGROUND, display);
}

static void
gala_framed_background_real_paint (ClutterActor* base,
                                   ClutterPaintContext* context)
{
	GalaFramedBackground * self;
	CoglFramebuffer* fb = NULL;
	CoglFramebuffer* _tmp0_;
	CoglPipeline* _tmp1_;
	gfloat _tmp2_;
	gfloat _tmp3_;
	gfloat _tmp4_;
	gfloat _tmp5_;
	CoglPipeline* _tmp6_;
	gfloat _tmp7_;
	gfloat _tmp8_;
	gfloat _tmp9_;
	gfloat _tmp10_;
	CoglColor color = {0};
	CoglPipeline* _tmp11_;
	CoglColor _tmp12_;
	gfloat _tmp13_;
	gfloat _tmp14_;
	gfloat _tmp15_;
	gfloat _tmp16_;
	CoglPipeline* _tmp17_;
	gfloat _tmp18_;
	gfloat _tmp19_;
	gfloat _tmp20_;
	gfloat _tmp21_;
	self = (GalaFramedBackground*) base;
	g_return_if_fail (context != NULL);
	CLUTTER_ACTOR_CLASS (gala_framed_background_parent_class)->paint ((ClutterActor*) G_TYPE_CHECK_INSTANCE_CAST (self, GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManager), context);
	_tmp0_ = clutter_paint_context_get_framebuffer (context);
	fb = _tmp0_;
	_tmp1_ = self->priv->pipeline;
	cogl_pipeline_set_color4ub (_tmp1_, (guint8) 0, (guint8) 0, (guint8) 0, (guint8) 100);
	_tmp2_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp5_ = _tmp4_;
	cogl_framebuffer_push_rectangle_clip (fb, (gfloat) 0, (gfloat) 0, _tmp3_, _tmp5_);
	_tmp6_ = self->priv->pipeline;
	_tmp7_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp10_ = _tmp9_;
	cogl_framebuffer_draw_rectangle (fb, _tmp6_, (gfloat) 0, (gfloat) 0, _tmp8_, _tmp10_);
	cogl_framebuffer_pop_clip (fb);
	cogl_color_init_from_4ub (&color, (guint8) 255, (guint8) 255, (guint8) 255, (guint8) 25);
	cogl_color_premultiply (&color);
	_tmp11_ = self->priv->pipeline;
	_tmp12_ = color;
	cogl_pipeline_set_color (_tmp11_, &_tmp12_);
	_tmp13_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp14_ = _tmp13_;
	_tmp15_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp16_ = _tmp15_;
	cogl_framebuffer_push_rectangle_clip (fb, 0.5f, 0.5f, _tmp14_ - 1, _tmp16_ - 1);
	_tmp17_ = self->priv->pipeline;
	_tmp18_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp19_ = _tmp18_;
	_tmp20_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp21_ = _tmp20_;
	cogl_framebuffer_draw_rectangle (fb, _tmp17_, 0.5f, 0.5f, _tmp19_ - 1, _tmp21_ - 1);
	cogl_framebuffer_pop_clip (fb);
}

static GObject *
gala_framed_background_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaFramedBackground * self;
	ClutterBackend* _tmp0_;
	CoglContext* _tmp1_;
	CoglPipeline* _tmp2_;
	gint primary = 0;
	MetaDisplay* _tmp3_;
	MetaDisplay* _tmp4_;
	MetaRectangle monitor_geom = {0};
	MetaDisplay* _tmp5_;
	MetaDisplay* _tmp6_;
	MetaRectangle _tmp7_ = {0};
	GalaShadowEffect* effect = NULL;
	gchar* _tmp8_;
	GalaShadowEffect* _tmp9_ = NULL;
	GalaShadowEffect* _tmp10_;
	parent_class = G_OBJECT_CLASS (gala_framed_background_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_FRAMED_BACKGROUND, GalaFramedBackground);
	_tmp0_ = clutter_get_default_backend ();
	_tmp1_ = clutter_backend_get_cogl_context (_tmp0_);
	_tmp2_ = cogl_pipeline_new (_tmp1_);
	_cogl_object_unref0 (self->priv->pipeline);
	self->priv->pipeline = _tmp2_;
	_tmp3_ = gala_background_manager_get_display ((GalaBackgroundManager*) self);
	_tmp4_ = _tmp3_;
	primary = meta_display_get_primary_monitor (_tmp4_);
	_tmp5_ = gala_background_manager_get_display ((GalaBackgroundManager*) self);
	_tmp6_ = _tmp5_;
	meta_display_get_monitor_geometry (_tmp6_, primary, &_tmp7_);
	monitor_geom = _tmp7_;
	_tmp8_ = g_strdup ("workspace");
	_tmp9_ = gala_shadow_effect_new (40, 5);
	gala_shadow_effect_set_css_class (_tmp9_, _tmp8_);
	_g_free0 (_tmp8_);
	g_object_ref_sink (_tmp9_);
	effect = _tmp9_;
	_tmp10_ = effect;
	clutter_actor_add_effect ((ClutterActor*) self, (ClutterEffect*) _tmp10_);
	_g_object_unref0 (effect);
	return obj;
}

static void
gala_framed_background_class_init (GalaFramedBackgroundClass * klass,
                                   gpointer klass_data)
{
	gala_framed_background_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaFramedBackground_private_offset);
	((ClutterActorClass *) klass)->paint = (void (*) (ClutterActor*, ClutterPaintContext*)) gala_framed_background_real_paint;
	G_OBJECT_CLASS (klass)->constructor = gala_framed_background_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_framed_background_finalize;
}

static void
gala_framed_background_instance_init (GalaFramedBackground * self,
                                      gpointer klass)
{
	self->priv = gala_framed_background_get_instance_private (self);
}

static void
gala_framed_background_finalize (GObject * obj)
{
	GalaFramedBackground * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_FRAMED_BACKGROUND, GalaFramedBackground);
	_cogl_object_unref0 (self->priv->pipeline);
	G_OBJECT_CLASS (gala_framed_background_parent_class)->finalize (obj);
}

/**
     * Utility class which adds a border and a shadow to a Background
     */
static GType
gala_framed_background_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaFramedBackgroundClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_framed_background_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaFramedBackground), 0, (GInstanceInitFunc) gala_framed_background_instance_init, NULL };
	GType gala_framed_background_type_id;
	gala_framed_background_type_id = g_type_register_static (GALA_TYPE_BACKGROUND_MANAGER, "GalaFramedBackground", &g_define_type_info, 0);
	GalaFramedBackground_private_offset = g_type_add_instance_private (gala_framed_background_type_id, sizeof (GalaFramedBackgroundPrivate));
	return gala_framed_background_type_id;
}

 G_GNUC_INTERNAL GType
gala_framed_background_get_type (void)
{
	static volatile gsize gala_framed_background_type_id__once = 0;
	if (g_once_init_enter (&gala_framed_background_type_id__once)) {
		GType gala_framed_background_type_id;
		gala_framed_background_type_id = gala_framed_background_get_type_once ();
		g_once_init_leave (&gala_framed_background_type_id__once, gala_framed_background_type_id);
	}
	return gala_framed_background_type_id__once;
}

static inline gpointer
gala_workspace_clone_get_instance_private (GalaWorkspaceClone* self)
{
	return G_STRUCT_MEMBER_P (self, GalaWorkspaceClone_private_offset);
}

static void
_gala_window_clone_container_restack_windows_meta_display_restacked (MetaDisplay* _sender,
                                                                     gpointer self)
{
	gala_window_clone_container_restack_windows ((GalaWindowCloneContainer*) self, _sender);
}

static void
_gala_workspace_clone_window_entered_monitor_meta_display_window_entered_monitor (MetaDisplay* _sender,
                                                                                  gint object,
                                                                                  MetaWindow* p0,
                                                                                  gpointer self)
{
	gala_workspace_clone_window_entered_monitor ((GalaWorkspaceClone*) self, _sender, object, p0);
}

static void
_gala_workspace_clone_window_left_monitor_meta_display_window_left_monitor (MetaDisplay* _sender,
                                                                            gint object,
                                                                            MetaWindow* p0,
                                                                            gpointer self)
{
	gala_workspace_clone_window_left_monitor ((GalaWorkspaceClone*) self, _sender, object, p0);
}

static void
_gala_workspace_clone_add_window_meta_workspace_window_added (MetaWorkspace* _sender,
                                                              MetaWindow* object,
                                                              gpointer self)
{
	gala_workspace_clone_add_window ((GalaWorkspaceClone*) self, object);
}

static void
_gala_workspace_clone_remove_window_meta_workspace_window_removed (MetaWorkspace* _sender,
                                                                   MetaWindow* object,
                                                                   gpointer self)
{
	gala_workspace_clone_remove_window ((GalaWorkspaceClone*) self, object);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_gala_workspace_clone_add_window_gala_window_listener_window_no_longer_on_all_workspaces (GalaWindowListener* _sender,
                                                                                          MetaWindow* window,
                                                                                          gpointer self)
{
	gala_workspace_clone_add_window ((GalaWorkspaceClone*) self, window);
}

GalaWorkspaceClone*
gala_workspace_clone_construct (GType object_type,
                                MetaWorkspace* workspace,
                                GalaGestureTracker* gesture_tracker)
{
	GalaWorkspaceClone * self = NULL;
	g_return_val_if_fail (workspace != NULL, NULL);
	g_return_val_if_fail (gesture_tracker != NULL, NULL);
	self = (GalaWorkspaceClone*) g_object_new (object_type, "workspace", workspace, "gesture-tracker", gesture_tracker, NULL);
	return self;
}

GalaWorkspaceClone*
gala_workspace_clone_new (MetaWorkspace* workspace,
                          GalaGestureTracker* gesture_tracker)
{
	return gala_workspace_clone_construct (GALA_TYPE_WORKSPACE_CLONE, workspace, gesture_tracker);
}

/**
         * Add a window to the WindowCloneContainer and the IconGroup if it really
         * belongs to this workspace and this monitor.
         */
static void
gala_workspace_clone_add_window (GalaWorkspaceClone* self,
                                 MetaWindow* window)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	MetaWindowType _tmp3_;
	MetaWindowType _tmp4_;
	GalaWindowCloneContainer* _tmp10_;
	GList* _tmp11_;
	GalaWindowCloneContainer* _tmp15_;
	GalaIconGroup* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp3_ = meta_window_get_window_type (window);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != META_WINDOW_NORMAL) {
		_tmp2_ = TRUE;
	} else {
		MetaWorkspace* _tmp5_;
		MetaWorkspace* _tmp6_;
		_tmp5_ = meta_window_get_workspace (window);
		_tmp6_ = self->priv->_workspace;
		_tmp2_ = _tmp5_ != _tmp6_;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp7_;
		gboolean _tmp8_;
		g_object_get (window, "on-all-workspaces", &_tmp7_, NULL);
		_tmp8_ = _tmp7_;
		_tmp1_ = _tmp8_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		MetaDisplay* _tmp9_;
		_tmp9_ = meta_window_get_display (window);
		_tmp0_ = meta_window_get_monitor (window) != meta_display_get_primary_monitor (_tmp9_);
	}
	if (_tmp0_) {
		return;
	}
	_tmp10_ = self->priv->_window_container;
	_tmp11_ = clutter_actor_get_children ((ClutterActor*) _tmp10_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp11_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				ClutterActor* _tmp12_;
				MetaWindow* _tmp13_;
				MetaWindow* _tmp14_;
				_tmp12_ = child;
				_tmp13_ = gala_window_clone_get_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone));
				_tmp14_ = _tmp13_;
				if (_tmp14_ == window) {
					(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
					return;
				}
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	_tmp15_ = self->priv->_window_container;
	gala_window_clone_container_add_window (_tmp15_, window);
	_tmp16_ = self->priv->_icon_group;
	gala_icon_group_add_window (_tmp16_, window, FALSE, FALSE);
}

/**
         * Remove a window from the WindowCloneContainer and the IconGroup
         */
static void
gala_workspace_clone_remove_window (GalaWorkspaceClone* self,
                                    MetaWindow* window)
{
	GalaWindowCloneContainer* _tmp0_;
	GalaIconGroup* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->_window_container;
	gala_window_clone_container_remove_window (_tmp0_, window);
	_tmp1_ = self->priv->_icon_group;
	gala_icon_group_remove_window (_tmp1_, window, self->priv->opened);
}

static void
gala_workspace_clone_window_entered_monitor (GalaWorkspaceClone* self,
                                             MetaDisplay* display,
                                             gint monitor,
                                             MetaWindow* window)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	g_return_if_fail (window != NULL);
	gala_workspace_clone_add_window (self, window);
}

static void
gala_workspace_clone_window_left_monitor (GalaWorkspaceClone* self,
                                          MetaDisplay* display,
                                          gint monitor,
                                          MetaWindow* window)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	g_return_if_fail (window != NULL);
	if (monitor == meta_display_get_primary_monitor (display)) {
		gala_workspace_clone_remove_window (self, window);
	}
}

static void
gala_workspace_clone_update_size (GalaWorkspaceClone* self,
                                  MetaRectangle* monitor_geometry)
{
	gboolean _tmp0_ = FALSE;
	GalaWindowCloneContainer* _tmp1_;
	gfloat _tmp2_;
	gfloat _tmp3_;
	MetaRectangle _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor_geometry != NULL);
	_tmp1_ = self->priv->_window_container;
	_tmp2_ = clutter_actor_get_width ((ClutterActor*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = *monitor_geometry;
	if (_tmp3_ != ((gfloat) _tmp4_.width)) {
		_tmp0_ = TRUE;
	} else {
		GalaWindowCloneContainer* _tmp5_;
		gfloat _tmp6_;
		gfloat _tmp7_;
		MetaRectangle _tmp8_;
		_tmp5_ = self->priv->_window_container;
		_tmp6_ = clutter_actor_get_height ((ClutterActor*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = *monitor_geometry;
		_tmp0_ = _tmp7_ != ((gfloat) _tmp8_.height);
	}
	if (_tmp0_) {
		GalaWindowCloneContainer* _tmp9_;
		MetaRectangle _tmp10_;
		MetaRectangle _tmp11_;
		GalaBackgroundManager* _tmp12_;
		GalaWindowCloneContainer* _tmp13_;
		gfloat _tmp14_;
		gfloat _tmp15_;
		GalaWindowCloneContainer* _tmp16_;
		gfloat _tmp17_;
		gfloat _tmp18_;
		_tmp9_ = self->priv->_window_container;
		_tmp10_ = *monitor_geometry;
		_tmp11_ = *monitor_geometry;
		clutter_actor_set_size ((ClutterActor*) _tmp9_, (gfloat) _tmp10_.width, (gfloat) _tmp11_.height);
		_tmp12_ = self->priv->background;
		_tmp13_ = self->priv->_window_container;
		_tmp14_ = clutter_actor_get_width ((ClutterActor*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = self->priv->_window_container;
		_tmp17_ = clutter_actor_get_height ((ClutterActor*) _tmp16_);
		_tmp18_ = _tmp17_;
		gala_background_manager_set_size (_tmp12_, _tmp15_, _tmp18_);
	}
}

/**
         * @return The position on the X axis of this workspace.
         */
gfloat
gala_workspace_clone_multitasking_view_x (GalaWorkspaceClone* self)
{
	gint scale_factor = 0;
	MetaWorkspace* _tmp0_;
	gfloat _tmp1_;
	gfloat _tmp2_;
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	scale_factor = gala_internal_utils_get_ui_scaling_factor ();
	_tmp0_ = self->priv->_workspace;
	_tmp1_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp2_ = _tmp1_;
	result = meta_workspace_index (_tmp0_) * (_tmp2_ - (GALA_WORKSPACE_CLONE_X_OFFSET * scale_factor));
	return result;
}

/**
         * @return The amount of pixels the workspace is overlapped in the X axis.
         */
static gfloat
gala_workspace_clone_current_x_overlap (GalaWorkspaceClone* self)
{
	gint scale_factor = 0;
	MetaDisplay* display = NULL;
	MetaWorkspace* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaDisplay* _tmp2_;
	MetaWorkspaceManager* manager = NULL;
	MetaDisplay* _tmp3_;
	MetaWorkspaceManager* _tmp4_;
	gint active_index = 0;
	MetaWorkspaceManager* _tmp5_;
	MetaWorkspace* _tmp6_;
	MetaWorkspace* _tmp7_;
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	scale_factor = gala_internal_utils_get_ui_scaling_factor ();
	_tmp0_ = self->priv->_workspace;
	_tmp1_ = meta_workspace_get_display (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	display = _tmp2_;
	_tmp3_ = display;
	_tmp4_ = meta_display_get_workspace_manager (_tmp3_);
	manager = _tmp4_;
	_tmp5_ = manager;
	_tmp6_ = meta_workspace_manager_get_active_workspace (_tmp5_);
	active_index = meta_workspace_index (_tmp6_);
	_tmp7_ = self->priv->_workspace;
	if (meta_workspace_index (_tmp7_) == active_index) {
		result = (gfloat) 0;
		_g_object_unref0 (display);
		return result;
	} else {
		gint x_offset = 0;
		gint _tmp8_ = 0;
		MetaWorkspace* _tmp9_;
		x_offset = (GALA_WORKSPACE_CLONE_X_OFFSET * scale_factor) + GALA_WINDOW_MANAGER_GALA_WORKSPACE_GAP;
		_tmp9_ = self->priv->_workspace;
		if (meta_workspace_index (_tmp9_) < active_index) {
			_tmp8_ = -x_offset;
		} else {
			_tmp8_ = x_offset;
		}
		result = (gfloat) _tmp8_;
		_g_object_unref0 (display);
		return result;
	}
}

/**
         * Utility function to shrink a MetaRectangle on all sides for the given amount.
         * Negative amounts will scale it instead.
         *
         * @param amount The amount in px to shrink.
         */
static inline void
gala_workspace_clone_shrink_rectangle (MetaRectangle* rect,
                                       gint amount)
{
	g_return_if_fail (rect != NULL);
	(*rect).x = (*rect).x + amount;
	(*rect).y = (*rect).y + amount;
	(*rect).width = (*rect).width - (amount * 2);
	(*rect).height = (*rect).height - (amount * 2);
}

/**
         * Animates the background to its scale, causes a redraw on the IconGroup and
         * makes sure the WindowCloneContainer animates its windows to their tiled layout.
         * Also sets the current_window of the WindowCloneContainer to the active window
         * if it belongs to this workspace.
         */
static Block69Data*
block69_data_ref (Block69Data* _data69_)
{
	g_atomic_int_inc (&_data69_->_ref_count_);
	return _data69_;
}

static void
block69_data_unref (void * _userdata_)
{
	Block69Data* _data69_;
	_data69_ = (Block69Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data69_->_ref_count_)) {
		GalaWorkspaceClone* self;
		self = _data69_->self;
		_g_object_unref0 (self);
		g_slice_free (Block69Data, _data69_);
	}
}

static void
__lambda106_ (Block69Data* _data69_)
{
	GalaWorkspaceClone* self;
	GalaBackgroundManager* _tmp0_;
	self = _data69_->self;
	clutter_actor_set_x ((ClutterActor*) self, _data69_->initial_x);
	_tmp0_ = self->priv->background;
	clutter_actor_set_pivot_point ((ClutterActor*) _tmp0_, 0.5f, _data69_->pivot_y);
}

static void
___lambda106__gala_gesture_tracker_on_begin (gdouble percentage,
                                             gpointer self)
{
	__lambda106_ (self);
}

static void
__lambda107_ (Block69Data* _data69_,
              gdouble percentage)
{
	GalaWorkspaceClone* self;
	gfloat x = 0.0F;
	gdouble update_scale = 0.0;
	GalaBackgroundManager* _tmp0_;
	self = _data69_->self;
	x = gala_gesture_tracker_animation_value (_data69_->initial_x, _data69_->target_x, percentage, FALSE);
	clutter_actor_set_x ((ClutterActor*) self, x);
	update_scale = (gdouble) gala_gesture_tracker_animation_value (1.0f, (gfloat) _data69_->scale, percentage, FALSE);
	_tmp0_ = self->priv->background;
	clutter_actor_set_scale ((ClutterActor*) _tmp0_, update_scale, update_scale);
}

static void
___lambda107__gala_gesture_tracker_on_update (gdouble percentage,
                                              gpointer self)
{
	__lambda107_ (self, percentage);
}

static void
__lambda108_ (Block69Data* _data69_,
              gdouble percentage,
              gboolean cancel_action)
{
	GalaWorkspaceClone* self;
	GalaBackgroundManager* _tmp0_;
	GalaBackgroundManager* _tmp1_;
	GalaBackgroundManager* _tmp2_;
	GalaBackgroundManager* _tmp3_;
	GalaBackgroundManager* _tmp4_;
	self = _data69_->self;
	if (cancel_action) {
		return;
	}
	clutter_actor_save_easing_state ((ClutterActor*) self);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) GALA_MULTITASKING_VIEW_ANIMATION_DURATION);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_QUAD);
	clutter_actor_set_x ((ClutterActor*) self, _data69_->target_x);
	clutter_actor_restore_easing_state ((ClutterActor*) self);
	_tmp0_ = self->priv->background;
	clutter_actor_save_easing_state ((ClutterActor*) _tmp0_);
	_tmp1_ = self->priv->background;
	clutter_actor_set_easing_duration ((ClutterActor*) _tmp1_, (guint) GALA_MULTITASKING_VIEW_ANIMATION_DURATION);
	_tmp2_ = self->priv->background;
	clutter_actor_set_easing_mode ((ClutterActor*) _tmp2_, CLUTTER_EASE_OUT_QUAD);
	_tmp3_ = self->priv->background;
	clutter_actor_set_scale ((ClutterActor*) _tmp3_, (gdouble) _data69_->scale, (gdouble) _data69_->scale);
	_tmp4_ = self->priv->background;
	clutter_actor_restore_easing_state ((ClutterActor*) _tmp4_);
}

static void
___lambda108__gala_gesture_tracker_on_end (gdouble percentage,
                                           gboolean cancel_action,
                                           gint calculated_duration,
                                           gpointer self)
{
	__lambda108_ (self, percentage, cancel_action);
}

void
gala_workspace_clone_open (GalaWorkspaceClone* self,
                           gboolean with_gesture,
                           gboolean is_cancel_animation)
{
	Block69Data* _data69_;
	gint scale_factor = 0;
	MetaDisplay* display = NULL;
	MetaWorkspace* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaDisplay* _tmp2_;
	MetaRectangle monitor = {0};
	MetaDisplay* _tmp3_;
	MetaDisplay* _tmp4_;
	MetaRectangle _tmp5_ = {0};
	gfloat _tmp6_ = 0.0F;
	MetaRectangle _tmp11_;
	MetaRectangle _tmp12_;
	MetaRectangle _tmp13_;
	MetaRectangle _tmp14_;
	MetaRectangle _tmp15_;
	GalaGestureTrackerOnBegin on_animation_begin = NULL;
	gpointer on_animation_begin_target;
	GDestroyNotify on_animation_begin_target_destroy_notify;
	GalaGestureTrackerOnUpdate on_animation_update = NULL;
	gpointer on_animation_update_target;
	GDestroyNotify on_animation_update_target_destroy_notify;
	GalaGestureTrackerOnEnd on_animation_end = NULL;
	gpointer on_animation_end_target;
	GDestroyNotify on_animation_end_target_destroy_notify;
	MetaRectangle area = {0};
	MetaRectangle _tmp22_;
	MetaRectangle _tmp23_;
	MetaRectangle _tmp24_;
	MetaRectangle _tmp25_;
	MetaRectangle _tmp26_;
	MetaRectangle _tmp27_;
	MetaRectangle _tmp28_ = {0};
	GalaWindowCloneContainer* _tmp29_;
	GalaWindowCloneContainer* _tmp30_;
	GalaWindowCloneContainer* _tmp31_;
	MetaRectangle _tmp32_;
	MetaRectangle _tmp33_;
	GalaWindowCloneContainer* _tmp34_;
	GalaIconGroup* _tmp35_;
	MetaWindow* _tmp36_ = NULL;
	MetaDisplay* _tmp37_;
	MetaWorkspaceManager* _tmp38_;
	MetaWorkspace* _tmp39_;
	MetaWorkspace* _tmp40_;
	MetaWindow* selected_window = NULL;
	MetaWindow* _tmp43_;
	GalaWindowCloneContainer* _tmp44_;
	MetaWindow* _tmp45_;
	g_return_if_fail (self != NULL);
	_data69_ = g_slice_new0 (Block69Data);
	_data69_->_ref_count_ = 1;
	_data69_->self = g_object_ref (self);
	if (self->priv->opened) {
		block69_data_unref (_data69_);
		_data69_ = NULL;
		return;
	}
	self->priv->opened = TRUE;
	scale_factor = gala_internal_utils_get_ui_scaling_factor ();
	_tmp0_ = self->priv->_workspace;
	_tmp1_ = meta_workspace_get_display (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	display = _tmp2_;
	_tmp3_ = display;
	_tmp4_ = display;
	meta_display_get_monitor_geometry (_tmp3_, meta_display_get_primary_monitor (_tmp4_), &_tmp5_);
	monitor = _tmp5_;
	if (is_cancel_animation) {
		gfloat _tmp7_;
		gfloat _tmp8_;
		_tmp7_ = clutter_actor_get_x ((ClutterActor*) self);
		_tmp8_ = _tmp7_;
		_tmp6_ = _tmp8_;
	} else {
		gfloat _tmp9_;
		gfloat _tmp10_;
		_tmp9_ = clutter_actor_get_x ((ClutterActor*) self);
		_tmp10_ = _tmp9_;
		_tmp6_ = _tmp10_ + gala_workspace_clone_current_x_overlap (self);
	}
	_data69_->initial_x = _tmp6_;
	_data69_->target_x = gala_workspace_clone_multitasking_view_x (self);
	_tmp11_ = monitor;
	_tmp12_ = monitor;
	_data69_->scale = ((gfloat) ((_tmp11_.height - (GALA_WORKSPACE_CLONE_TOP_OFFSET * scale_factor)) - (GALA_WORKSPACE_CLONE_BOTTOM_OFFSET * scale_factor))) / _tmp12_.height;
	_tmp13_ = monitor;
	_tmp14_ = monitor;
	_data69_->pivot_y = (GALA_WORKSPACE_CLONE_TOP_OFFSET * scale_factor) / (_tmp13_.height - (_tmp14_.height * _data69_->scale));
	_tmp15_ = monitor;
	gala_workspace_clone_update_size (self, &_tmp15_);
	on_animation_begin = ___lambda106__gala_gesture_tracker_on_begin;
	on_animation_begin_target = block69_data_ref (_data69_);
	on_animation_begin_target_destroy_notify = block69_data_unref;
	on_animation_update = ___lambda107__gala_gesture_tracker_on_update;
	on_animation_update_target = block69_data_ref (_data69_);
	on_animation_update_target_destroy_notify = block69_data_unref;
	on_animation_end = ___lambda108__gala_gesture_tracker_on_end;
	on_animation_end_target = block69_data_ref (_data69_);
	on_animation_end_target_destroy_notify = block69_data_unref;
	if (!with_gesture) {
		GalaGestureTrackerOnBegin _tmp16_;
		gpointer _tmp16__target;
		GalaGestureTrackerOnEnd _tmp17_;
		gpointer _tmp17__target;
		_tmp16_ = on_animation_begin;
		_tmp16__target = on_animation_begin_target;
		_tmp16_ ((gdouble) 0, _tmp16__target);
		_tmp17_ = on_animation_end;
		_tmp17__target = on_animation_end_target;
		_tmp17_ ((gdouble) 1, FALSE, 0, _tmp17__target);
	} else {
		GalaGestureTracker* _tmp18_;
		GalaGestureTrackerOnBegin _tmp19_;
		gpointer _tmp19__target;
		GDestroyNotify _tmp19__target_destroy_notify;
		GalaGestureTrackerOnUpdate _tmp20_;
		gpointer _tmp20__target;
		GDestroyNotify _tmp20__target_destroy_notify;
		GalaGestureTrackerOnEnd _tmp21_;
		gpointer _tmp21__target;
		GDestroyNotify _tmp21__target_destroy_notify;
		_tmp18_ = self->priv->_gesture_tracker;
		_tmp19_ = on_animation_begin;
		_tmp19__target = on_animation_begin_target;
		_tmp19__target_destroy_notify = on_animation_begin_target_destroy_notify;
		on_animation_begin = NULL;
		on_animation_begin_target = NULL;
		on_animation_begin_target_destroy_notify = NULL;
		_tmp20_ = on_animation_update;
		_tmp20__target = on_animation_update_target;
		_tmp20__target_destroy_notify = on_animation_update_target_destroy_notify;
		on_animation_update = NULL;
		on_animation_update_target = NULL;
		on_animation_update_target_destroy_notify = NULL;
		_tmp21_ = on_animation_end;
		_tmp21__target = on_animation_end_target;
		_tmp21__target_destroy_notify = on_animation_end_target_destroy_notify;
		on_animation_end = NULL;
		on_animation_end_target = NULL;
		on_animation_end_target_destroy_notify = NULL;
		gala_gesture_tracker_connect_handlers (_tmp18_, _tmp19_, _tmp19__target, _tmp19__target_destroy_notify, _tmp20_, _tmp20__target, _tmp20__target_destroy_notify, _tmp21_, _tmp21__target, _tmp21__target_destroy_notify);
	}
	_tmp22_ = monitor;
	_tmp23_ = monitor;
	_tmp24_ = monitor;
	_tmp25_ = monitor;
	_tmp26_ = monitor;
	_tmp27_ = monitor;
	_tmp28_.x = ((gint) floorf ((_tmp22_.x + _tmp23_.width) - (_tmp24_.width * _data69_->scale))) / 2;
	_tmp28_.y = (gint) floorf ((gfloat) (_tmp25_.y + (GALA_WORKSPACE_CLONE_TOP_OFFSET * scale_factor)));
	_tmp28_.width = (gint) floorf (_tmp26_.width * _data69_->scale);
	_tmp28_.height = (gint) floorf (_tmp27_.height * _data69_->scale);
	area = _tmp28_;
	gala_workspace_clone_shrink_rectangle (&area, 32);
	_tmp29_ = self->priv->_window_container;
	gala_window_clone_container_set_padding_top (_tmp29_, GALA_WORKSPACE_CLONE_TOP_OFFSET * scale_factor);
	_tmp30_ = self->priv->_window_container;
	_tmp31_ = self->priv->_window_container;
	_tmp32_ = monitor;
	_tmp33_ = monitor;
	gala_window_clone_container_set_padding_right (_tmp31_, ((gint) (_tmp32_.width - (_tmp33_.width * _data69_->scale))) / 2);
	gala_window_clone_container_set_padding_left (_tmp30_, ((gint) (_tmp32_.width - (_tmp33_.width * _data69_->scale))) / 2);
	_tmp34_ = self->priv->_window_container;
	gala_window_clone_container_set_padding_bottom (_tmp34_, GALA_WORKSPACE_CLONE_BOTTOM_OFFSET * scale_factor);
	_tmp35_ = self->priv->_icon_group;
	gala_icon_group_redraw (_tmp35_);
	_tmp37_ = display;
	_tmp38_ = meta_display_get_workspace_manager (_tmp37_);
	_tmp39_ = meta_workspace_manager_get_active_workspace (_tmp38_);
	_tmp40_ = self->priv->_workspace;
	if (_tmp39_ == _tmp40_) {
		MetaDisplay* _tmp41_;
		MetaWindow* _tmp42_;
		_tmp41_ = display;
		_tmp42_ = meta_display_get_focus_window (_tmp41_);
		_tmp36_ = _tmp42_;
	} else {
		_tmp36_ = NULL;
	}
	_tmp43_ = _g_object_ref0 (_tmp36_);
	selected_window = _tmp43_;
	_tmp44_ = self->priv->_window_container;
	_tmp45_ = selected_window;
	gala_window_clone_container_open (_tmp44_, _tmp45_, with_gesture, is_cancel_animation);
	_g_object_unref0 (selected_window);
	(on_animation_end_target_destroy_notify == NULL) ? NULL : (on_animation_end_target_destroy_notify (on_animation_end_target), NULL);
	on_animation_end = NULL;
	on_animation_end_target = NULL;
	on_animation_end_target_destroy_notify = NULL;
	(on_animation_update_target_destroy_notify == NULL) ? NULL : (on_animation_update_target_destroy_notify (on_animation_update_target), NULL);
	on_animation_update = NULL;
	on_animation_update_target = NULL;
	on_animation_update_target_destroy_notify = NULL;
	(on_animation_begin_target_destroy_notify == NULL) ? NULL : (on_animation_begin_target_destroy_notify (on_animation_begin_target), NULL);
	on_animation_begin = NULL;
	on_animation_begin_target = NULL;
	on_animation_begin_target_destroy_notify = NULL;
	_g_object_unref0 (display);
	block69_data_unref (_data69_);
	_data69_ = NULL;
}

/**
         * Close the view again by animating the background back to its scale and
         * the windows back to their old locations.
         */
static Block70Data*
block70_data_ref (Block70Data* _data70_)
{
	g_atomic_int_inc (&_data70_->_ref_count_);
	return _data70_;
}

static void
block70_data_unref (void * _userdata_)
{
	Block70Data* _data70_;
	_data70_ = (Block70Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data70_->_ref_count_)) {
		GalaWorkspaceClone* self;
		self = _data70_->self;
		_g_object_unref0 (self);
		g_slice_free (Block70Data, _data70_);
	}
}

static void
__lambda109_ (Block70Data* _data70_,
              gdouble percentage)
{
	GalaWorkspaceClone* self;
	gfloat x = 0.0F;
	gdouble scale_x = 0.0;
	gdouble scale_y = 0.0;
	GalaBackgroundManager* _tmp0_;
	self = _data70_->self;
	x = gala_gesture_tracker_animation_value (_data70_->initial_x, _data70_->target_x, percentage, FALSE);
	clutter_actor_set_x ((ClutterActor*) self, x);
	scale_x = (gdouble) gala_gesture_tracker_animation_value ((gfloat) _data70_->initial_scale_x, 1.0f, percentage, FALSE);
	scale_y = (gdouble) gala_gesture_tracker_animation_value ((gfloat) _data70_->initial_scale_y, 1.0f, percentage, FALSE);
	_tmp0_ = self->priv->background;
	clutter_actor_set_scale ((ClutterActor*) _tmp0_, scale_x, scale_y);
}

static void
___lambda109__gala_gesture_tracker_on_update (gdouble percentage,
                                              gpointer self)
{
	__lambda109_ (self, percentage);
}

static void
__lambda110_ (Block70Data* _data70_,
              gdouble percentage,
              gboolean cancel_action)
{
	GalaWorkspaceClone* self;
	GalaBackgroundManager* _tmp0_;
	GalaBackgroundManager* _tmp1_;
	GalaBackgroundManager* _tmp2_;
	GalaBackgroundManager* _tmp3_;
	GalaBackgroundManager* _tmp4_;
	self = _data70_->self;
	if (cancel_action) {
		return;
	}
	clutter_actor_save_easing_state ((ClutterActor*) self);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) GALA_MULTITASKING_VIEW_ANIMATION_DURATION);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_QUAD);
	clutter_actor_set_x ((ClutterActor*) self, _data70_->target_x);
	clutter_actor_restore_easing_state ((ClutterActor*) self);
	_tmp0_ = self->priv->background;
	clutter_actor_save_easing_state ((ClutterActor*) _tmp0_);
	_tmp1_ = self->priv->background;
	clutter_actor_set_easing_duration ((ClutterActor*) _tmp1_, (guint) GALA_MULTITASKING_VIEW_ANIMATION_DURATION);
	_tmp2_ = self->priv->background;
	clutter_actor_set_easing_mode ((ClutterActor*) _tmp2_, CLUTTER_EASE_OUT_QUAD);
	_tmp3_ = self->priv->background;
	clutter_actor_set_scale ((ClutterActor*) _tmp3_, (gdouble) 1, (gdouble) 1);
	_tmp4_ = self->priv->background;
	clutter_actor_restore_easing_state ((ClutterActor*) _tmp4_);
}

static void
___lambda110__gala_gesture_tracker_on_end (gdouble percentage,
                                           gboolean cancel_action,
                                           gint calculated_duration,
                                           gpointer self)
{
	__lambda110_ (self, percentage, cancel_action);
}

void
gala_workspace_clone_close (GalaWorkspaceClone* self,
                            gboolean with_gesture,
                            gboolean is_cancel_animation)
{
	Block70Data* _data70_;
	gfloat _tmp0_ = 0.0F;
	GalaBackgroundManager* _tmp3_;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	GalaGestureTrackerOnUpdate on_animation_update = NULL;
	gpointer on_animation_update_target;
	GDestroyNotify on_animation_update_target_destroy_notify;
	GalaGestureTrackerOnEnd on_animation_end = NULL;
	gpointer on_animation_end_target;
	GDestroyNotify on_animation_end_target_destroy_notify;
	GalaWindowCloneContainer* _tmp10_;
	g_return_if_fail (self != NULL);
	_data70_ = g_slice_new0 (Block70Data);
	_data70_->_ref_count_ = 1;
	_data70_->self = g_object_ref (self);
	if (!self->priv->opened) {
		block70_data_unref (_data70_);
		_data70_ = NULL;
		return;
	}
	self->priv->opened = FALSE;
	if (is_cancel_animation) {
		gfloat _tmp1_;
		gfloat _tmp2_;
		_tmp1_ = clutter_actor_get_x ((ClutterActor*) self);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = gala_workspace_clone_multitasking_view_x (self);
	}
	_data70_->initial_x = _tmp0_;
	_data70_->target_x = gala_workspace_clone_multitasking_view_x (self) + gala_workspace_clone_current_x_overlap (self);
	_tmp3_ = self->priv->background;
	clutter_actor_get_scale ((ClutterActor*) _tmp3_, &_tmp4_, &_tmp5_);
	_data70_->initial_scale_x = _tmp4_;
	_data70_->initial_scale_y = _tmp5_;
	on_animation_update = ___lambda109__gala_gesture_tracker_on_update;
	on_animation_update_target = block70_data_ref (_data70_);
	on_animation_update_target_destroy_notify = block70_data_unref;
	on_animation_end = ___lambda110__gala_gesture_tracker_on_end;
	on_animation_end_target = block70_data_ref (_data70_);
	on_animation_end_target_destroy_notify = block70_data_unref;
	if (!with_gesture) {
		GalaGestureTrackerOnEnd _tmp6_;
		gpointer _tmp6__target;
		_tmp6_ = on_animation_end;
		_tmp6__target = on_animation_end_target;
		_tmp6_ ((gdouble) 1, FALSE, 0, _tmp6__target);
	} else {
		GalaGestureTracker* _tmp7_;
		GalaGestureTrackerOnUpdate _tmp8_;
		gpointer _tmp8__target;
		GDestroyNotify _tmp8__target_destroy_notify;
		GalaGestureTrackerOnEnd _tmp9_;
		gpointer _tmp9__target;
		GDestroyNotify _tmp9__target_destroy_notify;
		_tmp7_ = self->priv->_gesture_tracker;
		_tmp8_ = on_animation_update;
		_tmp8__target = on_animation_update_target;
		_tmp8__target_destroy_notify = on_animation_update_target_destroy_notify;
		on_animation_update = NULL;
		on_animation_update_target = NULL;
		on_animation_update_target_destroy_notify = NULL;
		_tmp9_ = on_animation_end;
		_tmp9__target = on_animation_end_target;
		_tmp9__target_destroy_notify = on_animation_end_target_destroy_notify;
		on_animation_end = NULL;
		on_animation_end_target = NULL;
		on_animation_end_target_destroy_notify = NULL;
		gala_gesture_tracker_connect_handlers (_tmp7_, NULL, NULL, NULL, _tmp8_, _tmp8__target, _tmp8__target_destroy_notify, _tmp9_, _tmp9__target, _tmp9__target_destroy_notify);
	}
	_tmp10_ = self->priv->_window_container;
	gala_window_clone_container_close (_tmp10_, with_gesture, is_cancel_animation);
	(on_animation_end_target_destroy_notify == NULL) ? NULL : (on_animation_end_target_destroy_notify (on_animation_end_target), NULL);
	on_animation_end = NULL;
	on_animation_end_target = NULL;
	on_animation_end_target_destroy_notify = NULL;
	(on_animation_update_target_destroy_notify == NULL) ? NULL : (on_animation_update_target_destroy_notify (on_animation_update_target), NULL);
	on_animation_update = NULL;
	on_animation_update_target = NULL;
	on_animation_update_target_destroy_notify = NULL;
	block70_data_unref (_data70_);
	_data70_ = NULL;
}

MetaWorkspace*
gala_workspace_clone_get_workspace (GalaWorkspaceClone* self)
{
	MetaWorkspace* result;
	MetaWorkspace* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_workspace;
	result = _tmp0_;
	return result;
}

static void
gala_workspace_clone_set_workspace (GalaWorkspaceClone* self,
                                    MetaWorkspace* value)
{
	MetaWorkspace* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_workspace_clone_get_workspace (self);
	if (old_value != value) {
		MetaWorkspace* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_workspace);
		self->priv->_workspace = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_WORKSPACE_PROPERTY]);
	}
}

GalaGestureTracker*
gala_workspace_clone_get_gesture_tracker (GalaWorkspaceClone* self)
{
	GalaGestureTracker* result;
	GalaGestureTracker* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gesture_tracker;
	result = _tmp0_;
	return result;
}

static void
gala_workspace_clone_set_gesture_tracker (GalaWorkspaceClone* self,
                                          GalaGestureTracker* value)
{
	GalaGestureTracker* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_workspace_clone_get_gesture_tracker (self);
	if (old_value != value) {
		GalaGestureTracker* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_gesture_tracker);
		self->priv->_gesture_tracker = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_GESTURE_TRACKER_PROPERTY]);
	}
}

GalaIconGroup*
gala_workspace_clone_get_icon_group (GalaWorkspaceClone* self)
{
	GalaIconGroup* result;
	GalaIconGroup* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon_group;
	result = _tmp0_;
	return result;
}

static void
gala_workspace_clone_set_icon_group (GalaWorkspaceClone* self,
                                     GalaIconGroup* value)
{
	GalaIconGroup* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_workspace_clone_get_icon_group (self);
	if (old_value != value) {
		GalaIconGroup* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_icon_group);
		self->priv->_icon_group = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_ICON_GROUP_PROPERTY]);
	}
}

GalaWindowCloneContainer*
gala_workspace_clone_get_window_container (GalaWorkspaceClone* self)
{
	GalaWindowCloneContainer* result;
	GalaWindowCloneContainer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window_container;
	result = _tmp0_;
	return result;
}

static void
gala_workspace_clone_set_window_container (GalaWorkspaceClone* self,
                                           GalaWindowCloneContainer* value)
{
	GalaWindowCloneContainer* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_workspace_clone_get_window_container (self);
	if (old_value != value) {
		GalaWindowCloneContainer* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_window_container);
		self->priv->_window_container = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_WINDOW_CONTAINER_PROPERTY]);
	}
}

gboolean
gala_workspace_clone_get_active (GalaWorkspaceClone* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_active;
	return result;
}

void
gala_workspace_clone_set_active (GalaWorkspaceClone* self,
                                 gboolean value)
{
	GalaIconGroup* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_active = value;
	_tmp0_ = self->priv->_icon_group;
	gala_icon_group_set_active (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_ACTIVE_PROPERTY]);
}

static gboolean
_gala_workspace_clone___lambda111_ (GalaWorkspaceClone* self)
{
	gboolean result;
	g_signal_emit (self, gala_workspace_clone_signals[GALA_WORKSPACE_CLONE_SELECTED_SIGNAL], 0, TRUE);
	result = FALSE;
	return result;
}

static gboolean
__gala_workspace_clone___lambda111__clutter_actor_button_press_event (ClutterActor* _sender,
                                                                      ClutterButtonEvent* event,
                                                                      gpointer self)
{
	gboolean result;
	result = _gala_workspace_clone___lambda111_ ((GalaWorkspaceClone*) self);
	return result;
}

static void
_gala_workspace_clone___lambda112_ (GalaWorkspaceClone* self,
                                    MetaWindow* w)
{
	g_return_if_fail (w != NULL);
	g_signal_emit (self, gala_workspace_clone_signals[GALA_WORKSPACE_CLONE_WINDOW_SELECTED_SIGNAL], 0, w);
}

static void
__gala_workspace_clone___lambda112__gala_window_clone_container_window_selected (GalaWindowCloneContainer* _sender,
                                                                                 MetaWindow* window,
                                                                                 gpointer self)
{
	_gala_workspace_clone___lambda112_ ((GalaWorkspaceClone*) self, window);
}

static void
_gala_workspace_clone___lambda113_ (GalaWorkspaceClone* self)
{
	g_signal_emit (self, gala_workspace_clone_signals[GALA_WORKSPACE_CLONE_SELECTED_SIGNAL], 0, TRUE);
}

static void
__gala_workspace_clone___lambda113__gala_icon_group_selected (GalaIconGroup* _sender,
                                                              gpointer self)
{
	_gala_workspace_clone___lambda113_ ((GalaWorkspaceClone*) self);
}

static gboolean
___lambda115_ (GalaWorkspaceClone* self)
{
	gboolean result;
	g_signal_emit (self, gala_workspace_clone_signals[GALA_WORKSPACE_CLONE_SELECTED_SIGNAL], 0, FALSE);
	self->priv->hover_activate_timeout = (guint) 0;
	result = FALSE;
	return result;
}

static gboolean
____lambda115__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda115_ ((GalaWorkspaceClone*) self);
	return result;
}

static void
_gala_workspace_clone___lambda114_ (GalaWorkspaceClone* self,
                                    ClutterActor* target,
                                    gboolean hovered)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	if (!hovered) {
		_tmp0_ = self->priv->hover_activate_timeout != ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_source_remove (self->priv->hover_activate_timeout);
		self->priv->hover_activate_timeout = (guint) 0;
		return;
	}
	if (hovered) {
		_tmp1_ = self->priv->hover_activate_timeout == ((guint) 0);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		self->priv->hover_activate_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) GALA_WORKSPACE_CLONE_HOVER_ACTIVATE_DELAY, ____lambda115__gsource_func, g_object_ref (self), g_object_unref);
	}
}

static void
__gala_workspace_clone___lambda114__gala_drag_drop_action_crossed (GalaDragDropAction* _sender,
                                                                   ClutterActor* target,
                                                                   gboolean hovered,
                                                                   gpointer self)
{
	_gala_workspace_clone___lambda114_ ((GalaWorkspaceClone*) self, target, hovered);
}

static GObject *
gala_workspace_clone_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaWorkspaceClone * self;
	MetaDisplay* display = NULL;
	MetaWorkspace* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaRectangle monitor_geometry = {0};
	MetaDisplay* _tmp2_;
	MetaDisplay* _tmp3_;
	MetaRectangle _tmp4_ = {0};
	MetaDisplay* _tmp5_;
	GalaFramedBackground* _tmp6_;
	GalaBackgroundManager* _tmp7_;
	GalaBackgroundManager* _tmp8_;
	GalaGestureTracker* _tmp9_;
	GalaWindowCloneContainer* _tmp10_;
	GalaWindowCloneContainer* _tmp11_;
	GalaWindowCloneContainer* _tmp12_;
	GalaWindowCloneContainer* _tmp13_;
	MetaRectangle _tmp14_;
	MetaRectangle _tmp15_;
	MetaDisplay* _tmp16_;
	GalaWindowCloneContainer* _tmp17_;
	MetaWorkspace* _tmp18_;
	GalaIconGroup* _tmp19_;
	GalaIconGroup* _tmp20_;
	GalaIconGroup* _tmp21_;
	GalaDragDropAction* icons_drop_action = NULL;
	GalaDragDropAction* _tmp22_;
	GalaIconGroup* _tmp23_;
	GalaDragDropAction* _tmp24_;
	GalaDragDropAction* background_drop_action = NULL;
	GalaDragDropAction* _tmp25_;
	GalaBackgroundManager* _tmp26_;
	GalaDragDropAction* _tmp27_;
	GalaDragDropAction* _tmp28_;
	MetaDisplay* _tmp29_;
	MetaDisplay* _tmp30_;
	MetaWorkspace* _tmp31_;
	MetaWorkspace* _tmp32_;
	GalaBackgroundManager* _tmp33_;
	GalaWindowCloneContainer* _tmp34_;
	GList* windows = NULL;
	MetaWorkspace* _tmp35_;
	GList* _tmp36_;
	GList* _tmp37_;
	GalaWindowListener* listener = NULL;
	GalaWindowListener* _tmp52_;
	GalaWindowListener* _tmp53_;
	GalaWindowListener* _tmp54_;
	parent_class = G_OBJECT_CLASS (gala_workspace_clone_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone);
	self->priv->opened = FALSE;
	_tmp0_ = self->priv->_workspace;
	_tmp1_ = meta_workspace_get_display (_tmp0_);
	display = _tmp1_;
	_tmp2_ = display;
	_tmp3_ = display;
	meta_display_get_monitor_geometry (_tmp2_, meta_display_get_primary_monitor (_tmp3_), &_tmp4_);
	monitor_geometry = _tmp4_;
	_tmp5_ = display;
	_tmp6_ = gala_framed_background_new (_tmp5_);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->background);
	self->priv->background = (GalaBackgroundManager*) _tmp6_;
	_tmp7_ = self->priv->background;
	clutter_actor_set_reactive ((ClutterActor*) _tmp7_, TRUE);
	_tmp8_ = self->priv->background;
	g_signal_connect_object ((ClutterActor*) _tmp8_, "button-press-event", (GCallback) __gala_workspace_clone___lambda111__clutter_actor_button_press_event, self, 0);
	_tmp9_ = self->priv->_gesture_tracker;
	_tmp10_ = gala_window_clone_container_new (_tmp9_, FALSE);
	g_object_ref_sink (_tmp10_);
	_tmp11_ = _tmp10_;
	gala_workspace_clone_set_window_container (self, _tmp11_);
	_g_object_unref0 (_tmp11_);
	_tmp12_ = self->priv->_window_container;
	g_signal_connect_object (_tmp12_, "window-selected", (GCallback) __gala_workspace_clone___lambda112__gala_window_clone_container_window_selected, self, 0);
	_tmp13_ = self->priv->_window_container;
	_tmp14_ = monitor_geometry;
	_tmp15_ = monitor_geometry;
	clutter_actor_set_size ((ClutterActor*) _tmp13_, (gfloat) _tmp14_.width, (gfloat) _tmp15_.height);
	_tmp16_ = display;
	_tmp17_ = self->priv->_window_container;
	g_signal_connect_object (_tmp16_, "restacked", (GCallback) _gala_window_clone_container_restack_windows_meta_display_restacked, _tmp17_, 0);
	_tmp18_ = self->priv->_workspace;
	_tmp19_ = gala_icon_group_new (_tmp18_);
	g_object_ref_sink (_tmp19_);
	_tmp20_ = _tmp19_;
	gala_workspace_clone_set_icon_group (self, _tmp20_);
	_g_object_unref0 (_tmp20_);
	_tmp21_ = self->priv->_icon_group;
	g_signal_connect_object (_tmp21_, "selected", (GCallback) __gala_workspace_clone___lambda113__gala_icon_group_selected, self, 0);
	_tmp22_ = gala_drag_drop_action_new (GALA_DRAG_DROP_ACTION_TYPE_DESTINATION, "multitaskingview-window");
	g_object_ref_sink (_tmp22_);
	icons_drop_action = _tmp22_;
	_tmp23_ = self->priv->_icon_group;
	_tmp24_ = icons_drop_action;
	clutter_actor_add_action ((ClutterActor*) _tmp23_, (ClutterAction*) _tmp24_);
	_tmp25_ = gala_drag_drop_action_new (GALA_DRAG_DROP_ACTION_TYPE_DESTINATION, "multitaskingview-window");
	g_object_ref_sink (_tmp25_);
	background_drop_action = _tmp25_;
	_tmp26_ = self->priv->background;
	_tmp27_ = background_drop_action;
	clutter_actor_add_action ((ClutterActor*) _tmp26_, (ClutterAction*) _tmp27_);
	_tmp28_ = background_drop_action;
	g_signal_connect_object (_tmp28_, "crossed", (GCallback) __gala_workspace_clone___lambda114__gala_drag_drop_action_crossed, self, 0);
	_tmp29_ = display;
	g_signal_connect_object (_tmp29_, "window-entered-monitor", (GCallback) _gala_workspace_clone_window_entered_monitor_meta_display_window_entered_monitor, self, 0);
	_tmp30_ = display;
	g_signal_connect_object (_tmp30_, "window-left-monitor", (GCallback) _gala_workspace_clone_window_left_monitor_meta_display_window_left_monitor, self, 0);
	_tmp31_ = self->priv->_workspace;
	g_signal_connect_object (_tmp31_, "window-added", (GCallback) _gala_workspace_clone_add_window_meta_workspace_window_added, self, 0);
	_tmp32_ = self->priv->_workspace;
	g_signal_connect_object (_tmp32_, "window-removed", (GCallback) _gala_workspace_clone_remove_window_meta_workspace_window_removed, self, 0);
	_tmp33_ = self->priv->background;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp33_);
	_tmp34_ = self->priv->_window_container;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp34_);
	_tmp35_ = self->priv->_workspace;
	_tmp36_ = meta_workspace_list_windows (_tmp35_);
	windows = _tmp36_;
	_tmp37_ = windows;
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp37_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				gboolean _tmp38_ = FALSE;
				gboolean _tmp39_ = FALSE;
				MetaWindow* _tmp40_;
				MetaWindowType _tmp41_;
				MetaWindowType _tmp42_;
				_tmp40_ = window;
				_tmp41_ = meta_window_get_window_type (_tmp40_);
				_tmp42_ = _tmp41_;
				if (_tmp42_ == META_WINDOW_NORMAL) {
					MetaWindow* _tmp43_;
					gboolean _tmp44_;
					gboolean _tmp45_;
					_tmp43_ = window;
					g_object_get (_tmp43_, "on-all-workspaces", &_tmp44_, NULL);
					_tmp45_ = _tmp44_;
					_tmp39_ = !_tmp45_;
				} else {
					_tmp39_ = FALSE;
				}
				if (_tmp39_) {
					MetaWindow* _tmp46_;
					MetaDisplay* _tmp47_;
					_tmp46_ = window;
					_tmp47_ = display;
					_tmp38_ = meta_window_get_monitor (_tmp46_) == meta_display_get_primary_monitor (_tmp47_);
				} else {
					_tmp38_ = FALSE;
				}
				if (_tmp38_) {
					GalaWindowCloneContainer* _tmp48_;
					MetaWindow* _tmp49_;
					GalaIconGroup* _tmp50_;
					MetaWindow* _tmp51_;
					_tmp48_ = self->priv->_window_container;
					_tmp49_ = window;
					gala_window_clone_container_add_window (_tmp48_, _tmp49_);
					_tmp50_ = self->priv->_icon_group;
					_tmp51_ = window;
					gala_icon_group_add_window (_tmp50_, _tmp51_, TRUE, FALSE);
				}
			}
		}
	}
	_tmp52_ = gala_window_listener_get_default ();
	_tmp53_ = _g_object_ref0 (_tmp52_);
	listener = _tmp53_;
	_tmp54_ = listener;
	g_signal_connect_object (_tmp54_, "window-no-longer-on-all-workspaces", (GCallback) _gala_workspace_clone_add_window_gala_window_listener_window_no_longer_on_all_workspaces, self, 0);
	_g_object_unref0 (listener);
	(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
	_g_object_unref0 (background_drop_action);
	_g_object_unref0 (icons_drop_action);
	return obj;
}

static void
gala_workspace_clone_class_init (GalaWorkspaceCloneClass * klass,
                                 gpointer klass_data)
{
	gala_workspace_clone_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaWorkspaceClone_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_workspace_clone_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_workspace_clone_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_workspace_clone_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_workspace_clone_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WORKSPACE_CLONE_WORKSPACE_PROPERTY, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_WORKSPACE_PROPERTY] = g_param_spec_object ("workspace", "workspace", "workspace", meta_workspace_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WORKSPACE_CLONE_GESTURE_TRACKER_PROPERTY, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_GESTURE_TRACKER_PROPERTY] = g_param_spec_object ("gesture-tracker", "gesture-tracker", "gesture-tracker", GALA_TYPE_GESTURE_TRACKER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WORKSPACE_CLONE_ICON_GROUP_PROPERTY, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_ICON_GROUP_PROPERTY] = g_param_spec_object ("icon-group", "icon-group", "icon-group", GALA_TYPE_ICON_GROUP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WORKSPACE_CLONE_WINDOW_CONTAINER_PROPERTY, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_WINDOW_CONTAINER_PROPERTY] = g_param_spec_object ("window-container", "window-container", "window-container", GALA_TYPE_WINDOW_CLONE_CONTAINER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	         * If this WorkspaceClone is currently the active one. Also sets the active
	         * state on its IconGroup.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WORKSPACE_CLONE_ACTIVE_PROPERTY, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_ACTIVE_PROPERTY] = g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * A window has been selected, the MultitaskingView should consider activating
	         * and closing the view.
	         */
	gala_workspace_clone_signals[GALA_WORKSPACE_CLONE_WINDOW_SELECTED_SIGNAL] = g_signal_new ("window-selected", GALA_TYPE_WORKSPACE_CLONE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, meta_window_get_type ());
	/**
	         * The background has been selected. Switch to that workspace.
	         *
	         * @param close_view If the MultitaskingView should also consider closing itself
	         *                   after switching.
	         */
	gala_workspace_clone_signals[GALA_WORKSPACE_CLONE_SELECTED_SIGNAL] = g_signal_new ("selected", GALA_TYPE_WORKSPACE_CLONE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}

static void
gala_workspace_clone_instance_init (GalaWorkspaceClone * self,
                                    gpointer klass)
{
	self->priv = gala_workspace_clone_get_instance_private (self);
	self->priv->_active = FALSE;
	self->priv->hover_activate_timeout = (guint) 0;
}

static void
gala_workspace_clone_finalize (GObject * obj)
{
	GalaWorkspaceClone * self;
	MetaDisplay* display = NULL;
	MetaWorkspace* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaDisplay* _tmp2_;
	GalaWindowCloneContainer* _tmp3_;
	guint _tmp4_;
	MetaDisplay* _tmp5_;
	guint _tmp6_;
	MetaDisplay* _tmp7_;
	guint _tmp8_;
	MetaWorkspace* _tmp9_;
	guint _tmp10_;
	MetaWorkspace* _tmp11_;
	guint _tmp12_;
	GalaWindowListener* listener = NULL;
	GalaWindowListener* _tmp13_;
	GalaWindowListener* _tmp14_;
	GalaWindowListener* _tmp15_;
	guint _tmp16_;
	GalaBackgroundManager* _tmp17_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone);
	_tmp0_ = self->priv->_workspace;
	_tmp1_ = meta_workspace_get_display (_tmp0_);
	display = _tmp1_;
	_tmp2_ = display;
	_tmp3_ = self->priv->_window_container;
	g_signal_parse_name ("restacked", meta_display_get_type (), &_tmp4_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _gala_window_clone_container_restack_windows_meta_display_restacked, _tmp3_);
	_tmp5_ = display;
	g_signal_parse_name ("window-entered-monitor", meta_display_get_type (), &_tmp6_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _gala_workspace_clone_window_entered_monitor_meta_display_window_entered_monitor, self);
	_tmp7_ = display;
	g_signal_parse_name ("window-left-monitor", meta_display_get_type (), &_tmp8_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _gala_workspace_clone_window_left_monitor_meta_display_window_left_monitor, self);
	_tmp9_ = self->priv->_workspace;
	g_signal_parse_name ("window-added", meta_workspace_get_type (), &_tmp10_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp9_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _gala_workspace_clone_add_window_meta_workspace_window_added, self);
	_tmp11_ = self->priv->_workspace;
	g_signal_parse_name ("window-removed", meta_workspace_get_type (), &_tmp12_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp11_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, 0, NULL, (GCallback) _gala_workspace_clone_remove_window_meta_workspace_window_removed, self);
	_tmp13_ = gala_window_listener_get_default ();
	_tmp14_ = _g_object_ref0 (_tmp13_);
	listener = _tmp14_;
	_tmp15_ = listener;
	g_signal_parse_name ("window-no-longer-on-all-workspaces", GALA_TYPE_WINDOW_LISTENER, &_tmp16_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp15_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp16_, 0, NULL, (GCallback) _gala_workspace_clone_add_window_gala_window_listener_window_no_longer_on_all_workspaces, self);
	_tmp17_ = self->priv->background;
	clutter_actor_destroy ((ClutterActor*) _tmp17_);
	_g_object_unref0 (listener);
	_g_object_unref0 (self->priv->_workspace);
	_g_object_unref0 (self->priv->_gesture_tracker);
	_g_object_unref0 (self->priv->_icon_group);
	_g_object_unref0 (self->priv->_window_container);
	_g_object_unref0 (self->priv->background);
	G_OBJECT_CLASS (gala_workspace_clone_parent_class)->finalize (obj);
}

/**
     * This is the container which manages a clone of the background which will
     * be scaled and animated inwards, a WindowCloneContainer for the windows on
     * this workspace and also holds the instance for this workspace's IconGroup.
     * The latter is not added to the WorkspaceClone itself though but to a container
     * of the MultitaskingView.
     */
static GType
gala_workspace_clone_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWorkspaceCloneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_workspace_clone_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaWorkspaceClone), 0, (GInstanceInitFunc) gala_workspace_clone_instance_init, NULL };
	GType gala_workspace_clone_type_id;
	gala_workspace_clone_type_id = g_type_register_static (clutter_actor_get_type (), "GalaWorkspaceClone", &g_define_type_info, 0);
	GalaWorkspaceClone_private_offset = g_type_add_instance_private (gala_workspace_clone_type_id, sizeof (GalaWorkspaceClonePrivate));
	return gala_workspace_clone_type_id;
}

GType
gala_workspace_clone_get_type (void)
{
	static volatile gsize gala_workspace_clone_type_id__once = 0;
	if (g_once_init_enter (&gala_workspace_clone_type_id__once)) {
		GType gala_workspace_clone_type_id;
		gala_workspace_clone_type_id = gala_workspace_clone_get_type_once ();
		g_once_init_leave (&gala_workspace_clone_type_id__once, gala_workspace_clone_type_id);
	}
	return gala_workspace_clone_type_id__once;
}

static void
_vala_gala_workspace_clone_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	GalaWorkspaceClone * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone);
	switch (property_id) {
		case GALA_WORKSPACE_CLONE_WORKSPACE_PROPERTY:
		g_value_set_object (value, gala_workspace_clone_get_workspace (self));
		break;
		case GALA_WORKSPACE_CLONE_GESTURE_TRACKER_PROPERTY:
		g_value_set_object (value, gala_workspace_clone_get_gesture_tracker (self));
		break;
		case GALA_WORKSPACE_CLONE_ICON_GROUP_PROPERTY:
		g_value_set_object (value, gala_workspace_clone_get_icon_group (self));
		break;
		case GALA_WORKSPACE_CLONE_WINDOW_CONTAINER_PROPERTY:
		g_value_set_object (value, gala_workspace_clone_get_window_container (self));
		break;
		case GALA_WORKSPACE_CLONE_ACTIVE_PROPERTY:
		g_value_set_boolean (value, gala_workspace_clone_get_active (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_workspace_clone_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	GalaWorkspaceClone * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone);
	switch (property_id) {
		case GALA_WORKSPACE_CLONE_WORKSPACE_PROPERTY:
		gala_workspace_clone_set_workspace (self, g_value_get_object (value));
		break;
		case GALA_WORKSPACE_CLONE_GESTURE_TRACKER_PROPERTY:
		gala_workspace_clone_set_gesture_tracker (self, g_value_get_object (value));
		break;
		case GALA_WORKSPACE_CLONE_ICON_GROUP_PROPERTY:
		gala_workspace_clone_set_icon_group (self, g_value_get_object (value));
		break;
		case GALA_WORKSPACE_CLONE_WINDOW_CONTAINER_PROPERTY:
		gala_workspace_clone_set_window_container (self, g_value_get_object (value));
		break;
		case GALA_WORKSPACE_CLONE_ACTIVE_PROPERTY:
		gala_workspace_clone_set_active (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

