/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import java.util.Map;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;

public class PWmatReader
extends AtomSetCollectionReader {
    private int nAtoms;
    private boolean haveLattice;
    private boolean havePositions;
    private boolean haveMagnetic = false;

    @Override
    protected void initializeReader() throws Exception {
        this.doApplySymmetry = true;
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.nAtoms == 0) {
            this.setSpaceGroupName("P1");
            this.nAtoms = PT.parseInt(this.line);
            this.setFractionalCoordinates(true);
            return true;
        }
        this.removeComments();
        String lc = this.line.toLowerCase().trim();
        if (lc.length() == 0) {
            return true;
        }
        if (!this.haveLattice) {
            if (lc.startsWith("lattice")) {
                this.readUnitCell();
                this.haveLattice = true;
            }
            return true;
        }
        if (!this.havePositions) {
            if (lc.startsWith("position")) {
                this.readCoordinates();
                this.havePositions = true;
            }
            return true;
        }
        this.readDataBlock(lc);
        return true;
    }

    private void readUnitCell() throws Exception {
        float[] unitCellData = new float[3];
        this.addExplicitLatticeVector(0, this.fillFloatArray(this.getLine(), 0, unitCellData), 0);
        this.addExplicitLatticeVector(1, this.fillFloatArray(this.getLine(), 0, unitCellData), 0);
        this.addExplicitLatticeVector(2, this.fillFloatArray(this.getLine(), 0, unitCellData), 0);
    }

    private void readCoordinates() throws Exception {
        Lst<float[]> constraints = new Lst<float[]>();
        boolean haveConstraints = true;
        int i = 0;
        while (i++ < this.nAtoms && this.getLine() != null) {
            String[] tokens = this.getTokens();
            this.addAtomXYZSymName(tokens, 1, null, PWmatReader.getElementSymbol(Integer.parseInt(tokens[0])));
            haveConstraints = tokens.length >= 7 && haveConstraints;
            if (!haveConstraints) continue;
            constraints.addLast(new float[]{Float.parseFloat(tokens[4]), Float.parseFloat(tokens[5]), Float.parseFloat(tokens[6])});
        }
        float[] cx = new float[this.nAtoms];
        float[] cy = new float[this.nAtoms];
        float[] cz = new float[this.nAtoms];
        float[] c = new float[]{1.0f, 1.0f, 1.0f};
        i = this.nAtoms;
        while (--i >= 0) {
            if (haveConstraints) {
                c = (float[])constraints.get(i);
            }
            cx[i] = c[0];
            cy[i] = c[1];
            cz[i] = c[2];
        }
        this.setVectors("constraints", cx, cy, cz, this.nAtoms);
    }

    private void readDataBlock(String name) throws Exception {
        this.getLine();
        String[] tokens = this.getTokens();
        switch (tokens.length) {
            case 1: 
            case 2: 
            case 3: {
                this.readItems(name, tokens.length - 1, null);
                break;
            }
            case 4: {
                this.readVectors(name, 1, true);
                break;
            }
            default: {
                Logger.error("PWmatReader block " + name.toUpperCase() + " ignored");
            }
        }
    }

    private void readItems(String name, int offset, float[] values) throws Exception {
        if (name.equalsIgnoreCase("magnetic")) {
            this.haveMagnetic = true;
        }
        name = "pwm_" + name;
        if (values == null) {
            values = new float[this.nAtoms];
        } else {
            this.getLine();
        }
        int n = 0;
        int i = 0;
        while (true) {
            String[] tokens;
            if ((values[i] = Float.parseFloat((tokens = this.getTokens())[offset])) != 0.0f) {
                ++n;
            }
            if (++i == this.nAtoms) break;
            this.getLine();
        }
        this.setProperties(name, values, this.asc.iSet, n);
    }

    private void setProperties(String name, float[] values, int iSet, int n) {
        this.asc.setAtomProperties(name, values, this.asc.iSet, false);
        Logger.info("PWmatReader: " + name.toUpperCase() + " processed for " + n + " atoms");
        this.appendLoadNote("PWmatReader read property_" + name);
    }

    private void readVectors(String name, int offset, boolean haveLine) throws Exception {
        if (!haveLine) {
            this.getLine();
        }
        float[] valuesX = new float[this.nAtoms];
        float[] valuesY = new float[this.nAtoms];
        float[] valuesZ = new float[this.nAtoms];
        int n = 0;
        int i = 0;
        while (true) {
            String[] tokens;
            valuesY[i] = Float.parseFloat(tokens[offset + 1]);
            valuesZ[i] = Float.parseFloat(tokens[offset + 2]);
            tokens = this.getTokens();
            valuesX[i] = Float.parseFloat(tokens[offset]);
            if (valuesX[i] != 0.0f | valuesY[i] != 0.0f | valuesZ[i] != 0.0f) {
                ++n;
            }
            if (++i == this.nAtoms) break;
            this.getLine();
        }
        this.setVectors(name, valuesX, valuesY, valuesZ, n);
    }

    private String getLine() throws Exception {
        this.rd();
        return this.removeComments();
    }

    private String removeComments() {
        int pt;
        if (this.line != null && (pt = this.line.indexOf("#")) >= 0) {
            this.line = this.line.substring(0, pt).trim();
        }
        return this.line;
    }

    private void setVectors(String name, float[] valuesX, float[] valuesY, float[] valuesZ, int n) {
        name = "pwm_" + name;
        this.asc.setAtomProperties(name + "_x", valuesX, this.asc.iSet, false);
        this.asc.setAtomProperties(name + "_y", valuesY, this.asc.iSet, false);
        this.asc.setAtomProperties(name + "_z", valuesZ, this.asc.iSet, false);
        Logger.info("PWmatReader: " + name.toUpperCase() + " processed for " + n + " atoms");
        this.appendLoadNote("PWmatReader read property_" + name + "_x/_y/_z");
        if (name.equals("pwm_magnetic_xyz")) {
            for (int i = 0; i < this.nAtoms; ++i) {
                this.asc.addVibrationVector(i, valuesX[i], valuesY[i], valuesZ[i]);
            }
            this.addJmolScript("vectors 0.2;set vectorscentered");
        }
    }

    @Override
    public void applySymmetryAndSetTrajectory() throws Exception {
        super.applySymmetryAndSetTrajectory();
        if (this.nAtoms != this.asc.ac) {
            this.nAtoms = this.asc.ac;
            Map p = (Map)this.asc.getAtomSetAuxiliaryInfoValue(this.asc.iSet, "atomProperties");
            if (p != null) {
                Atom[] atoms = this.asc.atoms;
                for (Map.Entry entry : p.entrySet()) {
                    String key = (String)entry.getKey();
                    if (!key.startsWith("pwm_")) continue;
                    float[] af = (float[])entry.getValue();
                    float[] af2 = new float[this.nAtoms];
                    for (int j = 0; j < this.nAtoms; ++j) {
                        af2[j] = af[atoms[j].atomSite];
                    }
                    entry.setValue(af2);
                }
            }
        }
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        if (!this.haveMagnetic) {
            this.setProperties("pwm_magnetic", new float[this.asc.ac], this.nAtoms, this.nAtoms);
        }
    }
}

