from typing import Any
from typing_extensions import Literal

class UnknownLocaleError(Exception):
    identifier: Any
    def __init__(self, identifier) -> None: ...

class Locale:
    language: Any
    territory: Any
    script: Any
    variant: Any
    def __init__(self, language, territory: Any | None = ..., script: Any | None = ..., variant: Any | None = ...) -> None: ...
    @classmethod
    def default(cls, category: Any | None = ..., aliases=...): ...
    @classmethod
    def negotiate(cls, preferred, available, sep: str = ..., aliases=...): ...
    @classmethod
    def parse(cls, identifier, sep: str = ..., resolve_likely_subtags: bool = ...): ...
    def __eq__(self, other): ...
    def __ne__(self, other): ...
    def __hash__(self): ...
    def get_display_name(self, locale: Any | None = ...): ...
    @property
    def display_name(self): ...
    def get_language_name(self, locale: Any | None = ...): ...
    @property
    def language_name(self): ...
    def get_territory_name(self, locale: Any | None = ...): ...
    @property
    def territory_name(self): ...
    def get_script_name(self, locale: Any | None = ...): ...
    @property
    def script_name(self): ...
    @property
    def english_name(self): ...
    @property
    def languages(self): ...
    @property
    def scripts(self): ...
    @property
    def territories(self): ...
    @property
    def variants(self): ...
    @property
    def currencies(self): ...
    @property
    def currency_symbols(self): ...
    @property
    def number_symbols(self): ...
    @property
    def decimal_formats(self): ...
    @property
    def currency_formats(self): ...
    @property
    def percent_formats(self): ...
    @property
    def scientific_formats(self): ...
    @property
    def periods(self): ...
    @property
    def day_periods(self): ...
    @property
    def day_period_rules(self): ...
    @property
    def days(self): ...
    @property
    def months(self): ...
    @property
    def quarters(self): ...
    @property
    def eras(self): ...
    @property
    def time_zones(self): ...
    @property
    def meta_zones(self): ...
    @property
    def zone_formats(self): ...
    @property
    def first_week_day(self): ...
    @property
    def weekend_start(self): ...
    @property
    def weekend_end(self): ...
    @property
    def min_week_days(self): ...
    @property
    def date_formats(self): ...
    @property
    def time_formats(self): ...
    @property
    def datetime_formats(self): ...
    @property
    def datetime_skeletons(self): ...
    @property
    def interval_formats(self): ...
    @property
    def plural_form(self): ...
    @property
    def list_patterns(self): ...
    @property
    def ordinal_form(self): ...
    @property
    def measurement_systems(self): ...
    @property
    def character_order(self): ...
    @property
    def text_direction(self): ...
    @property
    def unit_display_names(self): ...

def default_locale(category: Any | None = ..., aliases=...): ...
def negotiate_locale(preferred, available, sep: str = ..., aliases=...): ...
def parse_locale(identifier, sep: str = ...): ...
def get_locale_identifier(tup, sep: str = ...): ...
def get_global(key: _GLOBAL_KEY): ...

_GLOBAL_KEY = Literal[
    "all_currencies",
    "currency_fractions",
    "language_aliases",
    "likely_subtags",
    "parent_exceptions",
    "script_aliases",
    "territory_aliases",
    "territory_currencies",
    "territory_languages",
    "territory_zones",
    "variant_aliases",
    "windows_zone_mapping",
    "zone_aliases",
    "zone_territories",
]
