// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from stm32l562.svd, see https://github.com/tinygo-org/stm32-svd

//go:build stm32 && stm32l562
// +build stm32,stm32l562

// STM32L562
//

package stm32

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "STM32L562"
	CPU          = "CM33"
	FPUPresent   = true
	NVICPrioBits = 3
)

// Interrupt numbers.
const (
	// System window watchdog
	IRQ_WWDG = 0

	// External interrupt/event controller
	IRQ_PVD_PVM = 1

	// Real-time clock
	IRQ_RTC = 2

	// Real-time clock
	IRQ_RTC_S = 3

	// External interrupt/event controller
	IRQ_TAMP = 4

	// External interrupt/event controller
	IRQ_TAMP_S = 5

	// Flash
	IRQ_FLASH = 6

	// Flash
	IRQ_FLASH_S = 7

	// Reset and clock control
	IRQ_RCC = 9

	// Reset and clock control
	IRQ_RCC_S = 10

	// External interrupt/event controller
	IRQ_EXTI0 = 11

	// External interrupt/event controller
	IRQ_EXTI1 = 12

	// External interrupt/event controller
	IRQ_EXTI2 = 13

	// External interrupt/event controller
	IRQ_EXTI3 = 14

	// External interrupt/event controller
	IRQ_EXTI4 = 15

	// External interrupt/event controller
	IRQ_EXTI5 = 16

	// External interrupt/event controller
	IRQ_EXTI6 = 17

	// External interrupt/event controller
	IRQ_EXTI7 = 18

	// External interrupt/event controller
	IRQ_EXTI8 = 19

	// External interrupt/event controller
	IRQ_EXTI9 = 20

	// External interrupt/event controller
	IRQ_EXTI10 = 21

	// External interrupt/event controller
	IRQ_EXTI11 = 22

	// External interrupt/event controller
	IRQ_EXTI12 = 23

	// External interrupt/event controller
	IRQ_EXTI13 = 24

	// External interrupt/event controller
	IRQ_EXTI14 = 25

	// External interrupt/event controller
	IRQ_EXTI15 = 26

	// Direct memory access Multiplexer
	IRQ_DMAMUX1_OVR = 27

	// Direct memory access Multiplexer
	IRQ_DMAMUX1_OVR_S = 28

	// Direct memory access controller
	IRQ_DMA1_CH1 = 29

	// Direct memory access controller
	IRQ_DMA1_CH2 = 30

	// Direct memory access controller
	IRQ_DMA1_CH3 = 31

	// Direct memory access controller
	IRQ_DMA1_CH4 = 32

	// Direct memory access controller
	IRQ_DMA1_CH5 = 33

	// Direct memory access controller
	IRQ_DMA1_CH6 = 34

	// Direct memory access controller
	IRQ_DMA1_CH7 = 35

	// Direct memory access controller
	IRQ_DMA1_Channel8 = 36

	// Analog-to-Digital Converter
	IRQ_ADC1_2 = 37

	// FDCAN1
	IRQ_FDCAN1_IT0 = 39

	// FDCAN1
	IRQ_FDCAN1_IT1 = 40

	// Advanced-timers
	IRQ_TIM1_BRK = 41

	// Advanced-timers
	IRQ_TIM1_UP = 42

	// Advanced-timers
	IRQ_TIM1_TRG_COM = 43

	// Advanced-timers
	IRQ_TIM1_CC = 44

	// General-purpose-timers
	IRQ_TIM2 = 45

	// General-purpose-timers
	IRQ_TIM3 = 46

	// General-purpose-timers
	IRQ_TIM4 = 47

	IRQ_TIM5 = 48

	// General-purpose-timers
	IRQ_TIM6 = 49

	// General-purpose-timers
	IRQ_TIM7 = 50

	// Advanced-timers
	IRQ_TIM8_BRK = 51

	// Advanced-timers
	IRQ_TIM8_UP = 52

	// Advanced-timers
	IRQ_TIM8_TRG_COM = 53

	// Advanced-timers
	IRQ_TIM8_CC = 54

	// Inter-integrated circuit
	IRQ_I2C1_EV = 55

	// Inter-integrated circuit
	IRQ_I2C1_ER = 56

	IRQ_I2C2_EV = 57

	IRQ_I2C2_ER = 58

	// Serial peripheral interface
	IRQ_SPI1 = 59

	IRQ_SPI2 = 60

	// Universal synchronous asynchronous receiver transmitter
	IRQ_USART1 = 61

	IRQ_USART2 = 62

	IRQ_USART3 = 63

	IRQ_UART4 = 64

	IRQ_UART5 = 65

	// Universal synchronous asynchronous receiver transmitter
	IRQ_LPUART1 = 66

	// Low power timer
	IRQ_LPTIM1 = 67

	// Low power timer
	IRQ_LPTIM2 = 68

	// General purpose timers
	IRQ_TIM15 = 69

	// General purpose timers
	IRQ_TIM16 = 70

	// General purpose timers
	IRQ_TIM17 = 71

	// Comparator
	IRQ_COMP = 72

	// Universal serial bus full-speed device interface
	IRQ_USB_FS = 73

	// FMC
	IRQ_FMC = 75

	// OctoSPI
	IRQ_OCTOSPI1 = 76

	// SDMMC1
	IRQ_SDMMC1 = 78

	IRQ_DMA2_CH1 = 80

	IRQ_DMA2_CH2 = 81

	IRQ_DMA2_CH3 = 82

	IRQ_DMA2_CH4 = 83

	IRQ_DMA2_CH5 = 84

	IRQ_DMA2_CH6 = 85

	IRQ_DMA2_CH7 = 86

	IRQ_DMA2_CH8 = 87

	IRQ_I2C3_EV = 88

	IRQ_I2C3_ER = 89

	// Serial audio interface
	IRQ_SAI1 = 90

	IRQ_SAI2 = 91

	// Touch sensing controller
	IRQ_TSC = 92

	// Advanced encryption standard hardware accelerator 1
	IRQ_AES = 93

	// RNG
	IRQ_RNG = 94

	// PKA
	IRQ_PKA = 97

	IRQ_LPTIM3 = 98

	IRQ_SPI3 = 99

	IRQ_I2C4_ER = 100

	IRQ_I2C4_EV = 101

	// Digital filter for sigma delta modulators
	IRQ_DFSDM1_FLT0 = 102

	// Digital filter for sigma delta modulators
	IRQ_DFSDM1_FLT1 = 103

	// Digital filter for sigma delta modulators
	IRQ_DFSDM1_FLT2 = 104

	// Digital filter for sigma delta modulators
	IRQ_DFSDM1_FLT3 = 105

	// USB Power Delivery interface
	IRQ_UCPD1 = 106

	// ICache
	IRQ_ICACHE = 107

	// On-The-Fly Decryption engine
	IRQ_OTFDEC1 = 108

	// Highest interrupt number on this device.
	IRQ_max = 108
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export WWDG_IRQHandler
func interruptWWDG() {
	callHandlers(IRQ_WWDG)
}

//export PVD_PVM_IRQHandler
func interruptPVD_PVM() {
	callHandlers(IRQ_PVD_PVM)
}

//export RTC_IRQHandler
func interruptRTC() {
	callHandlers(IRQ_RTC)
}

//export RTC_S_IRQHandler
func interruptRTC_S() {
	callHandlers(IRQ_RTC_S)
}

//export TAMP_IRQHandler
func interruptTAMP() {
	callHandlers(IRQ_TAMP)
}

//export TAMP_S_IRQHandler
func interruptTAMP_S() {
	callHandlers(IRQ_TAMP_S)
}

//export FLASH_IRQHandler
func interruptFLASH() {
	callHandlers(IRQ_FLASH)
}

//export FLASH_S_IRQHandler
func interruptFLASH_S() {
	callHandlers(IRQ_FLASH_S)
}

//export RCC_IRQHandler
func interruptRCC() {
	callHandlers(IRQ_RCC)
}

//export RCC_S_IRQHandler
func interruptRCC_S() {
	callHandlers(IRQ_RCC_S)
}

//export EXTI0_IRQHandler
func interruptEXTI0() {
	callHandlers(IRQ_EXTI0)
}

//export EXTI1_IRQHandler
func interruptEXTI1() {
	callHandlers(IRQ_EXTI1)
}

//export EXTI2_IRQHandler
func interruptEXTI2() {
	callHandlers(IRQ_EXTI2)
}

//export EXTI3_IRQHandler
func interruptEXTI3() {
	callHandlers(IRQ_EXTI3)
}

//export EXTI4_IRQHandler
func interruptEXTI4() {
	callHandlers(IRQ_EXTI4)
}

//export EXTI5_IRQHandler
func interruptEXTI5() {
	callHandlers(IRQ_EXTI5)
}

//export EXTI6_IRQHandler
func interruptEXTI6() {
	callHandlers(IRQ_EXTI6)
}

//export EXTI7_IRQHandler
func interruptEXTI7() {
	callHandlers(IRQ_EXTI7)
}

//export EXTI8_IRQHandler
func interruptEXTI8() {
	callHandlers(IRQ_EXTI8)
}

//export EXTI9_IRQHandler
func interruptEXTI9() {
	callHandlers(IRQ_EXTI9)
}

//export EXTI10_IRQHandler
func interruptEXTI10() {
	callHandlers(IRQ_EXTI10)
}

//export EXTI11_IRQHandler
func interruptEXTI11() {
	callHandlers(IRQ_EXTI11)
}

//export EXTI12_IRQHandler
func interruptEXTI12() {
	callHandlers(IRQ_EXTI12)
}

//export EXTI13_IRQHandler
func interruptEXTI13() {
	callHandlers(IRQ_EXTI13)
}

//export EXTI14_IRQHandler
func interruptEXTI14() {
	callHandlers(IRQ_EXTI14)
}

//export EXTI15_IRQHandler
func interruptEXTI15() {
	callHandlers(IRQ_EXTI15)
}

//export DMAMUX1_OVR_IRQHandler
func interruptDMAMUX1_OVR() {
	callHandlers(IRQ_DMAMUX1_OVR)
}

//export DMAMUX1_OVR_S_IRQHandler
func interruptDMAMUX1_OVR_S() {
	callHandlers(IRQ_DMAMUX1_OVR_S)
}

//export DMA1_CH1_IRQHandler
func interruptDMA1_CH1() {
	callHandlers(IRQ_DMA1_CH1)
}

//export DMA1_CH2_IRQHandler
func interruptDMA1_CH2() {
	callHandlers(IRQ_DMA1_CH2)
}

//export DMA1_CH3_IRQHandler
func interruptDMA1_CH3() {
	callHandlers(IRQ_DMA1_CH3)
}

//export DMA1_CH4_IRQHandler
func interruptDMA1_CH4() {
	callHandlers(IRQ_DMA1_CH4)
}

//export DMA1_CH5_IRQHandler
func interruptDMA1_CH5() {
	callHandlers(IRQ_DMA1_CH5)
}

//export DMA1_CH6_IRQHandler
func interruptDMA1_CH6() {
	callHandlers(IRQ_DMA1_CH6)
}

//export DMA1_CH7_IRQHandler
func interruptDMA1_CH7() {
	callHandlers(IRQ_DMA1_CH7)
}

//export DMA1_Channel8_IRQHandler
func interruptDMA1_Channel8() {
	callHandlers(IRQ_DMA1_Channel8)
}

//export ADC1_2_IRQHandler
func interruptADC1_2() {
	callHandlers(IRQ_ADC1_2)
}

//export FDCAN1_IT0_IRQHandler
func interruptFDCAN1_IT0() {
	callHandlers(IRQ_FDCAN1_IT0)
}

//export FDCAN1_IT1_IRQHandler
func interruptFDCAN1_IT1() {
	callHandlers(IRQ_FDCAN1_IT1)
}

//export TIM1_BRK_IRQHandler
func interruptTIM1_BRK() {
	callHandlers(IRQ_TIM1_BRK)
}

//export TIM1_UP_IRQHandler
func interruptTIM1_UP() {
	callHandlers(IRQ_TIM1_UP)
}

//export TIM1_TRG_COM_IRQHandler
func interruptTIM1_TRG_COM() {
	callHandlers(IRQ_TIM1_TRG_COM)
}

//export TIM1_CC_IRQHandler
func interruptTIM1_CC() {
	callHandlers(IRQ_TIM1_CC)
}

//export TIM2_IRQHandler
func interruptTIM2() {
	callHandlers(IRQ_TIM2)
}

//export TIM3_IRQHandler
func interruptTIM3() {
	callHandlers(IRQ_TIM3)
}

//export TIM4_IRQHandler
func interruptTIM4() {
	callHandlers(IRQ_TIM4)
}

//export TIM5_IRQHandler
func interruptTIM5() {
	callHandlers(IRQ_TIM5)
}

//export TIM6_IRQHandler
func interruptTIM6() {
	callHandlers(IRQ_TIM6)
}

//export TIM7_IRQHandler
func interruptTIM7() {
	callHandlers(IRQ_TIM7)
}

//export TIM8_BRK_IRQHandler
func interruptTIM8_BRK() {
	callHandlers(IRQ_TIM8_BRK)
}

//export TIM8_UP_IRQHandler
func interruptTIM8_UP() {
	callHandlers(IRQ_TIM8_UP)
}

//export TIM8_TRG_COM_IRQHandler
func interruptTIM8_TRG_COM() {
	callHandlers(IRQ_TIM8_TRG_COM)
}

//export TIM8_CC_IRQHandler
func interruptTIM8_CC() {
	callHandlers(IRQ_TIM8_CC)
}

//export I2C1_EV_IRQHandler
func interruptI2C1_EV() {
	callHandlers(IRQ_I2C1_EV)
}

//export I2C1_ER_IRQHandler
func interruptI2C1_ER() {
	callHandlers(IRQ_I2C1_ER)
}

//export I2C2_EV_IRQHandler
func interruptI2C2_EV() {
	callHandlers(IRQ_I2C2_EV)
}

//export I2C2_ER_IRQHandler
func interruptI2C2_ER() {
	callHandlers(IRQ_I2C2_ER)
}

//export SPI1_IRQHandler
func interruptSPI1() {
	callHandlers(IRQ_SPI1)
}

//export SPI2_IRQHandler
func interruptSPI2() {
	callHandlers(IRQ_SPI2)
}

//export USART1_IRQHandler
func interruptUSART1() {
	callHandlers(IRQ_USART1)
}

//export USART2_IRQHandler
func interruptUSART2() {
	callHandlers(IRQ_USART2)
}

//export USART3_IRQHandler
func interruptUSART3() {
	callHandlers(IRQ_USART3)
}

//export UART4_IRQHandler
func interruptUART4() {
	callHandlers(IRQ_UART4)
}

//export UART5_IRQHandler
func interruptUART5() {
	callHandlers(IRQ_UART5)
}

//export LPUART1_IRQHandler
func interruptLPUART1() {
	callHandlers(IRQ_LPUART1)
}

//export LPTIM1_IRQHandler
func interruptLPTIM1() {
	callHandlers(IRQ_LPTIM1)
}

//export LPTIM2_IRQHandler
func interruptLPTIM2() {
	callHandlers(IRQ_LPTIM2)
}

//export TIM15_IRQHandler
func interruptTIM15() {
	callHandlers(IRQ_TIM15)
}

//export TIM16_IRQHandler
func interruptTIM16() {
	callHandlers(IRQ_TIM16)
}

//export TIM17_IRQHandler
func interruptTIM17() {
	callHandlers(IRQ_TIM17)
}

//export COMP_IRQHandler
func interruptCOMP() {
	callHandlers(IRQ_COMP)
}

//export USB_FS_IRQHandler
func interruptUSB_FS() {
	callHandlers(IRQ_USB_FS)
}

//export FMC_IRQHandler
func interruptFMC() {
	callHandlers(IRQ_FMC)
}

//export OCTOSPI1_IRQHandler
func interruptOCTOSPI1() {
	callHandlers(IRQ_OCTOSPI1)
}

//export SDMMC1_IRQHandler
func interruptSDMMC1() {
	callHandlers(IRQ_SDMMC1)
}

//export DMA2_CH1_IRQHandler
func interruptDMA2_CH1() {
	callHandlers(IRQ_DMA2_CH1)
}

//export DMA2_CH2_IRQHandler
func interruptDMA2_CH2() {
	callHandlers(IRQ_DMA2_CH2)
}

//export DMA2_CH3_IRQHandler
func interruptDMA2_CH3() {
	callHandlers(IRQ_DMA2_CH3)
}

//export DMA2_CH4_IRQHandler
func interruptDMA2_CH4() {
	callHandlers(IRQ_DMA2_CH4)
}

//export DMA2_CH5_IRQHandler
func interruptDMA2_CH5() {
	callHandlers(IRQ_DMA2_CH5)
}

//export DMA2_CH6_IRQHandler
func interruptDMA2_CH6() {
	callHandlers(IRQ_DMA2_CH6)
}

//export DMA2_CH7_IRQHandler
func interruptDMA2_CH7() {
	callHandlers(IRQ_DMA2_CH7)
}

//export DMA2_CH8_IRQHandler
func interruptDMA2_CH8() {
	callHandlers(IRQ_DMA2_CH8)
}

//export I2C3_EV_IRQHandler
func interruptI2C3_EV() {
	callHandlers(IRQ_I2C3_EV)
}

//export I2C3_ER_IRQHandler
func interruptI2C3_ER() {
	callHandlers(IRQ_I2C3_ER)
}

//export SAI1_IRQHandler
func interruptSAI1() {
	callHandlers(IRQ_SAI1)
}

//export SAI2_IRQHandler
func interruptSAI2() {
	callHandlers(IRQ_SAI2)
}

//export TSC_IRQHandler
func interruptTSC() {
	callHandlers(IRQ_TSC)
}

//export AES_IRQHandler
func interruptAES() {
	callHandlers(IRQ_AES)
}

//export RNG_IRQHandler
func interruptRNG() {
	callHandlers(IRQ_RNG)
}

//export PKA_IRQHandler
func interruptPKA() {
	callHandlers(IRQ_PKA)
}

//export LPTIM3_IRQHandler
func interruptLPTIM3() {
	callHandlers(IRQ_LPTIM3)
}

//export SPI3_IRQHandler
func interruptSPI3() {
	callHandlers(IRQ_SPI3)
}

//export I2C4_ER_IRQHandler
func interruptI2C4_ER() {
	callHandlers(IRQ_I2C4_ER)
}

//export I2C4_EV_IRQHandler
func interruptI2C4_EV() {
	callHandlers(IRQ_I2C4_EV)
}

//export DFSDM1_FLT0_IRQHandler
func interruptDFSDM1_FLT0() {
	callHandlers(IRQ_DFSDM1_FLT0)
}

//export DFSDM1_FLT1_IRQHandler
func interruptDFSDM1_FLT1() {
	callHandlers(IRQ_DFSDM1_FLT1)
}

//export DFSDM1_FLT2_IRQHandler
func interruptDFSDM1_FLT2() {
	callHandlers(IRQ_DFSDM1_FLT2)
}

//export DFSDM1_FLT3_IRQHandler
func interruptDFSDM1_FLT3() {
	callHandlers(IRQ_DFSDM1_FLT3)
}

//export UCPD1_IRQHandler
func interruptUCPD1() {
	callHandlers(IRQ_UCPD1)
}

//export ICACHE_IRQHandler
func interruptICACHE() {
	callHandlers(IRQ_ICACHE)
}

//export OTFDEC1_IRQHandler
func interruptOTFDEC1() {
	callHandlers(IRQ_OTFDEC1)
}

// Peripherals.
var (
	// Debug Control Block
	DCB = (*DCB_Type)(unsafe.Pointer(uintptr(0xe000ee08)))

	// Digital filter for sigma delta modulators
	DFSDM1 = (*DFSDM_Type)(unsafe.Pointer(uintptr(0x40016000)))

	// Direct memory access Multiplexer
	DMAMUX1 = (*DMAMUX_Type)(unsafe.Pointer(uintptr(0x40020800)))

	// External interrupt/event controller
	EXTI = (*EXTI_Type)(unsafe.Pointer(uintptr(0x4002f400)))

	// External interrupt/event controller
	SEC_EXTI = (*EXTI_Type)(unsafe.Pointer(uintptr(0x5002f400)))

	// Flash
	FLASH = (*Flash_Type)(unsafe.Pointer(uintptr(0x40022000)))

	// General-purpose I/Os
	GPIOA = (*GPIO_Type)(unsafe.Pointer(uintptr(0x42020000)))

	// General-purpose I/Os
	GPIOB = (*GPIO_Type)(unsafe.Pointer(uintptr(0x42020400)))

	// General-purpose I/Os
	GPIOC = (*GPIO_Type)(unsafe.Pointer(uintptr(0x42020800)))

	// General-purpose I/Os
	GPIOH = (*GPIO_Type)(unsafe.Pointer(uintptr(0x42021c00)))

	// Tamper and backup registers
	TAMP = (*TAMP_Type)(unsafe.Pointer(uintptr(0x40003400)))

	// Tamper and backup registers
	SEC_TAMP = (*TAMP_Type)(unsafe.Pointer(uintptr(0x50003400)))

	// Inter-integrated circuit
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005400)))

	// ICache
	ICache = (*ICache_Type)(unsafe.Pointer(uintptr(0x40030400)))

	// ICache
	SEC_ICache = (*ICache_Type)(unsafe.Pointer(uintptr(0x50030400)))

	// Independent watchdog
	IWDG = (*IWDG_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// Independent watchdog
	SEC_IWDG = (*IWDG_Type)(unsafe.Pointer(uintptr(0x50003000)))

	// Low power timer
	LPTIM1 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40007c00)))

	// GTZC_MPCBB1
	GTZC_MPCBB1 = (*GTZC_Type)(unsafe.Pointer(uintptr(0x40032c00)))

	// GTZC_MPCBB2
	GTZC_MPCBB2 = (*GTZC_Type)(unsafe.Pointer(uintptr(0x40033000)))

	// Power control
	PWR = (*PWR_Type)(unsafe.Pointer(uintptr(0x40007000)))

	// Power control
	SEC_PWR = (*PWR_Type)(unsafe.Pointer(uintptr(0x50007000)))

	// Reset and clock control
	RCC = (*RCC_Type)(unsafe.Pointer(uintptr(0x40021000)))

	// Reset and clock control
	SEC_RCC = (*RCC_Type)(unsafe.Pointer(uintptr(0x50021000)))

	// Real-time clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x40002800)))

	// Real-time clock
	SEC_RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x50002800)))

	// Serial audio interface
	SAI1 = (*SAI_Type)(unsafe.Pointer(uintptr(0x40015400)))

	// Direct memory access controller
	DMA1 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// SEC_GTZC_MPCBB1
	SEC_GTZC_MPCBB1 = (*SEC_GTZC_Type)(unsafe.Pointer(uintptr(0x50032c00)))

	// SEC_GTZC_MPCBB2
	SEC_GTZC_MPCBB2 = (*SEC_GTZC_Type)(unsafe.Pointer(uintptr(0x50033000)))

	// Serial peripheral interface
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013000)))

	// Advanced-timers
	TIM1 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40012c00)))

	// General purpose timers
	TIM15 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// General purpose timers
	TIM16 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014400)))

	// General purpose timers
	TIM17 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014800)))

	// General-purpose-timers
	TIM2 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// General-purpose-timers
	TIM3 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000400)))

	// General-purpose-timers
	TIM4 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000800)))

	// General-purpose-timers
	TIM6 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001000)))

	// General-purpose-timers
	TIM7 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001400)))

	// DAC
	DAC = (*DAC_Type)(unsafe.Pointer(uintptr(0x40007400)))

	// DAC
	SEC_DAC = (*DAC_Type)(unsafe.Pointer(uintptr(0x50007400)))

	// Operational amplifiers
	OPAMP = (*OPAMP_Type)(unsafe.Pointer(uintptr(0x40007800)))

	// Operational amplifiers
	SEC_OPAMP = (*OPAMP_Type)(unsafe.Pointer(uintptr(0x50007800)))

	// Advanced encryption standard hardware accelerator 1
	AES = (*AES_Type)(unsafe.Pointer(uintptr(0x420c0000)))

	// Advanced encryption standard hardware accelerator 1
	SEC_AES = (*AES_Type)(unsafe.Pointer(uintptr(0x520c0000)))

	// PKA
	PKA = (*PKA_Type)(unsafe.Pointer(uintptr(0x420c2000)))

	// PKA
	SEC_PKA = (*PKA_Type)(unsafe.Pointer(uintptr(0x520c2000)))

	// On-The-Fly Decryption engine
	OTFDEC1 = (*OTFDEC_Type)(unsafe.Pointer(uintptr(0x420c5000)))

	// Advanced-timers
	TIM8 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40013400)))

	// GTZC_TZIC
	GTZC_TZIC = (*GTZC_Type)(unsafe.Pointer(uintptr(0x40032800)))

	// GTZC_TZSC
	GTZC_TZSC = (*GTZC_Type)(unsafe.Pointer(uintptr(0x40032400)))

	// System window watchdog
	WWDG = (*WWDG_Type)(unsafe.Pointer(uintptr(0x40002c00)))

	// System window watchdog
	SEC_WWDG = (*WWDG_Type)(unsafe.Pointer(uintptr(0x50002c00)))

	// System configuration controller
	SYSCFG = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// System configuration controller
	SEC_SYSCFG = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0x50010000)))

	// MCU debug component
	DBGMCU = (*DBGMCU_Type)(unsafe.Pointer(uintptr(0xe0044000)))

	// Universal serial bus full-speed device interface
	USB = (*USB_Type)(unsafe.Pointer(uintptr(0x4000d400)))

	// Universal serial bus full-speed device interface
	SEC_USB = (*USB_Type)(unsafe.Pointer(uintptr(0x5000d400)))

	// OctoSPI
	OCTOSPI1 = (*OctoSPI_Type)(unsafe.Pointer(uintptr(0x44021000)))

	// Universal synchronous asynchronous receiver transmitter
	LPUART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// Comparator
	COMP = (*COMP_Type)(unsafe.Pointer(uintptr(0x40010200)))

	// Comparator
	SEC_COMP = (*COMP_Type)(unsafe.Pointer(uintptr(0x50010200)))

	// Voltage reference buffer
	VREFBUF = (*VREF_Type)(unsafe.Pointer(uintptr(0x40010030)))

	// Touch sensing controller
	TSC = (*TSC_Type)(unsafe.Pointer(uintptr(0x40024000)))

	// Touch sensing controller
	SEC_TSC = (*TSC_Type)(unsafe.Pointer(uintptr(0x50024000)))

	// USB Power Delivery interface
	UCPD1 = (*UCPD_Type)(unsafe.Pointer(uintptr(0x4000dc00)))

	// FDCAN1
	FDCAN1 = (*FDCAN_Type)(unsafe.Pointer(uintptr(0x4000a400)))

	// Cyclic redundancy check calculation unit
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x40023000)))

	// Cyclic redundancy check calculation unit
	SEC_CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x50023000)))

	// Clock recovery system
	CRS = (*CRS_Type)(unsafe.Pointer(uintptr(0x40006000)))

	// Clock recovery system
	SEC_CRS = (*CRS_Type)(unsafe.Pointer(uintptr(0x50006000)))

	// Universal synchronous asynchronous receiver transmitter
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40013800)))

	// Analog-to-Digital Converter
	ADC_Common = (*ADC_Type)(unsafe.Pointer(uintptr(0x42028300)))

	// Analog-to-Digital Converter
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0x42028000)))

	// Analog-to-Digital Converter
	SEC_ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0x52028000)))

	// Nested Vectored Interrupt Controller
	NVIC = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))

	// Nested vectored interrupt controller
	NVIC_STIR = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000ef00)))

	// FMC
	FMC = (*FMC_Type)(unsafe.Pointer(uintptr(0x44020000)))

	// FMC
	SEC_FMC = (*FMC_Type)(unsafe.Pointer(uintptr(0x54020000)))

	// RNG
	RNG = (*RNG_Type)(unsafe.Pointer(uintptr(0x420c0800)))

	// RNG
	SEC_RNG = (*RNG_Type)(unsafe.Pointer(uintptr(0x520c0800)))

	// SDMMC1
	SDMMC1 = (*SDMMC_Type)(unsafe.Pointer(uintptr(0x420c8000)))

	// Digital filter for sigma delta modulators
	SEC_DFSDM1 = (*DFSDM_Type)(unsafe.Pointer(uintptr(0x50016000)))

	// Direct memory access Multiplexer
	SEC_DMAMUX1 = (*DMAMUX_Type)(unsafe.Pointer(uintptr(0x50020800)))

	// Flash
	SEC_FLASH = (*Flash_Type)(unsafe.Pointer(uintptr(0x50022000)))

	// General-purpose I/Os
	SEC_GPIOA = (*GPIO_Type)(unsafe.Pointer(uintptr(0x52020000)))

	// General-purpose I/Os
	SEC_GPIOB = (*GPIO_Type)(unsafe.Pointer(uintptr(0x52020400)))

	// General-purpose I/Os
	GPIOD = (*GPIO_Type)(unsafe.Pointer(uintptr(0x42020c00)))

	// General-purpose I/Os
	GPIOE = (*GPIO_Type)(unsafe.Pointer(uintptr(0x42021000)))

	// General-purpose I/Os
	GPIOF = (*GPIO_Type)(unsafe.Pointer(uintptr(0x42021400)))

	// General-purpose I/Os
	GPIOG = (*GPIO_Type)(unsafe.Pointer(uintptr(0x42021800)))

	// General-purpose I/Os
	SEC_GPIOC = (*GPIO_Type)(unsafe.Pointer(uintptr(0x52020800)))

	// General-purpose I/Os
	SEC_GPIOD = (*GPIO_Type)(unsafe.Pointer(uintptr(0x52020c00)))

	// General-purpose I/Os
	SEC_GPIOE = (*GPIO_Type)(unsafe.Pointer(uintptr(0x52021000)))

	// General-purpose I/Os
	SEC_GPIOF = (*GPIO_Type)(unsafe.Pointer(uintptr(0x52021400)))

	// General-purpose I/Os
	SEC_GPIOG = (*GPIO_Type)(unsafe.Pointer(uintptr(0x52021800)))

	// General-purpose I/Os
	SEC_GPIOH = (*GPIO_Type)(unsafe.Pointer(uintptr(0x52021c00)))

	// Inter-integrated circuit
	I2C2 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005800)))

	// Inter-integrated circuit
	I2C3 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005c00)))

	// Inter-integrated circuit
	I2C4 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40008400)))

	// Inter-integrated circuit
	SEC_I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x50005400)))

	// Inter-integrated circuit
	SEC_I2C2 = (*I2C_Type)(unsafe.Pointer(uintptr(0x50005800)))

	// Inter-integrated circuit
	SEC_I2C3 = (*I2C_Type)(unsafe.Pointer(uintptr(0x50005c00)))

	// Inter-integrated circuit
	SEC_I2C4 = (*I2C_Type)(unsafe.Pointer(uintptr(0x50008400)))

	// Low power timer
	LPTIM2 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40009400)))

	// Low power timer
	LPTIM3 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40009800)))

	// Low power timer
	SEC_LPTIM1 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x50007c00)))

	// Low power timer
	SEC_LPTIM2 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x50009400)))

	// Low power timer
	SEC_LPTIM3 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x50009800)))

	// Serial audio interface
	SAI2 = (*SAI_Type)(unsafe.Pointer(uintptr(0x40015800)))

	// Serial audio interface
	SEC_SAI1 = (*SAI_Type)(unsafe.Pointer(uintptr(0x50015400)))

	// Serial audio interface
	SEC_SAI2 = (*SAI_Type)(unsafe.Pointer(uintptr(0x50015800)))

	// Direct memory access controller
	SEC_DMA1 = (*DMA_Type)(unsafe.Pointer(uintptr(0x50020000)))

	// Direct memory access controller
	DMA2 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020400)))

	// Direct memory access controller
	SEC_DMA2 = (*DMA_Type)(unsafe.Pointer(uintptr(0x50020400)))

	// Serial peripheral interface
	SPI2 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003800)))

	// Serial peripheral interface
	SPI3 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003c00)))

	// Serial peripheral interface
	SEC_SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x50013000)))

	// Serial peripheral interface
	SEC_SPI2 = (*SPI_Type)(unsafe.Pointer(uintptr(0x50003800)))

	// Serial peripheral interface
	SEC_SPI3 = (*SPI_Type)(unsafe.Pointer(uintptr(0x50003c00)))

	// Advanced-timers
	SEC_TIM1 = (*TIM_Type)(unsafe.Pointer(uintptr(0x50012c00)))

	// General purpose timers
	SEC_TIM15 = (*TIM_Type)(unsafe.Pointer(uintptr(0x50014000)))

	// General purpose timers
	SEC_TIM16 = (*TIM_Type)(unsafe.Pointer(uintptr(0x50014400)))

	// General purpose timers
	SEC_TIM17 = (*TIM_Type)(unsafe.Pointer(uintptr(0x50014800)))

	// General-purpose-timers
	SEC_TIM2 = (*TIM_Type)(unsafe.Pointer(uintptr(0x50000000)))

	// General-purpose-timers
	SEC_TIM3 = (*TIM_Type)(unsafe.Pointer(uintptr(0x50000400)))

	// General-purpose-timers
	SEC_TIM4 = (*TIM_Type)(unsafe.Pointer(uintptr(0x50000800)))

	// General-purpose-timers
	TIM5 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000c00)))

	// General-purpose-timers
	SEC_TIM5 = (*TIM_Type)(unsafe.Pointer(uintptr(0x50000c00)))

	// General-purpose-timers
	SEC_TIM6 = (*TIM_Type)(unsafe.Pointer(uintptr(0x50001000)))

	// General-purpose-timers
	SEC_TIM7 = (*TIM_Type)(unsafe.Pointer(uintptr(0x50001400)))

	// On-The-Fly Decryption engine
	SEC_OTFDEC1 = (*OTFDEC_Type)(unsafe.Pointer(uintptr(0x520c5000)))

	// Advanced-timers
	SEC_TIM8 = (*TIM_Type)(unsafe.Pointer(uintptr(0x50013400)))

	// GTZC_TZIC
	SEC_GTZC_TZIC = (*GTZC_Type)(unsafe.Pointer(uintptr(0x50032800)))

	// GTZC_TZSC
	SEC_GTZC_TZSC = (*GTZC_Type)(unsafe.Pointer(uintptr(0x50032400)))

	// OctoSPI
	SEC_OCTOSPI1 = (*OctoSPI_Type)(unsafe.Pointer(uintptr(0x54021000)))

	// Universal synchronous asynchronous receiver transmitter
	SEC_LPUART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x50008000)))

	// Voltage reference buffer
	SEC_VREFBUF = (*VREF_Type)(unsafe.Pointer(uintptr(0x50010030)))

	// USB Power Delivery interface
	SEC_UCPD1 = (*UCPD_Type)(unsafe.Pointer(uintptr(0x5000dc00)))

	// FDCAN1
	SEC_FDCAN1 = (*FDCAN_Type)(unsafe.Pointer(uintptr(0x5000a400)))

	// Universal synchronous asynchronous receiver transmitter
	SEC_USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x50013800)))

	// Universal synchronous asynchronous receiver transmitter
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004400)))

	// Universal synchronous asynchronous receiver transmitter
	SEC_USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0x50004400)))

	// Universal synchronous asynchronous receiver transmitter
	USART3 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004800)))

	// Universal synchronous asynchronous receiver transmitter
	SEC_USART3 = (*USART_Type)(unsafe.Pointer(uintptr(0x50004800)))

	// Universal synchronous asynchronous receiver transmitter
	UART4 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004c00)))

	// Universal synchronous asynchronous receiver transmitter
	UART5 = (*USART_Type)(unsafe.Pointer(uintptr(0x40005000)))

	// Universal synchronous asynchronous receiver transmitter
	SEC_UART4 = (*USART_Type)(unsafe.Pointer(uintptr(0x50004c00)))

	// Universal synchronous asynchronous receiver transmitter
	SEC_UART5 = (*USART_Type)(unsafe.Pointer(uintptr(0x50005000)))

	// Analog-to-Digital Converter
	SEC_ADC_Common = (*ADC_Type)(unsafe.Pointer(uintptr(0x52028300)))

	// SDMMC1
	SEC_SDMMC1 = (*SDMMC_Type)(unsafe.Pointer(uintptr(0x520c8000)))
)

// Debug Control Block
type DCB_Type struct {
	DSCSR volatile.Register32 // 0x0
}

// DCB.DSCSR: Debug Security Control and Status Register
func (o *DCB_Type) SetDSCSR_CDS(value uint32) {
	volatile.StoreUint32(&o.DSCSR.Reg, volatile.LoadUint32(&o.DSCSR.Reg)&^(0x10000)|value<<16)
}
func (o *DCB_Type) GetDSCSR_CDS() uint32 {
	return (volatile.LoadUint32(&o.DSCSR.Reg) & 0x10000) >> 16
}

// Digital filter for sigma delta modulators
type DFSDM_Type struct {
	CH0CFGR1    volatile.Register32 // 0x0
	CH0CFGR2    volatile.Register32 // 0x4
	CH0AWSCDR   volatile.Register32 // 0x8
	CH0WDATR    volatile.Register32 // 0xC
	CH0DATINR   volatile.Register32 // 0x10
	CH0DLYR     volatile.Register32 // 0x14
	_           [8]byte
	CH1CFGR1    volatile.Register32 // 0x20
	CH1CFGR2    volatile.Register32 // 0x24
	CH1AWSCDR   volatile.Register32 // 0x28
	CH1WDATR    volatile.Register32 // 0x2C
	CH1DATINR   volatile.Register32 // 0x30
	CH1DLYR     volatile.Register32 // 0x34
	_           [8]byte
	CH2CFGR1    volatile.Register32 // 0x40
	CH2CFGR2    volatile.Register32 // 0x44
	CH2AWSCDR   volatile.Register32 // 0x48
	CH2WDATR    volatile.Register32 // 0x4C
	CH2DATINR   volatile.Register32 // 0x50
	CH2DLYR     volatile.Register32 // 0x54
	_           [8]byte
	CH3CFGR1    volatile.Register32 // 0x60
	CH3CFGR2    volatile.Register32 // 0x64
	CH3AWSCDR   volatile.Register32 // 0x68
	CH3WDATR    volatile.Register32 // 0x6C
	CH3DATINR   volatile.Register32 // 0x70
	CH3DLYR     volatile.Register32 // 0x74
	_           [8]byte
	CH4CFGR1    volatile.Register32 // 0x80
	CH4CFGR2    volatile.Register32 // 0x84
	CH4AWSCDR   volatile.Register32 // 0x88
	CH4WDATR    volatile.Register32 // 0x8C
	CH4DATINR   volatile.Register32 // 0x90
	CH4DLYR     volatile.Register32 // 0x94
	_           [8]byte
	CH5CFGR1    volatile.Register32 // 0xA0
	CH5CFGR2    volatile.Register32 // 0xA4
	CH5AWSCDR   volatile.Register32 // 0xA8
	CH5WDATR    volatile.Register32 // 0xAC
	CH5DATINR   volatile.Register32 // 0xB0
	CH5DLYR     volatile.Register32 // 0xB4
	_           [8]byte
	CH6CFGR1    volatile.Register32 // 0xC0
	CH6CFGR2    volatile.Register32 // 0xC4
	CH6AWSCDR   volatile.Register32 // 0xC8
	CH6WDATR    volatile.Register32 // 0xCC
	CH6DATINR   volatile.Register32 // 0xD0
	CH6DLYR     volatile.Register32 // 0xD4
	_           [8]byte
	CH7CFGR1    volatile.Register32 // 0xE0
	CH7CFGR2    volatile.Register32 // 0xE4
	CH7AWSCDR   volatile.Register32 // 0xE8
	CH7WDATR    volatile.Register32 // 0xEC
	CH7DATINR   volatile.Register32 // 0xF0
	CH7DLYR     volatile.Register32 // 0xF4
	_           [8]byte
	FLT0CR1     volatile.Register32 // 0x100
	FLT0CR2     volatile.Register32 // 0x104
	FLT0ISR     volatile.Register32 // 0x108
	FLT0ICR     volatile.Register32 // 0x10C
	FLT0JCHGR   volatile.Register32 // 0x110
	FLT0FCR     volatile.Register32 // 0x114
	FLT0JDATAR  volatile.Register32 // 0x118
	FLT0RDATAR  volatile.Register32 // 0x11C
	FLT0AWHTR   volatile.Register32 // 0x120
	FLT0AWLTR   volatile.Register32 // 0x124
	FLT0AWSR    volatile.Register32 // 0x128
	FLT0AWCFR   volatile.Register32 // 0x12C
	FLT0EXMAX   volatile.Register32 // 0x130
	FLT0EXMIN   volatile.Register32 // 0x134
	FLT0CNVTIMR volatile.Register32 // 0x138
	_           [68]byte
	FLT1CR1     volatile.Register32 // 0x180
	FLT1CR2     volatile.Register32 // 0x184
	FLT1ISR     volatile.Register32 // 0x188
	FLT1ICR     volatile.Register32 // 0x18C
	FLT1JCHGR   volatile.Register32 // 0x190
	FLT1FCR     volatile.Register32 // 0x194
	FLT1JDATAR  volatile.Register32 // 0x198
	FLT1RDATAR  volatile.Register32 // 0x19C
	_           [4]byte
	FLT1AWLTR   volatile.Register32 // 0x1A4
	FLT1AWSR    volatile.Register32 // 0x1A8
	FLT1AWHTR   volatile.Register32 // 0x1AC
	FLT1EXMAX   volatile.Register32 // 0x1B0
	FLT1EXMIN   volatile.Register32 // 0x1B4
	FLT1CNVTIMR volatile.Register32 // 0x1B8
	_           [68]byte
	FLT2CR1     volatile.Register32 // 0x200
	FLT2CR2     volatile.Register32 // 0x204
	FLT2ISR     volatile.Register32 // 0x208
	FLT2ICR     volatile.Register32 // 0x20C
	FLT2JCHGR   volatile.Register32 // 0x210
	FLT2FCR     volatile.Register32 // 0x214
	FLT2JDATAR  volatile.Register32 // 0x218
	FLT2RDATAR  volatile.Register32 // 0x21C
	FLT2AWHTR   volatile.Register32 // 0x220
	FLT2AWLTR   volatile.Register32 // 0x224
	FLT2AWSR    volatile.Register32 // 0x228
	FLT2AWCFR   volatile.Register32 // 0x22C
	FLT2EXMAX   volatile.Register32 // 0x230
	FLT2EXMIN   volatile.Register32 // 0x234
	FLT2CNVTIMR volatile.Register32 // 0x238
	_           [68]byte
	FLT3CR1     volatile.Register32 // 0x280
	FLT3CR2     volatile.Register32 // 0x284
	FLT3ISR     volatile.Register32 // 0x288
	FLT3ICR     volatile.Register32 // 0x28C
	FLT3JCHGR   volatile.Register32 // 0x290
	FLT3FCR     volatile.Register32 // 0x294
	FLT3JDATAR  volatile.Register32 // 0x298
	FLT3RDATAR  volatile.Register32 // 0x29C
	FLT3AWHTR   volatile.Register32 // 0x2A0
	FLT3AWLTR   volatile.Register32 // 0x2A4
	FLT3AWSR    volatile.Register32 // 0x2A8
	FLT3AWCFR   volatile.Register32 // 0x2AC
	FLT3EXMAX   volatile.Register32 // 0x2B0
	FLT3EXMIN   volatile.Register32 // 0x2B4
	FLT3CNVTIMR volatile.Register32 // 0x2B8
}

// DFSDM.CH0CFGR1: channel configuration y register
func (o *DFSDM_Type) SetCH0CFGR1_DFSDMEN(value uint32) {
	volatile.StoreUint32(&o.CH0CFGR1.Reg, volatile.LoadUint32(&o.CH0CFGR1.Reg)&^(0x80000000)|value<<31)
}
func (o *DFSDM_Type) GetCH0CFGR1_DFSDMEN() uint32 {
	return (volatile.LoadUint32(&o.CH0CFGR1.Reg) & 0x80000000) >> 31
}
func (o *DFSDM_Type) SetCH0CFGR1_CKOUTSRC(value uint32) {
	volatile.StoreUint32(&o.CH0CFGR1.Reg, volatile.LoadUint32(&o.CH0CFGR1.Reg)&^(0x40000000)|value<<30)
}
func (o *DFSDM_Type) GetCH0CFGR1_CKOUTSRC() uint32 {
	return (volatile.LoadUint32(&o.CH0CFGR1.Reg) & 0x40000000) >> 30
}
func (o *DFSDM_Type) SetCH0CFGR1_CKOUTDIV(value uint32) {
	volatile.StoreUint32(&o.CH0CFGR1.Reg, volatile.LoadUint32(&o.CH0CFGR1.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_Type) GetCH0CFGR1_CKOUTDIV() uint32 {
	return (volatile.LoadUint32(&o.CH0CFGR1.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_Type) SetCH0CFGR1_DATPACK(value uint32) {
	volatile.StoreUint32(&o.CH0CFGR1.Reg, volatile.LoadUint32(&o.CH0CFGR1.Reg)&^(0xc000)|value<<14)
}
func (o *DFSDM_Type) GetCH0CFGR1_DATPACK() uint32 {
	return (volatile.LoadUint32(&o.CH0CFGR1.Reg) & 0xc000) >> 14
}
func (o *DFSDM_Type) SetCH0CFGR1_DATMPX(value uint32) {
	volatile.StoreUint32(&o.CH0CFGR1.Reg, volatile.LoadUint32(&o.CH0CFGR1.Reg)&^(0x3000)|value<<12)
}
func (o *DFSDM_Type) GetCH0CFGR1_DATMPX() uint32 {
	return (volatile.LoadUint32(&o.CH0CFGR1.Reg) & 0x3000) >> 12
}
func (o *DFSDM_Type) SetCH0CFGR1_CHINSEL(value uint32) {
	volatile.StoreUint32(&o.CH0CFGR1.Reg, volatile.LoadUint32(&o.CH0CFGR1.Reg)&^(0x100)|value<<8)
}
func (o *DFSDM_Type) GetCH0CFGR1_CHINSEL() uint32 {
	return (volatile.LoadUint32(&o.CH0CFGR1.Reg) & 0x100) >> 8
}
func (o *DFSDM_Type) SetCH0CFGR1_CHEN(value uint32) {
	volatile.StoreUint32(&o.CH0CFGR1.Reg, volatile.LoadUint32(&o.CH0CFGR1.Reg)&^(0x80)|value<<7)
}
func (o *DFSDM_Type) GetCH0CFGR1_CHEN() uint32 {
	return (volatile.LoadUint32(&o.CH0CFGR1.Reg) & 0x80) >> 7
}
func (o *DFSDM_Type) SetCH0CFGR1_CKABEN(value uint32) {
	volatile.StoreUint32(&o.CH0CFGR1.Reg, volatile.LoadUint32(&o.CH0CFGR1.Reg)&^(0x40)|value<<6)
}
func (o *DFSDM_Type) GetCH0CFGR1_CKABEN() uint32 {
	return (volatile.LoadUint32(&o.CH0CFGR1.Reg) & 0x40) >> 6
}
func (o *DFSDM_Type) SetCH0CFGR1_SCDEN(value uint32) {
	volatile.StoreUint32(&o.CH0CFGR1.Reg, volatile.LoadUint32(&o.CH0CFGR1.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_Type) GetCH0CFGR1_SCDEN() uint32 {
	return (volatile.LoadUint32(&o.CH0CFGR1.Reg) & 0x20) >> 5
}
func (o *DFSDM_Type) SetCH0CFGR1_SPICKSEL(value uint32) {
	volatile.StoreUint32(&o.CH0CFGR1.Reg, volatile.LoadUint32(&o.CH0CFGR1.Reg)&^(0xc)|value<<2)
}
func (o *DFSDM_Type) GetCH0CFGR1_SPICKSEL() uint32 {
	return (volatile.LoadUint32(&o.CH0CFGR1.Reg) & 0xc) >> 2
}
func (o *DFSDM_Type) SetCH0CFGR1_SITP(value uint32) {
	volatile.StoreUint32(&o.CH0CFGR1.Reg, volatile.LoadUint32(&o.CH0CFGR1.Reg)&^(0x3)|value)
}
func (o *DFSDM_Type) GetCH0CFGR1_SITP() uint32 {
	return volatile.LoadUint32(&o.CH0CFGR1.Reg) & 0x3
}

// DFSDM.CH0CFGR2: channel configuration y register
func (o *DFSDM_Type) SetCH0CFGR2_OFFSET(value uint32) {
	volatile.StoreUint32(&o.CH0CFGR2.Reg, volatile.LoadUint32(&o.CH0CFGR2.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetCH0CFGR2_OFFSET() uint32 {
	return (volatile.LoadUint32(&o.CH0CFGR2.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetCH0CFGR2_DTRBS(value uint32) {
	volatile.StoreUint32(&o.CH0CFGR2.Reg, volatile.LoadUint32(&o.CH0CFGR2.Reg)&^(0xf8)|value<<3)
}
func (o *DFSDM_Type) GetCH0CFGR2_DTRBS() uint32 {
	return (volatile.LoadUint32(&o.CH0CFGR2.Reg) & 0xf8) >> 3
}

// DFSDM.CH0AWSCDR: analog watchdog and short-circuit detector register
func (o *DFSDM_Type) SetCH0AWSCDR_AWFORD(value uint32) {
	volatile.StoreUint32(&o.CH0AWSCDR.Reg, volatile.LoadUint32(&o.CH0AWSCDR.Reg)&^(0xc00000)|value<<22)
}
func (o *DFSDM_Type) GetCH0AWSCDR_AWFORD() uint32 {
	return (volatile.LoadUint32(&o.CH0AWSCDR.Reg) & 0xc00000) >> 22
}
func (o *DFSDM_Type) SetCH0AWSCDR_AWFOSR(value uint32) {
	volatile.StoreUint32(&o.CH0AWSCDR.Reg, volatile.LoadUint32(&o.CH0AWSCDR.Reg)&^(0x1f0000)|value<<16)
}
func (o *DFSDM_Type) GetCH0AWSCDR_AWFOSR() uint32 {
	return (volatile.LoadUint32(&o.CH0AWSCDR.Reg) & 0x1f0000) >> 16
}
func (o *DFSDM_Type) SetCH0AWSCDR_BKSCD(value uint32) {
	volatile.StoreUint32(&o.CH0AWSCDR.Reg, volatile.LoadUint32(&o.CH0AWSCDR.Reg)&^(0xf000)|value<<12)
}
func (o *DFSDM_Type) GetCH0AWSCDR_BKSCD() uint32 {
	return (volatile.LoadUint32(&o.CH0AWSCDR.Reg) & 0xf000) >> 12
}
func (o *DFSDM_Type) SetCH0AWSCDR_SCDT(value uint32) {
	volatile.StoreUint32(&o.CH0AWSCDR.Reg, volatile.LoadUint32(&o.CH0AWSCDR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetCH0AWSCDR_SCDT() uint32 {
	return volatile.LoadUint32(&o.CH0AWSCDR.Reg) & 0xff
}

// DFSDM.CH0WDATR: channel watchdog filter data register
func (o *DFSDM_Type) SetCH0WDATR_WDATA(value uint32) {
	volatile.StoreUint32(&o.CH0WDATR.Reg, volatile.LoadUint32(&o.CH0WDATR.Reg)&^(0xffff)|value)
}
func (o *DFSDM_Type) GetCH0WDATR_WDATA() uint32 {
	return volatile.LoadUint32(&o.CH0WDATR.Reg) & 0xffff
}

// DFSDM.CH0DATINR: channel data input register
func (o *DFSDM_Type) SetCH0DATINR_INDAT1(value uint32) {
	volatile.StoreUint32(&o.CH0DATINR.Reg, volatile.LoadUint32(&o.CH0DATINR.Reg)&^(0xffff0000)|value<<16)
}
func (o *DFSDM_Type) GetCH0DATINR_INDAT1() uint32 {
	return (volatile.LoadUint32(&o.CH0DATINR.Reg) & 0xffff0000) >> 16
}
func (o *DFSDM_Type) SetCH0DATINR_INDAT0(value uint32) {
	volatile.StoreUint32(&o.CH0DATINR.Reg, volatile.LoadUint32(&o.CH0DATINR.Reg)&^(0xffff)|value)
}
func (o *DFSDM_Type) GetCH0DATINR_INDAT0() uint32 {
	return volatile.LoadUint32(&o.CH0DATINR.Reg) & 0xffff
}

// DFSDM.CH0DLYR: DFSDM channel y delay register
func (o *DFSDM_Type) SetCH0DLYR_PLSSKP(value uint32) {
	volatile.StoreUint32(&o.CH0DLYR.Reg, volatile.LoadUint32(&o.CH0DLYR.Reg)&^(0x3f)|value)
}
func (o *DFSDM_Type) GetCH0DLYR_PLSSKP() uint32 {
	return volatile.LoadUint32(&o.CH0DLYR.Reg) & 0x3f
}

// DFSDM.CH1CFGR1: CHCFG1R1
func (o *DFSDM_Type) SetCH1CFGR1_DATPACK(value uint32) {
	volatile.StoreUint32(&o.CH1CFGR1.Reg, volatile.LoadUint32(&o.CH1CFGR1.Reg)&^(0xc000)|value<<14)
}
func (o *DFSDM_Type) GetCH1CFGR1_DATPACK() uint32 {
	return (volatile.LoadUint32(&o.CH1CFGR1.Reg) & 0xc000) >> 14
}
func (o *DFSDM_Type) SetCH1CFGR1_DATMPX(value uint32) {
	volatile.StoreUint32(&o.CH1CFGR1.Reg, volatile.LoadUint32(&o.CH1CFGR1.Reg)&^(0x3000)|value<<12)
}
func (o *DFSDM_Type) GetCH1CFGR1_DATMPX() uint32 {
	return (volatile.LoadUint32(&o.CH1CFGR1.Reg) & 0x3000) >> 12
}
func (o *DFSDM_Type) SetCH1CFGR1_CHINSEL(value uint32) {
	volatile.StoreUint32(&o.CH1CFGR1.Reg, volatile.LoadUint32(&o.CH1CFGR1.Reg)&^(0x100)|value<<8)
}
func (o *DFSDM_Type) GetCH1CFGR1_CHINSEL() uint32 {
	return (volatile.LoadUint32(&o.CH1CFGR1.Reg) & 0x100) >> 8
}
func (o *DFSDM_Type) SetCH1CFGR1_CHEN(value uint32) {
	volatile.StoreUint32(&o.CH1CFGR1.Reg, volatile.LoadUint32(&o.CH1CFGR1.Reg)&^(0x80)|value<<7)
}
func (o *DFSDM_Type) GetCH1CFGR1_CHEN() uint32 {
	return (volatile.LoadUint32(&o.CH1CFGR1.Reg) & 0x80) >> 7
}
func (o *DFSDM_Type) SetCH1CFGR1_CKABEN(value uint32) {
	volatile.StoreUint32(&o.CH1CFGR1.Reg, volatile.LoadUint32(&o.CH1CFGR1.Reg)&^(0x40)|value<<6)
}
func (o *DFSDM_Type) GetCH1CFGR1_CKABEN() uint32 {
	return (volatile.LoadUint32(&o.CH1CFGR1.Reg) & 0x40) >> 6
}
func (o *DFSDM_Type) SetCH1CFGR1_SCDEN(value uint32) {
	volatile.StoreUint32(&o.CH1CFGR1.Reg, volatile.LoadUint32(&o.CH1CFGR1.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_Type) GetCH1CFGR1_SCDEN() uint32 {
	return (volatile.LoadUint32(&o.CH1CFGR1.Reg) & 0x20) >> 5
}
func (o *DFSDM_Type) SetCH1CFGR1_SPICKSEL(value uint32) {
	volatile.StoreUint32(&o.CH1CFGR1.Reg, volatile.LoadUint32(&o.CH1CFGR1.Reg)&^(0xc)|value<<2)
}
func (o *DFSDM_Type) GetCH1CFGR1_SPICKSEL() uint32 {
	return (volatile.LoadUint32(&o.CH1CFGR1.Reg) & 0xc) >> 2
}
func (o *DFSDM_Type) SetCH1CFGR1_SITP(value uint32) {
	volatile.StoreUint32(&o.CH1CFGR1.Reg, volatile.LoadUint32(&o.CH1CFGR1.Reg)&^(0x3)|value)
}
func (o *DFSDM_Type) GetCH1CFGR1_SITP() uint32 {
	return volatile.LoadUint32(&o.CH1CFGR1.Reg) & 0x3
}
func (o *DFSDM_Type) SetCH1CFGR1_CKOUTDIV(value uint32) {
	volatile.StoreUint32(&o.CH1CFGR1.Reg, volatile.LoadUint32(&o.CH1CFGR1.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_Type) GetCH1CFGR1_CKOUTDIV() uint32 {
	return (volatile.LoadUint32(&o.CH1CFGR1.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_Type) SetCH1CFGR1_CKOUTSRC(value uint32) {
	volatile.StoreUint32(&o.CH1CFGR1.Reg, volatile.LoadUint32(&o.CH1CFGR1.Reg)&^(0x40000000)|value<<30)
}
func (o *DFSDM_Type) GetCH1CFGR1_CKOUTSRC() uint32 {
	return (volatile.LoadUint32(&o.CH1CFGR1.Reg) & 0x40000000) >> 30
}
func (o *DFSDM_Type) SetCH1CFGR1_DFSDMEN(value uint32) {
	volatile.StoreUint32(&o.CH1CFGR1.Reg, volatile.LoadUint32(&o.CH1CFGR1.Reg)&^(0x80000000)|value<<31)
}
func (o *DFSDM_Type) GetCH1CFGR1_DFSDMEN() uint32 {
	return (volatile.LoadUint32(&o.CH1CFGR1.Reg) & 0x80000000) >> 31
}

// DFSDM.CH1CFGR2: CHCFG1R2
func (o *DFSDM_Type) SetCH1CFGR2_OFFSET(value uint32) {
	volatile.StoreUint32(&o.CH1CFGR2.Reg, volatile.LoadUint32(&o.CH1CFGR2.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetCH1CFGR2_OFFSET() uint32 {
	return (volatile.LoadUint32(&o.CH1CFGR2.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetCH1CFGR2_DTRBS(value uint32) {
	volatile.StoreUint32(&o.CH1CFGR2.Reg, volatile.LoadUint32(&o.CH1CFGR2.Reg)&^(0xf8)|value<<3)
}
func (o *DFSDM_Type) GetCH1CFGR2_DTRBS() uint32 {
	return (volatile.LoadUint32(&o.CH1CFGR2.Reg) & 0xf8) >> 3
}

// DFSDM.CH1AWSCDR: AWSCD1R
func (o *DFSDM_Type) SetCH1AWSCDR_AWFORD(value uint32) {
	volatile.StoreUint32(&o.CH1AWSCDR.Reg, volatile.LoadUint32(&o.CH1AWSCDR.Reg)&^(0xc00000)|value<<22)
}
func (o *DFSDM_Type) GetCH1AWSCDR_AWFORD() uint32 {
	return (volatile.LoadUint32(&o.CH1AWSCDR.Reg) & 0xc00000) >> 22
}
func (o *DFSDM_Type) SetCH1AWSCDR_AWFOSR(value uint32) {
	volatile.StoreUint32(&o.CH1AWSCDR.Reg, volatile.LoadUint32(&o.CH1AWSCDR.Reg)&^(0x1f0000)|value<<16)
}
func (o *DFSDM_Type) GetCH1AWSCDR_AWFOSR() uint32 {
	return (volatile.LoadUint32(&o.CH1AWSCDR.Reg) & 0x1f0000) >> 16
}
func (o *DFSDM_Type) SetCH1AWSCDR_BKSCD(value uint32) {
	volatile.StoreUint32(&o.CH1AWSCDR.Reg, volatile.LoadUint32(&o.CH1AWSCDR.Reg)&^(0xf000)|value<<12)
}
func (o *DFSDM_Type) GetCH1AWSCDR_BKSCD() uint32 {
	return (volatile.LoadUint32(&o.CH1AWSCDR.Reg) & 0xf000) >> 12
}
func (o *DFSDM_Type) SetCH1AWSCDR_SCDT(value uint32) {
	volatile.StoreUint32(&o.CH1AWSCDR.Reg, volatile.LoadUint32(&o.CH1AWSCDR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetCH1AWSCDR_SCDT() uint32 {
	return volatile.LoadUint32(&o.CH1AWSCDR.Reg) & 0xff
}

// DFSDM.CH1WDATR: CHWDAT1R
func (o *DFSDM_Type) SetCH1WDATR_WDATA(value uint32) {
	volatile.StoreUint32(&o.CH1WDATR.Reg, volatile.LoadUint32(&o.CH1WDATR.Reg)&^(0xffff)|value)
}
func (o *DFSDM_Type) GetCH1WDATR_WDATA() uint32 {
	return volatile.LoadUint32(&o.CH1WDATR.Reg) & 0xffff
}

// DFSDM.CH1DATINR: CHDATIN1R
func (o *DFSDM_Type) SetCH1DATINR_INDAT1(value uint32) {
	volatile.StoreUint32(&o.CH1DATINR.Reg, volatile.LoadUint32(&o.CH1DATINR.Reg)&^(0xffff0000)|value<<16)
}
func (o *DFSDM_Type) GetCH1DATINR_INDAT1() uint32 {
	return (volatile.LoadUint32(&o.CH1DATINR.Reg) & 0xffff0000) >> 16
}
func (o *DFSDM_Type) SetCH1DATINR_INDAT0(value uint32) {
	volatile.StoreUint32(&o.CH1DATINR.Reg, volatile.LoadUint32(&o.CH1DATINR.Reg)&^(0xffff)|value)
}
func (o *DFSDM_Type) GetCH1DATINR_INDAT0() uint32 {
	return volatile.LoadUint32(&o.CH1DATINR.Reg) & 0xffff
}

// DFSDM.CH1DLYR: DFSDM channel y delay register
func (o *DFSDM_Type) SetCH1DLYR_PLSSKP(value uint32) {
	volatile.StoreUint32(&o.CH1DLYR.Reg, volatile.LoadUint32(&o.CH1DLYR.Reg)&^(0x3f)|value)
}
func (o *DFSDM_Type) GetCH1DLYR_PLSSKP() uint32 {
	return volatile.LoadUint32(&o.CH1DLYR.Reg) & 0x3f
}

// DFSDM.CH2CFGR1: CHCFG2R1
func (o *DFSDM_Type) SetCH2CFGR1_DATPACK(value uint32) {
	volatile.StoreUint32(&o.CH2CFGR1.Reg, volatile.LoadUint32(&o.CH2CFGR1.Reg)&^(0xc000)|value<<14)
}
func (o *DFSDM_Type) GetCH2CFGR1_DATPACK() uint32 {
	return (volatile.LoadUint32(&o.CH2CFGR1.Reg) & 0xc000) >> 14
}
func (o *DFSDM_Type) SetCH2CFGR1_DATMPX(value uint32) {
	volatile.StoreUint32(&o.CH2CFGR1.Reg, volatile.LoadUint32(&o.CH2CFGR1.Reg)&^(0x3000)|value<<12)
}
func (o *DFSDM_Type) GetCH2CFGR1_DATMPX() uint32 {
	return (volatile.LoadUint32(&o.CH2CFGR1.Reg) & 0x3000) >> 12
}
func (o *DFSDM_Type) SetCH2CFGR1_CHINSEL(value uint32) {
	volatile.StoreUint32(&o.CH2CFGR1.Reg, volatile.LoadUint32(&o.CH2CFGR1.Reg)&^(0x100)|value<<8)
}
func (o *DFSDM_Type) GetCH2CFGR1_CHINSEL() uint32 {
	return (volatile.LoadUint32(&o.CH2CFGR1.Reg) & 0x100) >> 8
}
func (o *DFSDM_Type) SetCH2CFGR1_CHEN(value uint32) {
	volatile.StoreUint32(&o.CH2CFGR1.Reg, volatile.LoadUint32(&o.CH2CFGR1.Reg)&^(0x80)|value<<7)
}
func (o *DFSDM_Type) GetCH2CFGR1_CHEN() uint32 {
	return (volatile.LoadUint32(&o.CH2CFGR1.Reg) & 0x80) >> 7
}
func (o *DFSDM_Type) SetCH2CFGR1_CKABEN(value uint32) {
	volatile.StoreUint32(&o.CH2CFGR1.Reg, volatile.LoadUint32(&o.CH2CFGR1.Reg)&^(0x40)|value<<6)
}
func (o *DFSDM_Type) GetCH2CFGR1_CKABEN() uint32 {
	return (volatile.LoadUint32(&o.CH2CFGR1.Reg) & 0x40) >> 6
}
func (o *DFSDM_Type) SetCH2CFGR1_SCDEN(value uint32) {
	volatile.StoreUint32(&o.CH2CFGR1.Reg, volatile.LoadUint32(&o.CH2CFGR1.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_Type) GetCH2CFGR1_SCDEN() uint32 {
	return (volatile.LoadUint32(&o.CH2CFGR1.Reg) & 0x20) >> 5
}
func (o *DFSDM_Type) SetCH2CFGR1_SPICKSEL(value uint32) {
	volatile.StoreUint32(&o.CH2CFGR1.Reg, volatile.LoadUint32(&o.CH2CFGR1.Reg)&^(0xc)|value<<2)
}
func (o *DFSDM_Type) GetCH2CFGR1_SPICKSEL() uint32 {
	return (volatile.LoadUint32(&o.CH2CFGR1.Reg) & 0xc) >> 2
}
func (o *DFSDM_Type) SetCH2CFGR1_SITP(value uint32) {
	volatile.StoreUint32(&o.CH2CFGR1.Reg, volatile.LoadUint32(&o.CH2CFGR1.Reg)&^(0x3)|value)
}
func (o *DFSDM_Type) GetCH2CFGR1_SITP() uint32 {
	return volatile.LoadUint32(&o.CH2CFGR1.Reg) & 0x3
}
func (o *DFSDM_Type) SetCH2CFGR1_CKOUTDIV(value uint32) {
	volatile.StoreUint32(&o.CH2CFGR1.Reg, volatile.LoadUint32(&o.CH2CFGR1.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_Type) GetCH2CFGR1_CKOUTDIV() uint32 {
	return (volatile.LoadUint32(&o.CH2CFGR1.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_Type) SetCH2CFGR1_CKOUTSRC(value uint32) {
	volatile.StoreUint32(&o.CH2CFGR1.Reg, volatile.LoadUint32(&o.CH2CFGR1.Reg)&^(0x40000000)|value<<30)
}
func (o *DFSDM_Type) GetCH2CFGR1_CKOUTSRC() uint32 {
	return (volatile.LoadUint32(&o.CH2CFGR1.Reg) & 0x40000000) >> 30
}
func (o *DFSDM_Type) SetCH2CFGR1_DFSDMEN(value uint32) {
	volatile.StoreUint32(&o.CH2CFGR1.Reg, volatile.LoadUint32(&o.CH2CFGR1.Reg)&^(0x80000000)|value<<31)
}
func (o *DFSDM_Type) GetCH2CFGR1_DFSDMEN() uint32 {
	return (volatile.LoadUint32(&o.CH2CFGR1.Reg) & 0x80000000) >> 31
}

// DFSDM.CH2CFGR2: CHCFG2R2
func (o *DFSDM_Type) SetCH2CFGR2_OFFSET(value uint32) {
	volatile.StoreUint32(&o.CH2CFGR2.Reg, volatile.LoadUint32(&o.CH2CFGR2.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetCH2CFGR2_OFFSET() uint32 {
	return (volatile.LoadUint32(&o.CH2CFGR2.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetCH2CFGR2_DTRBS(value uint32) {
	volatile.StoreUint32(&o.CH2CFGR2.Reg, volatile.LoadUint32(&o.CH2CFGR2.Reg)&^(0xf8)|value<<3)
}
func (o *DFSDM_Type) GetCH2CFGR2_DTRBS() uint32 {
	return (volatile.LoadUint32(&o.CH2CFGR2.Reg) & 0xf8) >> 3
}

// DFSDM.CH2AWSCDR: AWSCD2R
func (o *DFSDM_Type) SetCH2AWSCDR_AWFORD(value uint32) {
	volatile.StoreUint32(&o.CH2AWSCDR.Reg, volatile.LoadUint32(&o.CH2AWSCDR.Reg)&^(0xc00000)|value<<22)
}
func (o *DFSDM_Type) GetCH2AWSCDR_AWFORD() uint32 {
	return (volatile.LoadUint32(&o.CH2AWSCDR.Reg) & 0xc00000) >> 22
}
func (o *DFSDM_Type) SetCH2AWSCDR_AWFOSR(value uint32) {
	volatile.StoreUint32(&o.CH2AWSCDR.Reg, volatile.LoadUint32(&o.CH2AWSCDR.Reg)&^(0x1f0000)|value<<16)
}
func (o *DFSDM_Type) GetCH2AWSCDR_AWFOSR() uint32 {
	return (volatile.LoadUint32(&o.CH2AWSCDR.Reg) & 0x1f0000) >> 16
}
func (o *DFSDM_Type) SetCH2AWSCDR_BKSCD(value uint32) {
	volatile.StoreUint32(&o.CH2AWSCDR.Reg, volatile.LoadUint32(&o.CH2AWSCDR.Reg)&^(0xf000)|value<<12)
}
func (o *DFSDM_Type) GetCH2AWSCDR_BKSCD() uint32 {
	return (volatile.LoadUint32(&o.CH2AWSCDR.Reg) & 0xf000) >> 12
}
func (o *DFSDM_Type) SetCH2AWSCDR_SCDT(value uint32) {
	volatile.StoreUint32(&o.CH2AWSCDR.Reg, volatile.LoadUint32(&o.CH2AWSCDR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetCH2AWSCDR_SCDT() uint32 {
	return volatile.LoadUint32(&o.CH2AWSCDR.Reg) & 0xff
}

// DFSDM.CH2WDATR: CHWDAT2R
func (o *DFSDM_Type) SetCH2WDATR_WDATA(value uint32) {
	volatile.StoreUint32(&o.CH2WDATR.Reg, volatile.LoadUint32(&o.CH2WDATR.Reg)&^(0xffff)|value)
}
func (o *DFSDM_Type) GetCH2WDATR_WDATA() uint32 {
	return volatile.LoadUint32(&o.CH2WDATR.Reg) & 0xffff
}

// DFSDM.CH2DATINR: CHDATIN2R
func (o *DFSDM_Type) SetCH2DATINR_INDAT1(value uint32) {
	volatile.StoreUint32(&o.CH2DATINR.Reg, volatile.LoadUint32(&o.CH2DATINR.Reg)&^(0xffff0000)|value<<16)
}
func (o *DFSDM_Type) GetCH2DATINR_INDAT1() uint32 {
	return (volatile.LoadUint32(&o.CH2DATINR.Reg) & 0xffff0000) >> 16
}
func (o *DFSDM_Type) SetCH2DATINR_INDAT0(value uint32) {
	volatile.StoreUint32(&o.CH2DATINR.Reg, volatile.LoadUint32(&o.CH2DATINR.Reg)&^(0xffff)|value)
}
func (o *DFSDM_Type) GetCH2DATINR_INDAT0() uint32 {
	return volatile.LoadUint32(&o.CH2DATINR.Reg) & 0xffff
}

// DFSDM.CH2DLYR: DFSDM channel y delay register
func (o *DFSDM_Type) SetCH2DLYR_PLSSKP(value uint32) {
	volatile.StoreUint32(&o.CH2DLYR.Reg, volatile.LoadUint32(&o.CH2DLYR.Reg)&^(0x3f)|value)
}
func (o *DFSDM_Type) GetCH2DLYR_PLSSKP() uint32 {
	return volatile.LoadUint32(&o.CH2DLYR.Reg) & 0x3f
}

// DFSDM.CH3CFGR1: CHCFG3R1
func (o *DFSDM_Type) SetCH3CFGR1_DATPACK(value uint32) {
	volatile.StoreUint32(&o.CH3CFGR1.Reg, volatile.LoadUint32(&o.CH3CFGR1.Reg)&^(0xc000)|value<<14)
}
func (o *DFSDM_Type) GetCH3CFGR1_DATPACK() uint32 {
	return (volatile.LoadUint32(&o.CH3CFGR1.Reg) & 0xc000) >> 14
}
func (o *DFSDM_Type) SetCH3CFGR1_DATMPX(value uint32) {
	volatile.StoreUint32(&o.CH3CFGR1.Reg, volatile.LoadUint32(&o.CH3CFGR1.Reg)&^(0x3000)|value<<12)
}
func (o *DFSDM_Type) GetCH3CFGR1_DATMPX() uint32 {
	return (volatile.LoadUint32(&o.CH3CFGR1.Reg) & 0x3000) >> 12
}
func (o *DFSDM_Type) SetCH3CFGR1_CHINSEL(value uint32) {
	volatile.StoreUint32(&o.CH3CFGR1.Reg, volatile.LoadUint32(&o.CH3CFGR1.Reg)&^(0x100)|value<<8)
}
func (o *DFSDM_Type) GetCH3CFGR1_CHINSEL() uint32 {
	return (volatile.LoadUint32(&o.CH3CFGR1.Reg) & 0x100) >> 8
}
func (o *DFSDM_Type) SetCH3CFGR1_CHEN(value uint32) {
	volatile.StoreUint32(&o.CH3CFGR1.Reg, volatile.LoadUint32(&o.CH3CFGR1.Reg)&^(0x80)|value<<7)
}
func (o *DFSDM_Type) GetCH3CFGR1_CHEN() uint32 {
	return (volatile.LoadUint32(&o.CH3CFGR1.Reg) & 0x80) >> 7
}
func (o *DFSDM_Type) SetCH3CFGR1_CKABEN(value uint32) {
	volatile.StoreUint32(&o.CH3CFGR1.Reg, volatile.LoadUint32(&o.CH3CFGR1.Reg)&^(0x40)|value<<6)
}
func (o *DFSDM_Type) GetCH3CFGR1_CKABEN() uint32 {
	return (volatile.LoadUint32(&o.CH3CFGR1.Reg) & 0x40) >> 6
}
func (o *DFSDM_Type) SetCH3CFGR1_SCDEN(value uint32) {
	volatile.StoreUint32(&o.CH3CFGR1.Reg, volatile.LoadUint32(&o.CH3CFGR1.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_Type) GetCH3CFGR1_SCDEN() uint32 {
	return (volatile.LoadUint32(&o.CH3CFGR1.Reg) & 0x20) >> 5
}
func (o *DFSDM_Type) SetCH3CFGR1_SPICKSEL(value uint32) {
	volatile.StoreUint32(&o.CH3CFGR1.Reg, volatile.LoadUint32(&o.CH3CFGR1.Reg)&^(0xc)|value<<2)
}
func (o *DFSDM_Type) GetCH3CFGR1_SPICKSEL() uint32 {
	return (volatile.LoadUint32(&o.CH3CFGR1.Reg) & 0xc) >> 2
}
func (o *DFSDM_Type) SetCH3CFGR1_SITP(value uint32) {
	volatile.StoreUint32(&o.CH3CFGR1.Reg, volatile.LoadUint32(&o.CH3CFGR1.Reg)&^(0x3)|value)
}
func (o *DFSDM_Type) GetCH3CFGR1_SITP() uint32 {
	return volatile.LoadUint32(&o.CH3CFGR1.Reg) & 0x3
}
func (o *DFSDM_Type) SetCH3CFGR1_CKOUTDIV(value uint32) {
	volatile.StoreUint32(&o.CH3CFGR1.Reg, volatile.LoadUint32(&o.CH3CFGR1.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_Type) GetCH3CFGR1_CKOUTDIV() uint32 {
	return (volatile.LoadUint32(&o.CH3CFGR1.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_Type) SetCH3CFGR1_CKOUTSRC(value uint32) {
	volatile.StoreUint32(&o.CH3CFGR1.Reg, volatile.LoadUint32(&o.CH3CFGR1.Reg)&^(0x40000000)|value<<30)
}
func (o *DFSDM_Type) GetCH3CFGR1_CKOUTSRC() uint32 {
	return (volatile.LoadUint32(&o.CH3CFGR1.Reg) & 0x40000000) >> 30
}
func (o *DFSDM_Type) SetCH3CFGR1_DFSDMEN(value uint32) {
	volatile.StoreUint32(&o.CH3CFGR1.Reg, volatile.LoadUint32(&o.CH3CFGR1.Reg)&^(0x80000000)|value<<31)
}
func (o *DFSDM_Type) GetCH3CFGR1_DFSDMEN() uint32 {
	return (volatile.LoadUint32(&o.CH3CFGR1.Reg) & 0x80000000) >> 31
}

// DFSDM.CH3CFGR2: CHCFG3R2
func (o *DFSDM_Type) SetCH3CFGR2_OFFSET(value uint32) {
	volatile.StoreUint32(&o.CH3CFGR2.Reg, volatile.LoadUint32(&o.CH3CFGR2.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetCH3CFGR2_OFFSET() uint32 {
	return (volatile.LoadUint32(&o.CH3CFGR2.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetCH3CFGR2_DTRBS(value uint32) {
	volatile.StoreUint32(&o.CH3CFGR2.Reg, volatile.LoadUint32(&o.CH3CFGR2.Reg)&^(0xf8)|value<<3)
}
func (o *DFSDM_Type) GetCH3CFGR2_DTRBS() uint32 {
	return (volatile.LoadUint32(&o.CH3CFGR2.Reg) & 0xf8) >> 3
}

// DFSDM.CH3AWSCDR: AWSCD3R
func (o *DFSDM_Type) SetCH3AWSCDR_AWFORD(value uint32) {
	volatile.StoreUint32(&o.CH3AWSCDR.Reg, volatile.LoadUint32(&o.CH3AWSCDR.Reg)&^(0xc00000)|value<<22)
}
func (o *DFSDM_Type) GetCH3AWSCDR_AWFORD() uint32 {
	return (volatile.LoadUint32(&o.CH3AWSCDR.Reg) & 0xc00000) >> 22
}
func (o *DFSDM_Type) SetCH3AWSCDR_AWFOSR(value uint32) {
	volatile.StoreUint32(&o.CH3AWSCDR.Reg, volatile.LoadUint32(&o.CH3AWSCDR.Reg)&^(0x1f0000)|value<<16)
}
func (o *DFSDM_Type) GetCH3AWSCDR_AWFOSR() uint32 {
	return (volatile.LoadUint32(&o.CH3AWSCDR.Reg) & 0x1f0000) >> 16
}
func (o *DFSDM_Type) SetCH3AWSCDR_BKSCD(value uint32) {
	volatile.StoreUint32(&o.CH3AWSCDR.Reg, volatile.LoadUint32(&o.CH3AWSCDR.Reg)&^(0xf000)|value<<12)
}
func (o *DFSDM_Type) GetCH3AWSCDR_BKSCD() uint32 {
	return (volatile.LoadUint32(&o.CH3AWSCDR.Reg) & 0xf000) >> 12
}
func (o *DFSDM_Type) SetCH3AWSCDR_SCDT(value uint32) {
	volatile.StoreUint32(&o.CH3AWSCDR.Reg, volatile.LoadUint32(&o.CH3AWSCDR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetCH3AWSCDR_SCDT() uint32 {
	return volatile.LoadUint32(&o.CH3AWSCDR.Reg) & 0xff
}

// DFSDM.CH3WDATR: CHWDAT3R
func (o *DFSDM_Type) SetCH3WDATR_WDATA(value uint32) {
	volatile.StoreUint32(&o.CH3WDATR.Reg, volatile.LoadUint32(&o.CH3WDATR.Reg)&^(0xffff)|value)
}
func (o *DFSDM_Type) GetCH3WDATR_WDATA() uint32 {
	return volatile.LoadUint32(&o.CH3WDATR.Reg) & 0xffff
}

// DFSDM.CH3DATINR: CHDATIN3R
func (o *DFSDM_Type) SetCH3DATINR_INDAT1(value uint32) {
	volatile.StoreUint32(&o.CH3DATINR.Reg, volatile.LoadUint32(&o.CH3DATINR.Reg)&^(0xffff0000)|value<<16)
}
func (o *DFSDM_Type) GetCH3DATINR_INDAT1() uint32 {
	return (volatile.LoadUint32(&o.CH3DATINR.Reg) & 0xffff0000) >> 16
}
func (o *DFSDM_Type) SetCH3DATINR_INDAT0(value uint32) {
	volatile.StoreUint32(&o.CH3DATINR.Reg, volatile.LoadUint32(&o.CH3DATINR.Reg)&^(0xffff)|value)
}
func (o *DFSDM_Type) GetCH3DATINR_INDAT0() uint32 {
	return volatile.LoadUint32(&o.CH3DATINR.Reg) & 0xffff
}

// DFSDM.CH3DLYR: DFSDM channel y delay register
func (o *DFSDM_Type) SetCH3DLYR_PLSSKP(value uint32) {
	volatile.StoreUint32(&o.CH3DLYR.Reg, volatile.LoadUint32(&o.CH3DLYR.Reg)&^(0x3f)|value)
}
func (o *DFSDM_Type) GetCH3DLYR_PLSSKP() uint32 {
	return volatile.LoadUint32(&o.CH3DLYR.Reg) & 0x3f
}

// DFSDM.CH4CFGR1: CHCFG4R1
func (o *DFSDM_Type) SetCH4CFGR1_DATPACK(value uint32) {
	volatile.StoreUint32(&o.CH4CFGR1.Reg, volatile.LoadUint32(&o.CH4CFGR1.Reg)&^(0xc000)|value<<14)
}
func (o *DFSDM_Type) GetCH4CFGR1_DATPACK() uint32 {
	return (volatile.LoadUint32(&o.CH4CFGR1.Reg) & 0xc000) >> 14
}
func (o *DFSDM_Type) SetCH4CFGR1_DATMPX(value uint32) {
	volatile.StoreUint32(&o.CH4CFGR1.Reg, volatile.LoadUint32(&o.CH4CFGR1.Reg)&^(0x3000)|value<<12)
}
func (o *DFSDM_Type) GetCH4CFGR1_DATMPX() uint32 {
	return (volatile.LoadUint32(&o.CH4CFGR1.Reg) & 0x3000) >> 12
}
func (o *DFSDM_Type) SetCH4CFGR1_CHINSEL(value uint32) {
	volatile.StoreUint32(&o.CH4CFGR1.Reg, volatile.LoadUint32(&o.CH4CFGR1.Reg)&^(0x100)|value<<8)
}
func (o *DFSDM_Type) GetCH4CFGR1_CHINSEL() uint32 {
	return (volatile.LoadUint32(&o.CH4CFGR1.Reg) & 0x100) >> 8
}
func (o *DFSDM_Type) SetCH4CFGR1_CHEN(value uint32) {
	volatile.StoreUint32(&o.CH4CFGR1.Reg, volatile.LoadUint32(&o.CH4CFGR1.Reg)&^(0x80)|value<<7)
}
func (o *DFSDM_Type) GetCH4CFGR1_CHEN() uint32 {
	return (volatile.LoadUint32(&o.CH4CFGR1.Reg) & 0x80) >> 7
}
func (o *DFSDM_Type) SetCH4CFGR1_CKABEN(value uint32) {
	volatile.StoreUint32(&o.CH4CFGR1.Reg, volatile.LoadUint32(&o.CH4CFGR1.Reg)&^(0x40)|value<<6)
}
func (o *DFSDM_Type) GetCH4CFGR1_CKABEN() uint32 {
	return (volatile.LoadUint32(&o.CH4CFGR1.Reg) & 0x40) >> 6
}
func (o *DFSDM_Type) SetCH4CFGR1_SCDEN(value uint32) {
	volatile.StoreUint32(&o.CH4CFGR1.Reg, volatile.LoadUint32(&o.CH4CFGR1.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_Type) GetCH4CFGR1_SCDEN() uint32 {
	return (volatile.LoadUint32(&o.CH4CFGR1.Reg) & 0x20) >> 5
}
func (o *DFSDM_Type) SetCH4CFGR1_SPICKSEL(value uint32) {
	volatile.StoreUint32(&o.CH4CFGR1.Reg, volatile.LoadUint32(&o.CH4CFGR1.Reg)&^(0xc)|value<<2)
}
func (o *DFSDM_Type) GetCH4CFGR1_SPICKSEL() uint32 {
	return (volatile.LoadUint32(&o.CH4CFGR1.Reg) & 0xc) >> 2
}
func (o *DFSDM_Type) SetCH4CFGR1_SITP(value uint32) {
	volatile.StoreUint32(&o.CH4CFGR1.Reg, volatile.LoadUint32(&o.CH4CFGR1.Reg)&^(0x3)|value)
}
func (o *DFSDM_Type) GetCH4CFGR1_SITP() uint32 {
	return volatile.LoadUint32(&o.CH4CFGR1.Reg) & 0x3
}
func (o *DFSDM_Type) SetCH4CFGR1_CKOUTDIV(value uint32) {
	volatile.StoreUint32(&o.CH4CFGR1.Reg, volatile.LoadUint32(&o.CH4CFGR1.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_Type) GetCH4CFGR1_CKOUTDIV() uint32 {
	return (volatile.LoadUint32(&o.CH4CFGR1.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_Type) SetCH4CFGR1_CKOUTSRC(value uint32) {
	volatile.StoreUint32(&o.CH4CFGR1.Reg, volatile.LoadUint32(&o.CH4CFGR1.Reg)&^(0x40000000)|value<<30)
}
func (o *DFSDM_Type) GetCH4CFGR1_CKOUTSRC() uint32 {
	return (volatile.LoadUint32(&o.CH4CFGR1.Reg) & 0x40000000) >> 30
}
func (o *DFSDM_Type) SetCH4CFGR1_DFSDMEN(value uint32) {
	volatile.StoreUint32(&o.CH4CFGR1.Reg, volatile.LoadUint32(&o.CH4CFGR1.Reg)&^(0x80000000)|value<<31)
}
func (o *DFSDM_Type) GetCH4CFGR1_DFSDMEN() uint32 {
	return (volatile.LoadUint32(&o.CH4CFGR1.Reg) & 0x80000000) >> 31
}

// DFSDM.CH4CFGR2: CHCFG4R2
func (o *DFSDM_Type) SetCH4CFGR2_OFFSET(value uint32) {
	volatile.StoreUint32(&o.CH4CFGR2.Reg, volatile.LoadUint32(&o.CH4CFGR2.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetCH4CFGR2_OFFSET() uint32 {
	return (volatile.LoadUint32(&o.CH4CFGR2.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetCH4CFGR2_DTRBS(value uint32) {
	volatile.StoreUint32(&o.CH4CFGR2.Reg, volatile.LoadUint32(&o.CH4CFGR2.Reg)&^(0xf8)|value<<3)
}
func (o *DFSDM_Type) GetCH4CFGR2_DTRBS() uint32 {
	return (volatile.LoadUint32(&o.CH4CFGR2.Reg) & 0xf8) >> 3
}

// DFSDM.CH4AWSCDR: AWSCD4R
func (o *DFSDM_Type) SetCH4AWSCDR_AWFORD(value uint32) {
	volatile.StoreUint32(&o.CH4AWSCDR.Reg, volatile.LoadUint32(&o.CH4AWSCDR.Reg)&^(0xc00000)|value<<22)
}
func (o *DFSDM_Type) GetCH4AWSCDR_AWFORD() uint32 {
	return (volatile.LoadUint32(&o.CH4AWSCDR.Reg) & 0xc00000) >> 22
}
func (o *DFSDM_Type) SetCH4AWSCDR_AWFOSR(value uint32) {
	volatile.StoreUint32(&o.CH4AWSCDR.Reg, volatile.LoadUint32(&o.CH4AWSCDR.Reg)&^(0x1f0000)|value<<16)
}
func (o *DFSDM_Type) GetCH4AWSCDR_AWFOSR() uint32 {
	return (volatile.LoadUint32(&o.CH4AWSCDR.Reg) & 0x1f0000) >> 16
}
func (o *DFSDM_Type) SetCH4AWSCDR_BKSCD(value uint32) {
	volatile.StoreUint32(&o.CH4AWSCDR.Reg, volatile.LoadUint32(&o.CH4AWSCDR.Reg)&^(0xf000)|value<<12)
}
func (o *DFSDM_Type) GetCH4AWSCDR_BKSCD() uint32 {
	return (volatile.LoadUint32(&o.CH4AWSCDR.Reg) & 0xf000) >> 12
}
func (o *DFSDM_Type) SetCH4AWSCDR_SCDT(value uint32) {
	volatile.StoreUint32(&o.CH4AWSCDR.Reg, volatile.LoadUint32(&o.CH4AWSCDR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetCH4AWSCDR_SCDT() uint32 {
	return volatile.LoadUint32(&o.CH4AWSCDR.Reg) & 0xff
}

// DFSDM.CH4WDATR: CHWDAT4R
func (o *DFSDM_Type) SetCH4WDATR_WDATA(value uint32) {
	volatile.StoreUint32(&o.CH4WDATR.Reg, volatile.LoadUint32(&o.CH4WDATR.Reg)&^(0xffff)|value)
}
func (o *DFSDM_Type) GetCH4WDATR_WDATA() uint32 {
	return volatile.LoadUint32(&o.CH4WDATR.Reg) & 0xffff
}

// DFSDM.CH4DATINR: CHDATIN4R
func (o *DFSDM_Type) SetCH4DATINR_INDAT1(value uint32) {
	volatile.StoreUint32(&o.CH4DATINR.Reg, volatile.LoadUint32(&o.CH4DATINR.Reg)&^(0xffff0000)|value<<16)
}
func (o *DFSDM_Type) GetCH4DATINR_INDAT1() uint32 {
	return (volatile.LoadUint32(&o.CH4DATINR.Reg) & 0xffff0000) >> 16
}
func (o *DFSDM_Type) SetCH4DATINR_INDAT0(value uint32) {
	volatile.StoreUint32(&o.CH4DATINR.Reg, volatile.LoadUint32(&o.CH4DATINR.Reg)&^(0xffff)|value)
}
func (o *DFSDM_Type) GetCH4DATINR_INDAT0() uint32 {
	return volatile.LoadUint32(&o.CH4DATINR.Reg) & 0xffff
}

// DFSDM.CH4DLYR: DFSDM channel y delay register
func (o *DFSDM_Type) SetCH4DLYR_PLSSKP(value uint32) {
	volatile.StoreUint32(&o.CH4DLYR.Reg, volatile.LoadUint32(&o.CH4DLYR.Reg)&^(0x3f)|value)
}
func (o *DFSDM_Type) GetCH4DLYR_PLSSKP() uint32 {
	return volatile.LoadUint32(&o.CH4DLYR.Reg) & 0x3f
}

// DFSDM.CH5CFGR1: CHCFG5R1
func (o *DFSDM_Type) SetCH5CFGR1_DATPACK(value uint32) {
	volatile.StoreUint32(&o.CH5CFGR1.Reg, volatile.LoadUint32(&o.CH5CFGR1.Reg)&^(0xc000)|value<<14)
}
func (o *DFSDM_Type) GetCH5CFGR1_DATPACK() uint32 {
	return (volatile.LoadUint32(&o.CH5CFGR1.Reg) & 0xc000) >> 14
}
func (o *DFSDM_Type) SetCH5CFGR1_DATMPX(value uint32) {
	volatile.StoreUint32(&o.CH5CFGR1.Reg, volatile.LoadUint32(&o.CH5CFGR1.Reg)&^(0x3000)|value<<12)
}
func (o *DFSDM_Type) GetCH5CFGR1_DATMPX() uint32 {
	return (volatile.LoadUint32(&o.CH5CFGR1.Reg) & 0x3000) >> 12
}
func (o *DFSDM_Type) SetCH5CFGR1_CHINSEL(value uint32) {
	volatile.StoreUint32(&o.CH5CFGR1.Reg, volatile.LoadUint32(&o.CH5CFGR1.Reg)&^(0x100)|value<<8)
}
func (o *DFSDM_Type) GetCH5CFGR1_CHINSEL() uint32 {
	return (volatile.LoadUint32(&o.CH5CFGR1.Reg) & 0x100) >> 8
}
func (o *DFSDM_Type) SetCH5CFGR1_CHEN(value uint32) {
	volatile.StoreUint32(&o.CH5CFGR1.Reg, volatile.LoadUint32(&o.CH5CFGR1.Reg)&^(0x80)|value<<7)
}
func (o *DFSDM_Type) GetCH5CFGR1_CHEN() uint32 {
	return (volatile.LoadUint32(&o.CH5CFGR1.Reg) & 0x80) >> 7
}
func (o *DFSDM_Type) SetCH5CFGR1_CKABEN(value uint32) {
	volatile.StoreUint32(&o.CH5CFGR1.Reg, volatile.LoadUint32(&o.CH5CFGR1.Reg)&^(0x40)|value<<6)
}
func (o *DFSDM_Type) GetCH5CFGR1_CKABEN() uint32 {
	return (volatile.LoadUint32(&o.CH5CFGR1.Reg) & 0x40) >> 6
}
func (o *DFSDM_Type) SetCH5CFGR1_SCDEN(value uint32) {
	volatile.StoreUint32(&o.CH5CFGR1.Reg, volatile.LoadUint32(&o.CH5CFGR1.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_Type) GetCH5CFGR1_SCDEN() uint32 {
	return (volatile.LoadUint32(&o.CH5CFGR1.Reg) & 0x20) >> 5
}
func (o *DFSDM_Type) SetCH5CFGR1_SPICKSEL(value uint32) {
	volatile.StoreUint32(&o.CH5CFGR1.Reg, volatile.LoadUint32(&o.CH5CFGR1.Reg)&^(0xc)|value<<2)
}
func (o *DFSDM_Type) GetCH5CFGR1_SPICKSEL() uint32 {
	return (volatile.LoadUint32(&o.CH5CFGR1.Reg) & 0xc) >> 2
}
func (o *DFSDM_Type) SetCH5CFGR1_SITP(value uint32) {
	volatile.StoreUint32(&o.CH5CFGR1.Reg, volatile.LoadUint32(&o.CH5CFGR1.Reg)&^(0x3)|value)
}
func (o *DFSDM_Type) GetCH5CFGR1_SITP() uint32 {
	return volatile.LoadUint32(&o.CH5CFGR1.Reg) & 0x3
}
func (o *DFSDM_Type) SetCH5CFGR1_CKOUTDIV(value uint32) {
	volatile.StoreUint32(&o.CH5CFGR1.Reg, volatile.LoadUint32(&o.CH5CFGR1.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_Type) GetCH5CFGR1_CKOUTDIV() uint32 {
	return (volatile.LoadUint32(&o.CH5CFGR1.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_Type) SetCH5CFGR1_CKOUTSRC(value uint32) {
	volatile.StoreUint32(&o.CH5CFGR1.Reg, volatile.LoadUint32(&o.CH5CFGR1.Reg)&^(0x40000000)|value<<30)
}
func (o *DFSDM_Type) GetCH5CFGR1_CKOUTSRC() uint32 {
	return (volatile.LoadUint32(&o.CH5CFGR1.Reg) & 0x40000000) >> 30
}
func (o *DFSDM_Type) SetCH5CFGR1_DFSDMEN(value uint32) {
	volatile.StoreUint32(&o.CH5CFGR1.Reg, volatile.LoadUint32(&o.CH5CFGR1.Reg)&^(0x80000000)|value<<31)
}
func (o *DFSDM_Type) GetCH5CFGR1_DFSDMEN() uint32 {
	return (volatile.LoadUint32(&o.CH5CFGR1.Reg) & 0x80000000) >> 31
}

// DFSDM.CH5CFGR2: CHCFG5R2
func (o *DFSDM_Type) SetCH5CFGR2_OFFSET(value uint32) {
	volatile.StoreUint32(&o.CH5CFGR2.Reg, volatile.LoadUint32(&o.CH5CFGR2.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetCH5CFGR2_OFFSET() uint32 {
	return (volatile.LoadUint32(&o.CH5CFGR2.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetCH5CFGR2_DTRBS(value uint32) {
	volatile.StoreUint32(&o.CH5CFGR2.Reg, volatile.LoadUint32(&o.CH5CFGR2.Reg)&^(0xf8)|value<<3)
}
func (o *DFSDM_Type) GetCH5CFGR2_DTRBS() uint32 {
	return (volatile.LoadUint32(&o.CH5CFGR2.Reg) & 0xf8) >> 3
}

// DFSDM.CH5AWSCDR: AWSCD5R
func (o *DFSDM_Type) SetCH5AWSCDR_AWFORD(value uint32) {
	volatile.StoreUint32(&o.CH5AWSCDR.Reg, volatile.LoadUint32(&o.CH5AWSCDR.Reg)&^(0xc00000)|value<<22)
}
func (o *DFSDM_Type) GetCH5AWSCDR_AWFORD() uint32 {
	return (volatile.LoadUint32(&o.CH5AWSCDR.Reg) & 0xc00000) >> 22
}
func (o *DFSDM_Type) SetCH5AWSCDR_AWFOSR(value uint32) {
	volatile.StoreUint32(&o.CH5AWSCDR.Reg, volatile.LoadUint32(&o.CH5AWSCDR.Reg)&^(0x1f0000)|value<<16)
}
func (o *DFSDM_Type) GetCH5AWSCDR_AWFOSR() uint32 {
	return (volatile.LoadUint32(&o.CH5AWSCDR.Reg) & 0x1f0000) >> 16
}
func (o *DFSDM_Type) SetCH5AWSCDR_BKSCD(value uint32) {
	volatile.StoreUint32(&o.CH5AWSCDR.Reg, volatile.LoadUint32(&o.CH5AWSCDR.Reg)&^(0xf000)|value<<12)
}
func (o *DFSDM_Type) GetCH5AWSCDR_BKSCD() uint32 {
	return (volatile.LoadUint32(&o.CH5AWSCDR.Reg) & 0xf000) >> 12
}
func (o *DFSDM_Type) SetCH5AWSCDR_SCDT(value uint32) {
	volatile.StoreUint32(&o.CH5AWSCDR.Reg, volatile.LoadUint32(&o.CH5AWSCDR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetCH5AWSCDR_SCDT() uint32 {
	return volatile.LoadUint32(&o.CH5AWSCDR.Reg) & 0xff
}

// DFSDM.CH5WDATR: CHWDAT5R
func (o *DFSDM_Type) SetCH5WDATR_WDATA(value uint32) {
	volatile.StoreUint32(&o.CH5WDATR.Reg, volatile.LoadUint32(&o.CH5WDATR.Reg)&^(0xffff)|value)
}
func (o *DFSDM_Type) GetCH5WDATR_WDATA() uint32 {
	return volatile.LoadUint32(&o.CH5WDATR.Reg) & 0xffff
}

// DFSDM.CH5DATINR: CHDATIN5R
func (o *DFSDM_Type) SetCH5DATINR_INDAT1(value uint32) {
	volatile.StoreUint32(&o.CH5DATINR.Reg, volatile.LoadUint32(&o.CH5DATINR.Reg)&^(0xffff0000)|value<<16)
}
func (o *DFSDM_Type) GetCH5DATINR_INDAT1() uint32 {
	return (volatile.LoadUint32(&o.CH5DATINR.Reg) & 0xffff0000) >> 16
}
func (o *DFSDM_Type) SetCH5DATINR_INDAT0(value uint32) {
	volatile.StoreUint32(&o.CH5DATINR.Reg, volatile.LoadUint32(&o.CH5DATINR.Reg)&^(0xffff)|value)
}
func (o *DFSDM_Type) GetCH5DATINR_INDAT0() uint32 {
	return volatile.LoadUint32(&o.CH5DATINR.Reg) & 0xffff
}

// DFSDM.CH5DLYR: DFSDM channel y delay register
func (o *DFSDM_Type) SetCH5DLYR_PLSSKP(value uint32) {
	volatile.StoreUint32(&o.CH5DLYR.Reg, volatile.LoadUint32(&o.CH5DLYR.Reg)&^(0x3f)|value)
}
func (o *DFSDM_Type) GetCH5DLYR_PLSSKP() uint32 {
	return volatile.LoadUint32(&o.CH5DLYR.Reg) & 0x3f
}

// DFSDM.CH6CFGR1: CHCFG6R1
func (o *DFSDM_Type) SetCH6CFGR1_DATPACK(value uint32) {
	volatile.StoreUint32(&o.CH6CFGR1.Reg, volatile.LoadUint32(&o.CH6CFGR1.Reg)&^(0xc000)|value<<14)
}
func (o *DFSDM_Type) GetCH6CFGR1_DATPACK() uint32 {
	return (volatile.LoadUint32(&o.CH6CFGR1.Reg) & 0xc000) >> 14
}
func (o *DFSDM_Type) SetCH6CFGR1_DATMPX(value uint32) {
	volatile.StoreUint32(&o.CH6CFGR1.Reg, volatile.LoadUint32(&o.CH6CFGR1.Reg)&^(0x3000)|value<<12)
}
func (o *DFSDM_Type) GetCH6CFGR1_DATMPX() uint32 {
	return (volatile.LoadUint32(&o.CH6CFGR1.Reg) & 0x3000) >> 12
}
func (o *DFSDM_Type) SetCH6CFGR1_CHINSEL(value uint32) {
	volatile.StoreUint32(&o.CH6CFGR1.Reg, volatile.LoadUint32(&o.CH6CFGR1.Reg)&^(0x100)|value<<8)
}
func (o *DFSDM_Type) GetCH6CFGR1_CHINSEL() uint32 {
	return (volatile.LoadUint32(&o.CH6CFGR1.Reg) & 0x100) >> 8
}
func (o *DFSDM_Type) SetCH6CFGR1_CHEN(value uint32) {
	volatile.StoreUint32(&o.CH6CFGR1.Reg, volatile.LoadUint32(&o.CH6CFGR1.Reg)&^(0x80)|value<<7)
}
func (o *DFSDM_Type) GetCH6CFGR1_CHEN() uint32 {
	return (volatile.LoadUint32(&o.CH6CFGR1.Reg) & 0x80) >> 7
}
func (o *DFSDM_Type) SetCH6CFGR1_CKABEN(value uint32) {
	volatile.StoreUint32(&o.CH6CFGR1.Reg, volatile.LoadUint32(&o.CH6CFGR1.Reg)&^(0x40)|value<<6)
}
func (o *DFSDM_Type) GetCH6CFGR1_CKABEN() uint32 {
	return (volatile.LoadUint32(&o.CH6CFGR1.Reg) & 0x40) >> 6
}
func (o *DFSDM_Type) SetCH6CFGR1_SCDEN(value uint32) {
	volatile.StoreUint32(&o.CH6CFGR1.Reg, volatile.LoadUint32(&o.CH6CFGR1.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_Type) GetCH6CFGR1_SCDEN() uint32 {
	return (volatile.LoadUint32(&o.CH6CFGR1.Reg) & 0x20) >> 5
}
func (o *DFSDM_Type) SetCH6CFGR1_SPICKSEL(value uint32) {
	volatile.StoreUint32(&o.CH6CFGR1.Reg, volatile.LoadUint32(&o.CH6CFGR1.Reg)&^(0xc)|value<<2)
}
func (o *DFSDM_Type) GetCH6CFGR1_SPICKSEL() uint32 {
	return (volatile.LoadUint32(&o.CH6CFGR1.Reg) & 0xc) >> 2
}
func (o *DFSDM_Type) SetCH6CFGR1_SITP(value uint32) {
	volatile.StoreUint32(&o.CH6CFGR1.Reg, volatile.LoadUint32(&o.CH6CFGR1.Reg)&^(0x3)|value)
}
func (o *DFSDM_Type) GetCH6CFGR1_SITP() uint32 {
	return volatile.LoadUint32(&o.CH6CFGR1.Reg) & 0x3
}
func (o *DFSDM_Type) SetCH6CFGR1_CKOUTDIV(value uint32) {
	volatile.StoreUint32(&o.CH6CFGR1.Reg, volatile.LoadUint32(&o.CH6CFGR1.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_Type) GetCH6CFGR1_CKOUTDIV() uint32 {
	return (volatile.LoadUint32(&o.CH6CFGR1.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_Type) SetCH6CFGR1_CKOUTSRC(value uint32) {
	volatile.StoreUint32(&o.CH6CFGR1.Reg, volatile.LoadUint32(&o.CH6CFGR1.Reg)&^(0x40000000)|value<<30)
}
func (o *DFSDM_Type) GetCH6CFGR1_CKOUTSRC() uint32 {
	return (volatile.LoadUint32(&o.CH6CFGR1.Reg) & 0x40000000) >> 30
}
func (o *DFSDM_Type) SetCH6CFGR1_DFSDMEN(value uint32) {
	volatile.StoreUint32(&o.CH6CFGR1.Reg, volatile.LoadUint32(&o.CH6CFGR1.Reg)&^(0x80000000)|value<<31)
}
func (o *DFSDM_Type) GetCH6CFGR1_DFSDMEN() uint32 {
	return (volatile.LoadUint32(&o.CH6CFGR1.Reg) & 0x80000000) >> 31
}

// DFSDM.CH6CFGR2: CH6CFGR2
func (o *DFSDM_Type) SetCH6CFGR2_OFFSET(value uint32) {
	volatile.StoreUint32(&o.CH6CFGR2.Reg, volatile.LoadUint32(&o.CH6CFGR2.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetCH6CFGR2_OFFSET() uint32 {
	return (volatile.LoadUint32(&o.CH6CFGR2.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetCH6CFGR2_DTRBS(value uint32) {
	volatile.StoreUint32(&o.CH6CFGR2.Reg, volatile.LoadUint32(&o.CH6CFGR2.Reg)&^(0xf8)|value<<3)
}
func (o *DFSDM_Type) GetCH6CFGR2_DTRBS() uint32 {
	return (volatile.LoadUint32(&o.CH6CFGR2.Reg) & 0xf8) >> 3
}

// DFSDM.CH6AWSCDR: AWSCD6R
func (o *DFSDM_Type) SetCH6AWSCDR_AWFORD(value uint32) {
	volatile.StoreUint32(&o.CH6AWSCDR.Reg, volatile.LoadUint32(&o.CH6AWSCDR.Reg)&^(0xc00000)|value<<22)
}
func (o *DFSDM_Type) GetCH6AWSCDR_AWFORD() uint32 {
	return (volatile.LoadUint32(&o.CH6AWSCDR.Reg) & 0xc00000) >> 22
}
func (o *DFSDM_Type) SetCH6AWSCDR_AWFOSR(value uint32) {
	volatile.StoreUint32(&o.CH6AWSCDR.Reg, volatile.LoadUint32(&o.CH6AWSCDR.Reg)&^(0x1f0000)|value<<16)
}
func (o *DFSDM_Type) GetCH6AWSCDR_AWFOSR() uint32 {
	return (volatile.LoadUint32(&o.CH6AWSCDR.Reg) & 0x1f0000) >> 16
}
func (o *DFSDM_Type) SetCH6AWSCDR_BKSCD(value uint32) {
	volatile.StoreUint32(&o.CH6AWSCDR.Reg, volatile.LoadUint32(&o.CH6AWSCDR.Reg)&^(0xf000)|value<<12)
}
func (o *DFSDM_Type) GetCH6AWSCDR_BKSCD() uint32 {
	return (volatile.LoadUint32(&o.CH6AWSCDR.Reg) & 0xf000) >> 12
}
func (o *DFSDM_Type) SetCH6AWSCDR_SCDT(value uint32) {
	volatile.StoreUint32(&o.CH6AWSCDR.Reg, volatile.LoadUint32(&o.CH6AWSCDR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetCH6AWSCDR_SCDT() uint32 {
	return volatile.LoadUint32(&o.CH6AWSCDR.Reg) & 0xff
}

// DFSDM.CH6WDATR: CHWDAT6R
func (o *DFSDM_Type) SetCH6WDATR_WDATA(value uint32) {
	volatile.StoreUint32(&o.CH6WDATR.Reg, volatile.LoadUint32(&o.CH6WDATR.Reg)&^(0xffff)|value)
}
func (o *DFSDM_Type) GetCH6WDATR_WDATA() uint32 {
	return volatile.LoadUint32(&o.CH6WDATR.Reg) & 0xffff
}

// DFSDM.CH6DATINR: CHDATIN6R
func (o *DFSDM_Type) SetCH6DATINR_INDAT1(value uint32) {
	volatile.StoreUint32(&o.CH6DATINR.Reg, volatile.LoadUint32(&o.CH6DATINR.Reg)&^(0xffff0000)|value<<16)
}
func (o *DFSDM_Type) GetCH6DATINR_INDAT1() uint32 {
	return (volatile.LoadUint32(&o.CH6DATINR.Reg) & 0xffff0000) >> 16
}
func (o *DFSDM_Type) SetCH6DATINR_INDAT0(value uint32) {
	volatile.StoreUint32(&o.CH6DATINR.Reg, volatile.LoadUint32(&o.CH6DATINR.Reg)&^(0xffff)|value)
}
func (o *DFSDM_Type) GetCH6DATINR_INDAT0() uint32 {
	return volatile.LoadUint32(&o.CH6DATINR.Reg) & 0xffff
}

// DFSDM.CH6DLYR: DFSDM channel y delay register
func (o *DFSDM_Type) SetCH6DLYR_PLSSKP(value uint32) {
	volatile.StoreUint32(&o.CH6DLYR.Reg, volatile.LoadUint32(&o.CH6DLYR.Reg)&^(0x3f)|value)
}
func (o *DFSDM_Type) GetCH6DLYR_PLSSKP() uint32 {
	return volatile.LoadUint32(&o.CH6DLYR.Reg) & 0x3f
}

// DFSDM.CH7CFGR1: CHCFG7R1
func (o *DFSDM_Type) SetCH7CFGR1_DATPACK(value uint32) {
	volatile.StoreUint32(&o.CH7CFGR1.Reg, volatile.LoadUint32(&o.CH7CFGR1.Reg)&^(0xc000)|value<<14)
}
func (o *DFSDM_Type) GetCH7CFGR1_DATPACK() uint32 {
	return (volatile.LoadUint32(&o.CH7CFGR1.Reg) & 0xc000) >> 14
}
func (o *DFSDM_Type) SetCH7CFGR1_DATMPX(value uint32) {
	volatile.StoreUint32(&o.CH7CFGR1.Reg, volatile.LoadUint32(&o.CH7CFGR1.Reg)&^(0x3000)|value<<12)
}
func (o *DFSDM_Type) GetCH7CFGR1_DATMPX() uint32 {
	return (volatile.LoadUint32(&o.CH7CFGR1.Reg) & 0x3000) >> 12
}
func (o *DFSDM_Type) SetCH7CFGR1_CHINSEL(value uint32) {
	volatile.StoreUint32(&o.CH7CFGR1.Reg, volatile.LoadUint32(&o.CH7CFGR1.Reg)&^(0x100)|value<<8)
}
func (o *DFSDM_Type) GetCH7CFGR1_CHINSEL() uint32 {
	return (volatile.LoadUint32(&o.CH7CFGR1.Reg) & 0x100) >> 8
}
func (o *DFSDM_Type) SetCH7CFGR1_CHEN(value uint32) {
	volatile.StoreUint32(&o.CH7CFGR1.Reg, volatile.LoadUint32(&o.CH7CFGR1.Reg)&^(0x80)|value<<7)
}
func (o *DFSDM_Type) GetCH7CFGR1_CHEN() uint32 {
	return (volatile.LoadUint32(&o.CH7CFGR1.Reg) & 0x80) >> 7
}
func (o *DFSDM_Type) SetCH7CFGR1_CKABEN(value uint32) {
	volatile.StoreUint32(&o.CH7CFGR1.Reg, volatile.LoadUint32(&o.CH7CFGR1.Reg)&^(0x40)|value<<6)
}
func (o *DFSDM_Type) GetCH7CFGR1_CKABEN() uint32 {
	return (volatile.LoadUint32(&o.CH7CFGR1.Reg) & 0x40) >> 6
}
func (o *DFSDM_Type) SetCH7CFGR1_SCDEN(value uint32) {
	volatile.StoreUint32(&o.CH7CFGR1.Reg, volatile.LoadUint32(&o.CH7CFGR1.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_Type) GetCH7CFGR1_SCDEN() uint32 {
	return (volatile.LoadUint32(&o.CH7CFGR1.Reg) & 0x20) >> 5
}
func (o *DFSDM_Type) SetCH7CFGR1_SPICKSEL(value uint32) {
	volatile.StoreUint32(&o.CH7CFGR1.Reg, volatile.LoadUint32(&o.CH7CFGR1.Reg)&^(0xc)|value<<2)
}
func (o *DFSDM_Type) GetCH7CFGR1_SPICKSEL() uint32 {
	return (volatile.LoadUint32(&o.CH7CFGR1.Reg) & 0xc) >> 2
}
func (o *DFSDM_Type) SetCH7CFGR1_SITP(value uint32) {
	volatile.StoreUint32(&o.CH7CFGR1.Reg, volatile.LoadUint32(&o.CH7CFGR1.Reg)&^(0x3)|value)
}
func (o *DFSDM_Type) GetCH7CFGR1_SITP() uint32 {
	return volatile.LoadUint32(&o.CH7CFGR1.Reg) & 0x3
}
func (o *DFSDM_Type) SetCH7CFGR1_CKOUTDIV(value uint32) {
	volatile.StoreUint32(&o.CH7CFGR1.Reg, volatile.LoadUint32(&o.CH7CFGR1.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_Type) GetCH7CFGR1_CKOUTDIV() uint32 {
	return (volatile.LoadUint32(&o.CH7CFGR1.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_Type) SetCH7CFGR1_CKOUTSRC(value uint32) {
	volatile.StoreUint32(&o.CH7CFGR1.Reg, volatile.LoadUint32(&o.CH7CFGR1.Reg)&^(0x40000000)|value<<30)
}
func (o *DFSDM_Type) GetCH7CFGR1_CKOUTSRC() uint32 {
	return (volatile.LoadUint32(&o.CH7CFGR1.Reg) & 0x40000000) >> 30
}
func (o *DFSDM_Type) SetCH7CFGR1_DFSDMEN(value uint32) {
	volatile.StoreUint32(&o.CH7CFGR1.Reg, volatile.LoadUint32(&o.CH7CFGR1.Reg)&^(0x80000000)|value<<31)
}
func (o *DFSDM_Type) GetCH7CFGR1_DFSDMEN() uint32 {
	return (volatile.LoadUint32(&o.CH7CFGR1.Reg) & 0x80000000) >> 31
}

// DFSDM.CH7CFGR2: CHCFG7R2
func (o *DFSDM_Type) SetCH7CFGR2_OFFSET(value uint32) {
	volatile.StoreUint32(&o.CH7CFGR2.Reg, volatile.LoadUint32(&o.CH7CFGR2.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetCH7CFGR2_OFFSET() uint32 {
	return (volatile.LoadUint32(&o.CH7CFGR2.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetCH7CFGR2_DTRBS(value uint32) {
	volatile.StoreUint32(&o.CH7CFGR2.Reg, volatile.LoadUint32(&o.CH7CFGR2.Reg)&^(0xf8)|value<<3)
}
func (o *DFSDM_Type) GetCH7CFGR2_DTRBS() uint32 {
	return (volatile.LoadUint32(&o.CH7CFGR2.Reg) & 0xf8) >> 3
}

// DFSDM.CH7AWSCDR: AWSCD7R
func (o *DFSDM_Type) SetCH7AWSCDR_AWFORD(value uint32) {
	volatile.StoreUint32(&o.CH7AWSCDR.Reg, volatile.LoadUint32(&o.CH7AWSCDR.Reg)&^(0xc00000)|value<<22)
}
func (o *DFSDM_Type) GetCH7AWSCDR_AWFORD() uint32 {
	return (volatile.LoadUint32(&o.CH7AWSCDR.Reg) & 0xc00000) >> 22
}
func (o *DFSDM_Type) SetCH7AWSCDR_AWFOSR(value uint32) {
	volatile.StoreUint32(&o.CH7AWSCDR.Reg, volatile.LoadUint32(&o.CH7AWSCDR.Reg)&^(0x1f0000)|value<<16)
}
func (o *DFSDM_Type) GetCH7AWSCDR_AWFOSR() uint32 {
	return (volatile.LoadUint32(&o.CH7AWSCDR.Reg) & 0x1f0000) >> 16
}
func (o *DFSDM_Type) SetCH7AWSCDR_BKSCD(value uint32) {
	volatile.StoreUint32(&o.CH7AWSCDR.Reg, volatile.LoadUint32(&o.CH7AWSCDR.Reg)&^(0xf000)|value<<12)
}
func (o *DFSDM_Type) GetCH7AWSCDR_BKSCD() uint32 {
	return (volatile.LoadUint32(&o.CH7AWSCDR.Reg) & 0xf000) >> 12
}
func (o *DFSDM_Type) SetCH7AWSCDR_SCDT(value uint32) {
	volatile.StoreUint32(&o.CH7AWSCDR.Reg, volatile.LoadUint32(&o.CH7AWSCDR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetCH7AWSCDR_SCDT() uint32 {
	return volatile.LoadUint32(&o.CH7AWSCDR.Reg) & 0xff
}

// DFSDM.CH7WDATR: CHWDAT7R
func (o *DFSDM_Type) SetCH7WDATR_WDATA(value uint32) {
	volatile.StoreUint32(&o.CH7WDATR.Reg, volatile.LoadUint32(&o.CH7WDATR.Reg)&^(0xffff)|value)
}
func (o *DFSDM_Type) GetCH7WDATR_WDATA() uint32 {
	return volatile.LoadUint32(&o.CH7WDATR.Reg) & 0xffff
}

// DFSDM.CH7DATINR: CHDATIN7R
func (o *DFSDM_Type) SetCH7DATINR_INDAT1(value uint32) {
	volatile.StoreUint32(&o.CH7DATINR.Reg, volatile.LoadUint32(&o.CH7DATINR.Reg)&^(0xffff0000)|value<<16)
}
func (o *DFSDM_Type) GetCH7DATINR_INDAT1() uint32 {
	return (volatile.LoadUint32(&o.CH7DATINR.Reg) & 0xffff0000) >> 16
}
func (o *DFSDM_Type) SetCH7DATINR_INDAT0(value uint32) {
	volatile.StoreUint32(&o.CH7DATINR.Reg, volatile.LoadUint32(&o.CH7DATINR.Reg)&^(0xffff)|value)
}
func (o *DFSDM_Type) GetCH7DATINR_INDAT0() uint32 {
	return volatile.LoadUint32(&o.CH7DATINR.Reg) & 0xffff
}

// DFSDM.CH7DLYR: DFSDM channel y delay register
func (o *DFSDM_Type) SetCH7DLYR_PLSSKP(value uint32) {
	volatile.StoreUint32(&o.CH7DLYR.Reg, volatile.LoadUint32(&o.CH7DLYR.Reg)&^(0x3f)|value)
}
func (o *DFSDM_Type) GetCH7DLYR_PLSSKP() uint32 {
	return volatile.LoadUint32(&o.CH7DLYR.Reg) & 0x3f
}

// DFSDM.FLT0CR1: control register 1
func (o *DFSDM_Type) SetFLT0CR1_AWFSEL(value uint32) {
	volatile.StoreUint32(&o.FLT0CR1.Reg, volatile.LoadUint32(&o.FLT0CR1.Reg)&^(0x40000000)|value<<30)
}
func (o *DFSDM_Type) GetFLT0CR1_AWFSEL() uint32 {
	return (volatile.LoadUint32(&o.FLT0CR1.Reg) & 0x40000000) >> 30
}
func (o *DFSDM_Type) SetFLT0CR1_FAST(value uint32) {
	volatile.StoreUint32(&o.FLT0CR1.Reg, volatile.LoadUint32(&o.FLT0CR1.Reg)&^(0x20000000)|value<<29)
}
func (o *DFSDM_Type) GetFLT0CR1_FAST() uint32 {
	return (volatile.LoadUint32(&o.FLT0CR1.Reg) & 0x20000000) >> 29
}
func (o *DFSDM_Type) SetFLT0CR1_RCH(value uint32) {
	volatile.StoreUint32(&o.FLT0CR1.Reg, volatile.LoadUint32(&o.FLT0CR1.Reg)&^(0x7000000)|value<<24)
}
func (o *DFSDM_Type) GetFLT0CR1_RCH() uint32 {
	return (volatile.LoadUint32(&o.FLT0CR1.Reg) & 0x7000000) >> 24
}
func (o *DFSDM_Type) SetFLT0CR1_RDMAEN(value uint32) {
	volatile.StoreUint32(&o.FLT0CR1.Reg, volatile.LoadUint32(&o.FLT0CR1.Reg)&^(0x200000)|value<<21)
}
func (o *DFSDM_Type) GetFLT0CR1_RDMAEN() uint32 {
	return (volatile.LoadUint32(&o.FLT0CR1.Reg) & 0x200000) >> 21
}
func (o *DFSDM_Type) SetFLT0CR1_RSYNC(value uint32) {
	volatile.StoreUint32(&o.FLT0CR1.Reg, volatile.LoadUint32(&o.FLT0CR1.Reg)&^(0x80000)|value<<19)
}
func (o *DFSDM_Type) GetFLT0CR1_RSYNC() uint32 {
	return (volatile.LoadUint32(&o.FLT0CR1.Reg) & 0x80000) >> 19
}
func (o *DFSDM_Type) SetFLT0CR1_RCONT(value uint32) {
	volatile.StoreUint32(&o.FLT0CR1.Reg, volatile.LoadUint32(&o.FLT0CR1.Reg)&^(0x40000)|value<<18)
}
func (o *DFSDM_Type) GetFLT0CR1_RCONT() uint32 {
	return (volatile.LoadUint32(&o.FLT0CR1.Reg) & 0x40000) >> 18
}
func (o *DFSDM_Type) SetFLT0CR1_RSWSTART(value uint32) {
	volatile.StoreUint32(&o.FLT0CR1.Reg, volatile.LoadUint32(&o.FLT0CR1.Reg)&^(0x20000)|value<<17)
}
func (o *DFSDM_Type) GetFLT0CR1_RSWSTART() uint32 {
	return (volatile.LoadUint32(&o.FLT0CR1.Reg) & 0x20000) >> 17
}
func (o *DFSDM_Type) SetFLT0CR1_JEXTEN(value uint32) {
	volatile.StoreUint32(&o.FLT0CR1.Reg, volatile.LoadUint32(&o.FLT0CR1.Reg)&^(0x6000)|value<<13)
}
func (o *DFSDM_Type) GetFLT0CR1_JEXTEN() uint32 {
	return (volatile.LoadUint32(&o.FLT0CR1.Reg) & 0x6000) >> 13
}
func (o *DFSDM_Type) SetFLT0CR1_JEXTSEL(value uint32) {
	volatile.StoreUint32(&o.FLT0CR1.Reg, volatile.LoadUint32(&o.FLT0CR1.Reg)&^(0x700)|value<<8)
}
func (o *DFSDM_Type) GetFLT0CR1_JEXTSEL() uint32 {
	return (volatile.LoadUint32(&o.FLT0CR1.Reg) & 0x700) >> 8
}
func (o *DFSDM_Type) SetFLT0CR1_JDMAEN(value uint32) {
	volatile.StoreUint32(&o.FLT0CR1.Reg, volatile.LoadUint32(&o.FLT0CR1.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_Type) GetFLT0CR1_JDMAEN() uint32 {
	return (volatile.LoadUint32(&o.FLT0CR1.Reg) & 0x20) >> 5
}
func (o *DFSDM_Type) SetFLT0CR1_JSCAN(value uint32) {
	volatile.StoreUint32(&o.FLT0CR1.Reg, volatile.LoadUint32(&o.FLT0CR1.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_Type) GetFLT0CR1_JSCAN() uint32 {
	return (volatile.LoadUint32(&o.FLT0CR1.Reg) & 0x10) >> 4
}
func (o *DFSDM_Type) SetFLT0CR1_JSYNC(value uint32) {
	volatile.StoreUint32(&o.FLT0CR1.Reg, volatile.LoadUint32(&o.FLT0CR1.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_Type) GetFLT0CR1_JSYNC() uint32 {
	return (volatile.LoadUint32(&o.FLT0CR1.Reg) & 0x8) >> 3
}
func (o *DFSDM_Type) SetFLT0CR1_JSWSTART(value uint32) {
	volatile.StoreUint32(&o.FLT0CR1.Reg, volatile.LoadUint32(&o.FLT0CR1.Reg)&^(0x2)|value<<1)
}
func (o *DFSDM_Type) GetFLT0CR1_JSWSTART() uint32 {
	return (volatile.LoadUint32(&o.FLT0CR1.Reg) & 0x2) >> 1
}
func (o *DFSDM_Type) SetFLT0CR1_DFEN(value uint32) {
	volatile.StoreUint32(&o.FLT0CR1.Reg, volatile.LoadUint32(&o.FLT0CR1.Reg)&^(0x1)|value)
}
func (o *DFSDM_Type) GetFLT0CR1_DFEN() uint32 {
	return volatile.LoadUint32(&o.FLT0CR1.Reg) & 0x1
}

// DFSDM.FLT0CR2: control register 2
func (o *DFSDM_Type) SetFLT0CR2_AWDCH(value uint32) {
	volatile.StoreUint32(&o.FLT0CR2.Reg, volatile.LoadUint32(&o.FLT0CR2.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_Type) GetFLT0CR2_AWDCH() uint32 {
	return (volatile.LoadUint32(&o.FLT0CR2.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_Type) SetFLT0CR2_EXCH(value uint32) {
	volatile.StoreUint32(&o.FLT0CR2.Reg, volatile.LoadUint32(&o.FLT0CR2.Reg)&^(0xff00)|value<<8)
}
func (o *DFSDM_Type) GetFLT0CR2_EXCH() uint32 {
	return (volatile.LoadUint32(&o.FLT0CR2.Reg) & 0xff00) >> 8
}
func (o *DFSDM_Type) SetFLT0CR2_CKABIE(value uint32) {
	volatile.StoreUint32(&o.FLT0CR2.Reg, volatile.LoadUint32(&o.FLT0CR2.Reg)&^(0x40)|value<<6)
}
func (o *DFSDM_Type) GetFLT0CR2_CKABIE() uint32 {
	return (volatile.LoadUint32(&o.FLT0CR2.Reg) & 0x40) >> 6
}
func (o *DFSDM_Type) SetFLT0CR2_SCDIE(value uint32) {
	volatile.StoreUint32(&o.FLT0CR2.Reg, volatile.LoadUint32(&o.FLT0CR2.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_Type) GetFLT0CR2_SCDIE() uint32 {
	return (volatile.LoadUint32(&o.FLT0CR2.Reg) & 0x20) >> 5
}
func (o *DFSDM_Type) SetFLT0CR2_AWDIE(value uint32) {
	volatile.StoreUint32(&o.FLT0CR2.Reg, volatile.LoadUint32(&o.FLT0CR2.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_Type) GetFLT0CR2_AWDIE() uint32 {
	return (volatile.LoadUint32(&o.FLT0CR2.Reg) & 0x10) >> 4
}
func (o *DFSDM_Type) SetFLT0CR2_ROVRIE(value uint32) {
	volatile.StoreUint32(&o.FLT0CR2.Reg, volatile.LoadUint32(&o.FLT0CR2.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_Type) GetFLT0CR2_ROVRIE() uint32 {
	return (volatile.LoadUint32(&o.FLT0CR2.Reg) & 0x8) >> 3
}
func (o *DFSDM_Type) SetFLT0CR2_JOVRIE(value uint32) {
	volatile.StoreUint32(&o.FLT0CR2.Reg, volatile.LoadUint32(&o.FLT0CR2.Reg)&^(0x4)|value<<2)
}
func (o *DFSDM_Type) GetFLT0CR2_JOVRIE() uint32 {
	return (volatile.LoadUint32(&o.FLT0CR2.Reg) & 0x4) >> 2
}
func (o *DFSDM_Type) SetFLT0CR2_REOCIE(value uint32) {
	volatile.StoreUint32(&o.FLT0CR2.Reg, volatile.LoadUint32(&o.FLT0CR2.Reg)&^(0x2)|value<<1)
}
func (o *DFSDM_Type) GetFLT0CR2_REOCIE() uint32 {
	return (volatile.LoadUint32(&o.FLT0CR2.Reg) & 0x2) >> 1
}
func (o *DFSDM_Type) SetFLT0CR2_JEOCIE(value uint32) {
	volatile.StoreUint32(&o.FLT0CR2.Reg, volatile.LoadUint32(&o.FLT0CR2.Reg)&^(0x1)|value)
}
func (o *DFSDM_Type) GetFLT0CR2_JEOCIE() uint32 {
	return volatile.LoadUint32(&o.FLT0CR2.Reg) & 0x1
}

// DFSDM.FLT0ISR: interrupt and status register
func (o *DFSDM_Type) SetFLT0ISR_SCDF(value uint32) {
	volatile.StoreUint32(&o.FLT0ISR.Reg, volatile.LoadUint32(&o.FLT0ISR.Reg)&^(0xff000000)|value<<24)
}
func (o *DFSDM_Type) GetFLT0ISR_SCDF() uint32 {
	return (volatile.LoadUint32(&o.FLT0ISR.Reg) & 0xff000000) >> 24
}
func (o *DFSDM_Type) SetFLT0ISR_CKABF(value uint32) {
	volatile.StoreUint32(&o.FLT0ISR.Reg, volatile.LoadUint32(&o.FLT0ISR.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_Type) GetFLT0ISR_CKABF() uint32 {
	return (volatile.LoadUint32(&o.FLT0ISR.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_Type) SetFLT0ISR_RCIP(value uint32) {
	volatile.StoreUint32(&o.FLT0ISR.Reg, volatile.LoadUint32(&o.FLT0ISR.Reg)&^(0x4000)|value<<14)
}
func (o *DFSDM_Type) GetFLT0ISR_RCIP() uint32 {
	return (volatile.LoadUint32(&o.FLT0ISR.Reg) & 0x4000) >> 14
}
func (o *DFSDM_Type) SetFLT0ISR_JCIP(value uint32) {
	volatile.StoreUint32(&o.FLT0ISR.Reg, volatile.LoadUint32(&o.FLT0ISR.Reg)&^(0x2000)|value<<13)
}
func (o *DFSDM_Type) GetFLT0ISR_JCIP() uint32 {
	return (volatile.LoadUint32(&o.FLT0ISR.Reg) & 0x2000) >> 13
}
func (o *DFSDM_Type) SetFLT0ISR_AWDF(value uint32) {
	volatile.StoreUint32(&o.FLT0ISR.Reg, volatile.LoadUint32(&o.FLT0ISR.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_Type) GetFLT0ISR_AWDF() uint32 {
	return (volatile.LoadUint32(&o.FLT0ISR.Reg) & 0x10) >> 4
}
func (o *DFSDM_Type) SetFLT0ISR_ROVRF(value uint32) {
	volatile.StoreUint32(&o.FLT0ISR.Reg, volatile.LoadUint32(&o.FLT0ISR.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_Type) GetFLT0ISR_ROVRF() uint32 {
	return (volatile.LoadUint32(&o.FLT0ISR.Reg) & 0x8) >> 3
}
func (o *DFSDM_Type) SetFLT0ISR_JOVRF(value uint32) {
	volatile.StoreUint32(&o.FLT0ISR.Reg, volatile.LoadUint32(&o.FLT0ISR.Reg)&^(0x4)|value<<2)
}
func (o *DFSDM_Type) GetFLT0ISR_JOVRF() uint32 {
	return (volatile.LoadUint32(&o.FLT0ISR.Reg) & 0x4) >> 2
}
func (o *DFSDM_Type) SetFLT0ISR_REOCF(value uint32) {
	volatile.StoreUint32(&o.FLT0ISR.Reg, volatile.LoadUint32(&o.FLT0ISR.Reg)&^(0x2)|value<<1)
}
func (o *DFSDM_Type) GetFLT0ISR_REOCF() uint32 {
	return (volatile.LoadUint32(&o.FLT0ISR.Reg) & 0x2) >> 1
}
func (o *DFSDM_Type) SetFLT0ISR_JEOCF(value uint32) {
	volatile.StoreUint32(&o.FLT0ISR.Reg, volatile.LoadUint32(&o.FLT0ISR.Reg)&^(0x1)|value)
}
func (o *DFSDM_Type) GetFLT0ISR_JEOCF() uint32 {
	return volatile.LoadUint32(&o.FLT0ISR.Reg) & 0x1
}

// DFSDM.FLT0ICR: interrupt flag clear register
func (o *DFSDM_Type) SetFLT0ICR_CLRSCDF(value uint32) {
	volatile.StoreUint32(&o.FLT0ICR.Reg, volatile.LoadUint32(&o.FLT0ICR.Reg)&^(0xff000000)|value<<24)
}
func (o *DFSDM_Type) GetFLT0ICR_CLRSCDF() uint32 {
	return (volatile.LoadUint32(&o.FLT0ICR.Reg) & 0xff000000) >> 24
}
func (o *DFSDM_Type) SetFLT0ICR_CLRCKABF(value uint32) {
	volatile.StoreUint32(&o.FLT0ICR.Reg, volatile.LoadUint32(&o.FLT0ICR.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_Type) GetFLT0ICR_CLRCKABF() uint32 {
	return (volatile.LoadUint32(&o.FLT0ICR.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_Type) SetFLT0ICR_CLRROVRF(value uint32) {
	volatile.StoreUint32(&o.FLT0ICR.Reg, volatile.LoadUint32(&o.FLT0ICR.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_Type) GetFLT0ICR_CLRROVRF() uint32 {
	return (volatile.LoadUint32(&o.FLT0ICR.Reg) & 0x8) >> 3
}
func (o *DFSDM_Type) SetFLT0ICR_CLRJOVRF(value uint32) {
	volatile.StoreUint32(&o.FLT0ICR.Reg, volatile.LoadUint32(&o.FLT0ICR.Reg)&^(0x4)|value<<2)
}
func (o *DFSDM_Type) GetFLT0ICR_CLRJOVRF() uint32 {
	return (volatile.LoadUint32(&o.FLT0ICR.Reg) & 0x4) >> 2
}

// DFSDM.FLT0JCHGR: injected channel group selection register
func (o *DFSDM_Type) SetFLT0JCHGR_JCHG(value uint32) {
	volatile.StoreUint32(&o.FLT0JCHGR.Reg, volatile.LoadUint32(&o.FLT0JCHGR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetFLT0JCHGR_JCHG() uint32 {
	return volatile.LoadUint32(&o.FLT0JCHGR.Reg) & 0xff
}

// DFSDM.FLT0FCR: filter control register
func (o *DFSDM_Type) SetFLT0FCR_FORD(value uint32) {
	volatile.StoreUint32(&o.FLT0FCR.Reg, volatile.LoadUint32(&o.FLT0FCR.Reg)&^(0xe0000000)|value<<29)
}
func (o *DFSDM_Type) GetFLT0FCR_FORD() uint32 {
	return (volatile.LoadUint32(&o.FLT0FCR.Reg) & 0xe0000000) >> 29
}
func (o *DFSDM_Type) SetFLT0FCR_FOSR(value uint32) {
	volatile.StoreUint32(&o.FLT0FCR.Reg, volatile.LoadUint32(&o.FLT0FCR.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DFSDM_Type) GetFLT0FCR_FOSR() uint32 {
	return (volatile.LoadUint32(&o.FLT0FCR.Reg) & 0x3ff0000) >> 16
}
func (o *DFSDM_Type) SetFLT0FCR_IOSR(value uint32) {
	volatile.StoreUint32(&o.FLT0FCR.Reg, volatile.LoadUint32(&o.FLT0FCR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetFLT0FCR_IOSR() uint32 {
	return volatile.LoadUint32(&o.FLT0FCR.Reg) & 0xff
}

// DFSDM.FLT0JDATAR: data register for injected group
func (o *DFSDM_Type) SetFLT0JDATAR_JDATA(value uint32) {
	volatile.StoreUint32(&o.FLT0JDATAR.Reg, volatile.LoadUint32(&o.FLT0JDATAR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetFLT0JDATAR_JDATA() uint32 {
	return (volatile.LoadUint32(&o.FLT0JDATAR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetFLT0JDATAR_JDATACH(value uint32) {
	volatile.StoreUint32(&o.FLT0JDATAR.Reg, volatile.LoadUint32(&o.FLT0JDATAR.Reg)&^(0x7)|value)
}
func (o *DFSDM_Type) GetFLT0JDATAR_JDATACH() uint32 {
	return volatile.LoadUint32(&o.FLT0JDATAR.Reg) & 0x7
}

// DFSDM.FLT0RDATAR: data register for the regular channel
func (o *DFSDM_Type) SetFLT0RDATAR_RDATA(value uint32) {
	volatile.StoreUint32(&o.FLT0RDATAR.Reg, volatile.LoadUint32(&o.FLT0RDATAR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetFLT0RDATAR_RDATA() uint32 {
	return (volatile.LoadUint32(&o.FLT0RDATAR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetFLT0RDATAR_RPEND(value uint32) {
	volatile.StoreUint32(&o.FLT0RDATAR.Reg, volatile.LoadUint32(&o.FLT0RDATAR.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_Type) GetFLT0RDATAR_RPEND() uint32 {
	return (volatile.LoadUint32(&o.FLT0RDATAR.Reg) & 0x10) >> 4
}
func (o *DFSDM_Type) SetFLT0RDATAR_RDATACH(value uint32) {
	volatile.StoreUint32(&o.FLT0RDATAR.Reg, volatile.LoadUint32(&o.FLT0RDATAR.Reg)&^(0x7)|value)
}
func (o *DFSDM_Type) GetFLT0RDATAR_RDATACH() uint32 {
	return volatile.LoadUint32(&o.FLT0RDATAR.Reg) & 0x7
}

// DFSDM.FLT0AWHTR: analog watchdog high threshold register
func (o *DFSDM_Type) SetFLT0AWHTR_AWHT(value uint32) {
	volatile.StoreUint32(&o.FLT0AWHTR.Reg, volatile.LoadUint32(&o.FLT0AWHTR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetFLT0AWHTR_AWHT() uint32 {
	return (volatile.LoadUint32(&o.FLT0AWHTR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetFLT0AWHTR_BKAWH(value uint32) {
	volatile.StoreUint32(&o.FLT0AWHTR.Reg, volatile.LoadUint32(&o.FLT0AWHTR.Reg)&^(0xf)|value)
}
func (o *DFSDM_Type) GetFLT0AWHTR_BKAWH() uint32 {
	return volatile.LoadUint32(&o.FLT0AWHTR.Reg) & 0xf
}

// DFSDM.FLT0AWLTR: analog watchdog low threshold register
func (o *DFSDM_Type) SetFLT0AWLTR_AWLT(value uint32) {
	volatile.StoreUint32(&o.FLT0AWLTR.Reg, volatile.LoadUint32(&o.FLT0AWLTR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetFLT0AWLTR_AWLT() uint32 {
	return (volatile.LoadUint32(&o.FLT0AWLTR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetFLT0AWLTR_BKAWL(value uint32) {
	volatile.StoreUint32(&o.FLT0AWLTR.Reg, volatile.LoadUint32(&o.FLT0AWLTR.Reg)&^(0xf)|value)
}
func (o *DFSDM_Type) GetFLT0AWLTR_BKAWL() uint32 {
	return volatile.LoadUint32(&o.FLT0AWLTR.Reg) & 0xf
}

// DFSDM.FLT0AWSR: analog watchdog status register
func (o *DFSDM_Type) SetFLT0AWSR_AWHTF(value uint32) {
	volatile.StoreUint32(&o.FLT0AWSR.Reg, volatile.LoadUint32(&o.FLT0AWSR.Reg)&^(0xff00)|value<<8)
}
func (o *DFSDM_Type) GetFLT0AWSR_AWHTF() uint32 {
	return (volatile.LoadUint32(&o.FLT0AWSR.Reg) & 0xff00) >> 8
}
func (o *DFSDM_Type) SetFLT0AWSR_AWLTF(value uint32) {
	volatile.StoreUint32(&o.FLT0AWSR.Reg, volatile.LoadUint32(&o.FLT0AWSR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetFLT0AWSR_AWLTF() uint32 {
	return volatile.LoadUint32(&o.FLT0AWSR.Reg) & 0xff
}

// DFSDM.FLT0AWCFR: analog watchdog clear flag register
func (o *DFSDM_Type) SetFLT0AWCFR_CLRAWHTF(value uint32) {
	volatile.StoreUint32(&o.FLT0AWCFR.Reg, volatile.LoadUint32(&o.FLT0AWCFR.Reg)&^(0xff00)|value<<8)
}
func (o *DFSDM_Type) GetFLT0AWCFR_CLRAWHTF() uint32 {
	return (volatile.LoadUint32(&o.FLT0AWCFR.Reg) & 0xff00) >> 8
}
func (o *DFSDM_Type) SetFLT0AWCFR_CLRAWLTF(value uint32) {
	volatile.StoreUint32(&o.FLT0AWCFR.Reg, volatile.LoadUint32(&o.FLT0AWCFR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetFLT0AWCFR_CLRAWLTF() uint32 {
	return volatile.LoadUint32(&o.FLT0AWCFR.Reg) & 0xff
}

// DFSDM.FLT0EXMAX: Extremes detector maximum register
func (o *DFSDM_Type) SetFLT0EXMAX_EXMAX(value uint32) {
	volatile.StoreUint32(&o.FLT0EXMAX.Reg, volatile.LoadUint32(&o.FLT0EXMAX.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetFLT0EXMAX_EXMAX() uint32 {
	return (volatile.LoadUint32(&o.FLT0EXMAX.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetFLT0EXMAX_EXMAXCH(value uint32) {
	volatile.StoreUint32(&o.FLT0EXMAX.Reg, volatile.LoadUint32(&o.FLT0EXMAX.Reg)&^(0x7)|value)
}
func (o *DFSDM_Type) GetFLT0EXMAX_EXMAXCH() uint32 {
	return volatile.LoadUint32(&o.FLT0EXMAX.Reg) & 0x7
}

// DFSDM.FLT0EXMIN: Extremes detector minimum register
func (o *DFSDM_Type) SetFLT0EXMIN_EXMIN(value uint32) {
	volatile.StoreUint32(&o.FLT0EXMIN.Reg, volatile.LoadUint32(&o.FLT0EXMIN.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetFLT0EXMIN_EXMIN() uint32 {
	return (volatile.LoadUint32(&o.FLT0EXMIN.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetFLT0EXMIN_EXMINCH(value uint32) {
	volatile.StoreUint32(&o.FLT0EXMIN.Reg, volatile.LoadUint32(&o.FLT0EXMIN.Reg)&^(0x7)|value)
}
func (o *DFSDM_Type) GetFLT0EXMIN_EXMINCH() uint32 {
	return volatile.LoadUint32(&o.FLT0EXMIN.Reg) & 0x7
}

// DFSDM.FLT0CNVTIMR: conversion timer register
func (o *DFSDM_Type) SetFLT0CNVTIMR_CNVCNT(value uint32) {
	volatile.StoreUint32(&o.FLT0CNVTIMR.Reg, volatile.LoadUint32(&o.FLT0CNVTIMR.Reg)&^(0xfffffff0)|value<<4)
}
func (o *DFSDM_Type) GetFLT0CNVTIMR_CNVCNT() uint32 {
	return (volatile.LoadUint32(&o.FLT0CNVTIMR.Reg) & 0xfffffff0) >> 4
}

// DFSDM.FLT1CR1: control register 1
func (o *DFSDM_Type) SetFLT1CR1_AWFSEL(value uint32) {
	volatile.StoreUint32(&o.FLT1CR1.Reg, volatile.LoadUint32(&o.FLT1CR1.Reg)&^(0x40000000)|value<<30)
}
func (o *DFSDM_Type) GetFLT1CR1_AWFSEL() uint32 {
	return (volatile.LoadUint32(&o.FLT1CR1.Reg) & 0x40000000) >> 30
}
func (o *DFSDM_Type) SetFLT1CR1_FAST(value uint32) {
	volatile.StoreUint32(&o.FLT1CR1.Reg, volatile.LoadUint32(&o.FLT1CR1.Reg)&^(0x20000000)|value<<29)
}
func (o *DFSDM_Type) GetFLT1CR1_FAST() uint32 {
	return (volatile.LoadUint32(&o.FLT1CR1.Reg) & 0x20000000) >> 29
}
func (o *DFSDM_Type) SetFLT1CR1_RCH(value uint32) {
	volatile.StoreUint32(&o.FLT1CR1.Reg, volatile.LoadUint32(&o.FLT1CR1.Reg)&^(0x7000000)|value<<24)
}
func (o *DFSDM_Type) GetFLT1CR1_RCH() uint32 {
	return (volatile.LoadUint32(&o.FLT1CR1.Reg) & 0x7000000) >> 24
}
func (o *DFSDM_Type) SetFLT1CR1_RDMAEN(value uint32) {
	volatile.StoreUint32(&o.FLT1CR1.Reg, volatile.LoadUint32(&o.FLT1CR1.Reg)&^(0x200000)|value<<21)
}
func (o *DFSDM_Type) GetFLT1CR1_RDMAEN() uint32 {
	return (volatile.LoadUint32(&o.FLT1CR1.Reg) & 0x200000) >> 21
}
func (o *DFSDM_Type) SetFLT1CR1_RSYNC(value uint32) {
	volatile.StoreUint32(&o.FLT1CR1.Reg, volatile.LoadUint32(&o.FLT1CR1.Reg)&^(0x80000)|value<<19)
}
func (o *DFSDM_Type) GetFLT1CR1_RSYNC() uint32 {
	return (volatile.LoadUint32(&o.FLT1CR1.Reg) & 0x80000) >> 19
}
func (o *DFSDM_Type) SetFLT1CR1_RCONT(value uint32) {
	volatile.StoreUint32(&o.FLT1CR1.Reg, volatile.LoadUint32(&o.FLT1CR1.Reg)&^(0x40000)|value<<18)
}
func (o *DFSDM_Type) GetFLT1CR1_RCONT() uint32 {
	return (volatile.LoadUint32(&o.FLT1CR1.Reg) & 0x40000) >> 18
}
func (o *DFSDM_Type) SetFLT1CR1_RSWSTART(value uint32) {
	volatile.StoreUint32(&o.FLT1CR1.Reg, volatile.LoadUint32(&o.FLT1CR1.Reg)&^(0x20000)|value<<17)
}
func (o *DFSDM_Type) GetFLT1CR1_RSWSTART() uint32 {
	return (volatile.LoadUint32(&o.FLT1CR1.Reg) & 0x20000) >> 17
}
func (o *DFSDM_Type) SetFLT1CR1_JEXTEN(value uint32) {
	volatile.StoreUint32(&o.FLT1CR1.Reg, volatile.LoadUint32(&o.FLT1CR1.Reg)&^(0x6000)|value<<13)
}
func (o *DFSDM_Type) GetFLT1CR1_JEXTEN() uint32 {
	return (volatile.LoadUint32(&o.FLT1CR1.Reg) & 0x6000) >> 13
}
func (o *DFSDM_Type) SetFLT1CR1_JEXTSEL(value uint32) {
	volatile.StoreUint32(&o.FLT1CR1.Reg, volatile.LoadUint32(&o.FLT1CR1.Reg)&^(0x700)|value<<8)
}
func (o *DFSDM_Type) GetFLT1CR1_JEXTSEL() uint32 {
	return (volatile.LoadUint32(&o.FLT1CR1.Reg) & 0x700) >> 8
}
func (o *DFSDM_Type) SetFLT1CR1_JDMAEN(value uint32) {
	volatile.StoreUint32(&o.FLT1CR1.Reg, volatile.LoadUint32(&o.FLT1CR1.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_Type) GetFLT1CR1_JDMAEN() uint32 {
	return (volatile.LoadUint32(&o.FLT1CR1.Reg) & 0x20) >> 5
}
func (o *DFSDM_Type) SetFLT1CR1_JSCAN(value uint32) {
	volatile.StoreUint32(&o.FLT1CR1.Reg, volatile.LoadUint32(&o.FLT1CR1.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_Type) GetFLT1CR1_JSCAN() uint32 {
	return (volatile.LoadUint32(&o.FLT1CR1.Reg) & 0x10) >> 4
}
func (o *DFSDM_Type) SetFLT1CR1_JSYNC(value uint32) {
	volatile.StoreUint32(&o.FLT1CR1.Reg, volatile.LoadUint32(&o.FLT1CR1.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_Type) GetFLT1CR1_JSYNC() uint32 {
	return (volatile.LoadUint32(&o.FLT1CR1.Reg) & 0x8) >> 3
}
func (o *DFSDM_Type) SetFLT1CR1_JSWSTART(value uint32) {
	volatile.StoreUint32(&o.FLT1CR1.Reg, volatile.LoadUint32(&o.FLT1CR1.Reg)&^(0x2)|value<<1)
}
func (o *DFSDM_Type) GetFLT1CR1_JSWSTART() uint32 {
	return (volatile.LoadUint32(&o.FLT1CR1.Reg) & 0x2) >> 1
}
func (o *DFSDM_Type) SetFLT1CR1_DFEN(value uint32) {
	volatile.StoreUint32(&o.FLT1CR1.Reg, volatile.LoadUint32(&o.FLT1CR1.Reg)&^(0x1)|value)
}
func (o *DFSDM_Type) GetFLT1CR1_DFEN() uint32 {
	return volatile.LoadUint32(&o.FLT1CR1.Reg) & 0x1
}

// DFSDM.FLT1CR2: control register 2
func (o *DFSDM_Type) SetFLT1CR2_AWDCH(value uint32) {
	volatile.StoreUint32(&o.FLT1CR2.Reg, volatile.LoadUint32(&o.FLT1CR2.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_Type) GetFLT1CR2_AWDCH() uint32 {
	return (volatile.LoadUint32(&o.FLT1CR2.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_Type) SetFLT1CR2_EXCH(value uint32) {
	volatile.StoreUint32(&o.FLT1CR2.Reg, volatile.LoadUint32(&o.FLT1CR2.Reg)&^(0xff00)|value<<8)
}
func (o *DFSDM_Type) GetFLT1CR2_EXCH() uint32 {
	return (volatile.LoadUint32(&o.FLT1CR2.Reg) & 0xff00) >> 8
}
func (o *DFSDM_Type) SetFLT1CR2_CKABIE(value uint32) {
	volatile.StoreUint32(&o.FLT1CR2.Reg, volatile.LoadUint32(&o.FLT1CR2.Reg)&^(0x40)|value<<6)
}
func (o *DFSDM_Type) GetFLT1CR2_CKABIE() uint32 {
	return (volatile.LoadUint32(&o.FLT1CR2.Reg) & 0x40) >> 6
}
func (o *DFSDM_Type) SetFLT1CR2_SCDIE(value uint32) {
	volatile.StoreUint32(&o.FLT1CR2.Reg, volatile.LoadUint32(&o.FLT1CR2.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_Type) GetFLT1CR2_SCDIE() uint32 {
	return (volatile.LoadUint32(&o.FLT1CR2.Reg) & 0x20) >> 5
}
func (o *DFSDM_Type) SetFLT1CR2_AWDIE(value uint32) {
	volatile.StoreUint32(&o.FLT1CR2.Reg, volatile.LoadUint32(&o.FLT1CR2.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_Type) GetFLT1CR2_AWDIE() uint32 {
	return (volatile.LoadUint32(&o.FLT1CR2.Reg) & 0x10) >> 4
}
func (o *DFSDM_Type) SetFLT1CR2_ROVRIE(value uint32) {
	volatile.StoreUint32(&o.FLT1CR2.Reg, volatile.LoadUint32(&o.FLT1CR2.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_Type) GetFLT1CR2_ROVRIE() uint32 {
	return (volatile.LoadUint32(&o.FLT1CR2.Reg) & 0x8) >> 3
}
func (o *DFSDM_Type) SetFLT1CR2_JOVRIE(value uint32) {
	volatile.StoreUint32(&o.FLT1CR2.Reg, volatile.LoadUint32(&o.FLT1CR2.Reg)&^(0x4)|value<<2)
}
func (o *DFSDM_Type) GetFLT1CR2_JOVRIE() uint32 {
	return (volatile.LoadUint32(&o.FLT1CR2.Reg) & 0x4) >> 2
}
func (o *DFSDM_Type) SetFLT1CR2_REOCIE(value uint32) {
	volatile.StoreUint32(&o.FLT1CR2.Reg, volatile.LoadUint32(&o.FLT1CR2.Reg)&^(0x2)|value<<1)
}
func (o *DFSDM_Type) GetFLT1CR2_REOCIE() uint32 {
	return (volatile.LoadUint32(&o.FLT1CR2.Reg) & 0x2) >> 1
}
func (o *DFSDM_Type) SetFLT1CR2_JEOCIE(value uint32) {
	volatile.StoreUint32(&o.FLT1CR2.Reg, volatile.LoadUint32(&o.FLT1CR2.Reg)&^(0x1)|value)
}
func (o *DFSDM_Type) GetFLT1CR2_JEOCIE() uint32 {
	return volatile.LoadUint32(&o.FLT1CR2.Reg) & 0x1
}

// DFSDM.FLT1ISR: interrupt and status register
func (o *DFSDM_Type) SetFLT1ISR_SCDF(value uint32) {
	volatile.StoreUint32(&o.FLT1ISR.Reg, volatile.LoadUint32(&o.FLT1ISR.Reg)&^(0xff000000)|value<<24)
}
func (o *DFSDM_Type) GetFLT1ISR_SCDF() uint32 {
	return (volatile.LoadUint32(&o.FLT1ISR.Reg) & 0xff000000) >> 24
}
func (o *DFSDM_Type) SetFLT1ISR_CKABF(value uint32) {
	volatile.StoreUint32(&o.FLT1ISR.Reg, volatile.LoadUint32(&o.FLT1ISR.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_Type) GetFLT1ISR_CKABF() uint32 {
	return (volatile.LoadUint32(&o.FLT1ISR.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_Type) SetFLT1ISR_RCIP(value uint32) {
	volatile.StoreUint32(&o.FLT1ISR.Reg, volatile.LoadUint32(&o.FLT1ISR.Reg)&^(0x4000)|value<<14)
}
func (o *DFSDM_Type) GetFLT1ISR_RCIP() uint32 {
	return (volatile.LoadUint32(&o.FLT1ISR.Reg) & 0x4000) >> 14
}
func (o *DFSDM_Type) SetFLT1ISR_JCIP(value uint32) {
	volatile.StoreUint32(&o.FLT1ISR.Reg, volatile.LoadUint32(&o.FLT1ISR.Reg)&^(0x2000)|value<<13)
}
func (o *DFSDM_Type) GetFLT1ISR_JCIP() uint32 {
	return (volatile.LoadUint32(&o.FLT1ISR.Reg) & 0x2000) >> 13
}
func (o *DFSDM_Type) SetFLT1ISR_AWDF(value uint32) {
	volatile.StoreUint32(&o.FLT1ISR.Reg, volatile.LoadUint32(&o.FLT1ISR.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_Type) GetFLT1ISR_AWDF() uint32 {
	return (volatile.LoadUint32(&o.FLT1ISR.Reg) & 0x10) >> 4
}
func (o *DFSDM_Type) SetFLT1ISR_ROVRF(value uint32) {
	volatile.StoreUint32(&o.FLT1ISR.Reg, volatile.LoadUint32(&o.FLT1ISR.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_Type) GetFLT1ISR_ROVRF() uint32 {
	return (volatile.LoadUint32(&o.FLT1ISR.Reg) & 0x8) >> 3
}
func (o *DFSDM_Type) SetFLT1ISR_JOVRF(value uint32) {
	volatile.StoreUint32(&o.FLT1ISR.Reg, volatile.LoadUint32(&o.FLT1ISR.Reg)&^(0x4)|value<<2)
}
func (o *DFSDM_Type) GetFLT1ISR_JOVRF() uint32 {
	return (volatile.LoadUint32(&o.FLT1ISR.Reg) & 0x4) >> 2
}
func (o *DFSDM_Type) SetFLT1ISR_REOCF(value uint32) {
	volatile.StoreUint32(&o.FLT1ISR.Reg, volatile.LoadUint32(&o.FLT1ISR.Reg)&^(0x2)|value<<1)
}
func (o *DFSDM_Type) GetFLT1ISR_REOCF() uint32 {
	return (volatile.LoadUint32(&o.FLT1ISR.Reg) & 0x2) >> 1
}
func (o *DFSDM_Type) SetFLT1ISR_JEOCF(value uint32) {
	volatile.StoreUint32(&o.FLT1ISR.Reg, volatile.LoadUint32(&o.FLT1ISR.Reg)&^(0x1)|value)
}
func (o *DFSDM_Type) GetFLT1ISR_JEOCF() uint32 {
	return volatile.LoadUint32(&o.FLT1ISR.Reg) & 0x1
}

// DFSDM.FLT1ICR: interrupt flag clear register
func (o *DFSDM_Type) SetFLT1ICR_CLRSCDF(value uint32) {
	volatile.StoreUint32(&o.FLT1ICR.Reg, volatile.LoadUint32(&o.FLT1ICR.Reg)&^(0xff000000)|value<<24)
}
func (o *DFSDM_Type) GetFLT1ICR_CLRSCDF() uint32 {
	return (volatile.LoadUint32(&o.FLT1ICR.Reg) & 0xff000000) >> 24
}
func (o *DFSDM_Type) SetFLT1ICR_CLRCKABF(value uint32) {
	volatile.StoreUint32(&o.FLT1ICR.Reg, volatile.LoadUint32(&o.FLT1ICR.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_Type) GetFLT1ICR_CLRCKABF() uint32 {
	return (volatile.LoadUint32(&o.FLT1ICR.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_Type) SetFLT1ICR_CLRROVRF(value uint32) {
	volatile.StoreUint32(&o.FLT1ICR.Reg, volatile.LoadUint32(&o.FLT1ICR.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_Type) GetFLT1ICR_CLRROVRF() uint32 {
	return (volatile.LoadUint32(&o.FLT1ICR.Reg) & 0x8) >> 3
}
func (o *DFSDM_Type) SetFLT1ICR_CLRJOVRF(value uint32) {
	volatile.StoreUint32(&o.FLT1ICR.Reg, volatile.LoadUint32(&o.FLT1ICR.Reg)&^(0x4)|value<<2)
}
func (o *DFSDM_Type) GetFLT1ICR_CLRJOVRF() uint32 {
	return (volatile.LoadUint32(&o.FLT1ICR.Reg) & 0x4) >> 2
}

// DFSDM.FLT1JCHGR: injected channel group selection register
func (o *DFSDM_Type) SetFLT1JCHGR_JCHG(value uint32) {
	volatile.StoreUint32(&o.FLT1JCHGR.Reg, volatile.LoadUint32(&o.FLT1JCHGR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetFLT1JCHGR_JCHG() uint32 {
	return volatile.LoadUint32(&o.FLT1JCHGR.Reg) & 0xff
}

// DFSDM.FLT1FCR: filter control register
func (o *DFSDM_Type) SetFLT1FCR_FORD(value uint32) {
	volatile.StoreUint32(&o.FLT1FCR.Reg, volatile.LoadUint32(&o.FLT1FCR.Reg)&^(0xe0000000)|value<<29)
}
func (o *DFSDM_Type) GetFLT1FCR_FORD() uint32 {
	return (volatile.LoadUint32(&o.FLT1FCR.Reg) & 0xe0000000) >> 29
}
func (o *DFSDM_Type) SetFLT1FCR_FOSR(value uint32) {
	volatile.StoreUint32(&o.FLT1FCR.Reg, volatile.LoadUint32(&o.FLT1FCR.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DFSDM_Type) GetFLT1FCR_FOSR() uint32 {
	return (volatile.LoadUint32(&o.FLT1FCR.Reg) & 0x3ff0000) >> 16
}
func (o *DFSDM_Type) SetFLT1FCR_IOSR(value uint32) {
	volatile.StoreUint32(&o.FLT1FCR.Reg, volatile.LoadUint32(&o.FLT1FCR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetFLT1FCR_IOSR() uint32 {
	return volatile.LoadUint32(&o.FLT1FCR.Reg) & 0xff
}

// DFSDM.FLT1JDATAR: data register for injected group
func (o *DFSDM_Type) SetFLT1JDATAR_JDATA(value uint32) {
	volatile.StoreUint32(&o.FLT1JDATAR.Reg, volatile.LoadUint32(&o.FLT1JDATAR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetFLT1JDATAR_JDATA() uint32 {
	return (volatile.LoadUint32(&o.FLT1JDATAR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetFLT1JDATAR_JDATACH(value uint32) {
	volatile.StoreUint32(&o.FLT1JDATAR.Reg, volatile.LoadUint32(&o.FLT1JDATAR.Reg)&^(0x7)|value)
}
func (o *DFSDM_Type) GetFLT1JDATAR_JDATACH() uint32 {
	return volatile.LoadUint32(&o.FLT1JDATAR.Reg) & 0x7
}

// DFSDM.FLT1RDATAR: data register for the regular channel
func (o *DFSDM_Type) SetFLT1RDATAR_RDATA(value uint32) {
	volatile.StoreUint32(&o.FLT1RDATAR.Reg, volatile.LoadUint32(&o.FLT1RDATAR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetFLT1RDATAR_RDATA() uint32 {
	return (volatile.LoadUint32(&o.FLT1RDATAR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetFLT1RDATAR_RPEND(value uint32) {
	volatile.StoreUint32(&o.FLT1RDATAR.Reg, volatile.LoadUint32(&o.FLT1RDATAR.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_Type) GetFLT1RDATAR_RPEND() uint32 {
	return (volatile.LoadUint32(&o.FLT1RDATAR.Reg) & 0x10) >> 4
}
func (o *DFSDM_Type) SetFLT1RDATAR_RDATACH(value uint32) {
	volatile.StoreUint32(&o.FLT1RDATAR.Reg, volatile.LoadUint32(&o.FLT1RDATAR.Reg)&^(0x7)|value)
}
func (o *DFSDM_Type) GetFLT1RDATAR_RDATACH() uint32 {
	return volatile.LoadUint32(&o.FLT1RDATAR.Reg) & 0x7
}

// DFSDM.FLT1AWLTR: analog watchdog low threshold register
func (o *DFSDM_Type) SetFLT1AWLTR_AWLT(value uint32) {
	volatile.StoreUint32(&o.FLT1AWLTR.Reg, volatile.LoadUint32(&o.FLT1AWLTR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetFLT1AWLTR_AWLT() uint32 {
	return (volatile.LoadUint32(&o.FLT1AWLTR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetFLT1AWLTR_BKAWL(value uint32) {
	volatile.StoreUint32(&o.FLT1AWLTR.Reg, volatile.LoadUint32(&o.FLT1AWLTR.Reg)&^(0xf)|value)
}
func (o *DFSDM_Type) GetFLT1AWLTR_BKAWL() uint32 {
	return volatile.LoadUint32(&o.FLT1AWLTR.Reg) & 0xf
}

// DFSDM.FLT1AWSR: analog watchdog status register
func (o *DFSDM_Type) SetFLT1AWSR_AWHTF(value uint32) {
	volatile.StoreUint32(&o.FLT1AWSR.Reg, volatile.LoadUint32(&o.FLT1AWSR.Reg)&^(0xff00)|value<<8)
}
func (o *DFSDM_Type) GetFLT1AWSR_AWHTF() uint32 {
	return (volatile.LoadUint32(&o.FLT1AWSR.Reg) & 0xff00) >> 8
}
func (o *DFSDM_Type) SetFLT1AWSR_AWLTF(value uint32) {
	volatile.StoreUint32(&o.FLT1AWSR.Reg, volatile.LoadUint32(&o.FLT1AWSR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetFLT1AWSR_AWLTF() uint32 {
	return volatile.LoadUint32(&o.FLT1AWSR.Reg) & 0xff
}

// DFSDM.FLT1AWHTR: analog watchdog high threshold register
func (o *DFSDM_Type) SetFLT1AWHTR_AWHT(value uint32) {
	volatile.StoreUint32(&o.FLT1AWHTR.Reg, volatile.LoadUint32(&o.FLT1AWHTR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetFLT1AWHTR_AWHT() uint32 {
	return (volatile.LoadUint32(&o.FLT1AWHTR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetFLT1AWHTR_BKAWH(value uint32) {
	volatile.StoreUint32(&o.FLT1AWHTR.Reg, volatile.LoadUint32(&o.FLT1AWHTR.Reg)&^(0xf)|value)
}
func (o *DFSDM_Type) GetFLT1AWHTR_BKAWH() uint32 {
	return volatile.LoadUint32(&o.FLT1AWHTR.Reg) & 0xf
}

// DFSDM.FLT1EXMAX: Extremes detector maximum register
func (o *DFSDM_Type) SetFLT1EXMAX_EXMAX(value uint32) {
	volatile.StoreUint32(&o.FLT1EXMAX.Reg, volatile.LoadUint32(&o.FLT1EXMAX.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetFLT1EXMAX_EXMAX() uint32 {
	return (volatile.LoadUint32(&o.FLT1EXMAX.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetFLT1EXMAX_EXMAXCH(value uint32) {
	volatile.StoreUint32(&o.FLT1EXMAX.Reg, volatile.LoadUint32(&o.FLT1EXMAX.Reg)&^(0x7)|value)
}
func (o *DFSDM_Type) GetFLT1EXMAX_EXMAXCH() uint32 {
	return volatile.LoadUint32(&o.FLT1EXMAX.Reg) & 0x7
}

// DFSDM.FLT1EXMIN: Extremes detector minimum register
func (o *DFSDM_Type) SetFLT1EXMIN_EXMIN(value uint32) {
	volatile.StoreUint32(&o.FLT1EXMIN.Reg, volatile.LoadUint32(&o.FLT1EXMIN.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetFLT1EXMIN_EXMIN() uint32 {
	return (volatile.LoadUint32(&o.FLT1EXMIN.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetFLT1EXMIN_EXMINCH(value uint32) {
	volatile.StoreUint32(&o.FLT1EXMIN.Reg, volatile.LoadUint32(&o.FLT1EXMIN.Reg)&^(0x7)|value)
}
func (o *DFSDM_Type) GetFLT1EXMIN_EXMINCH() uint32 {
	return volatile.LoadUint32(&o.FLT1EXMIN.Reg) & 0x7
}

// DFSDM.FLT1CNVTIMR: conversion timer register
func (o *DFSDM_Type) SetFLT1CNVTIMR_CNVCNT(value uint32) {
	volatile.StoreUint32(&o.FLT1CNVTIMR.Reg, volatile.LoadUint32(&o.FLT1CNVTIMR.Reg)&^(0xfffffff0)|value<<4)
}
func (o *DFSDM_Type) GetFLT1CNVTIMR_CNVCNT() uint32 {
	return (volatile.LoadUint32(&o.FLT1CNVTIMR.Reg) & 0xfffffff0) >> 4
}

// DFSDM.FLT2CR1: control register 1
func (o *DFSDM_Type) SetFLT2CR1_AWFSEL(value uint32) {
	volatile.StoreUint32(&o.FLT2CR1.Reg, volatile.LoadUint32(&o.FLT2CR1.Reg)&^(0x40000000)|value<<30)
}
func (o *DFSDM_Type) GetFLT2CR1_AWFSEL() uint32 {
	return (volatile.LoadUint32(&o.FLT2CR1.Reg) & 0x40000000) >> 30
}
func (o *DFSDM_Type) SetFLT2CR1_FAST(value uint32) {
	volatile.StoreUint32(&o.FLT2CR1.Reg, volatile.LoadUint32(&o.FLT2CR1.Reg)&^(0x20000000)|value<<29)
}
func (o *DFSDM_Type) GetFLT2CR1_FAST() uint32 {
	return (volatile.LoadUint32(&o.FLT2CR1.Reg) & 0x20000000) >> 29
}
func (o *DFSDM_Type) SetFLT2CR1_RCH(value uint32) {
	volatile.StoreUint32(&o.FLT2CR1.Reg, volatile.LoadUint32(&o.FLT2CR1.Reg)&^(0x7000000)|value<<24)
}
func (o *DFSDM_Type) GetFLT2CR1_RCH() uint32 {
	return (volatile.LoadUint32(&o.FLT2CR1.Reg) & 0x7000000) >> 24
}
func (o *DFSDM_Type) SetFLT2CR1_RDMAEN(value uint32) {
	volatile.StoreUint32(&o.FLT2CR1.Reg, volatile.LoadUint32(&o.FLT2CR1.Reg)&^(0x200000)|value<<21)
}
func (o *DFSDM_Type) GetFLT2CR1_RDMAEN() uint32 {
	return (volatile.LoadUint32(&o.FLT2CR1.Reg) & 0x200000) >> 21
}
func (o *DFSDM_Type) SetFLT2CR1_RSYNC(value uint32) {
	volatile.StoreUint32(&o.FLT2CR1.Reg, volatile.LoadUint32(&o.FLT2CR1.Reg)&^(0x80000)|value<<19)
}
func (o *DFSDM_Type) GetFLT2CR1_RSYNC() uint32 {
	return (volatile.LoadUint32(&o.FLT2CR1.Reg) & 0x80000) >> 19
}
func (o *DFSDM_Type) SetFLT2CR1_RCONT(value uint32) {
	volatile.StoreUint32(&o.FLT2CR1.Reg, volatile.LoadUint32(&o.FLT2CR1.Reg)&^(0x40000)|value<<18)
}
func (o *DFSDM_Type) GetFLT2CR1_RCONT() uint32 {
	return (volatile.LoadUint32(&o.FLT2CR1.Reg) & 0x40000) >> 18
}
func (o *DFSDM_Type) SetFLT2CR1_RSWSTART(value uint32) {
	volatile.StoreUint32(&o.FLT2CR1.Reg, volatile.LoadUint32(&o.FLT2CR1.Reg)&^(0x20000)|value<<17)
}
func (o *DFSDM_Type) GetFLT2CR1_RSWSTART() uint32 {
	return (volatile.LoadUint32(&o.FLT2CR1.Reg) & 0x20000) >> 17
}
func (o *DFSDM_Type) SetFLT2CR1_JEXTEN(value uint32) {
	volatile.StoreUint32(&o.FLT2CR1.Reg, volatile.LoadUint32(&o.FLT2CR1.Reg)&^(0x6000)|value<<13)
}
func (o *DFSDM_Type) GetFLT2CR1_JEXTEN() uint32 {
	return (volatile.LoadUint32(&o.FLT2CR1.Reg) & 0x6000) >> 13
}
func (o *DFSDM_Type) SetFLT2CR1_JEXTSEL(value uint32) {
	volatile.StoreUint32(&o.FLT2CR1.Reg, volatile.LoadUint32(&o.FLT2CR1.Reg)&^(0x700)|value<<8)
}
func (o *DFSDM_Type) GetFLT2CR1_JEXTSEL() uint32 {
	return (volatile.LoadUint32(&o.FLT2CR1.Reg) & 0x700) >> 8
}
func (o *DFSDM_Type) SetFLT2CR1_JDMAEN(value uint32) {
	volatile.StoreUint32(&o.FLT2CR1.Reg, volatile.LoadUint32(&o.FLT2CR1.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_Type) GetFLT2CR1_JDMAEN() uint32 {
	return (volatile.LoadUint32(&o.FLT2CR1.Reg) & 0x20) >> 5
}
func (o *DFSDM_Type) SetFLT2CR1_JSCAN(value uint32) {
	volatile.StoreUint32(&o.FLT2CR1.Reg, volatile.LoadUint32(&o.FLT2CR1.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_Type) GetFLT2CR1_JSCAN() uint32 {
	return (volatile.LoadUint32(&o.FLT2CR1.Reg) & 0x10) >> 4
}
func (o *DFSDM_Type) SetFLT2CR1_JSYNC(value uint32) {
	volatile.StoreUint32(&o.FLT2CR1.Reg, volatile.LoadUint32(&o.FLT2CR1.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_Type) GetFLT2CR1_JSYNC() uint32 {
	return (volatile.LoadUint32(&o.FLT2CR1.Reg) & 0x8) >> 3
}
func (o *DFSDM_Type) SetFLT2CR1_JSWSTART(value uint32) {
	volatile.StoreUint32(&o.FLT2CR1.Reg, volatile.LoadUint32(&o.FLT2CR1.Reg)&^(0x2)|value<<1)
}
func (o *DFSDM_Type) GetFLT2CR1_JSWSTART() uint32 {
	return (volatile.LoadUint32(&o.FLT2CR1.Reg) & 0x2) >> 1
}
func (o *DFSDM_Type) SetFLT2CR1_DFEN(value uint32) {
	volatile.StoreUint32(&o.FLT2CR1.Reg, volatile.LoadUint32(&o.FLT2CR1.Reg)&^(0x1)|value)
}
func (o *DFSDM_Type) GetFLT2CR1_DFEN() uint32 {
	return volatile.LoadUint32(&o.FLT2CR1.Reg) & 0x1
}

// DFSDM.FLT2CR2: control register 2
func (o *DFSDM_Type) SetFLT2CR2_AWDCH(value uint32) {
	volatile.StoreUint32(&o.FLT2CR2.Reg, volatile.LoadUint32(&o.FLT2CR2.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_Type) GetFLT2CR2_AWDCH() uint32 {
	return (volatile.LoadUint32(&o.FLT2CR2.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_Type) SetFLT2CR2_EXCH(value uint32) {
	volatile.StoreUint32(&o.FLT2CR2.Reg, volatile.LoadUint32(&o.FLT2CR2.Reg)&^(0xff00)|value<<8)
}
func (o *DFSDM_Type) GetFLT2CR2_EXCH() uint32 {
	return (volatile.LoadUint32(&o.FLT2CR2.Reg) & 0xff00) >> 8
}
func (o *DFSDM_Type) SetFLT2CR2_CKABIE(value uint32) {
	volatile.StoreUint32(&o.FLT2CR2.Reg, volatile.LoadUint32(&o.FLT2CR2.Reg)&^(0x40)|value<<6)
}
func (o *DFSDM_Type) GetFLT2CR2_CKABIE() uint32 {
	return (volatile.LoadUint32(&o.FLT2CR2.Reg) & 0x40) >> 6
}
func (o *DFSDM_Type) SetFLT2CR2_SCDIE(value uint32) {
	volatile.StoreUint32(&o.FLT2CR2.Reg, volatile.LoadUint32(&o.FLT2CR2.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_Type) GetFLT2CR2_SCDIE() uint32 {
	return (volatile.LoadUint32(&o.FLT2CR2.Reg) & 0x20) >> 5
}
func (o *DFSDM_Type) SetFLT2CR2_AWDIE(value uint32) {
	volatile.StoreUint32(&o.FLT2CR2.Reg, volatile.LoadUint32(&o.FLT2CR2.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_Type) GetFLT2CR2_AWDIE() uint32 {
	return (volatile.LoadUint32(&o.FLT2CR2.Reg) & 0x10) >> 4
}
func (o *DFSDM_Type) SetFLT2CR2_ROVRIE(value uint32) {
	volatile.StoreUint32(&o.FLT2CR2.Reg, volatile.LoadUint32(&o.FLT2CR2.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_Type) GetFLT2CR2_ROVRIE() uint32 {
	return (volatile.LoadUint32(&o.FLT2CR2.Reg) & 0x8) >> 3
}
func (o *DFSDM_Type) SetFLT2CR2_JOVRIE(value uint32) {
	volatile.StoreUint32(&o.FLT2CR2.Reg, volatile.LoadUint32(&o.FLT2CR2.Reg)&^(0x4)|value<<2)
}
func (o *DFSDM_Type) GetFLT2CR2_JOVRIE() uint32 {
	return (volatile.LoadUint32(&o.FLT2CR2.Reg) & 0x4) >> 2
}
func (o *DFSDM_Type) SetFLT2CR2_REOCIE(value uint32) {
	volatile.StoreUint32(&o.FLT2CR2.Reg, volatile.LoadUint32(&o.FLT2CR2.Reg)&^(0x2)|value<<1)
}
func (o *DFSDM_Type) GetFLT2CR2_REOCIE() uint32 {
	return (volatile.LoadUint32(&o.FLT2CR2.Reg) & 0x2) >> 1
}
func (o *DFSDM_Type) SetFLT2CR2_JEOCIE(value uint32) {
	volatile.StoreUint32(&o.FLT2CR2.Reg, volatile.LoadUint32(&o.FLT2CR2.Reg)&^(0x1)|value)
}
func (o *DFSDM_Type) GetFLT2CR2_JEOCIE() uint32 {
	return volatile.LoadUint32(&o.FLT2CR2.Reg) & 0x1
}

// DFSDM.FLT2ISR: interrupt and status register
func (o *DFSDM_Type) SetFLT2ISR_SCDF(value uint32) {
	volatile.StoreUint32(&o.FLT2ISR.Reg, volatile.LoadUint32(&o.FLT2ISR.Reg)&^(0xff000000)|value<<24)
}
func (o *DFSDM_Type) GetFLT2ISR_SCDF() uint32 {
	return (volatile.LoadUint32(&o.FLT2ISR.Reg) & 0xff000000) >> 24
}
func (o *DFSDM_Type) SetFLT2ISR_CKABF(value uint32) {
	volatile.StoreUint32(&o.FLT2ISR.Reg, volatile.LoadUint32(&o.FLT2ISR.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_Type) GetFLT2ISR_CKABF() uint32 {
	return (volatile.LoadUint32(&o.FLT2ISR.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_Type) SetFLT2ISR_RCIP(value uint32) {
	volatile.StoreUint32(&o.FLT2ISR.Reg, volatile.LoadUint32(&o.FLT2ISR.Reg)&^(0x4000)|value<<14)
}
func (o *DFSDM_Type) GetFLT2ISR_RCIP() uint32 {
	return (volatile.LoadUint32(&o.FLT2ISR.Reg) & 0x4000) >> 14
}
func (o *DFSDM_Type) SetFLT2ISR_JCIP(value uint32) {
	volatile.StoreUint32(&o.FLT2ISR.Reg, volatile.LoadUint32(&o.FLT2ISR.Reg)&^(0x2000)|value<<13)
}
func (o *DFSDM_Type) GetFLT2ISR_JCIP() uint32 {
	return (volatile.LoadUint32(&o.FLT2ISR.Reg) & 0x2000) >> 13
}
func (o *DFSDM_Type) SetFLT2ISR_AWDF(value uint32) {
	volatile.StoreUint32(&o.FLT2ISR.Reg, volatile.LoadUint32(&o.FLT2ISR.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_Type) GetFLT2ISR_AWDF() uint32 {
	return (volatile.LoadUint32(&o.FLT2ISR.Reg) & 0x10) >> 4
}
func (o *DFSDM_Type) SetFLT2ISR_ROVRF(value uint32) {
	volatile.StoreUint32(&o.FLT2ISR.Reg, volatile.LoadUint32(&o.FLT2ISR.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_Type) GetFLT2ISR_ROVRF() uint32 {
	return (volatile.LoadUint32(&o.FLT2ISR.Reg) & 0x8) >> 3
}
func (o *DFSDM_Type) SetFLT2ISR_JOVRF(value uint32) {
	volatile.StoreUint32(&o.FLT2ISR.Reg, volatile.LoadUint32(&o.FLT2ISR.Reg)&^(0x4)|value<<2)
}
func (o *DFSDM_Type) GetFLT2ISR_JOVRF() uint32 {
	return (volatile.LoadUint32(&o.FLT2ISR.Reg) & 0x4) >> 2
}
func (o *DFSDM_Type) SetFLT2ISR_REOCF(value uint32) {
	volatile.StoreUint32(&o.FLT2ISR.Reg, volatile.LoadUint32(&o.FLT2ISR.Reg)&^(0x2)|value<<1)
}
func (o *DFSDM_Type) GetFLT2ISR_REOCF() uint32 {
	return (volatile.LoadUint32(&o.FLT2ISR.Reg) & 0x2) >> 1
}
func (o *DFSDM_Type) SetFLT2ISR_JEOCF(value uint32) {
	volatile.StoreUint32(&o.FLT2ISR.Reg, volatile.LoadUint32(&o.FLT2ISR.Reg)&^(0x1)|value)
}
func (o *DFSDM_Type) GetFLT2ISR_JEOCF() uint32 {
	return volatile.LoadUint32(&o.FLT2ISR.Reg) & 0x1
}

// DFSDM.FLT2ICR: interrupt flag clear register
func (o *DFSDM_Type) SetFLT2ICR_CLRSCDF(value uint32) {
	volatile.StoreUint32(&o.FLT2ICR.Reg, volatile.LoadUint32(&o.FLT2ICR.Reg)&^(0xff000000)|value<<24)
}
func (o *DFSDM_Type) GetFLT2ICR_CLRSCDF() uint32 {
	return (volatile.LoadUint32(&o.FLT2ICR.Reg) & 0xff000000) >> 24
}
func (o *DFSDM_Type) SetFLT2ICR_CLRCKABF(value uint32) {
	volatile.StoreUint32(&o.FLT2ICR.Reg, volatile.LoadUint32(&o.FLT2ICR.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_Type) GetFLT2ICR_CLRCKABF() uint32 {
	return (volatile.LoadUint32(&o.FLT2ICR.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_Type) SetFLT2ICR_CLRROVRF(value uint32) {
	volatile.StoreUint32(&o.FLT2ICR.Reg, volatile.LoadUint32(&o.FLT2ICR.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_Type) GetFLT2ICR_CLRROVRF() uint32 {
	return (volatile.LoadUint32(&o.FLT2ICR.Reg) & 0x8) >> 3
}
func (o *DFSDM_Type) SetFLT2ICR_CLRJOVRF(value uint32) {
	volatile.StoreUint32(&o.FLT2ICR.Reg, volatile.LoadUint32(&o.FLT2ICR.Reg)&^(0x4)|value<<2)
}
func (o *DFSDM_Type) GetFLT2ICR_CLRJOVRF() uint32 {
	return (volatile.LoadUint32(&o.FLT2ICR.Reg) & 0x4) >> 2
}

// DFSDM.FLT2JCHGR: injected channel group selection register
func (o *DFSDM_Type) SetFLT2JCHGR_JCHG(value uint32) {
	volatile.StoreUint32(&o.FLT2JCHGR.Reg, volatile.LoadUint32(&o.FLT2JCHGR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetFLT2JCHGR_JCHG() uint32 {
	return volatile.LoadUint32(&o.FLT2JCHGR.Reg) & 0xff
}

// DFSDM.FLT2FCR: filter control register
func (o *DFSDM_Type) SetFLT2FCR_FORD(value uint32) {
	volatile.StoreUint32(&o.FLT2FCR.Reg, volatile.LoadUint32(&o.FLT2FCR.Reg)&^(0xe0000000)|value<<29)
}
func (o *DFSDM_Type) GetFLT2FCR_FORD() uint32 {
	return (volatile.LoadUint32(&o.FLT2FCR.Reg) & 0xe0000000) >> 29
}
func (o *DFSDM_Type) SetFLT2FCR_FOSR(value uint32) {
	volatile.StoreUint32(&o.FLT2FCR.Reg, volatile.LoadUint32(&o.FLT2FCR.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DFSDM_Type) GetFLT2FCR_FOSR() uint32 {
	return (volatile.LoadUint32(&o.FLT2FCR.Reg) & 0x3ff0000) >> 16
}
func (o *DFSDM_Type) SetFLT2FCR_IOSR(value uint32) {
	volatile.StoreUint32(&o.FLT2FCR.Reg, volatile.LoadUint32(&o.FLT2FCR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetFLT2FCR_IOSR() uint32 {
	return volatile.LoadUint32(&o.FLT2FCR.Reg) & 0xff
}

// DFSDM.FLT2JDATAR: data register for injected group
func (o *DFSDM_Type) SetFLT2JDATAR_JDATA(value uint32) {
	volatile.StoreUint32(&o.FLT2JDATAR.Reg, volatile.LoadUint32(&o.FLT2JDATAR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetFLT2JDATAR_JDATA() uint32 {
	return (volatile.LoadUint32(&o.FLT2JDATAR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetFLT2JDATAR_JDATACH(value uint32) {
	volatile.StoreUint32(&o.FLT2JDATAR.Reg, volatile.LoadUint32(&o.FLT2JDATAR.Reg)&^(0x7)|value)
}
func (o *DFSDM_Type) GetFLT2JDATAR_JDATACH() uint32 {
	return volatile.LoadUint32(&o.FLT2JDATAR.Reg) & 0x7
}

// DFSDM.FLT2RDATAR: data register for the regular channel
func (o *DFSDM_Type) SetFLT2RDATAR_RDATA(value uint32) {
	volatile.StoreUint32(&o.FLT2RDATAR.Reg, volatile.LoadUint32(&o.FLT2RDATAR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetFLT2RDATAR_RDATA() uint32 {
	return (volatile.LoadUint32(&o.FLT2RDATAR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetFLT2RDATAR_RPEND(value uint32) {
	volatile.StoreUint32(&o.FLT2RDATAR.Reg, volatile.LoadUint32(&o.FLT2RDATAR.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_Type) GetFLT2RDATAR_RPEND() uint32 {
	return (volatile.LoadUint32(&o.FLT2RDATAR.Reg) & 0x10) >> 4
}
func (o *DFSDM_Type) SetFLT2RDATAR_RDATACH(value uint32) {
	volatile.StoreUint32(&o.FLT2RDATAR.Reg, volatile.LoadUint32(&o.FLT2RDATAR.Reg)&^(0x7)|value)
}
func (o *DFSDM_Type) GetFLT2RDATAR_RDATACH() uint32 {
	return volatile.LoadUint32(&o.FLT2RDATAR.Reg) & 0x7
}

// DFSDM.FLT2AWHTR: analog watchdog high threshold register
func (o *DFSDM_Type) SetFLT2AWHTR_AWHT(value uint32) {
	volatile.StoreUint32(&o.FLT2AWHTR.Reg, volatile.LoadUint32(&o.FLT2AWHTR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetFLT2AWHTR_AWHT() uint32 {
	return (volatile.LoadUint32(&o.FLT2AWHTR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetFLT2AWHTR_BKAWH(value uint32) {
	volatile.StoreUint32(&o.FLT2AWHTR.Reg, volatile.LoadUint32(&o.FLT2AWHTR.Reg)&^(0xf)|value)
}
func (o *DFSDM_Type) GetFLT2AWHTR_BKAWH() uint32 {
	return volatile.LoadUint32(&o.FLT2AWHTR.Reg) & 0xf
}

// DFSDM.FLT2AWLTR: analog watchdog low threshold register
func (o *DFSDM_Type) SetFLT2AWLTR_AWLT(value uint32) {
	volatile.StoreUint32(&o.FLT2AWLTR.Reg, volatile.LoadUint32(&o.FLT2AWLTR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetFLT2AWLTR_AWLT() uint32 {
	return (volatile.LoadUint32(&o.FLT2AWLTR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetFLT2AWLTR_BKAWL(value uint32) {
	volatile.StoreUint32(&o.FLT2AWLTR.Reg, volatile.LoadUint32(&o.FLT2AWLTR.Reg)&^(0xf)|value)
}
func (o *DFSDM_Type) GetFLT2AWLTR_BKAWL() uint32 {
	return volatile.LoadUint32(&o.FLT2AWLTR.Reg) & 0xf
}

// DFSDM.FLT2AWSR: analog watchdog status register
func (o *DFSDM_Type) SetFLT2AWSR_AWHTF(value uint32) {
	volatile.StoreUint32(&o.FLT2AWSR.Reg, volatile.LoadUint32(&o.FLT2AWSR.Reg)&^(0xff00)|value<<8)
}
func (o *DFSDM_Type) GetFLT2AWSR_AWHTF() uint32 {
	return (volatile.LoadUint32(&o.FLT2AWSR.Reg) & 0xff00) >> 8
}
func (o *DFSDM_Type) SetFLT2AWSR_AWLTF(value uint32) {
	volatile.StoreUint32(&o.FLT2AWSR.Reg, volatile.LoadUint32(&o.FLT2AWSR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetFLT2AWSR_AWLTF() uint32 {
	return volatile.LoadUint32(&o.FLT2AWSR.Reg) & 0xff
}

// DFSDM.FLT2AWCFR: analog watchdog clear flag register
func (o *DFSDM_Type) SetFLT2AWCFR_CLRAWHTF(value uint32) {
	volatile.StoreUint32(&o.FLT2AWCFR.Reg, volatile.LoadUint32(&o.FLT2AWCFR.Reg)&^(0xff00)|value<<8)
}
func (o *DFSDM_Type) GetFLT2AWCFR_CLRAWHTF() uint32 {
	return (volatile.LoadUint32(&o.FLT2AWCFR.Reg) & 0xff00) >> 8
}
func (o *DFSDM_Type) SetFLT2AWCFR_CLRAWLTF(value uint32) {
	volatile.StoreUint32(&o.FLT2AWCFR.Reg, volatile.LoadUint32(&o.FLT2AWCFR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetFLT2AWCFR_CLRAWLTF() uint32 {
	return volatile.LoadUint32(&o.FLT2AWCFR.Reg) & 0xff
}

// DFSDM.FLT2EXMAX: Extremes detector maximum register
func (o *DFSDM_Type) SetFLT2EXMAX_EXMAX(value uint32) {
	volatile.StoreUint32(&o.FLT2EXMAX.Reg, volatile.LoadUint32(&o.FLT2EXMAX.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetFLT2EXMAX_EXMAX() uint32 {
	return (volatile.LoadUint32(&o.FLT2EXMAX.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetFLT2EXMAX_EXMAXCH(value uint32) {
	volatile.StoreUint32(&o.FLT2EXMAX.Reg, volatile.LoadUint32(&o.FLT2EXMAX.Reg)&^(0x7)|value)
}
func (o *DFSDM_Type) GetFLT2EXMAX_EXMAXCH() uint32 {
	return volatile.LoadUint32(&o.FLT2EXMAX.Reg) & 0x7
}

// DFSDM.FLT2EXMIN: Extremes detector minimum register
func (o *DFSDM_Type) SetFLT2EXMIN_EXMIN(value uint32) {
	volatile.StoreUint32(&o.FLT2EXMIN.Reg, volatile.LoadUint32(&o.FLT2EXMIN.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetFLT2EXMIN_EXMIN() uint32 {
	return (volatile.LoadUint32(&o.FLT2EXMIN.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetFLT2EXMIN_EXMINCH(value uint32) {
	volatile.StoreUint32(&o.FLT2EXMIN.Reg, volatile.LoadUint32(&o.FLT2EXMIN.Reg)&^(0x7)|value)
}
func (o *DFSDM_Type) GetFLT2EXMIN_EXMINCH() uint32 {
	return volatile.LoadUint32(&o.FLT2EXMIN.Reg) & 0x7
}

// DFSDM.FLT2CNVTIMR: conversion timer register
func (o *DFSDM_Type) SetFLT2CNVTIMR_CNVCNT(value uint32) {
	volatile.StoreUint32(&o.FLT2CNVTIMR.Reg, volatile.LoadUint32(&o.FLT2CNVTIMR.Reg)&^(0xfffffff0)|value<<4)
}
func (o *DFSDM_Type) GetFLT2CNVTIMR_CNVCNT() uint32 {
	return (volatile.LoadUint32(&o.FLT2CNVTIMR.Reg) & 0xfffffff0) >> 4
}

// DFSDM.FLT3CR1: control register 1
func (o *DFSDM_Type) SetFLT3CR1_AWFSEL(value uint32) {
	volatile.StoreUint32(&o.FLT3CR1.Reg, volatile.LoadUint32(&o.FLT3CR1.Reg)&^(0x40000000)|value<<30)
}
func (o *DFSDM_Type) GetFLT3CR1_AWFSEL() uint32 {
	return (volatile.LoadUint32(&o.FLT3CR1.Reg) & 0x40000000) >> 30
}
func (o *DFSDM_Type) SetFLT3CR1_FAST(value uint32) {
	volatile.StoreUint32(&o.FLT3CR1.Reg, volatile.LoadUint32(&o.FLT3CR1.Reg)&^(0x20000000)|value<<29)
}
func (o *DFSDM_Type) GetFLT3CR1_FAST() uint32 {
	return (volatile.LoadUint32(&o.FLT3CR1.Reg) & 0x20000000) >> 29
}
func (o *DFSDM_Type) SetFLT3CR1_RCH(value uint32) {
	volatile.StoreUint32(&o.FLT3CR1.Reg, volatile.LoadUint32(&o.FLT3CR1.Reg)&^(0x7000000)|value<<24)
}
func (o *DFSDM_Type) GetFLT3CR1_RCH() uint32 {
	return (volatile.LoadUint32(&o.FLT3CR1.Reg) & 0x7000000) >> 24
}
func (o *DFSDM_Type) SetFLT3CR1_RDMAEN(value uint32) {
	volatile.StoreUint32(&o.FLT3CR1.Reg, volatile.LoadUint32(&o.FLT3CR1.Reg)&^(0x200000)|value<<21)
}
func (o *DFSDM_Type) GetFLT3CR1_RDMAEN() uint32 {
	return (volatile.LoadUint32(&o.FLT3CR1.Reg) & 0x200000) >> 21
}
func (o *DFSDM_Type) SetFLT3CR1_RSYNC(value uint32) {
	volatile.StoreUint32(&o.FLT3CR1.Reg, volatile.LoadUint32(&o.FLT3CR1.Reg)&^(0x80000)|value<<19)
}
func (o *DFSDM_Type) GetFLT3CR1_RSYNC() uint32 {
	return (volatile.LoadUint32(&o.FLT3CR1.Reg) & 0x80000) >> 19
}
func (o *DFSDM_Type) SetFLT3CR1_RCONT(value uint32) {
	volatile.StoreUint32(&o.FLT3CR1.Reg, volatile.LoadUint32(&o.FLT3CR1.Reg)&^(0x40000)|value<<18)
}
func (o *DFSDM_Type) GetFLT3CR1_RCONT() uint32 {
	return (volatile.LoadUint32(&o.FLT3CR1.Reg) & 0x40000) >> 18
}
func (o *DFSDM_Type) SetFLT3CR1_RSWSTART(value uint32) {
	volatile.StoreUint32(&o.FLT3CR1.Reg, volatile.LoadUint32(&o.FLT3CR1.Reg)&^(0x20000)|value<<17)
}
func (o *DFSDM_Type) GetFLT3CR1_RSWSTART() uint32 {
	return (volatile.LoadUint32(&o.FLT3CR1.Reg) & 0x20000) >> 17
}
func (o *DFSDM_Type) SetFLT3CR1_JEXTEN(value uint32) {
	volatile.StoreUint32(&o.FLT3CR1.Reg, volatile.LoadUint32(&o.FLT3CR1.Reg)&^(0x6000)|value<<13)
}
func (o *DFSDM_Type) GetFLT3CR1_JEXTEN() uint32 {
	return (volatile.LoadUint32(&o.FLT3CR1.Reg) & 0x6000) >> 13
}
func (o *DFSDM_Type) SetFLT3CR1_JEXTSEL(value uint32) {
	volatile.StoreUint32(&o.FLT3CR1.Reg, volatile.LoadUint32(&o.FLT3CR1.Reg)&^(0x700)|value<<8)
}
func (o *DFSDM_Type) GetFLT3CR1_JEXTSEL() uint32 {
	return (volatile.LoadUint32(&o.FLT3CR1.Reg) & 0x700) >> 8
}
func (o *DFSDM_Type) SetFLT3CR1_JDMAEN(value uint32) {
	volatile.StoreUint32(&o.FLT3CR1.Reg, volatile.LoadUint32(&o.FLT3CR1.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_Type) GetFLT3CR1_JDMAEN() uint32 {
	return (volatile.LoadUint32(&o.FLT3CR1.Reg) & 0x20) >> 5
}
func (o *DFSDM_Type) SetFLT3CR1_JSCAN(value uint32) {
	volatile.StoreUint32(&o.FLT3CR1.Reg, volatile.LoadUint32(&o.FLT3CR1.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_Type) GetFLT3CR1_JSCAN() uint32 {
	return (volatile.LoadUint32(&o.FLT3CR1.Reg) & 0x10) >> 4
}
func (o *DFSDM_Type) SetFLT3CR1_JSYNC(value uint32) {
	volatile.StoreUint32(&o.FLT3CR1.Reg, volatile.LoadUint32(&o.FLT3CR1.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_Type) GetFLT3CR1_JSYNC() uint32 {
	return (volatile.LoadUint32(&o.FLT3CR1.Reg) & 0x8) >> 3
}
func (o *DFSDM_Type) SetFLT3CR1_JSWSTART(value uint32) {
	volatile.StoreUint32(&o.FLT3CR1.Reg, volatile.LoadUint32(&o.FLT3CR1.Reg)&^(0x2)|value<<1)
}
func (o *DFSDM_Type) GetFLT3CR1_JSWSTART() uint32 {
	return (volatile.LoadUint32(&o.FLT3CR1.Reg) & 0x2) >> 1
}
func (o *DFSDM_Type) SetFLT3CR1_DFEN(value uint32) {
	volatile.StoreUint32(&o.FLT3CR1.Reg, volatile.LoadUint32(&o.FLT3CR1.Reg)&^(0x1)|value)
}
func (o *DFSDM_Type) GetFLT3CR1_DFEN() uint32 {
	return volatile.LoadUint32(&o.FLT3CR1.Reg) & 0x1
}

// DFSDM.FLT3CR2: control register 2
func (o *DFSDM_Type) SetFLT3CR2_AWDCH(value uint32) {
	volatile.StoreUint32(&o.FLT3CR2.Reg, volatile.LoadUint32(&o.FLT3CR2.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_Type) GetFLT3CR2_AWDCH() uint32 {
	return (volatile.LoadUint32(&o.FLT3CR2.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_Type) SetFLT3CR2_EXCH(value uint32) {
	volatile.StoreUint32(&o.FLT3CR2.Reg, volatile.LoadUint32(&o.FLT3CR2.Reg)&^(0xff00)|value<<8)
}
func (o *DFSDM_Type) GetFLT3CR2_EXCH() uint32 {
	return (volatile.LoadUint32(&o.FLT3CR2.Reg) & 0xff00) >> 8
}
func (o *DFSDM_Type) SetFLT3CR2_CKABIE(value uint32) {
	volatile.StoreUint32(&o.FLT3CR2.Reg, volatile.LoadUint32(&o.FLT3CR2.Reg)&^(0x40)|value<<6)
}
func (o *DFSDM_Type) GetFLT3CR2_CKABIE() uint32 {
	return (volatile.LoadUint32(&o.FLT3CR2.Reg) & 0x40) >> 6
}
func (o *DFSDM_Type) SetFLT3CR2_SCDIE(value uint32) {
	volatile.StoreUint32(&o.FLT3CR2.Reg, volatile.LoadUint32(&o.FLT3CR2.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_Type) GetFLT3CR2_SCDIE() uint32 {
	return (volatile.LoadUint32(&o.FLT3CR2.Reg) & 0x20) >> 5
}
func (o *DFSDM_Type) SetFLT3CR2_AWDIE(value uint32) {
	volatile.StoreUint32(&o.FLT3CR2.Reg, volatile.LoadUint32(&o.FLT3CR2.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_Type) GetFLT3CR2_AWDIE() uint32 {
	return (volatile.LoadUint32(&o.FLT3CR2.Reg) & 0x10) >> 4
}
func (o *DFSDM_Type) SetFLT3CR2_ROVRIE(value uint32) {
	volatile.StoreUint32(&o.FLT3CR2.Reg, volatile.LoadUint32(&o.FLT3CR2.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_Type) GetFLT3CR2_ROVRIE() uint32 {
	return (volatile.LoadUint32(&o.FLT3CR2.Reg) & 0x8) >> 3
}
func (o *DFSDM_Type) SetFLT3CR2_JOVRIE(value uint32) {
	volatile.StoreUint32(&o.FLT3CR2.Reg, volatile.LoadUint32(&o.FLT3CR2.Reg)&^(0x4)|value<<2)
}
func (o *DFSDM_Type) GetFLT3CR2_JOVRIE() uint32 {
	return (volatile.LoadUint32(&o.FLT3CR2.Reg) & 0x4) >> 2
}
func (o *DFSDM_Type) SetFLT3CR2_REOCIE(value uint32) {
	volatile.StoreUint32(&o.FLT3CR2.Reg, volatile.LoadUint32(&o.FLT3CR2.Reg)&^(0x2)|value<<1)
}
func (o *DFSDM_Type) GetFLT3CR2_REOCIE() uint32 {
	return (volatile.LoadUint32(&o.FLT3CR2.Reg) & 0x2) >> 1
}
func (o *DFSDM_Type) SetFLT3CR2_JEOCIE(value uint32) {
	volatile.StoreUint32(&o.FLT3CR2.Reg, volatile.LoadUint32(&o.FLT3CR2.Reg)&^(0x1)|value)
}
func (o *DFSDM_Type) GetFLT3CR2_JEOCIE() uint32 {
	return volatile.LoadUint32(&o.FLT3CR2.Reg) & 0x1
}

// DFSDM.FLT3ISR: interrupt and status register
func (o *DFSDM_Type) SetFLT3ISR_SCDF(value uint32) {
	volatile.StoreUint32(&o.FLT3ISR.Reg, volatile.LoadUint32(&o.FLT3ISR.Reg)&^(0xff000000)|value<<24)
}
func (o *DFSDM_Type) GetFLT3ISR_SCDF() uint32 {
	return (volatile.LoadUint32(&o.FLT3ISR.Reg) & 0xff000000) >> 24
}
func (o *DFSDM_Type) SetFLT3ISR_CKABF(value uint32) {
	volatile.StoreUint32(&o.FLT3ISR.Reg, volatile.LoadUint32(&o.FLT3ISR.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_Type) GetFLT3ISR_CKABF() uint32 {
	return (volatile.LoadUint32(&o.FLT3ISR.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_Type) SetFLT3ISR_RCIP(value uint32) {
	volatile.StoreUint32(&o.FLT3ISR.Reg, volatile.LoadUint32(&o.FLT3ISR.Reg)&^(0x4000)|value<<14)
}
func (o *DFSDM_Type) GetFLT3ISR_RCIP() uint32 {
	return (volatile.LoadUint32(&o.FLT3ISR.Reg) & 0x4000) >> 14
}
func (o *DFSDM_Type) SetFLT3ISR_JCIP(value uint32) {
	volatile.StoreUint32(&o.FLT3ISR.Reg, volatile.LoadUint32(&o.FLT3ISR.Reg)&^(0x2000)|value<<13)
}
func (o *DFSDM_Type) GetFLT3ISR_JCIP() uint32 {
	return (volatile.LoadUint32(&o.FLT3ISR.Reg) & 0x2000) >> 13
}
func (o *DFSDM_Type) SetFLT3ISR_AWDF(value uint32) {
	volatile.StoreUint32(&o.FLT3ISR.Reg, volatile.LoadUint32(&o.FLT3ISR.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_Type) GetFLT3ISR_AWDF() uint32 {
	return (volatile.LoadUint32(&o.FLT3ISR.Reg) & 0x10) >> 4
}
func (o *DFSDM_Type) SetFLT3ISR_ROVRF(value uint32) {
	volatile.StoreUint32(&o.FLT3ISR.Reg, volatile.LoadUint32(&o.FLT3ISR.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_Type) GetFLT3ISR_ROVRF() uint32 {
	return (volatile.LoadUint32(&o.FLT3ISR.Reg) & 0x8) >> 3
}
func (o *DFSDM_Type) SetFLT3ISR_JOVRF(value uint32) {
	volatile.StoreUint32(&o.FLT3ISR.Reg, volatile.LoadUint32(&o.FLT3ISR.Reg)&^(0x4)|value<<2)
}
func (o *DFSDM_Type) GetFLT3ISR_JOVRF() uint32 {
	return (volatile.LoadUint32(&o.FLT3ISR.Reg) & 0x4) >> 2
}
func (o *DFSDM_Type) SetFLT3ISR_REOCF(value uint32) {
	volatile.StoreUint32(&o.FLT3ISR.Reg, volatile.LoadUint32(&o.FLT3ISR.Reg)&^(0x2)|value<<1)
}
func (o *DFSDM_Type) GetFLT3ISR_REOCF() uint32 {
	return (volatile.LoadUint32(&o.FLT3ISR.Reg) & 0x2) >> 1
}
func (o *DFSDM_Type) SetFLT3ISR_JEOCF(value uint32) {
	volatile.StoreUint32(&o.FLT3ISR.Reg, volatile.LoadUint32(&o.FLT3ISR.Reg)&^(0x1)|value)
}
func (o *DFSDM_Type) GetFLT3ISR_JEOCF() uint32 {
	return volatile.LoadUint32(&o.FLT3ISR.Reg) & 0x1
}

// DFSDM.FLT3ICR: interrupt flag clear register
func (o *DFSDM_Type) SetFLT3ICR_CLRSCDF(value uint32) {
	volatile.StoreUint32(&o.FLT3ICR.Reg, volatile.LoadUint32(&o.FLT3ICR.Reg)&^(0xff000000)|value<<24)
}
func (o *DFSDM_Type) GetFLT3ICR_CLRSCDF() uint32 {
	return (volatile.LoadUint32(&o.FLT3ICR.Reg) & 0xff000000) >> 24
}
func (o *DFSDM_Type) SetFLT3ICR_CLRCKABF(value uint32) {
	volatile.StoreUint32(&o.FLT3ICR.Reg, volatile.LoadUint32(&o.FLT3ICR.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_Type) GetFLT3ICR_CLRCKABF() uint32 {
	return (volatile.LoadUint32(&o.FLT3ICR.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_Type) SetFLT3ICR_CLRROVRF(value uint32) {
	volatile.StoreUint32(&o.FLT3ICR.Reg, volatile.LoadUint32(&o.FLT3ICR.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_Type) GetFLT3ICR_CLRROVRF() uint32 {
	return (volatile.LoadUint32(&o.FLT3ICR.Reg) & 0x8) >> 3
}
func (o *DFSDM_Type) SetFLT3ICR_CLRJOVRF(value uint32) {
	volatile.StoreUint32(&o.FLT3ICR.Reg, volatile.LoadUint32(&o.FLT3ICR.Reg)&^(0x4)|value<<2)
}
func (o *DFSDM_Type) GetFLT3ICR_CLRJOVRF() uint32 {
	return (volatile.LoadUint32(&o.FLT3ICR.Reg) & 0x4) >> 2
}

// DFSDM.FLT3JCHGR: injected channel group selection register
func (o *DFSDM_Type) SetFLT3JCHGR_JCHG(value uint32) {
	volatile.StoreUint32(&o.FLT3JCHGR.Reg, volatile.LoadUint32(&o.FLT3JCHGR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetFLT3JCHGR_JCHG() uint32 {
	return volatile.LoadUint32(&o.FLT3JCHGR.Reg) & 0xff
}

// DFSDM.FLT3FCR: filter control register
func (o *DFSDM_Type) SetFLT3FCR_FORD(value uint32) {
	volatile.StoreUint32(&o.FLT3FCR.Reg, volatile.LoadUint32(&o.FLT3FCR.Reg)&^(0xe0000000)|value<<29)
}
func (o *DFSDM_Type) GetFLT3FCR_FORD() uint32 {
	return (volatile.LoadUint32(&o.FLT3FCR.Reg) & 0xe0000000) >> 29
}
func (o *DFSDM_Type) SetFLT3FCR_FOSR(value uint32) {
	volatile.StoreUint32(&o.FLT3FCR.Reg, volatile.LoadUint32(&o.FLT3FCR.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DFSDM_Type) GetFLT3FCR_FOSR() uint32 {
	return (volatile.LoadUint32(&o.FLT3FCR.Reg) & 0x3ff0000) >> 16
}
func (o *DFSDM_Type) SetFLT3FCR_IOSR(value uint32) {
	volatile.StoreUint32(&o.FLT3FCR.Reg, volatile.LoadUint32(&o.FLT3FCR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetFLT3FCR_IOSR() uint32 {
	return volatile.LoadUint32(&o.FLT3FCR.Reg) & 0xff
}

// DFSDM.FLT3JDATAR: data register for injected group
func (o *DFSDM_Type) SetFLT3JDATAR_JDATA(value uint32) {
	volatile.StoreUint32(&o.FLT3JDATAR.Reg, volatile.LoadUint32(&o.FLT3JDATAR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetFLT3JDATAR_JDATA() uint32 {
	return (volatile.LoadUint32(&o.FLT3JDATAR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetFLT3JDATAR_JDATACH(value uint32) {
	volatile.StoreUint32(&o.FLT3JDATAR.Reg, volatile.LoadUint32(&o.FLT3JDATAR.Reg)&^(0x7)|value)
}
func (o *DFSDM_Type) GetFLT3JDATAR_JDATACH() uint32 {
	return volatile.LoadUint32(&o.FLT3JDATAR.Reg) & 0x7
}

// DFSDM.FLT3RDATAR: data register for the regular channel
func (o *DFSDM_Type) SetFLT3RDATAR_RDATA(value uint32) {
	volatile.StoreUint32(&o.FLT3RDATAR.Reg, volatile.LoadUint32(&o.FLT3RDATAR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetFLT3RDATAR_RDATA() uint32 {
	return (volatile.LoadUint32(&o.FLT3RDATAR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetFLT3RDATAR_RPEND(value uint32) {
	volatile.StoreUint32(&o.FLT3RDATAR.Reg, volatile.LoadUint32(&o.FLT3RDATAR.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_Type) GetFLT3RDATAR_RPEND() uint32 {
	return (volatile.LoadUint32(&o.FLT3RDATAR.Reg) & 0x10) >> 4
}
func (o *DFSDM_Type) SetFLT3RDATAR_RDATACH(value uint32) {
	volatile.StoreUint32(&o.FLT3RDATAR.Reg, volatile.LoadUint32(&o.FLT3RDATAR.Reg)&^(0x7)|value)
}
func (o *DFSDM_Type) GetFLT3RDATAR_RDATACH() uint32 {
	return volatile.LoadUint32(&o.FLT3RDATAR.Reg) & 0x7
}

// DFSDM.FLT3AWHTR: analog watchdog high threshold register
func (o *DFSDM_Type) SetFLT3AWHTR_AWHT(value uint32) {
	volatile.StoreUint32(&o.FLT3AWHTR.Reg, volatile.LoadUint32(&o.FLT3AWHTR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetFLT3AWHTR_AWHT() uint32 {
	return (volatile.LoadUint32(&o.FLT3AWHTR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetFLT3AWHTR_BKAWH(value uint32) {
	volatile.StoreUint32(&o.FLT3AWHTR.Reg, volatile.LoadUint32(&o.FLT3AWHTR.Reg)&^(0xf)|value)
}
func (o *DFSDM_Type) GetFLT3AWHTR_BKAWH() uint32 {
	return volatile.LoadUint32(&o.FLT3AWHTR.Reg) & 0xf
}

// DFSDM.FLT3AWLTR: analog watchdog low threshold register
func (o *DFSDM_Type) SetFLT3AWLTR_AWLT(value uint32) {
	volatile.StoreUint32(&o.FLT3AWLTR.Reg, volatile.LoadUint32(&o.FLT3AWLTR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetFLT3AWLTR_AWLT() uint32 {
	return (volatile.LoadUint32(&o.FLT3AWLTR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetFLT3AWLTR_BKAWL(value uint32) {
	volatile.StoreUint32(&o.FLT3AWLTR.Reg, volatile.LoadUint32(&o.FLT3AWLTR.Reg)&^(0xf)|value)
}
func (o *DFSDM_Type) GetFLT3AWLTR_BKAWL() uint32 {
	return volatile.LoadUint32(&o.FLT3AWLTR.Reg) & 0xf
}

// DFSDM.FLT3AWSR: analog watchdog status register
func (o *DFSDM_Type) SetFLT3AWSR_AWHTF(value uint32) {
	volatile.StoreUint32(&o.FLT3AWSR.Reg, volatile.LoadUint32(&o.FLT3AWSR.Reg)&^(0xff00)|value<<8)
}
func (o *DFSDM_Type) GetFLT3AWSR_AWHTF() uint32 {
	return (volatile.LoadUint32(&o.FLT3AWSR.Reg) & 0xff00) >> 8
}
func (o *DFSDM_Type) SetFLT3AWSR_AWLTF(value uint32) {
	volatile.StoreUint32(&o.FLT3AWSR.Reg, volatile.LoadUint32(&o.FLT3AWSR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetFLT3AWSR_AWLTF() uint32 {
	return volatile.LoadUint32(&o.FLT3AWSR.Reg) & 0xff
}

// DFSDM.FLT3AWCFR: analog watchdog clear flag register
func (o *DFSDM_Type) SetFLT3AWCFR_CLRAWHTF(value uint32) {
	volatile.StoreUint32(&o.FLT3AWCFR.Reg, volatile.LoadUint32(&o.FLT3AWCFR.Reg)&^(0xff00)|value<<8)
}
func (o *DFSDM_Type) GetFLT3AWCFR_CLRAWHTF() uint32 {
	return (volatile.LoadUint32(&o.FLT3AWCFR.Reg) & 0xff00) >> 8
}
func (o *DFSDM_Type) SetFLT3AWCFR_CLRAWLTF(value uint32) {
	volatile.StoreUint32(&o.FLT3AWCFR.Reg, volatile.LoadUint32(&o.FLT3AWCFR.Reg)&^(0xff)|value)
}
func (o *DFSDM_Type) GetFLT3AWCFR_CLRAWLTF() uint32 {
	return volatile.LoadUint32(&o.FLT3AWCFR.Reg) & 0xff
}

// DFSDM.FLT3EXMAX: Extremes detector maximum register
func (o *DFSDM_Type) SetFLT3EXMAX_EXMAX(value uint32) {
	volatile.StoreUint32(&o.FLT3EXMAX.Reg, volatile.LoadUint32(&o.FLT3EXMAX.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetFLT3EXMAX_EXMAX() uint32 {
	return (volatile.LoadUint32(&o.FLT3EXMAX.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetFLT3EXMAX_EXMAXCH(value uint32) {
	volatile.StoreUint32(&o.FLT3EXMAX.Reg, volatile.LoadUint32(&o.FLT3EXMAX.Reg)&^(0x7)|value)
}
func (o *DFSDM_Type) GetFLT3EXMAX_EXMAXCH() uint32 {
	return volatile.LoadUint32(&o.FLT3EXMAX.Reg) & 0x7
}

// DFSDM.FLT3EXMIN: Extremes detector minimum register
func (o *DFSDM_Type) SetFLT3EXMIN_EXMIN(value uint32) {
	volatile.StoreUint32(&o.FLT3EXMIN.Reg, volatile.LoadUint32(&o.FLT3EXMIN.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_Type) GetFLT3EXMIN_EXMIN() uint32 {
	return (volatile.LoadUint32(&o.FLT3EXMIN.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_Type) SetFLT3EXMIN_EXMINCH(value uint32) {
	volatile.StoreUint32(&o.FLT3EXMIN.Reg, volatile.LoadUint32(&o.FLT3EXMIN.Reg)&^(0x7)|value)
}
func (o *DFSDM_Type) GetFLT3EXMIN_EXMINCH() uint32 {
	return volatile.LoadUint32(&o.FLT3EXMIN.Reg) & 0x7
}

// DFSDM.FLT3CNVTIMR: conversion timer register
func (o *DFSDM_Type) SetFLT3CNVTIMR_CNVCNT(value uint32) {
	volatile.StoreUint32(&o.FLT3CNVTIMR.Reg, volatile.LoadUint32(&o.FLT3CNVTIMR.Reg)&^(0xfffffff0)|value<<4)
}
func (o *DFSDM_Type) GetFLT3CNVTIMR_CNVCNT() uint32 {
	return (volatile.LoadUint32(&o.FLT3CNVTIMR.Reg) & 0xfffffff0) >> 4
}

// Direct memory access Multiplexer
type DMAMUX_Type struct {
	C0CR  volatile.Register32 // 0x0
	C1CR  volatile.Register32 // 0x4
	C2CR  volatile.Register32 // 0x8
	C3CR  volatile.Register32 // 0xC
	C4CR  volatile.Register32 // 0x10
	C5CR  volatile.Register32 // 0x14
	C6CR  volatile.Register32 // 0x18
	C7CR  volatile.Register32 // 0x1C
	C8CR  volatile.Register32 // 0x20
	C9CR  volatile.Register32 // 0x24
	C10CR volatile.Register32 // 0x28
	C11CR volatile.Register32 // 0x2C
	C12CR volatile.Register32 // 0x30
	C13CR volatile.Register32 // 0x34
	_     [72]byte
	CSR   volatile.Register32 // 0x80
	CCFR  volatile.Register32 // 0x84
	_     [120]byte
	RG0CR volatile.Register32 // 0x100
	RG1CR volatile.Register32 // 0x104
	RG2CR volatile.Register32 // 0x108
	RG3CR volatile.Register32 // 0x10C
	_     [40]byte
	C14CR volatile.Register32 // 0x138
	C15CR volatile.Register32 // 0x13C
	RGSR  volatile.Register32 // 0x140
	RGCFR volatile.Register32 // 0x144
}

// DMAMUX.C0CR: DMA Multiplexer Channel 0 Control register
func (o *DMAMUX_Type) SetC0CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC0CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C0CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC0CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC0CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C0CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC0CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC0CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C0CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC0CR_SE(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC0CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C0CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC0CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC0CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C0CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC0CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC0CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C0CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC0CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C0CR.Reg, volatile.LoadUint32(&o.C0CR.Reg)&^(0x7f)|value)
}
func (o *DMAMUX_Type) GetC0CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C0CR.Reg) & 0x7f
}

// DMAMUX.C1CR: DMA Multiplexer Channel 1 Control register
func (o *DMAMUX_Type) SetC1CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC1CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC1CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC1CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC1CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC1CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC1CR_SE(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC1CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC1CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC1CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC1CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC1CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C1CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC1CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C1CR.Reg, volatile.LoadUint32(&o.C1CR.Reg)&^(0x7f)|value)
}
func (o *DMAMUX_Type) GetC1CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C1CR.Reg) & 0x7f
}

// DMAMUX.C2CR: DMA Multiplexer Channel 2 Control register
func (o *DMAMUX_Type) SetC2CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC2CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC2CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC2CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC2CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC2CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC2CR_SE(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC2CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC2CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC2CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC2CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC2CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C2CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC2CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C2CR.Reg, volatile.LoadUint32(&o.C2CR.Reg)&^(0x7f)|value)
}
func (o *DMAMUX_Type) GetC2CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C2CR.Reg) & 0x7f
}

// DMAMUX.C3CR: DMA Multiplexer Channel 3 Control register
func (o *DMAMUX_Type) SetC3CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC3CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C3CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC3CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC3CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C3CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC3CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC3CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C3CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC3CR_SE(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC3CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C3CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC3CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC3CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C3CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC3CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC3CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C3CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC3CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C3CR.Reg, volatile.LoadUint32(&o.C3CR.Reg)&^(0x7f)|value)
}
func (o *DMAMUX_Type) GetC3CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C3CR.Reg) & 0x7f
}

// DMAMUX.C4CR: DMA Multiplexer Channel 4 Control register
func (o *DMAMUX_Type) SetC4CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC4CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C4CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC4CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC4CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C4CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC4CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC4CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C4CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC4CR_SE(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC4CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C4CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC4CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC4CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C4CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC4CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC4CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C4CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC4CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C4CR.Reg, volatile.LoadUint32(&o.C4CR.Reg)&^(0x7f)|value)
}
func (o *DMAMUX_Type) GetC4CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C4CR.Reg) & 0x7f
}

// DMAMUX.C5CR: DMA Multiplexer Channel 5 Control register
func (o *DMAMUX_Type) SetC5CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC5CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C5CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC5CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC5CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C5CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC5CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC5CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C5CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC5CR_SE(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC5CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C5CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC5CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC5CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C5CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC5CR_OIE(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC5CR_OIE() uint32 {
	return (volatile.LoadUint32(&o.C5CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC5CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C5CR.Reg, volatile.LoadUint32(&o.C5CR.Reg)&^(0x7f)|value)
}
func (o *DMAMUX_Type) GetC5CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C5CR.Reg) & 0x7f
}

// DMAMUX.C6CR: DMA Multiplexer Channel 6 Control register
func (o *DMAMUX_Type) SetC6CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC6CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C6CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC6CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC6CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C6CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC6CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC6CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C6CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC6CR_SE(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC6CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C6CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC6CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC6CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C6CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC6CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC6CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C6CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC6CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C6CR.Reg, volatile.LoadUint32(&o.C6CR.Reg)&^(0x7f)|value)
}
func (o *DMAMUX_Type) GetC6CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C6CR.Reg) & 0x7f
}

// DMAMUX.C7CR: DMA Multiplexer Channel 7 Control register
func (o *DMAMUX_Type) SetC7CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C7CR.Reg, volatile.LoadUint32(&o.C7CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC7CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C7CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC7CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C7CR.Reg, volatile.LoadUint32(&o.C7CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC7CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C7CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC7CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C7CR.Reg, volatile.LoadUint32(&o.C7CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC7CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C7CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC7CR_SE(value uint32) {
	volatile.StoreUint32(&o.C7CR.Reg, volatile.LoadUint32(&o.C7CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC7CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C7CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC7CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C7CR.Reg, volatile.LoadUint32(&o.C7CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC7CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C7CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC7CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C7CR.Reg, volatile.LoadUint32(&o.C7CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC7CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C7CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC7CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C7CR.Reg, volatile.LoadUint32(&o.C7CR.Reg)&^(0x7f)|value)
}
func (o *DMAMUX_Type) GetC7CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C7CR.Reg) & 0x7f
}

// DMAMUX.C8CR: DMA Multiplexer Channel 8 Control register
func (o *DMAMUX_Type) SetC8CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C8CR.Reg, volatile.LoadUint32(&o.C8CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC8CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C8CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC8CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C8CR.Reg, volatile.LoadUint32(&o.C8CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC8CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C8CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC8CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C8CR.Reg, volatile.LoadUint32(&o.C8CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC8CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C8CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC8CR_SE(value uint32) {
	volatile.StoreUint32(&o.C8CR.Reg, volatile.LoadUint32(&o.C8CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC8CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C8CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC8CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C8CR.Reg, volatile.LoadUint32(&o.C8CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC8CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C8CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC8CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C8CR.Reg, volatile.LoadUint32(&o.C8CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC8CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C8CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC8CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C8CR.Reg, volatile.LoadUint32(&o.C8CR.Reg)&^(0x7f)|value)
}
func (o *DMAMUX_Type) GetC8CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C8CR.Reg) & 0x7f
}

// DMAMUX.C9CR: DMA Multiplexer Channel 9 Control register
func (o *DMAMUX_Type) SetC9CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C9CR.Reg, volatile.LoadUint32(&o.C9CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC9CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C9CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC9CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C9CR.Reg, volatile.LoadUint32(&o.C9CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC9CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C9CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC9CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C9CR.Reg, volatile.LoadUint32(&o.C9CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC9CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C9CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC9CR_SE(value uint32) {
	volatile.StoreUint32(&o.C9CR.Reg, volatile.LoadUint32(&o.C9CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC9CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C9CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC9CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C9CR.Reg, volatile.LoadUint32(&o.C9CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC9CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C9CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC9CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C9CR.Reg, volatile.LoadUint32(&o.C9CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC9CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C9CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC9CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C9CR.Reg, volatile.LoadUint32(&o.C9CR.Reg)&^(0x7f)|value)
}
func (o *DMAMUX_Type) GetC9CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C9CR.Reg) & 0x7f
}

// DMAMUX.C10CR: DMA Multiplexer Channel 10 Control register
func (o *DMAMUX_Type) SetC10CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C10CR.Reg, volatile.LoadUint32(&o.C10CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC10CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C10CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC10CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C10CR.Reg, volatile.LoadUint32(&o.C10CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC10CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C10CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC10CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C10CR.Reg, volatile.LoadUint32(&o.C10CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC10CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C10CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC10CR_SE(value uint32) {
	volatile.StoreUint32(&o.C10CR.Reg, volatile.LoadUint32(&o.C10CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC10CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C10CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC10CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C10CR.Reg, volatile.LoadUint32(&o.C10CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC10CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C10CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC10CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C10CR.Reg, volatile.LoadUint32(&o.C10CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC10CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C10CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC10CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C10CR.Reg, volatile.LoadUint32(&o.C10CR.Reg)&^(0x7f)|value)
}
func (o *DMAMUX_Type) GetC10CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C10CR.Reg) & 0x7f
}

// DMAMUX.C11CR: DMA Multiplexer Channel 11 Control register
func (o *DMAMUX_Type) SetC11CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C11CR.Reg, volatile.LoadUint32(&o.C11CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC11CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C11CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC11CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C11CR.Reg, volatile.LoadUint32(&o.C11CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC11CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C11CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC11CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C11CR.Reg, volatile.LoadUint32(&o.C11CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC11CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C11CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC11CR_SE(value uint32) {
	volatile.StoreUint32(&o.C11CR.Reg, volatile.LoadUint32(&o.C11CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC11CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C11CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC11CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C11CR.Reg, volatile.LoadUint32(&o.C11CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC11CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C11CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC11CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C11CR.Reg, volatile.LoadUint32(&o.C11CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC11CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C11CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC11CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C11CR.Reg, volatile.LoadUint32(&o.C11CR.Reg)&^(0x7f)|value)
}
func (o *DMAMUX_Type) GetC11CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C11CR.Reg) & 0x7f
}

// DMAMUX.C12CR: DMA Multiplexer Channel 12 Control register
func (o *DMAMUX_Type) SetC12CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C12CR.Reg, volatile.LoadUint32(&o.C12CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC12CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C12CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC12CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C12CR.Reg, volatile.LoadUint32(&o.C12CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC12CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C12CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC12CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C12CR.Reg, volatile.LoadUint32(&o.C12CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC12CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C12CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC12CR_SE(value uint32) {
	volatile.StoreUint32(&o.C12CR.Reg, volatile.LoadUint32(&o.C12CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC12CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C12CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC12CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C12CR.Reg, volatile.LoadUint32(&o.C12CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC12CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C12CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC12CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C12CR.Reg, volatile.LoadUint32(&o.C12CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC12CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C12CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC12CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C12CR.Reg, volatile.LoadUint32(&o.C12CR.Reg)&^(0x7f)|value)
}
func (o *DMAMUX_Type) GetC12CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C12CR.Reg) & 0x7f
}

// DMAMUX.C13CR: DMA Multiplexer Channel 13 Control register
func (o *DMAMUX_Type) SetC13CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C13CR.Reg, volatile.LoadUint32(&o.C13CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC13CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C13CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC13CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C13CR.Reg, volatile.LoadUint32(&o.C13CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC13CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C13CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC13CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C13CR.Reg, volatile.LoadUint32(&o.C13CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC13CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C13CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC13CR_SE(value uint32) {
	volatile.StoreUint32(&o.C13CR.Reg, volatile.LoadUint32(&o.C13CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC13CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C13CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC13CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C13CR.Reg, volatile.LoadUint32(&o.C13CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC13CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C13CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC13CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C13CR.Reg, volatile.LoadUint32(&o.C13CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC13CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C13CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC13CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C13CR.Reg, volatile.LoadUint32(&o.C13CR.Reg)&^(0x7f)|value)
}
func (o *DMAMUX_Type) GetC13CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C13CR.Reg) & 0x7f
}

// DMAMUX.CSR: DMA Multiplexer Channel Status register
func (o *DMAMUX_Type) SetCSR_SOF0(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *DMAMUX_Type) GetCSR_SOF0() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}
func (o *DMAMUX_Type) SetCSR_SOF1(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *DMAMUX_Type) GetCSR_SOF1() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *DMAMUX_Type) SetCSR_SOF2(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *DMAMUX_Type) GetCSR_SOF2() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *DMAMUX_Type) SetCSR_SOF3(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8)|value<<3)
}
func (o *DMAMUX_Type) GetCSR_SOF3() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8) >> 3
}
func (o *DMAMUX_Type) SetCSR_SOF4(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10)|value<<4)
}
func (o *DMAMUX_Type) GetCSR_SOF4() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10) >> 4
}
func (o *DMAMUX_Type) SetCSR_SOF5(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20)|value<<5)
}
func (o *DMAMUX_Type) GetCSR_SOF5() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20) >> 5
}
func (o *DMAMUX_Type) SetCSR_SOF6(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCSR_SOF6() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCSR_SOF7(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCSR_SOF7() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80) >> 7
}
func (o *DMAMUX_Type) SetCSR_SOF8(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetCSR_SOF8() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetCSR_SOF9(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetCSR_SOF9() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetCSR_SOF10(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x400)|value<<10)
}
func (o *DMAMUX_Type) GetCSR_SOF10() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x400) >> 10
}
func (o *DMAMUX_Type) SetCSR_SOF11(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x800)|value<<11)
}
func (o *DMAMUX_Type) GetCSR_SOF11() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x800) >> 11
}
func (o *DMAMUX_Type) SetCSR_SOF12(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1000)|value<<12)
}
func (o *DMAMUX_Type) GetCSR_SOF12() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x1000) >> 12
}
func (o *DMAMUX_Type) SetCSR_SOF13(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2000)|value<<13)
}
func (o *DMAMUX_Type) GetCSR_SOF13() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2000) >> 13
}
func (o *DMAMUX_Type) SetCSR_SOF14(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4000)|value<<14)
}
func (o *DMAMUX_Type) GetCSR_SOF14() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4000) >> 14
}
func (o *DMAMUX_Type) SetCSR_SOF15(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8000)|value<<15)
}
func (o *DMAMUX_Type) GetCSR_SOF15() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8000) >> 15
}

// DMAMUX.CCFR: DMA Channel Clear Flag Register
func (o *DMAMUX_Type) SetCCFR_CSOF0(value uint32) {
	volatile.StoreUint32(&o.CCFR.Reg, volatile.LoadUint32(&o.CCFR.Reg)&^(0x1)|value)
}
func (o *DMAMUX_Type) GetCCFR_CSOF0() uint32 {
	return volatile.LoadUint32(&o.CCFR.Reg) & 0x1
}
func (o *DMAMUX_Type) SetCCFR_CSOF1(value uint32) {
	volatile.StoreUint32(&o.CCFR.Reg, volatile.LoadUint32(&o.CCFR.Reg)&^(0x2)|value<<1)
}
func (o *DMAMUX_Type) GetCCFR_CSOF1() uint32 {
	return (volatile.LoadUint32(&o.CCFR.Reg) & 0x2) >> 1
}
func (o *DMAMUX_Type) SetCCFR_CSOF2(value uint32) {
	volatile.StoreUint32(&o.CCFR.Reg, volatile.LoadUint32(&o.CCFR.Reg)&^(0x4)|value<<2)
}
func (o *DMAMUX_Type) GetCCFR_CSOF2() uint32 {
	return (volatile.LoadUint32(&o.CCFR.Reg) & 0x4) >> 2
}
func (o *DMAMUX_Type) SetCCFR_CSOF3(value uint32) {
	volatile.StoreUint32(&o.CCFR.Reg, volatile.LoadUint32(&o.CCFR.Reg)&^(0x8)|value<<3)
}
func (o *DMAMUX_Type) GetCCFR_CSOF3() uint32 {
	return (volatile.LoadUint32(&o.CCFR.Reg) & 0x8) >> 3
}
func (o *DMAMUX_Type) SetCCFR_CSOF4(value uint32) {
	volatile.StoreUint32(&o.CCFR.Reg, volatile.LoadUint32(&o.CCFR.Reg)&^(0x10)|value<<4)
}
func (o *DMAMUX_Type) GetCCFR_CSOF4() uint32 {
	return (volatile.LoadUint32(&o.CCFR.Reg) & 0x10) >> 4
}
func (o *DMAMUX_Type) SetCCFR_CSOF5(value uint32) {
	volatile.StoreUint32(&o.CCFR.Reg, volatile.LoadUint32(&o.CCFR.Reg)&^(0x20)|value<<5)
}
func (o *DMAMUX_Type) GetCCFR_CSOF5() uint32 {
	return (volatile.LoadUint32(&o.CCFR.Reg) & 0x20) >> 5
}
func (o *DMAMUX_Type) SetCCFR_CSOF6(value uint32) {
	volatile.StoreUint32(&o.CCFR.Reg, volatile.LoadUint32(&o.CCFR.Reg)&^(0x40)|value<<6)
}
func (o *DMAMUX_Type) GetCCFR_CSOF6() uint32 {
	return (volatile.LoadUint32(&o.CCFR.Reg) & 0x40) >> 6
}
func (o *DMAMUX_Type) SetCCFR_CSOF7(value uint32) {
	volatile.StoreUint32(&o.CCFR.Reg, volatile.LoadUint32(&o.CCFR.Reg)&^(0x80)|value<<7)
}
func (o *DMAMUX_Type) GetCCFR_CSOF7() uint32 {
	return (volatile.LoadUint32(&o.CCFR.Reg) & 0x80) >> 7
}
func (o *DMAMUX_Type) SetCCFR_CSOF8(value uint32) {
	volatile.StoreUint32(&o.CCFR.Reg, volatile.LoadUint32(&o.CCFR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetCCFR_CSOF8() uint32 {
	return (volatile.LoadUint32(&o.CCFR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetCCFR_CSOF9(value uint32) {
	volatile.StoreUint32(&o.CCFR.Reg, volatile.LoadUint32(&o.CCFR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetCCFR_CSOF9() uint32 {
	return (volatile.LoadUint32(&o.CCFR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetCCFR_CSOF10(value uint32) {
	volatile.StoreUint32(&o.CCFR.Reg, volatile.LoadUint32(&o.CCFR.Reg)&^(0x400)|value<<10)
}
func (o *DMAMUX_Type) GetCCFR_CSOF10() uint32 {
	return (volatile.LoadUint32(&o.CCFR.Reg) & 0x400) >> 10
}
func (o *DMAMUX_Type) SetCCFR_CSOF11(value uint32) {
	volatile.StoreUint32(&o.CCFR.Reg, volatile.LoadUint32(&o.CCFR.Reg)&^(0x800)|value<<11)
}
func (o *DMAMUX_Type) GetCCFR_CSOF11() uint32 {
	return (volatile.LoadUint32(&o.CCFR.Reg) & 0x800) >> 11
}
func (o *DMAMUX_Type) SetCCFR_CSOF12(value uint32) {
	volatile.StoreUint32(&o.CCFR.Reg, volatile.LoadUint32(&o.CCFR.Reg)&^(0x1000)|value<<12)
}
func (o *DMAMUX_Type) GetCCFR_CSOF12() uint32 {
	return (volatile.LoadUint32(&o.CCFR.Reg) & 0x1000) >> 12
}
func (o *DMAMUX_Type) SetCCFR_CSOF13(value uint32) {
	volatile.StoreUint32(&o.CCFR.Reg, volatile.LoadUint32(&o.CCFR.Reg)&^(0x2000)|value<<13)
}
func (o *DMAMUX_Type) GetCCFR_CSOF13() uint32 {
	return (volatile.LoadUint32(&o.CCFR.Reg) & 0x2000) >> 13
}
func (o *DMAMUX_Type) SetCCFR_CSOF14(value uint32) {
	volatile.StoreUint32(&o.CCFR.Reg, volatile.LoadUint32(&o.CCFR.Reg)&^(0x4000)|value<<14)
}
func (o *DMAMUX_Type) GetCCFR_CSOF14() uint32 {
	return (volatile.LoadUint32(&o.CCFR.Reg) & 0x4000) >> 14
}
func (o *DMAMUX_Type) SetCCFR_CSOF15(value uint32) {
	volatile.StoreUint32(&o.CCFR.Reg, volatile.LoadUint32(&o.CCFR.Reg)&^(0x8000)|value<<15)
}
func (o *DMAMUX_Type) GetCCFR_CSOF15() uint32 {
	return (volatile.LoadUint32(&o.CCFR.Reg) & 0x8000) >> 15
}

// DMAMUX.RG0CR: DMA Request Generator 0 Control Register
func (o *DMAMUX_Type) SetRG0CR_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RG0CR.Reg, volatile.LoadUint32(&o.RG0CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRG0CR_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RG0CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetRG0CR_GPOL(value uint32) {
	volatile.StoreUint32(&o.RG0CR.Reg, volatile.LoadUint32(&o.RG0CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRG0CR_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RG0CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRG0CR_GE(value uint32) {
	volatile.StoreUint32(&o.RG0CR.Reg, volatile.LoadUint32(&o.RG0CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRG0CR_GE() uint32 {
	return (volatile.LoadUint32(&o.RG0CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRG0CR_OIE(value uint32) {
	volatile.StoreUint32(&o.RG0CR.Reg, volatile.LoadUint32(&o.RG0CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRG0CR_OIE() uint32 {
	return (volatile.LoadUint32(&o.RG0CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRG0CR_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RG0CR.Reg, volatile.LoadUint32(&o.RG0CR.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRG0CR_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RG0CR.Reg) & 0x1f
}

// DMAMUX.RG1CR: DMA Request Generator 1 Control Register
func (o *DMAMUX_Type) SetRG1CR_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RG1CR.Reg, volatile.LoadUint32(&o.RG1CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRG1CR_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RG1CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetRG1CR_GPOL(value uint32) {
	volatile.StoreUint32(&o.RG1CR.Reg, volatile.LoadUint32(&o.RG1CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRG1CR_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RG1CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRG1CR_GE(value uint32) {
	volatile.StoreUint32(&o.RG1CR.Reg, volatile.LoadUint32(&o.RG1CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRG1CR_GE() uint32 {
	return (volatile.LoadUint32(&o.RG1CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRG1CR_OIE(value uint32) {
	volatile.StoreUint32(&o.RG1CR.Reg, volatile.LoadUint32(&o.RG1CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRG1CR_OIE() uint32 {
	return (volatile.LoadUint32(&o.RG1CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRG1CR_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RG1CR.Reg, volatile.LoadUint32(&o.RG1CR.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRG1CR_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RG1CR.Reg) & 0x1f
}

// DMAMUX.RG2CR: DMA Request Generator 2 Control Register
func (o *DMAMUX_Type) SetRG2CR_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RG2CR.Reg, volatile.LoadUint32(&o.RG2CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRG2CR_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RG2CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetRG2CR_GPOL(value uint32) {
	volatile.StoreUint32(&o.RG2CR.Reg, volatile.LoadUint32(&o.RG2CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRG2CR_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RG2CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRG2CR_GE(value uint32) {
	volatile.StoreUint32(&o.RG2CR.Reg, volatile.LoadUint32(&o.RG2CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRG2CR_GE() uint32 {
	return (volatile.LoadUint32(&o.RG2CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRG2CR_OIE(value uint32) {
	volatile.StoreUint32(&o.RG2CR.Reg, volatile.LoadUint32(&o.RG2CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRG2CR_OIE() uint32 {
	return (volatile.LoadUint32(&o.RG2CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRG2CR_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RG2CR.Reg, volatile.LoadUint32(&o.RG2CR.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRG2CR_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RG2CR.Reg) & 0x1f
}

// DMAMUX.RG3CR: DMA Request Generator 3 Control Register
func (o *DMAMUX_Type) SetRG3CR_GNBREQ(value uint32) {
	volatile.StoreUint32(&o.RG3CR.Reg, volatile.LoadUint32(&o.RG3CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetRG3CR_GNBREQ() uint32 {
	return (volatile.LoadUint32(&o.RG3CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetRG3CR_GPOL(value uint32) {
	volatile.StoreUint32(&o.RG3CR.Reg, volatile.LoadUint32(&o.RG3CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetRG3CR_GPOL() uint32 {
	return (volatile.LoadUint32(&o.RG3CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetRG3CR_GE(value uint32) {
	volatile.StoreUint32(&o.RG3CR.Reg, volatile.LoadUint32(&o.RG3CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetRG3CR_GE() uint32 {
	return (volatile.LoadUint32(&o.RG3CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetRG3CR_OIE(value uint32) {
	volatile.StoreUint32(&o.RG3CR.Reg, volatile.LoadUint32(&o.RG3CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetRG3CR_OIE() uint32 {
	return (volatile.LoadUint32(&o.RG3CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetRG3CR_SIG_ID(value uint32) {
	volatile.StoreUint32(&o.RG3CR.Reg, volatile.LoadUint32(&o.RG3CR.Reg)&^(0x1f)|value)
}
func (o *DMAMUX_Type) GetRG3CR_SIG_ID() uint32 {
	return volatile.LoadUint32(&o.RG3CR.Reg) & 0x1f
}

// DMAMUX.C14CR: DMA Multiplexer Channel 10 Control register
func (o *DMAMUX_Type) SetC14CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C14CR.Reg, volatile.LoadUint32(&o.C14CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC14CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C14CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC14CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C14CR.Reg, volatile.LoadUint32(&o.C14CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC14CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C14CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC14CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C14CR.Reg, volatile.LoadUint32(&o.C14CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC14CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C14CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC14CR_SE(value uint32) {
	volatile.StoreUint32(&o.C14CR.Reg, volatile.LoadUint32(&o.C14CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC14CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C14CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC14CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C14CR.Reg, volatile.LoadUint32(&o.C14CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC14CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C14CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC14CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C14CR.Reg, volatile.LoadUint32(&o.C14CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC14CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C14CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC14CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C14CR.Reg, volatile.LoadUint32(&o.C14CR.Reg)&^(0x7f)|value)
}
func (o *DMAMUX_Type) GetC14CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C14CR.Reg) & 0x7f
}

// DMAMUX.C15CR: DMA Multiplexer Channel 10 Control register
func (o *DMAMUX_Type) SetC15CR_SYNC_ID(value uint32) {
	volatile.StoreUint32(&o.C15CR.Reg, volatile.LoadUint32(&o.C15CR.Reg)&^(0x1f000000)|value<<24)
}
func (o *DMAMUX_Type) GetC15CR_SYNC_ID() uint32 {
	return (volatile.LoadUint32(&o.C15CR.Reg) & 0x1f000000) >> 24
}
func (o *DMAMUX_Type) SetC15CR_NBREQ(value uint32) {
	volatile.StoreUint32(&o.C15CR.Reg, volatile.LoadUint32(&o.C15CR.Reg)&^(0xf80000)|value<<19)
}
func (o *DMAMUX_Type) GetC15CR_NBREQ() uint32 {
	return (volatile.LoadUint32(&o.C15CR.Reg) & 0xf80000) >> 19
}
func (o *DMAMUX_Type) SetC15CR_SPOL(value uint32) {
	volatile.StoreUint32(&o.C15CR.Reg, volatile.LoadUint32(&o.C15CR.Reg)&^(0x60000)|value<<17)
}
func (o *DMAMUX_Type) GetC15CR_SPOL() uint32 {
	return (volatile.LoadUint32(&o.C15CR.Reg) & 0x60000) >> 17
}
func (o *DMAMUX_Type) SetC15CR_SE(value uint32) {
	volatile.StoreUint32(&o.C15CR.Reg, volatile.LoadUint32(&o.C15CR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAMUX_Type) GetC15CR_SE() uint32 {
	return (volatile.LoadUint32(&o.C15CR.Reg) & 0x10000) >> 16
}
func (o *DMAMUX_Type) SetC15CR_EGE(value uint32) {
	volatile.StoreUint32(&o.C15CR.Reg, volatile.LoadUint32(&o.C15CR.Reg)&^(0x200)|value<<9)
}
func (o *DMAMUX_Type) GetC15CR_EGE() uint32 {
	return (volatile.LoadUint32(&o.C15CR.Reg) & 0x200) >> 9
}
func (o *DMAMUX_Type) SetC15CR_SOIE(value uint32) {
	volatile.StoreUint32(&o.C15CR.Reg, volatile.LoadUint32(&o.C15CR.Reg)&^(0x100)|value<<8)
}
func (o *DMAMUX_Type) GetC15CR_SOIE() uint32 {
	return (volatile.LoadUint32(&o.C15CR.Reg) & 0x100) >> 8
}
func (o *DMAMUX_Type) SetC15CR_DMAREQ_ID(value uint32) {
	volatile.StoreUint32(&o.C15CR.Reg, volatile.LoadUint32(&o.C15CR.Reg)&^(0x7f)|value)
}
func (o *DMAMUX_Type) GetC15CR_DMAREQ_ID() uint32 {
	return volatile.LoadUint32(&o.C15CR.Reg) & 0x7f
}

// DMAMUX.RGSR: DMA Request Generator Status Register
func (o *DMAMUX_Type) SetRGSR_OF0(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0x1)|value)
}
func (o *DMAMUX_Type) GetRGSR_OF0() uint32 {
	return volatile.LoadUint32(&o.RGSR.Reg) & 0x1
}
func (o *DMAMUX_Type) SetRGSR_OF1(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0x2)|value<<1)
}
func (o *DMAMUX_Type) GetRGSR_OF1() uint32 {
	return (volatile.LoadUint32(&o.RGSR.Reg) & 0x2) >> 1
}
func (o *DMAMUX_Type) SetRGSR_OF2(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0x4)|value<<2)
}
func (o *DMAMUX_Type) GetRGSR_OF2() uint32 {
	return (volatile.LoadUint32(&o.RGSR.Reg) & 0x4) >> 2
}
func (o *DMAMUX_Type) SetRGSR_OF3(value uint32) {
	volatile.StoreUint32(&o.RGSR.Reg, volatile.LoadUint32(&o.RGSR.Reg)&^(0x8)|value<<3)
}
func (o *DMAMUX_Type) GetRGSR_OF3() uint32 {
	return (volatile.LoadUint32(&o.RGSR.Reg) & 0x8) >> 3
}

// DMAMUX.RGCFR: DMA Request Generator Clear Flag Register
func (o *DMAMUX_Type) SetRGCFR_CSOF0(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0x1)|value)
}
func (o *DMAMUX_Type) GetRGCFR_CSOF0() uint32 {
	return volatile.LoadUint32(&o.RGCFR.Reg) & 0x1
}
func (o *DMAMUX_Type) SetRGCFR_CSOF1(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0x2)|value<<1)
}
func (o *DMAMUX_Type) GetRGCFR_CSOF1() uint32 {
	return (volatile.LoadUint32(&o.RGCFR.Reg) & 0x2) >> 1
}
func (o *DMAMUX_Type) SetRGCFR_CSOF2(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0x4)|value<<2)
}
func (o *DMAMUX_Type) GetRGCFR_CSOF2() uint32 {
	return (volatile.LoadUint32(&o.RGCFR.Reg) & 0x4) >> 2
}
func (o *DMAMUX_Type) SetRGCFR_CSOF3(value uint32) {
	volatile.StoreUint32(&o.RGCFR.Reg, volatile.LoadUint32(&o.RGCFR.Reg)&^(0x8)|value<<3)
}
func (o *DMAMUX_Type) GetRGCFR_CSOF3() uint32 {
	return (volatile.LoadUint32(&o.RGCFR.Reg) & 0x8) >> 3
}

// External interrupt/event controller
type EXTI_Type struct {
	RTSR1     volatile.Register32 // 0x0
	FTSR1     volatile.Register32 // 0x4
	SWIER1    volatile.Register32 // 0x8
	RPR1      volatile.Register32 // 0xC
	FPR1      volatile.Register32 // 0x10
	SECCFGR1  volatile.Register32 // 0x14
	PRIVCFGR1 volatile.Register32 // 0x18
	_         [4]byte
	RTSR2     volatile.Register32 // 0x20
	FTSR2     volatile.Register32 // 0x24
	SWIER2    volatile.Register32 // 0x28
	RPR2      volatile.Register32 // 0x2C
	FPR2      volatile.Register32 // 0x30
	PRIVCFGR2 volatile.Register32 // 0x34
	SECCFGR2  volatile.Register32 // 0x38
	_         [36]byte
	EXTICR1   volatile.Register32 // 0x60
	EXTICR2   volatile.Register32 // 0x64
	EXTICR3   volatile.Register32 // 0x68
	EXTICR4   volatile.Register32 // 0x6C
	LOCKRG    volatile.Register32 // 0x70
	_         [12]byte
	IMR1      volatile.Register32 // 0x80
	EMR1      volatile.Register32 // 0x84
	_         [8]byte
	IMR2      volatile.Register32 // 0x90
	EMR2      volatile.Register32 // 0x94
}

// EXTI.RTSR1: EXTI rising trigger selection register
func (o *EXTI_Type) SetRTSR1_RT0(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetRTSR1_RT0() uint32 {
	return volatile.LoadUint32(&o.RTSR1.Reg) & 0x1
}
func (o *EXTI_Type) SetRTSR1_RT1(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetRTSR1_RT1() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetRTSR1_RT2(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetRTSR1_RT2() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetRTSR1_RT3(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetRTSR1_RT3() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetRTSR1_RT4(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetRTSR1_RT4() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetRTSR1_RT5(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetRTSR1_RT5() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetRTSR1_RT6(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetRTSR1_RT6() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetRTSR1_RT7(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetRTSR1_RT7() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetRTSR1_RT8(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetRTSR1_RT8() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetRTSR1_RT9(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetRTSR1_RT9() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetRTSR1_RT10(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetRTSR1_RT10() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetRTSR1_RT11(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetRTSR1_RT11() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetRTSR1_RT12(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetRTSR1_RT12() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetRTSR1_RT13(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetRTSR1_RT13() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetRTSR1_RT14(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetRTSR1_RT14() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetRTSR1_RT15(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetRTSR1_RT15() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetRTSR1_RT16(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetRTSR1_RT16() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetRTSR1_RT21(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetRTSR1_RT21() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetRTSR1_RT22(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetRTSR1_RT22() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x400000) >> 22
}

// EXTI.FTSR1: EXTI falling trigger selection register
func (o *EXTI_Type) SetFTSR1_FT0(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetFTSR1_FT0() uint32 {
	return volatile.LoadUint32(&o.FTSR1.Reg) & 0x1
}
func (o *EXTI_Type) SetFTSR1_FT1(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetFTSR1_FT1() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetFTSR1_FT2(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetFTSR1_FT2() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetFTSR1_FT3(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetFTSR1_FT3() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetFTSR1_FT4(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetFTSR1_FT4() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetFTSR1_FT5(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetFTSR1_FT5() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetFTSR1_FT6(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetFTSR1_FT6() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetFTSR1_FT7(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetFTSR1_FT7() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetFTSR1_FT8(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetFTSR1_FT8() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetFTSR1_FT9(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetFTSR1_FT9() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetFTSR1_FT10(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetFTSR1_FT10() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetFTSR1_FT11(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetFTSR1_FT11() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetFTSR1_FT12(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetFTSR1_FT12() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetFTSR1_FT13(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetFTSR1_FT13() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetFTSR1_FT14(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetFTSR1_FT14() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetFTSR1_FT15(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetFTSR1_FT15() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetFTSR1_FT16(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetFTSR1_FT16() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetFTSR1_FT21(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetFTSR1_FT21() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetFTSR1_FT22(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetFTSR1_FT22() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x400000) >> 22
}

// EXTI.SWIER1: EXTI software interrupt event register
func (o *EXTI_Type) SetSWIER1_SWI0(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetSWIER1_SWI0() uint32 {
	return volatile.LoadUint32(&o.SWIER1.Reg) & 0x1
}
func (o *EXTI_Type) SetSWIER1_SWI1(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetSWIER1_SWI1() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetSWIER1_SWI2(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetSWIER1_SWI2() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetSWIER1_SWI3(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetSWIER1_SWI3() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetSWIER1_SWI4(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetSWIER1_SWI4() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetSWIER1_SWI5(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetSWIER1_SWI5() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetSWIER1_SWI6(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetSWIER1_SWI6() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetSWIER1_SWI7(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetSWIER1_SWI7() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetSWIER1_SWI8(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetSWIER1_SWI8() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetSWIER1_SWI9(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetSWIER1_SWI9() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetSWIER1_SWI10(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetSWIER1_SWI10() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetSWIER1_SWI11(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetSWIER1_SWI11() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetSWIER1_SWI12(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetSWIER1_SWI12() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetSWIER1_SWI13(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetSWIER1_SWI13() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetSWIER1_SWI14(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetSWIER1_SWI14() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetSWIER1_SWI15(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetSWIER1_SWI15() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetSWIER1_SWI16(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetSWIER1_SWI16() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetSWIER1_SWI21(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetSWIER1_SWI21() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetSWIER1_SWI22(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetSWIER1_SWI22() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x400000) >> 22
}

// EXTI.RPR1: EXTI rising edge pending register
func (o *EXTI_Type) SetRPR1_RPIF0(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetRPR1_RPIF0() uint32 {
	return volatile.LoadUint32(&o.RPR1.Reg) & 0x1
}
func (o *EXTI_Type) SetRPR1_RPIF1(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetRPR1_RPIF1() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetRPR1_RPIF2(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetRPR1_RPIF2() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetRPR1_RPIF3(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetRPR1_RPIF3() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetRPR1_RPIF4(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetRPR1_RPIF4() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetRPR1_RPIF5(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetRPR1_RPIF5() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetRPR1_RPIF6(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetRPR1_RPIF6() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetRPR1_RPIF7(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetRPR1_RPIF7() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetRPR1_RPIF8(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetRPR1_RPIF8() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetRPR1_RPIF9(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetRPR1_RPIF9() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetRPR1_RPIF10(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetRPR1_RPIF10() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetRPR1_RPIF11(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetRPR1_RPIF11() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetRPR1_RPIF12(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetRPR1_RPIF12() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetRPR1_RPIF13(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetRPR1_RPIF13() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetRPR1_RPIF14(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetRPR1_RPIF14() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetRPR1_RPIF15(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetRPR1_RPIF15() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetRPR1_RPIF16(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetRPR1_RPIF16() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetRPR1_RPIF21(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetRPR1_RPIF21() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetRPR1_RPIF22(value uint32) {
	volatile.StoreUint32(&o.RPR1.Reg, volatile.LoadUint32(&o.RPR1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetRPR1_RPIF22() uint32 {
	return (volatile.LoadUint32(&o.RPR1.Reg) & 0x400000) >> 22
}

// EXTI.FPR1: EXTI falling edge pending register
func (o *EXTI_Type) SetFPR1_FPIF0(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetFPR1_FPIF0() uint32 {
	return volatile.LoadUint32(&o.FPR1.Reg) & 0x1
}
func (o *EXTI_Type) SetFPR1_FPIF1(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetFPR1_FPIF1() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetFPR1_FPIF2(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetFPR1_FPIF2() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetFPR1_FPIF3(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetFPR1_FPIF3() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetFPR1_FPIF4(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetFPR1_FPIF4() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetFPR1_FPIF5(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetFPR1_FPIF5() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetFPR1_FPIF6(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetFPR1_FPIF6() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetFPR1_FPIF7(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetFPR1_FPIF7() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetFPR1_FPIF8(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetFPR1_FPIF8() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetFPR1_FPIF9(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetFPR1_FPIF9() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetFPR1_FPIF10(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetFPR1_FPIF10() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetFPR1_FPIF11(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetFPR1_FPIF11() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetFPR1_FPIF12(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetFPR1_FPIF12() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetFPR1_FPIF13(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetFPR1_FPIF13() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetFPR1_FPIF14(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetFPR1_FPIF14() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetFPR1_FPIF15(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetFPR1_FPIF15() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetFPR1_FPIF16(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetFPR1_FPIF16() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetFPR1_FPIF21(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetFPR1_FPIF21() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetFPR1_FPIF22(value uint32) {
	volatile.StoreUint32(&o.FPR1.Reg, volatile.LoadUint32(&o.FPR1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetFPR1_FPIF22() uint32 {
	return (volatile.LoadUint32(&o.FPR1.Reg) & 0x400000) >> 22
}

// EXTI.SECCFGR1: EXTI security configuration register
func (o *EXTI_Type) SetSECCFGR1_SEC0(value uint32) {
	volatile.StoreUint32(&o.SECCFGR1.Reg, volatile.LoadUint32(&o.SECCFGR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetSECCFGR1_SEC0() uint32 {
	return volatile.LoadUint32(&o.SECCFGR1.Reg) & 0x1
}
func (o *EXTI_Type) SetSECCFGR1_SEC1(value uint32) {
	volatile.StoreUint32(&o.SECCFGR1.Reg, volatile.LoadUint32(&o.SECCFGR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetSECCFGR1_SEC1() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetSECCFGR1_SEC2(value uint32) {
	volatile.StoreUint32(&o.SECCFGR1.Reg, volatile.LoadUint32(&o.SECCFGR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetSECCFGR1_SEC2() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetSECCFGR1_SEC3(value uint32) {
	volatile.StoreUint32(&o.SECCFGR1.Reg, volatile.LoadUint32(&o.SECCFGR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetSECCFGR1_SEC3() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetSECCFGR1_SEC4(value uint32) {
	volatile.StoreUint32(&o.SECCFGR1.Reg, volatile.LoadUint32(&o.SECCFGR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetSECCFGR1_SEC4() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetSECCFGR1_SEC5(value uint32) {
	volatile.StoreUint32(&o.SECCFGR1.Reg, volatile.LoadUint32(&o.SECCFGR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetSECCFGR1_SEC5() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetSECCFGR1_SEC6(value uint32) {
	volatile.StoreUint32(&o.SECCFGR1.Reg, volatile.LoadUint32(&o.SECCFGR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetSECCFGR1_SEC6() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetSECCFGR1_SEC7(value uint32) {
	volatile.StoreUint32(&o.SECCFGR1.Reg, volatile.LoadUint32(&o.SECCFGR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetSECCFGR1_SEC7() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetSECCFGR1_SEC8(value uint32) {
	volatile.StoreUint32(&o.SECCFGR1.Reg, volatile.LoadUint32(&o.SECCFGR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetSECCFGR1_SEC8() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetSECCFGR1_SEC9(value uint32) {
	volatile.StoreUint32(&o.SECCFGR1.Reg, volatile.LoadUint32(&o.SECCFGR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetSECCFGR1_SEC9() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetSECCFGR1_SEC10(value uint32) {
	volatile.StoreUint32(&o.SECCFGR1.Reg, volatile.LoadUint32(&o.SECCFGR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetSECCFGR1_SEC10() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetSECCFGR1_SEC11(value uint32) {
	volatile.StoreUint32(&o.SECCFGR1.Reg, volatile.LoadUint32(&o.SECCFGR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetSECCFGR1_SEC11() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetSECCFGR1_SEC12(value uint32) {
	volatile.StoreUint32(&o.SECCFGR1.Reg, volatile.LoadUint32(&o.SECCFGR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetSECCFGR1_SEC12() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetSECCFGR1_SEC13(value uint32) {
	volatile.StoreUint32(&o.SECCFGR1.Reg, volatile.LoadUint32(&o.SECCFGR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetSECCFGR1_SEC13() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetSECCFGR1_SEC14(value uint32) {
	volatile.StoreUint32(&o.SECCFGR1.Reg, volatile.LoadUint32(&o.SECCFGR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetSECCFGR1_SEC14() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetSECCFGR1_SEC15(value uint32) {
	volatile.StoreUint32(&o.SECCFGR1.Reg, volatile.LoadUint32(&o.SECCFGR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetSECCFGR1_SEC15() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetSECCFGR1_SEC16(value uint32) {
	volatile.StoreUint32(&o.SECCFGR1.Reg, volatile.LoadUint32(&o.SECCFGR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetSECCFGR1_SEC16() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetSECCFGR1_SEC17(value uint32) {
	volatile.StoreUint32(&o.SECCFGR1.Reg, volatile.LoadUint32(&o.SECCFGR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetSECCFGR1_SEC17() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetSECCFGR1_SEC18(value uint32) {
	volatile.StoreUint32(&o.SECCFGR1.Reg, volatile.LoadUint32(&o.SECCFGR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetSECCFGR1_SEC18() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetSECCFGR1_SEC19(value uint32) {
	volatile.StoreUint32(&o.SECCFGR1.Reg, volatile.LoadUint32(&o.SECCFGR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetSECCFGR1_SEC19() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetSECCFGR1_SEC20(value uint32) {
	volatile.StoreUint32(&o.SECCFGR1.Reg, volatile.LoadUint32(&o.SECCFGR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetSECCFGR1_SEC20() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetSECCFGR1_SEC21(value uint32) {
	volatile.StoreUint32(&o.SECCFGR1.Reg, volatile.LoadUint32(&o.SECCFGR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetSECCFGR1_SEC21() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetSECCFGR1_SEC22(value uint32) {
	volatile.StoreUint32(&o.SECCFGR1.Reg, volatile.LoadUint32(&o.SECCFGR1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetSECCFGR1_SEC22() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR1.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetSECCFGR1_SEC23(value uint32) {
	volatile.StoreUint32(&o.SECCFGR1.Reg, volatile.LoadUint32(&o.SECCFGR1.Reg)&^(0x800000)|value<<23)
}
func (o *EXTI_Type) GetSECCFGR1_SEC23() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR1.Reg) & 0x800000) >> 23
}
func (o *EXTI_Type) SetSECCFGR1_SEC24(value uint32) {
	volatile.StoreUint32(&o.SECCFGR1.Reg, volatile.LoadUint32(&o.SECCFGR1.Reg)&^(0x1000000)|value<<24)
}
func (o *EXTI_Type) GetSECCFGR1_SEC24() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR1.Reg) & 0x1000000) >> 24
}
func (o *EXTI_Type) SetSECCFGR1_SEC25(value uint32) {
	volatile.StoreUint32(&o.SECCFGR1.Reg, volatile.LoadUint32(&o.SECCFGR1.Reg)&^(0x2000000)|value<<25)
}
func (o *EXTI_Type) GetSECCFGR1_SEC25() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR1.Reg) & 0x2000000) >> 25
}
func (o *EXTI_Type) SetSECCFGR1_SEC26(value uint32) {
	volatile.StoreUint32(&o.SECCFGR1.Reg, volatile.LoadUint32(&o.SECCFGR1.Reg)&^(0x4000000)|value<<26)
}
func (o *EXTI_Type) GetSECCFGR1_SEC26() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR1.Reg) & 0x4000000) >> 26
}
func (o *EXTI_Type) SetSECCFGR1_SEC27(value uint32) {
	volatile.StoreUint32(&o.SECCFGR1.Reg, volatile.LoadUint32(&o.SECCFGR1.Reg)&^(0x8000000)|value<<27)
}
func (o *EXTI_Type) GetSECCFGR1_SEC27() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR1.Reg) & 0x8000000) >> 27
}
func (o *EXTI_Type) SetSECCFGR1_SEC28(value uint32) {
	volatile.StoreUint32(&o.SECCFGR1.Reg, volatile.LoadUint32(&o.SECCFGR1.Reg)&^(0x10000000)|value<<28)
}
func (o *EXTI_Type) GetSECCFGR1_SEC28() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR1.Reg) & 0x10000000) >> 28
}
func (o *EXTI_Type) SetSECCFGR1_SEC29(value uint32) {
	volatile.StoreUint32(&o.SECCFGR1.Reg, volatile.LoadUint32(&o.SECCFGR1.Reg)&^(0x20000000)|value<<29)
}
func (o *EXTI_Type) GetSECCFGR1_SEC29() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR1.Reg) & 0x20000000) >> 29
}
func (o *EXTI_Type) SetSECCFGR1_SEC30(value uint32) {
	volatile.StoreUint32(&o.SECCFGR1.Reg, volatile.LoadUint32(&o.SECCFGR1.Reg)&^(0x40000000)|value<<30)
}
func (o *EXTI_Type) GetSECCFGR1_SEC30() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR1.Reg) & 0x40000000) >> 30
}
func (o *EXTI_Type) SetSECCFGR1_SEC31(value uint32) {
	volatile.StoreUint32(&o.SECCFGR1.Reg, volatile.LoadUint32(&o.SECCFGR1.Reg)&^(0x80000000)|value<<31)
}
func (o *EXTI_Type) GetSECCFGR1_SEC31() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR1.Reg) & 0x80000000) >> 31
}

// EXTI.PRIVCFGR1: EXTI privilege configuration register
func (o *EXTI_Type) SetPRIVCFGR1_PRIV0(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR1.Reg, volatile.LoadUint32(&o.PRIVCFGR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetPRIVCFGR1_PRIV0() uint32 {
	return volatile.LoadUint32(&o.PRIVCFGR1.Reg) & 0x1
}
func (o *EXTI_Type) SetPRIVCFGR1_PRIV1(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR1.Reg, volatile.LoadUint32(&o.PRIVCFGR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetPRIVCFGR1_PRIV1() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetPRIVCFGR1_PRIV2(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR1.Reg, volatile.LoadUint32(&o.PRIVCFGR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetPRIVCFGR1_PRIV2() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetPRIVCFGR1_PRIV3(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR1.Reg, volatile.LoadUint32(&o.PRIVCFGR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetPRIVCFGR1_PRIV3() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetPRIVCFGR1_PRIV4(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR1.Reg, volatile.LoadUint32(&o.PRIVCFGR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetPRIVCFGR1_PRIV4() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetPRIVCFGR1_PRIV5(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR1.Reg, volatile.LoadUint32(&o.PRIVCFGR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetPRIVCFGR1_PRIV5() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetPRIVCFGR1_PRIV6(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR1.Reg, volatile.LoadUint32(&o.PRIVCFGR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetPRIVCFGR1_PRIV6() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetPRIVCFGR1_PRIV7(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR1.Reg, volatile.LoadUint32(&o.PRIVCFGR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetPRIVCFGR1_PRIV7() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetPRIVCFGR1_PRIV8(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR1.Reg, volatile.LoadUint32(&o.PRIVCFGR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetPRIVCFGR1_PRIV8() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetPRIVCFGR1_PRIV9(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR1.Reg, volatile.LoadUint32(&o.PRIVCFGR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetPRIVCFGR1_PRIV9() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetPRIVCFGR1_PRIV10(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR1.Reg, volatile.LoadUint32(&o.PRIVCFGR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetPRIVCFGR1_PRIV10() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetPRIVCFGR1_PRIV11(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR1.Reg, volatile.LoadUint32(&o.PRIVCFGR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetPRIVCFGR1_PRIV11() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetPRIVCFGR1_PRIV12(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR1.Reg, volatile.LoadUint32(&o.PRIVCFGR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetPRIVCFGR1_PRIV12() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetPRIVCFGR1_PRIV13(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR1.Reg, volatile.LoadUint32(&o.PRIVCFGR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetPRIVCFGR1_PRIV13() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetPRIVCFGR1_PRIV14(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR1.Reg, volatile.LoadUint32(&o.PRIVCFGR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetPRIVCFGR1_PRIV14() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetPRIVCFGR1_PRIV15(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR1.Reg, volatile.LoadUint32(&o.PRIVCFGR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetPRIVCFGR1_PRIV15() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetPRIVCFGR1_PRIV16(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR1.Reg, volatile.LoadUint32(&o.PRIVCFGR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetPRIVCFGR1_PRIV16() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetPRIVCFGR1_PRIV17(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR1.Reg, volatile.LoadUint32(&o.PRIVCFGR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetPRIVCFGR1_PRIV17() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetPRIVCFGR1_PRIV18(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR1.Reg, volatile.LoadUint32(&o.PRIVCFGR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetPRIVCFGR1_PRIV18() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetPRIVCFGR1_PRIV19(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR1.Reg, volatile.LoadUint32(&o.PRIVCFGR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetPRIVCFGR1_PRIV19() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetPRIVCFGR1_PRIV20(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR1.Reg, volatile.LoadUint32(&o.PRIVCFGR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetPRIVCFGR1_PRIV20() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetPRIVCFGR1_PRIV21(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR1.Reg, volatile.LoadUint32(&o.PRIVCFGR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetPRIVCFGR1_PRIV21() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetPRIVCFGR1_PRIV22(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR1.Reg, volatile.LoadUint32(&o.PRIVCFGR1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetPRIVCFGR1_PRIV22() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR1.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetPRIVCFGR1_PRIV23(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR1.Reg, volatile.LoadUint32(&o.PRIVCFGR1.Reg)&^(0x800000)|value<<23)
}
func (o *EXTI_Type) GetPRIVCFGR1_PRIV23() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR1.Reg) & 0x800000) >> 23
}
func (o *EXTI_Type) SetPRIVCFGR1_PRIV24(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR1.Reg, volatile.LoadUint32(&o.PRIVCFGR1.Reg)&^(0x1000000)|value<<24)
}
func (o *EXTI_Type) GetPRIVCFGR1_PRIV24() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR1.Reg) & 0x1000000) >> 24
}
func (o *EXTI_Type) SetPRIVCFGR1_PRIV25(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR1.Reg, volatile.LoadUint32(&o.PRIVCFGR1.Reg)&^(0x2000000)|value<<25)
}
func (o *EXTI_Type) GetPRIVCFGR1_PRIV25() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR1.Reg) & 0x2000000) >> 25
}
func (o *EXTI_Type) SetPRIVCFGR1_PRIV26(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR1.Reg, volatile.LoadUint32(&o.PRIVCFGR1.Reg)&^(0x4000000)|value<<26)
}
func (o *EXTI_Type) GetPRIVCFGR1_PRIV26() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR1.Reg) & 0x4000000) >> 26
}
func (o *EXTI_Type) SetPRIVCFGR1_PRIV27(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR1.Reg, volatile.LoadUint32(&o.PRIVCFGR1.Reg)&^(0x8000000)|value<<27)
}
func (o *EXTI_Type) GetPRIVCFGR1_PRIV27() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR1.Reg) & 0x8000000) >> 27
}
func (o *EXTI_Type) SetPRIVCFGR1_PRIV28(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR1.Reg, volatile.LoadUint32(&o.PRIVCFGR1.Reg)&^(0x10000000)|value<<28)
}
func (o *EXTI_Type) GetPRIVCFGR1_PRIV28() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR1.Reg) & 0x10000000) >> 28
}
func (o *EXTI_Type) SetPRIVCFGR1_PRIV29(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR1.Reg, volatile.LoadUint32(&o.PRIVCFGR1.Reg)&^(0x20000000)|value<<29)
}
func (o *EXTI_Type) GetPRIVCFGR1_PRIV29() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR1.Reg) & 0x20000000) >> 29
}
func (o *EXTI_Type) SetPRIVCFGR1_PRIV30(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR1.Reg, volatile.LoadUint32(&o.PRIVCFGR1.Reg)&^(0x40000000)|value<<30)
}
func (o *EXTI_Type) GetPRIVCFGR1_PRIV30() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR1.Reg) & 0x40000000) >> 30
}
func (o *EXTI_Type) SetPRIVCFGR1_PRIV31(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR1.Reg, volatile.LoadUint32(&o.PRIVCFGR1.Reg)&^(0x80000000)|value<<31)
}
func (o *EXTI_Type) GetPRIVCFGR1_PRIV31() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR1.Reg) & 0x80000000) >> 31
}

// EXTI.RTSR2: EXTI rising trigger selection register
func (o *EXTI_Type) SetRTSR2_RT35(value uint32) {
	volatile.StoreUint32(&o.RTSR2.Reg, volatile.LoadUint32(&o.RTSR2.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetRTSR2_RT35() uint32 {
	return (volatile.LoadUint32(&o.RTSR2.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetRTSR2_RT36(value uint32) {
	volatile.StoreUint32(&o.RTSR2.Reg, volatile.LoadUint32(&o.RTSR2.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetRTSR2_RT36() uint32 {
	return (volatile.LoadUint32(&o.RTSR2.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetRTSR2_RT37(value uint32) {
	volatile.StoreUint32(&o.RTSR2.Reg, volatile.LoadUint32(&o.RTSR2.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetRTSR2_RT37() uint32 {
	return (volatile.LoadUint32(&o.RTSR2.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetRTSR2_RT38(value uint32) {
	volatile.StoreUint32(&o.RTSR2.Reg, volatile.LoadUint32(&o.RTSR2.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetRTSR2_RT38() uint32 {
	return (volatile.LoadUint32(&o.RTSR2.Reg) & 0x40) >> 6
}

// EXTI.FTSR2: EXTI falling trigger selection register
func (o *EXTI_Type) SetFTSR2_FT35(value uint32) {
	volatile.StoreUint32(&o.FTSR2.Reg, volatile.LoadUint32(&o.FTSR2.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetFTSR2_FT35() uint32 {
	return (volatile.LoadUint32(&o.FTSR2.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetFTSR2_FT36(value uint32) {
	volatile.StoreUint32(&o.FTSR2.Reg, volatile.LoadUint32(&o.FTSR2.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetFTSR2_FT36() uint32 {
	return (volatile.LoadUint32(&o.FTSR2.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetFTSR2_FT37(value uint32) {
	volatile.StoreUint32(&o.FTSR2.Reg, volatile.LoadUint32(&o.FTSR2.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetFTSR2_FT37() uint32 {
	return (volatile.LoadUint32(&o.FTSR2.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetFTSR2_FT38(value uint32) {
	volatile.StoreUint32(&o.FTSR2.Reg, volatile.LoadUint32(&o.FTSR2.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetFTSR2_FT38() uint32 {
	return (volatile.LoadUint32(&o.FTSR2.Reg) & 0x40) >> 6
}

// EXTI.SWIER2: EXTI software interrupt event register
func (o *EXTI_Type) SetSWIER2_SWI35(value uint32) {
	volatile.StoreUint32(&o.SWIER2.Reg, volatile.LoadUint32(&o.SWIER2.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetSWIER2_SWI35() uint32 {
	return (volatile.LoadUint32(&o.SWIER2.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetSWIER2_SWI36(value uint32) {
	volatile.StoreUint32(&o.SWIER2.Reg, volatile.LoadUint32(&o.SWIER2.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetSWIER2_SWI36() uint32 {
	return (volatile.LoadUint32(&o.SWIER2.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetSWIER2_SWI37(value uint32) {
	volatile.StoreUint32(&o.SWIER2.Reg, volatile.LoadUint32(&o.SWIER2.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetSWIER2_SWI37() uint32 {
	return (volatile.LoadUint32(&o.SWIER2.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetSWIER2_SWI38(value uint32) {
	volatile.StoreUint32(&o.SWIER2.Reg, volatile.LoadUint32(&o.SWIER2.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetSWIER2_SWI38() uint32 {
	return (volatile.LoadUint32(&o.SWIER2.Reg) & 0x40) >> 6
}

// EXTI.RPR2: EXTI rising edge pending register
func (o *EXTI_Type) SetRPR2_RPIF35(value uint32) {
	volatile.StoreUint32(&o.RPR2.Reg, volatile.LoadUint32(&o.RPR2.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetRPR2_RPIF35() uint32 {
	return (volatile.LoadUint32(&o.RPR2.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetRPR2_RPIF36(value uint32) {
	volatile.StoreUint32(&o.RPR2.Reg, volatile.LoadUint32(&o.RPR2.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetRPR2_RPIF36() uint32 {
	return (volatile.LoadUint32(&o.RPR2.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetRPR2_RPIF37(value uint32) {
	volatile.StoreUint32(&o.RPR2.Reg, volatile.LoadUint32(&o.RPR2.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetRPR2_RPIF37() uint32 {
	return (volatile.LoadUint32(&o.RPR2.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetRPR2_RPIF38(value uint32) {
	volatile.StoreUint32(&o.RPR2.Reg, volatile.LoadUint32(&o.RPR2.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetRPR2_RPIF38() uint32 {
	return (volatile.LoadUint32(&o.RPR2.Reg) & 0x40) >> 6
}

// EXTI.FPR2: EXTI falling edge pending register
func (o *EXTI_Type) SetFPR2_FPIF35(value uint32) {
	volatile.StoreUint32(&o.FPR2.Reg, volatile.LoadUint32(&o.FPR2.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetFPR2_FPIF35() uint32 {
	return (volatile.LoadUint32(&o.FPR2.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetFPR2_FPIF36(value uint32) {
	volatile.StoreUint32(&o.FPR2.Reg, volatile.LoadUint32(&o.FPR2.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetFPR2_FPIF36() uint32 {
	return (volatile.LoadUint32(&o.FPR2.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetFPR2_FPIF37(value uint32) {
	volatile.StoreUint32(&o.FPR2.Reg, volatile.LoadUint32(&o.FPR2.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetFPR2_FPIF37() uint32 {
	return (volatile.LoadUint32(&o.FPR2.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetFPR2_FPIF38(value uint32) {
	volatile.StoreUint32(&o.FPR2.Reg, volatile.LoadUint32(&o.FPR2.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetFPR2_FPIF38() uint32 {
	return (volatile.LoadUint32(&o.FPR2.Reg) & 0x40) >> 6
}

// EXTI.PRIVCFGR2: EXTI security enable register
func (o *EXTI_Type) SetPRIVCFGR2_PRIV32(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR2.Reg, volatile.LoadUint32(&o.PRIVCFGR2.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetPRIVCFGR2_PRIV32() uint32 {
	return volatile.LoadUint32(&o.PRIVCFGR2.Reg) & 0x1
}
func (o *EXTI_Type) SetPRIVCFGR2_PRIV33(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR2.Reg, volatile.LoadUint32(&o.PRIVCFGR2.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetPRIVCFGR2_PRIV33() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR2.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetPRIVCFGR2_PRIV34(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR2.Reg, volatile.LoadUint32(&o.PRIVCFGR2.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetPRIVCFGR2_PRIV34() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR2.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetPRIVCFGR2_PRIV35(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR2.Reg, volatile.LoadUint32(&o.PRIVCFGR2.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetPRIVCFGR2_PRIV35() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR2.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetPRIVCFGR2_PRIV36(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR2.Reg, volatile.LoadUint32(&o.PRIVCFGR2.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetPRIVCFGR2_PRIV36() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR2.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetPRIVCFGR2_PRIV37(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR2.Reg, volatile.LoadUint32(&o.PRIVCFGR2.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetPRIVCFGR2_PRIV37() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR2.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetPRIVCFGR2_PRIV38(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR2.Reg, volatile.LoadUint32(&o.PRIVCFGR2.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetPRIVCFGR2_PRIV38() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR2.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetPRIVCFGR2_PRIV39(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR2.Reg, volatile.LoadUint32(&o.PRIVCFGR2.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetPRIVCFGR2_PRIV39() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR2.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetPRIVCFGR2_PRIV40(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR2.Reg, volatile.LoadUint32(&o.PRIVCFGR2.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetPRIVCFGR2_PRIV40() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR2.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetPRIVCFGR2_PRIV41(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR2.Reg, volatile.LoadUint32(&o.PRIVCFGR2.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetPRIVCFGR2_PRIV41() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR2.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetPRIVCFGR2_PRIV42(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR2.Reg, volatile.LoadUint32(&o.PRIVCFGR2.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetPRIVCFGR2_PRIV42() uint32 {
	return (volatile.LoadUint32(&o.PRIVCFGR2.Reg) & 0x400) >> 10
}

// EXTI.SECCFGR2: EXTI security enable register
func (o *EXTI_Type) SetSECCFGR2_SEC32(value uint32) {
	volatile.StoreUint32(&o.SECCFGR2.Reg, volatile.LoadUint32(&o.SECCFGR2.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetSECCFGR2_SEC32() uint32 {
	return volatile.LoadUint32(&o.SECCFGR2.Reg) & 0x1
}
func (o *EXTI_Type) SetSECCFGR2_SEC33(value uint32) {
	volatile.StoreUint32(&o.SECCFGR2.Reg, volatile.LoadUint32(&o.SECCFGR2.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetSECCFGR2_SEC33() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR2.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetSECCFGR2_SEC34(value uint32) {
	volatile.StoreUint32(&o.SECCFGR2.Reg, volatile.LoadUint32(&o.SECCFGR2.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetSECCFGR2_SEC34() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR2.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetSECCFGR2_SEC35(value uint32) {
	volatile.StoreUint32(&o.SECCFGR2.Reg, volatile.LoadUint32(&o.SECCFGR2.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetSECCFGR2_SEC35() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR2.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetSECCFGR2_SEC36(value uint32) {
	volatile.StoreUint32(&o.SECCFGR2.Reg, volatile.LoadUint32(&o.SECCFGR2.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetSECCFGR2_SEC36() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR2.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetSECCFGR2_SEC37(value uint32) {
	volatile.StoreUint32(&o.SECCFGR2.Reg, volatile.LoadUint32(&o.SECCFGR2.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetSECCFGR2_SEC37() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR2.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetSECCFGR2_SEC38(value uint32) {
	volatile.StoreUint32(&o.SECCFGR2.Reg, volatile.LoadUint32(&o.SECCFGR2.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetSECCFGR2_SEC38() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR2.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetSECCFGR2_SEC39(value uint32) {
	volatile.StoreUint32(&o.SECCFGR2.Reg, volatile.LoadUint32(&o.SECCFGR2.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetSECCFGR2_SEC39() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR2.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetSECCFGR2_SEC40(value uint32) {
	volatile.StoreUint32(&o.SECCFGR2.Reg, volatile.LoadUint32(&o.SECCFGR2.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetSECCFGR2_SEC40() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR2.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetSECCFGR2_SEC41(value uint32) {
	volatile.StoreUint32(&o.SECCFGR2.Reg, volatile.LoadUint32(&o.SECCFGR2.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetSECCFGR2_SEC41() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR2.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetSECCFGR2_SEC42(value uint32) {
	volatile.StoreUint32(&o.SECCFGR2.Reg, volatile.LoadUint32(&o.SECCFGR2.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetSECCFGR2_SEC42() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR2.Reg) & 0x400) >> 10
}

// EXTI.EXTICR1: EXTI external interrupt selection register
func (o *EXTI_Type) SetEXTICR1_EXTI0_7(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xff)|value)
}
func (o *EXTI_Type) GetEXTICR1_EXTI0_7() uint32 {
	return volatile.LoadUint32(&o.EXTICR1.Reg) & 0xff
}
func (o *EXTI_Type) SetEXTICR1_EXTI8_15(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xff00)|value<<8)
}
func (o *EXTI_Type) GetEXTICR1_EXTI8_15() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0xff00) >> 8
}
func (o *EXTI_Type) SetEXTICR1_EXTI16_23(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xff0000)|value<<16)
}
func (o *EXTI_Type) GetEXTICR1_EXTI16_23() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0xff0000) >> 16
}
func (o *EXTI_Type) SetEXTICR1_EXTI24_31(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xff000000)|value<<24)
}
func (o *EXTI_Type) GetEXTICR1_EXTI24_31() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0xff000000) >> 24
}

// EXTI.EXTICR2: EXTI external interrupt selection register
func (o *EXTI_Type) SetEXTICR2_EXTI0_7(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xff)|value)
}
func (o *EXTI_Type) GetEXTICR2_EXTI0_7() uint32 {
	return volatile.LoadUint32(&o.EXTICR2.Reg) & 0xff
}
func (o *EXTI_Type) SetEXTICR2_EXTI8_15(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xff00)|value<<8)
}
func (o *EXTI_Type) GetEXTICR2_EXTI8_15() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0xff00) >> 8
}
func (o *EXTI_Type) SetEXTICR2_EXTI16_23(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xff0000)|value<<16)
}
func (o *EXTI_Type) GetEXTICR2_EXTI16_23() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0xff0000) >> 16
}
func (o *EXTI_Type) SetEXTICR2_EXTI24_31(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xff000000)|value<<24)
}
func (o *EXTI_Type) GetEXTICR2_EXTI24_31() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0xff000000) >> 24
}

// EXTI.EXTICR3: EXTI external interrupt selection register
func (o *EXTI_Type) SetEXTICR3_EXTI0_7(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xff)|value)
}
func (o *EXTI_Type) GetEXTICR3_EXTI0_7() uint32 {
	return volatile.LoadUint32(&o.EXTICR3.Reg) & 0xff
}
func (o *EXTI_Type) SetEXTICR3_EXTI8_15(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xff00)|value<<8)
}
func (o *EXTI_Type) GetEXTICR3_EXTI8_15() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0xff00) >> 8
}
func (o *EXTI_Type) SetEXTICR3_EXTI16_23(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xff0000)|value<<16)
}
func (o *EXTI_Type) GetEXTICR3_EXTI16_23() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0xff0000) >> 16
}
func (o *EXTI_Type) SetEXTICR3_EXTI24_31(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xff000000)|value<<24)
}
func (o *EXTI_Type) GetEXTICR3_EXTI24_31() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0xff000000) >> 24
}

// EXTI.EXTICR4: EXTI external interrupt selection register
func (o *EXTI_Type) SetEXTICR4_EXTI0_7(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xff)|value)
}
func (o *EXTI_Type) GetEXTICR4_EXTI0_7() uint32 {
	return volatile.LoadUint32(&o.EXTICR4.Reg) & 0xff
}
func (o *EXTI_Type) SetEXTICR4_EXTI8_15(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xff00)|value<<8)
}
func (o *EXTI_Type) GetEXTICR4_EXTI8_15() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0xff00) >> 8
}
func (o *EXTI_Type) SetEXTICR4_EXTI16_23(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xff0000)|value<<16)
}
func (o *EXTI_Type) GetEXTICR4_EXTI16_23() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0xff0000) >> 16
}
func (o *EXTI_Type) SetEXTICR4_EXTI24_31(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xff000000)|value<<24)
}
func (o *EXTI_Type) GetEXTICR4_EXTI24_31() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0xff000000) >> 24
}

// EXTI.LOCKRG: EXTI lock register
func (o *EXTI_Type) SetLOCKRG_LOCK(value uint32) {
	volatile.StoreUint32(&o.LOCKRG.Reg, volatile.LoadUint32(&o.LOCKRG.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetLOCKRG_LOCK() uint32 {
	return volatile.LoadUint32(&o.LOCKRG.Reg) & 0x1
}

// EXTI.IMR1: EXTI CPU wakeup with interrupt mask register
func (o *EXTI_Type) SetIMR1_IM0(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetIMR1_IM0() uint32 {
	return volatile.LoadUint32(&o.IMR1.Reg) & 0x1
}
func (o *EXTI_Type) SetIMR1_IM1(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetIMR1_IM1() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetIMR1_IM2(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetIMR1_IM2() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetIMR1_IM3(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetIMR1_IM3() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetIMR1_IM4(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetIMR1_IM4() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetIMR1_IM5(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetIMR1_IM5() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetIMR1_IM6(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetIMR1_IM6() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetIMR1_IM7(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetIMR1_IM7() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetIMR1_IM8(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetIMR1_IM8() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetIMR1_IM9(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetIMR1_IM9() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetIMR1_IM10(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetIMR1_IM10() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetIMR1_IM11(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetIMR1_IM11() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetIMR1_IM12(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetIMR1_IM12() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetIMR1_IM13(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetIMR1_IM13() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetIMR1_IM14(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetIMR1_IM14() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetIMR1_IM15(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetIMR1_IM15() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetIMR1_IM16(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetIMR1_IM16() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetIMR1_IM17(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetIMR1_IM17() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetIMR1_IM18(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetIMR1_IM18() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetIMR1_IM19(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetIMR1_IM19() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetIMR1_IM20(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetIMR1_IM20() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetIMR1_IM21(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetIMR1_IM21() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetIMR1_IM22(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetIMR1_IM22() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetIMR1_IM23(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x800000)|value<<23)
}
func (o *EXTI_Type) GetIMR1_IM23() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x800000) >> 23
}
func (o *EXTI_Type) SetIMR1_IM24(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x1000000)|value<<24)
}
func (o *EXTI_Type) GetIMR1_IM24() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x1000000) >> 24
}
func (o *EXTI_Type) SetIMR1_IM25(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x2000000)|value<<25)
}
func (o *EXTI_Type) GetIMR1_IM25() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x2000000) >> 25
}
func (o *EXTI_Type) SetIMR1_IM26(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4000000)|value<<26)
}
func (o *EXTI_Type) GetIMR1_IM26() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4000000) >> 26
}
func (o *EXTI_Type) SetIMR1_IM27(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x8000000)|value<<27)
}
func (o *EXTI_Type) GetIMR1_IM27() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x8000000) >> 27
}
func (o *EXTI_Type) SetIMR1_IM28(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x10000000)|value<<28)
}
func (o *EXTI_Type) GetIMR1_IM28() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x10000000) >> 28
}
func (o *EXTI_Type) SetIMR1_IM29(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x20000000)|value<<29)
}
func (o *EXTI_Type) GetIMR1_IM29() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x20000000) >> 29
}
func (o *EXTI_Type) SetIMR1_IM30(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x40000000)|value<<30)
}
func (o *EXTI_Type) GetIMR1_IM30() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x40000000) >> 30
}
func (o *EXTI_Type) SetIMR1_IM31(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x80000000)|value<<31)
}
func (o *EXTI_Type) GetIMR1_IM31() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x80000000) >> 31
}

// EXTI.EMR1: EXTI CPU wakeup with event mask register
func (o *EXTI_Type) SetEMR1_EM0(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetEMR1_EM0() uint32 {
	return volatile.LoadUint32(&o.EMR1.Reg) & 0x1
}
func (o *EXTI_Type) SetEMR1_EM1(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetEMR1_EM1() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetEMR1_EM2(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetEMR1_EM2() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetEMR1_EM3(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetEMR1_EM3() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetEMR1_EM4(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetEMR1_EM4() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetEMR1_EM5(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetEMR1_EM5() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetEMR1_EM6(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetEMR1_EM6() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetEMR1_EM7(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetEMR1_EM7() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetEMR1_EM8(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetEMR1_EM8() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetEMR1_EM9(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetEMR1_EM9() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetEMR1_EM10(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetEMR1_EM10() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetEMR1_EM11(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetEMR1_EM11() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetEMR1_EM12(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetEMR1_EM12() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetEMR1_EM13(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetEMR1_EM13() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetEMR1_EM14(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetEMR1_EM14() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetEMR1_EM15(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetEMR1_EM15() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetEMR1_EM16(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetEMR1_EM16() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetEMR1_EM17(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetEMR1_EM17() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetEMR1_EM18(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetEMR1_EM18() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetEMR1_EM19(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetEMR1_EM19() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetEMR1_EM20(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetEMR1_EM20() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetEMR1_EM21(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetEMR1_EM21() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetEMR1_EM22(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetEMR1_EM22() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetEMR1_EM23(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x800000)|value<<23)
}
func (o *EXTI_Type) GetEMR1_EM23() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x800000) >> 23
}
func (o *EXTI_Type) SetEMR1_EM24(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x1000000)|value<<24)
}
func (o *EXTI_Type) GetEMR1_EM24() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x1000000) >> 24
}
func (o *EXTI_Type) SetEMR1_EM25(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x2000000)|value<<25)
}
func (o *EXTI_Type) GetEMR1_EM25() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x2000000) >> 25
}
func (o *EXTI_Type) SetEMR1_EM26(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x4000000)|value<<26)
}
func (o *EXTI_Type) GetEMR1_EM26() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x4000000) >> 26
}
func (o *EXTI_Type) SetEMR1_EM27(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x8000000)|value<<27)
}
func (o *EXTI_Type) GetEMR1_EM27() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x8000000) >> 27
}
func (o *EXTI_Type) SetEMR1_EM28(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x10000000)|value<<28)
}
func (o *EXTI_Type) GetEMR1_EM28() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x10000000) >> 28
}
func (o *EXTI_Type) SetEMR1_EM29(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x20000000)|value<<29)
}
func (o *EXTI_Type) GetEMR1_EM29() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x20000000) >> 29
}
func (o *EXTI_Type) SetEMR1_EM30(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x40000000)|value<<30)
}
func (o *EXTI_Type) GetEMR1_EM30() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x40000000) >> 30
}
func (o *EXTI_Type) SetEMR1_EM31(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x80000000)|value<<31)
}
func (o *EXTI_Type) GetEMR1_EM31() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x80000000) >> 31
}

// EXTI.IMR2: EXTI CPUm wakeup with interrupt mask register
func (o *EXTI_Type) SetIMR2_IM32(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetIMR2_IM32() uint32 {
	return volatile.LoadUint32(&o.IMR2.Reg) & 0x1
}
func (o *EXTI_Type) SetIMR2_IM33(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetIMR2_IM33() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetIMR2_IM34(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetIMR2_IM34() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetIMR2_IM35(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetIMR2_IM35() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetIMR2_IM36(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetIMR2_IM36() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetIMR2_IM37(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetIMR2_IM37() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetIMR2_IM38(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetIMR2_IM38() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetIMR2_IM40(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetIMR2_IM40() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetIMR2_IM41(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetIMR2_IM41() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetIMR2_IM42(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetIMR2_IM42() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x400) >> 10
}

// EXTI.EMR2: EXTI CPU wakeup with event mask register
func (o *EXTI_Type) SetEMR2_EM32(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetEMR2_EM32() uint32 {
	return volatile.LoadUint32(&o.EMR2.Reg) & 0x1
}
func (o *EXTI_Type) SetEMR2_EM33(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetEMR2_EM33() uint32 {
	return (volatile.LoadUint32(&o.EMR2.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetEMR2_EM34(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetEMR2_EM34() uint32 {
	return (volatile.LoadUint32(&o.EMR2.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetEMR2_EM35(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetEMR2_EM35() uint32 {
	return (volatile.LoadUint32(&o.EMR2.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetEMR2_EM36(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetEMR2_EM36() uint32 {
	return (volatile.LoadUint32(&o.EMR2.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetEMR2_EM37(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetEMR2_EM37() uint32 {
	return (volatile.LoadUint32(&o.EMR2.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetEMR2_EM38(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetEMR2_EM38() uint32 {
	return (volatile.LoadUint32(&o.EMR2.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetEMR2_EM40(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetEMR2_EM40() uint32 {
	return (volatile.LoadUint32(&o.EMR2.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetEMR2_EM41(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetEMR2_EM41() uint32 {
	return (volatile.LoadUint32(&o.EMR2.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetEMR2_EM42(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetEMR2_EM42() uint32 {
	return (volatile.LoadUint32(&o.EMR2.Reg) & 0x400) >> 10
}

// Flash
type Flash_Type struct {
	ACR          volatile.Register32 // 0x0
	PDKEYR       volatile.Register32 // 0x4
	NSKEYR       volatile.Register32 // 0x8
	SECKEYR      volatile.Register32 // 0xC
	OPTKEYR      volatile.Register32 // 0x10
	LVEKEYR      volatile.Register32 // 0x14
	_            [8]byte
	NSSR         volatile.Register32 // 0x20
	SECSR        volatile.Register32 // 0x24
	NSCR         volatile.Register32 // 0x28
	SECCR        volatile.Register32 // 0x2C
	ECCR         volatile.Register32 // 0x30
	_            [12]byte
	OPTR         volatile.Register32 // 0x40
	NSBOOTADD0R  volatile.Register32 // 0x44
	NSBOOTADD1R  volatile.Register32 // 0x48
	SECBOOTADD0R volatile.Register32 // 0x4C
	SECWM1R1     volatile.Register32 // 0x50
	SECWM1R2     volatile.Register32 // 0x54
	WRP1AR       volatile.Register32 // 0x58
	WRP1BR       volatile.Register32 // 0x5C
	SECWM2R1     volatile.Register32 // 0x60
	SECWM2R2     volatile.Register32 // 0x64
	WRP2AR       volatile.Register32 // 0x68
	WRP2BR       volatile.Register32 // 0x6C
	_            [16]byte
	SECBB1R1     volatile.Register32 // 0x80
	SECBB1R2     volatile.Register32 // 0x84
	SECBB1R3     volatile.Register32 // 0x88
	SECBB1R4     volatile.Register32 // 0x8C
	_            [16]byte
	SECBB2R1     volatile.Register32 // 0xA0
	SECBB2R2     volatile.Register32 // 0xA4
	SECBB2R3     volatile.Register32 // 0xA8
	SECBB2R4     volatile.Register32 // 0xAC
	_            [16]byte
	SECHDPCR     volatile.Register32 // 0xC0
	PRIVCFGR     volatile.Register32 // 0xC4
}

// Flash.ACR: Access control register
func (o *Flash_Type) SetACR_LATENCY(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0xf)|value)
}
func (o *Flash_Type) GetACR_LATENCY() uint32 {
	return volatile.LoadUint32(&o.ACR.Reg) & 0xf
}
func (o *Flash_Type) SetACR_RUN_PD(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x2000)|value<<13)
}
func (o *Flash_Type) GetACR_RUN_PD() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x2000) >> 13
}
func (o *Flash_Type) SetACR_SLEEP_PD(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x4000)|value<<14)
}
func (o *Flash_Type) GetACR_SLEEP_PD() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x4000) >> 14
}
func (o *Flash_Type) SetACR_LVEN(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x8000)|value<<15)
}
func (o *Flash_Type) GetACR_LVEN() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x8000) >> 15
}

// Flash.PDKEYR: Power down key register
func (o *Flash_Type) SetPDKEYR(value uint32) {
	volatile.StoreUint32(&o.PDKEYR.Reg, value)
}
func (o *Flash_Type) GetPDKEYR() uint32 {
	return volatile.LoadUint32(&o.PDKEYR.Reg)
}

// Flash.NSKEYR: Flash non-secure key register
func (o *Flash_Type) SetNSKEYR(value uint32) {
	volatile.StoreUint32(&o.NSKEYR.Reg, value)
}
func (o *Flash_Type) GetNSKEYR() uint32 {
	return volatile.LoadUint32(&o.NSKEYR.Reg)
}

// Flash.SECKEYR: Flash secure key register
func (o *Flash_Type) SetSECKEYR(value uint32) {
	volatile.StoreUint32(&o.SECKEYR.Reg, value)
}
func (o *Flash_Type) GetSECKEYR() uint32 {
	return volatile.LoadUint32(&o.SECKEYR.Reg)
}

// Flash.OPTKEYR: Flash option key register
func (o *Flash_Type) SetOPTKEYR(value uint32) {
	volatile.StoreUint32(&o.OPTKEYR.Reg, value)
}
func (o *Flash_Type) GetOPTKEYR() uint32 {
	return volatile.LoadUint32(&o.OPTKEYR.Reg)
}

// Flash.LVEKEYR: Flash low voltage key register
func (o *Flash_Type) SetLVEKEYR(value uint32) {
	volatile.StoreUint32(&o.LVEKEYR.Reg, value)
}
func (o *Flash_Type) GetLVEKEYR() uint32 {
	return volatile.LoadUint32(&o.LVEKEYR.Reg)
}

// Flash.NSSR: Flash status register
func (o *Flash_Type) SetNSSR_NSEOP(value uint32) {
	volatile.StoreUint32(&o.NSSR.Reg, volatile.LoadUint32(&o.NSSR.Reg)&^(0x1)|value)
}
func (o *Flash_Type) GetNSSR_NSEOP() uint32 {
	return volatile.LoadUint32(&o.NSSR.Reg) & 0x1
}
func (o *Flash_Type) SetNSSR_NSOPERR(value uint32) {
	volatile.StoreUint32(&o.NSSR.Reg, volatile.LoadUint32(&o.NSSR.Reg)&^(0x2)|value<<1)
}
func (o *Flash_Type) GetNSSR_NSOPERR() uint32 {
	return (volatile.LoadUint32(&o.NSSR.Reg) & 0x2) >> 1
}
func (o *Flash_Type) SetNSSR_NSPROGERR(value uint32) {
	volatile.StoreUint32(&o.NSSR.Reg, volatile.LoadUint32(&o.NSSR.Reg)&^(0x8)|value<<3)
}
func (o *Flash_Type) GetNSSR_NSPROGERR() uint32 {
	return (volatile.LoadUint32(&o.NSSR.Reg) & 0x8) >> 3
}
func (o *Flash_Type) SetNSSR_NSWRPERR(value uint32) {
	volatile.StoreUint32(&o.NSSR.Reg, volatile.LoadUint32(&o.NSSR.Reg)&^(0x10)|value<<4)
}
func (o *Flash_Type) GetNSSR_NSWRPERR() uint32 {
	return (volatile.LoadUint32(&o.NSSR.Reg) & 0x10) >> 4
}
func (o *Flash_Type) SetNSSR_NSPGAERR(value uint32) {
	volatile.StoreUint32(&o.NSSR.Reg, volatile.LoadUint32(&o.NSSR.Reg)&^(0x20)|value<<5)
}
func (o *Flash_Type) GetNSSR_NSPGAERR() uint32 {
	return (volatile.LoadUint32(&o.NSSR.Reg) & 0x20) >> 5
}
func (o *Flash_Type) SetNSSR_NSSIZERR(value uint32) {
	volatile.StoreUint32(&o.NSSR.Reg, volatile.LoadUint32(&o.NSSR.Reg)&^(0x40)|value<<6)
}
func (o *Flash_Type) GetNSSR_NSSIZERR() uint32 {
	return (volatile.LoadUint32(&o.NSSR.Reg) & 0x40) >> 6
}
func (o *Flash_Type) SetNSSR_NSPGSERR(value uint32) {
	volatile.StoreUint32(&o.NSSR.Reg, volatile.LoadUint32(&o.NSSR.Reg)&^(0x80)|value<<7)
}
func (o *Flash_Type) GetNSSR_NSPGSERR() uint32 {
	return (volatile.LoadUint32(&o.NSSR.Reg) & 0x80) >> 7
}
func (o *Flash_Type) SetNSSR_OPTWERR(value uint32) {
	volatile.StoreUint32(&o.NSSR.Reg, volatile.LoadUint32(&o.NSSR.Reg)&^(0x2000)|value<<13)
}
func (o *Flash_Type) GetNSSR_OPTWERR() uint32 {
	return (volatile.LoadUint32(&o.NSSR.Reg) & 0x2000) >> 13
}
func (o *Flash_Type) SetNSSR_OPTVERR(value uint32) {
	volatile.StoreUint32(&o.NSSR.Reg, volatile.LoadUint32(&o.NSSR.Reg)&^(0x8000)|value<<15)
}
func (o *Flash_Type) GetNSSR_OPTVERR() uint32 {
	return (volatile.LoadUint32(&o.NSSR.Reg) & 0x8000) >> 15
}
func (o *Flash_Type) SetNSSR_NSBSY(value uint32) {
	volatile.StoreUint32(&o.NSSR.Reg, volatile.LoadUint32(&o.NSSR.Reg)&^(0x10000)|value<<16)
}
func (o *Flash_Type) GetNSSR_NSBSY() uint32 {
	return (volatile.LoadUint32(&o.NSSR.Reg) & 0x10000) >> 16
}

// Flash.SECSR: Flash status register
func (o *Flash_Type) SetSECSR_SECEOP(value uint32) {
	volatile.StoreUint32(&o.SECSR.Reg, volatile.LoadUint32(&o.SECSR.Reg)&^(0x1)|value)
}
func (o *Flash_Type) GetSECSR_SECEOP() uint32 {
	return volatile.LoadUint32(&o.SECSR.Reg) & 0x1
}
func (o *Flash_Type) SetSECSR_SECOPERR(value uint32) {
	volatile.StoreUint32(&o.SECSR.Reg, volatile.LoadUint32(&o.SECSR.Reg)&^(0x2)|value<<1)
}
func (o *Flash_Type) GetSECSR_SECOPERR() uint32 {
	return (volatile.LoadUint32(&o.SECSR.Reg) & 0x2) >> 1
}
func (o *Flash_Type) SetSECSR_SECPROGERR(value uint32) {
	volatile.StoreUint32(&o.SECSR.Reg, volatile.LoadUint32(&o.SECSR.Reg)&^(0x8)|value<<3)
}
func (o *Flash_Type) GetSECSR_SECPROGERR() uint32 {
	return (volatile.LoadUint32(&o.SECSR.Reg) & 0x8) >> 3
}
func (o *Flash_Type) SetSECSR_SECWRPERR(value uint32) {
	volatile.StoreUint32(&o.SECSR.Reg, volatile.LoadUint32(&o.SECSR.Reg)&^(0x10)|value<<4)
}
func (o *Flash_Type) GetSECSR_SECWRPERR() uint32 {
	return (volatile.LoadUint32(&o.SECSR.Reg) & 0x10) >> 4
}
func (o *Flash_Type) SetSECSR_SECPGAERR(value uint32) {
	volatile.StoreUint32(&o.SECSR.Reg, volatile.LoadUint32(&o.SECSR.Reg)&^(0x20)|value<<5)
}
func (o *Flash_Type) GetSECSR_SECPGAERR() uint32 {
	return (volatile.LoadUint32(&o.SECSR.Reg) & 0x20) >> 5
}
func (o *Flash_Type) SetSECSR_SECSIZERR(value uint32) {
	volatile.StoreUint32(&o.SECSR.Reg, volatile.LoadUint32(&o.SECSR.Reg)&^(0x40)|value<<6)
}
func (o *Flash_Type) GetSECSR_SECSIZERR() uint32 {
	return (volatile.LoadUint32(&o.SECSR.Reg) & 0x40) >> 6
}
func (o *Flash_Type) SetSECSR_SECPGSERR(value uint32) {
	volatile.StoreUint32(&o.SECSR.Reg, volatile.LoadUint32(&o.SECSR.Reg)&^(0x80)|value<<7)
}
func (o *Flash_Type) GetSECSR_SECPGSERR() uint32 {
	return (volatile.LoadUint32(&o.SECSR.Reg) & 0x80) >> 7
}
func (o *Flash_Type) SetSECSR_SECRDERR(value uint32) {
	volatile.StoreUint32(&o.SECSR.Reg, volatile.LoadUint32(&o.SECSR.Reg)&^(0x4000)|value<<14)
}
func (o *Flash_Type) GetSECSR_SECRDERR() uint32 {
	return (volatile.LoadUint32(&o.SECSR.Reg) & 0x4000) >> 14
}
func (o *Flash_Type) SetSECSR_SECBSY(value uint32) {
	volatile.StoreUint32(&o.SECSR.Reg, volatile.LoadUint32(&o.SECSR.Reg)&^(0x10000)|value<<16)
}
func (o *Flash_Type) GetSECSR_SECBSY() uint32 {
	return (volatile.LoadUint32(&o.SECSR.Reg) & 0x10000) >> 16
}

// Flash.NSCR: Flash non-secure control register
func (o *Flash_Type) SetNSCR_NSPG(value uint32) {
	volatile.StoreUint32(&o.NSCR.Reg, volatile.LoadUint32(&o.NSCR.Reg)&^(0x1)|value)
}
func (o *Flash_Type) GetNSCR_NSPG() uint32 {
	return volatile.LoadUint32(&o.NSCR.Reg) & 0x1
}
func (o *Flash_Type) SetNSCR_NSPER(value uint32) {
	volatile.StoreUint32(&o.NSCR.Reg, volatile.LoadUint32(&o.NSCR.Reg)&^(0x2)|value<<1)
}
func (o *Flash_Type) GetNSCR_NSPER() uint32 {
	return (volatile.LoadUint32(&o.NSCR.Reg) & 0x2) >> 1
}
func (o *Flash_Type) SetNSCR_NSMER1(value uint32) {
	volatile.StoreUint32(&o.NSCR.Reg, volatile.LoadUint32(&o.NSCR.Reg)&^(0x4)|value<<2)
}
func (o *Flash_Type) GetNSCR_NSMER1() uint32 {
	return (volatile.LoadUint32(&o.NSCR.Reg) & 0x4) >> 2
}
func (o *Flash_Type) SetNSCR_NSPNB(value uint32) {
	volatile.StoreUint32(&o.NSCR.Reg, volatile.LoadUint32(&o.NSCR.Reg)&^(0x3f8)|value<<3)
}
func (o *Flash_Type) GetNSCR_NSPNB() uint32 {
	return (volatile.LoadUint32(&o.NSCR.Reg) & 0x3f8) >> 3
}
func (o *Flash_Type) SetNSCR_NSBKER(value uint32) {
	volatile.StoreUint32(&o.NSCR.Reg, volatile.LoadUint32(&o.NSCR.Reg)&^(0x800)|value<<11)
}
func (o *Flash_Type) GetNSCR_NSBKER() uint32 {
	return (volatile.LoadUint32(&o.NSCR.Reg) & 0x800) >> 11
}
func (o *Flash_Type) SetNSCR_NSMER2(value uint32) {
	volatile.StoreUint32(&o.NSCR.Reg, volatile.LoadUint32(&o.NSCR.Reg)&^(0x8000)|value<<15)
}
func (o *Flash_Type) GetNSCR_NSMER2() uint32 {
	return (volatile.LoadUint32(&o.NSCR.Reg) & 0x8000) >> 15
}
func (o *Flash_Type) SetNSCR_NSSTRT(value uint32) {
	volatile.StoreUint32(&o.NSCR.Reg, volatile.LoadUint32(&o.NSCR.Reg)&^(0x10000)|value<<16)
}
func (o *Flash_Type) GetNSCR_NSSTRT() uint32 {
	return (volatile.LoadUint32(&o.NSCR.Reg) & 0x10000) >> 16
}
func (o *Flash_Type) SetNSCR_OPTSTRT(value uint32) {
	volatile.StoreUint32(&o.NSCR.Reg, volatile.LoadUint32(&o.NSCR.Reg)&^(0x20000)|value<<17)
}
func (o *Flash_Type) GetNSCR_OPTSTRT() uint32 {
	return (volatile.LoadUint32(&o.NSCR.Reg) & 0x20000) >> 17
}
func (o *Flash_Type) SetNSCR_NSEOPIE(value uint32) {
	volatile.StoreUint32(&o.NSCR.Reg, volatile.LoadUint32(&o.NSCR.Reg)&^(0x1000000)|value<<24)
}
func (o *Flash_Type) GetNSCR_NSEOPIE() uint32 {
	return (volatile.LoadUint32(&o.NSCR.Reg) & 0x1000000) >> 24
}
func (o *Flash_Type) SetNSCR_NSERRIE(value uint32) {
	volatile.StoreUint32(&o.NSCR.Reg, volatile.LoadUint32(&o.NSCR.Reg)&^(0x2000000)|value<<25)
}
func (o *Flash_Type) GetNSCR_NSERRIE() uint32 {
	return (volatile.LoadUint32(&o.NSCR.Reg) & 0x2000000) >> 25
}
func (o *Flash_Type) SetNSCR_OBL_LAUNCH(value uint32) {
	volatile.StoreUint32(&o.NSCR.Reg, volatile.LoadUint32(&o.NSCR.Reg)&^(0x8000000)|value<<27)
}
func (o *Flash_Type) GetNSCR_OBL_LAUNCH() uint32 {
	return (volatile.LoadUint32(&o.NSCR.Reg) & 0x8000000) >> 27
}
func (o *Flash_Type) SetNSCR_OPTLOCK(value uint32) {
	volatile.StoreUint32(&o.NSCR.Reg, volatile.LoadUint32(&o.NSCR.Reg)&^(0x40000000)|value<<30)
}
func (o *Flash_Type) GetNSCR_OPTLOCK() uint32 {
	return (volatile.LoadUint32(&o.NSCR.Reg) & 0x40000000) >> 30
}
func (o *Flash_Type) SetNSCR_NSLOCK(value uint32) {
	volatile.StoreUint32(&o.NSCR.Reg, volatile.LoadUint32(&o.NSCR.Reg)&^(0x80000000)|value<<31)
}
func (o *Flash_Type) GetNSCR_NSLOCK() uint32 {
	return (volatile.LoadUint32(&o.NSCR.Reg) & 0x80000000) >> 31
}

// Flash.SECCR: Flash secure control register
func (o *Flash_Type) SetSECCR_SECPG(value uint32) {
	volatile.StoreUint32(&o.SECCR.Reg, volatile.LoadUint32(&o.SECCR.Reg)&^(0x1)|value)
}
func (o *Flash_Type) GetSECCR_SECPG() uint32 {
	return volatile.LoadUint32(&o.SECCR.Reg) & 0x1
}
func (o *Flash_Type) SetSECCR_SECPER(value uint32) {
	volatile.StoreUint32(&o.SECCR.Reg, volatile.LoadUint32(&o.SECCR.Reg)&^(0x2)|value<<1)
}
func (o *Flash_Type) GetSECCR_SECPER() uint32 {
	return (volatile.LoadUint32(&o.SECCR.Reg) & 0x2) >> 1
}
func (o *Flash_Type) SetSECCR_SECMER1(value uint32) {
	volatile.StoreUint32(&o.SECCR.Reg, volatile.LoadUint32(&o.SECCR.Reg)&^(0x4)|value<<2)
}
func (o *Flash_Type) GetSECCR_SECMER1() uint32 {
	return (volatile.LoadUint32(&o.SECCR.Reg) & 0x4) >> 2
}
func (o *Flash_Type) SetSECCR_SECPNB(value uint32) {
	volatile.StoreUint32(&o.SECCR.Reg, volatile.LoadUint32(&o.SECCR.Reg)&^(0x3f8)|value<<3)
}
func (o *Flash_Type) GetSECCR_SECPNB() uint32 {
	return (volatile.LoadUint32(&o.SECCR.Reg) & 0x3f8) >> 3
}
func (o *Flash_Type) SetSECCR_SECBKER(value uint32) {
	volatile.StoreUint32(&o.SECCR.Reg, volatile.LoadUint32(&o.SECCR.Reg)&^(0x800)|value<<11)
}
func (o *Flash_Type) GetSECCR_SECBKER() uint32 {
	return (volatile.LoadUint32(&o.SECCR.Reg) & 0x800) >> 11
}
func (o *Flash_Type) SetSECCR_SECMER2(value uint32) {
	volatile.StoreUint32(&o.SECCR.Reg, volatile.LoadUint32(&o.SECCR.Reg)&^(0x8000)|value<<15)
}
func (o *Flash_Type) GetSECCR_SECMER2() uint32 {
	return (volatile.LoadUint32(&o.SECCR.Reg) & 0x8000) >> 15
}
func (o *Flash_Type) SetSECCR_SECSTRT(value uint32) {
	volatile.StoreUint32(&o.SECCR.Reg, volatile.LoadUint32(&o.SECCR.Reg)&^(0x10000)|value<<16)
}
func (o *Flash_Type) GetSECCR_SECSTRT() uint32 {
	return (volatile.LoadUint32(&o.SECCR.Reg) & 0x10000) >> 16
}
func (o *Flash_Type) SetSECCR_SECEOPIE(value uint32) {
	volatile.StoreUint32(&o.SECCR.Reg, volatile.LoadUint32(&o.SECCR.Reg)&^(0x1000000)|value<<24)
}
func (o *Flash_Type) GetSECCR_SECEOPIE() uint32 {
	return (volatile.LoadUint32(&o.SECCR.Reg) & 0x1000000) >> 24
}
func (o *Flash_Type) SetSECCR_SECERRIE(value uint32) {
	volatile.StoreUint32(&o.SECCR.Reg, volatile.LoadUint32(&o.SECCR.Reg)&^(0x2000000)|value<<25)
}
func (o *Flash_Type) GetSECCR_SECERRIE() uint32 {
	return (volatile.LoadUint32(&o.SECCR.Reg) & 0x2000000) >> 25
}
func (o *Flash_Type) SetSECCR_SECRDERRIE(value uint32) {
	volatile.StoreUint32(&o.SECCR.Reg, volatile.LoadUint32(&o.SECCR.Reg)&^(0x4000000)|value<<26)
}
func (o *Flash_Type) GetSECCR_SECRDERRIE() uint32 {
	return (volatile.LoadUint32(&o.SECCR.Reg) & 0x4000000) >> 26
}
func (o *Flash_Type) SetSECCR_SECINV(value uint32) {
	volatile.StoreUint32(&o.SECCR.Reg, volatile.LoadUint32(&o.SECCR.Reg)&^(0x20000000)|value<<29)
}
func (o *Flash_Type) GetSECCR_SECINV() uint32 {
	return (volatile.LoadUint32(&o.SECCR.Reg) & 0x20000000) >> 29
}
func (o *Flash_Type) SetSECCR_SECLOCK(value uint32) {
	volatile.StoreUint32(&o.SECCR.Reg, volatile.LoadUint32(&o.SECCR.Reg)&^(0x80000000)|value<<31)
}
func (o *Flash_Type) GetSECCR_SECLOCK() uint32 {
	return (volatile.LoadUint32(&o.SECCR.Reg) & 0x80000000) >> 31
}

// Flash.ECCR: Flash ECC register
func (o *Flash_Type) SetECCR_ADDR_ECC(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x7ffff)|value)
}
func (o *Flash_Type) GetECCR_ADDR_ECC() uint32 {
	return volatile.LoadUint32(&o.ECCR.Reg) & 0x7ffff
}
func (o *Flash_Type) SetECCR_BK_ECC(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x200000)|value<<21)
}
func (o *Flash_Type) GetECCR_BK_ECC() uint32 {
	return (volatile.LoadUint32(&o.ECCR.Reg) & 0x200000) >> 21
}
func (o *Flash_Type) SetECCR_SYSF_ECC(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x400000)|value<<22)
}
func (o *Flash_Type) GetECCR_SYSF_ECC() uint32 {
	return (volatile.LoadUint32(&o.ECCR.Reg) & 0x400000) >> 22
}
func (o *Flash_Type) SetECCR_ECCIE(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x1000000)|value<<24)
}
func (o *Flash_Type) GetECCR_ECCIE() uint32 {
	return (volatile.LoadUint32(&o.ECCR.Reg) & 0x1000000) >> 24
}
func (o *Flash_Type) SetECCR_ECCC2(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x10000000)|value<<28)
}
func (o *Flash_Type) GetECCR_ECCC2() uint32 {
	return (volatile.LoadUint32(&o.ECCR.Reg) & 0x10000000) >> 28
}
func (o *Flash_Type) SetECCR_ECCD2(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x20000000)|value<<29)
}
func (o *Flash_Type) GetECCR_ECCD2() uint32 {
	return (volatile.LoadUint32(&o.ECCR.Reg) & 0x20000000) >> 29
}
func (o *Flash_Type) SetECCR_ECCC(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x40000000)|value<<30)
}
func (o *Flash_Type) GetECCR_ECCC() uint32 {
	return (volatile.LoadUint32(&o.ECCR.Reg) & 0x40000000) >> 30
}
func (o *Flash_Type) SetECCR_ECCD(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, volatile.LoadUint32(&o.ECCR.Reg)&^(0x80000000)|value<<31)
}
func (o *Flash_Type) GetECCR_ECCD() uint32 {
	return (volatile.LoadUint32(&o.ECCR.Reg) & 0x80000000) >> 31
}

// Flash.OPTR: Flash option register
func (o *Flash_Type) SetOPTR_RDP(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0xff)|value)
}
func (o *Flash_Type) GetOPTR_RDP() uint32 {
	return volatile.LoadUint32(&o.OPTR.Reg) & 0xff
}
func (o *Flash_Type) SetOPTR_BOR_LEV(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x700)|value<<8)
}
func (o *Flash_Type) GetOPTR_BOR_LEV() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x700) >> 8
}
func (o *Flash_Type) SetOPTR_NRST_STOP(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x1000)|value<<12)
}
func (o *Flash_Type) GetOPTR_NRST_STOP() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x1000) >> 12
}
func (o *Flash_Type) SetOPTR_NRST_STDBY(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x2000)|value<<13)
}
func (o *Flash_Type) GetOPTR_NRST_STDBY() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x2000) >> 13
}
func (o *Flash_Type) SetOPTR_NRST_SHDW(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x4000)|value<<14)
}
func (o *Flash_Type) GetOPTR_NRST_SHDW() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x4000) >> 14
}
func (o *Flash_Type) SetOPTR_IWDG_SW(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x10000)|value<<16)
}
func (o *Flash_Type) GetOPTR_IWDG_SW() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x10000) >> 16
}
func (o *Flash_Type) SetOPTR_IWDG_STOP(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x20000)|value<<17)
}
func (o *Flash_Type) GetOPTR_IWDG_STOP() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x20000) >> 17
}
func (o *Flash_Type) SetOPTR_IWDG_STDBY(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x40000)|value<<18)
}
func (o *Flash_Type) GetOPTR_IWDG_STDBY() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x40000) >> 18
}
func (o *Flash_Type) SetOPTR_WWDG_SW(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x80000)|value<<19)
}
func (o *Flash_Type) GetOPTR_WWDG_SW() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x80000) >> 19
}
func (o *Flash_Type) SetOPTR_SWAP_BANK(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x100000)|value<<20)
}
func (o *Flash_Type) GetOPTR_SWAP_BANK() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x100000) >> 20
}
func (o *Flash_Type) SetOPTR_DB256K(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x200000)|value<<21)
}
func (o *Flash_Type) GetOPTR_DB256K() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x200000) >> 21
}
func (o *Flash_Type) SetOPTR_DBANK(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x400000)|value<<22)
}
func (o *Flash_Type) GetOPTR_DBANK() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x400000) >> 22
}
func (o *Flash_Type) SetOPTR_SRAM2_PE(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x1000000)|value<<24)
}
func (o *Flash_Type) GetOPTR_SRAM2_PE() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x1000000) >> 24
}
func (o *Flash_Type) SetOPTR_SRAM2_RST(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x2000000)|value<<25)
}
func (o *Flash_Type) GetOPTR_SRAM2_RST() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x2000000) >> 25
}
func (o *Flash_Type) SetOPTR_NSWBOOT0(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x4000000)|value<<26)
}
func (o *Flash_Type) GetOPTR_NSWBOOT0() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x4000000) >> 26
}
func (o *Flash_Type) SetOPTR_NBOOT0(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x8000000)|value<<27)
}
func (o *Flash_Type) GetOPTR_NBOOT0() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x8000000) >> 27
}
func (o *Flash_Type) SetOPTR_PA15_PUPEN(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x10000000)|value<<28)
}
func (o *Flash_Type) GetOPTR_PA15_PUPEN() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x10000000) >> 28
}
func (o *Flash_Type) SetOPTR_TZEN(value uint32) {
	volatile.StoreUint32(&o.OPTR.Reg, volatile.LoadUint32(&o.OPTR.Reg)&^(0x80000000)|value<<31)
}
func (o *Flash_Type) GetOPTR_TZEN() uint32 {
	return (volatile.LoadUint32(&o.OPTR.Reg) & 0x80000000) >> 31
}

// Flash.NSBOOTADD0R: Flash non-secure boot address 0 register
func (o *Flash_Type) SetNSBOOTADD0R_NSBOOTADD0(value uint32) {
	volatile.StoreUint32(&o.NSBOOTADD0R.Reg, volatile.LoadUint32(&o.NSBOOTADD0R.Reg)&^(0xffffff80)|value<<7)
}
func (o *Flash_Type) GetNSBOOTADD0R_NSBOOTADD0() uint32 {
	return (volatile.LoadUint32(&o.NSBOOTADD0R.Reg) & 0xffffff80) >> 7
}

// Flash.NSBOOTADD1R: Flash non-secure boot address 1 register
func (o *Flash_Type) SetNSBOOTADD1R_NSBOOTADD1(value uint32) {
	volatile.StoreUint32(&o.NSBOOTADD1R.Reg, volatile.LoadUint32(&o.NSBOOTADD1R.Reg)&^(0xffffff80)|value<<7)
}
func (o *Flash_Type) GetNSBOOTADD1R_NSBOOTADD1() uint32 {
	return (volatile.LoadUint32(&o.NSBOOTADD1R.Reg) & 0xffffff80) >> 7
}

// Flash.SECBOOTADD0R: FFlash secure boot address 0 register
func (o *Flash_Type) SetSECBOOTADD0R_BOOT_LOCK(value uint32) {
	volatile.StoreUint32(&o.SECBOOTADD0R.Reg, volatile.LoadUint32(&o.SECBOOTADD0R.Reg)&^(0x1)|value)
}
func (o *Flash_Type) GetSECBOOTADD0R_BOOT_LOCK() uint32 {
	return volatile.LoadUint32(&o.SECBOOTADD0R.Reg) & 0x1
}
func (o *Flash_Type) SetSECBOOTADD0R_SECBOOTADD0(value uint32) {
	volatile.StoreUint32(&o.SECBOOTADD0R.Reg, volatile.LoadUint32(&o.SECBOOTADD0R.Reg)&^(0xffffff80)|value<<7)
}
func (o *Flash_Type) GetSECBOOTADD0R_SECBOOTADD0() uint32 {
	return (volatile.LoadUint32(&o.SECBOOTADD0R.Reg) & 0xffffff80) >> 7
}

// Flash.SECWM1R1: Flash bank 1 secure watermak1 register
func (o *Flash_Type) SetSECWM1R1_SECWM1_PSTRT(value uint32) {
	volatile.StoreUint32(&o.SECWM1R1.Reg, volatile.LoadUint32(&o.SECWM1R1.Reg)&^(0x7f)|value)
}
func (o *Flash_Type) GetSECWM1R1_SECWM1_PSTRT() uint32 {
	return volatile.LoadUint32(&o.SECWM1R1.Reg) & 0x7f
}
func (o *Flash_Type) SetSECWM1R1_SECWM1_PEND(value uint32) {
	volatile.StoreUint32(&o.SECWM1R1.Reg, volatile.LoadUint32(&o.SECWM1R1.Reg)&^(0x7f0000)|value<<16)
}
func (o *Flash_Type) GetSECWM1R1_SECWM1_PEND() uint32 {
	return (volatile.LoadUint32(&o.SECWM1R1.Reg) & 0x7f0000) >> 16
}

// Flash.SECWM1R2: Flash secure watermak1 register 2
func (o *Flash_Type) SetSECWM1R2_PCROP1_PSTRT(value uint32) {
	volatile.StoreUint32(&o.SECWM1R2.Reg, volatile.LoadUint32(&o.SECWM1R2.Reg)&^(0x7f)|value)
}
func (o *Flash_Type) GetSECWM1R2_PCROP1_PSTRT() uint32 {
	return volatile.LoadUint32(&o.SECWM1R2.Reg) & 0x7f
}
func (o *Flash_Type) SetSECWM1R2_PCROP1EN(value uint32) {
	volatile.StoreUint32(&o.SECWM1R2.Reg, volatile.LoadUint32(&o.SECWM1R2.Reg)&^(0x8000)|value<<15)
}
func (o *Flash_Type) GetSECWM1R2_PCROP1EN() uint32 {
	return (volatile.LoadUint32(&o.SECWM1R2.Reg) & 0x8000) >> 15
}
func (o *Flash_Type) SetSECWM1R2_HDP1_PEND(value uint32) {
	volatile.StoreUint32(&o.SECWM1R2.Reg, volatile.LoadUint32(&o.SECWM1R2.Reg)&^(0x7f0000)|value<<16)
}
func (o *Flash_Type) GetSECWM1R2_HDP1_PEND() uint32 {
	return (volatile.LoadUint32(&o.SECWM1R2.Reg) & 0x7f0000) >> 16
}
func (o *Flash_Type) SetSECWM1R2_HDP1EN(value uint32) {
	volatile.StoreUint32(&o.SECWM1R2.Reg, volatile.LoadUint32(&o.SECWM1R2.Reg)&^(0x80000000)|value<<31)
}
func (o *Flash_Type) GetSECWM1R2_HDP1EN() uint32 {
	return (volatile.LoadUint32(&o.SECWM1R2.Reg) & 0x80000000) >> 31
}

// Flash.WRP1AR: Flash Bank 1 WRP area A address register
func (o *Flash_Type) SetWRP1AR_WRP1A_PSTRT(value uint32) {
	volatile.StoreUint32(&o.WRP1AR.Reg, volatile.LoadUint32(&o.WRP1AR.Reg)&^(0x7f)|value)
}
func (o *Flash_Type) GetWRP1AR_WRP1A_PSTRT() uint32 {
	return volatile.LoadUint32(&o.WRP1AR.Reg) & 0x7f
}
func (o *Flash_Type) SetWRP1AR_WRP1A_PEND(value uint32) {
	volatile.StoreUint32(&o.WRP1AR.Reg, volatile.LoadUint32(&o.WRP1AR.Reg)&^(0x7f0000)|value<<16)
}
func (o *Flash_Type) GetWRP1AR_WRP1A_PEND() uint32 {
	return (volatile.LoadUint32(&o.WRP1AR.Reg) & 0x7f0000) >> 16
}

// Flash.WRP1BR: Flash Bank 1 WRP area B address register
func (o *Flash_Type) SetWRP1BR_WRP1B_PSTRT(value uint32) {
	volatile.StoreUint32(&o.WRP1BR.Reg, volatile.LoadUint32(&o.WRP1BR.Reg)&^(0x7f)|value)
}
func (o *Flash_Type) GetWRP1BR_WRP1B_PSTRT() uint32 {
	return volatile.LoadUint32(&o.WRP1BR.Reg) & 0x7f
}
func (o *Flash_Type) SetWRP1BR_WRP1B_PEND(value uint32) {
	volatile.StoreUint32(&o.WRP1BR.Reg, volatile.LoadUint32(&o.WRP1BR.Reg)&^(0x7f0000)|value<<16)
}
func (o *Flash_Type) GetWRP1BR_WRP1B_PEND() uint32 {
	return (volatile.LoadUint32(&o.WRP1BR.Reg) & 0x7f0000) >> 16
}

// Flash.SECWM2R1: Flash secure watermak2 register
func (o *Flash_Type) SetSECWM2R1_SECWM2_PSTRT(value uint32) {
	volatile.StoreUint32(&o.SECWM2R1.Reg, volatile.LoadUint32(&o.SECWM2R1.Reg)&^(0x7f)|value)
}
func (o *Flash_Type) GetSECWM2R1_SECWM2_PSTRT() uint32 {
	return volatile.LoadUint32(&o.SECWM2R1.Reg) & 0x7f
}
func (o *Flash_Type) SetSECWM2R1_SECWM2_PEND(value uint32) {
	volatile.StoreUint32(&o.SECWM2R1.Reg, volatile.LoadUint32(&o.SECWM2R1.Reg)&^(0x7f0000)|value<<16)
}
func (o *Flash_Type) GetSECWM2R1_SECWM2_PEND() uint32 {
	return (volatile.LoadUint32(&o.SECWM2R1.Reg) & 0x7f0000) >> 16
}

// Flash.SECWM2R2: Flash secure watermak2 register2
func (o *Flash_Type) SetSECWM2R2_PCROP2_PSTRT(value uint32) {
	volatile.StoreUint32(&o.SECWM2R2.Reg, volatile.LoadUint32(&o.SECWM2R2.Reg)&^(0x7f)|value)
}
func (o *Flash_Type) GetSECWM2R2_PCROP2_PSTRT() uint32 {
	return volatile.LoadUint32(&o.SECWM2R2.Reg) & 0x7f
}
func (o *Flash_Type) SetSECWM2R2_PCROP2EN(value uint32) {
	volatile.StoreUint32(&o.SECWM2R2.Reg, volatile.LoadUint32(&o.SECWM2R2.Reg)&^(0x8000)|value<<15)
}
func (o *Flash_Type) GetSECWM2R2_PCROP2EN() uint32 {
	return (volatile.LoadUint32(&o.SECWM2R2.Reg) & 0x8000) >> 15
}
func (o *Flash_Type) SetSECWM2R2_HDP2_PEND(value uint32) {
	volatile.StoreUint32(&o.SECWM2R2.Reg, volatile.LoadUint32(&o.SECWM2R2.Reg)&^(0x7f0000)|value<<16)
}
func (o *Flash_Type) GetSECWM2R2_HDP2_PEND() uint32 {
	return (volatile.LoadUint32(&o.SECWM2R2.Reg) & 0x7f0000) >> 16
}
func (o *Flash_Type) SetSECWM2R2_HDP2EN(value uint32) {
	volatile.StoreUint32(&o.SECWM2R2.Reg, volatile.LoadUint32(&o.SECWM2R2.Reg)&^(0x80000000)|value<<31)
}
func (o *Flash_Type) GetSECWM2R2_HDP2EN() uint32 {
	return (volatile.LoadUint32(&o.SECWM2R2.Reg) & 0x80000000) >> 31
}

// Flash.WRP2AR: Flash WPR2 area A address register
func (o *Flash_Type) SetWRP2AR_WRP2A_PSTRT(value uint32) {
	volatile.StoreUint32(&o.WRP2AR.Reg, volatile.LoadUint32(&o.WRP2AR.Reg)&^(0x7f)|value)
}
func (o *Flash_Type) GetWRP2AR_WRP2A_PSTRT() uint32 {
	return volatile.LoadUint32(&o.WRP2AR.Reg) & 0x7f
}
func (o *Flash_Type) SetWRP2AR_WRP2A_PEND(value uint32) {
	volatile.StoreUint32(&o.WRP2AR.Reg, volatile.LoadUint32(&o.WRP2AR.Reg)&^(0x7f0000)|value<<16)
}
func (o *Flash_Type) GetWRP2AR_WRP2A_PEND() uint32 {
	return (volatile.LoadUint32(&o.WRP2AR.Reg) & 0x7f0000) >> 16
}

// Flash.WRP2BR: Flash WPR2 area B address register
func (o *Flash_Type) SetWRP2BR_WRP2B_PSTRT(value uint32) {
	volatile.StoreUint32(&o.WRP2BR.Reg, volatile.LoadUint32(&o.WRP2BR.Reg)&^(0x7f)|value)
}
func (o *Flash_Type) GetWRP2BR_WRP2B_PSTRT() uint32 {
	return volatile.LoadUint32(&o.WRP2BR.Reg) & 0x7f
}
func (o *Flash_Type) SetWRP2BR_WRP2B_PEND(value uint32) {
	volatile.StoreUint32(&o.WRP2BR.Reg, volatile.LoadUint32(&o.WRP2BR.Reg)&^(0x7f0000)|value<<16)
}
func (o *Flash_Type) GetWRP2BR_WRP2B_PEND() uint32 {
	return (volatile.LoadUint32(&o.WRP2BR.Reg) & 0x7f0000) >> 16
}

// Flash.SECBB1R1: FLASH secure block based bank 1 register
func (o *Flash_Type) SetSECBB1R1(value uint32) {
	volatile.StoreUint32(&o.SECBB1R1.Reg, value)
}
func (o *Flash_Type) GetSECBB1R1() uint32 {
	return volatile.LoadUint32(&o.SECBB1R1.Reg)
}

// Flash.SECBB1R2: FLASH secure block based bank 1 register
func (o *Flash_Type) SetSECBB1R2(value uint32) {
	volatile.StoreUint32(&o.SECBB1R2.Reg, value)
}
func (o *Flash_Type) GetSECBB1R2() uint32 {
	return volatile.LoadUint32(&o.SECBB1R2.Reg)
}

// Flash.SECBB1R3: FLASH secure block based bank 1 register
func (o *Flash_Type) SetSECBB1R3(value uint32) {
	volatile.StoreUint32(&o.SECBB1R3.Reg, value)
}
func (o *Flash_Type) GetSECBB1R3() uint32 {
	return volatile.LoadUint32(&o.SECBB1R3.Reg)
}

// Flash.SECBB1R4: FLASH secure block based bank 1 register
func (o *Flash_Type) SetSECBB1R4(value uint32) {
	volatile.StoreUint32(&o.SECBB1R4.Reg, value)
}
func (o *Flash_Type) GetSECBB1R4() uint32 {
	return volatile.LoadUint32(&o.SECBB1R4.Reg)
}

// Flash.SECBB2R1: FLASH secure block based bank 2 register
func (o *Flash_Type) SetSECBB2R1(value uint32) {
	volatile.StoreUint32(&o.SECBB2R1.Reg, value)
}
func (o *Flash_Type) GetSECBB2R1() uint32 {
	return volatile.LoadUint32(&o.SECBB2R1.Reg)
}

// Flash.SECBB2R2: FLASH secure block based bank 2 register
func (o *Flash_Type) SetSECBB2R2(value uint32) {
	volatile.StoreUint32(&o.SECBB2R2.Reg, value)
}
func (o *Flash_Type) GetSECBB2R2() uint32 {
	return volatile.LoadUint32(&o.SECBB2R2.Reg)
}

// Flash.SECBB2R3: FLASH secure block based bank 2 register
func (o *Flash_Type) SetSECBB2R3(value uint32) {
	volatile.StoreUint32(&o.SECBB2R3.Reg, value)
}
func (o *Flash_Type) GetSECBB2R3() uint32 {
	return volatile.LoadUint32(&o.SECBB2R3.Reg)
}

// Flash.SECBB2R4: FLASH secure block based bank 2 register
func (o *Flash_Type) SetSECBB2R4(value uint32) {
	volatile.StoreUint32(&o.SECBB2R4.Reg, value)
}
func (o *Flash_Type) GetSECBB2R4() uint32 {
	return volatile.LoadUint32(&o.SECBB2R4.Reg)
}

// Flash.SECHDPCR: FLASH secure HDP control register
func (o *Flash_Type) SetSECHDPCR_HDP1_ACCDIS(value uint32) {
	volatile.StoreUint32(&o.SECHDPCR.Reg, volatile.LoadUint32(&o.SECHDPCR.Reg)&^(0x1)|value)
}
func (o *Flash_Type) GetSECHDPCR_HDP1_ACCDIS() uint32 {
	return volatile.LoadUint32(&o.SECHDPCR.Reg) & 0x1
}
func (o *Flash_Type) SetSECHDPCR_HDP2_ACCDIS(value uint32) {
	volatile.StoreUint32(&o.SECHDPCR.Reg, volatile.LoadUint32(&o.SECHDPCR.Reg)&^(0x2)|value<<1)
}
func (o *Flash_Type) GetSECHDPCR_HDP2_ACCDIS() uint32 {
	return (volatile.LoadUint32(&o.SECHDPCR.Reg) & 0x2) >> 1
}

// Flash.PRIVCFGR: Power privilege configuration register
func (o *Flash_Type) SetPRIVCFGR_PRIV(value uint32) {
	volatile.StoreUint32(&o.PRIVCFGR.Reg, volatile.LoadUint32(&o.PRIVCFGR.Reg)&^(0x1)|value)
}
func (o *Flash_Type) GetPRIVCFGR_PRIV() uint32 {
	return volatile.LoadUint32(&o.PRIVCFGR.Reg) & 0x1
}

// General-purpose I/Os
type GPIO_Type struct {
	MODER   volatile.Register32 // 0x0
	OTYPER  volatile.Register32 // 0x4
	OSPEEDR volatile.Register32 // 0x8
	PUPDR   volatile.Register32 // 0xC
	IDR     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	BSRR    volatile.Register32 // 0x18
	LCKR    volatile.Register32 // 0x1C
	AFRL    volatile.Register32 // 0x20
	AFRH    volatile.Register32 // 0x24
	BRR     volatile.Register32 // 0x28
	_       [4]byte
	SECCFGR volatile.Register32 // 0x30
}

// GPIO.MODER: GPIO port mode register
func (o *GPIO_Type) SetMODER_MODER15(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetMODER_MODER15() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetMODER_MODER14(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetMODER_MODER14() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetMODER_MODER13(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetMODER_MODER13() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetMODER_MODER12(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetMODER_MODER12() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetMODER_MODER11(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetMODER_MODER11() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetMODER_MODER10(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetMODER_MODER10() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetMODER_MODER9(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetMODER_MODER9() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetMODER_MODER8(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetMODER_MODER8() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetMODER_MODER7(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetMODER_MODER7() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetMODER_MODER6(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetMODER_MODER6() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetMODER_MODER5(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetMODER_MODER5() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetMODER_MODER4(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetMODER_MODER4() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetMODER_MODER3(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetMODER_MODER3() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetMODER_MODER2(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetMODER_MODER2() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetMODER_MODER1(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetMODER_MODER1() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetMODER_MODER0(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetMODER_MODER0() uint32 {
	return volatile.LoadUint32(&o.MODER.Reg) & 0x3
}

// GPIO.OTYPER: GPIO port output type register
func (o *GPIO_Type) SetOTYPER_OT15(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetOTYPER_OT15() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetOTYPER_OT14(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetOTYPER_OT14() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetOTYPER_OT13(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetOTYPER_OT13() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetOTYPER_OT12(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetOTYPER_OT12() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetOTYPER_OT11(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetOTYPER_OT11() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetOTYPER_OT10(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetOTYPER_OT10() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetOTYPER_OT9(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetOTYPER_OT9() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetOTYPER_OT8(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetOTYPER_OT8() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetOTYPER_OT7(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetOTYPER_OT7() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetOTYPER_OT6(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetOTYPER_OT6() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetOTYPER_OT5(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetOTYPER_OT5() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetOTYPER_OT4(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetOTYPER_OT4() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetOTYPER_OT3(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetOTYPER_OT3() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetOTYPER_OT2(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetOTYPER_OT2() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetOTYPER_OT1(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetOTYPER_OT1() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetOTYPER_OT0(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetOTYPER_OT0() uint32 {
	return volatile.LoadUint32(&o.OTYPER.Reg) & 0x1
}

// GPIO.OSPEEDR: GPIO port output speed register
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR15(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR15() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR14(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR14() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR13(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR13() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR12(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR12() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR11(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR11() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR10(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR10() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR9(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR9() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR8(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR8() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR7(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR7() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR6(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR6() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR5(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR5() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR4(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR4() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR3(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR3() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR2(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR2() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR1(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR1() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR0(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR0() uint32 {
	return volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3
}

// GPIO.PUPDR: GPIO port pull-up/pull-down register
func (o *GPIO_Type) SetPUPDR_PUPDR15(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetPUPDR_PUPDR15() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetPUPDR_PUPDR14(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetPUPDR_PUPDR14() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetPUPDR_PUPDR13(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetPUPDR_PUPDR13() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetPUPDR_PUPDR12(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetPUPDR_PUPDR12() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetPUPDR_PUPDR11(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetPUPDR_PUPDR11() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetPUPDR_PUPDR10(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetPUPDR_PUPDR10() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetPUPDR_PUPDR9(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetPUPDR_PUPDR9() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetPUPDR_PUPDR8(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetPUPDR_PUPDR8() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetPUPDR_PUPDR7(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetPUPDR_PUPDR7() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetPUPDR_PUPDR6(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetPUPDR_PUPDR6() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetPUPDR_PUPDR5(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetPUPDR_PUPDR5() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetPUPDR_PUPDR4(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetPUPDR_PUPDR4() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetPUPDR_PUPDR3(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetPUPDR_PUPDR3() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetPUPDR_PUPDR2(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetPUPDR_PUPDR2() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetPUPDR_PUPDR1(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetPUPDR_PUPDR1() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetPUPDR_PUPDR0(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPUPDR_PUPDR0() uint32 {
	return volatile.LoadUint32(&o.PUPDR.Reg) & 0x3
}

// GPIO.IDR: GPIO port input data register
func (o *GPIO_Type) SetIDR_IDR15(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetIDR_IDR15() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetIDR_IDR14(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetIDR_IDR14() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetIDR_IDR13(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetIDR_IDR13() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetIDR_IDR12(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetIDR_IDR12() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetIDR_IDR11(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetIDR_IDR11() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetIDR_IDR10(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetIDR_IDR10() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetIDR_IDR9(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetIDR_IDR9() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetIDR_IDR8(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetIDR_IDR8() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetIDR_IDR7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetIDR_IDR7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetIDR_IDR6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetIDR_IDR6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetIDR_IDR5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetIDR_IDR5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetIDR_IDR4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetIDR_IDR4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetIDR_IDR3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetIDR_IDR3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetIDR_IDR2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetIDR_IDR2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetIDR_IDR1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetIDR_IDR1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetIDR_IDR0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetIDR_IDR0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}

// GPIO.ODR: GPIO port output data register
func (o *GPIO_Type) SetODR_ODR15(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetODR_ODR15() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetODR_ODR14(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetODR_ODR14() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetODR_ODR13(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetODR_ODR13() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetODR_ODR12(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetODR_ODR12() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetODR_ODR11(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetODR_ODR11() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetODR_ODR10(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetODR_ODR10() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetODR_ODR9(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetODR_ODR9() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetODR_ODR8(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetODR_ODR8() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetODR_ODR7(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetODR_ODR7() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetODR_ODR6(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetODR_ODR6() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetODR_ODR5(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetODR_ODR5() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetODR_ODR4(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetODR_ODR4() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetODR_ODR3(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetODR_ODR3() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetODR_ODR2(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetODR_ODR2() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetODR_ODR1(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetODR_ODR1() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetODR_ODR0(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetODR_ODR0() uint32 {
	return volatile.LoadUint32(&o.ODR.Reg) & 0x1
}

// GPIO.BSRR: GPIO port bit set/reset register
func (o *GPIO_Type) SetBSRR_BR15(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetBSRR_BR15() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80000000) >> 31
}
func (o *GPIO_Type) SetBSRR_BR14(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetBSRR_BR14() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetBSRR_BR13(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetBSRR_BR13() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetBSRR_BR12(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetBSRR_BR12() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetBSRR_BR11(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetBSRR_BR11() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetBSRR_BR10(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetBSRR_BR10() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetBSRR_BR9(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetBSRR_BR9() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetBSRR_BR8(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetBSRR_BR8() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetBSRR_BR7(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetBSRR_BR7() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetBSRR_BR6(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetBSRR_BR6() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetBSRR_BR5(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetBSRR_BR5() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetBSRR_BR4(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetBSRR_BR4() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetBSRR_BR3(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetBSRR_BR3() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetBSRR_BR2(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetBSRR_BR2() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetBSRR_BR1(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetBSRR_BR1() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetBSRR_BR0(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetBSRR_BR0() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetBSRR_BS15(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetBSRR_BS15() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetBSRR_BS14(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetBSRR_BS14() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetBSRR_BS13(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetBSRR_BS13() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetBSRR_BS12(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetBSRR_BS12() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetBSRR_BS11(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetBSRR_BS11() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetBSRR_BS10(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetBSRR_BS10() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetBSRR_BS9(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetBSRR_BS9() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetBSRR_BS8(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetBSRR_BS8() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetBSRR_BS7(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetBSRR_BS7() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetBSRR_BS6(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetBSRR_BS6() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetBSRR_BS5(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetBSRR_BS5() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetBSRR_BS4(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetBSRR_BS4() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetBSRR_BS3(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetBSRR_BS3() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetBSRR_BS2(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetBSRR_BS2() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetBSRR_BS1(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetBSRR_BS1() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetBSRR_BS0(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetBSRR_BS0() uint32 {
	return volatile.LoadUint32(&o.BSRR.Reg) & 0x1
}

// GPIO.LCKR: GPIO port configuration lock register
func (o *GPIO_Type) SetLCKR_LCKK(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetLCKR_LCKK() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetLCKR_LCK15(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetLCKR_LCK15() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetLCKR_LCK14(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetLCKR_LCK14() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetLCKR_LCK13(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetLCKR_LCK13() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetLCKR_LCK12(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetLCKR_LCK12() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetLCKR_LCK11(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetLCKR_LCK11() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetLCKR_LCK10(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetLCKR_LCK10() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetLCKR_LCK9(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetLCKR_LCK9() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetLCKR_LCK8(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetLCKR_LCK8() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetLCKR_LCK7(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetLCKR_LCK7() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetLCKR_LCK6(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetLCKR_LCK6() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetLCKR_LCK5(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetLCKR_LCK5() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetLCKR_LCK4(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetLCKR_LCK4() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetLCKR_LCK3(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetLCKR_LCK3() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetLCKR_LCK2(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetLCKR_LCK2() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetLCKR_LCK1(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetLCKR_LCK1() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetLCKR_LCK0(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetLCKR_LCK0() uint32 {
	return volatile.LoadUint32(&o.LCKR.Reg) & 0x1
}

// GPIO.AFRL: GPIO alternate function low register
func (o *GPIO_Type) SetAFRL_AFSEL7(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0000000)|value<<28)
}
func (o *GPIO_Type) GetAFRL_AFSEL7() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0000000) >> 28
}
func (o *GPIO_Type) SetAFRL_AFSEL6(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf000000)|value<<24)
}
func (o *GPIO_Type) GetAFRL_AFSEL6() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf000000) >> 24
}
func (o *GPIO_Type) SetAFRL_AFSEL5(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf00000)|value<<20)
}
func (o *GPIO_Type) GetAFRL_AFSEL5() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf00000) >> 20
}
func (o *GPIO_Type) SetAFRL_AFSEL4(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0000)|value<<16)
}
func (o *GPIO_Type) GetAFRL_AFSEL4() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0000) >> 16
}
func (o *GPIO_Type) SetAFRL_AFSEL3(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf000)|value<<12)
}
func (o *GPIO_Type) GetAFRL_AFSEL3() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf000) >> 12
}
func (o *GPIO_Type) SetAFRL_AFSEL2(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf00)|value<<8)
}
func (o *GPIO_Type) GetAFRL_AFSEL2() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf00) >> 8
}
func (o *GPIO_Type) SetAFRL_AFSEL1(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0)|value<<4)
}
func (o *GPIO_Type) GetAFRL_AFSEL1() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0) >> 4
}
func (o *GPIO_Type) SetAFRL_AFSEL0(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf)|value)
}
func (o *GPIO_Type) GetAFRL_AFSEL0() uint32 {
	return volatile.LoadUint32(&o.AFRL.Reg) & 0xf
}

// GPIO.AFRH: GPIO alternate function high register
func (o *GPIO_Type) SetAFRH_AFSEL15(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0000000)|value<<28)
}
func (o *GPIO_Type) GetAFRH_AFSEL15() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0000000) >> 28
}
func (o *GPIO_Type) SetAFRH_AFSEL14(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf000000)|value<<24)
}
func (o *GPIO_Type) GetAFRH_AFSEL14() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf000000) >> 24
}
func (o *GPIO_Type) SetAFRH_AFSEL13(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf00000)|value<<20)
}
func (o *GPIO_Type) GetAFRH_AFSEL13() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf00000) >> 20
}
func (o *GPIO_Type) SetAFRH_AFSEL12(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0000)|value<<16)
}
func (o *GPIO_Type) GetAFRH_AFSEL12() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0000) >> 16
}
func (o *GPIO_Type) SetAFRH_AFSEL11(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf000)|value<<12)
}
func (o *GPIO_Type) GetAFRH_AFSEL11() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf000) >> 12
}
func (o *GPIO_Type) SetAFRH_AFSEL10(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf00)|value<<8)
}
func (o *GPIO_Type) GetAFRH_AFSEL10() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf00) >> 8
}
func (o *GPIO_Type) SetAFRH_AFSEL9(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0)|value<<4)
}
func (o *GPIO_Type) GetAFRH_AFSEL9() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0) >> 4
}
func (o *GPIO_Type) SetAFRH_AFSEL8(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf)|value)
}
func (o *GPIO_Type) GetAFRH_AFSEL8() uint32 {
	return volatile.LoadUint32(&o.AFRH.Reg) & 0xf
}

// GPIO.BRR: GPIO port bit reset register
func (o *GPIO_Type) SetBRR_BR0(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetBRR_BR0() uint32 {
	return volatile.LoadUint32(&o.BRR.Reg) & 0x1
}
func (o *GPIO_Type) SetBRR_BR1(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetBRR_BR1() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetBRR_BR2(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetBRR_BR2() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetBRR_BR3(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetBRR_BR3() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetBRR_BR4(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetBRR_BR4() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetBRR_BR5(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetBRR_BR5() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetBRR_BR6(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetBRR_BR6() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetBRR_BR7(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetBRR_BR7() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetBRR_BR8(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetBRR_BR8() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetBRR_BR9(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetBRR_BR9() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetBRR_BR10(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetBRR_BR10() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetBRR_BR11(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetBRR_BR11() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetBRR_BR12(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetBRR_BR12() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetBRR_BR13(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetBRR_BR13() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetBRR_BR14(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetBRR_BR14() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetBRR_BR15(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetBRR_BR15() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x8000) >> 15
}

// GPIO.SECCFGR: GPIO secure configuration register
func (o *GPIO_Type) SetSECCFGR_SEC0(value uint32) {
	volatile.StoreUint32(&o.SECCFGR.Reg, volatile.LoadUint32(&o.SECCFGR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetSECCFGR_SEC0() uint32 {
	return volatile.LoadUint32(&o.SECCFGR.Reg) & 0x1
}
func (o *GPIO_Type) SetSECCFGR_SEC1(value uint32) {
	volatile.StoreUint32(&o.SECCFGR.Reg, volatile.LoadUint32(&o.SECCFGR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetSECCFGR_SEC1() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetSECCFGR_SEC2(value uint32) {
	volatile.StoreUint32(&o.SECCFGR.Reg, volatile.LoadUint32(&o.SECCFGR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetSECCFGR_SEC2() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetSECCFGR_SEC3(value uint32) {
	volatile.StoreUint32(&o.SECCFGR.Reg, volatile.LoadUint32(&o.SECCFGR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetSECCFGR_SEC3() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetSECCFGR_SEC4(value uint32) {
	volatile.StoreUint32(&o.SECCFGR.Reg, volatile.LoadUint32(&o.SECCFGR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetSECCFGR_SEC4() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetSECCFGR_SEC5(value uint32) {
	volatile.StoreUint32(&o.SECCFGR.Reg, volatile.LoadUint32(&o.SECCFGR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetSECCFGR_SEC5() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetSECCFGR_SEC6(value uint32) {
	volatile.StoreUint32(&o.SECCFGR.Reg, volatile.LoadUint32(&o.SECCFGR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetSECCFGR_SEC6() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetSECCFGR_SEC7(value uint32) {
	volatile.StoreUint32(&o.SECCFGR.Reg, volatile.LoadUint32(&o.SECCFGR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetSECCFGR_SEC7() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetSECCFGR_SEC8(value uint32) {
	volatile.StoreUint32(&o.SECCFGR.Reg, volatile.LoadUint32(&o.SECCFGR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetSECCFGR_SEC8() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetSECCFGR_SEC9(value uint32) {
	volatile.StoreUint32(&o.SECCFGR.Reg, volatile.LoadUint32(&o.SECCFGR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetSECCFGR_SEC9() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetSECCFGR_SEC10(value uint32) {
	volatile.StoreUint32(&o.SECCFGR.Reg, volatile.LoadUint32(&o.SECCFGR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetSECCFGR_SEC10() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetSECCFGR_SEC11(value uint32) {
	volatile.StoreUint32(&o.SECCFGR.Reg, volatile.LoadUint32(&o.SECCFGR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetSECCFGR_SEC11() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetSECCFGR_SEC12(value uint32) {
	volatile.StoreUint32(&o.SECCFGR.Reg, volatile.LoadUint32(&o.SECCFGR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetSECCFGR_SEC12() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetSECCFGR_SEC13(value uint32) {
	volatile.StoreUint32(&o.SECCFGR.Reg, volatile.LoadUint32(&o.SECCFGR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetSECCFGR_SEC13() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetSECCFGR_SEC14(value uint32) {
	volatile.StoreUint32(&o.SECCFGR.Reg, volatile.LoadUint32(&o.SECCFGR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetSECCFGR_SEC14() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetSECCFGR_SEC15(value uint32) {
	volatile.StoreUint32(&o.SECCFGR.Reg, volatile.LoadUint32(&o.SECCFGR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetSECCFGR_SEC15() uint32 {
	return (volatile.LoadUint32(&o.SECCFGR.Reg) & 0x8000) >> 15
}

// Tamper and backup registers
type TAMP_Type struct {
	CR1     volatile.Register32 // 0x0
	CR2     volatile.Register32 // 0x4
	CR3     volatile.Register32 // 0x8
	FLTCR   volatile.Register32 // 0xC
	ATCR1   volatile.Register32 // 0x10
	ATSEEDR volatile.Register32 // 0x14
	ATOR    volatile.Register32 // 0x18
	ATCR2   volatile.Register32 // 0x1C
	SMCR    volatile.Register32 // 0x20
	PRIVCR  volatile.Register32 // 0x24
	_       [4]byte
	IER     volatile.Register32 // 0x2C
	SR      volatile.Register32 // 0x30
	MISR    volatile.Register32 // 0x34
	SMISR   volatile.Register32 // 0x38
	SCR     volatile.Register32 // 0x3C
	COUNTR  volatile.Register32 // 0x40
	_       [12]byte
	CFGR    volatile.Register32 // 0x50
	_       [172]byte
	BKP0R   volatile.Register32 // 0x100
	BKP1R   volatile.Register32 // 0x104
	BKP2R   volatile.Register32 // 0x108
	BKP3R   volatile.Register32 // 0x10C
	BKP4R   volatile.Register32 // 0x110
	BKP5R   volatile.Register32 // 0x114
	BKP6R   volatile.Register32 // 0x118
	BKP7R   volatile.Register32 // 0x11C
	BKP8R   volatile.Register32 // 0x120
	BKP9R   volatile.Register32 // 0x124
	BKP10R  volatile.Register32 // 0x128
	BKP11R  volatile.Register32 // 0x12C
	BKP12R  volatile.Register32 // 0x130
	BKP13R  volatile.Register32 // 0x134
	BKP14R  volatile.Register32 // 0x138
	BKP15R  volatile.Register32 // 0x13C
	BKP16R  volatile.Register32 // 0x140
	BKP17R  volatile.Register32 // 0x144
	BKP18R  volatile.Register32 // 0x148
	BKP19R  volatile.Register32 // 0x14C
	BKP20R  volatile.Register32 // 0x150
	BKP21R  volatile.Register32 // 0x154
	BKP22R  volatile.Register32 // 0x158
	BKP23R  volatile.Register32 // 0x15C
	BKP24R  volatile.Register32 // 0x160
	BKP25R  volatile.Register32 // 0x164
	BKP26R  volatile.Register32 // 0x168
	BKP27R  volatile.Register32 // 0x16C
	BKP28R  volatile.Register32 // 0x170
	BKP29R  volatile.Register32 // 0x174
	BKP30R  volatile.Register32 // 0x178
	BKP31R  volatile.Register32 // 0x17C
}

// TAMP.CR1: control register 1
func (o *TAMP_Type) SetCR1_TAMP1E(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *TAMP_Type) GetCR1_TAMP1E() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}
func (o *TAMP_Type) SetCR1_TAMP2E(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *TAMP_Type) GetCR1_TAMP2E() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *TAMP_Type) SetCR1_TAMP3E(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *TAMP_Type) GetCR1_TAMP3E() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *TAMP_Type) SetCR1_TAMP4E(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *TAMP_Type) GetCR1_TAMP4E() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *TAMP_Type) SetCR1_TAMP5E(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *TAMP_Type) GetCR1_TAMP5E() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *TAMP_Type) SetCR1_TAMP6E(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *TAMP_Type) GetCR1_TAMP6E() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *TAMP_Type) SetCR1_TAMP7E(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *TAMP_Type) GetCR1_TAMP7E() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *TAMP_Type) SetCR1_TAMP8E(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *TAMP_Type) GetCR1_TAMP8E() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *TAMP_Type) SetCR1_ITAMP1E(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10000)|value<<16)
}
func (o *TAMP_Type) GetCR1_ITAMP1E() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10000) >> 16
}
func (o *TAMP_Type) SetCR1_ITAMP2E(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20000)|value<<17)
}
func (o *TAMP_Type) GetCR1_ITAMP2E() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20000) >> 17
}
func (o *TAMP_Type) SetCR1_ITAMP3E(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40000)|value<<18)
}
func (o *TAMP_Type) GetCR1_ITAMP3E() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40000) >> 18
}
func (o *TAMP_Type) SetCR1_ITAMP5E(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100000)|value<<20)
}
func (o *TAMP_Type) GetCR1_ITAMP5E() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100000) >> 20
}
func (o *TAMP_Type) SetCR1_ITAMP8E(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800000)|value<<23)
}
func (o *TAMP_Type) GetCR1_ITAMP8E() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800000) >> 23
}

// TAMP.CR2: control register 2
func (o *TAMP_Type) SetCR2_TAMP1NOER(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *TAMP_Type) GetCR2_TAMP1NOER() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}
func (o *TAMP_Type) SetCR2_TAMP2NOER(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2)|value<<1)
}
func (o *TAMP_Type) GetCR2_TAMP2NOER() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2) >> 1
}
func (o *TAMP_Type) SetCR2_TAMP3NOER(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4)|value<<2)
}
func (o *TAMP_Type) GetCR2_TAMP3NOER() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4) >> 2
}
func (o *TAMP_Type) SetCR2_TAMP4NOER(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *TAMP_Type) GetCR2_TAMP4NOER() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8) >> 3
}
func (o *TAMP_Type) SetCR2_TAMP5NOER(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *TAMP_Type) GetCR2_TAMP5NOER() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *TAMP_Type) SetCR2_TAMP6NOER(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *TAMP_Type) GetCR2_TAMP6NOER() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *TAMP_Type) SetCR2_TAMP7NOER(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *TAMP_Type) GetCR2_TAMP7NOER() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *TAMP_Type) SetCR2_TAMP8NOER(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80)|value<<7)
}
func (o *TAMP_Type) GetCR2_TAMP8NOER() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80) >> 7
}
func (o *TAMP_Type) SetCR2_TAMP1MSK(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10000)|value<<16)
}
func (o *TAMP_Type) GetCR2_TAMP1MSK() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10000) >> 16
}
func (o *TAMP_Type) SetCR2_TAMP2MSK(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20000)|value<<17)
}
func (o *TAMP_Type) GetCR2_TAMP2MSK() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20000) >> 17
}
func (o *TAMP_Type) SetCR2_TAMP3MSK(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40000)|value<<18)
}
func (o *TAMP_Type) GetCR2_TAMP3MSK() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40000) >> 18
}
func (o *TAMP_Type) SetCR2_BKERASE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800000)|value<<23)
}
func (o *TAMP_Type) GetCR2_BKERASE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800000) >> 23
}
func (o *TAMP_Type) SetCR2_TAMP1TRG(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000000)|value<<24)
}
func (o *TAMP_Type) GetCR2_TAMP1TRG() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000000) >> 24
}
func (o *TAMP_Type) SetCR2_TAMP2TRG(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000000)|value<<25)
}
func (o *TAMP_Type) GetCR2_TAMP2TRG() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000000) >> 25
}
func (o *TAMP_Type) SetCR2_TAMP3TRG(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000000)|value<<26)
}
func (o *TAMP_Type) GetCR2_TAMP3TRG() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000000) >> 26
}
func (o *TAMP_Type) SetCR2_TAMP4TRG(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8000000)|value<<27)
}
func (o *TAMP_Type) GetCR2_TAMP4TRG() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8000000) >> 27
}
func (o *TAMP_Type) SetCR2_TAMP5TRG(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10000000)|value<<28)
}
func (o *TAMP_Type) GetCR2_TAMP5TRG() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10000000) >> 28
}
func (o *TAMP_Type) SetCR2_TAMP6TRG(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20000000)|value<<29)
}
func (o *TAMP_Type) GetCR2_TAMP6TRG() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20000000) >> 29
}
func (o *TAMP_Type) SetCR2_TAMP7TRG(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40000000)|value<<30)
}
func (o *TAMP_Type) GetCR2_TAMP7TRG() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40000000) >> 30
}
func (o *TAMP_Type) SetCR2_TAMP8TRG(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80000000)|value<<31)
}
func (o *TAMP_Type) GetCR2_TAMP8TRG() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80000000) >> 31
}

// TAMP.CR3: control register 3
func (o *TAMP_Type) SetCR3_ITAMP1NOER(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1)|value)
}
func (o *TAMP_Type) GetCR3_ITAMP1NOER() uint32 {
	return volatile.LoadUint32(&o.CR3.Reg) & 0x1
}
func (o *TAMP_Type) SetCR3_ITAMP2NOER(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2)|value<<1)
}
func (o *TAMP_Type) GetCR3_ITAMP2NOER() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2) >> 1
}
func (o *TAMP_Type) SetCR3_ITAMP3NOER(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4)|value<<2)
}
func (o *TAMP_Type) GetCR3_ITAMP3NOER() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4) >> 2
}
func (o *TAMP_Type) SetCR3_ITAMP5NOER(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x10)|value<<4)
}
func (o *TAMP_Type) GetCR3_ITAMP5NOER() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x10) >> 4
}
func (o *TAMP_Type) SetCR3_ITAMP8NOER(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x80)|value<<7)
}
func (o *TAMP_Type) GetCR3_ITAMP8NOER() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x80) >> 7
}

// TAMP.FLTCR: TAMP filter control register
func (o *TAMP_Type) SetFLTCR_TAMPFREQ(value uint32) {
	volatile.StoreUint32(&o.FLTCR.Reg, volatile.LoadUint32(&o.FLTCR.Reg)&^(0x7)|value)
}
func (o *TAMP_Type) GetFLTCR_TAMPFREQ() uint32 {
	return volatile.LoadUint32(&o.FLTCR.Reg) & 0x7
}
func (o *TAMP_Type) SetFLTCR_TAMPFLT(value uint32) {
	volatile.StoreUint32(&o.FLTCR.Reg, volatile.LoadUint32(&o.FLTCR.Reg)&^(0x18)|value<<3)
}
func (o *TAMP_Type) GetFLTCR_TAMPFLT() uint32 {
	return (volatile.LoadUint32(&o.FLTCR.Reg) & 0x18) >> 3
}
func (o *TAMP_Type) SetFLTCR_TAMPPRCH(value uint32) {
	volatile.StoreUint32(&o.FLTCR.Reg, volatile.LoadUint32(&o.FLTCR.Reg)&^(0x60)|value<<5)
}
func (o *TAMP_Type) GetFLTCR_TAMPPRCH() uint32 {
	return (volatile.LoadUint32(&o.FLTCR.Reg) & 0x60) >> 5
}
func (o *TAMP_Type) SetFLTCR_TAMPPUDIS(value uint32) {
	volatile.StoreUint32(&o.FLTCR.Reg, volatile.LoadUint32(&o.FLTCR.Reg)&^(0x80)|value<<7)
}
func (o *TAMP_Type) GetFLTCR_TAMPPUDIS() uint32 {
	return (volatile.LoadUint32(&o.FLTCR.Reg) & 0x80) >> 7
}

// TAMP.ATCR1: TAMP active tamper control register 1
func (o *TAMP_Type) SetATCR1_TAMP1AM(value uint32) {
	volatile.StoreUint32(&o.ATCR1.Reg, volatile.LoadUint32(&o.ATCR1.Reg)&^(0x1)|value)
}
func (o *TAMP_Type) GetATCR1_TAMP1AM() uint32 {
	return volatile.LoadUint32(&o.ATCR1.Reg) & 0x1
}
func (o *TAMP_Type) SetATCR1_TAMP2AM(value uint32) {
	volatile.StoreUint32(&o.ATCR1.Reg, volatile.LoadUint32(&o.ATCR1.Reg)&^(0x2)|value<<1)
}
func (o *TAMP_Type) GetATCR1_TAMP2AM() uint32 {
	return (volatile.LoadUint32(&o.ATCR1.Reg) & 0x2) >> 1
}
func (o *TAMP_Type) SetATCR1_TAMP3AM(value uint32) {
	volatile.StoreUint32(&o.ATCR1.Reg, volatile.LoadUint32(&o.ATCR1.Reg)&^(0x4)|value<<2)
}
func (o *TAMP_Type) GetATCR1_TAMP3AM() uint32 {
	return (volatile.LoadUint32(&o.ATCR1.Reg) & 0x4) >> 2
}
func (o *TAMP_Type) SetATCR1_TAMP4AM(value uint32) {
	volatile.StoreUint32(&o.ATCR1.Reg, volatile.LoadUint32(&o.ATCR1.Reg)&^(0x8)|value<<3)
}
func (o *TAMP_Type) GetATCR1_TAMP4AM() uint32 {
	return (volatile.LoadUint32(&o.ATCR1.Reg) & 0x8) >> 3
}
func (o *TAMP_Type) SetATCR1_TAMP5AM(value uint32) {
	volatile.StoreUint32(&o.ATCR1.Reg, volatile.LoadUint32(&o.ATCR1.Reg)&^(0x10)|value<<4)
}
func (o *TAMP_Type) GetATCR1_TAMP5AM() uint32 {
	return (volatile.LoadUint32(&o.ATCR1.Reg) & 0x10) >> 4
}
func (o *TAMP_Type) SetATCR1_TAMP6AM(value uint32) {
	volatile.StoreUint32(&o.ATCR1.Reg, volatile.LoadUint32(&o.ATCR1.Reg)&^(0x20)|value<<5)
}
func (o *TAMP_Type) GetATCR1_TAMP6AM() uint32 {
	return (volatile.LoadUint32(&o.ATCR1.Reg) & 0x20) >> 5
}
func (o *TAMP_Type) SetATCR1_TAMP7AM(value uint32) {
	volatile.StoreUint32(&o.ATCR1.Reg, volatile.LoadUint32(&o.ATCR1.Reg)&^(0x40)|value<<6)
}
func (o *TAMP_Type) GetATCR1_TAMP7AM() uint32 {
	return (volatile.LoadUint32(&o.ATCR1.Reg) & 0x40) >> 6
}
func (o *TAMP_Type) SetATCR1_TAMP8AM(value uint32) {
	volatile.StoreUint32(&o.ATCR1.Reg, volatile.LoadUint32(&o.ATCR1.Reg)&^(0x80)|value<<7)
}
func (o *TAMP_Type) GetATCR1_TAMP8AM() uint32 {
	return (volatile.LoadUint32(&o.ATCR1.Reg) & 0x80) >> 7
}
func (o *TAMP_Type) SetATCR1_ATOSEL1(value uint32) {
	volatile.StoreUint32(&o.ATCR1.Reg, volatile.LoadUint32(&o.ATCR1.Reg)&^(0x300)|value<<8)
}
func (o *TAMP_Type) GetATCR1_ATOSEL1() uint32 {
	return (volatile.LoadUint32(&o.ATCR1.Reg) & 0x300) >> 8
}
func (o *TAMP_Type) SetATCR1_ATOSEL2(value uint32) {
	volatile.StoreUint32(&o.ATCR1.Reg, volatile.LoadUint32(&o.ATCR1.Reg)&^(0xc00)|value<<10)
}
func (o *TAMP_Type) GetATCR1_ATOSEL2() uint32 {
	return (volatile.LoadUint32(&o.ATCR1.Reg) & 0xc00) >> 10
}
func (o *TAMP_Type) SetATCR1_ATOSEL3(value uint32) {
	volatile.StoreUint32(&o.ATCR1.Reg, volatile.LoadUint32(&o.ATCR1.Reg)&^(0x3000)|value<<12)
}
func (o *TAMP_Type) GetATCR1_ATOSEL3() uint32 {
	return (volatile.LoadUint32(&o.ATCR1.Reg) & 0x3000) >> 12
}
func (o *TAMP_Type) SetATCR1_ATOSEL4(value uint32) {
	volatile.StoreUint32(&o.ATCR1.Reg, volatile.LoadUint32(&o.ATCR1.Reg)&^(0xc000)|value<<14)
}
func (o *TAMP_Type) GetATCR1_ATOSEL4() uint32 {
	return (volatile.LoadUint32(&o.ATCR1.Reg) & 0xc000) >> 14
}
func (o *TAMP_Type) SetATCR1_ATCKSEL(value uint32) {
	volatile.StoreUint32(&o.ATCR1.Reg, volatile.LoadUint32(&o.ATCR1.Reg)&^(0x30000)|value<<16)
}
func (o *TAMP_Type) GetATCR1_ATCKSEL() uint32 {
	return (volatile.LoadUint32(&o.ATCR1.Reg) & 0x30000) >> 16
}
func (o *TAMP_Type) SetATCR1_ATPER(value uint32) {
	volatile.StoreUint32(&o.ATCR1.Reg, volatile.LoadUint32(&o.ATCR1.Reg)&^(0x3000000)|value<<24)
}
func (o *TAMP_Type) GetATCR1_ATPER() uint32 {
	return (volatile.LoadUint32(&o.ATCR1.Reg) & 0x3000000) >> 24
}
func (o *TAMP_Type) SetATCR1_ATOSHARE(value uint32) {
	volatile.StoreUint32(&o.ATCR1.Reg, volatile.LoadUint32(&o.ATCR1.Reg)&^(0x40000000)|value<<30)
}
func (o *TAMP_Type) GetATCR1_ATOSHARE() uint32 {
	return (volatile.LoadUint32(&o.ATCR1.Reg) & 0x40000000) >> 30
}
func (o *TAMP_Type) SetATCR1_FLTEN(value uint32) {
	volatile.StoreUint32(&o.ATCR1.Reg, volatile.LoadUint32(&o.ATCR1.Reg)&^(0x80000000)|value<<31)
}
func (o *TAMP_Type) GetATCR1_FLTEN() uint32 {
	return (volatile.LoadUint32(&o.ATCR1.Reg) & 0x80000000) >> 31
}

// TAMP.ATSEEDR: TAMP active tamper seed register
func (o *TAMP_Type) SetATSEEDR(value uint32) {
	volatile.StoreUint32(&o.ATSEEDR.Reg, value)
}
func (o *TAMP_Type) GetATSEEDR() uint32 {
	return volatile.LoadUint32(&o.ATSEEDR.Reg)
}

// TAMP.ATOR: TAMP active tamper output register
func (o *TAMP_Type) SetATOR_PRNG(value uint32) {
	volatile.StoreUint32(&o.ATOR.Reg, volatile.LoadUint32(&o.ATOR.Reg)&^(0xff)|value)
}
func (o *TAMP_Type) GetATOR_PRNG() uint32 {
	return volatile.LoadUint32(&o.ATOR.Reg) & 0xff
}
func (o *TAMP_Type) SetATOR_SEEDF(value uint32) {
	volatile.StoreUint32(&o.ATOR.Reg, volatile.LoadUint32(&o.ATOR.Reg)&^(0x4000)|value<<14)
}
func (o *TAMP_Type) GetATOR_SEEDF() uint32 {
	return (volatile.LoadUint32(&o.ATOR.Reg) & 0x4000) >> 14
}
func (o *TAMP_Type) SetATOR_INITS(value uint32) {
	volatile.StoreUint32(&o.ATOR.Reg, volatile.LoadUint32(&o.ATOR.Reg)&^(0x8000)|value<<15)
}
func (o *TAMP_Type) GetATOR_INITS() uint32 {
	return (volatile.LoadUint32(&o.ATOR.Reg) & 0x8000) >> 15
}

// TAMP.ATCR2: TAMP active tamper control register 2
func (o *TAMP_Type) SetATCR2_ATOSEL1(value uint32) {
	volatile.StoreUint32(&o.ATCR2.Reg, volatile.LoadUint32(&o.ATCR2.Reg)&^(0x700)|value<<8)
}
func (o *TAMP_Type) GetATCR2_ATOSEL1() uint32 {
	return (volatile.LoadUint32(&o.ATCR2.Reg) & 0x700) >> 8
}
func (o *TAMP_Type) SetATCR2_ATOSEL2(value uint32) {
	volatile.StoreUint32(&o.ATCR2.Reg, volatile.LoadUint32(&o.ATCR2.Reg)&^(0x3800)|value<<11)
}
func (o *TAMP_Type) GetATCR2_ATOSEL2() uint32 {
	return (volatile.LoadUint32(&o.ATCR2.Reg) & 0x3800) >> 11
}
func (o *TAMP_Type) SetATCR2_ATOSEL3(value uint32) {
	volatile.StoreUint32(&o.ATCR2.Reg, volatile.LoadUint32(&o.ATCR2.Reg)&^(0x1c000)|value<<14)
}
func (o *TAMP_Type) GetATCR2_ATOSEL3() uint32 {
	return (volatile.LoadUint32(&o.ATCR2.Reg) & 0x1c000) >> 14
}
func (o *TAMP_Type) SetATCR2_ATOSEL4(value uint32) {
	volatile.StoreUint32(&o.ATCR2.Reg, volatile.LoadUint32(&o.ATCR2.Reg)&^(0xe0000)|value<<17)
}
func (o *TAMP_Type) GetATCR2_ATOSEL4() uint32 {
	return (volatile.LoadUint32(&o.ATCR2.Reg) & 0xe0000) >> 17
}
func (o *TAMP_Type) SetATCR2_ATOSEL5(value uint32) {
	volatile.StoreUint32(&o.ATCR2.Reg, volatile.LoadUint32(&o.ATCR2.Reg)&^(0x700000)|value<<20)
}
func (o *TAMP_Type) GetATCR2_ATOSEL5() uint32 {
	return (volatile.LoadUint32(&o.ATCR2.Reg) & 0x700000) >> 20
}
func (o *TAMP_Type) SetATCR2_ATOSEL6(value uint32) {
	volatile.StoreUint32(&o.ATCR2.Reg, volatile.LoadUint32(&o.ATCR2.Reg)&^(0x3800000)|value<<23)
}
func (o *TAMP_Type) GetATCR2_ATOSEL6() uint32 {
	return (volatile.LoadUint32(&o.ATCR2.Reg) & 0x3800000) >> 23
}
func (o *TAMP_Type) SetATCR2_ATOSEL7(value uint32) {
	volatile.StoreUint32(&o.ATCR2.Reg, volatile.LoadUint32(&o.ATCR2.Reg)&^(0x1c000000)|value<<26)
}
func (o *TAMP_Type) GetATCR2_ATOSEL7() uint32 {
	return (volatile.LoadUint32(&o.ATCR2.Reg) & 0x1c000000) >> 26
}
func (o *TAMP_Type) SetATCR2_ATOSEL8(value uint32) {
	volatile.StoreUint32(&o.ATCR2.Reg, volatile.LoadUint32(&o.ATCR2.Reg)&^(0xe0000000)|value<<29)
}
func (o *TAMP_Type) GetATCR2_ATOSEL8() uint32 {
	return (volatile.LoadUint32(&o.ATCR2.Reg) & 0xe0000000) >> 29
}

// TAMP.SMCR: TAMP secure mode register
func (o *TAMP_Type) SetSMCR_BKPRWDPROT(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0xff)|value)
}
func (o *TAMP_Type) GetSMCR_BKPRWDPROT() uint32 {
	return volatile.LoadUint32(&o.SMCR.Reg) & 0xff
}
func (o *TAMP_Type) SetSMCR_BKPWDPROT(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0xff0000)|value<<16)
}
func (o *TAMP_Type) GetSMCR_BKPWDPROT() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0xff0000) >> 16
}
func (o *TAMP_Type) SetSMCR_TAMPDPROT(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x80000000)|value<<31)
}
func (o *TAMP_Type) GetSMCR_TAMPDPROT() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x80000000) >> 31
}

// TAMP.PRIVCR: TAMP privilege mode control register
func (o *TAMP_Type) SetPRIVCR_BKPRWPRIV(value uint32) {
	volatile.StoreUint32(&o.PRIVCR.Reg, volatile.LoadUint32(&o.PRIVCR.Reg)&^(0x20000000)|value<<29)
}
func (o *TAMP_Type) GetPRIVCR_BKPRWPRIV() uint32 {
	return (volatile.LoadUint32(&o.PRIVCR.Reg) & 0x20000000) >> 29
}
func (o *TAMP_Type) SetPRIVCR_BKPWPRIV(value uint32) {
	volatile.StoreUint32(&o.PRIVCR.Reg, volatile.LoadUint32(&o.PRIVCR.Reg)&^(0x40000000)|value<<30)
}
func (o *TAMP_Type) GetPRIVCR_BKPWPRIV() uint32 {
	return (volatile.LoadUint32(&o.PRIVCR.Reg) & 0x40000000) >> 30
}
func (o *TAMP_Type) SetPRIVCR_TAMPPRIV(value uint32) {
	volatile.StoreUint32(&o.PRIVCR.Reg, volatile.LoadUint32(&o.PRIVCR.Reg)&^(0x80000000)|value<<31)
}
func (o *TAMP_Type) GetPRIVCR_TAMPPRIV() uint32 {
	return (volatile.LoadUint32(&o.PRIVCR.Reg) & 0x80000000) >> 31
}

// TAMP.IER: TAMP interrupt enable register
func (o *TAMP_Type) SetIER_TAMP1IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *TAMP_Type) GetIER_TAMP1IE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *TAMP_Type) SetIER_TAMP2IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *TAMP_Type) GetIER_TAMP2IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *TAMP_Type) SetIER_TAMP3IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *TAMP_Type) GetIER_TAMP3IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *TAMP_Type) SetIER_TAMP4IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *TAMP_Type) GetIER_TAMP4IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *TAMP_Type) SetIER_TAMP5IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *TAMP_Type) GetIER_TAMP5IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *TAMP_Type) SetIER_TAMP6IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *TAMP_Type) GetIER_TAMP6IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *TAMP_Type) SetIER_TAMP7IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *TAMP_Type) GetIER_TAMP7IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *TAMP_Type) SetIER_TAMP8IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *TAMP_Type) GetIER_TAMP8IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *TAMP_Type) SetIER_ITAMP1IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *TAMP_Type) GetIER_ITAMP1IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *TAMP_Type) SetIER_ITAMP2IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000)|value<<17)
}
func (o *TAMP_Type) GetIER_ITAMP2IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000) >> 17
}
func (o *TAMP_Type) SetIER_ITAMP3IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000)|value<<18)
}
func (o *TAMP_Type) GetIER_ITAMP3IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000) >> 18
}
func (o *TAMP_Type) SetIER_ITAMP5IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100000)|value<<20)
}
func (o *TAMP_Type) GetIER_ITAMP5IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100000) >> 20
}
func (o *TAMP_Type) SetIER_ITAMP8IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800000)|value<<23)
}
func (o *TAMP_Type) GetIER_ITAMP8IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800000) >> 23
}

// TAMP.SR: TAMP status register
func (o *TAMP_Type) SetSR_TAMP1F(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *TAMP_Type) GetSR_TAMP1F() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *TAMP_Type) SetSR_TAMP2F(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *TAMP_Type) GetSR_TAMP2F() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *TAMP_Type) SetSR_TAMP3F(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *TAMP_Type) GetSR_TAMP3F() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *TAMP_Type) SetSR_TAMP4F(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *TAMP_Type) GetSR_TAMP4F() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *TAMP_Type) SetSR_TAMP5F(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *TAMP_Type) GetSR_TAMP5F() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *TAMP_Type) SetSR_TAMP6F(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *TAMP_Type) GetSR_TAMP6F() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *TAMP_Type) SetSR_TAMP7F(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *TAMP_Type) GetSR_TAMP7F() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *TAMP_Type) SetSR_TAMP8F(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *TAMP_Type) GetSR_TAMP8F() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *TAMP_Type) SetSR_ITAMP1F(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *TAMP_Type) GetSR_ITAMP1F() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *TAMP_Type) SetSR_ITAMP2F(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *TAMP_Type) GetSR_ITAMP2F() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}
func (o *TAMP_Type) SetSR_ITAMP3F(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000)|value<<18)
}
func (o *TAMP_Type) GetSR_ITAMP3F() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000) >> 18
}
func (o *TAMP_Type) SetSR_ITAMP5F(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100000)|value<<20)
}
func (o *TAMP_Type) GetSR_ITAMP5F() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100000) >> 20
}
func (o *TAMP_Type) SetSR_ITAMP8F(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800000)|value<<23)
}
func (o *TAMP_Type) GetSR_ITAMP8F() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800000) >> 23
}

// TAMP.MISR: TAMP masked interrupt status register
func (o *TAMP_Type) SetMISR_TAMP1MF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x1)|value)
}
func (o *TAMP_Type) GetMISR_TAMP1MF() uint32 {
	return volatile.LoadUint32(&o.MISR.Reg) & 0x1
}
func (o *TAMP_Type) SetMISR_TAMP2MF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x2)|value<<1)
}
func (o *TAMP_Type) GetMISR_TAMP2MF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x2) >> 1
}
func (o *TAMP_Type) SetMISR_TAMP3MF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x4)|value<<2)
}
func (o *TAMP_Type) GetMISR_TAMP3MF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x4) >> 2
}
func (o *TAMP_Type) SetMISR_TAMP4MF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x8)|value<<3)
}
func (o *TAMP_Type) GetMISR_TAMP4MF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x8) >> 3
}
func (o *TAMP_Type) SetMISR_TAMP5MF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x10)|value<<4)
}
func (o *TAMP_Type) GetMISR_TAMP5MF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x10) >> 4
}
func (o *TAMP_Type) SetMISR_TAMP6MF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x20)|value<<5)
}
func (o *TAMP_Type) GetMISR_TAMP6MF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x20) >> 5
}
func (o *TAMP_Type) SetMISR_TAMP7MF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x40)|value<<6)
}
func (o *TAMP_Type) GetMISR_TAMP7MF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x40) >> 6
}
func (o *TAMP_Type) SetMISR_TAMP8MF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x80)|value<<7)
}
func (o *TAMP_Type) GetMISR_TAMP8MF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x80) >> 7
}
func (o *TAMP_Type) SetMISR_ITAMP1MF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x10000)|value<<16)
}
func (o *TAMP_Type) GetMISR_ITAMP1MF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x10000) >> 16
}
func (o *TAMP_Type) SetMISR_ITAMP2MF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x20000)|value<<17)
}
func (o *TAMP_Type) GetMISR_ITAMP2MF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x20000) >> 17
}
func (o *TAMP_Type) SetMISR_ITAMP3MF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x40000)|value<<18)
}
func (o *TAMP_Type) GetMISR_ITAMP3MF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x40000) >> 18
}
func (o *TAMP_Type) SetMISR_ITAMP5MF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x100000)|value<<20)
}
func (o *TAMP_Type) GetMISR_ITAMP5MF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x100000) >> 20
}
func (o *TAMP_Type) SetMISR_ITAMP8MF(value uint32) {
	volatile.StoreUint32(&o.MISR.Reg, volatile.LoadUint32(&o.MISR.Reg)&^(0x800000)|value<<23)
}
func (o *TAMP_Type) GetMISR_ITAMP8MF() uint32 {
	return (volatile.LoadUint32(&o.MISR.Reg) & 0x800000) >> 23
}

// TAMP.SMISR: TAMP secure masked interrupt status register
func (o *TAMP_Type) SetSMISR_TAMP1MF(value uint32) {
	volatile.StoreUint32(&o.SMISR.Reg, volatile.LoadUint32(&o.SMISR.Reg)&^(0x1)|value)
}
func (o *TAMP_Type) GetSMISR_TAMP1MF() uint32 {
	return volatile.LoadUint32(&o.SMISR.Reg) & 0x1
}
func (o *TAMP_Type) SetSMISR_TAMP2MF(value uint32) {
	volatile.StoreUint32(&o.SMISR.Reg, volatile.LoadUint32(&o.SMISR.Reg)&^(0x2)|value<<1)
}
func (o *TAMP_Type) GetSMISR_TAMP2MF() uint32 {
	return (volatile.LoadUint32(&o.SMISR.Reg) & 0x2) >> 1
}
func (o *TAMP_Type) SetSMISR_TAMP3MF(value uint32) {
	volatile.StoreUint32(&o.SMISR.Reg, volatile.LoadUint32(&o.SMISR.Reg)&^(0x4)|value<<2)
}
func (o *TAMP_Type) GetSMISR_TAMP3MF() uint32 {
	return (volatile.LoadUint32(&o.SMISR.Reg) & 0x4) >> 2
}
func (o *TAMP_Type) SetSMISR_TAMP4MF(value uint32) {
	volatile.StoreUint32(&o.SMISR.Reg, volatile.LoadUint32(&o.SMISR.Reg)&^(0x8)|value<<3)
}
func (o *TAMP_Type) GetSMISR_TAMP4MF() uint32 {
	return (volatile.LoadUint32(&o.SMISR.Reg) & 0x8) >> 3
}
func (o *TAMP_Type) SetSMISR_TAMP5MF(value uint32) {
	volatile.StoreUint32(&o.SMISR.Reg, volatile.LoadUint32(&o.SMISR.Reg)&^(0x10)|value<<4)
}
func (o *TAMP_Type) GetSMISR_TAMP5MF() uint32 {
	return (volatile.LoadUint32(&o.SMISR.Reg) & 0x10) >> 4
}
func (o *TAMP_Type) SetSMISR_TAMP6MF(value uint32) {
	volatile.StoreUint32(&o.SMISR.Reg, volatile.LoadUint32(&o.SMISR.Reg)&^(0x20)|value<<5)
}
func (o *TAMP_Type) GetSMISR_TAMP6MF() uint32 {
	return (volatile.LoadUint32(&o.SMISR.Reg) & 0x20) >> 5
}
func (o *TAMP_Type) SetSMISR_TAMP7MF(value uint32) {
	volatile.StoreUint32(&o.SMISR.Reg, volatile.LoadUint32(&o.SMISR.Reg)&^(0x40)|value<<6)
}
func (o *TAMP_Type) GetSMISR_TAMP7MF() uint32 {
	return (volatile.LoadUint32(&o.SMISR.Reg) & 0x40) >> 6
}
func (o *TAMP_Type) SetSMISR_TAMP8MF(value uint32) {
	volatile.StoreUint32(&o.SMISR.Reg, volatile.LoadUint32(&o.SMISR.Reg)&^(0x80)|value<<7)
}
func (o *TAMP_Type) GetSMISR_TAMP8MF() uint32 {
	return (volatile.LoadUint32(&o.SMISR.Reg) & 0x80) >> 7
}
func (o *TAMP_Type) SetSMISR_ITAMP1MF(value uint32) {
	volatile.StoreUint32(&o.SMISR.Reg, volatile.LoadUint32(&o.SMISR.Reg)&^(0x10000)|value<<16)
}
func (o *TAMP_Type) GetSMISR_ITAMP1MF() uint32 {
	return (volatile.LoadUint32(&o.SMISR.Reg) & 0x10000) >> 16
}
func (o *TAMP_Type) SetSMISR_ITAMP2MF(value uint32) {
	volatile.StoreUint32(&o.SMISR.Reg, volatile.LoadUint32(&o.SMISR.Reg)&^(0x20000)|value<<17)
}
func (o *TAMP_Type) GetSMISR_ITAMP2MF() uint32 {
	return (volatile.LoadUint32(&o.SMISR.Reg) & 0x20000) >> 17
}
func (o *TAMP_Type) SetSMISR_ITAMP3MF(value uint32) {
	volatile.StoreUint32(&o.SMISR.Reg, volatile.LoadUint32(&o.SMISR.Reg)&^(0x40000)|value<<18)
}
func (o *TAMP_Type) GetSMISR_ITAMP3MF() uint32 {
	return (volatile.LoadUint32(&o.SMISR.Reg) & 0x40000) >> 18
}
func (o *TAMP_Type) SetSMISR_ITAMP5MF(value uint32) {
	volatile.StoreUint32(&o.SMISR.Reg, volatile.LoadUint32(&o.SMISR.Reg)&^(0x100000)|value<<20)
}
func (o *TAMP_Type) GetSMISR_ITAMP5MF() uint32 {
	return (volatile.LoadUint32(&o.SMISR.Reg) & 0x100000) >> 20
}
func (o *TAMP_Type) SetSMISR_ITAMP8MF(value uint32) {
	volatile.StoreUint32(&o.SMISR.Reg, volatile.LoadUint32(&o.SMISR.Reg)&^(0x800000)|value<<23)
}
func (o *TAMP_Type) GetSMISR_ITAMP8MF() uint32 {
	return (volatile.LoadUint32(&o.SMISR.Reg) & 0x800000) >> 23
}

// TAMP.SCR: TAMP status clear register
func (o *TAMP_Type) SetSCR_CTAMP1F(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x1)|value)
}
func (o *TAMP_Type) GetSCR_CTAMP1F() uint32 {
	return volatile.LoadUint32(&o.SCR.Reg) & 0x1
}
func (o *TAMP_Type) SetSCR_CTAMP2F(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x2)|value<<1)
}
func (o *TAMP_Type) GetSCR_CTAMP2F() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x2) >> 1
}
func (o *TAMP_Type) SetSCR_CTAMP3F(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x4)|value<<2)
}
func (o *TAMP_Type) GetSCR_CTAMP3F() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x4) >> 2
}
func (o *TAMP_Type) SetSCR_CTAMP4F(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x8)|value<<3)
}
func (o *TAMP_Type) GetSCR_CTAMP4F() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x8) >> 3
}
func (o *TAMP_Type) SetSCR_CTAMP5F(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x10)|value<<4)
}
func (o *TAMP_Type) GetSCR_CTAMP5F() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x10) >> 4
}
func (o *TAMP_Type) SetSCR_CTAMP6F(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x20)|value<<5)
}
func (o *TAMP_Type) GetSCR_CTAMP6F() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x20) >> 5
}
func (o *TAMP_Type) SetSCR_CTAMP7F(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x40)|value<<6)
}
func (o *TAMP_Type) GetSCR_CTAMP7F() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x40) >> 6
}
func (o *TAMP_Type) SetSCR_CTAMP8F(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x80)|value<<7)
}
func (o *TAMP_Type) GetSCR_CTAMP8F() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x80) >> 7
}
func (o *TAMP_Type) SetSCR_CITAMP1F(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x10000)|value<<16)
}
func (o *TAMP_Type) GetSCR_CITAMP1F() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x10000) >> 16
}
func (o *TAMP_Type) SetSCR_CITAMP2F(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x20000)|value<<17)
}
func (o *TAMP_Type) GetSCR_CITAMP2F() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x20000) >> 17
}
func (o *TAMP_Type) SetSCR_CITAMP3F(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x40000)|value<<18)
}
func (o *TAMP_Type) GetSCR_CITAMP3F() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x40000) >> 18
}
func (o *TAMP_Type) SetSCR_CITAMP5F(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x100000)|value<<20)
}
func (o *TAMP_Type) GetSCR_CITAMP5F() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x100000) >> 20
}
func (o *TAMP_Type) SetSCR_CITAMP8F(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x800000)|value<<23)
}
func (o *TAMP_Type) GetSCR_CITAMP8F() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x800000) >> 23
}

// TAMP.COUNTR: TAMP monotonic counter register
func (o *TAMP_Type) SetCOUNTR(value uint32) {
	volatile.StoreUint32(&o.COUNTR.Reg, value)
}
func (o *TAMP_Type) GetCOUNTR() uint32 {
	return volatile.LoadUint32(&o.COUNTR.Reg)
}

// TAMP.CFGR: TAMP configuration register
func (o *TAMP_Type) SetCFGR_TMONEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x2)|value<<1)
}
func (o *TAMP_Type) GetCFGR_TMONEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x2) >> 1
}
func (o *TAMP_Type) SetCFGR_VMONEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x4)|value<<2)
}
func (o *TAMP_Type) GetCFGR_VMONEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x4) >> 2
}
func (o *TAMP_Type) SetCFGR_WUTMONEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x8)|value<<3)
}
func (o *TAMP_Type) GetCFGR_WUTMONEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x8) >> 3
}

// TAMP.BKP0R: TAMP backup register
func (o *TAMP_Type) SetBKP0R(value uint32) {
	volatile.StoreUint32(&o.BKP0R.Reg, value)
}
func (o *TAMP_Type) GetBKP0R() uint32 {
	return volatile.LoadUint32(&o.BKP0R.Reg)
}

// TAMP.BKP1R: TAMP backup register
func (o *TAMP_Type) SetBKP1R(value uint32) {
	volatile.StoreUint32(&o.BKP1R.Reg, value)
}
func (o *TAMP_Type) GetBKP1R() uint32 {
	return volatile.LoadUint32(&o.BKP1R.Reg)
}

// TAMP.BKP2R: TAMP backup register
func (o *TAMP_Type) SetBKP2R(value uint32) {
	volatile.StoreUint32(&o.BKP2R.Reg, value)
}
func (o *TAMP_Type) GetBKP2R() uint32 {
	return volatile.LoadUint32(&o.BKP2R.Reg)
}

// TAMP.BKP3R: TAMP backup register
func (o *TAMP_Type) SetBKP3R(value uint32) {
	volatile.StoreUint32(&o.BKP3R.Reg, value)
}
func (o *TAMP_Type) GetBKP3R() uint32 {
	return volatile.LoadUint32(&o.BKP3R.Reg)
}

// TAMP.BKP4R: TAMP backup register
func (o *TAMP_Type) SetBKP4R(value uint32) {
	volatile.StoreUint32(&o.BKP4R.Reg, value)
}
func (o *TAMP_Type) GetBKP4R() uint32 {
	return volatile.LoadUint32(&o.BKP4R.Reg)
}

// TAMP.BKP5R: TAMP backup register
func (o *TAMP_Type) SetBKP5R(value uint32) {
	volatile.StoreUint32(&o.BKP5R.Reg, value)
}
func (o *TAMP_Type) GetBKP5R() uint32 {
	return volatile.LoadUint32(&o.BKP5R.Reg)
}

// TAMP.BKP6R: TAMP backup register
func (o *TAMP_Type) SetBKP6R(value uint32) {
	volatile.StoreUint32(&o.BKP6R.Reg, value)
}
func (o *TAMP_Type) GetBKP6R() uint32 {
	return volatile.LoadUint32(&o.BKP6R.Reg)
}

// TAMP.BKP7R: TAMP backup register
func (o *TAMP_Type) SetBKP7R(value uint32) {
	volatile.StoreUint32(&o.BKP7R.Reg, value)
}
func (o *TAMP_Type) GetBKP7R() uint32 {
	return volatile.LoadUint32(&o.BKP7R.Reg)
}

// TAMP.BKP8R: TAMP backup register
func (o *TAMP_Type) SetBKP8R(value uint32) {
	volatile.StoreUint32(&o.BKP8R.Reg, value)
}
func (o *TAMP_Type) GetBKP8R() uint32 {
	return volatile.LoadUint32(&o.BKP8R.Reg)
}

// TAMP.BKP9R: TAMP backup register
func (o *TAMP_Type) SetBKP9R(value uint32) {
	volatile.StoreUint32(&o.BKP9R.Reg, value)
}
func (o *TAMP_Type) GetBKP9R() uint32 {
	return volatile.LoadUint32(&o.BKP9R.Reg)
}

// TAMP.BKP10R: TAMP backup register
func (o *TAMP_Type) SetBKP10R(value uint32) {
	volatile.StoreUint32(&o.BKP10R.Reg, value)
}
func (o *TAMP_Type) GetBKP10R() uint32 {
	return volatile.LoadUint32(&o.BKP10R.Reg)
}

// TAMP.BKP11R: TAMP backup register
func (o *TAMP_Type) SetBKP11R(value uint32) {
	volatile.StoreUint32(&o.BKP11R.Reg, value)
}
func (o *TAMP_Type) GetBKP11R() uint32 {
	return volatile.LoadUint32(&o.BKP11R.Reg)
}

// TAMP.BKP12R: TAMP backup register
func (o *TAMP_Type) SetBKP12R(value uint32) {
	volatile.StoreUint32(&o.BKP12R.Reg, value)
}
func (o *TAMP_Type) GetBKP12R() uint32 {
	return volatile.LoadUint32(&o.BKP12R.Reg)
}

// TAMP.BKP13R: TAMP backup register
func (o *TAMP_Type) SetBKP13R(value uint32) {
	volatile.StoreUint32(&o.BKP13R.Reg, value)
}
func (o *TAMP_Type) GetBKP13R() uint32 {
	return volatile.LoadUint32(&o.BKP13R.Reg)
}

// TAMP.BKP14R: TAMP backup register
func (o *TAMP_Type) SetBKP14R(value uint32) {
	volatile.StoreUint32(&o.BKP14R.Reg, value)
}
func (o *TAMP_Type) GetBKP14R() uint32 {
	return volatile.LoadUint32(&o.BKP14R.Reg)
}

// TAMP.BKP15R: TAMP backup register
func (o *TAMP_Type) SetBKP15R(value uint32) {
	volatile.StoreUint32(&o.BKP15R.Reg, value)
}
func (o *TAMP_Type) GetBKP15R() uint32 {
	return volatile.LoadUint32(&o.BKP15R.Reg)
}

// TAMP.BKP16R: TAMP backup register
func (o *TAMP_Type) SetBKP16R(value uint32) {
	volatile.StoreUint32(&o.BKP16R.Reg, value)
}
func (o *TAMP_Type) GetBKP16R() uint32 {
	return volatile.LoadUint32(&o.BKP16R.Reg)
}

// TAMP.BKP17R: TAMP backup register
func (o *TAMP_Type) SetBKP17R(value uint32) {
	volatile.StoreUint32(&o.BKP17R.Reg, value)
}
func (o *TAMP_Type) GetBKP17R() uint32 {
	return volatile.LoadUint32(&o.BKP17R.Reg)
}

// TAMP.BKP18R: TAMP backup register
func (o *TAMP_Type) SetBKP18R(value uint32) {
	volatile.StoreUint32(&o.BKP18R.Reg, value)
}
func (o *TAMP_Type) GetBKP18R() uint32 {
	return volatile.LoadUint32(&o.BKP18R.Reg)
}

// TAMP.BKP19R: TAMP backup register
func (o *TAMP_Type) SetBKP19R(value uint32) {
	volatile.StoreUint32(&o.BKP19R.Reg, value)
}
func (o *TAMP_Type) GetBKP19R() uint32 {
	return volatile.LoadUint32(&o.BKP19R.Reg)
}

// TAMP.BKP20R: TAMP backup register
func (o *TAMP_Type) SetBKP20R(value uint32) {
	volatile.StoreUint32(&o.BKP20R.Reg, value)
}
func (o *TAMP_Type) GetBKP20R() uint32 {
	return volatile.LoadUint32(&o.BKP20R.Reg)
}

// TAMP.BKP21R: TAMP backup register
func (o *TAMP_Type) SetBKP21R(value uint32) {
	volatile.StoreUint32(&o.BKP21R.Reg, value)
}
func (o *TAMP_Type) GetBKP21R() uint32 {
	return volatile.LoadUint32(&o.BKP21R.Reg)
}

// TAMP.BKP22R: TAMP backup register
func (o *TAMP_Type) SetBKP22R(value uint32) {
	volatile.StoreUint32(&o.BKP22R.Reg, value)
}
func (o *TAMP_Type) GetBKP22R() uint32 {
	return volatile.LoadUint32(&o.BKP22R.Reg)
}

// TAMP.BKP23R: TAMP backup register
func (o *TAMP_Type) SetBKP23R(value uint32) {
	volatile.StoreUint32(&o.BKP23R.Reg, value)
}
func (o *TAMP_Type) GetBKP23R() uint32 {
	return volatile.LoadUint32(&o.BKP23R.Reg)
}

// TAMP.BKP24R: TAMP backup register
func (o *TAMP_Type) SetBKP24R(value uint32) {
	volatile.StoreUint32(&o.BKP24R.Reg, value)
}
func (o *TAMP_Type) GetBKP24R() uint32 {
	return volatile.LoadUint32(&o.BKP24R.Reg)
}

// TAMP.BKP25R: TAMP backup register
func (o *TAMP_Type) SetBKP25R(value uint32) {
	volatile.StoreUint32(&o.BKP25R.Reg, value)
}
func (o *TAMP_Type) GetBKP25R() uint32 {
	return volatile.LoadUint32(&o.BKP25R.Reg)
}

// TAMP.BKP26R: TAMP backup register
func (o *TAMP_Type) SetBKP26R(value uint32) {
	volatile.StoreUint32(&o.BKP26R.Reg, value)
}
func (o *TAMP_Type) GetBKP26R() uint32 {
	return volatile.LoadUint32(&o.BKP26R.Reg)
}

// TAMP.BKP27R: TAMP backup register
func (o *TAMP_Type) SetBKP27R(value uint32) {
	volatile.StoreUint32(&o.BKP27R.Reg, value)
}
func (o *TAMP_Type) GetBKP27R() uint32 {
	return volatile.LoadUint32(&o.BKP27R.Reg)
}

// TAMP.BKP28R: TAMP backup register
func (o *TAMP_Type) SetBKP28R(value uint32) {
	volatile.StoreUint32(&o.BKP28R.Reg, value)
}
func (o *TAMP_Type) GetBKP28R() uint32 {
	return volatile.LoadUint32(&o.BKP28R.Reg)
}

// TAMP.BKP29R: TAMP backup register
func (o *TAMP_Type) SetBKP29R(value uint32) {
	volatile.StoreUint32(&o.BKP29R.Reg, value)
}
func (o *TAMP_Type) GetBKP29R() uint32 {
	return volatile.LoadUint32(&o.BKP29R.Reg)
}

// TAMP.BKP30R: TAMP backup register
func (o *TAMP_Type) SetBKP30R(value uint32) {
	volatile.StoreUint32(&o.BKP30R.Reg, value)
}
func (o *TAMP_Type) GetBKP30R() uint32 {
	return volatile.LoadUint32(&o.BKP30R.Reg)
}

// TAMP.BKP31R: TAMP backup register
func (o *TAMP_Type) SetBKP31R(value uint32) {
	volatile.StoreUint32(&o.BKP31R.Reg, value)
}
func (o *TAMP_Type) GetBKP31R() uint32 {
	return volatile.LoadUint32(&o.BKP31R.Reg)
}

// Inter-integrated circuit
type I2C_Type struct {
	CR1      volatile.Register32 // 0x0
	CR2      volatile.Register32 // 0x4
	OAR1     volatile.Register32 // 0x8
	OAR2     volatile.Register32 // 0xC
	TIMINGR  volatile.Register32 // 0x10
	TIMEOUTR volatile.Register32 // 0x14
	ISR      volatile.Register32 // 0x18
	ICR      volatile.Register32 // 0x1C
	PECR     volatile.Register32 // 0x20
	RXDR     volatile.Register32 // 0x24
	TXDR     volatile.Register32 // 0x28
}

// I2C.CR1: Control register 1
func (o *I2C_Type) SetCR1_PE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetCR1_PE() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}
func (o *I2C_Type) SetCR1_TXIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetCR1_TXIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetCR1_RXIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetCR1_RXIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetCR1_ADDRIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetCR1_ADDRIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetCR1_NACKIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetCR1_NACKIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetCR1_STOPIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetCR1_STOPIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetCR1_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetCR1_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetCR1_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetCR1_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetCR1_DNF(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xf00)|value<<8)
}
func (o *I2C_Type) GetCR1_DNF() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xf00) >> 8
}
func (o *I2C_Type) SetCR1_ANFOFF(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetCR1_ANFOFF() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetCR1_TXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetCR1_TXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetCR1_RXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetCR1_RXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetCR1_SBC(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetCR1_SBC() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10000) >> 16
}
func (o *I2C_Type) SetCR1_NOSTRETCH(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20000)|value<<17)
}
func (o *I2C_Type) GetCR1_NOSTRETCH() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20000) >> 17
}
func (o *I2C_Type) SetCR1_WUPEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40000)|value<<18)
}
func (o *I2C_Type) GetCR1_WUPEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40000) >> 18
}
func (o *I2C_Type) SetCR1_GCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80000)|value<<19)
}
func (o *I2C_Type) GetCR1_GCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80000) >> 19
}
func (o *I2C_Type) SetCR1_SMBHEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100000)|value<<20)
}
func (o *I2C_Type) GetCR1_SMBHEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100000) >> 20
}
func (o *I2C_Type) SetCR1_SMBDEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200000)|value<<21)
}
func (o *I2C_Type) GetCR1_SMBDEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200000) >> 21
}
func (o *I2C_Type) SetCR1_ALERTEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400000)|value<<22)
}
func (o *I2C_Type) GetCR1_ALERTEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400000) >> 22
}
func (o *I2C_Type) SetCR1_PECEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800000)|value<<23)
}
func (o *I2C_Type) GetCR1_PECEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800000) >> 23
}

// I2C.CR2: Control register 2
func (o *I2C_Type) SetCR2_PECBYTE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000000)|value<<26)
}
func (o *I2C_Type) GetCR2_PECBYTE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000000) >> 26
}
func (o *I2C_Type) SetCR2_AUTOEND(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000000)|value<<25)
}
func (o *I2C_Type) GetCR2_AUTOEND() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000000) >> 25
}
func (o *I2C_Type) SetCR2_RELOAD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000000)|value<<24)
}
func (o *I2C_Type) GetCR2_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000000) >> 24
}
func (o *I2C_Type) SetCR2_NBYTES(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xff0000)|value<<16)
}
func (o *I2C_Type) GetCR2_NBYTES() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xff0000) >> 16
}
func (o *I2C_Type) SetCR2_NACK(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetCR2_NACK() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetCR2_STOP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetCR2_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetCR2_START(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetCR2_START() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetCR2_HEAD10R(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetCR2_HEAD10R() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetCR2_ADD10(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetCR2_ADD10() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetCR2_RD_WRN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetCR2_RD_WRN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetCR2_SADD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetCR2_SADD() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x3ff
}

// I2C.OAR1: Own address register 1
func (o *I2C_Type) SetOAR1_OA1(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetOAR1_OA1() uint32 {
	return volatile.LoadUint32(&o.OAR1.Reg) & 0x3ff
}
func (o *I2C_Type) SetOAR1_OA1MODE(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetOAR1_OA1MODE() uint32 {
	return (volatile.LoadUint32(&o.OAR1.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetOAR1_OA1EN(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetOAR1_OA1EN() uint32 {
	return (volatile.LoadUint32(&o.OAR1.Reg) & 0x8000) >> 15
}

// I2C.OAR2: Own address register 2
func (o *I2C_Type) SetOAR2_OA2(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetOAR2_OA2() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetOAR2_OA2MSK(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0x700)|value<<8)
}
func (o *I2C_Type) GetOAR2_OA2MSK() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0x700) >> 8
}
func (o *I2C_Type) SetOAR2_OA2EN(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetOAR2_OA2EN() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0x8000) >> 15
}

// I2C.TIMINGR: Timing register
func (o *I2C_Type) SetTIMINGR_SCLL(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetTIMINGR_SCLL() uint32 {
	return volatile.LoadUint32(&o.TIMINGR.Reg) & 0xff
}
func (o *I2C_Type) SetTIMINGR_SCLH(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xff00)|value<<8)
}
func (o *I2C_Type) GetTIMINGR_SCLH() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xff00) >> 8
}
func (o *I2C_Type) SetTIMINGR_SDADEL(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xf0000)|value<<16)
}
func (o *I2C_Type) GetTIMINGR_SDADEL() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xf0000) >> 16
}
func (o *I2C_Type) SetTIMINGR_SCLDEL(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xf00000)|value<<20)
}
func (o *I2C_Type) GetTIMINGR_SCLDEL() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xf00000) >> 20
}
func (o *I2C_Type) SetTIMINGR_PRESC(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xf0000000)|value<<28)
}
func (o *I2C_Type) GetTIMINGR_PRESC() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xf0000000) >> 28
}

// I2C.TIMEOUTR: Status register 1
func (o *I2C_Type) SetTIMEOUTR_TIMEOUTA(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0xfff)|value)
}
func (o *I2C_Type) GetTIMEOUTR_TIMEOUTA() uint32 {
	return volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0xfff
}
func (o *I2C_Type) SetTIMEOUTR_TIDLE(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetTIMEOUTR_TIDLE() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetTIMEOUTR_TIMOUTEN(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetTIMEOUTR_TIMOUTEN() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetTIMEOUTR_TIMEOUTB(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0xfff0000)|value<<16)
}
func (o *I2C_Type) GetTIMEOUTR_TIMEOUTB() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0xfff0000) >> 16
}
func (o *I2C_Type) SetTIMEOUTR_TEXTEN(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetTIMEOUTR_TEXTEN() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0x80000000) >> 31
}

// I2C.ISR: Interrupt and Status register
func (o *I2C_Type) SetISR_ADDCODE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xfe0000)|value<<17)
}
func (o *I2C_Type) GetISR_ADDCODE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0xfe0000) >> 17
}
func (o *I2C_Type) SetISR_DIR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetISR_DIR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *I2C_Type) SetISR_BUSY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetISR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetISR_ALERT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetISR_ALERT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetISR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetISR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetISR_PECERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetISR_PECERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetISR_OVR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetISR_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetISR_ARLO(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetISR_ARLO() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetISR_BERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetISR_BERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetISR_TCR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetISR_TCR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetISR_TC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetISR_TC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetISR_STOPF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetISR_STOPF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetISR_NACKF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetISR_NACKF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetISR_ADDR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetISR_ADDR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetISR_RXNE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetISR_RXNE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetISR_TXIS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetISR_TXIS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetISR_TXE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetISR_TXE() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// I2C.ICR: Interrupt clear register
func (o *I2C_Type) SetICR_ALERTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetICR_ALERTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetICR_TIMOUTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetICR_TIMOUTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetICR_PECCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetICR_PECCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetICR_OVRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetICR_OVRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetICR_ARLOCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetICR_ARLOCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetICR_BERRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetICR_BERRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetICR_STOPCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetICR_STOPCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetICR_NACKCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetICR_NACKCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetICR_ADDRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetICR_ADDRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}

// I2C.PECR: PEC register
func (o *I2C_Type) SetPECR_PEC(value uint32) {
	volatile.StoreUint32(&o.PECR.Reg, volatile.LoadUint32(&o.PECR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetPECR_PEC() uint32 {
	return volatile.LoadUint32(&o.PECR.Reg) & 0xff
}

// I2C.RXDR: Receive data register
func (o *I2C_Type) SetRXDR_RXDATA(value uint32) {
	volatile.StoreUint32(&o.RXDR.Reg, volatile.LoadUint32(&o.RXDR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetRXDR_RXDATA() uint32 {
	return volatile.LoadUint32(&o.RXDR.Reg) & 0xff
}

// I2C.TXDR: Transmit data register
func (o *I2C_Type) SetTXDR_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXDR.Reg, volatile.LoadUint32(&o.TXDR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetTXDR_TXDATA() uint32 {
	return volatile.LoadUint32(&o.TXDR.Reg) & 0xff
}

// ICache
type ICache_Type struct {
	ICACHE_CR    volatile.Register32 // 0x0
	ICACHE_SR    volatile.Register32 // 0x4
	ICACHE_IER   volatile.Register32 // 0x8
	ICACHE_FCR   volatile.Register32 // 0xC
	ICACHE_HMONR volatile.Register32 // 0x10
	ICACHE_MMONR volatile.Register32 // 0x14
	_            [8]byte
	ICACHE_CRR0  volatile.Register32 // 0x20
	ICACHE_CRR1  volatile.Register32 // 0x24
	ICACHE_CRR2  volatile.Register32 // 0x28
	ICACHE_CRR3  volatile.Register32 // 0x2C
}

// ICache.ICACHE_CR: ICACHE control register
func (o *ICache_Type) SetICACHE_CR_EN(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CR.Reg, volatile.LoadUint32(&o.ICACHE_CR.Reg)&^(0x1)|value)
}
func (o *ICache_Type) GetICACHE_CR_EN() uint32 {
	return volatile.LoadUint32(&o.ICACHE_CR.Reg) & 0x1
}
func (o *ICache_Type) SetICACHE_CR_CACHEINV(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CR.Reg, volatile.LoadUint32(&o.ICACHE_CR.Reg)&^(0x2)|value<<1)
}
func (o *ICache_Type) GetICACHE_CR_CACHEINV() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_CR.Reg) & 0x2) >> 1
}
func (o *ICache_Type) SetICACHE_CR_WAYSEL(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CR.Reg, volatile.LoadUint32(&o.ICACHE_CR.Reg)&^(0x4)|value<<2)
}
func (o *ICache_Type) GetICACHE_CR_WAYSEL() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_CR.Reg) & 0x4) >> 2
}
func (o *ICache_Type) SetICACHE_CR_HITMEN(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CR.Reg, volatile.LoadUint32(&o.ICACHE_CR.Reg)&^(0x10000)|value<<16)
}
func (o *ICache_Type) GetICACHE_CR_HITMEN() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_CR.Reg) & 0x10000) >> 16
}
func (o *ICache_Type) SetICACHE_CR_MISSMEN(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CR.Reg, volatile.LoadUint32(&o.ICACHE_CR.Reg)&^(0x20000)|value<<17)
}
func (o *ICache_Type) GetICACHE_CR_MISSMEN() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_CR.Reg) & 0x20000) >> 17
}
func (o *ICache_Type) SetICACHE_CR_HITMRST(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CR.Reg, volatile.LoadUint32(&o.ICACHE_CR.Reg)&^(0x40000)|value<<18)
}
func (o *ICache_Type) GetICACHE_CR_HITMRST() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_CR.Reg) & 0x40000) >> 18
}
func (o *ICache_Type) SetICACHE_CR_MISSMRST(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CR.Reg, volatile.LoadUint32(&o.ICACHE_CR.Reg)&^(0x80000)|value<<19)
}
func (o *ICache_Type) GetICACHE_CR_MISSMRST() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_CR.Reg) & 0x80000) >> 19
}

// ICache.ICACHE_SR: ICACHE status register
func (o *ICache_Type) SetICACHE_SR_BUSYF(value uint32) {
	volatile.StoreUint32(&o.ICACHE_SR.Reg, volatile.LoadUint32(&o.ICACHE_SR.Reg)&^(0x1)|value)
}
func (o *ICache_Type) GetICACHE_SR_BUSYF() uint32 {
	return volatile.LoadUint32(&o.ICACHE_SR.Reg) & 0x1
}
func (o *ICache_Type) SetICACHE_SR_BSYENDF(value uint32) {
	volatile.StoreUint32(&o.ICACHE_SR.Reg, volatile.LoadUint32(&o.ICACHE_SR.Reg)&^(0x2)|value<<1)
}
func (o *ICache_Type) GetICACHE_SR_BSYENDF() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_SR.Reg) & 0x2) >> 1
}
func (o *ICache_Type) SetICACHE_SR_ERRF(value uint32) {
	volatile.StoreUint32(&o.ICACHE_SR.Reg, volatile.LoadUint32(&o.ICACHE_SR.Reg)&^(0x4)|value<<2)
}
func (o *ICache_Type) GetICACHE_SR_ERRF() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_SR.Reg) & 0x4) >> 2
}

// ICache.ICACHE_IER: ICACHE interrupt enable register
func (o *ICache_Type) SetICACHE_IER_BSYENDIE(value uint32) {
	volatile.StoreUint32(&o.ICACHE_IER.Reg, volatile.LoadUint32(&o.ICACHE_IER.Reg)&^(0x2)|value<<1)
}
func (o *ICache_Type) GetICACHE_IER_BSYENDIE() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_IER.Reg) & 0x2) >> 1
}
func (o *ICache_Type) SetICACHE_IER_ERRIE(value uint32) {
	volatile.StoreUint32(&o.ICACHE_IER.Reg, volatile.LoadUint32(&o.ICACHE_IER.Reg)&^(0x4)|value<<2)
}
func (o *ICache_Type) GetICACHE_IER_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_IER.Reg) & 0x4) >> 2
}

// ICache.ICACHE_FCR: ICACHE flag clear register
func (o *ICache_Type) SetICACHE_FCR_CBSYENDF(value uint32) {
	volatile.StoreUint32(&o.ICACHE_FCR.Reg, volatile.LoadUint32(&o.ICACHE_FCR.Reg)&^(0x2)|value<<1)
}
func (o *ICache_Type) GetICACHE_FCR_CBSYENDF() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_FCR.Reg) & 0x2) >> 1
}
func (o *ICache_Type) SetICACHE_FCR_CERRF(value uint32) {
	volatile.StoreUint32(&o.ICACHE_FCR.Reg, volatile.LoadUint32(&o.ICACHE_FCR.Reg)&^(0x4)|value<<2)
}
func (o *ICache_Type) GetICACHE_FCR_CERRF() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_FCR.Reg) & 0x4) >> 2
}

// ICache.ICACHE_HMONR: ICACHE hit monitor register
func (o *ICache_Type) SetICACHE_HMONR(value uint32) {
	volatile.StoreUint32(&o.ICACHE_HMONR.Reg, value)
}
func (o *ICache_Type) GetICACHE_HMONR() uint32 {
	return volatile.LoadUint32(&o.ICACHE_HMONR.Reg)
}

// ICache.ICACHE_MMONR: ICACHE miss monitor register
func (o *ICache_Type) SetICACHE_MMONR_MISSMON(value uint32) {
	volatile.StoreUint32(&o.ICACHE_MMONR.Reg, volatile.LoadUint32(&o.ICACHE_MMONR.Reg)&^(0xffff)|value)
}
func (o *ICache_Type) GetICACHE_MMONR_MISSMON() uint32 {
	return volatile.LoadUint32(&o.ICACHE_MMONR.Reg) & 0xffff
}

// ICache.ICACHE_CRR0: ICACHE region configuration register
func (o *ICache_Type) SetICACHE_CRR0_BASEADDR(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CRR0.Reg, volatile.LoadUint32(&o.ICACHE_CRR0.Reg)&^(0xff)|value)
}
func (o *ICache_Type) GetICACHE_CRR0_BASEADDR() uint32 {
	return volatile.LoadUint32(&o.ICACHE_CRR0.Reg) & 0xff
}
func (o *ICache_Type) SetICACHE_CRR0_RSIZE(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CRR0.Reg, volatile.LoadUint32(&o.ICACHE_CRR0.Reg)&^(0xe00)|value<<9)
}
func (o *ICache_Type) GetICACHE_CRR0_RSIZE() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_CRR0.Reg) & 0xe00) >> 9
}
func (o *ICache_Type) SetICACHE_CRR0_REN(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CRR0.Reg, volatile.LoadUint32(&o.ICACHE_CRR0.Reg)&^(0x8000)|value<<15)
}
func (o *ICache_Type) GetICACHE_CRR0_REN() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_CRR0.Reg) & 0x8000) >> 15
}
func (o *ICache_Type) SetICACHE_CRR0_REMAPADDR(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CRR0.Reg, volatile.LoadUint32(&o.ICACHE_CRR0.Reg)&^(0x7ff0000)|value<<16)
}
func (o *ICache_Type) GetICACHE_CRR0_REMAPADDR() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_CRR0.Reg) & 0x7ff0000) >> 16
}
func (o *ICache_Type) SetICACHE_CRR0_MSTSEL(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CRR0.Reg, volatile.LoadUint32(&o.ICACHE_CRR0.Reg)&^(0x10000000)|value<<28)
}
func (o *ICache_Type) GetICACHE_CRR0_MSTSEL() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_CRR0.Reg) & 0x10000000) >> 28
}
func (o *ICache_Type) SetICACHE_CRR0_HBURST(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CRR0.Reg, volatile.LoadUint32(&o.ICACHE_CRR0.Reg)&^(0x80000000)|value<<31)
}
func (o *ICache_Type) GetICACHE_CRR0_HBURST() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_CRR0.Reg) & 0x80000000) >> 31
}

// ICache.ICACHE_CRR1: ICACHE region configuration register
func (o *ICache_Type) SetICACHE_CRR1_BASEADDR(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CRR1.Reg, volatile.LoadUint32(&o.ICACHE_CRR1.Reg)&^(0xff)|value)
}
func (o *ICache_Type) GetICACHE_CRR1_BASEADDR() uint32 {
	return volatile.LoadUint32(&o.ICACHE_CRR1.Reg) & 0xff
}
func (o *ICache_Type) SetICACHE_CRR1_RSIZE(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CRR1.Reg, volatile.LoadUint32(&o.ICACHE_CRR1.Reg)&^(0xe00)|value<<9)
}
func (o *ICache_Type) GetICACHE_CRR1_RSIZE() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_CRR1.Reg) & 0xe00) >> 9
}
func (o *ICache_Type) SetICACHE_CRR1_REN(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CRR1.Reg, volatile.LoadUint32(&o.ICACHE_CRR1.Reg)&^(0x8000)|value<<15)
}
func (o *ICache_Type) GetICACHE_CRR1_REN() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_CRR1.Reg) & 0x8000) >> 15
}
func (o *ICache_Type) SetICACHE_CRR1_REMAPADDR(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CRR1.Reg, volatile.LoadUint32(&o.ICACHE_CRR1.Reg)&^(0x7ff0000)|value<<16)
}
func (o *ICache_Type) GetICACHE_CRR1_REMAPADDR() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_CRR1.Reg) & 0x7ff0000) >> 16
}
func (o *ICache_Type) SetICACHE_CRR1_MSTSEL(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CRR1.Reg, volatile.LoadUint32(&o.ICACHE_CRR1.Reg)&^(0x10000000)|value<<28)
}
func (o *ICache_Type) GetICACHE_CRR1_MSTSEL() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_CRR1.Reg) & 0x10000000) >> 28
}
func (o *ICache_Type) SetICACHE_CRR1_HBURST(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CRR1.Reg, volatile.LoadUint32(&o.ICACHE_CRR1.Reg)&^(0x80000000)|value<<31)
}
func (o *ICache_Type) GetICACHE_CRR1_HBURST() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_CRR1.Reg) & 0x80000000) >> 31
}

// ICache.ICACHE_CRR2: ICACHE region configuration register
func (o *ICache_Type) SetICACHE_CRR2_BASEADDR(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CRR2.Reg, volatile.LoadUint32(&o.ICACHE_CRR2.Reg)&^(0xff)|value)
}
func (o *ICache_Type) GetICACHE_CRR2_BASEADDR() uint32 {
	return volatile.LoadUint32(&o.ICACHE_CRR2.Reg) & 0xff
}
func (o *ICache_Type) SetICACHE_CRR2_RSIZE(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CRR2.Reg, volatile.LoadUint32(&o.ICACHE_CRR2.Reg)&^(0xe00)|value<<9)
}
func (o *ICache_Type) GetICACHE_CRR2_RSIZE() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_CRR2.Reg) & 0xe00) >> 9
}
func (o *ICache_Type) SetICACHE_CRR2_REN(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CRR2.Reg, volatile.LoadUint32(&o.ICACHE_CRR2.Reg)&^(0x8000)|value<<15)
}
func (o *ICache_Type) GetICACHE_CRR2_REN() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_CRR2.Reg) & 0x8000) >> 15
}
func (o *ICache_Type) SetICACHE_CRR2_REMAPADDR(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CRR2.Reg, volatile.LoadUint32(&o.ICACHE_CRR2.Reg)&^(0x7ff0000)|value<<16)
}
func (o *ICache_Type) GetICACHE_CRR2_REMAPADDR() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_CRR2.Reg) & 0x7ff0000) >> 16
}
func (o *ICache_Type) SetICACHE_CRR2_MSTSEL(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CRR2.Reg, volatile.LoadUint32(&o.ICACHE_CRR2.Reg)&^(0x10000000)|value<<28)
}
func (o *ICache_Type) GetICACHE_CRR2_MSTSEL() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_CRR2.Reg) & 0x10000000) >> 28
}
func (o *ICache_Type) SetICACHE_CRR2_HBURST(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CRR2.Reg, volatile.LoadUint32(&o.ICACHE_CRR2.Reg)&^(0x80000000)|value<<31)
}
func (o *ICache_Type) GetICACHE_CRR2_HBURST() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_CRR2.Reg) & 0x80000000) >> 31
}

// ICache.ICACHE_CRR3: ICACHE region configuration register
func (o *ICache_Type) SetICACHE_CRR3_BASEADDR(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CRR3.Reg, volatile.LoadUint32(&o.ICACHE_CRR3.Reg)&^(0xff)|value)
}
func (o *ICache_Type) GetICACHE_CRR3_BASEADDR() uint32 {
	return volatile.LoadUint32(&o.ICACHE_CRR3.Reg) & 0xff
}
func (o *ICache_Type) SetICACHE_CRR3_RSIZE(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CRR3.Reg, volatile.LoadUint32(&o.ICACHE_CRR3.Reg)&^(0xe00)|value<<9)
}
func (o *ICache_Type) GetICACHE_CRR3_RSIZE() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_CRR3.Reg) & 0xe00) >> 9
}
func (o *ICache_Type) SetICACHE_CRR3_REN(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CRR3.Reg, volatile.LoadUint32(&o.ICACHE_CRR3.Reg)&^(0x8000)|value<<15)
}
func (o *ICache_Type) GetICACHE_CRR3_REN() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_CRR3.Reg) & 0x8000) >> 15
}
func (o *ICache_Type) SetICACHE_CRR3_REMAPADDR(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CRR3.Reg, volatile.LoadUint32(&o.ICACHE_CRR3.Reg)&^(0x7ff0000)|value<<16)
}
func (o *ICache_Type) GetICACHE_CRR3_REMAPADDR() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_CRR3.Reg) & 0x7ff0000) >> 16
}
func (o *ICache_Type) SetICACHE_CRR3_MSTSEL(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CRR3.Reg, volatile.LoadUint32(&o.ICACHE_CRR3.Reg)&^(0x10000000)|value<<28)
}
func (o *ICache_Type) GetICACHE_CRR3_MSTSEL() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_CRR3.Reg) & 0x10000000) >> 28
}
func (o *ICache_Type) SetICACHE_CRR3_HBURST(value uint32) {
	volatile.StoreUint32(&o.ICACHE_CRR3.Reg, volatile.LoadUint32(&o.ICACHE_CRR3.Reg)&^(0x80000000)|value<<31)
}
func (o *ICache_Type) GetICACHE_CRR3_HBURST() uint32 {
	return (volatile.LoadUint32(&o.ICACHE_CRR3.Reg) & 0x80000000) >> 31
}

// Independent watchdog
type IWDG_Type struct {
	KR   volatile.Register32 // 0x0
	PR   volatile.Register32 // 0x4
	RLR  volatile.Register32 // 0x8
	SR   volatile.Register32 // 0xC
	WINR volatile.Register32 // 0x10
}

// IWDG.KR: Key register
func (o *IWDG_Type) SetKR_KEY(value uint32) {
	volatile.StoreUint32(&o.KR.Reg, volatile.LoadUint32(&o.KR.Reg)&^(0xffff)|value)
}
func (o *IWDG_Type) GetKR_KEY() uint32 {
	return volatile.LoadUint32(&o.KR.Reg) & 0xffff
}

// IWDG.PR: Prescaler register
func (o *IWDG_Type) SetPR(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x7)|value)
}
func (o *IWDG_Type) GetPR() uint32 {
	return volatile.LoadUint32(&o.PR.Reg) & 0x7
}

// IWDG.RLR: Reload register
func (o *IWDG_Type) SetRLR_RL(value uint32) {
	volatile.StoreUint32(&o.RLR.Reg, volatile.LoadUint32(&o.RLR.Reg)&^(0xfff)|value)
}
func (o *IWDG_Type) GetRLR_RL() uint32 {
	return volatile.LoadUint32(&o.RLR.Reg) & 0xfff
}

// IWDG.SR: Status register
func (o *IWDG_Type) SetSR_WVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *IWDG_Type) GetSR_WVU() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *IWDG_Type) SetSR_RVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *IWDG_Type) GetSR_RVU() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *IWDG_Type) SetSR_PVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *IWDG_Type) GetSR_PVU() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// IWDG.WINR: Window register
func (o *IWDG_Type) SetWINR_WIN(value uint32) {
	volatile.StoreUint32(&o.WINR.Reg, volatile.LoadUint32(&o.WINR.Reg)&^(0xfff)|value)
}
func (o *IWDG_Type) GetWINR_WIN() uint32 {
	return volatile.LoadUint32(&o.WINR.Reg) & 0xfff
}

// Low power timer
type LPTIM_Type struct {
	ISR  volatile.Register32 // 0x0
	ICR  volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	CFGR volatile.Register32 // 0xC
	CR   volatile.Register32 // 0x10
	CMP  volatile.Register32 // 0x14
	ARR  volatile.Register32 // 0x18
	CNT  volatile.Register32 // 0x1C
	OR   volatile.Register32 // 0x20
	_    [4]byte
	RCR  volatile.Register32 // 0x28
}

// LPTIM.ISR: Interrupt and Status Register
func (o *LPTIM_Type) SetISR_DOWN(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *LPTIM_Type) GetISR_DOWN() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *LPTIM_Type) SetISR_UP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *LPTIM_Type) GetISR_UP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *LPTIM_Type) SetISR_ARROK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetISR_ARROK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetISR_CMPOK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetISR_CMPOK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetISR_EXTTRIG(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetISR_EXTTRIG() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetISR_ARRM(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetISR_ARRM() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetISR_CMPM(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetISR_CMPM() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *LPTIM_Type) SetISR_UE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *LPTIM_Type) GetISR_UE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *LPTIM_Type) SetISR_REPOK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *LPTIM_Type) GetISR_REPOK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}

// LPTIM.ICR: Interrupt Clear Register
func (o *LPTIM_Type) SetICR_DOWNCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40)|value<<6)
}
func (o *LPTIM_Type) GetICR_DOWNCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40) >> 6
}
func (o *LPTIM_Type) SetICR_UPCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *LPTIM_Type) GetICR_UPCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *LPTIM_Type) SetICR_ARROKCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetICR_ARROKCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetICR_CMPOKCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetICR_CMPOKCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetICR_EXTTRIGCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetICR_EXTTRIGCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetICR_ARRMCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetICR_ARRMCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetICR_CMPMCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetICR_CMPMCF() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}
func (o *LPTIM_Type) SetICR_UECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x80)|value<<7)
}
func (o *LPTIM_Type) GetICR_UECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x80) >> 7
}
func (o *LPTIM_Type) SetICR_REPOKCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100)|value<<8)
}
func (o *LPTIM_Type) GetICR_REPOKCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100) >> 8
}

// LPTIM.IER: Interrupt Enable Register
func (o *LPTIM_Type) SetIER_DOWNIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *LPTIM_Type) GetIER_DOWNIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *LPTIM_Type) SetIER_UPIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *LPTIM_Type) GetIER_UPIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *LPTIM_Type) SetIER_ARROKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetIER_ARROKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetIER_CMPOKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetIER_CMPOKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetIER_EXTTRIGIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetIER_EXTTRIGIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetIER_ARRMIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetIER_ARRMIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetIER_CMPMIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetIER_CMPMIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *LPTIM_Type) SetIER_UEIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *LPTIM_Type) GetIER_UEIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *LPTIM_Type) SetIER_REPOKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *LPTIM_Type) GetIER_REPOKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}

// LPTIM.CFGR: Configuration Register
func (o *LPTIM_Type) SetCFGR_ENC(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1000000)|value<<24)
}
func (o *LPTIM_Type) GetCFGR_ENC() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1000000) >> 24
}
func (o *LPTIM_Type) SetCFGR_COUNTMODE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x800000)|value<<23)
}
func (o *LPTIM_Type) GetCFGR_COUNTMODE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x800000) >> 23
}
func (o *LPTIM_Type) SetCFGR_PRELOAD(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x400000)|value<<22)
}
func (o *LPTIM_Type) GetCFGR_PRELOAD() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x400000) >> 22
}
func (o *LPTIM_Type) SetCFGR_WAVPOL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x200000)|value<<21)
}
func (o *LPTIM_Type) GetCFGR_WAVPOL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x200000) >> 21
}
func (o *LPTIM_Type) SetCFGR_WAVE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x100000)|value<<20)
}
func (o *LPTIM_Type) GetCFGR_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x100000) >> 20
}
func (o *LPTIM_Type) SetCFGR_TIMOUT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x80000)|value<<19)
}
func (o *LPTIM_Type) GetCFGR_TIMOUT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x80000) >> 19
}
func (o *LPTIM_Type) SetCFGR_TRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x60000)|value<<17)
}
func (o *LPTIM_Type) GetCFGR_TRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x60000) >> 17
}
func (o *LPTIM_Type) SetCFGR_TRIGSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xe000)|value<<13)
}
func (o *LPTIM_Type) GetCFGR_TRIGSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xe000) >> 13
}
func (o *LPTIM_Type) SetCFGR_PRESC(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xe00)|value<<9)
}
func (o *LPTIM_Type) GetCFGR_PRESC() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xe00) >> 9
}
func (o *LPTIM_Type) SetCFGR_TRGFLT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xc0)|value<<6)
}
func (o *LPTIM_Type) GetCFGR_TRGFLT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xc0) >> 6
}
func (o *LPTIM_Type) SetCFGR_CKFLT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x18)|value<<3)
}
func (o *LPTIM_Type) GetCFGR_CKFLT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x18) >> 3
}
func (o *LPTIM_Type) SetCFGR_CKPOL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x6)|value<<1)
}
func (o *LPTIM_Type) GetCFGR_CKPOL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x6) >> 1
}
func (o *LPTIM_Type) SetCFGR_CKSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetCFGR_CKSEL() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0x1
}

// LPTIM.CR: Control Register
func (o *LPTIM_Type) SetCR_CNTSTRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetCR_CNTSTRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetCR_SNGSTRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetCR_SNGSTRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetCR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetCR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *LPTIM_Type) SetCR_COUNTRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetCR_COUNTRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetCR_RSTARE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetCR_RSTARE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}

// LPTIM.CMP: Compare Register
func (o *LPTIM_Type) SetCMP(value uint32) {
	volatile.StoreUint32(&o.CMP.Reg, volatile.LoadUint32(&o.CMP.Reg)&^(0xffff)|value)
}
func (o *LPTIM_Type) GetCMP() uint32 {
	return volatile.LoadUint32(&o.CMP.Reg) & 0xffff
}

// LPTIM.ARR: Autoreload Register
func (o *LPTIM_Type) SetARR(value uint32) {
	volatile.StoreUint32(&o.ARR.Reg, volatile.LoadUint32(&o.ARR.Reg)&^(0xffff)|value)
}
func (o *LPTIM_Type) GetARR() uint32 {
	return volatile.LoadUint32(&o.ARR.Reg) & 0xffff
}

// LPTIM.CNT: Counter Register
func (o *LPTIM_Type) SetCNT(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0xffff)|value)
}
func (o *LPTIM_Type) GetCNT() uint32 {
	return volatile.LoadUint32(&o.CNT.Reg) & 0xffff
}

// LPTIM.OR: LPTIM option register
func (o *LPTIM_Type) SetOR_OR_0(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, volatile.LoadUint32(&o.OR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetOR_OR_0() uint32 {
	return volatile.LoadUint32(&o.OR.Reg) & 0x1
}
func (o *LPTIM_Type) SetOR_OR_1(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, volatile.LoadUint32(&o.OR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetOR_OR_1() uint32 {
	return (volatile.LoadUint32(&o.OR.Reg) & 0x2) >> 1
}

// LPTIM.RCR: LPTIM repetition register
func (o *LPTIM_Type) SetRCR_REP(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xff)|value)
}
func (o *LPTIM_Type) GetRCR_REP() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xff
}

// GTZC_MPCBB1
type GTZC_Type struct {
	CR      volatile.Register32 // 0x0
	_       [12]byte
	LCKVTR1 volatile.Register32 // 0x10
	LCKVTR2 volatile.Register32 // 0x14
	_       [232]byte
	VCTR0   volatile.Register32 // 0x100
	VCTR1   volatile.Register32 // 0x104
	VCTR2   volatile.Register32 // 0x108
	VCTR3   volatile.Register32 // 0x10C
	VCTR4   volatile.Register32 // 0x110
	VCTR5   volatile.Register32 // 0x114
	VCTR6   volatile.Register32 // 0x118
	VCTR7   volatile.Register32 // 0x11C
	VCTR8   volatile.Register32 // 0x120
	VCTR9   volatile.Register32 // 0x124
	VCTR10  volatile.Register32 // 0x128
	VCTR11  volatile.Register32 // 0x12C
	VCTR12  volatile.Register32 // 0x130
	VCTR13  volatile.Register32 // 0x134
	VCTR14  volatile.Register32 // 0x138
	VCTR15  volatile.Register32 // 0x13C
	VCTR16  volatile.Register32 // 0x140
	VCTR17  volatile.Register32 // 0x144
	VCTR18  volatile.Register32 // 0x148
	VCTR19  volatile.Register32 // 0x14C
	VCTR20  volatile.Register32 // 0x150
	VCTR21  volatile.Register32 // 0x154
	VCTR22  volatile.Register32 // 0x158
	VCTR23  volatile.Register32 // 0x15C
	VCTR24  volatile.Register32 // 0x160
	VCTR25  volatile.Register32 // 0x164
	VCTR26  volatile.Register32 // 0x168
	VCTR27  volatile.Register32 // 0x16C
	VCTR28  volatile.Register32 // 0x170
	VCTR29  volatile.Register32 // 0x174
	VCTR30  volatile.Register32 // 0x178
	VCTR31  volatile.Register32 // 0x17C
	VCTR32  volatile.Register32 // 0x180
	VCTR33  volatile.Register32 // 0x184
	VCTR34  volatile.Register32 // 0x188
	VCTR35  volatile.Register32 // 0x18C
	VCTR36  volatile.Register32 // 0x190
	VCTR37  volatile.Register32 // 0x194
	VCTR38  volatile.Register32 // 0x198
	VCTR39  volatile.Register32 // 0x19C
	VCTR40  volatile.Register32 // 0x1A0
	VCTR41  volatile.Register32 // 0x1A4
	VCTR42  volatile.Register32 // 0x1A8
	VCTR43  volatile.Register32 // 0x1AC
	VCTR44  volatile.Register32 // 0x1B0
	VCTR45  volatile.Register32 // 0x1B4
	VCTR46  volatile.Register32 // 0x1B8
	VCTR47  volatile.Register32 // 0x1BC
	VCTR48  volatile.Register32 // 0x1C0
	VCTR49  volatile.Register32 // 0x1C4
	VCTR50  volatile.Register32 // 0x1C8
	VCTR51  volatile.Register32 // 0x1CC
	VCTR52  volatile.Register32 // 0x1D0
	VCTR53  volatile.Register32 // 0x1D4
	VCTR54  volatile.Register32 // 0x1D8
	VCTR55  volatile.Register32 // 0x1DC
	VCTR56  volatile.Register32 // 0x1E0
	VCTR57  volatile.Register32 // 0x1E4
	VCTR58  volatile.Register32 // 0x1E8
	VCTR59  volatile.Register32 // 0x1EC
	VCTR60  volatile.Register32 // 0x1F0
	VCTR61  volatile.Register32 // 0x1F4
	VCTR62  volatile.Register32 // 0x1F8
	VCTR63  volatile.Register32 // 0x1FC
}

// GTZC.CR: MPCBB control register
func (o *GTZC_Type) SetCR_LCK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetCR_LCK() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *GTZC_Type) SetCR_INVSECSTATE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetCR_INVSECSTATE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetCR_SRWILADIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetCR_SRWILADIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000000) >> 31
}

// GTZC.LCKVTR1: MPCBB control register
func (o *GTZC_Type) SetLCKVTR1_LCKSB0(value uint32) {
	volatile.StoreUint32(&o.LCKVTR1.Reg, volatile.LoadUint32(&o.LCKVTR1.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetLCKVTR1_LCKSB0() uint32 {
	return volatile.LoadUint32(&o.LCKVTR1.Reg) & 0x1
}
func (o *GTZC_Type) SetLCKVTR1_LCKSB1(value uint32) {
	volatile.StoreUint32(&o.LCKVTR1.Reg, volatile.LoadUint32(&o.LCKVTR1.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetLCKVTR1_LCKSB1() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR1.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetLCKVTR1_LCKSB2(value uint32) {
	volatile.StoreUint32(&o.LCKVTR1.Reg, volatile.LoadUint32(&o.LCKVTR1.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetLCKVTR1_LCKSB2() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR1.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetLCKVTR1_LCKSB3(value uint32) {
	volatile.StoreUint32(&o.LCKVTR1.Reg, volatile.LoadUint32(&o.LCKVTR1.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetLCKVTR1_LCKSB3() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR1.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetLCKVTR1_LCKSB4(value uint32) {
	volatile.StoreUint32(&o.LCKVTR1.Reg, volatile.LoadUint32(&o.LCKVTR1.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetLCKVTR1_LCKSB4() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR1.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetLCKVTR1_LCKSB5(value uint32) {
	volatile.StoreUint32(&o.LCKVTR1.Reg, volatile.LoadUint32(&o.LCKVTR1.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetLCKVTR1_LCKSB5() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR1.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetLCKVTR1_LCKSB6(value uint32) {
	volatile.StoreUint32(&o.LCKVTR1.Reg, volatile.LoadUint32(&o.LCKVTR1.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetLCKVTR1_LCKSB6() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR1.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetLCKVTR1_LCKSB7(value uint32) {
	volatile.StoreUint32(&o.LCKVTR1.Reg, volatile.LoadUint32(&o.LCKVTR1.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetLCKVTR1_LCKSB7() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR1.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetLCKVTR1_LCKSB8(value uint32) {
	volatile.StoreUint32(&o.LCKVTR1.Reg, volatile.LoadUint32(&o.LCKVTR1.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetLCKVTR1_LCKSB8() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR1.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetLCKVTR1_LCKSB9(value uint32) {
	volatile.StoreUint32(&o.LCKVTR1.Reg, volatile.LoadUint32(&o.LCKVTR1.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetLCKVTR1_LCKSB9() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR1.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetLCKVTR1_LCKSB10(value uint32) {
	volatile.StoreUint32(&o.LCKVTR1.Reg, volatile.LoadUint32(&o.LCKVTR1.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetLCKVTR1_LCKSB10() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR1.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetLCKVTR1_LCKSB11(value uint32) {
	volatile.StoreUint32(&o.LCKVTR1.Reg, volatile.LoadUint32(&o.LCKVTR1.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetLCKVTR1_LCKSB11() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR1.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetLCKVTR1_LCKSB12(value uint32) {
	volatile.StoreUint32(&o.LCKVTR1.Reg, volatile.LoadUint32(&o.LCKVTR1.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetLCKVTR1_LCKSB12() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR1.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetLCKVTR1_LCKSB13(value uint32) {
	volatile.StoreUint32(&o.LCKVTR1.Reg, volatile.LoadUint32(&o.LCKVTR1.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetLCKVTR1_LCKSB13() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR1.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetLCKVTR1_LCKSB14(value uint32) {
	volatile.StoreUint32(&o.LCKVTR1.Reg, volatile.LoadUint32(&o.LCKVTR1.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetLCKVTR1_LCKSB14() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR1.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetLCKVTR1_LCKSB15(value uint32) {
	volatile.StoreUint32(&o.LCKVTR1.Reg, volatile.LoadUint32(&o.LCKVTR1.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetLCKVTR1_LCKSB15() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR1.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetLCKVTR1_LCKSB16(value uint32) {
	volatile.StoreUint32(&o.LCKVTR1.Reg, volatile.LoadUint32(&o.LCKVTR1.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetLCKVTR1_LCKSB16() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR1.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetLCKVTR1_LCKSB17(value uint32) {
	volatile.StoreUint32(&o.LCKVTR1.Reg, volatile.LoadUint32(&o.LCKVTR1.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetLCKVTR1_LCKSB17() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR1.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetLCKVTR1_LCKSB18(value uint32) {
	volatile.StoreUint32(&o.LCKVTR1.Reg, volatile.LoadUint32(&o.LCKVTR1.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetLCKVTR1_LCKSB18() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR1.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetLCKVTR1_LCKSB19(value uint32) {
	volatile.StoreUint32(&o.LCKVTR1.Reg, volatile.LoadUint32(&o.LCKVTR1.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetLCKVTR1_LCKSB19() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR1.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetLCKVTR1_LCKSB20(value uint32) {
	volatile.StoreUint32(&o.LCKVTR1.Reg, volatile.LoadUint32(&o.LCKVTR1.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetLCKVTR1_LCKSB20() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR1.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetLCKVTR1_LCKSB21(value uint32) {
	volatile.StoreUint32(&o.LCKVTR1.Reg, volatile.LoadUint32(&o.LCKVTR1.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetLCKVTR1_LCKSB21() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR1.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetLCKVTR1_LCKSB22(value uint32) {
	volatile.StoreUint32(&o.LCKVTR1.Reg, volatile.LoadUint32(&o.LCKVTR1.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetLCKVTR1_LCKSB22() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR1.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetLCKVTR1_LCKSB23(value uint32) {
	volatile.StoreUint32(&o.LCKVTR1.Reg, volatile.LoadUint32(&o.LCKVTR1.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetLCKVTR1_LCKSB23() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR1.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetLCKVTR1_LCKSB24(value uint32) {
	volatile.StoreUint32(&o.LCKVTR1.Reg, volatile.LoadUint32(&o.LCKVTR1.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetLCKVTR1_LCKSB24() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR1.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetLCKVTR1_LCKSB25(value uint32) {
	volatile.StoreUint32(&o.LCKVTR1.Reg, volatile.LoadUint32(&o.LCKVTR1.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetLCKVTR1_LCKSB25() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR1.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetLCKVTR1_LCKSB26(value uint32) {
	volatile.StoreUint32(&o.LCKVTR1.Reg, volatile.LoadUint32(&o.LCKVTR1.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetLCKVTR1_LCKSB26() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR1.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetLCKVTR1_LCKSB27(value uint32) {
	volatile.StoreUint32(&o.LCKVTR1.Reg, volatile.LoadUint32(&o.LCKVTR1.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetLCKVTR1_LCKSB27() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR1.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetLCKVTR1_LCKSB28(value uint32) {
	volatile.StoreUint32(&o.LCKVTR1.Reg, volatile.LoadUint32(&o.LCKVTR1.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetLCKVTR1_LCKSB28() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR1.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetLCKVTR1_LCKSB29(value uint32) {
	volatile.StoreUint32(&o.LCKVTR1.Reg, volatile.LoadUint32(&o.LCKVTR1.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetLCKVTR1_LCKSB29() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR1.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetLCKVTR1_LCKSB30(value uint32) {
	volatile.StoreUint32(&o.LCKVTR1.Reg, volatile.LoadUint32(&o.LCKVTR1.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetLCKVTR1_LCKSB30() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR1.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetLCKVTR1_LCKSB31(value uint32) {
	volatile.StoreUint32(&o.LCKVTR1.Reg, volatile.LoadUint32(&o.LCKVTR1.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetLCKVTR1_LCKSB31() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR1.Reg) & 0x80000000) >> 31
}

// GTZC.LCKVTR2: MPCBB control register
func (o *GTZC_Type) SetLCKVTR2_LCKSB32(value uint32) {
	volatile.StoreUint32(&o.LCKVTR2.Reg, volatile.LoadUint32(&o.LCKVTR2.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetLCKVTR2_LCKSB32() uint32 {
	return volatile.LoadUint32(&o.LCKVTR2.Reg) & 0x1
}
func (o *GTZC_Type) SetLCKVTR2_LCKSB33(value uint32) {
	volatile.StoreUint32(&o.LCKVTR2.Reg, volatile.LoadUint32(&o.LCKVTR2.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetLCKVTR2_LCKSB33() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR2.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetLCKVTR2_LCKSB34(value uint32) {
	volatile.StoreUint32(&o.LCKVTR2.Reg, volatile.LoadUint32(&o.LCKVTR2.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetLCKVTR2_LCKSB34() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR2.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetLCKVTR2_LCKSB35(value uint32) {
	volatile.StoreUint32(&o.LCKVTR2.Reg, volatile.LoadUint32(&o.LCKVTR2.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetLCKVTR2_LCKSB35() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR2.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetLCKVTR2_LCKSB36(value uint32) {
	volatile.StoreUint32(&o.LCKVTR2.Reg, volatile.LoadUint32(&o.LCKVTR2.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetLCKVTR2_LCKSB36() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR2.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetLCKVTR2_LCKSB37(value uint32) {
	volatile.StoreUint32(&o.LCKVTR2.Reg, volatile.LoadUint32(&o.LCKVTR2.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetLCKVTR2_LCKSB37() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR2.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetLCKVTR2_LCKSB38(value uint32) {
	volatile.StoreUint32(&o.LCKVTR2.Reg, volatile.LoadUint32(&o.LCKVTR2.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetLCKVTR2_LCKSB38() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR2.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetLCKVTR2_LCKSB39(value uint32) {
	volatile.StoreUint32(&o.LCKVTR2.Reg, volatile.LoadUint32(&o.LCKVTR2.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetLCKVTR2_LCKSB39() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR2.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetLCKVTR2_LCKSB40(value uint32) {
	volatile.StoreUint32(&o.LCKVTR2.Reg, volatile.LoadUint32(&o.LCKVTR2.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetLCKVTR2_LCKSB40() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR2.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetLCKVTR2_LCKSB41(value uint32) {
	volatile.StoreUint32(&o.LCKVTR2.Reg, volatile.LoadUint32(&o.LCKVTR2.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetLCKVTR2_LCKSB41() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR2.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetLCKVTR2_LCKSB42(value uint32) {
	volatile.StoreUint32(&o.LCKVTR2.Reg, volatile.LoadUint32(&o.LCKVTR2.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetLCKVTR2_LCKSB42() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR2.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetLCKVTR2_LCKSB43(value uint32) {
	volatile.StoreUint32(&o.LCKVTR2.Reg, volatile.LoadUint32(&o.LCKVTR2.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetLCKVTR2_LCKSB43() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR2.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetLCKVTR2_LCKSB44(value uint32) {
	volatile.StoreUint32(&o.LCKVTR2.Reg, volatile.LoadUint32(&o.LCKVTR2.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetLCKVTR2_LCKSB44() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR2.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetLCKVTR2_LCKSB45(value uint32) {
	volatile.StoreUint32(&o.LCKVTR2.Reg, volatile.LoadUint32(&o.LCKVTR2.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetLCKVTR2_LCKSB45() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR2.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetLCKVTR2_LCKSB46(value uint32) {
	volatile.StoreUint32(&o.LCKVTR2.Reg, volatile.LoadUint32(&o.LCKVTR2.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetLCKVTR2_LCKSB46() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR2.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetLCKVTR2_LCKSB47(value uint32) {
	volatile.StoreUint32(&o.LCKVTR2.Reg, volatile.LoadUint32(&o.LCKVTR2.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetLCKVTR2_LCKSB47() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR2.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetLCKVTR2_LCKSB48(value uint32) {
	volatile.StoreUint32(&o.LCKVTR2.Reg, volatile.LoadUint32(&o.LCKVTR2.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetLCKVTR2_LCKSB48() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR2.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetLCKVTR2_LCKSB49(value uint32) {
	volatile.StoreUint32(&o.LCKVTR2.Reg, volatile.LoadUint32(&o.LCKVTR2.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetLCKVTR2_LCKSB49() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR2.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetLCKVTR2_LCKSB50(value uint32) {
	volatile.StoreUint32(&o.LCKVTR2.Reg, volatile.LoadUint32(&o.LCKVTR2.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetLCKVTR2_LCKSB50() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR2.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetLCKVTR2_LCKSB51(value uint32) {
	volatile.StoreUint32(&o.LCKVTR2.Reg, volatile.LoadUint32(&o.LCKVTR2.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetLCKVTR2_LCKSB51() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR2.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetLCKVTR2_LCKSB52(value uint32) {
	volatile.StoreUint32(&o.LCKVTR2.Reg, volatile.LoadUint32(&o.LCKVTR2.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetLCKVTR2_LCKSB52() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR2.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetLCKVTR2_LCKSB53(value uint32) {
	volatile.StoreUint32(&o.LCKVTR2.Reg, volatile.LoadUint32(&o.LCKVTR2.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetLCKVTR2_LCKSB53() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR2.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetLCKVTR2_LCKSB54(value uint32) {
	volatile.StoreUint32(&o.LCKVTR2.Reg, volatile.LoadUint32(&o.LCKVTR2.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetLCKVTR2_LCKSB54() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR2.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetLCKVTR2_LCKSB55(value uint32) {
	volatile.StoreUint32(&o.LCKVTR2.Reg, volatile.LoadUint32(&o.LCKVTR2.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetLCKVTR2_LCKSB55() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR2.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetLCKVTR2_LCKSB56(value uint32) {
	volatile.StoreUint32(&o.LCKVTR2.Reg, volatile.LoadUint32(&o.LCKVTR2.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetLCKVTR2_LCKSB56() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR2.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetLCKVTR2_LCKSB57(value uint32) {
	volatile.StoreUint32(&o.LCKVTR2.Reg, volatile.LoadUint32(&o.LCKVTR2.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetLCKVTR2_LCKSB57() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR2.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetLCKVTR2_LCKSB58(value uint32) {
	volatile.StoreUint32(&o.LCKVTR2.Reg, volatile.LoadUint32(&o.LCKVTR2.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetLCKVTR2_LCKSB58() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR2.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetLCKVTR2_LCKSB59(value uint32) {
	volatile.StoreUint32(&o.LCKVTR2.Reg, volatile.LoadUint32(&o.LCKVTR2.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetLCKVTR2_LCKSB59() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR2.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetLCKVTR2_LCKSB60(value uint32) {
	volatile.StoreUint32(&o.LCKVTR2.Reg, volatile.LoadUint32(&o.LCKVTR2.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetLCKVTR2_LCKSB60() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR2.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetLCKVTR2_LCKSB61(value uint32) {
	volatile.StoreUint32(&o.LCKVTR2.Reg, volatile.LoadUint32(&o.LCKVTR2.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetLCKVTR2_LCKSB61() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR2.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetLCKVTR2_LCKSB62(value uint32) {
	volatile.StoreUint32(&o.LCKVTR2.Reg, volatile.LoadUint32(&o.LCKVTR2.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetLCKVTR2_LCKSB62() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR2.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetLCKVTR2_LCKSB63(value uint32) {
	volatile.StoreUint32(&o.LCKVTR2.Reg, volatile.LoadUint32(&o.LCKVTR2.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetLCKVTR2_LCKSB63() uint32 {
	return (volatile.LoadUint32(&o.LCKVTR2.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR0: MPCBBx vector register
func (o *GTZC_Type) SetVCTR0_B0(value uint32) {
	volatile.StoreUint32(&o.VCTR0.Reg, volatile.LoadUint32(&o.VCTR0.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR0_B0() uint32 {
	return volatile.LoadUint32(&o.VCTR0.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR0_B1(value uint32) {
	volatile.StoreUint32(&o.VCTR0.Reg, volatile.LoadUint32(&o.VCTR0.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR0_B1() uint32 {
	return (volatile.LoadUint32(&o.VCTR0.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR0_B2(value uint32) {
	volatile.StoreUint32(&o.VCTR0.Reg, volatile.LoadUint32(&o.VCTR0.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR0_B2() uint32 {
	return (volatile.LoadUint32(&o.VCTR0.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR0_B3(value uint32) {
	volatile.StoreUint32(&o.VCTR0.Reg, volatile.LoadUint32(&o.VCTR0.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR0_B3() uint32 {
	return (volatile.LoadUint32(&o.VCTR0.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR0_B4(value uint32) {
	volatile.StoreUint32(&o.VCTR0.Reg, volatile.LoadUint32(&o.VCTR0.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR0_B4() uint32 {
	return (volatile.LoadUint32(&o.VCTR0.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR0_B5(value uint32) {
	volatile.StoreUint32(&o.VCTR0.Reg, volatile.LoadUint32(&o.VCTR0.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR0_B5() uint32 {
	return (volatile.LoadUint32(&o.VCTR0.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR0_B6(value uint32) {
	volatile.StoreUint32(&o.VCTR0.Reg, volatile.LoadUint32(&o.VCTR0.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR0_B6() uint32 {
	return (volatile.LoadUint32(&o.VCTR0.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR0_B7(value uint32) {
	volatile.StoreUint32(&o.VCTR0.Reg, volatile.LoadUint32(&o.VCTR0.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR0_B7() uint32 {
	return (volatile.LoadUint32(&o.VCTR0.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR0_B8(value uint32) {
	volatile.StoreUint32(&o.VCTR0.Reg, volatile.LoadUint32(&o.VCTR0.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR0_B8() uint32 {
	return (volatile.LoadUint32(&o.VCTR0.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR0_B9(value uint32) {
	volatile.StoreUint32(&o.VCTR0.Reg, volatile.LoadUint32(&o.VCTR0.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR0_B9() uint32 {
	return (volatile.LoadUint32(&o.VCTR0.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR0_B10(value uint32) {
	volatile.StoreUint32(&o.VCTR0.Reg, volatile.LoadUint32(&o.VCTR0.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR0_B10() uint32 {
	return (volatile.LoadUint32(&o.VCTR0.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR0_B11(value uint32) {
	volatile.StoreUint32(&o.VCTR0.Reg, volatile.LoadUint32(&o.VCTR0.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR0_B11() uint32 {
	return (volatile.LoadUint32(&o.VCTR0.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR0_B12(value uint32) {
	volatile.StoreUint32(&o.VCTR0.Reg, volatile.LoadUint32(&o.VCTR0.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR0_B12() uint32 {
	return (volatile.LoadUint32(&o.VCTR0.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR0_B13(value uint32) {
	volatile.StoreUint32(&o.VCTR0.Reg, volatile.LoadUint32(&o.VCTR0.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR0_B13() uint32 {
	return (volatile.LoadUint32(&o.VCTR0.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR0_B14(value uint32) {
	volatile.StoreUint32(&o.VCTR0.Reg, volatile.LoadUint32(&o.VCTR0.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR0_B14() uint32 {
	return (volatile.LoadUint32(&o.VCTR0.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR0_B15(value uint32) {
	volatile.StoreUint32(&o.VCTR0.Reg, volatile.LoadUint32(&o.VCTR0.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR0_B15() uint32 {
	return (volatile.LoadUint32(&o.VCTR0.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR0_B16(value uint32) {
	volatile.StoreUint32(&o.VCTR0.Reg, volatile.LoadUint32(&o.VCTR0.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR0_B16() uint32 {
	return (volatile.LoadUint32(&o.VCTR0.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR0_B17(value uint32) {
	volatile.StoreUint32(&o.VCTR0.Reg, volatile.LoadUint32(&o.VCTR0.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR0_B17() uint32 {
	return (volatile.LoadUint32(&o.VCTR0.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR0_B18(value uint32) {
	volatile.StoreUint32(&o.VCTR0.Reg, volatile.LoadUint32(&o.VCTR0.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR0_B18() uint32 {
	return (volatile.LoadUint32(&o.VCTR0.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR0_B19(value uint32) {
	volatile.StoreUint32(&o.VCTR0.Reg, volatile.LoadUint32(&o.VCTR0.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR0_B19() uint32 {
	return (volatile.LoadUint32(&o.VCTR0.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR0_B20(value uint32) {
	volatile.StoreUint32(&o.VCTR0.Reg, volatile.LoadUint32(&o.VCTR0.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR0_B20() uint32 {
	return (volatile.LoadUint32(&o.VCTR0.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR0_B21(value uint32) {
	volatile.StoreUint32(&o.VCTR0.Reg, volatile.LoadUint32(&o.VCTR0.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR0_B21() uint32 {
	return (volatile.LoadUint32(&o.VCTR0.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR0_B22(value uint32) {
	volatile.StoreUint32(&o.VCTR0.Reg, volatile.LoadUint32(&o.VCTR0.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR0_B22() uint32 {
	return (volatile.LoadUint32(&o.VCTR0.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR0_B23(value uint32) {
	volatile.StoreUint32(&o.VCTR0.Reg, volatile.LoadUint32(&o.VCTR0.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR0_B23() uint32 {
	return (volatile.LoadUint32(&o.VCTR0.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR0_B24(value uint32) {
	volatile.StoreUint32(&o.VCTR0.Reg, volatile.LoadUint32(&o.VCTR0.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR0_B24() uint32 {
	return (volatile.LoadUint32(&o.VCTR0.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR0_B25(value uint32) {
	volatile.StoreUint32(&o.VCTR0.Reg, volatile.LoadUint32(&o.VCTR0.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR0_B25() uint32 {
	return (volatile.LoadUint32(&o.VCTR0.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR0_B26(value uint32) {
	volatile.StoreUint32(&o.VCTR0.Reg, volatile.LoadUint32(&o.VCTR0.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR0_B26() uint32 {
	return (volatile.LoadUint32(&o.VCTR0.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR0_B27(value uint32) {
	volatile.StoreUint32(&o.VCTR0.Reg, volatile.LoadUint32(&o.VCTR0.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR0_B27() uint32 {
	return (volatile.LoadUint32(&o.VCTR0.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR0_B28(value uint32) {
	volatile.StoreUint32(&o.VCTR0.Reg, volatile.LoadUint32(&o.VCTR0.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR0_B28() uint32 {
	return (volatile.LoadUint32(&o.VCTR0.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR0_B29(value uint32) {
	volatile.StoreUint32(&o.VCTR0.Reg, volatile.LoadUint32(&o.VCTR0.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR0_B29() uint32 {
	return (volatile.LoadUint32(&o.VCTR0.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR0_B30(value uint32) {
	volatile.StoreUint32(&o.VCTR0.Reg, volatile.LoadUint32(&o.VCTR0.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR0_B30() uint32 {
	return (volatile.LoadUint32(&o.VCTR0.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR0_B31(value uint32) {
	volatile.StoreUint32(&o.VCTR0.Reg, volatile.LoadUint32(&o.VCTR0.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR0_B31() uint32 {
	return (volatile.LoadUint32(&o.VCTR0.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR1: MPCBBx vector register
func (o *GTZC_Type) SetVCTR1_B32(value uint32) {
	volatile.StoreUint32(&o.VCTR1.Reg, volatile.LoadUint32(&o.VCTR1.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR1_B32() uint32 {
	return volatile.LoadUint32(&o.VCTR1.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR1_B33(value uint32) {
	volatile.StoreUint32(&o.VCTR1.Reg, volatile.LoadUint32(&o.VCTR1.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR1_B33() uint32 {
	return (volatile.LoadUint32(&o.VCTR1.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR1_B34(value uint32) {
	volatile.StoreUint32(&o.VCTR1.Reg, volatile.LoadUint32(&o.VCTR1.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR1_B34() uint32 {
	return (volatile.LoadUint32(&o.VCTR1.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR1_B35(value uint32) {
	volatile.StoreUint32(&o.VCTR1.Reg, volatile.LoadUint32(&o.VCTR1.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR1_B35() uint32 {
	return (volatile.LoadUint32(&o.VCTR1.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR1_B36(value uint32) {
	volatile.StoreUint32(&o.VCTR1.Reg, volatile.LoadUint32(&o.VCTR1.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR1_B36() uint32 {
	return (volatile.LoadUint32(&o.VCTR1.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR1_B37(value uint32) {
	volatile.StoreUint32(&o.VCTR1.Reg, volatile.LoadUint32(&o.VCTR1.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR1_B37() uint32 {
	return (volatile.LoadUint32(&o.VCTR1.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR1_B38(value uint32) {
	volatile.StoreUint32(&o.VCTR1.Reg, volatile.LoadUint32(&o.VCTR1.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR1_B38() uint32 {
	return (volatile.LoadUint32(&o.VCTR1.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR1_B39(value uint32) {
	volatile.StoreUint32(&o.VCTR1.Reg, volatile.LoadUint32(&o.VCTR1.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR1_B39() uint32 {
	return (volatile.LoadUint32(&o.VCTR1.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR1_B40(value uint32) {
	volatile.StoreUint32(&o.VCTR1.Reg, volatile.LoadUint32(&o.VCTR1.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR1_B40() uint32 {
	return (volatile.LoadUint32(&o.VCTR1.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR1_B41(value uint32) {
	volatile.StoreUint32(&o.VCTR1.Reg, volatile.LoadUint32(&o.VCTR1.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR1_B41() uint32 {
	return (volatile.LoadUint32(&o.VCTR1.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR1_B42(value uint32) {
	volatile.StoreUint32(&o.VCTR1.Reg, volatile.LoadUint32(&o.VCTR1.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR1_B42() uint32 {
	return (volatile.LoadUint32(&o.VCTR1.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR1_B43(value uint32) {
	volatile.StoreUint32(&o.VCTR1.Reg, volatile.LoadUint32(&o.VCTR1.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR1_B43() uint32 {
	return (volatile.LoadUint32(&o.VCTR1.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR1_B44(value uint32) {
	volatile.StoreUint32(&o.VCTR1.Reg, volatile.LoadUint32(&o.VCTR1.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR1_B44() uint32 {
	return (volatile.LoadUint32(&o.VCTR1.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR1_B45(value uint32) {
	volatile.StoreUint32(&o.VCTR1.Reg, volatile.LoadUint32(&o.VCTR1.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR1_B45() uint32 {
	return (volatile.LoadUint32(&o.VCTR1.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR1_B46(value uint32) {
	volatile.StoreUint32(&o.VCTR1.Reg, volatile.LoadUint32(&o.VCTR1.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR1_B46() uint32 {
	return (volatile.LoadUint32(&o.VCTR1.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR1_B47(value uint32) {
	volatile.StoreUint32(&o.VCTR1.Reg, volatile.LoadUint32(&o.VCTR1.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR1_B47() uint32 {
	return (volatile.LoadUint32(&o.VCTR1.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR1_B48(value uint32) {
	volatile.StoreUint32(&o.VCTR1.Reg, volatile.LoadUint32(&o.VCTR1.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR1_B48() uint32 {
	return (volatile.LoadUint32(&o.VCTR1.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR1_B49(value uint32) {
	volatile.StoreUint32(&o.VCTR1.Reg, volatile.LoadUint32(&o.VCTR1.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR1_B49() uint32 {
	return (volatile.LoadUint32(&o.VCTR1.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR1_B50(value uint32) {
	volatile.StoreUint32(&o.VCTR1.Reg, volatile.LoadUint32(&o.VCTR1.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR1_B50() uint32 {
	return (volatile.LoadUint32(&o.VCTR1.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR1_B51(value uint32) {
	volatile.StoreUint32(&o.VCTR1.Reg, volatile.LoadUint32(&o.VCTR1.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR1_B51() uint32 {
	return (volatile.LoadUint32(&o.VCTR1.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR1_B52(value uint32) {
	volatile.StoreUint32(&o.VCTR1.Reg, volatile.LoadUint32(&o.VCTR1.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR1_B52() uint32 {
	return (volatile.LoadUint32(&o.VCTR1.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR1_B53(value uint32) {
	volatile.StoreUint32(&o.VCTR1.Reg, volatile.LoadUint32(&o.VCTR1.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR1_B53() uint32 {
	return (volatile.LoadUint32(&o.VCTR1.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR1_B54(value uint32) {
	volatile.StoreUint32(&o.VCTR1.Reg, volatile.LoadUint32(&o.VCTR1.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR1_B54() uint32 {
	return (volatile.LoadUint32(&o.VCTR1.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR1_B55(value uint32) {
	volatile.StoreUint32(&o.VCTR1.Reg, volatile.LoadUint32(&o.VCTR1.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR1_B55() uint32 {
	return (volatile.LoadUint32(&o.VCTR1.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR1_B56(value uint32) {
	volatile.StoreUint32(&o.VCTR1.Reg, volatile.LoadUint32(&o.VCTR1.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR1_B56() uint32 {
	return (volatile.LoadUint32(&o.VCTR1.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR1_B57(value uint32) {
	volatile.StoreUint32(&o.VCTR1.Reg, volatile.LoadUint32(&o.VCTR1.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR1_B57() uint32 {
	return (volatile.LoadUint32(&o.VCTR1.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR1_B58(value uint32) {
	volatile.StoreUint32(&o.VCTR1.Reg, volatile.LoadUint32(&o.VCTR1.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR1_B58() uint32 {
	return (volatile.LoadUint32(&o.VCTR1.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR1_B59(value uint32) {
	volatile.StoreUint32(&o.VCTR1.Reg, volatile.LoadUint32(&o.VCTR1.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR1_B59() uint32 {
	return (volatile.LoadUint32(&o.VCTR1.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR1_B60(value uint32) {
	volatile.StoreUint32(&o.VCTR1.Reg, volatile.LoadUint32(&o.VCTR1.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR1_B60() uint32 {
	return (volatile.LoadUint32(&o.VCTR1.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR1_B61(value uint32) {
	volatile.StoreUint32(&o.VCTR1.Reg, volatile.LoadUint32(&o.VCTR1.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR1_B61() uint32 {
	return (volatile.LoadUint32(&o.VCTR1.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR1_B62(value uint32) {
	volatile.StoreUint32(&o.VCTR1.Reg, volatile.LoadUint32(&o.VCTR1.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR1_B62() uint32 {
	return (volatile.LoadUint32(&o.VCTR1.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR1_B63(value uint32) {
	volatile.StoreUint32(&o.VCTR1.Reg, volatile.LoadUint32(&o.VCTR1.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR1_B63() uint32 {
	return (volatile.LoadUint32(&o.VCTR1.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR2: MPCBBx vector register
func (o *GTZC_Type) SetVCTR2_B64(value uint32) {
	volatile.StoreUint32(&o.VCTR2.Reg, volatile.LoadUint32(&o.VCTR2.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR2_B64() uint32 {
	return volatile.LoadUint32(&o.VCTR2.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR2_B65(value uint32) {
	volatile.StoreUint32(&o.VCTR2.Reg, volatile.LoadUint32(&o.VCTR2.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR2_B65() uint32 {
	return (volatile.LoadUint32(&o.VCTR2.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR2_B66(value uint32) {
	volatile.StoreUint32(&o.VCTR2.Reg, volatile.LoadUint32(&o.VCTR2.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR2_B66() uint32 {
	return (volatile.LoadUint32(&o.VCTR2.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR2_B67(value uint32) {
	volatile.StoreUint32(&o.VCTR2.Reg, volatile.LoadUint32(&o.VCTR2.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR2_B67() uint32 {
	return (volatile.LoadUint32(&o.VCTR2.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR2_B68(value uint32) {
	volatile.StoreUint32(&o.VCTR2.Reg, volatile.LoadUint32(&o.VCTR2.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR2_B68() uint32 {
	return (volatile.LoadUint32(&o.VCTR2.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR2_B69(value uint32) {
	volatile.StoreUint32(&o.VCTR2.Reg, volatile.LoadUint32(&o.VCTR2.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR2_B69() uint32 {
	return (volatile.LoadUint32(&o.VCTR2.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR2_B70(value uint32) {
	volatile.StoreUint32(&o.VCTR2.Reg, volatile.LoadUint32(&o.VCTR2.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR2_B70() uint32 {
	return (volatile.LoadUint32(&o.VCTR2.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR2_B71(value uint32) {
	volatile.StoreUint32(&o.VCTR2.Reg, volatile.LoadUint32(&o.VCTR2.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR2_B71() uint32 {
	return (volatile.LoadUint32(&o.VCTR2.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR2_B72(value uint32) {
	volatile.StoreUint32(&o.VCTR2.Reg, volatile.LoadUint32(&o.VCTR2.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR2_B72() uint32 {
	return (volatile.LoadUint32(&o.VCTR2.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR2_B73(value uint32) {
	volatile.StoreUint32(&o.VCTR2.Reg, volatile.LoadUint32(&o.VCTR2.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR2_B73() uint32 {
	return (volatile.LoadUint32(&o.VCTR2.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR2_B74(value uint32) {
	volatile.StoreUint32(&o.VCTR2.Reg, volatile.LoadUint32(&o.VCTR2.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR2_B74() uint32 {
	return (volatile.LoadUint32(&o.VCTR2.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR2_B75(value uint32) {
	volatile.StoreUint32(&o.VCTR2.Reg, volatile.LoadUint32(&o.VCTR2.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR2_B75() uint32 {
	return (volatile.LoadUint32(&o.VCTR2.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR2_B76(value uint32) {
	volatile.StoreUint32(&o.VCTR2.Reg, volatile.LoadUint32(&o.VCTR2.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR2_B76() uint32 {
	return (volatile.LoadUint32(&o.VCTR2.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR2_B77(value uint32) {
	volatile.StoreUint32(&o.VCTR2.Reg, volatile.LoadUint32(&o.VCTR2.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR2_B77() uint32 {
	return (volatile.LoadUint32(&o.VCTR2.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR2_B78(value uint32) {
	volatile.StoreUint32(&o.VCTR2.Reg, volatile.LoadUint32(&o.VCTR2.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR2_B78() uint32 {
	return (volatile.LoadUint32(&o.VCTR2.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR2_B79(value uint32) {
	volatile.StoreUint32(&o.VCTR2.Reg, volatile.LoadUint32(&o.VCTR2.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR2_B79() uint32 {
	return (volatile.LoadUint32(&o.VCTR2.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR2_B80(value uint32) {
	volatile.StoreUint32(&o.VCTR2.Reg, volatile.LoadUint32(&o.VCTR2.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR2_B80() uint32 {
	return (volatile.LoadUint32(&o.VCTR2.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR2_B81(value uint32) {
	volatile.StoreUint32(&o.VCTR2.Reg, volatile.LoadUint32(&o.VCTR2.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR2_B81() uint32 {
	return (volatile.LoadUint32(&o.VCTR2.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR2_B82(value uint32) {
	volatile.StoreUint32(&o.VCTR2.Reg, volatile.LoadUint32(&o.VCTR2.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR2_B82() uint32 {
	return (volatile.LoadUint32(&o.VCTR2.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR2_B83(value uint32) {
	volatile.StoreUint32(&o.VCTR2.Reg, volatile.LoadUint32(&o.VCTR2.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR2_B83() uint32 {
	return (volatile.LoadUint32(&o.VCTR2.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR2_B84(value uint32) {
	volatile.StoreUint32(&o.VCTR2.Reg, volatile.LoadUint32(&o.VCTR2.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR2_B84() uint32 {
	return (volatile.LoadUint32(&o.VCTR2.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR2_B85(value uint32) {
	volatile.StoreUint32(&o.VCTR2.Reg, volatile.LoadUint32(&o.VCTR2.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR2_B85() uint32 {
	return (volatile.LoadUint32(&o.VCTR2.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR2_B86(value uint32) {
	volatile.StoreUint32(&o.VCTR2.Reg, volatile.LoadUint32(&o.VCTR2.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR2_B86() uint32 {
	return (volatile.LoadUint32(&o.VCTR2.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR2_B87(value uint32) {
	volatile.StoreUint32(&o.VCTR2.Reg, volatile.LoadUint32(&o.VCTR2.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR2_B87() uint32 {
	return (volatile.LoadUint32(&o.VCTR2.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR2_B88(value uint32) {
	volatile.StoreUint32(&o.VCTR2.Reg, volatile.LoadUint32(&o.VCTR2.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR2_B88() uint32 {
	return (volatile.LoadUint32(&o.VCTR2.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR2_B89(value uint32) {
	volatile.StoreUint32(&o.VCTR2.Reg, volatile.LoadUint32(&o.VCTR2.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR2_B89() uint32 {
	return (volatile.LoadUint32(&o.VCTR2.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR2_B90(value uint32) {
	volatile.StoreUint32(&o.VCTR2.Reg, volatile.LoadUint32(&o.VCTR2.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR2_B90() uint32 {
	return (volatile.LoadUint32(&o.VCTR2.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR2_B91(value uint32) {
	volatile.StoreUint32(&o.VCTR2.Reg, volatile.LoadUint32(&o.VCTR2.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR2_B91() uint32 {
	return (volatile.LoadUint32(&o.VCTR2.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR2_B92(value uint32) {
	volatile.StoreUint32(&o.VCTR2.Reg, volatile.LoadUint32(&o.VCTR2.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR2_B92() uint32 {
	return (volatile.LoadUint32(&o.VCTR2.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR2_B93(value uint32) {
	volatile.StoreUint32(&o.VCTR2.Reg, volatile.LoadUint32(&o.VCTR2.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR2_B93() uint32 {
	return (volatile.LoadUint32(&o.VCTR2.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR2_B94(value uint32) {
	volatile.StoreUint32(&o.VCTR2.Reg, volatile.LoadUint32(&o.VCTR2.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR2_B94() uint32 {
	return (volatile.LoadUint32(&o.VCTR2.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR2_B95(value uint32) {
	volatile.StoreUint32(&o.VCTR2.Reg, volatile.LoadUint32(&o.VCTR2.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR2_B95() uint32 {
	return (volatile.LoadUint32(&o.VCTR2.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR3: MPCBBx vector register
func (o *GTZC_Type) SetVCTR3_B96(value uint32) {
	volatile.StoreUint32(&o.VCTR3.Reg, volatile.LoadUint32(&o.VCTR3.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR3_B96() uint32 {
	return volatile.LoadUint32(&o.VCTR3.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR3_B97(value uint32) {
	volatile.StoreUint32(&o.VCTR3.Reg, volatile.LoadUint32(&o.VCTR3.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR3_B97() uint32 {
	return (volatile.LoadUint32(&o.VCTR3.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR3_B98(value uint32) {
	volatile.StoreUint32(&o.VCTR3.Reg, volatile.LoadUint32(&o.VCTR3.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR3_B98() uint32 {
	return (volatile.LoadUint32(&o.VCTR3.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR3_B99(value uint32) {
	volatile.StoreUint32(&o.VCTR3.Reg, volatile.LoadUint32(&o.VCTR3.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR3_B99() uint32 {
	return (volatile.LoadUint32(&o.VCTR3.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR3_B100(value uint32) {
	volatile.StoreUint32(&o.VCTR3.Reg, volatile.LoadUint32(&o.VCTR3.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR3_B100() uint32 {
	return (volatile.LoadUint32(&o.VCTR3.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR3_B101(value uint32) {
	volatile.StoreUint32(&o.VCTR3.Reg, volatile.LoadUint32(&o.VCTR3.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR3_B101() uint32 {
	return (volatile.LoadUint32(&o.VCTR3.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR3_B102(value uint32) {
	volatile.StoreUint32(&o.VCTR3.Reg, volatile.LoadUint32(&o.VCTR3.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR3_B102() uint32 {
	return (volatile.LoadUint32(&o.VCTR3.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR3_B103(value uint32) {
	volatile.StoreUint32(&o.VCTR3.Reg, volatile.LoadUint32(&o.VCTR3.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR3_B103() uint32 {
	return (volatile.LoadUint32(&o.VCTR3.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR3_B104(value uint32) {
	volatile.StoreUint32(&o.VCTR3.Reg, volatile.LoadUint32(&o.VCTR3.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR3_B104() uint32 {
	return (volatile.LoadUint32(&o.VCTR3.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR3_B105(value uint32) {
	volatile.StoreUint32(&o.VCTR3.Reg, volatile.LoadUint32(&o.VCTR3.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR3_B105() uint32 {
	return (volatile.LoadUint32(&o.VCTR3.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR3_B106(value uint32) {
	volatile.StoreUint32(&o.VCTR3.Reg, volatile.LoadUint32(&o.VCTR3.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR3_B106() uint32 {
	return (volatile.LoadUint32(&o.VCTR3.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR3_B107(value uint32) {
	volatile.StoreUint32(&o.VCTR3.Reg, volatile.LoadUint32(&o.VCTR3.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR3_B107() uint32 {
	return (volatile.LoadUint32(&o.VCTR3.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR3_B108(value uint32) {
	volatile.StoreUint32(&o.VCTR3.Reg, volatile.LoadUint32(&o.VCTR3.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR3_B108() uint32 {
	return (volatile.LoadUint32(&o.VCTR3.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR3_B109(value uint32) {
	volatile.StoreUint32(&o.VCTR3.Reg, volatile.LoadUint32(&o.VCTR3.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR3_B109() uint32 {
	return (volatile.LoadUint32(&o.VCTR3.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR3_B110(value uint32) {
	volatile.StoreUint32(&o.VCTR3.Reg, volatile.LoadUint32(&o.VCTR3.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR3_B110() uint32 {
	return (volatile.LoadUint32(&o.VCTR3.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR3_B111(value uint32) {
	volatile.StoreUint32(&o.VCTR3.Reg, volatile.LoadUint32(&o.VCTR3.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR3_B111() uint32 {
	return (volatile.LoadUint32(&o.VCTR3.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR3_B112(value uint32) {
	volatile.StoreUint32(&o.VCTR3.Reg, volatile.LoadUint32(&o.VCTR3.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR3_B112() uint32 {
	return (volatile.LoadUint32(&o.VCTR3.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR3_B113(value uint32) {
	volatile.StoreUint32(&o.VCTR3.Reg, volatile.LoadUint32(&o.VCTR3.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR3_B113() uint32 {
	return (volatile.LoadUint32(&o.VCTR3.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR3_B114(value uint32) {
	volatile.StoreUint32(&o.VCTR3.Reg, volatile.LoadUint32(&o.VCTR3.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR3_B114() uint32 {
	return (volatile.LoadUint32(&o.VCTR3.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR3_B115(value uint32) {
	volatile.StoreUint32(&o.VCTR3.Reg, volatile.LoadUint32(&o.VCTR3.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR3_B115() uint32 {
	return (volatile.LoadUint32(&o.VCTR3.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR3_B116(value uint32) {
	volatile.StoreUint32(&o.VCTR3.Reg, volatile.LoadUint32(&o.VCTR3.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR3_B116() uint32 {
	return (volatile.LoadUint32(&o.VCTR3.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR3_B117(value uint32) {
	volatile.StoreUint32(&o.VCTR3.Reg, volatile.LoadUint32(&o.VCTR3.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR3_B117() uint32 {
	return (volatile.LoadUint32(&o.VCTR3.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR3_B118(value uint32) {
	volatile.StoreUint32(&o.VCTR3.Reg, volatile.LoadUint32(&o.VCTR3.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR3_B118() uint32 {
	return (volatile.LoadUint32(&o.VCTR3.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR3_B119(value uint32) {
	volatile.StoreUint32(&o.VCTR3.Reg, volatile.LoadUint32(&o.VCTR3.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR3_B119() uint32 {
	return (volatile.LoadUint32(&o.VCTR3.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR3_B120(value uint32) {
	volatile.StoreUint32(&o.VCTR3.Reg, volatile.LoadUint32(&o.VCTR3.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR3_B120() uint32 {
	return (volatile.LoadUint32(&o.VCTR3.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR3_B121(value uint32) {
	volatile.StoreUint32(&o.VCTR3.Reg, volatile.LoadUint32(&o.VCTR3.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR3_B121() uint32 {
	return (volatile.LoadUint32(&o.VCTR3.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR3_B122(value uint32) {
	volatile.StoreUint32(&o.VCTR3.Reg, volatile.LoadUint32(&o.VCTR3.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR3_B122() uint32 {
	return (volatile.LoadUint32(&o.VCTR3.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR3_B123(value uint32) {
	volatile.StoreUint32(&o.VCTR3.Reg, volatile.LoadUint32(&o.VCTR3.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR3_B123() uint32 {
	return (volatile.LoadUint32(&o.VCTR3.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR3_B124(value uint32) {
	volatile.StoreUint32(&o.VCTR3.Reg, volatile.LoadUint32(&o.VCTR3.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR3_B124() uint32 {
	return (volatile.LoadUint32(&o.VCTR3.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR3_B125(value uint32) {
	volatile.StoreUint32(&o.VCTR3.Reg, volatile.LoadUint32(&o.VCTR3.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR3_B125() uint32 {
	return (volatile.LoadUint32(&o.VCTR3.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR3_B126(value uint32) {
	volatile.StoreUint32(&o.VCTR3.Reg, volatile.LoadUint32(&o.VCTR3.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR3_B126() uint32 {
	return (volatile.LoadUint32(&o.VCTR3.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR3_B127(value uint32) {
	volatile.StoreUint32(&o.VCTR3.Reg, volatile.LoadUint32(&o.VCTR3.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR3_B127() uint32 {
	return (volatile.LoadUint32(&o.VCTR3.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR4: MPCBBx vector register
func (o *GTZC_Type) SetVCTR4_B128(value uint32) {
	volatile.StoreUint32(&o.VCTR4.Reg, volatile.LoadUint32(&o.VCTR4.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR4_B128() uint32 {
	return volatile.LoadUint32(&o.VCTR4.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR4_B129(value uint32) {
	volatile.StoreUint32(&o.VCTR4.Reg, volatile.LoadUint32(&o.VCTR4.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR4_B129() uint32 {
	return (volatile.LoadUint32(&o.VCTR4.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR4_B130(value uint32) {
	volatile.StoreUint32(&o.VCTR4.Reg, volatile.LoadUint32(&o.VCTR4.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR4_B130() uint32 {
	return (volatile.LoadUint32(&o.VCTR4.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR4_B131(value uint32) {
	volatile.StoreUint32(&o.VCTR4.Reg, volatile.LoadUint32(&o.VCTR4.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR4_B131() uint32 {
	return (volatile.LoadUint32(&o.VCTR4.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR4_B132(value uint32) {
	volatile.StoreUint32(&o.VCTR4.Reg, volatile.LoadUint32(&o.VCTR4.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR4_B132() uint32 {
	return (volatile.LoadUint32(&o.VCTR4.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR4_B133(value uint32) {
	volatile.StoreUint32(&o.VCTR4.Reg, volatile.LoadUint32(&o.VCTR4.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR4_B133() uint32 {
	return (volatile.LoadUint32(&o.VCTR4.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR4_B134(value uint32) {
	volatile.StoreUint32(&o.VCTR4.Reg, volatile.LoadUint32(&o.VCTR4.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR4_B134() uint32 {
	return (volatile.LoadUint32(&o.VCTR4.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR4_B135(value uint32) {
	volatile.StoreUint32(&o.VCTR4.Reg, volatile.LoadUint32(&o.VCTR4.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR4_B135() uint32 {
	return (volatile.LoadUint32(&o.VCTR4.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR4_B136(value uint32) {
	volatile.StoreUint32(&o.VCTR4.Reg, volatile.LoadUint32(&o.VCTR4.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR4_B136() uint32 {
	return (volatile.LoadUint32(&o.VCTR4.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR4_B137(value uint32) {
	volatile.StoreUint32(&o.VCTR4.Reg, volatile.LoadUint32(&o.VCTR4.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR4_B137() uint32 {
	return (volatile.LoadUint32(&o.VCTR4.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR4_B138(value uint32) {
	volatile.StoreUint32(&o.VCTR4.Reg, volatile.LoadUint32(&o.VCTR4.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR4_B138() uint32 {
	return (volatile.LoadUint32(&o.VCTR4.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR4_B139(value uint32) {
	volatile.StoreUint32(&o.VCTR4.Reg, volatile.LoadUint32(&o.VCTR4.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR4_B139() uint32 {
	return (volatile.LoadUint32(&o.VCTR4.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR4_B140(value uint32) {
	volatile.StoreUint32(&o.VCTR4.Reg, volatile.LoadUint32(&o.VCTR4.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR4_B140() uint32 {
	return (volatile.LoadUint32(&o.VCTR4.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR4_B141(value uint32) {
	volatile.StoreUint32(&o.VCTR4.Reg, volatile.LoadUint32(&o.VCTR4.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR4_B141() uint32 {
	return (volatile.LoadUint32(&o.VCTR4.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR4_B142(value uint32) {
	volatile.StoreUint32(&o.VCTR4.Reg, volatile.LoadUint32(&o.VCTR4.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR4_B142() uint32 {
	return (volatile.LoadUint32(&o.VCTR4.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR4_B143(value uint32) {
	volatile.StoreUint32(&o.VCTR4.Reg, volatile.LoadUint32(&o.VCTR4.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR4_B143() uint32 {
	return (volatile.LoadUint32(&o.VCTR4.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR4_B144(value uint32) {
	volatile.StoreUint32(&o.VCTR4.Reg, volatile.LoadUint32(&o.VCTR4.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR4_B144() uint32 {
	return (volatile.LoadUint32(&o.VCTR4.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR4_B145(value uint32) {
	volatile.StoreUint32(&o.VCTR4.Reg, volatile.LoadUint32(&o.VCTR4.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR4_B145() uint32 {
	return (volatile.LoadUint32(&o.VCTR4.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR4_B146(value uint32) {
	volatile.StoreUint32(&o.VCTR4.Reg, volatile.LoadUint32(&o.VCTR4.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR4_B146() uint32 {
	return (volatile.LoadUint32(&o.VCTR4.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR4_B147(value uint32) {
	volatile.StoreUint32(&o.VCTR4.Reg, volatile.LoadUint32(&o.VCTR4.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR4_B147() uint32 {
	return (volatile.LoadUint32(&o.VCTR4.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR4_B148(value uint32) {
	volatile.StoreUint32(&o.VCTR4.Reg, volatile.LoadUint32(&o.VCTR4.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR4_B148() uint32 {
	return (volatile.LoadUint32(&o.VCTR4.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR4_B149(value uint32) {
	volatile.StoreUint32(&o.VCTR4.Reg, volatile.LoadUint32(&o.VCTR4.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR4_B149() uint32 {
	return (volatile.LoadUint32(&o.VCTR4.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR4_B150(value uint32) {
	volatile.StoreUint32(&o.VCTR4.Reg, volatile.LoadUint32(&o.VCTR4.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR4_B150() uint32 {
	return (volatile.LoadUint32(&o.VCTR4.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR4_B151(value uint32) {
	volatile.StoreUint32(&o.VCTR4.Reg, volatile.LoadUint32(&o.VCTR4.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR4_B151() uint32 {
	return (volatile.LoadUint32(&o.VCTR4.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR4_B152(value uint32) {
	volatile.StoreUint32(&o.VCTR4.Reg, volatile.LoadUint32(&o.VCTR4.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR4_B152() uint32 {
	return (volatile.LoadUint32(&o.VCTR4.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR4_B153(value uint32) {
	volatile.StoreUint32(&o.VCTR4.Reg, volatile.LoadUint32(&o.VCTR4.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR4_B153() uint32 {
	return (volatile.LoadUint32(&o.VCTR4.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR4_B154(value uint32) {
	volatile.StoreUint32(&o.VCTR4.Reg, volatile.LoadUint32(&o.VCTR4.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR4_B154() uint32 {
	return (volatile.LoadUint32(&o.VCTR4.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR4_B155(value uint32) {
	volatile.StoreUint32(&o.VCTR4.Reg, volatile.LoadUint32(&o.VCTR4.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR4_B155() uint32 {
	return (volatile.LoadUint32(&o.VCTR4.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR4_B156(value uint32) {
	volatile.StoreUint32(&o.VCTR4.Reg, volatile.LoadUint32(&o.VCTR4.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR4_B156() uint32 {
	return (volatile.LoadUint32(&o.VCTR4.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR4_B157(value uint32) {
	volatile.StoreUint32(&o.VCTR4.Reg, volatile.LoadUint32(&o.VCTR4.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR4_B157() uint32 {
	return (volatile.LoadUint32(&o.VCTR4.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR4_B158(value uint32) {
	volatile.StoreUint32(&o.VCTR4.Reg, volatile.LoadUint32(&o.VCTR4.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR4_B158() uint32 {
	return (volatile.LoadUint32(&o.VCTR4.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR4_B159(value uint32) {
	volatile.StoreUint32(&o.VCTR4.Reg, volatile.LoadUint32(&o.VCTR4.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR4_B159() uint32 {
	return (volatile.LoadUint32(&o.VCTR4.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR5: MPCBBx vector register
func (o *GTZC_Type) SetVCTR5_B160(value uint32) {
	volatile.StoreUint32(&o.VCTR5.Reg, volatile.LoadUint32(&o.VCTR5.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR5_B160() uint32 {
	return volatile.LoadUint32(&o.VCTR5.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR5_B161(value uint32) {
	volatile.StoreUint32(&o.VCTR5.Reg, volatile.LoadUint32(&o.VCTR5.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR5_B161() uint32 {
	return (volatile.LoadUint32(&o.VCTR5.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR5_B162(value uint32) {
	volatile.StoreUint32(&o.VCTR5.Reg, volatile.LoadUint32(&o.VCTR5.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR5_B162() uint32 {
	return (volatile.LoadUint32(&o.VCTR5.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR5_B163(value uint32) {
	volatile.StoreUint32(&o.VCTR5.Reg, volatile.LoadUint32(&o.VCTR5.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR5_B163() uint32 {
	return (volatile.LoadUint32(&o.VCTR5.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR5_B164(value uint32) {
	volatile.StoreUint32(&o.VCTR5.Reg, volatile.LoadUint32(&o.VCTR5.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR5_B164() uint32 {
	return (volatile.LoadUint32(&o.VCTR5.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR5_B165(value uint32) {
	volatile.StoreUint32(&o.VCTR5.Reg, volatile.LoadUint32(&o.VCTR5.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR5_B165() uint32 {
	return (volatile.LoadUint32(&o.VCTR5.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR5_B166(value uint32) {
	volatile.StoreUint32(&o.VCTR5.Reg, volatile.LoadUint32(&o.VCTR5.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR5_B166() uint32 {
	return (volatile.LoadUint32(&o.VCTR5.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR5_B167(value uint32) {
	volatile.StoreUint32(&o.VCTR5.Reg, volatile.LoadUint32(&o.VCTR5.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR5_B167() uint32 {
	return (volatile.LoadUint32(&o.VCTR5.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR5_B168(value uint32) {
	volatile.StoreUint32(&o.VCTR5.Reg, volatile.LoadUint32(&o.VCTR5.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR5_B168() uint32 {
	return (volatile.LoadUint32(&o.VCTR5.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR5_B169(value uint32) {
	volatile.StoreUint32(&o.VCTR5.Reg, volatile.LoadUint32(&o.VCTR5.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR5_B169() uint32 {
	return (volatile.LoadUint32(&o.VCTR5.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR5_B170(value uint32) {
	volatile.StoreUint32(&o.VCTR5.Reg, volatile.LoadUint32(&o.VCTR5.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR5_B170() uint32 {
	return (volatile.LoadUint32(&o.VCTR5.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR5_B171(value uint32) {
	volatile.StoreUint32(&o.VCTR5.Reg, volatile.LoadUint32(&o.VCTR5.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR5_B171() uint32 {
	return (volatile.LoadUint32(&o.VCTR5.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR5_B172(value uint32) {
	volatile.StoreUint32(&o.VCTR5.Reg, volatile.LoadUint32(&o.VCTR5.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR5_B172() uint32 {
	return (volatile.LoadUint32(&o.VCTR5.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR5_B173(value uint32) {
	volatile.StoreUint32(&o.VCTR5.Reg, volatile.LoadUint32(&o.VCTR5.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR5_B173() uint32 {
	return (volatile.LoadUint32(&o.VCTR5.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR5_B174(value uint32) {
	volatile.StoreUint32(&o.VCTR5.Reg, volatile.LoadUint32(&o.VCTR5.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR5_B174() uint32 {
	return (volatile.LoadUint32(&o.VCTR5.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR5_B175(value uint32) {
	volatile.StoreUint32(&o.VCTR5.Reg, volatile.LoadUint32(&o.VCTR5.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR5_B175() uint32 {
	return (volatile.LoadUint32(&o.VCTR5.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR5_B176(value uint32) {
	volatile.StoreUint32(&o.VCTR5.Reg, volatile.LoadUint32(&o.VCTR5.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR5_B176() uint32 {
	return (volatile.LoadUint32(&o.VCTR5.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR5_B177(value uint32) {
	volatile.StoreUint32(&o.VCTR5.Reg, volatile.LoadUint32(&o.VCTR5.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR5_B177() uint32 {
	return (volatile.LoadUint32(&o.VCTR5.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR5_B178(value uint32) {
	volatile.StoreUint32(&o.VCTR5.Reg, volatile.LoadUint32(&o.VCTR5.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR5_B178() uint32 {
	return (volatile.LoadUint32(&o.VCTR5.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR5_B179(value uint32) {
	volatile.StoreUint32(&o.VCTR5.Reg, volatile.LoadUint32(&o.VCTR5.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR5_B179() uint32 {
	return (volatile.LoadUint32(&o.VCTR5.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR5_B180(value uint32) {
	volatile.StoreUint32(&o.VCTR5.Reg, volatile.LoadUint32(&o.VCTR5.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR5_B180() uint32 {
	return (volatile.LoadUint32(&o.VCTR5.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR5_B181(value uint32) {
	volatile.StoreUint32(&o.VCTR5.Reg, volatile.LoadUint32(&o.VCTR5.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR5_B181() uint32 {
	return (volatile.LoadUint32(&o.VCTR5.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR5_B182(value uint32) {
	volatile.StoreUint32(&o.VCTR5.Reg, volatile.LoadUint32(&o.VCTR5.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR5_B182() uint32 {
	return (volatile.LoadUint32(&o.VCTR5.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR5_B183(value uint32) {
	volatile.StoreUint32(&o.VCTR5.Reg, volatile.LoadUint32(&o.VCTR5.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR5_B183() uint32 {
	return (volatile.LoadUint32(&o.VCTR5.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR5_B184(value uint32) {
	volatile.StoreUint32(&o.VCTR5.Reg, volatile.LoadUint32(&o.VCTR5.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR5_B184() uint32 {
	return (volatile.LoadUint32(&o.VCTR5.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR5_B185(value uint32) {
	volatile.StoreUint32(&o.VCTR5.Reg, volatile.LoadUint32(&o.VCTR5.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR5_B185() uint32 {
	return (volatile.LoadUint32(&o.VCTR5.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR5_B186(value uint32) {
	volatile.StoreUint32(&o.VCTR5.Reg, volatile.LoadUint32(&o.VCTR5.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR5_B186() uint32 {
	return (volatile.LoadUint32(&o.VCTR5.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR5_B187(value uint32) {
	volatile.StoreUint32(&o.VCTR5.Reg, volatile.LoadUint32(&o.VCTR5.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR5_B187() uint32 {
	return (volatile.LoadUint32(&o.VCTR5.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR5_B188(value uint32) {
	volatile.StoreUint32(&o.VCTR5.Reg, volatile.LoadUint32(&o.VCTR5.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR5_B188() uint32 {
	return (volatile.LoadUint32(&o.VCTR5.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR5_B189(value uint32) {
	volatile.StoreUint32(&o.VCTR5.Reg, volatile.LoadUint32(&o.VCTR5.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR5_B189() uint32 {
	return (volatile.LoadUint32(&o.VCTR5.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR5_B190(value uint32) {
	volatile.StoreUint32(&o.VCTR5.Reg, volatile.LoadUint32(&o.VCTR5.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR5_B190() uint32 {
	return (volatile.LoadUint32(&o.VCTR5.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR5_B191(value uint32) {
	volatile.StoreUint32(&o.VCTR5.Reg, volatile.LoadUint32(&o.VCTR5.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR5_B191() uint32 {
	return (volatile.LoadUint32(&o.VCTR5.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR6: MPCBBx vector register
func (o *GTZC_Type) SetVCTR6_B192(value uint32) {
	volatile.StoreUint32(&o.VCTR6.Reg, volatile.LoadUint32(&o.VCTR6.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR6_B192() uint32 {
	return volatile.LoadUint32(&o.VCTR6.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR6_B193(value uint32) {
	volatile.StoreUint32(&o.VCTR6.Reg, volatile.LoadUint32(&o.VCTR6.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR6_B193() uint32 {
	return (volatile.LoadUint32(&o.VCTR6.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR6_B194(value uint32) {
	volatile.StoreUint32(&o.VCTR6.Reg, volatile.LoadUint32(&o.VCTR6.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR6_B194() uint32 {
	return (volatile.LoadUint32(&o.VCTR6.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR6_B195(value uint32) {
	volatile.StoreUint32(&o.VCTR6.Reg, volatile.LoadUint32(&o.VCTR6.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR6_B195() uint32 {
	return (volatile.LoadUint32(&o.VCTR6.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR6_B196(value uint32) {
	volatile.StoreUint32(&o.VCTR6.Reg, volatile.LoadUint32(&o.VCTR6.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR6_B196() uint32 {
	return (volatile.LoadUint32(&o.VCTR6.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR6_B197(value uint32) {
	volatile.StoreUint32(&o.VCTR6.Reg, volatile.LoadUint32(&o.VCTR6.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR6_B197() uint32 {
	return (volatile.LoadUint32(&o.VCTR6.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR6_B198(value uint32) {
	volatile.StoreUint32(&o.VCTR6.Reg, volatile.LoadUint32(&o.VCTR6.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR6_B198() uint32 {
	return (volatile.LoadUint32(&o.VCTR6.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR6_B199(value uint32) {
	volatile.StoreUint32(&o.VCTR6.Reg, volatile.LoadUint32(&o.VCTR6.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR6_B199() uint32 {
	return (volatile.LoadUint32(&o.VCTR6.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR6_B200(value uint32) {
	volatile.StoreUint32(&o.VCTR6.Reg, volatile.LoadUint32(&o.VCTR6.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR6_B200() uint32 {
	return (volatile.LoadUint32(&o.VCTR6.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR6_B201(value uint32) {
	volatile.StoreUint32(&o.VCTR6.Reg, volatile.LoadUint32(&o.VCTR6.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR6_B201() uint32 {
	return (volatile.LoadUint32(&o.VCTR6.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR6_B202(value uint32) {
	volatile.StoreUint32(&o.VCTR6.Reg, volatile.LoadUint32(&o.VCTR6.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR6_B202() uint32 {
	return (volatile.LoadUint32(&o.VCTR6.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR6_B203(value uint32) {
	volatile.StoreUint32(&o.VCTR6.Reg, volatile.LoadUint32(&o.VCTR6.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR6_B203() uint32 {
	return (volatile.LoadUint32(&o.VCTR6.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR6_B204(value uint32) {
	volatile.StoreUint32(&o.VCTR6.Reg, volatile.LoadUint32(&o.VCTR6.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR6_B204() uint32 {
	return (volatile.LoadUint32(&o.VCTR6.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR6_B205(value uint32) {
	volatile.StoreUint32(&o.VCTR6.Reg, volatile.LoadUint32(&o.VCTR6.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR6_B205() uint32 {
	return (volatile.LoadUint32(&o.VCTR6.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR6_B206(value uint32) {
	volatile.StoreUint32(&o.VCTR6.Reg, volatile.LoadUint32(&o.VCTR6.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR6_B206() uint32 {
	return (volatile.LoadUint32(&o.VCTR6.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR6_B207(value uint32) {
	volatile.StoreUint32(&o.VCTR6.Reg, volatile.LoadUint32(&o.VCTR6.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR6_B207() uint32 {
	return (volatile.LoadUint32(&o.VCTR6.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR6_B208(value uint32) {
	volatile.StoreUint32(&o.VCTR6.Reg, volatile.LoadUint32(&o.VCTR6.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR6_B208() uint32 {
	return (volatile.LoadUint32(&o.VCTR6.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR6_B209(value uint32) {
	volatile.StoreUint32(&o.VCTR6.Reg, volatile.LoadUint32(&o.VCTR6.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR6_B209() uint32 {
	return (volatile.LoadUint32(&o.VCTR6.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR6_B210(value uint32) {
	volatile.StoreUint32(&o.VCTR6.Reg, volatile.LoadUint32(&o.VCTR6.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR6_B210() uint32 {
	return (volatile.LoadUint32(&o.VCTR6.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR6_B211(value uint32) {
	volatile.StoreUint32(&o.VCTR6.Reg, volatile.LoadUint32(&o.VCTR6.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR6_B211() uint32 {
	return (volatile.LoadUint32(&o.VCTR6.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR6_B212(value uint32) {
	volatile.StoreUint32(&o.VCTR6.Reg, volatile.LoadUint32(&o.VCTR6.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR6_B212() uint32 {
	return (volatile.LoadUint32(&o.VCTR6.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR6_B213(value uint32) {
	volatile.StoreUint32(&o.VCTR6.Reg, volatile.LoadUint32(&o.VCTR6.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR6_B213() uint32 {
	return (volatile.LoadUint32(&o.VCTR6.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR6_B214(value uint32) {
	volatile.StoreUint32(&o.VCTR6.Reg, volatile.LoadUint32(&o.VCTR6.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR6_B214() uint32 {
	return (volatile.LoadUint32(&o.VCTR6.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR6_B215(value uint32) {
	volatile.StoreUint32(&o.VCTR6.Reg, volatile.LoadUint32(&o.VCTR6.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR6_B215() uint32 {
	return (volatile.LoadUint32(&o.VCTR6.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR6_B216(value uint32) {
	volatile.StoreUint32(&o.VCTR6.Reg, volatile.LoadUint32(&o.VCTR6.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR6_B216() uint32 {
	return (volatile.LoadUint32(&o.VCTR6.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR6_B217(value uint32) {
	volatile.StoreUint32(&o.VCTR6.Reg, volatile.LoadUint32(&o.VCTR6.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR6_B217() uint32 {
	return (volatile.LoadUint32(&o.VCTR6.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR6_B218(value uint32) {
	volatile.StoreUint32(&o.VCTR6.Reg, volatile.LoadUint32(&o.VCTR6.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR6_B218() uint32 {
	return (volatile.LoadUint32(&o.VCTR6.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR6_B219(value uint32) {
	volatile.StoreUint32(&o.VCTR6.Reg, volatile.LoadUint32(&o.VCTR6.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR6_B219() uint32 {
	return (volatile.LoadUint32(&o.VCTR6.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR6_B220(value uint32) {
	volatile.StoreUint32(&o.VCTR6.Reg, volatile.LoadUint32(&o.VCTR6.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR6_B220() uint32 {
	return (volatile.LoadUint32(&o.VCTR6.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR6_B221(value uint32) {
	volatile.StoreUint32(&o.VCTR6.Reg, volatile.LoadUint32(&o.VCTR6.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR6_B221() uint32 {
	return (volatile.LoadUint32(&o.VCTR6.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR6_B222(value uint32) {
	volatile.StoreUint32(&o.VCTR6.Reg, volatile.LoadUint32(&o.VCTR6.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR6_B222() uint32 {
	return (volatile.LoadUint32(&o.VCTR6.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR6_B223(value uint32) {
	volatile.StoreUint32(&o.VCTR6.Reg, volatile.LoadUint32(&o.VCTR6.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR6_B223() uint32 {
	return (volatile.LoadUint32(&o.VCTR6.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR7: MPCBBx vector register
func (o *GTZC_Type) SetVCTR7_B224(value uint32) {
	volatile.StoreUint32(&o.VCTR7.Reg, volatile.LoadUint32(&o.VCTR7.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR7_B224() uint32 {
	return volatile.LoadUint32(&o.VCTR7.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR7_B225(value uint32) {
	volatile.StoreUint32(&o.VCTR7.Reg, volatile.LoadUint32(&o.VCTR7.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR7_B225() uint32 {
	return (volatile.LoadUint32(&o.VCTR7.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR7_B226(value uint32) {
	volatile.StoreUint32(&o.VCTR7.Reg, volatile.LoadUint32(&o.VCTR7.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR7_B226() uint32 {
	return (volatile.LoadUint32(&o.VCTR7.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR7_B227(value uint32) {
	volatile.StoreUint32(&o.VCTR7.Reg, volatile.LoadUint32(&o.VCTR7.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR7_B227() uint32 {
	return (volatile.LoadUint32(&o.VCTR7.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR7_B228(value uint32) {
	volatile.StoreUint32(&o.VCTR7.Reg, volatile.LoadUint32(&o.VCTR7.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR7_B228() uint32 {
	return (volatile.LoadUint32(&o.VCTR7.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR7_B229(value uint32) {
	volatile.StoreUint32(&o.VCTR7.Reg, volatile.LoadUint32(&o.VCTR7.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR7_B229() uint32 {
	return (volatile.LoadUint32(&o.VCTR7.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR7_B230(value uint32) {
	volatile.StoreUint32(&o.VCTR7.Reg, volatile.LoadUint32(&o.VCTR7.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR7_B230() uint32 {
	return (volatile.LoadUint32(&o.VCTR7.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR7_B231(value uint32) {
	volatile.StoreUint32(&o.VCTR7.Reg, volatile.LoadUint32(&o.VCTR7.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR7_B231() uint32 {
	return (volatile.LoadUint32(&o.VCTR7.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR7_B232(value uint32) {
	volatile.StoreUint32(&o.VCTR7.Reg, volatile.LoadUint32(&o.VCTR7.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR7_B232() uint32 {
	return (volatile.LoadUint32(&o.VCTR7.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR7_B233(value uint32) {
	volatile.StoreUint32(&o.VCTR7.Reg, volatile.LoadUint32(&o.VCTR7.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR7_B233() uint32 {
	return (volatile.LoadUint32(&o.VCTR7.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR7_B234(value uint32) {
	volatile.StoreUint32(&o.VCTR7.Reg, volatile.LoadUint32(&o.VCTR7.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR7_B234() uint32 {
	return (volatile.LoadUint32(&o.VCTR7.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR7_B235(value uint32) {
	volatile.StoreUint32(&o.VCTR7.Reg, volatile.LoadUint32(&o.VCTR7.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR7_B235() uint32 {
	return (volatile.LoadUint32(&o.VCTR7.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR7_B236(value uint32) {
	volatile.StoreUint32(&o.VCTR7.Reg, volatile.LoadUint32(&o.VCTR7.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR7_B236() uint32 {
	return (volatile.LoadUint32(&o.VCTR7.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR7_B237(value uint32) {
	volatile.StoreUint32(&o.VCTR7.Reg, volatile.LoadUint32(&o.VCTR7.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR7_B237() uint32 {
	return (volatile.LoadUint32(&o.VCTR7.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR7_B238(value uint32) {
	volatile.StoreUint32(&o.VCTR7.Reg, volatile.LoadUint32(&o.VCTR7.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR7_B238() uint32 {
	return (volatile.LoadUint32(&o.VCTR7.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR7_B239(value uint32) {
	volatile.StoreUint32(&o.VCTR7.Reg, volatile.LoadUint32(&o.VCTR7.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR7_B239() uint32 {
	return (volatile.LoadUint32(&o.VCTR7.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR7_B240(value uint32) {
	volatile.StoreUint32(&o.VCTR7.Reg, volatile.LoadUint32(&o.VCTR7.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR7_B240() uint32 {
	return (volatile.LoadUint32(&o.VCTR7.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR7_B241(value uint32) {
	volatile.StoreUint32(&o.VCTR7.Reg, volatile.LoadUint32(&o.VCTR7.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR7_B241() uint32 {
	return (volatile.LoadUint32(&o.VCTR7.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR7_B242(value uint32) {
	volatile.StoreUint32(&o.VCTR7.Reg, volatile.LoadUint32(&o.VCTR7.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR7_B242() uint32 {
	return (volatile.LoadUint32(&o.VCTR7.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR7_B243(value uint32) {
	volatile.StoreUint32(&o.VCTR7.Reg, volatile.LoadUint32(&o.VCTR7.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR7_B243() uint32 {
	return (volatile.LoadUint32(&o.VCTR7.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR7_B244(value uint32) {
	volatile.StoreUint32(&o.VCTR7.Reg, volatile.LoadUint32(&o.VCTR7.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR7_B244() uint32 {
	return (volatile.LoadUint32(&o.VCTR7.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR7_B245(value uint32) {
	volatile.StoreUint32(&o.VCTR7.Reg, volatile.LoadUint32(&o.VCTR7.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR7_B245() uint32 {
	return (volatile.LoadUint32(&o.VCTR7.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR7_B246(value uint32) {
	volatile.StoreUint32(&o.VCTR7.Reg, volatile.LoadUint32(&o.VCTR7.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR7_B246() uint32 {
	return (volatile.LoadUint32(&o.VCTR7.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR7_B247(value uint32) {
	volatile.StoreUint32(&o.VCTR7.Reg, volatile.LoadUint32(&o.VCTR7.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR7_B247() uint32 {
	return (volatile.LoadUint32(&o.VCTR7.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR7_B248(value uint32) {
	volatile.StoreUint32(&o.VCTR7.Reg, volatile.LoadUint32(&o.VCTR7.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR7_B248() uint32 {
	return (volatile.LoadUint32(&o.VCTR7.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR7_B249(value uint32) {
	volatile.StoreUint32(&o.VCTR7.Reg, volatile.LoadUint32(&o.VCTR7.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR7_B249() uint32 {
	return (volatile.LoadUint32(&o.VCTR7.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR7_B250(value uint32) {
	volatile.StoreUint32(&o.VCTR7.Reg, volatile.LoadUint32(&o.VCTR7.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR7_B250() uint32 {
	return (volatile.LoadUint32(&o.VCTR7.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR7_B251(value uint32) {
	volatile.StoreUint32(&o.VCTR7.Reg, volatile.LoadUint32(&o.VCTR7.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR7_B251() uint32 {
	return (volatile.LoadUint32(&o.VCTR7.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR7_B252(value uint32) {
	volatile.StoreUint32(&o.VCTR7.Reg, volatile.LoadUint32(&o.VCTR7.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR7_B252() uint32 {
	return (volatile.LoadUint32(&o.VCTR7.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR7_B253(value uint32) {
	volatile.StoreUint32(&o.VCTR7.Reg, volatile.LoadUint32(&o.VCTR7.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR7_B253() uint32 {
	return (volatile.LoadUint32(&o.VCTR7.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR7_B254(value uint32) {
	volatile.StoreUint32(&o.VCTR7.Reg, volatile.LoadUint32(&o.VCTR7.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR7_B254() uint32 {
	return (volatile.LoadUint32(&o.VCTR7.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR7_B255(value uint32) {
	volatile.StoreUint32(&o.VCTR7.Reg, volatile.LoadUint32(&o.VCTR7.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR7_B255() uint32 {
	return (volatile.LoadUint32(&o.VCTR7.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR8: MPCBBx vector register
func (o *GTZC_Type) SetVCTR8_B256(value uint32) {
	volatile.StoreUint32(&o.VCTR8.Reg, volatile.LoadUint32(&o.VCTR8.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR8_B256() uint32 {
	return volatile.LoadUint32(&o.VCTR8.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR8_B257(value uint32) {
	volatile.StoreUint32(&o.VCTR8.Reg, volatile.LoadUint32(&o.VCTR8.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR8_B257() uint32 {
	return (volatile.LoadUint32(&o.VCTR8.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR8_B258(value uint32) {
	volatile.StoreUint32(&o.VCTR8.Reg, volatile.LoadUint32(&o.VCTR8.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR8_B258() uint32 {
	return (volatile.LoadUint32(&o.VCTR8.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR8_B259(value uint32) {
	volatile.StoreUint32(&o.VCTR8.Reg, volatile.LoadUint32(&o.VCTR8.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR8_B259() uint32 {
	return (volatile.LoadUint32(&o.VCTR8.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR8_B260(value uint32) {
	volatile.StoreUint32(&o.VCTR8.Reg, volatile.LoadUint32(&o.VCTR8.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR8_B260() uint32 {
	return (volatile.LoadUint32(&o.VCTR8.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR8_B261(value uint32) {
	volatile.StoreUint32(&o.VCTR8.Reg, volatile.LoadUint32(&o.VCTR8.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR8_B261() uint32 {
	return (volatile.LoadUint32(&o.VCTR8.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR8_B262(value uint32) {
	volatile.StoreUint32(&o.VCTR8.Reg, volatile.LoadUint32(&o.VCTR8.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR8_B262() uint32 {
	return (volatile.LoadUint32(&o.VCTR8.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR8_B263(value uint32) {
	volatile.StoreUint32(&o.VCTR8.Reg, volatile.LoadUint32(&o.VCTR8.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR8_B263() uint32 {
	return (volatile.LoadUint32(&o.VCTR8.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR8_B264(value uint32) {
	volatile.StoreUint32(&o.VCTR8.Reg, volatile.LoadUint32(&o.VCTR8.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR8_B264() uint32 {
	return (volatile.LoadUint32(&o.VCTR8.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR8_B265(value uint32) {
	volatile.StoreUint32(&o.VCTR8.Reg, volatile.LoadUint32(&o.VCTR8.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR8_B265() uint32 {
	return (volatile.LoadUint32(&o.VCTR8.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR8_B266(value uint32) {
	volatile.StoreUint32(&o.VCTR8.Reg, volatile.LoadUint32(&o.VCTR8.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR8_B266() uint32 {
	return (volatile.LoadUint32(&o.VCTR8.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR8_B267(value uint32) {
	volatile.StoreUint32(&o.VCTR8.Reg, volatile.LoadUint32(&o.VCTR8.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR8_B267() uint32 {
	return (volatile.LoadUint32(&o.VCTR8.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR8_B268(value uint32) {
	volatile.StoreUint32(&o.VCTR8.Reg, volatile.LoadUint32(&o.VCTR8.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR8_B268() uint32 {
	return (volatile.LoadUint32(&o.VCTR8.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR8_B269(value uint32) {
	volatile.StoreUint32(&o.VCTR8.Reg, volatile.LoadUint32(&o.VCTR8.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR8_B269() uint32 {
	return (volatile.LoadUint32(&o.VCTR8.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR8_B270(value uint32) {
	volatile.StoreUint32(&o.VCTR8.Reg, volatile.LoadUint32(&o.VCTR8.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR8_B270() uint32 {
	return (volatile.LoadUint32(&o.VCTR8.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR8_B271(value uint32) {
	volatile.StoreUint32(&o.VCTR8.Reg, volatile.LoadUint32(&o.VCTR8.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR8_B271() uint32 {
	return (volatile.LoadUint32(&o.VCTR8.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR8_B272(value uint32) {
	volatile.StoreUint32(&o.VCTR8.Reg, volatile.LoadUint32(&o.VCTR8.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR8_B272() uint32 {
	return (volatile.LoadUint32(&o.VCTR8.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR8_B273(value uint32) {
	volatile.StoreUint32(&o.VCTR8.Reg, volatile.LoadUint32(&o.VCTR8.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR8_B273() uint32 {
	return (volatile.LoadUint32(&o.VCTR8.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR8_B274(value uint32) {
	volatile.StoreUint32(&o.VCTR8.Reg, volatile.LoadUint32(&o.VCTR8.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR8_B274() uint32 {
	return (volatile.LoadUint32(&o.VCTR8.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR8_B275(value uint32) {
	volatile.StoreUint32(&o.VCTR8.Reg, volatile.LoadUint32(&o.VCTR8.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR8_B275() uint32 {
	return (volatile.LoadUint32(&o.VCTR8.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR8_B276(value uint32) {
	volatile.StoreUint32(&o.VCTR8.Reg, volatile.LoadUint32(&o.VCTR8.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR8_B276() uint32 {
	return (volatile.LoadUint32(&o.VCTR8.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR8_B277(value uint32) {
	volatile.StoreUint32(&o.VCTR8.Reg, volatile.LoadUint32(&o.VCTR8.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR8_B277() uint32 {
	return (volatile.LoadUint32(&o.VCTR8.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR8_B278(value uint32) {
	volatile.StoreUint32(&o.VCTR8.Reg, volatile.LoadUint32(&o.VCTR8.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR8_B278() uint32 {
	return (volatile.LoadUint32(&o.VCTR8.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR8_B279(value uint32) {
	volatile.StoreUint32(&o.VCTR8.Reg, volatile.LoadUint32(&o.VCTR8.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR8_B279() uint32 {
	return (volatile.LoadUint32(&o.VCTR8.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR8_B280(value uint32) {
	volatile.StoreUint32(&o.VCTR8.Reg, volatile.LoadUint32(&o.VCTR8.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR8_B280() uint32 {
	return (volatile.LoadUint32(&o.VCTR8.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR8_B281(value uint32) {
	volatile.StoreUint32(&o.VCTR8.Reg, volatile.LoadUint32(&o.VCTR8.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR8_B281() uint32 {
	return (volatile.LoadUint32(&o.VCTR8.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR8_B282(value uint32) {
	volatile.StoreUint32(&o.VCTR8.Reg, volatile.LoadUint32(&o.VCTR8.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR8_B282() uint32 {
	return (volatile.LoadUint32(&o.VCTR8.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR8_B283(value uint32) {
	volatile.StoreUint32(&o.VCTR8.Reg, volatile.LoadUint32(&o.VCTR8.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR8_B283() uint32 {
	return (volatile.LoadUint32(&o.VCTR8.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR8_B284(value uint32) {
	volatile.StoreUint32(&o.VCTR8.Reg, volatile.LoadUint32(&o.VCTR8.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR8_B284() uint32 {
	return (volatile.LoadUint32(&o.VCTR8.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR8_B285(value uint32) {
	volatile.StoreUint32(&o.VCTR8.Reg, volatile.LoadUint32(&o.VCTR8.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR8_B285() uint32 {
	return (volatile.LoadUint32(&o.VCTR8.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR8_B286(value uint32) {
	volatile.StoreUint32(&o.VCTR8.Reg, volatile.LoadUint32(&o.VCTR8.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR8_B286() uint32 {
	return (volatile.LoadUint32(&o.VCTR8.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR8_B287(value uint32) {
	volatile.StoreUint32(&o.VCTR8.Reg, volatile.LoadUint32(&o.VCTR8.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR8_B287() uint32 {
	return (volatile.LoadUint32(&o.VCTR8.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR9: MPCBBx vector register
func (o *GTZC_Type) SetVCTR9_B288(value uint32) {
	volatile.StoreUint32(&o.VCTR9.Reg, volatile.LoadUint32(&o.VCTR9.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR9_B288() uint32 {
	return volatile.LoadUint32(&o.VCTR9.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR9_B289(value uint32) {
	volatile.StoreUint32(&o.VCTR9.Reg, volatile.LoadUint32(&o.VCTR9.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR9_B289() uint32 {
	return (volatile.LoadUint32(&o.VCTR9.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR9_B290(value uint32) {
	volatile.StoreUint32(&o.VCTR9.Reg, volatile.LoadUint32(&o.VCTR9.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR9_B290() uint32 {
	return (volatile.LoadUint32(&o.VCTR9.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR9_B291(value uint32) {
	volatile.StoreUint32(&o.VCTR9.Reg, volatile.LoadUint32(&o.VCTR9.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR9_B291() uint32 {
	return (volatile.LoadUint32(&o.VCTR9.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR9_B292(value uint32) {
	volatile.StoreUint32(&o.VCTR9.Reg, volatile.LoadUint32(&o.VCTR9.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR9_B292() uint32 {
	return (volatile.LoadUint32(&o.VCTR9.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR9_B293(value uint32) {
	volatile.StoreUint32(&o.VCTR9.Reg, volatile.LoadUint32(&o.VCTR9.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR9_B293() uint32 {
	return (volatile.LoadUint32(&o.VCTR9.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR9_B294(value uint32) {
	volatile.StoreUint32(&o.VCTR9.Reg, volatile.LoadUint32(&o.VCTR9.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR9_B294() uint32 {
	return (volatile.LoadUint32(&o.VCTR9.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR9_B295(value uint32) {
	volatile.StoreUint32(&o.VCTR9.Reg, volatile.LoadUint32(&o.VCTR9.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR9_B295() uint32 {
	return (volatile.LoadUint32(&o.VCTR9.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR9_B296(value uint32) {
	volatile.StoreUint32(&o.VCTR9.Reg, volatile.LoadUint32(&o.VCTR9.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR9_B296() uint32 {
	return (volatile.LoadUint32(&o.VCTR9.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR9_B297(value uint32) {
	volatile.StoreUint32(&o.VCTR9.Reg, volatile.LoadUint32(&o.VCTR9.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR9_B297() uint32 {
	return (volatile.LoadUint32(&o.VCTR9.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR9_B298(value uint32) {
	volatile.StoreUint32(&o.VCTR9.Reg, volatile.LoadUint32(&o.VCTR9.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR9_B298() uint32 {
	return (volatile.LoadUint32(&o.VCTR9.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR9_B299(value uint32) {
	volatile.StoreUint32(&o.VCTR9.Reg, volatile.LoadUint32(&o.VCTR9.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR9_B299() uint32 {
	return (volatile.LoadUint32(&o.VCTR9.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR9_B300(value uint32) {
	volatile.StoreUint32(&o.VCTR9.Reg, volatile.LoadUint32(&o.VCTR9.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR9_B300() uint32 {
	return (volatile.LoadUint32(&o.VCTR9.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR9_B301(value uint32) {
	volatile.StoreUint32(&o.VCTR9.Reg, volatile.LoadUint32(&o.VCTR9.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR9_B301() uint32 {
	return (volatile.LoadUint32(&o.VCTR9.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR9_B302(value uint32) {
	volatile.StoreUint32(&o.VCTR9.Reg, volatile.LoadUint32(&o.VCTR9.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR9_B302() uint32 {
	return (volatile.LoadUint32(&o.VCTR9.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR9_B303(value uint32) {
	volatile.StoreUint32(&o.VCTR9.Reg, volatile.LoadUint32(&o.VCTR9.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR9_B303() uint32 {
	return (volatile.LoadUint32(&o.VCTR9.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR9_B304(value uint32) {
	volatile.StoreUint32(&o.VCTR9.Reg, volatile.LoadUint32(&o.VCTR9.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR9_B304() uint32 {
	return (volatile.LoadUint32(&o.VCTR9.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR9_B305(value uint32) {
	volatile.StoreUint32(&o.VCTR9.Reg, volatile.LoadUint32(&o.VCTR9.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR9_B305() uint32 {
	return (volatile.LoadUint32(&o.VCTR9.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR9_B306(value uint32) {
	volatile.StoreUint32(&o.VCTR9.Reg, volatile.LoadUint32(&o.VCTR9.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR9_B306() uint32 {
	return (volatile.LoadUint32(&o.VCTR9.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR9_B307(value uint32) {
	volatile.StoreUint32(&o.VCTR9.Reg, volatile.LoadUint32(&o.VCTR9.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR9_B307() uint32 {
	return (volatile.LoadUint32(&o.VCTR9.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR9_B308(value uint32) {
	volatile.StoreUint32(&o.VCTR9.Reg, volatile.LoadUint32(&o.VCTR9.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR9_B308() uint32 {
	return (volatile.LoadUint32(&o.VCTR9.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR9_B309(value uint32) {
	volatile.StoreUint32(&o.VCTR9.Reg, volatile.LoadUint32(&o.VCTR9.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR9_B309() uint32 {
	return (volatile.LoadUint32(&o.VCTR9.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR9_B310(value uint32) {
	volatile.StoreUint32(&o.VCTR9.Reg, volatile.LoadUint32(&o.VCTR9.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR9_B310() uint32 {
	return (volatile.LoadUint32(&o.VCTR9.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR9_B311(value uint32) {
	volatile.StoreUint32(&o.VCTR9.Reg, volatile.LoadUint32(&o.VCTR9.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR9_B311() uint32 {
	return (volatile.LoadUint32(&o.VCTR9.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR9_B312(value uint32) {
	volatile.StoreUint32(&o.VCTR9.Reg, volatile.LoadUint32(&o.VCTR9.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR9_B312() uint32 {
	return (volatile.LoadUint32(&o.VCTR9.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR9_B313(value uint32) {
	volatile.StoreUint32(&o.VCTR9.Reg, volatile.LoadUint32(&o.VCTR9.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR9_B313() uint32 {
	return (volatile.LoadUint32(&o.VCTR9.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR9_B314(value uint32) {
	volatile.StoreUint32(&o.VCTR9.Reg, volatile.LoadUint32(&o.VCTR9.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR9_B314() uint32 {
	return (volatile.LoadUint32(&o.VCTR9.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR9_B315(value uint32) {
	volatile.StoreUint32(&o.VCTR9.Reg, volatile.LoadUint32(&o.VCTR9.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR9_B315() uint32 {
	return (volatile.LoadUint32(&o.VCTR9.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR9_B316(value uint32) {
	volatile.StoreUint32(&o.VCTR9.Reg, volatile.LoadUint32(&o.VCTR9.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR9_B316() uint32 {
	return (volatile.LoadUint32(&o.VCTR9.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR9_B317(value uint32) {
	volatile.StoreUint32(&o.VCTR9.Reg, volatile.LoadUint32(&o.VCTR9.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR9_B317() uint32 {
	return (volatile.LoadUint32(&o.VCTR9.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR9_B318(value uint32) {
	volatile.StoreUint32(&o.VCTR9.Reg, volatile.LoadUint32(&o.VCTR9.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR9_B318() uint32 {
	return (volatile.LoadUint32(&o.VCTR9.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR9_B319(value uint32) {
	volatile.StoreUint32(&o.VCTR9.Reg, volatile.LoadUint32(&o.VCTR9.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR9_B319() uint32 {
	return (volatile.LoadUint32(&o.VCTR9.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR10: MPCBBx vector register
func (o *GTZC_Type) SetVCTR10_B320(value uint32) {
	volatile.StoreUint32(&o.VCTR10.Reg, volatile.LoadUint32(&o.VCTR10.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR10_B320() uint32 {
	return volatile.LoadUint32(&o.VCTR10.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR10_B321(value uint32) {
	volatile.StoreUint32(&o.VCTR10.Reg, volatile.LoadUint32(&o.VCTR10.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR10_B321() uint32 {
	return (volatile.LoadUint32(&o.VCTR10.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR10_B322(value uint32) {
	volatile.StoreUint32(&o.VCTR10.Reg, volatile.LoadUint32(&o.VCTR10.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR10_B322() uint32 {
	return (volatile.LoadUint32(&o.VCTR10.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR10_B323(value uint32) {
	volatile.StoreUint32(&o.VCTR10.Reg, volatile.LoadUint32(&o.VCTR10.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR10_B323() uint32 {
	return (volatile.LoadUint32(&o.VCTR10.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR10_B324(value uint32) {
	volatile.StoreUint32(&o.VCTR10.Reg, volatile.LoadUint32(&o.VCTR10.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR10_B324() uint32 {
	return (volatile.LoadUint32(&o.VCTR10.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR10_B325(value uint32) {
	volatile.StoreUint32(&o.VCTR10.Reg, volatile.LoadUint32(&o.VCTR10.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR10_B325() uint32 {
	return (volatile.LoadUint32(&o.VCTR10.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR10_B326(value uint32) {
	volatile.StoreUint32(&o.VCTR10.Reg, volatile.LoadUint32(&o.VCTR10.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR10_B326() uint32 {
	return (volatile.LoadUint32(&o.VCTR10.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR10_B327(value uint32) {
	volatile.StoreUint32(&o.VCTR10.Reg, volatile.LoadUint32(&o.VCTR10.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR10_B327() uint32 {
	return (volatile.LoadUint32(&o.VCTR10.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR10_B328(value uint32) {
	volatile.StoreUint32(&o.VCTR10.Reg, volatile.LoadUint32(&o.VCTR10.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR10_B328() uint32 {
	return (volatile.LoadUint32(&o.VCTR10.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR10_B329(value uint32) {
	volatile.StoreUint32(&o.VCTR10.Reg, volatile.LoadUint32(&o.VCTR10.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR10_B329() uint32 {
	return (volatile.LoadUint32(&o.VCTR10.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR10_B330(value uint32) {
	volatile.StoreUint32(&o.VCTR10.Reg, volatile.LoadUint32(&o.VCTR10.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR10_B330() uint32 {
	return (volatile.LoadUint32(&o.VCTR10.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR10_B331(value uint32) {
	volatile.StoreUint32(&o.VCTR10.Reg, volatile.LoadUint32(&o.VCTR10.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR10_B331() uint32 {
	return (volatile.LoadUint32(&o.VCTR10.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR10_B332(value uint32) {
	volatile.StoreUint32(&o.VCTR10.Reg, volatile.LoadUint32(&o.VCTR10.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR10_B332() uint32 {
	return (volatile.LoadUint32(&o.VCTR10.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR10_B333(value uint32) {
	volatile.StoreUint32(&o.VCTR10.Reg, volatile.LoadUint32(&o.VCTR10.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR10_B333() uint32 {
	return (volatile.LoadUint32(&o.VCTR10.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR10_B334(value uint32) {
	volatile.StoreUint32(&o.VCTR10.Reg, volatile.LoadUint32(&o.VCTR10.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR10_B334() uint32 {
	return (volatile.LoadUint32(&o.VCTR10.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR10_B335(value uint32) {
	volatile.StoreUint32(&o.VCTR10.Reg, volatile.LoadUint32(&o.VCTR10.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR10_B335() uint32 {
	return (volatile.LoadUint32(&o.VCTR10.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR10_B336(value uint32) {
	volatile.StoreUint32(&o.VCTR10.Reg, volatile.LoadUint32(&o.VCTR10.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR10_B336() uint32 {
	return (volatile.LoadUint32(&o.VCTR10.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR10_B337(value uint32) {
	volatile.StoreUint32(&o.VCTR10.Reg, volatile.LoadUint32(&o.VCTR10.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR10_B337() uint32 {
	return (volatile.LoadUint32(&o.VCTR10.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR10_B338(value uint32) {
	volatile.StoreUint32(&o.VCTR10.Reg, volatile.LoadUint32(&o.VCTR10.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR10_B338() uint32 {
	return (volatile.LoadUint32(&o.VCTR10.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR10_B339(value uint32) {
	volatile.StoreUint32(&o.VCTR10.Reg, volatile.LoadUint32(&o.VCTR10.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR10_B339() uint32 {
	return (volatile.LoadUint32(&o.VCTR10.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR10_B340(value uint32) {
	volatile.StoreUint32(&o.VCTR10.Reg, volatile.LoadUint32(&o.VCTR10.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR10_B340() uint32 {
	return (volatile.LoadUint32(&o.VCTR10.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR10_B341(value uint32) {
	volatile.StoreUint32(&o.VCTR10.Reg, volatile.LoadUint32(&o.VCTR10.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR10_B341() uint32 {
	return (volatile.LoadUint32(&o.VCTR10.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR10_B342(value uint32) {
	volatile.StoreUint32(&o.VCTR10.Reg, volatile.LoadUint32(&o.VCTR10.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR10_B342() uint32 {
	return (volatile.LoadUint32(&o.VCTR10.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR10_B343(value uint32) {
	volatile.StoreUint32(&o.VCTR10.Reg, volatile.LoadUint32(&o.VCTR10.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR10_B343() uint32 {
	return (volatile.LoadUint32(&o.VCTR10.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR10_B344(value uint32) {
	volatile.StoreUint32(&o.VCTR10.Reg, volatile.LoadUint32(&o.VCTR10.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR10_B344() uint32 {
	return (volatile.LoadUint32(&o.VCTR10.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR10_B345(value uint32) {
	volatile.StoreUint32(&o.VCTR10.Reg, volatile.LoadUint32(&o.VCTR10.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR10_B345() uint32 {
	return (volatile.LoadUint32(&o.VCTR10.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR10_B346(value uint32) {
	volatile.StoreUint32(&o.VCTR10.Reg, volatile.LoadUint32(&o.VCTR10.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR10_B346() uint32 {
	return (volatile.LoadUint32(&o.VCTR10.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR10_B347(value uint32) {
	volatile.StoreUint32(&o.VCTR10.Reg, volatile.LoadUint32(&o.VCTR10.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR10_B347() uint32 {
	return (volatile.LoadUint32(&o.VCTR10.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR10_B348(value uint32) {
	volatile.StoreUint32(&o.VCTR10.Reg, volatile.LoadUint32(&o.VCTR10.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR10_B348() uint32 {
	return (volatile.LoadUint32(&o.VCTR10.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR10_B349(value uint32) {
	volatile.StoreUint32(&o.VCTR10.Reg, volatile.LoadUint32(&o.VCTR10.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR10_B349() uint32 {
	return (volatile.LoadUint32(&o.VCTR10.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR10_B350(value uint32) {
	volatile.StoreUint32(&o.VCTR10.Reg, volatile.LoadUint32(&o.VCTR10.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR10_B350() uint32 {
	return (volatile.LoadUint32(&o.VCTR10.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR10_B351(value uint32) {
	volatile.StoreUint32(&o.VCTR10.Reg, volatile.LoadUint32(&o.VCTR10.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR10_B351() uint32 {
	return (volatile.LoadUint32(&o.VCTR10.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR11: MPCBBx vector register
func (o *GTZC_Type) SetVCTR11_B352(value uint32) {
	volatile.StoreUint32(&o.VCTR11.Reg, volatile.LoadUint32(&o.VCTR11.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR11_B352() uint32 {
	return volatile.LoadUint32(&o.VCTR11.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR11_B353(value uint32) {
	volatile.StoreUint32(&o.VCTR11.Reg, volatile.LoadUint32(&o.VCTR11.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR11_B353() uint32 {
	return (volatile.LoadUint32(&o.VCTR11.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR11_B354(value uint32) {
	volatile.StoreUint32(&o.VCTR11.Reg, volatile.LoadUint32(&o.VCTR11.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR11_B354() uint32 {
	return (volatile.LoadUint32(&o.VCTR11.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR11_B355(value uint32) {
	volatile.StoreUint32(&o.VCTR11.Reg, volatile.LoadUint32(&o.VCTR11.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR11_B355() uint32 {
	return (volatile.LoadUint32(&o.VCTR11.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR11_B356(value uint32) {
	volatile.StoreUint32(&o.VCTR11.Reg, volatile.LoadUint32(&o.VCTR11.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR11_B356() uint32 {
	return (volatile.LoadUint32(&o.VCTR11.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR11_B357(value uint32) {
	volatile.StoreUint32(&o.VCTR11.Reg, volatile.LoadUint32(&o.VCTR11.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR11_B357() uint32 {
	return (volatile.LoadUint32(&o.VCTR11.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR11_B358(value uint32) {
	volatile.StoreUint32(&o.VCTR11.Reg, volatile.LoadUint32(&o.VCTR11.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR11_B358() uint32 {
	return (volatile.LoadUint32(&o.VCTR11.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR11_B359(value uint32) {
	volatile.StoreUint32(&o.VCTR11.Reg, volatile.LoadUint32(&o.VCTR11.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR11_B359() uint32 {
	return (volatile.LoadUint32(&o.VCTR11.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR11_B360(value uint32) {
	volatile.StoreUint32(&o.VCTR11.Reg, volatile.LoadUint32(&o.VCTR11.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR11_B360() uint32 {
	return (volatile.LoadUint32(&o.VCTR11.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR11_B361(value uint32) {
	volatile.StoreUint32(&o.VCTR11.Reg, volatile.LoadUint32(&o.VCTR11.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR11_B361() uint32 {
	return (volatile.LoadUint32(&o.VCTR11.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR11_B362(value uint32) {
	volatile.StoreUint32(&o.VCTR11.Reg, volatile.LoadUint32(&o.VCTR11.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR11_B362() uint32 {
	return (volatile.LoadUint32(&o.VCTR11.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR11_B363(value uint32) {
	volatile.StoreUint32(&o.VCTR11.Reg, volatile.LoadUint32(&o.VCTR11.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR11_B363() uint32 {
	return (volatile.LoadUint32(&o.VCTR11.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR11_B364(value uint32) {
	volatile.StoreUint32(&o.VCTR11.Reg, volatile.LoadUint32(&o.VCTR11.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR11_B364() uint32 {
	return (volatile.LoadUint32(&o.VCTR11.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR11_B365(value uint32) {
	volatile.StoreUint32(&o.VCTR11.Reg, volatile.LoadUint32(&o.VCTR11.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR11_B365() uint32 {
	return (volatile.LoadUint32(&o.VCTR11.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR11_B366(value uint32) {
	volatile.StoreUint32(&o.VCTR11.Reg, volatile.LoadUint32(&o.VCTR11.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR11_B366() uint32 {
	return (volatile.LoadUint32(&o.VCTR11.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR11_B367(value uint32) {
	volatile.StoreUint32(&o.VCTR11.Reg, volatile.LoadUint32(&o.VCTR11.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR11_B367() uint32 {
	return (volatile.LoadUint32(&o.VCTR11.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR11_B368(value uint32) {
	volatile.StoreUint32(&o.VCTR11.Reg, volatile.LoadUint32(&o.VCTR11.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR11_B368() uint32 {
	return (volatile.LoadUint32(&o.VCTR11.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR11_B369(value uint32) {
	volatile.StoreUint32(&o.VCTR11.Reg, volatile.LoadUint32(&o.VCTR11.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR11_B369() uint32 {
	return (volatile.LoadUint32(&o.VCTR11.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR11_B370(value uint32) {
	volatile.StoreUint32(&o.VCTR11.Reg, volatile.LoadUint32(&o.VCTR11.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR11_B370() uint32 {
	return (volatile.LoadUint32(&o.VCTR11.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR11_B371(value uint32) {
	volatile.StoreUint32(&o.VCTR11.Reg, volatile.LoadUint32(&o.VCTR11.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR11_B371() uint32 {
	return (volatile.LoadUint32(&o.VCTR11.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR11_B372(value uint32) {
	volatile.StoreUint32(&o.VCTR11.Reg, volatile.LoadUint32(&o.VCTR11.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR11_B372() uint32 {
	return (volatile.LoadUint32(&o.VCTR11.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR11_B373(value uint32) {
	volatile.StoreUint32(&o.VCTR11.Reg, volatile.LoadUint32(&o.VCTR11.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR11_B373() uint32 {
	return (volatile.LoadUint32(&o.VCTR11.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR11_B374(value uint32) {
	volatile.StoreUint32(&o.VCTR11.Reg, volatile.LoadUint32(&o.VCTR11.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR11_B374() uint32 {
	return (volatile.LoadUint32(&o.VCTR11.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR11_B375(value uint32) {
	volatile.StoreUint32(&o.VCTR11.Reg, volatile.LoadUint32(&o.VCTR11.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR11_B375() uint32 {
	return (volatile.LoadUint32(&o.VCTR11.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR11_B376(value uint32) {
	volatile.StoreUint32(&o.VCTR11.Reg, volatile.LoadUint32(&o.VCTR11.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR11_B376() uint32 {
	return (volatile.LoadUint32(&o.VCTR11.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR11_B377(value uint32) {
	volatile.StoreUint32(&o.VCTR11.Reg, volatile.LoadUint32(&o.VCTR11.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR11_B377() uint32 {
	return (volatile.LoadUint32(&o.VCTR11.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR11_B378(value uint32) {
	volatile.StoreUint32(&o.VCTR11.Reg, volatile.LoadUint32(&o.VCTR11.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR11_B378() uint32 {
	return (volatile.LoadUint32(&o.VCTR11.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR11_B379(value uint32) {
	volatile.StoreUint32(&o.VCTR11.Reg, volatile.LoadUint32(&o.VCTR11.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR11_B379() uint32 {
	return (volatile.LoadUint32(&o.VCTR11.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR11_B380(value uint32) {
	volatile.StoreUint32(&o.VCTR11.Reg, volatile.LoadUint32(&o.VCTR11.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR11_B380() uint32 {
	return (volatile.LoadUint32(&o.VCTR11.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR11_B381(value uint32) {
	volatile.StoreUint32(&o.VCTR11.Reg, volatile.LoadUint32(&o.VCTR11.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR11_B381() uint32 {
	return (volatile.LoadUint32(&o.VCTR11.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR11_B382(value uint32) {
	volatile.StoreUint32(&o.VCTR11.Reg, volatile.LoadUint32(&o.VCTR11.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR11_B382() uint32 {
	return (volatile.LoadUint32(&o.VCTR11.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR11_B383(value uint32) {
	volatile.StoreUint32(&o.VCTR11.Reg, volatile.LoadUint32(&o.VCTR11.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR11_B383() uint32 {
	return (volatile.LoadUint32(&o.VCTR11.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR12: MPCBBx vector register
func (o *GTZC_Type) SetVCTR12_B384(value uint32) {
	volatile.StoreUint32(&o.VCTR12.Reg, volatile.LoadUint32(&o.VCTR12.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR12_B384() uint32 {
	return volatile.LoadUint32(&o.VCTR12.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR12_B385(value uint32) {
	volatile.StoreUint32(&o.VCTR12.Reg, volatile.LoadUint32(&o.VCTR12.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR12_B385() uint32 {
	return (volatile.LoadUint32(&o.VCTR12.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR12_B386(value uint32) {
	volatile.StoreUint32(&o.VCTR12.Reg, volatile.LoadUint32(&o.VCTR12.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR12_B386() uint32 {
	return (volatile.LoadUint32(&o.VCTR12.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR12_B387(value uint32) {
	volatile.StoreUint32(&o.VCTR12.Reg, volatile.LoadUint32(&o.VCTR12.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR12_B387() uint32 {
	return (volatile.LoadUint32(&o.VCTR12.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR12_B388(value uint32) {
	volatile.StoreUint32(&o.VCTR12.Reg, volatile.LoadUint32(&o.VCTR12.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR12_B388() uint32 {
	return (volatile.LoadUint32(&o.VCTR12.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR12_B389(value uint32) {
	volatile.StoreUint32(&o.VCTR12.Reg, volatile.LoadUint32(&o.VCTR12.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR12_B389() uint32 {
	return (volatile.LoadUint32(&o.VCTR12.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR12_B390(value uint32) {
	volatile.StoreUint32(&o.VCTR12.Reg, volatile.LoadUint32(&o.VCTR12.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR12_B390() uint32 {
	return (volatile.LoadUint32(&o.VCTR12.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR12_B391(value uint32) {
	volatile.StoreUint32(&o.VCTR12.Reg, volatile.LoadUint32(&o.VCTR12.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR12_B391() uint32 {
	return (volatile.LoadUint32(&o.VCTR12.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR12_B392(value uint32) {
	volatile.StoreUint32(&o.VCTR12.Reg, volatile.LoadUint32(&o.VCTR12.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR12_B392() uint32 {
	return (volatile.LoadUint32(&o.VCTR12.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR12_B393(value uint32) {
	volatile.StoreUint32(&o.VCTR12.Reg, volatile.LoadUint32(&o.VCTR12.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR12_B393() uint32 {
	return (volatile.LoadUint32(&o.VCTR12.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR12_B394(value uint32) {
	volatile.StoreUint32(&o.VCTR12.Reg, volatile.LoadUint32(&o.VCTR12.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR12_B394() uint32 {
	return (volatile.LoadUint32(&o.VCTR12.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR12_B395(value uint32) {
	volatile.StoreUint32(&o.VCTR12.Reg, volatile.LoadUint32(&o.VCTR12.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR12_B395() uint32 {
	return (volatile.LoadUint32(&o.VCTR12.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR12_B396(value uint32) {
	volatile.StoreUint32(&o.VCTR12.Reg, volatile.LoadUint32(&o.VCTR12.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR12_B396() uint32 {
	return (volatile.LoadUint32(&o.VCTR12.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR12_B397(value uint32) {
	volatile.StoreUint32(&o.VCTR12.Reg, volatile.LoadUint32(&o.VCTR12.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR12_B397() uint32 {
	return (volatile.LoadUint32(&o.VCTR12.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR12_B398(value uint32) {
	volatile.StoreUint32(&o.VCTR12.Reg, volatile.LoadUint32(&o.VCTR12.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR12_B398() uint32 {
	return (volatile.LoadUint32(&o.VCTR12.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR12_B399(value uint32) {
	volatile.StoreUint32(&o.VCTR12.Reg, volatile.LoadUint32(&o.VCTR12.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR12_B399() uint32 {
	return (volatile.LoadUint32(&o.VCTR12.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR12_B400(value uint32) {
	volatile.StoreUint32(&o.VCTR12.Reg, volatile.LoadUint32(&o.VCTR12.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR12_B400() uint32 {
	return (volatile.LoadUint32(&o.VCTR12.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR12_B401(value uint32) {
	volatile.StoreUint32(&o.VCTR12.Reg, volatile.LoadUint32(&o.VCTR12.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR12_B401() uint32 {
	return (volatile.LoadUint32(&o.VCTR12.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR12_B402(value uint32) {
	volatile.StoreUint32(&o.VCTR12.Reg, volatile.LoadUint32(&o.VCTR12.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR12_B402() uint32 {
	return (volatile.LoadUint32(&o.VCTR12.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR12_B403(value uint32) {
	volatile.StoreUint32(&o.VCTR12.Reg, volatile.LoadUint32(&o.VCTR12.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR12_B403() uint32 {
	return (volatile.LoadUint32(&o.VCTR12.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR12_B404(value uint32) {
	volatile.StoreUint32(&o.VCTR12.Reg, volatile.LoadUint32(&o.VCTR12.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR12_B404() uint32 {
	return (volatile.LoadUint32(&o.VCTR12.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR12_B405(value uint32) {
	volatile.StoreUint32(&o.VCTR12.Reg, volatile.LoadUint32(&o.VCTR12.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR12_B405() uint32 {
	return (volatile.LoadUint32(&o.VCTR12.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR12_B406(value uint32) {
	volatile.StoreUint32(&o.VCTR12.Reg, volatile.LoadUint32(&o.VCTR12.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR12_B406() uint32 {
	return (volatile.LoadUint32(&o.VCTR12.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR12_B407(value uint32) {
	volatile.StoreUint32(&o.VCTR12.Reg, volatile.LoadUint32(&o.VCTR12.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR12_B407() uint32 {
	return (volatile.LoadUint32(&o.VCTR12.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR12_B408(value uint32) {
	volatile.StoreUint32(&o.VCTR12.Reg, volatile.LoadUint32(&o.VCTR12.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR12_B408() uint32 {
	return (volatile.LoadUint32(&o.VCTR12.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR12_B409(value uint32) {
	volatile.StoreUint32(&o.VCTR12.Reg, volatile.LoadUint32(&o.VCTR12.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR12_B409() uint32 {
	return (volatile.LoadUint32(&o.VCTR12.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR12_B410(value uint32) {
	volatile.StoreUint32(&o.VCTR12.Reg, volatile.LoadUint32(&o.VCTR12.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR12_B410() uint32 {
	return (volatile.LoadUint32(&o.VCTR12.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR12_B411(value uint32) {
	volatile.StoreUint32(&o.VCTR12.Reg, volatile.LoadUint32(&o.VCTR12.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR12_B411() uint32 {
	return (volatile.LoadUint32(&o.VCTR12.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR12_B412(value uint32) {
	volatile.StoreUint32(&o.VCTR12.Reg, volatile.LoadUint32(&o.VCTR12.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR12_B412() uint32 {
	return (volatile.LoadUint32(&o.VCTR12.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR12_B413(value uint32) {
	volatile.StoreUint32(&o.VCTR12.Reg, volatile.LoadUint32(&o.VCTR12.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR12_B413() uint32 {
	return (volatile.LoadUint32(&o.VCTR12.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR12_B414(value uint32) {
	volatile.StoreUint32(&o.VCTR12.Reg, volatile.LoadUint32(&o.VCTR12.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR12_B414() uint32 {
	return (volatile.LoadUint32(&o.VCTR12.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR12_B415(value uint32) {
	volatile.StoreUint32(&o.VCTR12.Reg, volatile.LoadUint32(&o.VCTR12.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR12_B415() uint32 {
	return (volatile.LoadUint32(&o.VCTR12.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR13: MPCBBx vector register
func (o *GTZC_Type) SetVCTR13_B416(value uint32) {
	volatile.StoreUint32(&o.VCTR13.Reg, volatile.LoadUint32(&o.VCTR13.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR13_B416() uint32 {
	return volatile.LoadUint32(&o.VCTR13.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR13_B417(value uint32) {
	volatile.StoreUint32(&o.VCTR13.Reg, volatile.LoadUint32(&o.VCTR13.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR13_B417() uint32 {
	return (volatile.LoadUint32(&o.VCTR13.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR13_B418(value uint32) {
	volatile.StoreUint32(&o.VCTR13.Reg, volatile.LoadUint32(&o.VCTR13.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR13_B418() uint32 {
	return (volatile.LoadUint32(&o.VCTR13.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR13_B419(value uint32) {
	volatile.StoreUint32(&o.VCTR13.Reg, volatile.LoadUint32(&o.VCTR13.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR13_B419() uint32 {
	return (volatile.LoadUint32(&o.VCTR13.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR13_B420(value uint32) {
	volatile.StoreUint32(&o.VCTR13.Reg, volatile.LoadUint32(&o.VCTR13.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR13_B420() uint32 {
	return (volatile.LoadUint32(&o.VCTR13.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR13_B421(value uint32) {
	volatile.StoreUint32(&o.VCTR13.Reg, volatile.LoadUint32(&o.VCTR13.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR13_B421() uint32 {
	return (volatile.LoadUint32(&o.VCTR13.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR13_B422(value uint32) {
	volatile.StoreUint32(&o.VCTR13.Reg, volatile.LoadUint32(&o.VCTR13.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR13_B422() uint32 {
	return (volatile.LoadUint32(&o.VCTR13.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR13_B423(value uint32) {
	volatile.StoreUint32(&o.VCTR13.Reg, volatile.LoadUint32(&o.VCTR13.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR13_B423() uint32 {
	return (volatile.LoadUint32(&o.VCTR13.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR13_B424(value uint32) {
	volatile.StoreUint32(&o.VCTR13.Reg, volatile.LoadUint32(&o.VCTR13.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR13_B424() uint32 {
	return (volatile.LoadUint32(&o.VCTR13.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR13_B425(value uint32) {
	volatile.StoreUint32(&o.VCTR13.Reg, volatile.LoadUint32(&o.VCTR13.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR13_B425() uint32 {
	return (volatile.LoadUint32(&o.VCTR13.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR13_B426(value uint32) {
	volatile.StoreUint32(&o.VCTR13.Reg, volatile.LoadUint32(&o.VCTR13.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR13_B426() uint32 {
	return (volatile.LoadUint32(&o.VCTR13.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR13_B427(value uint32) {
	volatile.StoreUint32(&o.VCTR13.Reg, volatile.LoadUint32(&o.VCTR13.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR13_B427() uint32 {
	return (volatile.LoadUint32(&o.VCTR13.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR13_B428(value uint32) {
	volatile.StoreUint32(&o.VCTR13.Reg, volatile.LoadUint32(&o.VCTR13.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR13_B428() uint32 {
	return (volatile.LoadUint32(&o.VCTR13.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR13_B429(value uint32) {
	volatile.StoreUint32(&o.VCTR13.Reg, volatile.LoadUint32(&o.VCTR13.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR13_B429() uint32 {
	return (volatile.LoadUint32(&o.VCTR13.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR13_B430(value uint32) {
	volatile.StoreUint32(&o.VCTR13.Reg, volatile.LoadUint32(&o.VCTR13.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR13_B430() uint32 {
	return (volatile.LoadUint32(&o.VCTR13.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR13_B431(value uint32) {
	volatile.StoreUint32(&o.VCTR13.Reg, volatile.LoadUint32(&o.VCTR13.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR13_B431() uint32 {
	return (volatile.LoadUint32(&o.VCTR13.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR13_B432(value uint32) {
	volatile.StoreUint32(&o.VCTR13.Reg, volatile.LoadUint32(&o.VCTR13.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR13_B432() uint32 {
	return (volatile.LoadUint32(&o.VCTR13.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR13_B433(value uint32) {
	volatile.StoreUint32(&o.VCTR13.Reg, volatile.LoadUint32(&o.VCTR13.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR13_B433() uint32 {
	return (volatile.LoadUint32(&o.VCTR13.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR13_B434(value uint32) {
	volatile.StoreUint32(&o.VCTR13.Reg, volatile.LoadUint32(&o.VCTR13.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR13_B434() uint32 {
	return (volatile.LoadUint32(&o.VCTR13.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR13_B435(value uint32) {
	volatile.StoreUint32(&o.VCTR13.Reg, volatile.LoadUint32(&o.VCTR13.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR13_B435() uint32 {
	return (volatile.LoadUint32(&o.VCTR13.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR13_B436(value uint32) {
	volatile.StoreUint32(&o.VCTR13.Reg, volatile.LoadUint32(&o.VCTR13.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR13_B436() uint32 {
	return (volatile.LoadUint32(&o.VCTR13.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR13_B437(value uint32) {
	volatile.StoreUint32(&o.VCTR13.Reg, volatile.LoadUint32(&o.VCTR13.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR13_B437() uint32 {
	return (volatile.LoadUint32(&o.VCTR13.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR13_B438(value uint32) {
	volatile.StoreUint32(&o.VCTR13.Reg, volatile.LoadUint32(&o.VCTR13.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR13_B438() uint32 {
	return (volatile.LoadUint32(&o.VCTR13.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR13_B439(value uint32) {
	volatile.StoreUint32(&o.VCTR13.Reg, volatile.LoadUint32(&o.VCTR13.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR13_B439() uint32 {
	return (volatile.LoadUint32(&o.VCTR13.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR13_B440(value uint32) {
	volatile.StoreUint32(&o.VCTR13.Reg, volatile.LoadUint32(&o.VCTR13.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR13_B440() uint32 {
	return (volatile.LoadUint32(&o.VCTR13.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR13_B441(value uint32) {
	volatile.StoreUint32(&o.VCTR13.Reg, volatile.LoadUint32(&o.VCTR13.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR13_B441() uint32 {
	return (volatile.LoadUint32(&o.VCTR13.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR13_B442(value uint32) {
	volatile.StoreUint32(&o.VCTR13.Reg, volatile.LoadUint32(&o.VCTR13.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR13_B442() uint32 {
	return (volatile.LoadUint32(&o.VCTR13.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR13_B443(value uint32) {
	volatile.StoreUint32(&o.VCTR13.Reg, volatile.LoadUint32(&o.VCTR13.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR13_B443() uint32 {
	return (volatile.LoadUint32(&o.VCTR13.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR13_B444(value uint32) {
	volatile.StoreUint32(&o.VCTR13.Reg, volatile.LoadUint32(&o.VCTR13.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR13_B444() uint32 {
	return (volatile.LoadUint32(&o.VCTR13.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR13_B445(value uint32) {
	volatile.StoreUint32(&o.VCTR13.Reg, volatile.LoadUint32(&o.VCTR13.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR13_B445() uint32 {
	return (volatile.LoadUint32(&o.VCTR13.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR13_B446(value uint32) {
	volatile.StoreUint32(&o.VCTR13.Reg, volatile.LoadUint32(&o.VCTR13.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR13_B446() uint32 {
	return (volatile.LoadUint32(&o.VCTR13.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR13_B447(value uint32) {
	volatile.StoreUint32(&o.VCTR13.Reg, volatile.LoadUint32(&o.VCTR13.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR13_B447() uint32 {
	return (volatile.LoadUint32(&o.VCTR13.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR14: MPCBBx vector register
func (o *GTZC_Type) SetVCTR14_B448(value uint32) {
	volatile.StoreUint32(&o.VCTR14.Reg, volatile.LoadUint32(&o.VCTR14.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR14_B448() uint32 {
	return volatile.LoadUint32(&o.VCTR14.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR14_B449(value uint32) {
	volatile.StoreUint32(&o.VCTR14.Reg, volatile.LoadUint32(&o.VCTR14.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR14_B449() uint32 {
	return (volatile.LoadUint32(&o.VCTR14.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR14_B450(value uint32) {
	volatile.StoreUint32(&o.VCTR14.Reg, volatile.LoadUint32(&o.VCTR14.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR14_B450() uint32 {
	return (volatile.LoadUint32(&o.VCTR14.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR14_B451(value uint32) {
	volatile.StoreUint32(&o.VCTR14.Reg, volatile.LoadUint32(&o.VCTR14.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR14_B451() uint32 {
	return (volatile.LoadUint32(&o.VCTR14.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR14_B452(value uint32) {
	volatile.StoreUint32(&o.VCTR14.Reg, volatile.LoadUint32(&o.VCTR14.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR14_B452() uint32 {
	return (volatile.LoadUint32(&o.VCTR14.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR14_B453(value uint32) {
	volatile.StoreUint32(&o.VCTR14.Reg, volatile.LoadUint32(&o.VCTR14.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR14_B453() uint32 {
	return (volatile.LoadUint32(&o.VCTR14.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR14_B454(value uint32) {
	volatile.StoreUint32(&o.VCTR14.Reg, volatile.LoadUint32(&o.VCTR14.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR14_B454() uint32 {
	return (volatile.LoadUint32(&o.VCTR14.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR14_B455(value uint32) {
	volatile.StoreUint32(&o.VCTR14.Reg, volatile.LoadUint32(&o.VCTR14.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR14_B455() uint32 {
	return (volatile.LoadUint32(&o.VCTR14.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR14_B456(value uint32) {
	volatile.StoreUint32(&o.VCTR14.Reg, volatile.LoadUint32(&o.VCTR14.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR14_B456() uint32 {
	return (volatile.LoadUint32(&o.VCTR14.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR14_B457(value uint32) {
	volatile.StoreUint32(&o.VCTR14.Reg, volatile.LoadUint32(&o.VCTR14.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR14_B457() uint32 {
	return (volatile.LoadUint32(&o.VCTR14.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR14_B458(value uint32) {
	volatile.StoreUint32(&o.VCTR14.Reg, volatile.LoadUint32(&o.VCTR14.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR14_B458() uint32 {
	return (volatile.LoadUint32(&o.VCTR14.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR14_B459(value uint32) {
	volatile.StoreUint32(&o.VCTR14.Reg, volatile.LoadUint32(&o.VCTR14.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR14_B459() uint32 {
	return (volatile.LoadUint32(&o.VCTR14.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR14_B460(value uint32) {
	volatile.StoreUint32(&o.VCTR14.Reg, volatile.LoadUint32(&o.VCTR14.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR14_B460() uint32 {
	return (volatile.LoadUint32(&o.VCTR14.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR14_B461(value uint32) {
	volatile.StoreUint32(&o.VCTR14.Reg, volatile.LoadUint32(&o.VCTR14.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR14_B461() uint32 {
	return (volatile.LoadUint32(&o.VCTR14.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR14_B462(value uint32) {
	volatile.StoreUint32(&o.VCTR14.Reg, volatile.LoadUint32(&o.VCTR14.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR14_B462() uint32 {
	return (volatile.LoadUint32(&o.VCTR14.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR14_B463(value uint32) {
	volatile.StoreUint32(&o.VCTR14.Reg, volatile.LoadUint32(&o.VCTR14.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR14_B463() uint32 {
	return (volatile.LoadUint32(&o.VCTR14.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR14_B464(value uint32) {
	volatile.StoreUint32(&o.VCTR14.Reg, volatile.LoadUint32(&o.VCTR14.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR14_B464() uint32 {
	return (volatile.LoadUint32(&o.VCTR14.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR14_B465(value uint32) {
	volatile.StoreUint32(&o.VCTR14.Reg, volatile.LoadUint32(&o.VCTR14.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR14_B465() uint32 {
	return (volatile.LoadUint32(&o.VCTR14.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR14_B466(value uint32) {
	volatile.StoreUint32(&o.VCTR14.Reg, volatile.LoadUint32(&o.VCTR14.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR14_B466() uint32 {
	return (volatile.LoadUint32(&o.VCTR14.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR14_B467(value uint32) {
	volatile.StoreUint32(&o.VCTR14.Reg, volatile.LoadUint32(&o.VCTR14.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR14_B467() uint32 {
	return (volatile.LoadUint32(&o.VCTR14.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR14_B468(value uint32) {
	volatile.StoreUint32(&o.VCTR14.Reg, volatile.LoadUint32(&o.VCTR14.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR14_B468() uint32 {
	return (volatile.LoadUint32(&o.VCTR14.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR14_B469(value uint32) {
	volatile.StoreUint32(&o.VCTR14.Reg, volatile.LoadUint32(&o.VCTR14.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR14_B469() uint32 {
	return (volatile.LoadUint32(&o.VCTR14.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR14_B470(value uint32) {
	volatile.StoreUint32(&o.VCTR14.Reg, volatile.LoadUint32(&o.VCTR14.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR14_B470() uint32 {
	return (volatile.LoadUint32(&o.VCTR14.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR14_B471(value uint32) {
	volatile.StoreUint32(&o.VCTR14.Reg, volatile.LoadUint32(&o.VCTR14.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR14_B471() uint32 {
	return (volatile.LoadUint32(&o.VCTR14.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR14_B472(value uint32) {
	volatile.StoreUint32(&o.VCTR14.Reg, volatile.LoadUint32(&o.VCTR14.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR14_B472() uint32 {
	return (volatile.LoadUint32(&o.VCTR14.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR14_B473(value uint32) {
	volatile.StoreUint32(&o.VCTR14.Reg, volatile.LoadUint32(&o.VCTR14.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR14_B473() uint32 {
	return (volatile.LoadUint32(&o.VCTR14.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR14_B474(value uint32) {
	volatile.StoreUint32(&o.VCTR14.Reg, volatile.LoadUint32(&o.VCTR14.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR14_B474() uint32 {
	return (volatile.LoadUint32(&o.VCTR14.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR14_B475(value uint32) {
	volatile.StoreUint32(&o.VCTR14.Reg, volatile.LoadUint32(&o.VCTR14.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR14_B475() uint32 {
	return (volatile.LoadUint32(&o.VCTR14.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR14_B476(value uint32) {
	volatile.StoreUint32(&o.VCTR14.Reg, volatile.LoadUint32(&o.VCTR14.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR14_B476() uint32 {
	return (volatile.LoadUint32(&o.VCTR14.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR14_B477(value uint32) {
	volatile.StoreUint32(&o.VCTR14.Reg, volatile.LoadUint32(&o.VCTR14.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR14_B477() uint32 {
	return (volatile.LoadUint32(&o.VCTR14.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR14_B478(value uint32) {
	volatile.StoreUint32(&o.VCTR14.Reg, volatile.LoadUint32(&o.VCTR14.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR14_B478() uint32 {
	return (volatile.LoadUint32(&o.VCTR14.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR14_B479(value uint32) {
	volatile.StoreUint32(&o.VCTR14.Reg, volatile.LoadUint32(&o.VCTR14.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR14_B479() uint32 {
	return (volatile.LoadUint32(&o.VCTR14.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR15: MPCBBx vector register
func (o *GTZC_Type) SetVCTR15_B480(value uint32) {
	volatile.StoreUint32(&o.VCTR15.Reg, volatile.LoadUint32(&o.VCTR15.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR15_B480() uint32 {
	return volatile.LoadUint32(&o.VCTR15.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR15_B481(value uint32) {
	volatile.StoreUint32(&o.VCTR15.Reg, volatile.LoadUint32(&o.VCTR15.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR15_B481() uint32 {
	return (volatile.LoadUint32(&o.VCTR15.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR15_B482(value uint32) {
	volatile.StoreUint32(&o.VCTR15.Reg, volatile.LoadUint32(&o.VCTR15.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR15_B482() uint32 {
	return (volatile.LoadUint32(&o.VCTR15.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR15_B483(value uint32) {
	volatile.StoreUint32(&o.VCTR15.Reg, volatile.LoadUint32(&o.VCTR15.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR15_B483() uint32 {
	return (volatile.LoadUint32(&o.VCTR15.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR15_B484(value uint32) {
	volatile.StoreUint32(&o.VCTR15.Reg, volatile.LoadUint32(&o.VCTR15.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR15_B484() uint32 {
	return (volatile.LoadUint32(&o.VCTR15.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR15_B485(value uint32) {
	volatile.StoreUint32(&o.VCTR15.Reg, volatile.LoadUint32(&o.VCTR15.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR15_B485() uint32 {
	return (volatile.LoadUint32(&o.VCTR15.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR15_B486(value uint32) {
	volatile.StoreUint32(&o.VCTR15.Reg, volatile.LoadUint32(&o.VCTR15.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR15_B486() uint32 {
	return (volatile.LoadUint32(&o.VCTR15.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR15_B487(value uint32) {
	volatile.StoreUint32(&o.VCTR15.Reg, volatile.LoadUint32(&o.VCTR15.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR15_B487() uint32 {
	return (volatile.LoadUint32(&o.VCTR15.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR15_B488(value uint32) {
	volatile.StoreUint32(&o.VCTR15.Reg, volatile.LoadUint32(&o.VCTR15.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR15_B488() uint32 {
	return (volatile.LoadUint32(&o.VCTR15.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR15_B489(value uint32) {
	volatile.StoreUint32(&o.VCTR15.Reg, volatile.LoadUint32(&o.VCTR15.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR15_B489() uint32 {
	return (volatile.LoadUint32(&o.VCTR15.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR15_B490(value uint32) {
	volatile.StoreUint32(&o.VCTR15.Reg, volatile.LoadUint32(&o.VCTR15.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR15_B490() uint32 {
	return (volatile.LoadUint32(&o.VCTR15.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR15_B491(value uint32) {
	volatile.StoreUint32(&o.VCTR15.Reg, volatile.LoadUint32(&o.VCTR15.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR15_B491() uint32 {
	return (volatile.LoadUint32(&o.VCTR15.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR15_B492(value uint32) {
	volatile.StoreUint32(&o.VCTR15.Reg, volatile.LoadUint32(&o.VCTR15.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR15_B492() uint32 {
	return (volatile.LoadUint32(&o.VCTR15.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR15_B493(value uint32) {
	volatile.StoreUint32(&o.VCTR15.Reg, volatile.LoadUint32(&o.VCTR15.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR15_B493() uint32 {
	return (volatile.LoadUint32(&o.VCTR15.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR15_B494(value uint32) {
	volatile.StoreUint32(&o.VCTR15.Reg, volatile.LoadUint32(&o.VCTR15.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR15_B494() uint32 {
	return (volatile.LoadUint32(&o.VCTR15.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR15_B495(value uint32) {
	volatile.StoreUint32(&o.VCTR15.Reg, volatile.LoadUint32(&o.VCTR15.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR15_B495() uint32 {
	return (volatile.LoadUint32(&o.VCTR15.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR15_B496(value uint32) {
	volatile.StoreUint32(&o.VCTR15.Reg, volatile.LoadUint32(&o.VCTR15.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR15_B496() uint32 {
	return (volatile.LoadUint32(&o.VCTR15.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR15_B497(value uint32) {
	volatile.StoreUint32(&o.VCTR15.Reg, volatile.LoadUint32(&o.VCTR15.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR15_B497() uint32 {
	return (volatile.LoadUint32(&o.VCTR15.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR15_B498(value uint32) {
	volatile.StoreUint32(&o.VCTR15.Reg, volatile.LoadUint32(&o.VCTR15.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR15_B498() uint32 {
	return (volatile.LoadUint32(&o.VCTR15.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR15_B499(value uint32) {
	volatile.StoreUint32(&o.VCTR15.Reg, volatile.LoadUint32(&o.VCTR15.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR15_B499() uint32 {
	return (volatile.LoadUint32(&o.VCTR15.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR15_B500(value uint32) {
	volatile.StoreUint32(&o.VCTR15.Reg, volatile.LoadUint32(&o.VCTR15.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR15_B500() uint32 {
	return (volatile.LoadUint32(&o.VCTR15.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR15_B501(value uint32) {
	volatile.StoreUint32(&o.VCTR15.Reg, volatile.LoadUint32(&o.VCTR15.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR15_B501() uint32 {
	return (volatile.LoadUint32(&o.VCTR15.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR15_B502(value uint32) {
	volatile.StoreUint32(&o.VCTR15.Reg, volatile.LoadUint32(&o.VCTR15.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR15_B502() uint32 {
	return (volatile.LoadUint32(&o.VCTR15.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR15_B503(value uint32) {
	volatile.StoreUint32(&o.VCTR15.Reg, volatile.LoadUint32(&o.VCTR15.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR15_B503() uint32 {
	return (volatile.LoadUint32(&o.VCTR15.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR15_B504(value uint32) {
	volatile.StoreUint32(&o.VCTR15.Reg, volatile.LoadUint32(&o.VCTR15.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR15_B504() uint32 {
	return (volatile.LoadUint32(&o.VCTR15.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR15_B505(value uint32) {
	volatile.StoreUint32(&o.VCTR15.Reg, volatile.LoadUint32(&o.VCTR15.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR15_B505() uint32 {
	return (volatile.LoadUint32(&o.VCTR15.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR15_B506(value uint32) {
	volatile.StoreUint32(&o.VCTR15.Reg, volatile.LoadUint32(&o.VCTR15.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR15_B506() uint32 {
	return (volatile.LoadUint32(&o.VCTR15.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR15_B507(value uint32) {
	volatile.StoreUint32(&o.VCTR15.Reg, volatile.LoadUint32(&o.VCTR15.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR15_B507() uint32 {
	return (volatile.LoadUint32(&o.VCTR15.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR15_B508(value uint32) {
	volatile.StoreUint32(&o.VCTR15.Reg, volatile.LoadUint32(&o.VCTR15.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR15_B508() uint32 {
	return (volatile.LoadUint32(&o.VCTR15.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR15_B509(value uint32) {
	volatile.StoreUint32(&o.VCTR15.Reg, volatile.LoadUint32(&o.VCTR15.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR15_B509() uint32 {
	return (volatile.LoadUint32(&o.VCTR15.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR15_B510(value uint32) {
	volatile.StoreUint32(&o.VCTR15.Reg, volatile.LoadUint32(&o.VCTR15.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR15_B510() uint32 {
	return (volatile.LoadUint32(&o.VCTR15.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR15_B511(value uint32) {
	volatile.StoreUint32(&o.VCTR15.Reg, volatile.LoadUint32(&o.VCTR15.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR15_B511() uint32 {
	return (volatile.LoadUint32(&o.VCTR15.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR16: MPCBBx vector register
func (o *GTZC_Type) SetVCTR16_B512(value uint32) {
	volatile.StoreUint32(&o.VCTR16.Reg, volatile.LoadUint32(&o.VCTR16.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR16_B512() uint32 {
	return volatile.LoadUint32(&o.VCTR16.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR16_B513(value uint32) {
	volatile.StoreUint32(&o.VCTR16.Reg, volatile.LoadUint32(&o.VCTR16.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR16_B513() uint32 {
	return (volatile.LoadUint32(&o.VCTR16.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR16_B514(value uint32) {
	volatile.StoreUint32(&o.VCTR16.Reg, volatile.LoadUint32(&o.VCTR16.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR16_B514() uint32 {
	return (volatile.LoadUint32(&o.VCTR16.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR16_B515(value uint32) {
	volatile.StoreUint32(&o.VCTR16.Reg, volatile.LoadUint32(&o.VCTR16.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR16_B515() uint32 {
	return (volatile.LoadUint32(&o.VCTR16.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR16_B516(value uint32) {
	volatile.StoreUint32(&o.VCTR16.Reg, volatile.LoadUint32(&o.VCTR16.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR16_B516() uint32 {
	return (volatile.LoadUint32(&o.VCTR16.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR16_B517(value uint32) {
	volatile.StoreUint32(&o.VCTR16.Reg, volatile.LoadUint32(&o.VCTR16.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR16_B517() uint32 {
	return (volatile.LoadUint32(&o.VCTR16.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR16_B518(value uint32) {
	volatile.StoreUint32(&o.VCTR16.Reg, volatile.LoadUint32(&o.VCTR16.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR16_B518() uint32 {
	return (volatile.LoadUint32(&o.VCTR16.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR16_B519(value uint32) {
	volatile.StoreUint32(&o.VCTR16.Reg, volatile.LoadUint32(&o.VCTR16.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR16_B519() uint32 {
	return (volatile.LoadUint32(&o.VCTR16.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR16_B520(value uint32) {
	volatile.StoreUint32(&o.VCTR16.Reg, volatile.LoadUint32(&o.VCTR16.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR16_B520() uint32 {
	return (volatile.LoadUint32(&o.VCTR16.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR16_B521(value uint32) {
	volatile.StoreUint32(&o.VCTR16.Reg, volatile.LoadUint32(&o.VCTR16.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR16_B521() uint32 {
	return (volatile.LoadUint32(&o.VCTR16.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR16_B522(value uint32) {
	volatile.StoreUint32(&o.VCTR16.Reg, volatile.LoadUint32(&o.VCTR16.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR16_B522() uint32 {
	return (volatile.LoadUint32(&o.VCTR16.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR16_B523(value uint32) {
	volatile.StoreUint32(&o.VCTR16.Reg, volatile.LoadUint32(&o.VCTR16.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR16_B523() uint32 {
	return (volatile.LoadUint32(&o.VCTR16.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR16_B524(value uint32) {
	volatile.StoreUint32(&o.VCTR16.Reg, volatile.LoadUint32(&o.VCTR16.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR16_B524() uint32 {
	return (volatile.LoadUint32(&o.VCTR16.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR16_B525(value uint32) {
	volatile.StoreUint32(&o.VCTR16.Reg, volatile.LoadUint32(&o.VCTR16.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR16_B525() uint32 {
	return (volatile.LoadUint32(&o.VCTR16.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR16_B526(value uint32) {
	volatile.StoreUint32(&o.VCTR16.Reg, volatile.LoadUint32(&o.VCTR16.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR16_B526() uint32 {
	return (volatile.LoadUint32(&o.VCTR16.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR16_B527(value uint32) {
	volatile.StoreUint32(&o.VCTR16.Reg, volatile.LoadUint32(&o.VCTR16.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR16_B527() uint32 {
	return (volatile.LoadUint32(&o.VCTR16.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR16_B528(value uint32) {
	volatile.StoreUint32(&o.VCTR16.Reg, volatile.LoadUint32(&o.VCTR16.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR16_B528() uint32 {
	return (volatile.LoadUint32(&o.VCTR16.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR16_B529(value uint32) {
	volatile.StoreUint32(&o.VCTR16.Reg, volatile.LoadUint32(&o.VCTR16.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR16_B529() uint32 {
	return (volatile.LoadUint32(&o.VCTR16.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR16_B530(value uint32) {
	volatile.StoreUint32(&o.VCTR16.Reg, volatile.LoadUint32(&o.VCTR16.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR16_B530() uint32 {
	return (volatile.LoadUint32(&o.VCTR16.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR16_B531(value uint32) {
	volatile.StoreUint32(&o.VCTR16.Reg, volatile.LoadUint32(&o.VCTR16.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR16_B531() uint32 {
	return (volatile.LoadUint32(&o.VCTR16.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR16_B532(value uint32) {
	volatile.StoreUint32(&o.VCTR16.Reg, volatile.LoadUint32(&o.VCTR16.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR16_B532() uint32 {
	return (volatile.LoadUint32(&o.VCTR16.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR16_B533(value uint32) {
	volatile.StoreUint32(&o.VCTR16.Reg, volatile.LoadUint32(&o.VCTR16.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR16_B533() uint32 {
	return (volatile.LoadUint32(&o.VCTR16.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR16_B534(value uint32) {
	volatile.StoreUint32(&o.VCTR16.Reg, volatile.LoadUint32(&o.VCTR16.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR16_B534() uint32 {
	return (volatile.LoadUint32(&o.VCTR16.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR16_B535(value uint32) {
	volatile.StoreUint32(&o.VCTR16.Reg, volatile.LoadUint32(&o.VCTR16.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR16_B535() uint32 {
	return (volatile.LoadUint32(&o.VCTR16.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR16_B536(value uint32) {
	volatile.StoreUint32(&o.VCTR16.Reg, volatile.LoadUint32(&o.VCTR16.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR16_B536() uint32 {
	return (volatile.LoadUint32(&o.VCTR16.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR16_B537(value uint32) {
	volatile.StoreUint32(&o.VCTR16.Reg, volatile.LoadUint32(&o.VCTR16.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR16_B537() uint32 {
	return (volatile.LoadUint32(&o.VCTR16.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR16_B538(value uint32) {
	volatile.StoreUint32(&o.VCTR16.Reg, volatile.LoadUint32(&o.VCTR16.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR16_B538() uint32 {
	return (volatile.LoadUint32(&o.VCTR16.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR16_B539(value uint32) {
	volatile.StoreUint32(&o.VCTR16.Reg, volatile.LoadUint32(&o.VCTR16.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR16_B539() uint32 {
	return (volatile.LoadUint32(&o.VCTR16.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR16_B540(value uint32) {
	volatile.StoreUint32(&o.VCTR16.Reg, volatile.LoadUint32(&o.VCTR16.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR16_B540() uint32 {
	return (volatile.LoadUint32(&o.VCTR16.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR16_B541(value uint32) {
	volatile.StoreUint32(&o.VCTR16.Reg, volatile.LoadUint32(&o.VCTR16.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR16_B541() uint32 {
	return (volatile.LoadUint32(&o.VCTR16.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR16_B542(value uint32) {
	volatile.StoreUint32(&o.VCTR16.Reg, volatile.LoadUint32(&o.VCTR16.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR16_B542() uint32 {
	return (volatile.LoadUint32(&o.VCTR16.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR16_B543(value uint32) {
	volatile.StoreUint32(&o.VCTR16.Reg, volatile.LoadUint32(&o.VCTR16.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR16_B543() uint32 {
	return (volatile.LoadUint32(&o.VCTR16.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR17: MPCBBx vector register
func (o *GTZC_Type) SetVCTR17_B544(value uint32) {
	volatile.StoreUint32(&o.VCTR17.Reg, volatile.LoadUint32(&o.VCTR17.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR17_B544() uint32 {
	return volatile.LoadUint32(&o.VCTR17.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR17_B545(value uint32) {
	volatile.StoreUint32(&o.VCTR17.Reg, volatile.LoadUint32(&o.VCTR17.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR17_B545() uint32 {
	return (volatile.LoadUint32(&o.VCTR17.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR17_B546(value uint32) {
	volatile.StoreUint32(&o.VCTR17.Reg, volatile.LoadUint32(&o.VCTR17.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR17_B546() uint32 {
	return (volatile.LoadUint32(&o.VCTR17.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR17_B547(value uint32) {
	volatile.StoreUint32(&o.VCTR17.Reg, volatile.LoadUint32(&o.VCTR17.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR17_B547() uint32 {
	return (volatile.LoadUint32(&o.VCTR17.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR17_B548(value uint32) {
	volatile.StoreUint32(&o.VCTR17.Reg, volatile.LoadUint32(&o.VCTR17.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR17_B548() uint32 {
	return (volatile.LoadUint32(&o.VCTR17.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR17_B549(value uint32) {
	volatile.StoreUint32(&o.VCTR17.Reg, volatile.LoadUint32(&o.VCTR17.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR17_B549() uint32 {
	return (volatile.LoadUint32(&o.VCTR17.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR17_B550(value uint32) {
	volatile.StoreUint32(&o.VCTR17.Reg, volatile.LoadUint32(&o.VCTR17.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR17_B550() uint32 {
	return (volatile.LoadUint32(&o.VCTR17.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR17_B551(value uint32) {
	volatile.StoreUint32(&o.VCTR17.Reg, volatile.LoadUint32(&o.VCTR17.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR17_B551() uint32 {
	return (volatile.LoadUint32(&o.VCTR17.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR17_B552(value uint32) {
	volatile.StoreUint32(&o.VCTR17.Reg, volatile.LoadUint32(&o.VCTR17.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR17_B552() uint32 {
	return (volatile.LoadUint32(&o.VCTR17.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR17_B553(value uint32) {
	volatile.StoreUint32(&o.VCTR17.Reg, volatile.LoadUint32(&o.VCTR17.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR17_B553() uint32 {
	return (volatile.LoadUint32(&o.VCTR17.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR17_B554(value uint32) {
	volatile.StoreUint32(&o.VCTR17.Reg, volatile.LoadUint32(&o.VCTR17.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR17_B554() uint32 {
	return (volatile.LoadUint32(&o.VCTR17.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR17_B555(value uint32) {
	volatile.StoreUint32(&o.VCTR17.Reg, volatile.LoadUint32(&o.VCTR17.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR17_B555() uint32 {
	return (volatile.LoadUint32(&o.VCTR17.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR17_B556(value uint32) {
	volatile.StoreUint32(&o.VCTR17.Reg, volatile.LoadUint32(&o.VCTR17.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR17_B556() uint32 {
	return (volatile.LoadUint32(&o.VCTR17.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR17_B557(value uint32) {
	volatile.StoreUint32(&o.VCTR17.Reg, volatile.LoadUint32(&o.VCTR17.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR17_B557() uint32 {
	return (volatile.LoadUint32(&o.VCTR17.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR17_B558(value uint32) {
	volatile.StoreUint32(&o.VCTR17.Reg, volatile.LoadUint32(&o.VCTR17.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR17_B558() uint32 {
	return (volatile.LoadUint32(&o.VCTR17.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR17_B559(value uint32) {
	volatile.StoreUint32(&o.VCTR17.Reg, volatile.LoadUint32(&o.VCTR17.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR17_B559() uint32 {
	return (volatile.LoadUint32(&o.VCTR17.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR17_B560(value uint32) {
	volatile.StoreUint32(&o.VCTR17.Reg, volatile.LoadUint32(&o.VCTR17.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR17_B560() uint32 {
	return (volatile.LoadUint32(&o.VCTR17.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR17_B561(value uint32) {
	volatile.StoreUint32(&o.VCTR17.Reg, volatile.LoadUint32(&o.VCTR17.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR17_B561() uint32 {
	return (volatile.LoadUint32(&o.VCTR17.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR17_B562(value uint32) {
	volatile.StoreUint32(&o.VCTR17.Reg, volatile.LoadUint32(&o.VCTR17.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR17_B562() uint32 {
	return (volatile.LoadUint32(&o.VCTR17.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR17_B563(value uint32) {
	volatile.StoreUint32(&o.VCTR17.Reg, volatile.LoadUint32(&o.VCTR17.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR17_B563() uint32 {
	return (volatile.LoadUint32(&o.VCTR17.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR17_B564(value uint32) {
	volatile.StoreUint32(&o.VCTR17.Reg, volatile.LoadUint32(&o.VCTR17.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR17_B564() uint32 {
	return (volatile.LoadUint32(&o.VCTR17.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR17_B565(value uint32) {
	volatile.StoreUint32(&o.VCTR17.Reg, volatile.LoadUint32(&o.VCTR17.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR17_B565() uint32 {
	return (volatile.LoadUint32(&o.VCTR17.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR17_B566(value uint32) {
	volatile.StoreUint32(&o.VCTR17.Reg, volatile.LoadUint32(&o.VCTR17.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR17_B566() uint32 {
	return (volatile.LoadUint32(&o.VCTR17.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR17_B567(value uint32) {
	volatile.StoreUint32(&o.VCTR17.Reg, volatile.LoadUint32(&o.VCTR17.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR17_B567() uint32 {
	return (volatile.LoadUint32(&o.VCTR17.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR17_B568(value uint32) {
	volatile.StoreUint32(&o.VCTR17.Reg, volatile.LoadUint32(&o.VCTR17.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR17_B568() uint32 {
	return (volatile.LoadUint32(&o.VCTR17.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR17_B569(value uint32) {
	volatile.StoreUint32(&o.VCTR17.Reg, volatile.LoadUint32(&o.VCTR17.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR17_B569() uint32 {
	return (volatile.LoadUint32(&o.VCTR17.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR17_B570(value uint32) {
	volatile.StoreUint32(&o.VCTR17.Reg, volatile.LoadUint32(&o.VCTR17.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR17_B570() uint32 {
	return (volatile.LoadUint32(&o.VCTR17.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR17_B571(value uint32) {
	volatile.StoreUint32(&o.VCTR17.Reg, volatile.LoadUint32(&o.VCTR17.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR17_B571() uint32 {
	return (volatile.LoadUint32(&o.VCTR17.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR17_B572(value uint32) {
	volatile.StoreUint32(&o.VCTR17.Reg, volatile.LoadUint32(&o.VCTR17.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR17_B572() uint32 {
	return (volatile.LoadUint32(&o.VCTR17.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR17_B573(value uint32) {
	volatile.StoreUint32(&o.VCTR17.Reg, volatile.LoadUint32(&o.VCTR17.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR17_B573() uint32 {
	return (volatile.LoadUint32(&o.VCTR17.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR17_B574(value uint32) {
	volatile.StoreUint32(&o.VCTR17.Reg, volatile.LoadUint32(&o.VCTR17.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR17_B574() uint32 {
	return (volatile.LoadUint32(&o.VCTR17.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR17_B575(value uint32) {
	volatile.StoreUint32(&o.VCTR17.Reg, volatile.LoadUint32(&o.VCTR17.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR17_B575() uint32 {
	return (volatile.LoadUint32(&o.VCTR17.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR18: MPCBBx vector register
func (o *GTZC_Type) SetVCTR18_B576(value uint32) {
	volatile.StoreUint32(&o.VCTR18.Reg, volatile.LoadUint32(&o.VCTR18.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR18_B576() uint32 {
	return volatile.LoadUint32(&o.VCTR18.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR18_B577(value uint32) {
	volatile.StoreUint32(&o.VCTR18.Reg, volatile.LoadUint32(&o.VCTR18.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR18_B577() uint32 {
	return (volatile.LoadUint32(&o.VCTR18.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR18_B578(value uint32) {
	volatile.StoreUint32(&o.VCTR18.Reg, volatile.LoadUint32(&o.VCTR18.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR18_B578() uint32 {
	return (volatile.LoadUint32(&o.VCTR18.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR18_B579(value uint32) {
	volatile.StoreUint32(&o.VCTR18.Reg, volatile.LoadUint32(&o.VCTR18.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR18_B579() uint32 {
	return (volatile.LoadUint32(&o.VCTR18.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR18_B580(value uint32) {
	volatile.StoreUint32(&o.VCTR18.Reg, volatile.LoadUint32(&o.VCTR18.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR18_B580() uint32 {
	return (volatile.LoadUint32(&o.VCTR18.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR18_B581(value uint32) {
	volatile.StoreUint32(&o.VCTR18.Reg, volatile.LoadUint32(&o.VCTR18.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR18_B581() uint32 {
	return (volatile.LoadUint32(&o.VCTR18.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR18_B582(value uint32) {
	volatile.StoreUint32(&o.VCTR18.Reg, volatile.LoadUint32(&o.VCTR18.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR18_B582() uint32 {
	return (volatile.LoadUint32(&o.VCTR18.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR18_B583(value uint32) {
	volatile.StoreUint32(&o.VCTR18.Reg, volatile.LoadUint32(&o.VCTR18.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR18_B583() uint32 {
	return (volatile.LoadUint32(&o.VCTR18.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR18_B584(value uint32) {
	volatile.StoreUint32(&o.VCTR18.Reg, volatile.LoadUint32(&o.VCTR18.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR18_B584() uint32 {
	return (volatile.LoadUint32(&o.VCTR18.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR18_B585(value uint32) {
	volatile.StoreUint32(&o.VCTR18.Reg, volatile.LoadUint32(&o.VCTR18.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR18_B585() uint32 {
	return (volatile.LoadUint32(&o.VCTR18.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR18_B586(value uint32) {
	volatile.StoreUint32(&o.VCTR18.Reg, volatile.LoadUint32(&o.VCTR18.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR18_B586() uint32 {
	return (volatile.LoadUint32(&o.VCTR18.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR18_B587(value uint32) {
	volatile.StoreUint32(&o.VCTR18.Reg, volatile.LoadUint32(&o.VCTR18.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR18_B587() uint32 {
	return (volatile.LoadUint32(&o.VCTR18.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR18_B588(value uint32) {
	volatile.StoreUint32(&o.VCTR18.Reg, volatile.LoadUint32(&o.VCTR18.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR18_B588() uint32 {
	return (volatile.LoadUint32(&o.VCTR18.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR18_B589(value uint32) {
	volatile.StoreUint32(&o.VCTR18.Reg, volatile.LoadUint32(&o.VCTR18.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR18_B589() uint32 {
	return (volatile.LoadUint32(&o.VCTR18.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR18_B590(value uint32) {
	volatile.StoreUint32(&o.VCTR18.Reg, volatile.LoadUint32(&o.VCTR18.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR18_B590() uint32 {
	return (volatile.LoadUint32(&o.VCTR18.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR18_B591(value uint32) {
	volatile.StoreUint32(&o.VCTR18.Reg, volatile.LoadUint32(&o.VCTR18.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR18_B591() uint32 {
	return (volatile.LoadUint32(&o.VCTR18.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR18_B592(value uint32) {
	volatile.StoreUint32(&o.VCTR18.Reg, volatile.LoadUint32(&o.VCTR18.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR18_B592() uint32 {
	return (volatile.LoadUint32(&o.VCTR18.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR18_B593(value uint32) {
	volatile.StoreUint32(&o.VCTR18.Reg, volatile.LoadUint32(&o.VCTR18.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR18_B593() uint32 {
	return (volatile.LoadUint32(&o.VCTR18.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR18_B594(value uint32) {
	volatile.StoreUint32(&o.VCTR18.Reg, volatile.LoadUint32(&o.VCTR18.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR18_B594() uint32 {
	return (volatile.LoadUint32(&o.VCTR18.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR18_B595(value uint32) {
	volatile.StoreUint32(&o.VCTR18.Reg, volatile.LoadUint32(&o.VCTR18.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR18_B595() uint32 {
	return (volatile.LoadUint32(&o.VCTR18.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR18_B596(value uint32) {
	volatile.StoreUint32(&o.VCTR18.Reg, volatile.LoadUint32(&o.VCTR18.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR18_B596() uint32 {
	return (volatile.LoadUint32(&o.VCTR18.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR18_B597(value uint32) {
	volatile.StoreUint32(&o.VCTR18.Reg, volatile.LoadUint32(&o.VCTR18.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR18_B597() uint32 {
	return (volatile.LoadUint32(&o.VCTR18.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR18_B598(value uint32) {
	volatile.StoreUint32(&o.VCTR18.Reg, volatile.LoadUint32(&o.VCTR18.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR18_B598() uint32 {
	return (volatile.LoadUint32(&o.VCTR18.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR18_B599(value uint32) {
	volatile.StoreUint32(&o.VCTR18.Reg, volatile.LoadUint32(&o.VCTR18.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR18_B599() uint32 {
	return (volatile.LoadUint32(&o.VCTR18.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR18_B600(value uint32) {
	volatile.StoreUint32(&o.VCTR18.Reg, volatile.LoadUint32(&o.VCTR18.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR18_B600() uint32 {
	return (volatile.LoadUint32(&o.VCTR18.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR18_B601(value uint32) {
	volatile.StoreUint32(&o.VCTR18.Reg, volatile.LoadUint32(&o.VCTR18.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR18_B601() uint32 {
	return (volatile.LoadUint32(&o.VCTR18.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR18_B602(value uint32) {
	volatile.StoreUint32(&o.VCTR18.Reg, volatile.LoadUint32(&o.VCTR18.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR18_B602() uint32 {
	return (volatile.LoadUint32(&o.VCTR18.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR18_B603(value uint32) {
	volatile.StoreUint32(&o.VCTR18.Reg, volatile.LoadUint32(&o.VCTR18.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR18_B603() uint32 {
	return (volatile.LoadUint32(&o.VCTR18.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR18_B604(value uint32) {
	volatile.StoreUint32(&o.VCTR18.Reg, volatile.LoadUint32(&o.VCTR18.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR18_B604() uint32 {
	return (volatile.LoadUint32(&o.VCTR18.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR18_B605(value uint32) {
	volatile.StoreUint32(&o.VCTR18.Reg, volatile.LoadUint32(&o.VCTR18.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR18_B605() uint32 {
	return (volatile.LoadUint32(&o.VCTR18.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR18_B606(value uint32) {
	volatile.StoreUint32(&o.VCTR18.Reg, volatile.LoadUint32(&o.VCTR18.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR18_B606() uint32 {
	return (volatile.LoadUint32(&o.VCTR18.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR18_B607(value uint32) {
	volatile.StoreUint32(&o.VCTR18.Reg, volatile.LoadUint32(&o.VCTR18.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR18_B607() uint32 {
	return (volatile.LoadUint32(&o.VCTR18.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR19: MPCBBx vector register
func (o *GTZC_Type) SetVCTR19_B608(value uint32) {
	volatile.StoreUint32(&o.VCTR19.Reg, volatile.LoadUint32(&o.VCTR19.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR19_B608() uint32 {
	return volatile.LoadUint32(&o.VCTR19.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR19_B609(value uint32) {
	volatile.StoreUint32(&o.VCTR19.Reg, volatile.LoadUint32(&o.VCTR19.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR19_B609() uint32 {
	return (volatile.LoadUint32(&o.VCTR19.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR19_B610(value uint32) {
	volatile.StoreUint32(&o.VCTR19.Reg, volatile.LoadUint32(&o.VCTR19.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR19_B610() uint32 {
	return (volatile.LoadUint32(&o.VCTR19.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR19_B611(value uint32) {
	volatile.StoreUint32(&o.VCTR19.Reg, volatile.LoadUint32(&o.VCTR19.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR19_B611() uint32 {
	return (volatile.LoadUint32(&o.VCTR19.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR19_B612(value uint32) {
	volatile.StoreUint32(&o.VCTR19.Reg, volatile.LoadUint32(&o.VCTR19.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR19_B612() uint32 {
	return (volatile.LoadUint32(&o.VCTR19.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR19_B613(value uint32) {
	volatile.StoreUint32(&o.VCTR19.Reg, volatile.LoadUint32(&o.VCTR19.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR19_B613() uint32 {
	return (volatile.LoadUint32(&o.VCTR19.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR19_B614(value uint32) {
	volatile.StoreUint32(&o.VCTR19.Reg, volatile.LoadUint32(&o.VCTR19.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR19_B614() uint32 {
	return (volatile.LoadUint32(&o.VCTR19.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR19_B615(value uint32) {
	volatile.StoreUint32(&o.VCTR19.Reg, volatile.LoadUint32(&o.VCTR19.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR19_B615() uint32 {
	return (volatile.LoadUint32(&o.VCTR19.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR19_B616(value uint32) {
	volatile.StoreUint32(&o.VCTR19.Reg, volatile.LoadUint32(&o.VCTR19.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR19_B616() uint32 {
	return (volatile.LoadUint32(&o.VCTR19.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR19_B617(value uint32) {
	volatile.StoreUint32(&o.VCTR19.Reg, volatile.LoadUint32(&o.VCTR19.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR19_B617() uint32 {
	return (volatile.LoadUint32(&o.VCTR19.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR19_B618(value uint32) {
	volatile.StoreUint32(&o.VCTR19.Reg, volatile.LoadUint32(&o.VCTR19.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR19_B618() uint32 {
	return (volatile.LoadUint32(&o.VCTR19.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR19_B619(value uint32) {
	volatile.StoreUint32(&o.VCTR19.Reg, volatile.LoadUint32(&o.VCTR19.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR19_B619() uint32 {
	return (volatile.LoadUint32(&o.VCTR19.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR19_B620(value uint32) {
	volatile.StoreUint32(&o.VCTR19.Reg, volatile.LoadUint32(&o.VCTR19.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR19_B620() uint32 {
	return (volatile.LoadUint32(&o.VCTR19.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR19_B621(value uint32) {
	volatile.StoreUint32(&o.VCTR19.Reg, volatile.LoadUint32(&o.VCTR19.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR19_B621() uint32 {
	return (volatile.LoadUint32(&o.VCTR19.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR19_B622(value uint32) {
	volatile.StoreUint32(&o.VCTR19.Reg, volatile.LoadUint32(&o.VCTR19.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR19_B622() uint32 {
	return (volatile.LoadUint32(&o.VCTR19.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR19_B623(value uint32) {
	volatile.StoreUint32(&o.VCTR19.Reg, volatile.LoadUint32(&o.VCTR19.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR19_B623() uint32 {
	return (volatile.LoadUint32(&o.VCTR19.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR19_B624(value uint32) {
	volatile.StoreUint32(&o.VCTR19.Reg, volatile.LoadUint32(&o.VCTR19.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR19_B624() uint32 {
	return (volatile.LoadUint32(&o.VCTR19.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR19_B625(value uint32) {
	volatile.StoreUint32(&o.VCTR19.Reg, volatile.LoadUint32(&o.VCTR19.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR19_B625() uint32 {
	return (volatile.LoadUint32(&o.VCTR19.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR19_B626(value uint32) {
	volatile.StoreUint32(&o.VCTR19.Reg, volatile.LoadUint32(&o.VCTR19.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR19_B626() uint32 {
	return (volatile.LoadUint32(&o.VCTR19.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR19_B627(value uint32) {
	volatile.StoreUint32(&o.VCTR19.Reg, volatile.LoadUint32(&o.VCTR19.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR19_B627() uint32 {
	return (volatile.LoadUint32(&o.VCTR19.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR19_B628(value uint32) {
	volatile.StoreUint32(&o.VCTR19.Reg, volatile.LoadUint32(&o.VCTR19.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR19_B628() uint32 {
	return (volatile.LoadUint32(&o.VCTR19.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR19_B629(value uint32) {
	volatile.StoreUint32(&o.VCTR19.Reg, volatile.LoadUint32(&o.VCTR19.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR19_B629() uint32 {
	return (volatile.LoadUint32(&o.VCTR19.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR19_B630(value uint32) {
	volatile.StoreUint32(&o.VCTR19.Reg, volatile.LoadUint32(&o.VCTR19.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR19_B630() uint32 {
	return (volatile.LoadUint32(&o.VCTR19.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR19_B631(value uint32) {
	volatile.StoreUint32(&o.VCTR19.Reg, volatile.LoadUint32(&o.VCTR19.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR19_B631() uint32 {
	return (volatile.LoadUint32(&o.VCTR19.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR19_B632(value uint32) {
	volatile.StoreUint32(&o.VCTR19.Reg, volatile.LoadUint32(&o.VCTR19.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR19_B632() uint32 {
	return (volatile.LoadUint32(&o.VCTR19.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR19_B633(value uint32) {
	volatile.StoreUint32(&o.VCTR19.Reg, volatile.LoadUint32(&o.VCTR19.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR19_B633() uint32 {
	return (volatile.LoadUint32(&o.VCTR19.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR19_B634(value uint32) {
	volatile.StoreUint32(&o.VCTR19.Reg, volatile.LoadUint32(&o.VCTR19.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR19_B634() uint32 {
	return (volatile.LoadUint32(&o.VCTR19.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR19_B635(value uint32) {
	volatile.StoreUint32(&o.VCTR19.Reg, volatile.LoadUint32(&o.VCTR19.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR19_B635() uint32 {
	return (volatile.LoadUint32(&o.VCTR19.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR19_B636(value uint32) {
	volatile.StoreUint32(&o.VCTR19.Reg, volatile.LoadUint32(&o.VCTR19.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR19_B636() uint32 {
	return (volatile.LoadUint32(&o.VCTR19.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR19_B637(value uint32) {
	volatile.StoreUint32(&o.VCTR19.Reg, volatile.LoadUint32(&o.VCTR19.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR19_B637() uint32 {
	return (volatile.LoadUint32(&o.VCTR19.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR19_B638(value uint32) {
	volatile.StoreUint32(&o.VCTR19.Reg, volatile.LoadUint32(&o.VCTR19.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR19_B638() uint32 {
	return (volatile.LoadUint32(&o.VCTR19.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR19_B639(value uint32) {
	volatile.StoreUint32(&o.VCTR19.Reg, volatile.LoadUint32(&o.VCTR19.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR19_B639() uint32 {
	return (volatile.LoadUint32(&o.VCTR19.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR20: MPCBBx vector register
func (o *GTZC_Type) SetVCTR20_B640(value uint32) {
	volatile.StoreUint32(&o.VCTR20.Reg, volatile.LoadUint32(&o.VCTR20.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR20_B640() uint32 {
	return volatile.LoadUint32(&o.VCTR20.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR20_B641(value uint32) {
	volatile.StoreUint32(&o.VCTR20.Reg, volatile.LoadUint32(&o.VCTR20.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR20_B641() uint32 {
	return (volatile.LoadUint32(&o.VCTR20.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR20_B642(value uint32) {
	volatile.StoreUint32(&o.VCTR20.Reg, volatile.LoadUint32(&o.VCTR20.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR20_B642() uint32 {
	return (volatile.LoadUint32(&o.VCTR20.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR20_B643(value uint32) {
	volatile.StoreUint32(&o.VCTR20.Reg, volatile.LoadUint32(&o.VCTR20.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR20_B643() uint32 {
	return (volatile.LoadUint32(&o.VCTR20.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR20_B644(value uint32) {
	volatile.StoreUint32(&o.VCTR20.Reg, volatile.LoadUint32(&o.VCTR20.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR20_B644() uint32 {
	return (volatile.LoadUint32(&o.VCTR20.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR20_B645(value uint32) {
	volatile.StoreUint32(&o.VCTR20.Reg, volatile.LoadUint32(&o.VCTR20.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR20_B645() uint32 {
	return (volatile.LoadUint32(&o.VCTR20.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR20_B646(value uint32) {
	volatile.StoreUint32(&o.VCTR20.Reg, volatile.LoadUint32(&o.VCTR20.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR20_B646() uint32 {
	return (volatile.LoadUint32(&o.VCTR20.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR20_B647(value uint32) {
	volatile.StoreUint32(&o.VCTR20.Reg, volatile.LoadUint32(&o.VCTR20.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR20_B647() uint32 {
	return (volatile.LoadUint32(&o.VCTR20.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR20_B648(value uint32) {
	volatile.StoreUint32(&o.VCTR20.Reg, volatile.LoadUint32(&o.VCTR20.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR20_B648() uint32 {
	return (volatile.LoadUint32(&o.VCTR20.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR20_B649(value uint32) {
	volatile.StoreUint32(&o.VCTR20.Reg, volatile.LoadUint32(&o.VCTR20.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR20_B649() uint32 {
	return (volatile.LoadUint32(&o.VCTR20.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR20_B650(value uint32) {
	volatile.StoreUint32(&o.VCTR20.Reg, volatile.LoadUint32(&o.VCTR20.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR20_B650() uint32 {
	return (volatile.LoadUint32(&o.VCTR20.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR20_B651(value uint32) {
	volatile.StoreUint32(&o.VCTR20.Reg, volatile.LoadUint32(&o.VCTR20.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR20_B651() uint32 {
	return (volatile.LoadUint32(&o.VCTR20.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR20_B652(value uint32) {
	volatile.StoreUint32(&o.VCTR20.Reg, volatile.LoadUint32(&o.VCTR20.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR20_B652() uint32 {
	return (volatile.LoadUint32(&o.VCTR20.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR20_B653(value uint32) {
	volatile.StoreUint32(&o.VCTR20.Reg, volatile.LoadUint32(&o.VCTR20.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR20_B653() uint32 {
	return (volatile.LoadUint32(&o.VCTR20.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR20_B654(value uint32) {
	volatile.StoreUint32(&o.VCTR20.Reg, volatile.LoadUint32(&o.VCTR20.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR20_B654() uint32 {
	return (volatile.LoadUint32(&o.VCTR20.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR20_B655(value uint32) {
	volatile.StoreUint32(&o.VCTR20.Reg, volatile.LoadUint32(&o.VCTR20.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR20_B655() uint32 {
	return (volatile.LoadUint32(&o.VCTR20.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR20_B656(value uint32) {
	volatile.StoreUint32(&o.VCTR20.Reg, volatile.LoadUint32(&o.VCTR20.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR20_B656() uint32 {
	return (volatile.LoadUint32(&o.VCTR20.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR20_B657(value uint32) {
	volatile.StoreUint32(&o.VCTR20.Reg, volatile.LoadUint32(&o.VCTR20.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR20_B657() uint32 {
	return (volatile.LoadUint32(&o.VCTR20.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR20_B658(value uint32) {
	volatile.StoreUint32(&o.VCTR20.Reg, volatile.LoadUint32(&o.VCTR20.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR20_B658() uint32 {
	return (volatile.LoadUint32(&o.VCTR20.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR20_B659(value uint32) {
	volatile.StoreUint32(&o.VCTR20.Reg, volatile.LoadUint32(&o.VCTR20.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR20_B659() uint32 {
	return (volatile.LoadUint32(&o.VCTR20.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR20_B660(value uint32) {
	volatile.StoreUint32(&o.VCTR20.Reg, volatile.LoadUint32(&o.VCTR20.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR20_B660() uint32 {
	return (volatile.LoadUint32(&o.VCTR20.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR20_B661(value uint32) {
	volatile.StoreUint32(&o.VCTR20.Reg, volatile.LoadUint32(&o.VCTR20.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR20_B661() uint32 {
	return (volatile.LoadUint32(&o.VCTR20.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR20_B662(value uint32) {
	volatile.StoreUint32(&o.VCTR20.Reg, volatile.LoadUint32(&o.VCTR20.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR20_B662() uint32 {
	return (volatile.LoadUint32(&o.VCTR20.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR20_B663(value uint32) {
	volatile.StoreUint32(&o.VCTR20.Reg, volatile.LoadUint32(&o.VCTR20.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR20_B663() uint32 {
	return (volatile.LoadUint32(&o.VCTR20.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR20_B664(value uint32) {
	volatile.StoreUint32(&o.VCTR20.Reg, volatile.LoadUint32(&o.VCTR20.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR20_B664() uint32 {
	return (volatile.LoadUint32(&o.VCTR20.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR20_B665(value uint32) {
	volatile.StoreUint32(&o.VCTR20.Reg, volatile.LoadUint32(&o.VCTR20.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR20_B665() uint32 {
	return (volatile.LoadUint32(&o.VCTR20.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR20_B666(value uint32) {
	volatile.StoreUint32(&o.VCTR20.Reg, volatile.LoadUint32(&o.VCTR20.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR20_B666() uint32 {
	return (volatile.LoadUint32(&o.VCTR20.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR20_B667(value uint32) {
	volatile.StoreUint32(&o.VCTR20.Reg, volatile.LoadUint32(&o.VCTR20.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR20_B667() uint32 {
	return (volatile.LoadUint32(&o.VCTR20.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR20_B668(value uint32) {
	volatile.StoreUint32(&o.VCTR20.Reg, volatile.LoadUint32(&o.VCTR20.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR20_B668() uint32 {
	return (volatile.LoadUint32(&o.VCTR20.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR20_B669(value uint32) {
	volatile.StoreUint32(&o.VCTR20.Reg, volatile.LoadUint32(&o.VCTR20.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR20_B669() uint32 {
	return (volatile.LoadUint32(&o.VCTR20.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR20_B670(value uint32) {
	volatile.StoreUint32(&o.VCTR20.Reg, volatile.LoadUint32(&o.VCTR20.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR20_B670() uint32 {
	return (volatile.LoadUint32(&o.VCTR20.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR20_B671(value uint32) {
	volatile.StoreUint32(&o.VCTR20.Reg, volatile.LoadUint32(&o.VCTR20.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR20_B671() uint32 {
	return (volatile.LoadUint32(&o.VCTR20.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR21: MPCBBx vector register
func (o *GTZC_Type) SetVCTR21_B672(value uint32) {
	volatile.StoreUint32(&o.VCTR21.Reg, volatile.LoadUint32(&o.VCTR21.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR21_B672() uint32 {
	return volatile.LoadUint32(&o.VCTR21.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR21_B673(value uint32) {
	volatile.StoreUint32(&o.VCTR21.Reg, volatile.LoadUint32(&o.VCTR21.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR21_B673() uint32 {
	return (volatile.LoadUint32(&o.VCTR21.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR21_B674(value uint32) {
	volatile.StoreUint32(&o.VCTR21.Reg, volatile.LoadUint32(&o.VCTR21.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR21_B674() uint32 {
	return (volatile.LoadUint32(&o.VCTR21.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR21_B675(value uint32) {
	volatile.StoreUint32(&o.VCTR21.Reg, volatile.LoadUint32(&o.VCTR21.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR21_B675() uint32 {
	return (volatile.LoadUint32(&o.VCTR21.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR21_B676(value uint32) {
	volatile.StoreUint32(&o.VCTR21.Reg, volatile.LoadUint32(&o.VCTR21.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR21_B676() uint32 {
	return (volatile.LoadUint32(&o.VCTR21.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR21_B677(value uint32) {
	volatile.StoreUint32(&o.VCTR21.Reg, volatile.LoadUint32(&o.VCTR21.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR21_B677() uint32 {
	return (volatile.LoadUint32(&o.VCTR21.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR21_B678(value uint32) {
	volatile.StoreUint32(&o.VCTR21.Reg, volatile.LoadUint32(&o.VCTR21.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR21_B678() uint32 {
	return (volatile.LoadUint32(&o.VCTR21.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR21_B679(value uint32) {
	volatile.StoreUint32(&o.VCTR21.Reg, volatile.LoadUint32(&o.VCTR21.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR21_B679() uint32 {
	return (volatile.LoadUint32(&o.VCTR21.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR21_B680(value uint32) {
	volatile.StoreUint32(&o.VCTR21.Reg, volatile.LoadUint32(&o.VCTR21.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR21_B680() uint32 {
	return (volatile.LoadUint32(&o.VCTR21.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR21_B681(value uint32) {
	volatile.StoreUint32(&o.VCTR21.Reg, volatile.LoadUint32(&o.VCTR21.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR21_B681() uint32 {
	return (volatile.LoadUint32(&o.VCTR21.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR21_B682(value uint32) {
	volatile.StoreUint32(&o.VCTR21.Reg, volatile.LoadUint32(&o.VCTR21.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR21_B682() uint32 {
	return (volatile.LoadUint32(&o.VCTR21.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR21_B683(value uint32) {
	volatile.StoreUint32(&o.VCTR21.Reg, volatile.LoadUint32(&o.VCTR21.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR21_B683() uint32 {
	return (volatile.LoadUint32(&o.VCTR21.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR21_B684(value uint32) {
	volatile.StoreUint32(&o.VCTR21.Reg, volatile.LoadUint32(&o.VCTR21.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR21_B684() uint32 {
	return (volatile.LoadUint32(&o.VCTR21.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR21_B685(value uint32) {
	volatile.StoreUint32(&o.VCTR21.Reg, volatile.LoadUint32(&o.VCTR21.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR21_B685() uint32 {
	return (volatile.LoadUint32(&o.VCTR21.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR21_B686(value uint32) {
	volatile.StoreUint32(&o.VCTR21.Reg, volatile.LoadUint32(&o.VCTR21.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR21_B686() uint32 {
	return (volatile.LoadUint32(&o.VCTR21.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR21_B687(value uint32) {
	volatile.StoreUint32(&o.VCTR21.Reg, volatile.LoadUint32(&o.VCTR21.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR21_B687() uint32 {
	return (volatile.LoadUint32(&o.VCTR21.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR21_B688(value uint32) {
	volatile.StoreUint32(&o.VCTR21.Reg, volatile.LoadUint32(&o.VCTR21.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR21_B688() uint32 {
	return (volatile.LoadUint32(&o.VCTR21.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR21_B689(value uint32) {
	volatile.StoreUint32(&o.VCTR21.Reg, volatile.LoadUint32(&o.VCTR21.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR21_B689() uint32 {
	return (volatile.LoadUint32(&o.VCTR21.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR21_B690(value uint32) {
	volatile.StoreUint32(&o.VCTR21.Reg, volatile.LoadUint32(&o.VCTR21.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR21_B690() uint32 {
	return (volatile.LoadUint32(&o.VCTR21.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR21_B691(value uint32) {
	volatile.StoreUint32(&o.VCTR21.Reg, volatile.LoadUint32(&o.VCTR21.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR21_B691() uint32 {
	return (volatile.LoadUint32(&o.VCTR21.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR21_B692(value uint32) {
	volatile.StoreUint32(&o.VCTR21.Reg, volatile.LoadUint32(&o.VCTR21.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR21_B692() uint32 {
	return (volatile.LoadUint32(&o.VCTR21.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR21_B693(value uint32) {
	volatile.StoreUint32(&o.VCTR21.Reg, volatile.LoadUint32(&o.VCTR21.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR21_B693() uint32 {
	return (volatile.LoadUint32(&o.VCTR21.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR21_B694(value uint32) {
	volatile.StoreUint32(&o.VCTR21.Reg, volatile.LoadUint32(&o.VCTR21.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR21_B694() uint32 {
	return (volatile.LoadUint32(&o.VCTR21.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR21_B695(value uint32) {
	volatile.StoreUint32(&o.VCTR21.Reg, volatile.LoadUint32(&o.VCTR21.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR21_B695() uint32 {
	return (volatile.LoadUint32(&o.VCTR21.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR21_B696(value uint32) {
	volatile.StoreUint32(&o.VCTR21.Reg, volatile.LoadUint32(&o.VCTR21.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR21_B696() uint32 {
	return (volatile.LoadUint32(&o.VCTR21.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR21_B697(value uint32) {
	volatile.StoreUint32(&o.VCTR21.Reg, volatile.LoadUint32(&o.VCTR21.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR21_B697() uint32 {
	return (volatile.LoadUint32(&o.VCTR21.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR21_B698(value uint32) {
	volatile.StoreUint32(&o.VCTR21.Reg, volatile.LoadUint32(&o.VCTR21.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR21_B698() uint32 {
	return (volatile.LoadUint32(&o.VCTR21.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR21_B699(value uint32) {
	volatile.StoreUint32(&o.VCTR21.Reg, volatile.LoadUint32(&o.VCTR21.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR21_B699() uint32 {
	return (volatile.LoadUint32(&o.VCTR21.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR21_B700(value uint32) {
	volatile.StoreUint32(&o.VCTR21.Reg, volatile.LoadUint32(&o.VCTR21.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR21_B700() uint32 {
	return (volatile.LoadUint32(&o.VCTR21.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR21_B701(value uint32) {
	volatile.StoreUint32(&o.VCTR21.Reg, volatile.LoadUint32(&o.VCTR21.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR21_B701() uint32 {
	return (volatile.LoadUint32(&o.VCTR21.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR21_B702(value uint32) {
	volatile.StoreUint32(&o.VCTR21.Reg, volatile.LoadUint32(&o.VCTR21.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR21_B702() uint32 {
	return (volatile.LoadUint32(&o.VCTR21.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR21_B703(value uint32) {
	volatile.StoreUint32(&o.VCTR21.Reg, volatile.LoadUint32(&o.VCTR21.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR21_B703() uint32 {
	return (volatile.LoadUint32(&o.VCTR21.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR22: MPCBBx vector register
func (o *GTZC_Type) SetVCTR22_B704(value uint32) {
	volatile.StoreUint32(&o.VCTR22.Reg, volatile.LoadUint32(&o.VCTR22.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR22_B704() uint32 {
	return volatile.LoadUint32(&o.VCTR22.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR22_B705(value uint32) {
	volatile.StoreUint32(&o.VCTR22.Reg, volatile.LoadUint32(&o.VCTR22.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR22_B705() uint32 {
	return (volatile.LoadUint32(&o.VCTR22.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR22_B706(value uint32) {
	volatile.StoreUint32(&o.VCTR22.Reg, volatile.LoadUint32(&o.VCTR22.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR22_B706() uint32 {
	return (volatile.LoadUint32(&o.VCTR22.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR22_B707(value uint32) {
	volatile.StoreUint32(&o.VCTR22.Reg, volatile.LoadUint32(&o.VCTR22.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR22_B707() uint32 {
	return (volatile.LoadUint32(&o.VCTR22.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR22_B708(value uint32) {
	volatile.StoreUint32(&o.VCTR22.Reg, volatile.LoadUint32(&o.VCTR22.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR22_B708() uint32 {
	return (volatile.LoadUint32(&o.VCTR22.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR22_B709(value uint32) {
	volatile.StoreUint32(&o.VCTR22.Reg, volatile.LoadUint32(&o.VCTR22.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR22_B709() uint32 {
	return (volatile.LoadUint32(&o.VCTR22.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR22_B710(value uint32) {
	volatile.StoreUint32(&o.VCTR22.Reg, volatile.LoadUint32(&o.VCTR22.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR22_B710() uint32 {
	return (volatile.LoadUint32(&o.VCTR22.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR22_B711(value uint32) {
	volatile.StoreUint32(&o.VCTR22.Reg, volatile.LoadUint32(&o.VCTR22.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR22_B711() uint32 {
	return (volatile.LoadUint32(&o.VCTR22.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR22_B712(value uint32) {
	volatile.StoreUint32(&o.VCTR22.Reg, volatile.LoadUint32(&o.VCTR22.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR22_B712() uint32 {
	return (volatile.LoadUint32(&o.VCTR22.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR22_B713(value uint32) {
	volatile.StoreUint32(&o.VCTR22.Reg, volatile.LoadUint32(&o.VCTR22.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR22_B713() uint32 {
	return (volatile.LoadUint32(&o.VCTR22.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR22_B714(value uint32) {
	volatile.StoreUint32(&o.VCTR22.Reg, volatile.LoadUint32(&o.VCTR22.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR22_B714() uint32 {
	return (volatile.LoadUint32(&o.VCTR22.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR22_B715(value uint32) {
	volatile.StoreUint32(&o.VCTR22.Reg, volatile.LoadUint32(&o.VCTR22.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR22_B715() uint32 {
	return (volatile.LoadUint32(&o.VCTR22.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR22_B716(value uint32) {
	volatile.StoreUint32(&o.VCTR22.Reg, volatile.LoadUint32(&o.VCTR22.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR22_B716() uint32 {
	return (volatile.LoadUint32(&o.VCTR22.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR22_B717(value uint32) {
	volatile.StoreUint32(&o.VCTR22.Reg, volatile.LoadUint32(&o.VCTR22.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR22_B717() uint32 {
	return (volatile.LoadUint32(&o.VCTR22.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR22_B718(value uint32) {
	volatile.StoreUint32(&o.VCTR22.Reg, volatile.LoadUint32(&o.VCTR22.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR22_B718() uint32 {
	return (volatile.LoadUint32(&o.VCTR22.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR22_B719(value uint32) {
	volatile.StoreUint32(&o.VCTR22.Reg, volatile.LoadUint32(&o.VCTR22.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR22_B719() uint32 {
	return (volatile.LoadUint32(&o.VCTR22.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR22_B720(value uint32) {
	volatile.StoreUint32(&o.VCTR22.Reg, volatile.LoadUint32(&o.VCTR22.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR22_B720() uint32 {
	return (volatile.LoadUint32(&o.VCTR22.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR22_B721(value uint32) {
	volatile.StoreUint32(&o.VCTR22.Reg, volatile.LoadUint32(&o.VCTR22.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR22_B721() uint32 {
	return (volatile.LoadUint32(&o.VCTR22.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR22_B722(value uint32) {
	volatile.StoreUint32(&o.VCTR22.Reg, volatile.LoadUint32(&o.VCTR22.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR22_B722() uint32 {
	return (volatile.LoadUint32(&o.VCTR22.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR22_B723(value uint32) {
	volatile.StoreUint32(&o.VCTR22.Reg, volatile.LoadUint32(&o.VCTR22.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR22_B723() uint32 {
	return (volatile.LoadUint32(&o.VCTR22.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR22_B724(value uint32) {
	volatile.StoreUint32(&o.VCTR22.Reg, volatile.LoadUint32(&o.VCTR22.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR22_B724() uint32 {
	return (volatile.LoadUint32(&o.VCTR22.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR22_B725(value uint32) {
	volatile.StoreUint32(&o.VCTR22.Reg, volatile.LoadUint32(&o.VCTR22.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR22_B725() uint32 {
	return (volatile.LoadUint32(&o.VCTR22.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR22_B726(value uint32) {
	volatile.StoreUint32(&o.VCTR22.Reg, volatile.LoadUint32(&o.VCTR22.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR22_B726() uint32 {
	return (volatile.LoadUint32(&o.VCTR22.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR22_B727(value uint32) {
	volatile.StoreUint32(&o.VCTR22.Reg, volatile.LoadUint32(&o.VCTR22.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR22_B727() uint32 {
	return (volatile.LoadUint32(&o.VCTR22.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR22_B728(value uint32) {
	volatile.StoreUint32(&o.VCTR22.Reg, volatile.LoadUint32(&o.VCTR22.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR22_B728() uint32 {
	return (volatile.LoadUint32(&o.VCTR22.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR22_B729(value uint32) {
	volatile.StoreUint32(&o.VCTR22.Reg, volatile.LoadUint32(&o.VCTR22.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR22_B729() uint32 {
	return (volatile.LoadUint32(&o.VCTR22.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR22_B730(value uint32) {
	volatile.StoreUint32(&o.VCTR22.Reg, volatile.LoadUint32(&o.VCTR22.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR22_B730() uint32 {
	return (volatile.LoadUint32(&o.VCTR22.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR22_B731(value uint32) {
	volatile.StoreUint32(&o.VCTR22.Reg, volatile.LoadUint32(&o.VCTR22.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR22_B731() uint32 {
	return (volatile.LoadUint32(&o.VCTR22.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR22_B732(value uint32) {
	volatile.StoreUint32(&o.VCTR22.Reg, volatile.LoadUint32(&o.VCTR22.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR22_B732() uint32 {
	return (volatile.LoadUint32(&o.VCTR22.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR22_B733(value uint32) {
	volatile.StoreUint32(&o.VCTR22.Reg, volatile.LoadUint32(&o.VCTR22.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR22_B733() uint32 {
	return (volatile.LoadUint32(&o.VCTR22.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR22_B734(value uint32) {
	volatile.StoreUint32(&o.VCTR22.Reg, volatile.LoadUint32(&o.VCTR22.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR22_B734() uint32 {
	return (volatile.LoadUint32(&o.VCTR22.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR22_B735(value uint32) {
	volatile.StoreUint32(&o.VCTR22.Reg, volatile.LoadUint32(&o.VCTR22.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR22_B735() uint32 {
	return (volatile.LoadUint32(&o.VCTR22.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR23: MPCBBx vector register
func (o *GTZC_Type) SetVCTR23_B736(value uint32) {
	volatile.StoreUint32(&o.VCTR23.Reg, volatile.LoadUint32(&o.VCTR23.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR23_B736() uint32 {
	return volatile.LoadUint32(&o.VCTR23.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR23_B737(value uint32) {
	volatile.StoreUint32(&o.VCTR23.Reg, volatile.LoadUint32(&o.VCTR23.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR23_B737() uint32 {
	return (volatile.LoadUint32(&o.VCTR23.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR23_B738(value uint32) {
	volatile.StoreUint32(&o.VCTR23.Reg, volatile.LoadUint32(&o.VCTR23.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR23_B738() uint32 {
	return (volatile.LoadUint32(&o.VCTR23.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR23_B739(value uint32) {
	volatile.StoreUint32(&o.VCTR23.Reg, volatile.LoadUint32(&o.VCTR23.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR23_B739() uint32 {
	return (volatile.LoadUint32(&o.VCTR23.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR23_B740(value uint32) {
	volatile.StoreUint32(&o.VCTR23.Reg, volatile.LoadUint32(&o.VCTR23.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR23_B740() uint32 {
	return (volatile.LoadUint32(&o.VCTR23.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR23_B741(value uint32) {
	volatile.StoreUint32(&o.VCTR23.Reg, volatile.LoadUint32(&o.VCTR23.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR23_B741() uint32 {
	return (volatile.LoadUint32(&o.VCTR23.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR23_B742(value uint32) {
	volatile.StoreUint32(&o.VCTR23.Reg, volatile.LoadUint32(&o.VCTR23.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR23_B742() uint32 {
	return (volatile.LoadUint32(&o.VCTR23.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR23_B743(value uint32) {
	volatile.StoreUint32(&o.VCTR23.Reg, volatile.LoadUint32(&o.VCTR23.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR23_B743() uint32 {
	return (volatile.LoadUint32(&o.VCTR23.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR23_B744(value uint32) {
	volatile.StoreUint32(&o.VCTR23.Reg, volatile.LoadUint32(&o.VCTR23.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR23_B744() uint32 {
	return (volatile.LoadUint32(&o.VCTR23.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR23_B745(value uint32) {
	volatile.StoreUint32(&o.VCTR23.Reg, volatile.LoadUint32(&o.VCTR23.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR23_B745() uint32 {
	return (volatile.LoadUint32(&o.VCTR23.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR23_B746(value uint32) {
	volatile.StoreUint32(&o.VCTR23.Reg, volatile.LoadUint32(&o.VCTR23.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR23_B746() uint32 {
	return (volatile.LoadUint32(&o.VCTR23.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR23_B747(value uint32) {
	volatile.StoreUint32(&o.VCTR23.Reg, volatile.LoadUint32(&o.VCTR23.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR23_B747() uint32 {
	return (volatile.LoadUint32(&o.VCTR23.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR23_B748(value uint32) {
	volatile.StoreUint32(&o.VCTR23.Reg, volatile.LoadUint32(&o.VCTR23.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR23_B748() uint32 {
	return (volatile.LoadUint32(&o.VCTR23.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR23_B749(value uint32) {
	volatile.StoreUint32(&o.VCTR23.Reg, volatile.LoadUint32(&o.VCTR23.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR23_B749() uint32 {
	return (volatile.LoadUint32(&o.VCTR23.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR23_B750(value uint32) {
	volatile.StoreUint32(&o.VCTR23.Reg, volatile.LoadUint32(&o.VCTR23.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR23_B750() uint32 {
	return (volatile.LoadUint32(&o.VCTR23.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR23_B751(value uint32) {
	volatile.StoreUint32(&o.VCTR23.Reg, volatile.LoadUint32(&o.VCTR23.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR23_B751() uint32 {
	return (volatile.LoadUint32(&o.VCTR23.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR23_B752(value uint32) {
	volatile.StoreUint32(&o.VCTR23.Reg, volatile.LoadUint32(&o.VCTR23.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR23_B752() uint32 {
	return (volatile.LoadUint32(&o.VCTR23.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR23_B753(value uint32) {
	volatile.StoreUint32(&o.VCTR23.Reg, volatile.LoadUint32(&o.VCTR23.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR23_B753() uint32 {
	return (volatile.LoadUint32(&o.VCTR23.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR23_B754(value uint32) {
	volatile.StoreUint32(&o.VCTR23.Reg, volatile.LoadUint32(&o.VCTR23.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR23_B754() uint32 {
	return (volatile.LoadUint32(&o.VCTR23.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR23_B755(value uint32) {
	volatile.StoreUint32(&o.VCTR23.Reg, volatile.LoadUint32(&o.VCTR23.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR23_B755() uint32 {
	return (volatile.LoadUint32(&o.VCTR23.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR23_B756(value uint32) {
	volatile.StoreUint32(&o.VCTR23.Reg, volatile.LoadUint32(&o.VCTR23.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR23_B756() uint32 {
	return (volatile.LoadUint32(&o.VCTR23.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR23_B757(value uint32) {
	volatile.StoreUint32(&o.VCTR23.Reg, volatile.LoadUint32(&o.VCTR23.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR23_B757() uint32 {
	return (volatile.LoadUint32(&o.VCTR23.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR23_B758(value uint32) {
	volatile.StoreUint32(&o.VCTR23.Reg, volatile.LoadUint32(&o.VCTR23.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR23_B758() uint32 {
	return (volatile.LoadUint32(&o.VCTR23.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR23_B759(value uint32) {
	volatile.StoreUint32(&o.VCTR23.Reg, volatile.LoadUint32(&o.VCTR23.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR23_B759() uint32 {
	return (volatile.LoadUint32(&o.VCTR23.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR23_B760(value uint32) {
	volatile.StoreUint32(&o.VCTR23.Reg, volatile.LoadUint32(&o.VCTR23.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR23_B760() uint32 {
	return (volatile.LoadUint32(&o.VCTR23.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR23_B761(value uint32) {
	volatile.StoreUint32(&o.VCTR23.Reg, volatile.LoadUint32(&o.VCTR23.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR23_B761() uint32 {
	return (volatile.LoadUint32(&o.VCTR23.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR23_B762(value uint32) {
	volatile.StoreUint32(&o.VCTR23.Reg, volatile.LoadUint32(&o.VCTR23.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR23_B762() uint32 {
	return (volatile.LoadUint32(&o.VCTR23.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR23_B763(value uint32) {
	volatile.StoreUint32(&o.VCTR23.Reg, volatile.LoadUint32(&o.VCTR23.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR23_B763() uint32 {
	return (volatile.LoadUint32(&o.VCTR23.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR23_B764(value uint32) {
	volatile.StoreUint32(&o.VCTR23.Reg, volatile.LoadUint32(&o.VCTR23.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR23_B764() uint32 {
	return (volatile.LoadUint32(&o.VCTR23.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR23_B765(value uint32) {
	volatile.StoreUint32(&o.VCTR23.Reg, volatile.LoadUint32(&o.VCTR23.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR23_B765() uint32 {
	return (volatile.LoadUint32(&o.VCTR23.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR23_B766(value uint32) {
	volatile.StoreUint32(&o.VCTR23.Reg, volatile.LoadUint32(&o.VCTR23.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR23_B766() uint32 {
	return (volatile.LoadUint32(&o.VCTR23.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR23_B767(value uint32) {
	volatile.StoreUint32(&o.VCTR23.Reg, volatile.LoadUint32(&o.VCTR23.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR23_B767() uint32 {
	return (volatile.LoadUint32(&o.VCTR23.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR24: MPCBBx vector register
func (o *GTZC_Type) SetVCTR24_B768(value uint32) {
	volatile.StoreUint32(&o.VCTR24.Reg, volatile.LoadUint32(&o.VCTR24.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR24_B768() uint32 {
	return volatile.LoadUint32(&o.VCTR24.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR24_B769(value uint32) {
	volatile.StoreUint32(&o.VCTR24.Reg, volatile.LoadUint32(&o.VCTR24.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR24_B769() uint32 {
	return (volatile.LoadUint32(&o.VCTR24.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR24_B770(value uint32) {
	volatile.StoreUint32(&o.VCTR24.Reg, volatile.LoadUint32(&o.VCTR24.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR24_B770() uint32 {
	return (volatile.LoadUint32(&o.VCTR24.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR24_B771(value uint32) {
	volatile.StoreUint32(&o.VCTR24.Reg, volatile.LoadUint32(&o.VCTR24.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR24_B771() uint32 {
	return (volatile.LoadUint32(&o.VCTR24.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR24_B772(value uint32) {
	volatile.StoreUint32(&o.VCTR24.Reg, volatile.LoadUint32(&o.VCTR24.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR24_B772() uint32 {
	return (volatile.LoadUint32(&o.VCTR24.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR24_B773(value uint32) {
	volatile.StoreUint32(&o.VCTR24.Reg, volatile.LoadUint32(&o.VCTR24.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR24_B773() uint32 {
	return (volatile.LoadUint32(&o.VCTR24.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR24_B774(value uint32) {
	volatile.StoreUint32(&o.VCTR24.Reg, volatile.LoadUint32(&o.VCTR24.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR24_B774() uint32 {
	return (volatile.LoadUint32(&o.VCTR24.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR24_B775(value uint32) {
	volatile.StoreUint32(&o.VCTR24.Reg, volatile.LoadUint32(&o.VCTR24.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR24_B775() uint32 {
	return (volatile.LoadUint32(&o.VCTR24.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR24_B776(value uint32) {
	volatile.StoreUint32(&o.VCTR24.Reg, volatile.LoadUint32(&o.VCTR24.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR24_B776() uint32 {
	return (volatile.LoadUint32(&o.VCTR24.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR24_B777(value uint32) {
	volatile.StoreUint32(&o.VCTR24.Reg, volatile.LoadUint32(&o.VCTR24.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR24_B777() uint32 {
	return (volatile.LoadUint32(&o.VCTR24.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR24_B778(value uint32) {
	volatile.StoreUint32(&o.VCTR24.Reg, volatile.LoadUint32(&o.VCTR24.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR24_B778() uint32 {
	return (volatile.LoadUint32(&o.VCTR24.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR24_B779(value uint32) {
	volatile.StoreUint32(&o.VCTR24.Reg, volatile.LoadUint32(&o.VCTR24.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR24_B779() uint32 {
	return (volatile.LoadUint32(&o.VCTR24.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR24_B780(value uint32) {
	volatile.StoreUint32(&o.VCTR24.Reg, volatile.LoadUint32(&o.VCTR24.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR24_B780() uint32 {
	return (volatile.LoadUint32(&o.VCTR24.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR24_B781(value uint32) {
	volatile.StoreUint32(&o.VCTR24.Reg, volatile.LoadUint32(&o.VCTR24.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR24_B781() uint32 {
	return (volatile.LoadUint32(&o.VCTR24.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR24_B782(value uint32) {
	volatile.StoreUint32(&o.VCTR24.Reg, volatile.LoadUint32(&o.VCTR24.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR24_B782() uint32 {
	return (volatile.LoadUint32(&o.VCTR24.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR24_B783(value uint32) {
	volatile.StoreUint32(&o.VCTR24.Reg, volatile.LoadUint32(&o.VCTR24.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR24_B783() uint32 {
	return (volatile.LoadUint32(&o.VCTR24.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR24_B784(value uint32) {
	volatile.StoreUint32(&o.VCTR24.Reg, volatile.LoadUint32(&o.VCTR24.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR24_B784() uint32 {
	return (volatile.LoadUint32(&o.VCTR24.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR24_B785(value uint32) {
	volatile.StoreUint32(&o.VCTR24.Reg, volatile.LoadUint32(&o.VCTR24.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR24_B785() uint32 {
	return (volatile.LoadUint32(&o.VCTR24.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR24_B786(value uint32) {
	volatile.StoreUint32(&o.VCTR24.Reg, volatile.LoadUint32(&o.VCTR24.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR24_B786() uint32 {
	return (volatile.LoadUint32(&o.VCTR24.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR24_B787(value uint32) {
	volatile.StoreUint32(&o.VCTR24.Reg, volatile.LoadUint32(&o.VCTR24.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR24_B787() uint32 {
	return (volatile.LoadUint32(&o.VCTR24.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR24_B788(value uint32) {
	volatile.StoreUint32(&o.VCTR24.Reg, volatile.LoadUint32(&o.VCTR24.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR24_B788() uint32 {
	return (volatile.LoadUint32(&o.VCTR24.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR24_B789(value uint32) {
	volatile.StoreUint32(&o.VCTR24.Reg, volatile.LoadUint32(&o.VCTR24.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR24_B789() uint32 {
	return (volatile.LoadUint32(&o.VCTR24.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR24_B790(value uint32) {
	volatile.StoreUint32(&o.VCTR24.Reg, volatile.LoadUint32(&o.VCTR24.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR24_B790() uint32 {
	return (volatile.LoadUint32(&o.VCTR24.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR24_B791(value uint32) {
	volatile.StoreUint32(&o.VCTR24.Reg, volatile.LoadUint32(&o.VCTR24.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR24_B791() uint32 {
	return (volatile.LoadUint32(&o.VCTR24.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR24_B792(value uint32) {
	volatile.StoreUint32(&o.VCTR24.Reg, volatile.LoadUint32(&o.VCTR24.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR24_B792() uint32 {
	return (volatile.LoadUint32(&o.VCTR24.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR24_B793(value uint32) {
	volatile.StoreUint32(&o.VCTR24.Reg, volatile.LoadUint32(&o.VCTR24.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR24_B793() uint32 {
	return (volatile.LoadUint32(&o.VCTR24.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR24_B794(value uint32) {
	volatile.StoreUint32(&o.VCTR24.Reg, volatile.LoadUint32(&o.VCTR24.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR24_B794() uint32 {
	return (volatile.LoadUint32(&o.VCTR24.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR24_B795(value uint32) {
	volatile.StoreUint32(&o.VCTR24.Reg, volatile.LoadUint32(&o.VCTR24.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR24_B795() uint32 {
	return (volatile.LoadUint32(&o.VCTR24.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR24_B796(value uint32) {
	volatile.StoreUint32(&o.VCTR24.Reg, volatile.LoadUint32(&o.VCTR24.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR24_B796() uint32 {
	return (volatile.LoadUint32(&o.VCTR24.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR24_B797(value uint32) {
	volatile.StoreUint32(&o.VCTR24.Reg, volatile.LoadUint32(&o.VCTR24.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR24_B797() uint32 {
	return (volatile.LoadUint32(&o.VCTR24.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR24_B798(value uint32) {
	volatile.StoreUint32(&o.VCTR24.Reg, volatile.LoadUint32(&o.VCTR24.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR24_B798() uint32 {
	return (volatile.LoadUint32(&o.VCTR24.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR24_B799(value uint32) {
	volatile.StoreUint32(&o.VCTR24.Reg, volatile.LoadUint32(&o.VCTR24.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR24_B799() uint32 {
	return (volatile.LoadUint32(&o.VCTR24.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR25: MPCBBx vector register
func (o *GTZC_Type) SetVCTR25_B800(value uint32) {
	volatile.StoreUint32(&o.VCTR25.Reg, volatile.LoadUint32(&o.VCTR25.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR25_B800() uint32 {
	return volatile.LoadUint32(&o.VCTR25.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR25_B801(value uint32) {
	volatile.StoreUint32(&o.VCTR25.Reg, volatile.LoadUint32(&o.VCTR25.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR25_B801() uint32 {
	return (volatile.LoadUint32(&o.VCTR25.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR25_B802(value uint32) {
	volatile.StoreUint32(&o.VCTR25.Reg, volatile.LoadUint32(&o.VCTR25.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR25_B802() uint32 {
	return (volatile.LoadUint32(&o.VCTR25.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR25_B803(value uint32) {
	volatile.StoreUint32(&o.VCTR25.Reg, volatile.LoadUint32(&o.VCTR25.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR25_B803() uint32 {
	return (volatile.LoadUint32(&o.VCTR25.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR25_B804(value uint32) {
	volatile.StoreUint32(&o.VCTR25.Reg, volatile.LoadUint32(&o.VCTR25.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR25_B804() uint32 {
	return (volatile.LoadUint32(&o.VCTR25.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR25_B805(value uint32) {
	volatile.StoreUint32(&o.VCTR25.Reg, volatile.LoadUint32(&o.VCTR25.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR25_B805() uint32 {
	return (volatile.LoadUint32(&o.VCTR25.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR25_B806(value uint32) {
	volatile.StoreUint32(&o.VCTR25.Reg, volatile.LoadUint32(&o.VCTR25.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR25_B806() uint32 {
	return (volatile.LoadUint32(&o.VCTR25.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR25_B807(value uint32) {
	volatile.StoreUint32(&o.VCTR25.Reg, volatile.LoadUint32(&o.VCTR25.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR25_B807() uint32 {
	return (volatile.LoadUint32(&o.VCTR25.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR25_B808(value uint32) {
	volatile.StoreUint32(&o.VCTR25.Reg, volatile.LoadUint32(&o.VCTR25.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR25_B808() uint32 {
	return (volatile.LoadUint32(&o.VCTR25.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR25_B809(value uint32) {
	volatile.StoreUint32(&o.VCTR25.Reg, volatile.LoadUint32(&o.VCTR25.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR25_B809() uint32 {
	return (volatile.LoadUint32(&o.VCTR25.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR25_B810(value uint32) {
	volatile.StoreUint32(&o.VCTR25.Reg, volatile.LoadUint32(&o.VCTR25.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR25_B810() uint32 {
	return (volatile.LoadUint32(&o.VCTR25.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR25_B811(value uint32) {
	volatile.StoreUint32(&o.VCTR25.Reg, volatile.LoadUint32(&o.VCTR25.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR25_B811() uint32 {
	return (volatile.LoadUint32(&o.VCTR25.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR25_B812(value uint32) {
	volatile.StoreUint32(&o.VCTR25.Reg, volatile.LoadUint32(&o.VCTR25.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR25_B812() uint32 {
	return (volatile.LoadUint32(&o.VCTR25.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR25_B813(value uint32) {
	volatile.StoreUint32(&o.VCTR25.Reg, volatile.LoadUint32(&o.VCTR25.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR25_B813() uint32 {
	return (volatile.LoadUint32(&o.VCTR25.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR25_B814(value uint32) {
	volatile.StoreUint32(&o.VCTR25.Reg, volatile.LoadUint32(&o.VCTR25.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR25_B814() uint32 {
	return (volatile.LoadUint32(&o.VCTR25.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR25_B815(value uint32) {
	volatile.StoreUint32(&o.VCTR25.Reg, volatile.LoadUint32(&o.VCTR25.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR25_B815() uint32 {
	return (volatile.LoadUint32(&o.VCTR25.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR25_B816(value uint32) {
	volatile.StoreUint32(&o.VCTR25.Reg, volatile.LoadUint32(&o.VCTR25.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR25_B816() uint32 {
	return (volatile.LoadUint32(&o.VCTR25.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR25_B817(value uint32) {
	volatile.StoreUint32(&o.VCTR25.Reg, volatile.LoadUint32(&o.VCTR25.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR25_B817() uint32 {
	return (volatile.LoadUint32(&o.VCTR25.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR25_B818(value uint32) {
	volatile.StoreUint32(&o.VCTR25.Reg, volatile.LoadUint32(&o.VCTR25.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR25_B818() uint32 {
	return (volatile.LoadUint32(&o.VCTR25.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR25_B819(value uint32) {
	volatile.StoreUint32(&o.VCTR25.Reg, volatile.LoadUint32(&o.VCTR25.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR25_B819() uint32 {
	return (volatile.LoadUint32(&o.VCTR25.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR25_B820(value uint32) {
	volatile.StoreUint32(&o.VCTR25.Reg, volatile.LoadUint32(&o.VCTR25.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR25_B820() uint32 {
	return (volatile.LoadUint32(&o.VCTR25.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR25_B821(value uint32) {
	volatile.StoreUint32(&o.VCTR25.Reg, volatile.LoadUint32(&o.VCTR25.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR25_B821() uint32 {
	return (volatile.LoadUint32(&o.VCTR25.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR25_B822(value uint32) {
	volatile.StoreUint32(&o.VCTR25.Reg, volatile.LoadUint32(&o.VCTR25.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR25_B822() uint32 {
	return (volatile.LoadUint32(&o.VCTR25.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR25_B823(value uint32) {
	volatile.StoreUint32(&o.VCTR25.Reg, volatile.LoadUint32(&o.VCTR25.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR25_B823() uint32 {
	return (volatile.LoadUint32(&o.VCTR25.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR25_B824(value uint32) {
	volatile.StoreUint32(&o.VCTR25.Reg, volatile.LoadUint32(&o.VCTR25.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR25_B824() uint32 {
	return (volatile.LoadUint32(&o.VCTR25.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR25_B825(value uint32) {
	volatile.StoreUint32(&o.VCTR25.Reg, volatile.LoadUint32(&o.VCTR25.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR25_B825() uint32 {
	return (volatile.LoadUint32(&o.VCTR25.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR25_B826(value uint32) {
	volatile.StoreUint32(&o.VCTR25.Reg, volatile.LoadUint32(&o.VCTR25.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR25_B826() uint32 {
	return (volatile.LoadUint32(&o.VCTR25.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR25_B827(value uint32) {
	volatile.StoreUint32(&o.VCTR25.Reg, volatile.LoadUint32(&o.VCTR25.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR25_B827() uint32 {
	return (volatile.LoadUint32(&o.VCTR25.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR25_B828(value uint32) {
	volatile.StoreUint32(&o.VCTR25.Reg, volatile.LoadUint32(&o.VCTR25.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR25_B828() uint32 {
	return (volatile.LoadUint32(&o.VCTR25.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR25_B829(value uint32) {
	volatile.StoreUint32(&o.VCTR25.Reg, volatile.LoadUint32(&o.VCTR25.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR25_B829() uint32 {
	return (volatile.LoadUint32(&o.VCTR25.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR25_B830(value uint32) {
	volatile.StoreUint32(&o.VCTR25.Reg, volatile.LoadUint32(&o.VCTR25.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR25_B830() uint32 {
	return (volatile.LoadUint32(&o.VCTR25.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR25_B831(value uint32) {
	volatile.StoreUint32(&o.VCTR25.Reg, volatile.LoadUint32(&o.VCTR25.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR25_B831() uint32 {
	return (volatile.LoadUint32(&o.VCTR25.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR26: MPCBBx vector register
func (o *GTZC_Type) SetVCTR26_B832(value uint32) {
	volatile.StoreUint32(&o.VCTR26.Reg, volatile.LoadUint32(&o.VCTR26.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR26_B832() uint32 {
	return volatile.LoadUint32(&o.VCTR26.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR26_B833(value uint32) {
	volatile.StoreUint32(&o.VCTR26.Reg, volatile.LoadUint32(&o.VCTR26.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR26_B833() uint32 {
	return (volatile.LoadUint32(&o.VCTR26.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR26_B834(value uint32) {
	volatile.StoreUint32(&o.VCTR26.Reg, volatile.LoadUint32(&o.VCTR26.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR26_B834() uint32 {
	return (volatile.LoadUint32(&o.VCTR26.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR26_B835(value uint32) {
	volatile.StoreUint32(&o.VCTR26.Reg, volatile.LoadUint32(&o.VCTR26.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR26_B835() uint32 {
	return (volatile.LoadUint32(&o.VCTR26.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR26_B836(value uint32) {
	volatile.StoreUint32(&o.VCTR26.Reg, volatile.LoadUint32(&o.VCTR26.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR26_B836() uint32 {
	return (volatile.LoadUint32(&o.VCTR26.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR26_B837(value uint32) {
	volatile.StoreUint32(&o.VCTR26.Reg, volatile.LoadUint32(&o.VCTR26.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR26_B837() uint32 {
	return (volatile.LoadUint32(&o.VCTR26.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR26_B838(value uint32) {
	volatile.StoreUint32(&o.VCTR26.Reg, volatile.LoadUint32(&o.VCTR26.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR26_B838() uint32 {
	return (volatile.LoadUint32(&o.VCTR26.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR26_B839(value uint32) {
	volatile.StoreUint32(&o.VCTR26.Reg, volatile.LoadUint32(&o.VCTR26.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR26_B839() uint32 {
	return (volatile.LoadUint32(&o.VCTR26.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR26_B840(value uint32) {
	volatile.StoreUint32(&o.VCTR26.Reg, volatile.LoadUint32(&o.VCTR26.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR26_B840() uint32 {
	return (volatile.LoadUint32(&o.VCTR26.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR26_B841(value uint32) {
	volatile.StoreUint32(&o.VCTR26.Reg, volatile.LoadUint32(&o.VCTR26.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR26_B841() uint32 {
	return (volatile.LoadUint32(&o.VCTR26.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR26_B842(value uint32) {
	volatile.StoreUint32(&o.VCTR26.Reg, volatile.LoadUint32(&o.VCTR26.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR26_B842() uint32 {
	return (volatile.LoadUint32(&o.VCTR26.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR26_B843(value uint32) {
	volatile.StoreUint32(&o.VCTR26.Reg, volatile.LoadUint32(&o.VCTR26.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR26_B843() uint32 {
	return (volatile.LoadUint32(&o.VCTR26.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR26_B844(value uint32) {
	volatile.StoreUint32(&o.VCTR26.Reg, volatile.LoadUint32(&o.VCTR26.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR26_B844() uint32 {
	return (volatile.LoadUint32(&o.VCTR26.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR26_B845(value uint32) {
	volatile.StoreUint32(&o.VCTR26.Reg, volatile.LoadUint32(&o.VCTR26.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR26_B845() uint32 {
	return (volatile.LoadUint32(&o.VCTR26.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR26_B846(value uint32) {
	volatile.StoreUint32(&o.VCTR26.Reg, volatile.LoadUint32(&o.VCTR26.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR26_B846() uint32 {
	return (volatile.LoadUint32(&o.VCTR26.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR26_B847(value uint32) {
	volatile.StoreUint32(&o.VCTR26.Reg, volatile.LoadUint32(&o.VCTR26.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR26_B847() uint32 {
	return (volatile.LoadUint32(&o.VCTR26.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR26_B848(value uint32) {
	volatile.StoreUint32(&o.VCTR26.Reg, volatile.LoadUint32(&o.VCTR26.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR26_B848() uint32 {
	return (volatile.LoadUint32(&o.VCTR26.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR26_B849(value uint32) {
	volatile.StoreUint32(&o.VCTR26.Reg, volatile.LoadUint32(&o.VCTR26.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR26_B849() uint32 {
	return (volatile.LoadUint32(&o.VCTR26.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR26_B850(value uint32) {
	volatile.StoreUint32(&o.VCTR26.Reg, volatile.LoadUint32(&o.VCTR26.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR26_B850() uint32 {
	return (volatile.LoadUint32(&o.VCTR26.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR26_B851(value uint32) {
	volatile.StoreUint32(&o.VCTR26.Reg, volatile.LoadUint32(&o.VCTR26.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR26_B851() uint32 {
	return (volatile.LoadUint32(&o.VCTR26.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR26_B852(value uint32) {
	volatile.StoreUint32(&o.VCTR26.Reg, volatile.LoadUint32(&o.VCTR26.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR26_B852() uint32 {
	return (volatile.LoadUint32(&o.VCTR26.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR26_B853(value uint32) {
	volatile.StoreUint32(&o.VCTR26.Reg, volatile.LoadUint32(&o.VCTR26.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR26_B853() uint32 {
	return (volatile.LoadUint32(&o.VCTR26.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR26_B854(value uint32) {
	volatile.StoreUint32(&o.VCTR26.Reg, volatile.LoadUint32(&o.VCTR26.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR26_B854() uint32 {
	return (volatile.LoadUint32(&o.VCTR26.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR26_B855(value uint32) {
	volatile.StoreUint32(&o.VCTR26.Reg, volatile.LoadUint32(&o.VCTR26.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR26_B855() uint32 {
	return (volatile.LoadUint32(&o.VCTR26.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR26_B856(value uint32) {
	volatile.StoreUint32(&o.VCTR26.Reg, volatile.LoadUint32(&o.VCTR26.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR26_B856() uint32 {
	return (volatile.LoadUint32(&o.VCTR26.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR26_B857(value uint32) {
	volatile.StoreUint32(&o.VCTR26.Reg, volatile.LoadUint32(&o.VCTR26.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR26_B857() uint32 {
	return (volatile.LoadUint32(&o.VCTR26.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR26_B858(value uint32) {
	volatile.StoreUint32(&o.VCTR26.Reg, volatile.LoadUint32(&o.VCTR26.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR26_B858() uint32 {
	return (volatile.LoadUint32(&o.VCTR26.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR26_B859(value uint32) {
	volatile.StoreUint32(&o.VCTR26.Reg, volatile.LoadUint32(&o.VCTR26.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR26_B859() uint32 {
	return (volatile.LoadUint32(&o.VCTR26.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR26_B860(value uint32) {
	volatile.StoreUint32(&o.VCTR26.Reg, volatile.LoadUint32(&o.VCTR26.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR26_B860() uint32 {
	return (volatile.LoadUint32(&o.VCTR26.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR26_B861(value uint32) {
	volatile.StoreUint32(&o.VCTR26.Reg, volatile.LoadUint32(&o.VCTR26.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR26_B861() uint32 {
	return (volatile.LoadUint32(&o.VCTR26.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR26_B862(value uint32) {
	volatile.StoreUint32(&o.VCTR26.Reg, volatile.LoadUint32(&o.VCTR26.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR26_B862() uint32 {
	return (volatile.LoadUint32(&o.VCTR26.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR26_B863(value uint32) {
	volatile.StoreUint32(&o.VCTR26.Reg, volatile.LoadUint32(&o.VCTR26.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR26_B863() uint32 {
	return (volatile.LoadUint32(&o.VCTR26.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR27: MPCBBx vector register
func (o *GTZC_Type) SetVCTR27_B864(value uint32) {
	volatile.StoreUint32(&o.VCTR27.Reg, volatile.LoadUint32(&o.VCTR27.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR27_B864() uint32 {
	return volatile.LoadUint32(&o.VCTR27.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR27_B865(value uint32) {
	volatile.StoreUint32(&o.VCTR27.Reg, volatile.LoadUint32(&o.VCTR27.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR27_B865() uint32 {
	return (volatile.LoadUint32(&o.VCTR27.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR27_B866(value uint32) {
	volatile.StoreUint32(&o.VCTR27.Reg, volatile.LoadUint32(&o.VCTR27.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR27_B866() uint32 {
	return (volatile.LoadUint32(&o.VCTR27.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR27_B867(value uint32) {
	volatile.StoreUint32(&o.VCTR27.Reg, volatile.LoadUint32(&o.VCTR27.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR27_B867() uint32 {
	return (volatile.LoadUint32(&o.VCTR27.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR27_B868(value uint32) {
	volatile.StoreUint32(&o.VCTR27.Reg, volatile.LoadUint32(&o.VCTR27.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR27_B868() uint32 {
	return (volatile.LoadUint32(&o.VCTR27.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR27_B869(value uint32) {
	volatile.StoreUint32(&o.VCTR27.Reg, volatile.LoadUint32(&o.VCTR27.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR27_B869() uint32 {
	return (volatile.LoadUint32(&o.VCTR27.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR27_B870(value uint32) {
	volatile.StoreUint32(&o.VCTR27.Reg, volatile.LoadUint32(&o.VCTR27.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR27_B870() uint32 {
	return (volatile.LoadUint32(&o.VCTR27.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR27_B871(value uint32) {
	volatile.StoreUint32(&o.VCTR27.Reg, volatile.LoadUint32(&o.VCTR27.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR27_B871() uint32 {
	return (volatile.LoadUint32(&o.VCTR27.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR27_B872(value uint32) {
	volatile.StoreUint32(&o.VCTR27.Reg, volatile.LoadUint32(&o.VCTR27.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR27_B872() uint32 {
	return (volatile.LoadUint32(&o.VCTR27.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR27_B873(value uint32) {
	volatile.StoreUint32(&o.VCTR27.Reg, volatile.LoadUint32(&o.VCTR27.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR27_B873() uint32 {
	return (volatile.LoadUint32(&o.VCTR27.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR27_B874(value uint32) {
	volatile.StoreUint32(&o.VCTR27.Reg, volatile.LoadUint32(&o.VCTR27.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR27_B874() uint32 {
	return (volatile.LoadUint32(&o.VCTR27.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR27_B875(value uint32) {
	volatile.StoreUint32(&o.VCTR27.Reg, volatile.LoadUint32(&o.VCTR27.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR27_B875() uint32 {
	return (volatile.LoadUint32(&o.VCTR27.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR27_B876(value uint32) {
	volatile.StoreUint32(&o.VCTR27.Reg, volatile.LoadUint32(&o.VCTR27.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR27_B876() uint32 {
	return (volatile.LoadUint32(&o.VCTR27.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR27_B877(value uint32) {
	volatile.StoreUint32(&o.VCTR27.Reg, volatile.LoadUint32(&o.VCTR27.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR27_B877() uint32 {
	return (volatile.LoadUint32(&o.VCTR27.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR27_B878(value uint32) {
	volatile.StoreUint32(&o.VCTR27.Reg, volatile.LoadUint32(&o.VCTR27.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR27_B878() uint32 {
	return (volatile.LoadUint32(&o.VCTR27.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR27_B879(value uint32) {
	volatile.StoreUint32(&o.VCTR27.Reg, volatile.LoadUint32(&o.VCTR27.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR27_B879() uint32 {
	return (volatile.LoadUint32(&o.VCTR27.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR27_B880(value uint32) {
	volatile.StoreUint32(&o.VCTR27.Reg, volatile.LoadUint32(&o.VCTR27.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR27_B880() uint32 {
	return (volatile.LoadUint32(&o.VCTR27.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR27_B881(value uint32) {
	volatile.StoreUint32(&o.VCTR27.Reg, volatile.LoadUint32(&o.VCTR27.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR27_B881() uint32 {
	return (volatile.LoadUint32(&o.VCTR27.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR27_B882(value uint32) {
	volatile.StoreUint32(&o.VCTR27.Reg, volatile.LoadUint32(&o.VCTR27.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR27_B882() uint32 {
	return (volatile.LoadUint32(&o.VCTR27.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR27_B883(value uint32) {
	volatile.StoreUint32(&o.VCTR27.Reg, volatile.LoadUint32(&o.VCTR27.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR27_B883() uint32 {
	return (volatile.LoadUint32(&o.VCTR27.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR27_B884(value uint32) {
	volatile.StoreUint32(&o.VCTR27.Reg, volatile.LoadUint32(&o.VCTR27.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR27_B884() uint32 {
	return (volatile.LoadUint32(&o.VCTR27.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR27_B885(value uint32) {
	volatile.StoreUint32(&o.VCTR27.Reg, volatile.LoadUint32(&o.VCTR27.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR27_B885() uint32 {
	return (volatile.LoadUint32(&o.VCTR27.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR27_B886(value uint32) {
	volatile.StoreUint32(&o.VCTR27.Reg, volatile.LoadUint32(&o.VCTR27.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR27_B886() uint32 {
	return (volatile.LoadUint32(&o.VCTR27.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR27_B887(value uint32) {
	volatile.StoreUint32(&o.VCTR27.Reg, volatile.LoadUint32(&o.VCTR27.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR27_B887() uint32 {
	return (volatile.LoadUint32(&o.VCTR27.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR27_B888(value uint32) {
	volatile.StoreUint32(&o.VCTR27.Reg, volatile.LoadUint32(&o.VCTR27.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR27_B888() uint32 {
	return (volatile.LoadUint32(&o.VCTR27.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR27_B889(value uint32) {
	volatile.StoreUint32(&o.VCTR27.Reg, volatile.LoadUint32(&o.VCTR27.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR27_B889() uint32 {
	return (volatile.LoadUint32(&o.VCTR27.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR27_B890(value uint32) {
	volatile.StoreUint32(&o.VCTR27.Reg, volatile.LoadUint32(&o.VCTR27.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR27_B890() uint32 {
	return (volatile.LoadUint32(&o.VCTR27.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR27_B891(value uint32) {
	volatile.StoreUint32(&o.VCTR27.Reg, volatile.LoadUint32(&o.VCTR27.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR27_B891() uint32 {
	return (volatile.LoadUint32(&o.VCTR27.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR27_B892(value uint32) {
	volatile.StoreUint32(&o.VCTR27.Reg, volatile.LoadUint32(&o.VCTR27.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR27_B892() uint32 {
	return (volatile.LoadUint32(&o.VCTR27.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR27_B893(value uint32) {
	volatile.StoreUint32(&o.VCTR27.Reg, volatile.LoadUint32(&o.VCTR27.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR27_B893() uint32 {
	return (volatile.LoadUint32(&o.VCTR27.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR27_B894(value uint32) {
	volatile.StoreUint32(&o.VCTR27.Reg, volatile.LoadUint32(&o.VCTR27.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR27_B894() uint32 {
	return (volatile.LoadUint32(&o.VCTR27.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR27_B895(value uint32) {
	volatile.StoreUint32(&o.VCTR27.Reg, volatile.LoadUint32(&o.VCTR27.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR27_B895() uint32 {
	return (volatile.LoadUint32(&o.VCTR27.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR28: MPCBBx vector register
func (o *GTZC_Type) SetVCTR28_B896(value uint32) {
	volatile.StoreUint32(&o.VCTR28.Reg, volatile.LoadUint32(&o.VCTR28.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR28_B896() uint32 {
	return volatile.LoadUint32(&o.VCTR28.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR28_B897(value uint32) {
	volatile.StoreUint32(&o.VCTR28.Reg, volatile.LoadUint32(&o.VCTR28.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR28_B897() uint32 {
	return (volatile.LoadUint32(&o.VCTR28.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR28_B898(value uint32) {
	volatile.StoreUint32(&o.VCTR28.Reg, volatile.LoadUint32(&o.VCTR28.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR28_B898() uint32 {
	return (volatile.LoadUint32(&o.VCTR28.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR28_B899(value uint32) {
	volatile.StoreUint32(&o.VCTR28.Reg, volatile.LoadUint32(&o.VCTR28.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR28_B899() uint32 {
	return (volatile.LoadUint32(&o.VCTR28.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR28_B900(value uint32) {
	volatile.StoreUint32(&o.VCTR28.Reg, volatile.LoadUint32(&o.VCTR28.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR28_B900() uint32 {
	return (volatile.LoadUint32(&o.VCTR28.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR28_B901(value uint32) {
	volatile.StoreUint32(&o.VCTR28.Reg, volatile.LoadUint32(&o.VCTR28.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR28_B901() uint32 {
	return (volatile.LoadUint32(&o.VCTR28.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR28_B902(value uint32) {
	volatile.StoreUint32(&o.VCTR28.Reg, volatile.LoadUint32(&o.VCTR28.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR28_B902() uint32 {
	return (volatile.LoadUint32(&o.VCTR28.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR28_B903(value uint32) {
	volatile.StoreUint32(&o.VCTR28.Reg, volatile.LoadUint32(&o.VCTR28.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR28_B903() uint32 {
	return (volatile.LoadUint32(&o.VCTR28.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR28_B904(value uint32) {
	volatile.StoreUint32(&o.VCTR28.Reg, volatile.LoadUint32(&o.VCTR28.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR28_B904() uint32 {
	return (volatile.LoadUint32(&o.VCTR28.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR28_B905(value uint32) {
	volatile.StoreUint32(&o.VCTR28.Reg, volatile.LoadUint32(&o.VCTR28.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR28_B905() uint32 {
	return (volatile.LoadUint32(&o.VCTR28.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR28_B906(value uint32) {
	volatile.StoreUint32(&o.VCTR28.Reg, volatile.LoadUint32(&o.VCTR28.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR28_B906() uint32 {
	return (volatile.LoadUint32(&o.VCTR28.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR28_B907(value uint32) {
	volatile.StoreUint32(&o.VCTR28.Reg, volatile.LoadUint32(&o.VCTR28.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR28_B907() uint32 {
	return (volatile.LoadUint32(&o.VCTR28.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR28_B908(value uint32) {
	volatile.StoreUint32(&o.VCTR28.Reg, volatile.LoadUint32(&o.VCTR28.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR28_B908() uint32 {
	return (volatile.LoadUint32(&o.VCTR28.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR28_B909(value uint32) {
	volatile.StoreUint32(&o.VCTR28.Reg, volatile.LoadUint32(&o.VCTR28.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR28_B909() uint32 {
	return (volatile.LoadUint32(&o.VCTR28.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR28_B910(value uint32) {
	volatile.StoreUint32(&o.VCTR28.Reg, volatile.LoadUint32(&o.VCTR28.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR28_B910() uint32 {
	return (volatile.LoadUint32(&o.VCTR28.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR28_B911(value uint32) {
	volatile.StoreUint32(&o.VCTR28.Reg, volatile.LoadUint32(&o.VCTR28.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR28_B911() uint32 {
	return (volatile.LoadUint32(&o.VCTR28.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR28_B912(value uint32) {
	volatile.StoreUint32(&o.VCTR28.Reg, volatile.LoadUint32(&o.VCTR28.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR28_B912() uint32 {
	return (volatile.LoadUint32(&o.VCTR28.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR28_B913(value uint32) {
	volatile.StoreUint32(&o.VCTR28.Reg, volatile.LoadUint32(&o.VCTR28.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR28_B913() uint32 {
	return (volatile.LoadUint32(&o.VCTR28.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR28_B914(value uint32) {
	volatile.StoreUint32(&o.VCTR28.Reg, volatile.LoadUint32(&o.VCTR28.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR28_B914() uint32 {
	return (volatile.LoadUint32(&o.VCTR28.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR28_B915(value uint32) {
	volatile.StoreUint32(&o.VCTR28.Reg, volatile.LoadUint32(&o.VCTR28.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR28_B915() uint32 {
	return (volatile.LoadUint32(&o.VCTR28.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR28_B916(value uint32) {
	volatile.StoreUint32(&o.VCTR28.Reg, volatile.LoadUint32(&o.VCTR28.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR28_B916() uint32 {
	return (volatile.LoadUint32(&o.VCTR28.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR28_B917(value uint32) {
	volatile.StoreUint32(&o.VCTR28.Reg, volatile.LoadUint32(&o.VCTR28.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR28_B917() uint32 {
	return (volatile.LoadUint32(&o.VCTR28.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR28_B918(value uint32) {
	volatile.StoreUint32(&o.VCTR28.Reg, volatile.LoadUint32(&o.VCTR28.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR28_B918() uint32 {
	return (volatile.LoadUint32(&o.VCTR28.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR28_B919(value uint32) {
	volatile.StoreUint32(&o.VCTR28.Reg, volatile.LoadUint32(&o.VCTR28.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR28_B919() uint32 {
	return (volatile.LoadUint32(&o.VCTR28.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR28_B920(value uint32) {
	volatile.StoreUint32(&o.VCTR28.Reg, volatile.LoadUint32(&o.VCTR28.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR28_B920() uint32 {
	return (volatile.LoadUint32(&o.VCTR28.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR28_B921(value uint32) {
	volatile.StoreUint32(&o.VCTR28.Reg, volatile.LoadUint32(&o.VCTR28.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR28_B921() uint32 {
	return (volatile.LoadUint32(&o.VCTR28.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR28_B922(value uint32) {
	volatile.StoreUint32(&o.VCTR28.Reg, volatile.LoadUint32(&o.VCTR28.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR28_B922() uint32 {
	return (volatile.LoadUint32(&o.VCTR28.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR28_B923(value uint32) {
	volatile.StoreUint32(&o.VCTR28.Reg, volatile.LoadUint32(&o.VCTR28.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR28_B923() uint32 {
	return (volatile.LoadUint32(&o.VCTR28.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR28_B924(value uint32) {
	volatile.StoreUint32(&o.VCTR28.Reg, volatile.LoadUint32(&o.VCTR28.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR28_B924() uint32 {
	return (volatile.LoadUint32(&o.VCTR28.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR28_B925(value uint32) {
	volatile.StoreUint32(&o.VCTR28.Reg, volatile.LoadUint32(&o.VCTR28.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR28_B925() uint32 {
	return (volatile.LoadUint32(&o.VCTR28.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR28_B926(value uint32) {
	volatile.StoreUint32(&o.VCTR28.Reg, volatile.LoadUint32(&o.VCTR28.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR28_B926() uint32 {
	return (volatile.LoadUint32(&o.VCTR28.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR28_B927(value uint32) {
	volatile.StoreUint32(&o.VCTR28.Reg, volatile.LoadUint32(&o.VCTR28.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR28_B927() uint32 {
	return (volatile.LoadUint32(&o.VCTR28.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR29: MPCBBx vector register
func (o *GTZC_Type) SetVCTR29_B928(value uint32) {
	volatile.StoreUint32(&o.VCTR29.Reg, volatile.LoadUint32(&o.VCTR29.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR29_B928() uint32 {
	return volatile.LoadUint32(&o.VCTR29.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR29_B929(value uint32) {
	volatile.StoreUint32(&o.VCTR29.Reg, volatile.LoadUint32(&o.VCTR29.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR29_B929() uint32 {
	return (volatile.LoadUint32(&o.VCTR29.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR29_B930(value uint32) {
	volatile.StoreUint32(&o.VCTR29.Reg, volatile.LoadUint32(&o.VCTR29.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR29_B930() uint32 {
	return (volatile.LoadUint32(&o.VCTR29.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR29_B931(value uint32) {
	volatile.StoreUint32(&o.VCTR29.Reg, volatile.LoadUint32(&o.VCTR29.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR29_B931() uint32 {
	return (volatile.LoadUint32(&o.VCTR29.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR29_B932(value uint32) {
	volatile.StoreUint32(&o.VCTR29.Reg, volatile.LoadUint32(&o.VCTR29.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR29_B932() uint32 {
	return (volatile.LoadUint32(&o.VCTR29.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR29_B933(value uint32) {
	volatile.StoreUint32(&o.VCTR29.Reg, volatile.LoadUint32(&o.VCTR29.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR29_B933() uint32 {
	return (volatile.LoadUint32(&o.VCTR29.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR29_B934(value uint32) {
	volatile.StoreUint32(&o.VCTR29.Reg, volatile.LoadUint32(&o.VCTR29.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR29_B934() uint32 {
	return (volatile.LoadUint32(&o.VCTR29.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR29_B935(value uint32) {
	volatile.StoreUint32(&o.VCTR29.Reg, volatile.LoadUint32(&o.VCTR29.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR29_B935() uint32 {
	return (volatile.LoadUint32(&o.VCTR29.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR29_B936(value uint32) {
	volatile.StoreUint32(&o.VCTR29.Reg, volatile.LoadUint32(&o.VCTR29.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR29_B936() uint32 {
	return (volatile.LoadUint32(&o.VCTR29.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR29_B937(value uint32) {
	volatile.StoreUint32(&o.VCTR29.Reg, volatile.LoadUint32(&o.VCTR29.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR29_B937() uint32 {
	return (volatile.LoadUint32(&o.VCTR29.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR29_B938(value uint32) {
	volatile.StoreUint32(&o.VCTR29.Reg, volatile.LoadUint32(&o.VCTR29.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR29_B938() uint32 {
	return (volatile.LoadUint32(&o.VCTR29.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR29_B939(value uint32) {
	volatile.StoreUint32(&o.VCTR29.Reg, volatile.LoadUint32(&o.VCTR29.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR29_B939() uint32 {
	return (volatile.LoadUint32(&o.VCTR29.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR29_B940(value uint32) {
	volatile.StoreUint32(&o.VCTR29.Reg, volatile.LoadUint32(&o.VCTR29.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR29_B940() uint32 {
	return (volatile.LoadUint32(&o.VCTR29.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR29_B941(value uint32) {
	volatile.StoreUint32(&o.VCTR29.Reg, volatile.LoadUint32(&o.VCTR29.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR29_B941() uint32 {
	return (volatile.LoadUint32(&o.VCTR29.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR29_B942(value uint32) {
	volatile.StoreUint32(&o.VCTR29.Reg, volatile.LoadUint32(&o.VCTR29.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR29_B942() uint32 {
	return (volatile.LoadUint32(&o.VCTR29.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR29_B943(value uint32) {
	volatile.StoreUint32(&o.VCTR29.Reg, volatile.LoadUint32(&o.VCTR29.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR29_B943() uint32 {
	return (volatile.LoadUint32(&o.VCTR29.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR29_B944(value uint32) {
	volatile.StoreUint32(&o.VCTR29.Reg, volatile.LoadUint32(&o.VCTR29.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR29_B944() uint32 {
	return (volatile.LoadUint32(&o.VCTR29.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR29_B945(value uint32) {
	volatile.StoreUint32(&o.VCTR29.Reg, volatile.LoadUint32(&o.VCTR29.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR29_B945() uint32 {
	return (volatile.LoadUint32(&o.VCTR29.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR29_B946(value uint32) {
	volatile.StoreUint32(&o.VCTR29.Reg, volatile.LoadUint32(&o.VCTR29.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR29_B946() uint32 {
	return (volatile.LoadUint32(&o.VCTR29.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR29_B947(value uint32) {
	volatile.StoreUint32(&o.VCTR29.Reg, volatile.LoadUint32(&o.VCTR29.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR29_B947() uint32 {
	return (volatile.LoadUint32(&o.VCTR29.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR29_B948(value uint32) {
	volatile.StoreUint32(&o.VCTR29.Reg, volatile.LoadUint32(&o.VCTR29.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR29_B948() uint32 {
	return (volatile.LoadUint32(&o.VCTR29.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR29_B949(value uint32) {
	volatile.StoreUint32(&o.VCTR29.Reg, volatile.LoadUint32(&o.VCTR29.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR29_B949() uint32 {
	return (volatile.LoadUint32(&o.VCTR29.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR29_B950(value uint32) {
	volatile.StoreUint32(&o.VCTR29.Reg, volatile.LoadUint32(&o.VCTR29.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR29_B950() uint32 {
	return (volatile.LoadUint32(&o.VCTR29.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR29_B951(value uint32) {
	volatile.StoreUint32(&o.VCTR29.Reg, volatile.LoadUint32(&o.VCTR29.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR29_B951() uint32 {
	return (volatile.LoadUint32(&o.VCTR29.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR29_B952(value uint32) {
	volatile.StoreUint32(&o.VCTR29.Reg, volatile.LoadUint32(&o.VCTR29.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR29_B952() uint32 {
	return (volatile.LoadUint32(&o.VCTR29.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR29_B953(value uint32) {
	volatile.StoreUint32(&o.VCTR29.Reg, volatile.LoadUint32(&o.VCTR29.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR29_B953() uint32 {
	return (volatile.LoadUint32(&o.VCTR29.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR29_B954(value uint32) {
	volatile.StoreUint32(&o.VCTR29.Reg, volatile.LoadUint32(&o.VCTR29.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR29_B954() uint32 {
	return (volatile.LoadUint32(&o.VCTR29.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR29_B955(value uint32) {
	volatile.StoreUint32(&o.VCTR29.Reg, volatile.LoadUint32(&o.VCTR29.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR29_B955() uint32 {
	return (volatile.LoadUint32(&o.VCTR29.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR29_B956(value uint32) {
	volatile.StoreUint32(&o.VCTR29.Reg, volatile.LoadUint32(&o.VCTR29.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR29_B956() uint32 {
	return (volatile.LoadUint32(&o.VCTR29.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR29_B957(value uint32) {
	volatile.StoreUint32(&o.VCTR29.Reg, volatile.LoadUint32(&o.VCTR29.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR29_B957() uint32 {
	return (volatile.LoadUint32(&o.VCTR29.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR29_B958(value uint32) {
	volatile.StoreUint32(&o.VCTR29.Reg, volatile.LoadUint32(&o.VCTR29.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR29_B958() uint32 {
	return (volatile.LoadUint32(&o.VCTR29.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR29_B959(value uint32) {
	volatile.StoreUint32(&o.VCTR29.Reg, volatile.LoadUint32(&o.VCTR29.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR29_B959() uint32 {
	return (volatile.LoadUint32(&o.VCTR29.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR30: MPCBBx vector register
func (o *GTZC_Type) SetVCTR30_B960(value uint32) {
	volatile.StoreUint32(&o.VCTR30.Reg, volatile.LoadUint32(&o.VCTR30.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR30_B960() uint32 {
	return volatile.LoadUint32(&o.VCTR30.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR30_B961(value uint32) {
	volatile.StoreUint32(&o.VCTR30.Reg, volatile.LoadUint32(&o.VCTR30.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR30_B961() uint32 {
	return (volatile.LoadUint32(&o.VCTR30.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR30_B962(value uint32) {
	volatile.StoreUint32(&o.VCTR30.Reg, volatile.LoadUint32(&o.VCTR30.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR30_B962() uint32 {
	return (volatile.LoadUint32(&o.VCTR30.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR30_B963(value uint32) {
	volatile.StoreUint32(&o.VCTR30.Reg, volatile.LoadUint32(&o.VCTR30.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR30_B963() uint32 {
	return (volatile.LoadUint32(&o.VCTR30.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR30_B964(value uint32) {
	volatile.StoreUint32(&o.VCTR30.Reg, volatile.LoadUint32(&o.VCTR30.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR30_B964() uint32 {
	return (volatile.LoadUint32(&o.VCTR30.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR30_B965(value uint32) {
	volatile.StoreUint32(&o.VCTR30.Reg, volatile.LoadUint32(&o.VCTR30.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR30_B965() uint32 {
	return (volatile.LoadUint32(&o.VCTR30.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR30_B966(value uint32) {
	volatile.StoreUint32(&o.VCTR30.Reg, volatile.LoadUint32(&o.VCTR30.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR30_B966() uint32 {
	return (volatile.LoadUint32(&o.VCTR30.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR30_B967(value uint32) {
	volatile.StoreUint32(&o.VCTR30.Reg, volatile.LoadUint32(&o.VCTR30.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR30_B967() uint32 {
	return (volatile.LoadUint32(&o.VCTR30.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR30_B968(value uint32) {
	volatile.StoreUint32(&o.VCTR30.Reg, volatile.LoadUint32(&o.VCTR30.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR30_B968() uint32 {
	return (volatile.LoadUint32(&o.VCTR30.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR30_B969(value uint32) {
	volatile.StoreUint32(&o.VCTR30.Reg, volatile.LoadUint32(&o.VCTR30.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR30_B969() uint32 {
	return (volatile.LoadUint32(&o.VCTR30.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR30_B970(value uint32) {
	volatile.StoreUint32(&o.VCTR30.Reg, volatile.LoadUint32(&o.VCTR30.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR30_B970() uint32 {
	return (volatile.LoadUint32(&o.VCTR30.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR30_B971(value uint32) {
	volatile.StoreUint32(&o.VCTR30.Reg, volatile.LoadUint32(&o.VCTR30.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR30_B971() uint32 {
	return (volatile.LoadUint32(&o.VCTR30.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR30_B972(value uint32) {
	volatile.StoreUint32(&o.VCTR30.Reg, volatile.LoadUint32(&o.VCTR30.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR30_B972() uint32 {
	return (volatile.LoadUint32(&o.VCTR30.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR30_B973(value uint32) {
	volatile.StoreUint32(&o.VCTR30.Reg, volatile.LoadUint32(&o.VCTR30.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR30_B973() uint32 {
	return (volatile.LoadUint32(&o.VCTR30.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR30_B974(value uint32) {
	volatile.StoreUint32(&o.VCTR30.Reg, volatile.LoadUint32(&o.VCTR30.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR30_B974() uint32 {
	return (volatile.LoadUint32(&o.VCTR30.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR30_B975(value uint32) {
	volatile.StoreUint32(&o.VCTR30.Reg, volatile.LoadUint32(&o.VCTR30.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR30_B975() uint32 {
	return (volatile.LoadUint32(&o.VCTR30.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR30_B976(value uint32) {
	volatile.StoreUint32(&o.VCTR30.Reg, volatile.LoadUint32(&o.VCTR30.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR30_B976() uint32 {
	return (volatile.LoadUint32(&o.VCTR30.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR30_B977(value uint32) {
	volatile.StoreUint32(&o.VCTR30.Reg, volatile.LoadUint32(&o.VCTR30.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR30_B977() uint32 {
	return (volatile.LoadUint32(&o.VCTR30.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR30_B978(value uint32) {
	volatile.StoreUint32(&o.VCTR30.Reg, volatile.LoadUint32(&o.VCTR30.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR30_B978() uint32 {
	return (volatile.LoadUint32(&o.VCTR30.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR30_B979(value uint32) {
	volatile.StoreUint32(&o.VCTR30.Reg, volatile.LoadUint32(&o.VCTR30.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR30_B979() uint32 {
	return (volatile.LoadUint32(&o.VCTR30.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR30_B980(value uint32) {
	volatile.StoreUint32(&o.VCTR30.Reg, volatile.LoadUint32(&o.VCTR30.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR30_B980() uint32 {
	return (volatile.LoadUint32(&o.VCTR30.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR30_B981(value uint32) {
	volatile.StoreUint32(&o.VCTR30.Reg, volatile.LoadUint32(&o.VCTR30.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR30_B981() uint32 {
	return (volatile.LoadUint32(&o.VCTR30.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR30_B982(value uint32) {
	volatile.StoreUint32(&o.VCTR30.Reg, volatile.LoadUint32(&o.VCTR30.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR30_B982() uint32 {
	return (volatile.LoadUint32(&o.VCTR30.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR30_B983(value uint32) {
	volatile.StoreUint32(&o.VCTR30.Reg, volatile.LoadUint32(&o.VCTR30.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR30_B983() uint32 {
	return (volatile.LoadUint32(&o.VCTR30.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR30_B984(value uint32) {
	volatile.StoreUint32(&o.VCTR30.Reg, volatile.LoadUint32(&o.VCTR30.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR30_B984() uint32 {
	return (volatile.LoadUint32(&o.VCTR30.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR30_B985(value uint32) {
	volatile.StoreUint32(&o.VCTR30.Reg, volatile.LoadUint32(&o.VCTR30.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR30_B985() uint32 {
	return (volatile.LoadUint32(&o.VCTR30.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR30_B986(value uint32) {
	volatile.StoreUint32(&o.VCTR30.Reg, volatile.LoadUint32(&o.VCTR30.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR30_B986() uint32 {
	return (volatile.LoadUint32(&o.VCTR30.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR30_B987(value uint32) {
	volatile.StoreUint32(&o.VCTR30.Reg, volatile.LoadUint32(&o.VCTR30.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR30_B987() uint32 {
	return (volatile.LoadUint32(&o.VCTR30.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR30_B988(value uint32) {
	volatile.StoreUint32(&o.VCTR30.Reg, volatile.LoadUint32(&o.VCTR30.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR30_B988() uint32 {
	return (volatile.LoadUint32(&o.VCTR30.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR30_B989(value uint32) {
	volatile.StoreUint32(&o.VCTR30.Reg, volatile.LoadUint32(&o.VCTR30.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR30_B989() uint32 {
	return (volatile.LoadUint32(&o.VCTR30.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR30_B990(value uint32) {
	volatile.StoreUint32(&o.VCTR30.Reg, volatile.LoadUint32(&o.VCTR30.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR30_B990() uint32 {
	return (volatile.LoadUint32(&o.VCTR30.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR30_B991(value uint32) {
	volatile.StoreUint32(&o.VCTR30.Reg, volatile.LoadUint32(&o.VCTR30.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR30_B991() uint32 {
	return (volatile.LoadUint32(&o.VCTR30.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR31: MPCBBx vector register
func (o *GTZC_Type) SetVCTR31_B992(value uint32) {
	volatile.StoreUint32(&o.VCTR31.Reg, volatile.LoadUint32(&o.VCTR31.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR31_B992() uint32 {
	return volatile.LoadUint32(&o.VCTR31.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR31_B993(value uint32) {
	volatile.StoreUint32(&o.VCTR31.Reg, volatile.LoadUint32(&o.VCTR31.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR31_B993() uint32 {
	return (volatile.LoadUint32(&o.VCTR31.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR31_B994(value uint32) {
	volatile.StoreUint32(&o.VCTR31.Reg, volatile.LoadUint32(&o.VCTR31.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR31_B994() uint32 {
	return (volatile.LoadUint32(&o.VCTR31.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR31_B995(value uint32) {
	volatile.StoreUint32(&o.VCTR31.Reg, volatile.LoadUint32(&o.VCTR31.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR31_B995() uint32 {
	return (volatile.LoadUint32(&o.VCTR31.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR31_B996(value uint32) {
	volatile.StoreUint32(&o.VCTR31.Reg, volatile.LoadUint32(&o.VCTR31.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR31_B996() uint32 {
	return (volatile.LoadUint32(&o.VCTR31.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR31_B997(value uint32) {
	volatile.StoreUint32(&o.VCTR31.Reg, volatile.LoadUint32(&o.VCTR31.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR31_B997() uint32 {
	return (volatile.LoadUint32(&o.VCTR31.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR31_B998(value uint32) {
	volatile.StoreUint32(&o.VCTR31.Reg, volatile.LoadUint32(&o.VCTR31.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR31_B998() uint32 {
	return (volatile.LoadUint32(&o.VCTR31.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR31_B999(value uint32) {
	volatile.StoreUint32(&o.VCTR31.Reg, volatile.LoadUint32(&o.VCTR31.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR31_B999() uint32 {
	return (volatile.LoadUint32(&o.VCTR31.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR31_B1000(value uint32) {
	volatile.StoreUint32(&o.VCTR31.Reg, volatile.LoadUint32(&o.VCTR31.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR31_B1000() uint32 {
	return (volatile.LoadUint32(&o.VCTR31.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR31_B1001(value uint32) {
	volatile.StoreUint32(&o.VCTR31.Reg, volatile.LoadUint32(&o.VCTR31.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR31_B1001() uint32 {
	return (volatile.LoadUint32(&o.VCTR31.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR31_B1002(value uint32) {
	volatile.StoreUint32(&o.VCTR31.Reg, volatile.LoadUint32(&o.VCTR31.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR31_B1002() uint32 {
	return (volatile.LoadUint32(&o.VCTR31.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR31_B1003(value uint32) {
	volatile.StoreUint32(&o.VCTR31.Reg, volatile.LoadUint32(&o.VCTR31.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR31_B1003() uint32 {
	return (volatile.LoadUint32(&o.VCTR31.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR31_B1004(value uint32) {
	volatile.StoreUint32(&o.VCTR31.Reg, volatile.LoadUint32(&o.VCTR31.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR31_B1004() uint32 {
	return (volatile.LoadUint32(&o.VCTR31.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR31_B1005(value uint32) {
	volatile.StoreUint32(&o.VCTR31.Reg, volatile.LoadUint32(&o.VCTR31.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR31_B1005() uint32 {
	return (volatile.LoadUint32(&o.VCTR31.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR31_B1006(value uint32) {
	volatile.StoreUint32(&o.VCTR31.Reg, volatile.LoadUint32(&o.VCTR31.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR31_B1006() uint32 {
	return (volatile.LoadUint32(&o.VCTR31.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR31_B1007(value uint32) {
	volatile.StoreUint32(&o.VCTR31.Reg, volatile.LoadUint32(&o.VCTR31.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR31_B1007() uint32 {
	return (volatile.LoadUint32(&o.VCTR31.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR31_B1008(value uint32) {
	volatile.StoreUint32(&o.VCTR31.Reg, volatile.LoadUint32(&o.VCTR31.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR31_B1008() uint32 {
	return (volatile.LoadUint32(&o.VCTR31.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR31_B1009(value uint32) {
	volatile.StoreUint32(&o.VCTR31.Reg, volatile.LoadUint32(&o.VCTR31.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR31_B1009() uint32 {
	return (volatile.LoadUint32(&o.VCTR31.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR31_B1010(value uint32) {
	volatile.StoreUint32(&o.VCTR31.Reg, volatile.LoadUint32(&o.VCTR31.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR31_B1010() uint32 {
	return (volatile.LoadUint32(&o.VCTR31.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR31_B1011(value uint32) {
	volatile.StoreUint32(&o.VCTR31.Reg, volatile.LoadUint32(&o.VCTR31.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR31_B1011() uint32 {
	return (volatile.LoadUint32(&o.VCTR31.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR31_B1012(value uint32) {
	volatile.StoreUint32(&o.VCTR31.Reg, volatile.LoadUint32(&o.VCTR31.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR31_B1012() uint32 {
	return (volatile.LoadUint32(&o.VCTR31.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR31_B1013(value uint32) {
	volatile.StoreUint32(&o.VCTR31.Reg, volatile.LoadUint32(&o.VCTR31.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR31_B1013() uint32 {
	return (volatile.LoadUint32(&o.VCTR31.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR31_B1014(value uint32) {
	volatile.StoreUint32(&o.VCTR31.Reg, volatile.LoadUint32(&o.VCTR31.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR31_B1014() uint32 {
	return (volatile.LoadUint32(&o.VCTR31.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR31_B1015(value uint32) {
	volatile.StoreUint32(&o.VCTR31.Reg, volatile.LoadUint32(&o.VCTR31.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR31_B1015() uint32 {
	return (volatile.LoadUint32(&o.VCTR31.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR31_B1016(value uint32) {
	volatile.StoreUint32(&o.VCTR31.Reg, volatile.LoadUint32(&o.VCTR31.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR31_B1016() uint32 {
	return (volatile.LoadUint32(&o.VCTR31.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR31_B1017(value uint32) {
	volatile.StoreUint32(&o.VCTR31.Reg, volatile.LoadUint32(&o.VCTR31.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR31_B1017() uint32 {
	return (volatile.LoadUint32(&o.VCTR31.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR31_B1018(value uint32) {
	volatile.StoreUint32(&o.VCTR31.Reg, volatile.LoadUint32(&o.VCTR31.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR31_B1018() uint32 {
	return (volatile.LoadUint32(&o.VCTR31.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR31_B1019(value uint32) {
	volatile.StoreUint32(&o.VCTR31.Reg, volatile.LoadUint32(&o.VCTR31.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR31_B1019() uint32 {
	return (volatile.LoadUint32(&o.VCTR31.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR31_B1020(value uint32) {
	volatile.StoreUint32(&o.VCTR31.Reg, volatile.LoadUint32(&o.VCTR31.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR31_B1020() uint32 {
	return (volatile.LoadUint32(&o.VCTR31.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR31_B1021(value uint32) {
	volatile.StoreUint32(&o.VCTR31.Reg, volatile.LoadUint32(&o.VCTR31.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR31_B1021() uint32 {
	return (volatile.LoadUint32(&o.VCTR31.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR31_B1022(value uint32) {
	volatile.StoreUint32(&o.VCTR31.Reg, volatile.LoadUint32(&o.VCTR31.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR31_B1022() uint32 {
	return (volatile.LoadUint32(&o.VCTR31.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR31_B1023(value uint32) {
	volatile.StoreUint32(&o.VCTR31.Reg, volatile.LoadUint32(&o.VCTR31.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR31_B1023() uint32 {
	return (volatile.LoadUint32(&o.VCTR31.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR32: MPCBBx vector register
func (o *GTZC_Type) SetVCTR32_B1024(value uint32) {
	volatile.StoreUint32(&o.VCTR32.Reg, volatile.LoadUint32(&o.VCTR32.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR32_B1024() uint32 {
	return volatile.LoadUint32(&o.VCTR32.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR32_B1025(value uint32) {
	volatile.StoreUint32(&o.VCTR32.Reg, volatile.LoadUint32(&o.VCTR32.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR32_B1025() uint32 {
	return (volatile.LoadUint32(&o.VCTR32.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR32_B1026(value uint32) {
	volatile.StoreUint32(&o.VCTR32.Reg, volatile.LoadUint32(&o.VCTR32.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR32_B1026() uint32 {
	return (volatile.LoadUint32(&o.VCTR32.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR32_B1027(value uint32) {
	volatile.StoreUint32(&o.VCTR32.Reg, volatile.LoadUint32(&o.VCTR32.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR32_B1027() uint32 {
	return (volatile.LoadUint32(&o.VCTR32.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR32_B1028(value uint32) {
	volatile.StoreUint32(&o.VCTR32.Reg, volatile.LoadUint32(&o.VCTR32.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR32_B1028() uint32 {
	return (volatile.LoadUint32(&o.VCTR32.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR32_B1029(value uint32) {
	volatile.StoreUint32(&o.VCTR32.Reg, volatile.LoadUint32(&o.VCTR32.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR32_B1029() uint32 {
	return (volatile.LoadUint32(&o.VCTR32.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR32_B1030(value uint32) {
	volatile.StoreUint32(&o.VCTR32.Reg, volatile.LoadUint32(&o.VCTR32.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR32_B1030() uint32 {
	return (volatile.LoadUint32(&o.VCTR32.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR32_B1031(value uint32) {
	volatile.StoreUint32(&o.VCTR32.Reg, volatile.LoadUint32(&o.VCTR32.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR32_B1031() uint32 {
	return (volatile.LoadUint32(&o.VCTR32.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR32_B1032(value uint32) {
	volatile.StoreUint32(&o.VCTR32.Reg, volatile.LoadUint32(&o.VCTR32.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR32_B1032() uint32 {
	return (volatile.LoadUint32(&o.VCTR32.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR32_B1033(value uint32) {
	volatile.StoreUint32(&o.VCTR32.Reg, volatile.LoadUint32(&o.VCTR32.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR32_B1033() uint32 {
	return (volatile.LoadUint32(&o.VCTR32.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR32_B1034(value uint32) {
	volatile.StoreUint32(&o.VCTR32.Reg, volatile.LoadUint32(&o.VCTR32.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR32_B1034() uint32 {
	return (volatile.LoadUint32(&o.VCTR32.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR32_B1035(value uint32) {
	volatile.StoreUint32(&o.VCTR32.Reg, volatile.LoadUint32(&o.VCTR32.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR32_B1035() uint32 {
	return (volatile.LoadUint32(&o.VCTR32.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR32_B1036(value uint32) {
	volatile.StoreUint32(&o.VCTR32.Reg, volatile.LoadUint32(&o.VCTR32.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR32_B1036() uint32 {
	return (volatile.LoadUint32(&o.VCTR32.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR32_B1037(value uint32) {
	volatile.StoreUint32(&o.VCTR32.Reg, volatile.LoadUint32(&o.VCTR32.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR32_B1037() uint32 {
	return (volatile.LoadUint32(&o.VCTR32.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR32_B1038(value uint32) {
	volatile.StoreUint32(&o.VCTR32.Reg, volatile.LoadUint32(&o.VCTR32.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR32_B1038() uint32 {
	return (volatile.LoadUint32(&o.VCTR32.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR32_B1039(value uint32) {
	volatile.StoreUint32(&o.VCTR32.Reg, volatile.LoadUint32(&o.VCTR32.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR32_B1039() uint32 {
	return (volatile.LoadUint32(&o.VCTR32.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR32_B1040(value uint32) {
	volatile.StoreUint32(&o.VCTR32.Reg, volatile.LoadUint32(&o.VCTR32.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR32_B1040() uint32 {
	return (volatile.LoadUint32(&o.VCTR32.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR32_B1041(value uint32) {
	volatile.StoreUint32(&o.VCTR32.Reg, volatile.LoadUint32(&o.VCTR32.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR32_B1041() uint32 {
	return (volatile.LoadUint32(&o.VCTR32.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR32_B1042(value uint32) {
	volatile.StoreUint32(&o.VCTR32.Reg, volatile.LoadUint32(&o.VCTR32.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR32_B1042() uint32 {
	return (volatile.LoadUint32(&o.VCTR32.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR32_B1043(value uint32) {
	volatile.StoreUint32(&o.VCTR32.Reg, volatile.LoadUint32(&o.VCTR32.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR32_B1043() uint32 {
	return (volatile.LoadUint32(&o.VCTR32.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR32_B1044(value uint32) {
	volatile.StoreUint32(&o.VCTR32.Reg, volatile.LoadUint32(&o.VCTR32.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR32_B1044() uint32 {
	return (volatile.LoadUint32(&o.VCTR32.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR32_B1045(value uint32) {
	volatile.StoreUint32(&o.VCTR32.Reg, volatile.LoadUint32(&o.VCTR32.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR32_B1045() uint32 {
	return (volatile.LoadUint32(&o.VCTR32.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR32_B1046(value uint32) {
	volatile.StoreUint32(&o.VCTR32.Reg, volatile.LoadUint32(&o.VCTR32.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR32_B1046() uint32 {
	return (volatile.LoadUint32(&o.VCTR32.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR32_B1047(value uint32) {
	volatile.StoreUint32(&o.VCTR32.Reg, volatile.LoadUint32(&o.VCTR32.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR32_B1047() uint32 {
	return (volatile.LoadUint32(&o.VCTR32.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR32_B1048(value uint32) {
	volatile.StoreUint32(&o.VCTR32.Reg, volatile.LoadUint32(&o.VCTR32.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR32_B1048() uint32 {
	return (volatile.LoadUint32(&o.VCTR32.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR32_B1049(value uint32) {
	volatile.StoreUint32(&o.VCTR32.Reg, volatile.LoadUint32(&o.VCTR32.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR32_B1049() uint32 {
	return (volatile.LoadUint32(&o.VCTR32.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR32_B1050(value uint32) {
	volatile.StoreUint32(&o.VCTR32.Reg, volatile.LoadUint32(&o.VCTR32.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR32_B1050() uint32 {
	return (volatile.LoadUint32(&o.VCTR32.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR32_B1051(value uint32) {
	volatile.StoreUint32(&o.VCTR32.Reg, volatile.LoadUint32(&o.VCTR32.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR32_B1051() uint32 {
	return (volatile.LoadUint32(&o.VCTR32.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR32_B1052(value uint32) {
	volatile.StoreUint32(&o.VCTR32.Reg, volatile.LoadUint32(&o.VCTR32.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR32_B1052() uint32 {
	return (volatile.LoadUint32(&o.VCTR32.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR32_B1053(value uint32) {
	volatile.StoreUint32(&o.VCTR32.Reg, volatile.LoadUint32(&o.VCTR32.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR32_B1053() uint32 {
	return (volatile.LoadUint32(&o.VCTR32.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR32_B1054(value uint32) {
	volatile.StoreUint32(&o.VCTR32.Reg, volatile.LoadUint32(&o.VCTR32.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR32_B1054() uint32 {
	return (volatile.LoadUint32(&o.VCTR32.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR32_B1055(value uint32) {
	volatile.StoreUint32(&o.VCTR32.Reg, volatile.LoadUint32(&o.VCTR32.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR32_B1055() uint32 {
	return (volatile.LoadUint32(&o.VCTR32.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR33: MPCBBx vector register
func (o *GTZC_Type) SetVCTR33_B1056(value uint32) {
	volatile.StoreUint32(&o.VCTR33.Reg, volatile.LoadUint32(&o.VCTR33.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR33_B1056() uint32 {
	return volatile.LoadUint32(&o.VCTR33.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR33_B1057(value uint32) {
	volatile.StoreUint32(&o.VCTR33.Reg, volatile.LoadUint32(&o.VCTR33.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR33_B1057() uint32 {
	return (volatile.LoadUint32(&o.VCTR33.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR33_B1058(value uint32) {
	volatile.StoreUint32(&o.VCTR33.Reg, volatile.LoadUint32(&o.VCTR33.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR33_B1058() uint32 {
	return (volatile.LoadUint32(&o.VCTR33.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR33_B1059(value uint32) {
	volatile.StoreUint32(&o.VCTR33.Reg, volatile.LoadUint32(&o.VCTR33.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR33_B1059() uint32 {
	return (volatile.LoadUint32(&o.VCTR33.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR33_B1060(value uint32) {
	volatile.StoreUint32(&o.VCTR33.Reg, volatile.LoadUint32(&o.VCTR33.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR33_B1060() uint32 {
	return (volatile.LoadUint32(&o.VCTR33.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR33_B1061(value uint32) {
	volatile.StoreUint32(&o.VCTR33.Reg, volatile.LoadUint32(&o.VCTR33.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR33_B1061() uint32 {
	return (volatile.LoadUint32(&o.VCTR33.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR33_B1062(value uint32) {
	volatile.StoreUint32(&o.VCTR33.Reg, volatile.LoadUint32(&o.VCTR33.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR33_B1062() uint32 {
	return (volatile.LoadUint32(&o.VCTR33.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR33_B1063(value uint32) {
	volatile.StoreUint32(&o.VCTR33.Reg, volatile.LoadUint32(&o.VCTR33.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR33_B1063() uint32 {
	return (volatile.LoadUint32(&o.VCTR33.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR33_B1064(value uint32) {
	volatile.StoreUint32(&o.VCTR33.Reg, volatile.LoadUint32(&o.VCTR33.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR33_B1064() uint32 {
	return (volatile.LoadUint32(&o.VCTR33.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR33_B1065(value uint32) {
	volatile.StoreUint32(&o.VCTR33.Reg, volatile.LoadUint32(&o.VCTR33.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR33_B1065() uint32 {
	return (volatile.LoadUint32(&o.VCTR33.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR33_B1066(value uint32) {
	volatile.StoreUint32(&o.VCTR33.Reg, volatile.LoadUint32(&o.VCTR33.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR33_B1066() uint32 {
	return (volatile.LoadUint32(&o.VCTR33.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR33_B1067(value uint32) {
	volatile.StoreUint32(&o.VCTR33.Reg, volatile.LoadUint32(&o.VCTR33.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR33_B1067() uint32 {
	return (volatile.LoadUint32(&o.VCTR33.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR33_B1068(value uint32) {
	volatile.StoreUint32(&o.VCTR33.Reg, volatile.LoadUint32(&o.VCTR33.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR33_B1068() uint32 {
	return (volatile.LoadUint32(&o.VCTR33.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR33_B1069(value uint32) {
	volatile.StoreUint32(&o.VCTR33.Reg, volatile.LoadUint32(&o.VCTR33.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR33_B1069() uint32 {
	return (volatile.LoadUint32(&o.VCTR33.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR33_B1070(value uint32) {
	volatile.StoreUint32(&o.VCTR33.Reg, volatile.LoadUint32(&o.VCTR33.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR33_B1070() uint32 {
	return (volatile.LoadUint32(&o.VCTR33.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR33_B1071(value uint32) {
	volatile.StoreUint32(&o.VCTR33.Reg, volatile.LoadUint32(&o.VCTR33.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR33_B1071() uint32 {
	return (volatile.LoadUint32(&o.VCTR33.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR33_B1072(value uint32) {
	volatile.StoreUint32(&o.VCTR33.Reg, volatile.LoadUint32(&o.VCTR33.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR33_B1072() uint32 {
	return (volatile.LoadUint32(&o.VCTR33.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR33_B1073(value uint32) {
	volatile.StoreUint32(&o.VCTR33.Reg, volatile.LoadUint32(&o.VCTR33.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR33_B1073() uint32 {
	return (volatile.LoadUint32(&o.VCTR33.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR33_B1074(value uint32) {
	volatile.StoreUint32(&o.VCTR33.Reg, volatile.LoadUint32(&o.VCTR33.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR33_B1074() uint32 {
	return (volatile.LoadUint32(&o.VCTR33.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR33_B1075(value uint32) {
	volatile.StoreUint32(&o.VCTR33.Reg, volatile.LoadUint32(&o.VCTR33.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR33_B1075() uint32 {
	return (volatile.LoadUint32(&o.VCTR33.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR33_B1076(value uint32) {
	volatile.StoreUint32(&o.VCTR33.Reg, volatile.LoadUint32(&o.VCTR33.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR33_B1076() uint32 {
	return (volatile.LoadUint32(&o.VCTR33.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR33_B1077(value uint32) {
	volatile.StoreUint32(&o.VCTR33.Reg, volatile.LoadUint32(&o.VCTR33.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR33_B1077() uint32 {
	return (volatile.LoadUint32(&o.VCTR33.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR33_B1078(value uint32) {
	volatile.StoreUint32(&o.VCTR33.Reg, volatile.LoadUint32(&o.VCTR33.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR33_B1078() uint32 {
	return (volatile.LoadUint32(&o.VCTR33.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR33_B1079(value uint32) {
	volatile.StoreUint32(&o.VCTR33.Reg, volatile.LoadUint32(&o.VCTR33.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR33_B1079() uint32 {
	return (volatile.LoadUint32(&o.VCTR33.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR33_B1080(value uint32) {
	volatile.StoreUint32(&o.VCTR33.Reg, volatile.LoadUint32(&o.VCTR33.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR33_B1080() uint32 {
	return (volatile.LoadUint32(&o.VCTR33.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR33_B1081(value uint32) {
	volatile.StoreUint32(&o.VCTR33.Reg, volatile.LoadUint32(&o.VCTR33.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR33_B1081() uint32 {
	return (volatile.LoadUint32(&o.VCTR33.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR33_B1082(value uint32) {
	volatile.StoreUint32(&o.VCTR33.Reg, volatile.LoadUint32(&o.VCTR33.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR33_B1082() uint32 {
	return (volatile.LoadUint32(&o.VCTR33.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR33_B1083(value uint32) {
	volatile.StoreUint32(&o.VCTR33.Reg, volatile.LoadUint32(&o.VCTR33.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR33_B1083() uint32 {
	return (volatile.LoadUint32(&o.VCTR33.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR33_B1084(value uint32) {
	volatile.StoreUint32(&o.VCTR33.Reg, volatile.LoadUint32(&o.VCTR33.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR33_B1084() uint32 {
	return (volatile.LoadUint32(&o.VCTR33.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR33_B1085(value uint32) {
	volatile.StoreUint32(&o.VCTR33.Reg, volatile.LoadUint32(&o.VCTR33.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR33_B1085() uint32 {
	return (volatile.LoadUint32(&o.VCTR33.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR33_B1086(value uint32) {
	volatile.StoreUint32(&o.VCTR33.Reg, volatile.LoadUint32(&o.VCTR33.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR33_B1086() uint32 {
	return (volatile.LoadUint32(&o.VCTR33.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR33_B1087(value uint32) {
	volatile.StoreUint32(&o.VCTR33.Reg, volatile.LoadUint32(&o.VCTR33.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR33_B1087() uint32 {
	return (volatile.LoadUint32(&o.VCTR33.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR34: MPCBBx vector register
func (o *GTZC_Type) SetVCTR34_B1088(value uint32) {
	volatile.StoreUint32(&o.VCTR34.Reg, volatile.LoadUint32(&o.VCTR34.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR34_B1088() uint32 {
	return volatile.LoadUint32(&o.VCTR34.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR34_B1089(value uint32) {
	volatile.StoreUint32(&o.VCTR34.Reg, volatile.LoadUint32(&o.VCTR34.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR34_B1089() uint32 {
	return (volatile.LoadUint32(&o.VCTR34.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR34_B1090(value uint32) {
	volatile.StoreUint32(&o.VCTR34.Reg, volatile.LoadUint32(&o.VCTR34.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR34_B1090() uint32 {
	return (volatile.LoadUint32(&o.VCTR34.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR34_B1091(value uint32) {
	volatile.StoreUint32(&o.VCTR34.Reg, volatile.LoadUint32(&o.VCTR34.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR34_B1091() uint32 {
	return (volatile.LoadUint32(&o.VCTR34.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR34_B1092(value uint32) {
	volatile.StoreUint32(&o.VCTR34.Reg, volatile.LoadUint32(&o.VCTR34.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR34_B1092() uint32 {
	return (volatile.LoadUint32(&o.VCTR34.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR34_B1093(value uint32) {
	volatile.StoreUint32(&o.VCTR34.Reg, volatile.LoadUint32(&o.VCTR34.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR34_B1093() uint32 {
	return (volatile.LoadUint32(&o.VCTR34.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR34_B1094(value uint32) {
	volatile.StoreUint32(&o.VCTR34.Reg, volatile.LoadUint32(&o.VCTR34.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR34_B1094() uint32 {
	return (volatile.LoadUint32(&o.VCTR34.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR34_B1095(value uint32) {
	volatile.StoreUint32(&o.VCTR34.Reg, volatile.LoadUint32(&o.VCTR34.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR34_B1095() uint32 {
	return (volatile.LoadUint32(&o.VCTR34.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR34_B1096(value uint32) {
	volatile.StoreUint32(&o.VCTR34.Reg, volatile.LoadUint32(&o.VCTR34.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR34_B1096() uint32 {
	return (volatile.LoadUint32(&o.VCTR34.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR34_B1097(value uint32) {
	volatile.StoreUint32(&o.VCTR34.Reg, volatile.LoadUint32(&o.VCTR34.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR34_B1097() uint32 {
	return (volatile.LoadUint32(&o.VCTR34.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR34_B1098(value uint32) {
	volatile.StoreUint32(&o.VCTR34.Reg, volatile.LoadUint32(&o.VCTR34.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR34_B1098() uint32 {
	return (volatile.LoadUint32(&o.VCTR34.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR34_B1099(value uint32) {
	volatile.StoreUint32(&o.VCTR34.Reg, volatile.LoadUint32(&o.VCTR34.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR34_B1099() uint32 {
	return (volatile.LoadUint32(&o.VCTR34.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR34_B1100(value uint32) {
	volatile.StoreUint32(&o.VCTR34.Reg, volatile.LoadUint32(&o.VCTR34.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR34_B1100() uint32 {
	return (volatile.LoadUint32(&o.VCTR34.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR34_B1101(value uint32) {
	volatile.StoreUint32(&o.VCTR34.Reg, volatile.LoadUint32(&o.VCTR34.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR34_B1101() uint32 {
	return (volatile.LoadUint32(&o.VCTR34.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR34_B1102(value uint32) {
	volatile.StoreUint32(&o.VCTR34.Reg, volatile.LoadUint32(&o.VCTR34.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR34_B1102() uint32 {
	return (volatile.LoadUint32(&o.VCTR34.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR34_B1103(value uint32) {
	volatile.StoreUint32(&o.VCTR34.Reg, volatile.LoadUint32(&o.VCTR34.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR34_B1103() uint32 {
	return (volatile.LoadUint32(&o.VCTR34.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR34_B1104(value uint32) {
	volatile.StoreUint32(&o.VCTR34.Reg, volatile.LoadUint32(&o.VCTR34.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR34_B1104() uint32 {
	return (volatile.LoadUint32(&o.VCTR34.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR34_B1105(value uint32) {
	volatile.StoreUint32(&o.VCTR34.Reg, volatile.LoadUint32(&o.VCTR34.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR34_B1105() uint32 {
	return (volatile.LoadUint32(&o.VCTR34.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR34_B1106(value uint32) {
	volatile.StoreUint32(&o.VCTR34.Reg, volatile.LoadUint32(&o.VCTR34.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR34_B1106() uint32 {
	return (volatile.LoadUint32(&o.VCTR34.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR34_B1107(value uint32) {
	volatile.StoreUint32(&o.VCTR34.Reg, volatile.LoadUint32(&o.VCTR34.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR34_B1107() uint32 {
	return (volatile.LoadUint32(&o.VCTR34.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR34_B1108(value uint32) {
	volatile.StoreUint32(&o.VCTR34.Reg, volatile.LoadUint32(&o.VCTR34.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR34_B1108() uint32 {
	return (volatile.LoadUint32(&o.VCTR34.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR34_B1109(value uint32) {
	volatile.StoreUint32(&o.VCTR34.Reg, volatile.LoadUint32(&o.VCTR34.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR34_B1109() uint32 {
	return (volatile.LoadUint32(&o.VCTR34.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR34_B1110(value uint32) {
	volatile.StoreUint32(&o.VCTR34.Reg, volatile.LoadUint32(&o.VCTR34.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR34_B1110() uint32 {
	return (volatile.LoadUint32(&o.VCTR34.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR34_B1111(value uint32) {
	volatile.StoreUint32(&o.VCTR34.Reg, volatile.LoadUint32(&o.VCTR34.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR34_B1111() uint32 {
	return (volatile.LoadUint32(&o.VCTR34.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR34_B1112(value uint32) {
	volatile.StoreUint32(&o.VCTR34.Reg, volatile.LoadUint32(&o.VCTR34.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR34_B1112() uint32 {
	return (volatile.LoadUint32(&o.VCTR34.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR34_B1113(value uint32) {
	volatile.StoreUint32(&o.VCTR34.Reg, volatile.LoadUint32(&o.VCTR34.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR34_B1113() uint32 {
	return (volatile.LoadUint32(&o.VCTR34.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR34_B1114(value uint32) {
	volatile.StoreUint32(&o.VCTR34.Reg, volatile.LoadUint32(&o.VCTR34.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR34_B1114() uint32 {
	return (volatile.LoadUint32(&o.VCTR34.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR34_B1115(value uint32) {
	volatile.StoreUint32(&o.VCTR34.Reg, volatile.LoadUint32(&o.VCTR34.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR34_B1115() uint32 {
	return (volatile.LoadUint32(&o.VCTR34.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR34_B1116(value uint32) {
	volatile.StoreUint32(&o.VCTR34.Reg, volatile.LoadUint32(&o.VCTR34.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR34_B1116() uint32 {
	return (volatile.LoadUint32(&o.VCTR34.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR34_B1117(value uint32) {
	volatile.StoreUint32(&o.VCTR34.Reg, volatile.LoadUint32(&o.VCTR34.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR34_B1117() uint32 {
	return (volatile.LoadUint32(&o.VCTR34.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR34_B1118(value uint32) {
	volatile.StoreUint32(&o.VCTR34.Reg, volatile.LoadUint32(&o.VCTR34.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR34_B1118() uint32 {
	return (volatile.LoadUint32(&o.VCTR34.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR34_B1119(value uint32) {
	volatile.StoreUint32(&o.VCTR34.Reg, volatile.LoadUint32(&o.VCTR34.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR34_B1119() uint32 {
	return (volatile.LoadUint32(&o.VCTR34.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR35: MPCBBx vector register
func (o *GTZC_Type) SetVCTR35_B1120(value uint32) {
	volatile.StoreUint32(&o.VCTR35.Reg, volatile.LoadUint32(&o.VCTR35.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR35_B1120() uint32 {
	return volatile.LoadUint32(&o.VCTR35.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR35_B1121(value uint32) {
	volatile.StoreUint32(&o.VCTR35.Reg, volatile.LoadUint32(&o.VCTR35.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR35_B1121() uint32 {
	return (volatile.LoadUint32(&o.VCTR35.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR35_B1122(value uint32) {
	volatile.StoreUint32(&o.VCTR35.Reg, volatile.LoadUint32(&o.VCTR35.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR35_B1122() uint32 {
	return (volatile.LoadUint32(&o.VCTR35.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR35_B1123(value uint32) {
	volatile.StoreUint32(&o.VCTR35.Reg, volatile.LoadUint32(&o.VCTR35.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR35_B1123() uint32 {
	return (volatile.LoadUint32(&o.VCTR35.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR35_B1124(value uint32) {
	volatile.StoreUint32(&o.VCTR35.Reg, volatile.LoadUint32(&o.VCTR35.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR35_B1124() uint32 {
	return (volatile.LoadUint32(&o.VCTR35.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR35_B1125(value uint32) {
	volatile.StoreUint32(&o.VCTR35.Reg, volatile.LoadUint32(&o.VCTR35.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR35_B1125() uint32 {
	return (volatile.LoadUint32(&o.VCTR35.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR35_B1126(value uint32) {
	volatile.StoreUint32(&o.VCTR35.Reg, volatile.LoadUint32(&o.VCTR35.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR35_B1126() uint32 {
	return (volatile.LoadUint32(&o.VCTR35.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR35_B1127(value uint32) {
	volatile.StoreUint32(&o.VCTR35.Reg, volatile.LoadUint32(&o.VCTR35.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR35_B1127() uint32 {
	return (volatile.LoadUint32(&o.VCTR35.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR35_B1128(value uint32) {
	volatile.StoreUint32(&o.VCTR35.Reg, volatile.LoadUint32(&o.VCTR35.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR35_B1128() uint32 {
	return (volatile.LoadUint32(&o.VCTR35.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR35_B1129(value uint32) {
	volatile.StoreUint32(&o.VCTR35.Reg, volatile.LoadUint32(&o.VCTR35.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR35_B1129() uint32 {
	return (volatile.LoadUint32(&o.VCTR35.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR35_B1130(value uint32) {
	volatile.StoreUint32(&o.VCTR35.Reg, volatile.LoadUint32(&o.VCTR35.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR35_B1130() uint32 {
	return (volatile.LoadUint32(&o.VCTR35.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR35_B1131(value uint32) {
	volatile.StoreUint32(&o.VCTR35.Reg, volatile.LoadUint32(&o.VCTR35.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR35_B1131() uint32 {
	return (volatile.LoadUint32(&o.VCTR35.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR35_B1132(value uint32) {
	volatile.StoreUint32(&o.VCTR35.Reg, volatile.LoadUint32(&o.VCTR35.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR35_B1132() uint32 {
	return (volatile.LoadUint32(&o.VCTR35.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR35_B1133(value uint32) {
	volatile.StoreUint32(&o.VCTR35.Reg, volatile.LoadUint32(&o.VCTR35.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR35_B1133() uint32 {
	return (volatile.LoadUint32(&o.VCTR35.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR35_B1134(value uint32) {
	volatile.StoreUint32(&o.VCTR35.Reg, volatile.LoadUint32(&o.VCTR35.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR35_B1134() uint32 {
	return (volatile.LoadUint32(&o.VCTR35.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR35_B1135(value uint32) {
	volatile.StoreUint32(&o.VCTR35.Reg, volatile.LoadUint32(&o.VCTR35.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR35_B1135() uint32 {
	return (volatile.LoadUint32(&o.VCTR35.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR35_B1136(value uint32) {
	volatile.StoreUint32(&o.VCTR35.Reg, volatile.LoadUint32(&o.VCTR35.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR35_B1136() uint32 {
	return (volatile.LoadUint32(&o.VCTR35.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR35_B1137(value uint32) {
	volatile.StoreUint32(&o.VCTR35.Reg, volatile.LoadUint32(&o.VCTR35.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR35_B1137() uint32 {
	return (volatile.LoadUint32(&o.VCTR35.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR35_B1138(value uint32) {
	volatile.StoreUint32(&o.VCTR35.Reg, volatile.LoadUint32(&o.VCTR35.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR35_B1138() uint32 {
	return (volatile.LoadUint32(&o.VCTR35.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR35_B1139(value uint32) {
	volatile.StoreUint32(&o.VCTR35.Reg, volatile.LoadUint32(&o.VCTR35.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR35_B1139() uint32 {
	return (volatile.LoadUint32(&o.VCTR35.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR35_B1140(value uint32) {
	volatile.StoreUint32(&o.VCTR35.Reg, volatile.LoadUint32(&o.VCTR35.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR35_B1140() uint32 {
	return (volatile.LoadUint32(&o.VCTR35.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR35_B1141(value uint32) {
	volatile.StoreUint32(&o.VCTR35.Reg, volatile.LoadUint32(&o.VCTR35.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR35_B1141() uint32 {
	return (volatile.LoadUint32(&o.VCTR35.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR35_B1142(value uint32) {
	volatile.StoreUint32(&o.VCTR35.Reg, volatile.LoadUint32(&o.VCTR35.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR35_B1142() uint32 {
	return (volatile.LoadUint32(&o.VCTR35.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR35_B1143(value uint32) {
	volatile.StoreUint32(&o.VCTR35.Reg, volatile.LoadUint32(&o.VCTR35.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR35_B1143() uint32 {
	return (volatile.LoadUint32(&o.VCTR35.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR35_B1144(value uint32) {
	volatile.StoreUint32(&o.VCTR35.Reg, volatile.LoadUint32(&o.VCTR35.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR35_B1144() uint32 {
	return (volatile.LoadUint32(&o.VCTR35.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR35_B1145(value uint32) {
	volatile.StoreUint32(&o.VCTR35.Reg, volatile.LoadUint32(&o.VCTR35.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR35_B1145() uint32 {
	return (volatile.LoadUint32(&o.VCTR35.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR35_B1146(value uint32) {
	volatile.StoreUint32(&o.VCTR35.Reg, volatile.LoadUint32(&o.VCTR35.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR35_B1146() uint32 {
	return (volatile.LoadUint32(&o.VCTR35.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR35_B1147(value uint32) {
	volatile.StoreUint32(&o.VCTR35.Reg, volatile.LoadUint32(&o.VCTR35.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR35_B1147() uint32 {
	return (volatile.LoadUint32(&o.VCTR35.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR35_B1148(value uint32) {
	volatile.StoreUint32(&o.VCTR35.Reg, volatile.LoadUint32(&o.VCTR35.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR35_B1148() uint32 {
	return (volatile.LoadUint32(&o.VCTR35.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR35_B1149(value uint32) {
	volatile.StoreUint32(&o.VCTR35.Reg, volatile.LoadUint32(&o.VCTR35.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR35_B1149() uint32 {
	return (volatile.LoadUint32(&o.VCTR35.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR35_B1150(value uint32) {
	volatile.StoreUint32(&o.VCTR35.Reg, volatile.LoadUint32(&o.VCTR35.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR35_B1150() uint32 {
	return (volatile.LoadUint32(&o.VCTR35.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR35_B1151(value uint32) {
	volatile.StoreUint32(&o.VCTR35.Reg, volatile.LoadUint32(&o.VCTR35.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR35_B1151() uint32 {
	return (volatile.LoadUint32(&o.VCTR35.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR36: MPCBBx vector register
func (o *GTZC_Type) SetVCTR36_B1152(value uint32) {
	volatile.StoreUint32(&o.VCTR36.Reg, volatile.LoadUint32(&o.VCTR36.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR36_B1152() uint32 {
	return volatile.LoadUint32(&o.VCTR36.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR36_B1153(value uint32) {
	volatile.StoreUint32(&o.VCTR36.Reg, volatile.LoadUint32(&o.VCTR36.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR36_B1153() uint32 {
	return (volatile.LoadUint32(&o.VCTR36.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR36_B1154(value uint32) {
	volatile.StoreUint32(&o.VCTR36.Reg, volatile.LoadUint32(&o.VCTR36.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR36_B1154() uint32 {
	return (volatile.LoadUint32(&o.VCTR36.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR36_B1155(value uint32) {
	volatile.StoreUint32(&o.VCTR36.Reg, volatile.LoadUint32(&o.VCTR36.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR36_B1155() uint32 {
	return (volatile.LoadUint32(&o.VCTR36.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR36_B1156(value uint32) {
	volatile.StoreUint32(&o.VCTR36.Reg, volatile.LoadUint32(&o.VCTR36.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR36_B1156() uint32 {
	return (volatile.LoadUint32(&o.VCTR36.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR36_B1157(value uint32) {
	volatile.StoreUint32(&o.VCTR36.Reg, volatile.LoadUint32(&o.VCTR36.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR36_B1157() uint32 {
	return (volatile.LoadUint32(&o.VCTR36.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR36_B1158(value uint32) {
	volatile.StoreUint32(&o.VCTR36.Reg, volatile.LoadUint32(&o.VCTR36.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR36_B1158() uint32 {
	return (volatile.LoadUint32(&o.VCTR36.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR36_B1159(value uint32) {
	volatile.StoreUint32(&o.VCTR36.Reg, volatile.LoadUint32(&o.VCTR36.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR36_B1159() uint32 {
	return (volatile.LoadUint32(&o.VCTR36.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR36_B1160(value uint32) {
	volatile.StoreUint32(&o.VCTR36.Reg, volatile.LoadUint32(&o.VCTR36.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR36_B1160() uint32 {
	return (volatile.LoadUint32(&o.VCTR36.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR36_B1161(value uint32) {
	volatile.StoreUint32(&o.VCTR36.Reg, volatile.LoadUint32(&o.VCTR36.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR36_B1161() uint32 {
	return (volatile.LoadUint32(&o.VCTR36.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR36_B1162(value uint32) {
	volatile.StoreUint32(&o.VCTR36.Reg, volatile.LoadUint32(&o.VCTR36.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR36_B1162() uint32 {
	return (volatile.LoadUint32(&o.VCTR36.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR36_B1163(value uint32) {
	volatile.StoreUint32(&o.VCTR36.Reg, volatile.LoadUint32(&o.VCTR36.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR36_B1163() uint32 {
	return (volatile.LoadUint32(&o.VCTR36.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR36_B1164(value uint32) {
	volatile.StoreUint32(&o.VCTR36.Reg, volatile.LoadUint32(&o.VCTR36.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR36_B1164() uint32 {
	return (volatile.LoadUint32(&o.VCTR36.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR36_B1165(value uint32) {
	volatile.StoreUint32(&o.VCTR36.Reg, volatile.LoadUint32(&o.VCTR36.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR36_B1165() uint32 {
	return (volatile.LoadUint32(&o.VCTR36.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR36_B1166(value uint32) {
	volatile.StoreUint32(&o.VCTR36.Reg, volatile.LoadUint32(&o.VCTR36.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR36_B1166() uint32 {
	return (volatile.LoadUint32(&o.VCTR36.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR36_B1167(value uint32) {
	volatile.StoreUint32(&o.VCTR36.Reg, volatile.LoadUint32(&o.VCTR36.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR36_B1167() uint32 {
	return (volatile.LoadUint32(&o.VCTR36.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR36_B1168(value uint32) {
	volatile.StoreUint32(&o.VCTR36.Reg, volatile.LoadUint32(&o.VCTR36.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR36_B1168() uint32 {
	return (volatile.LoadUint32(&o.VCTR36.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR36_B1169(value uint32) {
	volatile.StoreUint32(&o.VCTR36.Reg, volatile.LoadUint32(&o.VCTR36.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR36_B1169() uint32 {
	return (volatile.LoadUint32(&o.VCTR36.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR36_B1170(value uint32) {
	volatile.StoreUint32(&o.VCTR36.Reg, volatile.LoadUint32(&o.VCTR36.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR36_B1170() uint32 {
	return (volatile.LoadUint32(&o.VCTR36.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR36_B1171(value uint32) {
	volatile.StoreUint32(&o.VCTR36.Reg, volatile.LoadUint32(&o.VCTR36.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR36_B1171() uint32 {
	return (volatile.LoadUint32(&o.VCTR36.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR36_B1172(value uint32) {
	volatile.StoreUint32(&o.VCTR36.Reg, volatile.LoadUint32(&o.VCTR36.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR36_B1172() uint32 {
	return (volatile.LoadUint32(&o.VCTR36.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR36_B1173(value uint32) {
	volatile.StoreUint32(&o.VCTR36.Reg, volatile.LoadUint32(&o.VCTR36.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR36_B1173() uint32 {
	return (volatile.LoadUint32(&o.VCTR36.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR36_B1174(value uint32) {
	volatile.StoreUint32(&o.VCTR36.Reg, volatile.LoadUint32(&o.VCTR36.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR36_B1174() uint32 {
	return (volatile.LoadUint32(&o.VCTR36.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR36_B1175(value uint32) {
	volatile.StoreUint32(&o.VCTR36.Reg, volatile.LoadUint32(&o.VCTR36.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR36_B1175() uint32 {
	return (volatile.LoadUint32(&o.VCTR36.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR36_B1176(value uint32) {
	volatile.StoreUint32(&o.VCTR36.Reg, volatile.LoadUint32(&o.VCTR36.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR36_B1176() uint32 {
	return (volatile.LoadUint32(&o.VCTR36.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR36_B1177(value uint32) {
	volatile.StoreUint32(&o.VCTR36.Reg, volatile.LoadUint32(&o.VCTR36.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR36_B1177() uint32 {
	return (volatile.LoadUint32(&o.VCTR36.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR36_B1178(value uint32) {
	volatile.StoreUint32(&o.VCTR36.Reg, volatile.LoadUint32(&o.VCTR36.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR36_B1178() uint32 {
	return (volatile.LoadUint32(&o.VCTR36.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR36_B1179(value uint32) {
	volatile.StoreUint32(&o.VCTR36.Reg, volatile.LoadUint32(&o.VCTR36.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR36_B1179() uint32 {
	return (volatile.LoadUint32(&o.VCTR36.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR36_B1180(value uint32) {
	volatile.StoreUint32(&o.VCTR36.Reg, volatile.LoadUint32(&o.VCTR36.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR36_B1180() uint32 {
	return (volatile.LoadUint32(&o.VCTR36.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR36_B1181(value uint32) {
	volatile.StoreUint32(&o.VCTR36.Reg, volatile.LoadUint32(&o.VCTR36.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR36_B1181() uint32 {
	return (volatile.LoadUint32(&o.VCTR36.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR36_B1182(value uint32) {
	volatile.StoreUint32(&o.VCTR36.Reg, volatile.LoadUint32(&o.VCTR36.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR36_B1182() uint32 {
	return (volatile.LoadUint32(&o.VCTR36.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR36_B1183(value uint32) {
	volatile.StoreUint32(&o.VCTR36.Reg, volatile.LoadUint32(&o.VCTR36.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR36_B1183() uint32 {
	return (volatile.LoadUint32(&o.VCTR36.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR37: MPCBBx vector register
func (o *GTZC_Type) SetVCTR37_B1184(value uint32) {
	volatile.StoreUint32(&o.VCTR37.Reg, volatile.LoadUint32(&o.VCTR37.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR37_B1184() uint32 {
	return volatile.LoadUint32(&o.VCTR37.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR37_B1185(value uint32) {
	volatile.StoreUint32(&o.VCTR37.Reg, volatile.LoadUint32(&o.VCTR37.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR37_B1185() uint32 {
	return (volatile.LoadUint32(&o.VCTR37.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR37_B1186(value uint32) {
	volatile.StoreUint32(&o.VCTR37.Reg, volatile.LoadUint32(&o.VCTR37.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR37_B1186() uint32 {
	return (volatile.LoadUint32(&o.VCTR37.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR37_B1187(value uint32) {
	volatile.StoreUint32(&o.VCTR37.Reg, volatile.LoadUint32(&o.VCTR37.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR37_B1187() uint32 {
	return (volatile.LoadUint32(&o.VCTR37.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR37_B1188(value uint32) {
	volatile.StoreUint32(&o.VCTR37.Reg, volatile.LoadUint32(&o.VCTR37.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR37_B1188() uint32 {
	return (volatile.LoadUint32(&o.VCTR37.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR37_B1189(value uint32) {
	volatile.StoreUint32(&o.VCTR37.Reg, volatile.LoadUint32(&o.VCTR37.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR37_B1189() uint32 {
	return (volatile.LoadUint32(&o.VCTR37.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR37_B1190(value uint32) {
	volatile.StoreUint32(&o.VCTR37.Reg, volatile.LoadUint32(&o.VCTR37.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR37_B1190() uint32 {
	return (volatile.LoadUint32(&o.VCTR37.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR37_B1191(value uint32) {
	volatile.StoreUint32(&o.VCTR37.Reg, volatile.LoadUint32(&o.VCTR37.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR37_B1191() uint32 {
	return (volatile.LoadUint32(&o.VCTR37.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR37_B1192(value uint32) {
	volatile.StoreUint32(&o.VCTR37.Reg, volatile.LoadUint32(&o.VCTR37.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR37_B1192() uint32 {
	return (volatile.LoadUint32(&o.VCTR37.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR37_B1193(value uint32) {
	volatile.StoreUint32(&o.VCTR37.Reg, volatile.LoadUint32(&o.VCTR37.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR37_B1193() uint32 {
	return (volatile.LoadUint32(&o.VCTR37.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR37_B1194(value uint32) {
	volatile.StoreUint32(&o.VCTR37.Reg, volatile.LoadUint32(&o.VCTR37.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR37_B1194() uint32 {
	return (volatile.LoadUint32(&o.VCTR37.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR37_B1195(value uint32) {
	volatile.StoreUint32(&o.VCTR37.Reg, volatile.LoadUint32(&o.VCTR37.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR37_B1195() uint32 {
	return (volatile.LoadUint32(&o.VCTR37.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR37_B1196(value uint32) {
	volatile.StoreUint32(&o.VCTR37.Reg, volatile.LoadUint32(&o.VCTR37.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR37_B1196() uint32 {
	return (volatile.LoadUint32(&o.VCTR37.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR37_B1197(value uint32) {
	volatile.StoreUint32(&o.VCTR37.Reg, volatile.LoadUint32(&o.VCTR37.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR37_B1197() uint32 {
	return (volatile.LoadUint32(&o.VCTR37.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR37_B1198(value uint32) {
	volatile.StoreUint32(&o.VCTR37.Reg, volatile.LoadUint32(&o.VCTR37.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR37_B1198() uint32 {
	return (volatile.LoadUint32(&o.VCTR37.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR37_B1199(value uint32) {
	volatile.StoreUint32(&o.VCTR37.Reg, volatile.LoadUint32(&o.VCTR37.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR37_B1199() uint32 {
	return (volatile.LoadUint32(&o.VCTR37.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR37_B1200(value uint32) {
	volatile.StoreUint32(&o.VCTR37.Reg, volatile.LoadUint32(&o.VCTR37.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR37_B1200() uint32 {
	return (volatile.LoadUint32(&o.VCTR37.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR37_B1201(value uint32) {
	volatile.StoreUint32(&o.VCTR37.Reg, volatile.LoadUint32(&o.VCTR37.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR37_B1201() uint32 {
	return (volatile.LoadUint32(&o.VCTR37.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR37_B1202(value uint32) {
	volatile.StoreUint32(&o.VCTR37.Reg, volatile.LoadUint32(&o.VCTR37.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR37_B1202() uint32 {
	return (volatile.LoadUint32(&o.VCTR37.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR37_B1203(value uint32) {
	volatile.StoreUint32(&o.VCTR37.Reg, volatile.LoadUint32(&o.VCTR37.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR37_B1203() uint32 {
	return (volatile.LoadUint32(&o.VCTR37.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR37_B1204(value uint32) {
	volatile.StoreUint32(&o.VCTR37.Reg, volatile.LoadUint32(&o.VCTR37.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR37_B1204() uint32 {
	return (volatile.LoadUint32(&o.VCTR37.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR37_B1205(value uint32) {
	volatile.StoreUint32(&o.VCTR37.Reg, volatile.LoadUint32(&o.VCTR37.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR37_B1205() uint32 {
	return (volatile.LoadUint32(&o.VCTR37.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR37_B1206(value uint32) {
	volatile.StoreUint32(&o.VCTR37.Reg, volatile.LoadUint32(&o.VCTR37.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR37_B1206() uint32 {
	return (volatile.LoadUint32(&o.VCTR37.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR37_B1207(value uint32) {
	volatile.StoreUint32(&o.VCTR37.Reg, volatile.LoadUint32(&o.VCTR37.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR37_B1207() uint32 {
	return (volatile.LoadUint32(&o.VCTR37.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR37_B1208(value uint32) {
	volatile.StoreUint32(&o.VCTR37.Reg, volatile.LoadUint32(&o.VCTR37.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR37_B1208() uint32 {
	return (volatile.LoadUint32(&o.VCTR37.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR37_B1209(value uint32) {
	volatile.StoreUint32(&o.VCTR37.Reg, volatile.LoadUint32(&o.VCTR37.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR37_B1209() uint32 {
	return (volatile.LoadUint32(&o.VCTR37.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR37_B1210(value uint32) {
	volatile.StoreUint32(&o.VCTR37.Reg, volatile.LoadUint32(&o.VCTR37.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR37_B1210() uint32 {
	return (volatile.LoadUint32(&o.VCTR37.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR37_B1211(value uint32) {
	volatile.StoreUint32(&o.VCTR37.Reg, volatile.LoadUint32(&o.VCTR37.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR37_B1211() uint32 {
	return (volatile.LoadUint32(&o.VCTR37.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR37_B1212(value uint32) {
	volatile.StoreUint32(&o.VCTR37.Reg, volatile.LoadUint32(&o.VCTR37.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR37_B1212() uint32 {
	return (volatile.LoadUint32(&o.VCTR37.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR37_B1213(value uint32) {
	volatile.StoreUint32(&o.VCTR37.Reg, volatile.LoadUint32(&o.VCTR37.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR37_B1213() uint32 {
	return (volatile.LoadUint32(&o.VCTR37.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR37_B1214(value uint32) {
	volatile.StoreUint32(&o.VCTR37.Reg, volatile.LoadUint32(&o.VCTR37.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR37_B1214() uint32 {
	return (volatile.LoadUint32(&o.VCTR37.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR37_B1215(value uint32) {
	volatile.StoreUint32(&o.VCTR37.Reg, volatile.LoadUint32(&o.VCTR37.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR37_B1215() uint32 {
	return (volatile.LoadUint32(&o.VCTR37.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR38: MPCBBx vector register
func (o *GTZC_Type) SetVCTR38_B1216(value uint32) {
	volatile.StoreUint32(&o.VCTR38.Reg, volatile.LoadUint32(&o.VCTR38.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR38_B1216() uint32 {
	return volatile.LoadUint32(&o.VCTR38.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR38_B1217(value uint32) {
	volatile.StoreUint32(&o.VCTR38.Reg, volatile.LoadUint32(&o.VCTR38.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR38_B1217() uint32 {
	return (volatile.LoadUint32(&o.VCTR38.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR38_B1218(value uint32) {
	volatile.StoreUint32(&o.VCTR38.Reg, volatile.LoadUint32(&o.VCTR38.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR38_B1218() uint32 {
	return (volatile.LoadUint32(&o.VCTR38.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR38_B1219(value uint32) {
	volatile.StoreUint32(&o.VCTR38.Reg, volatile.LoadUint32(&o.VCTR38.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR38_B1219() uint32 {
	return (volatile.LoadUint32(&o.VCTR38.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR38_B1220(value uint32) {
	volatile.StoreUint32(&o.VCTR38.Reg, volatile.LoadUint32(&o.VCTR38.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR38_B1220() uint32 {
	return (volatile.LoadUint32(&o.VCTR38.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR38_B1221(value uint32) {
	volatile.StoreUint32(&o.VCTR38.Reg, volatile.LoadUint32(&o.VCTR38.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR38_B1221() uint32 {
	return (volatile.LoadUint32(&o.VCTR38.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR38_B1222(value uint32) {
	volatile.StoreUint32(&o.VCTR38.Reg, volatile.LoadUint32(&o.VCTR38.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR38_B1222() uint32 {
	return (volatile.LoadUint32(&o.VCTR38.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR38_B1223(value uint32) {
	volatile.StoreUint32(&o.VCTR38.Reg, volatile.LoadUint32(&o.VCTR38.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR38_B1223() uint32 {
	return (volatile.LoadUint32(&o.VCTR38.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR38_B1224(value uint32) {
	volatile.StoreUint32(&o.VCTR38.Reg, volatile.LoadUint32(&o.VCTR38.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR38_B1224() uint32 {
	return (volatile.LoadUint32(&o.VCTR38.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR38_B1225(value uint32) {
	volatile.StoreUint32(&o.VCTR38.Reg, volatile.LoadUint32(&o.VCTR38.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR38_B1225() uint32 {
	return (volatile.LoadUint32(&o.VCTR38.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR38_B1226(value uint32) {
	volatile.StoreUint32(&o.VCTR38.Reg, volatile.LoadUint32(&o.VCTR38.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR38_B1226() uint32 {
	return (volatile.LoadUint32(&o.VCTR38.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR38_B1227(value uint32) {
	volatile.StoreUint32(&o.VCTR38.Reg, volatile.LoadUint32(&o.VCTR38.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR38_B1227() uint32 {
	return (volatile.LoadUint32(&o.VCTR38.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR38_B1228(value uint32) {
	volatile.StoreUint32(&o.VCTR38.Reg, volatile.LoadUint32(&o.VCTR38.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR38_B1228() uint32 {
	return (volatile.LoadUint32(&o.VCTR38.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR38_B1229(value uint32) {
	volatile.StoreUint32(&o.VCTR38.Reg, volatile.LoadUint32(&o.VCTR38.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR38_B1229() uint32 {
	return (volatile.LoadUint32(&o.VCTR38.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR38_B1230(value uint32) {
	volatile.StoreUint32(&o.VCTR38.Reg, volatile.LoadUint32(&o.VCTR38.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR38_B1230() uint32 {
	return (volatile.LoadUint32(&o.VCTR38.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR38_B1231(value uint32) {
	volatile.StoreUint32(&o.VCTR38.Reg, volatile.LoadUint32(&o.VCTR38.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR38_B1231() uint32 {
	return (volatile.LoadUint32(&o.VCTR38.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR38_B1232(value uint32) {
	volatile.StoreUint32(&o.VCTR38.Reg, volatile.LoadUint32(&o.VCTR38.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR38_B1232() uint32 {
	return (volatile.LoadUint32(&o.VCTR38.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR38_B1233(value uint32) {
	volatile.StoreUint32(&o.VCTR38.Reg, volatile.LoadUint32(&o.VCTR38.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR38_B1233() uint32 {
	return (volatile.LoadUint32(&o.VCTR38.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR38_B1234(value uint32) {
	volatile.StoreUint32(&o.VCTR38.Reg, volatile.LoadUint32(&o.VCTR38.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR38_B1234() uint32 {
	return (volatile.LoadUint32(&o.VCTR38.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR38_B1235(value uint32) {
	volatile.StoreUint32(&o.VCTR38.Reg, volatile.LoadUint32(&o.VCTR38.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR38_B1235() uint32 {
	return (volatile.LoadUint32(&o.VCTR38.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR38_B1236(value uint32) {
	volatile.StoreUint32(&o.VCTR38.Reg, volatile.LoadUint32(&o.VCTR38.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR38_B1236() uint32 {
	return (volatile.LoadUint32(&o.VCTR38.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR38_B1237(value uint32) {
	volatile.StoreUint32(&o.VCTR38.Reg, volatile.LoadUint32(&o.VCTR38.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR38_B1237() uint32 {
	return (volatile.LoadUint32(&o.VCTR38.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR38_B1238(value uint32) {
	volatile.StoreUint32(&o.VCTR38.Reg, volatile.LoadUint32(&o.VCTR38.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR38_B1238() uint32 {
	return (volatile.LoadUint32(&o.VCTR38.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR38_B1239(value uint32) {
	volatile.StoreUint32(&o.VCTR38.Reg, volatile.LoadUint32(&o.VCTR38.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR38_B1239() uint32 {
	return (volatile.LoadUint32(&o.VCTR38.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR38_B1240(value uint32) {
	volatile.StoreUint32(&o.VCTR38.Reg, volatile.LoadUint32(&o.VCTR38.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR38_B1240() uint32 {
	return (volatile.LoadUint32(&o.VCTR38.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR38_B1241(value uint32) {
	volatile.StoreUint32(&o.VCTR38.Reg, volatile.LoadUint32(&o.VCTR38.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR38_B1241() uint32 {
	return (volatile.LoadUint32(&o.VCTR38.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR38_B1242(value uint32) {
	volatile.StoreUint32(&o.VCTR38.Reg, volatile.LoadUint32(&o.VCTR38.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR38_B1242() uint32 {
	return (volatile.LoadUint32(&o.VCTR38.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR38_B1243(value uint32) {
	volatile.StoreUint32(&o.VCTR38.Reg, volatile.LoadUint32(&o.VCTR38.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR38_B1243() uint32 {
	return (volatile.LoadUint32(&o.VCTR38.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR38_B1244(value uint32) {
	volatile.StoreUint32(&o.VCTR38.Reg, volatile.LoadUint32(&o.VCTR38.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR38_B1244() uint32 {
	return (volatile.LoadUint32(&o.VCTR38.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR38_B1245(value uint32) {
	volatile.StoreUint32(&o.VCTR38.Reg, volatile.LoadUint32(&o.VCTR38.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR38_B1245() uint32 {
	return (volatile.LoadUint32(&o.VCTR38.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR38_B1246(value uint32) {
	volatile.StoreUint32(&o.VCTR38.Reg, volatile.LoadUint32(&o.VCTR38.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR38_B1246() uint32 {
	return (volatile.LoadUint32(&o.VCTR38.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR38_B1247(value uint32) {
	volatile.StoreUint32(&o.VCTR38.Reg, volatile.LoadUint32(&o.VCTR38.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR38_B1247() uint32 {
	return (volatile.LoadUint32(&o.VCTR38.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR39: MPCBBx vector register
func (o *GTZC_Type) SetVCTR39_B1248(value uint32) {
	volatile.StoreUint32(&o.VCTR39.Reg, volatile.LoadUint32(&o.VCTR39.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR39_B1248() uint32 {
	return volatile.LoadUint32(&o.VCTR39.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR39_B1249(value uint32) {
	volatile.StoreUint32(&o.VCTR39.Reg, volatile.LoadUint32(&o.VCTR39.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR39_B1249() uint32 {
	return (volatile.LoadUint32(&o.VCTR39.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR39_B1250(value uint32) {
	volatile.StoreUint32(&o.VCTR39.Reg, volatile.LoadUint32(&o.VCTR39.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR39_B1250() uint32 {
	return (volatile.LoadUint32(&o.VCTR39.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR39_B1251(value uint32) {
	volatile.StoreUint32(&o.VCTR39.Reg, volatile.LoadUint32(&o.VCTR39.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR39_B1251() uint32 {
	return (volatile.LoadUint32(&o.VCTR39.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR39_B1252(value uint32) {
	volatile.StoreUint32(&o.VCTR39.Reg, volatile.LoadUint32(&o.VCTR39.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR39_B1252() uint32 {
	return (volatile.LoadUint32(&o.VCTR39.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR39_B1253(value uint32) {
	volatile.StoreUint32(&o.VCTR39.Reg, volatile.LoadUint32(&o.VCTR39.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR39_B1253() uint32 {
	return (volatile.LoadUint32(&o.VCTR39.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR39_B1254(value uint32) {
	volatile.StoreUint32(&o.VCTR39.Reg, volatile.LoadUint32(&o.VCTR39.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR39_B1254() uint32 {
	return (volatile.LoadUint32(&o.VCTR39.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR39_B1255(value uint32) {
	volatile.StoreUint32(&o.VCTR39.Reg, volatile.LoadUint32(&o.VCTR39.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR39_B1255() uint32 {
	return (volatile.LoadUint32(&o.VCTR39.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR39_B1256(value uint32) {
	volatile.StoreUint32(&o.VCTR39.Reg, volatile.LoadUint32(&o.VCTR39.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR39_B1256() uint32 {
	return (volatile.LoadUint32(&o.VCTR39.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR39_B1257(value uint32) {
	volatile.StoreUint32(&o.VCTR39.Reg, volatile.LoadUint32(&o.VCTR39.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR39_B1257() uint32 {
	return (volatile.LoadUint32(&o.VCTR39.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR39_B1258(value uint32) {
	volatile.StoreUint32(&o.VCTR39.Reg, volatile.LoadUint32(&o.VCTR39.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR39_B1258() uint32 {
	return (volatile.LoadUint32(&o.VCTR39.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR39_B1259(value uint32) {
	volatile.StoreUint32(&o.VCTR39.Reg, volatile.LoadUint32(&o.VCTR39.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR39_B1259() uint32 {
	return (volatile.LoadUint32(&o.VCTR39.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR39_B1260(value uint32) {
	volatile.StoreUint32(&o.VCTR39.Reg, volatile.LoadUint32(&o.VCTR39.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR39_B1260() uint32 {
	return (volatile.LoadUint32(&o.VCTR39.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR39_B1261(value uint32) {
	volatile.StoreUint32(&o.VCTR39.Reg, volatile.LoadUint32(&o.VCTR39.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR39_B1261() uint32 {
	return (volatile.LoadUint32(&o.VCTR39.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR39_B1262(value uint32) {
	volatile.StoreUint32(&o.VCTR39.Reg, volatile.LoadUint32(&o.VCTR39.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR39_B1262() uint32 {
	return (volatile.LoadUint32(&o.VCTR39.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR39_B1263(value uint32) {
	volatile.StoreUint32(&o.VCTR39.Reg, volatile.LoadUint32(&o.VCTR39.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR39_B1263() uint32 {
	return (volatile.LoadUint32(&o.VCTR39.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR39_B1264(value uint32) {
	volatile.StoreUint32(&o.VCTR39.Reg, volatile.LoadUint32(&o.VCTR39.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR39_B1264() uint32 {
	return (volatile.LoadUint32(&o.VCTR39.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR39_B1265(value uint32) {
	volatile.StoreUint32(&o.VCTR39.Reg, volatile.LoadUint32(&o.VCTR39.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR39_B1265() uint32 {
	return (volatile.LoadUint32(&o.VCTR39.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR39_B1266(value uint32) {
	volatile.StoreUint32(&o.VCTR39.Reg, volatile.LoadUint32(&o.VCTR39.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR39_B1266() uint32 {
	return (volatile.LoadUint32(&o.VCTR39.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR39_B1267(value uint32) {
	volatile.StoreUint32(&o.VCTR39.Reg, volatile.LoadUint32(&o.VCTR39.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR39_B1267() uint32 {
	return (volatile.LoadUint32(&o.VCTR39.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR39_B1268(value uint32) {
	volatile.StoreUint32(&o.VCTR39.Reg, volatile.LoadUint32(&o.VCTR39.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR39_B1268() uint32 {
	return (volatile.LoadUint32(&o.VCTR39.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR39_B1269(value uint32) {
	volatile.StoreUint32(&o.VCTR39.Reg, volatile.LoadUint32(&o.VCTR39.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR39_B1269() uint32 {
	return (volatile.LoadUint32(&o.VCTR39.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR39_B1270(value uint32) {
	volatile.StoreUint32(&o.VCTR39.Reg, volatile.LoadUint32(&o.VCTR39.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR39_B1270() uint32 {
	return (volatile.LoadUint32(&o.VCTR39.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR39_B1271(value uint32) {
	volatile.StoreUint32(&o.VCTR39.Reg, volatile.LoadUint32(&o.VCTR39.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR39_B1271() uint32 {
	return (volatile.LoadUint32(&o.VCTR39.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR39_B1272(value uint32) {
	volatile.StoreUint32(&o.VCTR39.Reg, volatile.LoadUint32(&o.VCTR39.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR39_B1272() uint32 {
	return (volatile.LoadUint32(&o.VCTR39.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR39_B1273(value uint32) {
	volatile.StoreUint32(&o.VCTR39.Reg, volatile.LoadUint32(&o.VCTR39.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR39_B1273() uint32 {
	return (volatile.LoadUint32(&o.VCTR39.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR39_B1274(value uint32) {
	volatile.StoreUint32(&o.VCTR39.Reg, volatile.LoadUint32(&o.VCTR39.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR39_B1274() uint32 {
	return (volatile.LoadUint32(&o.VCTR39.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR39_B1275(value uint32) {
	volatile.StoreUint32(&o.VCTR39.Reg, volatile.LoadUint32(&o.VCTR39.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR39_B1275() uint32 {
	return (volatile.LoadUint32(&o.VCTR39.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR39_B1276(value uint32) {
	volatile.StoreUint32(&o.VCTR39.Reg, volatile.LoadUint32(&o.VCTR39.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR39_B1276() uint32 {
	return (volatile.LoadUint32(&o.VCTR39.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR39_B1277(value uint32) {
	volatile.StoreUint32(&o.VCTR39.Reg, volatile.LoadUint32(&o.VCTR39.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR39_B1277() uint32 {
	return (volatile.LoadUint32(&o.VCTR39.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR39_B1278(value uint32) {
	volatile.StoreUint32(&o.VCTR39.Reg, volatile.LoadUint32(&o.VCTR39.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR39_B1278() uint32 {
	return (volatile.LoadUint32(&o.VCTR39.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR39_B1279(value uint32) {
	volatile.StoreUint32(&o.VCTR39.Reg, volatile.LoadUint32(&o.VCTR39.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR39_B1279() uint32 {
	return (volatile.LoadUint32(&o.VCTR39.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR40: MPCBBx vector register
func (o *GTZC_Type) SetVCTR40_B1280(value uint32) {
	volatile.StoreUint32(&o.VCTR40.Reg, volatile.LoadUint32(&o.VCTR40.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR40_B1280() uint32 {
	return volatile.LoadUint32(&o.VCTR40.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR40_B1281(value uint32) {
	volatile.StoreUint32(&o.VCTR40.Reg, volatile.LoadUint32(&o.VCTR40.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR40_B1281() uint32 {
	return (volatile.LoadUint32(&o.VCTR40.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR40_B1282(value uint32) {
	volatile.StoreUint32(&o.VCTR40.Reg, volatile.LoadUint32(&o.VCTR40.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR40_B1282() uint32 {
	return (volatile.LoadUint32(&o.VCTR40.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR40_B1283(value uint32) {
	volatile.StoreUint32(&o.VCTR40.Reg, volatile.LoadUint32(&o.VCTR40.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR40_B1283() uint32 {
	return (volatile.LoadUint32(&o.VCTR40.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR40_B1284(value uint32) {
	volatile.StoreUint32(&o.VCTR40.Reg, volatile.LoadUint32(&o.VCTR40.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR40_B1284() uint32 {
	return (volatile.LoadUint32(&o.VCTR40.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR40_B1285(value uint32) {
	volatile.StoreUint32(&o.VCTR40.Reg, volatile.LoadUint32(&o.VCTR40.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR40_B1285() uint32 {
	return (volatile.LoadUint32(&o.VCTR40.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR40_B1286(value uint32) {
	volatile.StoreUint32(&o.VCTR40.Reg, volatile.LoadUint32(&o.VCTR40.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR40_B1286() uint32 {
	return (volatile.LoadUint32(&o.VCTR40.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR40_B1287(value uint32) {
	volatile.StoreUint32(&o.VCTR40.Reg, volatile.LoadUint32(&o.VCTR40.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR40_B1287() uint32 {
	return (volatile.LoadUint32(&o.VCTR40.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR40_B1288(value uint32) {
	volatile.StoreUint32(&o.VCTR40.Reg, volatile.LoadUint32(&o.VCTR40.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR40_B1288() uint32 {
	return (volatile.LoadUint32(&o.VCTR40.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR40_B1289(value uint32) {
	volatile.StoreUint32(&o.VCTR40.Reg, volatile.LoadUint32(&o.VCTR40.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR40_B1289() uint32 {
	return (volatile.LoadUint32(&o.VCTR40.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR40_B1290(value uint32) {
	volatile.StoreUint32(&o.VCTR40.Reg, volatile.LoadUint32(&o.VCTR40.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR40_B1290() uint32 {
	return (volatile.LoadUint32(&o.VCTR40.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR40_B1291(value uint32) {
	volatile.StoreUint32(&o.VCTR40.Reg, volatile.LoadUint32(&o.VCTR40.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR40_B1291() uint32 {
	return (volatile.LoadUint32(&o.VCTR40.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR40_B1292(value uint32) {
	volatile.StoreUint32(&o.VCTR40.Reg, volatile.LoadUint32(&o.VCTR40.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR40_B1292() uint32 {
	return (volatile.LoadUint32(&o.VCTR40.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR40_B1293(value uint32) {
	volatile.StoreUint32(&o.VCTR40.Reg, volatile.LoadUint32(&o.VCTR40.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR40_B1293() uint32 {
	return (volatile.LoadUint32(&o.VCTR40.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR40_B1294(value uint32) {
	volatile.StoreUint32(&o.VCTR40.Reg, volatile.LoadUint32(&o.VCTR40.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR40_B1294() uint32 {
	return (volatile.LoadUint32(&o.VCTR40.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR40_B1295(value uint32) {
	volatile.StoreUint32(&o.VCTR40.Reg, volatile.LoadUint32(&o.VCTR40.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR40_B1295() uint32 {
	return (volatile.LoadUint32(&o.VCTR40.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR40_B1296(value uint32) {
	volatile.StoreUint32(&o.VCTR40.Reg, volatile.LoadUint32(&o.VCTR40.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR40_B1296() uint32 {
	return (volatile.LoadUint32(&o.VCTR40.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR40_B1297(value uint32) {
	volatile.StoreUint32(&o.VCTR40.Reg, volatile.LoadUint32(&o.VCTR40.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR40_B1297() uint32 {
	return (volatile.LoadUint32(&o.VCTR40.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR40_B1298(value uint32) {
	volatile.StoreUint32(&o.VCTR40.Reg, volatile.LoadUint32(&o.VCTR40.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR40_B1298() uint32 {
	return (volatile.LoadUint32(&o.VCTR40.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR40_B1299(value uint32) {
	volatile.StoreUint32(&o.VCTR40.Reg, volatile.LoadUint32(&o.VCTR40.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR40_B1299() uint32 {
	return (volatile.LoadUint32(&o.VCTR40.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR40_B1300(value uint32) {
	volatile.StoreUint32(&o.VCTR40.Reg, volatile.LoadUint32(&o.VCTR40.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR40_B1300() uint32 {
	return (volatile.LoadUint32(&o.VCTR40.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR40_B1301(value uint32) {
	volatile.StoreUint32(&o.VCTR40.Reg, volatile.LoadUint32(&o.VCTR40.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR40_B1301() uint32 {
	return (volatile.LoadUint32(&o.VCTR40.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR40_B1302(value uint32) {
	volatile.StoreUint32(&o.VCTR40.Reg, volatile.LoadUint32(&o.VCTR40.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR40_B1302() uint32 {
	return (volatile.LoadUint32(&o.VCTR40.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR40_B1303(value uint32) {
	volatile.StoreUint32(&o.VCTR40.Reg, volatile.LoadUint32(&o.VCTR40.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR40_B1303() uint32 {
	return (volatile.LoadUint32(&o.VCTR40.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR40_B1304(value uint32) {
	volatile.StoreUint32(&o.VCTR40.Reg, volatile.LoadUint32(&o.VCTR40.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR40_B1304() uint32 {
	return (volatile.LoadUint32(&o.VCTR40.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR40_B1305(value uint32) {
	volatile.StoreUint32(&o.VCTR40.Reg, volatile.LoadUint32(&o.VCTR40.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR40_B1305() uint32 {
	return (volatile.LoadUint32(&o.VCTR40.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR40_B1306(value uint32) {
	volatile.StoreUint32(&o.VCTR40.Reg, volatile.LoadUint32(&o.VCTR40.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR40_B1306() uint32 {
	return (volatile.LoadUint32(&o.VCTR40.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR40_B1307(value uint32) {
	volatile.StoreUint32(&o.VCTR40.Reg, volatile.LoadUint32(&o.VCTR40.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR40_B1307() uint32 {
	return (volatile.LoadUint32(&o.VCTR40.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR40_B1308(value uint32) {
	volatile.StoreUint32(&o.VCTR40.Reg, volatile.LoadUint32(&o.VCTR40.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR40_B1308() uint32 {
	return (volatile.LoadUint32(&o.VCTR40.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR40_B1309(value uint32) {
	volatile.StoreUint32(&o.VCTR40.Reg, volatile.LoadUint32(&o.VCTR40.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR40_B1309() uint32 {
	return (volatile.LoadUint32(&o.VCTR40.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR40_B1310(value uint32) {
	volatile.StoreUint32(&o.VCTR40.Reg, volatile.LoadUint32(&o.VCTR40.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR40_B1310() uint32 {
	return (volatile.LoadUint32(&o.VCTR40.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR40_B1311(value uint32) {
	volatile.StoreUint32(&o.VCTR40.Reg, volatile.LoadUint32(&o.VCTR40.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR40_B1311() uint32 {
	return (volatile.LoadUint32(&o.VCTR40.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR41: MPCBBx vector register
func (o *GTZC_Type) SetVCTR41_B1312(value uint32) {
	volatile.StoreUint32(&o.VCTR41.Reg, volatile.LoadUint32(&o.VCTR41.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR41_B1312() uint32 {
	return volatile.LoadUint32(&o.VCTR41.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR41_B1313(value uint32) {
	volatile.StoreUint32(&o.VCTR41.Reg, volatile.LoadUint32(&o.VCTR41.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR41_B1313() uint32 {
	return (volatile.LoadUint32(&o.VCTR41.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR41_B1314(value uint32) {
	volatile.StoreUint32(&o.VCTR41.Reg, volatile.LoadUint32(&o.VCTR41.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR41_B1314() uint32 {
	return (volatile.LoadUint32(&o.VCTR41.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR41_B1315(value uint32) {
	volatile.StoreUint32(&o.VCTR41.Reg, volatile.LoadUint32(&o.VCTR41.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR41_B1315() uint32 {
	return (volatile.LoadUint32(&o.VCTR41.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR41_B1316(value uint32) {
	volatile.StoreUint32(&o.VCTR41.Reg, volatile.LoadUint32(&o.VCTR41.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR41_B1316() uint32 {
	return (volatile.LoadUint32(&o.VCTR41.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR41_B1317(value uint32) {
	volatile.StoreUint32(&o.VCTR41.Reg, volatile.LoadUint32(&o.VCTR41.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR41_B1317() uint32 {
	return (volatile.LoadUint32(&o.VCTR41.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR41_B1318(value uint32) {
	volatile.StoreUint32(&o.VCTR41.Reg, volatile.LoadUint32(&o.VCTR41.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR41_B1318() uint32 {
	return (volatile.LoadUint32(&o.VCTR41.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR41_B1319(value uint32) {
	volatile.StoreUint32(&o.VCTR41.Reg, volatile.LoadUint32(&o.VCTR41.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR41_B1319() uint32 {
	return (volatile.LoadUint32(&o.VCTR41.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR41_B1320(value uint32) {
	volatile.StoreUint32(&o.VCTR41.Reg, volatile.LoadUint32(&o.VCTR41.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR41_B1320() uint32 {
	return (volatile.LoadUint32(&o.VCTR41.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR41_B1321(value uint32) {
	volatile.StoreUint32(&o.VCTR41.Reg, volatile.LoadUint32(&o.VCTR41.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR41_B1321() uint32 {
	return (volatile.LoadUint32(&o.VCTR41.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR41_B1322(value uint32) {
	volatile.StoreUint32(&o.VCTR41.Reg, volatile.LoadUint32(&o.VCTR41.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR41_B1322() uint32 {
	return (volatile.LoadUint32(&o.VCTR41.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR41_B1323(value uint32) {
	volatile.StoreUint32(&o.VCTR41.Reg, volatile.LoadUint32(&o.VCTR41.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR41_B1323() uint32 {
	return (volatile.LoadUint32(&o.VCTR41.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR41_B1324(value uint32) {
	volatile.StoreUint32(&o.VCTR41.Reg, volatile.LoadUint32(&o.VCTR41.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR41_B1324() uint32 {
	return (volatile.LoadUint32(&o.VCTR41.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR41_B1325(value uint32) {
	volatile.StoreUint32(&o.VCTR41.Reg, volatile.LoadUint32(&o.VCTR41.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR41_B1325() uint32 {
	return (volatile.LoadUint32(&o.VCTR41.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR41_B1326(value uint32) {
	volatile.StoreUint32(&o.VCTR41.Reg, volatile.LoadUint32(&o.VCTR41.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR41_B1326() uint32 {
	return (volatile.LoadUint32(&o.VCTR41.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR41_B1327(value uint32) {
	volatile.StoreUint32(&o.VCTR41.Reg, volatile.LoadUint32(&o.VCTR41.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR41_B1327() uint32 {
	return (volatile.LoadUint32(&o.VCTR41.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR41_B1328(value uint32) {
	volatile.StoreUint32(&o.VCTR41.Reg, volatile.LoadUint32(&o.VCTR41.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR41_B1328() uint32 {
	return (volatile.LoadUint32(&o.VCTR41.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR41_B1329(value uint32) {
	volatile.StoreUint32(&o.VCTR41.Reg, volatile.LoadUint32(&o.VCTR41.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR41_B1329() uint32 {
	return (volatile.LoadUint32(&o.VCTR41.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR41_B1330(value uint32) {
	volatile.StoreUint32(&o.VCTR41.Reg, volatile.LoadUint32(&o.VCTR41.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR41_B1330() uint32 {
	return (volatile.LoadUint32(&o.VCTR41.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR41_B1331(value uint32) {
	volatile.StoreUint32(&o.VCTR41.Reg, volatile.LoadUint32(&o.VCTR41.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR41_B1331() uint32 {
	return (volatile.LoadUint32(&o.VCTR41.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR41_B1332(value uint32) {
	volatile.StoreUint32(&o.VCTR41.Reg, volatile.LoadUint32(&o.VCTR41.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR41_B1332() uint32 {
	return (volatile.LoadUint32(&o.VCTR41.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR41_B1333(value uint32) {
	volatile.StoreUint32(&o.VCTR41.Reg, volatile.LoadUint32(&o.VCTR41.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR41_B1333() uint32 {
	return (volatile.LoadUint32(&o.VCTR41.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR41_B1334(value uint32) {
	volatile.StoreUint32(&o.VCTR41.Reg, volatile.LoadUint32(&o.VCTR41.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR41_B1334() uint32 {
	return (volatile.LoadUint32(&o.VCTR41.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR41_B1335(value uint32) {
	volatile.StoreUint32(&o.VCTR41.Reg, volatile.LoadUint32(&o.VCTR41.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR41_B1335() uint32 {
	return (volatile.LoadUint32(&o.VCTR41.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR41_B1336(value uint32) {
	volatile.StoreUint32(&o.VCTR41.Reg, volatile.LoadUint32(&o.VCTR41.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR41_B1336() uint32 {
	return (volatile.LoadUint32(&o.VCTR41.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR41_B1337(value uint32) {
	volatile.StoreUint32(&o.VCTR41.Reg, volatile.LoadUint32(&o.VCTR41.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR41_B1337() uint32 {
	return (volatile.LoadUint32(&o.VCTR41.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR41_B1338(value uint32) {
	volatile.StoreUint32(&o.VCTR41.Reg, volatile.LoadUint32(&o.VCTR41.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR41_B1338() uint32 {
	return (volatile.LoadUint32(&o.VCTR41.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR41_B1339(value uint32) {
	volatile.StoreUint32(&o.VCTR41.Reg, volatile.LoadUint32(&o.VCTR41.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR41_B1339() uint32 {
	return (volatile.LoadUint32(&o.VCTR41.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR41_B1340(value uint32) {
	volatile.StoreUint32(&o.VCTR41.Reg, volatile.LoadUint32(&o.VCTR41.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR41_B1340() uint32 {
	return (volatile.LoadUint32(&o.VCTR41.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR41_B1341(value uint32) {
	volatile.StoreUint32(&o.VCTR41.Reg, volatile.LoadUint32(&o.VCTR41.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR41_B1341() uint32 {
	return (volatile.LoadUint32(&o.VCTR41.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR41_B1342(value uint32) {
	volatile.StoreUint32(&o.VCTR41.Reg, volatile.LoadUint32(&o.VCTR41.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR41_B1342() uint32 {
	return (volatile.LoadUint32(&o.VCTR41.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR41_B1343(value uint32) {
	volatile.StoreUint32(&o.VCTR41.Reg, volatile.LoadUint32(&o.VCTR41.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR41_B1343() uint32 {
	return (volatile.LoadUint32(&o.VCTR41.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR42: MPCBBx vector register
func (o *GTZC_Type) SetVCTR42_B1344(value uint32) {
	volatile.StoreUint32(&o.VCTR42.Reg, volatile.LoadUint32(&o.VCTR42.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR42_B1344() uint32 {
	return volatile.LoadUint32(&o.VCTR42.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR42_B1345(value uint32) {
	volatile.StoreUint32(&o.VCTR42.Reg, volatile.LoadUint32(&o.VCTR42.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR42_B1345() uint32 {
	return (volatile.LoadUint32(&o.VCTR42.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR42_B1346(value uint32) {
	volatile.StoreUint32(&o.VCTR42.Reg, volatile.LoadUint32(&o.VCTR42.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR42_B1346() uint32 {
	return (volatile.LoadUint32(&o.VCTR42.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR42_B1347(value uint32) {
	volatile.StoreUint32(&o.VCTR42.Reg, volatile.LoadUint32(&o.VCTR42.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR42_B1347() uint32 {
	return (volatile.LoadUint32(&o.VCTR42.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR42_B1348(value uint32) {
	volatile.StoreUint32(&o.VCTR42.Reg, volatile.LoadUint32(&o.VCTR42.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR42_B1348() uint32 {
	return (volatile.LoadUint32(&o.VCTR42.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR42_B1349(value uint32) {
	volatile.StoreUint32(&o.VCTR42.Reg, volatile.LoadUint32(&o.VCTR42.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR42_B1349() uint32 {
	return (volatile.LoadUint32(&o.VCTR42.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR42_B1350(value uint32) {
	volatile.StoreUint32(&o.VCTR42.Reg, volatile.LoadUint32(&o.VCTR42.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR42_B1350() uint32 {
	return (volatile.LoadUint32(&o.VCTR42.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR42_B1351(value uint32) {
	volatile.StoreUint32(&o.VCTR42.Reg, volatile.LoadUint32(&o.VCTR42.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR42_B1351() uint32 {
	return (volatile.LoadUint32(&o.VCTR42.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR42_B1352(value uint32) {
	volatile.StoreUint32(&o.VCTR42.Reg, volatile.LoadUint32(&o.VCTR42.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR42_B1352() uint32 {
	return (volatile.LoadUint32(&o.VCTR42.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR42_B1353(value uint32) {
	volatile.StoreUint32(&o.VCTR42.Reg, volatile.LoadUint32(&o.VCTR42.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR42_B1353() uint32 {
	return (volatile.LoadUint32(&o.VCTR42.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR42_B1354(value uint32) {
	volatile.StoreUint32(&o.VCTR42.Reg, volatile.LoadUint32(&o.VCTR42.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR42_B1354() uint32 {
	return (volatile.LoadUint32(&o.VCTR42.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR42_B1355(value uint32) {
	volatile.StoreUint32(&o.VCTR42.Reg, volatile.LoadUint32(&o.VCTR42.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR42_B1355() uint32 {
	return (volatile.LoadUint32(&o.VCTR42.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR42_B1356(value uint32) {
	volatile.StoreUint32(&o.VCTR42.Reg, volatile.LoadUint32(&o.VCTR42.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR42_B1356() uint32 {
	return (volatile.LoadUint32(&o.VCTR42.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR42_B1357(value uint32) {
	volatile.StoreUint32(&o.VCTR42.Reg, volatile.LoadUint32(&o.VCTR42.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR42_B1357() uint32 {
	return (volatile.LoadUint32(&o.VCTR42.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR42_B1358(value uint32) {
	volatile.StoreUint32(&o.VCTR42.Reg, volatile.LoadUint32(&o.VCTR42.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR42_B1358() uint32 {
	return (volatile.LoadUint32(&o.VCTR42.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR42_B1359(value uint32) {
	volatile.StoreUint32(&o.VCTR42.Reg, volatile.LoadUint32(&o.VCTR42.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR42_B1359() uint32 {
	return (volatile.LoadUint32(&o.VCTR42.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR42_B1360(value uint32) {
	volatile.StoreUint32(&o.VCTR42.Reg, volatile.LoadUint32(&o.VCTR42.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR42_B1360() uint32 {
	return (volatile.LoadUint32(&o.VCTR42.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR42_B1361(value uint32) {
	volatile.StoreUint32(&o.VCTR42.Reg, volatile.LoadUint32(&o.VCTR42.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR42_B1361() uint32 {
	return (volatile.LoadUint32(&o.VCTR42.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR42_B1362(value uint32) {
	volatile.StoreUint32(&o.VCTR42.Reg, volatile.LoadUint32(&o.VCTR42.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR42_B1362() uint32 {
	return (volatile.LoadUint32(&o.VCTR42.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR42_B1363(value uint32) {
	volatile.StoreUint32(&o.VCTR42.Reg, volatile.LoadUint32(&o.VCTR42.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR42_B1363() uint32 {
	return (volatile.LoadUint32(&o.VCTR42.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR42_B1364(value uint32) {
	volatile.StoreUint32(&o.VCTR42.Reg, volatile.LoadUint32(&o.VCTR42.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR42_B1364() uint32 {
	return (volatile.LoadUint32(&o.VCTR42.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR42_B1365(value uint32) {
	volatile.StoreUint32(&o.VCTR42.Reg, volatile.LoadUint32(&o.VCTR42.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR42_B1365() uint32 {
	return (volatile.LoadUint32(&o.VCTR42.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR42_B1366(value uint32) {
	volatile.StoreUint32(&o.VCTR42.Reg, volatile.LoadUint32(&o.VCTR42.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR42_B1366() uint32 {
	return (volatile.LoadUint32(&o.VCTR42.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR42_B1367(value uint32) {
	volatile.StoreUint32(&o.VCTR42.Reg, volatile.LoadUint32(&o.VCTR42.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR42_B1367() uint32 {
	return (volatile.LoadUint32(&o.VCTR42.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR42_B1368(value uint32) {
	volatile.StoreUint32(&o.VCTR42.Reg, volatile.LoadUint32(&o.VCTR42.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR42_B1368() uint32 {
	return (volatile.LoadUint32(&o.VCTR42.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR42_B1369(value uint32) {
	volatile.StoreUint32(&o.VCTR42.Reg, volatile.LoadUint32(&o.VCTR42.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR42_B1369() uint32 {
	return (volatile.LoadUint32(&o.VCTR42.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR42_B1370(value uint32) {
	volatile.StoreUint32(&o.VCTR42.Reg, volatile.LoadUint32(&o.VCTR42.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR42_B1370() uint32 {
	return (volatile.LoadUint32(&o.VCTR42.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR42_B1371(value uint32) {
	volatile.StoreUint32(&o.VCTR42.Reg, volatile.LoadUint32(&o.VCTR42.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR42_B1371() uint32 {
	return (volatile.LoadUint32(&o.VCTR42.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR42_B1372(value uint32) {
	volatile.StoreUint32(&o.VCTR42.Reg, volatile.LoadUint32(&o.VCTR42.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR42_B1372() uint32 {
	return (volatile.LoadUint32(&o.VCTR42.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR42_B1373(value uint32) {
	volatile.StoreUint32(&o.VCTR42.Reg, volatile.LoadUint32(&o.VCTR42.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR42_B1373() uint32 {
	return (volatile.LoadUint32(&o.VCTR42.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR42_B1374(value uint32) {
	volatile.StoreUint32(&o.VCTR42.Reg, volatile.LoadUint32(&o.VCTR42.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR42_B1374() uint32 {
	return (volatile.LoadUint32(&o.VCTR42.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR42_B1375(value uint32) {
	volatile.StoreUint32(&o.VCTR42.Reg, volatile.LoadUint32(&o.VCTR42.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR42_B1375() uint32 {
	return (volatile.LoadUint32(&o.VCTR42.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR43: MPCBBx vector register
func (o *GTZC_Type) SetVCTR43_B1376(value uint32) {
	volatile.StoreUint32(&o.VCTR43.Reg, volatile.LoadUint32(&o.VCTR43.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR43_B1376() uint32 {
	return volatile.LoadUint32(&o.VCTR43.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR43_B1377(value uint32) {
	volatile.StoreUint32(&o.VCTR43.Reg, volatile.LoadUint32(&o.VCTR43.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR43_B1377() uint32 {
	return (volatile.LoadUint32(&o.VCTR43.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR43_B1378(value uint32) {
	volatile.StoreUint32(&o.VCTR43.Reg, volatile.LoadUint32(&o.VCTR43.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR43_B1378() uint32 {
	return (volatile.LoadUint32(&o.VCTR43.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR43_B1379(value uint32) {
	volatile.StoreUint32(&o.VCTR43.Reg, volatile.LoadUint32(&o.VCTR43.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR43_B1379() uint32 {
	return (volatile.LoadUint32(&o.VCTR43.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR43_B1380(value uint32) {
	volatile.StoreUint32(&o.VCTR43.Reg, volatile.LoadUint32(&o.VCTR43.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR43_B1380() uint32 {
	return (volatile.LoadUint32(&o.VCTR43.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR43_B1381(value uint32) {
	volatile.StoreUint32(&o.VCTR43.Reg, volatile.LoadUint32(&o.VCTR43.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR43_B1381() uint32 {
	return (volatile.LoadUint32(&o.VCTR43.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR43_B1382(value uint32) {
	volatile.StoreUint32(&o.VCTR43.Reg, volatile.LoadUint32(&o.VCTR43.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR43_B1382() uint32 {
	return (volatile.LoadUint32(&o.VCTR43.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR43_B1383(value uint32) {
	volatile.StoreUint32(&o.VCTR43.Reg, volatile.LoadUint32(&o.VCTR43.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR43_B1383() uint32 {
	return (volatile.LoadUint32(&o.VCTR43.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR43_B1384(value uint32) {
	volatile.StoreUint32(&o.VCTR43.Reg, volatile.LoadUint32(&o.VCTR43.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR43_B1384() uint32 {
	return (volatile.LoadUint32(&o.VCTR43.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR43_B1385(value uint32) {
	volatile.StoreUint32(&o.VCTR43.Reg, volatile.LoadUint32(&o.VCTR43.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR43_B1385() uint32 {
	return (volatile.LoadUint32(&o.VCTR43.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR43_B1386(value uint32) {
	volatile.StoreUint32(&o.VCTR43.Reg, volatile.LoadUint32(&o.VCTR43.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR43_B1386() uint32 {
	return (volatile.LoadUint32(&o.VCTR43.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR43_B1387(value uint32) {
	volatile.StoreUint32(&o.VCTR43.Reg, volatile.LoadUint32(&o.VCTR43.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR43_B1387() uint32 {
	return (volatile.LoadUint32(&o.VCTR43.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR43_B1388(value uint32) {
	volatile.StoreUint32(&o.VCTR43.Reg, volatile.LoadUint32(&o.VCTR43.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR43_B1388() uint32 {
	return (volatile.LoadUint32(&o.VCTR43.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR43_B1389(value uint32) {
	volatile.StoreUint32(&o.VCTR43.Reg, volatile.LoadUint32(&o.VCTR43.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR43_B1389() uint32 {
	return (volatile.LoadUint32(&o.VCTR43.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR43_B1390(value uint32) {
	volatile.StoreUint32(&o.VCTR43.Reg, volatile.LoadUint32(&o.VCTR43.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR43_B1390() uint32 {
	return (volatile.LoadUint32(&o.VCTR43.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR43_B1391(value uint32) {
	volatile.StoreUint32(&o.VCTR43.Reg, volatile.LoadUint32(&o.VCTR43.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR43_B1391() uint32 {
	return (volatile.LoadUint32(&o.VCTR43.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR43_B1392(value uint32) {
	volatile.StoreUint32(&o.VCTR43.Reg, volatile.LoadUint32(&o.VCTR43.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR43_B1392() uint32 {
	return (volatile.LoadUint32(&o.VCTR43.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR43_B1393(value uint32) {
	volatile.StoreUint32(&o.VCTR43.Reg, volatile.LoadUint32(&o.VCTR43.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR43_B1393() uint32 {
	return (volatile.LoadUint32(&o.VCTR43.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR43_B1394(value uint32) {
	volatile.StoreUint32(&o.VCTR43.Reg, volatile.LoadUint32(&o.VCTR43.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR43_B1394() uint32 {
	return (volatile.LoadUint32(&o.VCTR43.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR43_B1395(value uint32) {
	volatile.StoreUint32(&o.VCTR43.Reg, volatile.LoadUint32(&o.VCTR43.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR43_B1395() uint32 {
	return (volatile.LoadUint32(&o.VCTR43.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR43_B1396(value uint32) {
	volatile.StoreUint32(&o.VCTR43.Reg, volatile.LoadUint32(&o.VCTR43.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR43_B1396() uint32 {
	return (volatile.LoadUint32(&o.VCTR43.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR43_B1397(value uint32) {
	volatile.StoreUint32(&o.VCTR43.Reg, volatile.LoadUint32(&o.VCTR43.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR43_B1397() uint32 {
	return (volatile.LoadUint32(&o.VCTR43.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR43_B1398(value uint32) {
	volatile.StoreUint32(&o.VCTR43.Reg, volatile.LoadUint32(&o.VCTR43.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR43_B1398() uint32 {
	return (volatile.LoadUint32(&o.VCTR43.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR43_B1399(value uint32) {
	volatile.StoreUint32(&o.VCTR43.Reg, volatile.LoadUint32(&o.VCTR43.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR43_B1399() uint32 {
	return (volatile.LoadUint32(&o.VCTR43.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR43_B1400(value uint32) {
	volatile.StoreUint32(&o.VCTR43.Reg, volatile.LoadUint32(&o.VCTR43.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR43_B1400() uint32 {
	return (volatile.LoadUint32(&o.VCTR43.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR43_B1401(value uint32) {
	volatile.StoreUint32(&o.VCTR43.Reg, volatile.LoadUint32(&o.VCTR43.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR43_B1401() uint32 {
	return (volatile.LoadUint32(&o.VCTR43.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR43_B1402(value uint32) {
	volatile.StoreUint32(&o.VCTR43.Reg, volatile.LoadUint32(&o.VCTR43.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR43_B1402() uint32 {
	return (volatile.LoadUint32(&o.VCTR43.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR43_B1403(value uint32) {
	volatile.StoreUint32(&o.VCTR43.Reg, volatile.LoadUint32(&o.VCTR43.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR43_B1403() uint32 {
	return (volatile.LoadUint32(&o.VCTR43.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR43_B1404(value uint32) {
	volatile.StoreUint32(&o.VCTR43.Reg, volatile.LoadUint32(&o.VCTR43.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR43_B1404() uint32 {
	return (volatile.LoadUint32(&o.VCTR43.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR43_B1405(value uint32) {
	volatile.StoreUint32(&o.VCTR43.Reg, volatile.LoadUint32(&o.VCTR43.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR43_B1405() uint32 {
	return (volatile.LoadUint32(&o.VCTR43.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR43_B1406(value uint32) {
	volatile.StoreUint32(&o.VCTR43.Reg, volatile.LoadUint32(&o.VCTR43.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR43_B1406() uint32 {
	return (volatile.LoadUint32(&o.VCTR43.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR43_B1407(value uint32) {
	volatile.StoreUint32(&o.VCTR43.Reg, volatile.LoadUint32(&o.VCTR43.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR43_B1407() uint32 {
	return (volatile.LoadUint32(&o.VCTR43.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR44: MPCBBx vector register
func (o *GTZC_Type) SetVCTR44_B1408(value uint32) {
	volatile.StoreUint32(&o.VCTR44.Reg, volatile.LoadUint32(&o.VCTR44.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR44_B1408() uint32 {
	return volatile.LoadUint32(&o.VCTR44.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR44_B1409(value uint32) {
	volatile.StoreUint32(&o.VCTR44.Reg, volatile.LoadUint32(&o.VCTR44.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR44_B1409() uint32 {
	return (volatile.LoadUint32(&o.VCTR44.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR44_B1410(value uint32) {
	volatile.StoreUint32(&o.VCTR44.Reg, volatile.LoadUint32(&o.VCTR44.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR44_B1410() uint32 {
	return (volatile.LoadUint32(&o.VCTR44.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR44_B1411(value uint32) {
	volatile.StoreUint32(&o.VCTR44.Reg, volatile.LoadUint32(&o.VCTR44.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR44_B1411() uint32 {
	return (volatile.LoadUint32(&o.VCTR44.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR44_B1412(value uint32) {
	volatile.StoreUint32(&o.VCTR44.Reg, volatile.LoadUint32(&o.VCTR44.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR44_B1412() uint32 {
	return (volatile.LoadUint32(&o.VCTR44.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR44_B1413(value uint32) {
	volatile.StoreUint32(&o.VCTR44.Reg, volatile.LoadUint32(&o.VCTR44.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR44_B1413() uint32 {
	return (volatile.LoadUint32(&o.VCTR44.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR44_B1414(value uint32) {
	volatile.StoreUint32(&o.VCTR44.Reg, volatile.LoadUint32(&o.VCTR44.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR44_B1414() uint32 {
	return (volatile.LoadUint32(&o.VCTR44.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR44_B1415(value uint32) {
	volatile.StoreUint32(&o.VCTR44.Reg, volatile.LoadUint32(&o.VCTR44.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR44_B1415() uint32 {
	return (volatile.LoadUint32(&o.VCTR44.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR44_B1416(value uint32) {
	volatile.StoreUint32(&o.VCTR44.Reg, volatile.LoadUint32(&o.VCTR44.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR44_B1416() uint32 {
	return (volatile.LoadUint32(&o.VCTR44.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR44_B1417(value uint32) {
	volatile.StoreUint32(&o.VCTR44.Reg, volatile.LoadUint32(&o.VCTR44.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR44_B1417() uint32 {
	return (volatile.LoadUint32(&o.VCTR44.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR44_B1418(value uint32) {
	volatile.StoreUint32(&o.VCTR44.Reg, volatile.LoadUint32(&o.VCTR44.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR44_B1418() uint32 {
	return (volatile.LoadUint32(&o.VCTR44.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR44_B1419(value uint32) {
	volatile.StoreUint32(&o.VCTR44.Reg, volatile.LoadUint32(&o.VCTR44.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR44_B1419() uint32 {
	return (volatile.LoadUint32(&o.VCTR44.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR44_B1420(value uint32) {
	volatile.StoreUint32(&o.VCTR44.Reg, volatile.LoadUint32(&o.VCTR44.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR44_B1420() uint32 {
	return (volatile.LoadUint32(&o.VCTR44.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR44_B1421(value uint32) {
	volatile.StoreUint32(&o.VCTR44.Reg, volatile.LoadUint32(&o.VCTR44.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR44_B1421() uint32 {
	return (volatile.LoadUint32(&o.VCTR44.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR44_B1422(value uint32) {
	volatile.StoreUint32(&o.VCTR44.Reg, volatile.LoadUint32(&o.VCTR44.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR44_B1422() uint32 {
	return (volatile.LoadUint32(&o.VCTR44.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR44_B1423(value uint32) {
	volatile.StoreUint32(&o.VCTR44.Reg, volatile.LoadUint32(&o.VCTR44.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR44_B1423() uint32 {
	return (volatile.LoadUint32(&o.VCTR44.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR44_B1424(value uint32) {
	volatile.StoreUint32(&o.VCTR44.Reg, volatile.LoadUint32(&o.VCTR44.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR44_B1424() uint32 {
	return (volatile.LoadUint32(&o.VCTR44.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR44_B1425(value uint32) {
	volatile.StoreUint32(&o.VCTR44.Reg, volatile.LoadUint32(&o.VCTR44.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR44_B1425() uint32 {
	return (volatile.LoadUint32(&o.VCTR44.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR44_B1426(value uint32) {
	volatile.StoreUint32(&o.VCTR44.Reg, volatile.LoadUint32(&o.VCTR44.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR44_B1426() uint32 {
	return (volatile.LoadUint32(&o.VCTR44.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR44_B1427(value uint32) {
	volatile.StoreUint32(&o.VCTR44.Reg, volatile.LoadUint32(&o.VCTR44.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR44_B1427() uint32 {
	return (volatile.LoadUint32(&o.VCTR44.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR44_B1428(value uint32) {
	volatile.StoreUint32(&o.VCTR44.Reg, volatile.LoadUint32(&o.VCTR44.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR44_B1428() uint32 {
	return (volatile.LoadUint32(&o.VCTR44.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR44_B1429(value uint32) {
	volatile.StoreUint32(&o.VCTR44.Reg, volatile.LoadUint32(&o.VCTR44.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR44_B1429() uint32 {
	return (volatile.LoadUint32(&o.VCTR44.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR44_B1430(value uint32) {
	volatile.StoreUint32(&o.VCTR44.Reg, volatile.LoadUint32(&o.VCTR44.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR44_B1430() uint32 {
	return (volatile.LoadUint32(&o.VCTR44.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR44_B1431(value uint32) {
	volatile.StoreUint32(&o.VCTR44.Reg, volatile.LoadUint32(&o.VCTR44.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR44_B1431() uint32 {
	return (volatile.LoadUint32(&o.VCTR44.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR44_B1432(value uint32) {
	volatile.StoreUint32(&o.VCTR44.Reg, volatile.LoadUint32(&o.VCTR44.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR44_B1432() uint32 {
	return (volatile.LoadUint32(&o.VCTR44.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR44_B1433(value uint32) {
	volatile.StoreUint32(&o.VCTR44.Reg, volatile.LoadUint32(&o.VCTR44.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR44_B1433() uint32 {
	return (volatile.LoadUint32(&o.VCTR44.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR44_B1434(value uint32) {
	volatile.StoreUint32(&o.VCTR44.Reg, volatile.LoadUint32(&o.VCTR44.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR44_B1434() uint32 {
	return (volatile.LoadUint32(&o.VCTR44.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR44_B1435(value uint32) {
	volatile.StoreUint32(&o.VCTR44.Reg, volatile.LoadUint32(&o.VCTR44.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR44_B1435() uint32 {
	return (volatile.LoadUint32(&o.VCTR44.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR44_B1436(value uint32) {
	volatile.StoreUint32(&o.VCTR44.Reg, volatile.LoadUint32(&o.VCTR44.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR44_B1436() uint32 {
	return (volatile.LoadUint32(&o.VCTR44.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR44_B1437(value uint32) {
	volatile.StoreUint32(&o.VCTR44.Reg, volatile.LoadUint32(&o.VCTR44.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR44_B1437() uint32 {
	return (volatile.LoadUint32(&o.VCTR44.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR44_B1438(value uint32) {
	volatile.StoreUint32(&o.VCTR44.Reg, volatile.LoadUint32(&o.VCTR44.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR44_B1438() uint32 {
	return (volatile.LoadUint32(&o.VCTR44.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR44_B1439(value uint32) {
	volatile.StoreUint32(&o.VCTR44.Reg, volatile.LoadUint32(&o.VCTR44.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR44_B1439() uint32 {
	return (volatile.LoadUint32(&o.VCTR44.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR45: MPCBBx vector register
func (o *GTZC_Type) SetVCTR45_B1440(value uint32) {
	volatile.StoreUint32(&o.VCTR45.Reg, volatile.LoadUint32(&o.VCTR45.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR45_B1440() uint32 {
	return volatile.LoadUint32(&o.VCTR45.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR45_B1441(value uint32) {
	volatile.StoreUint32(&o.VCTR45.Reg, volatile.LoadUint32(&o.VCTR45.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR45_B1441() uint32 {
	return (volatile.LoadUint32(&o.VCTR45.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR45_B1442(value uint32) {
	volatile.StoreUint32(&o.VCTR45.Reg, volatile.LoadUint32(&o.VCTR45.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR45_B1442() uint32 {
	return (volatile.LoadUint32(&o.VCTR45.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR45_B1443(value uint32) {
	volatile.StoreUint32(&o.VCTR45.Reg, volatile.LoadUint32(&o.VCTR45.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR45_B1443() uint32 {
	return (volatile.LoadUint32(&o.VCTR45.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR45_B1444(value uint32) {
	volatile.StoreUint32(&o.VCTR45.Reg, volatile.LoadUint32(&o.VCTR45.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR45_B1444() uint32 {
	return (volatile.LoadUint32(&o.VCTR45.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR45_B1445(value uint32) {
	volatile.StoreUint32(&o.VCTR45.Reg, volatile.LoadUint32(&o.VCTR45.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR45_B1445() uint32 {
	return (volatile.LoadUint32(&o.VCTR45.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR45_B1446(value uint32) {
	volatile.StoreUint32(&o.VCTR45.Reg, volatile.LoadUint32(&o.VCTR45.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR45_B1446() uint32 {
	return (volatile.LoadUint32(&o.VCTR45.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR45_B1447(value uint32) {
	volatile.StoreUint32(&o.VCTR45.Reg, volatile.LoadUint32(&o.VCTR45.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR45_B1447() uint32 {
	return (volatile.LoadUint32(&o.VCTR45.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR45_B1448(value uint32) {
	volatile.StoreUint32(&o.VCTR45.Reg, volatile.LoadUint32(&o.VCTR45.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR45_B1448() uint32 {
	return (volatile.LoadUint32(&o.VCTR45.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR45_B1449(value uint32) {
	volatile.StoreUint32(&o.VCTR45.Reg, volatile.LoadUint32(&o.VCTR45.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR45_B1449() uint32 {
	return (volatile.LoadUint32(&o.VCTR45.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR45_B1450(value uint32) {
	volatile.StoreUint32(&o.VCTR45.Reg, volatile.LoadUint32(&o.VCTR45.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR45_B1450() uint32 {
	return (volatile.LoadUint32(&o.VCTR45.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR45_B1451(value uint32) {
	volatile.StoreUint32(&o.VCTR45.Reg, volatile.LoadUint32(&o.VCTR45.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR45_B1451() uint32 {
	return (volatile.LoadUint32(&o.VCTR45.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR45_B1452(value uint32) {
	volatile.StoreUint32(&o.VCTR45.Reg, volatile.LoadUint32(&o.VCTR45.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR45_B1452() uint32 {
	return (volatile.LoadUint32(&o.VCTR45.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR45_B1453(value uint32) {
	volatile.StoreUint32(&o.VCTR45.Reg, volatile.LoadUint32(&o.VCTR45.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR45_B1453() uint32 {
	return (volatile.LoadUint32(&o.VCTR45.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR45_B1454(value uint32) {
	volatile.StoreUint32(&o.VCTR45.Reg, volatile.LoadUint32(&o.VCTR45.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR45_B1454() uint32 {
	return (volatile.LoadUint32(&o.VCTR45.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR45_B1455(value uint32) {
	volatile.StoreUint32(&o.VCTR45.Reg, volatile.LoadUint32(&o.VCTR45.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR45_B1455() uint32 {
	return (volatile.LoadUint32(&o.VCTR45.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR45_B1456(value uint32) {
	volatile.StoreUint32(&o.VCTR45.Reg, volatile.LoadUint32(&o.VCTR45.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR45_B1456() uint32 {
	return (volatile.LoadUint32(&o.VCTR45.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR45_B1457(value uint32) {
	volatile.StoreUint32(&o.VCTR45.Reg, volatile.LoadUint32(&o.VCTR45.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR45_B1457() uint32 {
	return (volatile.LoadUint32(&o.VCTR45.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR45_B1458(value uint32) {
	volatile.StoreUint32(&o.VCTR45.Reg, volatile.LoadUint32(&o.VCTR45.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR45_B1458() uint32 {
	return (volatile.LoadUint32(&o.VCTR45.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR45_B1459(value uint32) {
	volatile.StoreUint32(&o.VCTR45.Reg, volatile.LoadUint32(&o.VCTR45.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR45_B1459() uint32 {
	return (volatile.LoadUint32(&o.VCTR45.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR45_B1460(value uint32) {
	volatile.StoreUint32(&o.VCTR45.Reg, volatile.LoadUint32(&o.VCTR45.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR45_B1460() uint32 {
	return (volatile.LoadUint32(&o.VCTR45.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR45_B1461(value uint32) {
	volatile.StoreUint32(&o.VCTR45.Reg, volatile.LoadUint32(&o.VCTR45.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR45_B1461() uint32 {
	return (volatile.LoadUint32(&o.VCTR45.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR45_B1462(value uint32) {
	volatile.StoreUint32(&o.VCTR45.Reg, volatile.LoadUint32(&o.VCTR45.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR45_B1462() uint32 {
	return (volatile.LoadUint32(&o.VCTR45.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR45_B1463(value uint32) {
	volatile.StoreUint32(&o.VCTR45.Reg, volatile.LoadUint32(&o.VCTR45.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR45_B1463() uint32 {
	return (volatile.LoadUint32(&o.VCTR45.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR45_B1464(value uint32) {
	volatile.StoreUint32(&o.VCTR45.Reg, volatile.LoadUint32(&o.VCTR45.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR45_B1464() uint32 {
	return (volatile.LoadUint32(&o.VCTR45.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR45_B1465(value uint32) {
	volatile.StoreUint32(&o.VCTR45.Reg, volatile.LoadUint32(&o.VCTR45.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR45_B1465() uint32 {
	return (volatile.LoadUint32(&o.VCTR45.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR45_B1466(value uint32) {
	volatile.StoreUint32(&o.VCTR45.Reg, volatile.LoadUint32(&o.VCTR45.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR45_B1466() uint32 {
	return (volatile.LoadUint32(&o.VCTR45.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR45_B1467(value uint32) {
	volatile.StoreUint32(&o.VCTR45.Reg, volatile.LoadUint32(&o.VCTR45.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR45_B1467() uint32 {
	return (volatile.LoadUint32(&o.VCTR45.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR45_B1468(value uint32) {
	volatile.StoreUint32(&o.VCTR45.Reg, volatile.LoadUint32(&o.VCTR45.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR45_B1468() uint32 {
	return (volatile.LoadUint32(&o.VCTR45.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR45_B1469(value uint32) {
	volatile.StoreUint32(&o.VCTR45.Reg, volatile.LoadUint32(&o.VCTR45.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR45_B1469() uint32 {
	return (volatile.LoadUint32(&o.VCTR45.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR45_B1470(value uint32) {
	volatile.StoreUint32(&o.VCTR45.Reg, volatile.LoadUint32(&o.VCTR45.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR45_B1470() uint32 {
	return (volatile.LoadUint32(&o.VCTR45.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR45_B1471(value uint32) {
	volatile.StoreUint32(&o.VCTR45.Reg, volatile.LoadUint32(&o.VCTR45.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR45_B1471() uint32 {
	return (volatile.LoadUint32(&o.VCTR45.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR46: MPCBBx vector register
func (o *GTZC_Type) SetVCTR46_B1472(value uint32) {
	volatile.StoreUint32(&o.VCTR46.Reg, volatile.LoadUint32(&o.VCTR46.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR46_B1472() uint32 {
	return volatile.LoadUint32(&o.VCTR46.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR46_B1473(value uint32) {
	volatile.StoreUint32(&o.VCTR46.Reg, volatile.LoadUint32(&o.VCTR46.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR46_B1473() uint32 {
	return (volatile.LoadUint32(&o.VCTR46.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR46_B1474(value uint32) {
	volatile.StoreUint32(&o.VCTR46.Reg, volatile.LoadUint32(&o.VCTR46.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR46_B1474() uint32 {
	return (volatile.LoadUint32(&o.VCTR46.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR46_B1475(value uint32) {
	volatile.StoreUint32(&o.VCTR46.Reg, volatile.LoadUint32(&o.VCTR46.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR46_B1475() uint32 {
	return (volatile.LoadUint32(&o.VCTR46.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR46_B1476(value uint32) {
	volatile.StoreUint32(&o.VCTR46.Reg, volatile.LoadUint32(&o.VCTR46.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR46_B1476() uint32 {
	return (volatile.LoadUint32(&o.VCTR46.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR46_B1477(value uint32) {
	volatile.StoreUint32(&o.VCTR46.Reg, volatile.LoadUint32(&o.VCTR46.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR46_B1477() uint32 {
	return (volatile.LoadUint32(&o.VCTR46.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR46_B1478(value uint32) {
	volatile.StoreUint32(&o.VCTR46.Reg, volatile.LoadUint32(&o.VCTR46.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR46_B1478() uint32 {
	return (volatile.LoadUint32(&o.VCTR46.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR46_B1479(value uint32) {
	volatile.StoreUint32(&o.VCTR46.Reg, volatile.LoadUint32(&o.VCTR46.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR46_B1479() uint32 {
	return (volatile.LoadUint32(&o.VCTR46.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR46_B1480(value uint32) {
	volatile.StoreUint32(&o.VCTR46.Reg, volatile.LoadUint32(&o.VCTR46.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR46_B1480() uint32 {
	return (volatile.LoadUint32(&o.VCTR46.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR46_B1481(value uint32) {
	volatile.StoreUint32(&o.VCTR46.Reg, volatile.LoadUint32(&o.VCTR46.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR46_B1481() uint32 {
	return (volatile.LoadUint32(&o.VCTR46.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR46_B1482(value uint32) {
	volatile.StoreUint32(&o.VCTR46.Reg, volatile.LoadUint32(&o.VCTR46.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR46_B1482() uint32 {
	return (volatile.LoadUint32(&o.VCTR46.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR46_B1483(value uint32) {
	volatile.StoreUint32(&o.VCTR46.Reg, volatile.LoadUint32(&o.VCTR46.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR46_B1483() uint32 {
	return (volatile.LoadUint32(&o.VCTR46.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR46_B1484(value uint32) {
	volatile.StoreUint32(&o.VCTR46.Reg, volatile.LoadUint32(&o.VCTR46.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR46_B1484() uint32 {
	return (volatile.LoadUint32(&o.VCTR46.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR46_B1485(value uint32) {
	volatile.StoreUint32(&o.VCTR46.Reg, volatile.LoadUint32(&o.VCTR46.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR46_B1485() uint32 {
	return (volatile.LoadUint32(&o.VCTR46.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR46_B1486(value uint32) {
	volatile.StoreUint32(&o.VCTR46.Reg, volatile.LoadUint32(&o.VCTR46.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR46_B1486() uint32 {
	return (volatile.LoadUint32(&o.VCTR46.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR46_B1487(value uint32) {
	volatile.StoreUint32(&o.VCTR46.Reg, volatile.LoadUint32(&o.VCTR46.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR46_B1487() uint32 {
	return (volatile.LoadUint32(&o.VCTR46.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR46_B1488(value uint32) {
	volatile.StoreUint32(&o.VCTR46.Reg, volatile.LoadUint32(&o.VCTR46.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR46_B1488() uint32 {
	return (volatile.LoadUint32(&o.VCTR46.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR46_B1489(value uint32) {
	volatile.StoreUint32(&o.VCTR46.Reg, volatile.LoadUint32(&o.VCTR46.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR46_B1489() uint32 {
	return (volatile.LoadUint32(&o.VCTR46.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR46_B1490(value uint32) {
	volatile.StoreUint32(&o.VCTR46.Reg, volatile.LoadUint32(&o.VCTR46.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR46_B1490() uint32 {
	return (volatile.LoadUint32(&o.VCTR46.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR46_B1491(value uint32) {
	volatile.StoreUint32(&o.VCTR46.Reg, volatile.LoadUint32(&o.VCTR46.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR46_B1491() uint32 {
	return (volatile.LoadUint32(&o.VCTR46.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR46_B1492(value uint32) {
	volatile.StoreUint32(&o.VCTR46.Reg, volatile.LoadUint32(&o.VCTR46.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR46_B1492() uint32 {
	return (volatile.LoadUint32(&o.VCTR46.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR46_B1493(value uint32) {
	volatile.StoreUint32(&o.VCTR46.Reg, volatile.LoadUint32(&o.VCTR46.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR46_B1493() uint32 {
	return (volatile.LoadUint32(&o.VCTR46.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR46_B1494(value uint32) {
	volatile.StoreUint32(&o.VCTR46.Reg, volatile.LoadUint32(&o.VCTR46.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR46_B1494() uint32 {
	return (volatile.LoadUint32(&o.VCTR46.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR46_B1495(value uint32) {
	volatile.StoreUint32(&o.VCTR46.Reg, volatile.LoadUint32(&o.VCTR46.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR46_B1495() uint32 {
	return (volatile.LoadUint32(&o.VCTR46.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR46_B1496(value uint32) {
	volatile.StoreUint32(&o.VCTR46.Reg, volatile.LoadUint32(&o.VCTR46.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR46_B1496() uint32 {
	return (volatile.LoadUint32(&o.VCTR46.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR46_B1497(value uint32) {
	volatile.StoreUint32(&o.VCTR46.Reg, volatile.LoadUint32(&o.VCTR46.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR46_B1497() uint32 {
	return (volatile.LoadUint32(&o.VCTR46.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR46_B1498(value uint32) {
	volatile.StoreUint32(&o.VCTR46.Reg, volatile.LoadUint32(&o.VCTR46.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR46_B1498() uint32 {
	return (volatile.LoadUint32(&o.VCTR46.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR46_B1499(value uint32) {
	volatile.StoreUint32(&o.VCTR46.Reg, volatile.LoadUint32(&o.VCTR46.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR46_B1499() uint32 {
	return (volatile.LoadUint32(&o.VCTR46.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR46_B1500(value uint32) {
	volatile.StoreUint32(&o.VCTR46.Reg, volatile.LoadUint32(&o.VCTR46.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR46_B1500() uint32 {
	return (volatile.LoadUint32(&o.VCTR46.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR46_B1501(value uint32) {
	volatile.StoreUint32(&o.VCTR46.Reg, volatile.LoadUint32(&o.VCTR46.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR46_B1501() uint32 {
	return (volatile.LoadUint32(&o.VCTR46.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR46_B1502(value uint32) {
	volatile.StoreUint32(&o.VCTR46.Reg, volatile.LoadUint32(&o.VCTR46.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR46_B1502() uint32 {
	return (volatile.LoadUint32(&o.VCTR46.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR46_B1503(value uint32) {
	volatile.StoreUint32(&o.VCTR46.Reg, volatile.LoadUint32(&o.VCTR46.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR46_B1503() uint32 {
	return (volatile.LoadUint32(&o.VCTR46.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR47: MPCBBx vector register
func (o *GTZC_Type) SetVCTR47_B1504(value uint32) {
	volatile.StoreUint32(&o.VCTR47.Reg, volatile.LoadUint32(&o.VCTR47.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR47_B1504() uint32 {
	return volatile.LoadUint32(&o.VCTR47.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR47_B1505(value uint32) {
	volatile.StoreUint32(&o.VCTR47.Reg, volatile.LoadUint32(&o.VCTR47.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR47_B1505() uint32 {
	return (volatile.LoadUint32(&o.VCTR47.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR47_B1506(value uint32) {
	volatile.StoreUint32(&o.VCTR47.Reg, volatile.LoadUint32(&o.VCTR47.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR47_B1506() uint32 {
	return (volatile.LoadUint32(&o.VCTR47.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR47_B1507(value uint32) {
	volatile.StoreUint32(&o.VCTR47.Reg, volatile.LoadUint32(&o.VCTR47.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR47_B1507() uint32 {
	return (volatile.LoadUint32(&o.VCTR47.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR47_B1508(value uint32) {
	volatile.StoreUint32(&o.VCTR47.Reg, volatile.LoadUint32(&o.VCTR47.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR47_B1508() uint32 {
	return (volatile.LoadUint32(&o.VCTR47.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR47_B1509(value uint32) {
	volatile.StoreUint32(&o.VCTR47.Reg, volatile.LoadUint32(&o.VCTR47.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR47_B1509() uint32 {
	return (volatile.LoadUint32(&o.VCTR47.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR47_B1510(value uint32) {
	volatile.StoreUint32(&o.VCTR47.Reg, volatile.LoadUint32(&o.VCTR47.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR47_B1510() uint32 {
	return (volatile.LoadUint32(&o.VCTR47.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR47_B1511(value uint32) {
	volatile.StoreUint32(&o.VCTR47.Reg, volatile.LoadUint32(&o.VCTR47.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR47_B1511() uint32 {
	return (volatile.LoadUint32(&o.VCTR47.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR47_B1512(value uint32) {
	volatile.StoreUint32(&o.VCTR47.Reg, volatile.LoadUint32(&o.VCTR47.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR47_B1512() uint32 {
	return (volatile.LoadUint32(&o.VCTR47.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR47_B1513(value uint32) {
	volatile.StoreUint32(&o.VCTR47.Reg, volatile.LoadUint32(&o.VCTR47.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR47_B1513() uint32 {
	return (volatile.LoadUint32(&o.VCTR47.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR47_B1514(value uint32) {
	volatile.StoreUint32(&o.VCTR47.Reg, volatile.LoadUint32(&o.VCTR47.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR47_B1514() uint32 {
	return (volatile.LoadUint32(&o.VCTR47.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR47_B1515(value uint32) {
	volatile.StoreUint32(&o.VCTR47.Reg, volatile.LoadUint32(&o.VCTR47.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR47_B1515() uint32 {
	return (volatile.LoadUint32(&o.VCTR47.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR47_B1516(value uint32) {
	volatile.StoreUint32(&o.VCTR47.Reg, volatile.LoadUint32(&o.VCTR47.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR47_B1516() uint32 {
	return (volatile.LoadUint32(&o.VCTR47.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR47_B1517(value uint32) {
	volatile.StoreUint32(&o.VCTR47.Reg, volatile.LoadUint32(&o.VCTR47.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR47_B1517() uint32 {
	return (volatile.LoadUint32(&o.VCTR47.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR47_B1518(value uint32) {
	volatile.StoreUint32(&o.VCTR47.Reg, volatile.LoadUint32(&o.VCTR47.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR47_B1518() uint32 {
	return (volatile.LoadUint32(&o.VCTR47.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR47_B1519(value uint32) {
	volatile.StoreUint32(&o.VCTR47.Reg, volatile.LoadUint32(&o.VCTR47.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR47_B1519() uint32 {
	return (volatile.LoadUint32(&o.VCTR47.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR47_B1520(value uint32) {
	volatile.StoreUint32(&o.VCTR47.Reg, volatile.LoadUint32(&o.VCTR47.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR47_B1520() uint32 {
	return (volatile.LoadUint32(&o.VCTR47.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR47_B1521(value uint32) {
	volatile.StoreUint32(&o.VCTR47.Reg, volatile.LoadUint32(&o.VCTR47.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR47_B1521() uint32 {
	return (volatile.LoadUint32(&o.VCTR47.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR47_B1522(value uint32) {
	volatile.StoreUint32(&o.VCTR47.Reg, volatile.LoadUint32(&o.VCTR47.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR47_B1522() uint32 {
	return (volatile.LoadUint32(&o.VCTR47.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR47_B1523(value uint32) {
	volatile.StoreUint32(&o.VCTR47.Reg, volatile.LoadUint32(&o.VCTR47.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR47_B1523() uint32 {
	return (volatile.LoadUint32(&o.VCTR47.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR47_B1524(value uint32) {
	volatile.StoreUint32(&o.VCTR47.Reg, volatile.LoadUint32(&o.VCTR47.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR47_B1524() uint32 {
	return (volatile.LoadUint32(&o.VCTR47.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR47_B1525(value uint32) {
	volatile.StoreUint32(&o.VCTR47.Reg, volatile.LoadUint32(&o.VCTR47.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR47_B1525() uint32 {
	return (volatile.LoadUint32(&o.VCTR47.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR47_B1526(value uint32) {
	volatile.StoreUint32(&o.VCTR47.Reg, volatile.LoadUint32(&o.VCTR47.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR47_B1526() uint32 {
	return (volatile.LoadUint32(&o.VCTR47.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR47_B1527(value uint32) {
	volatile.StoreUint32(&o.VCTR47.Reg, volatile.LoadUint32(&o.VCTR47.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR47_B1527() uint32 {
	return (volatile.LoadUint32(&o.VCTR47.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR47_B1528(value uint32) {
	volatile.StoreUint32(&o.VCTR47.Reg, volatile.LoadUint32(&o.VCTR47.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR47_B1528() uint32 {
	return (volatile.LoadUint32(&o.VCTR47.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR47_B1529(value uint32) {
	volatile.StoreUint32(&o.VCTR47.Reg, volatile.LoadUint32(&o.VCTR47.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR47_B1529() uint32 {
	return (volatile.LoadUint32(&o.VCTR47.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR47_B1530(value uint32) {
	volatile.StoreUint32(&o.VCTR47.Reg, volatile.LoadUint32(&o.VCTR47.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR47_B1530() uint32 {
	return (volatile.LoadUint32(&o.VCTR47.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR47_B1531(value uint32) {
	volatile.StoreUint32(&o.VCTR47.Reg, volatile.LoadUint32(&o.VCTR47.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR47_B1531() uint32 {
	return (volatile.LoadUint32(&o.VCTR47.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR47_B1532(value uint32) {
	volatile.StoreUint32(&o.VCTR47.Reg, volatile.LoadUint32(&o.VCTR47.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR47_B1532() uint32 {
	return (volatile.LoadUint32(&o.VCTR47.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR47_B1533(value uint32) {
	volatile.StoreUint32(&o.VCTR47.Reg, volatile.LoadUint32(&o.VCTR47.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR47_B1533() uint32 {
	return (volatile.LoadUint32(&o.VCTR47.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR47_B1534(value uint32) {
	volatile.StoreUint32(&o.VCTR47.Reg, volatile.LoadUint32(&o.VCTR47.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR47_B1534() uint32 {
	return (volatile.LoadUint32(&o.VCTR47.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR47_B1535(value uint32) {
	volatile.StoreUint32(&o.VCTR47.Reg, volatile.LoadUint32(&o.VCTR47.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR47_B1535() uint32 {
	return (volatile.LoadUint32(&o.VCTR47.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR48: MPCBBx vector register
func (o *GTZC_Type) SetVCTR48_B1536(value uint32) {
	volatile.StoreUint32(&o.VCTR48.Reg, volatile.LoadUint32(&o.VCTR48.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR48_B1536() uint32 {
	return volatile.LoadUint32(&o.VCTR48.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR48_B1537(value uint32) {
	volatile.StoreUint32(&o.VCTR48.Reg, volatile.LoadUint32(&o.VCTR48.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR48_B1537() uint32 {
	return (volatile.LoadUint32(&o.VCTR48.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR48_B1538(value uint32) {
	volatile.StoreUint32(&o.VCTR48.Reg, volatile.LoadUint32(&o.VCTR48.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR48_B1538() uint32 {
	return (volatile.LoadUint32(&o.VCTR48.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR48_B1539(value uint32) {
	volatile.StoreUint32(&o.VCTR48.Reg, volatile.LoadUint32(&o.VCTR48.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR48_B1539() uint32 {
	return (volatile.LoadUint32(&o.VCTR48.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR48_B1540(value uint32) {
	volatile.StoreUint32(&o.VCTR48.Reg, volatile.LoadUint32(&o.VCTR48.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR48_B1540() uint32 {
	return (volatile.LoadUint32(&o.VCTR48.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR48_B1541(value uint32) {
	volatile.StoreUint32(&o.VCTR48.Reg, volatile.LoadUint32(&o.VCTR48.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR48_B1541() uint32 {
	return (volatile.LoadUint32(&o.VCTR48.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR48_B1542(value uint32) {
	volatile.StoreUint32(&o.VCTR48.Reg, volatile.LoadUint32(&o.VCTR48.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR48_B1542() uint32 {
	return (volatile.LoadUint32(&o.VCTR48.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR48_B1543(value uint32) {
	volatile.StoreUint32(&o.VCTR48.Reg, volatile.LoadUint32(&o.VCTR48.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR48_B1543() uint32 {
	return (volatile.LoadUint32(&o.VCTR48.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR48_B1544(value uint32) {
	volatile.StoreUint32(&o.VCTR48.Reg, volatile.LoadUint32(&o.VCTR48.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR48_B1544() uint32 {
	return (volatile.LoadUint32(&o.VCTR48.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR48_B1545(value uint32) {
	volatile.StoreUint32(&o.VCTR48.Reg, volatile.LoadUint32(&o.VCTR48.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR48_B1545() uint32 {
	return (volatile.LoadUint32(&o.VCTR48.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR48_B1546(value uint32) {
	volatile.StoreUint32(&o.VCTR48.Reg, volatile.LoadUint32(&o.VCTR48.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR48_B1546() uint32 {
	return (volatile.LoadUint32(&o.VCTR48.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR48_B1547(value uint32) {
	volatile.StoreUint32(&o.VCTR48.Reg, volatile.LoadUint32(&o.VCTR48.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR48_B1547() uint32 {
	return (volatile.LoadUint32(&o.VCTR48.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR48_B1548(value uint32) {
	volatile.StoreUint32(&o.VCTR48.Reg, volatile.LoadUint32(&o.VCTR48.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR48_B1548() uint32 {
	return (volatile.LoadUint32(&o.VCTR48.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR48_B1549(value uint32) {
	volatile.StoreUint32(&o.VCTR48.Reg, volatile.LoadUint32(&o.VCTR48.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR48_B1549() uint32 {
	return (volatile.LoadUint32(&o.VCTR48.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR48_B1550(value uint32) {
	volatile.StoreUint32(&o.VCTR48.Reg, volatile.LoadUint32(&o.VCTR48.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR48_B1550() uint32 {
	return (volatile.LoadUint32(&o.VCTR48.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR48_B1551(value uint32) {
	volatile.StoreUint32(&o.VCTR48.Reg, volatile.LoadUint32(&o.VCTR48.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR48_B1551() uint32 {
	return (volatile.LoadUint32(&o.VCTR48.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR48_B1552(value uint32) {
	volatile.StoreUint32(&o.VCTR48.Reg, volatile.LoadUint32(&o.VCTR48.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR48_B1552() uint32 {
	return (volatile.LoadUint32(&o.VCTR48.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR48_B1553(value uint32) {
	volatile.StoreUint32(&o.VCTR48.Reg, volatile.LoadUint32(&o.VCTR48.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR48_B1553() uint32 {
	return (volatile.LoadUint32(&o.VCTR48.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR48_B1554(value uint32) {
	volatile.StoreUint32(&o.VCTR48.Reg, volatile.LoadUint32(&o.VCTR48.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR48_B1554() uint32 {
	return (volatile.LoadUint32(&o.VCTR48.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR48_B1555(value uint32) {
	volatile.StoreUint32(&o.VCTR48.Reg, volatile.LoadUint32(&o.VCTR48.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR48_B1555() uint32 {
	return (volatile.LoadUint32(&o.VCTR48.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR48_B1556(value uint32) {
	volatile.StoreUint32(&o.VCTR48.Reg, volatile.LoadUint32(&o.VCTR48.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR48_B1556() uint32 {
	return (volatile.LoadUint32(&o.VCTR48.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR48_B1557(value uint32) {
	volatile.StoreUint32(&o.VCTR48.Reg, volatile.LoadUint32(&o.VCTR48.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR48_B1557() uint32 {
	return (volatile.LoadUint32(&o.VCTR48.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR48_B1558(value uint32) {
	volatile.StoreUint32(&o.VCTR48.Reg, volatile.LoadUint32(&o.VCTR48.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR48_B1558() uint32 {
	return (volatile.LoadUint32(&o.VCTR48.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR48_B1559(value uint32) {
	volatile.StoreUint32(&o.VCTR48.Reg, volatile.LoadUint32(&o.VCTR48.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR48_B1559() uint32 {
	return (volatile.LoadUint32(&o.VCTR48.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR48_B1560(value uint32) {
	volatile.StoreUint32(&o.VCTR48.Reg, volatile.LoadUint32(&o.VCTR48.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR48_B1560() uint32 {
	return (volatile.LoadUint32(&o.VCTR48.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR48_B1561(value uint32) {
	volatile.StoreUint32(&o.VCTR48.Reg, volatile.LoadUint32(&o.VCTR48.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR48_B1561() uint32 {
	return (volatile.LoadUint32(&o.VCTR48.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR48_B1562(value uint32) {
	volatile.StoreUint32(&o.VCTR48.Reg, volatile.LoadUint32(&o.VCTR48.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR48_B1562() uint32 {
	return (volatile.LoadUint32(&o.VCTR48.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR48_B1563(value uint32) {
	volatile.StoreUint32(&o.VCTR48.Reg, volatile.LoadUint32(&o.VCTR48.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR48_B1563() uint32 {
	return (volatile.LoadUint32(&o.VCTR48.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR48_B1564(value uint32) {
	volatile.StoreUint32(&o.VCTR48.Reg, volatile.LoadUint32(&o.VCTR48.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR48_B1564() uint32 {
	return (volatile.LoadUint32(&o.VCTR48.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR48_B1565(value uint32) {
	volatile.StoreUint32(&o.VCTR48.Reg, volatile.LoadUint32(&o.VCTR48.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR48_B1565() uint32 {
	return (volatile.LoadUint32(&o.VCTR48.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR48_B1566(value uint32) {
	volatile.StoreUint32(&o.VCTR48.Reg, volatile.LoadUint32(&o.VCTR48.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR48_B1566() uint32 {
	return (volatile.LoadUint32(&o.VCTR48.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR48_B1567(value uint32) {
	volatile.StoreUint32(&o.VCTR48.Reg, volatile.LoadUint32(&o.VCTR48.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR48_B1567() uint32 {
	return (volatile.LoadUint32(&o.VCTR48.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR49: MPCBBx vector register
func (o *GTZC_Type) SetVCTR49_B1568(value uint32) {
	volatile.StoreUint32(&o.VCTR49.Reg, volatile.LoadUint32(&o.VCTR49.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR49_B1568() uint32 {
	return volatile.LoadUint32(&o.VCTR49.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR49_B1569(value uint32) {
	volatile.StoreUint32(&o.VCTR49.Reg, volatile.LoadUint32(&o.VCTR49.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR49_B1569() uint32 {
	return (volatile.LoadUint32(&o.VCTR49.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR49_B1570(value uint32) {
	volatile.StoreUint32(&o.VCTR49.Reg, volatile.LoadUint32(&o.VCTR49.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR49_B1570() uint32 {
	return (volatile.LoadUint32(&o.VCTR49.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR49_B1571(value uint32) {
	volatile.StoreUint32(&o.VCTR49.Reg, volatile.LoadUint32(&o.VCTR49.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR49_B1571() uint32 {
	return (volatile.LoadUint32(&o.VCTR49.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR49_B1572(value uint32) {
	volatile.StoreUint32(&o.VCTR49.Reg, volatile.LoadUint32(&o.VCTR49.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR49_B1572() uint32 {
	return (volatile.LoadUint32(&o.VCTR49.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR49_B1573(value uint32) {
	volatile.StoreUint32(&o.VCTR49.Reg, volatile.LoadUint32(&o.VCTR49.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR49_B1573() uint32 {
	return (volatile.LoadUint32(&o.VCTR49.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR49_B1574(value uint32) {
	volatile.StoreUint32(&o.VCTR49.Reg, volatile.LoadUint32(&o.VCTR49.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR49_B1574() uint32 {
	return (volatile.LoadUint32(&o.VCTR49.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR49_B1575(value uint32) {
	volatile.StoreUint32(&o.VCTR49.Reg, volatile.LoadUint32(&o.VCTR49.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR49_B1575() uint32 {
	return (volatile.LoadUint32(&o.VCTR49.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR49_B1576(value uint32) {
	volatile.StoreUint32(&o.VCTR49.Reg, volatile.LoadUint32(&o.VCTR49.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR49_B1576() uint32 {
	return (volatile.LoadUint32(&o.VCTR49.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR49_B1577(value uint32) {
	volatile.StoreUint32(&o.VCTR49.Reg, volatile.LoadUint32(&o.VCTR49.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR49_B1577() uint32 {
	return (volatile.LoadUint32(&o.VCTR49.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR49_B1578(value uint32) {
	volatile.StoreUint32(&o.VCTR49.Reg, volatile.LoadUint32(&o.VCTR49.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR49_B1578() uint32 {
	return (volatile.LoadUint32(&o.VCTR49.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR49_B1579(value uint32) {
	volatile.StoreUint32(&o.VCTR49.Reg, volatile.LoadUint32(&o.VCTR49.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR49_B1579() uint32 {
	return (volatile.LoadUint32(&o.VCTR49.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR49_B1580(value uint32) {
	volatile.StoreUint32(&o.VCTR49.Reg, volatile.LoadUint32(&o.VCTR49.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR49_B1580() uint32 {
	return (volatile.LoadUint32(&o.VCTR49.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR49_B1581(value uint32) {
	volatile.StoreUint32(&o.VCTR49.Reg, volatile.LoadUint32(&o.VCTR49.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR49_B1581() uint32 {
	return (volatile.LoadUint32(&o.VCTR49.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR49_B1582(value uint32) {
	volatile.StoreUint32(&o.VCTR49.Reg, volatile.LoadUint32(&o.VCTR49.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR49_B1582() uint32 {
	return (volatile.LoadUint32(&o.VCTR49.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR49_B1583(value uint32) {
	volatile.StoreUint32(&o.VCTR49.Reg, volatile.LoadUint32(&o.VCTR49.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR49_B1583() uint32 {
	return (volatile.LoadUint32(&o.VCTR49.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR49_B1584(value uint32) {
	volatile.StoreUint32(&o.VCTR49.Reg, volatile.LoadUint32(&o.VCTR49.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR49_B1584() uint32 {
	return (volatile.LoadUint32(&o.VCTR49.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR49_B1585(value uint32) {
	volatile.StoreUint32(&o.VCTR49.Reg, volatile.LoadUint32(&o.VCTR49.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR49_B1585() uint32 {
	return (volatile.LoadUint32(&o.VCTR49.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR49_B1586(value uint32) {
	volatile.StoreUint32(&o.VCTR49.Reg, volatile.LoadUint32(&o.VCTR49.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR49_B1586() uint32 {
	return (volatile.LoadUint32(&o.VCTR49.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR49_B1587(value uint32) {
	volatile.StoreUint32(&o.VCTR49.Reg, volatile.LoadUint32(&o.VCTR49.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR49_B1587() uint32 {
	return (volatile.LoadUint32(&o.VCTR49.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR49_B1588(value uint32) {
	volatile.StoreUint32(&o.VCTR49.Reg, volatile.LoadUint32(&o.VCTR49.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR49_B1588() uint32 {
	return (volatile.LoadUint32(&o.VCTR49.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR49_B1589(value uint32) {
	volatile.StoreUint32(&o.VCTR49.Reg, volatile.LoadUint32(&o.VCTR49.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR49_B1589() uint32 {
	return (volatile.LoadUint32(&o.VCTR49.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR49_B1590(value uint32) {
	volatile.StoreUint32(&o.VCTR49.Reg, volatile.LoadUint32(&o.VCTR49.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR49_B1590() uint32 {
	return (volatile.LoadUint32(&o.VCTR49.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR49_B1591(value uint32) {
	volatile.StoreUint32(&o.VCTR49.Reg, volatile.LoadUint32(&o.VCTR49.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR49_B1591() uint32 {
	return (volatile.LoadUint32(&o.VCTR49.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR49_B1592(value uint32) {
	volatile.StoreUint32(&o.VCTR49.Reg, volatile.LoadUint32(&o.VCTR49.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR49_B1592() uint32 {
	return (volatile.LoadUint32(&o.VCTR49.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR49_B1593(value uint32) {
	volatile.StoreUint32(&o.VCTR49.Reg, volatile.LoadUint32(&o.VCTR49.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR49_B1593() uint32 {
	return (volatile.LoadUint32(&o.VCTR49.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR49_B1594(value uint32) {
	volatile.StoreUint32(&o.VCTR49.Reg, volatile.LoadUint32(&o.VCTR49.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR49_B1594() uint32 {
	return (volatile.LoadUint32(&o.VCTR49.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR49_B1595(value uint32) {
	volatile.StoreUint32(&o.VCTR49.Reg, volatile.LoadUint32(&o.VCTR49.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR49_B1595() uint32 {
	return (volatile.LoadUint32(&o.VCTR49.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR49_B1596(value uint32) {
	volatile.StoreUint32(&o.VCTR49.Reg, volatile.LoadUint32(&o.VCTR49.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR49_B1596() uint32 {
	return (volatile.LoadUint32(&o.VCTR49.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR49_B1597(value uint32) {
	volatile.StoreUint32(&o.VCTR49.Reg, volatile.LoadUint32(&o.VCTR49.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR49_B1597() uint32 {
	return (volatile.LoadUint32(&o.VCTR49.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR49_B1598(value uint32) {
	volatile.StoreUint32(&o.VCTR49.Reg, volatile.LoadUint32(&o.VCTR49.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR49_B1598() uint32 {
	return (volatile.LoadUint32(&o.VCTR49.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR49_B1599(value uint32) {
	volatile.StoreUint32(&o.VCTR49.Reg, volatile.LoadUint32(&o.VCTR49.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR49_B1599() uint32 {
	return (volatile.LoadUint32(&o.VCTR49.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR50: MPCBBx vector register
func (o *GTZC_Type) SetVCTR50_B1600(value uint32) {
	volatile.StoreUint32(&o.VCTR50.Reg, volatile.LoadUint32(&o.VCTR50.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR50_B1600() uint32 {
	return volatile.LoadUint32(&o.VCTR50.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR50_B1601(value uint32) {
	volatile.StoreUint32(&o.VCTR50.Reg, volatile.LoadUint32(&o.VCTR50.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR50_B1601() uint32 {
	return (volatile.LoadUint32(&o.VCTR50.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR50_B1602(value uint32) {
	volatile.StoreUint32(&o.VCTR50.Reg, volatile.LoadUint32(&o.VCTR50.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR50_B1602() uint32 {
	return (volatile.LoadUint32(&o.VCTR50.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR50_B1603(value uint32) {
	volatile.StoreUint32(&o.VCTR50.Reg, volatile.LoadUint32(&o.VCTR50.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR50_B1603() uint32 {
	return (volatile.LoadUint32(&o.VCTR50.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR50_B1604(value uint32) {
	volatile.StoreUint32(&o.VCTR50.Reg, volatile.LoadUint32(&o.VCTR50.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR50_B1604() uint32 {
	return (volatile.LoadUint32(&o.VCTR50.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR50_B1605(value uint32) {
	volatile.StoreUint32(&o.VCTR50.Reg, volatile.LoadUint32(&o.VCTR50.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR50_B1605() uint32 {
	return (volatile.LoadUint32(&o.VCTR50.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR50_B1606(value uint32) {
	volatile.StoreUint32(&o.VCTR50.Reg, volatile.LoadUint32(&o.VCTR50.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR50_B1606() uint32 {
	return (volatile.LoadUint32(&o.VCTR50.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR50_B1607(value uint32) {
	volatile.StoreUint32(&o.VCTR50.Reg, volatile.LoadUint32(&o.VCTR50.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR50_B1607() uint32 {
	return (volatile.LoadUint32(&o.VCTR50.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR50_B1608(value uint32) {
	volatile.StoreUint32(&o.VCTR50.Reg, volatile.LoadUint32(&o.VCTR50.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR50_B1608() uint32 {
	return (volatile.LoadUint32(&o.VCTR50.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR50_B1609(value uint32) {
	volatile.StoreUint32(&o.VCTR50.Reg, volatile.LoadUint32(&o.VCTR50.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR50_B1609() uint32 {
	return (volatile.LoadUint32(&o.VCTR50.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR50_B1610(value uint32) {
	volatile.StoreUint32(&o.VCTR50.Reg, volatile.LoadUint32(&o.VCTR50.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR50_B1610() uint32 {
	return (volatile.LoadUint32(&o.VCTR50.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR50_B1611(value uint32) {
	volatile.StoreUint32(&o.VCTR50.Reg, volatile.LoadUint32(&o.VCTR50.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR50_B1611() uint32 {
	return (volatile.LoadUint32(&o.VCTR50.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR50_B1612(value uint32) {
	volatile.StoreUint32(&o.VCTR50.Reg, volatile.LoadUint32(&o.VCTR50.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR50_B1612() uint32 {
	return (volatile.LoadUint32(&o.VCTR50.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR50_B1613(value uint32) {
	volatile.StoreUint32(&o.VCTR50.Reg, volatile.LoadUint32(&o.VCTR50.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR50_B1613() uint32 {
	return (volatile.LoadUint32(&o.VCTR50.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR50_B1614(value uint32) {
	volatile.StoreUint32(&o.VCTR50.Reg, volatile.LoadUint32(&o.VCTR50.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR50_B1614() uint32 {
	return (volatile.LoadUint32(&o.VCTR50.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR50_B1615(value uint32) {
	volatile.StoreUint32(&o.VCTR50.Reg, volatile.LoadUint32(&o.VCTR50.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR50_B1615() uint32 {
	return (volatile.LoadUint32(&o.VCTR50.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR50_B1616(value uint32) {
	volatile.StoreUint32(&o.VCTR50.Reg, volatile.LoadUint32(&o.VCTR50.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR50_B1616() uint32 {
	return (volatile.LoadUint32(&o.VCTR50.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR50_B1617(value uint32) {
	volatile.StoreUint32(&o.VCTR50.Reg, volatile.LoadUint32(&o.VCTR50.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR50_B1617() uint32 {
	return (volatile.LoadUint32(&o.VCTR50.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR50_B1618(value uint32) {
	volatile.StoreUint32(&o.VCTR50.Reg, volatile.LoadUint32(&o.VCTR50.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR50_B1618() uint32 {
	return (volatile.LoadUint32(&o.VCTR50.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR50_B1619(value uint32) {
	volatile.StoreUint32(&o.VCTR50.Reg, volatile.LoadUint32(&o.VCTR50.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR50_B1619() uint32 {
	return (volatile.LoadUint32(&o.VCTR50.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR50_B1620(value uint32) {
	volatile.StoreUint32(&o.VCTR50.Reg, volatile.LoadUint32(&o.VCTR50.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR50_B1620() uint32 {
	return (volatile.LoadUint32(&o.VCTR50.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR50_B1621(value uint32) {
	volatile.StoreUint32(&o.VCTR50.Reg, volatile.LoadUint32(&o.VCTR50.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR50_B1621() uint32 {
	return (volatile.LoadUint32(&o.VCTR50.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR50_B1622(value uint32) {
	volatile.StoreUint32(&o.VCTR50.Reg, volatile.LoadUint32(&o.VCTR50.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR50_B1622() uint32 {
	return (volatile.LoadUint32(&o.VCTR50.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR50_B1623(value uint32) {
	volatile.StoreUint32(&o.VCTR50.Reg, volatile.LoadUint32(&o.VCTR50.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR50_B1623() uint32 {
	return (volatile.LoadUint32(&o.VCTR50.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR50_B1624(value uint32) {
	volatile.StoreUint32(&o.VCTR50.Reg, volatile.LoadUint32(&o.VCTR50.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR50_B1624() uint32 {
	return (volatile.LoadUint32(&o.VCTR50.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR50_B1625(value uint32) {
	volatile.StoreUint32(&o.VCTR50.Reg, volatile.LoadUint32(&o.VCTR50.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR50_B1625() uint32 {
	return (volatile.LoadUint32(&o.VCTR50.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR50_B1626(value uint32) {
	volatile.StoreUint32(&o.VCTR50.Reg, volatile.LoadUint32(&o.VCTR50.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR50_B1626() uint32 {
	return (volatile.LoadUint32(&o.VCTR50.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR50_B1627(value uint32) {
	volatile.StoreUint32(&o.VCTR50.Reg, volatile.LoadUint32(&o.VCTR50.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR50_B1627() uint32 {
	return (volatile.LoadUint32(&o.VCTR50.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR50_B1628(value uint32) {
	volatile.StoreUint32(&o.VCTR50.Reg, volatile.LoadUint32(&o.VCTR50.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR50_B1628() uint32 {
	return (volatile.LoadUint32(&o.VCTR50.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR50_B1629(value uint32) {
	volatile.StoreUint32(&o.VCTR50.Reg, volatile.LoadUint32(&o.VCTR50.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR50_B1629() uint32 {
	return (volatile.LoadUint32(&o.VCTR50.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR50_B1630(value uint32) {
	volatile.StoreUint32(&o.VCTR50.Reg, volatile.LoadUint32(&o.VCTR50.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR50_B1630() uint32 {
	return (volatile.LoadUint32(&o.VCTR50.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR50_B1631(value uint32) {
	volatile.StoreUint32(&o.VCTR50.Reg, volatile.LoadUint32(&o.VCTR50.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR50_B1631() uint32 {
	return (volatile.LoadUint32(&o.VCTR50.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR51: MPCBBx vector register
func (o *GTZC_Type) SetVCTR51_B1632(value uint32) {
	volatile.StoreUint32(&o.VCTR51.Reg, volatile.LoadUint32(&o.VCTR51.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR51_B1632() uint32 {
	return volatile.LoadUint32(&o.VCTR51.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR51_B1633(value uint32) {
	volatile.StoreUint32(&o.VCTR51.Reg, volatile.LoadUint32(&o.VCTR51.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR51_B1633() uint32 {
	return (volatile.LoadUint32(&o.VCTR51.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR51_B1634(value uint32) {
	volatile.StoreUint32(&o.VCTR51.Reg, volatile.LoadUint32(&o.VCTR51.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR51_B1634() uint32 {
	return (volatile.LoadUint32(&o.VCTR51.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR51_B1635(value uint32) {
	volatile.StoreUint32(&o.VCTR51.Reg, volatile.LoadUint32(&o.VCTR51.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR51_B1635() uint32 {
	return (volatile.LoadUint32(&o.VCTR51.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR51_B1636(value uint32) {
	volatile.StoreUint32(&o.VCTR51.Reg, volatile.LoadUint32(&o.VCTR51.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR51_B1636() uint32 {
	return (volatile.LoadUint32(&o.VCTR51.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR51_B1637(value uint32) {
	volatile.StoreUint32(&o.VCTR51.Reg, volatile.LoadUint32(&o.VCTR51.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR51_B1637() uint32 {
	return (volatile.LoadUint32(&o.VCTR51.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR51_B1638(value uint32) {
	volatile.StoreUint32(&o.VCTR51.Reg, volatile.LoadUint32(&o.VCTR51.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR51_B1638() uint32 {
	return (volatile.LoadUint32(&o.VCTR51.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR51_B1639(value uint32) {
	volatile.StoreUint32(&o.VCTR51.Reg, volatile.LoadUint32(&o.VCTR51.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR51_B1639() uint32 {
	return (volatile.LoadUint32(&o.VCTR51.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR51_B1640(value uint32) {
	volatile.StoreUint32(&o.VCTR51.Reg, volatile.LoadUint32(&o.VCTR51.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR51_B1640() uint32 {
	return (volatile.LoadUint32(&o.VCTR51.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR51_B1641(value uint32) {
	volatile.StoreUint32(&o.VCTR51.Reg, volatile.LoadUint32(&o.VCTR51.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR51_B1641() uint32 {
	return (volatile.LoadUint32(&o.VCTR51.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR51_B1642(value uint32) {
	volatile.StoreUint32(&o.VCTR51.Reg, volatile.LoadUint32(&o.VCTR51.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR51_B1642() uint32 {
	return (volatile.LoadUint32(&o.VCTR51.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR51_B1643(value uint32) {
	volatile.StoreUint32(&o.VCTR51.Reg, volatile.LoadUint32(&o.VCTR51.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR51_B1643() uint32 {
	return (volatile.LoadUint32(&o.VCTR51.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR51_B1644(value uint32) {
	volatile.StoreUint32(&o.VCTR51.Reg, volatile.LoadUint32(&o.VCTR51.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR51_B1644() uint32 {
	return (volatile.LoadUint32(&o.VCTR51.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR51_B1645(value uint32) {
	volatile.StoreUint32(&o.VCTR51.Reg, volatile.LoadUint32(&o.VCTR51.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR51_B1645() uint32 {
	return (volatile.LoadUint32(&o.VCTR51.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR51_B1646(value uint32) {
	volatile.StoreUint32(&o.VCTR51.Reg, volatile.LoadUint32(&o.VCTR51.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR51_B1646() uint32 {
	return (volatile.LoadUint32(&o.VCTR51.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR51_B1647(value uint32) {
	volatile.StoreUint32(&o.VCTR51.Reg, volatile.LoadUint32(&o.VCTR51.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR51_B1647() uint32 {
	return (volatile.LoadUint32(&o.VCTR51.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR51_B1648(value uint32) {
	volatile.StoreUint32(&o.VCTR51.Reg, volatile.LoadUint32(&o.VCTR51.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR51_B1648() uint32 {
	return (volatile.LoadUint32(&o.VCTR51.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR51_B1649(value uint32) {
	volatile.StoreUint32(&o.VCTR51.Reg, volatile.LoadUint32(&o.VCTR51.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR51_B1649() uint32 {
	return (volatile.LoadUint32(&o.VCTR51.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR51_B1650(value uint32) {
	volatile.StoreUint32(&o.VCTR51.Reg, volatile.LoadUint32(&o.VCTR51.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR51_B1650() uint32 {
	return (volatile.LoadUint32(&o.VCTR51.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR51_B1651(value uint32) {
	volatile.StoreUint32(&o.VCTR51.Reg, volatile.LoadUint32(&o.VCTR51.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR51_B1651() uint32 {
	return (volatile.LoadUint32(&o.VCTR51.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR51_B1652(value uint32) {
	volatile.StoreUint32(&o.VCTR51.Reg, volatile.LoadUint32(&o.VCTR51.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR51_B1652() uint32 {
	return (volatile.LoadUint32(&o.VCTR51.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR51_B1653(value uint32) {
	volatile.StoreUint32(&o.VCTR51.Reg, volatile.LoadUint32(&o.VCTR51.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR51_B1653() uint32 {
	return (volatile.LoadUint32(&o.VCTR51.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR51_B1654(value uint32) {
	volatile.StoreUint32(&o.VCTR51.Reg, volatile.LoadUint32(&o.VCTR51.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR51_B1654() uint32 {
	return (volatile.LoadUint32(&o.VCTR51.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR51_B1655(value uint32) {
	volatile.StoreUint32(&o.VCTR51.Reg, volatile.LoadUint32(&o.VCTR51.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR51_B1655() uint32 {
	return (volatile.LoadUint32(&o.VCTR51.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR51_B1656(value uint32) {
	volatile.StoreUint32(&o.VCTR51.Reg, volatile.LoadUint32(&o.VCTR51.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR51_B1656() uint32 {
	return (volatile.LoadUint32(&o.VCTR51.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR51_B1657(value uint32) {
	volatile.StoreUint32(&o.VCTR51.Reg, volatile.LoadUint32(&o.VCTR51.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR51_B1657() uint32 {
	return (volatile.LoadUint32(&o.VCTR51.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR51_B1658(value uint32) {
	volatile.StoreUint32(&o.VCTR51.Reg, volatile.LoadUint32(&o.VCTR51.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR51_B1658() uint32 {
	return (volatile.LoadUint32(&o.VCTR51.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR51_B1659(value uint32) {
	volatile.StoreUint32(&o.VCTR51.Reg, volatile.LoadUint32(&o.VCTR51.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR51_B1659() uint32 {
	return (volatile.LoadUint32(&o.VCTR51.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR51_B1660(value uint32) {
	volatile.StoreUint32(&o.VCTR51.Reg, volatile.LoadUint32(&o.VCTR51.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR51_B1660() uint32 {
	return (volatile.LoadUint32(&o.VCTR51.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR51_B1661(value uint32) {
	volatile.StoreUint32(&o.VCTR51.Reg, volatile.LoadUint32(&o.VCTR51.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR51_B1661() uint32 {
	return (volatile.LoadUint32(&o.VCTR51.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR51_B1662(value uint32) {
	volatile.StoreUint32(&o.VCTR51.Reg, volatile.LoadUint32(&o.VCTR51.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR51_B1662() uint32 {
	return (volatile.LoadUint32(&o.VCTR51.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR51_B1663(value uint32) {
	volatile.StoreUint32(&o.VCTR51.Reg, volatile.LoadUint32(&o.VCTR51.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR51_B1663() uint32 {
	return (volatile.LoadUint32(&o.VCTR51.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR52: MPCBBx vector register
func (o *GTZC_Type) SetVCTR52_B1664(value uint32) {
	volatile.StoreUint32(&o.VCTR52.Reg, volatile.LoadUint32(&o.VCTR52.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR52_B1664() uint32 {
	return volatile.LoadUint32(&o.VCTR52.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR52_B1665(value uint32) {
	volatile.StoreUint32(&o.VCTR52.Reg, volatile.LoadUint32(&o.VCTR52.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR52_B1665() uint32 {
	return (volatile.LoadUint32(&o.VCTR52.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR52_B1666(value uint32) {
	volatile.StoreUint32(&o.VCTR52.Reg, volatile.LoadUint32(&o.VCTR52.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR52_B1666() uint32 {
	return (volatile.LoadUint32(&o.VCTR52.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR52_B1667(value uint32) {
	volatile.StoreUint32(&o.VCTR52.Reg, volatile.LoadUint32(&o.VCTR52.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR52_B1667() uint32 {
	return (volatile.LoadUint32(&o.VCTR52.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR52_B1668(value uint32) {
	volatile.StoreUint32(&o.VCTR52.Reg, volatile.LoadUint32(&o.VCTR52.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR52_B1668() uint32 {
	return (volatile.LoadUint32(&o.VCTR52.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR52_B1669(value uint32) {
	volatile.StoreUint32(&o.VCTR52.Reg, volatile.LoadUint32(&o.VCTR52.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR52_B1669() uint32 {
	return (volatile.LoadUint32(&o.VCTR52.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR52_B1670(value uint32) {
	volatile.StoreUint32(&o.VCTR52.Reg, volatile.LoadUint32(&o.VCTR52.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR52_B1670() uint32 {
	return (volatile.LoadUint32(&o.VCTR52.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR52_B1671(value uint32) {
	volatile.StoreUint32(&o.VCTR52.Reg, volatile.LoadUint32(&o.VCTR52.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR52_B1671() uint32 {
	return (volatile.LoadUint32(&o.VCTR52.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR52_B1672(value uint32) {
	volatile.StoreUint32(&o.VCTR52.Reg, volatile.LoadUint32(&o.VCTR52.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR52_B1672() uint32 {
	return (volatile.LoadUint32(&o.VCTR52.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR52_B1673(value uint32) {
	volatile.StoreUint32(&o.VCTR52.Reg, volatile.LoadUint32(&o.VCTR52.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR52_B1673() uint32 {
	return (volatile.LoadUint32(&o.VCTR52.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR52_B1674(value uint32) {
	volatile.StoreUint32(&o.VCTR52.Reg, volatile.LoadUint32(&o.VCTR52.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR52_B1674() uint32 {
	return (volatile.LoadUint32(&o.VCTR52.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR52_B1675(value uint32) {
	volatile.StoreUint32(&o.VCTR52.Reg, volatile.LoadUint32(&o.VCTR52.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR52_B1675() uint32 {
	return (volatile.LoadUint32(&o.VCTR52.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR52_B1676(value uint32) {
	volatile.StoreUint32(&o.VCTR52.Reg, volatile.LoadUint32(&o.VCTR52.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR52_B1676() uint32 {
	return (volatile.LoadUint32(&o.VCTR52.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR52_B1677(value uint32) {
	volatile.StoreUint32(&o.VCTR52.Reg, volatile.LoadUint32(&o.VCTR52.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR52_B1677() uint32 {
	return (volatile.LoadUint32(&o.VCTR52.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR52_B1678(value uint32) {
	volatile.StoreUint32(&o.VCTR52.Reg, volatile.LoadUint32(&o.VCTR52.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR52_B1678() uint32 {
	return (volatile.LoadUint32(&o.VCTR52.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR52_B1679(value uint32) {
	volatile.StoreUint32(&o.VCTR52.Reg, volatile.LoadUint32(&o.VCTR52.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR52_B1679() uint32 {
	return (volatile.LoadUint32(&o.VCTR52.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR52_B1680(value uint32) {
	volatile.StoreUint32(&o.VCTR52.Reg, volatile.LoadUint32(&o.VCTR52.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR52_B1680() uint32 {
	return (volatile.LoadUint32(&o.VCTR52.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR52_B1681(value uint32) {
	volatile.StoreUint32(&o.VCTR52.Reg, volatile.LoadUint32(&o.VCTR52.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR52_B1681() uint32 {
	return (volatile.LoadUint32(&o.VCTR52.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR52_B1682(value uint32) {
	volatile.StoreUint32(&o.VCTR52.Reg, volatile.LoadUint32(&o.VCTR52.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR52_B1682() uint32 {
	return (volatile.LoadUint32(&o.VCTR52.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR52_B1683(value uint32) {
	volatile.StoreUint32(&o.VCTR52.Reg, volatile.LoadUint32(&o.VCTR52.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR52_B1683() uint32 {
	return (volatile.LoadUint32(&o.VCTR52.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR52_B1684(value uint32) {
	volatile.StoreUint32(&o.VCTR52.Reg, volatile.LoadUint32(&o.VCTR52.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR52_B1684() uint32 {
	return (volatile.LoadUint32(&o.VCTR52.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR52_B1685(value uint32) {
	volatile.StoreUint32(&o.VCTR52.Reg, volatile.LoadUint32(&o.VCTR52.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR52_B1685() uint32 {
	return (volatile.LoadUint32(&o.VCTR52.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR52_B1686(value uint32) {
	volatile.StoreUint32(&o.VCTR52.Reg, volatile.LoadUint32(&o.VCTR52.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR52_B1686() uint32 {
	return (volatile.LoadUint32(&o.VCTR52.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR52_B1687(value uint32) {
	volatile.StoreUint32(&o.VCTR52.Reg, volatile.LoadUint32(&o.VCTR52.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR52_B1687() uint32 {
	return (volatile.LoadUint32(&o.VCTR52.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR52_B1688(value uint32) {
	volatile.StoreUint32(&o.VCTR52.Reg, volatile.LoadUint32(&o.VCTR52.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR52_B1688() uint32 {
	return (volatile.LoadUint32(&o.VCTR52.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR52_B1689(value uint32) {
	volatile.StoreUint32(&o.VCTR52.Reg, volatile.LoadUint32(&o.VCTR52.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR52_B1689() uint32 {
	return (volatile.LoadUint32(&o.VCTR52.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR52_B1690(value uint32) {
	volatile.StoreUint32(&o.VCTR52.Reg, volatile.LoadUint32(&o.VCTR52.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR52_B1690() uint32 {
	return (volatile.LoadUint32(&o.VCTR52.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR52_B1691(value uint32) {
	volatile.StoreUint32(&o.VCTR52.Reg, volatile.LoadUint32(&o.VCTR52.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR52_B1691() uint32 {
	return (volatile.LoadUint32(&o.VCTR52.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR52_B1692(value uint32) {
	volatile.StoreUint32(&o.VCTR52.Reg, volatile.LoadUint32(&o.VCTR52.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR52_B1692() uint32 {
	return (volatile.LoadUint32(&o.VCTR52.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR52_B1693(value uint32) {
	volatile.StoreUint32(&o.VCTR52.Reg, volatile.LoadUint32(&o.VCTR52.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR52_B1693() uint32 {
	return (volatile.LoadUint32(&o.VCTR52.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR52_B1694(value uint32) {
	volatile.StoreUint32(&o.VCTR52.Reg, volatile.LoadUint32(&o.VCTR52.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR52_B1694() uint32 {
	return (volatile.LoadUint32(&o.VCTR52.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR52_B1695(value uint32) {
	volatile.StoreUint32(&o.VCTR52.Reg, volatile.LoadUint32(&o.VCTR52.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR52_B1695() uint32 {
	return (volatile.LoadUint32(&o.VCTR52.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR53: MPCBBx vector register
func (o *GTZC_Type) SetVCTR53_B1696(value uint32) {
	volatile.StoreUint32(&o.VCTR53.Reg, volatile.LoadUint32(&o.VCTR53.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR53_B1696() uint32 {
	return volatile.LoadUint32(&o.VCTR53.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR53_B1697(value uint32) {
	volatile.StoreUint32(&o.VCTR53.Reg, volatile.LoadUint32(&o.VCTR53.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR53_B1697() uint32 {
	return (volatile.LoadUint32(&o.VCTR53.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR53_B1698(value uint32) {
	volatile.StoreUint32(&o.VCTR53.Reg, volatile.LoadUint32(&o.VCTR53.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR53_B1698() uint32 {
	return (volatile.LoadUint32(&o.VCTR53.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR53_B1699(value uint32) {
	volatile.StoreUint32(&o.VCTR53.Reg, volatile.LoadUint32(&o.VCTR53.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR53_B1699() uint32 {
	return (volatile.LoadUint32(&o.VCTR53.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR53_B1700(value uint32) {
	volatile.StoreUint32(&o.VCTR53.Reg, volatile.LoadUint32(&o.VCTR53.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR53_B1700() uint32 {
	return (volatile.LoadUint32(&o.VCTR53.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR53_B1701(value uint32) {
	volatile.StoreUint32(&o.VCTR53.Reg, volatile.LoadUint32(&o.VCTR53.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR53_B1701() uint32 {
	return (volatile.LoadUint32(&o.VCTR53.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR53_B1702(value uint32) {
	volatile.StoreUint32(&o.VCTR53.Reg, volatile.LoadUint32(&o.VCTR53.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR53_B1702() uint32 {
	return (volatile.LoadUint32(&o.VCTR53.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR53_B1703(value uint32) {
	volatile.StoreUint32(&o.VCTR53.Reg, volatile.LoadUint32(&o.VCTR53.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR53_B1703() uint32 {
	return (volatile.LoadUint32(&o.VCTR53.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR53_B1704(value uint32) {
	volatile.StoreUint32(&o.VCTR53.Reg, volatile.LoadUint32(&o.VCTR53.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR53_B1704() uint32 {
	return (volatile.LoadUint32(&o.VCTR53.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR53_B1705(value uint32) {
	volatile.StoreUint32(&o.VCTR53.Reg, volatile.LoadUint32(&o.VCTR53.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR53_B1705() uint32 {
	return (volatile.LoadUint32(&o.VCTR53.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR53_B1706(value uint32) {
	volatile.StoreUint32(&o.VCTR53.Reg, volatile.LoadUint32(&o.VCTR53.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR53_B1706() uint32 {
	return (volatile.LoadUint32(&o.VCTR53.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR53_B1707(value uint32) {
	volatile.StoreUint32(&o.VCTR53.Reg, volatile.LoadUint32(&o.VCTR53.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR53_B1707() uint32 {
	return (volatile.LoadUint32(&o.VCTR53.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR53_B1708(value uint32) {
	volatile.StoreUint32(&o.VCTR53.Reg, volatile.LoadUint32(&o.VCTR53.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR53_B1708() uint32 {
	return (volatile.LoadUint32(&o.VCTR53.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR53_B1709(value uint32) {
	volatile.StoreUint32(&o.VCTR53.Reg, volatile.LoadUint32(&o.VCTR53.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR53_B1709() uint32 {
	return (volatile.LoadUint32(&o.VCTR53.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR53_B1710(value uint32) {
	volatile.StoreUint32(&o.VCTR53.Reg, volatile.LoadUint32(&o.VCTR53.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR53_B1710() uint32 {
	return (volatile.LoadUint32(&o.VCTR53.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR53_B1711(value uint32) {
	volatile.StoreUint32(&o.VCTR53.Reg, volatile.LoadUint32(&o.VCTR53.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR53_B1711() uint32 {
	return (volatile.LoadUint32(&o.VCTR53.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR53_B1712(value uint32) {
	volatile.StoreUint32(&o.VCTR53.Reg, volatile.LoadUint32(&o.VCTR53.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR53_B1712() uint32 {
	return (volatile.LoadUint32(&o.VCTR53.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR53_B1713(value uint32) {
	volatile.StoreUint32(&o.VCTR53.Reg, volatile.LoadUint32(&o.VCTR53.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR53_B1713() uint32 {
	return (volatile.LoadUint32(&o.VCTR53.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR53_B1714(value uint32) {
	volatile.StoreUint32(&o.VCTR53.Reg, volatile.LoadUint32(&o.VCTR53.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR53_B1714() uint32 {
	return (volatile.LoadUint32(&o.VCTR53.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR53_B1715(value uint32) {
	volatile.StoreUint32(&o.VCTR53.Reg, volatile.LoadUint32(&o.VCTR53.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR53_B1715() uint32 {
	return (volatile.LoadUint32(&o.VCTR53.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR53_B1716(value uint32) {
	volatile.StoreUint32(&o.VCTR53.Reg, volatile.LoadUint32(&o.VCTR53.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR53_B1716() uint32 {
	return (volatile.LoadUint32(&o.VCTR53.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR53_B1717(value uint32) {
	volatile.StoreUint32(&o.VCTR53.Reg, volatile.LoadUint32(&o.VCTR53.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR53_B1717() uint32 {
	return (volatile.LoadUint32(&o.VCTR53.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR53_B1718(value uint32) {
	volatile.StoreUint32(&o.VCTR53.Reg, volatile.LoadUint32(&o.VCTR53.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR53_B1718() uint32 {
	return (volatile.LoadUint32(&o.VCTR53.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR53_B1719(value uint32) {
	volatile.StoreUint32(&o.VCTR53.Reg, volatile.LoadUint32(&o.VCTR53.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR53_B1719() uint32 {
	return (volatile.LoadUint32(&o.VCTR53.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR53_B1720(value uint32) {
	volatile.StoreUint32(&o.VCTR53.Reg, volatile.LoadUint32(&o.VCTR53.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR53_B1720() uint32 {
	return (volatile.LoadUint32(&o.VCTR53.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR53_B1721(value uint32) {
	volatile.StoreUint32(&o.VCTR53.Reg, volatile.LoadUint32(&o.VCTR53.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR53_B1721() uint32 {
	return (volatile.LoadUint32(&o.VCTR53.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR53_B1722(value uint32) {
	volatile.StoreUint32(&o.VCTR53.Reg, volatile.LoadUint32(&o.VCTR53.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR53_B1722() uint32 {
	return (volatile.LoadUint32(&o.VCTR53.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR53_B1723(value uint32) {
	volatile.StoreUint32(&o.VCTR53.Reg, volatile.LoadUint32(&o.VCTR53.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR53_B1723() uint32 {
	return (volatile.LoadUint32(&o.VCTR53.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR53_B1724(value uint32) {
	volatile.StoreUint32(&o.VCTR53.Reg, volatile.LoadUint32(&o.VCTR53.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR53_B1724() uint32 {
	return (volatile.LoadUint32(&o.VCTR53.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR53_B1725(value uint32) {
	volatile.StoreUint32(&o.VCTR53.Reg, volatile.LoadUint32(&o.VCTR53.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR53_B1725() uint32 {
	return (volatile.LoadUint32(&o.VCTR53.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR53_B1726(value uint32) {
	volatile.StoreUint32(&o.VCTR53.Reg, volatile.LoadUint32(&o.VCTR53.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR53_B1726() uint32 {
	return (volatile.LoadUint32(&o.VCTR53.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR53_B1727(value uint32) {
	volatile.StoreUint32(&o.VCTR53.Reg, volatile.LoadUint32(&o.VCTR53.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR53_B1727() uint32 {
	return (volatile.LoadUint32(&o.VCTR53.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR54: MPCBBx vector register
func (o *GTZC_Type) SetVCTR54_B1728(value uint32) {
	volatile.StoreUint32(&o.VCTR54.Reg, volatile.LoadUint32(&o.VCTR54.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR54_B1728() uint32 {
	return volatile.LoadUint32(&o.VCTR54.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR54_B1729(value uint32) {
	volatile.StoreUint32(&o.VCTR54.Reg, volatile.LoadUint32(&o.VCTR54.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR54_B1729() uint32 {
	return (volatile.LoadUint32(&o.VCTR54.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR54_B1730(value uint32) {
	volatile.StoreUint32(&o.VCTR54.Reg, volatile.LoadUint32(&o.VCTR54.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR54_B1730() uint32 {
	return (volatile.LoadUint32(&o.VCTR54.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR54_B1731(value uint32) {
	volatile.StoreUint32(&o.VCTR54.Reg, volatile.LoadUint32(&o.VCTR54.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR54_B1731() uint32 {
	return (volatile.LoadUint32(&o.VCTR54.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR54_B1732(value uint32) {
	volatile.StoreUint32(&o.VCTR54.Reg, volatile.LoadUint32(&o.VCTR54.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR54_B1732() uint32 {
	return (volatile.LoadUint32(&o.VCTR54.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR54_B1733(value uint32) {
	volatile.StoreUint32(&o.VCTR54.Reg, volatile.LoadUint32(&o.VCTR54.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR54_B1733() uint32 {
	return (volatile.LoadUint32(&o.VCTR54.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR54_B1734(value uint32) {
	volatile.StoreUint32(&o.VCTR54.Reg, volatile.LoadUint32(&o.VCTR54.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR54_B1734() uint32 {
	return (volatile.LoadUint32(&o.VCTR54.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR54_B1735(value uint32) {
	volatile.StoreUint32(&o.VCTR54.Reg, volatile.LoadUint32(&o.VCTR54.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR54_B1735() uint32 {
	return (volatile.LoadUint32(&o.VCTR54.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR54_B1736(value uint32) {
	volatile.StoreUint32(&o.VCTR54.Reg, volatile.LoadUint32(&o.VCTR54.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR54_B1736() uint32 {
	return (volatile.LoadUint32(&o.VCTR54.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR54_B1737(value uint32) {
	volatile.StoreUint32(&o.VCTR54.Reg, volatile.LoadUint32(&o.VCTR54.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR54_B1737() uint32 {
	return (volatile.LoadUint32(&o.VCTR54.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR54_B1738(value uint32) {
	volatile.StoreUint32(&o.VCTR54.Reg, volatile.LoadUint32(&o.VCTR54.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR54_B1738() uint32 {
	return (volatile.LoadUint32(&o.VCTR54.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR54_B1739(value uint32) {
	volatile.StoreUint32(&o.VCTR54.Reg, volatile.LoadUint32(&o.VCTR54.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR54_B1739() uint32 {
	return (volatile.LoadUint32(&o.VCTR54.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR54_B1740(value uint32) {
	volatile.StoreUint32(&o.VCTR54.Reg, volatile.LoadUint32(&o.VCTR54.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR54_B1740() uint32 {
	return (volatile.LoadUint32(&o.VCTR54.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR54_B1741(value uint32) {
	volatile.StoreUint32(&o.VCTR54.Reg, volatile.LoadUint32(&o.VCTR54.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR54_B1741() uint32 {
	return (volatile.LoadUint32(&o.VCTR54.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR54_B1742(value uint32) {
	volatile.StoreUint32(&o.VCTR54.Reg, volatile.LoadUint32(&o.VCTR54.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR54_B1742() uint32 {
	return (volatile.LoadUint32(&o.VCTR54.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR54_B1743(value uint32) {
	volatile.StoreUint32(&o.VCTR54.Reg, volatile.LoadUint32(&o.VCTR54.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR54_B1743() uint32 {
	return (volatile.LoadUint32(&o.VCTR54.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR54_B1744(value uint32) {
	volatile.StoreUint32(&o.VCTR54.Reg, volatile.LoadUint32(&o.VCTR54.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR54_B1744() uint32 {
	return (volatile.LoadUint32(&o.VCTR54.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR54_B1745(value uint32) {
	volatile.StoreUint32(&o.VCTR54.Reg, volatile.LoadUint32(&o.VCTR54.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR54_B1745() uint32 {
	return (volatile.LoadUint32(&o.VCTR54.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR54_B1746(value uint32) {
	volatile.StoreUint32(&o.VCTR54.Reg, volatile.LoadUint32(&o.VCTR54.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR54_B1746() uint32 {
	return (volatile.LoadUint32(&o.VCTR54.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR54_B1747(value uint32) {
	volatile.StoreUint32(&o.VCTR54.Reg, volatile.LoadUint32(&o.VCTR54.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR54_B1747() uint32 {
	return (volatile.LoadUint32(&o.VCTR54.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR54_B1748(value uint32) {
	volatile.StoreUint32(&o.VCTR54.Reg, volatile.LoadUint32(&o.VCTR54.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR54_B1748() uint32 {
	return (volatile.LoadUint32(&o.VCTR54.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR54_B1749(value uint32) {
	volatile.StoreUint32(&o.VCTR54.Reg, volatile.LoadUint32(&o.VCTR54.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR54_B1749() uint32 {
	return (volatile.LoadUint32(&o.VCTR54.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR54_B1750(value uint32) {
	volatile.StoreUint32(&o.VCTR54.Reg, volatile.LoadUint32(&o.VCTR54.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR54_B1750() uint32 {
	return (volatile.LoadUint32(&o.VCTR54.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR54_B1751(value uint32) {
	volatile.StoreUint32(&o.VCTR54.Reg, volatile.LoadUint32(&o.VCTR54.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR54_B1751() uint32 {
	return (volatile.LoadUint32(&o.VCTR54.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR54_B1752(value uint32) {
	volatile.StoreUint32(&o.VCTR54.Reg, volatile.LoadUint32(&o.VCTR54.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR54_B1752() uint32 {
	return (volatile.LoadUint32(&o.VCTR54.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR54_B1753(value uint32) {
	volatile.StoreUint32(&o.VCTR54.Reg, volatile.LoadUint32(&o.VCTR54.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR54_B1753() uint32 {
	return (volatile.LoadUint32(&o.VCTR54.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR54_B1754(value uint32) {
	volatile.StoreUint32(&o.VCTR54.Reg, volatile.LoadUint32(&o.VCTR54.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR54_B1754() uint32 {
	return (volatile.LoadUint32(&o.VCTR54.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR54_B1755(value uint32) {
	volatile.StoreUint32(&o.VCTR54.Reg, volatile.LoadUint32(&o.VCTR54.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR54_B1755() uint32 {
	return (volatile.LoadUint32(&o.VCTR54.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR54_B1756(value uint32) {
	volatile.StoreUint32(&o.VCTR54.Reg, volatile.LoadUint32(&o.VCTR54.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR54_B1756() uint32 {
	return (volatile.LoadUint32(&o.VCTR54.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR54_B1757(value uint32) {
	volatile.StoreUint32(&o.VCTR54.Reg, volatile.LoadUint32(&o.VCTR54.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR54_B1757() uint32 {
	return (volatile.LoadUint32(&o.VCTR54.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR54_B1758(value uint32) {
	volatile.StoreUint32(&o.VCTR54.Reg, volatile.LoadUint32(&o.VCTR54.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR54_B1758() uint32 {
	return (volatile.LoadUint32(&o.VCTR54.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR54_B1759(value uint32) {
	volatile.StoreUint32(&o.VCTR54.Reg, volatile.LoadUint32(&o.VCTR54.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR54_B1759() uint32 {
	return (volatile.LoadUint32(&o.VCTR54.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR55: MPCBBx vector register
func (o *GTZC_Type) SetVCTR55_B1760(value uint32) {
	volatile.StoreUint32(&o.VCTR55.Reg, volatile.LoadUint32(&o.VCTR55.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR55_B1760() uint32 {
	return volatile.LoadUint32(&o.VCTR55.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR55_B1761(value uint32) {
	volatile.StoreUint32(&o.VCTR55.Reg, volatile.LoadUint32(&o.VCTR55.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR55_B1761() uint32 {
	return (volatile.LoadUint32(&o.VCTR55.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR55_B1762(value uint32) {
	volatile.StoreUint32(&o.VCTR55.Reg, volatile.LoadUint32(&o.VCTR55.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR55_B1762() uint32 {
	return (volatile.LoadUint32(&o.VCTR55.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR55_B1763(value uint32) {
	volatile.StoreUint32(&o.VCTR55.Reg, volatile.LoadUint32(&o.VCTR55.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR55_B1763() uint32 {
	return (volatile.LoadUint32(&o.VCTR55.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR55_B1764(value uint32) {
	volatile.StoreUint32(&o.VCTR55.Reg, volatile.LoadUint32(&o.VCTR55.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR55_B1764() uint32 {
	return (volatile.LoadUint32(&o.VCTR55.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR55_B1765(value uint32) {
	volatile.StoreUint32(&o.VCTR55.Reg, volatile.LoadUint32(&o.VCTR55.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR55_B1765() uint32 {
	return (volatile.LoadUint32(&o.VCTR55.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR55_B1766(value uint32) {
	volatile.StoreUint32(&o.VCTR55.Reg, volatile.LoadUint32(&o.VCTR55.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR55_B1766() uint32 {
	return (volatile.LoadUint32(&o.VCTR55.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR55_B1767(value uint32) {
	volatile.StoreUint32(&o.VCTR55.Reg, volatile.LoadUint32(&o.VCTR55.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR55_B1767() uint32 {
	return (volatile.LoadUint32(&o.VCTR55.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR55_B1768(value uint32) {
	volatile.StoreUint32(&o.VCTR55.Reg, volatile.LoadUint32(&o.VCTR55.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR55_B1768() uint32 {
	return (volatile.LoadUint32(&o.VCTR55.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR55_B1769(value uint32) {
	volatile.StoreUint32(&o.VCTR55.Reg, volatile.LoadUint32(&o.VCTR55.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR55_B1769() uint32 {
	return (volatile.LoadUint32(&o.VCTR55.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR55_B1770(value uint32) {
	volatile.StoreUint32(&o.VCTR55.Reg, volatile.LoadUint32(&o.VCTR55.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR55_B1770() uint32 {
	return (volatile.LoadUint32(&o.VCTR55.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR55_B1771(value uint32) {
	volatile.StoreUint32(&o.VCTR55.Reg, volatile.LoadUint32(&o.VCTR55.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR55_B1771() uint32 {
	return (volatile.LoadUint32(&o.VCTR55.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR55_B1772(value uint32) {
	volatile.StoreUint32(&o.VCTR55.Reg, volatile.LoadUint32(&o.VCTR55.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR55_B1772() uint32 {
	return (volatile.LoadUint32(&o.VCTR55.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR55_B1773(value uint32) {
	volatile.StoreUint32(&o.VCTR55.Reg, volatile.LoadUint32(&o.VCTR55.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR55_B1773() uint32 {
	return (volatile.LoadUint32(&o.VCTR55.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR55_B1774(value uint32) {
	volatile.StoreUint32(&o.VCTR55.Reg, volatile.LoadUint32(&o.VCTR55.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR55_B1774() uint32 {
	return (volatile.LoadUint32(&o.VCTR55.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR55_B1775(value uint32) {
	volatile.StoreUint32(&o.VCTR55.Reg, volatile.LoadUint32(&o.VCTR55.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR55_B1775() uint32 {
	return (volatile.LoadUint32(&o.VCTR55.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR55_B1776(value uint32) {
	volatile.StoreUint32(&o.VCTR55.Reg, volatile.LoadUint32(&o.VCTR55.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR55_B1776() uint32 {
	return (volatile.LoadUint32(&o.VCTR55.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR55_B1777(value uint32) {
	volatile.StoreUint32(&o.VCTR55.Reg, volatile.LoadUint32(&o.VCTR55.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR55_B1777() uint32 {
	return (volatile.LoadUint32(&o.VCTR55.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR55_B1778(value uint32) {
	volatile.StoreUint32(&o.VCTR55.Reg, volatile.LoadUint32(&o.VCTR55.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR55_B1778() uint32 {
	return (volatile.LoadUint32(&o.VCTR55.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR55_B1779(value uint32) {
	volatile.StoreUint32(&o.VCTR55.Reg, volatile.LoadUint32(&o.VCTR55.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR55_B1779() uint32 {
	return (volatile.LoadUint32(&o.VCTR55.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR55_B1780(value uint32) {
	volatile.StoreUint32(&o.VCTR55.Reg, volatile.LoadUint32(&o.VCTR55.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR55_B1780() uint32 {
	return (volatile.LoadUint32(&o.VCTR55.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR55_B1781(value uint32) {
	volatile.StoreUint32(&o.VCTR55.Reg, volatile.LoadUint32(&o.VCTR55.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR55_B1781() uint32 {
	return (volatile.LoadUint32(&o.VCTR55.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR55_B1782(value uint32) {
	volatile.StoreUint32(&o.VCTR55.Reg, volatile.LoadUint32(&o.VCTR55.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR55_B1782() uint32 {
	return (volatile.LoadUint32(&o.VCTR55.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR55_B1783(value uint32) {
	volatile.StoreUint32(&o.VCTR55.Reg, volatile.LoadUint32(&o.VCTR55.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR55_B1783() uint32 {
	return (volatile.LoadUint32(&o.VCTR55.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR55_B1784(value uint32) {
	volatile.StoreUint32(&o.VCTR55.Reg, volatile.LoadUint32(&o.VCTR55.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR55_B1784() uint32 {
	return (volatile.LoadUint32(&o.VCTR55.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR55_B1785(value uint32) {
	volatile.StoreUint32(&o.VCTR55.Reg, volatile.LoadUint32(&o.VCTR55.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR55_B1785() uint32 {
	return (volatile.LoadUint32(&o.VCTR55.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR55_B1786(value uint32) {
	volatile.StoreUint32(&o.VCTR55.Reg, volatile.LoadUint32(&o.VCTR55.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR55_B1786() uint32 {
	return (volatile.LoadUint32(&o.VCTR55.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR55_B1787(value uint32) {
	volatile.StoreUint32(&o.VCTR55.Reg, volatile.LoadUint32(&o.VCTR55.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR55_B1787() uint32 {
	return (volatile.LoadUint32(&o.VCTR55.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR55_B1788(value uint32) {
	volatile.StoreUint32(&o.VCTR55.Reg, volatile.LoadUint32(&o.VCTR55.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR55_B1788() uint32 {
	return (volatile.LoadUint32(&o.VCTR55.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR55_B1789(value uint32) {
	volatile.StoreUint32(&o.VCTR55.Reg, volatile.LoadUint32(&o.VCTR55.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR55_B1789() uint32 {
	return (volatile.LoadUint32(&o.VCTR55.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR55_B1790(value uint32) {
	volatile.StoreUint32(&o.VCTR55.Reg, volatile.LoadUint32(&o.VCTR55.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR55_B1790() uint32 {
	return (volatile.LoadUint32(&o.VCTR55.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR55_B1791(value uint32) {
	volatile.StoreUint32(&o.VCTR55.Reg, volatile.LoadUint32(&o.VCTR55.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR55_B1791() uint32 {
	return (volatile.LoadUint32(&o.VCTR55.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR56: MPCBBx vector register
func (o *GTZC_Type) SetVCTR56_B1792(value uint32) {
	volatile.StoreUint32(&o.VCTR56.Reg, volatile.LoadUint32(&o.VCTR56.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR56_B1792() uint32 {
	return volatile.LoadUint32(&o.VCTR56.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR56_B1793(value uint32) {
	volatile.StoreUint32(&o.VCTR56.Reg, volatile.LoadUint32(&o.VCTR56.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR56_B1793() uint32 {
	return (volatile.LoadUint32(&o.VCTR56.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR56_B1794(value uint32) {
	volatile.StoreUint32(&o.VCTR56.Reg, volatile.LoadUint32(&o.VCTR56.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR56_B1794() uint32 {
	return (volatile.LoadUint32(&o.VCTR56.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR56_B1795(value uint32) {
	volatile.StoreUint32(&o.VCTR56.Reg, volatile.LoadUint32(&o.VCTR56.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR56_B1795() uint32 {
	return (volatile.LoadUint32(&o.VCTR56.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR56_B1796(value uint32) {
	volatile.StoreUint32(&o.VCTR56.Reg, volatile.LoadUint32(&o.VCTR56.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR56_B1796() uint32 {
	return (volatile.LoadUint32(&o.VCTR56.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR56_B1797(value uint32) {
	volatile.StoreUint32(&o.VCTR56.Reg, volatile.LoadUint32(&o.VCTR56.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR56_B1797() uint32 {
	return (volatile.LoadUint32(&o.VCTR56.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR56_B1798(value uint32) {
	volatile.StoreUint32(&o.VCTR56.Reg, volatile.LoadUint32(&o.VCTR56.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR56_B1798() uint32 {
	return (volatile.LoadUint32(&o.VCTR56.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR56_B1799(value uint32) {
	volatile.StoreUint32(&o.VCTR56.Reg, volatile.LoadUint32(&o.VCTR56.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR56_B1799() uint32 {
	return (volatile.LoadUint32(&o.VCTR56.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR56_B1800(value uint32) {
	volatile.StoreUint32(&o.VCTR56.Reg, volatile.LoadUint32(&o.VCTR56.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR56_B1800() uint32 {
	return (volatile.LoadUint32(&o.VCTR56.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR56_B1801(value uint32) {
	volatile.StoreUint32(&o.VCTR56.Reg, volatile.LoadUint32(&o.VCTR56.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR56_B1801() uint32 {
	return (volatile.LoadUint32(&o.VCTR56.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR56_B1802(value uint32) {
	volatile.StoreUint32(&o.VCTR56.Reg, volatile.LoadUint32(&o.VCTR56.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR56_B1802() uint32 {
	return (volatile.LoadUint32(&o.VCTR56.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR56_B1803(value uint32) {
	volatile.StoreUint32(&o.VCTR56.Reg, volatile.LoadUint32(&o.VCTR56.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR56_B1803() uint32 {
	return (volatile.LoadUint32(&o.VCTR56.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR56_B1804(value uint32) {
	volatile.StoreUint32(&o.VCTR56.Reg, volatile.LoadUint32(&o.VCTR56.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR56_B1804() uint32 {
	return (volatile.LoadUint32(&o.VCTR56.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR56_B1805(value uint32) {
	volatile.StoreUint32(&o.VCTR56.Reg, volatile.LoadUint32(&o.VCTR56.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR56_B1805() uint32 {
	return (volatile.LoadUint32(&o.VCTR56.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR56_B1806(value uint32) {
	volatile.StoreUint32(&o.VCTR56.Reg, volatile.LoadUint32(&o.VCTR56.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR56_B1806() uint32 {
	return (volatile.LoadUint32(&o.VCTR56.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR56_B1807(value uint32) {
	volatile.StoreUint32(&o.VCTR56.Reg, volatile.LoadUint32(&o.VCTR56.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR56_B1807() uint32 {
	return (volatile.LoadUint32(&o.VCTR56.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR56_B1808(value uint32) {
	volatile.StoreUint32(&o.VCTR56.Reg, volatile.LoadUint32(&o.VCTR56.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR56_B1808() uint32 {
	return (volatile.LoadUint32(&o.VCTR56.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR56_B1809(value uint32) {
	volatile.StoreUint32(&o.VCTR56.Reg, volatile.LoadUint32(&o.VCTR56.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR56_B1809() uint32 {
	return (volatile.LoadUint32(&o.VCTR56.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR56_B1810(value uint32) {
	volatile.StoreUint32(&o.VCTR56.Reg, volatile.LoadUint32(&o.VCTR56.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR56_B1810() uint32 {
	return (volatile.LoadUint32(&o.VCTR56.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR56_B1811(value uint32) {
	volatile.StoreUint32(&o.VCTR56.Reg, volatile.LoadUint32(&o.VCTR56.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR56_B1811() uint32 {
	return (volatile.LoadUint32(&o.VCTR56.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR56_B1812(value uint32) {
	volatile.StoreUint32(&o.VCTR56.Reg, volatile.LoadUint32(&o.VCTR56.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR56_B1812() uint32 {
	return (volatile.LoadUint32(&o.VCTR56.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR56_B1813(value uint32) {
	volatile.StoreUint32(&o.VCTR56.Reg, volatile.LoadUint32(&o.VCTR56.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR56_B1813() uint32 {
	return (volatile.LoadUint32(&o.VCTR56.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR56_B1814(value uint32) {
	volatile.StoreUint32(&o.VCTR56.Reg, volatile.LoadUint32(&o.VCTR56.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR56_B1814() uint32 {
	return (volatile.LoadUint32(&o.VCTR56.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR56_B1815(value uint32) {
	volatile.StoreUint32(&o.VCTR56.Reg, volatile.LoadUint32(&o.VCTR56.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR56_B1815() uint32 {
	return (volatile.LoadUint32(&o.VCTR56.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR56_B1816(value uint32) {
	volatile.StoreUint32(&o.VCTR56.Reg, volatile.LoadUint32(&o.VCTR56.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR56_B1816() uint32 {
	return (volatile.LoadUint32(&o.VCTR56.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR56_B1817(value uint32) {
	volatile.StoreUint32(&o.VCTR56.Reg, volatile.LoadUint32(&o.VCTR56.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR56_B1817() uint32 {
	return (volatile.LoadUint32(&o.VCTR56.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR56_B1818(value uint32) {
	volatile.StoreUint32(&o.VCTR56.Reg, volatile.LoadUint32(&o.VCTR56.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR56_B1818() uint32 {
	return (volatile.LoadUint32(&o.VCTR56.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR56_B1819(value uint32) {
	volatile.StoreUint32(&o.VCTR56.Reg, volatile.LoadUint32(&o.VCTR56.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR56_B1819() uint32 {
	return (volatile.LoadUint32(&o.VCTR56.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR56_B1820(value uint32) {
	volatile.StoreUint32(&o.VCTR56.Reg, volatile.LoadUint32(&o.VCTR56.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR56_B1820() uint32 {
	return (volatile.LoadUint32(&o.VCTR56.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR56_B1821(value uint32) {
	volatile.StoreUint32(&o.VCTR56.Reg, volatile.LoadUint32(&o.VCTR56.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR56_B1821() uint32 {
	return (volatile.LoadUint32(&o.VCTR56.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR56_B1822(value uint32) {
	volatile.StoreUint32(&o.VCTR56.Reg, volatile.LoadUint32(&o.VCTR56.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR56_B1822() uint32 {
	return (volatile.LoadUint32(&o.VCTR56.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR56_B1823(value uint32) {
	volatile.StoreUint32(&o.VCTR56.Reg, volatile.LoadUint32(&o.VCTR56.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR56_B1823() uint32 {
	return (volatile.LoadUint32(&o.VCTR56.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR57: MPCBBx vector register
func (o *GTZC_Type) SetVCTR57_B1824(value uint32) {
	volatile.StoreUint32(&o.VCTR57.Reg, volatile.LoadUint32(&o.VCTR57.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR57_B1824() uint32 {
	return volatile.LoadUint32(&o.VCTR57.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR57_B1825(value uint32) {
	volatile.StoreUint32(&o.VCTR57.Reg, volatile.LoadUint32(&o.VCTR57.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR57_B1825() uint32 {
	return (volatile.LoadUint32(&o.VCTR57.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR57_B1826(value uint32) {
	volatile.StoreUint32(&o.VCTR57.Reg, volatile.LoadUint32(&o.VCTR57.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR57_B1826() uint32 {
	return (volatile.LoadUint32(&o.VCTR57.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR57_B1827(value uint32) {
	volatile.StoreUint32(&o.VCTR57.Reg, volatile.LoadUint32(&o.VCTR57.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR57_B1827() uint32 {
	return (volatile.LoadUint32(&o.VCTR57.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR57_B1828(value uint32) {
	volatile.StoreUint32(&o.VCTR57.Reg, volatile.LoadUint32(&o.VCTR57.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR57_B1828() uint32 {
	return (volatile.LoadUint32(&o.VCTR57.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR57_B1829(value uint32) {
	volatile.StoreUint32(&o.VCTR57.Reg, volatile.LoadUint32(&o.VCTR57.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR57_B1829() uint32 {
	return (volatile.LoadUint32(&o.VCTR57.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR57_B1830(value uint32) {
	volatile.StoreUint32(&o.VCTR57.Reg, volatile.LoadUint32(&o.VCTR57.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR57_B1830() uint32 {
	return (volatile.LoadUint32(&o.VCTR57.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR57_B1831(value uint32) {
	volatile.StoreUint32(&o.VCTR57.Reg, volatile.LoadUint32(&o.VCTR57.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR57_B1831() uint32 {
	return (volatile.LoadUint32(&o.VCTR57.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR57_B1832(value uint32) {
	volatile.StoreUint32(&o.VCTR57.Reg, volatile.LoadUint32(&o.VCTR57.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR57_B1832() uint32 {
	return (volatile.LoadUint32(&o.VCTR57.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR57_B1833(value uint32) {
	volatile.StoreUint32(&o.VCTR57.Reg, volatile.LoadUint32(&o.VCTR57.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR57_B1833() uint32 {
	return (volatile.LoadUint32(&o.VCTR57.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR57_B1834(value uint32) {
	volatile.StoreUint32(&o.VCTR57.Reg, volatile.LoadUint32(&o.VCTR57.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR57_B1834() uint32 {
	return (volatile.LoadUint32(&o.VCTR57.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR57_B1835(value uint32) {
	volatile.StoreUint32(&o.VCTR57.Reg, volatile.LoadUint32(&o.VCTR57.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR57_B1835() uint32 {
	return (volatile.LoadUint32(&o.VCTR57.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR57_B1836(value uint32) {
	volatile.StoreUint32(&o.VCTR57.Reg, volatile.LoadUint32(&o.VCTR57.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR57_B1836() uint32 {
	return (volatile.LoadUint32(&o.VCTR57.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR57_B1837(value uint32) {
	volatile.StoreUint32(&o.VCTR57.Reg, volatile.LoadUint32(&o.VCTR57.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR57_B1837() uint32 {
	return (volatile.LoadUint32(&o.VCTR57.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR57_B1838(value uint32) {
	volatile.StoreUint32(&o.VCTR57.Reg, volatile.LoadUint32(&o.VCTR57.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR57_B1838() uint32 {
	return (volatile.LoadUint32(&o.VCTR57.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR57_B1839(value uint32) {
	volatile.StoreUint32(&o.VCTR57.Reg, volatile.LoadUint32(&o.VCTR57.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR57_B1839() uint32 {
	return (volatile.LoadUint32(&o.VCTR57.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR57_B1840(value uint32) {
	volatile.StoreUint32(&o.VCTR57.Reg, volatile.LoadUint32(&o.VCTR57.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR57_B1840() uint32 {
	return (volatile.LoadUint32(&o.VCTR57.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR57_B1841(value uint32) {
	volatile.StoreUint32(&o.VCTR57.Reg, volatile.LoadUint32(&o.VCTR57.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR57_B1841() uint32 {
	return (volatile.LoadUint32(&o.VCTR57.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR57_B1842(value uint32) {
	volatile.StoreUint32(&o.VCTR57.Reg, volatile.LoadUint32(&o.VCTR57.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR57_B1842() uint32 {
	return (volatile.LoadUint32(&o.VCTR57.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR57_B1843(value uint32) {
	volatile.StoreUint32(&o.VCTR57.Reg, volatile.LoadUint32(&o.VCTR57.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR57_B1843() uint32 {
	return (volatile.LoadUint32(&o.VCTR57.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR57_B1844(value uint32) {
	volatile.StoreUint32(&o.VCTR57.Reg, volatile.LoadUint32(&o.VCTR57.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR57_B1844() uint32 {
	return (volatile.LoadUint32(&o.VCTR57.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR57_B1845(value uint32) {
	volatile.StoreUint32(&o.VCTR57.Reg, volatile.LoadUint32(&o.VCTR57.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR57_B1845() uint32 {
	return (volatile.LoadUint32(&o.VCTR57.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR57_B1846(value uint32) {
	volatile.StoreUint32(&o.VCTR57.Reg, volatile.LoadUint32(&o.VCTR57.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR57_B1846() uint32 {
	return (volatile.LoadUint32(&o.VCTR57.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR57_B1847(value uint32) {
	volatile.StoreUint32(&o.VCTR57.Reg, volatile.LoadUint32(&o.VCTR57.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR57_B1847() uint32 {
	return (volatile.LoadUint32(&o.VCTR57.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR57_B1848(value uint32) {
	volatile.StoreUint32(&o.VCTR57.Reg, volatile.LoadUint32(&o.VCTR57.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR57_B1848() uint32 {
	return (volatile.LoadUint32(&o.VCTR57.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR57_B1849(value uint32) {
	volatile.StoreUint32(&o.VCTR57.Reg, volatile.LoadUint32(&o.VCTR57.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR57_B1849() uint32 {
	return (volatile.LoadUint32(&o.VCTR57.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR57_B1850(value uint32) {
	volatile.StoreUint32(&o.VCTR57.Reg, volatile.LoadUint32(&o.VCTR57.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR57_B1850() uint32 {
	return (volatile.LoadUint32(&o.VCTR57.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR57_B1851(value uint32) {
	volatile.StoreUint32(&o.VCTR57.Reg, volatile.LoadUint32(&o.VCTR57.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR57_B1851() uint32 {
	return (volatile.LoadUint32(&o.VCTR57.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR57_B1852(value uint32) {
	volatile.StoreUint32(&o.VCTR57.Reg, volatile.LoadUint32(&o.VCTR57.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR57_B1852() uint32 {
	return (volatile.LoadUint32(&o.VCTR57.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR57_B1853(value uint32) {
	volatile.StoreUint32(&o.VCTR57.Reg, volatile.LoadUint32(&o.VCTR57.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR57_B1853() uint32 {
	return (volatile.LoadUint32(&o.VCTR57.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR57_B1854(value uint32) {
	volatile.StoreUint32(&o.VCTR57.Reg, volatile.LoadUint32(&o.VCTR57.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR57_B1854() uint32 {
	return (volatile.LoadUint32(&o.VCTR57.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR57_B1855(value uint32) {
	volatile.StoreUint32(&o.VCTR57.Reg, volatile.LoadUint32(&o.VCTR57.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR57_B1855() uint32 {
	return (volatile.LoadUint32(&o.VCTR57.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR58: MPCBBx vector register
func (o *GTZC_Type) SetVCTR58_B1856(value uint32) {
	volatile.StoreUint32(&o.VCTR58.Reg, volatile.LoadUint32(&o.VCTR58.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR58_B1856() uint32 {
	return volatile.LoadUint32(&o.VCTR58.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR58_B1857(value uint32) {
	volatile.StoreUint32(&o.VCTR58.Reg, volatile.LoadUint32(&o.VCTR58.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR58_B1857() uint32 {
	return (volatile.LoadUint32(&o.VCTR58.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR58_B1858(value uint32) {
	volatile.StoreUint32(&o.VCTR58.Reg, volatile.LoadUint32(&o.VCTR58.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR58_B1858() uint32 {
	return (volatile.LoadUint32(&o.VCTR58.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR58_B1859(value uint32) {
	volatile.StoreUint32(&o.VCTR58.Reg, volatile.LoadUint32(&o.VCTR58.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR58_B1859() uint32 {
	return (volatile.LoadUint32(&o.VCTR58.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR58_B1860(value uint32) {
	volatile.StoreUint32(&o.VCTR58.Reg, volatile.LoadUint32(&o.VCTR58.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR58_B1860() uint32 {
	return (volatile.LoadUint32(&o.VCTR58.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR58_B1861(value uint32) {
	volatile.StoreUint32(&o.VCTR58.Reg, volatile.LoadUint32(&o.VCTR58.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR58_B1861() uint32 {
	return (volatile.LoadUint32(&o.VCTR58.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR58_B1862(value uint32) {
	volatile.StoreUint32(&o.VCTR58.Reg, volatile.LoadUint32(&o.VCTR58.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR58_B1862() uint32 {
	return (volatile.LoadUint32(&o.VCTR58.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR58_B1863(value uint32) {
	volatile.StoreUint32(&o.VCTR58.Reg, volatile.LoadUint32(&o.VCTR58.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR58_B1863() uint32 {
	return (volatile.LoadUint32(&o.VCTR58.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR58_B1864(value uint32) {
	volatile.StoreUint32(&o.VCTR58.Reg, volatile.LoadUint32(&o.VCTR58.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR58_B1864() uint32 {
	return (volatile.LoadUint32(&o.VCTR58.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR58_B1865(value uint32) {
	volatile.StoreUint32(&o.VCTR58.Reg, volatile.LoadUint32(&o.VCTR58.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR58_B1865() uint32 {
	return (volatile.LoadUint32(&o.VCTR58.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR58_B1866(value uint32) {
	volatile.StoreUint32(&o.VCTR58.Reg, volatile.LoadUint32(&o.VCTR58.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR58_B1866() uint32 {
	return (volatile.LoadUint32(&o.VCTR58.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR58_B1867(value uint32) {
	volatile.StoreUint32(&o.VCTR58.Reg, volatile.LoadUint32(&o.VCTR58.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR58_B1867() uint32 {
	return (volatile.LoadUint32(&o.VCTR58.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR58_B1868(value uint32) {
	volatile.StoreUint32(&o.VCTR58.Reg, volatile.LoadUint32(&o.VCTR58.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR58_B1868() uint32 {
	return (volatile.LoadUint32(&o.VCTR58.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR58_B1869(value uint32) {
	volatile.StoreUint32(&o.VCTR58.Reg, volatile.LoadUint32(&o.VCTR58.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR58_B1869() uint32 {
	return (volatile.LoadUint32(&o.VCTR58.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR58_B1870(value uint32) {
	volatile.StoreUint32(&o.VCTR58.Reg, volatile.LoadUint32(&o.VCTR58.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR58_B1870() uint32 {
	return (volatile.LoadUint32(&o.VCTR58.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR58_B1871(value uint32) {
	volatile.StoreUint32(&o.VCTR58.Reg, volatile.LoadUint32(&o.VCTR58.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR58_B1871() uint32 {
	return (volatile.LoadUint32(&o.VCTR58.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR58_B1872(value uint32) {
	volatile.StoreUint32(&o.VCTR58.Reg, volatile.LoadUint32(&o.VCTR58.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR58_B1872() uint32 {
	return (volatile.LoadUint32(&o.VCTR58.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR58_B1873(value uint32) {
	volatile.StoreUint32(&o.VCTR58.Reg, volatile.LoadUint32(&o.VCTR58.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR58_B1873() uint32 {
	return (volatile.LoadUint32(&o.VCTR58.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR58_B1874(value uint32) {
	volatile.StoreUint32(&o.VCTR58.Reg, volatile.LoadUint32(&o.VCTR58.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR58_B1874() uint32 {
	return (volatile.LoadUint32(&o.VCTR58.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR58_B1875(value uint32) {
	volatile.StoreUint32(&o.VCTR58.Reg, volatile.LoadUint32(&o.VCTR58.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR58_B1875() uint32 {
	return (volatile.LoadUint32(&o.VCTR58.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR58_B1876(value uint32) {
	volatile.StoreUint32(&o.VCTR58.Reg, volatile.LoadUint32(&o.VCTR58.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR58_B1876() uint32 {
	return (volatile.LoadUint32(&o.VCTR58.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR58_B1877(value uint32) {
	volatile.StoreUint32(&o.VCTR58.Reg, volatile.LoadUint32(&o.VCTR58.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR58_B1877() uint32 {
	return (volatile.LoadUint32(&o.VCTR58.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR58_B1878(value uint32) {
	volatile.StoreUint32(&o.VCTR58.Reg, volatile.LoadUint32(&o.VCTR58.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR58_B1878() uint32 {
	return (volatile.LoadUint32(&o.VCTR58.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR58_B1879(value uint32) {
	volatile.StoreUint32(&o.VCTR58.Reg, volatile.LoadUint32(&o.VCTR58.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR58_B1879() uint32 {
	return (volatile.LoadUint32(&o.VCTR58.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR58_B1880(value uint32) {
	volatile.StoreUint32(&o.VCTR58.Reg, volatile.LoadUint32(&o.VCTR58.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR58_B1880() uint32 {
	return (volatile.LoadUint32(&o.VCTR58.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR58_B1881(value uint32) {
	volatile.StoreUint32(&o.VCTR58.Reg, volatile.LoadUint32(&o.VCTR58.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR58_B1881() uint32 {
	return (volatile.LoadUint32(&o.VCTR58.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR58_B1882(value uint32) {
	volatile.StoreUint32(&o.VCTR58.Reg, volatile.LoadUint32(&o.VCTR58.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR58_B1882() uint32 {
	return (volatile.LoadUint32(&o.VCTR58.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR58_B1883(value uint32) {
	volatile.StoreUint32(&o.VCTR58.Reg, volatile.LoadUint32(&o.VCTR58.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR58_B1883() uint32 {
	return (volatile.LoadUint32(&o.VCTR58.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR58_B1884(value uint32) {
	volatile.StoreUint32(&o.VCTR58.Reg, volatile.LoadUint32(&o.VCTR58.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR58_B1884() uint32 {
	return (volatile.LoadUint32(&o.VCTR58.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR58_B1885(value uint32) {
	volatile.StoreUint32(&o.VCTR58.Reg, volatile.LoadUint32(&o.VCTR58.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR58_B1885() uint32 {
	return (volatile.LoadUint32(&o.VCTR58.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR58_B1886(value uint32) {
	volatile.StoreUint32(&o.VCTR58.Reg, volatile.LoadUint32(&o.VCTR58.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR58_B1886() uint32 {
	return (volatile.LoadUint32(&o.VCTR58.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR58_B1887(value uint32) {
	volatile.StoreUint32(&o.VCTR58.Reg, volatile.LoadUint32(&o.VCTR58.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR58_B1887() uint32 {
	return (volatile.LoadUint32(&o.VCTR58.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR59: MPCBBx vector register
func (o *GTZC_Type) SetVCTR59_B1888(value uint32) {
	volatile.StoreUint32(&o.VCTR59.Reg, volatile.LoadUint32(&o.VCTR59.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR59_B1888() uint32 {
	return volatile.LoadUint32(&o.VCTR59.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR59_B1889(value uint32) {
	volatile.StoreUint32(&o.VCTR59.Reg, volatile.LoadUint32(&o.VCTR59.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR59_B1889() uint32 {
	return (volatile.LoadUint32(&o.VCTR59.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR59_B1890(value uint32) {
	volatile.StoreUint32(&o.VCTR59.Reg, volatile.LoadUint32(&o.VCTR59.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR59_B1890() uint32 {
	return (volatile.LoadUint32(&o.VCTR59.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR59_B1891(value uint32) {
	volatile.StoreUint32(&o.VCTR59.Reg, volatile.LoadUint32(&o.VCTR59.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR59_B1891() uint32 {
	return (volatile.LoadUint32(&o.VCTR59.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR59_B1892(value uint32) {
	volatile.StoreUint32(&o.VCTR59.Reg, volatile.LoadUint32(&o.VCTR59.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR59_B1892() uint32 {
	return (volatile.LoadUint32(&o.VCTR59.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR59_B1893(value uint32) {
	volatile.StoreUint32(&o.VCTR59.Reg, volatile.LoadUint32(&o.VCTR59.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR59_B1893() uint32 {
	return (volatile.LoadUint32(&o.VCTR59.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR59_B1894(value uint32) {
	volatile.StoreUint32(&o.VCTR59.Reg, volatile.LoadUint32(&o.VCTR59.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR59_B1894() uint32 {
	return (volatile.LoadUint32(&o.VCTR59.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR59_B1895(value uint32) {
	volatile.StoreUint32(&o.VCTR59.Reg, volatile.LoadUint32(&o.VCTR59.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR59_B1895() uint32 {
	return (volatile.LoadUint32(&o.VCTR59.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR59_B1896(value uint32) {
	volatile.StoreUint32(&o.VCTR59.Reg, volatile.LoadUint32(&o.VCTR59.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR59_B1896() uint32 {
	return (volatile.LoadUint32(&o.VCTR59.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR59_B1897(value uint32) {
	volatile.StoreUint32(&o.VCTR59.Reg, volatile.LoadUint32(&o.VCTR59.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR59_B1897() uint32 {
	return (volatile.LoadUint32(&o.VCTR59.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR59_B1898(value uint32) {
	volatile.StoreUint32(&o.VCTR59.Reg, volatile.LoadUint32(&o.VCTR59.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR59_B1898() uint32 {
	return (volatile.LoadUint32(&o.VCTR59.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR59_B1899(value uint32) {
	volatile.StoreUint32(&o.VCTR59.Reg, volatile.LoadUint32(&o.VCTR59.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR59_B1899() uint32 {
	return (volatile.LoadUint32(&o.VCTR59.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR59_B1900(value uint32) {
	volatile.StoreUint32(&o.VCTR59.Reg, volatile.LoadUint32(&o.VCTR59.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR59_B1900() uint32 {
	return (volatile.LoadUint32(&o.VCTR59.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR59_B1901(value uint32) {
	volatile.StoreUint32(&o.VCTR59.Reg, volatile.LoadUint32(&o.VCTR59.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR59_B1901() uint32 {
	return (volatile.LoadUint32(&o.VCTR59.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR59_B1902(value uint32) {
	volatile.StoreUint32(&o.VCTR59.Reg, volatile.LoadUint32(&o.VCTR59.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR59_B1902() uint32 {
	return (volatile.LoadUint32(&o.VCTR59.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR59_B1903(value uint32) {
	volatile.StoreUint32(&o.VCTR59.Reg, volatile.LoadUint32(&o.VCTR59.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR59_B1903() uint32 {
	return (volatile.LoadUint32(&o.VCTR59.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR59_B1904(value uint32) {
	volatile.StoreUint32(&o.VCTR59.Reg, volatile.LoadUint32(&o.VCTR59.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR59_B1904() uint32 {
	return (volatile.LoadUint32(&o.VCTR59.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR59_B1905(value uint32) {
	volatile.StoreUint32(&o.VCTR59.Reg, volatile.LoadUint32(&o.VCTR59.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR59_B1905() uint32 {
	return (volatile.LoadUint32(&o.VCTR59.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR59_B1906(value uint32) {
	volatile.StoreUint32(&o.VCTR59.Reg, volatile.LoadUint32(&o.VCTR59.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR59_B1906() uint32 {
	return (volatile.LoadUint32(&o.VCTR59.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR59_B1907(value uint32) {
	volatile.StoreUint32(&o.VCTR59.Reg, volatile.LoadUint32(&o.VCTR59.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR59_B1907() uint32 {
	return (volatile.LoadUint32(&o.VCTR59.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR59_B1908(value uint32) {
	volatile.StoreUint32(&o.VCTR59.Reg, volatile.LoadUint32(&o.VCTR59.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR59_B1908() uint32 {
	return (volatile.LoadUint32(&o.VCTR59.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR59_B1909(value uint32) {
	volatile.StoreUint32(&o.VCTR59.Reg, volatile.LoadUint32(&o.VCTR59.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR59_B1909() uint32 {
	return (volatile.LoadUint32(&o.VCTR59.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR59_B1910(value uint32) {
	volatile.StoreUint32(&o.VCTR59.Reg, volatile.LoadUint32(&o.VCTR59.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR59_B1910() uint32 {
	return (volatile.LoadUint32(&o.VCTR59.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR59_B1911(value uint32) {
	volatile.StoreUint32(&o.VCTR59.Reg, volatile.LoadUint32(&o.VCTR59.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR59_B1911() uint32 {
	return (volatile.LoadUint32(&o.VCTR59.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR59_B1912(value uint32) {
	volatile.StoreUint32(&o.VCTR59.Reg, volatile.LoadUint32(&o.VCTR59.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR59_B1912() uint32 {
	return (volatile.LoadUint32(&o.VCTR59.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR59_B1913(value uint32) {
	volatile.StoreUint32(&o.VCTR59.Reg, volatile.LoadUint32(&o.VCTR59.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR59_B1913() uint32 {
	return (volatile.LoadUint32(&o.VCTR59.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR59_B1914(value uint32) {
	volatile.StoreUint32(&o.VCTR59.Reg, volatile.LoadUint32(&o.VCTR59.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR59_B1914() uint32 {
	return (volatile.LoadUint32(&o.VCTR59.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR59_B1915(value uint32) {
	volatile.StoreUint32(&o.VCTR59.Reg, volatile.LoadUint32(&o.VCTR59.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR59_B1915() uint32 {
	return (volatile.LoadUint32(&o.VCTR59.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR59_B1916(value uint32) {
	volatile.StoreUint32(&o.VCTR59.Reg, volatile.LoadUint32(&o.VCTR59.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR59_B1916() uint32 {
	return (volatile.LoadUint32(&o.VCTR59.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR59_B1917(value uint32) {
	volatile.StoreUint32(&o.VCTR59.Reg, volatile.LoadUint32(&o.VCTR59.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR59_B1917() uint32 {
	return (volatile.LoadUint32(&o.VCTR59.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR59_B1918(value uint32) {
	volatile.StoreUint32(&o.VCTR59.Reg, volatile.LoadUint32(&o.VCTR59.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR59_B1918() uint32 {
	return (volatile.LoadUint32(&o.VCTR59.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR59_B1919(value uint32) {
	volatile.StoreUint32(&o.VCTR59.Reg, volatile.LoadUint32(&o.VCTR59.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR59_B1919() uint32 {
	return (volatile.LoadUint32(&o.VCTR59.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR60: MPCBBx vector register
func (o *GTZC_Type) SetVCTR60_B1920(value uint32) {
	volatile.StoreUint32(&o.VCTR60.Reg, volatile.LoadUint32(&o.VCTR60.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR60_B1920() uint32 {
	return volatile.LoadUint32(&o.VCTR60.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR60_B1921(value uint32) {
	volatile.StoreUint32(&o.VCTR60.Reg, volatile.LoadUint32(&o.VCTR60.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR60_B1921() uint32 {
	return (volatile.LoadUint32(&o.VCTR60.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR60_B1922(value uint32) {
	volatile.StoreUint32(&o.VCTR60.Reg, volatile.LoadUint32(&o.VCTR60.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR60_B1922() uint32 {
	return (volatile.LoadUint32(&o.VCTR60.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR60_B1923(value uint32) {
	volatile.StoreUint32(&o.VCTR60.Reg, volatile.LoadUint32(&o.VCTR60.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR60_B1923() uint32 {
	return (volatile.LoadUint32(&o.VCTR60.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR60_B1924(value uint32) {
	volatile.StoreUint32(&o.VCTR60.Reg, volatile.LoadUint32(&o.VCTR60.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR60_B1924() uint32 {
	return (volatile.LoadUint32(&o.VCTR60.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR60_B1925(value uint32) {
	volatile.StoreUint32(&o.VCTR60.Reg, volatile.LoadUint32(&o.VCTR60.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR60_B1925() uint32 {
	return (volatile.LoadUint32(&o.VCTR60.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR60_B1926(value uint32) {
	volatile.StoreUint32(&o.VCTR60.Reg, volatile.LoadUint32(&o.VCTR60.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR60_B1926() uint32 {
	return (volatile.LoadUint32(&o.VCTR60.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR60_B1927(value uint32) {
	volatile.StoreUint32(&o.VCTR60.Reg, volatile.LoadUint32(&o.VCTR60.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR60_B1927() uint32 {
	return (volatile.LoadUint32(&o.VCTR60.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR60_B1928(value uint32) {
	volatile.StoreUint32(&o.VCTR60.Reg, volatile.LoadUint32(&o.VCTR60.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR60_B1928() uint32 {
	return (volatile.LoadUint32(&o.VCTR60.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR60_B1929(value uint32) {
	volatile.StoreUint32(&o.VCTR60.Reg, volatile.LoadUint32(&o.VCTR60.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR60_B1929() uint32 {
	return (volatile.LoadUint32(&o.VCTR60.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR60_B1930(value uint32) {
	volatile.StoreUint32(&o.VCTR60.Reg, volatile.LoadUint32(&o.VCTR60.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR60_B1930() uint32 {
	return (volatile.LoadUint32(&o.VCTR60.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR60_B1931(value uint32) {
	volatile.StoreUint32(&o.VCTR60.Reg, volatile.LoadUint32(&o.VCTR60.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR60_B1931() uint32 {
	return (volatile.LoadUint32(&o.VCTR60.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR60_B1932(value uint32) {
	volatile.StoreUint32(&o.VCTR60.Reg, volatile.LoadUint32(&o.VCTR60.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR60_B1932() uint32 {
	return (volatile.LoadUint32(&o.VCTR60.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR60_B1933(value uint32) {
	volatile.StoreUint32(&o.VCTR60.Reg, volatile.LoadUint32(&o.VCTR60.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR60_B1933() uint32 {
	return (volatile.LoadUint32(&o.VCTR60.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR60_B1934(value uint32) {
	volatile.StoreUint32(&o.VCTR60.Reg, volatile.LoadUint32(&o.VCTR60.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR60_B1934() uint32 {
	return (volatile.LoadUint32(&o.VCTR60.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR60_B1935(value uint32) {
	volatile.StoreUint32(&o.VCTR60.Reg, volatile.LoadUint32(&o.VCTR60.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR60_B1935() uint32 {
	return (volatile.LoadUint32(&o.VCTR60.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR60_B1936(value uint32) {
	volatile.StoreUint32(&o.VCTR60.Reg, volatile.LoadUint32(&o.VCTR60.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR60_B1936() uint32 {
	return (volatile.LoadUint32(&o.VCTR60.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR60_B1937(value uint32) {
	volatile.StoreUint32(&o.VCTR60.Reg, volatile.LoadUint32(&o.VCTR60.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR60_B1937() uint32 {
	return (volatile.LoadUint32(&o.VCTR60.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR60_B1938(value uint32) {
	volatile.StoreUint32(&o.VCTR60.Reg, volatile.LoadUint32(&o.VCTR60.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR60_B1938() uint32 {
	return (volatile.LoadUint32(&o.VCTR60.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR60_B1939(value uint32) {
	volatile.StoreUint32(&o.VCTR60.Reg, volatile.LoadUint32(&o.VCTR60.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR60_B1939() uint32 {
	return (volatile.LoadUint32(&o.VCTR60.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR60_B1940(value uint32) {
	volatile.StoreUint32(&o.VCTR60.Reg, volatile.LoadUint32(&o.VCTR60.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR60_B1940() uint32 {
	return (volatile.LoadUint32(&o.VCTR60.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR60_B1941(value uint32) {
	volatile.StoreUint32(&o.VCTR60.Reg, volatile.LoadUint32(&o.VCTR60.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR60_B1941() uint32 {
	return (volatile.LoadUint32(&o.VCTR60.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR60_B1942(value uint32) {
	volatile.StoreUint32(&o.VCTR60.Reg, volatile.LoadUint32(&o.VCTR60.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR60_B1942() uint32 {
	return (volatile.LoadUint32(&o.VCTR60.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR60_B1943(value uint32) {
	volatile.StoreUint32(&o.VCTR60.Reg, volatile.LoadUint32(&o.VCTR60.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR60_B1943() uint32 {
	return (volatile.LoadUint32(&o.VCTR60.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR60_B1944(value uint32) {
	volatile.StoreUint32(&o.VCTR60.Reg, volatile.LoadUint32(&o.VCTR60.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR60_B1944() uint32 {
	return (volatile.LoadUint32(&o.VCTR60.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR60_B1945(value uint32) {
	volatile.StoreUint32(&o.VCTR60.Reg, volatile.LoadUint32(&o.VCTR60.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR60_B1945() uint32 {
	return (volatile.LoadUint32(&o.VCTR60.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR60_B1946(value uint32) {
	volatile.StoreUint32(&o.VCTR60.Reg, volatile.LoadUint32(&o.VCTR60.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR60_B1946() uint32 {
	return (volatile.LoadUint32(&o.VCTR60.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR60_B1947(value uint32) {
	volatile.StoreUint32(&o.VCTR60.Reg, volatile.LoadUint32(&o.VCTR60.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR60_B1947() uint32 {
	return (volatile.LoadUint32(&o.VCTR60.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR60_B1948(value uint32) {
	volatile.StoreUint32(&o.VCTR60.Reg, volatile.LoadUint32(&o.VCTR60.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR60_B1948() uint32 {
	return (volatile.LoadUint32(&o.VCTR60.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR60_B1949(value uint32) {
	volatile.StoreUint32(&o.VCTR60.Reg, volatile.LoadUint32(&o.VCTR60.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR60_B1949() uint32 {
	return (volatile.LoadUint32(&o.VCTR60.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR60_B1950(value uint32) {
	volatile.StoreUint32(&o.VCTR60.Reg, volatile.LoadUint32(&o.VCTR60.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR60_B1950() uint32 {
	return (volatile.LoadUint32(&o.VCTR60.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR60_B1951(value uint32) {
	volatile.StoreUint32(&o.VCTR60.Reg, volatile.LoadUint32(&o.VCTR60.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR60_B1951() uint32 {
	return (volatile.LoadUint32(&o.VCTR60.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR61: MPCBBx vector register
func (o *GTZC_Type) SetVCTR61_B1952(value uint32) {
	volatile.StoreUint32(&o.VCTR61.Reg, volatile.LoadUint32(&o.VCTR61.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR61_B1952() uint32 {
	return volatile.LoadUint32(&o.VCTR61.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR61_B1953(value uint32) {
	volatile.StoreUint32(&o.VCTR61.Reg, volatile.LoadUint32(&o.VCTR61.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR61_B1953() uint32 {
	return (volatile.LoadUint32(&o.VCTR61.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR61_B1954(value uint32) {
	volatile.StoreUint32(&o.VCTR61.Reg, volatile.LoadUint32(&o.VCTR61.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR61_B1954() uint32 {
	return (volatile.LoadUint32(&o.VCTR61.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR61_B1955(value uint32) {
	volatile.StoreUint32(&o.VCTR61.Reg, volatile.LoadUint32(&o.VCTR61.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR61_B1955() uint32 {
	return (volatile.LoadUint32(&o.VCTR61.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR61_B1956(value uint32) {
	volatile.StoreUint32(&o.VCTR61.Reg, volatile.LoadUint32(&o.VCTR61.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR61_B1956() uint32 {
	return (volatile.LoadUint32(&o.VCTR61.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR61_B1957(value uint32) {
	volatile.StoreUint32(&o.VCTR61.Reg, volatile.LoadUint32(&o.VCTR61.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR61_B1957() uint32 {
	return (volatile.LoadUint32(&o.VCTR61.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR61_B1958(value uint32) {
	volatile.StoreUint32(&o.VCTR61.Reg, volatile.LoadUint32(&o.VCTR61.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR61_B1958() uint32 {
	return (volatile.LoadUint32(&o.VCTR61.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR61_B1959(value uint32) {
	volatile.StoreUint32(&o.VCTR61.Reg, volatile.LoadUint32(&o.VCTR61.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR61_B1959() uint32 {
	return (volatile.LoadUint32(&o.VCTR61.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR61_B1960(value uint32) {
	volatile.StoreUint32(&o.VCTR61.Reg, volatile.LoadUint32(&o.VCTR61.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR61_B1960() uint32 {
	return (volatile.LoadUint32(&o.VCTR61.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR61_B1961(value uint32) {
	volatile.StoreUint32(&o.VCTR61.Reg, volatile.LoadUint32(&o.VCTR61.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR61_B1961() uint32 {
	return (volatile.LoadUint32(&o.VCTR61.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR61_B1962(value uint32) {
	volatile.StoreUint32(&o.VCTR61.Reg, volatile.LoadUint32(&o.VCTR61.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR61_B1962() uint32 {
	return (volatile.LoadUint32(&o.VCTR61.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR61_B1963(value uint32) {
	volatile.StoreUint32(&o.VCTR61.Reg, volatile.LoadUint32(&o.VCTR61.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR61_B1963() uint32 {
	return (volatile.LoadUint32(&o.VCTR61.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR61_B1964(value uint32) {
	volatile.StoreUint32(&o.VCTR61.Reg, volatile.LoadUint32(&o.VCTR61.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR61_B1964() uint32 {
	return (volatile.LoadUint32(&o.VCTR61.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR61_B1965(value uint32) {
	volatile.StoreUint32(&o.VCTR61.Reg, volatile.LoadUint32(&o.VCTR61.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR61_B1965() uint32 {
	return (volatile.LoadUint32(&o.VCTR61.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR61_B1966(value uint32) {
	volatile.StoreUint32(&o.VCTR61.Reg, volatile.LoadUint32(&o.VCTR61.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR61_B1966() uint32 {
	return (volatile.LoadUint32(&o.VCTR61.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR61_B1967(value uint32) {
	volatile.StoreUint32(&o.VCTR61.Reg, volatile.LoadUint32(&o.VCTR61.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR61_B1967() uint32 {
	return (volatile.LoadUint32(&o.VCTR61.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR61_B1968(value uint32) {
	volatile.StoreUint32(&o.VCTR61.Reg, volatile.LoadUint32(&o.VCTR61.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR61_B1968() uint32 {
	return (volatile.LoadUint32(&o.VCTR61.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR61_B1969(value uint32) {
	volatile.StoreUint32(&o.VCTR61.Reg, volatile.LoadUint32(&o.VCTR61.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR61_B1969() uint32 {
	return (volatile.LoadUint32(&o.VCTR61.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR61_B1970(value uint32) {
	volatile.StoreUint32(&o.VCTR61.Reg, volatile.LoadUint32(&o.VCTR61.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR61_B1970() uint32 {
	return (volatile.LoadUint32(&o.VCTR61.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR61_B1971(value uint32) {
	volatile.StoreUint32(&o.VCTR61.Reg, volatile.LoadUint32(&o.VCTR61.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR61_B1971() uint32 {
	return (volatile.LoadUint32(&o.VCTR61.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR61_B1972(value uint32) {
	volatile.StoreUint32(&o.VCTR61.Reg, volatile.LoadUint32(&o.VCTR61.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR61_B1972() uint32 {
	return (volatile.LoadUint32(&o.VCTR61.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR61_B1973(value uint32) {
	volatile.StoreUint32(&o.VCTR61.Reg, volatile.LoadUint32(&o.VCTR61.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR61_B1973() uint32 {
	return (volatile.LoadUint32(&o.VCTR61.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR61_B1974(value uint32) {
	volatile.StoreUint32(&o.VCTR61.Reg, volatile.LoadUint32(&o.VCTR61.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR61_B1974() uint32 {
	return (volatile.LoadUint32(&o.VCTR61.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR61_B1975(value uint32) {
	volatile.StoreUint32(&o.VCTR61.Reg, volatile.LoadUint32(&o.VCTR61.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR61_B1975() uint32 {
	return (volatile.LoadUint32(&o.VCTR61.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR61_B1976(value uint32) {
	volatile.StoreUint32(&o.VCTR61.Reg, volatile.LoadUint32(&o.VCTR61.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR61_B1976() uint32 {
	return (volatile.LoadUint32(&o.VCTR61.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR61_B1977(value uint32) {
	volatile.StoreUint32(&o.VCTR61.Reg, volatile.LoadUint32(&o.VCTR61.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR61_B1977() uint32 {
	return (volatile.LoadUint32(&o.VCTR61.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR61_B1978(value uint32) {
	volatile.StoreUint32(&o.VCTR61.Reg, volatile.LoadUint32(&o.VCTR61.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR61_B1978() uint32 {
	return (volatile.LoadUint32(&o.VCTR61.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR61_B1979(value uint32) {
	volatile.StoreUint32(&o.VCTR61.Reg, volatile.LoadUint32(&o.VCTR61.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR61_B1979() uint32 {
	return (volatile.LoadUint32(&o.VCTR61.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR61_B1980(value uint32) {
	volatile.StoreUint32(&o.VCTR61.Reg, volatile.LoadUint32(&o.VCTR61.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR61_B1980() uint32 {
	return (volatile.LoadUint32(&o.VCTR61.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR61_B1981(value uint32) {
	volatile.StoreUint32(&o.VCTR61.Reg, volatile.LoadUint32(&o.VCTR61.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR61_B1981() uint32 {
	return (volatile.LoadUint32(&o.VCTR61.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR61_B1982(value uint32) {
	volatile.StoreUint32(&o.VCTR61.Reg, volatile.LoadUint32(&o.VCTR61.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR61_B1982() uint32 {
	return (volatile.LoadUint32(&o.VCTR61.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR61_B1983(value uint32) {
	volatile.StoreUint32(&o.VCTR61.Reg, volatile.LoadUint32(&o.VCTR61.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR61_B1983() uint32 {
	return (volatile.LoadUint32(&o.VCTR61.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR62: MPCBBx vector register
func (o *GTZC_Type) SetVCTR62_B1984(value uint32) {
	volatile.StoreUint32(&o.VCTR62.Reg, volatile.LoadUint32(&o.VCTR62.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR62_B1984() uint32 {
	return volatile.LoadUint32(&o.VCTR62.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR62_B1985(value uint32) {
	volatile.StoreUint32(&o.VCTR62.Reg, volatile.LoadUint32(&o.VCTR62.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR62_B1985() uint32 {
	return (volatile.LoadUint32(&o.VCTR62.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR62_B1986(value uint32) {
	volatile.StoreUint32(&o.VCTR62.Reg, volatile.LoadUint32(&o.VCTR62.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR62_B1986() uint32 {
	return (volatile.LoadUint32(&o.VCTR62.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR62_B1987(value uint32) {
	volatile.StoreUint32(&o.VCTR62.Reg, volatile.LoadUint32(&o.VCTR62.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR62_B1987() uint32 {
	return (volatile.LoadUint32(&o.VCTR62.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR62_B1988(value uint32) {
	volatile.StoreUint32(&o.VCTR62.Reg, volatile.LoadUint32(&o.VCTR62.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR62_B1988() uint32 {
	return (volatile.LoadUint32(&o.VCTR62.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR62_B1989(value uint32) {
	volatile.StoreUint32(&o.VCTR62.Reg, volatile.LoadUint32(&o.VCTR62.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR62_B1989() uint32 {
	return (volatile.LoadUint32(&o.VCTR62.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR62_B1990(value uint32) {
	volatile.StoreUint32(&o.VCTR62.Reg, volatile.LoadUint32(&o.VCTR62.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR62_B1990() uint32 {
	return (volatile.LoadUint32(&o.VCTR62.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR62_B1991(value uint32) {
	volatile.StoreUint32(&o.VCTR62.Reg, volatile.LoadUint32(&o.VCTR62.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR62_B1991() uint32 {
	return (volatile.LoadUint32(&o.VCTR62.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR62_B1992(value uint32) {
	volatile.StoreUint32(&o.VCTR62.Reg, volatile.LoadUint32(&o.VCTR62.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR62_B1992() uint32 {
	return (volatile.LoadUint32(&o.VCTR62.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR62_B1993(value uint32) {
	volatile.StoreUint32(&o.VCTR62.Reg, volatile.LoadUint32(&o.VCTR62.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR62_B1993() uint32 {
	return (volatile.LoadUint32(&o.VCTR62.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR62_B1994(value uint32) {
	volatile.StoreUint32(&o.VCTR62.Reg, volatile.LoadUint32(&o.VCTR62.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR62_B1994() uint32 {
	return (volatile.LoadUint32(&o.VCTR62.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR62_B1995(value uint32) {
	volatile.StoreUint32(&o.VCTR62.Reg, volatile.LoadUint32(&o.VCTR62.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR62_B1995() uint32 {
	return (volatile.LoadUint32(&o.VCTR62.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR62_B1996(value uint32) {
	volatile.StoreUint32(&o.VCTR62.Reg, volatile.LoadUint32(&o.VCTR62.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR62_B1996() uint32 {
	return (volatile.LoadUint32(&o.VCTR62.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR62_B1997(value uint32) {
	volatile.StoreUint32(&o.VCTR62.Reg, volatile.LoadUint32(&o.VCTR62.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR62_B1997() uint32 {
	return (volatile.LoadUint32(&o.VCTR62.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR62_B1998(value uint32) {
	volatile.StoreUint32(&o.VCTR62.Reg, volatile.LoadUint32(&o.VCTR62.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR62_B1998() uint32 {
	return (volatile.LoadUint32(&o.VCTR62.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR62_B1999(value uint32) {
	volatile.StoreUint32(&o.VCTR62.Reg, volatile.LoadUint32(&o.VCTR62.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR62_B1999() uint32 {
	return (volatile.LoadUint32(&o.VCTR62.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR62_B2000(value uint32) {
	volatile.StoreUint32(&o.VCTR62.Reg, volatile.LoadUint32(&o.VCTR62.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR62_B2000() uint32 {
	return (volatile.LoadUint32(&o.VCTR62.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR62_B2001(value uint32) {
	volatile.StoreUint32(&o.VCTR62.Reg, volatile.LoadUint32(&o.VCTR62.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR62_B2001() uint32 {
	return (volatile.LoadUint32(&o.VCTR62.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR62_B2002(value uint32) {
	volatile.StoreUint32(&o.VCTR62.Reg, volatile.LoadUint32(&o.VCTR62.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR62_B2002() uint32 {
	return (volatile.LoadUint32(&o.VCTR62.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR62_B2003(value uint32) {
	volatile.StoreUint32(&o.VCTR62.Reg, volatile.LoadUint32(&o.VCTR62.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR62_B2003() uint32 {
	return (volatile.LoadUint32(&o.VCTR62.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR62_B2004(value uint32) {
	volatile.StoreUint32(&o.VCTR62.Reg, volatile.LoadUint32(&o.VCTR62.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR62_B2004() uint32 {
	return (volatile.LoadUint32(&o.VCTR62.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR62_B2005(value uint32) {
	volatile.StoreUint32(&o.VCTR62.Reg, volatile.LoadUint32(&o.VCTR62.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR62_B2005() uint32 {
	return (volatile.LoadUint32(&o.VCTR62.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR62_B2006(value uint32) {
	volatile.StoreUint32(&o.VCTR62.Reg, volatile.LoadUint32(&o.VCTR62.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR62_B2006() uint32 {
	return (volatile.LoadUint32(&o.VCTR62.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR62_B2007(value uint32) {
	volatile.StoreUint32(&o.VCTR62.Reg, volatile.LoadUint32(&o.VCTR62.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR62_B2007() uint32 {
	return (volatile.LoadUint32(&o.VCTR62.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR62_B2008(value uint32) {
	volatile.StoreUint32(&o.VCTR62.Reg, volatile.LoadUint32(&o.VCTR62.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR62_B2008() uint32 {
	return (volatile.LoadUint32(&o.VCTR62.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR62_B2009(value uint32) {
	volatile.StoreUint32(&o.VCTR62.Reg, volatile.LoadUint32(&o.VCTR62.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR62_B2009() uint32 {
	return (volatile.LoadUint32(&o.VCTR62.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR62_B2010(value uint32) {
	volatile.StoreUint32(&o.VCTR62.Reg, volatile.LoadUint32(&o.VCTR62.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR62_B2010() uint32 {
	return (volatile.LoadUint32(&o.VCTR62.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR62_B2011(value uint32) {
	volatile.StoreUint32(&o.VCTR62.Reg, volatile.LoadUint32(&o.VCTR62.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR62_B2011() uint32 {
	return (volatile.LoadUint32(&o.VCTR62.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR62_B2012(value uint32) {
	volatile.StoreUint32(&o.VCTR62.Reg, volatile.LoadUint32(&o.VCTR62.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR62_B2012() uint32 {
	return (volatile.LoadUint32(&o.VCTR62.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR62_B2013(value uint32) {
	volatile.StoreUint32(&o.VCTR62.Reg, volatile.LoadUint32(&o.VCTR62.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR62_B2013() uint32 {
	return (volatile.LoadUint32(&o.VCTR62.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR62_B2014(value uint32) {
	volatile.StoreUint32(&o.VCTR62.Reg, volatile.LoadUint32(&o.VCTR62.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR62_B2014() uint32 {
	return (volatile.LoadUint32(&o.VCTR62.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR62_B2015(value uint32) {
	volatile.StoreUint32(&o.VCTR62.Reg, volatile.LoadUint32(&o.VCTR62.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR62_B2015() uint32 {
	return (volatile.LoadUint32(&o.VCTR62.Reg) & 0x80000000) >> 31
}

// GTZC.VCTR63: MPCBBx vector register
func (o *GTZC_Type) SetVCTR63_B2016(value uint32) {
	volatile.StoreUint32(&o.VCTR63.Reg, volatile.LoadUint32(&o.VCTR63.Reg)&^(0x1)|value)
}
func (o *GTZC_Type) GetVCTR63_B2016() uint32 {
	return volatile.LoadUint32(&o.VCTR63.Reg) & 0x1
}
func (o *GTZC_Type) SetVCTR63_B2017(value uint32) {
	volatile.StoreUint32(&o.VCTR63.Reg, volatile.LoadUint32(&o.VCTR63.Reg)&^(0x2)|value<<1)
}
func (o *GTZC_Type) GetVCTR63_B2017() uint32 {
	return (volatile.LoadUint32(&o.VCTR63.Reg) & 0x2) >> 1
}
func (o *GTZC_Type) SetVCTR63_B2018(value uint32) {
	volatile.StoreUint32(&o.VCTR63.Reg, volatile.LoadUint32(&o.VCTR63.Reg)&^(0x4)|value<<2)
}
func (o *GTZC_Type) GetVCTR63_B2018() uint32 {
	return (volatile.LoadUint32(&o.VCTR63.Reg) & 0x4) >> 2
}
func (o *GTZC_Type) SetVCTR63_B2019(value uint32) {
	volatile.StoreUint32(&o.VCTR63.Reg, volatile.LoadUint32(&o.VCTR63.Reg)&^(0x8)|value<<3)
}
func (o *GTZC_Type) GetVCTR63_B2019() uint32 {
	return (volatile.LoadUint32(&o.VCTR63.Reg) & 0x8) >> 3
}
func (o *GTZC_Type) SetVCTR63_B2020(value uint32) {
	volatile.StoreUint32(&o.VCTR63.Reg, volatile.LoadUint32(&o.VCTR63.Reg)&^(0x10)|value<<4)
}
func (o *GTZC_Type) GetVCTR63_B2020() uint32 {
	return (volatile.LoadUint32(&o.VCTR63.Reg) & 0x10) >> 4
}
func (o *GTZC_Type) SetVCTR63_B2021(value uint32) {
	volatile.StoreUint32(&o.VCTR63.Reg, volatile.LoadUint32(&o.VCTR63.Reg)&^(0x20)|value<<5)
}
func (o *GTZC_Type) GetVCTR63_B2021() uint32 {
	return (volatile.LoadUint32(&o.VCTR63.Reg) & 0x20) >> 5
}
func (o *GTZC_Type) SetVCTR63_B2022(value uint32) {
	volatile.StoreUint32(&o.VCTR63.Reg, volatile.LoadUint32(&o.VCTR63.Reg)&^(0x40)|value<<6)
}
func (o *GTZC_Type) GetVCTR63_B2022() uint32 {
	return (volatile.LoadUint32(&o.VCTR63.Reg) & 0x40) >> 6
}
func (o *GTZC_Type) SetVCTR63_B2023(value uint32) {
	volatile.StoreUint32(&o.VCTR63.Reg, volatile.LoadUint32(&o.VCTR63.Reg)&^(0x80)|value<<7)
}
func (o *GTZC_Type) GetVCTR63_B2023() uint32 {
	return (volatile.LoadUint32(&o.VCTR63.Reg) & 0x80) >> 7
}
func (o *GTZC_Type) SetVCTR63_B2024(value uint32) {
	volatile.StoreUint32(&o.VCTR63.Reg, volatile.LoadUint32(&o.VCTR63.Reg)&^(0x100)|value<<8)
}
func (o *GTZC_Type) GetVCTR63_B2024() uint32 {
	return (volatile.LoadUint32(&o.VCTR63.Reg) & 0x100) >> 8
}
func (o *GTZC_Type) SetVCTR63_B2025(value uint32) {
	volatile.StoreUint32(&o.VCTR63.Reg, volatile.LoadUint32(&o.VCTR63.Reg)&^(0x200)|value<<9)
}
func (o *GTZC_Type) GetVCTR63_B2025() uint32 {
	return (volatile.LoadUint32(&o.VCTR63.Reg) & 0x200) >> 9
}
func (o *GTZC_Type) SetVCTR63_B2026(value uint32) {
	volatile.StoreUint32(&o.VCTR63.Reg, volatile.LoadUint32(&o.VCTR63.Reg)&^(0x400)|value<<10)
}
func (o *GTZC_Type) GetVCTR63_B2026() uint32 {
	return (volatile.LoadUint32(&o.VCTR63.Reg) & 0x400) >> 10
}
func (o *GTZC_Type) SetVCTR63_B2027(value uint32) {
	volatile.StoreUint32(&o.VCTR63.Reg, volatile.LoadUint32(&o.VCTR63.Reg)&^(0x800)|value<<11)
}
func (o *GTZC_Type) GetVCTR63_B2027() uint32 {
	return (volatile.LoadUint32(&o.VCTR63.Reg) & 0x800) >> 11
}
func (o *GTZC_Type) SetVCTR63_B2028(value uint32) {
	volatile.StoreUint32(&o.VCTR63.Reg, volatile.LoadUint32(&o.VCTR63.Reg)&^(0x1000)|value<<12)
}
func (o *GTZC_Type) GetVCTR63_B2028() uint32 {
	return (volatile.LoadUint32(&o.VCTR63.Reg) & 0x1000) >> 12
}
func (o *GTZC_Type) SetVCTR63_B2029(value uint32) {
	volatile.StoreUint32(&o.VCTR63.Reg, volatile.LoadUint32(&o.VCTR63.Reg)&^(0x2000)|value<<13)
}
func (o *GTZC_Type) GetVCTR63_B2029() uint32 {
	return (volatile.LoadUint32(&o.VCTR63.Reg) & 0x2000) >> 13
}
func (o *GTZC_Type) SetVCTR63_B2030(value uint32) {
	volatile.StoreUint32(&o.VCTR63.Reg, volatile.LoadUint32(&o.VCTR63.Reg)&^(0x4000)|value<<14)
}
func (o *GTZC_Type) GetVCTR63_B2030() uint32 {
	return (volatile.LoadUint32(&o.VCTR63.Reg) & 0x4000) >> 14
}
func (o *GTZC_Type) SetVCTR63_B2031(value uint32) {
	volatile.StoreUint32(&o.VCTR63.Reg, volatile.LoadUint32(&o.VCTR63.Reg)&^(0x8000)|value<<15)
}
func (o *GTZC_Type) GetVCTR63_B2031() uint32 {
	return (volatile.LoadUint32(&o.VCTR63.Reg) & 0x8000) >> 15
}
func (o *GTZC_Type) SetVCTR63_B2032(value uint32) {
	volatile.StoreUint32(&o.VCTR63.Reg, volatile.LoadUint32(&o.VCTR63.Reg)&^(0x10000)|value<<16)
}
func (o *GTZC_Type) GetVCTR63_B2032() uint32 {
	return (volatile.LoadUint32(&o.VCTR63.Reg) & 0x10000) >> 16
}
func (o *GTZC_Type) SetVCTR63_B2033(value uint32) {
	volatile.StoreUint32(&o.VCTR63.Reg, volatile.LoadUint32(&o.VCTR63.Reg)&^(0x20000)|value<<17)
}
func (o *GTZC_Type) GetVCTR63_B2033() uint32 {
	return (volatile.LoadUint32(&o.VCTR63.Reg) & 0x20000) >> 17
}
func (o *GTZC_Type) SetVCTR63_B2034(value uint32) {
	volatile.StoreUint32(&o.VCTR63.Reg, volatile.LoadUint32(&o.VCTR63.Reg)&^(0x40000)|value<<18)
}
func (o *GTZC_Type) GetVCTR63_B2034() uint32 {
	return (volatile.LoadUint32(&o.VCTR63.Reg) & 0x40000) >> 18
}
func (o *GTZC_Type) SetVCTR63_B2035(value uint32) {
	volatile.StoreUint32(&o.VCTR63.Reg, volatile.LoadUint32(&o.VCTR63.Reg)&^(0x80000)|value<<19)
}
func (o *GTZC_Type) GetVCTR63_B2035() uint32 {
	return (volatile.LoadUint32(&o.VCTR63.Reg) & 0x80000) >> 19
}
func (o *GTZC_Type) SetVCTR63_B2036(value uint32) {
	volatile.StoreUint32(&o.VCTR63.Reg, volatile.LoadUint32(&o.VCTR63.Reg)&^(0x100000)|value<<20)
}
func (o *GTZC_Type) GetVCTR63_B2036() uint32 {
	return (volatile.LoadUint32(&o.VCTR63.Reg) & 0x100000) >> 20
}
func (o *GTZC_Type) SetVCTR63_B2037(value uint32) {
	volatile.StoreUint32(&o.VCTR63.Reg, volatile.LoadUint32(&o.VCTR63.Reg)&^(0x200000)|value<<21)
}
func (o *GTZC_Type) GetVCTR63_B2037() uint32 {
	return (volatile.LoadUint32(&o.VCTR63.Reg) & 0x200000) >> 21
}
func (o *GTZC_Type) SetVCTR63_B2038(value uint32) {
	volatile.StoreUint32(&o.VCTR63.Reg, volatile.LoadUint32(&o.VCTR63.Reg)&^(0x400000)|value<<22)
}
func (o *GTZC_Type) GetVCTR63_B2038() uint32 {
	return (volatile.LoadUint32(&o.VCTR63.Reg) & 0x400000) >> 22
}
func (o *GTZC_Type) SetVCTR63_B2039(value uint32) {
	volatile.StoreUint32(&o.VCTR63.Reg, volatile.LoadUint32(&o.VCTR63.Reg)&^(0x800000)|value<<23)
}
func (o *GTZC_Type) GetVCTR63_B2039() uint32 {
	return (volatile.LoadUint32(&o.VCTR63.Reg) & 0x800000) >> 23
}
func (o *GTZC_Type) SetVCTR63_B2040(value uint32) {
	volatile.StoreUint32(&o.VCTR63.Reg, volatile.LoadUint32(&o.VCTR63.Reg)&^(0x1000000)|value<<24)
}
func (o *GTZC_Type) GetVCTR63_B2040() uint32 {
	return (volatile.LoadUint32(&o.VCTR63.Reg) & 0x1000000) >> 24
}
func (o *GTZC_Type) SetVCTR63_B2041(value uint32) {
	volatile.StoreUint32(&o.VCTR63.Reg, volatile.LoadUint32(&o.VCTR63.Reg)&^(0x2000000)|value<<25)
}
func (o *GTZC_Type) GetVCTR63_B2041() uint32 {
	return (volatile.LoadUint32(&o.VCTR63.Reg) & 0x2000000) >> 25
}
func (o *GTZC_Type) SetVCTR63_B2042(value uint32) {
	volatile.StoreUint32(&o.VCTR63.Reg, volatile.LoadUint32(&o.VCTR63.Reg)&^(0x4000000)|value<<26)
}
func (o *GTZC_Type) GetVCTR63_B2042() uint32 {
	return (volatile.LoadUint32(&o.VCTR63.Reg) & 0x4000000) >> 26
}
func (o *GTZC_Type) SetVCTR63_B2043(value uint32) {
	volatile.StoreUint32(&o.VCTR63.Reg, volatile.LoadUint32(&o.VCTR63.Reg)&^(0x8000000)|value<<27)
}
func (o *GTZC_Type) GetVCTR63_B2043() uint32 {
	return (volatile.LoadUint32(&o.VCTR63.Reg) & 0x8000000) >> 27
}
func (o *GTZC_Type) SetVCTR63_B2044(value uint32) {
	volatile.StoreUint32(&o.VCTR63.Reg, volatile.LoadUint32(&o.VCTR63.Reg)&^(0x10000000)|value<<28)
}
func (o *GTZC_Type) GetVCTR63_B2044() uint32 {
	return (volatile.LoadUint32(&o.VCTR63.Reg) & 0x10000000) >> 28
}
func (o *GTZC_Type) SetVCTR63_B2045(value uint32) {
	volatile.StoreUint32(&o.VCTR63.Reg, volatile.LoadUint32(&o.VCTR63.Reg)&^(0x20000000)|value<<29)
}
func (o *GTZC_Type) GetVCTR63_B2045() uint32 {
	return (volatile.LoadUint32(&o.VCTR63.Reg) & 0x20000000) >> 29
}
func (o *GTZC_Type) SetVCTR63_B2046(value uint32) {
	volatile.StoreUint32(&o.VCTR63.Reg, volatile.LoadUint32(&o.VCTR63.Reg)&^(0x40000000)|value<<30)
}
func (o *GTZC_Type) GetVCTR63_B2046() uint32 {
	return (volatile.LoadUint32(&o.VCTR63.Reg) & 0x40000000) >> 30
}
func (o *GTZC_Type) SetVCTR63_B2047(value uint32) {
	volatile.StoreUint32(&o.VCTR63.Reg, volatile.LoadUint32(&o.VCTR63.Reg)&^(0x80000000)|value<<31)
}
func (o *GTZC_Type) GetVCTR63_B2047() uint32 {
	return (volatile.LoadUint32(&o.VCTR63.Reg) & 0x80000000) >> 31
}

// Power control
type PWR_Type struct {
	CR1      volatile.Register32 // 0x0
	CR2      volatile.Register32 // 0x4
	CR3      volatile.Register32 // 0x8
	CR4      volatile.Register32 // 0xC
	SR1      volatile.Register32 // 0x10
	SR2      volatile.Register32 // 0x14
	SCR      volatile.Register32 // 0x18
	_        [4]byte
	PUCRA    volatile.Register32 // 0x20
	PDCRA    volatile.Register32 // 0x24
	PUCRB    volatile.Register32 // 0x28
	PDCRB    volatile.Register32 // 0x2C
	PUCRC    volatile.Register32 // 0x30
	PDCRC    volatile.Register32 // 0x34
	PUCRD    volatile.Register32 // 0x38
	PDCRD    volatile.Register32 // 0x3C
	PUCRE    volatile.Register32 // 0x40
	PDCRE    volatile.Register32 // 0x44
	PUCRF    volatile.Register32 // 0x48
	PDCRF    volatile.Register32 // 0x4C
	PUCRG    volatile.Register32 // 0x50
	PDCRG    volatile.Register32 // 0x54
	PUCRH    volatile.Register32 // 0x58
	PDCRH    volatile.Register32 // 0x5C
	_        [24]byte
	SECCFGR  volatile.Register32 // 0x78
	_        [4]byte
	PRIVCFGR volatile.Register32 // 0x80
}

// PWR.CR1: Power control register 1
func (o *PWR_Type) SetCR1_LPR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetCR1_LPR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetCR1_VOS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x600)|value<<9)
}
func (o *PWR_Type) GetCR1_VOS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x600) >> 9
}
func (o *PWR_Type) SetCR1_DBP(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCR1_DBP() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCR1_LPMS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x7)|value)
}
func (o *PWR_Type) GetCR1_LPMS() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x7
}

// PWR.CR2: Power control register 2
func (o *PWR_Type) SetCR2_USV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetCR2_USV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetCR2_IOSV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetCR2_IOSV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetCR2_PVME4(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetCR2_PVME4() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetCR2_PVME3(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetCR2_PVME3() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetCR2_PVME2(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetCR2_PVME2() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetCR2_PVME1(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetCR2_PVME1() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetCR2_PLS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xe)|value<<1)
}
func (o *PWR_Type) GetCR2_PLS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xe) >> 1
}
func (o *PWR_Type) SetCR2_PVDE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCR2_PVDE() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}

// PWR.CR3: Power control register 3
func (o *PWR_Type) SetCR3_UCPD_DBDIS(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetCR3_UCPD_DBDIS() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetCR3_UCPD_STDBY(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetCR3_UCPD_STDBY() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetCR3_ULPMEN(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetCR3_ULPMEN() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetCR3_APC(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetCR3_APC() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetCR3_RRS(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x300)|value<<8)
}
func (o *PWR_Type) GetCR3_RRS() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x300) >> 8
}
func (o *PWR_Type) SetCR3_EWUP5(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetCR3_EWUP5() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetCR3_EWUP4(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetCR3_EWUP4() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetCR3_EWUP3(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetCR3_EWUP3() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetCR3_EWUP2(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetCR3_EWUP2() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetCR3_EWUP1(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCR3_EWUP1() uint32 {
	return volatile.LoadUint32(&o.CR3.Reg) & 0x1
}

// PWR.CR4: Power control register 4
func (o *PWR_Type) SetCR4_SMPSLPEN(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetCR4_SMPSLPEN() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetCR4_SMPSFSTEN(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetCR4_SMPSFSTEN() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetCR4_EXTSMPSEN(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetCR4_EXTSMPSEN() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetCR4_SMPSBYP(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetCR4_SMPSBYP() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetCR4_VBRS(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetCR4_VBRS() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetCR4_VBE(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCR4_VBE() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCR4_WUPP5(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetCR4_WUPP5() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetCR4_WUPP4(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetCR4_WUPP4() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetCR4_WUPP3(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetCR4_WUPP3() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetCR4_WUPP2(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetCR4_WUPP2() uint32 {
	return (volatile.LoadUint32(&o.CR4.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetCR4_WUPP1(value uint32) {
	volatile.StoreUint32(&o.CR4.Reg, volatile.LoadUint32(&o.CR4.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCR4_WUPP1() uint32 {
	return volatile.LoadUint32(&o.CR4.Reg) & 0x1
}

// PWR.SR1: Power status register 1
func (o *PWR_Type) SetSR1_SMPSHPRDY(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetSR1_SMPSHPRDY() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetSR1_EXTSMPSRDY(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetSR1_EXTSMPSRDY() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetSR1_SMPSBYPRDY(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetSR1_SMPSBYPRDY() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetSR1_SBF(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetSR1_SBF() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetSR1_WUF5(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetSR1_WUF5() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetSR1_WUF4(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetSR1_WUF4() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetSR1_WUF3(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetSR1_WUF3() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetSR1_WUF2(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetSR1_WUF2() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetSR1_WUF1(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetSR1_WUF1() uint32 {
	return volatile.LoadUint32(&o.SR1.Reg) & 0x1
}

// PWR.SR2: Power status register 2
func (o *PWR_Type) SetSR2_PVMO4(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetSR2_PVMO4() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetSR2_PVMO3(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetSR2_PVMO3() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetSR2_PVMO2(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetSR2_PVMO2() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetSR2_PVMO1(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetSR2_PVMO1() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetSR2_PVDO(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetSR2_PVDO() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetSR2_VOSF(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetSR2_VOSF() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetSR2_REGLPF(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetSR2_REGLPF() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetSR2_REGLPS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetSR2_REGLPS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x100) >> 8
}

// PWR.SCR: Power status clear register
func (o *PWR_Type) SetSCR_CSBF(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetSCR_CSBF() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetSCR_CWUF5(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetSCR_CWUF5() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetSCR_CWUF4(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetSCR_CWUF4() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetSCR_CWUF3(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetSCR_CWUF3() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetSCR_CWUF2(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetSCR_CWUF2() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetSCR_CWUF1(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetSCR_CWUF1() uint32 {
	return volatile.LoadUint32(&o.SCR.Reg) & 0x1
}

// PWR.PUCRA: Power Port A pull-up control register
func (o *PWR_Type) SetPUCRA_PU15(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPUCRA_PU15() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPUCRA_PU14(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetPUCRA_PU14() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetPUCRA_PU13(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetPUCRA_PU13() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetPUCRA_PU12(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetPUCRA_PU12() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetPUCRA_PU11(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetPUCRA_PU11() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetPUCRA_PU10(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetPUCRA_PU10() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetPUCRA_PU9(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetPUCRA_PU9() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetPUCRA_PU8(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetPUCRA_PU8() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetPUCRA_PU7(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x80)|value<<7)
}
func (o *PWR_Type) GetPUCRA_PU7() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x80) >> 7
}
func (o *PWR_Type) SetPUCRA_PU6(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x40)|value<<6)
}
func (o *PWR_Type) GetPUCRA_PU6() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x40) >> 6
}
func (o *PWR_Type) SetPUCRA_PU5(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetPUCRA_PU5() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetPUCRA_PU4(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetPUCRA_PU4() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetPUCRA_PU3(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetPUCRA_PU3() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetPUCRA_PU2(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetPUCRA_PU2() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetPUCRA_PU1(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetPUCRA_PU1() uint32 {
	return (volatile.LoadUint32(&o.PUCRA.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetPUCRA_PU0(value uint32) {
	volatile.StoreUint32(&o.PUCRA.Reg, volatile.LoadUint32(&o.PUCRA.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetPUCRA_PU0() uint32 {
	return volatile.LoadUint32(&o.PUCRA.Reg) & 0x1
}

// PWR.PDCRA: Power Port A pull-down control register
func (o *PWR_Type) SetPDCRA_PD15(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x8000)|value<<15)
}
func (o *PWR_Type) GetPDCRA_PD15() uint32 {
	return (volatile.LoadUint32(&o.PDCRA.Reg) & 0x8000) >> 15
}
func (o *PWR_Type) SetPDCRA_PD14(value uint32) {
	volatile.StoreUint32(&o.PDCRA.Reg, volatile.LoadUint32(&o.PDCRA.Reg)&^(0x