/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELManager;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.el.Util;

public class BeanELResolver
extends ELResolver {
    private static final int CACHE_SIZE;
    private static final String CACHE_SIZE_PROP = "org.apache.el.BeanELResolver.CACHE_SIZE";
    private final boolean readOnly;
    private final ConcurrentCache<String, BeanProperties> cache = new ConcurrentCache(CACHE_SIZE);

    public BeanELResolver() {
        this.readOnly = false;
    }

    public BeanELResolver(boolean bl) {
        this.readOnly = bl;
    }

    @Override
    public Class<?> getType(ELContext eLContext, Object object, Object object2) {
        Objects.requireNonNull(eLContext);
        if (object == null || object2 == null) {
            return null;
        }
        eLContext.setPropertyResolved(object, object2);
        return this.property(eLContext, object, object2).getPropertyType();
    }

    @Override
    public Object getValue(ELContext eLContext, Object object, Object object2) {
        Objects.requireNonNull(eLContext);
        if (object == null || object2 == null) {
            return null;
        }
        eLContext.setPropertyResolved(object, object2);
        Method method = this.property(eLContext, object, object2).read(eLContext, object);
        try {
            return method.invoke(object, (Object[])null);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            Util.handleThrowable(throwable);
            throw new ELException(Util.message(eLContext, "propertyReadError", object.getClass().getName(), object2.toString()), throwable);
        }
        catch (Exception exception) {
            throw new ELException(exception);
        }
    }

    @Override
    public void setValue(ELContext eLContext, Object object, Object object2, Object object3) {
        Objects.requireNonNull(eLContext);
        if (object == null || object2 == null) {
            return;
        }
        eLContext.setPropertyResolved(object, object2);
        if (this.readOnly) {
            throw new PropertyNotWritableException(Util.message(eLContext, "resolverNotWritable", object.getClass().getName()));
        }
        Method method = this.property(eLContext, object, object2).write(eLContext, object);
        try {
            method.invoke(object, object3);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            Util.handleThrowable(throwable);
            throw new ELException(Util.message(eLContext, "propertyWriteError", object.getClass().getName(), object2.toString()), throwable);
        }
        catch (Exception exception) {
            throw new ELException(exception);
        }
    }

    @Override
    public Object invoke(ELContext eLContext, Object object, Object object2, Class<?>[] classArray, Object[] objectArray) {
        Objects.requireNonNull(eLContext);
        if (object == null || object2 == null) {
            return null;
        }
        ExpressionFactory expressionFactory = ELManager.getExpressionFactory();
        String string = (String)expressionFactory.coerceToType(object2, String.class);
        Method method = Util.findMethod(object.getClass(), object, string, classArray, objectArray);
        Object[] objectArray2 = Util.buildParameters(method.getParameterTypes(), method.isVarArgs(), objectArray);
        Object object3 = null;
        try {
            object3 = method.invoke(object, objectArray2);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            throw new ELException(exception);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            Util.handleThrowable(throwable);
            throw new ELException(throwable);
        }
        eLContext.setPropertyResolved(object, object2);
        return object3;
    }

    @Override
    public boolean isReadOnly(ELContext eLContext, Object object, Object object2) {
        Objects.requireNonNull(eLContext);
        if (object == null || object2 == null) {
            return false;
        }
        eLContext.setPropertyResolved(object, object2);
        return this.readOnly || this.property(eLContext, object, object2).isReadOnly(object);
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext eLContext, Object object) {
        if (object == null) {
            return null;
        }
        try {
            PropertyDescriptor[] propertyDescriptorArray;
            BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
            for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray = beanInfo.getPropertyDescriptors()) {
                propertyDescriptor.setValue("resolvableAtDesignTime", Boolean.TRUE);
                propertyDescriptor.setValue("type", propertyDescriptor.getPropertyType());
            }
            return Arrays.asList((FeatureDescriptor[])propertyDescriptorArray).iterator();
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext eLContext, Object object) {
        if (object != null) {
            return Object.class;
        }
        return null;
    }

    private final BeanProperty property(ELContext eLContext, Object object, Object object2) {
        Class<?> clazz = object.getClass();
        String string = object2.toString();
        BeanProperties beanProperties = this.cache.get(clazz.getName());
        if (beanProperties == null || clazz != beanProperties.getType()) {
            beanProperties = new BeanProperties(clazz);
            this.cache.put(clazz.getName(), beanProperties);
        }
        return beanProperties.get(eLContext, string);
    }

    static {
        String string = System.getSecurityManager() == null ? System.getProperty(CACHE_SIZE_PROP, "1000") : AccessController.doPrivileged(() -> System.getProperty(CACHE_SIZE_PROP, "1000"));
        CACHE_SIZE = Integer.parseInt(string);
    }

    private static final class ConcurrentCache<K, V> {
        private final int size;
        private final Map<K, V> eden;
        private final Map<K, V> longterm;

        public ConcurrentCache(int n) {
            this.size = n;
            this.eden = new ConcurrentHashMap(n);
            this.longterm = new WeakHashMap(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V get(K k) {
            V v = this.eden.get(k);
            if (v == null) {
                Map<K, V> map = this.longterm;
                synchronized (map) {
                    v = this.longterm.get(k);
                }
                if (v != null) {
                    this.eden.put(k, v);
                }
            }
            return v;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(K k, V v) {
            if (this.eden.size() >= this.size) {
                Map<K, V> map = this.longterm;
                synchronized (map) {
                    this.longterm.putAll(this.eden);
                }
                this.eden.clear();
            }
            this.eden.put(k, v);
        }
    }

    static final class BeanProperty {
        private final Class<?> type;
        private final Class<?> owner;
        private final PropertyDescriptor descriptor;
        private Method read;
        private Method write;

        public BeanProperty(Class<?> clazz, PropertyDescriptor propertyDescriptor) {
            this.owner = clazz;
            this.descriptor = propertyDescriptor;
            this.type = propertyDescriptor.getPropertyType();
        }

        public Class<?> getPropertyType() {
            return this.type;
        }

        public boolean isReadOnly(Object object) {
            return this.write == null && null == (this.write = Util.getMethod(this.owner, object, this.descriptor.getWriteMethod()));
        }

        private Method write(ELContext eLContext, Object object) {
            if (this.write == null) {
                this.write = Util.getMethod(this.owner, object, this.descriptor.getWriteMethod());
                if (this.write == null) {
                    throw new PropertyNotWritableException(Util.message(eLContext, "propertyNotWritable", this.owner.getName(), this.descriptor.getName()));
                }
            }
            return this.write;
        }

        private Method read(ELContext eLContext, Object object) {
            if (this.read == null) {
                this.read = Util.getMethod(this.owner, object, this.descriptor.getReadMethod());
                if (this.read == null) {
                    throw new PropertyNotFoundException(Util.message(eLContext, "propertyNotReadable", this.owner.getName(), this.descriptor.getName()));
                }
            }
            return this.read;
        }
    }

    static final class BeanProperties {
        private final Map<String, BeanProperty> properties;
        private final Class<?> type;

        public BeanProperties(Class<?> clazz) throws ELException {
            this.type = clazz;
            this.properties = new HashMap<String, BeanProperty>();
            try {
                PropertyDescriptor[] propertyDescriptorArray;
                BeanInfo beanInfo = Introspector.getBeanInfo(this.type);
                for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray = beanInfo.getPropertyDescriptors()) {
                    this.properties.put(propertyDescriptor.getName(), new BeanProperty(clazz, propertyDescriptor));
                }
                if (System.getSecurityManager() != null) {
                    this.populateFromInterfaces(clazz);
                }
            }
            catch (IntrospectionException introspectionException) {
                throw new ELException(introspectionException);
            }
        }

        private void populateFromInterfaces(Class<?> clazz) throws IntrospectionException {
            Object object;
            Class<?>[] classArray = clazz.getInterfaces();
            if (classArray.length > 0) {
                object = classArray;
                int n = ((Class<?>[])object).length;
                for (int i = 0; i < n; ++i) {
                    PropertyDescriptor[] propertyDescriptorArray;
                    Class<?> clazz2 = object[i];
                    BeanInfo beanInfo = Introspector.getBeanInfo(clazz2);
                    for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray = beanInfo.getPropertyDescriptors()) {
                        if (this.properties.containsKey(propertyDescriptor.getName())) continue;
                        this.properties.put(propertyDescriptor.getName(), new BeanProperty(this.type, propertyDescriptor));
                    }
                    this.populateFromInterfaces(clazz2);
                }
            }
            if ((object = clazz.getSuperclass()) != null) {
                this.populateFromInterfaces((Class<?>)object);
            }
        }

        private BeanProperty get(ELContext eLContext, String string) {
            BeanProperty beanProperty = this.properties.get(string);
            if (beanProperty == null) {
                throw new PropertyNotFoundException(Util.message(eLContext, "propertyNotFound", this.type.getName(), string));
            }
            return beanProperty;
        }

        private Class<?> getType() {
            return this.type;
        }
    }
}

