/* PlaceItem.c generated by valac 0.56.0, the Vala compiler
 * generated from PlaceItem.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "placesindicator.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>

enum  {
	PLACE_ITEM_0_PROPERTY,
	PLACE_ITEM_NUM_PROPERTIES
};
static GParamSpec* place_item_properties[PLACE_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _Block3Data {
	int _ref_count_;
	PlaceItem* self;
	GFile* file;
};

static gpointer place_item_parent_class = NULL;
static GType place_item_type_id = 0;

static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda6_ (Block3Data* _data3_);
static void ___lambda6__gtk_tool_button_clicked (GtkToolButton* _sender,
                                          gpointer self);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		PlaceItem* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->file);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
__lambda6_ (Block3Data* _data3_)
{
	PlaceItem* self;
	self = _data3_->self;
	list_item_open_directory ((ListItem*) self, _data3_->file);
}

static void
___lambda6__gtk_tool_button_clicked (GtkToolButton* _sender,
                                     gpointer self)
{
	__lambda6_ (self);
}

PlaceItem*
place_item_construct (GType object_type,
                      GFile* file,
                      const gchar* class,
                      const gchar* bookmark_name)
{
	PlaceItem * self = NULL;
	Block3Data* _data3_;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* name = NULL;
	gchar* _tmp2_;
	GtkToolButton* _tmp36_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	GtkToolButton* _tmp42_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (class != NULL, NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (_data3_->file);
	_data3_->file = _tmp0_;
	self = (PlaceItem*) list_item_construct (object_type);
	_data3_->self = g_object_ref (self);
	_tmp1_ = g_strdup (class);
	_g_free0 (((ListItem*) self)->item_class);
	((ListItem*) self)->item_class = _tmp1_;
	_tmp2_ = g_strdup ("");
	name = _tmp2_;
	if (bookmark_name != NULL) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (bookmark_name);
		_g_free0 (name);
		name = _tmp3_;
	} else {
		gboolean _tmp4_ = FALSE;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = g_file_get_basename (_data3_->file);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strcmp0 (_tmp6_, "/") == 0;
		_g_free0 (_tmp6_);
		if (_tmp7_) {
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp8_ = g_file_get_uri (_data3_->file);
			_tmp9_ = _tmp8_;
			_tmp4_ = g_strcmp0 (_tmp9_, "file:///") != 0;
			_g_free0 (_tmp9_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar** _tmp12_;
			gchar** _tmp13_;
			gchar** _tmp14_;
			gint _tmp14__length1;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			const gchar* _tmp17_;
			_tmp10_ = g_file_get_uri (_data3_->file);
			_tmp11_ = _tmp10_;
			_tmp13_ = _tmp12_ = g_strsplit (_tmp11_, "://", 0);
			_tmp14_ = _tmp13_;
			_tmp14__length1 = _vala_array_length (_tmp12_);
			_tmp15_ = _tmp14_[1];
			_tmp16_ = g_strdup (_tmp15_);
			_g_free0 (name);
			name = _tmp16_;
			_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (_tmp11_);
			_tmp17_ = name;
			if (g_str_has_suffix (_tmp17_, "/")) {
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
				gchar* _tmp22_;
				_tmp18_ = name;
				_tmp19_ = name;
				_tmp20_ = strlen (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = string_slice (_tmp18_, (glong) 0, (glong) (_tmp21_ - 1));
				_g_free0 (name);
				name = _tmp22_;
			}
		} else {
			gchar* _tmp23_;
			_tmp23_ = g_file_get_basename (_data3_->file);
			_g_free0 (name);
			name = _tmp23_;
		}
	}
	{
		GFileInfo* info = NULL;
		GFileInfo* _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		GIcon* _tmp28_;
		GtkImage* _tmp29_;
		GtkImage* _tmp30_;
		_tmp24_ = g_file_query_info (_data3_->file, "standard::symbolic-icon", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		info = _tmp24_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp25_ = name;
		_tmp26_ = string_strip (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_file_info_get_symbolic_icon (info);
		_tmp29_ = list_item_get_icon ((ListItem*) self, _tmp28_);
		_tmp30_ = _tmp29_;
		list_item_set_button ((ListItem*) self, _tmp27_, _tmp30_, FALSE, FALSE);
		_g_object_unref0 (_tmp30_);
		_g_free0 (_tmp27_);
		_g_object_unref0 (info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		const gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		GtkImage* _tmp34_;
		GtkImage* _tmp35_;
		g_clear_error (&_inner_error0_);
		_tmp31_ = name;
		_tmp32_ = string_strip (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = list_item_get_icon ((ListItem*) self, NULL);
		_tmp35_ = _tmp34_;
		list_item_set_button ((ListItem*) self, _tmp33_, _tmp35_, FALSE, FALSE);
		_g_object_unref0 (_tmp35_);
		_g_free0 (_tmp33_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (name);
		block3_data_unref (_data3_);
		_data3_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp36_ = ((ListItem*) self)->name_button;
	_tmp37_ = name;
	_tmp38_ = string_strip (_tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = g_strdup_printf ("Open \"%s\"", _tmp39_);
	_tmp41_ = _tmp40_;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp36_, _ (_tmp41_));
	_g_free0 (_tmp41_);
	_g_free0 (_tmp39_);
	_tmp42_ = ((ListItem*) self)->name_button;
	g_signal_connect_data (_tmp42_, "clicked", (GCallback) ___lambda6__gtk_tool_button_clicked, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_g_free0 (name);
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return self;
}

PlaceItem*
place_item_new (GFile* file,
                const gchar* class,
                const gchar* bookmark_name)
{
	return place_item_construct (TYPE_PLACE_ITEM, file, class, bookmark_name);
}

static void
place_item_class_init (PlaceItemClass * klass,
                       gpointer klass_data)
{
	place_item_parent_class = g_type_class_peek_parent (klass);
}

static void
place_item_instance_init (PlaceItem * self,
                          gpointer klass)
{
}

GType
place_item_get_type (void)
{
	return place_item_type_id;
}

GType
place_item_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlaceItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) place_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlaceItem), 0, (GInstanceInitFunc) place_item_instance_init, NULL };
	place_item_type_id = g_type_module_register_type (module, TYPE_LIST_ITEM, "PlaceItem", &g_define_type_info, 0);
	return place_item_type_id;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

