/* PlacesIndicatorWindow.c generated by valac 0.56.0, the Vala compiler
 * generated from PlacesIndicatorWindow.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "placesindicator.h"
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "plugin.h"
#include <glib-object.h>
#include <glib/gi18n-lib.h>

enum  {
	PLACES_INDICATOR_WINDOW_0_PROPERTY,
	PLACES_INDICATOR_WINDOW_EXPAND_PLACES_PROPERTY,
	PLACES_INDICATOR_WINDOW_SHOW_PLACES_PROPERTY,
	PLACES_INDICATOR_WINDOW_SHOW_DRIVES_PROPERTY,
	PLACES_INDICATOR_WINDOW_SHOW_NETWORKS_PROPERTY,
	PLACES_INDICATOR_WINDOW_NUM_PROPERTIES
};
static GParamSpec* places_indicator_window_properties[PLACES_INDICATOR_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _PlacesIndicatorWindowPrivate {
	GVolumeMonitor* volume_monitor;
	MessageRevealer* message_bar;
	PlacesSection* places_section;
	GtkListBox* mounts_listbox;
	GtkListBox* networks_listbox;
	GtkBox* placeholder;
	GHashTable* places_list;
	gboolean _expand_places;
	gboolean _show_places;
	gboolean _show_drives;
	gboolean _show_networks;
	gboolean only_places;
	GFileMonitor* bookmarks_monitor;
	GUserDirectory* DEFAULT_DIRECTORIES;
	gint DEFAULT_DIRECTORIES_length1;
	gint _DEFAULT_DIRECTORIES_size_;
};

static gint PlacesIndicatorWindow_private_offset;
static gpointer places_indicator_window_parent_class = NULL;
static GType places_indicator_window_type_id = 0;

static void _g_free0_ (gpointer var);
static void places_indicator_window_list_header_func (PlacesIndicatorWindow* self,
                                               GtkListBoxRow* before,
                                               GtkListBoxRow* after);
static void _places_indicator_window_list_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                                GtkListBoxRow* before,
                                                                                gpointer self);
static GtkBox* places_indicator_window_set_up_placeholder (PlacesIndicatorWindow* self);
static void places_indicator_window_connect_signals (PlacesIndicatorWindow* self);
static void places_indicator_window_refresh_special_dirs (PlacesIndicatorWindow* self);
static void places_indicator_window_refresh_mounts (PlacesIndicatorWindow* self);
static void places_indicator_window_real_closed (BudgiePopover* base);
static void places_indicator_window_check_expand (PlacesIndicatorWindow* self);
static GFile* places_indicator_window_get_bookmarks_file (PlacesIndicatorWindow* self);
static void places_indicator_window_connect_bookmarks_monitor (PlacesIndicatorWindow* self);
static void places_indicator_window_on_bookmarks_change (PlacesIndicatorWindow* self,
                                                  GFile* src,
                                                  GFile* dest,
                                                  GFileMonitorEvent event);
static void _places_indicator_window_on_bookmarks_change_g_file_monitor_changed (GFileMonitor* _sender,
                                                                          GFile* file,
                                                                          GFile* other_file,
                                                                          GFileMonitorEvent event_type,
                                                                          gpointer self);
static void _places_indicator_window_refresh_mounts_g_volume_monitor_volume_added (GVolumeMonitor* _sender,
                                                                            GVolume* volume,
                                                                            gpointer self);
static void _places_indicator_window_refresh_mounts_g_volume_monitor_volume_removed (GVolumeMonitor* _sender,
                                                                              GVolume* volume,
                                                                              gpointer self);
static void _places_indicator_window_refresh_mounts_g_volume_monitor_drive_connected (GVolumeMonitor* _sender,
                                                                               GDrive* drive,
                                                                               gpointer self);
static void _places_indicator_window_refresh_mounts_g_volume_monitor_drive_disconnected (GVolumeMonitor* _sender,
                                                                                  GDrive* drive,
                                                                                  gpointer self);
static void _places_indicator_window_refresh_mounts_g_volume_monitor_mount_added (GVolumeMonitor* _sender,
                                                                           GMount* mount,
                                                                           gpointer self);
static void _places_indicator_window_refresh_mounts_g_volume_monitor_mount_removed (GVolumeMonitor* _sender,
                                                                             GMount* mount,
                                                                             gpointer self);
static void places_indicator_window_toggle_section_visibility (PlacesIndicatorWindow* self,
                                                        const gchar* section);
static void places_indicator_window_refresh_bookmarks (PlacesIndicatorWindow* self);
static void places_indicator_window_add_place (PlacesIndicatorWindow* self,
                                        const gchar* path,
                                        const gchar* class);
static void places_indicator_window_add_volume (PlacesIndicatorWindow* self,
                                         GVolume* volume);
static void places_indicator_window_add_mount (PlacesIndicatorWindow* self,
                                        GMount* mount,
                                        const gchar* mount_class);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void __lambda9_ (PlacesIndicatorWindow* self);
static void ___lambda9__list_item_close_popover (ListItem* _sender,
                                          gpointer self);
static void places_indicator_window_set_message (PlacesIndicatorWindow* self,
                                          const gchar* message);
static void _places_indicator_window_set_message_list_item_send_message (ListItem* _sender,
                                                                  const gchar* message_content,
                                                                  gpointer self);
static void __lambda12_ (PlacesIndicatorWindow* self);
static void ___lambda12__list_item_close_popover (ListItem* _sender,
                                           gpointer self);
static void __lambda7_ (PlacesIndicatorWindow* self);
static void ___lambda7__list_item_close_popover (ListItem* _sender,
                                          gpointer self);
static void places_indicator_window_finalize (GObject * obj);
static void _vala_places_indicator_window_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_places_indicator_window_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
places_indicator_window_get_instance_private (PlacesIndicatorWindow* self)
{
	return G_STRUCT_MEMBER_P (self, PlacesIndicatorWindow_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_places_indicator_window_list_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                           GtkListBoxRow* before,
                                                                           gpointer self)
{
	places_indicator_window_list_header_func ((PlacesIndicatorWindow*) self, row, before);
}

PlacesIndicatorWindow*
places_indicator_window_construct (GType object_type,
                                   GtkWidget* window_parent)
{
	PlacesIndicatorWindow * self = NULL;
	GtkStyleContext* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	GtkBox* main_content = NULL;
	GtkBox* _tmp4_;
	GtkStyleContext* _tmp5_;
	MessageRevealer* _tmp6_;
	MessageRevealer* _tmp7_;
	MessageRevealer* _tmp8_;
	PlacesSection* _tmp9_;
	PlacesSection* _tmp10_;
	GtkListBox* _tmp11_;
	GtkListBox* _tmp12_;
	GtkListBox* _tmp13_;
	GtkListBox* _tmp14_;
	GtkListBox* _tmp15_;
	GtkListBox* _tmp16_;
	GtkListBox* _tmp17_;
	GtkListBox* _tmp18_;
	GtkBox* _tmp19_;
	GtkBox* _tmp20_;
	GtkBox* _tmp21_;
	GVolumeMonitor* _tmp22_;
	self = (PlacesIndicatorWindow*) g_object_new (object_type, "relative-to", window_parent, NULL);
	gtk_widget_set_size_request ((GtkWidget*) self, 280, 0);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "places-menu");
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->places_list);
	self->priv->places_list = _tmp3_;
	_tmp4_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp4_);
	main_content = _tmp4_;
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) main_content);
	gtk_style_context_add_class (_tmp5_, "container");
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) main_content);
	_tmp6_ = message_revealer_new ();
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->message_bar);
	self->priv->message_bar = _tmp6_;
	_tmp7_ = self->priv->message_bar;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp7_, TRUE);
	_tmp8_ = self->priv->message_bar;
	gtk_box_pack_start (main_content, (GtkWidget*) _tmp8_, FALSE, TRUE, (guint) 0);
	_tmp9_ = places_section_new ();
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->places_section);
	self->priv->places_section = _tmp9_;
	_tmp10_ = self->priv->places_section;
	gtk_box_pack_start (main_content, (GtkWidget*) _tmp10_, FALSE, TRUE, (guint) 0);
	_tmp11_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->mounts_listbox);
	self->priv->mounts_listbox = _tmp11_;
	_tmp12_ = self->priv->mounts_listbox;
	gtk_list_box_set_selection_mode (_tmp12_, GTK_SELECTION_NONE);
	_tmp13_ = self->priv->mounts_listbox;
	gtk_list_box_set_header_func (_tmp13_, _places_indicator_window_list_header_func_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
	_tmp14_ = self->priv->mounts_listbox;
	gtk_box_pack_start (main_content, (GtkWidget*) _tmp14_, TRUE, TRUE, (guint) 0);
	_tmp15_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->networks_listbox);
	self->priv->networks_listbox = _tmp15_;
	_tmp16_ = self->priv->networks_listbox;
	gtk_list_box_set_selection_mode (_tmp16_, GTK_SELECTION_NONE);
	_tmp17_ = self->priv->networks_listbox;
	gtk_list_box_set_header_func (_tmp17_, _places_indicator_window_list_header_func_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
	_tmp18_ = self->priv->networks_listbox;
	gtk_box_pack_start (main_content, (GtkWidget*) _tmp18_, TRUE, TRUE, (guint) 0);
	_tmp19_ = places_indicator_window_set_up_placeholder (self);
	_g_object_unref0 (self->priv->placeholder);
	self->priv->placeholder = _tmp19_;
	_tmp20_ = self->priv->placeholder;
	gtk_box_pack_start (main_content, (GtkWidget*) _tmp20_, TRUE, TRUE, (guint) 0);
	_tmp21_ = self->priv->placeholder;
	gtk_widget_hide ((GtkWidget*) _tmp21_);
	_tmp22_ = g_volume_monitor_get ();
	_g_object_unref0 (self->priv->volume_monitor);
	self->priv->volume_monitor = _tmp22_;
	places_indicator_window_connect_signals (self);
	places_indicator_window_refresh_special_dirs (self);
	places_indicator_window_refresh_mounts (self);
	gtk_widget_show_all ((GtkWidget*) main_content);
	_g_object_unref0 (main_content);
	return self;
}

PlacesIndicatorWindow*
places_indicator_window_new (GtkWidget* window_parent)
{
	return places_indicator_window_construct (TYPE_PLACES_INDICATOR_WINDOW, window_parent);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
places_indicator_window_real_closed (BudgiePopover* base)
{
	PlacesIndicatorWindow * self;
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	GtkListBox* _tmp7_;
	GList* _tmp8_;
	PlacesSection* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	MessageRevealer* _tmp17_;
	self = (PlacesIndicatorWindow*) base;
	_tmp0_ = self->priv->mounts_listbox;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = _tmp1_;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			GtkWidget* _tmp2_;
			GtkWidget* item = NULL;
			_tmp2_ = _g_object_ref0 ((GtkWidget*) item_it->data);
			item = _tmp2_;
			{
				ListItem* list_item = NULL;
				GtkWidget* _tmp3_;
				GtkWidget* _tmp4_;
				ListItem* _tmp5_;
				ListItem* _tmp6_;
				_tmp3_ = item;
				_tmp4_ = gtk_bin_get_child ((GtkBin*) G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_list_box_row_get_type (), GtkListBoxRow));
				_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_LIST_ITEM, ListItem));
				list_item = _tmp5_;
				_tmp6_ = list_item;
				list_item_cancel_operation (_tmp6_);
				_g_object_unref0 (list_item);
				_g_object_unref0 (item);
			}
		}
		(item_collection == NULL) ? NULL : (item_collection = (g_list_free (item_collection), NULL));
	}
	_tmp7_ = self->priv->networks_listbox;
	_tmp8_ = gtk_container_get_children ((GtkContainer*) _tmp7_);
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = _tmp8_;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			GtkWidget* _tmp9_;
			GtkWidget* item = NULL;
			_tmp9_ = _g_object_ref0 ((GtkWidget*) item_it->data);
			item = _tmp9_;
			{
				ListItem* list_item = NULL;
				GtkWidget* _tmp10_;
				GtkWidget* _tmp11_;
				ListItem* _tmp12_;
				ListItem* _tmp13_;
				_tmp10_ = item;
				_tmp11_ = gtk_bin_get_child ((GtkBin*) G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_list_box_row_get_type (), GtkListBoxRow));
				_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_LIST_ITEM, ListItem));
				list_item = _tmp12_;
				_tmp13_ = list_item;
				list_item_cancel_operation (_tmp13_);
				_g_object_unref0 (list_item);
				_g_object_unref0 (item);
			}
		}
		(item_collection == NULL) ? NULL : (item_collection = (g_list_free (item_collection), NULL));
	}
	_tmp14_ = self->priv->places_section;
	_tmp15_ = places_indicator_window_get_expand_places (self);
	_tmp16_ = _tmp15_;
	places_section_reveal (_tmp14_, _tmp16_);
	_tmp17_ = self->priv->message_bar;
	message_revealer_hide_it (_tmp17_);
	places_indicator_window_check_expand (self);
}

/**
 * Provide section headers in the mounts list
 * Ripped out of budgie-menu
 */
static void
places_indicator_window_list_header_func (PlacesIndicatorWindow* self,
                                          GtkListBoxRow* before,
                                          GtkListBoxRow* after)
{
	ListItem* child = NULL;
	gchar* prev = NULL;
	gchar* next = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	g_return_if_fail (self != NULL);
	child = NULL;
	prev = NULL;
	next = NULL;
	if (before != NULL) {
		GtkWidget* _tmp0_;
		ListItem* _tmp1_;
		ListItem* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = gtk_bin_get_child ((GtkBin*) before);
		_tmp1_ = _g_object_ref0 (IS_LIST_ITEM (_tmp0_) ? ((ListItem*) _tmp0_) : NULL);
		_g_object_unref0 (child);
		child = _tmp1_;
		_tmp2_ = child;
		_tmp3_ = list_item_get_item_category (_tmp2_);
		_g_free0 (prev);
		prev = _tmp3_;
	}
	if (after != NULL) {
		GtkWidget* _tmp4_;
		ListItem* _tmp5_;
		ListItem* _tmp6_;
		gchar* _tmp7_;
		_tmp4_ = gtk_bin_get_child ((GtkBin*) after);
		_tmp5_ = _g_object_ref0 (IS_LIST_ITEM (_tmp4_) ? ((ListItem*) _tmp4_) : NULL);
		_g_object_unref0 (child);
		child = _tmp5_;
		_tmp6_ = child;
		_tmp7_ = list_item_get_item_category (_tmp6_);
		_g_free0 (next);
		next = _tmp7_;
	}
	if (before == NULL) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = after == NULL;
	}
	if (_tmp9_) {
		_tmp8_ = TRUE;
	} else {
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp10_ = prev;
		_tmp11_ = next;
		_tmp8_ = g_strcmp0 (_tmp10_, _tmp11_) != 0;
	}
	if (_tmp8_) {
		GtkLabel* label = NULL;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		GtkLabel* _tmp15_;
		GtkLabel* _tmp16_;
		GtkLabel* _tmp17_;
		GtkStyleContext* _tmp18_;
		GtkLabel* _tmp19_;
		GtkLabel* _tmp20_;
		GtkLabel* _tmp21_;
		GtkLabel* _tmp22_;
		_tmp12_ = prev;
		_tmp13_ = g_markup_printf_escaped ("<span font=\"11\">%s</span>", _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = (GtkLabel*) gtk_label_new (_tmp14_);
		g_object_ref_sink (_tmp15_);
		_tmp16_ = _tmp15_;
		_g_free0 (_tmp14_);
		label = _tmp16_;
		_tmp17_ = label;
		_tmp18_ = gtk_widget_get_style_context ((GtkWidget*) _tmp17_);
		gtk_style_context_add_class (_tmp18_, "dim-label");
		_tmp19_ = label;
		gtk_widget_set_halign ((GtkWidget*) _tmp19_, GTK_ALIGN_START);
		_tmp20_ = label;
		gtk_label_set_use_markup (_tmp20_, TRUE);
		_tmp21_ = label;
		gtk_list_box_row_set_header (before, (GtkWidget*) _tmp21_);
		_tmp22_ = label;
		g_object_set ((GtkWidget*) _tmp22_, "margin", 3, NULL);
		_g_object_unref0 (label);
	} else {
		gtk_list_box_row_set_header (before, NULL);
	}
	_g_free0 (next);
	_g_free0 (prev);
	_g_object_unref0 (child);
}

static GtkBox*
places_indicator_window_set_up_placeholder (PlacesIndicatorWindow* self)
{
	GtkBox* placeholder_box = NULL;
	GtkBox* _tmp0_;
	GtkImage* placeholder_image = NULL;
	GtkImage* _tmp1_;
	GtkLabel* placeholder_label = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* placeholder_label1 = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkStyleContext* _tmp10_;
	GtkBox* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp0_);
	placeholder_box = _tmp0_;
	g_object_set ((GtkWidget*) placeholder_box, "margin", 20, NULL);
	gtk_widget_set_halign ((GtkWidget*) placeholder_box, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) placeholder_box, GTK_ALIGN_CENTER);
	_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name ("drive-harddisk-symbolic", (GtkIconSize) GTK_ICON_SIZE_DIALOG);
	g_object_ref_sink (_tmp1_);
	placeholder_image = _tmp1_;
	gtk_image_set_pixel_size (placeholder_image, 64);
	gtk_box_pack_start (placeholder_box, (GtkWidget*) placeholder_image, FALSE, FALSE, (guint) 6);
	_tmp2_ = g_strdup_printf ("<span font=\"11\">%s</span>", _ ("Nothing to display right now"));
	_tmp3_ = _tmp2_;
	_tmp4_ = (GtkLabel*) gtk_label_new (_tmp3_);
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	placeholder_label = _tmp5_;
	gtk_label_set_use_markup (placeholder_label, TRUE);
	gtk_box_pack_start (placeholder_box, (GtkWidget*) placeholder_label, FALSE, FALSE, (guint) 0);
	_tmp6_ = g_strdup_printf ("<span font=\"10\">%s\n%s</span>", _ ("Mount some drives"), _ ("Enable more sections"));
	_tmp7_ = _tmp6_;
	_tmp8_ = (GtkLabel*) gtk_label_new (_tmp7_);
	g_object_ref_sink (_tmp8_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	placeholder_label1 = _tmp9_;
	gtk_label_set_use_markup (placeholder_label1, TRUE);
	gtk_label_set_justify (placeholder_label1, GTK_JUSTIFY_LEFT);
	_tmp10_ = gtk_widget_get_style_context ((GtkWidget*) placeholder_label1);
	gtk_style_context_add_class (_tmp10_, "dim-label");
	gtk_box_pack_start (placeholder_box, (GtkWidget*) placeholder_label1, FALSE, FALSE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) placeholder_box);
	result = placeholder_box;
	_g_object_unref0 (placeholder_label1);
	_g_object_unref0 (placeholder_label);
	_g_object_unref0 (placeholder_image);
	return result;
}

static GFile*
places_indicator_window_get_bookmarks_file (PlacesIndicatorWindow* self)
{
	gchar* path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "gtk-3.0", "bookmarks", NULL);
	path = _tmp1_;
	_tmp2_ = g_file_new_for_path (path);
	result = _tmp2_;
	_g_free0 (path);
	return result;
}

static void
_places_indicator_window_on_bookmarks_change_g_file_monitor_changed (GFileMonitor* _sender,
                                                                     GFile* file,
                                                                     GFile* other_file,
                                                                     GFileMonitorEvent event_type,
                                                                     gpointer self)
{
	places_indicator_window_on_bookmarks_change ((PlacesIndicatorWindow*) self, file, other_file, event_type);
}

static void
places_indicator_window_connect_bookmarks_monitor (PlacesIndicatorWindow* self)
{
	GFile* bookmarks_file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = places_indicator_window_get_bookmarks_file (self);
	bookmarks_file = _tmp0_;
	_tmp1_ = bookmarks_file;
	if (!g_file_query_exists (_tmp1_, NULL)) {
		_g_object_unref0 (bookmarks_file);
		return;
	}
	{
		GFileMonitor* _tmp2_ = NULL;
		GFile* _tmp3_;
		GFileMonitor* _tmp4_;
		GFileMonitor* _tmp5_;
		GFileMonitor* _tmp6_;
		GFileMonitor* _tmp7_;
		_tmp3_ = bookmarks_file;
		_tmp4_ = g_file_monitor_file (_tmp3_, G_FILE_MONITOR_WATCH_MOVES, NULL, &_inner_error0_);
		_tmp2_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			_g_object_unref0 (bookmarks_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp5_ = _tmp2_;
		_tmp2_ = NULL;
		_g_object_unref0 (self->priv->bookmarks_monitor);
		self->priv->bookmarks_monitor = _tmp5_;
		_tmp6_ = self->priv->bookmarks_monitor;
		g_file_monitor_set_rate_limit (_tmp6_, 1000);
		_tmp7_ = self->priv->bookmarks_monitor;
		g_signal_connect_object (_tmp7_, "changed", (GCallback) _places_indicator_window_on_bookmarks_change_g_file_monitor_changed, self, 0);
		_g_object_unref0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("PlacesIndicatorWindow.vala:218: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (bookmarks_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (bookmarks_file);
}

static void
places_indicator_window_on_bookmarks_change (PlacesIndicatorWindow* self,
                                             GFile* src,
                                             GFile* dest,
                                             GFileMonitorEvent event)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (src != NULL);
	if (event == G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = event == G_FILE_MONITOR_EVENT_RENAMED;
	}
	if (_tmp0_) {
		places_indicator_window_refresh_special_dirs (self);
	}
}

static void
_places_indicator_window_refresh_mounts_g_volume_monitor_volume_added (GVolumeMonitor* _sender,
                                                                       GVolume* volume,
                                                                       gpointer self)
{
	places_indicator_window_refresh_mounts ((PlacesIndicatorWindow*) self);
}

static void
_places_indicator_window_refresh_mounts_g_volume_monitor_volume_removed (GVolumeMonitor* _sender,
                                                                         GVolume* volume,
                                                                         gpointer self)
{
	places_indicator_window_refresh_mounts ((PlacesIndicatorWindow*) self);
}

static void
_places_indicator_window_refresh_mounts_g_volume_monitor_drive_connected (GVolumeMonitor* _sender,
                                                                          GDrive* drive,
                                                                          gpointer self)
{
	places_indicator_window_refresh_mounts ((PlacesIndicatorWindow*) self);
}

static void
_places_indicator_window_refresh_mounts_g_volume_monitor_drive_disconnected (GVolumeMonitor* _sender,
                                                                             GDrive* drive,
                                                                             gpointer self)
{
	places_indicator_window_refresh_mounts ((PlacesIndicatorWindow*) self);
}

static void
_places_indicator_window_refresh_mounts_g_volume_monitor_mount_added (GVolumeMonitor* _sender,
                                                                      GMount* mount,
                                                                      gpointer self)
{
	places_indicator_window_refresh_mounts ((PlacesIndicatorWindow*) self);
}

static void
_places_indicator_window_refresh_mounts_g_volume_monitor_mount_removed (GVolumeMonitor* _sender,
                                                                        GMount* mount,
                                                                        gpointer self)
{
	places_indicator_window_refresh_mounts ((PlacesIndicatorWindow*) self);
}

static void
places_indicator_window_connect_signals (PlacesIndicatorWindow* self)
{
	GVolumeMonitor* _tmp0_;
	GVolumeMonitor* _tmp1_;
	GVolumeMonitor* _tmp2_;
	GVolumeMonitor* _tmp3_;
	GVolumeMonitor* _tmp4_;
	GVolumeMonitor* _tmp5_;
	g_return_if_fail (self != NULL);
	places_indicator_window_connect_bookmarks_monitor (self);
	_tmp0_ = self->priv->volume_monitor;
	g_signal_connect_object (_tmp0_, "volume-added", (GCallback) _places_indicator_window_refresh_mounts_g_volume_monitor_volume_added, self, 0);
	_tmp1_ = self->priv->volume_monitor;
	g_signal_connect_object (_tmp1_, "volume-removed", (GCallback) _places_indicator_window_refresh_mounts_g_volume_monitor_volume_removed, self, 0);
	_tmp2_ = self->priv->volume_monitor;
	g_signal_connect_object (_tmp2_, "drive-connected", (GCallback) _places_indicator_window_refresh_mounts_g_volume_monitor_drive_connected, self, 0);
	_tmp3_ = self->priv->volume_monitor;
	g_signal_connect_object (_tmp3_, "drive-disconnected", (GCallback) _places_indicator_window_refresh_mounts_g_volume_monitor_drive_disconnected, self, 0);
	_tmp4_ = self->priv->volume_monitor;
	g_signal_connect_object (_tmp4_, "mount-added", (GCallback) _places_indicator_window_refresh_mounts_g_volume_monitor_mount_added, self, 0);
	_tmp5_ = self->priv->volume_monitor;
	g_signal_connect_object (_tmp5_, "mount-removed", (GCallback) _places_indicator_window_refresh_mounts_g_volume_monitor_mount_removed, self, 0);
}

static void
places_indicator_window_check_expand (PlacesIndicatorWindow* self)
{
	GtkListBox* _tmp0_;
	GtkListBox* _tmp5_;
	PlacesSection* _tmp10_;
	GtkBox* _tmp16_;
	GtkBox* _tmp17_;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	PlacesSection* _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mounts_listbox;
	if (gtk_widget_get_visible ((GtkWidget*) _tmp0_)) {
		GtkListBox* _tmp1_;
		GtkListBox* _tmp2_;
		GList* _tmp3_;
		GList* _tmp4_;
		_tmp1_ = self->priv->mounts_listbox;
		_tmp2_ = self->priv->mounts_listbox;
		_tmp3_ = gtk_container_get_children ((GtkContainer*) _tmp2_);
		_tmp4_ = _tmp3_;
		gtk_widget_set_visible ((GtkWidget*) _tmp1_, g_list_length (_tmp4_) != ((guint) 0));
		(_tmp4_ == NULL) ? NULL : (_tmp4_ = (g_list_free (_tmp4_), NULL));
	}
	_tmp5_ = self->priv->networks_listbox;
	if (gtk_widget_get_visible ((GtkWidget*) _tmp5_)) {
		GtkListBox* _tmp6_;
		GtkListBox* _tmp7_;
		GList* _tmp8_;
		GList* _tmp9_;
		_tmp6_ = self->priv->networks_listbox;
		_tmp7_ = self->priv->networks_listbox;
		_tmp8_ = gtk_container_get_children ((GtkContainer*) _tmp7_);
		_tmp9_ = _tmp8_;
		gtk_widget_set_visible ((GtkWidget*) _tmp6_, g_list_length (_tmp9_) != ((guint) 0));
		(_tmp9_ == NULL) ? NULL : (_tmp9_ = (g_list_free (_tmp9_), NULL));
	}
	_tmp10_ = self->priv->places_section;
	if (gtk_widget_get_visible ((GtkWidget*) _tmp10_)) {
		gboolean _tmp11_ = FALSE;
		GtkListBox* _tmp12_;
		_tmp12_ = self->priv->mounts_listbox;
		if (!gtk_widget_get_visible ((GtkWidget*) _tmp12_)) {
			GtkListBox* _tmp13_;
			_tmp13_ = self->priv->networks_listbox;
			_tmp11_ = !gtk_widget_get_visible ((GtkWidget*) _tmp13_);
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			PlacesSection* _tmp14_;
			_tmp14_ = self->priv->places_section;
			places_section_reveal (_tmp14_, TRUE);
			self->priv->only_places = TRUE;
		} else {
			if (self->priv->only_places) {
				PlacesSection* _tmp15_;
				_tmp15_ = self->priv->places_section;
				places_section_reveal (_tmp15_, FALSE);
				self->priv->only_places = FALSE;
			}
		}
	}
	_tmp16_ = self->priv->placeholder;
	gtk_widget_hide ((GtkWidget*) _tmp16_);
	_tmp17_ = self->priv->placeholder;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp17_, TRUE);
	_tmp20_ = self->priv->places_section;
	if (!gtk_widget_get_visible ((GtkWidget*) _tmp20_)) {
		GtkListBox* _tmp21_;
		_tmp21_ = self->priv->mounts_listbox;
		_tmp19_ = !gtk_widget_get_visible ((GtkWidget*) _tmp21_);
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		GtkListBox* _tmp22_;
		_tmp22_ = self->priv->networks_listbox;
		_tmp18_ = !gtk_widget_get_visible ((GtkWidget*) _tmp22_);
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		GtkBox* _tmp23_;
		GtkBox* _tmp24_;
		_tmp23_ = self->priv->placeholder;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp23_, FALSE);
		_tmp24_ = self->priv->placeholder;
		gtk_widget_show ((GtkWidget*) _tmp24_);
	}
}

static void
places_indicator_window_toggle_section_visibility (PlacesIndicatorWindow* self,
                                                   const gchar* section)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (section != NULL);
	_tmp0_ = section;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("places")))) {
		switch (0) {
			default:
			{
				PlacesSection* _tmp3_;
				gboolean _tmp4_;
				gboolean _tmp5_;
				PlacesSection* _tmp6_;
				gboolean _tmp7_;
				gboolean _tmp8_;
				_tmp3_ = self->priv->places_section;
				_tmp4_ = places_indicator_window_get_show_places (self);
				_tmp5_ = _tmp4_;
				gtk_widget_set_no_show_all ((GtkWidget*) _tmp3_, !_tmp5_);
				_tmp6_ = self->priv->places_section;
				_tmp7_ = places_indicator_window_get_show_places (self);
				_tmp8_ = _tmp7_;
				gtk_widget_set_visible ((GtkWidget*) _tmp6_, _tmp8_);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("drives")))) {
		switch (0) {
			default:
			{
				GtkListBox* _tmp9_;
				gboolean _tmp10_;
				gboolean _tmp11_;
				GtkListBox* _tmp12_;
				gboolean _tmp13_;
				gboolean _tmp14_;
				_tmp9_ = self->priv->mounts_listbox;
				_tmp10_ = places_indicator_window_get_show_drives (self);
				_tmp11_ = _tmp10_;
				gtk_widget_set_no_show_all ((GtkWidget*) _tmp9_, !_tmp11_);
				_tmp12_ = self->priv->mounts_listbox;
				_tmp13_ = places_indicator_window_get_show_drives (self);
				_tmp14_ = _tmp13_;
				gtk_widget_set_visible ((GtkWidget*) _tmp12_, _tmp14_);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("networks")))) {
		switch (0) {
			default:
			{
				GtkListBox* _tmp15_;
				gboolean _tmp16_;
				gboolean _tmp17_;
				GtkListBox* _tmp18_;
				gboolean _tmp19_;
				gboolean _tmp20_;
				_tmp15_ = self->priv->networks_listbox;
				_tmp16_ = places_indicator_window_get_show_networks (self);
				_tmp17_ = _tmp16_;
				gtk_widget_set_no_show_all ((GtkWidget*) _tmp15_, !_tmp17_);
				_tmp18_ = self->priv->networks_listbox;
				_tmp19_ = places_indicator_window_get_show_networks (self);
				_tmp20_ = _tmp19_;
				gtk_widget_set_visible ((GtkWidget*) _tmp18_, _tmp20_);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
	places_indicator_window_check_expand (self);
}

static void
places_indicator_window_refresh_bookmarks (PlacesIndicatorWindow* self)
{
	GFile* bookmarks_file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = places_indicator_window_get_bookmarks_file (self);
	bookmarks_file = _tmp0_;
	_tmp1_ = bookmarks_file;
	if (!g_file_query_exists (_tmp1_, NULL)) {
		_g_object_unref0 (bookmarks_file);
		return;
	}
	{
		GFileInputStream* _tmp2_ = NULL;
		GFile* _tmp3_;
		GFileInputStream* _tmp4_;
		GDataInputStream* dis = NULL;
		GDataInputStream* _tmp5_;
		gchar* line = NULL;
		_tmp3_ = bookmarks_file;
		_tmp4_ = g_file_read (_tmp3_, NULL, &_inner_error0_);
		_tmp2_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = g_data_input_stream_new ((GInputStream*) _tmp2_);
		dis = _tmp5_;
		while (TRUE) {
			gchar* _tmp6_ = NULL;
			GDataInputStream* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			_tmp7_ = dis;
			_tmp8_ = g_data_input_stream_read_line (_tmp7_, NULL, NULL, &_inner_error0_);
			_tmp6_ = _tmp8_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (line);
				_g_object_unref0 (dis);
				_g_object_unref0 (_tmp2_);
				goto __catch0_g_error;
			}
			_tmp9_ = _tmp6_;
			_tmp6_ = NULL;
			_g_free0 (line);
			line = _tmp9_;
			_tmp10_ = line;
			if (!(_tmp10_ != NULL)) {
				_g_free0 (_tmp6_);
				break;
			}
			_tmp11_ = line;
			places_indicator_window_add_place (self, _tmp11_, "bookmark");
			_g_free0 (_tmp6_);
		}
		_g_free0 (line);
		_g_object_unref0 (dis);
		_g_object_unref0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("PlacesIndicatorWindow.vala:315: %s", _tmp13_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (bookmarks_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (bookmarks_file);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
places_indicator_window_refresh_special_dirs (PlacesIndicatorWindow* self)
{
	GHashTable* _tmp0_;
	PlacesSection* _tmp1_;
	gchar* path = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GUserDirectory* _tmp8_;
	gint _tmp8__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->places_list;
	g_hash_table_remove_all (_tmp0_);
	_tmp1_ = self->priv->places_section;
	places_section_clear (_tmp1_);
	_tmp2_ = g_get_home_dir ();
	_tmp3_ = g_strdup (_tmp2_);
	path = _tmp3_;
	_tmp4_ = path;
	_tmp5_ = string_to_string (_tmp4_);
	_tmp6_ = g_strconcat ("file://", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	places_indicator_window_add_place (self, _tmp7_, "place");
	_g_free0 (_tmp7_);
	_tmp8_ = self->priv->DEFAULT_DIRECTORIES;
	_tmp8__length1 = self->priv->DEFAULT_DIRECTORIES_length1;
	{
		GUserDirectory* special_dir_collection = NULL;
		gint special_dir_collection_length1 = 0;
		gint _special_dir_collection_size_ = 0;
		gint special_dir_it = 0;
		special_dir_collection = _tmp8_;
		special_dir_collection_length1 = _tmp8__length1;
		for (special_dir_it = 0; special_dir_it < special_dir_collection_length1; special_dir_it = special_dir_it + 1) {
			GUserDirectory special_dir = 0;
			special_dir = special_dir_collection[special_dir_it];
			{
				const gchar* _tmp9_;
				gchar* _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp9_ = g_get_user_special_dir (special_dir);
				_tmp10_ = g_strdup (_tmp9_);
				_g_free0 (path);
				path = _tmp10_;
				_tmp11_ = path;
				_tmp12_ = string_to_string (_tmp11_);
				_tmp13_ = g_strconcat ("file://", _tmp12_, NULL);
				_tmp14_ = _tmp13_;
				places_indicator_window_add_place (self, _tmp14_, "place");
				_g_free0 (_tmp14_);
			}
		}
	}
	places_indicator_window_refresh_bookmarks (self);
	_g_free0 (path);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
places_indicator_window_refresh_mounts (PlacesIndicatorWindow* self)
{
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	GtkListBox* _tmp4_;
	GList* _tmp5_;
	GVolumeMonitor* _tmp8_;
	GList* _tmp9_;
	GVolumeMonitor* _tmp22_;
	GList* _tmp23_;
	GVolumeMonitor* _tmp37_;
	GList* _tmp38_;
	GtkWidget* _tmp50_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mounts_listbox;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = _tmp1_;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			GtkWidget* _tmp2_;
			GtkWidget* item = NULL;
			_tmp2_ = _g_object_ref0 ((GtkWidget*) item_it->data);
			item = _tmp2_;
			{
				GtkWidget* _tmp3_;
				_tmp3_ = item;
				gtk_widget_destroy (_tmp3_);
				_g_object_unref0 (item);
			}
		}
		(item_collection == NULL) ? NULL : (item_collection = (g_list_free (item_collection), NULL));
	}
	_tmp4_ = self->priv->networks_listbox;
	_tmp5_ = gtk_container_get_children ((GtkContainer*) _tmp4_);
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = _tmp5_;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			GtkWidget* _tmp6_;
			GtkWidget* item = NULL;
			_tmp6_ = _g_object_ref0 ((GtkWidget*) item_it->data);
			item = _tmp6_;
			{
				GtkWidget* _tmp7_;
				_tmp7_ = item;
				gtk_widget_destroy (_tmp7_);
				_g_object_unref0 (item);
			}
		}
		(item_collection == NULL) ? NULL : (item_collection = (g_list_free (item_collection), NULL));
	}
	_tmp8_ = self->priv->volume_monitor;
	_tmp9_ = g_volume_monitor_get_connected_drives (_tmp8_);
	{
		GList* drive_collection = NULL;
		GList* drive_it = NULL;
		drive_collection = _tmp9_;
		for (drive_it = drive_collection; drive_it != NULL; drive_it = drive_it->next) {
			GDrive* _tmp10_;
			GDrive* drive = NULL;
			_tmp10_ = _g_object_ref0 ((GDrive*) drive_it->data);
			drive = _tmp10_;
			{
				GDrive* _tmp11_;
				GList* _tmp12_;
				_tmp11_ = drive;
				_tmp12_ = g_drive_get_volumes (_tmp11_);
				{
					GList* volume_collection = NULL;
					GList* volume_it = NULL;
					volume_collection = _tmp12_;
					for (volume_it = volume_collection; volume_it != NULL; volume_it = volume_it->next) {
						GVolume* _tmp13_;
						GVolume* volume = NULL;
						_tmp13_ = _g_object_ref0 ((GVolume*) volume_it->data);
						volume = _tmp13_;
						{
							GMount* mount = NULL;
							GVolume* _tmp14_;
							GMount* _tmp15_;
							GMount* _tmp16_;
							_tmp14_ = volume;
							_tmp15_ = g_volume_get_mount (_tmp14_);
							mount = _tmp15_;
							_tmp16_ = mount;
							if (_tmp16_ == NULL) {
								GVolume* _tmp17_;
								_tmp17_ = volume;
								places_indicator_window_add_volume (self, _tmp17_);
							} else {
								GMount* _tmp18_;
								GVolume* _tmp19_;
								gchar* _tmp20_;
								gchar* _tmp21_;
								_tmp18_ = mount;
								_tmp19_ = volume;
								_tmp20_ = g_volume_get_identifier (_tmp19_, "class");
								_tmp21_ = _tmp20_;
								places_indicator_window_add_mount (self, _tmp18_, _tmp21_);
								_g_free0 (_tmp21_);
							}
							_g_object_unref0 (mount);
							_g_object_unref0 (volume);
						}
					}
					(volume_collection == NULL) ? NULL : (volume_collection = (_g_list_free__g_object_unref0_ (volume_collection), NULL));
				}
				_g_object_unref0 (drive);
			}
		}
		(drive_collection == NULL) ? NULL : (drive_collection = (_g_list_free__g_object_unref0_ (drive_collection), NULL));
	}
	_tmp22_ = self->priv->volume_monitor;
	_tmp23_ = g_volume_monitor_get_volumes (_tmp22_);
	{
		GList* volume_collection = NULL;
		GList* volume_it = NULL;
		volume_collection = _tmp23_;
		for (volume_it = volume_collection; volume_it != NULL; volume_it = volume_it->next) {
			GVolume* _tmp24_;
			GVolume* volume = NULL;
			_tmp24_ = _g_object_ref0 ((GVolume*) volume_it->data);
			volume = _tmp24_;
			{
				GVolume* _tmp25_;
				GDrive* _tmp26_;
				GDrive* _tmp27_;
				gboolean _tmp28_;
				GMount* mount = NULL;
				GVolume* _tmp29_;
				GMount* _tmp30_;
				GMount* _tmp31_;
				_tmp25_ = volume;
				_tmp26_ = g_volume_get_drive (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = _tmp27_ != NULL;
				_g_object_unref0 (_tmp27_);
				if (_tmp28_) {
					_g_object_unref0 (volume);
					continue;
				}
				_tmp29_ = volume;
				_tmp30_ = g_volume_get_mount (_tmp29_);
				mount = _tmp30_;
				_tmp31_ = mount;
				if (_tmp31_ == NULL) {
					GVolume* _tmp32_;
					_tmp32_ = volume;
					places_indicator_window_add_volume (self, _tmp32_);
				} else {
					GMount* _tmp33_;
					GVolume* _tmp34_;
					gchar* _tmp35_;
					gchar* _tmp36_;
					_tmp33_ = mount;
					_tmp34_ = volume;
					_tmp35_ = g_volume_get_identifier (_tmp34_, "class");
					_tmp36_ = _tmp35_;
					places_indicator_window_add_mount (self, _tmp33_, _tmp36_);
					_g_free0 (_tmp36_);
				}
				_g_object_unref0 (mount);
				_g_object_unref0 (volume);
			}
		}
		(volume_collection == NULL) ? NULL : (volume_collection = (_g_list_free__g_object_unref0_ (volume_collection), NULL));
	}
	_tmp37_ = self->priv->volume_monitor;
	_tmp38_ = g_volume_monitor_get_mounts (_tmp37_);
	{
		GList* mount_collection = NULL;
		GList* mount_it = NULL;
		mount_collection = _tmp38_;
		for (mount_it = mount_collection; mount_it != NULL; mount_it = mount_it->next) {
			GMount* _tmp39_;
			GMount* mount = NULL;
			_tmp39_ = _g_object_ref0 ((GMount*) mount_it->data);
			mount = _tmp39_;
			{
				gboolean _tmp40_ = FALSE;
				GMount* _tmp41_;
				GFile* root = NULL;
				GMount* _tmp45_;
				GFile* _tmp46_;
				GFile* _tmp47_;
				_tmp41_ = mount;
				if (g_mount_is_shadowed (_tmp41_)) {
					_tmp40_ = TRUE;
				} else {
					GMount* _tmp42_;
					GVolume* _tmp43_;
					GVolume* _tmp44_;
					_tmp42_ = mount;
					_tmp43_ = g_mount_get_volume (_tmp42_);
					_tmp44_ = _tmp43_;
					_tmp40_ = _tmp44_ != NULL;
					_g_object_unref0 (_tmp44_);
				}
				if (_tmp40_) {
					_g_object_unref0 (mount);
					continue;
				}
				_tmp45_ = mount;
				_tmp46_ = g_mount_get_default_location (_tmp45_);
				root = _tmp46_;
				_tmp47_ = root;
				if (!g_file_is_native (_tmp47_)) {
					GMount* _tmp48_;
					_tmp48_ = mount;
					places_indicator_window_add_mount (self, _tmp48_, "network");
				} else {
					GMount* _tmp49_;
					_tmp49_ = mount;
					places_indicator_window_add_mount (self, _tmp49_, "device");
				}
				_g_object_unref0 (root);
				_g_object_unref0 (mount);
			}
		}
		(mount_collection == NULL) ? NULL : (mount_collection = (_g_list_free__g_object_unref0_ (mount_collection), NULL));
	}
	_tmp50_ = gtk_bin_get_child ((GtkBin*) self);
	gtk_widget_show_all (_tmp50_);
	places_indicator_window_check_expand (self);
}

static void
__lambda9_ (PlacesIndicatorWindow* self)
{
	gtk_widget_hide ((GtkWidget*) self);
}

static void
___lambda9__list_item_close_popover (ListItem* _sender,
                                     gpointer self)
{
	__lambda9_ ((PlacesIndicatorWindow*) self);
}

static void
_places_indicator_window_set_message_list_item_send_message (ListItem* _sender,
                                                             const gchar* message_content,
                                                             gpointer self)
{
	places_indicator_window_set_message ((PlacesIndicatorWindow*) self, message_content);
}

static void
places_indicator_window_add_volume (PlacesIndicatorWindow* self,
                                    GVolume* volume)
{
	gchar* volume_class = NULL;
	gchar* _tmp0_;
	VolumeItem* volume_item = NULL;
	VolumeItem* _tmp1_;
	VolumeItem* _tmp2_;
	const gchar* _tmp3_;
	VolumeItem* _tmp8_;
	GtkContainer* _tmp9_;
	VolumeItem* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (volume != NULL);
	_tmp0_ = g_volume_get_identifier (volume, "class");
	volume_class = _tmp0_;
	_tmp1_ = volume_item_new (volume);
	g_object_ref_sink (_tmp1_);
	volume_item = _tmp1_;
	_tmp2_ = volume_item;
	g_signal_connect_object ((ListItem*) _tmp2_, "close-popover", (GCallback) ___lambda9__list_item_close_popover, self, 0);
	_tmp3_ = volume_class;
	if (g_strcmp0 (_tmp3_, "network") == 0) {
		GtkListBox* _tmp4_;
		VolumeItem* _tmp5_;
		_tmp4_ = self->priv->networks_listbox;
		_tmp5_ = volume_item;
		gtk_container_add ((GtkContainer*) _tmp4_, (GtkWidget*) _tmp5_);
	} else {
		GtkListBox* _tmp6_;
		VolumeItem* _tmp7_;
		_tmp6_ = self->priv->mounts_listbox;
		_tmp7_ = volume_item;
		gtk_container_add ((GtkContainer*) _tmp6_, (GtkWidget*) _tmp7_);
	}
	_tmp8_ = volume_item;
	_tmp9_ = gtk_widget_get_parent ((GtkWidget*) _tmp8_);
	gtk_widget_set_can_focus ((GtkWidget*) _tmp9_, FALSE);
	_tmp10_ = volume_item;
	g_signal_connect_object ((ListItem*) _tmp10_, "send-message", (GCallback) _places_indicator_window_set_message_list_item_send_message, self, 0);
	_g_object_unref0 (volume_item);
	_g_free0 (volume_class);
}

static void
__lambda12_ (PlacesIndicatorWindow* self)
{
	gtk_widget_hide ((GtkWidget*) self);
}

static void
___lambda12__list_item_close_popover (ListItem* _sender,
                                      gpointer self)
{
	__lambda12_ ((PlacesIndicatorWindow*) self);
}

static void
places_indicator_window_add_mount (PlacesIndicatorWindow* self,
                                   GMount* mount,
                                   const gchar* mount_class)
{
	gboolean _tmp0_ = FALSE;
	MountItem* mount_item = NULL;
	MountItem* _tmp1_;
	MountItem* _tmp2_;
	MountItem* _tmp7_;
	GtkContainer* _tmp8_;
	MountItem* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mount != NULL);
	if (!g_mount_can_unmount (mount)) {
		_tmp0_ = !g_mount_can_eject (mount);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	if (g_mount_is_shadowed (mount)) {
		return;
	}
	_tmp1_ = mount_item_new (mount, mount_class);
	g_object_ref_sink (_tmp1_);
	mount_item = _tmp1_;
	_tmp2_ = mount_item;
	g_signal_connect_object ((ListItem*) _tmp2_, "close-popover", (GCallback) ___lambda12__list_item_close_popover, self, 0);
	if (g_strcmp0 (mount_class, "network") == 0) {
		GtkListBox* _tmp3_;
		MountItem* _tmp4_;
		_tmp3_ = self->priv->networks_listbox;
		_tmp4_ = mount_item;
		gtk_container_add ((GtkContainer*) _tmp3_, (GtkWidget*) _tmp4_);
	} else {
		GtkListBox* _tmp5_;
		MountItem* _tmp6_;
		_tmp5_ = self->priv->mounts_listbox;
		_tmp6_ = mount_item;
		gtk_container_add ((GtkContainer*) _tmp5_, (GtkWidget*) _tmp6_);
	}
	_tmp7_ = mount_item;
	_tmp8_ = gtk_widget_get_parent ((GtkWidget*) _tmp7_);
	gtk_widget_set_can_focus ((GtkWidget*) _tmp8_, FALSE);
	_tmp9_ = mount_item;
	g_signal_connect_object ((ListItem*) _tmp9_, "send-message", (GCallback) _places_indicator_window_set_message_list_item_send_message, self, 0);
	_g_object_unref0 (mount_item);
}

static void
__lambda7_ (PlacesIndicatorWindow* self)
{
	gtk_widget_hide ((GtkWidget*) self);
}

static void
___lambda7__list_item_close_popover (ListItem* _sender,
                                     gpointer self)
{
	__lambda7_ ((PlacesIndicatorWindow*) self);
}

static void
places_indicator_window_add_place (PlacesIndicatorWindow* self,
                                   const gchar* path,
                                   const gchar* class)
{
	gchar** arr = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint arr_length1;
	gint _arr_size_;
	gchar* place = NULL;
	gchar** _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* place_name = NULL;
	gchar* _tmp5_;
	gchar* unescaped_path = NULL;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	GHashTable* _tmp17_;
	const gchar* _tmp18_;
	GFile* file = NULL;
	const gchar* _tmp19_;
	GFile* _tmp20_;
	PlaceItem* place_item = NULL;
	gboolean _tmp21_ = FALSE;
	PlaceItem* _tmp28_;
	GHashTable* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	PlacesSection* _tmp32_;
	PlaceItem* _tmp33_;
	PlaceItem* _tmp34_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (class != NULL);
	_tmp1_ = _tmp0_ = g_strsplit (path, " ", 0);
	arr = _tmp1_;
	arr_length1 = _vala_array_length (_tmp0_);
	_arr_size_ = arr_length1;
	_tmp2_ = arr;
	_tmp2__length1 = arr_length1;
	_tmp3_ = _tmp2_[0];
	_tmp4_ = g_strdup (_tmp3_);
	place = _tmp4_;
	_tmp5_ = g_strdup ("");
	place_name = _tmp5_;
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gchar** _tmp8_;
				gint _tmp8__length1;
				const gchar* _tmp9_;
				gchar** _tmp10_;
				gint _tmp10__length1;
				const gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = arr;
				_tmp8__length1 = arr_length1;
				if (!(i < _tmp8__length1)) {
					break;
				}
				_tmp9_ = place_name;
				_tmp10_ = arr;
				_tmp10__length1 = arr_length1;
				_tmp11_ = _tmp10_[i];
				_tmp12_ = g_strconcat (_tmp11_, " ", NULL);
				_tmp13_ = _tmp12_;
				_tmp14_ = g_strconcat (_tmp9_, _tmp13_, NULL);
				_g_free0 (place_name);
				place_name = _tmp14_;
				_g_free0 (_tmp13_);
			}
		}
	}
	_tmp15_ = place;
	_tmp16_ = g_uri_unescape_string (_tmp15_, NULL);
	unescaped_path = _tmp16_;
	_tmp17_ = self->priv->places_list;
	_tmp18_ = unescaped_path;
	if (g_hash_table_contains (_tmp17_, _tmp18_)) {
		_g_free0 (unescaped_path);
		_g_free0 (place_name);
		_g_free0 (place);
		arr = (_vala_array_free (arr, arr_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp19_ = unescaped_path;
	_tmp20_ = g_file_new_for_uri (_tmp19_);
	file = _tmp20_;
	if (g_strcmp0 (class, "bookmark") == 0) {
		const gchar* _tmp22_;
		_tmp22_ = place_name;
		_tmp21_ = g_strcmp0 (_tmp22_, "") != 0;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		GFile* _tmp23_;
		const gchar* _tmp24_;
		PlaceItem* _tmp25_;
		_tmp23_ = file;
		_tmp24_ = place_name;
		_tmp25_ = place_item_new (_tmp23_, "place", _tmp24_);
		g_object_ref_sink (_tmp25_);
		_g_object_unref0 (place_item);
		place_item = _tmp25_;
	} else {
		GFile* _tmp26_;
		PlaceItem* _tmp27_;
		_tmp26_ = file;
		_tmp27_ = place_item_new (_tmp26_, "place", NULL);
		g_object_ref_sink (_tmp27_);
		_g_object_unref0 (place_item);
		place_item = _tmp27_;
	}
	_tmp28_ = place_item;
	g_signal_connect_object ((ListItem*) _tmp28_, "close-popover", (GCallback) ___lambda7__list_item_close_popover, self, 0);
	_tmp29_ = self->priv->places_list;
	_tmp30_ = unescaped_path;
	_tmp31_ = g_strdup (_tmp30_);
	g_hash_table_add (_tmp29_, _tmp31_);
	_tmp32_ = self->priv->places_section;
	_tmp33_ = place_item;
	places_section_add_item (_tmp32_, _tmp33_);
	_tmp34_ = place_item;
	g_signal_connect_object ((ListItem*) _tmp34_, "send-message", (GCallback) _places_indicator_window_set_message_list_item_send_message, self, 0);
	_g_object_unref0 (place_item);
	_g_object_unref0 (file);
	_g_free0 (unescaped_path);
	_g_free0 (place_name);
	_g_free0 (place);
	arr = (_vala_array_free (arr, arr_length1, (GDestroyNotify) g_free), NULL);
}

static void
places_indicator_window_set_message (PlacesIndicatorWindow* self,
                                     const gchar* message)
{
	MessageRevealer* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = self->priv->message_bar;
	message_revealer_set_content (_tmp0_, message);
}

gboolean
places_indicator_window_get_expand_places (PlacesIndicatorWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_expand_places;
	return result;
}

void
places_indicator_window_set_expand_places (PlacesIndicatorWindow* self,
                                           gboolean value)
{
	PlacesSection* _tmp0_;
	PlacesSection* _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->_expand_places = value;
	_tmp0_ = self->priv->places_section;
	places_section_reveal (_tmp0_, value);
	_tmp1_ = self->priv->places_section;
	places_section_show_alternative_header (_tmp1_, value);
	g_object_notify_by_pspec ((GObject *) self, places_indicator_window_properties[PLACES_INDICATOR_WINDOW_EXPAND_PLACES_PROPERTY]);
}

gboolean
places_indicator_window_get_show_places (PlacesIndicatorWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_places;
	return result;
}

void
places_indicator_window_set_show_places (PlacesIndicatorWindow* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_show_places = value;
	places_indicator_window_toggle_section_visibility (self, "places");
	g_object_notify_by_pspec ((GObject *) self, places_indicator_window_properties[PLACES_INDICATOR_WINDOW_SHOW_PLACES_PROPERTY]);
}

gboolean
places_indicator_window_get_show_drives (PlacesIndicatorWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_drives;
	return result;
}

void
places_indicator_window_set_show_drives (PlacesIndicatorWindow* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_show_drives = value;
	places_indicator_window_toggle_section_visibility (self, "drives");
	g_object_notify_by_pspec ((GObject *) self, places_indicator_window_properties[PLACES_INDICATOR_WINDOW_SHOW_DRIVES_PROPERTY]);
}

gboolean
places_indicator_window_get_show_networks (PlacesIndicatorWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_networks;
	return result;
}

void
places_indicator_window_set_show_networks (PlacesIndicatorWindow* self,
                                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_show_networks = value;
	places_indicator_window_toggle_section_visibility (self, "networks");
	g_object_notify_by_pspec ((GObject *) self, places_indicator_window_properties[PLACES_INDICATOR_WINDOW_SHOW_NETWORKS_PROPERTY]);
}

static void
places_indicator_window_class_init (PlacesIndicatorWindowClass * klass,
                                    gpointer klass_data)
{
	places_indicator_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlacesIndicatorWindow_private_offset);
	((BudgiePopoverClass *) klass)->closed = (void (*) (BudgiePopover*)) places_indicator_window_real_closed;
	G_OBJECT_CLASS (klass)->get_property = _vala_places_indicator_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_places_indicator_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = places_indicator_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLACES_INDICATOR_WINDOW_EXPAND_PLACES_PROPERTY, places_indicator_window_properties[PLACES_INDICATOR_WINDOW_EXPAND_PLACES_PROPERTY] = g_param_spec_boolean ("expand-places", "expand-places", "expand-places", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLACES_INDICATOR_WINDOW_SHOW_PLACES_PROPERTY, places_indicator_window_properties[PLACES_INDICATOR_WINDOW_SHOW_PLACES_PROPERTY] = g_param_spec_boolean ("show-places", "show-places", "show-places", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLACES_INDICATOR_WINDOW_SHOW_DRIVES_PROPERTY, places_indicator_window_properties[PLACES_INDICATOR_WINDOW_SHOW_DRIVES_PROPERTY] = g_param_spec_boolean ("show-drives", "show-drives", "show-drives", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLACES_INDICATOR_WINDOW_SHOW_NETWORKS_PROPERTY, places_indicator_window_properties[PLACES_INDICATOR_WINDOW_SHOW_NETWORKS_PROPERTY] = g_param_spec_boolean ("show-networks", "show-networks", "show-networks", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
places_indicator_window_instance_init (PlacesIndicatorWindow * self,
                                       gpointer klass)
{
	GUserDirectory* _tmp0_;
	self->priv = places_indicator_window_get_instance_private (self);
	self->priv->_expand_places = FALSE;
	self->priv->_show_places = FALSE;
	self->priv->_show_drives = FALSE;
	self->priv->_show_networks = FALSE;
	self->priv->only_places = TRUE;
	_tmp0_ = g_new0 (GUserDirectory, 5);
	_tmp0_[0] = G_USER_DIRECTORY_DOCUMENTS;
	_tmp0_[1] = G_USER_DIRECTORY_DOWNLOAD;
	_tmp0_[2] = G_USER_DIRECTORY_MUSIC;
	_tmp0_[3] = G_USER_DIRECTORY_PICTURES;
	_tmp0_[4] = G_USER_DIRECTORY_VIDEOS;
	self->priv->DEFAULT_DIRECTORIES = _tmp0_;
	self->priv->DEFAULT_DIRECTORIES_length1 = 5;
	self->priv->_DEFAULT_DIRECTORIES_size_ = self->priv->DEFAULT_DIRECTORIES_length1;
}

static void
places_indicator_window_finalize (GObject * obj)
{
	PlacesIndicatorWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PLACES_INDICATOR_WINDOW, PlacesIndicatorWindow);
	_g_object_unref0 (self->priv->volume_monitor);
	_g_object_unref0 (self->priv->message_bar);
	_g_object_unref0 (self->priv->places_section);
	_g_object_unref0 (self->priv->mounts_listbox);
	_g_object_unref0 (self->priv->networks_listbox);
	_g_object_unref0 (self->priv->placeholder);
	_g_hash_table_unref0 (self->priv->places_list);
	_g_object_unref0 (self->priv->bookmarks_monitor);
	self->priv->DEFAULT_DIRECTORIES = (g_free (self->priv->DEFAULT_DIRECTORIES), NULL);
	G_OBJECT_CLASS (places_indicator_window_parent_class)->finalize (obj);
}

GType
places_indicator_window_get_type (void)
{
	return places_indicator_window_type_id;
}

GType
places_indicator_window_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlacesIndicatorWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) places_indicator_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlacesIndicatorWindow), 0, (GInstanceInitFunc) places_indicator_window_instance_init, NULL };
	places_indicator_window_type_id = g_type_module_register_type (module, budgie_popover_get_type (), "PlacesIndicatorWindow", &g_define_type_info, 0);
	PlacesIndicatorWindow_private_offset = sizeof (PlacesIndicatorWindowPrivate);
	return places_indicator_window_type_id;
}

static void
_vala_places_indicator_window_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	PlacesIndicatorWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PLACES_INDICATOR_WINDOW, PlacesIndicatorWindow);
	switch (property_id) {
		case PLACES_INDICATOR_WINDOW_EXPAND_PLACES_PROPERTY:
		g_value_set_boolean (value, places_indicator_window_get_expand_places (self));
		break;
		case PLACES_INDICATOR_WINDOW_SHOW_PLACES_PROPERTY:
		g_value_set_boolean (value, places_indicator_window_get_show_places (self));
		break;
		case PLACES_INDICATOR_WINDOW_SHOW_DRIVES_PROPERTY:
		g_value_set_boolean (value, places_indicator_window_get_show_drives (self));
		break;
		case PLACES_INDICATOR_WINDOW_SHOW_NETWORKS_PROPERTY:
		g_value_set_boolean (value, places_indicator_window_get_show_networks (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_places_indicator_window_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	PlacesIndicatorWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PLACES_INDICATOR_WINDOW, PlacesIndicatorWindow);
	switch (property_id) {
		case PLACES_INDICATOR_WINDOW_EXPAND_PLACES_PROPERTY:
		places_indicator_window_set_expand_places (self, g_value_get_boolean (value));
		break;
		case PLACES_INDICATOR_WINDOW_SHOW_PLACES_PROPERTY:
		places_indicator_window_set_show_places (self, g_value_get_boolean (value));
		break;
		case PLACES_INDICATOR_WINDOW_SHOW_DRIVES_PROPERTY:
		places_indicator_window_set_show_drives (self, g_value_get_boolean (value));
		break;
		case PLACES_INDICATOR_WINDOW_SHOW_NETWORKS_PROPERTY:
		places_indicator_window_set_show_networks (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

