/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import javajs.util.BS;
import org.jmol.c.STR;

public class Structure
implements Cloneable {
    public STR structureType;
    public STR substructureType;
    public String structureID;
    public int serialID;
    public int strandCount;
    public int startSequenceNumber;
    public int startChainID;
    public char startInsertionCode = '\u0000';
    public int endSequenceNumber;
    public int endChainID;
    public char endInsertionCode = '\u0000';
    public int[] atomStartEnd = new int[2];
    public int[] modelStartEnd = new int[]{-1, -1};
    public BS[] bsAll;

    public static STR getHelixType(int type) {
        switch (type) {
            case 1: {
                return STR.HELIXALPHA;
            }
            case 3: {
                return STR.HELIXPI;
            }
            case 5: {
                return STR.HELIX310;
            }
        }
        return STR.HELIX;
    }

    public Structure(int modelIndex, STR structureType, STR substructureType, String structureID, int serialID, int strandCount, BS[] bsAll) {
        if (bsAll != null) {
            this.modelStartEnd = new int[]{0, modelIndex};
            this.bsAll = bsAll;
            return;
        }
        this.structureType = structureType;
        this.substructureType = substructureType;
        if (structureID == null) {
            return;
        }
        this.modelStartEnd[0] = this.modelStartEnd[1] = modelIndex;
        this.structureID = structureID;
        this.strandCount = strandCount;
        this.serialID = serialID;
    }

    public void set(int startChainID, int startSequenceNumber, char startInsertionCode, int endChainID, int endSequenceNumber, char endInsertionCode, int istart, int iend) {
        this.startChainID = startChainID;
        this.startSequenceNumber = startSequenceNumber;
        this.startInsertionCode = startInsertionCode;
        this.endChainID = endChainID;
        this.endSequenceNumber = endSequenceNumber;
        this.endInsertionCode = endInsertionCode;
        this.atomStartEnd[0] = istart;
        this.atomStartEnd[1] = iend;
    }

    public Structure clone() {
        Structure s = null;
        try {
            s = (Structure)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return s;
    }
}

