/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyFrame;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.ThreadState;
import org.python.core.TraceFunction;
import org.python.core.Traverseproc;
import org.python.core.Visitproc;
import org.python.core.imp;

class PythonTraceFunction
extends TraceFunction
implements Traverseproc {
    PyObject tracefunc;

    PythonTraceFunction(PyObject tracefunc) {
        this.tracefunc = tracefunc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TraceFunction safeCall(PyFrame frame, String label, PyObject arg) {
        Class<imp> clazz = imp.class;
        synchronized (imp.class) {
            PythonTraceFunction pythonTraceFunction = this;
            synchronized (pythonTraceFunction) {
                ThreadState ts = Py.getThreadState();
                if (ts.tracing) {
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 6, 15] lbl9 : MonitorExitStatement: MONITOREXIT : var5_5
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return null;
                }
                if (this.tracefunc == null) {
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 6, 14] lbl13 : MonitorExitStatement: MONITOREXIT : var5_5
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return null;
                }
                PyObject ret = null;
                try {
                    ts.tracing = true;
                    ret = this.tracefunc.__call__((PyObject)frame, (PyObject)new PyString(label), arg);
                }
                catch (PyException exc) {
                    frame.tracefunc = null;
                    ts.tracefunc = null;
                    ts.profilefunc = null;
                    throw exc;
                }
                finally {
                    ts.tracing = false;
                }
                if (ret == this.tracefunc) {
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 6, 13] lbl30 : MonitorExitStatement: MONITOREXIT : var5_5
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return this;
                }
                if (ret == Py.None) {
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 6, 12] lbl34 : MonitorExitStatement: MONITOREXIT : var5_5
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return null;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 6] lbl37 : MonitorExitStatement: MONITOREXIT : var5_5
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return new PythonTraceFunction(ret);
            }
        }
    }

    @Override
    public TraceFunction traceCall(PyFrame frame) {
        return this.safeCall(frame, "call", Py.None);
    }

    @Override
    public TraceFunction traceReturn(PyFrame frame, PyObject ret) {
        return this.safeCall(frame, "return", ret);
    }

    @Override
    public TraceFunction traceLine(PyFrame frame, int line) {
        return this.safeCall(frame, "line", Py.None);
    }

    @Override
    public TraceFunction traceException(PyFrame frame, PyException exc) {
        PyObject safeTraceback = exc.traceback == null ? Py.None : exc.traceback;
        return this.safeCall(frame, "exception", new PyTuple(exc.type, exc.value, safeTraceback));
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        return this.tracefunc == null ? 0 : visit.visit(this.tracefunc, arg);
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && ob == this.tracefunc;
    }
}

