# This file has been autogenerated by the pywayland scanner

# Copyright © 2008-2011 Kristian Høgsberg
# Copyright © 2010-2011 Intel Corporation
# Copyright © 2012-2013 Collabora, Ltd.
#
# Permission is hereby granted, free of charge, to any person
# obtaining a copy of this software and associated documentation files
# (the "Software"), to deal in the Software without restriction,
# including without limitation the rights to use, copy, modify, merge,
# publish, distribute, sublicense, and/or sell copies of the Software,
# and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice (including the
# next paragraph) shall be included in all copies or substantial
# portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
# BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
# ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

from __future__ import annotations


from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)
from .wl_region import WlRegion
from .wl_surface import WlSurface


class WlCompositor(Interface):
    """The compositor singleton

    A compositor.  This object is a singleton global.  The compositor is in
    charge of combining the contents of multiple surfaces into one displayable
    output.
    """

    name = "wl_compositor"
    version = 5


class WlCompositorProxy(Proxy[WlCompositor]):
    interface = WlCompositor

    @WlCompositor.request(
        Argument(ArgumentType.NewId, interface=WlSurface),
    )
    def create_surface(self) -> Proxy[WlSurface]:
        """Create new surface

        Ask the compositor to create a new surface.

        :returns:
            :class:`~pywayland.protocol.wayland.WlSurface` -- the new surface
        """
        id = self._marshal_constructor(0, WlSurface)
        return id

    @WlCompositor.request(
        Argument(ArgumentType.NewId, interface=WlRegion),
    )
    def create_region(self) -> Proxy[WlRegion]:
        """Create new region

        Ask the compositor to create a new region.

        :returns:
            :class:`~pywayland.protocol.wayland.WlRegion` -- the new region
        """
        id = self._marshal_constructor(1, WlRegion)
        return id


class WlCompositorResource(Resource):
    interface = WlCompositor


class WlCompositorGlobal(Global):
    interface = WlCompositor


WlCompositor._gen_c()
WlCompositor.proxy_class = WlCompositorProxy
WlCompositor.resource_class = WlCompositorResource
WlCompositor.global_class = WlCompositorGlobal
