/* Indicator.c generated by valac 0.56.0, the Vala compiler
 * generated from Indicator.vala, do not modify */

/*
 * Copyright (c) 2011-2015 Wingpanel Developers (http://launchpad.net/wingpanel)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 */

#include "wingpanel.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <glib-object.h>

enum  {
	WINGPANEL_INDICATOR_0_PROPERTY,
	WINGPANEL_INDICATOR_CODE_NAME_PROPERTY,
	WINGPANEL_INDICATOR_VISIBLE_PROPERTY,
	WINGPANEL_INDICATOR_NUM_PROPERTIES
};
static GParamSpec* wingpanel_indicator_properties[WINGPANEL_INDICATOR_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	WINGPANEL_INDICATOR_CLOSE_SIGNAL,
	WINGPANEL_INDICATOR_NUM_SIGNALS
};
static guint wingpanel_indicator_signals[WINGPANEL_INDICATOR_NUM_SIGNALS] = {0};

struct _WingpanelIndicatorPrivate {
	gchar* _code_name;
	gboolean _visible;
};

static gint WingpanelIndicator_private_offset;
static gpointer wingpanel_indicator_parent_class = NULL;

static GtkWidget* wingpanel_indicator_real_get_display_widget (WingpanelIndicator* self);
static GtkWidget* wingpanel_indicator_real_get_widget (WingpanelIndicator* self);
static void wingpanel_indicator_real_opened (WingpanelIndicator* self);
static void wingpanel_indicator_real_closed (WingpanelIndicator* self);
static void wingpanel_indicator_finalize (GObject * obj);
static GType wingpanel_indicator_get_type_once (void);
static void _vala_wingpanel_indicator_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_wingpanel_indicator_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);

static inline gpointer
wingpanel_indicator_get_instance_private (WingpanelIndicator* self)
{
	return G_STRUCT_MEMBER_P (self, WingpanelIndicator_private_offset);
}

/**
     * Returns the display widget that will be displayed in the panel.
     * Middle click and scroll events will be passed to this widget.
     * If get_widget () returns null all EventButton events will be passed.
     *
     * @return a {@link Gtk.Widget} that represents the status.
     */
static GtkWidget*
wingpanel_indicator_real_get_display_widget (WingpanelIndicator* self)
{
	g_critical ("Type `%s' does not implement abstract method `wingpanel_indicator_get_display_widget'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GtkWidget*
wingpanel_indicator_get_display_widget (WingpanelIndicator* self)
{
	WingpanelIndicatorClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = WINGPANEL_INDICATOR_GET_CLASS (self);
	if (_klass_->get_display_widget) {
		return _klass_->get_display_widget (self);
	}
	return NULL;
}

/**
     * Returns the widget that will be displayed in the popover.
     * Return null if no popover should be shown.
     *
     * @return a {@link Gtk.Widget} containing the popover interface.
     */
static GtkWidget*
wingpanel_indicator_real_get_widget (WingpanelIndicator* self)
{
	g_critical ("Type `%s' does not implement abstract method `wingpanel_indicator_get_widget'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GtkWidget*
wingpanel_indicator_get_widget (WingpanelIndicator* self)
{
	WingpanelIndicatorClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = WINGPANEL_INDICATOR_GET_CLASS (self);
	if (_klass_->get_widget) {
		return _klass_->get_widget (self);
	}
	return NULL;
}

/**
     * Called when the indicator popover opened.
     */
static void
wingpanel_indicator_real_opened (WingpanelIndicator* self)
{
	g_critical ("Type `%s' does not implement abstract method `wingpanel_indicator_opened'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
wingpanel_indicator_opened (WingpanelIndicator* self)
{
	WingpanelIndicatorClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = WINGPANEL_INDICATOR_GET_CLASS (self);
	if (_klass_->opened) {
		_klass_->opened (self);
	}
}

/**
     * Called when the indicator popover closed.
     */
static void
wingpanel_indicator_real_closed (WingpanelIndicator* self)
{
	g_critical ("Type `%s' does not implement abstract method `wingpanel_indicator_closed'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
wingpanel_indicator_closed (WingpanelIndicator* self)
{
	WingpanelIndicatorClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = WINGPANEL_INDICATOR_GET_CLASS (self);
	if (_klass_->closed) {
		_klass_->closed (self);
	}
}

WingpanelIndicator*
wingpanel_indicator_construct (GType object_type)
{
	WingpanelIndicator * self = NULL;
	self = (WingpanelIndicator*) g_object_new (object_type, NULL);
	return self;
}

const gchar*
wingpanel_indicator_get_code_name (WingpanelIndicator* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_code_name;
	result = _tmp0_;
	return result;
}

static void
wingpanel_indicator_set_code_name (WingpanelIndicator* self,
                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = wingpanel_indicator_get_code_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_code_name);
		self->priv->_code_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, wingpanel_indicator_properties[WINGPANEL_INDICATOR_CODE_NAME_PROPERTY]);
	}
}

gboolean
wingpanel_indicator_get_visible (WingpanelIndicator* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_visible;
	return result;
}

void
wingpanel_indicator_set_visible (WingpanelIndicator* self,
                                 gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = wingpanel_indicator_get_visible (self);
	if (old_value != value) {
		self->priv->_visible = value;
		g_object_notify_by_pspec ((GObject *) self, wingpanel_indicator_properties[WINGPANEL_INDICATOR_VISIBLE_PROPERTY]);
	}
}

static void
wingpanel_indicator_class_init (WingpanelIndicatorClass * klass,
                                gpointer klass_data)
{
	wingpanel_indicator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WingpanelIndicator_private_offset);
	((WingpanelIndicatorClass *) klass)->get_display_widget = (GtkWidget* (*) (WingpanelIndicator*)) wingpanel_indicator_real_get_display_widget;
	((WingpanelIndicatorClass *) klass)->get_widget = (GtkWidget* (*) (WingpanelIndicator*)) wingpanel_indicator_real_get_widget;
	((WingpanelIndicatorClass *) klass)->opened = (void (*) (WingpanelIndicator*)) wingpanel_indicator_real_opened;
	((WingpanelIndicatorClass *) klass)->closed = (void (*) (WingpanelIndicator*)) wingpanel_indicator_real_closed;
	G_OBJECT_CLASS (klass)->get_property = _vala_wingpanel_indicator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_wingpanel_indicator_set_property;
	G_OBJECT_CLASS (klass)->finalize = wingpanel_indicator_finalize;
	/**
	     * The unique name representing the indicator.
	     * It is also used for the indicator ordering.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), WINGPANEL_INDICATOR_CODE_NAME_PROPERTY, wingpanel_indicator_properties[WINGPANEL_INDICATOR_CODE_NAME_PROPERTY] = g_param_spec_string ("code-name", "code-name", "code-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * Defines if the indicator display widget should be shown or not.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), WINGPANEL_INDICATOR_VISIBLE_PROPERTY, wingpanel_indicator_properties[WINGPANEL_INDICATOR_VISIBLE_PROPERTY] = g_param_spec_boolean ("visible", "visible", "visible", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Request a popover closing.
	     */
	wingpanel_indicator_signals[WINGPANEL_INDICATOR_CLOSE_SIGNAL] = g_signal_new ("close", WINGPANEL_TYPE_INDICATOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
wingpanel_indicator_instance_init (WingpanelIndicator * self,
                                   gpointer klass)
{
	self->priv = wingpanel_indicator_get_instance_private (self);
	self->priv->_visible = FALSE;
}

static void
wingpanel_indicator_finalize (GObject * obj)
{
	WingpanelIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WINGPANEL_TYPE_INDICATOR, WingpanelIndicator);
	_g_free0 (self->priv->_code_name);
	G_OBJECT_CLASS (wingpanel_indicator_parent_class)->finalize (obj);
}

static GType
wingpanel_indicator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WingpanelIndicatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) wingpanel_indicator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WingpanelIndicator), 0, (GInstanceInitFunc) wingpanel_indicator_instance_init, NULL };
	GType wingpanel_indicator_type_id;
	wingpanel_indicator_type_id = g_type_register_static (G_TYPE_OBJECT, "WingpanelIndicator", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	WingpanelIndicator_private_offset = g_type_add_instance_private (wingpanel_indicator_type_id, sizeof (WingpanelIndicatorPrivate));
	return wingpanel_indicator_type_id;
}

GType
wingpanel_indicator_get_type (void)
{
	static volatile gsize wingpanel_indicator_type_id__once = 0;
	if (g_once_init_enter (&wingpanel_indicator_type_id__once)) {
		GType wingpanel_indicator_type_id;
		wingpanel_indicator_type_id = wingpanel_indicator_get_type_once ();
		g_once_init_leave (&wingpanel_indicator_type_id__once, wingpanel_indicator_type_id);
	}
	return wingpanel_indicator_type_id__once;
}

static void
_vala_wingpanel_indicator_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	WingpanelIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, WINGPANEL_TYPE_INDICATOR, WingpanelIndicator);
	switch (property_id) {
		case WINGPANEL_INDICATOR_CODE_NAME_PROPERTY:
		g_value_set_string (value, wingpanel_indicator_get_code_name (self));
		break;
		case WINGPANEL_INDICATOR_VISIBLE_PROPERTY:
		g_value_set_boolean (value, wingpanel_indicator_get_visible (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_wingpanel_indicator_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	WingpanelIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, WINGPANEL_TYPE_INDICATOR, WingpanelIndicator);
	switch (property_id) {
		case WINGPANEL_INDICATOR_CODE_NAME_PROPERTY:
		wingpanel_indicator_set_code_name (self, g_value_get_string (value));
		break;
		case WINGPANEL_INDICATOR_VISIBLE_PROPERTY:
		wingpanel_indicator_set_visible (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

