/*
 * Decompiled with CFR 0.152.
 */
package tim.prune;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import tim.prune.App;
import tim.prune.FileDropHandler;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.Config;
import tim.prune.config.ConfigException;
import tim.prune.gui.DetailsDisplay;
import tim.prune.gui.IconManager;
import tim.prune.gui.MenuManager;
import tim.prune.gui.SelectorDisplay;
import tim.prune.gui.SidebarController;
import tim.prune.gui.StatusBar;
import tim.prune.gui.Viewport;
import tim.prune.gui.map.MapCanvas;
import tim.prune.gui.profile.ProfileChart;

public class GpsPrune {
    public static final String VERSION_NUMBER = "21.1";
    public static final String BUILD_NUMBER = "392";
    private static App APP = null;
    private static final String PROGRAM_NAME = "GpsPrune";

    public static void main(String[] stringArray) {
        boolean bl;
        Locale locale = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        ArrayList<File> arrayList = new ArrayList<File>();
        boolean bl2 = false;
        if (System.getProperty("mrj.version") != null) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", PROGRAM_NAME);
        }
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string4 = stringArray2[n2];
            if (string4.startsWith("--lang=")) {
                string = string4.substring(7);
                locale = GpsPrune.getLanguage(string);
            } else if (string4.startsWith("--langfile=")) {
                string2 = string4.substring(11);
            } else if (string4.startsWith("--configfile=")) {
                string3 = string4.substring(13);
            } else if (string4.startsWith("--help")) {
                bl2 = true;
            } else {
                File file = new File(string4);
                if (file.exists() && file.isFile() && file.canRead()) {
                    arrayList.add(file);
                } else {
                    System.out.println(GpsPrune.makeUnknownParameterString(string4));
                    bl2 = true;
                }
            }
            ++n2;
        }
        if (bl2) {
            System.out.println("GpsPrune - a tool for editing GPS data.\nPossible parameters:\n   --configfile=<file> used to specify a configuration file\n   --lang=<code>       used to specify language code such as DE\n   --langfile=<file>   used to specify an alternative language file\n");
        }
        try {
            if (string3 != null) {
                Config.loadFile(new File(string3));
            } else {
                Config.loadDefaultFile();
            }
        }
        catch (ConfigException configException) {
            System.err.println("Failed to load config file: " + string3);
        }
        boolean bl3 = bl = locale != null;
        if (bl) {
            Config.setConfigString("prune.languagecode", string);
        } else {
            Locale locale2;
            String string5 = Config.getConfigString("prune.languagecode");
            if (string5 != null && (locale2 = GpsPrune.getLanguage(string5)) != null) {
                locale = locale2;
            }
        }
        I18nManager.init(locale);
        if (string2 == null && !bl) {
            string2 = Config.getConfigString("prune.languagefile");
        }
        if (string2 != null) {
            try {
                I18nManager.addLanguageFile(string2);
                Config.setConfigString("prune.languagefile", string2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("Failed to load language file: " + string2);
                Config.setConfigString("prune.languagefile", "");
            }
        }
        try {
            String string6 = Config.getConfigString("prune.windowstyle");
            UIManager.setLookAndFeel(string6);
        }
        catch (Exception exception) {}
        GpsPrune.launch(arrayList);
    }

    private static Locale getLanguage(String string) {
        if (string.length() == 2) {
            return new Locale(string);
        }
        if (string.length() == 5 && string.charAt(2) == '_') {
            return new Locale(string.substring(0, 2), string.substring(3));
        }
        System.out.println("Unrecognised locale '" + string + "' - value should be eg 'DE' or 'DE_ch'");
        return null;
    }

    private static void launch(ArrayList<File> arrayList) {
        Object object;
        JFrame jFrame = new JFrame(PROGRAM_NAME);
        APP = new App(jFrame);
        MenuManager menuManager = new MenuManager(APP, APP.getTrackInfo());
        jFrame.setJMenuBar(menuManager.createMenuBar());
        APP.setMenuManager(menuManager);
        UpdateMessageBroker.addSubscriber(menuManager);
        JToolBar jToolBar = menuManager.createToolBar();
        SelectorDisplay selectorDisplay = new SelectorDisplay(APP.getTrackInfo());
        UpdateMessageBroker.addSubscriber(selectorDisplay);
        DetailsDisplay detailsDisplay = new DetailsDisplay(APP.getTrackInfo());
        UpdateMessageBroker.addSubscriber(detailsDisplay);
        MapCanvas mapCanvas = new MapCanvas(APP, APP.getTrackInfo());
        UpdateMessageBroker.addSubscriber(mapCanvas);
        Viewport viewport = new Viewport(mapCanvas);
        APP.setViewport(viewport);
        ProfileChart profileChart = new ProfileChart(APP.getTrackInfo());
        UpdateMessageBroker.addSubscriber(profileChart);
        StatusBar statusBar = new StatusBar();
        UpdateMessageBroker.addSubscriber(statusBar);
        UpdateMessageBroker.informSubscribers("GpsPrune v21.1");
        JSplitPane jSplitPane = new JSplitPane(0, mapCanvas, profileChart);
        jSplitPane.setResizeWeight(1.0);
        JSplitPane jSplitPane2 = new JSplitPane(1, jSplitPane, detailsDisplay);
        jSplitPane2.setResizeWeight(1.0);
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)jToolBar, "North");
        JSplitPane jSplitPane3 = new JSplitPane(1, selectorDisplay, jSplitPane2);
        jFrame.getContentPane().add((Component)jSplitPane3, "Center");
        jFrame.getContentPane().add((Component)statusBar, "South");
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                APP.exit();
            }
        });
        jFrame.setDefaultCloseOperation(0);
        try {
            String[] stringArray;
            object = new ArrayList();
            String[] stringArray2 = stringArray = new String[]{"_16", "_20", "_22", "_24", "_32", "_36", "_48", "_64", "_72", "_96", "_128"};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                ((ArrayList)object).add(IconManager.getImageIcon("window_icon" + string + ".png").getImage());
                ++n2;
            }
            jFrame.setIconImages((List<? extends Image>)object);
        }
        catch (Exception exception) {
            try {
                jFrame.setIconImage(IconManager.getImageIcon("window_icon_16.png").getImage());
            }
            catch (Exception exception2) {}
        }
        jFrame.setTransferHandler(new FileDropHandler(APP));
        jFrame.pack();
        if (!GpsPrune.setFrameBoundsFromConfig(jFrame)) {
            jFrame.setSize(650, 450);
        }
        jFrame.setVisible(true);
        jSplitPane.setDividerLocation(0.75);
        UpdateMessageBroker.informSubscribers();
        object = new SidebarController(new Component[]{selectorDisplay, profileChart, detailsDisplay}, new JSplitPane[]{jSplitPane3, jSplitPane, jSplitPane2});
        APP.setSidebarController((SidebarController)object);
        APP.loadDataFiles(arrayList);
    }

    private static boolean setFrameBoundsFromConfig(JFrame jFrame) {
        String string = Config.getConfigString("prune.windowbounds");
        try {
            String[] stringArray = string.split("x");
            if (stringArray.length == 4) {
                int[] nArray = new int[4];
                int n = 0;
                while (n < 4) {
                    nArray[n] = Integer.parseInt(stringArray[n]);
                    ++n;
                }
                nArray[2] = Math.max(nArray[2], 400);
                nArray[3] = Math.max(nArray[3], 300);
                jFrame.setBounds(nArray[0], nArray[1], nArray[2], nArray[3]);
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (NumberFormatException numberFormatException) {}
        return false;
    }

    private static String makeUnknownParameterString(String string) {
        File file = new File(string);
        if (file.exists()) {
            if (file.isDirectory()) {
                return "'" + string + "' is a directory";
            }
            if (!file.canRead()) {
                return "Cannot read file '" + string + "'";
            }
            return "Something wrong with file '" + string + "'";
        }
        do {
            String string2 = file.getName();
            if ((file = file.getParentFile()) == null || !file.exists() || !file.canRead()) continue;
            return "Tried to load file '" + string + "' but cannot find '" + string2 + "'";
        } while (file != null);
        return "Unknown parameter '" + string + "'";
    }
}

