/*
 * Decompiled with CFR 0.152.
 */
package org.junit.contrib.java.lang.system;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentVariables
implements TestRule {
    private final Map<String, String> buffer = new HashMap<String, String>();
    private boolean statementIsExecuting = false;

    public EnvironmentVariables set(String name, String value) {
        if (this.statementIsExecuting) {
            this.writeVariableToEnvMap(name, value);
        } else {
            this.writeVariableToBuffer(name, value);
        }
        return this;
    }

    public EnvironmentVariables clear(String ... names) {
        for (String name : names) {
            this.set(name, null);
        }
        return this;
    }

    private void writeVariableToEnvMap(String name, String value) {
        this.set(EnvironmentVariables.getEditableMapOfVariables(), name, value);
        this.set(EnvironmentVariables.getTheCaseInsensitiveEnvironment(), name, value);
    }

    private void set(Map<String, String> variables, String name, String value) {
        if (variables != null) {
            if (value == null) {
                variables.remove(name);
            } else {
                variables.put(name, value);
            }
        }
    }

    private void writeVariableToBuffer(String name, String value) {
        this.buffer.put(name, value);
    }

    private void copyVariablesFromBufferToEnvMap() {
        for (Map.Entry<String, String> nameAndValue : this.buffer.entrySet()) {
            this.writeVariableToEnvMap(nameAndValue.getKey(), nameAndValue.getValue());
        }
    }

    public Statement apply(Statement base, Description description) {
        return new EnvironmentVariablesStatement(base);
    }

    private static Map<String, String> getEditableMapOfVariables() {
        Class<?> classOfMap = System.getenv().getClass();
        try {
            return EnvironmentVariables.getFieldValue(classOfMap, System.getenv(), "m");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("System Rules cannot access the field 'm' of the map System.getenv().", e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("System Rules expects System.getenv() to have a field 'm' but it has not.", e);
        }
    }

    private static Map<String, String> getTheCaseInsensitiveEnvironment() {
        try {
            Class<?> processEnvironment = Class.forName("java.lang.ProcessEnvironment");
            return EnvironmentVariables.getFieldValue(processEnvironment, null, "theCaseInsensitiveEnvironment");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("System Rules expects the existence of the class java.lang.ProcessEnvironment but it does not exist.", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("System Rules cannot access the static field 'theCaseInsensitiveEnvironment' of the class java.lang.ProcessEnvironment.", e);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    private static Map<String, String> getFieldValue(Class<?> klass, Object object, String name) throws NoSuchFieldException, IllegalAccessException {
        Field field = klass.getDeclaredField(name);
        field.setAccessible(true);
        return (Map)field.get(object);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EnvironmentVariablesStatement
    extends Statement {
        final Statement baseStatement;
        Map<String, String> originalVariables;

        EnvironmentVariablesStatement(Statement baseStatement) {
            this.baseStatement = baseStatement;
        }

        public void evaluate() throws Throwable {
            this.saveCurrentState();
            EnvironmentVariables.this.statementIsExecuting = true;
            try {
                EnvironmentVariables.this.copyVariablesFromBufferToEnvMap();
                this.baseStatement.evaluate();
            }
            finally {
                EnvironmentVariables.this.statementIsExecuting = false;
                this.restoreOriginalVariables();
            }
        }

        void saveCurrentState() {
            this.originalVariables = new HashMap<String, String>(System.getenv());
        }

        void restoreOriginalVariables() {
            this.restoreVariables(EnvironmentVariables.getEditableMapOfVariables());
            Map theCaseInsensitiveEnvironment = EnvironmentVariables.getTheCaseInsensitiveEnvironment();
            if (theCaseInsensitiveEnvironment != null) {
                this.restoreVariables(theCaseInsensitiveEnvironment);
            }
        }

        void restoreVariables(Map<String, String> variables) {
            variables.clear();
            variables.putAll(this.originalVariables);
        }
    }
}

