/// <reference types="node" />
import { EventEmitter } from "events";
import { MatrixClient } from "../matrix";
import { MatrixEvent } from "./event";
import { EventTimelineSet } from './event-timeline-set';
import { Room } from './room';
/**
 * @experimental
 */
export declare class Thread extends EventEmitter {
    readonly room: Room;
    readonly client: MatrixClient;
    /**
     * A reference to the event ID at the top of the thread
     */
    private root;
    /**
     * A reference to all the events ID at the bottom of the threads
     */
    readonly tail: Set<string>;
    private _timelineSet;
    constructor(events: MatrixEvent[], room: Room, client: MatrixClient);
    /**
     * Add an event to the thread and updates
     * the tail/root references if needed
     * Will fire "Thread.update"
     * @param event The event to add
     */
    addEvent(event: MatrixEvent): Promise<void>;
    /**
     * Completes the reply chain with all events
     * missing from the current sync data
     * Will fire "Thread.ready"
     */
    fetchReplyChain(): Promise<void>;
    private decryptEvents;
    /**
     * Fetches an event over the network
     */
    private fetchEventById;
    /**
     * Finds an event by ID in the current thread
     */
    findEventById(eventId: string): MatrixEvent;
    /**
     * Determines thread's ready status
     */
    get ready(): boolean;
    /**
     * The thread ID, which is the same as the root event ID
     */
    get id(): string;
    /**
     * The thread root event
     */
    get rootEvent(): MatrixEvent;
    /**
     * The number of messages in the thread
     */
    get length(): number;
    /**
     * A set of mxid participating to the thread
     */
    get participants(): Set<string>;
    /**
     * A read-only getter to access the timeline set
     */
    get timelineSet(): EventTimelineSet;
    /**
     * A getter for the last event added to the thread
     */
    get replyToEvent(): MatrixEvent;
    get events(): MatrixEvent[];
    merge(thread: Thread): void;
}
