/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.filmInformation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.net.URISyntaxException;
import java.util.NoSuchElementException;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextArea;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mediathek.daten.DatenFilm;
import mediathek.daten.abo.DatenAbo;
import mediathek.gui.actions.UrlHyperlinkAction;
import mediathek.javafx.tool.JavaFxUtils;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.sender_icon_cache.MVSenderIconCache;
import net.miginfocom.layout.CC;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.sync.LockMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tbee.javafx.scene.layout.MigPane;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0002()B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001cH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u0010H\u0002J\b\u0010\"\u001a\u00020\u001cH\u0002J\b\u0010#\u001a\u00020\u001cH\u0002J\u0006\u0010$\u001a\u00020\u001cJ\u0010\u0010%\u001a\u00020\u001c2\b\u0010&\u001a\u0004\u0018\u00010\fJ\b\u0010'\u001a\u00020\u001cH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lmediathek/gui/filmInformation/InfoDialog;", "Ljavax/swing/JDialog;", "parent", "Ljava/awt/Window;", "(Ljava/awt/Window;)V", "cbHq", "Lmediathek/gui/filmInformation/InfoDialog$DisabledCheckBox;", "cbSubtitle", "config", "Lorg/apache/commons/configuration2/Configuration;", "kotlin.jvm.PlatformType", "currentFilm", "Lmediathek/daten/DatenFilm;", "hyperlink", "Ljavafx/scene/control/Hyperlink;", "lblAbo", "Ljavafx/scene/control/Label;", "lblDate", "lblDescription", "Ljavafx/scene/control/TextArea;", "lblDuration", "lblGeo", "lblSender", "lblSize", "lblThema", "lblTitle", "lblUhrzeit", "buildLayout", "", "clearControls", "createCopyUrlContextMenu", "Ljavafx/scene/control/ContextMenu;", "installContextMenu", "component", "restoreLocation", "saveLocation", "showInfo", "updateCurrentFilm", "film", "updateTextFields", "DisabledCheckBox", "RightOrientedLabel", "MediathekView"})
public final class InfoDialog
extends JDialog {
    private final Configuration config = ApplicationConfiguration.getConfiguration();
    @Nullable
    private DatenFilm currentFilm;
    @NotNull
    private final Label lblSender = new Label();
    @NotNull
    private final Label lblThema = new Label();
    @NotNull
    private final Label lblTitle = new Label();
    @NotNull
    private final Label lblDate = new Label();
    @NotNull
    private final Label lblUhrzeit = new Label();
    @NotNull
    private final Label lblDuration = new Label();
    @NotNull
    private final Label lblSize = new Label();
    @NotNull
    private final DisabledCheckBox cbHq = new DisabledCheckBox();
    @NotNull
    private final DisabledCheckBox cbSubtitle = new DisabledCheckBox();
    @NotNull
    private final Label lblGeo = new Label();
    @NotNull
    private final Label lblAbo = new Label();
    @NotNull
    private final Hyperlink hyperlink = new Hyperlink("Link zur Webseite");
    @NotNull
    private final TextArea lblDescription = new TextArea();

    public InfoDialog(@Nullable Window parent) {
        super(parent);
        this.setType(Window.Type.UTILITY);
        this.setTitle("Filminformation");
        this.setResizable(false);
        this.setSize(325, 520);
        this.setDefaultCloseOperation(2);
        this.buildLayout();
        this.updateTextFields();
        this.restoreLocation();
        boolean wasVisible = this.config.getBoolean("film.information.visible", false);
        if (wasVisible) {
            this.setVisible(true);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(@NotNull WindowEvent e) {
                Intrinsics.checkNotNullParameter(e, "e");
                config.setProperty("film.information.visible", true);
            }

            @Override
            public void windowClosed(@NotNull WindowEvent e) {
                Intrinsics.checkNotNullParameter(e, "e");
                config.setProperty("film.information.visible", false);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(@NotNull ComponentEvent e) {
                Intrinsics.checkNotNullParameter(e, "e");
                if (this.isVisible()) {
                    this.saveLocation();
                }
            }
        });
    }

    private final void installContextMenu(Label component) {
        ContextMenu ctMenu = new ContextMenu();
        MenuItem mi = new MenuItem("Text in die Zwischenablage kopieren");
        mi.setOnAction(arg_0 -> InfoDialog.installContextMenu$lambda-0(component, arg_0));
        ctMenu.getItems().add((Object)mi);
        component.setContextMenu(ctMenu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void restoreLocation() {
        this.config.lock(LockMode.READ);
        try {
            Point newLocation = new Point();
            newLocation.x = this.config.getInt("film.information.location.x");
            newLocation.y = this.config.getInt("film.information.location.y");
            this.setLocation(newLocation);
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        finally {
            this.config.unlock(LockMode.READ);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveLocation() {
        if (!this.isVisible()) {
            return;
        }
        this.config.lock(LockMode.WRITE);
        try {
            Point location = this.getLocationOnScreen();
            this.config.setProperty("film.information.location.x", location.x);
            this.config.setProperty("film.information.location.y", location.y);
        }
        finally {
            this.config.unlock(LockMode.WRITE);
        }
    }

    public final void showInfo() {
        this.updateTextFields();
        if (!this.isVisible()) {
            this.setVisible(true);
        }
    }

    private final void clearControls() {
        Platform.runLater(() -> InfoDialog.clearControls$lambda-1(this));
    }

    private final void updateTextFields() {
        if (this.currentFilm == null) {
            this.clearControls();
        } else {
            Platform.runLater(() -> InfoDialog.updateTextFields$lambda-4(this));
        }
    }

    public final void updateCurrentFilm(@Nullable DatenFilm film) {
        this.currentFilm = film;
        if (this.isVisible()) {
            this.updateTextFields();
        }
    }

    private final void buildLayout() {
        this.getContentPane().setLayout(new BorderLayout());
        JFXPanel newFxPanel = new JFXPanel();
        this.getContentPane().add((Component)newFxPanel, "Center");
        Platform.runLater(() -> InfoDialog.buildLayout$lambda-7(this, newFxPanel));
    }

    private final ContextMenu createCopyUrlContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem mi = new MenuItem("URL kopieren");
        mi.setOnAction(arg_0 -> InfoDialog.createCopyUrlContextMenu$lambda-9(this, arg_0));
        contextMenu.getItems().add((Object)mi);
        return contextMenu;
    }

    private static final void installContextMenu$lambda-0(Label $component, ActionEvent it) {
        Intrinsics.checkNotNullParameter($component, "$component");
        GuiFunktionen.copyToClipboard($component.getText());
    }

    private static final void clearControls$lambda-1(InfoDialog this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.lblDescription.setText("");
        this$0.lblAbo.setText("");
        this$0.lblGeo.setText("");
        this$0.lblSender.setText("");
        this$0.lblSender.setGraphic(null);
        this$0.lblSize.setText("");
        this$0.lblThema.setText("");
        this$0.lblTitle.setText("");
        this$0.lblDate.setText("");
        this$0.lblUhrzeit.setText("");
        this$0.lblDuration.setText("");
        this$0.cbHq.setSelected(false);
        this$0.cbSubtitle.setSelected(false);
        this$0.hyperlink.setTooltip(null);
        this$0.hyperlink.setDisable(true);
    }

    private static final void updateTextFields$lambda-4$lambda-3(InfoDialog this$0, ImageIcon icon) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.lblSender.setText("");
        this$0.lblSender.setGraphic((Node)new ImageView((Image)SwingFXUtils.toFXImage((BufferedImage)JavaFxUtils.toBufferedImage(icon), null)));
    }

    /*
     * WARNING - void declaration
     */
    private static final void updateTextFields$lambda-4(InfoDialog this$0) {
        void $this$trim$iv;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        DatenFilm datenFilm = this$0.currentFilm;
        Intrinsics.checkNotNull(datenFilm);
        String string = datenFilm.getDescription();
        Intrinsics.checkNotNullExpressionValue(string, "currentFilm!!.description");
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        String desc = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        this$0.lblDescription.setText(desc);
        this$0.lblDescription.setScrollTop(0.0);
        this$0.lblDescription.setScrollLeft(0.0);
        DatenFilm datenFilm2 = this$0.currentFilm;
        Intrinsics.checkNotNull(datenFilm2);
        string = datenFilm2.getSender();
        Intrinsics.checkNotNullExpressionValue(string, "currentFilm!!.sender");
        MVSenderIconCache.get(string, true).ifPresent(arg_0 -> InfoDialog.updateTextFields$lambda-4$lambda-3(this$0, arg_0));
        Label label = this$0.lblGeo;
        DatenFilm datenFilm3 = this$0.currentFilm;
        Intrinsics.checkNotNull(datenFilm3);
        label.setText(datenFilm3.getGeo().orElse(""));
        Label label2 = this$0.lblSize;
        DatenFilm datenFilm4 = this$0.currentFilm;
        Intrinsics.checkNotNull(datenFilm4);
        label2.setText(datenFilm4.getSize());
        Label label3 = this$0.lblThema;
        DatenFilm datenFilm5 = this$0.currentFilm;
        Intrinsics.checkNotNull(datenFilm5);
        label3.setText(datenFilm5.getThema());
        Label label4 = this$0.lblTitle;
        DatenFilm datenFilm6 = this$0.currentFilm;
        Intrinsics.checkNotNull(datenFilm6);
        label4.setText(datenFilm6.getTitle());
        Label label5 = this$0.lblDate;
        DatenFilm datenFilm7 = this$0.currentFilm;
        Intrinsics.checkNotNull(datenFilm7);
        label5.setText(datenFilm7.getSendeDatum());
        Label label6 = this$0.lblUhrzeit;
        DatenFilm datenFilm8 = this$0.currentFilm;
        Intrinsics.checkNotNull(datenFilm8);
        label6.setText(datenFilm8.getSendeZeit());
        Label label7 = this$0.lblDuration;
        DatenFilm datenFilm9 = this$0.currentFilm;
        Intrinsics.checkNotNull(datenFilm9);
        label7.setText(datenFilm9.getDauer());
        DisabledCheckBox disabledCheckBox = this$0.cbHq;
        DatenFilm datenFilm10 = this$0.currentFilm;
        Intrinsics.checkNotNull(datenFilm10);
        disabledCheckBox.setSelected(datenFilm10.isHighQuality());
        DisabledCheckBox disabledCheckBox2 = this$0.cbSubtitle;
        DatenFilm datenFilm11 = this$0.currentFilm;
        Intrinsics.checkNotNull(datenFilm11);
        disabledCheckBox2.setSelected(datenFilm11.hasSubtitle());
        Hyperlink hyperlink = this$0.hyperlink;
        DatenFilm datenFilm12 = this$0.currentFilm;
        Intrinsics.checkNotNull(datenFilm12);
        hyperlink.setTooltip(new Tooltip(datenFilm12.getWebsiteLink()));
        this$0.hyperlink.setDisable(false);
        Label label8 = this$0.lblAbo;
        DatenFilm datenFilm13 = this$0.currentFilm;
        Intrinsics.checkNotNull(datenFilm13);
        DatenAbo datenAbo = datenFilm13.getAbo();
        label8.setText((String)(datenAbo == null ? null : datenAbo.getName()));
    }

    private static final void buildLayout$lambda-7$lambda-6$lambda-5(InfoDialog this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        if (this$0.currentFilm != null) {
            try {
                DatenFilm datenFilm = this$0.currentFilm;
                Intrinsics.checkNotNull(datenFilm);
                UrlHyperlinkAction.openURL(null, datenFilm.getWebsiteLink());
            }
            catch (URISyntaxException ex) {
                ex.printStackTrace();
            }
        }
    }

    private static final void buildLayout$lambda-7$lambda-6(InfoDialog this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        SwingUtilities.invokeLater(() -> InfoDialog.buildLayout$lambda-7$lambda-6$lambda-5(this$0));
    }

    private static final void buildLayout$lambda-7(InfoDialog this$0, JFXPanel $newFxPanel) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($newFxPanel, "$newFxPanel");
        MigPane migPane = new MigPane("hidemode 3", "[fill,shrink 0][fill]", "[][][][][][][][][][][][][][fill,grow]");
        int[] nArray = new int[]{0, 0};
        migPane.add((Node)new RightOrientedLabel("Sender:"), new CC().cell(nArray));
        nArray = new int[]{1, 0};
        migPane.add((Node)this$0.lblSender, new CC().cell(nArray));
        nArray = new int[]{0, 1};
        migPane.add((Node)new RightOrientedLabel("Thema:"), new CC().cell(nArray));
        this$0.lblThema.setWrapText(true);
        this$0.installContextMenu(this$0.lblThema);
        nArray = new int[]{1, 1};
        migPane.add((Node)this$0.lblThema, new CC().cell(nArray).growY());
        nArray = new int[]{0, 2};
        migPane.add((Node)new RightOrientedLabel("Titel:"), new CC().cell(nArray));
        this$0.lblTitle.setWrapText(true);
        this$0.installContextMenu(this$0.lblTitle);
        nArray = new int[]{1, 2};
        migPane.add((Node)this$0.lblTitle, new CC().cell(nArray).growY());
        nArray = new int[]{0, 3};
        migPane.add((Node)new RightOrientedLabel("Datum:"), new CC().cell(nArray));
        nArray = new int[]{1, 3};
        migPane.add((Node)this$0.lblDate, new CC().cell(nArray));
        nArray = new int[]{0, 4};
        migPane.add((Node)new RightOrientedLabel("Uhrzeit:"), new CC().cell(nArray));
        nArray = new int[]{1, 4};
        migPane.add((Node)this$0.lblUhrzeit, new CC().cell(nArray));
        nArray = new int[]{0, 5};
        migPane.add((Node)new RightOrientedLabel("Dauer:"), new CC().cell(nArray));
        nArray = new int[]{1, 5};
        migPane.add((Node)this$0.lblDuration, new CC().cell(nArray));
        nArray = new int[]{0, 6};
        migPane.add((Node)new RightOrientedLabel("Gr\u00f6\u00dfe (MB):"), new CC().cell(nArray));
        nArray = new int[]{1, 6};
        migPane.add((Node)this$0.lblSize, new CC().cell(nArray));
        nArray = new int[]{0, 7};
        migPane.add((Node)new RightOrientedLabel("HQ:"), new CC().cell(nArray));
        nArray = new int[]{1, 7};
        migPane.add((Node)this$0.cbHq, new CC().cell(nArray));
        nArray = new int[]{0, 8};
        migPane.add((Node)new RightOrientedLabel("Untertitel:"), new CC().cell(nArray));
        nArray = new int[]{1, 8};
        migPane.add((Node)this$0.cbSubtitle, new CC().cell(nArray));
        nArray = new int[]{0, 9};
        migPane.add((Node)new RightOrientedLabel("Geo:"), new CC().cell(nArray));
        nArray = new int[]{1, 9};
        migPane.add((Node)this$0.lblGeo, new CC().cell(nArray));
        nArray = new int[]{0, 10};
        migPane.add((Node)new RightOrientedLabel("Abo:"), new CC().cell(nArray));
        nArray = new int[]{1, 10};
        migPane.add((Node)this$0.lblAbo, new CC().cell(nArray));
        nArray = new int[]{0, 12};
        migPane.add((Node)new RightOrientedLabel("Beschreibung:"), new CC().cell(nArray));
        this$0.hyperlink.setContextMenu(this$0.createCopyUrlContextMenu());
        this$0.hyperlink.setUnderline(true);
        this$0.hyperlink.setOnAction(arg_0 -> InfoDialog.buildLayout$lambda-7$lambda-6(this$0, arg_0));
        nArray = new int[]{0, 11};
        migPane.add((Node)this$0.hyperlink, new CC().cell(nArray).spanX(2));
        this$0.lblDescription.setWrapText(true);
        this$0.lblDescription.setPrefRowCount(4);
        this$0.lblDescription.setEditable(false);
        nArray = new int[]{0, 13};
        migPane.add((Node)this$0.lblDescription, new CC().cell(nArray).spanX(2).growY().growX().minHeight("60"));
        $newFxPanel.setScene(new Scene((Parent)migPane));
    }

    private static final void createCopyUrlContextMenu$lambda-9$lambda-8(InfoDialog this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        DatenFilm datenFilm = this$0.currentFilm;
        Intrinsics.checkNotNull(datenFilm);
        GuiFunktionen.copyToClipboard(datenFilm.getWebsiteLink());
    }

    private static final void createCopyUrlContextMenu$lambda-9(InfoDialog this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        SwingUtilities.invokeLater(() -> InfoDialog.createCopyUrlContextMenu$lambda-9$lambda-8(this$0));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lmediathek/gui/filmInformation/InfoDialog$RightOrientedLabel;", "Ljavafx/scene/control/Label;", "label", "", "(Ljava/lang/String;)V", "MediathekView"})
    public static final class RightOrientedLabel
    extends Label {
        public RightOrientedLabel(@Nullable String label) {
            super(label);
            this.setAlignment(Pos.BASELINE_RIGHT);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lmediathek/gui/filmInformation/InfoDialog$DisabledCheckBox;", "Ljavafx/scene/control/CheckBox;", "()V", "MediathekView"})
    public static final class DisabledCheckBox
    extends CheckBox {
        public DisabledCheckBox() {
            this.setDisable(true);
        }
    }
}

