/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx.tool;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javafx.application.Platform;
import javafx.scene.paint.Color;
import javax.swing.ImageIcon;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class JavaFxUtils {
    private static final Logger logger = LogManager.getLogger(JavaFxUtils.class);

    public static void invokeInFxThreadAndWait(Runnable run) {
        if (Platform.isFxApplicationThread()) {
            run.run();
            return;
        }
        try {
            FutureTask<Object> future = new FutureTask<Object>(run, null);
            Platform.runLater(future);
            future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("invokeInFxThreadAndWait() failed", (Throwable)e);
        }
    }

    public static <V> V invokeInFxThreadAndWait(Callable<V> call) {
        V result = null;
        if (Platform.isFxApplicationThread()) {
            try {
                result = call.call();
            }
            catch (Exception e) {
                logger.error("invokeInFxThreadAndWait() failed", (Throwable)e);
            }
        } else {
            try {
                FutureTask<V> future = new FutureTask<V>(call);
                Platform.runLater(future);
                result = future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                logger.error("invokeInFxThreadAndWait() failed", (Throwable)e);
            }
        }
        return result;
    }

    public static Color toFXColor(@NotNull java.awt.Color awtColor) {
        int r = awtColor.getRed();
        int g2 = awtColor.getGreen();
        int b = awtColor.getBlue();
        int a = awtColor.getAlpha();
        double opacity = (double)a / 255.0;
        return Color.rgb((int)r, (int)g2, (int)b, (double)opacity);
    }

    public static BufferedImage toBufferedImage(ImageIcon icon) {
        BufferedImage bi = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D g2 = bi.createGraphics();
        icon.paintIcon(null, g2, 0, 0);
        g2.dispose();
        return bi;
    }
}

