//
//  Emojione.m
//
//  Created by Alessandro Calzavara on 16/12/14.
//  Copyright (c) 2014 Spreaker, Inc.
//

#import "Emojione.h"

@implementation Emojione

+ (NSString *)shortnameToUnicode:(NSString *)string
{
    static NSDictionary * emojiMapping;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        emojiMapping = [self _loadShortNameToUnicode];
    });

    NSString * SHORTNAME_PATTERN = @":([-+\\w]+):";

    NSMutableString * unicodeString = [string mutableCopy];
    NSError * error = nil;
    NSRegularExpression * regex = [NSRegularExpression regularExpressionWithPattern:SHORTNAME_PATTERN
                                                                            options:0
                                                                              error:&error];

    NSAssert(!error, @"Unable to create regex: ", error);

    NSArray * matches = [regex matchesInString:unicodeString
                                       options:0
                                         range:NSMakeRange(0, [unicodeString length])];
    
    for (NSTextCheckingResult * result in [matches reverseObjectEnumerator]) {

        if ([result numberOfRanges] < 2) {
            continue;
        }
        
        // Range 0: full shortname
        // Range 1: shortname without :
        
        NSString * shortname = [string substringWithRange:[result rangeAtIndex:1]];
        NSString * emoji = [emojiMapping objectForKey:shortname];
        if (emoji) {
            [unicodeString replaceCharactersInRange:[result rangeAtIndex:0]
                                         withString:emoji];
        }
    }

    return unicodeString;
}

+ (NSDictionary *)_loadShortNameToUnicode
{
    // Mapping generated by script.

    return @{
        @"interrobang" : @"\U00002049",
        @"tm" : @"\U00002122",
        @"information_source" : @"\U00002139",
        @"left_right_arrow" : @"\U00002194",
        @"arrow_up_down" : @"\U00002195",
        @"arrow_upper_left" : @"\U00002196",
        @"arrow_upper_right" : @"\U00002197",
        @"arrow_lower_right" : @"\U00002198",
        @"arrow_lower_left" : @"\U00002199",
        @"keyboard" : @"\U00002328",
        @"sunny" : @"\U00002600",
        @"cloud" : @"\U00002601",
        @"umbrella2" : @"\U00002602",
        @"snowman2" : @"\U00002603",
        @"comet" : @"\U00002604",
        @"ballot_box_with_check" : @"\U00002611",
        @"umbrella" : @"\U00002614",
        @"coffee" : @"\U00002615",
        @"shamrock" : @"\U00002618",
        @"skull_crossbones" : @"\U00002620",
        @"radioactive" : @"\U00002622",
        @"biohazard" : @"\U00002623",
        @"orthodox_cross" : @"\U00002626",
        @"wheel_of_dharma" : @"\U00002638",
        @"frowning2" : @"\U00002639",
        @"female_sign" : @"\U00002640",
        @"male_sign" : @"\U00002642",
        @"aries" : @"\U00002648",
        @"taurus" : @"\U00002649",
        @"sagittarius" : @"\U00002650",
        @"capricorn" : @"\U00002651",
        @"aquarius" : @"\U00002652",
        @"pisces" : @"\U00002653",
        @"spades" : @"\U00002660",
        @"clubs" : @"\U00002663",
        @"hearts" : @"\U00002665",
        @"diamonds" : @"\U00002666",
        @"hotsprings" : @"\U00002668",
        @"hammer_pick" : @"\U00002692",
        @"anchor" : @"\U00002693",
        @"crossed_swords" : @"\U00002694",
        @"medical_symbol" : @"\U00002695",
        @"scales" : @"\U00002696",
        @"alembic" : @"\U00002697",
        @"gear" : @"\U00002699",
        @"scissors" : @"\U00002702",
        @"white_check_mark" : @"\U00002705",
        @"airplane" : @"\U00002708",
        @"envelope" : @"\U00002709",
        @"black_nib" : @"\U00002712",
        @"heavy_check_mark" : @"\U00002714",
        @"heavy_multiplication_x" : @"\U00002716",
        @"star_of_david" : @"\U00002721",
        @"sparkles" : @"\U00002728",
        @"eight_spoked_asterisk" : @"\U00002733",
        @"eight_pointed_black_star" : @"\U00002734",
        @"snowflake" : @"\U00002744",
        @"sparkle" : @"\U00002747",
        @"question" : @"\U00002753",
        @"grey_question" : @"\U00002754",
        @"grey_exclamation" : @"\U00002755",
        @"exclamation" : @"\U00002757",
        @"heart_exclamation" : @"\U00002763",
        @"heart" : @"\U00002764",
        @"heavy_plus_sign" : @"\U00002795",
        @"heavy_minus_sign" : @"\U00002796",
        @"heavy_division_sign" : @"\U00002797",
        @"arrow_heading_up" : @"\U00002934",
        @"arrow_heading_down" : @"\U00002935",
        @"wavy_dash" : @"\U00003030",
        @"congratulations" : @"\U00003297",
        @"secret" : @"\U00003299",
        @"grinning" : @"\U0001f600",
        @"smiley" : @"\U0001f603",
        @"smile" : @"\U0001f604",
        @"grin" : @"\U0001f601",
        @"laughing" : @"\U0001f606",
        @"sweat_smile" : @"\U0001f605",
        @"joy" : @"\U0001f602",
        @"rofl" : @"\U0001f923",
        @"relaxed" : @"\U0000263a",
        @"blush" : @"\U0001f60a",
        @"innocent" : @"\U0001f607",
        @"slight_smile" : @"\U0001f642",
        @"upside_down" : @"\U0001f643",
        @"wink" : @"\U0001f609",
        @"relieved" : @"\U0001f60c",
        @"heart_eyes" : @"\U0001f60d",
        @"kissing_heart" : @"\U0001f618",
        @"kissing" : @"\U0001f617",
        @"kissing_smiling_eyes" : @"\U0001f619",
        @"kissing_closed_eyes" : @"\U0001f61a",
        @"yum" : @"\U0001f60b",
        @"stuck_out_tongue_winking_eye" : @"\U0001f61c",
        @"stuck_out_tongue_closed_eyes" : @"\U0001f61d",
        @"stuck_out_tongue" : @"\U0001f61b",
        @"money_mouth" : @"\U0001f911",
        @"hugging" : @"\U0001f917",
        @"nerd" : @"\U0001f913",
        @"sunglasses" : @"\U0001f60e",
        @"clown" : @"\U0001f921",
        @"cowboy" : @"\U0001f920",
        @"smirk" : @"\U0001f60f",
        @"unamused" : @"\U0001f612",
        @"disappointed" : @"\U0001f61e",
        @"pensive" : @"\U0001f614",
        @"worried" : @"\U0001f61f",
        @"confused" : @"\U0001f615",
        @"slight_frown" : @"\U0001f641",
        @"persevere" : @"\U0001f623",
        @"confounded" : @"\U0001f616",
        @"tired_face" : @"\U0001f62b",
        @"weary" : @"\U0001f629",
        @"triumph" : @"\U0001f624",
        @"angry" : @"\U0001f620",
        @"rage" : @"\U0001f621",
        @"no_mouth" : @"\U0001f636",
        @"neutral_face" : @"\U0001f610",
        @"expressionless" : @"\U0001f611",
        @"hushed" : @"\U0001f62f",
        @"frowning" : @"\U0001f626",
        @"anguished" : @"\U0001f627",
        @"open_mouth" : @"\U0001f62e",
        @"astonished" : @"\U0001f632",
        @"dizzy_face" : @"\U0001f635",
        @"flushed" : @"\U0001f633",
        @"scream" : @"\U0001f631",
        @"fearful" : @"\U0001f628",
        @"cold_sweat" : @"\U0001f630",
        @"cry" : @"\U0001f622",
        @"disappointed_relieved" : @"\U0001f625",
        @"drooling_face" : @"\U0001f924",
        @"sob" : @"\U0001f62d",
        @"sweat" : @"\U0001f613",
        @"sleepy" : @"\U0001f62a",
        @"sleeping" : @"\U0001f634",
        @"rolling_eyes" : @"\U0001f644",
        @"thinking" : @"\U0001f914",
        @"lying_face" : @"\U0001f925",
        @"grimacing" : @"\U0001f62c",
        @"zipper_mouth" : @"\U0001f910",
        @"nauseated_face" : @"\U0001f922",
        @"sneezing_face" : @"\U0001f927",
        @"mask" : @"\U0001f637",
        @"thermometer_face" : @"\U0001f912",
        @"head_bandage" : @"\U0001f915",
        @"smiling_imp" : @"\U0001f608",
        @"imp" : @"\U0001f47f",
        @"japanese_ogre" : @"\U0001f479",
        @"japanese_goblin" : @"\U0001f47a",
        @"poop" : @"\U0001f4a9",
        @"ghost" : @"\U0001f47b",
        @"skull" : @"\U0001f480",
        @"alien" : @"\U0001f47d",
        @"space_invader" : @"\U0001f47e",
        @"robot" : @"\U0001f916",
        @"jack_o_lantern" : @"\U0001f383",
        @"smiley_cat" : @"\U0001f63a",
        @"smile_cat" : @"\U0001f638",
        @"joy_cat" : @"\U0001f639",
        @"heart_eyes_cat" : @"\U0001f63b",
        @"smirk_cat" : @"\U0001f63c",
        @"kissing_cat" : @"\U0001f63d",
        @"scream_cat" : @"\U0001f640",
        @"crying_cat_face" : @"\U0001f63f",
        @"pouting_cat" : @"\U0001f63e",
        @"open_hands" : @"\U0001f450",
        @"open_hands_tone1" : @"\U0001f450\U0001f3fb",
        @"open_hands_tone2" : @"\U0001f450\U0001f3fc",
        @"open_hands_tone3" : @"\U0001f450\U0001f3fd",
        @"open_hands_tone4" : @"\U0001f450\U0001f3fe",
        @"open_hands_tone5" : @"\U0001f450\U0001f3ff",
        @"raised_hands" : @"\U0001f64c",
        @"raised_hands_tone1" : @"\U0001f64c\U0001f3fb",
        @"raised_hands_tone2" : @"\U0001f64c\U0001f3fc",
        @"raised_hands_tone3" : @"\U0001f64c\U0001f3fd",
        @"raised_hands_tone4" : @"\U0001f64c\U0001f3fe",
        @"raised_hands_tone5" : @"\U0001f64c\U0001f3ff",
        @"clap" : @"\U0001f44f",
        @"clap_tone1" : @"\U0001f44f\U0001f3fb",
        @"clap_tone2" : @"\U0001f44f\U0001f3fc",
        @"clap_tone3" : @"\U0001f44f\U0001f3fd",
        @"clap_tone4" : @"\U0001f44f\U0001f3fe",
        @"clap_tone5" : @"\U0001f44f\U0001f3ff",
        @"pray" : @"\U0001f64f",
        @"pray_tone1" : @"\U0001f64f\U0001f3fb",
        @"pray_tone2" : @"\U0001f64f\U0001f3fc",
        @"pray_tone3" : @"\U0001f64f\U0001f3fd",
        @"pray_tone4" : @"\U0001f64f\U0001f3fe",
        @"pray_tone5" : @"\U0001f64f\U0001f3ff",
        @"handshake" : @"\U0001f91d",
        @"thumbsup" : @"\U0001f44d",
        @"thumbsup_tone1" : @"\U0001f44d\U0001f3fb",
        @"thumbsup_tone2" : @"\U0001f44d\U0001f3fc",
        @"thumbsup_tone3" : @"\U0001f44d\U0001f3fd",
        @"thumbsup_tone4" : @"\U0001f44d\U0001f3fe",
        @"thumbsup_tone5" : @"\U0001f44d\U0001f3ff",
        @"thumbsdown" : @"\U0001f44e",
        @"thumbsdown_tone1" : @"\U0001f44e\U0001f3fb",
        @"thumbsdown_tone2" : @"\U0001f44e\U0001f3fc",
        @"thumbsdown_tone3" : @"\U0001f44e\U0001f3fd",
        @"thumbsdown_tone4" : @"\U0001f44e\U0001f3fe",
        @"thumbsdown_tone5" : @"\U0001f44e\U0001f3ff",
        @"punch" : @"\U0001f44a",
        @"punch_tone1" : @"\U0001f44a\U0001f3fb",
        @"punch_tone2" : @"\U0001f44a\U0001f3fc",
        @"punch_tone3" : @"\U0001f44a\U0001f3fd",
        @"punch_tone4" : @"\U0001f44a\U0001f3fe",
        @"punch_tone5" : @"\U0001f44a\U0001f3ff",
        @"fist" : @"\U0000270a",
        @"fist_tone1" : @"\U0000270a\U0001f3fb",
        @"fist_tone2" : @"\U0000270a\U0001f3fc",
        @"fist_tone3" : @"\U0000270a\U0001f3fd",
        @"fist_tone4" : @"\U0000270a\U0001f3fe",
        @"fist_tone5" : @"\U0000270a\U0001f3ff",
        @"left_facing_fist" : @"\U0001f91b",
        @"left_facing_fist_tone1" : @"\U0001f91b\U0001f3fb",
        @"left_facing_fist_tone2" : @"\U0001f91b\U0001f3fc",
        @"left_facing_fist_tone3" : @"\U0001f91b\U0001f3fd",
        @"left_facing_fist_tone4" : @"\U0001f91b\U0001f3fe",
        @"left_facing_fist_tone5" : @"\U0001f91b\U0001f3ff",
        @"right_facing_fist" : @"\U0001f91c",
        @"right_facing_fist_tone1" : @"\U0001f91c\U0001f3fb",
        @"right_facing_fist_tone2" : @"\U0001f91c\U0001f3fc",
        @"right_facing_fist_tone3" : @"\U0001f91c\U0001f3fd",
        @"right_facing_fist_tone4" : @"\U0001f91c\U0001f3fe",
        @"right_facing_fist_tone5" : @"\U0001f91c\U0001f3ff",
        @"fingers_crossed" : @"\U0001f91e",
        @"fingers_crossed_tone1" : @"\U0001f91e\U0001f3fb",
        @"fingers_crossed_tone2" : @"\U0001f91e\U0001f3fc",
        @"fingers_crossed_tone3" : @"\U0001f91e\U0001f3fd",
        @"fingers_crossed_tone4" : @"\U0001f91e\U0001f3fe",
        @"fingers_crossed_tone5" : @"\U0001f91e\U0001f3ff",
        @"v" : @"\U0000270c",
        @"v_tone1" : @"\U0000270c\U0001f3fb",
        @"v_tone2" : @"\U0000270c\U0001f3fc",
        @"v_tone3" : @"\U0000270c\U0001f3fd",
        @"v_tone4" : @"\U0000270c\U0001f3fe",
        @"v_tone5" : @"\U0000270c\U0001f3ff",
        @"metal" : @"\U0001f918",
        @"metal_tone1" : @"\U0001f918\U0001f3fb",
        @"metal_tone2" : @"\U0001f918\U0001f3fc",
        @"metal_tone3" : @"\U0001f918\U0001f3fd",
        @"metal_tone4" : @"\U0001f918\U0001f3fe",
        @"metal_tone5" : @"\U0001f918\U0001f3ff",
        @"ok_hand" : @"\U0001f44c",
        @"ok_hand_tone1" : @"\U0001f44c\U0001f3fb",
        @"ok_hand_tone2" : @"\U0001f44c\U0001f3fc",
        @"ok_hand_tone3" : @"\U0001f44c\U0001f3fd",
        @"ok_hand_tone4" : @"\U0001f44c\U0001f3fe",
        @"ok_hand_tone5" : @"\U0001f44c\U0001f3ff",
        @"point_left" : @"\U0001f448",
        @"point_left_tone1" : @"\U0001f448\U0001f3fb",
        @"point_left_tone2" : @"\U0001f448\U0001f3fc",
        @"point_left_tone3" : @"\U0001f448\U0001f3fd",
        @"point_left_tone4" : @"\U0001f448\U0001f3fe",
        @"point_left_tone5" : @"\U0001f448\U0001f3ff",
        @"point_right" : @"\U0001f449",
        @"point_right_tone1" : @"\U0001f449\U0001f3fb",
        @"point_right_tone2" : @"\U0001f449\U0001f3fc",
        @"point_right_tone3" : @"\U0001f449\U0001f3fd",
        @"point_right_tone4" : @"\U0001f449\U0001f3fe",
        @"point_right_tone5" : @"\U0001f449\U0001f3ff",
        @"point_up_2" : @"\U0001f446",
        @"point_up_2_tone1" : @"\U0001f446\U0001f3fb",
        @"point_up_2_tone2" : @"\U0001f446\U0001f3fc",
        @"point_up_2_tone3" : @"\U0001f446\U0001f3fd",
        @"point_up_2_tone4" : @"\U0001f446\U0001f3fe",
        @"point_up_2_tone5" : @"\U0001f446\U0001f3ff",
        @"point_down" : @"\U0001f447",
        @"point_down_tone1" : @"\U0001f447\U0001f3fb",
        @"point_down_tone2" : @"\U0001f447\U0001f3fc",
        @"point_down_tone3" : @"\U0001f447\U0001f3fd",
        @"point_down_tone4" : @"\U0001f447\U0001f3fe",
        @"point_down_tone5" : @"\U0001f447\U0001f3ff",
        @"point_up" : @"\U0000261d",
        @"point_up_tone1" : @"\U0000261d\U0001f3fb",
        @"point_up_tone2" : @"\U0000261d\U0001f3fc",
        @"point_up_tone3" : @"\U0000261d\U0001f3fd",
        @"point_up_tone4" : @"\U0000261d\U0001f3fe",
        @"point_up_tone5" : @"\U0000261d\U0001f3ff",
        @"raised_hand" : @"\U0000270b",
        @"raised_hand_tone1" : @"\U0000270b\U0001f3fb",
        @"raised_hand_tone2" : @"\U0000270b\U0001f3fc",
        @"raised_hand_tone3" : @"\U0000270b\U0001f3fd",
        @"raised_hand_tone4" : @"\U0000270b\U0001f3fe",
        @"raised_hand_tone5" : @"\U0000270b\U0001f3ff",
        @"raised_back_of_hand" : @"\U0001f91a",
        @"raised_back_of_hand_tone1" : @"\U0001f91a\U0001f3fb",
        @"raised_back_of_hand_tone2" : @"\U0001f91a\U0001f3fc",
        @"raised_back_of_hand_tone3" : @"\U0001f91a\U0001f3fd",
        @"raised_back_of_hand_tone4" : @"\U0001f91a\U0001f3fe",
        @"raised_back_of_hand_tone5" : @"\U0001f91a\U0001f3ff",
        @"hand_splayed" : @"\U0001f590",
        @"hand_splayed_tone1" : @"\U0001f590\U0001f3fb",
        @"hand_splayed_tone2" : @"\U0001f590\U0001f3fc",
        @"hand_splayed_tone3" : @"\U0001f590\U0001f3fd",
        @"hand_splayed_tone4" : @"\U0001f590\U0001f3fe",
        @"hand_splayed_tone5" : @"\U0001f590\U0001f3ff",
        @"vulcan" : @"\U0001f596",
        @"vulcan_tone1" : @"\U0001f596\U0001f3fb",
        @"vulcan_tone2" : @"\U0001f596\U0001f3fc",
        @"vulcan_tone3" : @"\U0001f596\U0001f3fd",
        @"vulcan_tone4" : @"\U0001f596\U0001f3fe",
        @"vulcan_tone5" : @"\U0001f596\U0001f3ff",
        @"wave" : @"\U0001f44b",
        @"wave_tone1" : @"\U0001f44b\U0001f3fb",
        @"wave_tone2" : @"\U0001f44b\U0001f3fc",
        @"wave_tone3" : @"\U0001f44b\U0001f3fd",
        @"wave_tone4" : @"\U0001f44b\U0001f3fe",
        @"wave_tone5" : @"\U0001f44b\U0001f3ff",
        @"call_me" : @"\U0001f919",
        @"call_me_tone1" : @"\U0001f919\U0001f3fb",
        @"call_me_tone2" : @"\U0001f919\U0001f3fc",
        @"call_me_tone3" : @"\U0001f919\U0001f3fd",
        @"call_me_tone4" : @"\U0001f919\U0001f3fe",
        @"call_me_tone5" : @"\U0001f919\U0001f3ff",
        @"muscle" : @"\U0001f4aa",
        @"muscle_tone1" : @"\U0001f4aa\U0001f3fb",
        @"muscle_tone2" : @"\U0001f4aa\U0001f3fc",
        @"muscle_tone3" : @"\U0001f4aa\U0001f3fd",
        @"muscle_tone4" : @"\U0001f4aa\U0001f3fe",
        @"muscle_tone5" : @"\U0001f4aa\U0001f3ff",
        @"middle_finger" : @"\U0001f595",
        @"middle_finger_tone1" : @"\U0001f595\U0001f3fb",
        @"middle_finger_tone2" : @"\U0001f595\U0001f3fc",
        @"middle_finger_tone3" : @"\U0001f595\U0001f3fd",
        @"middle_finger_tone4" : @"\U0001f595\U0001f3fe",
        @"middle_finger_tone5" : @"\U0001f595\U0001f3ff",
        @"writing_hand" : @"\U0000270d",
        @"writing_hand_tone1" : @"\U0000270d\U0001f3fb",
        @"writing_hand_tone2" : @"\U0000270d\U0001f3fc",
        @"writing_hand_tone3" : @"\U0000270d\U0001f3fd",
        @"writing_hand_tone4" : @"\U0000270d\U0001f3fe",
        @"writing_hand_tone5" : @"\U0000270d\U0001f3ff",
        @"selfie" : @"\U0001f933",
        @"selfie_tone1" : @"\U0001f933\U0001f3fb",
        @"selfie_tone2" : @"\U0001f933\U0001f3fc",
        @"selfie_tone3" : @"\U0001f933\U0001f3fd",
        @"selfie_tone4" : @"\U0001f933\U0001f3fe",
        @"selfie_tone5" : @"\U0001f933\U0001f3ff",
        @"nail_care" : @"\U0001f485",
        @"nail_care_tone1" : @"\U0001f485\U0001f3fb",
        @"nail_care_tone2" : @"\U0001f485\U0001f3fc",
        @"nail_care_tone3" : @"\U0001f485\U0001f3fd",
        @"nail_care_tone4" : @"\U0001f485\U0001f3fe",
        @"nail_care_tone5" : @"\U0001f485\U0001f3ff",
        @"ring" : @"\U0001f48d",
        @"lipstick" : @"\U0001f484",
        @"kiss" : @"\U0001f48b",
        @"lips" : @"\U0001f444",
        @"tongue" : @"\U0001f445",
        @"ear" : @"\U0001f442",
        @"ear_tone1" : @"\U0001f442\U0001f3fb",
        @"ear_tone2" : @"\U0001f442\U0001f3fc",
        @"ear_tone3" : @"\U0001f442\U0001f3fd",
        @"ear_tone4" : @"\U0001f442\U0001f3fe",
        @"ear_tone5" : @"\U0001f442\U0001f3ff",
        @"nose" : @"\U0001f443",
        @"nose_tone1" : @"\U0001f443\U0001f3fb",
        @"nose_tone2" : @"\U0001f443\U0001f3fc",
        @"nose_tone3" : @"\U0001f443\U0001f3fd",
        @"nose_tone4" : @"\U0001f443\U0001f3fe",
        @"nose_tone5" : @"\U0001f443\U0001f3ff",
        @"footprints" : @"\U0001f463",
        @"eye" : @"\U0001f441",
        @"eyes" : @"\U0001f440",
        @"speaking_head" : @"\U0001f5e3",
        @"bust_in_silhouette" : @"\U0001f464",
        @"busts_in_silhouette" : @"\U0001f465",
        @"baby" : @"\U0001f476",
        @"baby_tone1" : @"\U0001f476\U0001f3fb",
        @"baby_tone2" : @"\U0001f476\U0001f3fc",
        @"baby_tone3" : @"\U0001f476\U0001f3fd",
        @"baby_tone4" : @"\U0001f476\U0001f3fe",
        @"baby_tone5" : @"\U0001f476\U0001f3ff",
        @"boy" : @"\U0001f466",
        @"boy_tone1" : @"\U0001f466\U0001f3fb",
        @"boy_tone2" : @"\U0001f466\U0001f3fc",
        @"boy_tone3" : @"\U0001f466\U0001f3fd",
        @"boy_tone4" : @"\U0001f466\U0001f3fe",
        @"boy_tone5" : @"\U0001f466\U0001f3ff",
        @"girl" : @"\U0001f467",
        @"girl_tone1" : @"\U0001f467\U0001f3fb",
        @"girl_tone2" : @"\U0001f467\U0001f3fc",
        @"girl_tone3" : @"\U0001f467\U0001f3fd",
        @"girl_tone4" : @"\U0001f467\U0001f3fe",
        @"girl_tone5" : @"\U0001f467\U0001f3ff",
        @"man" : @"\U0001f468",
        @"man_tone1" : @"\U0001f468\U0001f3fb",
        @"man_tone2" : @"\U0001f468\U0001f3fc",
        @"man_tone3" : @"\U0001f468\U0001f3fd",
        @"man_tone4" : @"\U0001f468\U0001f3fe",
        @"man_tone5" : @"\U0001f468\U0001f3ff",
        @"woman" : @"\U0001f469",
        @"woman_tone1" : @"\U0001f469\U0001f3fb",
        @"woman_tone2" : @"\U0001f469\U0001f3fc",
        @"woman_tone3" : @"\U0001f469\U0001f3fd",
        @"woman_tone4" : @"\U0001f469\U0001f3fe",
        @"woman_tone5" : @"\U0001f469\U0001f3ff",
        @"blond-haired_woman" : @"\U0001f471\U00002640",
        @"blond-haired_woman_tone1" : @"\U0001f471\U0001f3fb\U00002640",
        @"blond-haired_woman_tone2" : @"\U0001f471\U0001f3fc\U00002640",
        @"blond-haired_woman_tone3" : @"\U0001f471\U0001f3fd\U00002640",
        @"blond-haired_woman_tone4" : @"\U0001f471\U0001f3fe\U00002640",
        @"blond-haired_woman_tone5" : @"\U0001f471\U0001f3ff\U00002640",
        @"blond_haired_person" : @"\U0001f471",
        @"blond_haired_person_tone1" : @"\U0001f471\U0001f3fb",
        @"blond_haired_person_tone2" : @"\U0001f471\U0001f3fc",
        @"blond_haired_person_tone3" : @"\U0001f471\U0001f3fd",
        @"blond_haired_person_tone4" : @"\U0001f471\U0001f3fe",
        @"blond_haired_person_tone5" : @"\U0001f471\U0001f3ff",
        @"blond-haired_man" : @"\U0001f471\U00002642",
        @"blond-haired_man_tone5" : @"\U0001f471\U0001f3ff\U00002642",
        @"blond-haired_man_tone4" : @"\U0001f471\U0001f3fe\U00002642",
        @"blond-haired_man_tone3" : @"\U0001f471\U0001f3fd\U00002642",
        @"blond-haired_man_tone2" : @"\U0001f471\U0001f3fc\U00002642",
        @"blond-haired_man_tone1" : @"\U0001f471\U0001f3fb\U00002642",
        @"older_man" : @"\U0001f474",
        @"older_man_tone1" : @"\U0001f474\U0001f3fb",
        @"older_man_tone2" : @"\U0001f474\U0001f3fc",
        @"older_man_tone3" : @"\U0001f474\U0001f3fd",
        @"older_man_tone4" : @"\U0001f474\U0001f3fe",
        @"older_man_tone5" : @"\U0001f474\U0001f3ff",
        @"older_woman" : @"\U0001f475",
        @"older_woman_tone1" : @"\U0001f475\U0001f3fb",
        @"older_woman_tone2" : @"\U0001f475\U0001f3fc",
        @"older_woman_tone3" : @"\U0001f475\U0001f3fd",
        @"older_woman_tone4" : @"\U0001f475\U0001f3fe",
        @"older_woman_tone5" : @"\U0001f475\U0001f3ff",
        @"man_with_chinese_cap" : @"\U0001f472",
        @"man_with_chinese_cap_tone1" : @"\U0001f472\U0001f3fb",
        @"man_with_chinese_cap_tone2" : @"\U0001f472\U0001f3fc",
        @"man_with_chinese_cap_tone3" : @"\U0001f472\U0001f3fd",
        @"man_with_chinese_cap_tone4" : @"\U0001f472\U0001f3fe",
        @"man_with_chinese_cap_tone5" : @"\U0001f472\U0001f3ff",
        @"woman_wearing_turban" : @"\U0001f473\U00002640",
        @"woman_wearing_turban_tone1" : @"\U0001f473\U0001f3fb\U00002640",
        @"woman_wearing_turban_tone2" : @"\U0001f473\U0001f3fc\U00002640",
        @"woman_wearing_turban_tone3" : @"\U0001f473\U0001f3fd\U00002640",
        @"woman_wearing_turban_tone4" : @"\U0001f473\U0001f3fe\U00002640",
        @"woman_wearing_turban_tone5" : @"\U0001f473\U0001f3ff\U00002640",
        @"person_wearing_turban" : @"\U0001f473",
        @"person_wearing_turban_tone1" : @"\U0001f473\U0001f3fb",
        @"person_wearing_turban_tone2" : @"\U0001f473\U0001f3fc",
        @"person_wearing_turban_tone3" : @"\U0001f473\U0001f3fd",
        @"person_wearing_turban_tone4" : @"\U0001f473\U0001f3fe",
        @"person_wearing_turban_tone5" : @"\U0001f473\U0001f3ff",
        @"man_wearing_turban" : @"\U0001f473\U00002642",
        @"man_wearing_turban_tone5" : @"\U0001f473\U0001f3ff\U00002642",
        @"man_wearing_turban_tone4" : @"\U0001f473\U0001f3fe\U00002642",
        @"man_wearing_turban_tone3" : @"\U0001f473\U0001f3fd\U00002642",
        @"man_wearing_turban_tone2" : @"\U0001f473\U0001f3fc\U00002642",
        @"man_wearing_turban_tone1" : @"\U0001f473\U0001f3fb\U00002642",
        @"woman_police_officer" : @"\U0001f46e\U00002640",
        @"woman_police_officer_tone1" : @"\U0001f46e\U0001f3fb\U00002640",
        @"woman_police_officer_tone2" : @"\U0001f46e\U0001f3fc\U00002640",
        @"woman_police_officer_tone3" : @"\U0001f46e\U0001f3fd\U00002640",
        @"woman_police_officer_tone4" : @"\U0001f46e\U0001f3fe\U00002640",
        @"woman_police_officer_tone5" : @"\U0001f46e\U0001f3ff\U00002640",
        @"police_officer" : @"\U0001f46e",
        @"police_officer_tone1" : @"\U0001f46e\U0001f3fb",
        @"police_officer_tone2" : @"\U0001f46e\U0001f3fc",
        @"police_officer_tone3" : @"\U0001f46e\U0001f3fd",
        @"police_officer_tone4" : @"\U0001f46e\U0001f3fe",
        @"police_officer_tone5" : @"\U0001f46e\U0001f3ff",
        @"man_police_officer" : @"\U0001f46e\U00002642",
        @"man_police_officer_tone5" : @"\U0001f46e\U0001f3ff\U00002642",
        @"man_police_officer_tone4" : @"\U0001f46e\U0001f3fe\U00002642",
        @"man_police_officer_tone3" : @"\U0001f46e\U0001f3fd\U00002642",
        @"man_police_officer_tone2" : @"\U0001f46e\U0001f3fc\U00002642",
        @"man_police_officer_tone1" : @"\U0001f46e\U0001f3fb\U00002642",
        @"woman_construction_worker" : @"\U0001f477\U00002640",
        @"woman_construction_worker_tone1" : @"\U0001f477\U0001f3fb\U00002640",
        @"woman_construction_worker_tone2" : @"\U0001f477\U0001f3fc\U00002640",
        @"woman_construction_worker_tone3" : @"\U0001f477\U0001f3fd\U00002640",
        @"woman_construction_worker_tone4" : @"\U0001f477\U0001f3fe\U00002640",
        @"woman_construction_worker_tone5" : @"\U0001f477\U0001f3ff\U00002640",
        @"construction_worker" : @"\U0001f477",
        @"construction_worker_tone1" : @"\U0001f477\U0001f3fb",
        @"construction_worker_tone2" : @"\U0001f477\U0001f3fc",
        @"construction_worker_tone3" : @"\U0001f477\U0001f3fd",
        @"construction_worker_tone4" : @"\U0001f477\U0001f3fe",
        @"construction_worker_tone5" : @"\U0001f477\U0001f3ff",
        @"man_construction_worker" : @"\U0001f477\U00002642",
        @"man_construction_worker_tone5" : @"\U0001f477\U0001f3ff\U00002642",
        @"man_construction_worker_tone4" : @"\U0001f477\U0001f3fe\U00002642",
        @"man_construction_worker_tone3" : @"\U0001f477\U0001f3fd\U00002642",
        @"man_construction_worker_tone2" : @"\U0001f477\U0001f3fc\U00002642",
        @"man_construction_worker_tone1" : @"\U0001f477\U0001f3fb\U00002642",
        @"woman_guard" : @"\U0001f482\U00002640",
        @"woman_guard_tone1" : @"\U0001f482\U0001f3fb\U00002640",
        @"woman_guard_tone2" : @"\U0001f482\U0001f3fc\U00002640",
        @"woman_guard_tone3" : @"\U0001f482\U0001f3fd\U00002640",
        @"woman_guard_tone4" : @"\U0001f482\U0001f3fe\U00002640",
        @"woman_guard_tone5" : @"\U0001f482\U0001f3ff\U00002640",
        @"guard" : @"\U0001f482",
        @"guard_tone1" : @"\U0001f482\U0001f3fb",
        @"guard_tone2" : @"\U0001f482\U0001f3fc",
        @"guard_tone3" : @"\U0001f482\U0001f3fd",
        @"guard_tone4" : @"\U0001f482\U0001f3fe",
        @"guard_tone5" : @"\U0001f482\U0001f3ff",
        @"man_guard" : @"\U0001f482\U00002642",
        @"man_guard_tone5" : @"\U0001f482\U0001f3ff\U00002642",
        @"man_guard_tone4" : @"\U0001f482\U0001f3fe\U00002642",
        @"man_guard_tone3" : @"\U0001f482\U0001f3fd\U00002642",
        @"man_guard_tone2" : @"\U0001f482\U0001f3fc\U00002642",
        @"man_guard_tone1" : @"\U0001f482\U0001f3fb\U00002642",
        @"woman_detective" : @"\U0001f575\U00002640",
        @"woman_detective_tone1" : @"\U0001f575\U0001f3fb\U00002640",
        @"woman_detective_tone2" : @"\U0001f575\U0001f3fc\U00002640",
        @"woman_detective_tone3" : @"\U0001f575\U0001f3fd\U00002640",
        @"woman_detective_tone4" : @"\U0001f575\U0001f3fe\U00002640",
        @"woman_detective_tone5" : @"\U0001f575\U0001f3ff\U00002640",
        @"detective" : @"\U0001f575",
        @"detective_tone1" : @"\U0001f575\U0001f3fb",
        @"detective_tone2" : @"\U0001f575\U0001f3fc",
        @"detective_tone3" : @"\U0001f575\U0001f3fd",
        @"detective_tone4" : @"\U0001f575\U0001f3fe",
        @"detective_tone5" : @"\U0001f575\U0001f3ff",
        @"man_detective" : @"\U0001f575\U00002642",
        @"man_detective_tone5" : @"\U0001f575\U0001f3ff\U00002642",
        @"man_detective_tone4" : @"\U0001f575\U0001f3fe\U00002642",
        @"man_detective_tone3" : @"\U0001f575\U0001f3fd\U00002642",
        @"man_detective_tone2" : @"\U0001f575\U0001f3fc\U00002642",
        @"man_detective_tone1" : @"\U0001f575\U0001f3fb\U00002642",
        @"woman_health_worker" : @"\U0001f469\U00002695",
        @"woman_health_worker_tone1" : @"\U0001f469\U0001f3fb\U00002695",
        @"woman_health_worker_tone2" : @"\U0001f469\U0001f3fc\U00002695",
        @"woman_health_worker_tone3" : @"\U0001f469\U0001f3fd\U00002695",
        @"woman_health_worker_tone4" : @"\U0001f469\U0001f3fe\U00002695",
        @"woman_health_worker_tone5" : @"\U0001f469\U0001f3ff\U00002695",
        @"man_health_worker" : @"\U0001f468\U00002695",
        @"man_health_worker_tone1" : @"\U0001f468\U0001f3fb\U00002695",
        @"man_health_worker_tone2" : @"\U0001f468\U0001f3fc\U00002695",
        @"man_health_worker_tone3" : @"\U0001f468\U0001f3fd\U00002695",
        @"man_health_worker_tone4" : @"\U0001f468\U0001f3fe\U00002695",
        @"man_health_worker_tone5" : @"\U0001f468\U0001f3ff\U00002695",
        @"woman_farmer" : @"\U0001f469\U0001f33e",
        @"woman_farmer_tone1" : @"\U0001f469\U0001f3fb\U0001f33e",
        @"woman_farmer_tone2" : @"\U0001f469\U0001f3fc\U0001f33e",
        @"woman_farmer_tone3" : @"\U0001f469\U0001f3fd\U0001f33e",
        @"woman_farmer_tone4" : @"\U0001f469\U0001f3fe\U0001f33e",
        @"woman_farmer_tone5" : @"\U0001f469\U0001f3ff\U0001f33e",
        @"man_farmer" : @"\U0001f468\U0001f33e",
        @"man_farmer_tone1" : @"\U0001f468\U0001f3fb\U0001f33e",
        @"man_farmer_tone2" : @"\U0001f468\U0001f3fc\U0001f33e",
        @"man_farmer_tone3" : @"\U0001f468\U0001f3fd\U0001f33e",
        @"man_farmer_tone4" : @"\U0001f468\U0001f3fe\U0001f33e",
        @"man_farmer_tone5" : @"\U0001f468\U0001f3ff\U0001f33e",
        @"woman_cook" : @"\U0001f469\U0001f373",
        @"woman_cook_tone1" : @"\U0001f469\U0001f3fb\U0001f373",
        @"woman_cook_tone2" : @"\U0001f469\U0001f3fc\U0001f373",
        @"woman_cook_tone3" : @"\U0001f469\U0001f3fd\U0001f373",
        @"woman_cook_tone4" : @"\U0001f469\U0001f3fe\U0001f373",
        @"woman_cook_tone5" : @"\U0001f469\U0001f3ff\U0001f373",
        @"man_cook" : @"\U0001f468\U0001f373",
        @"man_cook_tone1" : @"\U0001f468\U0001f3fb\U0001f373",
        @"man_cook_tone2" : @"\U0001f468\U0001f3fc\U0001f373",
        @"man_cook_tone3" : @"\U0001f468\U0001f3fd\U0001f373",
        @"man_cook_tone4" : @"\U0001f468\U0001f3fe\U0001f373",
        @"man_cook_tone5" : @"\U0001f468\U0001f3ff\U0001f373",
        @"woman_student" : @"\U0001f469\U0001f393",
        @"woman_student_tone1" : @"\U0001f469\U0001f3fb\U0001f393",
        @"woman_student_tone2" : @"\U0001f469\U0001f3fc\U0001f393",
        @"woman_student_tone3" : @"\U0001f469\U0001f3fd\U0001f393",
        @"woman_student_tone4" : @"\U0001f469\U0001f3fe\U0001f393",
        @"woman_student_tone5" : @"\U0001f469\U0001f3ff\U0001f393",
        @"man_student" : @"\U0001f468\U0001f393",
        @"man_student_tone1" : @"\U0001f468\U0001f3fb\U0001f393",
        @"man_student_tone2" : @"\U0001f468\U0001f3fc\U0001f393",
        @"man_student_tone3" : @"\U0001f468\U0001f3fd\U0001f393",
        @"man_student_tone4" : @"\U0001f468\U0001f3fe\U0001f393",
        @"man_student_tone5" : @"\U0001f468\U0001f3ff\U0001f393",
        @"woman_singer" : @"\U0001f469\U0001f3a4",
        @"woman_singer_tone1" : @"\U0001f469\U0001f3fb\U0001f3a4",
        @"woman_singer_tone2" : @"\U0001f469\U0001f3fc\U0001f3a4",
        @"woman_singer_tone3" : @"\U0001f469\U0001f3fd\U0001f3a4",
        @"woman_singer_tone4" : @"\U0001f469\U0001f3fe\U0001f3a4",
        @"woman_singer_tone5" : @"\U0001f469\U0001f3ff\U0001f3a4",
        @"man_singer" : @"\U0001f468\U0001f3a4",
        @"man_singer_tone1" : @"\U0001f468\U0001f3fb\U0001f3a4",
        @"man_singer_tone2" : @"\U0001f468\U0001f3fc\U0001f3a4",
        @"man_singer_tone3" : @"\U0001f468\U0001f3fd\U0001f3a4",
        @"man_singer_tone4" : @"\U0001f468\U0001f3fe\U0001f3a4",
        @"man_singer_tone5" : @"\U0001f468\U0001f3ff\U0001f3a4",
        @"woman_teacher" : @"\U0001f469\U0001f3eb",
        @"woman_teacher_tone1" : @"\U0001f469\U0001f3fb\U0001f3eb",
        @"woman_teacher_tone2" : @"\U0001f469\U0001f3fc\U0001f3eb",
        @"woman_teacher_tone3" : @"\U0001f469\U0001f3fd\U0001f3eb",
        @"woman_teacher_tone4" : @"\U0001f469\U0001f3fe\U0001f3eb",
        @"woman_teacher_tone5" : @"\U0001f469\U0001f3ff\U0001f3eb",
        @"man_teacher" : @"\U0001f468\U0001f3eb",
        @"man_teacher_tone1" : @"\U0001f468\U0001f3fb\U0001f3eb",
        @"man_teacher_tone2" : @"\U0001f468\U0001f3fc\U0001f3eb",
        @"man_teacher_tone3" : @"\U0001f468\U0001f3fd\U0001f3eb",
        @"man_teacher_tone4" : @"\U0001f468\U0001f3fe\U0001f3eb",
        @"man_teacher_tone5" : @"\U0001f468\U0001f3ff\U0001f3eb",
        @"woman_factory_worker" : @"\U0001f469\U0001f3ed",
        @"woman_factory_worker_tone1" : @"\U0001f469\U0001f3fb\U0001f3ed",
        @"woman_factory_worker_tone2" : @"\U0001f469\U0001f3fc\U0001f3ed",
        @"woman_factory_worker_tone3" : @"\U0001f469\U0001f3fd\U0001f3ed",
        @"woman_factory_worker_tone4" : @"\U0001f469\U0001f3fe\U0001f3ed",
        @"woman_factory_worker_tone5" : @"\U0001f469\U0001f3ff\U0001f3ed",
        @"man_factory_worker" : @"\U0001f468\U0001f3ed",
        @"man_factory_worker_tone1" : @"\U0001f468\U0001f3fb\U0001f3ed",
        @"man_factory_worker_tone2" : @"\U0001f468\U0001f3fc\U0001f3ed",
        @"man_factory_worker_tone3" : @"\U0001f468\U0001f3fd\U0001f3ed",
        @"man_factory_worker_tone4" : @"\U0001f468\U0001f3fe\U0001f3ed",
        @"man_factory_worker_tone5" : @"\U0001f468\U0001f3ff\U0001f3ed",
        @"woman_technologist" : @"\U0001f469\U0001f4bb",
        @"woman_technologist_tone1" : @"\U0001f469\U0001f3fb\U0001f4bb",
        @"woman_technologist_tone2" : @"\U0001f469\U0001f3fc\U0001f4bb",
        @"woman_technologist_tone3" : @"\U0001f469\U0001f3fd\U0001f4bb",
        @"woman_technologist_tone4" : @"\U0001f469\U0001f3fe\U0001f4bb",
        @"woman_technologist_tone5" : @"\U0001f469\U0001f3ff\U0001f4bb",
        @"man_technologist" : @"\U0001f468\U0001f4bb",
        @"man_technologist_tone1" : @"\U0001f468\U0001f3fb\U0001f4bb",
        @"man_technologist_tone2" : @"\U0001f468\U0001f3fc\U0001f4bb",
        @"man_technologist_tone3" : @"\U0001f468\U0001f3fd\U0001f4bb",
        @"man_technologist_tone4" : @"\U0001f468\U0001f3fe\U0001f4bb",
        @"man_technologist_tone5" : @"\U0001f468\U0001f3ff\U0001f4bb",
        @"woman_office_worker" : @"\U0001f469\U0001f4bc",
        @"woman_office_worker_tone1" : @"\U0001f469\U0001f3fb\U0001f4bc",
        @"woman_office_worker_tone2" : @"\U0001f469\U0001f3fc\U0001f4bc",
        @"woman_office_worker_tone3" : @"\U0001f469\U0001f3fd\U0001f4bc",
        @"woman_office_worker_tone4" : @"\U0001f469\U0001f3fe\U0001f4bc",
        @"woman_office_worker_tone5" : @"\U0001f469\U0001f3ff\U0001f4bc",
        @"man_office_worker" : @"\U0001f468\U0001f4bc",
        @"man_office_worker_tone1" : @"\U0001f468\U0001f3fb\U0001f4bc",
        @"man_office_worker_tone2" : @"\U0001f468\U0001f3fc\U0001f4bc",
        @"man_office_worker_tone3" : @"\U0001f468\U0001f3fd\U0001f4bc",
        @"man_office_worker_tone4" : @"\U0001f468\U0001f3fe\U0001f4bc",
        @"man_office_worker_tone5" : @"\U0001f468\U0001f3ff\U0001f4bc",
        @"woman_mechanic" : @"\U0001f469\U0001f527",
        @"woman_mechanic_tone1" : @"\U0001f469\U0001f3fb\U0001f527",
        @"woman_mechanic_tone2" : @"\U0001f469\U0001f3fc\U0001f527",
        @"woman_mechanic_tone3" : @"\U0001f469\U0001f3fd\U0001f527",
        @"woman_mechanic_tone4" : @"\U0001f469\U0001f3fe\U0001f527",
        @"woman_mechanic_tone5" : @"\U0001f469\U0001f3ff\U0001f527",
        @"man_mechanic" : @"\U0001f468\U0001f527",
        @"man_mechanic_tone1" : @"\U0001f468\U0001f3fb\U0001f527",
        @"man_mechanic_tone2" : @"\U0001f468\U0001f3fc\U0001f527",
        @"man_mechanic_tone3" : @"\U0001f468\U0001f3fd\U0001f527",
        @"man_mechanic_tone4" : @"\U0001f468\U0001f3fe\U0001f527",
        @"man_mechanic_tone5" : @"\U0001f468\U0001f3ff\U0001f527",
        @"woman_scientist" : @"\U0001f469\U0001f52c",
        @"woman_scientist_tone1" : @"\U0001f469\U0001f3fb\U0001f52c",
        @"woman_scientist_tone2" : @"\U0001f469\U0001f3fc\U0001f52c",
        @"woman_scientist_tone3" : @"\U0001f469\U0001f3fd\U0001f52c",
        @"woman_scientist_tone4" : @"\U0001f469\U0001f3fe\U0001f52c",
        @"woman_scientist_tone5" : @"\U0001f469\U0001f3ff\U0001f52c",
        @"man_scientist" : @"\U0001f468\U0001f52c",
        @"man_scientist_tone1" : @"\U0001f468\U0001f3fb\U0001f52c",
        @"man_scientist_tone2" : @"\U0001f468\U0001f3fc\U0001f52c",
        @"man_scientist_tone3" : @"\U0001f468\U0001f3fd\U0001f52c",
        @"man_scientist_tone4" : @"\U0001f468\U0001f3fe\U0001f52c",
        @"man_scientist_tone5" : @"\U0001f468\U0001f3ff\U0001f52c",
        @"woman_artist" : @"\U0001f469\U0001f3a8",
        @"woman_artist_tone1" : @"\U0001f469\U0001f3fb\U0001f3a8",
        @"woman_artist_tone2" : @"\U0001f469\U0001f3fc\U0001f3a8",
        @"woman_artist_tone3" : @"\U0001f469\U0001f3fd\U0001f3a8",
        @"woman_artist_tone4" : @"\U0001f469\U0001f3fe\U0001f3a8",
        @"woman_artist_tone5" : @"\U0001f469\U0001f3ff\U0001f3a8",
        @"man_artist" : @"\U0001f468\U0001f3a8",
        @"man_artist_tone1" : @"\U0001f468\U0001f3fb\U0001f3a8",
        @"man_artist_tone2" : @"\U0001f468\U0001f3fc\U0001f3a8",
        @"man_artist_tone3" : @"\U0001f468\U0001f3fd\U0001f3a8",
        @"man_artist_tone4" : @"\U0001f468\U0001f3fe\U0001f3a8",
        @"man_artist_tone5" : @"\U0001f468\U0001f3ff\U0001f3a8",
        @"woman_firefighter" : @"\U0001f469\U0001f692",
        @"woman_firefighter_tone1" : @"\U0001f469\U0001f3fb\U0001f692",
        @"woman_firefighter_tone2" : @"\U0001f469\U0001f3fc\U0001f692",
        @"woman_firefighter_tone3" : @"\U0001f469\U0001f3fd\U0001f692",
        @"woman_firefighter_tone4" : @"\U0001f469\U0001f3fe\U0001f692",
        @"woman_firefighter_tone5" : @"\U0001f469\U0001f3ff\U0001f692",
        @"man_firefighter" : @"\U0001f468\U0001f692",
        @"man_firefighter_tone1" : @"\U0001f468\U0001f3fb\U0001f692",
        @"man_firefighter_tone2" : @"\U0001f468\U0001f3fc\U0001f692",
        @"man_firefighter_tone3" : @"\U0001f468\U0001f3fd\U0001f692",
        @"man_firefighter_tone4" : @"\U0001f468\U0001f3fe\U0001f692",
        @"man_firefighter_tone5" : @"\U0001f468\U0001f3ff\U0001f692",
        @"woman_pilot" : @"\U0001f469\U00002708",
        @"woman_pilot_tone1" : @"\U0001f469\U0001f3fb\U00002708",
        @"woman_pilot_tone2" : @"\U0001f469\U0001f3fc\U00002708",
        @"woman_pilot_tone3" : @"\U0001f469\U0001f3fd\U00002708",
        @"woman_pilot_tone4" : @"\U0001f469\U0001f3fe\U00002708",
        @"woman_pilot_tone5" : @"\U0001f469\U0001f3ff\U00002708",
        @"man_pilot" : @"\U0001f468\U00002708",
        @"man_pilot_tone1" : @"\U0001f468\U0001f3fb\U00002708",
        @"man_pilot_tone2" : @"\U0001f468\U0001f3fc\U00002708",
        @"man_pilot_tone3" : @"\U0001f468\U0001f3fd\U00002708",
        @"man_pilot_tone4" : @"\U0001f468\U0001f3fe\U00002708",
        @"man_pilot_tone5" : @"\U0001f468\U0001f3ff\U00002708",
        @"woman_astronaut" : @"\U0001f469\U0001f680",
        @"woman_astronaut_tone1" : @"\U0001f469\U0001f3fb\U0001f680",
        @"woman_astronaut_tone2" : @"\U0001f469\U0001f3fc\U0001f680",
        @"woman_astronaut_tone3" : @"\U0001f469\U0001f3fd\U0001f680",
        @"woman_astronaut_tone4" : @"\U0001f469\U0001f3fe\U0001f680",
        @"woman_astronaut_tone5" : @"\U0001f469\U0001f3ff\U0001f680",
        @"man_astronaut" : @"\U0001f468\U0001f680",
        @"man_astronaut_tone1" : @"\U0001f468\U0001f3fb\U0001f680",
        @"man_astronaut_tone2" : @"\U0001f468\U0001f3fc\U0001f680",
        @"man_astronaut_tone3" : @"\U0001f468\U0001f3fd\U0001f680",
        @"man_astronaut_tone4" : @"\U0001f468\U0001f3fe\U0001f680",
        @"man_astronaut_tone5" : @"\U0001f468\U0001f3ff\U0001f680",
        @"woman_judge" : @"\U0001f469\U00002696",
        @"woman_judge_tone1" : @"\U0001f469\U0001f3fb\U00002696",
        @"woman_judge_tone2" : @"\U0001f469\U0001f3fc\U00002696",
        @"woman_judge_tone3" : @"\U0001f469\U0001f3fd\U00002696",
        @"woman_judge_tone4" : @"\U0001f469\U0001f3fe\U00002696",
        @"woman_judge_tone5" : @"\U0001f469\U0001f3ff\U00002696",
        @"man_judge" : @"\U0001f468\U00002696",
        @"man_judge_tone1" : @"\U0001f468\U0001f3fb\U00002696",
        @"man_judge_tone2" : @"\U0001f468\U0001f3fc\U00002696",
        @"man_judge_tone3" : @"\U0001f468\U0001f3fd\U00002696",
        @"man_judge_tone4" : @"\U0001f468\U0001f3fe\U00002696",
        @"man_judge_tone5" : @"\U0001f468\U0001f3ff\U00002696",
        @"mrs_claus" : @"\U0001f936",
        @"mrs_claus_tone1" : @"\U0001f936\U0001f3fb",
        @"mrs_claus_tone2" : @"\U0001f936\U0001f3fc",
        @"mrs_claus_tone3" : @"\U0001f936\U0001f3fd",
        @"mrs_claus_tone4" : @"\U0001f936\U0001f3fe",
        @"mrs_claus_tone5" : @"\U0001f936\U0001f3ff",
        @"santa" : @"\U0001f385",
        @"santa_tone1" : @"\U0001f385\U0001f3fb",
        @"santa_tone2" : @"\U0001f385\U0001f3fc",
        @"santa_tone3" : @"\U0001f385\U0001f3fd",
        @"santa_tone4" : @"\U0001f385\U0001f3fe",
        @"santa_tone5" : @"\U0001f385\U0001f3ff",
        @"princess" : @"\U0001f478",
        @"princess_tone1" : @"\U0001f478\U0001f3fb",
        @"princess_tone2" : @"\U0001f478\U0001f3fc",
        @"princess_tone3" : @"\U0001f478\U0001f3fd",
        @"princess_tone4" : @"\U0001f478\U0001f3fe",
        @"princess_tone5" : @"\U0001f478\U0001f3ff",
        @"prince" : @"\U0001f934",
        @"prince_tone1" : @"\U0001f934\U0001f3fb",
        @"prince_tone2" : @"\U0001f934\U0001f3fc",
        @"prince_tone3" : @"\U0001f934\U0001f3fd",
        @"prince_tone4" : @"\U0001f934\U0001f3fe",
        @"prince_tone5" : @"\U0001f934\U0001f3ff",
        @"bride_with_veil" : @"\U0001f470",
        @"bride_with_veil_tone1" : @"\U0001f470\U0001f3fb",
        @"bride_with_veil_tone2" : @"\U0001f470\U0001f3fc",
        @"bride_with_veil_tone3" : @"\U0001f470\U0001f3fd",
        @"bride_with_veil_tone4" : @"\U0001f470\U0001f3fe",
        @"bride_with_veil_tone5" : @"\U0001f470\U0001f3ff",
        @"man_in_tuxedo" : @"\U0001f935",
        @"man_in_tuxedo_tone1" : @"\U0001f935\U0001f3fb",
        @"man_in_tuxedo_tone2" : @"\U0001f935\U0001f3fc",
        @"man_in_tuxedo_tone3" : @"\U0001f935\U0001f3fd",
        @"man_in_tuxedo_tone4" : @"\U0001f935\U0001f3fe",
        @"man_in_tuxedo_tone5" : @"\U0001f935\U0001f3ff",
        @"angel" : @"\U0001f47c",
        @"angel_tone1" : @"\U0001f47c\U0001f3fb",
        @"angel_tone2" : @"\U0001f47c\U0001f3fc",
        @"angel_tone3" : @"\U0001f47c\U0001f3fd",
        @"angel_tone4" : @"\U0001f47c\U0001f3fe",
        @"angel_tone5" : @"\U0001f47c\U0001f3ff",
        @"pregnant_woman" : @"\U0001f930",
        @"pregnant_woman_tone1" : @"\U0001f930\U0001f3fb",
        @"pregnant_woman_tone2" : @"\U0001f930\U0001f3fc",
        @"pregnant_woman_tone3" : @"\U0001f930\U0001f3fd",
        @"pregnant_woman_tone4" : @"\U0001f930\U0001f3fe",
        @"pregnant_woman_tone5" : @"\U0001f930\U0001f3ff",
        @"woman_bowing" : @"\U0001f647\U00002640",
        @"woman_bowing_tone1" : @"\U0001f647\U0001f3fb\U00002640",
        @"woman_bowing_tone2" : @"\U0001f647\U0001f3fc\U00002640",
        @"woman_bowing_tone3" : @"\U0001f647\U0001f3fd\U00002640",
        @"woman_bowing_tone4" : @"\U0001f647\U0001f3fe\U00002640",
        @"woman_bowing_tone5" : @"\U0001f647\U0001f3ff\U00002640",
        @"person_bowing" : @"\U0001f647",
        @"person_bowing_tone1" : @"\U0001f647\U0001f3fb",
        @"person_bowing_tone2" : @"\U0001f647\U0001f3fc",
        @"person_bowing_tone3" : @"\U0001f647\U0001f3fd",
        @"person_bowing_tone4" : @"\U0001f647\U0001f3fe",
        @"person_bowing_tone5" : @"\U0001f647\U0001f3ff",
        @"man_bowing" : @"\U0001f647\U00002642",
        @"man_bowing_tone5" : @"\U0001f647\U0001f3ff\U00002642",
        @"man_bowing_tone4" : @"\U0001f647\U0001f3fe\U00002642",
        @"man_bowing_tone3" : @"\U0001f647\U0001f3fd\U00002642",
        @"man_bowing_tone2" : @"\U0001f647\U0001f3fc\U00002642",
        @"man_bowing_tone1" : @"\U0001f647\U0001f3fb\U00002642",
        @"person_tipping_hand" : @"\U0001f481",
        @"person_tipping_hand_tone1" : @"\U0001f481\U0001f3fb",
        @"person_tipping_hand_tone2" : @"\U0001f481\U0001f3fc",
        @"person_tipping_hand_tone3" : @"\U0001f481\U0001f3fd",
        @"person_tipping_hand_tone4" : @"\U0001f481\U0001f3fe",
        @"person_tipping_hand_tone5" : @"\U0001f481\U0001f3ff",
        @"man_tipping_hand" : @"\U0001f481\U00002642",
        @"man_tipping_hand_tone1" : @"\U0001f481\U0001f3fb\U00002642",
        @"man_tipping_hand_tone2" : @"\U0001f481\U0001f3fc\U00002642",
        @"man_tipping_hand_tone3" : @"\U0001f481\U0001f3fd\U00002642",
        @"man_tipping_hand_tone4" : @"\U0001f481\U0001f3fe\U00002642",
        @"man_tipping_hand_tone5" : @"\U0001f481\U0001f3ff\U00002642",
        @"woman_tipping_hand" : @"\U0001f481\U00002640",
        @"woman_tipping_hand_tone5" : @"\U0001f481\U0001f3ff\U00002640",
        @"woman_tipping_hand_tone4" : @"\U0001f481\U0001f3fe\U00002640",
        @"woman_tipping_hand_tone3" : @"\U0001f481\U0001f3fd\U00002640",
        @"woman_tipping_hand_tone2" : @"\U0001f481\U0001f3fc\U00002640",
        @"woman_tipping_hand_tone1" : @"\U0001f481\U0001f3fb\U00002640",
        @"person_gesturing_no" : @"\U0001f645",
        @"person_gesturing_no_tone1" : @"\U0001f645\U0001f3fb",
        @"person_gesturing_no_tone2" : @"\U0001f645\U0001f3fc",
        @"person_gesturing_no_tone3" : @"\U0001f645\U0001f3fd",
        @"person_gesturing_no_tone4" : @"\U0001f645\U0001f3fe",
        @"person_gesturing_no_tone5" : @"\U0001f645\U0001f3ff",
        @"man_gesturing_no" : @"\U0001f645\U00002642",
        @"man_gesturing_no_tone1" : @"\U0001f645\U0001f3fb\U00002642",
        @"man_gesturing_no_tone2" : @"\U0001f645\U0001f3fc\U00002642",
        @"man_gesturing_no_tone3" : @"\U0001f645\U0001f3fd\U00002642",
        @"man_gesturing_no_tone4" : @"\U0001f645\U0001f3fe\U00002642",
        @"man_gesturing_no_tone5" : @"\U0001f645\U0001f3ff\U00002642",
        @"woman_gesturing_no" : @"\U0001f645\U00002640",
        @"woman_gesturing_no_tone5" : @"\U0001f645\U0001f3ff\U00002640",
        @"woman_gesturing_no_tone4" : @"\U0001f645\U0001f3fe\U00002640",
        @"woman_gesturing_no_tone3" : @"\U0001f645\U0001f3fd\U00002640",
        @"woman_gesturing_no_tone2" : @"\U0001f645\U0001f3fc\U00002640",
        @"woman_gesturing_no_tone1" : @"\U0001f645\U0001f3fb\U00002640",
        @"person_gesturing_ok" : @"\U0001f646",
        @"person_gesturing_ok_tone1" : @"\U0001f646\U0001f3fb",
        @"person_gesturing_ok_tone2" : @"\U0001f646\U0001f3fc",
        @"person_gesturing_ok_tone3" : @"\U0001f646\U0001f3fd",
        @"person_gesturing_ok_tone4" : @"\U0001f646\U0001f3fe",
        @"person_gesturing_ok_tone5" : @"\U0001f646\U0001f3ff",
        @"man_gesturing_ok" : @"\U0001f646\U00002642",
        @"man_gesturing_ok_tone1" : @"\U0001f646\U0001f3fb\U00002642",
        @"man_gesturing_ok_tone2" : @"\U0001f646\U0001f3fc\U00002642",
        @"man_gesturing_ok_tone3" : @"\U0001f646\U0001f3fd\U00002642",
        @"man_gesturing_ok_tone4" : @"\U0001f646\U0001f3fe\U00002642",
        @"man_gesturing_ok_tone5" : @"\U0001f646\U0001f3ff\U00002642",
        @"woman_gesturing_ok" : @"\U0001f646\U00002640",
        @"woman_gesturing_ok_tone5" : @"\U0001f646\U0001f3ff\U00002640",
        @"woman_gesturing_ok_tone4" : @"\U0001f646\U0001f3fe\U00002640",
        @"woman_gesturing_ok_tone3" : @"\U0001f646\U0001f3fd\U00002640",
        @"woman_gesturing_ok_tone2" : @"\U0001f646\U0001f3fc\U00002640",
        @"woman_gesturing_ok_tone1" : @"\U0001f646\U0001f3fb\U00002640",
        @"person_raising_hand" : @"\U0001f64b",
        @"person_raising_hand_tone1" : @"\U0001f64b\U0001f3fb",
        @"person_raising_hand_tone2" : @"\U0001f64b\U0001f3fc",
        @"person_raising_hand_tone3" : @"\U0001f64b\U0001f3fd",
        @"person_raising_hand_tone4" : @"\U0001f64b\U0001f3fe",
        @"person_raising_hand_tone5" : @"\U0001f64b\U0001f3ff",
        @"man_raising_hand" : @"\U0001f64b\U00002642",
        @"man_raising_hand_tone1" : @"\U0001f64b\U0001f3fb\U00002642",
        @"man_raising_hand_tone2" : @"\U0001f64b\U0001f3fc\U00002642",
        @"man_raising_hand_tone3" : @"\U0001f64b\U0001f3fd\U00002642",
        @"man_raising_hand_tone4" : @"\U0001f64b\U0001f3fe\U00002642",
        @"man_raising_hand_tone5" : @"\U0001f64b\U0001f3ff\U00002642",
        @"woman_raising_hand" : @"\U0001f64b\U00002640",
        @"woman_raising_hand_tone5" : @"\U0001f64b\U0001f3ff\U00002640",
        @"woman_raising_hand_tone4" : @"\U0001f64b\U0001f3fe\U00002640",
        @"woman_raising_hand_tone3" : @"\U0001f64b\U0001f3fd\U00002640",
        @"woman_raising_hand_tone2" : @"\U0001f64b\U0001f3fc\U00002640",
        @"woman_raising_hand_tone1" : @"\U0001f64b\U0001f3fb\U00002640",
        @"woman_facepalming" : @"\U0001f926\U00002640",
        @"woman_facepalming_tone1" : @"\U0001f926\U0001f3fb\U00002640",
        @"woman_facepalming_tone2" : @"\U0001f926\U0001f3fc\U00002640",
        @"woman_facepalming_tone3" : @"\U0001f926\U0001f3fd\U00002640",
        @"woman_facepalming_tone4" : @"\U0001f926\U0001f3fe\U00002640",
        @"woman_facepalming_tone5" : @"\U0001f926\U0001f3ff\U00002640",
        @"man_facepalming" : @"\U0001f926\U00002642",
        @"man_facepalming_tone1" : @"\U0001f926\U0001f3fb\U00002642",
        @"man_facepalming_tone2" : @"\U0001f926\U0001f3fc\U00002642",
        @"man_facepalming_tone3" : @"\U0001f926\U0001f3fd\U00002642",
        @"man_facepalming_tone4" : @"\U0001f926\U0001f3fe\U00002642",
        @"man_facepalming_tone5" : @"\U0001f926\U0001f3ff\U00002642",
        @"person_facepalming" : @"\U0001f926",
        @"person_facepalming_tone1" : @"\U0001f926\U0001f3fb",
        @"person_facepalming_tone2" : @"\U0001f926\U0001f3fc",
        @"person_facepalming_tone3" : @"\U0001f926\U0001f3fd",
        @"person_facepalming_tone4" : @"\U0001f926\U0001f3fe",
        @"person_facepalming_tone5" : @"\U0001f926\U0001f3ff",
        @"woman_shrugging" : @"\U0001f937\U00002640",
        @"woman_shrugging_tone1" : @"\U0001f937\U0001f3fb\U00002640",
        @"woman_shrugging_tone2" : @"\U0001f937\U0001f3fc\U00002640",
        @"woman_shrugging_tone3" : @"\U0001f937\U0001f3fd\U00002640",
        @"woman_shrugging_tone4" : @"\U0001f937\U0001f3fe\U00002640",
        @"woman_shrugging_tone5" : @"\U0001f937\U0001f3ff\U00002640",
        @"man_shrugging" : @"\U0001f937\U00002642",
        @"man_shrugging_tone1" : @"\U0001f937\U0001f3fb\U00002642",
        @"man_shrugging_tone2" : @"\U0001f937\U0001f3fc\U00002642",
        @"man_shrugging_tone3" : @"\U0001f937\U0001f3fd\U00002642",
        @"man_shrugging_tone4" : @"\U0001f937\U0001f3fe\U00002642",
        @"man_shrugging_tone5" : @"\U0001f937\U0001f3ff\U00002642",
        @"person_shrugging" : @"\U0001f937",
        @"person_shrugging_tone1" : @"\U0001f937\U0001f3fb",
        @"person_shrugging_tone2" : @"\U0001f937\U0001f3fc",
        @"person_shrugging_tone3" : @"\U0001f937\U0001f3fd",
        @"person_shrugging_tone4" : @"\U0001f937\U0001f3fe",
        @"person_shrugging_tone5" : @"\U0001f937\U0001f3ff",
        @"person_pouting" : @"\U0001f64e",
        @"person_pouting_tone1" : @"\U0001f64e\U0001f3fb",
        @"person_pouting_tone2" : @"\U0001f64e\U0001f3fc",
        @"person_pouting_tone3" : @"\U0001f64e\U0001f3fd",
        @"person_pouting_tone4" : @"\U0001f64e\U0001f3fe",
        @"person_pouting_tone5" : @"\U0001f64e\U0001f3ff",
        @"man_pouting" : @"\U0001f64e\U00002642",
        @"man_pouting_tone1" : @"\U0001f64e\U0001f3fb\U00002642",
        @"man_pouting_tone2" : @"\U0001f64e\U0001f3fc\U00002642",
        @"man_pouting_tone3" : @"\U0001f64e\U0001f3fd\U00002642",
        @"man_pouting_tone4" : @"\U0001f64e\U0001f3fe\U00002642",
        @"man_pouting_tone5" : @"\U0001f64e\U0001f3ff\U00002642",
        @"woman_pouting" : @"\U0001f64e\U00002640",
        @"woman_pouting_tone5" : @"\U0001f64e\U0001f3ff\U00002640",
        @"woman_pouting_tone4" : @"\U0001f64e\U0001f3fe\U00002640",
        @"woman_pouting_tone3" : @"\U0001f64e\U0001f3fd\U00002640",
        @"woman_pouting_tone2" : @"\U0001f64e\U0001f3fc\U00002640",
        @"woman_pouting_tone1" : @"\U0001f64e\U0001f3fb\U00002640",
        @"person_frowning" : @"\U0001f64d",
        @"person_frowning_tone1" : @"\U0001f64d\U0001f3fb",
        @"person_frowning_tone2" : @"\U0001f64d\U0001f3fc",
        @"person_frowning_tone3" : @"\U0001f64d\U0001f3fd",
        @"person_frowning_tone4" : @"\U0001f64d\U0001f3fe",
        @"person_frowning_tone5" : @"\U0001f64d\U0001f3ff",
        @"man_frowning" : @"\U0001f64d\U00002642",
        @"man_frowning_tone1" : @"\U0001f64d\U0001f3fb\U00002642",
        @"man_frowning_tone2" : @"\U0001f64d\U0001f3fc\U00002642",
        @"man_frowning_tone3" : @"\U0001f64d\U0001f3fd\U00002642",
        @"man_frowning_tone4" : @"\U0001f64d\U0001f3fe\U00002642",
        @"man_frowning_tone5" : @"\U0001f64d\U0001f3ff\U00002642",
        @"woman_frowning" : @"\U0001f64d\U00002640",
        @"woman_frowning_tone5" : @"\U0001f64d\U0001f3ff\U00002640",
        @"woman_frowning_tone4" : @"\U0001f64d\U0001f3fe\U00002640",
        @"woman_frowning_tone3" : @"\U0001f64d\U0001f3fd\U00002640",
        @"woman_frowning_tone2" : @"\U0001f64d\U0001f3fc\U00002640",
        @"woman_frowning_tone1" : @"\U0001f64d\U0001f3fb\U00002640",
        @"person_getting_haircut" : @"\U0001f487",
        @"person_getting_haircut_tone1" : @"\U0001f487\U0001f3fb",
        @"person_getting_haircut_tone2" : @"\U0001f487\U0001f3fc",
        @"person_getting_haircut_tone3" : @"\U0001f487\U0001f3fd",
        @"person_getting_haircut_tone4" : @"\U0001f487\U0001f3fe",
        @"person_getting_haircut_tone5" : @"\U0001f487\U0001f3ff",
        @"man_getting_haircut" : @"\U0001f487\U00002642",
        @"man_getting_haircut_tone1" : @"\U0001f487\U0001f3fb\U00002642",
        @"man_getting_haircut_tone2" : @"\U0001f487\U0001f3fc\U00002642",
        @"man_getting_haircut_tone3" : @"\U0001f487\U0001f3fd\U00002642",
        @"man_getting_haircut_tone4" : @"\U0001f487\U0001f3fe\U00002642",
        @"man_getting_haircut_tone5" : @"\U0001f487\U0001f3ff\U00002642",
        @"woman_getting_haircut" : @"\U0001f487\U00002640",
        @"woman_getting_haircut_tone5" : @"\U0001f487\U0001f3ff\U00002640",
        @"woman_getting_haircut_tone4" : @"\U0001f487\U0001f3fe\U00002640",
        @"woman_getting_haircut_tone3" : @"\U0001f487\U0001f3fd\U00002640",
        @"woman_getting_haircut_tone2" : @"\U0001f487\U0001f3fc\U00002640",
        @"woman_getting_haircut_tone1" : @"\U0001f487\U0001f3fb\U00002640",
        @"person_getting_massage" : @"\U0001f486",
        @"person_getting_massage_tone1" : @"\U0001f486\U0001f3fb",
        @"person_getting_massage_tone2" : @"\U0001f486\U0001f3fc",
        @"person_getting_massage_tone3" : @"\U0001f486\U0001f3fd",
        @"person_getting_massage_tone4" : @"\U0001f486\U0001f3fe",
        @"person_getting_massage_tone5" : @"\U0001f486\U0001f3ff",
        @"man_getting_face_massage" : @"\U0001f486\U00002642",
        @"man_getting_face_massage_tone1" : @"\U0001f486\U0001f3fb\U00002642",
        @"man_getting_face_massage_tone2" : @"\U0001f486\U0001f3fc\U00002642",
        @"man_getting_face_massage_tone3" : @"\U0001f486\U0001f3fd\U00002642",
        @"man_getting_face_massage_tone4" : @"\U0001f486\U0001f3fe\U00002642",
        @"man_getting_face_massage_tone5" : @"\U0001f486\U0001f3ff\U00002642",
        @"woman_getting_face_massage" : @"\U0001f486\U00002640",
        @"woman_getting_face_massage_tone5" : @"\U0001f486\U0001f3ff\U00002640",
        @"woman_getting_face_massage_tone4" : @"\U0001f486\U0001f3fe\U00002640",
        @"woman_getting_face_massage_tone3" : @"\U0001f486\U0001f3fd\U00002640",
        @"woman_getting_face_massage_tone2" : @"\U0001f486\U0001f3fc\U00002640",
        @"woman_getting_face_massage_tone1" : @"\U0001f486\U0001f3fb\U00002640",
        @"levitate" : @"\U0001f574",
        @"man_in_business_suit_levitating_tone1" : @"\U0001f574\U0001f3fb",
        @"man_in_business_suit_levitating_tone2" : @"\U0001f574\U0001f3fc",
        @"man_in_business_suit_levitating_tone3" : @"\U0001f574\U0001f3fd",
        @"man_in_business_suit_levitating_tone4" : @"\U0001f574\U0001f3fe",
        @"man_in_business_suit_levitating_tone5" : @"\U0001f574\U0001f3ff",
        @"dancer" : @"\U0001f483",
        @"dancer_tone1" : @"\U0001f483\U0001f3fb",
        @"dancer_tone2" : @"\U0001f483\U0001f3fc",
        @"dancer_tone3" : @"\U0001f483\U0001f3fd",
        @"dancer_tone4" : @"\U0001f483\U0001f3fe",
        @"dancer_tone5" : @"\U0001f483\U0001f3ff",
        @"man_dancing" : @"\U0001f57a",
        @"man_dancing_tone1" : @"\U0001f57a\U0001f3fb",
        @"man_dancing_tone2" : @"\U0001f57a\U0001f3fc",
        @"man_dancing_tone3" : @"\U0001f57a\U0001f3fd",
        @"man_dancing_tone4" : @"\U0001f57a\U0001f3fe",
        @"man_dancing_tone5" : @"\U0001f57a\U0001f3ff",
        @"people_with_bunny_ears_partying" : @"\U0001f46f",
        @"men_with_bunny_ears_partying" : @"\U0001f46f\U00002642",
        @"women_with_bunny_ears_partying" : @"\U0001f46f\U00002640",
        @"woman_walking" : @"\U0001f6b6\U00002640",
        @"woman_walking_tone1" : @"\U0001f6b6\U0001f3fb\U00002640",
        @"woman_walking_tone2" : @"\U0001f6b6\U0001f3fc\U00002640",
        @"woman_walking_tone3" : @"\U0001f6b6\U0001f3fd\U00002640",
        @"woman_walking_tone4" : @"\U0001f6b6\U0001f3fe\U00002640",
        @"woman_walking_tone5" : @"\U0001f6b6\U0001f3ff\U00002640",
        @"person_walking" : @"\U0001f6b6",
        @"person_walking_tone1" : @"\U0001f6b6\U0001f3fb",
        @"person_walking_tone2" : @"\U0001f6b6\U0001f3fc",
        @"person_walking_tone3" : @"\U0001f6b6\U0001f3fd",
        @"person_walking_tone4" : @"\U0001f6b6\U0001f3fe",
        @"person_walking_tone5" : @"\U0001f6b6\U0001f3ff",
        @"man_walking" : @"\U0001f6b6\U00002642",
        @"man_walking_tone5" : @"\U0001f6b6\U0001f3ff\U00002642",
        @"man_walking_tone4" : @"\U0001f6b6\U0001f3fe\U00002642",
        @"man_walking_tone3" : @"\U0001f6b6\U0001f3fd\U00002642",
        @"man_walking_tone2" : @"\U0001f6b6\U0001f3fc\U00002642",
        @"man_walking_tone1" : @"\U0001f6b6\U0001f3fb\U00002642",
        @"woman_running" : @"\U0001f3c3\U00002640",
        @"woman_running_tone1" : @"\U0001f3c3\U0001f3fb\U00002640",
        @"woman_running_tone2" : @"\U0001f3c3\U0001f3fc\U00002640",
        @"woman_running_tone3" : @"\U0001f3c3\U0001f3fd\U00002640",
        @"woman_running_tone4" : @"\U0001f3c3\U0001f3fe\U00002640",
        @"woman_running_tone5" : @"\U0001f3c3\U0001f3ff\U00002640",
        @"person_running" : @"\U0001f3c3",
        @"person_running_tone1" : @"\U0001f3c3\U0001f3fb",
        @"person_running_tone2" : @"\U0001f3c3\U0001f3fc",
        @"person_running_tone3" : @"\U0001f3c3\U0001f3fd",
        @"person_running_tone4" : @"\U0001f3c3\U0001f3fe",
        @"person_running_tone5" : @"\U0001f3c3\U0001f3ff",
        @"man_running" : @"\U0001f3c3\U00002642",
        @"man_running_tone5" : @"\U0001f3c3\U0001f3ff\U00002642",
        @"man_running_tone4" : @"\U0001f3c3\U0001f3fe\U00002642",
        @"man_running_tone3" : @"\U0001f3c3\U0001f3fd\U00002642",
        @"man_running_tone2" : @"\U0001f3c3\U0001f3fc\U00002642",
        @"man_running_tone1" : @"\U0001f3c3\U0001f3fb\U00002642",
        @"couple" : @"\U0001f46b",
        @"two_women_holding_hands" : @"\U0001f46d",
        @"two_men_holding_hands" : @"\U0001f46c",
        @"couple_with_heart" : @"\U0001f491",
        @"couple_ww" : @"\U0001f469\U00002764\U0001f469",
        @"couple_mm" : @"\U0001f468\U00002764\U0001f468",
        @"couplekiss" : @"\U0001f48f",
        @"kiss_ww" : @"\U0001f469\U00002764\U0001f48b\U0001f469",
        @"kiss_mm" : @"\U0001f468\U00002764\U0001f48b\U0001f468",
        @"family" : @"\U0001f46a",
        @"family_mwg" : @"\U0001f468\U0001f469\U0001f467",
        @"family_mwgb" : @"\U0001f468\U0001f469\U0001f467\U0001f466",
        @"family_mwbb" : @"\U0001f468\U0001f469\U0001f466\U0001f466",
        @"family_mwgg" : @"\U0001f468\U0001f469\U0001f467\U0001f467",
        @"family_wwb" : @"\U0001f469\U0001f469\U0001f466",
        @"family_wwg" : @"\U0001f469\U0001f469\U0001f467",
        @"family_wwgb" : @"\U0001f469\U0001f469\U0001f467\U0001f466",
        @"family_wwbb" : @"\U0001f469\U0001f469\U0001f466\U0001f466",
        @"family_wwgg" : @"\U0001f469\U0001f469\U0001f467\U0001f467",
        @"family_mmb" : @"\U0001f468\U0001f468\U0001f466",
        @"family_mmg" : @"\U0001f468\U0001f468\U0001f467",
        @"family_mmgb" : @"\U0001f468\U0001f468\U0001f467\U0001f466",
        @"family_mmbb" : @"\U0001f468\U0001f468\U0001f466\U0001f466",
        @"family_mmgg" : @"\U0001f468\U0001f468\U0001f467\U0001f467",
        @"family_woman_boy" : @"\U0001f469\U0001f466",
        @"family_woman_girl" : @"\U0001f469\U0001f467",
        @"family_woman_girl_boy" : @"\U0001f469\U0001f467\U0001f466",
        @"family_woman_boy_boy" : @"\U0001f469\U0001f466\U0001f466",
        @"family_woman_girl_girl" : @"\U0001f469\U0001f467\U0001f467",
        @"family_man_boy" : @"\U0001f468\U0001f466",
        @"family_man_girl" : @"\U0001f468\U0001f467",
        @"family_man_girl_boy" : @"\U0001f468\U0001f467\U0001f466",
        @"family_man_boy_boy" : @"\U0001f468\U0001f466\U0001f466",
        @"family_man_girl_girl" : @"\U0001f468\U0001f467\U0001f467",
        @"womans_clothes" : @"\U0001f45a",
        @"shirt" : @"\U0001f455",
        @"jeans" : @"\U0001f456",
        @"necktie" : @"\U0001f454",
        @"dress" : @"\U0001f457",
        @"bikini" : @"\U0001f459",
        @"kimono" : @"\U0001f458",
        @"high_heel" : @"\U0001f460",
        @"sandal" : @"\U0001f461",
        @"boot" : @"\U0001f462",
        @"mans_shoe" : @"\U0001f45e",
        @"athletic_shoe" : @"\U0001f45f",
        @"womans_hat" : @"\U0001f452",
        @"tophat" : @"\U0001f3a9",
        @"mortar_board" : @"\U0001f393",
        @"crown" : @"\U0001f451",
        @"helmet_with_cross" : @"\U000026d1",
        @"school_satchel" : @"\U0001f392",
        @"pouch" : @"\U0001f45d",
        @"purse" : @"\U0001f45b",
        @"handbag" : @"\U0001f45c",
        @"briefcase" : @"\U0001f4bc",
        @"eyeglasses" : @"\U0001f453",
        @"dark_sunglasses" : @"\U0001f576",
        @"closed_umbrella" : @"\U0001f302",
        @"dog" : @"\U0001f436",
        @"cat" : @"\U0001f431",
        @"mouse" : @"\U0001f42d",
        @"hamster" : @"\U0001f439",
        @"rabbit" : @"\U0001f430",
        @"fox" : @"\U0001f98a",
        @"bear" : @"\U0001f43b",
        @"panda_face" : @"\U0001f43c",
        @"koala" : @"\U0001f428",
        @"tiger" : @"\U0001f42f",
        @"lion_face" : @"\U0001f981",
        @"cow" : @"\U0001f42e",
        @"pig" : @"\U0001f437",
        @"pig_nose" : @"\U0001f43d",
        @"frog" : @"\U0001f438",
        @"monkey_face" : @"\U0001f435",
        @"see_no_evil" : @"\U0001f648",
        @"hear_no_evil" : @"\U0001f649",
        @"speak_no_evil" : @"\U0001f64a",
        @"monkey" : @"\U0001f412",
        @"chicken" : @"\U0001f414",
        @"penguin" : @"\U0001f427",
        @"bird" : @"\U0001f426",
        @"baby_chick" : @"\U0001f424",
        @"hatching_chick" : @"\U0001f423",
        @"hatched_chick" : @"\U0001f425",
        @"duck" : @"\U0001f986",
        @"eagle" : @"\U0001f985",
        @"owl" : @"\U0001f989",
        @"bat" : @"\U0001f987",
        @"wolf" : @"\U0001f43a",
        @"boar" : @"\U0001f417",
        @"horse" : @"\U0001f434",
        @"unicorn" : @"\U0001f984",
        @"bee" : @"\U0001f41d",
        @"bug" : @"\U0001f41b",
        @"butterfly" : @"\U0001f98b",
        @"snail" : @"\U0001f40c",
        @"shell" : @"\U0001f41a",
        @"beetle" : @"\U0001f41e",
        @"ant" : @"\U0001f41c",
        @"spider" : @"\U0001f577",
        @"spider_web" : @"\U0001f578",
        @"turtle" : @"\U0001f422",
        @"snake" : @"\U0001f40d",
        @"lizard" : @"\U0001f98e",
        @"scorpion" : @"\U0001f982",
        @"crab" : @"\U0001f980",
        @"squid" : @"\U0001f991",
        @"octopus" : @"\U0001f419",
        @"shrimp" : @"\U0001f990",
        @"tropical_fish" : @"\U0001f420",
        @"fish" : @"\U0001f41f",
        @"blowfish" : @"\U0001f421",
        @"dolphin" : @"\U0001f42c",
        @"shark" : @"\U0001f988",
        @"whale" : @"\U0001f433",
        @"whale2" : @"\U0001f40b",
        @"crocodile" : @"\U0001f40a",
        @"leopard" : @"\U0001f406",
        @"tiger2" : @"\U0001f405",
        @"water_buffalo" : @"\U0001f403",
        @"ox" : @"\U0001f402",
        @"cow2" : @"\U0001f404",
        @"deer" : @"\U0001f98c",
        @"dromedary_camel" : @"\U0001f42a",
        @"camel" : @"\U0001f42b",
        @"elephant" : @"\U0001f418",
        @"rhino" : @"\U0001f98f",
        @"gorilla" : @"\U0001f98d",
        @"racehorse" : @"\U0001f40e",
        @"pig2" : @"\U0001f416",
        @"goat" : @"\U0001f410",
        @"ram" : @"\U0001f40f",
        @"sheep" : @"\U0001f411",
        @"dog2" : @"\U0001f415",
        @"poodle" : @"\U0001f429",
        @"cat2" : @"\U0001f408",
        @"rooster" : @"\U0001f413",
        @"turkey" : @"\U0001f983",
        @"dove" : @"\U0001f54a",
        @"rabbit2" : @"\U0001f407",
        @"mouse2" : @"\U0001f401",
        @"rat" : @"\U0001f400",
        @"chipmunk" : @"\U0001f43f",
        @"feet" : @"\U0001f43e",
        @"dragon" : @"\U0001f409",
        @"dragon_face" : @"\U0001f432",
        @"cactus" : @"\U0001f335",
        @"christmas_tree" : @"\U0001f384",
        @"evergreen_tree" : @"\U0001f332",
        @"deciduous_tree" : @"\U0001f333",
        @"palm_tree" : @"\U0001f334",
        @"seedling" : @"\U0001f331",
        @"herb" : @"\U0001f33f",
        @"four_leaf_clover" : @"\U0001f340",
        @"bamboo" : @"\U0001f38d",
        @"tanabata_tree" : @"\U0001f38b",
        @"leaves" : @"\U0001f343",
        @"fallen_leaf" : @"\U0001f342",
        @"maple_leaf" : @"\U0001f341",
        @"mushroom" : @"\U0001f344",
        @"ear_of_rice" : @"\U0001f33e",
        @"bouquet" : @"\U0001f490",
        @"tulip" : @"\U0001f337",
        @"rose" : @"\U0001f339",
        @"wilted_rose" : @"\U0001f940",
        @"sunflower" : @"\U0001f33b",
        @"blossom" : @"\U0001f33c",
        @"cherry_blossom" : @"\U0001f338",
        @"hibiscus" : @"\U0001f33a",
        @"earth_americas" : @"\U0001f30e",
        @"earth_africa" : @"\U0001f30d",
        @"earth_asia" : @"\U0001f30f",
        @"full_moon" : @"\U0001f315",
        @"waning_gibbous_moon" : @"\U0001f316",
        @"last_quarter_moon" : @"\U0001f317",
        @"waning_crescent_moon" : @"\U0001f318",
        @"new_moon" : @"\U0001f311",
        @"waxing_crescent_moon" : @"\U0001f312",
        @"first_quarter_moon" : @"\U0001f313",
        @"waxing_gibbous_moon" : @"\U0001f314",
        @"new_moon_with_face" : @"\U0001f31a",
        @"full_moon_with_face" : @"\U0001f31d",
        @"sun_with_face" : @"\U0001f31e",
        @"first_quarter_moon_with_face" : @"\U0001f31b",
        @"last_quarter_moon_with_face" : @"\U0001f31c",
        @"crescent_moon" : @"\U0001f319",
        @"dizzy" : @"\U0001f4ab",
        @"star" : @"\U00002b50",
        @"star2" : @"\U0001f31f",
        @"zap" : @"\U000026a1",
        @"fire" : @"\U0001f525",
        @"boom" : @"\U0001f4a5",
        @"white_sun_small_cloud" : @"\U0001f324",
        @"partly_sunny" : @"\U000026c5",
        @"white_sun_cloud" : @"\U0001f325",
        @"white_sun_rain_cloud" : @"\U0001f326",
        @"rainbow" : @"\U0001f308",
        @"cloud_rain" : @"\U0001f327",
        @"thunder_cloud_rain" : @"\U000026c8",
        @"cloud_lightning" : @"\U0001f329",
        @"cloud_snow" : @"\U0001f328",
        @"snowman" : @"\U000026c4",
        @"wind_blowing_face" : @"\U0001f32c",
        @"dash" : @"\U0001f4a8",
        @"cloud_tornado" : @"\U0001f32a",
        @"fog" : @"\U0001f32b",
        @"ocean" : @"\U0001f30a",
        @"droplet" : @"\U0001f4a7",
        @"sweat_drops" : @"\U0001f4a6",
        @"giraffe" : @"\U0001f992",
        @"zebra" : @"\U0001f993",
        @"hedgehog" : @"\U0001f994",
        @"sauropod" : @"\U0001f995",
        @"t_rex" : @"\U0001f996",
        @"cricket" : @"\U0001f997",
        @"green_apple" : @"\U0001f34f",
        @"apple" : @"\U0001f34e",
        @"pear" : @"\U0001f350",
        @"tangerine" : @"\U0001f34a",
        @"lemon" : @"\U0001f34b",
        @"banana" : @"\U0001f34c",
        @"watermelon" : @"\U0001f349",
        @"grapes" : @"\U0001f347",
        @"strawberry" : @"\U0001f353",
        @"melon" : @"\U0001f348",
        @"cherries" : @"\U0001f352",
        @"peach" : @"\U0001f351",
        @"pineapple" : @"\U0001f34d",
        @"kiwi" : @"\U0001f95d",
        @"avocado" : @"\U0001f951",
        @"tomato" : @"\U0001f345",
        @"eggplant" : @"\U0001f346",
        @"cucumber" : @"\U0001f952",
        @"carrot" : @"\U0001f955",
        @"corn" : @"\U0001f33d",
        @"hot_pepper" : @"\U0001f336",
        @"potato" : @"\U0001f954",
        @"sweet_potato" : @"\U0001f360",
        @"chestnut" : @"\U0001f330",
        @"peanuts" : @"\U0001f95c",
        @"honey_pot" : @"\U0001f36f",
        @"croissant" : @"\U0001f950",
        @"bread" : @"\U0001f35e",
        @"french_bread" : @"\U0001f956",
        @"cheese" : @"\U0001f9c0",
        @"egg" : @"\U0001f95a",
        @"cooking" : @"\U0001f373",
        @"bacon" : @"\U0001f953",
        @"pancakes" : @"\U0001f95e",
        @"fried_shrimp" : @"\U0001f364",
        @"poultry_leg" : @"\U0001f357",
        @"meat_on_bone" : @"\U0001f356",
        @"pizza" : @"\U0001f355",
        @"hotdog" : @"\U0001f32d",
        @"hamburger" : @"\U0001f354",
        @"fries" : @"\U0001f35f",
        @"stuffed_flatbread" : @"\U0001f959",
        @"taco" : @"\U0001f32e",
        @"burrito" : @"\U0001f32f",
        @"salad" : @"\U0001f957",
        @"shallow_pan_of_food" : @"\U0001f958",
        @"spaghetti" : @"\U0001f35d",
        @"ramen" : @"\U0001f35c",
        @"stew" : @"\U0001f372",
        @"fish_cake" : @"\U0001f365",
        @"sushi" : @"\U0001f363",
        @"bento" : @"\U0001f371",
        @"curry" : @"\U0001f35b",
        @"rice_ball" : @"\U0001f359",
        @"rice" : @"\U0001f35a",
        @"rice_cracker" : @"\U0001f358",
        @"oden" : @"\U0001f362",
        @"dango" : @"\U0001f361",
        @"shaved_ice" : @"\U0001f367",
        @"ice_cream" : @"\U0001f368",
        @"icecream" : @"\U0001f366",
        @"cake" : @"\U0001f370",
        @"birthday" : @"\U0001f382",
        @"custard" : @"\U0001f36e",
        @"lollipop" : @"\U0001f36d",
        @"candy" : @"\U0001f36c",
        @"chocolate_bar" : @"\U0001f36b",
        @"popcorn" : @"\U0001f37f",
        @"doughnut" : @"\U0001f369",
        @"cookie" : @"\U0001f36a",
        @"milk" : @"\U0001f95b",
        @"baby_bottle" : @"\U0001f37c",
        @"tea" : @"\U0001f375",
        @"sake" : @"\U0001f376",
        @"beer" : @"\U0001f37a",
        @"beers" : @"\U0001f37b",
        @"champagne_glass" : @"\U0001f942",
        @"wine_glass" : @"\U0001f377",
        @"tumbler_glass" : @"\U0001f943",
        @"cocktail" : @"\U0001f378",
        @"tropical_drink" : @"\U0001f379",
        @"champagne" : @"\U0001f37e",
        @"spoon" : @"\U0001f944",
        @"fork_and_knife" : @"\U0001f374",
        @"fork_knife_plate" : @"\U0001f37d",
        @"dumpling" : @"\U0001f95f",
        @"fortune_cookie" : @"\U0001f960",
        @"takeout_box" : @"\U0001f961",
        @"chopsticks" : @"\U0001f962",
        @"bowl_with_spoon" : @"\U0001f963",
        @"cup_with_straw" : @"\U0001f964",
        @"coconut" : @"\U0001f965",
        @"broccoli" : @"\U0001f966",
        @"pie" : @"\U0001f967",
        @"pretzel" : @"\U0001f968",
        @"cut_of_meat" : @"\U0001f969",
        @"sandwich" : @"\U0001f96a",
        @"canned_food" : @"\U0001f96b",
        @"soccer" : @"\U000026bd",
        @"basketball" : @"\U0001f3c0",
        @"football" : @"\U0001f3c8",
        @"baseball" : @"\U000026be",
        @"tennis" : @"\U0001f3be",
        @"volleyball" : @"\U0001f3d0",
        @"rugby_football" : @"\U0001f3c9",
        @"8ball" : @"\U0001f3b1",
        @"ping_pong" : @"\U0001f3d3",
        @"badminton" : @"\U0001f3f8",
        @"goal" : @"\U0001f945",
        @"hockey" : @"\U0001f3d2",
        @"field_hockey" : @"\U0001f3d1",
        @"cricket_game" : @"\U0001f3cf",
        @"golf" : @"\U000026f3",
        @"bow_and_arrow" : @"\U0001f3f9",
        @"fishing_pole_and_fish" : @"\U0001f3a3",
        @"boxing_glove" : @"\U0001f94a",
        @"martial_arts_uniform" : @"\U0001f94b",
        @"ice_skate" : @"\U000026f8",
        @"ski" : @"\U0001f3bf",
        @"skier" : @"\U000026f7",
        @"snowboarder" : @"\U0001f3c2",
        @"snowboarder_tone1" : @"\U0001f3c2\U0001f3fb",
        @"snowboarder_tone2" : @"\U0001f3c2\U0001f3fc",
        @"snowboarder_tone3" : @"\U0001f3c2\U0001f3fd",
        @"snowboarder_tone4" : @"\U0001f3c2\U0001f3fe",
        @"snowboarder_tone5" : @"\U0001f3c2\U0001f3ff",
        @"woman_lifting_weights" : @"\U0001f3cb\U00002640",
        @"woman_lifting_weights_tone1" : @"\U0001f3cb\U0001f3fb\U00002640",
        @"woman_lifting_weights_tone2" : @"\U0001f3cb\U0001f3fc\U00002640",
        @"woman_lifting_weights_tone3" : @"\U0001f3cb\U0001f3fd\U00002640",
        @"woman_lifting_weights_tone4" : @"\U0001f3cb\U0001f3fe\U00002640",
        @"woman_lifting_weights_tone5" : @"\U0001f3cb\U0001f3ff\U00002640",
        @"person_lifting_weights" : @"\U0001f3cb",
        @"person_lifting_weights_tone1" : @"\U0001f3cb\U0001f3fb",
        @"person_lifting_weights_tone2" : @"\U0001f3cb\U0001f3fc",
        @"person_lifting_weights_tone3" : @"\U0001f3cb\U0001f3fd",
        @"person_lifting_weights_tone4" : @"\U0001f3cb\U0001f3fe",
        @"person_lifting_weights_tone5" : @"\U0001f3cb\U0001f3ff",
        @"man_lifting_weights" : @"\U0001f3cb\U00002642",
        @"man_lifting_weights_tone5" : @"\U0001f3cb\U0001f3ff\U00002642",
        @"man_lifting_weights_tone4" : @"\U0001f3cb\U0001f3fe\U00002642",
        @"man_lifting_weights_tone3" : @"\U0001f3cb\U0001f3fd\U00002642",
        @"man_lifting_weights_tone2" : @"\U0001f3cb\U0001f3fc\U00002642",
        @"man_lifting_weights_tone1" : @"\U0001f3cb\U0001f3fb\U00002642",
        @"person_fencing" : @"\U0001f93a",
        @"women_wrestling" : @"\U0001f93c\U00002640",
        @"men_wrestling" : @"\U0001f93c\U00002642",
        @"people_wrestling" : @"\U0001f93c",
        @"woman_cartwheeling" : @"\U0001f938\U00002640",
        @"woman_cartwheeling_tone1" : @"\U0001f938\U0001f3fb\U00002640",
        @"woman_cartwheeling_tone2" : @"\U0001f938\U0001f3fc\U00002640",
        @"woman_cartwheeling_tone3" : @"\U0001f938\U0001f3fd\U00002640",
        @"woman_cartwheeling_tone4" : @"\U0001f938\U0001f3fe\U00002640",
        @"woman_cartwheeling_tone5" : @"\U0001f938\U0001f3ff\U00002640",
        @"man_cartwheeling" : @"\U0001f938\U00002642",
        @"man_cartwheeling_tone1" : @"\U0001f938\U0001f3fb\U00002642",
        @"man_cartwheeling_tone2" : @"\U0001f938\U0001f3fc\U00002642",
        @"man_cartwheeling_tone3" : @"\U0001f938\U0001f3fd\U00002642",
        @"man_cartwheeling_tone4" : @"\U0001f938\U0001f3fe\U00002642",
        @"man_cartwheeling_tone5" : @"\U0001f938\U0001f3ff\U00002642",
        @"person_doing_cartwheel" : @"\U0001f938",
        @"person_doing_cartwheel_tone1" : @"\U0001f938\U0001f3fb",
        @"person_doing_cartwheel_tone2" : @"\U0001f938\U0001f3fc",
        @"person_doing_cartwheel_tone3" : @"\U0001f938\U0001f3fd",
        @"person_doing_cartwheel_tone4" : @"\U0001f938\U0001f3fe",
        @"person_doing_cartwheel_tone5" : @"\U0001f938\U0001f3ff",
        @"woman_bouncing_ball" : @"\U000026f9\U00002640",
        @"woman_bouncing_ball_tone1" : @"\U000026f9\U0001f3fb\U00002640",
        @"woman_bouncing_ball_tone2" : @"\U000026f9\U0001f3fc\U00002640",
        @"woman_bouncing_ball_tone3" : @"\U000026f9\U0001f3fd\U00002640",
        @"woman_bouncing_ball_tone4" : @"\U000026f9\U0001f3fe\U00002640",
        @"woman_bouncing_ball_tone5" : @"\U000026f9\U0001f3ff\U00002640",
        @"person_bouncing_ball" : @"\U000026f9",
        @"person_bouncing_ball_tone1" : @"\U000026f9\U0001f3fb",
        @"person_bouncing_ball_tone2" : @"\U000026f9\U0001f3fc",
        @"person_bouncing_ball_tone3" : @"\U000026f9\U0001f3fd",
        @"person_bouncing_ball_tone4" : @"\U000026f9\U0001f3fe",
        @"person_bouncing_ball_tone5" : @"\U000026f9\U0001f3ff",
        @"man_bouncing_ball" : @"\U000026f9\U00002642",
        @"man_bouncing_ball_tone5" : @"\U000026f9\U0001f3ff\U00002642",
        @"man_bouncing_ball_tone4" : @"\U000026f9\U0001f3fe\U00002642",
        @"man_bouncing_ball_tone3" : @"\U000026f9\U0001f3fd\U00002642",
        @"man_bouncing_ball_tone2" : @"\U000026f9\U0001f3fc\U00002642",
        @"man_bouncing_ball_tone1" : @"\U000026f9\U0001f3fb\U00002642",
        @"woman_playing_handball" : @"\U0001f93e\U00002640",
        @"woman_playing_handball_tone1" : @"\U0001f93e\U0001f3fb\U00002640",
        @"woman_playing_handball_tone2" : @"\U0001f93e\U0001f3fc\U00002640",
        @"woman_playing_handball_tone3" : @"\U0001f93e\U0001f3fd\U00002640",
        @"woman_playing_handball_tone4" : @"\U0001f93e\U0001f3fe\U00002640",
        @"woman_playing_handball_tone5" : @"\U0001f93e\U0001f3ff\U00002640",
        @"man_playing_handball" : @"\U0001f93e\U00002642",
        @"man_playing_handball_tone1" : @"\U0001f93e\U0001f3fb\U00002642",
        @"man_playing_handball_tone2" : @"\U0001f93e\U0001f3fc\U00002642",
        @"man_playing_handball_tone3" : @"\U0001f93e\U0001f3fd\U00002642",
        @"man_playing_handball_tone4" : @"\U0001f93e\U0001f3fe\U00002642",
        @"man_playing_handball_tone5" : @"\U0001f93e\U0001f3ff\U00002642",
        @"person_playing_handball" : @"\U0001f93e",
        @"person_playing_handball_tone1" : @"\U0001f93e\U0001f3fb",
        @"person_playing_handball_tone2" : @"\U0001f93e\U0001f3fc",
        @"person_playing_handball_tone3" : @"\U0001f93e\U0001f3fd",
        @"person_playing_handball_tone4" : @"\U0001f93e\U0001f3fe",
        @"person_playing_handball_tone5" : @"\U0001f93e\U0001f3ff",
        @"woman_golfing" : @"\U0001f3cc\U00002640",
        @"woman_golfing_tone1" : @"\U0001f3cc\U0001f3fb\U00002640",
        @"woman_golfing_tone2" : @"\U0001f3cc\U0001f3fc\U00002640",
        @"woman_golfing_tone3" : @"\U0001f3cc\U0001f3fd\U00002640",
        @"woman_golfing_tone4" : @"\U0001f3cc\U0001f3fe\U00002640",
        @"woman_golfing_tone5" : @"\U0001f3cc\U0001f3ff\U00002640",
        @"person_golfing" : @"\U0001f3cc",
        @"person_golfing_tone1" : @"\U0001f3cc\U0001f3fb",
        @"person_golfing_tone2" : @"\U0001f3cc\U0001f3fc",
        @"person_golfing_tone3" : @"\U0001f3cc\U0001f3fd",
        @"person_golfing_tone4" : @"\U0001f3cc\U0001f3fe",
        @"person_golfing_tone5" : @"\U0001f3cc\U0001f3ff",
        @"man_golfing" : @"\U0001f3cc\U00002642",
        @"man_golfing_tone1" : @"\U0001f3cc\U0001f3fb\U00002642",
        @"man_golfing_tone2" : @"\U0001f3cc\U0001f3fc\U00002642",
        @"man_golfing_tone3" : @"\U0001f3cc\U0001f3fd\U00002642",
        @"man_golfing_tone4" : @"\U0001f3cc\U0001f3fe\U00002642",
        @"man_golfing_tone5" : @"\U0001f3cc\U0001f3ff\U00002642",
        @"woman_surfing" : @"\U0001f3c4\U00002640",
        @"woman_surfing_tone1" : @"\U0001f3c4\U0001f3fb\U00002640",
        @"woman_surfing_tone2" : @"\U0001f3c4\U0001f3fc\U00002640",
        @"woman_surfing_tone3" : @"\U0001f3c4\U0001f3fd\U00002640",
        @"woman_surfing_tone4" : @"\U0001f3c4\U0001f3fe\U00002640",
        @"woman_surfing_tone5" : @"\U0001f3c4\U0001f3ff\U00002640",
        @"person_surfing" : @"\U0001f3c4",
        @"person_surfing_tone1" : @"\U0001f3c4\U0001f3fb",
        @"person_surfing_tone2" : @"\U0001f3c4\U0001f3fc",
        @"person_surfing_tone3" : @"\U0001f3c4\U0001f3fd",
        @"person_surfing_tone4" : @"\U0001f3c4\U0001f3fe",
        @"person_surfing_tone5" : @"\U0001f3c4\U0001f3ff",
        @"man_surfing" : @"\U0001f3c4\U00002642",
        @"man_surfing_tone5" : @"\U0001f3c4\U0001f3ff\U00002642",
        @"man_surfing_tone4" : @"\U0001f3c4\U0001f3fe\U00002642",
        @"man_surfing_tone3" : @"\U0001f3c4\U0001f3fd\U00002642",
        @"man_surfing_tone2" : @"\U0001f3c4\U0001f3fc\U00002642",
        @"man_surfing_tone1" : @"\U0001f3c4\U0001f3fb\U00002642",
        @"woman_swimming" : @"\U0001f3ca\U00002640",
        @"woman_swimming_tone1" : @"\U0001f3ca\U0001f3fb\U00002640",
        @"woman_swimming_tone2" : @"\U0001f3ca\U0001f3fc\U00002640",
        @"woman_swimming_tone3" : @"\U0001f3ca\U0001f3fd\U00002640",
        @"woman_swimming_tone4" : @"\U0001f3ca\U0001f3fe\U00002640",
        @"woman_swimming_tone5" : @"\U0001f3ca\U0001f3ff\U00002640",
        @"person_swimming" : @"\U0001f3ca",
        @"person_swimming_tone1" : @"\U0001f3ca\U0001f3fb",
        @"person_swimming_tone2" : @"\U0001f3ca\U0001f3fc",
        @"person_swimming_tone3" : @"\U0001f3ca\U0001f3fd",
        @"person_swimming_tone4" : @"\U0001f3ca\U0001f3fe",
        @"person_swimming_tone5" : @"\U0001f3ca\U0001f3ff",
        @"man_swimming" : @"\U0001f3ca\U00002642",
        @"man_swimming_tone5" : @"\U0001f3ca\U0001f3ff\U00002642",
        @"man_swimming_tone4" : @"\U0001f3ca\U0001f3fe\U00002642",
        @"man_swimming_tone3" : @"\U0001f3ca\U0001f3fd\U00002642",
        @"man_swimming_tone2" : @"\U0001f3ca\U0001f3fc\U00002642",
        @"man_swimming_tone1" : @"\U0001f3ca\U0001f3fb\U00002642",
        @"woman_playing_water_polo" : @"\U0001f93d\U00002640",
        @"woman_playing_water_polo_tone1" : @"\U0001f93d\U0001f3fb\U00002640",
        @"woman_playing_water_polo_tone2" : @"\U0001f93d\U0001f3fc\U00002640",
        @"woman_playing_water_polo_tone3" : @"\U0001f93d\U0001f3fd\U00002640",
        @"woman_playing_water_polo_tone4" : @"\U0001f93d\U0001f3fe\U00002640",
        @"woman_playing_water_polo_tone5" : @"\U0001f93d\U0001f3ff\U00002640",
        @"man_playing_water_polo" : @"\U0001f93d\U00002642",
        @"man_playing_water_polo_tone1" : @"\U0001f93d\U0001f3fb\U00002642",
        @"man_playing_water_polo_tone2" : @"\U0001f93d\U0001f3fc\U00002642",
        @"man_playing_water_polo_tone3" : @"\U0001f93d\U0001f3fd\U00002642",
        @"man_playing_water_polo_tone4" : @"\U0001f93d\U0001f3fe\U00002642",
        @"man_playing_water_polo_tone5" : @"\U0001f93d\U0001f3ff\U00002642",
        @"person_playing_water_polo" : @"\U0001f93d",
        @"person_playing_water_polo_tone1" : @"\U0001f93d\U0001f3fb",
        @"person_playing_water_polo_tone2" : @"\U0001f93d\U0001f3fc",
        @"person_playing_water_polo_tone3" : @"\U0001f93d\U0001f3fd",
        @"person_playing_water_polo_tone4" : @"\U0001f93d\U0001f3fe",
        @"person_playing_water_polo_tone5" : @"\U0001f93d\U0001f3ff",
        @"woman_rowing_boat" : @"\U0001f6a3\U00002640",
        @"woman_rowing_boat_tone1" : @"\U0001f6a3\U0001f3fb\U00002640",
        @"woman_rowing_boat_tone2" : @"\U0001f6a3\U0001f3fc\U00002640",
        @"woman_rowing_boat_tone3" : @"\U0001f6a3\U0001f3fd\U00002640",
        @"woman_rowing_boat_tone4" : @"\U0001f6a3\U0001f3fe\U00002640",
        @"woman_rowing_boat_tone5" : @"\U0001f6a3\U0001f3ff\U00002640",
        @"person_rowing_boat" : @"\U0001f6a3",
        @"person_rowing_boat_tone1" : @"\U0001f6a3\U0001f3fb",
        @"person_rowing_boat_tone2" : @"\U0001f6a3\U0001f3fc",
        @"person_rowing_boat_tone3" : @"\U0001f6a3\U0001f3fd",
        @"person_rowing_boat_tone4" : @"\U0001f6a3\U0001f3fe",
        @"person_rowing_boat_tone5" : @"\U0001f6a3\U0001f3ff",
        @"man_rowing_boat" : @"\U0001f6a3\U00002642",
        @"man_rowing_boat_tone5" : @"\U0001f6a3\U0001f3ff\U00002642",
        @"man_rowing_boat_tone4" : @"\U0001f6a3\U0001f3fe\U00002642",
        @"man_rowing_boat_tone3" : @"\U0001f6a3\U0001f3fd\U00002642",
        @"man_rowing_boat_tone2" : @"\U0001f6a3\U0001f3fc\U00002642",
        @"man_rowing_boat_tone1" : @"\U0001f6a3\U0001f3fb\U00002642",
        @"horse_racing" : @"\U0001f3c7",
        @"horse_racing_tone1" : @"\U0001f3c7\U0001f3fb",
        @"horse_racing_tone2" : @"\U0001f3c7\U0001f3fc",
        @"horse_racing_tone3" : @"\U0001f3c7\U0001f3fd",
        @"horse_racing_tone4" : @"\U0001f3c7\U0001f3fe",
        @"horse_racing_tone5" : @"\U0001f3c7\U0001f3ff",
        @"woman_biking" : @"\U0001f6b4\U00002640",
        @"woman_biking_tone1" : @"\U0001f6b4\U0001f3fb\U00002640",
        @"woman_biking_tone2" : @"\U0001f6b4\U0001f3fc\U00002640",
        @"woman_biking_tone3" : @"\U0001f6b4\U0001f3fd\U00002640",
        @"woman_biking_tone4" : @"\U0001f6b4\U0001f3fe\U00002640",
        @"woman_biking_tone5" : @"\U0001f6b4\U0001f3ff\U00002640",
        @"person_biking" : @"\U0001f6b4",
        @"person_biking_tone1" : @"\U0001f6b4\U0001f3fb",
        @"person_biking_tone2" : @"\U0001f6b4\U0001f3fc",
        @"person_biking_tone3" : @"\U0001f6b4\U0001f3fd",
        @"person_biking_tone4" : @"\U0001f6b4\U0001f3fe",
        @"person_biking_tone5" : @"\U0001f6b4\U0001f3ff",
        @"man_biking" : @"\U0001f6b4\U00002642",
        @"man_biking_tone5" : @"\U0001f6b4\U0001f3ff\U00002642",
        @"man_biking_tone4" : @"\U0001f6b4\U0001f3fe\U00002642",
        @"man_biking_tone3" : @"\U0001f6b4\U0001f3fd\U00002642",
        @"man_biking_tone2" : @"\U0001f6b4\U0001f3fc\U00002642",
        @"man_biking_tone1" : @"\U0001f6b4\U0001f3fb\U00002642",
        @"woman_mountain_biking" : @"\U0001f6b5\U00002640",
        @"woman_mountain_biking_tone1" : @"\U0001f6b5\U0001f3fb\U00002640",
        @"woman_mountain_biking_tone2" : @"\U0001f6b5\U0001f3fc\U00002640",
        @"woman_mountain_biking_tone3" : @"\U0001f6b5\U0001f3fd\U00002640",
        @"woman_mountain_biking_tone4" : @"\U0001f6b5\U0001f3fe\U00002640",
        @"woman_mountain_biking_tone5" : @"\U0001f6b5\U0001f3ff\U00002640",
        @"person_mountain_biking" : @"\U0001f6b5",
        @"person_mountain_biking_tone1" : @"\U0001f6b5\U0001f3fb",
        @"person_mountain_biking_tone2" : @"\U0001f6b5\U0001f3fc",
        @"person_mountain_biking_tone3" : @"\U0001f6b5\U0001f3fd",
        @"person_mountain_biking_tone4" : @"\U0001f6b5\U0001f3fe",
        @"person_mountain_biking_tone5" : @"\U0001f6b5\U0001f3ff",
        @"man_mountain_biking" : @"\U0001f6b5\U00002642",
        @"man_mountain_biking_tone5" : @"\U0001f6b5\U0001f3ff\U00002642",
        @"man_mountain_biking_tone4" : @"\U0001f6b5\U0001f3fe\U00002642",
        @"man_mountain_biking_tone3" : @"\U0001f6b5\U0001f3fd\U00002642",
        @"man_mountain_biking_tone2" : @"\U0001f6b5\U0001f3fc\U00002642",
        @"man_mountain_biking_tone1" : @"\U0001f6b5\U0001f3fb\U00002642",
        @"running_shirt_with_sash" : @"\U0001f3bd",
        @"medal" : @"\U0001f3c5",
        @"military_medal" : @"\U0001f396",
        @"first_place" : @"\U0001f947",
        @"second_place" : @"\U0001f948",
        @"third_place" : @"\U0001f949",
        @"trophy" : @"\U0001f3c6",
        @"rosette" : @"\U0001f3f5",
        @"reminder_ribbon" : @"\U0001f397",
        @"ticket" : @"\U0001f3ab",
        @"tickets" : @"\U0001f39f",
        @"circus_tent" : @"\U0001f3aa",
        @"woman_juggling" : @"\U0001f939\U00002640",
        @"woman_juggling_tone1" : @"\U0001f939\U0001f3fb\U00002640",
        @"woman_juggling_tone2" : @"\U0001f939\U0001f3fc\U00002640",
        @"woman_juggling_tone3" : @"\U0001f939\U0001f3fd\U00002640",
        @"woman_juggling_tone4" : @"\U0001f939\U0001f3fe\U00002640",
        @"woman_juggling_tone5" : @"\U0001f939\U0001f3ff\U00002640",
        @"man_juggling" : @"\U0001f939\U00002642",
        @"man_juggling_tone1" : @"\U0001f939\U0001f3fb\U00002642",
        @"man_juggling_tone2" : @"\U0001f939\U0001f3fc\U00002642",
        @"man_juggling_tone3" : @"\U0001f939\U0001f3fd\U00002642",
        @"man_juggling_tone4" : @"\U0001f939\U0001f3fe\U00002642",
        @"man_juggling_tone5" : @"\U0001f939\U0001f3ff\U00002642",
        @"person_juggling" : @"\U0001f939",
        @"person_juggling_tone1" : @"\U0001f939\U0001f3fb",
        @"person_juggling_tone2" : @"\U0001f939\U0001f3fc",
        @"person_juggling_tone3" : @"\U0001f939\U0001f3fd",
        @"person_juggling_tone4" : @"\U0001f939\U0001f3fe",
        @"person_juggling_tone5" : @"\U0001f939\U0001f3ff",
        @"performing_arts" : @"\U0001f3ad",
        @"art" : @"\U0001f3a8",
        @"clapper" : @"\U0001f3ac",
        @"microphone" : @"\U0001f3a4",
        @"headphones" : @"\U0001f3a7",
        @"musical_score" : @"\U0001f3bc",
        @"musical_keyboard" : @"\U0001f3b9",
        @"drum" : @"\U0001f941",
        @"saxophone" : @"\U0001f3b7",
        @"trumpet" : @"\U0001f3ba",
        @"guitar" : @"\U0001f3b8",
        @"violin" : @"\U0001f3bb",
        @"game_die" : @"\U0001f3b2",
        @"dart" : @"\U0001f3af",
        @"bowling" : @"\U0001f3b3",
        @"video_game" : @"\U0001f3ae",
        @"slot_machine" : @"\U0001f3b0",
        @"sled" : @"\U0001f6f7",
        @"breast_feeding" : @"\U0001f931",
        @"curling_stone" : @"\U0001f94c",
        @"person_in_steamy_room" : @"\U0001f9d6",
        @"person_climbing" : @"\U0001f9d7",
        @"person_in_lotus_position" : @"\U0001f9d8",
        @"breast_feeding_tone1" : @"\U0001f931\U0001f3fb",
        @"breast_feeding_tone2" : @"\U0001f931\U0001f3fc",
        @"breast_feeding_tone3" : @"\U0001f931\U0001f3fd",
        @"breast_feeding_tone4" : @"\U0001f931\U0001f3fe",
        @"breast_feeding_tone5" : @"\U0001f931\U0001f3ff",
        @"person_in_steamy_room_tone1" : @"\U0001f9d6\U0001f3fb",
        @"person_in_steamy_room_tone2" : @"\U0001f9d6\U0001f3fc",
        @"person_in_steamy_room_tone3" : @"\U0001f9d6\U0001f3fd",
        @"person_in_steamy_room_tone4" : @"\U0001f9d6\U0001f3fe",
        @"person_in_steamy_room_tone5" : @"\U0001f9d6\U0001f3ff",
        @"person_climbing_tone1" : @"\U0001f9d7\U0001f3fb",
        @"person_climbing_tone2" : @"\U0001f9d7\U0001f3fc",
        @"person_climbing_tone3" : @"\U0001f9d7\U0001f3fd",
        @"person_climbing_tone4" : @"\U0001f9d7\U0001f3fe",
        @"person_climbing_tone5" : @"\U0001f9d7\U0001f3ff",
        @"person_in_lotus_position_tone1" : @"\U0001f9d8\U0001f3fb",
        @"person_in_lotus_position_tone2" : @"\U0001f9d8\U0001f3fc",
        @"person_in_lotus_position_tone3" : @"\U0001f9d8\U0001f3fd",
        @"person_in_lotus_position_tone4" : @"\U0001f9d8\U0001f3fe",
        @"person_in_lotus_position_tone5" : @"\U0001f9d8\U0001f3ff",
        @"woman_in_steamy_room" : @"\U0001f9d6\U00002640",
        @"man_in_steamy_room" : @"\U0001f9d6\U00002642",
        @"woman_in_steamy_room_tone1" : @"\U0001f9d6\U0001f3fb\U00002640",
        @"man_in_steamy_room_tone1" : @"\U0001f9d6\U0001f3fb\U00002642",
        @"woman_in_steamy_room_tone2" : @"\U0001f9d6\U0001f3fc\U00002640",
        @"man_in_steamy_room_tone2" : @"\U0001f9d6\U0001f3fc\U00002642",
        @"woman_in_steamy_room_tone3" : @"\U0001f9d6\U0001f3fd\U00002640",
        @"man_in_steamy_room_tone3" : @"\U0001f9d6\U0001f3fd\U00002642",
        @"woman_in_steamy_room_tone4" : @"\U0001f9d6\U0001f3fe\U00002640",
        @"man_in_steamy_room_tone4" : @"\U0001f9d6\U0001f3fe\U00002642",
        @"woman_in_steamy_room_tone5" : @"\U0001f9d6\U0001f3ff\U00002640",
        @"man_in_steamy_room_tone5" : @"\U0001f9d6\U0001f3ff\U00002642",
        @"woman_climbing" : @"\U0001f9d7\U00002640",
        @"man_climbing" : @"\U0001f9d7\U00002642",
        @"woman_climbing_tone1" : @"\U0001f9d7\U0001f3fb\U00002640",
        @"man_climbing_tone1" : @"\U0001f9d7\U0001f3fb\U00002642",
        @"woman_climbing_tone2" : @"\U0001f9d7\U0001f3fc\U00002640",
        @"man_climbing_tone2" : @"\U0001f9d7\U0001f3fc\U00002642",
        @"woman_climbing_tone3" : @"\U0001f9d7\U0001f3fd\U00002640",
        @"man_climbing_tone3" : @"\U0001f9d7\U0001f3fd\U00002642",
        @"woman_climbing_tone4" : @"\U0001f9d7\U0001f3fe\U00002640",
        @"man_climbing_tone4" : @"\U0001f9d7\U0001f3fe\U00002642",
        @"woman_climbing_tone5" : @"\U0001f9d7\U0001f3ff\U00002640",
        @"man_climbing_tone5" : @"\U0001f9d7\U0001f3ff\U00002642",
        @"woman_in_lotus_position" : @"\U0001f9d8\U00002640",
        @"man_in_lotus_position" : @"\U0001f9d8\U00002642",
        @"woman_in_lotus_position_tone1" : @"\U0001f9d8\U0001f3fb\U00002640",
        @"man_in_lotus_position_tone1" : @"\U0001f9d8\U0001f3fb\U00002642",
        @"woman_in_lotus_position_tone2" : @"\U0001f9d8\U0001f3fc\U00002640",
        @"man_in_lotus_position_tone2" : @"\U0001f9d8\U0001f3fc\U00002642",
        @"woman_in_lotus_position_tone3" : @"\U0001f9d8\U0001f3fd\U00002640",
        @"man_in_lotus_position_tone3" : @"\U0001f9d8\U0001f3fd\U00002642",
        @"woman_in_lotus_position_tone4" : @"\U0001f9d8\U0001f3fe\U00002640",
        @"man_in_lotus_position_tone4" : @"\U0001f9d8\U0001f3fe\U00002642",
        @"woman_in_lotus_position_tone5" : @"\U0001f9d8\U0001f3ff\U00002640",
        @"man_in_lotus_position_tone5" : @"\U0001f9d8\U0001f3ff\U00002642",
        @"red_car" : @"\U0001f697",
        @"taxi" : @"\U0001f695",
        @"blue_car" : @"\U0001f699",
        @"bus" : @"\U0001f68c",
        @"trolleybus" : @"\U0001f68e",
        @"race_car" : @"\U0001f3ce",
        @"police_car" : @"\U0001f693",
        @"ambulance" : @"\U0001f691",
        @"fire_engine" : @"\U0001f692",
        @"minibus" : @"\U0001f690",
        @"truck" : @"\U0001f69a",
        @"articulated_lorry" : @"\U0001f69b",
        @"tractor" : @"\U0001f69c",
        @"scooter" : @"\U0001f6f4",
        @"bike" : @"\U0001f6b2",
        @"motor_scooter" : @"\U0001f6f5",
        @"motorcycle" : @"\U0001f3cd",
        @"rotating_light" : @"\U0001f6a8",
        @"oncoming_police_car" : @"\U0001f694",
        @"oncoming_bus" : @"\U0001f68d",
        @"oncoming_automobile" : @"\U0001f698",
        @"oncoming_taxi" : @"\U0001f696",
        @"aerial_tramway" : @"\U0001f6a1",
        @"mountain_cableway" : @"\U0001f6a0",
        @"suspension_railway" : @"\U0001f69f",
        @"railway_car" : @"\U0001f683",
        @"train" : @"\U0001f68b",
        @"mountain_railway" : @"\U0001f69e",
        @"monorail" : @"\U0001f69d",
        @"bullettrain_side" : @"\U0001f684",
        @"bullettrain_front" : @"\U0001f685",
        @"light_rail" : @"\U0001f688",
        @"steam_locomotive" : @"\U0001f682",
        @"train2" : @"\U0001f686",
        @"metro" : @"\U0001f687",
        @"tram" : @"\U0001f68a",
        @"station" : @"\U0001f689",
        @"helicopter" : @"\U0001f681",
        @"airplane_small" : @"\U0001f6e9",
        @"airplane_departure" : @"\U0001f6eb",
        @"airplane_arriving" : @"\U0001f6ec",
        @"rocket" : @"\U0001f680",
        @"satellite_orbital" : @"\U0001f6f0",
        @"seat" : @"\U0001f4ba",
        @"canoe" : @"\U0001f6f6",
        @"sailboat" : @"\U000026f5",
        @"motorboat" : @"\U0001f6e5",
        @"speedboat" : @"\U0001f6a4",
        @"cruise_ship" : @"\U0001f6f3",
        @"ferry" : @"\U000026f4",
        @"ship" : @"\U0001f6a2",
        @"construction" : @"\U0001f6a7",
        @"fuelpump" : @"\U000026fd",
        @"busstop" : @"\U0001f68f",
        @"vertical_traffic_light" : @"\U0001f6a6",
        @"traffic_light" : @"\U0001f6a5",
        @"map" : @"\U0001f5fa",
        @"moyai" : @"\U0001f5ff",
        @"statue_of_liberty" : @"\U0001f5fd",
        @"fountain" : @"\U000026f2",
        @"tokyo_tower" : @"\U0001f5fc",
        @"european_castle" : @"\U0001f3f0",
        @"japanese_castle" : @"\U0001f3ef",
        @"stadium" : @"\U0001f3df",
        @"ferris_wheel" : @"\U0001f3a1",
        @"roller_coaster" : @"\U0001f3a2",
        @"carousel_horse" : @"\U0001f3a0",
        @"beach_umbrella" : @"\U000026f1",
        @"beach" : @"\U0001f3d6",
        @"island" : @"\U0001f3dd",
        @"mountain" : @"\U000026f0",
        @"mountain_snow" : @"\U0001f3d4",
        @"mount_fuji" : @"\U0001f5fb",
        @"volcano" : @"\U0001f30b",
        @"desert" : @"\U0001f3dc",
        @"camping" : @"\U0001f3d5",
        @"tent" : @"\U000026fa",
        @"railway_track" : @"\U0001f6e4",
        @"motorway" : @"\U0001f6e3",
        @"construction_site" : @"\U0001f3d7",
        @"factory" : @"\U0001f3ed",
        @"house" : @"\U0001f3e0",
        @"house_with_garden" : @"\U0001f3e1",
        @"homes" : @"\U0001f3d8",
        @"house_abandoned" : @"\U0001f3da",
        @"office" : @"\U0001f3e2",
        @"department_store" : @"\U0001f3ec",
        @"post_office" : @"\U0001f3e3",
        @"european_post_office" : @"\U0001f3e4",
        @"hospital" : @"\U0001f3e5",
        @"bank" : @"\U0001f3e6",
        @"hotel" : @"\U0001f3e8",
        @"convenience_store" : @"\U0001f3ea",
        @"school" : @"\U0001f3eb",
        @"love_hotel" : @"\U0001f3e9",
        @"wedding" : @"\U0001f492",
        @"classical_building" : @"\U0001f3db",
        @"church" : @"\U000026ea",
        @"mosque" : @"\U0001f54c",
        @"synagogue" : @"\U0001f54d",
        @"kaaba" : @"\U0001f54b",
        @"shinto_shrine" : @"\U000026e9",
        @"japan" : @"\U0001f5fe",
        @"rice_scene" : @"\U0001f391",
        @"park" : @"\U0001f3de",
        @"sunrise" : @"\U0001f305",
        @"sunrise_over_mountains" : @"\U0001f304",
        @"stars" : @"\U0001f320",
        @"sparkler" : @"\U0001f387",
        @"fireworks" : @"\U0001f386",
        @"city_sunset" : @"\U0001f307",
        @"city_dusk" : @"\U0001f306",
        @"cityscape" : @"\U0001f3d9",
        @"night_with_stars" : @"\U0001f303",
        @"milky_way" : @"\U0001f30c",
        @"bridge_at_night" : @"\U0001f309",
        @"foggy" : @"\U0001f301",
        @"flying_saucer" : @"\U0001f6f8",
        @"watch" : @"\U0000231a",
        @"iphone" : @"\U0001f4f1",
        @"calling" : @"\U0001f4f2",
        @"computer" : @"\U0001f4bb",
        @"desktop" : @"\U0001f5a5",
        @"printer" : @"\U0001f5a8",
        @"mouse_three_button" : @"\U0001f5b1",
        @"trackball" : @"\U0001f5b2",
        @"joystick" : @"\U0001f579",
        @"compression" : @"\U0001f5dc",
        @"minidisc" : @"\U0001f4bd",
        @"floppy_disk" : @"\U0001f4be",
        @"cd" : @"\U0001f4bf",
        @"dvd" : @"\U0001f4c0",
        @"vhs" : @"\U0001f4fc",
        @"camera" : @"\U0001f4f7",
        @"camera_with_flash" : @"\U0001f4f8",
        @"video_camera" : @"\U0001f4f9",
        @"movie_camera" : @"\U0001f3a5",
        @"projector" : @"\U0001f4fd",
        @"film_frames" : @"\U0001f39e",
        @"telephone_receiver" : @"\U0001f4de",
        @"telephone" : @"\U0000260e",
        @"pager" : @"\U0001f4df",
        @"fax" : @"\U0001f4e0",
        @"tv" : @"\U0001f4fa",
        @"radio" : @"\U0001f4fb",
        @"microphone2" : @"\U0001f399",
        @"level_slider" : @"\U0001f39a",
        @"control_knobs" : @"\U0001f39b",
        @"stopwatch" : @"\U000023f1",
        @"timer" : @"\U000023f2",
        @"alarm_clock" : @"\U000023f0",
        @"clock" : @"\U0001f570",
        @"hourglass" : @"\U0000231b",
        @"hourglass_flowing_sand" : @"\U000023f3",
        @"satellite" : @"\U0001f4e1",
        @"battery" : @"\U0001f50b",
        @"electric_plug" : @"\U0001f50c",
        @"bulb" : @"\U0001f4a1",
        @"flashlight" : @"\U0001f526",
        @"candle" : @"\U0001f56f",
        @"wastebasket" : @"\U0001f5d1",
        @"oil" : @"\U0001f6e2",
        @"money_with_wings" : @"\U0001f4b8",
        @"dollar" : @"\U0001f4b5",
        @"yen" : @"\U0001f4b4",
        @"euro" : @"\U0001f4b6",
        @"pound" : @"\U0001f4b7",
        @"moneybag" : @"\U0001f4b0",
        @"credit_card" : @"\U0001f4b3",
        @"gem" : @"\U0001f48e",
        @"wrench" : @"\U0001f527",
        @"hammer" : @"\U0001f528",
        @"tools" : @"\U0001f6e0",
        @"pick" : @"\U000026cf",
        @"nut_and_bolt" : @"\U0001f529",
        @"chains" : @"\U000026d3",
        @"gun" : @"\U0001f52b",
        @"bomb" : @"\U0001f4a3",
        @"knife" : @"\U0001f52a",
        @"dagger" : @"\U0001f5e1",
        @"shield" : @"\U0001f6e1",
        @"smoking" : @"\U0001f6ac",
        @"coffin" : @"\U000026b0",
        @"urn" : @"\U000026b1",
        @"amphora" : @"\U0001f3fa",
        @"crystal_ball" : @"\U0001f52e",
        @"prayer_beads" : @"\U0001f4ff",
        @"barber" : @"\U0001f488",
        @"telescope" : @"\U0001f52d",
        @"microscope" : @"\U0001f52c",
        @"hole" : @"\U0001f573",
        @"pill" : @"\U0001f48a",
        @"syringe" : @"\U0001f489",
        @"thermometer" : @"\U0001f321",
        @"toilet" : @"\U0001f6bd",
        @"potable_water" : @"\U0001f6b0",
        @"shower" : @"\U0001f6bf",
        @"bathtub" : @"\U0001f6c1",
        @"bath" : @"\U0001f6c0",
        @"bath_tone1" : @"\U0001f6c0\U0001f3fb",
        @"bath_tone2" : @"\U0001f6c0\U0001f3fc",
        @"bath_tone3" : @"\U0001f6c0\U0001f3fd",
        @"bath_tone4" : @"\U0001f6c0\U0001f3fe",
        @"bath_tone5" : @"\U0001f6c0\U0001f3ff",
        @"bellhop" : @"\U0001f6ce",
        @"key" : @"\U0001f511",
        @"key2" : @"\U0001f5dd",
        @"door" : @"\U0001f6aa",
        @"couch" : @"\U0001f6cb",
        @"bed" : @"\U0001f6cf",
        @"sleeping_accommodation" : @"\U0001f6cc",
        @"person_in_bed_tone1" : @"\U0001f6cc\U0001f3fb",
        @"person_in_bed_tone2" : @"\U0001f6cc\U0001f3fc",
        @"person_in_bed_tone3" : @"\U0001f6cc\U0001f3fd",
        @"person_in_bed_tone4" : @"\U0001f6cc\U0001f3fe",
        @"person_in_bed_tone5" : @"\U0001f6cc\U0001f3ff",
        @"frame_photo" : @"\U0001f5bc",
        @"shopping_bags" : @"\U0001f6cd",
        @"shopping_cart" : @"\U0001f6d2",
        @"gift" : @"\U0001f381",
        @"balloon" : @"\U0001f388",
        @"flags" : @"\U0001f38f",
        @"ribbon" : @"\U0001f380",
        @"confetti_ball" : @"\U0001f38a",
        @"tada" : @"\U0001f389",
        @"dolls" : @"\U0001f38e",
        @"izakaya_lantern" : @"\U0001f3ee",
        @"wind_chime" : @"\U0001f390",
        @"envelope_with_arrow" : @"\U0001f4e9",
        @"incoming_envelope" : @"\U0001f4e8",
        @"e-mail" : @"\U0001f4e7",
        @"love_letter" : @"\U0001f48c",
        @"inbox_tray" : @"\U0001f4e5",
        @"outbox_tray" : @"\U0001f4e4",
        @"package" : @"\U0001f4e6",
        @"label" : @"\U0001f3f7",
        @"mailbox_closed" : @"\U0001f4ea",
        @"mailbox" : @"\U0001f4eb",
        @"mailbox_with_mail" : @"\U0001f4ec",
        @"mailbox_with_no_mail" : @"\U0001f4ed",
        @"postbox" : @"\U0001f4ee",
        @"postal_horn" : @"\U0001f4ef",
        @"scroll" : @"\U0001f4dc",
        @"page_with_curl" : @"\U0001f4c3",
        @"page_facing_up" : @"\U0001f4c4",
        @"bookmark_tabs" : @"\U0001f4d1",
        @"bar_chart" : @"\U0001f4ca",
        @"chart_with_upwards_trend" : @"\U0001f4c8",
        @"chart_with_downwards_trend" : @"\U0001f4c9",
        @"notepad_spiral" : @"\U0001f5d2",
        @"calendar_spiral" : @"\U0001f5d3",
        @"calendar" : @"\U0001f4c6",
        @"date" : @"\U0001f4c5",
        @"card_index" : @"\U0001f4c7",
        @"card_box" : @"\U0001f5c3",
        @"ballot_box" : @"\U0001f5f3",
        @"file_cabinet" : @"\U0001f5c4",
        @"clipboard" : @"\U0001f4cb",
        @"file_folder" : @"\U0001f4c1",
        @"open_file_folder" : @"\U0001f4c2",
        @"dividers" : @"\U0001f5c2",
        @"newspaper2" : @"\U0001f5de",
        @"newspaper" : @"\U0001f4f0",
        @"notebook" : @"\U0001f4d3",
        @"notebook_with_decorative_cover" : @"\U0001f4d4",
        @"ledger" : @"\U0001f4d2",
        @"closed_book" : @"\U0001f4d5",
        @"green_book" : @"\U0001f4d7",
        @"blue_book" : @"\U0001f4d8",
        @"orange_book" : @"\U0001f4d9",
        @"books" : @"\U0001f4da",
        @"book" : @"\U0001f4d6",
        @"bookmark" : @"\U0001f516",
        @"link" : @"\U0001f517",
        @"paperclip" : @"\U0001f4ce",
        @"paperclips" : @"\U0001f587",
        @"triangular_ruler" : @"\U0001f4d0",
        @"straight_ruler" : @"\U0001f4cf",
        @"pushpin" : @"\U0001f4cc",
        @"round_pushpin" : @"\U0001f4cd",
        @"pen_ballpoint" : @"\U0001f58a",
        @"pen_fountain" : @"\U0001f58b",
        @"paintbrush" : @"\U0001f58c",
        @"crayon" : @"\U0001f58d",
        @"pencil" : @"\U0001f4dd",
        @"pencil2" : @"\U0000270f",
        @"mag" : @"\U0001f50d",
        @"mag_right" : @"\U0001f50e",
        @"lock_with_ink_pen" : @"\U0001f50f",
        @"closed_lock_with_key" : @"\U0001f510",
        @"lock" : @"\U0001f512",
        @"unlock" : @"\U0001f513",
        @"orange_heart" : @"\U0001f9e1",
        @"yellow_heart" : @"\U0001f49b",
        @"green_heart" : @"\U0001f49a",
        @"blue_heart" : @"\U0001f499",
        @"purple_heart" : @"\U0001f49c",
        @"black_heart" : @"\U0001f5a4",
        @"broken_heart" : @"\U0001f494",
        @"two_hearts" : @"\U0001f495",
        @"revolving_hearts" : @"\U0001f49e",
        @"heartbeat" : @"\U0001f493",
        @"heartpulse" : @"\U0001f497",
        @"sparkling_heart" : @"\U0001f496",
        @"cupid" : @"\U0001f498",
        @"gift_heart" : @"\U0001f49d",
        @"heart_decoration" : @"\U0001f49f",
        @"peace" : @"\U0000262e",
        @"cross" : @"\U0000271d",
        @"star_and_crescent" : @"\U0000262a",
        @"om_symbol" : @"\U0001f549",
        @"six_pointed_star" : @"\U0001f52f",
        @"menorah" : @"\U0001f54e",
        @"yin_yang" : @"\U0000262f",
        @"place_of_worship" : @"\U0001f6d0",
        @"ophiuchus" : @"\U000026ce",
        @"gemini" : @"\U0000264a",
        @"cancer" : @"\U0000264b",
        @"leo" : @"\U0000264c",
        @"virgo" : @"\U0000264d",
        @"libra" : @"\U0000264e",
        @"scorpius" : @"\U0000264f",
        @"id" : @"\U0001f194",
        @"atom" : @"\U0000269b",
        @"accept" : @"\U0001f251",
        @"mobile_phone_off" : @"\U0001f4f4",
        @"vibration_mode" : @"\U0001f4f3",
        @"u6709" : @"\U0001f236",
        @"u7121" : @"\U0001f21a",
        @"u7533" : @"\U0001f238",
        @"u55b6" : @"\U0001f23a",
        @"u6708" : @"\U0001f237",
        @"vs" : @"\U0001f19a",
        @"white_flower" : @"\U0001f4ae",
        @"ideograph_advantage" : @"\U0001f250",
        @"u5408" : @"\U0001f234",
        @"u6e80" : @"\U0001f235",
        @"u5272" : @"\U0001f239",
        @"u7981" : @"\U0001f232",
        @"a" : @"\U0001f170",
        @"b" : @"\U0001f171",
        @"ab" : @"\U0001f18e",
        @"cl" : @"\U0001f191",
        @"o2" : @"\U0001f17e",
        @"sos" : @"\U0001f198",
        @"x" : @"\U0000274c",
        @"o" : @"\U00002b55",
        @"octagonal_sign" : @"\U0001f6d1",
        @"no_entry" : @"\U000026d4",
        @"name_badge" : @"\U0001f4db",
        @"no_entry_sign" : @"\U0001f6ab",
        @"100" : @"\U0001f4af",
        @"anger" : @"\U0001f4a2",
        @"no_pedestrians" : @"\U0001f6b7",
        @"do_not_litter" : @"\U0001f6af",
        @"no_bicycles" : @"\U0001f6b3",
        @"non-potable_water" : @"\U0001f6b1",
        @"underage" : @"\U0001f51e",
        @"no_mobile_phones" : @"\U0001f4f5",
        @"no_smoking" : @"\U0001f6ad",
        @"bangbang" : @"\U0000203c",
        @"low_brightness" : @"\U0001f505",
        @"high_brightness" : @"\U0001f506",
        @"part_alternation_mark" : @"\U0000303d",
        @"warning" : @"\U000026a0",
        @"children_crossing" : @"\U0001f6b8",
        @"trident" : @"\U0001f531",
        @"fleur-de-lis" : @"\U0000269c",
        @"beginner" : @"\U0001f530",
        @"recycle" : @"\U0000267b",
        @"u6307" : @"\U0001f22f",
        @"chart" : @"\U0001f4b9",
        @"negative_squared_cross_mark" : @"\U0000274e",
        @"globe_with_meridians" : @"\U0001f310",
        @"diamond_shape_with_a_dot_inside" : @"\U0001f4a0",
        @"m" : @"\U000024c2",
        @"cyclone" : @"\U0001f300",
        @"zzz" : @"\U0001f4a4",
        @"atm" : @"\U0001f3e7",
        @"wc" : @"\U0001f6be",
        @"wheelchair" : @"\U0000267f",
        @"parking" : @"\U0001f17f",
        @"u7a7a" : @"\U0001f233",
        @"sa" : @"\U0001f202",
        @"passport_control" : @"\U0001f6c2",
        @"customs" : @"\U0001f6c3",
        @"baggage_claim" : @"\U0001f6c4",
        @"left_luggage" : @"\U0001f6c5",
        @"mens" : @"\U0001f6b9",
        @"womens" : @"\U0001f6ba",
        @"baby_symbol" : @"\U0001f6bc",
        @"restroom" : @"\U0001f6bb",
        @"put_litter_in_its_place" : @"\U0001f6ae",
        @"cinema" : @"\U0001f3a6",
        @"signal_strength" : @"\U0001f4f6",
        @"koko" : @"\U0001f201",
        @"symbols" : @"\U0001f523",
        @"abc" : @"\U0001f524",
        @"abcd" : @"\U0001f521",
        @"capital_abcd" : @"\U0001f520",
        @"ng" : @"\U0001f196",
        @"ok" : @"\U0001f197",
        @"up" : @"\U0001f199",
        @"cool" : @"\U0001f192",
        @"new" : @"\U0001f195",
        @"free" : @"\U0001f193",
        @"zero" : @"0\U000020e3",
        @"one" : @"1\U000020e3",
        @"two" : @"2\U000020e3",
        @"three" : @"3\U000020e3",
        @"four" : @"4\U000020e3",
        @"five" : @"5\U000020e3",
        @"six" : @"6\U000020e3",
        @"seven" : @"7\U000020e3",
        @"eight" : @"8\U000020e3",
        @"nine" : @"9\U000020e3",
        @"keycap_ten" : @"\U0001f51f",
        @"1234" : @"\U0001f522",
        @"hash" : @"#\U000020e3",
        @"asterisk" : @"\U0000002a\U000020e3",
        @"arrow_forward" : @"\U000025b6",
        @"pause_button" : @"\U000023f8",
        @"play_pause" : @"\U000023ef",
        @"stop_button" : @"\U000023f9",
        @"record_button" : @"\U000023fa",
        @"eject" : @"\U000023cf",
        @"track_next" : @"\U000023ed",
        @"track_previous" : @"\U000023ee",
        @"fast_forward" : @"\U000023e9",
        @"rewind" : @"\U000023ea",
        @"arrow_double_up" : @"\U000023eb",
        @"arrow_double_down" : @"\U000023ec",
        @"arrow_backward" : @"\U000025c0",
        @"arrow_up_small" : @"\U0001f53c",
        @"arrow_down_small" : @"\U0001f53d",
        @"arrow_right" : @"\U000027a1",
        @"arrow_left" : @"\U00002b05",
        @"arrow_up" : @"\U00002b06",
        @"arrow_down" : @"\U00002b07",
        @"arrow_right_hook" : @"\U000021aa",
        @"leftwards_arrow_with_hook" : @"\U000021a9",
        @"twisted_rightwards_arrows" : @"\U0001f500",
        @"repeat" : @"\U0001f501",
        @"repeat_one" : @"\U0001f502",
        @"arrows_counterclockwise" : @"\U0001f504",
        @"arrows_clockwise" : @"\U0001f503",
        @"musical_note" : @"\U0001f3b5",
        @"notes" : @"\U0001f3b6",
        @"heavy_dollar_sign" : @"\U0001f4b2",
        @"currency_exchange" : @"\U0001f4b1",
        @"copyright" : @"\U000000a9",
        @"registered" : @"\U000000ae",
        @"curly_loop" : @"\U000027b0",
        @"loop" : @"\U000027bf",
        @"end" : @"\U0001f51a",
        @"back" : @"\U0001f519",
        @"on" : @"\U0001f51b",
        @"top" : @"\U0001f51d",
        @"soon" : @"\U0001f51c",
        @"radio_button" : @"\U0001f518",
        @"white_circle" : @"\U000026aa",
        @"black_circle" : @"\U000026ab",
        @"red_circle" : @"\U0001f534",
        @"blue_circle" : @"\U0001f535",
        @"small_red_triangle" : @"\U0001f53a",
        @"small_red_triangle_down" : @"\U0001f53b",
        @"small_orange_diamond" : @"\U0001f538",
        @"small_blue_diamond" : @"\U0001f539",
        @"large_orange_diamond" : @"\U0001f536",
        @"large_blue_diamond" : @"\U0001f537",
        @"white_square_button" : @"\U0001f533",
        @"black_square_button" : @"\U0001f532",
        @"black_small_square" : @"\U000025aa",
        @"white_small_square" : @"\U000025ab",
        @"black_medium_small_square" : @"\U000025fe",
        @"white_medium_small_square" : @"\U000025fd",
        @"black_medium_square" : @"\U000025fc",
        @"white_medium_square" : @"\U000025fb",
        @"black_large_square" : @"\U00002b1b",
        @"white_large_square" : @"\U00002b1c",
        @"speaker" : @"\U0001f508",
        @"mute" : @"\U0001f507",
        @"sound" : @"\U0001f509",
        @"loud_sound" : @"\U0001f50a",
        @"bell" : @"\U0001f514",
        @"no_bell" : @"\U0001f515",
        @"mega" : @"\U0001f4e3",
        @"loudspeaker" : @"\U0001f4e2",
        @"speech_left" : @"\U0001f5e8",
        @"eye_in_speech_bubble" : @"\U0001f441\U0001f5e8",
        @"speech_balloon" : @"\U0001f4ac",
        @"thought_balloon" : @"\U0001f4ad",
        @"anger_right" : @"\U0001f5ef",
        @"black_joker" : @"\U0001f0cf",
        @"flower_playing_cards" : @"\U0001f3b4",
        @"mahjong" : @"\U0001f004",
        @"clock1" : @"\U0001f550",
        @"clock2" : @"\U0001f551",
        @"clock3" : @"\U0001f552",
        @"clock4" : @"\U0001f553",
        @"clock5" : @"\U0001f554",
        @"clock6" : @"\U0001f555",
        @"clock7" : @"\U0001f556",
        @"clock8" : @"\U0001f557",
        @"clock9" : @"\U0001f558",
        @"clock10" : @"\U0001f559",
        @"clock11" : @"\U0001f55a",
        @"clock12" : @"\U0001f55b",
        @"clock130" : @"\U0001f55c",
        @"clock230" : @"\U0001f55d",
        @"clock330" : @"\U0001f55e",
        @"clock430" : @"\U0001f55f",
        @"clock530" : @"\U0001f560",
        @"clock630" : @"\U0001f561",
        @"clock730" : @"\U0001f562",
        @"clock830" : @"\U0001f563",
        @"clock930" : @"\U0001f564",
        @"clock1030" : @"\U0001f565",
        @"clock1130" : @"\U0001f566",
        @"clock1230" : @"\U0001f567",
        @"flag_white" : @"\U0001f3f3",
        @"flag_black" : @"\U0001f3f4",
        @"checkered_flag" : @"\U0001f3c1",
        @"triangular_flag_on_post" : @"\U0001f6a9",
        @"rainbow_flag" : @"\U0001f3f3\U0001f308",
        @"flag_af" : @"\U0001f1e6\U0001f1eb",
        @"flag_ax" : @"\U0001f1e6\U0001f1fd",
        @"flag_al" : @"\U0001f1e6\U0001f1f1",
        @"flag_dz" : @"\U0001f1e9\U0001f1ff",
        @"flag_as" : @"\U0001f1e6\U0001f1f8",
        @"flag_ad" : @"\U0001f1e6\U0001f1e9",
        @"flag_ao" : @"\U0001f1e6\U0001f1f4",
        @"flag_ai" : @"\U0001f1e6\U0001f1ee",
        @"flag_aq" : @"\U0001f1e6\U0001f1f6",
        @"flag_ag" : @"\U0001f1e6\U0001f1ec",
        @"flag_ar" : @"\U0001f1e6\U0001f1f7",
        @"flag_am" : @"\U0001f1e6\U0001f1f2",
        @"flag_aw" : @"\U0001f1e6\U0001f1fc",
        @"flag_au" : @"\U0001f1e6\U0001f1fa",
        @"flag_at" : @"\U0001f1e6\U0001f1f9",
        @"flag_az" : @"\U0001f1e6\U0001f1ff",
        @"flag_bs" : @"\U0001f1e7\U0001f1f8",
        @"flag_bh" : @"\U0001f1e7\U0001f1ed",
        @"flag_bd" : @"\U0001f1e7\U0001f1e9",
        @"flag_bb" : @"\U0001f1e7\U0001f1e7",
        @"flag_by" : @"\U0001f1e7\U0001f1fe",
        @"flag_be" : @"\U0001f1e7\U0001f1ea",
        @"flag_bz" : @"\U0001f1e7\U0001f1ff",
        @"flag_bj" : @"\U0001f1e7\U0001f1ef",
        @"flag_bm" : @"\U0001f1e7\U0001f1f2",
        @"flag_bt" : @"\U0001f1e7\U0001f1f9",
        @"flag_bo" : @"\U0001f1e7\U0001f1f4",
        @"flag_ba" : @"\U0001f1e7\U0001f1e6",
        @"flag_bw" : @"\U0001f1e7\U0001f1fc",
        @"flag_br" : @"\U0001f1e7\U0001f1f7",
        @"flag_io" : @"\U0001f1ee\U0001f1f4",
        @"flag_vg" : @"\U0001f1fb\U0001f1ec",
        @"flag_bn" : @"\U0001f1e7\U0001f1f3",
        @"flag_bg" : @"\U0001f1e7\U0001f1ec",
        @"flag_bf" : @"\U0001f1e7\U0001f1eb",
        @"flag_bi" : @"\U0001f1e7\U0001f1ee",
        @"flag_kh" : @"\U0001f1f0\U0001f1ed",
        @"flag_cm" : @"\U0001f1e8\U0001f1f2",
        @"flag_ca" : @"\U0001f1e8\U0001f1e6",
        @"flag_ic" : @"\U0001f1ee\U0001f1e8",
        @"flag_cv" : @"\U0001f1e8\U0001f1fb",
        @"flag_bq" : @"\U0001f1e7\U0001f1f6",
        @"flag_ky" : @"\U0001f1f0\U0001f1fe",
        @"flag_cf" : @"\U0001f1e8\U0001f1eb",
        @"flag_td" : @"\U0001f1f9\U0001f1e9",
        @"flag_cl" : @"\U0001f1e8\U0001f1f1",
        @"flag_cn" : @"\U0001f1e8\U0001f1f3",
        @"flag_cx" : @"\U0001f1e8\U0001f1fd",
        @"flag_cc" : @"\U0001f1e8\U0001f1e8",
        @"flag_co" : @"\U0001f1e8\U0001f1f4",
        @"flag_km" : @"\U0001f1f0\U0001f1f2",
        @"flag_cg" : @"\U0001f1e8\U0001f1ec",
        @"flag_cd" : @"\U0001f1e8\U0001f1e9",
        @"flag_ck" : @"\U0001f1e8\U0001f1f0",
        @"flag_cr" : @"\U0001f1e8\U0001f1f7",
        @"flag_ci" : @"\U0001f1e8\U0001f1ee",
        @"flag_hr" : @"\U0001f1ed\U0001f1f7",
        @"flag_cu" : @"\U0001f1e8\U0001f1fa",
        @"flag_cw" : @"\U0001f1e8\U0001f1fc",
        @"flag_cy" : @"\U0001f1e8\U0001f1fe",
        @"flag_cz" : @"\U0001f1e8\U0001f1ff",
        @"flag_dk" : @"\U0001f1e9\U0001f1f0",
        @"flag_dj" : @"\U0001f1e9\U0001f1ef",
        @"flag_dm" : @"\U0001f1e9\U0001f1f2",
        @"flag_do" : @"\U0001f1e9\U0001f1f4",
        @"flag_ec" : @"\U0001f1ea\U0001f1e8",
        @"flag_eg" : @"\U0001f1ea\U0001f1ec",
        @"flag_sv" : @"\U0001f1f8\U0001f1fb",
        @"flag_gq" : @"\U0001f1ec\U0001f1f6",
        @"flag_er" : @"\U0001f1ea\U0001f1f7",
        @"flag_ee" : @"\U0001f1ea\U0001f1ea",
        @"flag_et" : @"\U0001f1ea\U0001f1f9",
        @"flag_eu" : @"\U0001f1ea\U0001f1fa",
        @"flag_fk" : @"\U0001f1eb\U0001f1f0",
        @"flag_fo" : @"\U0001f1eb\U0001f1f4",
        @"flag_fj" : @"\U0001f1eb\U0001f1ef",
        @"flag_fi" : @"\U0001f1eb\U0001f1ee",
        @"flag_fr" : @"\U0001f1eb\U0001f1f7",
        @"flag_gf" : @"\U0001f1ec\U0001f1eb",
        @"flag_pf" : @"\U0001f1f5\U0001f1eb",
        @"flag_tf" : @"\U0001f1f9\U0001f1eb",
        @"flag_ga" : @"\U0001f1ec\U0001f1e6",
        @"flag_gm" : @"\U0001f1ec\U0001f1f2",
        @"flag_ge" : @"\U0001f1ec\U0001f1ea",
        @"flag_de" : @"\U0001f1e9\U0001f1ea",
        @"flag_gh" : @"\U0001f1ec\U0001f1ed",
        @"flag_gi" : @"\U0001f1ec\U0001f1ee",
        @"flag_gr" : @"\U0001f1ec\U0001f1f7",
        @"flag_gl" : @"\U0001f1ec\U0001f1f1",
        @"flag_gd" : @"\U0001f1ec\U0001f1e9",
        @"flag_gp" : @"\U0001f1ec\U0001f1f5",
        @"flag_gu" : @"\U0001f1ec\U0001f1fa",
        @"flag_gt" : @"\U0001f1ec\U0001f1f9",
        @"flag_gg" : @"\U0001f1ec\U0001f1ec",
        @"flag_gn" : @"\U0001f1ec\U0001f1f3",
        @"flag_gw" : @"\U0001f1ec\U0001f1fc",
        @"flag_gy" : @"\U0001f1ec\U0001f1fe",
        @"flag_ht" : @"\U0001f1ed\U0001f1f9",
        @"flag_hn" : @"\U0001f1ed\U0001f1f3",
        @"flag_hk" : @"\U0001f1ed\U0001f1f0",
        @"flag_hu" : @"\U0001f1ed\U0001f1fa",
        @"flag_is" : @"\U0001f1ee\U0001f1f8",
        @"flag_in" : @"\U0001f1ee\U0001f1f3",
        @"flag_id" : @"\U0001f1ee\U0001f1e9",
        @"flag_ir" : @"\U0001f1ee\U0001f1f7",
        @"flag_iq" : @"\U0001f1ee\U0001f1f6",
        @"flag_ie" : @"\U0001f1ee\U0001f1ea",
        @"flag_im" : @"\U0001f1ee\U0001f1f2",
        @"flag_il" : @"\U0001f1ee\U0001f1f1",
        @"flag_it" : @"\U0001f1ee\U0001f1f9",
        @"flag_jm" : @"\U0001f1ef\U0001f1f2",
        @"flag_jp" : @"\U0001f1ef\U0001f1f5",
        @"crossed_flags" : @"\U0001f38c",
        @"flag_je" : @"\U0001f1ef\U0001f1ea",
        @"flag_jo" : @"\U0001f1ef\U0001f1f4",
        @"flag_kz" : @"\U0001f1f0\U0001f1ff",
        @"flag_ke" : @"\U0001f1f0\U0001f1ea",
        @"flag_ki" : @"\U0001f1f0\U0001f1ee",
        @"flag_xk" : @"\U0001f1fd\U0001f1f0",
        @"flag_kw" : @"\U0001f1f0\U0001f1fc",
        @"flag_kg" : @"\U0001f1f0\U0001f1ec",
        @"flag_la" : @"\U0001f1f1\U0001f1e6",
        @"flag_lv" : @"\U0001f1f1\U0001f1fb",
        @"flag_lb" : @"\U0001f1f1\U0001f1e7",
        @"flag_ls" : @"\U0001f1f1\U0001f1f8",
        @"flag_lr" : @"\U0001f1f1\U0001f1f7",
        @"flag_ly" : @"\U0001f1f1\U0001f1fe",
        @"flag_li" : @"\U0001f1f1\U0001f1ee",
        @"flag_lt" : @"\U0001f1f1\U0001f1f9",
        @"flag_lu" : @"\U0001f1f1\U0001f1fa",
        @"flag_mo" : @"\U0001f1f2\U0001f1f4",
        @"flag_mk" : @"\U0001f1f2\U0001f1f0",
        @"flag_mg" : @"\U0001f1f2\U0001f1ec",
        @"flag_mw" : @"\U0001f1f2\U0001f1fc",
        @"flag_my" : @"\U0001f1f2\U0001f1fe",
        @"flag_mv" : @"\U0001f1f2\U0001f1fb",
        @"flag_ml" : @"\U0001f1f2\U0001f1f1",
        @"flag_mt" : @"\U0001f1f2\U0001f1f9",
        @"flag_mh" : @"\U0001f1f2\U0001f1ed",
        @"flag_mq" : @"\U0001f1f2\U0001f1f6",
        @"flag_mr" : @"\U0001f1f2\U0001f1f7",
        @"flag_mu" : @"\U0001f1f2\U0001f1fa",
        @"flag_yt" : @"\U0001f1fe\U0001f1f9",
        @"flag_mx" : @"\U0001f1f2\U0001f1fd",
        @"flag_fm" : @"\U0001f1eb\U0001f1f2",
        @"flag_md" : @"\U0001f1f2\U0001f1e9",
        @"flag_mc" : @"\U0001f1f2\U0001f1e8",
        @"flag_mn" : @"\U0001f1f2\U0001f1f3",
        @"flag_me" : @"\U0001f1f2\U0001f1ea",
        @"flag_ms" : @"\U0001f1f2\U0001f1f8",
        @"flag_ma" : @"\U0001f1f2\U0001f1e6",
        @"flag_mz" : @"\U0001f1f2\U0001f1ff",
        @"flag_mm" : @"\U0001f1f2\U0001f1f2",
        @"flag_na" : @"\U0001f1f3\U0001f1e6",
        @"flag_nr" : @"\U0001f1f3\U0001f1f7",
        @"flag_np" : @"\U0001f1f3\U0001f1f5",
        @"flag_nl" : @"\U0001f1f3\U0001f1f1",
        @"flag_nc" : @"\U0001f1f3\U0001f1e8",
        @"flag_nz" : @"\U0001f1f3\U0001f1ff",
        @"flag_ni" : @"\U0001f1f3\U0001f1ee",
        @"flag_ne" : @"\U0001f1f3\U0001f1ea",
        @"flag_ng" : @"\U0001f1f3\U0001f1ec",
        @"flag_nu" : @"\U0001f1f3\U0001f1fa",
        @"flag_nf" : @"\U0001f1f3\U0001f1eb",
        @"flag_kp" : @"\U0001f1f0\U0001f1f5",
        @"flag_mp" : @"\U0001f1f2\U0001f1f5",
        @"flag_no" : @"\U0001f1f3\U0001f1f4",
        @"flag_om" : @"\U0001f1f4\U0001f1f2",
        @"flag_pk" : @"\U0001f1f5\U0001f1f0",
        @"flag_pw" : @"\U0001f1f5\U0001f1fc",
        @"flag_ps" : @"\U0001f1f5\U0001f1f8",
        @"flag_pa" : @"\U0001f1f5\U0001f1e6",
        @"flag_pg" : @"\U0001f1f5\U0001f1ec",
        @"flag_py" : @"\U0001f1f5\U0001f1fe",
        @"flag_pe" : @"\U0001f1f5\U0001f1ea",
        @"flag_ph" : @"\U0001f1f5\U0001f1ed",
        @"flag_pn" : @"\U0001f1f5\U0001f1f3",
        @"flag_pl" : @"\U0001f1f5\U0001f1f1",
        @"flag_pt" : @"\U0001f1f5\U0001f1f9",
        @"flag_pr" : @"\U0001f1f5\U0001f1f7",
        @"flag_qa" : @"\U0001f1f6\U0001f1e6",
        @"flag_re" : @"\U0001f1f7\U0001f1ea",
        @"flag_ro" : @"\U0001f1f7\U0001f1f4",
        @"flag_ru" : @"\U0001f1f7\U0001f1fa",
        @"flag_rw" : @"\U0001f1f7\U0001f1fc",
        @"flag_ws" : @"\U0001f1fc\U0001f1f8",
        @"flag_sm" : @"\U0001f1f8\U0001f1f2",
        @"flag_st" : @"\U0001f1f8\U0001f1f9",
        @"flag_sa" : @"\U0001f1f8\U0001f1e6",
        @"flag_sn" : @"\U0001f1f8\U0001f1f3",
        @"flag_rs" : @"\U0001f1f7\U0001f1f8",
        @"flag_sc" : @"\U0001f1f8\U0001f1e8",
        @"flag_sl" : @"\U0001f1f8\U0001f1f1",
        @"flag_sg" : @"\U0001f1f8\U0001f1ec",
        @"flag_sx" : @"\U0001f1f8\U0001f1fd",
        @"flag_sk" : @"\U0001f1f8\U0001f1f0",
        @"flag_si" : @"\U0001f1f8\U0001f1ee",
        @"flag_gs" : @"\U0001f1ec\U0001f1f8",
        @"flag_sb" : @"\U0001f1f8\U0001f1e7",
        @"flag_so" : @"\U0001f1f8\U0001f1f4",
        @"flag_za" : @"\U0001f1ff\U0001f1e6",
        @"flag_kr" : @"\U0001f1f0\U0001f1f7",
        @"flag_ss" : @"\U0001f1f8\U0001f1f8",
        @"flag_es" : @"\U0001f1ea\U0001f1f8",
        @"flag_lk" : @"\U0001f1f1\U0001f1f0",
        @"flag_bl" : @"\U0001f1e7\U0001f1f1",
        @"flag_sh" : @"\U0001f1f8\U0001f1ed",
        @"flag_kn" : @"\U0001f1f0\U0001f1f3",
        @"flag_lc" : @"\U0001f1f1\U0001f1e8",
        @"flag_pm" : @"\U0001f1f5\U0001f1f2",
        @"flag_vc" : @"\U0001f1fb\U0001f1e8",
        @"flag_sd" : @"\U0001f1f8\U0001f1e9",
        @"flag_sr" : @"\U0001f1f8\U0001f1f7",
        @"flag_sz" : @"\U0001f1f8\U0001f1ff",
        @"flag_se" : @"\U0001f1f8\U0001f1ea",
        @"flag_ch" : @"\U0001f1e8\U0001f1ed",
        @"flag_sy" : @"\U0001f1f8\U0001f1fe",
        @"flag_tw" : @"\U0001f1f9\U0001f1fc",
        @"flag_tj" : @"\U0001f1f9\U0001f1ef",
        @"flag_tz" : @"\U0001f1f9\U0001f1ff",
        @"flag_th" : @"\U0001f1f9\U0001f1ed",
        @"flag_tl" : @"\U0001f1f9\U0001f1f1",
        @"flag_tg" : @"\U0001f1f9\U0001f1ec",
        @"flag_tk" : @"\U0001f1f9\U0001f1f0",
        @"flag_to" : @"\U0001f1f9\U0001f1f4",
        @"flag_tt" : @"\U0001f1f9\U0001f1f9",
        @"flag_tn" : @"\U0001f1f9\U0001f1f3",
        @"flag_tr" : @"\U0001f1f9\U0001f1f7",
        @"flag_tm" : @"\U0001f1f9\U0001f1f2",
        @"flag_tc" : @"\U0001f1f9\U0001f1e8",
        @"flag_tv" : @"\U0001f1f9\U0001f1fb",
        @"flag_vi" : @"\U0001f1fb\U0001f1ee",
        @"flag_ug" : @"\U0001f1fa\U0001f1ec",
        @"flag_ua" : @"\U0001f1fa\U0001f1e6",
        @"flag_ae" : @"\U0001f1e6\U0001f1ea",
        @"flag_gb" : @"\U0001f1ec\U0001f1e7",
        @"flag_us" : @"\U0001f1fa\U0001f1f8",
        @"flag_uy" : @"\U0001f1fa\U0001f1fe",
        @"flag_uz" : @"\U0001f1fa\U0001f1ff",
        @"flag_vu" : @"\U0001f1fb\U0001f1fa",
        @"flag_va" : @"\U0001f1fb\U0001f1e6",
        @"flag_ve" : @"\U0001f1fb\U0001f1ea",
        @"flag_vn" : @"\U0001f1fb\U0001f1f3",
        @"flag_wf" : @"\U0001f1fc\U0001f1eb",
        @"flag_eh" : @"\U0001f1ea\U0001f1ed",
        @"flag_ye" : @"\U0001f1fe\U0001f1ea",
        @"flag_zm" : @"\U0001f1ff\U0001f1f2",
        @"flag_zw" : @"\U0001f1ff\U0001f1fc",
        @"flag_ac" : @"\U0001f1e6\U0001f1e8",
        @"flag_ta" : @"\U0001f1f9\U0001f1e6",
        @"flag_bv" : @"\U0001f1e7\U0001f1fb",
        @"flag_hm" : @"\U0001f1ed\U0001f1f2",
        @"flag_sj" : @"\U0001f1f8\U0001f1ef",
        @"flag_um" : @"\U0001f1fa\U0001f1f2",
        @"flag_ea" : @"\U0001f1ea\U0001f1e6",
        @"flag_cp" : @"\U0001f1e8\U0001f1f5",
        @"flag_dg" : @"\U0001f1e9\U0001f1ec",
        @"flag_mf" : @"\U0001f1f2\U0001f1eb",
        @"united_nations" : @"\U0001f1fa\U0001f1f3",
        @"england" : @"\U0001f3f4\U000e0067\U000e0062\U000e0065\U000e006e\U000e0067\U000e007f",
        @"scotland" : @"\U0001f3f4\U000e0067\U000e0062\U000e0073\U000e0063\U000e0074\U000e007f",
        @"wales" : @"\U0001f3f4\U000e0067\U000e0062\U000e0077\U000e006c\U000e0073\U000e007f",
        @"asterisk_symbol" : @"\U0000002a",
        @"regional_indicator_z" : @"\U0001f1ff",
        @"regional_indicator_y" : @"\U0001f1fe",
        @"regional_indicator_x" : @"\U0001f1fd",
        @"pound_symbol" : @"#",
        @"tone1" : @"\U0001f3fb",
        @"tone2" : @"\U0001f3fc",
        @"tone3" : @"\U0001f3fd",
        @"tone4" : @"\U0001f3fe",
        @"tone5" : @"\U0001f3ff",
        @"regional_indicator_w" : @"\U0001f1fc",
        @"regional_indicator_v" : @"\U0001f1fb",
        @"regional_indicator_u" : @"\U0001f1fa",
        @"regional_indicator_t" : @"\U0001f1f9",
        @"regional_indicator_s" : @"\U0001f1f8",
        @"regional_indicator_r" : @"\U0001f1f7",
        @"regional_indicator_q" : @"\U0001f1f6",
        @"regional_indicator_p" : @"\U0001f1f5",
        @"regional_indicator_o" : @"\U0001f1f4",
        @"regional_indicator_n" : @"\U0001f1f3",
        @"regional_indicator_m" : @"\U0001f1f2",
        @"regional_indicator_l" : @"\U0001f1f1",
        @"regional_indicator_k" : @"\U0001f1f0",
        @"regional_indicator_j" : @"\U0001f1ef",
        @"regional_indicator_i" : @"\U0001f1ee",
        @"regional_indicator_h" : @"\U0001f1ed",
        @"regional_indicator_g" : @"\U0001f1ec",
        @"regional_indicator_f" : @"\U0001f1eb",
        @"regional_indicator_e" : @"\U0001f1ea",
        @"regional_indicator_d" : @"\U0001f1e9",
        @"regional_indicator_c" : @"\U0001f1e8",
        @"regional_indicator_b" : @"\U0001f1e7",
        @"regional_indicator_a" : @"\U0001f1e6",
        @"digit_nine" : @"9",
        @"digit_eight" : @"8",
        @"digit_seven" : @"7",
        @"digit_six" : @"6",
        @"digit_five" : @"5",
        @"digit_four" : @"4",
        @"digit_three" : @"3",
        @"digit_two" : @"2",
        @"digit_one" : @"1",
        @"digit_zero" : @"0",
        @"family_man_woman_boy" : @"\U0001f468\U0001f469\U0001f466",
        @"couple_with_heart_woman_man" : @"\U0001f469\U00002764\U0001f468",
        @"kiss_woman_man" : @"\U0001f469\U00002764\U0001f48b\U0001f468",
        @"face_with_raised_eyebrow" : @"\U0001f928",
        @"star_struck" : @"\U0001f929",
        @"crazy_face" : @"\U0001f92a",
        @"shushing_face" : @"\U0001f92b",
        @"face_with_symbols_over_mouth" : @"\U0001f92c",
        @"face_with_hand_over_mouth" : @"\U0001f92d",
        @"face_vomiting" : @"\U0001f92e",
        @"exploding_head" : @"\U0001f92f",
        @"face_with_monocle" : @"\U0001f9d0",
        @"adult" : @"\U0001f9d1",
        @"child" : @"\U0001f9d2",
        @"older_adult" : @"\U0001f9d3",
        @"bearded_person" : @"\U0001f9d4",
        @"woman_with_headscarf" : @"\U0001f9d5",
        @"brain" : @"\U0001f9e0",
        @"billed_cap" : @"\U0001f9e2",
        @"mage" : @"\U0001f9d9",
        @"fairy" : @"\U0001f9da",
        @"vampire" : @"\U0001f9db",
        @"merperson" : @"\U0001f9dc",
        @"elf" : @"\U0001f9dd",
        @"genie" : @"\U0001f9de",
        @"zombie" : @"\U0001f9df",
        @"scarf" : @"\U0001f9e3",
        @"gloves" : @"\U0001f9e4",
        @"coat" : @"\U0001f9e5",
        @"socks" : @"\U0001f9e6",
        @"love_you_gesture" : @"\U0001f91f",
        @"love_you_gesture_tone1" : @"\U0001f91f\U0001f3fb",
        @"love_you_gesture_tone2" : @"\U0001f91f\U0001f3fc",
        @"love_you_gesture_tone3" : @"\U0001f91f\U0001f3fd",
        @"love_you_gesture_tone4" : @"\U0001f91f\U0001f3fe",
        @"love_you_gesture_tone5" : @"\U0001f91f\U0001f3ff",
        @"palms_up_together" : @"\U0001f932",
        @"palms_up_together_tone1" : @"\U0001f932\U0001f3fb",
        @"palms_up_together_tone2" : @"\U0001f932\U0001f3fc",
        @"palms_up_together_tone3" : @"\U0001f932\U0001f3fd",
        @"palms_up_together_tone4" : @"\U0001f932\U0001f3fe",
        @"palms_up_together_tone5" : @"\U0001f932\U0001f3ff",
        @"adult_tone1" : @"\U0001f9d1\U0001f3fb",
        @"adult_tone2" : @"\U0001f9d1\U0001f3fc",
        @"adult_tone3" : @"\U0001f9d1\U0001f3fd",
        @"adult_tone4" : @"\U0001f9d1\U0001f3fe",
        @"adult_tone5" : @"\U0001f9d1\U0001f3ff",
        @"child_tone1" : @"\U0001f9d2\U0001f3fb",
        @"child_tone2" : @"\U0001f9d2\U0001f3fc",
        @"child_tone3" : @"\U0001f9d2\U0001f3fd",
        @"child_tone4" : @"\U0001f9d2\U0001f3fe",
        @"child_tone5" : @"\U0001f9d2\U0001f3ff",
        @"older_adult_tone1" : @"\U0001f9d3\U0001f3fb",
        @"older_adult_tone2" : @"\U0001f9d3\U0001f3fc",
        @"older_adult_tone3" : @"\U0001f9d3\U0001f3fd",
        @"older_adult_tone4" : @"\U0001f9d3\U0001f3fe",
        @"older_adult_tone5" : @"\U0001f9d3\U0001f3ff",
        @"bearded_person_tone1" : @"\U0001f9d4\U0001f3fb",
        @"bearded_person_tone2" : @"\U0001f9d4\U0001f3fc",
        @"bearded_person_tone3" : @"\U0001f9d4\U0001f3fd",
        @"bearded_person_tone4" : @"\U0001f9d4\U0001f3fe",
        @"bearded_person_tone5" : @"\U0001f9d4\U0001f3ff",
        @"woman_with_headscarf_tone1" : @"\U0001f9d5\U0001f3fb",
        @"woman_with_headscarf_tone2" : @"\U0001f9d5\U0001f3fc",
        @"woman_with_headscarf_tone3" : @"\U0001f9d5\U0001f3fd",
        @"woman_with_headscarf_tone4" : @"\U0001f9d5\U0001f3fe",
        @"woman_with_headscarf_tone5" : @"\U0001f9d5\U0001f3ff",
        @"mage_tone1" : @"\U0001f9d9\U0001f3fb",
        @"mage_tone2" : @"\U0001f9d9\U0001f3fc",
        @"mage_tone3" : @"\U0001f9d9\U0001f3fd",
        @"mage_tone4" : @"\U0001f9d9\U0001f3fe",
        @"mage_tone5" : @"\U0001f9d9\U0001f3ff",
        @"fairy_tone1" : @"\U0001f9da\U0001f3fb",
        @"fairy_tone2" : @"\U0001f9da\U0001f3fc",
        @"fairy_tone3" : @"\U0001f9da\U0001f3fd",
        @"fairy_tone4" : @"\U0001f9da\U0001f3fe",
        @"fairy_tone5" : @"\U0001f9da\U0001f3ff",
        @"vampire_tone1" : @"\U0001f9db\U0001f3fb",
        @"vampire_tone2" : @"\U0001f9db\U0001f3fc",
        @"vampire_tone3" : @"\U0001f9db\U0001f3fd",
        @"vampire_tone4" : @"\U0001f9db\U0001f3fe",
        @"vampire_tone5" : @"\U0001f9db\U0001f3ff",
        @"merperson_tone1" : @"\U0001f9dc\U0001f3fb",
        @"merperson_tone2" : @"\U0001f9dc\U0001f3fc",
        @"merperson_tone3" : @"\U0001f9dc\U0001f3fd",
        @"merperson_tone4" : @"\U0001f9dc\U0001f3fe",
        @"merperson_tone5" : @"\U0001f9dc\U0001f3ff",
        @"elf_tone1" : @"\U0001f9dd\U0001f3fb",
        @"elf_tone2" : @"\U0001f9dd\U0001f3fc",
        @"elf_tone3" : @"\U0001f9dd\U0001f3fd",
        @"elf_tone4" : @"\U0001f9dd\U0001f3fe",
        @"elf_tone5" : @"\U0001f9dd\U0001f3ff",
        @"woman_mage" : @"\U0001f9d9\U00002640",
        @"man_mage" : @"\U0001f9d9\U00002642",
        @"woman_mage_tone1" : @"\U0001f9d9\U0001f3fb\U00002640",
        @"man_mage_tone1" : @"\U0001f9d9\U0001f3fb\U00002642",
        @"woman_mage_tone2" : @"\U0001f9d9\U0001f3fc\U00002640",
        @"man_mage_tone2" : @"\U0001f9d9\U0001f3fc\U00002642",
        @"woman_mage_tone3" : @"\U0001f9d9\U0001f3fd\U00002640",
        @"man_mage_tone3" : @"\U0001f9d9\U0001f3fd\U00002642",
        @"woman_mage_tone4" : @"\U0001f9d9\U0001f3fe\U00002640",
        @"man_mage_tone4" : @"\U0001f9d9\U0001f3fe\U00002642",
        @"woman_mage_tone5" : @"\U0001f9d9\U0001f3ff\U00002640",
        @"man_mage_tone5" : @"\U0001f9d9\U0001f3ff\U00002642",
        @"woman_fairy" : @"\U0001f9da\U00002640",
        @"man_fairy" : @"\U0001f9da\U00002642",
        @"woman_fairy_tone1" : @"\U0001f9da\U0001f3fb\U00002640",
        @"man_fairy_tone1" : @"\U0001f9da\U0001f3fb\U00002642",
        @"woman_fairy_tone2" : @"\U0001f9da\U0001f3fc\U00002640",
        @"man_fairy_tone2" : @"\U0001f9da\U0001f3fc\U00002642",
        @"woman_fairy_tone3" : @"\U0001f9da\U0001f3fd\U00002640",
        @"man_fairy_tone3" : @"\U0001f9da\U0001f3fd\U00002642",
        @"woman_fairy_tone4" : @"\U0001f9da\U0001f3fe\U00002640",
        @"man_fairy_tone4" : @"\U0001f9da\U0001f3fe\U00002642",
        @"woman_fairy_tone5" : @"\U0001f9da\U0001f3ff\U00002640",
        @"man_fairy_tone5" : @"\U0001f9da\U0001f3ff\U00002642",
        @"woman_vampire" : @"\U0001f9db\U00002640",
        @"man_vampire" : @"\U0001f9db\U00002642",
        @"woman_vampire_tone1" : @"\U0001f9db\U0001f3fb\U00002640",
        @"man_vampire_tone1" : @"\U0001f9db\U0001f3fb\U00002642",
        @"woman_vampire_tone2" : @"\U0001f9db\U0001f3fc\U00002640",
        @"man_vampire_tone2" : @"\U0001f9db\U0001f3fc\U00002642",
        @"woman_vampire_tone3" : @"\U0001f9db\U0001f3fd\U00002640",
        @"man_vampire_tone3" : @"\U0001f9db\U0001f3fd\U00002642",
        @"woman_vampire_tone4" : @"\U0001f9db\U0001f3fe\U00002640",
        @"man_vampire_tone4" : @"\U0001f9db\U0001f3fe\U00002642",
        @"woman_vampire_tone5" : @"\U0001f9db\U0001f3ff\U00002640",
        @"man_vampire_tone5" : @"\U0001f9db\U0001f3ff\U00002642",
        @"mermaid" : @"\U0001f9dc\U00002640",
        @"merman" : @"\U0001f9dc\U00002642",
        @"mermaid_tone1" : @"\U0001f9dc\U0001f3fb\U00002640",
        @"merman_tone1" : @"\U0001f9dc\U0001f3fb\U00002642",
        @"mermaid_tone2" : @"\U0001f9dc\U0001f3fc\U00002640",
        @"merman_tone2" : @"\U0001f9dc\U0001f3fc\U00002642",
        @"mermaid_tone3" : @"\U0001f9dc\U0001f3fd\U00002640",
        @"merman_tone3" : @"\U0001f9dc\U0001f3fd\U00002642",
        @"mermaid_tone4" : @"\U0001f9dc\U0001f3fe\U00002640",
        @"merman_tone4" : @"\U0001f9dc\U0001f3fe\U00002642",
        @"mermaid_tone5" : @"\U0001f9dc\U0001f3ff\U00002640",
        @"merman_tone5" : @"\U0001f9dc\U0001f3ff\U00002642",
        @"woman_elf" : @"\U0001f9dd\U00002640",
        @"man_elf" : @"\U0001f9dd\U00002642",
        @"woman_elf_tone1" : @"\U0001f9dd\U0001f3fb\U00002640",
        @"man_elf_tone1" : @"\U0001f9dd\U0001f3fb\U00002642",
        @"woman_elf_tone2" : @"\U0001f9dd\U0001f3fc\U00002640",
        @"man_elf_tone2" : @"\U0001f9dd\U0001f3fc\U00002642",
        @"woman_elf_tone3" : @"\U0001f9dd\U0001f3fd\U00002640",
        @"man_elf_tone3" : @"\U0001f9dd\U0001f3fd\U00002642",
        @"woman_elf_tone4" : @"\U0001f9dd\U0001f3fe\U00002640",
        @"man_elf_tone4" : @"\U0001f9dd\U0001f3fe\U00002642",
        @"woman_elf_tone5" : @"\U0001f9dd\U0001f3ff\U00002640",
        @"man_elf_tone5" : @"\U0001f9dd\U0001f3ff\U00002642",
        @"woman_genie" : @"\U0001f9de\U00002640",
        @"man_genie" : @"\U0001f9de\U00002642",
        @"woman_zombie" : @"\U0001f9df\U00002640",
        @"man_zombie" : @"\U0001f9df\U00002642",
            };
}

@end
