/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.model;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeMirror;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.apt.model.AnnotationMemberValue;
import org.eclipse.jdt.internal.compiler.apt.model.ExecutableElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.Factory;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class AnnotationMirrorImpl
implements AnnotationMirror,
InvocationHandler {
    public final BaseProcessingEnvImpl _env;
    public final AnnotationBinding _binding;

    AnnotationMirrorImpl(BaseProcessingEnvImpl baseProcessingEnvImpl, AnnotationBinding annotationBinding) {
        this._env = baseProcessingEnvImpl;
        this._binding = annotationBinding;
    }

    public boolean equals(Object object) {
        if (object instanceof AnnotationMirrorImpl) {
            if (this._binding == null) {
                return ((AnnotationMirrorImpl)object)._binding == null;
            }
            return AnnotationMirrorImpl.equals(this._binding, ((AnnotationMirrorImpl)object)._binding);
        }
        return object == null ? false : object.equals(this);
    }

    private static boolean equals(AnnotationBinding annotationBinding, AnnotationBinding annotationBinding2) {
        ElementValuePair[] elementValuePairArray;
        if (annotationBinding.getAnnotationType() != annotationBinding2.getAnnotationType()) {
            return false;
        }
        ElementValuePair[] elementValuePairArray2 = annotationBinding.getElementValuePairs();
        int n = elementValuePairArray2.length;
        if (n != (elementValuePairArray = annotationBinding2.getElementValuePairs()).length) {
            return false;
        }
        block0: for (int i = 0; i < n; ++i) {
            ElementValuePair elementValuePair = elementValuePairArray2[i];
            for (int j = 0; j < n; ++j) {
                ElementValuePair elementValuePair2 = elementValuePairArray[j];
                if (elementValuePair.binding != elementValuePair2.binding) continue;
                if (elementValuePair.value == null) {
                    if (elementValuePair2.value == null) continue block0;
                    return false;
                }
                if (elementValuePair2.value == null) {
                    return false;
                }
                if (!(elementValuePair2.value instanceof Object[] && elementValuePair.value instanceof Object[] ? !Arrays.equals((Object[])elementValuePair.value, (Object[])elementValuePair2.value) : !elementValuePair2.value.equals(elementValuePair.value))) continue block0;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public DeclaredType getAnnotationType() {
        return (DeclaredType)this._env.getFactory().newTypeMirror(this._binding.getAnnotationType());
    }

    @Override
    public Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValues() {
        if (this._binding == null) {
            return Collections.emptyMap();
        }
        ElementValuePair[] elementValuePairArray = this._binding.getElementValuePairs();
        LinkedHashMap<ExecutableElementImpl, AnnotationMemberValue> linkedHashMap = new LinkedHashMap<ExecutableElementImpl, AnnotationMemberValue>(elementValuePairArray.length);
        for (ElementValuePair elementValuePair : elementValuePairArray) {
            MethodBinding methodBinding = elementValuePair.getMethodBinding();
            if (methodBinding == null) continue;
            ExecutableElementImpl executableElementImpl = new ExecutableElementImpl(this._env, methodBinding);
            AnnotationMemberValue annotationMemberValue = new AnnotationMemberValue(this._env, elementValuePair.getValue(), methodBinding);
            linkedHashMap.put(executableElementImpl, annotationMemberValue);
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    public Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValuesWithDefaults() {
        if (this._binding == null) {
            return Collections.emptyMap();
        }
        ElementValuePair[] elementValuePairArray = this._binding.getElementValuePairs();
        ReferenceBinding referenceBinding = this._binding.getAnnotationType();
        LinkedHashMap<Object, Object> linkedHashMap = new LinkedHashMap<Object, Object>();
        for (MethodBinding methodBinding : referenceBinding.methods()) {
            Object object;
            Object object2;
            Object object3;
            boolean bl = false;
            for (int i = 0; i < elementValuePairArray.length; ++i) {
                object3 = elementValuePairArray[i].getMethodBinding();
                if (methodBinding != object3) continue;
                object2 = new ExecutableElementImpl(this._env, (MethodBinding)object3);
                AnnotationMemberValue annotationMemberValue = new AnnotationMemberValue(this._env, elementValuePairArray[i].getValue(), (MethodBinding)object3);
                linkedHashMap.put(object2, annotationMemberValue);
                bl = true;
                break;
            }
            if (bl || null == (object = methodBinding.getDefaultValue())) continue;
            object3 = new ExecutableElementImpl(this._env, methodBinding);
            object2 = new AnnotationMemberValue(this._env, object, methodBinding);
            linkedHashMap.put(object3, object2);
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    public int hashCode() {
        if (this._binding == null) {
            return this._env.hashCode();
        }
        return this._binding.hashCode();
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        ElementValuePair[] elementValuePairArray;
        if (this._binding == null) {
            return null;
        }
        String string = method.getName();
        if (objectArray == null || objectArray.length == 0) {
            if (string.equals("hashCode")) {
                return this.hashCode();
            }
            if (string.equals("toString")) {
                return this.toString();
            }
            if (string.equals("annotationType")) {
                return object.getClass().getInterfaces()[0];
            }
        } else if (objectArray.length == 1 && string.equals("equals")) {
            return this.equals(objectArray[0]);
        }
        if (objectArray != null && objectArray.length != 0) {
            throw new NoSuchMethodException("method " + method.getName() + this.formatArgs(objectArray) + " does not exist on annotation " + this.toString());
        }
        MethodBinding methodBinding = this.getMethodBinding(string);
        if (methodBinding == null) {
            throw new NoSuchMethodException("method " + method.getName() + "() does not exist on annotation" + this.toString());
        }
        Object object2 = null;
        boolean bl = false;
        for (ElementValuePair elementValuePair : elementValuePairArray = this._binding.getElementValuePairs()) {
            if (!string.equals(new String(elementValuePair.getName()))) continue;
            object2 = elementValuePair.getValue();
            bl = true;
            break;
        }
        if (!bl) {
            object2 = methodBinding.getDefaultValue();
        }
        Class<?> clazz = method.getReturnType();
        TypeBinding typeBinding = methodBinding.returnType;
        return this.getReflectionValue(object2, typeBinding, clazz);
    }

    public String toString() {
        DeclaredType declaredType = this.getAnnotationType();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('@');
        stringBuilder.append(declaredType.toString());
        Map<? extends ExecutableElement, ? extends AnnotationValue> map = this.getElementValues();
        if (!map.isEmpty()) {
            stringBuilder.append('(');
            boolean bl = true;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : map.entrySet()) {
                if (!bl) {
                    stringBuilder.append(", ");
                }
                bl = false;
                stringBuilder.append(entry.getKey().getSimpleName());
                stringBuilder.append(" = ");
                stringBuilder.append(entry.getValue().toString());
            }
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    private String formatArgs(Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder(objectArray.length * 8 + 2);
        stringBuilder.append('(');
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(objectArray[i].getClass().getName());
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private MethodBinding getMethodBinding(String string) {
        MethodBinding[] methodBindingArray;
        ReferenceBinding referenceBinding = this._binding.getAnnotationType();
        for (MethodBinding methodBinding : methodBindingArray = referenceBinding.getMethods(string.toCharArray())) {
            if (methodBinding.parameters.length != 0) continue;
            return methodBinding;
        }
        return null;
    }

    private Object getReflectionValue(Object object, TypeBinding typeBinding, Class<?> clazz) {
        if (null == clazz) {
            return null;
        }
        if (null == object) {
            return Factory.getMatchingDummyValue(clazz);
        }
        if (clazz.isArray()) {
            if (Class.class.equals(clazz.getComponentType())) {
                Object object2;
                if (typeBinding.isArrayType() && ((ArrayBinding)typeBinding).leafComponentType.erasure().id == 16 && (object2 = object instanceof Object[] ? (Object[])object : (object instanceof TypeBinding ? new Object[]{object} : null)) != null) {
                    ArrayList<TypeMirror> arrayList = new ArrayList<TypeMirror>(((Object[])object2).length);
                    for (int i = 0; i < ((Object[])object2).length; ++i) {
                        if (!(object2[i] instanceof TypeBinding)) continue;
                        arrayList.add(this._env.getFactory().newTypeMirror((TypeBinding)object2[i]));
                    }
                    throw new MirroredTypesException(arrayList);
                }
                return null;
            }
            return this.convertJDTArrayToReflectionArray(object, typeBinding, clazz);
        }
        if (Class.class.equals(clazz)) {
            if (object instanceof TypeBinding) {
                TypeMirror typeMirror = this._env.getFactory().newTypeMirror((TypeBinding)object);
                throw new MirroredTypeException(typeMirror);
            }
            return null;
        }
        return this.convertJDTValueToReflectionType(object, typeBinding, clazz);
    }

    private Object convertJDTArrayToReflectionArray(Object object, TypeBinding typeBinding, Class<?> clazz) {
        Object[] objectArray;
        assert (null != clazz && clazz.isArray());
        if (!typeBinding.isArrayType()) {
            return null;
        }
        if (object != null && !(object instanceof Object[])) {
            objectArray = (Object[])Array.newInstance(object.getClass(), 1);
            objectArray[0] = object;
        } else {
            objectArray = (Object[])object;
        }
        TypeBinding typeBinding2 = typeBinding.leafComponentType();
        Class<?> clazz2 = clazz.getComponentType();
        int n = objectArray.length;
        Object object2 = Array.newInstance(clazz2, n);
        for (int i = 0; i < n; ++i) {
            Object object3;
            Object object4;
            Object object5 = objectArray[i];
            if (clazz2.isPrimitive() || String.class.equals(clazz2)) {
                if (object5 instanceof Constant) {
                    if (Boolean.TYPE.equals(clazz2)) {
                        Array.setBoolean(object2, i, ((Constant)object5).booleanValue());
                        continue;
                    }
                    if (Byte.TYPE.equals(clazz2)) {
                        Array.setByte(object2, i, ((Constant)object5).byteValue());
                        continue;
                    }
                    if (Character.TYPE.equals(clazz2)) {
                        Array.setChar(object2, i, ((Constant)object5).charValue());
                        continue;
                    }
                    if (Double.TYPE.equals(clazz2)) {
                        Array.setDouble(object2, i, ((Constant)object5).doubleValue());
                        continue;
                    }
                    if (Float.TYPE.equals(clazz2)) {
                        Array.setFloat(object2, i, ((Constant)object5).floatValue());
                        continue;
                    }
                    if (Integer.TYPE.equals(clazz2)) {
                        Array.setInt(object2, i, ((Constant)object5).intValue());
                        continue;
                    }
                    if (Long.TYPE.equals(clazz2)) {
                        Array.setLong(object2, i, ((Constant)object5).longValue());
                        continue;
                    }
                    if (Short.TYPE.equals(clazz2)) {
                        Array.setShort(object2, i, ((Constant)object5).shortValue());
                        continue;
                    }
                    if (!String.class.equals(clazz2)) continue;
                    Array.set(object2, i, ((Constant)object5).stringValue());
                    continue;
                }
                Factory.setArrayMatchingDummyValue(object2, i, clazz2);
                continue;
            }
            if (clazz2.isEnum()) {
                object4 = null;
                if (typeBinding2 != null && typeBinding2.isEnum() && object5 instanceof FieldBinding) {
                    object3 = (FieldBinding)object5;
                    try {
                        Field field = null;
                        field = clazz2.getField(new String(((FieldBinding)object3).name));
                        if (null != field) {
                            object4 = field.get(null);
                        }
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                Array.set(object2, i, object4);
                continue;
            }
            if (clazz2.isAnnotation()) {
                object4 = null;
                if (typeBinding2.isAnnotationType() && object5 instanceof AnnotationBinding) {
                    object3 = (AnnotationMirrorImpl)this._env.getFactory().newAnnotationMirror((AnnotationBinding)object5);
                    object4 = Proxy.newProxyInstance(clazz2.getClassLoader(), new Class[]{clazz2}, (InvocationHandler)object3);
                }
                Array.set(object2, i, object4);
                continue;
            }
            Array.set(object2, i, null);
        }
        return object2;
    }

    private Object convertJDTValueToReflectionType(Object object, TypeBinding typeBinding, Class<?> clazz) {
        if (clazz.isPrimitive() || String.class.equals(clazz)) {
            if (object instanceof Constant) {
                if (Boolean.TYPE.equals(clazz)) {
                    return ((Constant)object).booleanValue();
                }
                if (Byte.TYPE.equals(clazz)) {
                    return ((Constant)object).byteValue();
                }
                if (Character.TYPE.equals(clazz)) {
                    return Character.valueOf(((Constant)object).charValue());
                }
                if (Double.TYPE.equals(clazz)) {
                    return ((Constant)object).doubleValue();
                }
                if (Float.TYPE.equals(clazz)) {
                    return Float.valueOf(((Constant)object).floatValue());
                }
                if (Integer.TYPE.equals(clazz)) {
                    return ((Constant)object).intValue();
                }
                if (Long.TYPE.equals(clazz)) {
                    return ((Constant)object).longValue();
                }
                if (Short.TYPE.equals(clazz)) {
                    return ((Constant)object).shortValue();
                }
                if (String.class.equals(clazz)) {
                    return ((Constant)object).stringValue();
                }
            }
            return Factory.getMatchingDummyValue(clazz);
        }
        if (clazz.isEnum()) {
            Object object2 = null;
            if (typeBinding != null && typeBinding.isEnum() && object instanceof FieldBinding) {
                FieldBinding fieldBinding = (FieldBinding)object;
                try {
                    Field field = null;
                    field = clazz.getField(new String(fieldBinding.name));
                    if (null != field) {
                        object2 = field.get(null);
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            return null == object2 ? Factory.getMatchingDummyValue(clazz) : object2;
        }
        if (clazz.isAnnotation()) {
            if (typeBinding.isAnnotationType() && object instanceof AnnotationBinding) {
                AnnotationMirrorImpl annotationMirrorImpl = (AnnotationMirrorImpl)this._env.getFactory().newAnnotationMirror((AnnotationBinding)object);
                return Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)annotationMirrorImpl);
            }
            return null;
        }
        return Factory.getMatchingDummyValue(clazz);
    }
}

