/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SplitPackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;

public class QualifiedTypeReference
extends TypeReference {
    public char[][] tokens;
    public long[] sourcePositions;

    public QualifiedTypeReference(char[][] cArray, long[] lArray) {
        this.tokens = cArray;
        this.sourcePositions = lArray;
        this.sourceStart = (int)(this.sourcePositions[0] >>> 32);
        this.sourceEnd = (int)(this.sourcePositions[this.sourcePositions.length - 1] & 0xFFFFFFFFL);
    }

    @Override
    public TypeReference augmentTypeWithAdditionalDimensions(int n, Annotation[][] annotationArray, boolean bl) {
        int n2 = this.dimensions() + n;
        Annotation[][] annotationArray2 = this.getMergedAnnotationsOnDimensions(n, annotationArray);
        ArrayQualifiedTypeReference arrayQualifiedTypeReference = new ArrayQualifiedTypeReference(this.tokens, n2, annotationArray2, this.sourcePositions);
        arrayQualifiedTypeReference.annotations = this.annotations;
        arrayQualifiedTypeReference.bits |= this.bits & 0x100000;
        if (!bl) {
            arrayQualifiedTypeReference.extendedDimensions = n;
        }
        return arrayQualifiedTypeReference;
    }

    protected TypeBinding findNextTypeBinding(int n, Scope scope, PackageBinding packageBinding) {
        LookupEnvironment lookupEnvironment = scope.environment();
        try {
            lookupEnvironment.missingClassFileLocation = this;
            if (this.resolvedType == null) {
                this.resolvedType = scope.getType(this.tokens[n], packageBinding);
            } else {
                this.resolvedType = scope.getMemberType(this.tokens[n], (ReferenceBinding)this.resolvedType);
                if (!this.resolvedType.isValidBinding()) {
                    this.resolvedType = new ProblemReferenceBinding(CharOperation.subarray(this.tokens, 0, n + 1), (ReferenceBinding)this.resolvedType.closestMatch(), this.resolvedType.problemId());
                }
            }
            TypeBinding typeBinding = this.resolvedType;
            return typeBinding;
        }
        catch (AbortCompilation abortCompilation) {
            abortCompilation.updateContext(this, scope.referenceCompilationUnit().compilationResult);
            throw abortCompilation;
        }
        finally {
            lookupEnvironment.missingClassFileLocation = null;
        }
    }

    @Override
    public char[] getLastToken() {
        return this.tokens[this.tokens.length - 1];
    }

    protected void rejectAnnotationsOnPackageQualifiers(Scope scope, PackageBinding packageBinding) {
        if (packageBinding == null || this.annotations == null) {
            return;
        }
        int n = packageBinding.compoundName.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] annotationArray = this.annotations[i];
            if (annotationArray == null || annotationArray.length <= 0) continue;
            if (i == 0) {
                for (int j = 0; j < annotationArray.length; ++j) {
                    scope.problemReporter().typeAnnotationAtQualifiedName(annotationArray[j]);
                }
                continue;
            }
            scope.problemReporter().misplacedTypeAnnotations(annotationArray[0], annotationArray[annotationArray.length - 1]);
            this.annotations[i] = null;
        }
    }

    protected static void rejectAnnotationsOnStaticMemberQualififer(Scope scope, ReferenceBinding referenceBinding, Annotation[] annotationArray) {
        if (referenceBinding.isMemberType() && referenceBinding.isStatic() && annotationArray != null && annotationArray.length > 0) {
            scope.problemReporter().illegalTypeAnnotationsInStaticMemberAccess(annotationArray[0], annotationArray[annotationArray.length - 1]);
        }
    }

    @Override
    protected TypeBinding getTypeBinding(Scope scope) {
        int n;
        Object object;
        PackageBinding packageBinding;
        int n2;
        if (this.resolvedType != null) {
            return this.resolvedType;
        }
        Binding binding = scope.getPackage(this.tokens);
        if (this.resolvedType != null) {
            return this.resolvedType;
        }
        if (binding != null && !binding.isValidBinding()) {
            if (binding instanceof ProblemReferenceBinding && binding.problemId() == 1) {
                ProblemReferenceBinding problemReferenceBinding = (ProblemReferenceBinding)binding;
                Binding binding2 = scope.getTypeOrPackage(this.tokens);
                return new ProblemReferenceBinding(problemReferenceBinding.compoundName, binding2 instanceof PackageBinding ? null : scope.environment().createMissingType(null, this.tokens), 1);
            }
            return (ReferenceBinding)binding;
        }
        PackageBinding packageBinding2 = binding == null ? null : (PackageBinding)binding;
        int n3 = n2 = packageBinding2 == null ? 0 : packageBinding2.compoundName.length;
        if (packageBinding2 != null && (packageBinding = packageBinding2.getVisibleFor(scope.module(), false)) instanceof SplitPackageBinding) {
            object = scope.compilerOptions();
            n = ((CompilerOptions)object).enableJdtDebugCompileMode ? 1 : 0;
            if (n == 0) {
                SplitPackageBinding splitPackageBinding = (SplitPackageBinding)packageBinding;
                scope.problemReporter().conflictingPackagesFromModules(splitPackageBinding, scope.module(), this.sourceStart, (int)this.sourcePositions[n2 - 1]);
                this.resolvedType = new ProblemReferenceBinding(this.tokens, null, 3);
                return null;
            }
        }
        this.rejectAnnotationsOnPackageQualifiers(scope, packageBinding2);
        boolean bl = scope.kind == 3;
        object = null;
        int n4 = this.tokens.length;
        int n5 = n4 - 1;
        for (n = n2; n < n4; ++n) {
            this.findNextTypeBinding(n, scope, packageBinding2);
            if (!this.resolvedType.isValidBinding()) {
                return this.resolvedType;
            }
            if (n == 0 && this.resolvedType.isTypeVariable() && ((TypeVariableBinding)this.resolvedType).firstBound == null) {
                scope.problemReporter().illegalAccessFromTypeVariable((TypeVariableBinding)this.resolvedType, this);
                return null;
            }
            if (n <= n5 && this.isTypeUseDeprecated(this.resolvedType, scope)) {
                this.reportDeprecatedType(this.resolvedType, scope, n);
            }
            if (bl && ((ClassScope)scope).detectHierarchyCycle(this.resolvedType, this)) {
                return null;
            }
            ReferenceBinding referenceBinding = (ReferenceBinding)this.resolvedType;
            if (object != null) {
                boolean bl2;
                ReferenceBinding referenceBinding2;
                if (this.annotations != null) {
                    QualifiedTypeReference.rejectAnnotationsOnStaticMemberQualififer(scope, referenceBinding, this.annotations[n - 1]);
                }
                if ((referenceBinding2 = referenceBinding.enclosingType()) != null && TypeBinding.notEquals(referenceBinding2.erasure(), ((TypeBinding)object).erasure())) {
                    object = referenceBinding2;
                }
                object = referenceBinding.isGenericType() ? scope.environment().createRawType(referenceBinding, (ReferenceBinding)object) : (!referenceBinding.hasEnclosingInstanceContext() ? referenceBinding : ((bl2 = ((TypeBinding)object).isRawType()) ? scope.environment().createRawType((ReferenceBinding)referenceBinding.erasure(), (ReferenceBinding)object) : (((TypeBinding)object).isParameterizedType() && TypeBinding.equalsEquals(((TypeBinding)object).erasure(), referenceBinding.enclosingType().erasure()) ? scope.environment().createParameterizedType((ReferenceBinding)referenceBinding.erasure(), null, (ReferenceBinding)object) : referenceBinding)));
            } else {
                object = referenceBinding.isGenericType() ? (ReferenceBinding)scope.environment().convertToRawType(referenceBinding, false) : referenceBinding;
            }
            this.recordResolution(scope.environment(), (TypeBinding)object);
        }
        this.resolvedType = object;
        return this.resolvedType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordResolution(LookupEnvironment lookupEnvironment, TypeBinding typeBinding) {
        if (typeBinding != null && typeBinding.isValidBinding()) {
            LookupEnvironment lookupEnvironment2 = lookupEnvironment.root;
            synchronized (lookupEnvironment2) {
                for (int i = 0; i < lookupEnvironment.root.resolutionListeners.length; ++i) {
                    lookupEnvironment.root.resolutionListeners[i].recordResolution(this, typeBinding);
                }
            }
        }
    }

    @Override
    public char[][] getTypeName() {
        return this.tokens;
    }

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        for (int i = 0; i < this.tokens.length; ++i) {
            if (i > 0) {
                stringBuffer.append('.');
            }
            if (this.annotations != null && this.annotations[i] != null) {
                QualifiedTypeReference.printAnnotations(this.annotations[i], stringBuffer);
                stringBuffer.append(' ');
            }
            stringBuffer.append(this.tokens[i]);
        }
        return stringBuffer;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope) && this.annotations != null) {
            int n = this.annotations.length;
            for (int i = 0; i < n; ++i) {
                int n2 = this.annotations[i] == null ? 0 : this.annotations[i].length;
                for (int j = 0; j < n2; ++j) {
                    this.annotations[i][j].traverse(aSTVisitor, blockScope);
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope) && this.annotations != null) {
            int n = this.annotations.length;
            for (int i = 0; i < n; ++i) {
                int n2 = this.annotations[i] == null ? 0 : this.annotations[i].length;
                for (int j = 0; j < n2; ++j) {
                    this.annotations[i][j].traverse(aSTVisitor, classScope);
                }
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }

    @Override
    public int getAnnotatableLevels() {
        return this.tokens.length;
    }
}

