/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.flow;

import java.util.ArrayList;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FakedTrackingVariable;
import org.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.LabelFlowContext;
import org.eclipse.jdt.internal.compiler.flow.SwitchFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class LoopingFlowContext
extends SwitchFlowContext {
    public BranchLabel continueLabel;
    public UnconditionalFlowInfo initsOnContinue = FlowInfo.DEAD_END;
    private UnconditionalFlowInfo upstreamNullFlowInfo;
    private LoopingFlowContext[] innerFlowContexts = null;
    private UnconditionalFlowInfo[] innerFlowInfos = null;
    private int innerFlowContextsCount = 0;
    private LabelFlowContext[] breakTargetContexts = null;
    private int breakTargetsCount = 0;
    Reference[] finalAssignments;
    VariableBinding[] finalVariables;
    int assignCount = 0;
    LocalVariableBinding[] nullLocals;
    ASTNode[] nullReferences;
    int[] nullCheckTypes;
    UnconditionalFlowInfo[] nullInfos;
    NullAnnotationMatching[] nullAnnotationStatuses;
    int nullCount;
    private ArrayList escapingExceptionCatchSites = null;
    Scope associatedScope;

    public LoopingFlowContext(FlowContext flowContext, FlowInfo flowInfo, ASTNode aSTNode, BranchLabel branchLabel, BranchLabel branchLabel2, Scope scope, boolean bl) {
        super(flowContext, aSTNode, branchLabel, bl, false);
        this.tagBits |= 2;
        this.continueLabel = branchLabel2;
        this.associatedScope = scope;
        this.upstreamNullFlowInfo = flowInfo.unconditionalCopy();
    }

    public void complainOnDeferredFinalChecks(BlockScope blockScope, FlowInfo flowInfo) {
        for (int i = 0; i < this.assignCount; ++i) {
            VariableBinding variableBinding = this.finalVariables[i];
            if (variableBinding == null) continue;
            boolean bl = false;
            if (variableBinding instanceof FieldBinding) {
                if (flowInfo.isPotentiallyAssigned((FieldBinding)variableBinding)) {
                    bl = true;
                    blockScope.problemReporter().duplicateInitializationOfBlankFinalField((FieldBinding)variableBinding, this.finalAssignments[i]);
                }
            } else if (flowInfo.isPotentiallyAssigned((LocalVariableBinding)variableBinding)) {
                variableBinding.tagBits &= 0xFFFFFFFFFFFFF7FFL;
                if (variableBinding.isFinal()) {
                    bl = true;
                    blockScope.problemReporter().duplicateInitializationOfFinalLocal((LocalVariableBinding)variableBinding, this.finalAssignments[i]);
                }
            }
            if (!bl) continue;
            for (FlowContext flowContext = this.getLocalParent(); flowContext != null; flowContext = flowContext.getLocalParent()) {
                flowContext.removeFinalAssignmentIfAny(this.finalAssignments[i]);
            }
        }
    }

    public void complainOnDeferredNullChecks(BlockScope blockScope, FlowInfo flowInfo) {
        this.complainOnDeferredNullChecks(blockScope, flowInfo, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void complainOnDeferredNullChecks(BlockScope blockScope, FlowInfo flowInfo, boolean bl) {
        Object object;
        int n;
        Expression expression;
        UnconditionalFlowInfo unconditionalFlowInfo;
        Object object2;
        Object object3;
        int n2;
        for (int i = 0; i < this.innerFlowContextsCount; ++i) {
            this.upstreamNullFlowInfo.addPotentialNullInfoFrom(this.innerFlowContexts[i].upstreamNullFlowInfo).addPotentialNullInfoFrom(this.innerFlowInfos[i]);
        }
        this.innerFlowContextsCount = 0;
        FlowInfo flowInfo2 = this.upstreamNullFlowInfo.copy();
        UnconditionalFlowInfo unconditionalFlowInfo2 = this.upstreamNullFlowInfo.addPotentialNullInfoFrom(flowInfo.unconditionalInitsWithoutSideEffect());
        if ((this.tagBits & 1) != 0) {
            block38: for (n2 = 0; n2 < this.nullCount; ++n2) {
                object3 = this.nullLocals[n2];
                object2 = this.nullReferences[n2];
                unconditionalFlowInfo = this.nullInfos[n2] != null ? unconditionalFlowInfo2.copy().addNullInfoFrom(this.nullInfos[n2]) : unconditionalFlowInfo2;
                block0 : switch (this.nullCheckTypes[n2] & 0xFFFF0FFF) {
                    case 258: 
                    case 514: {
                        if (!((FlowInfo)unconditionalFlowInfo).isDefinitelyNonNull((LocalVariableBinding)object3)) break;
                        this.nullReferences[n2] = null;
                        if ((this.nullCheckTypes[n2] & 0xFFFF0FFF) == 514) {
                            if ((this.nullCheckTypes[n2] & 0x1000) != 0) continue block38;
                            blockScope.problemReporter().localVariableRedundantCheckOnNonNull((LocalVariableBinding)object3, (ASTNode)object2);
                            continue block38;
                        }
                        blockScope.problemReporter().localVariableNonNullComparedToNull((LocalVariableBinding)object3, (ASTNode)object2);
                        continue block38;
                    }
                    case 256: 
                    case 512: {
                        if (((FlowInfo)unconditionalFlowInfo).isDefinitelyNonNull((LocalVariableBinding)object3)) {
                            this.nullReferences[n2] = null;
                            if ((this.nullCheckTypes[n2] & 0xFFFF0FFF) == 512) {
                                if ((this.nullCheckTypes[n2] & 0x1000) != 0) continue block38;
                                blockScope.problemReporter().localVariableRedundantCheckOnNonNull((LocalVariableBinding)object3, (ASTNode)object2);
                                continue block38;
                            }
                            blockScope.problemReporter().localVariableNonNullComparedToNull((LocalVariableBinding)object3, (ASTNode)object2);
                            continue block38;
                        }
                        if (!((FlowInfo)unconditionalFlowInfo).isDefinitelyNull((LocalVariableBinding)object3)) break;
                        this.nullReferences[n2] = null;
                        if ((this.nullCheckTypes[n2] & 0xFFFF0FFF) == 256) {
                            if ((this.nullCheckTypes[n2] & 0x1000) != 0) continue block38;
                            blockScope.problemReporter().localVariableRedundantCheckOnNull((LocalVariableBinding)object3, (ASTNode)object2);
                            continue block38;
                        }
                        blockScope.problemReporter().localVariableNullComparedToNonNull((LocalVariableBinding)object3, (ASTNode)object2);
                        continue block38;
                    }
                    case 257: 
                    case 513: 
                    case 769: 
                    case 1025: {
                        expression = (Expression)object2;
                        if (((FlowInfo)unconditionalFlowInfo).isDefinitelyNull((LocalVariableBinding)object3)) {
                            this.nullReferences[n2] = null;
                            switch (this.nullCheckTypes[n2] & 0xFFFF0F00) {
                                case 256: {
                                    if ((this.nullCheckTypes[n2] & 0xFF & 0xFFFF0FFF) == 1 && (expression.implicitConversion & 0x400) != 0) {
                                        blockScope.problemReporter().localVariableNullReference((LocalVariableBinding)object3, expression);
                                        continue block38;
                                    }
                                    if ((this.nullCheckTypes[n2] & 0x1000) != 0) continue block38;
                                    blockScope.problemReporter().localVariableRedundantCheckOnNull((LocalVariableBinding)object3, expression);
                                    continue block38;
                                }
                                case 512: {
                                    if ((this.nullCheckTypes[n2] & 0xFF & 0xFFFF0FFF) == 1 && (expression.implicitConversion & 0x400) != 0) {
                                        blockScope.problemReporter().localVariableNullReference((LocalVariableBinding)object3, expression);
                                        continue block38;
                                    }
                                    blockScope.problemReporter().localVariableNullComparedToNonNull((LocalVariableBinding)object3, expression);
                                    continue block38;
                                }
                                case 768: {
                                    blockScope.problemReporter().localVariableRedundantNullAssignment((LocalVariableBinding)object3, expression);
                                    continue block38;
                                }
                                case 1024: {
                                    blockScope.problemReporter().localVariableNullInstanceof((LocalVariableBinding)object3, expression);
                                    continue block38;
                                }
                            }
                            break;
                        }
                        if (!((FlowInfo)unconditionalFlowInfo).isPotentiallyNull((LocalVariableBinding)object3)) break;
                        switch (this.nullCheckTypes[n2] & 0xFFFF0F00) {
                            case 256: {
                                this.nullReferences[n2] = null;
                                if ((this.nullCheckTypes[n2] & 0xFF & 0xFFFF0FFF) == 1 && (expression.implicitConversion & 0x400) != 0) {
                                    blockScope.problemReporter().localVariablePotentialNullReference((LocalVariableBinding)object3, expression);
                                    continue block38;
                                }
                                break block0;
                            }
                            case 512: {
                                this.nullReferences[n2] = null;
                                if ((this.nullCheckTypes[n2] & 0xFF & 0xFFFF0FFF) == 1 && (expression.implicitConversion & 0x400) != 0) {
                                    blockScope.problemReporter().localVariablePotentialNullReference((LocalVariableBinding)object3, expression);
                                    continue block38;
                                }
                                break block0;
                            }
                        }
                        break;
                    }
                    case 3: {
                        if (!((FlowInfo)unconditionalFlowInfo).isDefinitelyNull((LocalVariableBinding)object3)) break;
                        this.nullReferences[n2] = null;
                        blockScope.problemReporter().localVariableNullReference((LocalVariableBinding)object3, (ASTNode)object2);
                        continue block38;
                    }
                    case 128: {
                        n = unconditionalFlowInfo.nullStatus((LocalVariableBinding)object3);
                        if (n == 4) continue block38;
                        this.parent.recordNullityMismatch(blockScope, (Expression)object2, this.providedExpectedTypes[n2][0], this.providedExpectedTypes[n2][1], unconditionalFlowInfo, n, null);
                        continue block38;
                    }
                    case 2048: {
                        object = ((LocalVariableBinding)object3).closeTracker;
                        if (object == null) break;
                        if (((FakedTrackingVariable)object).hasDefinitelyNoResource(unconditionalFlowInfo) || ((FakedTrackingVariable)object).isClosedInFinallyOfEnclosing(blockScope)) continue block38;
                        if (!this.parent.recordExitAgainstResource(blockScope, unconditionalFlowInfo, (FakedTrackingVariable)object, (ASTNode)object2)) break;
                        this.nullReferences[n2] = null;
                        continue block38;
                    }
                    case 16: {
                        this.checkUnboxing(blockScope, (Expression)object2, unconditionalFlowInfo);
                        continue block38;
                    }
                }
                if (this.nullCheckTypes[n2] == 3 && flowInfo2.isDefinitelyNonNull((LocalVariableBinding)object3)) continue;
                this.parent.recordUsingNullReference(blockScope, (LocalVariableBinding)object3, (ASTNode)object2, this.nullCheckTypes[n2], unconditionalFlowInfo);
            }
        } else {
            block39: for (n2 = 0; n2 < this.nullCount; ++n2) {
                object3 = this.nullReferences[n2];
                object2 = this.nullLocals[n2];
                unconditionalFlowInfo = this.nullInfos[n2] != null ? unconditionalFlowInfo2.copy().addNullInfoFrom(this.nullInfos[n2]) : unconditionalFlowInfo2;
                switch (this.nullCheckTypes[n2] & 0xFFFF0FFF) {
                    case 256: 
                    case 512: {
                        if (((FlowInfo)unconditionalFlowInfo).isDefinitelyNonNull((LocalVariableBinding)object2)) {
                            this.nullReferences[n2] = null;
                            if ((this.nullCheckTypes[n2] & 0xFFFF0FFF) == 512) {
                                if ((this.nullCheckTypes[n2] & 0x1000) != 0) continue block39;
                                blockScope.problemReporter().localVariableRedundantCheckOnNonNull((LocalVariableBinding)object2, (ASTNode)object3);
                                continue block39;
                            }
                            blockScope.problemReporter().localVariableNonNullComparedToNull((LocalVariableBinding)object2, (ASTNode)object3);
                            continue block39;
                        }
                    }
                    case 257: 
                    case 513: 
                    case 769: 
                    case 1025: {
                        expression = (Expression)object3;
                        if (((FlowInfo)unconditionalFlowInfo).isDefinitelyNull((LocalVariableBinding)object2)) {
                            this.nullReferences[n2] = null;
                            switch (this.nullCheckTypes[n2] & 0xFFFF0F00) {
                                case 256: {
                                    if ((this.nullCheckTypes[n2] & 0xFF & 0xFFFF0FFF) == 1 && (expression.implicitConversion & 0x400) != 0) {
                                        blockScope.problemReporter().localVariableNullReference((LocalVariableBinding)object2, expression);
                                        break;
                                    }
                                    if ((this.nullCheckTypes[n2] & 0x1000) != 0) break;
                                    blockScope.problemReporter().localVariableRedundantCheckOnNull((LocalVariableBinding)object2, expression);
                                    break;
                                }
                                case 512: {
                                    if ((this.nullCheckTypes[n2] & 0xFF & 0xFFFF0FFF) == 1 && (expression.implicitConversion & 0x400) != 0) {
                                        blockScope.problemReporter().localVariableNullReference((LocalVariableBinding)object2, expression);
                                        break;
                                    }
                                    blockScope.problemReporter().localVariableNullComparedToNonNull((LocalVariableBinding)object2, expression);
                                    break;
                                }
                                case 768: {
                                    blockScope.problemReporter().localVariableRedundantNullAssignment((LocalVariableBinding)object2, expression);
                                    break;
                                }
                                case 1024: {
                                    blockScope.problemReporter().localVariableNullInstanceof((LocalVariableBinding)object2, expression);
                                    break;
                                }
                            }
                            continue block39;
                        }
                        if (!((FlowInfo)unconditionalFlowInfo).isPotentiallyNull((LocalVariableBinding)object2)) continue block39;
                        switch (this.nullCheckTypes[n2] & 0xFFFF0F00) {
                            case 256: {
                                this.nullReferences[n2] = null;
                                if ((this.nullCheckTypes[n2] & 0xFF & 0xFFFF0FFF) != 1 || (expression.implicitConversion & 0x400) == 0) break;
                                blockScope.problemReporter().localVariablePotentialNullReference((LocalVariableBinding)object2, expression);
                                break;
                            }
                            case 512: {
                                this.nullReferences[n2] = null;
                                if ((this.nullCheckTypes[n2] & 0xFF & 0xFFFF0FFF) != 1 || (expression.implicitConversion & 0x400) == 0) break;
                                blockScope.problemReporter().localVariablePotentialNullReference((LocalVariableBinding)object2, expression);
                                break;
                            }
                        }
                        continue block39;
                    }
                    case 3: {
                        if (((FlowInfo)unconditionalFlowInfo).isDefinitelyNull((LocalVariableBinding)object2)) {
                            this.nullReferences[n2] = null;
                            blockScope.problemReporter().localVariableNullReference((LocalVariableBinding)object2, (ASTNode)object3);
                            continue block39;
                        }
                        if (!((FlowInfo)unconditionalFlowInfo).isPotentiallyNull((LocalVariableBinding)object2)) continue block39;
                        this.nullReferences[n2] = null;
                        blockScope.problemReporter().localVariablePotentialNullReference((LocalVariableBinding)object2, (ASTNode)object3);
                        continue block39;
                    }
                    case 128: {
                        n = unconditionalFlowInfo.nullStatus((LocalVariableBinding)object2);
                        if (n == 4) continue block39;
                        object = blockScope.environment().getNonNullAnnotationName();
                        TypeBinding typeBinding = this.providedExpectedTypes[n2][0];
                        TypeBinding typeBinding2 = this.providedExpectedTypes[n2][1];
                        Expression expression2 = (Expression)object3;
                        if (this.nullAnnotationStatuses[n2] != null) {
                            this.nullAnnotationStatuses[n2] = this.nullAnnotationStatuses[n2].withNullStatus(n);
                            blockScope.problemReporter().nullityMismatchingTypeAnnotation(expression2, typeBinding, typeBinding2, this.nullAnnotationStatuses[n2]);
                            continue block39;
                        }
                        blockScope.problemReporter().nullityMismatch(expression2, typeBinding, typeBinding2, n, (char[][])object);
                        continue block39;
                    }
                    case 2048: {
                        n = unconditionalFlowInfo.nullStatus((LocalVariableBinding)object2);
                        if (n == 4 || (object = ((LocalVariableBinding)object2).closeTracker) == null || ((FakedTrackingVariable)object).hasDefinitelyNoResource(unconditionalFlowInfo) || ((FakedTrackingVariable)object).isClosedInFinallyOfEnclosing(blockScope)) continue block39;
                        n = ((FakedTrackingVariable)object).findMostSpecificStatus(unconditionalFlowInfo, blockScope, null);
                        ((FakedTrackingVariable)object).recordErrorLocation(this.nullReferences[n2], n);
                        ((FakedTrackingVariable)object).reportRecordedErrors(blockScope, n, unconditionalFlowInfo.reachMode() != 0);
                        this.nullReferences[n2] = null;
                        continue block39;
                    }
                    case 16: {
                        this.checkUnboxing(blockScope, (Expression)object3, unconditionalFlowInfo);
                        continue block39;
                    }
                }
            }
        }
        if (bl) {
            this.initsOnBreak.addPotentialNullInfoFrom(unconditionalFlowInfo2);
            for (n2 = 0; n2 < this.breakTargetsCount; ++n2) {
                this.breakTargetContexts[n2].initsOnBreak.addPotentialNullInfoFrom(unconditionalFlowInfo2);
            }
        }
    }

    @Override
    public BranchLabel continueLabel() {
        return this.continueLabel;
    }

    @Override
    public String individualToString() {
        StringBuilder stringBuilder = new StringBuilder("Looping flow context");
        stringBuilder.append("[initsOnBreak - ").append(this.initsOnBreak.toString()).append(']');
        stringBuilder.append("[initsOnContinue - ").append(this.initsOnContinue.toString()).append(']');
        stringBuilder.append("[finalAssignments count - ").append(this.assignCount).append(']');
        stringBuilder.append("[nullReferences count - ").append(this.nullCount).append(']');
        return stringBuilder.toString();
    }

    @Override
    public boolean isContinuable() {
        return true;
    }

    public boolean isContinuedTo() {
        return this.initsOnContinue != FlowInfo.DEAD_END;
    }

    @Override
    public void recordBreakTo(FlowContext flowContext) {
        if (flowContext instanceof LabelFlowContext) {
            int n;
            if ((n = this.breakTargetsCount++) == 0) {
                this.breakTargetContexts = new LabelFlowContext[2];
            } else if (n == this.breakTargetContexts.length) {
                this.breakTargetContexts = new LabelFlowContext[n + 2];
                System.arraycopy(this.breakTargetContexts, 0, this.breakTargetContexts, 0, n);
            }
            this.breakTargetContexts[n] = (LabelFlowContext)flowContext;
        }
    }

    @Override
    public void recordContinueFrom(FlowContext flowContext, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) == 0) {
            this.initsOnContinue = (this.initsOnContinue.tagBits & 1) == 0 ? this.initsOnContinue.mergedWith(flowInfo.unconditionalInitsWithoutSideEffect()) : flowInfo.unconditionalCopy();
            FlowContext flowContext2 = flowContext;
            while (flowContext2 != this && !(flowContext2 instanceof LoopingFlowContext)) {
                flowContext2 = flowContext2.parent;
            }
            if (flowContext2 == this) {
                this.upstreamNullFlowInfo.addPotentialNullInfoFrom(flowInfo.unconditionalInitsWithoutSideEffect());
            } else {
                int n = 0;
                if (this.innerFlowContexts == null) {
                    this.innerFlowContexts = new LoopingFlowContext[5];
                    this.innerFlowInfos = new UnconditionalFlowInfo[5];
                } else {
                    n = this.innerFlowContexts.length;
                    if (this.innerFlowContextsCount == n - 1) {
                        this.innerFlowContexts = new LoopingFlowContext[n + 5];
                        System.arraycopy(this.innerFlowContexts, 0, this.innerFlowContexts, 0, n);
                        this.innerFlowInfos = new UnconditionalFlowInfo[n + 5];
                        System.arraycopy(this.innerFlowInfos, 0, this.innerFlowInfos, 0, n);
                    }
                }
                this.innerFlowContexts[this.innerFlowContextsCount] = (LoopingFlowContext)flowContext2;
                this.innerFlowInfos[this.innerFlowContextsCount++] = flowInfo.unconditionalInitsWithoutSideEffect();
            }
        }
    }

    @Override
    protected boolean recordFinalAssignment(VariableBinding variableBinding, Reference reference) {
        if (variableBinding instanceof LocalVariableBinding) {
            Scope scope = ((LocalVariableBinding)variableBinding).declaringScope;
            while ((scope = scope.parent) != null) {
                if (scope != this.associatedScope) continue;
                return false;
            }
        }
        if (this.assignCount == 0) {
            this.finalAssignments = new Reference[5];
            this.finalVariables = new VariableBinding[5];
        } else {
            if (this.assignCount == this.finalAssignments.length) {
                this.finalAssignments = new Reference[this.assignCount * 2];
                System.arraycopy(this.finalAssignments, 0, this.finalAssignments, 0, this.assignCount);
            }
            this.finalVariables = new VariableBinding[this.assignCount * 2];
            System.arraycopy(this.finalVariables, 0, this.finalVariables, 0, this.assignCount);
        }
        this.finalAssignments[this.assignCount] = reference;
        this.finalVariables[this.assignCount++] = variableBinding;
        return true;
    }

    @Override
    protected void recordNullReferenceWithAnnotationStatus(LocalVariableBinding localVariableBinding, ASTNode aSTNode, int n, FlowInfo flowInfo, NullAnnotationMatching nullAnnotationMatching) {
        if (this.nullCount == 0) {
            this.nullLocals = new LocalVariableBinding[5];
            this.nullReferences = new ASTNode[5];
            this.nullCheckTypes = new int[5];
            this.nullInfos = new UnconditionalFlowInfo[5];
            this.nullAnnotationStatuses = new NullAnnotationMatching[5];
        } else if (this.nullCount == this.nullLocals.length) {
            this.nullLocals = new LocalVariableBinding[this.nullCount * 2];
            System.arraycopy(this.nullLocals, 0, this.nullLocals, 0, this.nullCount);
            this.nullReferences = new ASTNode[this.nullCount * 2];
            System.arraycopy(this.nullReferences, 0, this.nullReferences, 0, this.nullCount);
            this.nullCheckTypes = new int[this.nullCount * 2];
            System.arraycopy(this.nullCheckTypes, 0, this.nullCheckTypes, 0, this.nullCount);
            this.nullInfos = new UnconditionalFlowInfo[this.nullCount * 2];
            System.arraycopy(this.nullInfos, 0, this.nullInfos, 0, this.nullCount);
            this.nullAnnotationStatuses = new NullAnnotationMatching[this.nullCount * 2];
            System.arraycopy(this.nullAnnotationStatuses, 0, this.nullAnnotationStatuses, 0, this.nullCount);
        }
        this.nullLocals[this.nullCount] = localVariableBinding;
        this.nullReferences[this.nullCount] = aSTNode;
        this.nullCheckTypes[this.nullCount] = n;
        this.nullAnnotationStatuses[this.nullCount] = nullAnnotationMatching;
        this.nullInfos[this.nullCount++] = flowInfo != null ? flowInfo.unconditionalCopy() : null;
    }

    @Override
    public void recordUnboxing(Scope scope, Expression expression, int n, FlowInfo flowInfo) {
        if (n == 2) {
            super.recordUnboxing(scope, expression, n, flowInfo);
        } else {
            this.recordNullReference(null, expression, 16, flowInfo);
        }
    }

    @Override
    public boolean recordExitAgainstResource(BlockScope blockScope, FlowInfo flowInfo, FakedTrackingVariable fakedTrackingVariable, ASTNode aSTNode) {
        LocalVariableBinding localVariableBinding = fakedTrackingVariable.binding;
        if (flowInfo.isDefinitelyNonNull(localVariableBinding)) {
            return false;
        }
        if (flowInfo.isDefinitelyNull(localVariableBinding)) {
            blockScope.problemReporter().unclosedCloseable(fakedTrackingVariable, aSTNode);
            return true;
        }
        if (flowInfo.isPotentiallyNull(localVariableBinding)) {
            blockScope.problemReporter().potentiallyUnclosedCloseable(fakedTrackingVariable, aSTNode);
            return true;
        }
        this.recordNullReference(fakedTrackingVariable.binding, aSTNode, 2048, flowInfo);
        return true;
    }

    @Override
    public void recordUsingNullReference(Scope scope, LocalVariableBinding localVariableBinding, ASTNode aSTNode, int n, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 3) != 0 || flowInfo.isDefinitelyUnknown(localVariableBinding)) {
            return;
        }
        int n2 = (n |= this.tagBits & 0x1000) & 0xFFFF0FFF;
        switch (n2) {
            case 256: 
            case 512: {
                Expression expression = (Expression)aSTNode;
                if (flowInfo.isDefinitelyNonNull(localVariableBinding)) {
                    if (n2 == 512) {
                        if ((this.tagBits & 0x1000) == 0) {
                            scope.problemReporter().localVariableRedundantCheckOnNonNull(localVariableBinding, expression);
                        }
                        flowInfo.initsWhenFalse().setReachMode(2);
                    } else {
                        scope.problemReporter().localVariableNonNullComparedToNull(localVariableBinding, expression);
                        flowInfo.initsWhenTrue().setReachMode(2);
                    }
                } else if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                    if (n2 == 256) {
                        if ((this.tagBits & 0x1000) == 0) {
                            scope.problemReporter().localVariableRedundantCheckOnNull(localVariableBinding, expression);
                        }
                        flowInfo.initsWhenFalse().setReachMode(2);
                    } else {
                        scope.problemReporter().localVariableNullComparedToNonNull(localVariableBinding, expression);
                        flowInfo.initsWhenTrue().setReachMode(2);
                    }
                } else if (this.upstreamNullFlowInfo.isDefinitelyNonNull(localVariableBinding) && !flowInfo.isPotentiallyNull(localVariableBinding) && !flowInfo.isPotentiallyUnknown(localVariableBinding)) {
                    this.recordNullReference(localVariableBinding, expression, n, flowInfo);
                    flowInfo.markAsDefinitelyNonNull(localVariableBinding);
                } else {
                    if (flowInfo.cannotBeDefinitelyNullOrNonNull(localVariableBinding)) {
                        return;
                    }
                    if (flowInfo.isPotentiallyNonNull(localVariableBinding)) {
                        this.recordNullReference(localVariableBinding, expression, 2 | n & 0xFFFFFF00, flowInfo);
                    } else if (flowInfo.isPotentiallyNull(localVariableBinding)) {
                        this.recordNullReference(localVariableBinding, expression, 1 | n & 0xFFFFFF00, flowInfo);
                    } else {
                        this.recordNullReference(localVariableBinding, expression, n, flowInfo);
                    }
                }
                return;
            }
            case 257: 
            case 513: 
            case 769: 
            case 1025: {
                Expression expression = (Expression)aSTNode;
                if (flowInfo.isPotentiallyNonNull(localVariableBinding) || flowInfo.isPotentiallyUnknown(localVariableBinding) || flowInfo.isProtectedNonNull(localVariableBinding)) {
                    return;
                }
                if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                    switch (n2 & 0xFFFF0F00) {
                        case 256: {
                            if ((n2 & 0xFF) == 1 && (expression.implicitConversion & 0x400) != 0) {
                                scope.problemReporter().localVariableNullReference(localVariableBinding, expression);
                                return;
                            }
                            if ((this.tagBits & 0x1000) == 0) {
                                scope.problemReporter().localVariableRedundantCheckOnNull(localVariableBinding, expression);
                            }
                            flowInfo.initsWhenFalse().setReachMode(2);
                            return;
                        }
                        case 512: {
                            if ((n2 & 0xFF) == 1 && (expression.implicitConversion & 0x400) != 0) {
                                scope.problemReporter().localVariableNullReference(localVariableBinding, expression);
                                return;
                            }
                            scope.problemReporter().localVariableNullComparedToNonNull(localVariableBinding, expression);
                            flowInfo.initsWhenTrue().setReachMode(2);
                            return;
                        }
                        case 768: {
                            scope.problemReporter().localVariableRedundantNullAssignment(localVariableBinding, expression);
                            return;
                        }
                        case 1024: {
                            scope.problemReporter().localVariableNullInstanceof(localVariableBinding, expression);
                            return;
                        }
                    }
                } else if (flowInfo.isPotentiallyNull(localVariableBinding)) {
                    switch (n2 & 0xFFFF0F00) {
                        case 256: {
                            if ((n2 & 0xFF) != 1 || (expression.implicitConversion & 0x400) == 0) break;
                            scope.problemReporter().localVariablePotentialNullReference(localVariableBinding, expression);
                            return;
                        }
                        case 512: {
                            if ((n2 & 0xFF) != 1 || (expression.implicitConversion & 0x400) == 0) break;
                            scope.problemReporter().localVariablePotentialNullReference(localVariableBinding, expression);
                            return;
                        }
                    }
                }
                this.recordNullReference(localVariableBinding, expression, n, flowInfo);
                return;
            }
            case 3: {
                if (flowInfo.isDefinitelyNonNull(localVariableBinding)) {
                    return;
                }
                if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                    scope.problemReporter().localVariableNullReference(localVariableBinding, aSTNode);
                    return;
                }
                if (flowInfo.isPotentiallyNull(localVariableBinding)) {
                    scope.problemReporter().localVariablePotentialNullReference(localVariableBinding, aSTNode);
                    return;
                }
                this.recordNullReference(localVariableBinding, aSTNode, n, flowInfo);
                return;
            }
        }
    }

    @Override
    void removeFinalAssignmentIfAny(Reference reference) {
        for (int i = 0; i < this.assignCount; ++i) {
            if (this.finalAssignments[i] != reference) continue;
            this.finalAssignments[i] = null;
            this.finalVariables[i] = null;
            return;
        }
    }

    public void simulateThrowAfterLoopBack(FlowInfo flowInfo) {
        if (this.escapingExceptionCatchSites != null) {
            int n = this.escapingExceptionCatchSites.size();
            for (int i = 0; i < n; ++i) {
                ((EscapingExceptionCatchSite)this.escapingExceptionCatchSites.get(i)).simulateThrowAfterLoopBack(flowInfo);
            }
            this.escapingExceptionCatchSites = null;
        }
    }

    public void recordCatchContextOfEscapingException(ExceptionHandlingFlowContext exceptionHandlingFlowContext, ReferenceBinding referenceBinding, FlowInfo flowInfo) {
        if (this.escapingExceptionCatchSites == null) {
            this.escapingExceptionCatchSites = new ArrayList(5);
        }
        this.escapingExceptionCatchSites.add(new EscapingExceptionCatchSite(exceptionHandlingFlowContext, referenceBinding, flowInfo));
    }

    public boolean hasEscapingExceptions() {
        return this.escapingExceptionCatchSites != null;
    }

    @Override
    protected boolean internalRecordNullityMismatch(Expression expression, TypeBinding typeBinding, FlowInfo flowInfo, int n, NullAnnotationMatching nullAnnotationMatching, TypeBinding typeBinding2, int n2) {
        this.recordProvidedExpectedTypes(typeBinding, typeBinding2, this.nullCount);
        this.recordNullReferenceWithAnnotationStatus(expression.localVariableBinding(), expression, n2, flowInfo, nullAnnotationMatching);
        return true;
    }

    private static class EscapingExceptionCatchSite {
        final ReferenceBinding caughtException;
        final ExceptionHandlingFlowContext catchingContext;
        final FlowInfo exceptionInfo;

        public EscapingExceptionCatchSite(ExceptionHandlingFlowContext exceptionHandlingFlowContext, ReferenceBinding referenceBinding, FlowInfo flowInfo) {
            this.catchingContext = exceptionHandlingFlowContext;
            this.caughtException = referenceBinding;
            this.exceptionInfo = flowInfo;
        }

        void simulateThrowAfterLoopBack(FlowInfo flowInfo) {
            this.catchingContext.recordHandlingException(this.caughtException, flowInfo.unconditionalCopy().addNullInfoFrom(this.exceptionInfo).unconditionalInits(), null, null, null, true);
        }
    }
}

