/* gcalc-solver.c generated by valac 0.56.0, the Vala compiler
 * generated from gcalc-solver.vala, do not modify */

/* gcalc-solver.vala
 *
 * Copyright (C) 2018  Daniel Espinosa <esodan@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      Daniel Espinosa <esodan@gmail.com>
 */

#include "gcalc/gcalc.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <glib-object.h>
#include "gcalc.h"

enum  {
	GCALC_SOLVER_0_PROPERTY,
	GCALC_SOLVER_EQUATION_MANAGER_PROPERTY,
	GCALC_SOLVER_NUM_PROPERTIES
};
static GParamSpec* gcalc_solver_properties[GCALC_SOLVER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GCalcSolverPrivate {
	GCalcMathEquationManager* _equation_manager;
};

static gint GCalcSolver_private_offset;
static gpointer gcalc_solver_parent_class = NULL;

static GObject * gcalc_solver_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties);
static void gcalc_solver_finalize (GObject * obj);
static GType gcalc_solver_get_type_once (void);
static void _vala_gcalc_solver_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_gcalc_solver_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);

static inline gpointer
gcalc_solver_get_instance_private (GCalcSolver* self)
{
	return G_STRUCT_MEMBER_P (self, GCalcSolver_private_offset);
}

/**
   * Add an equation to {@link equation_manager}
   */
void
gcalc_solver_add_expression (GCalcSolver* self,
                             const gchar* exp,
                             GError** error)
{
	GCalcParser* p = NULL;
	GCalcParser* _tmp0_;
	GCalcMathEquationManager* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (exp != NULL);
	_tmp0_ = gcalc_parser_new ();
	p = _tmp0_;
	_tmp1_ = self->priv->_equation_manager;
	gcalc_parser_parse (p, exp, _tmp1_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (p);
		return;
	}
	_g_object_unref0 (p);
}

/**
   * Add an equation to {@link equation_manager} and solves it
   */
GCalcMathResult*
gcalc_solver_solve (GCalcSolver* self,
                    const gchar* str,
                    GError** error)
{
	GCalcParser* p = NULL;
	GCalcParser* _tmp0_;
	GCalcMathResult* res = NULL;
	GError* _inner_error0_ = NULL;
	GCalcMathResult* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = gcalc_parser_new ();
	p = _tmp0_;
	{
		GCalcParser* _tmp1_;
		GCalcMathEquationManager* _tmp2_;
		GCalcMathEquationManager* _tmp3_;
		GCalcExpressionContainer* _tmp4_;
		GCalcExpressionContainer* _tmp5_;
		GCalcMathEquation* eq = NULL;
		GCalcMathEquationManager* _tmp7_;
		GCalcExpressionContainer* _tmp8_;
		GCalcExpressionContainer* _tmp9_;
		GObject* _tmp10_;
		GCalcMathEquation* _tmp11_;
		GCalcMathEquation* _tmp12_;
		GCalcMathEquation* _tmp14_;
		GCalcMathResult* _tmp15_;
		_tmp1_ = p;
		_tmp2_ = self->priv->_equation_manager;
		gcalc_parser_parse (_tmp1_, str, _tmp2_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = self->priv->_equation_manager;
		_tmp4_ = gcalc_math_equation_manager_get_equations (_tmp3_);
		_tmp5_ = _tmp4_;
		if (g_list_model_get_n_items ((GListModel*) _tmp5_) == ((guint) 0)) {
			GCalcErrorResult* _tmp6_;
			_tmp6_ = gcalc_error_result_new (_ ("No equations found after parsing"));
			result = (GCalcMathResult*) _tmp6_;
			_g_object_unref0 (res);
			_g_object_unref0 (p);
			return result;
		}
		_tmp7_ = self->priv->_equation_manager;
		_tmp8_ = gcalc_math_equation_manager_get_equations (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_list_model_get_item ((GListModel*) _tmp9_, (guint) 0);
		_tmp11_ = GCALC_IS_MATH_EQUATION (_tmp10_) ? ((GCalcMathEquation*) _tmp10_) : NULL;
		if (_tmp11_ == NULL) {
			_g_object_unref0 (_tmp10_);
		}
		eq = _tmp11_;
		_tmp12_ = eq;
		if (_tmp12_ == NULL) {
			GCalcErrorResult* _tmp13_;
			_tmp13_ = gcalc_error_result_new (_ ("No equations found after parsing"));
			result = (GCalcMathResult*) _tmp13_;
			_g_object_unref0 (eq);
			_g_object_unref0 (res);
			_g_object_unref0 (p);
			return result;
		}
		_tmp14_ = eq;
		_tmp15_ = gcalc_math_expression_solve ((GCalcMathExpression*) _tmp14_);
		_g_object_unref0 (res);
		res = _tmp15_;
		_g_object_unref0 (eq);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		GCalcErrorResult* _tmp20_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		_tmp18_ = g_strdup_printf (_ ("Solving fails: %s"), _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = gcalc_error_result_new (_tmp19_);
		_g_object_unref0 (res);
		res = (GCalcMathResult*) _tmp20_;
		_g_free0 (_tmp19_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (res);
		_g_object_unref0 (p);
		return NULL;
	}
	result = res;
	_g_object_unref0 (p);
	return result;
}

GCalcSolver*
gcalc_solver_construct (GType object_type)
{
	GCalcSolver * self = NULL;
	self = (GCalcSolver*) g_object_new (object_type, NULL);
	return self;
}

GCalcSolver*
gcalc_solver_new (void)
{
	return gcalc_solver_construct (GCALC_TYPE_SOLVER);
}

GCalcMathEquationManager*
gcalc_solver_get_equation_manager (GCalcSolver* self)
{
	GCalcMathEquationManager* result;
	GCalcMathEquationManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_equation_manager;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
gcalc_solver_set_equation_manager (GCalcSolver* self,
                                   GCalcMathEquationManager* value)
{
	GCalcMathEquationManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gcalc_solver_get_equation_manager (self);
	if (old_value != value) {
		GCalcMathEquationManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_equation_manager);
		self->priv->_equation_manager = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gcalc_solver_properties[GCALC_SOLVER_EQUATION_MANAGER_PROPERTY]);
	}
}

static GObject *
gcalc_solver_constructor (GType type,
                          guint n_construct_properties,
                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GCalcSolver * self;
	GCalcEquationManager* _tmp0_;
	GCalcEquationManager* _tmp1_;
	parent_class = G_OBJECT_CLASS (gcalc_solver_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GCALC_TYPE_SOLVER, GCalcSolver);
	_tmp0_ = gcalc_equation_manager_new ();
	_tmp1_ = _tmp0_;
	gcalc_solver_set_equation_manager (self, (GCalcMathEquationManager*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	return obj;
}

static void
gcalc_solver_class_init (GCalcSolverClass * klass,
                         gpointer klass_data)
{
	gcalc_solver_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GCalcSolver_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gcalc_solver_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gcalc_solver_set_property;
	G_OBJECT_CLASS (klass)->constructor = gcalc_solver_constructor;
	G_OBJECT_CLASS (klass)->finalize = gcalc_solver_finalize;
	/**
	   * An equation manager using to solve a given expression
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCALC_SOLVER_EQUATION_MANAGER_PROPERTY, gcalc_solver_properties[GCALC_SOLVER_EQUATION_MANAGER_PROPERTY] = g_param_spec_object ("equation-manager", "equation-manager", "equation-manager", GCALC_TYPE_MATH_EQUATION_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
gcalc_solver_instance_init (GCalcSolver * self,
                            gpointer klass)
{
	self->priv = gcalc_solver_get_instance_private (self);
}

static void
gcalc_solver_finalize (GObject * obj)
{
	GCalcSolver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GCALC_TYPE_SOLVER, GCalcSolver);
	_g_object_unref0 (self->priv->_equation_manager);
	G_OBJECT_CLASS (gcalc_solver_parent_class)->finalize (obj);
}

/**
 * Math expression solver.
 *
 * Add any required equations to {@link equation_manager} or use {@link add_expression},
 * then {@link solve} will add a new equation and returns the resulting
 * {@link MathResult}.
 * {{{
 *  var s = new Solver ();
 *  s.add ("x=3*5");
 *  var res = s.solve ("2*x+7*x^2");
 *  var c = (MathConstant) res;
 *  // Result will be 1605
 *  stdout.printf ("%g", c.real ());
 * }}}
 */
static GType
gcalc_solver_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GCalcSolverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gcalc_solver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GCalcSolver), 0, (GInstanceInitFunc) gcalc_solver_instance_init, NULL };
	GType gcalc_solver_type_id;
	gcalc_solver_type_id = g_type_register_static (G_TYPE_OBJECT, "GCalcSolver", &g_define_type_info, 0);
	GCalcSolver_private_offset = g_type_add_instance_private (gcalc_solver_type_id, sizeof (GCalcSolverPrivate));
	return gcalc_solver_type_id;
}

GType
gcalc_solver_get_type (void)
{
	static volatile gsize gcalc_solver_type_id__once = 0;
	if (g_once_init_enter (&gcalc_solver_type_id__once)) {
		GType gcalc_solver_type_id;
		gcalc_solver_type_id = gcalc_solver_get_type_once ();
		g_once_init_leave (&gcalc_solver_type_id__once, gcalc_solver_type_id);
	}
	return gcalc_solver_type_id__once;
}

static void
_vala_gcalc_solver_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	GCalcSolver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GCALC_TYPE_SOLVER, GCalcSolver);
	switch (property_id) {
		case GCALC_SOLVER_EQUATION_MANAGER_PROPERTY:
		g_value_set_object (value, gcalc_solver_get_equation_manager (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gcalc_solver_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	GCalcSolver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GCALC_TYPE_SOLVER, GCalcSolver);
	switch (property_id) {
		case GCALC_SOLVER_EQUATION_MANAGER_PROPERTY:
		gcalc_solver_set_equation_manager (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

GQuark
gcalc_solver_error_quark (void)
{
	return g_quark_from_static_string ("gcalc-solver-error-quark");
}

static GType
gcalc_solver_error_get_type_once (void)
{
	static const GEnumValue values[] = {{GCALC_SOLVER_ERROR_EXPRESSION_ERROR, "GCALC_SOLVER_ERROR_EXPRESSION_ERROR", "expression-error"}, {0, NULL, NULL}};
	GType gcalc_solver_error_type_id;
	gcalc_solver_error_type_id = g_enum_register_static ("GCalcSolverError", values);
	return gcalc_solver_error_type_id;
}

GType
gcalc_solver_error_get_type (void)
{
	static volatile gsize gcalc_solver_error_type_id__once = 0;
	if (g_once_init_enter (&gcalc_solver_error_type_id__once)) {
		GType gcalc_solver_error_type_id;
		gcalc_solver_error_type_id = gcalc_solver_error_get_type_once ();
		g_once_init_leave (&gcalc_solver_error_type_id__once, gcalc_solver_error_type_id);
	}
	return gcalc_solver_error_type_id__once;
}

