/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Comparator;

public class CharsetMapping {
    public static final char UNMAPPABLE_DECODING = '\ufffd';
    public static final int UNMAPPABLE_ENCODING = 65533;
    char[] b2cSB;
    char[] b2cDB1;
    char[] b2cDB2;
    int b2Min;
    int b2Max;
    int b1MinDB1;
    int b1MaxDB1;
    int b1MinDB2;
    int b1MaxDB2;
    int dbSegSize;
    char[] c2b;
    char[] c2bIndex;
    char[] b2cSupp;
    char[] c2bSupp;
    Entry[] b2cComp;
    Entry[] c2bComp;
    static Comparator<Entry> comparatorBytes = new Comparator<Entry>(){

        @Override
        public int compare(Entry m1, Entry m2) {
            return m1.bs - m2.bs;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }
    };
    static Comparator<Entry> comparatorCP = new Comparator<Entry>(){

        @Override
        public int compare(Entry m1, Entry m2) {
            return m1.cp - m2.cp;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }
    };
    static Comparator<Entry> comparatorComp = new Comparator<Entry>(){

        @Override
        public int compare(Entry m1, Entry m2) {
            int v = m1.cp - m2.cp;
            if (v == 0) {
                v = m1.cp2 - m2.cp2;
            }
            return v;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }
    };
    private static final int MAP_SINGLEBYTE = 1;
    private static final int MAP_DOUBLEBYTE1 = 2;
    private static final int MAP_DOUBLEBYTE2 = 3;
    private static final int MAP_SUPPLEMENT = 5;
    private static final int MAP_SUPPLEMENT_C2B = 6;
    private static final int MAP_COMPOSITE = 7;
    private static final int MAP_INDEXC2B = 8;
    int off = 0;
    byte[] bb;

    public char decodeSingle(int b) {
        return this.b2cSB[b];
    }

    public char decodeDouble(int b1, int b2) {
        if (b2 >= this.b2Min && b2 < this.b2Max) {
            b2 -= this.b2Min;
            if (b1 >= this.b1MinDB1 && b1 <= this.b1MaxDB1) {
                return this.b2cDB1[(b1 -= this.b1MinDB1) * this.dbSegSize + b2];
            }
            if (b1 >= this.b1MinDB2 && b1 <= this.b1MaxDB2) {
                return this.b2cDB2[(b1 -= this.b1MinDB2) * this.dbSegSize + b2];
            }
        }
        return '\ufffd';
    }

    public char[] decodeSurrogate(int db, char[] cc) {
        int end = this.b2cSupp.length / 2;
        int i = Arrays.binarySearch(this.b2cSupp, 0, end, (char)db);
        if (i >= 0) {
            Character.toChars(this.b2cSupp[end + i] + 131072, cc, 0);
            return cc;
        }
        return null;
    }

    public char[] decodeComposite(Entry comp, char[] cc) {
        int i = CharsetMapping.findBytes(this.b2cComp, comp);
        if (i >= 0) {
            cc[0] = (char)this.b2cComp[i].cp;
            cc[1] = (char)this.b2cComp[i].cp2;
            return cc;
        }
        return null;
    }

    public int encodeChar(char ch) {
        char index = this.c2bIndex[ch >> 8];
        if (index == '\uffff') {
            return 65533;
        }
        return this.c2b[index + (ch & 0xFF)];
    }

    public int encodeSurrogate(char hi, char lo) {
        int cp = Character.toCodePoint(hi, lo);
        if (cp < 131072 || cp >= 196608) {
            return 65533;
        }
        int end = this.c2bSupp.length / 2;
        int i = Arrays.binarySearch(this.c2bSupp, 0, end, (char)cp);
        if (i >= 0) {
            return this.c2bSupp[end + i];
        }
        return 65533;
    }

    public boolean isCompositeBase(Entry comp) {
        if (comp.cp <= 12791 && comp.cp >= 230) {
            return CharsetMapping.findCP(this.c2bComp, comp) >= 0;
        }
        return false;
    }

    public int encodeComposite(Entry comp) {
        int i = CharsetMapping.findComp(this.c2bComp, comp);
        if (i >= 0) {
            return this.c2bComp[i].bs;
        }
        return 65533;
    }

    public static CharsetMapping get(final InputStream is) {
        return AccessController.doPrivileged(new PrivilegedAction<CharsetMapping>(){

            @Override
            public CharsetMapping run() {
                return new CharsetMapping().load(is);
            }
        });
    }

    static int findBytes(Entry[] a, Entry k) {
        return Arrays.binarySearch(a, 0, a.length, k, comparatorBytes);
    }

    static int findCP(Entry[] a, Entry k) {
        return Arrays.binarySearch(a, 0, a.length, k, comparatorCP);
    }

    static int findComp(Entry[] a, Entry k) {
        return Arrays.binarySearch(a, 0, a.length, k, comparatorComp);
    }

    private static final boolean readNBytes(InputStream in, byte[] bb, int N) throws IOException {
        int off = 0;
        while (N > 0) {
            int n = in.read(bb, off, N);
            if (n == -1) {
                return false;
            }
            N -= n;
            off += n;
        }
        return true;
    }

    private char[] readCharArray() {
        int size = (this.bb[this.off++] & 0xFF) << 8 | this.bb[this.off++] & 0xFF;
        char[] cc = new char[size];
        for (int i = 0; i < size; ++i) {
            cc[i] = (char)((this.bb[this.off++] & 0xFF) << 8 | this.bb[this.off++] & 0xFF);
        }
        return cc;
    }

    void readSINGLEBYTE() {
        char[] map = this.readCharArray();
        for (int i = 0; i < map.length; ++i) {
            char c = map[i];
            if (c == '\ufffd') continue;
            this.c2b[this.c2bIndex[c >> 8] + (c & 0xFF)] = (char)i;
        }
        this.b2cSB = map;
    }

    void readINDEXC2B() {
        char[] map = this.readCharArray();
        for (int i = map.length - 1; i >= 0; --i) {
            if (this.c2b != null || map[i] == '\uffffffff') continue;
            this.c2b = new char[map[i] + 256];
            Arrays.fill(this.c2b, '\ufffd');
            break;
        }
        this.c2bIndex = map;
    }

    char[] readDB(int b1Min, int b2Min, int segSize) {
        char[] map = this.readCharArray();
        for (int i = 0; i < map.length; ++i) {
            char c = map[i];
            if (c == '\ufffd') continue;
            int b1 = i / segSize;
            int b2 = i % segSize;
            int b = (b1 + b1Min) * 256 + (b2 + b2Min);
            this.c2b[this.c2bIndex[c >> 8] + (c & 0xFF)] = (char)b;
        }
        return map;
    }

    void readDOUBLEBYTE1() {
        this.b1MinDB1 = (this.bb[this.off++] & 0xFF) << 8 | this.bb[this.off++] & 0xFF;
        this.b1MaxDB1 = (this.bb[this.off++] & 0xFF) << 8 | this.bb[this.off++] & 0xFF;
        this.b2Min = (this.bb[this.off++] & 0xFF) << 8 | this.bb[this.off++] & 0xFF;
        this.b2Max = (this.bb[this.off++] & 0xFF) << 8 | this.bb[this.off++] & 0xFF;
        this.dbSegSize = this.b2Max - this.b2Min + 1;
        this.b2cDB1 = this.readDB(this.b1MinDB1, this.b2Min, this.dbSegSize);
    }

    void readDOUBLEBYTE2() {
        this.b1MinDB2 = (this.bb[this.off++] & 0xFF) << 8 | this.bb[this.off++] & 0xFF;
        this.b1MaxDB2 = (this.bb[this.off++] & 0xFF) << 8 | this.bb[this.off++] & 0xFF;
        this.b2Min = (this.bb[this.off++] & 0xFF) << 8 | this.bb[this.off++] & 0xFF;
        this.b2Max = (this.bb[this.off++] & 0xFF) << 8 | this.bb[this.off++] & 0xFF;
        this.dbSegSize = this.b2Max - this.b2Min + 1;
        this.b2cDB2 = this.readDB(this.b1MinDB2, this.b2Min, this.dbSegSize);
    }

    void readCOMPOSITE() {
        char[] map = this.readCharArray();
        int mLen = map.length / 3;
        this.b2cComp = new Entry[mLen];
        this.c2bComp = new Entry[mLen];
        int j = 0;
        for (int i = 0; i < mLen; ++i) {
            Entry m = new Entry();
            m.bs = map[j++];
            m.cp = map[j++];
            m.cp2 = map[j++];
            this.b2cComp[i] = m;
            this.c2bComp[i] = m;
        }
        Arrays.sort(this.c2bComp, 0, this.c2bComp.length, comparatorComp);
    }

    CharsetMapping load(InputStream in) {
        try {
            int len = (in.read() & 0xFF) << 24 | (in.read() & 0xFF) << 16 | (in.read() & 0xFF) << 8 | in.read() & 0xFF;
            this.bb = new byte[len];
            this.off = 0;
            if (!CharsetMapping.readNBytes(in, this.bb, len)) {
                throw new RuntimeException("Corrupted data file");
            }
            in.close();
            block11: while (this.off < len) {
                int type = (this.bb[this.off++] & 0xFF) << 8 | this.bb[this.off++] & 0xFF;
                switch (type) {
                    case 8: {
                        this.readINDEXC2B();
                        continue block11;
                    }
                    case 1: {
                        this.readSINGLEBYTE();
                        continue block11;
                    }
                    case 2: {
                        this.readDOUBLEBYTE1();
                        continue block11;
                    }
                    case 3: {
                        this.readDOUBLEBYTE2();
                        continue block11;
                    }
                    case 5: {
                        this.b2cSupp = this.readCharArray();
                        continue block11;
                    }
                    case 6: {
                        this.c2bSupp = this.readCharArray();
                        continue block11;
                    }
                    case 7: {
                        this.readCOMPOSITE();
                        continue block11;
                    }
                }
                throw new RuntimeException("Corrupted data file");
            }
            this.bb = null;
            return this;
        }
        catch (IOException x) {
            x.printStackTrace();
            return null;
        }
    }

    public static class Entry {
        public int bs;
        public int cp;
        public int cp2;
    }
}

