/* hashable.c generated by valac 0.56.0, the Vala compiler
 * generated from hashable.vala, do not modify */

/* hashable.vala
 *
 * Copyright (C) 2010  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Maciej Piechotka <uzytkwonik2@gmail.com>
 */

#include "gee.h"
#include <glib-object.h>
#include <glib.h>

static GType gee_hashable_get_type_once (void);

/**
 * Computes hash for an objects. Two hashes of equal objects have to be
 * equal.
 *
 * Note: Hash //must not// change during lifetime of an object.
 *
 * @return hash of an object
 */
guint
gee_hashable_hash (GeeHashable* self)
{
	GeeHashableIface* _iface_;
	g_return_val_if_fail (self != NULL, 0U);
	_iface_ = GEE_HASHABLE_GET_INTERFACE (self);
	if (_iface_->hash) {
		return _iface_->hash (self);
	}
	return 0U;
}

/**
 * Compares this object with the specified object. This defines the
 * equivalence relation between them.
 *
 * In other words:
 *
 *  * It must be reflexive: for all objects `a` it holds that
 *    `a.equal_to(a)`.
 *  * It must be symmetric: for all objects `a` and `b` if
 *    `a.equal_to(b)` then `b.equal_to(a)`.
 *  * It must be transitive: if `a.equal_to(b)` and `b.equal_to(c)` then
 *    `a.equal_to(c)`.
 *
 * Note: Relationship //must not// change during lifetime of an object.
 *
 * @param object Object this objest is compared with
 * @return true if objects are equal
 */
gboolean
gee_hashable_equal_to (GeeHashable* self,
                       gconstpointer object)
{
	GeeHashableIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GEE_HASHABLE_GET_INTERFACE (self);
	if (_iface_->equal_to) {
		return _iface_->equal_to (self, object);
	}
	return FALSE;
}

static void
gee_hashable_default_init (GeeHashableIface * iface,
                           gpointer iface_data)
{
}

/**
 * This interface defines a hash function among instances of each class
 * implementing it.
 *
 * @see Comparable
 */
static GType
gee_hashable_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GeeHashableIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_hashable_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gee_hashable_type_id;
	gee_hashable_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeHashable", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gee_hashable_type_id, G_TYPE_OBJECT);
	return gee_hashable_type_id;
}

GType
gee_hashable_get_type (void)
{
	static volatile gsize gee_hashable_type_id__once = 0;
	if (g_once_init_enter (&gee_hashable_type_id__once)) {
		GType gee_hashable_type_id;
		gee_hashable_type_id = gee_hashable_get_type_once ();
		g_once_init_leave (&gee_hashable_type_id__once, gee_hashable_type_id);
	}
	return gee_hashable_type_id__once;
}

