/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "org.freedesktop.NetworkManager.WifiP2PPeer.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.NetworkManager.WifiP2PPeer
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:NMDBusWifiP2PPeer
 * @title: NMDBusWifiP2PPeer
 * @short_description: Generated C code for the org.freedesktop.NetworkManager.WifiP2PPeer D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-NetworkManager-WifiP2PPeer.top_of_page">org.freedesktop.NetworkManager.WifiP2PPeer</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.NetworkManager.WifiP2PPeer ---- */

static const _ExtendedGDBusPropertyInfo _nmdbus_wifi_p2p_peer_property_info_name =
{
  {
    -1,
    (gchar *) "Name",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_wifi_p2p_peer_property_info_flags =
{
  {
    -1,
    (gchar *) "Flags",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "flags",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_wifi_p2p_peer_property_info_manufacturer =
{
  {
    -1,
    (gchar *) "Manufacturer",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "manufacturer",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_wifi_p2p_peer_property_info_model =
{
  {
    -1,
    (gchar *) "Model",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "model",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_wifi_p2p_peer_property_info_model_number =
{
  {
    -1,
    (gchar *) "ModelNumber",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "model-number",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_wifi_p2p_peer_property_info_serial =
{
  {
    -1,
    (gchar *) "Serial",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "serial",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_wifi_p2p_peer_property_info_wfd_ies =
{
  {
    -1,
    (gchar *) "WfdIEs",
    (gchar *) "ay",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "wfd-ies",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_wifi_p2p_peer_property_info_hw_address =
{
  {
    -1,
    (gchar *) "HwAddress",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "hw-address",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_wifi_p2p_peer_property_info_strength =
{
  {
    -1,
    (gchar *) "Strength",
    (gchar *) "y",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "strength",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_wifi_p2p_peer_property_info_last_seen =
{
  {
    -1,
    (gchar *) "LastSeen",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "last-seen",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _nmdbus_wifi_p2p_peer_property_info_pointers[] =
{
  &_nmdbus_wifi_p2p_peer_property_info_name.parent_struct,
  &_nmdbus_wifi_p2p_peer_property_info_flags.parent_struct,
  &_nmdbus_wifi_p2p_peer_property_info_manufacturer.parent_struct,
  &_nmdbus_wifi_p2p_peer_property_info_model.parent_struct,
  &_nmdbus_wifi_p2p_peer_property_info_model_number.parent_struct,
  &_nmdbus_wifi_p2p_peer_property_info_serial.parent_struct,
  &_nmdbus_wifi_p2p_peer_property_info_wfd_ies.parent_struct,
  &_nmdbus_wifi_p2p_peer_property_info_hw_address.parent_struct,
  &_nmdbus_wifi_p2p_peer_property_info_strength.parent_struct,
  &_nmdbus_wifi_p2p_peer_property_info_last_seen.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _nmdbus_wifi_p2p_peer_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.NetworkManager.WifiP2PPeer",
    NULL,
    NULL,
    (GDBusPropertyInfo **) &_nmdbus_wifi_p2p_peer_property_info_pointers,
    NULL
  },
  "wifi-p2p-peer",
};


/**
 * nmdbus_wifi_p2p_peer_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-NetworkManager-WifiP2PPeer.top_of_page">org.freedesktop.NetworkManager.WifiP2PPeer</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
nmdbus_wifi_p2p_peer_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_nmdbus_wifi_p2p_peer_interface_info.parent_struct;
}

/**
 * nmdbus_wifi_p2p_peer_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #NMDBusWifiP2PPeer interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
nmdbus_wifi_p2p_peer_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "name");
  g_object_class_override_property (klass, property_id_begin++, "flags");
  g_object_class_override_property (klass, property_id_begin++, "manufacturer");
  g_object_class_override_property (klass, property_id_begin++, "model");
  g_object_class_override_property (klass, property_id_begin++, "model-number");
  g_object_class_override_property (klass, property_id_begin++, "serial");
  g_object_class_override_property (klass, property_id_begin++, "wfd-ies");
  g_object_class_override_property (klass, property_id_begin++, "hw-address");
  g_object_class_override_property (klass, property_id_begin++, "strength");
  g_object_class_override_property (klass, property_id_begin++, "last-seen");
  return property_id_begin - 1;
}



/**
 * NMDBusWifiP2PPeer:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager-WifiP2PPeer.top_of_page">org.freedesktop.NetworkManager.WifiP2PPeer</link>.
 */

/**
 * NMDBusWifiP2PPeerIface:
 * @parent_iface: The parent interface.
 * @get_flags: Getter for the #NMDBusWifiP2PPeer:flags property.
 * @get_hw_address: Getter for the #NMDBusWifiP2PPeer:hw-address property.
 * @get_last_seen: Getter for the #NMDBusWifiP2PPeer:last-seen property.
 * @get_manufacturer: Getter for the #NMDBusWifiP2PPeer:manufacturer property.
 * @get_model: Getter for the #NMDBusWifiP2PPeer:model property.
 * @get_model_number: Getter for the #NMDBusWifiP2PPeer:model-number property.
 * @get_name: Getter for the #NMDBusWifiP2PPeer:name property.
 * @get_serial: Getter for the #NMDBusWifiP2PPeer:serial property.
 * @get_strength: Getter for the #NMDBusWifiP2PPeer:strength property.
 * @get_wfd_ies: Getter for the #NMDBusWifiP2PPeer:wfd-ies property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager-WifiP2PPeer.top_of_page">org.freedesktop.NetworkManager.WifiP2PPeer</link>.
 */

typedef NMDBusWifiP2PPeerIface NMDBusWifiP2PPeerInterface;
G_DEFINE_INTERFACE (NMDBusWifiP2PPeer, nmdbus_wifi_p2p_peer, G_TYPE_OBJECT)

static void
nmdbus_wifi_p2p_peer_default_init (NMDBusWifiP2PPeerIface *iface)
{
  /* GObject properties for D-Bus properties: */
  /**
   * NMDBusWifiP2PPeer:name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.Name">"Name"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("name", "Name", "Name", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusWifiP2PPeer:flags:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.Flags">"Flags"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("flags", "Flags", "Flags", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusWifiP2PPeer:manufacturer:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.Manufacturer">"Manufacturer"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("manufacturer", "Manufacturer", "Manufacturer", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusWifiP2PPeer:model:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.Model">"Model"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("model", "Model", "Model", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusWifiP2PPeer:model-number:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.ModelNumber">"ModelNumber"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("model-number", "ModelNumber", "ModelNumber", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusWifiP2PPeer:serial:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.Serial">"Serial"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("serial", "Serial", "Serial", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusWifiP2PPeer:wfd-ies:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.WfdIEs">"WfdIEs"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("wfd-ies", "WfdIEs", "WfdIEs", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusWifiP2PPeer:hw-address:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.HwAddress">"HwAddress"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("hw-address", "HwAddress", "HwAddress", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusWifiP2PPeer:strength:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.Strength">"Strength"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uchar ("strength", "Strength", "Strength", 0, 255, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusWifiP2PPeer:last-seen:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.LastSeen">"LastSeen"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("last-seen", "LastSeen", "LastSeen", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * nmdbus_wifi_p2p_peer_get_name: (skip)
 * @object: A #NMDBusWifiP2PPeer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_wifi_p2p_peer_dup_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
nmdbus_wifi_p2p_peer_get_name (NMDBusWifiP2PPeer *object)
{
  return NMDBUS_WIFI_P2P_PEER_GET_IFACE (object)->get_name (object);
}

/**
 * nmdbus_wifi_p2p_peer_dup_name: (skip)
 * @object: A #NMDBusWifiP2PPeer.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
nmdbus_wifi_p2p_peer_dup_name (NMDBusWifiP2PPeer *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "name", &value, NULL);
  return value;
}

/**
 * nmdbus_wifi_p2p_peer_set_name: (skip)
 * @object: A #NMDBusWifiP2PPeer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.Name">"Name"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_wifi_p2p_peer_set_name (NMDBusWifiP2PPeer *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "name", value, NULL);
}

/**
 * nmdbus_wifi_p2p_peer_get_flags: (skip)
 * @object: A #NMDBusWifiP2PPeer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.Flags">"Flags"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
nmdbus_wifi_p2p_peer_get_flags (NMDBusWifiP2PPeer *object)
{
  return NMDBUS_WIFI_P2P_PEER_GET_IFACE (object)->get_flags (object);
}

/**
 * nmdbus_wifi_p2p_peer_set_flags: (skip)
 * @object: A #NMDBusWifiP2PPeer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.Flags">"Flags"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_wifi_p2p_peer_set_flags (NMDBusWifiP2PPeer *object, guint value)
{
  g_object_set (G_OBJECT (object), "flags", value, NULL);
}

/**
 * nmdbus_wifi_p2p_peer_get_manufacturer: (skip)
 * @object: A #NMDBusWifiP2PPeer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.Manufacturer">"Manufacturer"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_wifi_p2p_peer_dup_manufacturer() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
nmdbus_wifi_p2p_peer_get_manufacturer (NMDBusWifiP2PPeer *object)
{
  return NMDBUS_WIFI_P2P_PEER_GET_IFACE (object)->get_manufacturer (object);
}

/**
 * nmdbus_wifi_p2p_peer_dup_manufacturer: (skip)
 * @object: A #NMDBusWifiP2PPeer.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.Manufacturer">"Manufacturer"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
nmdbus_wifi_p2p_peer_dup_manufacturer (NMDBusWifiP2PPeer *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "manufacturer", &value, NULL);
  return value;
}

/**
 * nmdbus_wifi_p2p_peer_set_manufacturer: (skip)
 * @object: A #NMDBusWifiP2PPeer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.Manufacturer">"Manufacturer"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_wifi_p2p_peer_set_manufacturer (NMDBusWifiP2PPeer *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "manufacturer", value, NULL);
}

/**
 * nmdbus_wifi_p2p_peer_get_model: (skip)
 * @object: A #NMDBusWifiP2PPeer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.Model">"Model"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_wifi_p2p_peer_dup_model() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
nmdbus_wifi_p2p_peer_get_model (NMDBusWifiP2PPeer *object)
{
  return NMDBUS_WIFI_P2P_PEER_GET_IFACE (object)->get_model (object);
}

/**
 * nmdbus_wifi_p2p_peer_dup_model: (skip)
 * @object: A #NMDBusWifiP2PPeer.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.Model">"Model"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
nmdbus_wifi_p2p_peer_dup_model (NMDBusWifiP2PPeer *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "model", &value, NULL);
  return value;
}

/**
 * nmdbus_wifi_p2p_peer_set_model: (skip)
 * @object: A #NMDBusWifiP2PPeer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.Model">"Model"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_wifi_p2p_peer_set_model (NMDBusWifiP2PPeer *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "model", value, NULL);
}

/**
 * nmdbus_wifi_p2p_peer_get_model_number: (skip)
 * @object: A #NMDBusWifiP2PPeer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.ModelNumber">"ModelNumber"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_wifi_p2p_peer_dup_model_number() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
nmdbus_wifi_p2p_peer_get_model_number (NMDBusWifiP2PPeer *object)
{
  return NMDBUS_WIFI_P2P_PEER_GET_IFACE (object)->get_model_number (object);
}

/**
 * nmdbus_wifi_p2p_peer_dup_model_number: (skip)
 * @object: A #NMDBusWifiP2PPeer.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.ModelNumber">"ModelNumber"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
nmdbus_wifi_p2p_peer_dup_model_number (NMDBusWifiP2PPeer *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "model-number", &value, NULL);
  return value;
}

/**
 * nmdbus_wifi_p2p_peer_set_model_number: (skip)
 * @object: A #NMDBusWifiP2PPeer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.ModelNumber">"ModelNumber"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_wifi_p2p_peer_set_model_number (NMDBusWifiP2PPeer *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "model-number", value, NULL);
}

/**
 * nmdbus_wifi_p2p_peer_get_serial: (skip)
 * @object: A #NMDBusWifiP2PPeer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.Serial">"Serial"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_wifi_p2p_peer_dup_serial() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
nmdbus_wifi_p2p_peer_get_serial (NMDBusWifiP2PPeer *object)
{
  return NMDBUS_WIFI_P2P_PEER_GET_IFACE (object)->get_serial (object);
}

/**
 * nmdbus_wifi_p2p_peer_dup_serial: (skip)
 * @object: A #NMDBusWifiP2PPeer.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.Serial">"Serial"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
nmdbus_wifi_p2p_peer_dup_serial (NMDBusWifiP2PPeer *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "serial", &value, NULL);
  return value;
}

/**
 * nmdbus_wifi_p2p_peer_set_serial: (skip)
 * @object: A #NMDBusWifiP2PPeer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.Serial">"Serial"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_wifi_p2p_peer_set_serial (NMDBusWifiP2PPeer *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "serial", value, NULL);
}

/**
 * nmdbus_wifi_p2p_peer_get_wfd_ies: (skip)
 * @object: A #NMDBusWifiP2PPeer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.WfdIEs">"WfdIEs"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_wifi_p2p_peer_dup_wfd_ies() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
nmdbus_wifi_p2p_peer_get_wfd_ies (NMDBusWifiP2PPeer *object)
{
  return NMDBUS_WIFI_P2P_PEER_GET_IFACE (object)->get_wfd_ies (object);
}

/**
 * nmdbus_wifi_p2p_peer_dup_wfd_ies: (skip)
 * @object: A #NMDBusWifiP2PPeer.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.WfdIEs">"WfdIEs"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
nmdbus_wifi_p2p_peer_dup_wfd_ies (NMDBusWifiP2PPeer *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "wfd-ies", &value, NULL);
  return value;
}

/**
 * nmdbus_wifi_p2p_peer_set_wfd_ies: (skip)
 * @object: A #NMDBusWifiP2PPeer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.WfdIEs">"WfdIEs"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_wifi_p2p_peer_set_wfd_ies (NMDBusWifiP2PPeer *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "wfd-ies", value, NULL);
}

/**
 * nmdbus_wifi_p2p_peer_get_hw_address: (skip)
 * @object: A #NMDBusWifiP2PPeer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.HwAddress">"HwAddress"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_wifi_p2p_peer_dup_hw_address() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
nmdbus_wifi_p2p_peer_get_hw_address (NMDBusWifiP2PPeer *object)
{
  return NMDBUS_WIFI_P2P_PEER_GET_IFACE (object)->get_hw_address (object);
}

/**
 * nmdbus_wifi_p2p_peer_dup_hw_address: (skip)
 * @object: A #NMDBusWifiP2PPeer.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.HwAddress">"HwAddress"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
nmdbus_wifi_p2p_peer_dup_hw_address (NMDBusWifiP2PPeer *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "hw-address", &value, NULL);
  return value;
}

/**
 * nmdbus_wifi_p2p_peer_set_hw_address: (skip)
 * @object: A #NMDBusWifiP2PPeer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.HwAddress">"HwAddress"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_wifi_p2p_peer_set_hw_address (NMDBusWifiP2PPeer *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "hw-address", value, NULL);
}

/**
 * nmdbus_wifi_p2p_peer_get_strength: (skip)
 * @object: A #NMDBusWifiP2PPeer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.Strength">"Strength"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guchar 
nmdbus_wifi_p2p_peer_get_strength (NMDBusWifiP2PPeer *object)
{
  return NMDBUS_WIFI_P2P_PEER_GET_IFACE (object)->get_strength (object);
}

/**
 * nmdbus_wifi_p2p_peer_set_strength: (skip)
 * @object: A #NMDBusWifiP2PPeer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.Strength">"Strength"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_wifi_p2p_peer_set_strength (NMDBusWifiP2PPeer *object, guchar value)
{
  g_object_set (G_OBJECT (object), "strength", value, NULL);
}

/**
 * nmdbus_wifi_p2p_peer_get_last_seen: (skip)
 * @object: A #NMDBusWifiP2PPeer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.LastSeen">"LastSeen"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
nmdbus_wifi_p2p_peer_get_last_seen (NMDBusWifiP2PPeer *object)
{
  return NMDBUS_WIFI_P2P_PEER_GET_IFACE (object)->get_last_seen (object);
}

/**
 * nmdbus_wifi_p2p_peer_set_last_seen: (skip)
 * @object: A #NMDBusWifiP2PPeer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-WifiP2PPeer.LastSeen">"LastSeen"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_wifi_p2p_peer_set_last_seen (NMDBusWifiP2PPeer *object, gint value)
{
  g_object_set (G_OBJECT (object), "last-seen", value, NULL);
}

/* ------------------------------------------------------------------------ */

/**
 * NMDBusWifiP2PPeerProxy:
 *
 * The #NMDBusWifiP2PPeerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NMDBusWifiP2PPeerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NMDBusWifiP2PPeerProxy.
 */

struct _NMDBusWifiP2PPeerProxyPrivate
{
  GData *qdata;
};

static void nmdbus_wifi_p2p_peer_proxy_iface_init (NMDBusWifiP2PPeerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (NMDBusWifiP2PPeerProxy, nmdbus_wifi_p2p_peer_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (NMDBusWifiP2PPeerProxy)
                         G_IMPLEMENT_INTERFACE (NMDBUS_TYPE_WIFI_P2P_PEER, nmdbus_wifi_p2p_peer_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (NMDBusWifiP2PPeerProxy, nmdbus_wifi_p2p_peer_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (NMDBUS_TYPE_WIFI_P2P_PEER, nmdbus_wifi_p2p_peer_proxy_iface_init))

#endif
static void
nmdbus_wifi_p2p_peer_proxy_finalize (GObject *object)
{
  NMDBusWifiP2PPeerProxy *proxy = NMDBUS_WIFI_P2P_PEER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (nmdbus_wifi_p2p_peer_proxy_parent_class)->finalize (object);
}

static void
nmdbus_wifi_p2p_peer_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 10);
  info = (const _ExtendedGDBusPropertyInfo *) _nmdbus_wifi_p2p_peer_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
nmdbus_wifi_p2p_peer_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.NetworkManager.WifiP2PPeer: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
nmdbus_wifi_p2p_peer_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 10);
  info = (const _ExtendedGDBusPropertyInfo *) _nmdbus_wifi_p2p_peer_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.NetworkManager.WifiP2PPeer", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) nmdbus_wifi_p2p_peer_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
nmdbus_wifi_p2p_peer_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_nmdbus_wifi_p2p_peer_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], NMDBUS_TYPE_WIFI_P2P_PEER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, NMDBUS_TYPE_WIFI_P2P_PEER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
nmdbus_wifi_p2p_peer_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  NMDBusWifiP2PPeerProxy *proxy = NMDBUS_WIFI_P2P_PEER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nmdbus_wifi_p2p_peer_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nmdbus_wifi_p2p_peer_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
nmdbus_wifi_p2p_peer_proxy_get_name (NMDBusWifiP2PPeer *object)
{
  NMDBusWifiP2PPeerProxy *proxy = NMDBUS_WIFI_P2P_PEER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Name");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
nmdbus_wifi_p2p_peer_proxy_get_flags (NMDBusWifiP2PPeer *object)
{
  NMDBusWifiP2PPeerProxy *proxy = NMDBUS_WIFI_P2P_PEER_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Flags");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
nmdbus_wifi_p2p_peer_proxy_get_manufacturer (NMDBusWifiP2PPeer *object)
{
  NMDBusWifiP2PPeerProxy *proxy = NMDBUS_WIFI_P2P_PEER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Manufacturer");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
nmdbus_wifi_p2p_peer_proxy_get_model (NMDBusWifiP2PPeer *object)
{
  NMDBusWifiP2PPeerProxy *proxy = NMDBUS_WIFI_P2P_PEER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Model");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
nmdbus_wifi_p2p_peer_proxy_get_model_number (NMDBusWifiP2PPeer *object)
{
  NMDBusWifiP2PPeerProxy *proxy = NMDBUS_WIFI_P2P_PEER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ModelNumber");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
nmdbus_wifi_p2p_peer_proxy_get_serial (NMDBusWifiP2PPeer *object)
{
  NMDBusWifiP2PPeerProxy *proxy = NMDBUS_WIFI_P2P_PEER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Serial");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
nmdbus_wifi_p2p_peer_proxy_get_wfd_ies (NMDBusWifiP2PPeer *object)
{
  NMDBusWifiP2PPeerProxy *proxy = NMDBUS_WIFI_P2P_PEER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "WfdIEs");
  if (variant != NULL)
    {
      value = g_variant_get_bytestring (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
nmdbus_wifi_p2p_peer_proxy_get_hw_address (NMDBusWifiP2PPeer *object)
{
  NMDBusWifiP2PPeerProxy *proxy = NMDBUS_WIFI_P2P_PEER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "HwAddress");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guchar 
nmdbus_wifi_p2p_peer_proxy_get_strength (NMDBusWifiP2PPeer *object)
{
  NMDBusWifiP2PPeerProxy *proxy = NMDBUS_WIFI_P2P_PEER_PROXY (object);
  GVariant *variant;
  guchar value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Strength");
  if (variant != NULL)
    {
      value = g_variant_get_byte (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gint 
nmdbus_wifi_p2p_peer_proxy_get_last_seen (NMDBusWifiP2PPeer *object)
{
  NMDBusWifiP2PPeerProxy *proxy = NMDBUS_WIFI_P2P_PEER_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "LastSeen");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
nmdbus_wifi_p2p_peer_proxy_init (NMDBusWifiP2PPeerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = nmdbus_wifi_p2p_peer_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, NMDBUS_TYPE_WIFI_P2P_PEER_PROXY, NMDBusWifiP2PPeerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), nmdbus_wifi_p2p_peer_interface_info ());
}

static void
nmdbus_wifi_p2p_peer_proxy_class_init (NMDBusWifiP2PPeerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = nmdbus_wifi_p2p_peer_proxy_finalize;
  gobject_class->get_property = nmdbus_wifi_p2p_peer_proxy_get_property;
  gobject_class->set_property = nmdbus_wifi_p2p_peer_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = nmdbus_wifi_p2p_peer_proxy_g_signal;
  proxy_class->g_properties_changed = nmdbus_wifi_p2p_peer_proxy_g_properties_changed;

  nmdbus_wifi_p2p_peer_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (NMDBusWifiP2PPeerProxyPrivate));
#endif
}

static void
nmdbus_wifi_p2p_peer_proxy_iface_init (NMDBusWifiP2PPeerIface *iface)
{
  iface->get_name = nmdbus_wifi_p2p_peer_proxy_get_name;
  iface->get_flags = nmdbus_wifi_p2p_peer_proxy_get_flags;
  iface->get_manufacturer = nmdbus_wifi_p2p_peer_proxy_get_manufacturer;
  iface->get_model = nmdbus_wifi_p2p_peer_proxy_get_model;
  iface->get_model_number = nmdbus_wifi_p2p_peer_proxy_get_model_number;
  iface->get_serial = nmdbus_wifi_p2p_peer_proxy_get_serial;
  iface->get_wfd_ies = nmdbus_wifi_p2p_peer_proxy_get_wfd_ies;
  iface->get_hw_address = nmdbus_wifi_p2p_peer_proxy_get_hw_address;
  iface->get_strength = nmdbus_wifi_p2p_peer_proxy_get_strength;
  iface->get_last_seen = nmdbus_wifi_p2p_peer_proxy_get_last_seen;
}

/**
 * nmdbus_wifi_p2p_peer_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager-WifiP2PPeer.top_of_page">org.freedesktop.NetworkManager.WifiP2PPeer</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_wifi_p2p_peer_proxy_new_finish() to get the result of the operation.
 *
 * See nmdbus_wifi_p2p_peer_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
nmdbus_wifi_p2p_peer_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (NMDBUS_TYPE_WIFI_P2P_PEER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.NetworkManager.WifiP2PPeer", NULL);
}

/**
 * nmdbus_wifi_p2p_peer_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_wifi_p2p_peer_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with nmdbus_wifi_p2p_peer_proxy_new().
 *
 * Returns: (transfer full) (type NMDBusWifiP2PPeerProxy): The constructed proxy object or %NULL if @error is set.
 */
NMDBusWifiP2PPeer *
nmdbus_wifi_p2p_peer_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return NMDBUS_WIFI_P2P_PEER (ret);
  else
    return NULL;
}

/**
 * nmdbus_wifi_p2p_peer_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager-WifiP2PPeer.top_of_page">org.freedesktop.NetworkManager.WifiP2PPeer</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See nmdbus_wifi_p2p_peer_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NMDBusWifiP2PPeerProxy): The constructed proxy object or %NULL if @error is set.
 */
NMDBusWifiP2PPeer *
nmdbus_wifi_p2p_peer_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (NMDBUS_TYPE_WIFI_P2P_PEER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.NetworkManager.WifiP2PPeer", NULL);
  if (ret != NULL)
    return NMDBUS_WIFI_P2P_PEER (ret);
  else
    return NULL;
}


/**
 * nmdbus_wifi_p2p_peer_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like nmdbus_wifi_p2p_peer_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_wifi_p2p_peer_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See nmdbus_wifi_p2p_peer_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
nmdbus_wifi_p2p_peer_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (NMDBUS_TYPE_WIFI_P2P_PEER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.NetworkManager.WifiP2PPeer", NULL);
}

/**
 * nmdbus_wifi_p2p_peer_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_wifi_p2p_peer_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with nmdbus_wifi_p2p_peer_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type NMDBusWifiP2PPeerProxy): The constructed proxy object or %NULL if @error is set.
 */
NMDBusWifiP2PPeer *
nmdbus_wifi_p2p_peer_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return NMDBUS_WIFI_P2P_PEER (ret);
  else
    return NULL;
}

/**
 * nmdbus_wifi_p2p_peer_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like nmdbus_wifi_p2p_peer_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See nmdbus_wifi_p2p_peer_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NMDBusWifiP2PPeerProxy): The constructed proxy object or %NULL if @error is set.
 */
NMDBusWifiP2PPeer *
nmdbus_wifi_p2p_peer_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (NMDBUS_TYPE_WIFI_P2P_PEER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.NetworkManager.WifiP2PPeer", NULL);
  if (ret != NULL)
    return NMDBUS_WIFI_P2P_PEER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * NMDBusWifiP2PPeerSkeleton:
 *
 * The #NMDBusWifiP2PPeerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NMDBusWifiP2PPeerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NMDBusWifiP2PPeerSkeleton.
 */

struct _NMDBusWifiP2PPeerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_nmdbus_wifi_p2p_peer_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  NMDBusWifiP2PPeerSkeleton *skeleton = NMDBUS_WIFI_P2P_PEER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], NMDBUS_TYPE_WIFI_P2P_PEER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, NMDBUS_TYPE_WIFI_P2P_PEER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_nmdbus_wifi_p2p_peer_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  NMDBusWifiP2PPeerSkeleton *skeleton = NMDBUS_WIFI_P2P_PEER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nmdbus_wifi_p2p_peer_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_nmdbus_wifi_p2p_peer_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  NMDBusWifiP2PPeerSkeleton *skeleton = NMDBUS_WIFI_P2P_PEER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nmdbus_wifi_p2p_peer_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _nmdbus_wifi_p2p_peer_skeleton_vtable =
{
  _nmdbus_wifi_p2p_peer_skeleton_handle_method_call,
  _nmdbus_wifi_p2p_peer_skeleton_handle_get_property,
  _nmdbus_wifi_p2p_peer_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
nmdbus_wifi_p2p_peer_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return nmdbus_wifi_p2p_peer_interface_info ();
}

static GDBusInterfaceVTable *
nmdbus_wifi_p2p_peer_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_nmdbus_wifi_p2p_peer_skeleton_vtable;
}

static GVariant *
nmdbus_wifi_p2p_peer_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  NMDBusWifiP2PPeerSkeleton *skeleton = NMDBUS_WIFI_P2P_PEER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_nmdbus_wifi_p2p_peer_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _nmdbus_wifi_p2p_peer_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _nmdbus_wifi_p2p_peer_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _nmdbus_wifi_p2p_peer_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.NetworkManager.WifiP2PPeer", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _nmdbus_wifi_p2p_peer_emit_changed (gpointer user_data);

static void
nmdbus_wifi_p2p_peer_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  NMDBusWifiP2PPeerSkeleton *skeleton = NMDBUS_WIFI_P2P_PEER_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _nmdbus_wifi_p2p_peer_emit_changed (skeleton);
}

static void nmdbus_wifi_p2p_peer_skeleton_iface_init (NMDBusWifiP2PPeerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (NMDBusWifiP2PPeerSkeleton, nmdbus_wifi_p2p_peer_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (NMDBusWifiP2PPeerSkeleton)
                         G_IMPLEMENT_INTERFACE (NMDBUS_TYPE_WIFI_P2P_PEER, nmdbus_wifi_p2p_peer_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (NMDBusWifiP2PPeerSkeleton, nmdbus_wifi_p2p_peer_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (NMDBUS_TYPE_WIFI_P2P_PEER, nmdbus_wifi_p2p_peer_skeleton_iface_init))

#endif
static void
nmdbus_wifi_p2p_peer_skeleton_finalize (GObject *object)
{
  NMDBusWifiP2PPeerSkeleton *skeleton = NMDBUS_WIFI_P2P_PEER_SKELETON (object);
  guint n;
  for (n = 0; n < 10; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (nmdbus_wifi_p2p_peer_skeleton_parent_class)->finalize (object);
}

static void
nmdbus_wifi_p2p_peer_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  NMDBusWifiP2PPeerSkeleton *skeleton = NMDBUS_WIFI_P2P_PEER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 10);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_nmdbus_wifi_p2p_peer_emit_changed (gpointer user_data)
{
  NMDBusWifiP2PPeerSkeleton *skeleton = NMDBUS_WIFI_P2P_PEER_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.NetworkManager.WifiP2PPeer",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_nmdbus_wifi_p2p_peer_schedule_emit_changed (NMDBusWifiP2PPeerSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
nmdbus_wifi_p2p_peer_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  NMDBusWifiP2PPeerSkeleton *skeleton = NMDBUS_WIFI_P2P_PEER_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _nmdbus_wifi_p2p_peer_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _nmdbus_wifi_p2p_peer_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
nmdbus_wifi_p2p_peer_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  NMDBusWifiP2PPeerSkeleton *skeleton = NMDBUS_WIFI_P2P_PEER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 10);
  info = (const _ExtendedGDBusPropertyInfo *) _nmdbus_wifi_p2p_peer_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _nmdbus_wifi_p2p_peer_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
nmdbus_wifi_p2p_peer_skeleton_init (NMDBusWifiP2PPeerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = nmdbus_wifi_p2p_peer_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, NMDBUS_TYPE_WIFI_P2P_PEER_SKELETON, NMDBusWifiP2PPeerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 10);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[8], G_TYPE_UCHAR);
  g_value_init (&skeleton->priv->properties[9], G_TYPE_INT);
}

static const gchar *
nmdbus_wifi_p2p_peer_skeleton_get_name (NMDBusWifiP2PPeer *object)
{
  NMDBusWifiP2PPeerSkeleton *skeleton = NMDBUS_WIFI_P2P_PEER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
nmdbus_wifi_p2p_peer_skeleton_get_flags (NMDBusWifiP2PPeer *object)
{
  NMDBusWifiP2PPeerSkeleton *skeleton = NMDBUS_WIFI_P2P_PEER_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
nmdbus_wifi_p2p_peer_skeleton_get_manufacturer (NMDBusWifiP2PPeer *object)
{
  NMDBusWifiP2PPeerSkeleton *skeleton = NMDBUS_WIFI_P2P_PEER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
nmdbus_wifi_p2p_peer_skeleton_get_model (NMDBusWifiP2PPeer *object)
{
  NMDBusWifiP2PPeerSkeleton *skeleton = NMDBUS_WIFI_P2P_PEER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
nmdbus_wifi_p2p_peer_skeleton_get_model_number (NMDBusWifiP2PPeer *object)
{
  NMDBusWifiP2PPeerSkeleton *skeleton = NMDBUS_WIFI_P2P_PEER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
nmdbus_wifi_p2p_peer_skeleton_get_serial (NMDBusWifiP2PPeer *object)
{
  NMDBusWifiP2PPeerSkeleton *skeleton = NMDBUS_WIFI_P2P_PEER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
nmdbus_wifi_p2p_peer_skeleton_get_wfd_ies (NMDBusWifiP2PPeer *object)
{
  NMDBusWifiP2PPeerSkeleton *skeleton = NMDBUS_WIFI_P2P_PEER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
nmdbus_wifi_p2p_peer_skeleton_get_hw_address (NMDBusWifiP2PPeer *object)
{
  NMDBusWifiP2PPeerSkeleton *skeleton = NMDBUS_WIFI_P2P_PEER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guchar 
nmdbus_wifi_p2p_peer_skeleton_get_strength (NMDBusWifiP2PPeer *object)
{
  NMDBusWifiP2PPeerSkeleton *skeleton = NMDBUS_WIFI_P2P_PEER_SKELETON (object);
  guchar value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uchar (&(skeleton->priv->properties[8]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint 
nmdbus_wifi_p2p_peer_skeleton_get_last_seen (NMDBusWifiP2PPeer *object)
{
  NMDBusWifiP2PPeerSkeleton *skeleton = NMDBUS_WIFI_P2P_PEER_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_int (&(skeleton->priv->properties[9]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
nmdbus_wifi_p2p_peer_skeleton_class_init (NMDBusWifiP2PPeerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = nmdbus_wifi_p2p_peer_skeleton_finalize;
  gobject_class->get_property = nmdbus_wifi_p2p_peer_skeleton_get_property;
  gobject_class->set_property = nmdbus_wifi_p2p_peer_skeleton_set_property;
  gobject_class->notify       = nmdbus_wifi_p2p_peer_skeleton_notify;


  nmdbus_wifi_p2p_peer_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = nmdbus_wifi_p2p_peer_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = nmdbus_wifi_p2p_peer_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = nmdbus_wifi_p2p_peer_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = nmdbus_wifi_p2p_peer_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (NMDBusWifiP2PPeerSkeletonPrivate));
#endif
}

static void
nmdbus_wifi_p2p_peer_skeleton_iface_init (NMDBusWifiP2PPeerIface *iface)
{
  iface->get_name = nmdbus_wifi_p2p_peer_skeleton_get_name;
  iface->get_flags = nmdbus_wifi_p2p_peer_skeleton_get_flags;
  iface->get_manufacturer = nmdbus_wifi_p2p_peer_skeleton_get_manufacturer;
  iface->get_model = nmdbus_wifi_p2p_peer_skeleton_get_model;
  iface->get_model_number = nmdbus_wifi_p2p_peer_skeleton_get_model_number;
  iface->get_serial = nmdbus_wifi_p2p_peer_skeleton_get_serial;
  iface->get_wfd_ies = nmdbus_wifi_p2p_peer_skeleton_get_wfd_ies;
  iface->get_hw_address = nmdbus_wifi_p2p_peer_skeleton_get_hw_address;
  iface->get_strength = nmdbus_wifi_p2p_peer_skeleton_get_strength;
  iface->get_last_seen = nmdbus_wifi_p2p_peer_skeleton_get_last_seen;
}

/**
 * nmdbus_wifi_p2p_peer_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager-WifiP2PPeer.top_of_page">org.freedesktop.NetworkManager.WifiP2PPeer</link>.
 *
 * Returns: (transfer full) (type NMDBusWifiP2PPeerSkeleton): The skeleton object.
 */
NMDBusWifiP2PPeer *
nmdbus_wifi_p2p_peer_skeleton_new (void)
{
  return NMDBUS_WIFI_P2P_PEER (g_object_new (NMDBUS_TYPE_WIFI_P2P_PEER_SKELETON, NULL));
}

