/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.6.1
 *
 * Copyright (c) 2022 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 30 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 29 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQByteArray.cpp"

#line 30 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 381 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 35 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQByteArray.cpp"
#line 25 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qflags.sip"
#include <qglobal.h>
#line 38 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQByteArray.cpp"
#line 28 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qbytearrayview.sip"
#include <qbytearrayview.h>
#line 41 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQByteArray.cpp"
#line 26 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 150 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qtextstream.sip"
#include <qtextstream.h>
#line 46 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQByteArray.cpp"
#line 24 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 49 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQByteArray.cpp"
#line 28 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 52 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQByteArray.cpp"
#line 34 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qbytearray.sip"
// This is needed by __hash__().
#include <qhash.h>


// Convenience function for converting a QByteArray to a Python str object.
static PyObject *QByteArrayToPyStr(QByteArray *ba)
{
    char *data = ba->data();

    if (data)
        // QByteArrays may have embedded '\0's so set the size explicitly.    
        return PyBytes_FromStringAndSize(data, ba->size());

    return PyBytes_FromString("");
}
#line 69 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQByteArray.cpp"


PyDoc_STRVAR(doc_QByteArray_resize, "resize(self, int)");

extern "C" {static PyObject *meth_QByteArray_resize(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_resize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::qsizetype a0;
         ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QByteArray, &sipCpp, &a0))
        {
            sipCpp->resize(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_resize, doc_QByteArray_resize);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_fill, "fill(self, bytes, size: int = -1) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_fill(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_fill(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        char a0;
         ::qsizetype a1 = -1;
         ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_size,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bc|n", &sipSelf, sipType_QByteArray, &sipCpp, &a0, &a1))
        {
             ::QByteArray*sipRes;

            sipRes = &sipCpp->fill(a0,a1);

            return sipConvertFromType(sipRes,sipType_QByteArray,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_fill, doc_QByteArray_fill);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_clear, "clear(self)");

extern "C" {static PyObject *meth_QByteArray_clear(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_clear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            sipCpp->clear();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_clear, doc_QByteArray_clear);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_indexOf, "indexOf(self, Union[QByteArray, bytes, bytearray, memoryview], from_: int = 0) -> int");

extern "C" {static PyObject *meth_QByteArray_indexOf(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_indexOf(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QByteArrayView* a0;
        int a0State = 0;
        void *a0UserState = SIP_NULLPTR;
         ::qsizetype a1 = 0;
        const  ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_from,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|n", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArrayView, &a0, &a0State, &a0UserState, &a1))
        {
             ::qsizetype sipRes;

            sipRes = sipCpp->indexOf(*a0,a1);
            sipReleaseTypeUS(a0, sipType_QByteArrayView, a0State, a0UserState);

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_indexOf, doc_QByteArray_indexOf);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_lastIndexOf, "lastIndexOf(self, Union[QByteArray, bytes, bytearray, memoryview], from_: int = -1) -> int");

extern "C" {static PyObject *meth_QByteArray_lastIndexOf(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_lastIndexOf(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QByteArrayView* a0;
        int a0State = 0;
        void *a0UserState = SIP_NULLPTR;
         ::qsizetype a1 = -1;
        const  ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_from,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|n", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArrayView, &a0, &a0State, &a0UserState, &a1))
        {
             ::qsizetype sipRes;

            sipRes = sipCpp->lastIndexOf(*a0,a1);
            sipReleaseTypeUS(a0, sipType_QByteArrayView, a0State, a0UserState);

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_lastIndexOf, doc_QByteArray_lastIndexOf);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_count, "count(self, Union[QByteArray, bytes, bytearray, memoryview]) -> int\n"
"count(self) -> int");

extern "C" {static PyObject *meth_QByteArray_count(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_count(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QByteArrayView* a0;
        int a0State = 0;
        void *a0UserState = SIP_NULLPTR;
        const  ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArrayView, &a0, &a0State, &a0UserState))
        {
             ::qsizetype sipRes;

            sipRes = sipCpp->count(*a0);
            sipReleaseTypeUS(a0, sipType_QByteArrayView, a0State, a0UserState);

            return PyLong_FromLongLong(sipRes);
        }
    }

    {
        const  ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
             ::qsizetype sipRes;

            sipRes = sipCpp->count();

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_count, doc_QByteArray_count);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_left, "left(self, int) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_left(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_left(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::qsizetype a0;
        const  ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QByteArray, &sipCpp, &a0))
        {
             ::QByteArray*sipRes;

            sipRes = new  ::QByteArray(sipCpp->left(a0));

            return sipConvertFromNewType(sipRes,sipType_QByteArray,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_left, doc_QByteArray_left);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_right, "right(self, int) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_right(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_right(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::qsizetype a0;
        const  ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QByteArray, &sipCpp, &a0))
        {
             ::QByteArray*sipRes;

            sipRes = new  ::QByteArray(sipCpp->right(a0));

            return sipConvertFromNewType(sipRes,sipType_QByteArray,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_right, doc_QByteArray_right);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_mid, "mid(self, int, length: int = -1) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_mid(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_mid(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::qsizetype a0;
         ::qsizetype a1 = -1;
        const  ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_length,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bn|n", &sipSelf, sipType_QByteArray, &sipCpp, &a0, &a1))
        {
             ::QByteArray*sipRes;

            sipRes = new  ::QByteArray(sipCpp->mid(a0,a1));

            return sipConvertFromNewType(sipRes,sipType_QByteArray,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_mid, doc_QByteArray_mid);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_first, "first(self, int) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_first(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_first(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::qsizetype a0;
        const  ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QByteArray, &sipCpp, &a0))
        {
             ::QByteArray*sipRes;

            sipRes = new  ::QByteArray(sipCpp->first(a0));

            return sipConvertFromNewType(sipRes,sipType_QByteArray,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_first, doc_QByteArray_first);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_last, "last(self, int) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_last(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_last(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::qsizetype a0;
        const  ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QByteArray, &sipCpp, &a0))
        {
             ::QByteArray*sipRes;

            sipRes = new  ::QByteArray(sipCpp->last(a0));

            return sipConvertFromNewType(sipRes,sipType_QByteArray,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_last, doc_QByteArray_last);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_startsWith, "startsWith(self, Union[QByteArray, bytes, bytearray, memoryview]) -> bool");

extern "C" {static PyObject *meth_QByteArray_startsWith(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_startsWith(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QByteArrayView* a0;
        int a0State = 0;
        void *a0UserState = SIP_NULLPTR;
        const  ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArrayView, &a0, &a0State, &a0UserState))
        {
            bool sipRes;

            sipRes = sipCpp->startsWith(*a0);
            sipReleaseTypeUS(a0, sipType_QByteArrayView, a0State, a0UserState);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_startsWith, doc_QByteArray_startsWith);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_endsWith, "endsWith(self, Union[QByteArray, bytes, bytearray, memoryview]) -> bool");

extern "C" {static PyObject *meth_QByteArray_endsWith(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_endsWith(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QByteArrayView* a0;
        int a0State = 0;
        void *a0UserState = SIP_NULLPTR;
        const  ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArrayView, &a0, &a0State, &a0UserState))
        {
            bool sipRes;

            sipRes = sipCpp->endsWith(*a0);
            sipReleaseTypeUS(a0, sipType_QByteArrayView, a0State, a0UserState);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_endsWith, doc_QByteArray_endsWith);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_truncate, "truncate(self, int)");

extern "C" {static PyObject *meth_QByteArray_truncate(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_truncate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::qsizetype a0;
         ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QByteArray, &sipCpp, &a0))
        {
            sipCpp->truncate(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_truncate, doc_QByteArray_truncate);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_chop, "chop(self, int)");

extern "C" {static PyObject *meth_QByteArray_chop(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_chop(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::qsizetype a0;
         ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QByteArray, &sipCpp, &a0))
        {
            sipCpp->chop(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_chop, doc_QByteArray_chop);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_toLower, "toLower(self) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_toLower(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toLower(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
             ::QByteArray*sipRes;

            sipRes = new  ::QByteArray(sipCpp->toLower());

            return sipConvertFromNewType(sipRes,sipType_QByteArray,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toLower, doc_QByteArray_toLower);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_toUpper, "toUpper(self) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_toUpper(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toUpper(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
             ::QByteArray*sipRes;

            sipRes = new  ::QByteArray(sipCpp->toUpper());

            return sipConvertFromNewType(sipRes,sipType_QByteArray,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toUpper, doc_QByteArray_toUpper);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_trimmed, "trimmed(self) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_trimmed(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_trimmed(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
             ::QByteArray*sipRes;

            sipRes = new  ::QByteArray(sipCpp->trimmed());

            return sipConvertFromNewType(sipRes,sipType_QByteArray,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_trimmed, doc_QByteArray_trimmed);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_simplified, "simplified(self) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_simplified(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_simplified(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
             ::QByteArray*sipRes;

            sipRes = new  ::QByteArray(sipCpp->simplified());

            return sipConvertFromNewType(sipRes,sipType_QByteArray,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_simplified, doc_QByteArray_simplified);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_leftJustified, "leftJustified(self, int, fill: bytes = ' ', truncate: bool = False) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_leftJustified(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_leftJustified(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::qsizetype a0;
        char a1 = ' ';
        bool a2 = 0;
        const  ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_fill,
            sipName_truncate,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bn|cb", &sipSelf, sipType_QByteArray, &sipCpp, &a0, &a1, &a2))
        {
             ::QByteArray*sipRes;

            sipRes = new  ::QByteArray(sipCpp->leftJustified(a0,a1,a2));

            return sipConvertFromNewType(sipRes,sipType_QByteArray,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_leftJustified, doc_QByteArray_leftJustified);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_rightJustified, "rightJustified(self, int, fill: bytes = ' ', truncate: bool = False) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_rightJustified(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_rightJustified(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::qsizetype a0;
        char a1 = ' ';
        bool a2 = 0;
        const  ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_fill,
            sipName_truncate,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bn|cb", &sipSelf, sipType_QByteArray, &sipCpp, &a0, &a1, &a2))
        {
             ::QByteArray*sipRes;

            sipRes = new  ::QByteArray(sipCpp->rightJustified(a0,a1,a2));

            return sipConvertFromNewType(sipRes,sipType_QByteArray,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_rightJustified, doc_QByteArray_rightJustified);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_prepend, "prepend(self, Union[QByteArray, bytes, bytearray, memoryview]) -> QByteArray\n"
"prepend(self, int, bytes) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_prepend(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_prepend(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QByteArrayView* a0;
        int a0State = 0;
        void *a0UserState = SIP_NULLPTR;
         ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArrayView, &a0, &a0State, &a0UserState))
        {
             ::QByteArray*sipRes;

            sipRes = &sipCpp->prepend(*a0);
            sipReleaseTypeUS(a0, sipType_QByteArrayView, a0State, a0UserState);

            return sipConvertFromType(sipRes,sipType_QByteArray,SIP_NULLPTR);
        }
    }

    {
         ::qsizetype a0;
        char a1;
         ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bnc", &sipSelf, sipType_QByteArray, &sipCpp, &a0, &a1))
        {
             ::QByteArray*sipRes;

            sipRes = &sipCpp->prepend(a0,a1);

            return sipConvertFromType(sipRes,sipType_QByteArray,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_prepend, doc_QByteArray_prepend);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_append, "append(self, Union[QByteArray, bytes, bytearray, memoryview]) -> QByteArray\n"
"append(self, int, bytes) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_append(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_append(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QByteArrayView* a0;
        int a0State = 0;
        void *a0UserState = SIP_NULLPTR;
         ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArrayView, &a0, &a0State, &a0UserState))
        {
             ::QByteArray*sipRes;

            sipRes = &sipCpp->append(*a0);
            sipReleaseTypeUS(a0, sipType_QByteArrayView, a0State, a0UserState);

            return sipConvertFromType(sipRes,sipType_QByteArray,SIP_NULLPTR);
        }
    }

    {
         ::qsizetype a0;
        char a1;
         ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bnc", &sipSelf, sipType_QByteArray, &sipCpp, &a0, &a1))
        {
             ::QByteArray*sipRes;

            sipRes = &sipCpp->append(a0,a1);

            return sipConvertFromType(sipRes,sipType_QByteArray,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_append, doc_QByteArray_append);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_insert, "insert(self, int, Union[QByteArray, bytes, bytearray, memoryview]) -> QByteArray\n"
"insert(self, int, int, bytes) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_insert(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_insert(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::qsizetype a0;
         ::QByteArrayView* a1;
        int a1State = 0;
        void *a1UserState = SIP_NULLPTR;
         ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BnJ1", &sipSelf, sipType_QByteArray, &sipCpp, &a0, sipType_QByteArrayView, &a1, &a1State, &a1UserState))
        {
             ::QByteArray*sipRes;

            sipRes = &sipCpp->insert(a0,*a1);
            sipReleaseTypeUS(a1, sipType_QByteArrayView, a1State, a1UserState);

            return sipConvertFromType(sipRes,sipType_QByteArray,SIP_NULLPTR);
        }
    }

    {
         ::qsizetype a0;
         ::qsizetype a1;
        char a2;
         ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bnnc", &sipSelf, sipType_QByteArray, &sipCpp, &a0, &a1, &a2))
        {
             ::QByteArray*sipRes;

            sipRes = &sipCpp->insert(a0,a1,a2);

            return sipConvertFromType(sipRes,sipType_QByteArray,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_insert, doc_QByteArray_insert);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_remove, "remove(self, int, int) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_remove(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_remove(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::qsizetype a0;
         ::qsizetype a1;
         ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bnn", &sipSelf, sipType_QByteArray, &sipCpp, &a0, &a1))
        {
             ::QByteArray*sipRes;

            sipRes = &sipCpp->remove(a0,a1);

            return sipConvertFromType(sipRes,sipType_QByteArray,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_remove, doc_QByteArray_remove);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_replace, "replace(self, Union[QByteArray, bytes, bytearray, memoryview], Union[QByteArray, bytes, bytearray, memoryview]) -> QByteArray\n"
"replace(self, int, int, Union[QByteArray, bytes, bytearray, memoryview]) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_replace(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_replace(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QByteArrayView* a0;
        int a0State = 0;
        void *a0UserState = SIP_NULLPTR;
         ::QByteArrayView* a1;
        int a1State = 0;
        void *a1UserState = SIP_NULLPTR;
         ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1J1", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArrayView, &a0, &a0State, &a0UserState, sipType_QByteArrayView, &a1, &a1State, &a1UserState))
        {
             ::QByteArray*sipRes;

            sipRes = &sipCpp->replace(*a0,*a1);
            sipReleaseTypeUS(a0, sipType_QByteArrayView, a0State, a0UserState);
            sipReleaseTypeUS(a1, sipType_QByteArrayView, a1State, a1UserState);

            return sipConvertFromType(sipRes,sipType_QByteArray,SIP_NULLPTR);
        }
    }

    {
         ::qsizetype a0;
         ::qsizetype a1;
         ::QByteArrayView* a2;
        int a2State = 0;
        void *a2UserState = SIP_NULLPTR;
         ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BnnJ1", &sipSelf, sipType_QByteArray, &sipCpp, &a0, &a1, sipType_QByteArrayView, &a2, &a2State, &a2UserState))
        {
             ::QByteArray*sipRes;

            sipRes = &sipCpp->replace(a0,a1,*a2);
            sipReleaseTypeUS(a2, sipType_QByteArrayView, a2State, a2UserState);

            return sipConvertFromType(sipRes,sipType_QByteArray,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_replace, doc_QByteArray_replace);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_split, "split(self, bytes) -> List[QByteArray]");

extern "C" {static PyObject *meth_QByteArray_split(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_split(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        char a0;
        const  ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bc", &sipSelf, sipType_QByteArray, &sipCpp, &a0))
        {
            QList< ::QByteArray>*sipRes;

            sipRes = new QList< ::QByteArray>(sipCpp->split(a0));

            return sipConvertFromNewType(sipRes,sipType_QList_0100QByteArray,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_split, doc_QByteArray_split);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_toShort, "toShort(self, base: int = 10) -> Tuple[int, bool]");

extern "C" {static PyObject *meth_QByteArray_toShort(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toShort(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        int a1 = 10;
        const  ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_base,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|i", &sipSelf, sipType_QByteArray, &sipCpp, &a1))
        {
            short sipRes;

            sipRes = sipCpp->toShort(&a0,a1);

            return sipBuildResult(0,"(hb)",sipRes,a0);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toShort, doc_QByteArray_toShort);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_toUShort, "toUShort(self, base: int = 10) -> Tuple[int, bool]");

extern "C" {static PyObject *meth_QByteArray_toUShort(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toUShort(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        int a1 = 10;
        const  ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_base,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|i", &sipSelf, sipType_QByteArray, &sipCpp, &a1))
        {
             ::ushort sipRes;

            sipRes = sipCpp->toUShort(&a0,a1);

            return sipBuildResult(0,"(tb)",sipRes,a0);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toUShort, doc_QByteArray_toUShort);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_toInt, "toInt(self, base: int = 10) -> Tuple[int, bool]");

extern "C" {static PyObject *meth_QByteArray_toInt(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toInt(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        int a1 = 10;
        const  ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_base,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|i", &sipSelf, sipType_QByteArray, &sipCpp, &a1))
        {
            int sipRes;

            sipRes = sipCpp->toInt(&a0,a1);

            return sipBuildResult(0,"(ib)",sipRes,a0);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toInt, doc_QByteArray_toInt);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_toUInt, "toUInt(self, base: int = 10) -> Tuple[int, bool]");

extern "C" {static PyObject *meth_QByteArray_toUInt(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toUInt(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        int a1 = 10;
        const  ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_base,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|i", &sipSelf, sipType_QByteArray, &sipCpp, &a1))
        {
             ::uint sipRes;

            sipRes = sipCpp->toUInt(&a0,a1);

            return sipBuildResult(0,"(ub)",sipRes,a0);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toUInt, doc_QByteArray_toUInt);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_toLong, "toLong(self, base: int = 10) -> Tuple[int, bool]");

extern "C" {static PyObject *meth_QByteArray_toLong(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toLong(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        int a1 = 10;
        const  ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_base,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|i", &sipSelf, sipType_QByteArray, &sipCpp, &a1))
        {
            long sipRes;

            sipRes = sipCpp->toLong(&a0,a1);

            return sipBuildResult(0,"(lb)",sipRes,a0);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toLong, doc_QByteArray_toLong);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_toULong, "toULong(self, base: int = 10) -> Tuple[int, bool]");

extern "C" {static PyObject *meth_QByteArray_toULong(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toULong(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        int a1 = 10;
        const  ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_base,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|i", &sipSelf, sipType_QByteArray, &sipCpp, &a1))
        {
             ::ulong sipRes;

            sipRes = sipCpp->toULong(&a0,a1);

            return sipBuildResult(0,"(mb)",sipRes,a0);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toULong, doc_QByteArray_toULong);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_toLongLong, "toLongLong(self, base: int = 10) -> Tuple[int, bool]");

extern "C" {static PyObject *meth_QByteArray_toLongLong(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toLongLong(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        int a1 = 10;
        const  ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_base,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|i", &sipSelf, sipType_QByteArray, &sipCpp, &a1))
        {
             ::qlonglong sipRes;

            sipRes = sipCpp->toLongLong(&a0,a1);

            return sipBuildResult(0,"(nb)",sipRes,a0);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toLongLong, doc_QByteArray_toLongLong);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_toULongLong, "toULongLong(self, base: int = 10) -> Tuple[int, bool]");

extern "C" {static PyObject *meth_QByteArray_toULongLong(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toULongLong(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        int a1 = 10;
        const  ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_base,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|i", &sipSelf, sipType_QByteArray, &sipCpp, &a1))
        {
             ::qulonglong sipRes;

            sipRes = sipCpp->toULongLong(&a0,a1);

            return sipBuildResult(0,"(ob)",sipRes,a0);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toULongLong, doc_QByteArray_toULongLong);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_toFloat, "toFloat(self) -> Tuple[float, bool]");

extern "C" {static PyObject *meth_QByteArray_toFloat(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toFloat(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        const  ::QByteArray *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            float sipRes;

            sipRes = sipCpp->toFloat(&a0);

            return sipBuildResult(0,"(fb)",sipRes,a0);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toFloat, doc_QByteArray_toFloat);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_toDouble, "toDouble(self) -> Tuple[float, bool]");

extern "C" {static PyObject *meth_QByteArray_toDouble(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toDouble(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        const  ::QByteArray *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            double sipRes;

            sipRes = sipCpp->toDouble(&a0);

            return sipBuildResult(0,"(db)",sipRes,a0);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toDouble, doc_QByteArray_toDouble);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_toBase64, "toBase64(self, options: QByteArray.Base64Option = QByteArray.Base64Encoding) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_toBase64(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toBase64(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QByteArray::Base64Options a0def = QByteArray::Base64Encoding;
         ::QByteArray::Base64Options* a0 = &a0def;
        int a0State = 0;
        const  ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_options,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|J1", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QFlags_0100QByteArray_Base64Option, &a0, &a0State))
        {
             ::QByteArray*sipRes;

            sipRes = new  ::QByteArray(sipCpp->toBase64(*a0));
            sipReleaseType(a0, sipType_QFlags_0100QByteArray_Base64Option, a0State);

            return sipConvertFromNewType(sipRes,sipType_QByteArray,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toBase64, doc_QByteArray_toBase64);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_setNum, "setNum(self, float, format: str = 'g', precision: int = 6) -> QByteArray\n"
"setNum(self, int, base: int = 10) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_setNum(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_setNum(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        double a0;
        char a1 = 'g';
        int a2 = 6;
         ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_format,
            sipName_precision,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BXd|aAi", &sipSelf, sipType_QByteArray, &sipCpp, &a0, &a1, &a2))
        {
             ::QByteArray*sipRes;

            sipRes = &sipCpp->setNum(a0,a1,a2);

            return sipConvertFromType(sipRes,sipType_QByteArray,SIP_NULLPTR);
        }
    }

    {
        PyObject * a0;
        int a1 = 10;
         ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_base,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BP0|i", &sipSelf, sipType_QByteArray, &sipCpp, &a0, &a1))
        {
             ::QByteArray*sipRes = 0;
            sipErrorState sipError = sipErrorNone;

#line 172 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qbytearray.sip"
        qlonglong val = sipLong_AsLongLong(a0);
        
        if (!PyErr_Occurred())
        {
            sipRes = &sipCpp->setNum(val, a1);
        }
        else
        {
            // If it is positive then it might fit an unsigned long long.
        
            qulonglong uval = sipLong_AsUnsignedLongLong(a0);
        
            if (!PyErr_Occurred())
            {
                sipRes = &sipCpp->setNum(uval, a1);
            }
            else
            {
                sipError = (PyErr_ExceptionMatches(PyExc_OverflowError)
                        ? sipErrorFail : sipErrorContinue);
            }
        }
#line 1405 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQByteArray.cpp"

            if (sipError == sipErrorFail)
                return 0;

            if (sipError == sipErrorNone)
            {
            return sipConvertFromType(sipRes,sipType_QByteArray,SIP_NULLPTR);
            }

            sipAddException(sipError, &sipParseErr);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_setNum, doc_QByteArray_setNum);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_number, "number(float, format: str = 'g', precision: int = 6) -> QByteArray\n"
"number(int, base: int = 10) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_number(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_number(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        double a0;
        char a1 = 'g';
        int a2 = 6;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_format,
            sipName_precision,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "CXd|aAi", &sipSelf, &a0, &a1, &a2))
        {
             ::QByteArray*sipRes;

            sipRes = new  ::QByteArray( ::QByteArray::number(a0,a1,a2));

            return sipConvertFromNewType(sipRes,sipType_QByteArray,SIP_NULLPTR);
        }
    }

    {
        PyObject * a0;
        int a1 = 10;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_base,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "CP0|i", &sipSelf, &a0, &a1))
        {
             ::QByteArray*sipRes = 0;
            sipErrorState sipError = sipErrorNone;

#line 199 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qbytearray.sip"
        qlonglong val = sipLong_AsLongLong(a0);
        
        if (!PyErr_Occurred())
        {
            sipRes = new QByteArray(QByteArray::number(val, a1));
        }
        else
        {
            // If it is positive then it might fit an unsigned long long.
        
            qulonglong uval = sipLong_AsUnsignedLongLong(a0);
        
            if (!PyErr_Occurred())
            {
                sipRes = new QByteArray(QByteArray::number(uval, a1));
            }
            else
            {
                sipError = (PyErr_ExceptionMatches(PyExc_OverflowError)
                        ? sipErrorFail : sipErrorContinue);
            }
        }
#line 1493 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQByteArray.cpp"

            if (sipError == sipErrorFail)
                return 0;

            if (sipError == sipErrorNone)
            {
            return sipConvertFromNewType(sipRes,sipType_QByteArray,SIP_NULLPTR);
            }

            sipAddException(sipError, &sipParseErr);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_number, doc_QByteArray_number);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_fromBase64, "fromBase64(QByteArray, options: QByteArray.Base64Option = QByteArray.Base64Encoding) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_fromBase64(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_fromBase64(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QByteArray* a0;
        int a0State = 0;
         ::QByteArray::Base64Options a1def = QByteArray::Base64Encoding;
         ::QByteArray::Base64Options* a1 = &a1def;
        int a1State = 0;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_options,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "CJ1|J1", &sipSelf, sipType_QByteArray, &a0, &a0State, sipType_QFlags_0100QByteArray_Base64Option, &a1, &a1State))
        {
             ::QByteArray*sipRes;

            sipRes = new  ::QByteArray( ::QByteArray::fromBase64(*a0,*a1));
            sipReleaseType(const_cast< ::QByteArray *>(a0), sipType_QByteArray, a0State);
            sipReleaseType(a1, sipType_QFlags_0100QByteArray_Base64Option, a1State);

            return sipConvertFromNewType(sipRes,sipType_QByteArray,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_fromBase64, doc_QByteArray_fromBase64);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_fromHex, "fromHex(QByteArray) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_fromHex(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_fromHex(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QByteArray* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "CJ1", &sipSelf, sipType_QByteArray, &a0, &a0State))
        {
             ::QByteArray*sipRes;

            sipRes = new  ::QByteArray( ::QByteArray::fromHex(*a0));
            sipReleaseType(const_cast< ::QByteArray *>(a0), sipType_QByteArray, a0State);

            return sipConvertFromNewType(sipRes,sipType_QByteArray,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_fromHex, doc_QByteArray_fromHex);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_length, "length(self) -> int");

extern "C" {static PyObject *meth_QByteArray_length(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_length(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
             ::qsizetype sipRes;

            sipRes = sipCpp->length();

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_length, doc_QByteArray_length);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_isNull, "isNull(self) -> bool");

extern "C" {static PyObject *meth_QByteArray_isNull(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_isNull(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isNull();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_isNull, doc_QByteArray_isNull);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_size, "size(self) -> int");

extern "C" {static PyObject *meth_QByteArray_size(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_size(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
             ::qsizetype sipRes;

            sipRes = sipCpp->size();

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_size, doc_QByteArray_size);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_at, "at(self, int) -> bytes");

extern "C" {static PyObject *meth_QByteArray_at(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_at(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::qsizetype a0;
        const  ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QByteArray, &sipCpp, &a0))
        {
            char sipRes;

            sipRes = sipCpp->at(a0);

            return PyBytes_FromStringAndSize(&sipRes,1);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_at, doc_QByteArray_at);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_isEmpty, "isEmpty(self) -> bool");

extern "C" {static PyObject *meth_QByteArray_isEmpty(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_isEmpty(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isEmpty();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_isEmpty, doc_QByteArray_isEmpty);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_data, "data(self) -> bytes");

extern "C" {static PyObject *meth_QByteArray_data(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_data(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;

#line 323 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qbytearray.sip"
        // QByteArrays may contain embedded '\0's so set the size explicitly.
        
        char *res = sipCpp->data();
        qsizetype len = sipCpp->size();
        
        if (res)
        {
            if ((sipRes = PyBytes_FromStringAndSize(res, (Py_ssize_t)len)) == NULL)
                sipIsErr = 1;
        }
        else
        {
            Py_INCREF(Py_None);
            sipRes = Py_None;
        }
#line 1748 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQByteArray.cpp"

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_data, doc_QByteArray_data);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_capacity, "capacity(self) -> int");

extern "C" {static PyObject *meth_QByteArray_capacity(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_capacity(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
             ::qsizetype sipRes;

            sipRes = sipCpp->capacity();

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_capacity, doc_QByteArray_capacity);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_reserve, "reserve(self, int)");

extern "C" {static PyObject *meth_QByteArray_reserve(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_reserve(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::qsizetype a0;
         ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QByteArray, &sipCpp, &a0))
        {
            sipCpp->reserve(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_reserve, doc_QByteArray_reserve);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_squeeze, "squeeze(self)");

extern "C" {static PyObject *meth_QByteArray_squeeze(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_squeeze(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            sipCpp->squeeze();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_squeeze, doc_QByteArray_squeeze);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_push_back, "push_back(self, Union[QByteArray, bytes, bytearray, memoryview])");

extern "C" {static PyObject *meth_QByteArray_push_back(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_push_back(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QByteArrayView* a0;
        int a0State = 0;
        void *a0UserState = SIP_NULLPTR;
         ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArrayView, &a0, &a0State, &a0UserState))
        {
            sipCpp->push_back(*a0);
            sipReleaseTypeUS(a0, sipType_QByteArrayView, a0State, a0UserState);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_push_back, doc_QByteArray_push_back);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_push_front, "push_front(self, Union[QByteArray, bytes, bytearray, memoryview])");

extern "C" {static PyObject *meth_QByteArray_push_front(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_push_front(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QByteArrayView* a0;
        int a0State = 0;
        void *a0UserState = SIP_NULLPTR;
         ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArrayView, &a0, &a0State, &a0UserState))
        {
            sipCpp->push_front(*a0);
            sipReleaseTypeUS(a0, sipType_QByteArrayView, a0State, a0UserState);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_push_front, doc_QByteArray_push_front);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_contains, "contains(self, Union[QByteArray, bytes, bytearray, memoryview]) -> bool");

extern "C" {static PyObject *meth_QByteArray_contains(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_contains(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QByteArrayView* a0;
        int a0State = 0;
        void *a0UserState = SIP_NULLPTR;
        const  ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArrayView, &a0, &a0State, &a0UserState))
        {
            bool sipRes;

            sipRes = sipCpp->contains(*a0);
            sipReleaseTypeUS(a0, sipType_QByteArrayView, a0State, a0UserState);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_contains, doc_QByteArray_contains);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_toHex, "toHex(self, separator: bytes = '\000') -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_toHex(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toHex(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        char a0 = '\000';
        const  ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_separator,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|c", &sipSelf, sipType_QByteArray, &sipCpp, &a0))
        {
             ::QByteArray*sipRes;

            sipRes = new  ::QByteArray(sipCpp->toHex(a0));

            return sipConvertFromNewType(sipRes,sipType_QByteArray,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toHex, doc_QByteArray_toHex);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_toPercentEncoding, "toPercentEncoding(self, exclude: QByteArray = QByteArray(), include: QByteArray = QByteArray(), percent: str = '%') -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_toPercentEncoding(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_toPercentEncoding(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QByteArray& a0def = QByteArray();
        const  ::QByteArray* a0 = &a0def;
        int a0State = 0;
        const  ::QByteArray& a1def = QByteArray();
        const  ::QByteArray* a1 = &a1def;
        int a1State = 0;
        char a2 = '%';
        const  ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_exclude,
            sipName_include,
            sipName_percent,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|J1J1aA", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArray, &a0, &a0State, sipType_QByteArray, &a1, &a1State, &a2))
        {
             ::QByteArray*sipRes;

            sipRes = new  ::QByteArray(sipCpp->toPercentEncoding(*a0,*a1,a2));
            sipReleaseType(const_cast< ::QByteArray *>(a0), sipType_QByteArray, a0State);
            sipReleaseType(const_cast< ::QByteArray *>(a1), sipType_QByteArray, a1State);

            return sipConvertFromNewType(sipRes,sipType_QByteArray,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_toPercentEncoding, doc_QByteArray_toPercentEncoding);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_fromPercentEncoding, "fromPercentEncoding(QByteArray, percent: str = '%') -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_fromPercentEncoding(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_fromPercentEncoding(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QByteArray* a0;
        int a0State = 0;
        char a1 = '%';

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_percent,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "CJ1|aA", &sipSelf, sipType_QByteArray, &a0, &a0State, &a1))
        {
             ::QByteArray*sipRes;

            sipRes = new  ::QByteArray( ::QByteArray::fromPercentEncoding(*a0,a1));
            sipReleaseType(const_cast< ::QByteArray *>(a0), sipType_QByteArray, a0State);

            return sipConvertFromNewType(sipRes,sipType_QByteArray,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_fromPercentEncoding, doc_QByteArray_fromPercentEncoding);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_repeated, "repeated(self, int) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_repeated(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_repeated(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::qsizetype a0;
        const  ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QByteArray, &sipCpp, &a0))
        {
             ::QByteArray*sipRes;

            sipRes = new  ::QByteArray(sipCpp->repeated(a0));

            return sipConvertFromNewType(sipRes,sipType_QByteArray,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_repeated, doc_QByteArray_repeated);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_swap, "swap(self, QByteArray)");

extern "C" {static PyObject *meth_QByteArray_swap(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_swap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QByteArray* a0;
         ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArray, &a0))
        {
            sipCpp->swap(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_swap, doc_QByteArray_swap);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_chopped, "chopped(self, int) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_chopped(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_chopped(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::qsizetype a0;
        const  ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QByteArray, &sipCpp, &a0))
        {
             ::QByteArray*sipRes;

            sipRes = new  ::QByteArray(sipCpp->chopped(a0));

            return sipConvertFromNewType(sipRes,sipType_QByteArray,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_chopped, doc_QByteArray_chopped);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_compare, "compare(self, Union[QByteArray, bytes, bytearray, memoryview], cs: Qt.CaseSensitivity = Qt.CaseSensitive) -> int");

extern "C" {static PyObject *meth_QByteArray_compare(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_compare(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QByteArrayView* a0;
        int a0State = 0;
        void *a0UserState = SIP_NULLPTR;
         ::Qt::CaseSensitivity a1 = Qt::CaseSensitive;
        const  ::QByteArray *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_cs,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|E", &sipSelf, sipType_QByteArray, &sipCpp, sipType_QByteArrayView, &a0, &a0State, &a0UserState, sipType_Qt_CaseSensitivity, &a1))
        {
            int sipRes;

            sipRes = sipCpp->compare(*a0,a1);
            sipReleaseTypeUS(a0, sipType_QByteArrayView, a0State, a0UserState);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_compare, doc_QByteArray_compare);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_isUpper, "isUpper(self) -> bool");

extern "C" {static PyObject *meth_QByteArray_isUpper(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_isUpper(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isUpper();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_isUpper, doc_QByteArray_isUpper);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_isLower, "isLower(self) -> bool");

extern "C" {static PyObject *meth_QByteArray_isLower(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_isLower(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isLower();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_isLower, doc_QByteArray_isLower);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_fromBase64Encoding, "fromBase64Encoding(QByteArray, options: QByteArray.Base64Option = QByteArray.Base64Encoding) -> QByteArray.FromBase64Result");

extern "C" {static PyObject *meth_QByteArray_fromBase64Encoding(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QByteArray_fromBase64Encoding(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QByteArray* a0;
        int a0State = 0;
         ::QByteArray::Base64Options a1def = QByteArray::Base64Encoding;
         ::QByteArray::Base64Options* a1 = &a1def;
        int a1State = 0;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_options,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "CJ1|J1", &sipSelf, sipType_QByteArray, &a0, &a0State, sipType_QFlags_0100QByteArray_Base64Option, &a1, &a1State))
        {
             ::QByteArray::FromBase64Result*sipRes;

            sipRes = new  ::QByteArray::FromBase64Result( ::QByteArray::fromBase64Encoding(*a0,*a1));
            sipReleaseType(const_cast< ::QByteArray *>(a0), sipType_QByteArray, a0State);
            sipReleaseType(a1, sipType_QFlags_0100QByteArray_Base64Option, a1State);

            return sipConvertFromNewType(sipRes,sipType_QByteArray_FromBase64Result,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_fromBase64Encoding, doc_QByteArray_fromBase64Encoding);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_sliced, "sliced(self, int) -> QByteArray\n"
"sliced(self, int, int) -> QByteArray");

extern "C" {static PyObject *meth_QByteArray_sliced(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_sliced(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::qsizetype a0;
        const  ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QByteArray, &sipCpp, &a0))
        {
             ::QByteArray*sipRes;

            sipRes = new  ::QByteArray(sipCpp->sliced(a0));

            return sipConvertFromNewType(sipRes,sipType_QByteArray,SIP_NULLPTR);
        }
    }

    {
         ::qsizetype a0;
         ::qsizetype a1;
        const  ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bnn", &sipSelf, sipType_QByteArray, &sipCpp, &a0, &a1))
        {
             ::QByteArray*sipRes;

            sipRes = new  ::QByteArray(sipCpp->sliced(a0,a1));

            return sipConvertFromNewType(sipRes,sipType_QByteArray,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_sliced, doc_QByteArray_sliced);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QByteArray_isValidUtf8, "isValidUtf8(self) -> bool");

extern "C" {static PyObject *meth_QByteArray_isValidUtf8(PyObject *, PyObject *);}
static PyObject *meth_QByteArray_isValidUtf8(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QByteArray *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QByteArray, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isValidUtf8();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName_isValidUtf8, doc_QByteArray_isValidUtf8);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QByteArray___add__(PyObject *,PyObject *);}
static PyObject *slot_QByteArray___add__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QByteArray* a0;
        int a0State = 0;
        const  ::QByteArray* a1;
        int a1State = 0;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J1J1", sipType_QByteArray, &a0, &a0State, sipType_QByteArray, &a1, &a1State))
        {
             ::QByteArray*sipRes;

            sipRes = new  ::QByteArray((*a0 + *a1));
            sipReleaseType(const_cast< ::QByteArray *>(a0), sipType_QByteArray, a0State);
            sipReleaseType(const_cast< ::QByteArray *>(a1), sipType_QByteArray, a1State);

            return sipConvertFromNewType(sipRes,sipType_QByteArray,SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, add_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QByteArray___imul__(PyObject *,int);}
static PyObject *slot_QByteArray___imul__(PyObject *sipSelf,int a0)
{
     ::QByteArray *sipCpp = reinterpret_cast< ::QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QByteArray));

    if (!sipCpp)
        return SIP_NULLPTR;


    {
        {
#line 312 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qbytearray.sip"
        QByteArray orig(*sipCpp);
        
        sipCpp->clear();
        
        while (a0-- > 0)
            *sipCpp += orig;
#line 2377 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQByteArray.cpp"

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_QByteArray___mul__(PyObject *,int);}
static PyObject *slot_QByteArray___mul__(PyObject *sipSelf,int a0)
{
     ::QByteArray *sipCpp = reinterpret_cast< ::QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QByteArray));

    if (!sipCpp)
        return SIP_NULLPTR;


    {
        {
             ::QByteArray*sipRes = 0;

#line 304 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qbytearray.sip"
        sipRes = new QByteArray();
        
        while (a0-- > 0)
            *sipRes += *sipCpp;
#line 2406 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQByteArray.cpp"

            return sipConvertFromNewType(sipRes,sipType_QByteArray,SIP_NULLPTR);
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_QByteArray___repr__(PyObject *);}
static PyObject *slot_QByteArray___repr__(PyObject *sipSelf)
{
     ::QByteArray *sipCpp = reinterpret_cast< ::QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QByteArray));

    if (!sipCpp)
        return SIP_NULLPTR;


    {
        {
            PyObject * sipRes = SIP_NULLPTR;

#line 285 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qbytearray.sip"
        if (sipCpp->isNull())
        {
            sipRes = PyUnicode_FromString("PyQt6.QtCore.QByteArray()");
        }
        else
        {
            PyObject *str = QByteArrayToPyStr(sipCpp);
        
            if (str)
            {
                sipRes = PyUnicode_FromFormat("PyQt6.QtCore.QByteArray(%R)", str);
        
                Py_DECREF(str);
            }
        }
#line 2445 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQByteArray.cpp"

            return sipRes;
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_QByteArray___str__(PyObject *);}
static PyObject *slot_QByteArray___str__(PyObject *sipSelf)
{
     ::QByteArray *sipCpp = reinterpret_cast< ::QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QByteArray));

    if (!sipCpp)
        return SIP_NULLPTR;


    {
        {
            PyObject * sipRes = SIP_NULLPTR;

#line 272 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qbytearray.sip"
        sipRes = QByteArrayToPyStr(sipCpp);
        
        PyObject *repr = PyObject_Repr(sipRes);
        
        if (repr)
        {
            Py_DECREF(sipRes);
            sipRes = repr;
        }
#line 2478 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQByteArray.cpp"

            return sipRes;
        }
    }

    return 0;
}


extern "C" {static Py_hash_t slot_QByteArray___hash__(PyObject *);}
static Py_hash_t slot_QByteArray___hash__(PyObject *sipSelf)
{
     ::QByteArray *sipCpp = reinterpret_cast< ::QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QByteArray));

    if (!sipCpp)
        return 0;


    {
        {
            Py_hash_t sipRes = 0;

#line 267 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qbytearray.sip"
        sipRes = qHash(*sipCpp);
#line 2503 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQByteArray.cpp"

            return sipRes;
        }
    }

    return 0;
}


extern "C" {static int slot_QByteArray___contains__(PyObject *,PyObject *);}
static int slot_QByteArray___contains__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QByteArray *sipCpp = reinterpret_cast< ::QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QByteArray));

    if (!sipCpp)
        return -1;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QByteArrayView* a0;
        int a0State = 0;
        void *a0UserState = SIP_NULLPTR;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QByteArrayView, &a0, &a0State, &a0UserState))
        {
            int sipRes = 0;

#line 262 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qbytearray.sip"
        sipRes = sipCpp->contains(*a0);
#line 2534 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQByteArray.cpp"
            sipReleaseTypeUS(const_cast< ::QByteArrayView *>(a0), sipType_QByteArrayView, a0State, a0UserState);

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName___contains__, SIP_NULLPTR);

    return -1;
}


extern "C" {static PyObject *slot_QByteArray___getitem__(PyObject *,PyObject *);}
static PyObject *slot_QByteArray___getitem__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QByteArray *sipCpp = reinterpret_cast< ::QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QByteArray));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::qsizetype a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1n", &a0))
        {
            char sipRes = 0;
            int sipIsErr = 0;

#line 232 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qbytearray.sip"
        Py_ssize_t idx = sipConvertFromSequenceIndex(a0, sipCpp->size());
        
        if (idx < 0)
            sipIsErr = 1;
        else
            sipRes = sipCpp->operator[]((qsizetype)idx);
#line 2572 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQByteArray.cpp"

            if (sipIsErr)
                return 0;

            return PyBytes_FromStringAndSize(&sipRes,1);
        }
    }

    {
        PyObject * a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1T", &PySlice_Type, &a0))
        {
             ::QByteArray*sipRes = 0;
            int sipIsErr = 0;

#line 242 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qbytearray.sip"
        Py_ssize_t start, stop, step, slicelength;
        
        if (sipConvertFromSliceObject(a0, sipCpp->size(), &start, &stop, &step, &slicelength) < 0)
        {
            sipIsErr = 1;
        }
        else
        {
            sipRes = new QByteArray();
        
            for (Py_ssize_t i = 0; i < slicelength; ++i)
            {
                sipRes->append(sipCpp->at((qsizetype)start));
                start += step;
            }
        }
#line 2606 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQByteArray.cpp"

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes,sipType_QByteArray,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QByteArray, sipName___getitem__, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static Py_ssize_t slot_QByteArray___len__(PyObject *);}
static Py_ssize_t slot_QByteArray___len__(PyObject *sipSelf)
{
     ::QByteArray *sipCpp = reinterpret_cast< ::QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QByteArray));

    if (!sipCpp)
        return 0;


    {
        {
            Py_ssize_t sipRes = 0;

#line 1 "Auto-generated"
            sipRes = (Py_ssize_t)sipCpp->size();
#line 2636 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQByteArray.cpp"

            return sipRes;
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_QByteArray___ge__(PyObject *,PyObject *);}
static PyObject *slot_QByteArray___ge__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QByteArray *sipCpp = reinterpret_cast< ::QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QByteArray));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QString* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QString, &a0, &a0State))
        {
            bool sipRes;

            sipRes = sipCpp-> ::QByteArray::operator>=(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const  ::QByteArray* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QByteArray, &a0, &a0State))
        {
            bool sipRes;

            sipRes = operator>=((*sipCpp), *a0);
            sipReleaseType(const_cast< ::QByteArray *>(a0), sipType_QByteArray, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, ge_slot, sipType_QByteArray, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QByteArray___le__(PyObject *,PyObject *);}
static PyObject *slot_QByteArray___le__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QByteArray *sipCpp = reinterpret_cast< ::QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QByteArray));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QString* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QString, &a0, &a0State))
        {
            bool sipRes;

            sipRes = sipCpp-> ::QByteArray::operator<=(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const  ::QByteArray* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QByteArray, &a0, &a0State))
        {
            bool sipRes;

            sipRes = operator<=((*sipCpp), *a0);
            sipReleaseType(const_cast< ::QByteArray *>(a0), sipType_QByteArray, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, le_slot, sipType_QByteArray, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QByteArray___gt__(PyObject *,PyObject *);}
static PyObject *slot_QByteArray___gt__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QByteArray *sipCpp = reinterpret_cast< ::QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QByteArray));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QString* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QString, &a0, &a0State))
        {
            bool sipRes;

            sipRes = sipCpp-> ::QByteArray::operator>(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const  ::QByteArray* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QByteArray, &a0, &a0State))
        {
            bool sipRes;

            sipRes = operator>((*sipCpp), *a0);
            sipReleaseType(const_cast< ::QByteArray *>(a0), sipType_QByteArray, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, gt_slot, sipType_QByteArray, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QByteArray___lt__(PyObject *,PyObject *);}
static PyObject *slot_QByteArray___lt__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QByteArray *sipCpp = reinterpret_cast< ::QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QByteArray));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QString* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QString, &a0, &a0State))
        {
            bool sipRes;

            sipRes = sipCpp-> ::QByteArray::operator<(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const  ::QByteArray* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QByteArray, &a0, &a0State))
        {
            bool sipRes;

            sipRes = operator<((*sipCpp), *a0);
            sipReleaseType(const_cast< ::QByteArray *>(a0), sipType_QByteArray, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, lt_slot, sipType_QByteArray, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QByteArray___ne__(PyObject *,PyObject *);}
static PyObject *slot_QByteArray___ne__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QByteArray *sipCpp = reinterpret_cast< ::QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QByteArray));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QString* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QString, &a0, &a0State))
        {
            bool sipRes;

            sipRes = sipCpp-> ::QByteArray::operator!=(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const  ::QByteArray* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QByteArray, &a0, &a0State))
        {
            bool sipRes;

            sipRes = operator!=((*sipCpp), *a0);
            sipReleaseType(const_cast< ::QByteArray *>(a0), sipType_QByteArray, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, ne_slot, sipType_QByteArray, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QByteArray___eq__(PyObject *,PyObject *);}
static PyObject *slot_QByteArray___eq__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QByteArray *sipCpp = reinterpret_cast< ::QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QByteArray));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QString* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QString, &a0, &a0State))
        {
            bool sipRes;

            sipRes = sipCpp-> ::QByteArray::operator==(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const  ::QByteArray* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QByteArray, &a0, &a0State))
        {
            bool sipRes;

            sipRes = operator==((*sipCpp), *a0);
            sipReleaseType(const_cast< ::QByteArray *>(a0), sipType_QByteArray, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, eq_slot, sipType_QByteArray, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QByteArray___iadd__(PyObject *,PyObject *);}
static PyObject *slot_QByteArray___iadd__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QByteArray *sipCpp = reinterpret_cast< ::QByteArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QByteArray));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QByteArrayView* a0;
        int a0State = 0;
        void *a0UserState = SIP_NULLPTR;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QByteArrayView, &a0, &a0State, &a0UserState))
        {
            sipCpp-> ::QByteArray::operator+=(*a0);
            sipReleaseTypeUS(a0, sipType_QByteArrayView, a0State, a0UserState);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    /* Raise an exception if the argument couldn't be parsed. */
    sipBadOperatorArg(sipSelf,sipArg,iconcat_slot);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QByteArray(void *, int);}
static void release_QByteArray(void *sipCppV, int)
{
    delete reinterpret_cast< ::QByteArray *>(sipCppV);
}


extern "C" {static int getbuffer_QByteArray(PyObject *, void *, sipBufferDef *);}
static int getbuffer_QByteArray(PyObject *sipSelf, void *sipCppV, sipBufferDef *sipBuffer)
{
     ::QByteArray *sipCpp = reinterpret_cast< ::QByteArray *>(sipCppV);
    int sipRes;

#line 102 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qbytearray.sip"
    Q_UNUSED(sipSelf);
    
    sipBuffer->bd_buffer = sipCpp->data();
    sipBuffer->bd_length = sipCpp->size();
    sipBuffer->bd_readonly = 0;
    
    sipRes = 0;
#line 2994 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQByteArray.cpp"

    return sipRes;
}


extern "C" {static PyObject *pickle_QByteArray(void *);}
static PyObject *pickle_QByteArray(void *sipCppV)
{
     ::QByteArray *sipCpp = reinterpret_cast< ::QByteArray *>(sipCppV);
    PyObject *sipRes;

#line 112 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qbytearray.sip"
    sipRes = Py_BuildValue("(y#)", sipCpp->data(), static_cast<Py_ssize_t>(sipCpp->size()));
#line 3008 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQByteArray.cpp"

    return sipRes;
}


extern "C" {static void *array_QByteArray(Py_ssize_t);}
static void *array_QByteArray(Py_ssize_t sipNrElem)
{
    return new  ::QByteArray[sipNrElem];
}


extern "C" {static void assign_QByteArray(void *, Py_ssize_t, void *);}
static void assign_QByteArray(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QByteArray *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QByteArray *>(sipSrc);
}


extern "C" {static void *copy_QByteArray(const void *, Py_ssize_t);}
static void *copy_QByteArray(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new  ::QByteArray(reinterpret_cast<const  ::QByteArray *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QByteArray(sipSimpleWrapper *);}
static void dealloc_QByteArray(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QByteArray(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QByteArray(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QByteArray(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::QByteArray *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new  ::QByteArray();

            return sipCpp;
        }
    }

    {
         ::qsizetype a0;
        char a1;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "nc", &a0, &a1))
        {
            sipCpp = new  ::QByteArray(a0,a1);

            return sipCpp;
        }
    }

    {
        const  ::QByteArray* a0;
        int a0State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J1", sipType_QByteArray, &a0, &a0State))
        {
            sipCpp = new  ::QByteArray(*a0);
            sipReleaseType(const_cast< ::QByteArray *>(a0), sipType_QByteArray, a0State);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


extern "C" {static int convertTo_QByteArray(PyObject *, void **, int *, PyObject *, void **);}
static int convertTo_QByteArray(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj, void **)
{
     ::QByteArray **sipCppPtr = reinterpret_cast< ::QByteArray **>(sipCppPtrV);

#line 52 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qbytearray.sip"
// Accept anything that implements the buffer protocol (including QByteArray
// itself).

if (sipIsErr == NULL)
    return sipGetBufferInfo(sipPy, NULL);


// If it is already a QByteArray then use it rather than make an unnecessary
// copy of the data.
if (sipCanConvertToType(sipPy, sipType_QByteArray, SIP_NO_CONVERTORS))
{
    *sipCppPtr = reinterpret_cast<QByteArray *>(
            sipConvertToType(sipPy, sipType_QByteArray, sipTransferObj,
            SIP_NO_CONVERTORS, 0, sipIsErr));

    return 0;
}

// Create a QByteArray from the data.
sipBufferInfoDef buffer_info;

if (sipGetBufferInfo(sipPy, &buffer_info) > 0)
{
    // Check that the buffer is compatible with one defined by
    // PyBuffer_FillInfo() as used by QByteArray and the standard Python byte
    // objects.
    if (buffer_info.bi_format == NULL || buffer_info.bi_format[0] == 'B')
    {
        *sipCppPtr = new QByteArray(
                reinterpret_cast<const char *>(buffer_info.bi_buf),
                (qsizetype)buffer_info.bi_len);

        sipReleaseBufferInfo(&buffer_info);

        // We don't support transfer of ownership.
        return SIP_TEMPORARY;
    }

    PyErr_Format(PyExc_TypeError, "unsupported buffer format '%s'",
            buffer_info.bi_format);

    sipReleaseBufferInfo(&buffer_info);
}

*sipIsErr = 1;

return 0;
#line 3141 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQByteArray.cpp"
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QByteArray[] = {
    {(void *)slot_QByteArray___add__, add_slot},
    {(void *)slot_QByteArray___imul__, irepeat_slot},
    {(void *)slot_QByteArray___mul__, repeat_slot},
    {(void *)slot_QByteArray___repr__, repr_slot},
    {(void *)slot_QByteArray___str__, str_slot},
    {(void *)slot_QByteArray___hash__, hash_slot},
    {(void *)slot_QByteArray___contains__, contains_slot},
    {(void *)slot_QByteArray___getitem__, getitem_slot},
    {(void *)slot_QByteArray___len__, len_slot},
    {(void *)slot_QByteArray___ge__, ge_slot},
    {(void *)slot_QByteArray___le__, le_slot},
    {(void *)slot_QByteArray___gt__, gt_slot},
    {(void *)slot_QByteArray___lt__, lt_slot},
    {(void *)slot_QByteArray___ne__, ne_slot},
    {(void *)slot_QByteArray___eq__, eq_slot},
    {(void *)slot_QByteArray___iadd__, iconcat_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QByteArray[] = {
    {sipName_append, meth_QByteArray_append, METH_VARARGS, doc_QByteArray_append},
    {sipName_at, meth_QByteArray_at, METH_VARARGS, doc_QByteArray_at},
    {sipName_capacity, meth_QByteArray_capacity, METH_VARARGS, doc_QByteArray_capacity},
    {sipName_chop, meth_QByteArray_chop, METH_VARARGS, doc_QByteArray_chop},
    {sipName_chopped, meth_QByteArray_chopped, METH_VARARGS, doc_QByteArray_chopped},
    {sipName_clear, meth_QByteArray_clear, METH_VARARGS, doc_QByteArray_clear},
    {sipName_compare, SIP_MLMETH_CAST(meth_QByteArray_compare), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_compare},
    {sipName_contains, meth_QByteArray_contains, METH_VARARGS, doc_QByteArray_contains},
    {sipName_count, meth_QByteArray_count, METH_VARARGS, doc_QByteArray_count},
    {sipName_data, meth_QByteArray_data, METH_VARARGS, doc_QByteArray_data},
    {sipName_endsWith, meth_QByteArray_endsWith, METH_VARARGS, doc_QByteArray_endsWith},
    {sipName_fill, SIP_MLMETH_CAST(meth_QByteArray_fill), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_fill},
    {sipName_first, meth_QByteArray_first, METH_VARARGS, doc_QByteArray_first},
    {sipName_fromBase64, SIP_MLMETH_CAST(meth_QByteArray_fromBase64), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_fromBase64},
    {sipName_fromBase64Encoding, SIP_MLMETH_CAST(meth_QByteArray_fromBase64Encoding), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_fromBase64Encoding},
    {sipName_fromHex, meth_QByteArray_fromHex, METH_VARARGS, doc_QByteArray_fromHex},
    {sipName_fromPercentEncoding, SIP_MLMETH_CAST(meth_QByteArray_fromPercentEncoding), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_fromPercentEncoding},
    {sipName_indexOf, SIP_MLMETH_CAST(meth_QByteArray_indexOf), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_indexOf},
    {sipName_insert, meth_QByteArray_insert, METH_VARARGS, doc_QByteArray_insert},
    {sipName_isEmpty, meth_QByteArray_isEmpty, METH_VARARGS, doc_QByteArray_isEmpty},
    {sipName_isLower, meth_QByteArray_isLower, METH_VARARGS, doc_QByteArray_isLower},
    {sipName_isNull, meth_QByteArray_isNull, METH_VARARGS, doc_QByteArray_isNull},
    {sipName_isUpper, meth_QByteArray_isUpper, METH_VARARGS, doc_QByteArray_isUpper},
    {sipName_isValidUtf8, meth_QByteArray_isValidUtf8, METH_VARARGS, doc_QByteArray_isValidUtf8},
    {sipName_last, meth_QByteArray_last, METH_VARARGS, doc_QByteArray_last},
    {sipName_lastIndexOf, SIP_MLMETH_CAST(meth_QByteArray_lastIndexOf), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_lastIndexOf},
    {sipName_left, meth_QByteArray_left, METH_VARARGS, doc_QByteArray_left},
    {sipName_leftJustified, SIP_MLMETH_CAST(meth_QByteArray_leftJustified), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_leftJustified},
    {sipName_length, meth_QByteArray_length, METH_VARARGS, doc_QByteArray_length},
    {sipName_mid, SIP_MLMETH_CAST(meth_QByteArray_mid), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_mid},
    {sipName_number, SIP_MLMETH_CAST(meth_QByteArray_number), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_number},
    {sipName_prepend, meth_QByteArray_prepend, METH_VARARGS, doc_QByteArray_prepend},
    {sipName_push_back, meth_QByteArray_push_back, METH_VARARGS, doc_QByteArray_push_back},
    {sipName_push_front, meth_QByteArray_push_front, METH_VARARGS, doc_QByteArray_push_front},
    {sipName_remove, meth_QByteArray_remove, METH_VARARGS, doc_QByteArray_remove},
    {sipName_repeated, meth_QByteArray_repeated, METH_VARARGS, doc_QByteArray_repeated},
    {sipName_replace, meth_QByteArray_replace, METH_VARARGS, doc_QByteArray_replace},
    {sipName_reserve, meth_QByteArray_reserve, METH_VARARGS, doc_QByteArray_reserve},
    {sipName_resize, meth_QByteArray_resize, METH_VARARGS, doc_QByteArray_resize},
    {sipName_right, meth_QByteArray_right, METH_VARARGS, doc_QByteArray_right},
    {sipName_rightJustified, SIP_MLMETH_CAST(meth_QByteArray_rightJustified), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_rightJustified},
    {sipName_setNum, SIP_MLMETH_CAST(meth_QByteArray_setNum), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_setNum},
    {sipName_simplified, meth_QByteArray_simplified, METH_VARARGS, doc_QByteArray_simplified},
    {sipName_size, meth_QByteArray_size, METH_VARARGS, doc_QByteArray_size},
    {sipName_sliced, meth_QByteArray_sliced, METH_VARARGS, doc_QByteArray_sliced},
    {sipName_split, meth_QByteArray_split, METH_VARARGS, doc_QByteArray_split},
    {sipName_squeeze, meth_QByteArray_squeeze, METH_VARARGS, doc_QByteArray_squeeze},
    {sipName_startsWith, meth_QByteArray_startsWith, METH_VARARGS, doc_QByteArray_startsWith},
    {sipName_swap, meth_QByteArray_swap, METH_VARARGS, doc_QByteArray_swap},
    {sipName_toBase64, SIP_MLMETH_CAST(meth_QByteArray_toBase64), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_toBase64},
    {sipName_toDouble, SIP_MLMETH_CAST(meth_QByteArray_toDouble), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_toDouble},
    {sipName_toFloat, SIP_MLMETH_CAST(meth_QByteArray_toFloat), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_toFloat},
    {sipName_toHex, SIP_MLMETH_CAST(meth_QByteArray_toHex), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_toHex},
    {sipName_toInt, SIP_MLMETH_CAST(meth_QByteArray_toInt), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_toInt},
    {sipName_toLong, SIP_MLMETH_CAST(meth_QByteArray_toLong), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_toLong},
    {sipName_toLongLong, SIP_MLMETH_CAST(meth_QByteArray_toLongLong), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_toLongLong},
    {sipName_toLower, meth_QByteArray_toLower, METH_VARARGS, doc_QByteArray_toLower},
    {sipName_toPercentEncoding, SIP_MLMETH_CAST(meth_QByteArray_toPercentEncoding), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_toPercentEncoding},
    {sipName_toShort, SIP_MLMETH_CAST(meth_QByteArray_toShort), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_toShort},
    {sipName_toUInt, SIP_MLMETH_CAST(meth_QByteArray_toUInt), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_toUInt},
    {sipName_toULong, SIP_MLMETH_CAST(meth_QByteArray_toULong), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_toULong},
    {sipName_toULongLong, SIP_MLMETH_CAST(meth_QByteArray_toULongLong), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_toULongLong},
    {sipName_toUShort, SIP_MLMETH_CAST(meth_QByteArray_toUShort), METH_VARARGS|METH_KEYWORDS, doc_QByteArray_toUShort},
    {sipName_toUpper, meth_QByteArray_toUpper, METH_VARARGS, doc_QByteArray_toUpper},
    {sipName_trimmed, meth_QByteArray_trimmed, METH_VARARGS, doc_QByteArray_trimmed},
    {sipName_truncate, meth_QByteArray_truncate, METH_VARARGS, doc_QByteArray_truncate}
};


/* Define the enum members and ints to be added to this type. */
static sipIntInstanceDef intInstances_QByteArray[] = {
    {sipName_Ok, static_cast<int>(::QByteArray::Base64DecodingStatus::Ok)},
    {sipName_IllegalInputLength, static_cast<int>(::QByteArray::Base64DecodingStatus::IllegalInputLength)},
    {sipName_IllegalCharacter, static_cast<int>(::QByteArray::Base64DecodingStatus::IllegalCharacter)},
    {sipName_IllegalPadding, static_cast<int>(::QByteArray::Base64DecodingStatus::IllegalPadding)},
    {sipName_Base64Encoding, static_cast<int>( ::QByteArray::Base64Encoding)},
    {sipName_Base64UrlEncoding, static_cast<int>( ::QByteArray::Base64UrlEncoding)},
    {sipName_KeepTrailingEquals, static_cast<int>( ::QByteArray::KeepTrailingEquals)},
    {sipName_OmitTrailingEquals, static_cast<int>( ::QByteArray::OmitTrailingEquals)},
    {sipName_IgnoreBase64DecodingErrors, static_cast<int>( ::QByteArray::IgnoreBase64DecodingErrors)},
    {sipName_AbortOnBase64DecodingErrors, static_cast<int>( ::QByteArray::AbortOnBase64DecodingErrors)},
    {0, 0}
};

PyDoc_STRVAR(doc_QByteArray, "\1QByteArray()\n"
"QByteArray(int, bytes)\n"
"QByteArray(QByteArray)");


sipClassTypeDef sipTypeDef_QtCore_QByteArray = {
    {
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QByteArray,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        sipNameNr_QByteArray,
        {0, 0, 1},
        66, methods_QByteArray,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, intInstances_QByteArray, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QByteArray,
    -1,
    sipNameNr_PyQt6_sip_simplewrapper,
    SIP_NULLPTR,
    slots_QByteArray,
    init_type_QByteArray,
    SIP_NULLPTR,
    SIP_NULLPTR,
    getbuffer_QByteArray,
    SIP_NULLPTR,
    dealloc_QByteArray,
    assign_QByteArray,
    array_QByteArray,
    copy_QByteArray,
    release_QByteArray,
    SIP_NULLPTR,
    convertTo_QByteArray,
    SIP_NULLPTR,
    SIP_NULLPTR,
    pickle_QByteArray,
    SIP_NULLPTR,
    SIP_NULLPTR
};
