/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.6.1
 *
 * Copyright (c) 2022 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 31 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qjsonarray.sip"
#include <qjsonarray.h>
#line 29 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQJsonArray.cpp"



extern "C" {static void assign_QJsonArray(void *, Py_ssize_t, void *);}
static void assign_QJsonArray(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QJsonArray *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QJsonArray *>(sipSrc);
}


extern "C" {static void *array_QJsonArray(Py_ssize_t);}
static void *array_QJsonArray(Py_ssize_t sipNrElem)
{
    return new  ::QJsonArray[sipNrElem];
}


extern "C" {static void *copy_QJsonArray(const void *, Py_ssize_t);}
static void *copy_QJsonArray(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new  ::QJsonArray(reinterpret_cast<const  ::QJsonArray *>(sipSrc)[sipSrcIdx]);
}


/* Call the mapped type's destructor. */
extern "C" {static void release_QJsonArray(void *, int, void *);}
static void release_QJsonArray(void *sipCppV, int, void *)
{
     ::QJsonArray *sipCpp = reinterpret_cast< ::QJsonArray *>(sipCppV);
    delete sipCpp;
}



extern "C" {static int convertTo_QJsonArray(PyObject *, void **, int *, PyObject *, void **);}
static int convertTo_QJsonArray(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj, void **)
{
     ::QJsonArray **sipCppPtr = reinterpret_cast< ::QJsonArray **>(sipCppPtrV);

#line 61 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qjsonarray.sip"
    PyObject *iter = PyObject_GetIter(sipPy);

    if (!sipIsErr)
    {
        PyErr_Clear();
        Py_XDECREF(iter);

        return (iter && !PyUnicode_Check(sipPy));
    }

    if (!iter)
    {
        *sipIsErr = 1;

        return 0;
    }

    QJsonArray *ql = new QJsonArray;
 
    for (Py_ssize_t i = 0; ; ++i)
    {
        PyErr_Clear();
        PyObject *itm = PyIter_Next(iter);

        if (!itm)
        {
            if (PyErr_Occurred())
            {
                delete ql;
                Py_DECREF(iter);
                *sipIsErr = 1;

                return 0;
            }

            break;
        }

        int state;
        QJsonValue *t = reinterpret_cast<QJsonValue *>(
                sipForceConvertToType(itm, sipType_QJsonValue, sipTransferObj,
                        SIP_NOT_NONE, &state, sipIsErr));

        if (*sipIsErr)
        {
            PyErr_Format(PyExc_TypeError,
                    "index %zd has type '%s' but 'QJsonValue' is expected", i,
                    sipPyTypeName(Py_TYPE(itm)));

            Py_DECREF(itm);
            delete ql;
            Py_DECREF(iter);

            return 0;
        }

        ql->append(*t);

        sipReleaseType(t, sipType_QJsonValue, state);
        Py_DECREF(itm);
    }
 
    Py_DECREF(iter);

    *sipCppPtr = ql;
 
    return sipGetState(sipTransferObj);
#line 137 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQJsonArray.cpp"
}


extern "C" {static PyObject *convertFrom_QJsonArray(void *, PyObject *);}
static PyObject *convertFrom_QJsonArray(void *sipCppV, PyObject *sipTransferObj)
{
    ::QJsonArray *sipCpp = reinterpret_cast< ::QJsonArray *>(sipCppV);

#line 35 "/build/pyqt6/src/PyQt6-6.3.0/sip/QtCore/qjsonarray.sip"
    PyObject *l = PyList_New(sipCpp->size());

    if (!l)
        return 0;

    for (int i = 0; i < sipCpp->size(); ++i)
    {
        QJsonValue *t = new QJsonValue(sipCpp->at(i));
        PyObject *tobj = sipConvertFromNewType(t, sipType_QJsonValue,
                sipTransferObj);

        if (!tobj)
        {
            delete t;
            Py_DECREF(l);

            return 0;
        }

        PyList_SetItem(l, i, tobj);
    }

    return l;
#line 170 "/build/pyqt6/src/PyQt6-6.3.0/build/QtCore/sipQtCoreQJsonArray.cpp"
}


sipMappedTypeDef sipTypeDef_QtCore_QJsonArray = {
    {
        SIP_NULLPTR,
        SIP_TYPE_MAPPED,
        sipNameNr_QJsonArray,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        -1,
        {0, 0, 1},
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    },
    assign_QJsonArray,
    array_QJsonArray,
    copy_QJsonArray,
    release_QJsonArray,
    convertTo_QJsonArray,
    convertFrom_QJsonArray
};
