// Copyright (c) 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/extensions/api/generated_api_registration.h"

#include "build/build_config.h"
#include "build/chromeos_buildflags.h"

#include "chrome/browser/extensions/api/enterprise_hardware_platform/enterprise_hardware_platform_api.h"
#include "chrome/browser/extensions/api/webrtc_logging_private/webrtc_logging_private_api.h"

#include "extensions/browser/extension_function_registry.h"

namespace extensions {
namespace api {

// static
void ChromeGeneratedFunctionRegistry::RegisterAll(ExtensionFunctionRegistry* registry) {
  constexpr ExtensionFunctionRegistry::FactoryEntry kEntries[] = {
    {
      &NewExtensionFunction<EnterpriseHardwarePlatformGetHardwarePlatformInfoFunction>,
      EnterpriseHardwarePlatformGetHardwarePlatformInfoFunction::function_name(),
      EnterpriseHardwarePlatformGetHardwarePlatformInfoFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateSetMetaDataFunction>,
      WebrtcLoggingPrivateSetMetaDataFunction::function_name(),
      WebrtcLoggingPrivateSetMetaDataFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateStartFunction>,
      WebrtcLoggingPrivateStartFunction::function_name(),
      WebrtcLoggingPrivateStartFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateSetUploadOnRenderCloseFunction>,
      WebrtcLoggingPrivateSetUploadOnRenderCloseFunction::function_name(),
      WebrtcLoggingPrivateSetUploadOnRenderCloseFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateStopFunction>,
      WebrtcLoggingPrivateStopFunction::function_name(),
      WebrtcLoggingPrivateStopFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateStoreFunction>,
      WebrtcLoggingPrivateStoreFunction::function_name(),
      WebrtcLoggingPrivateStoreFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateUploadStoredFunction>,
      WebrtcLoggingPrivateUploadStoredFunction::function_name(),
      WebrtcLoggingPrivateUploadStoredFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateUploadFunction>,
      WebrtcLoggingPrivateUploadFunction::function_name(),
      WebrtcLoggingPrivateUploadFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateDiscardFunction>,
      WebrtcLoggingPrivateDiscardFunction::function_name(),
      WebrtcLoggingPrivateDiscardFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateStartRtpDumpFunction>,
      WebrtcLoggingPrivateStartRtpDumpFunction::function_name(),
      WebrtcLoggingPrivateStartRtpDumpFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateStopRtpDumpFunction>,
      WebrtcLoggingPrivateStopRtpDumpFunction::function_name(),
      WebrtcLoggingPrivateStopRtpDumpFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateStartAudioDebugRecordingsFunction>,
      WebrtcLoggingPrivateStartAudioDebugRecordingsFunction::function_name(),
      WebrtcLoggingPrivateStartAudioDebugRecordingsFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateStopAudioDebugRecordingsFunction>,
      WebrtcLoggingPrivateStopAudioDebugRecordingsFunction::function_name(),
      WebrtcLoggingPrivateStopAudioDebugRecordingsFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateStartEventLoggingFunction>,
      WebrtcLoggingPrivateStartEventLoggingFunction::function_name(),
      WebrtcLoggingPrivateStartEventLoggingFunction::histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateGetLogsDirectoryFunction>,
      WebrtcLoggingPrivateGetLogsDirectoryFunction::function_name(),
      WebrtcLoggingPrivateGetLogsDirectoryFunction::histogram_value(),
    },
  };
  for (const auto& entry : kEntries) {
      registry->Register(entry);
  }
}

}  // namespace api
}  // namespace extensions
