// services/network/public/mojom/host_resolver.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/host_resolver.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/network/public/mojom/host_resolver.mojom-params-data.h"
#include "services/network/public/mojom/host_resolver.mojom-shared-message-ids.h"

#include "services/network/public/mojom/host_resolver.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_HOST_RESOLVER_MOJOM_BLINK_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_HOST_RESOLVER_MOJOM_BLINK_JUMBO_H_
#endif
namespace network {
namespace mojom {
namespace blink {
DnsOverHttpsServer::DnsOverHttpsServer()
    : server_template(),
      use_post(false) {}

DnsOverHttpsServer::DnsOverHttpsServer(
    const WTF::String& server_template_in,
    bool use_post_in)
    : server_template(std::move(server_template_in)),
      use_post(std::move(use_post_in)) {}

DnsOverHttpsServer::~DnsOverHttpsServer() = default;
size_t DnsOverHttpsServer::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->server_template);
  seed = mojo::internal::WTFHash(seed, this->use_post);
  return seed;
}

void DnsOverHttpsServer::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("server_template", this->server_template.Utf8());
  value->SetBoolean("use_post", this->use_post);
}

bool DnsOverHttpsServer::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DnsConfigOverrides::DnsConfigOverrides()
    : nameservers(),
      search(),
      append_to_multi_label_name(DnsConfigOverrides_Tristate::NO_OVERRIDE),
      ndots(-1),
      timeout(),
      attempts(-1),
      rotate(DnsConfigOverrides_Tristate::NO_OVERRIDE),
      use_local_ipv6(DnsConfigOverrides_Tristate::NO_OVERRIDE),
      dns_over_https_servers(),
      secure_dns_mode(OptionalSecureDnsMode::NO_OVERRIDE),
      allow_dns_over_https_upgrade(DnsConfigOverrides_Tristate::NO_OVERRIDE),
      disabled_upgrade_providers(),
      clear_hosts(false) {}

DnsConfigOverrides::DnsConfigOverrides(
    base::Optional<WTF::Vector<::net::IPEndPoint>> nameservers_in,
    base::Optional<WTF::Vector<WTF::String>> search_in,
    DnsConfigOverrides::Tristate append_to_multi_label_name_in,
    int8_t ndots_in,
    base::Optional<::base::TimeDelta> timeout_in,
    int32_t attempts_in,
    DnsConfigOverrides::Tristate rotate_in,
    DnsConfigOverrides::Tristate use_local_ipv6_in,
    base::Optional<WTF::Vector<DnsOverHttpsServerPtr>> dns_over_https_servers_in,
    OptionalSecureDnsMode secure_dns_mode_in,
    DnsConfigOverrides::Tristate allow_dns_over_https_upgrade_in,
    base::Optional<WTF::Vector<WTF::String>> disabled_upgrade_providers_in,
    bool clear_hosts_in)
    : nameservers(std::move(nameservers_in)),
      search(std::move(search_in)),
      append_to_multi_label_name(std::move(append_to_multi_label_name_in)),
      ndots(std::move(ndots_in)),
      timeout(std::move(timeout_in)),
      attempts(std::move(attempts_in)),
      rotate(std::move(rotate_in)),
      use_local_ipv6(std::move(use_local_ipv6_in)),
      dns_over_https_servers(std::move(dns_over_https_servers_in)),
      secure_dns_mode(std::move(secure_dns_mode_in)),
      allow_dns_over_https_upgrade(std::move(allow_dns_over_https_upgrade_in)),
      disabled_upgrade_providers(std::move(disabled_upgrade_providers_in)),
      clear_hosts(std::move(clear_hosts_in)) {}

DnsConfigOverrides::~DnsConfigOverrides() = default;

void DnsConfigOverrides::AsValueInto(base::trace_event::TracedValue* value) const {
  if (this->nameservers.has_value()) {
    value->BeginArray("nameservers");
    for (const auto& item0 : this->nameservers.value()) {
      value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::net::IPEndPoint&>"));
    }
    value->EndArray();
  } else {
    value->SetString("nameservers", "base::nullopt");
  }
  if (this->search.has_value()) {
    value->BeginArray("search");
    for (const auto& item0 : this->search.value()) {
      value->AppendString(item0.Utf8());
    }
    value->EndArray();
  } else {
    value->SetString("search", "base::nullopt");
  }
  value->SetString("append_to_multi_label_name", base::trace_event::ValueToString(this->append_to_multi_label_name));
  value->SetInteger("ndots", this->ndots);
  value->SetString("timeout", base::trace_event::ValueToString(this->timeout, "<value of type base::Optional<::base::TimeDelta>>"));
  value->SetInteger("attempts", this->attempts);
  value->SetString("rotate", base::trace_event::ValueToString(this->rotate));
  value->SetString("use_local_ipv6", base::trace_event::ValueToString(this->use_local_ipv6));
  if (this->dns_over_https_servers.has_value()) {
    value->BeginArray("dns_over_https_servers");
    for (const auto& item0 : this->dns_over_https_servers.value()) {
      if (item0.is_null()) {
        value->AppendString("nullptr");
      } else {
        value->BeginDictionary();
        item0->AsValueInto(value);
        value->EndDictionary();
      }
    }
    value->EndArray();
  } else {
    value->SetString("dns_over_https_servers", "base::nullopt");
  }
  value->SetString("secure_dns_mode", base::trace_event::ValueToString(this->secure_dns_mode));
  value->SetString("allow_dns_over_https_upgrade", base::trace_event::ValueToString(this->allow_dns_over_https_upgrade));
  if (this->disabled_upgrade_providers.has_value()) {
    value->BeginArray("disabled_upgrade_providers");
    for (const auto& item0 : this->disabled_upgrade_providers.value()) {
      value->AppendString(item0.Utf8());
    }
    value->EndArray();
  } else {
    value->SetString("disabled_upgrade_providers", "base::nullopt");
  }
  value->SetBoolean("clear_hosts", this->clear_hosts);
}

bool DnsConfigOverrides::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ResolveErrorInfo::ResolveErrorInfo()
    : error(),
      is_secure_network_error(false) {}

ResolveErrorInfo::ResolveErrorInfo(
    int32_t error_in,
    bool is_secure_network_error_in)
    : error(std::move(error_in)),
      is_secure_network_error(std::move(is_secure_network_error_in)) {}

ResolveErrorInfo::~ResolveErrorInfo() = default;
size_t ResolveErrorInfo::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->error);
  seed = mojo::internal::WTFHash(seed, this->is_secure_network_error);
  return seed;
}

void ResolveErrorInfo::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetInteger("error", this->error);
  value->SetBoolean("is_secure_network_error", this->is_secure_network_error);
}

bool ResolveErrorInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ResolveHostParameters::ResolveHostParameters()
    : dns_query_type(DnsQueryType::UNSPECIFIED),
      initial_priority(mojo::internal::ConvertEnumValue<::network::mojom::blink::RequestPriority, ::net::RequestPriority>(::network::mojom::blink::RequestPriority::kLowest)),
      source(ResolveHostParameters_Source::ANY),
      cache_usage(ResolveHostParameters_CacheUsage::ALLOWED),
      control_handle(),
      include_canonical_name(false),
      loopback_only(false),
      is_speculative(false),
      secure_dns_mode_override(OptionalSecureDnsMode::NO_OVERRIDE) {}

ResolveHostParameters::ResolveHostParameters(
    DnsQueryType dns_query_type_in,
    ::net::RequestPriority initial_priority_in,
    ResolveHostParameters::Source source_in,
    ResolveHostParameters::CacheUsage cache_usage_in,
    ::mojo::PendingReceiver<ResolveHostHandle> control_handle_in,
    bool include_canonical_name_in,
    bool loopback_only_in,
    bool is_speculative_in,
    OptionalSecureDnsMode secure_dns_mode_override_in)
    : dns_query_type(std::move(dns_query_type_in)),
      initial_priority(std::move(initial_priority_in)),
      source(std::move(source_in)),
      cache_usage(std::move(cache_usage_in)),
      control_handle(std::move(control_handle_in)),
      include_canonical_name(std::move(include_canonical_name_in)),
      loopback_only(std::move(loopback_only_in)),
      is_speculative(std::move(is_speculative_in)),
      secure_dns_mode_override(std::move(secure_dns_mode_override_in)) {}

ResolveHostParameters::~ResolveHostParameters() = default;

void ResolveHostParameters::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("dns_query_type", base::trace_event::ValueToString(this->dns_query_type));
  value->SetInteger("initial_priority", static_cast<int>(this->initial_priority));
  value->SetString("source", base::trace_event::ValueToString(this->source));
  value->SetString("cache_usage", base::trace_event::ValueToString(this->cache_usage));
  value->SetBoolean("control_handle", this->control_handle.is_valid());
  value->SetBoolean("include_canonical_name", this->include_canonical_name);
  value->SetBoolean("loopback_only", this->loopback_only);
  value->SetBoolean("is_speculative", this->is_speculative);
  value->SetString("secure_dns_mode_override", base::trace_event::ValueToString(this->secure_dns_mode_override));
}

bool ResolveHostParameters::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char ResolveHostHandle::Name_[] = "network.mojom.ResolveHostHandle";

ResolveHostHandleProxy::ResolveHostHandleProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ResolveHostHandleProxy::Cancel(
    int32_t in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::ResolveHostHandle::Cancel", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("result", in_result);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kResolveHostHandle_Cancel_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::ResolveHostHandle_Cancel_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->result = in_result;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResolveHostHandle::Name_);
  message.set_method_name("Cancel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ResolveHostHandleStubDispatch::Accept(
    ResolveHostHandle* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kResolveHostHandle_Cancel_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::ResolveHostHandle::Cancel",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::ResolveHostHandle::Cancel");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ResolveHostHandle_Cancel_Params_Data* params =
          reinterpret_cast<internal::ResolveHostHandle_Cancel_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_result{};
      ResolveHostHandle_Cancel_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_result = input_data_view.result();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResolveHostHandle::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Cancel(
std::move(p_result));
      return true;
    }
  }
  return false;
}

// static
bool ResolveHostHandleStubDispatch::AcceptWithResponder(
    ResolveHostHandle* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kResolveHostHandle_Cancel_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kResolveHostHandleValidationInfo[] = {
    {internal::kResolveHostHandle_Cancel_Name,
     {&internal::ResolveHostHandle_Cancel_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ResolveHostHandleRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::ResolveHostHandle::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kResolveHostHandleValidationInfo);
}

const char ResolveHostClient::Name_[] = "network.mojom.ResolveHostClient";

ResolveHostClientProxy::ResolveHostClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ResolveHostClientProxy::OnComplete(
    int32_t in_result, ResolveErrorInfoPtr in_resolve_error_info, ::network::mojom::blink::AddressListPtr in_resolved_addresses) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::ResolveHostClient::OnComplete", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("result", in_result);
      if (in_resolve_error_info.is_null()) {
        raw_value->SetString("resolve_error_info", "nullptr");
      } else {
        raw_value->BeginDictionary("resolve_error_info");
        in_resolve_error_info->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      if (in_resolved_addresses.is_null()) {
        raw_value->SetString("resolved_addresses", "nullptr");
      } else {
        raw_value->BeginDictionary("resolved_addresses");
        in_resolved_addresses->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kResolveHostClient_OnComplete_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::ResolveHostClient_OnComplete_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->result = in_result;
  typename decltype(params->resolve_error_info)::BaseType::BufferWriter
      resolve_error_info_writer;
  mojo::internal::Serialize<::network::mojom::ResolveErrorInfoDataView>(
      in_resolve_error_info, buffer, &resolve_error_info_writer, &serialization_context);
  params->resolve_error_info.Set(
      resolve_error_info_writer.is_null() ? nullptr : resolve_error_info_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->resolve_error_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null resolve_error_info in ResolveHostClient.OnComplete request");
  typename decltype(params->resolved_addresses)::BaseType::BufferWriter
      resolved_addresses_writer;
  mojo::internal::Serialize<::network::mojom::AddressListDataView>(
      in_resolved_addresses, buffer, &resolved_addresses_writer, &serialization_context);
  params->resolved_addresses.Set(
      resolved_addresses_writer.is_null() ? nullptr : resolved_addresses_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResolveHostClient::Name_);
  message.set_method_name("OnComplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ResolveHostClientProxy::OnTextResults(
    const WTF::Vector<WTF::String>& in_text_results) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::ResolveHostClient::OnTextResults", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("text_results");
      for (const auto& item0 : in_text_results) {
        raw_value->AppendString(item0.Utf8());
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kResolveHostClient_OnTextResults_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::ResolveHostClient_OnTextResults_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->text_results)::BaseType::BufferWriter
      text_results_writer;
  const mojo::internal::ContainerValidateParams text_results_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_text_results, buffer, &text_results_writer, &text_results_validate_params,
      &serialization_context);
  params->text_results.Set(
      text_results_writer.is_null() ? nullptr : text_results_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->text_results.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text_results in ResolveHostClient.OnTextResults request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResolveHostClient::Name_);
  message.set_method_name("OnTextResults");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ResolveHostClientProxy::OnHostnameResults(
    WTF::Vector<::network::mojom::blink::HostPortPairPtr> in_hosts) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::ResolveHostClient::OnHostnameResults", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("hosts");
      for (const auto& item0 : in_hosts) {
        raw_value->AppendString(base::trace_event::ValueToString(item0, "<value of type ::network::mojom::blink::HostPortPairPtr>"));
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kResolveHostClient_OnHostnameResults_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::ResolveHostClient_OnHostnameResults_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->hosts)::BaseType::BufferWriter
      hosts_writer;
  const mojo::internal::ContainerValidateParams hosts_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::HostPortPairDataView>>(
      in_hosts, buffer, &hosts_writer, &hosts_validate_params,
      &serialization_context);
  params->hosts.Set(
      hosts_writer.is_null() ? nullptr : hosts_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->hosts.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null hosts in ResolveHostClient.OnHostnameResults request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResolveHostClient::Name_);
  message.set_method_name("OnHostnameResults");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ResolveHostClientStubDispatch::Accept(
    ResolveHostClient* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kResolveHostClient_OnComplete_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::ResolveHostClient::OnComplete",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::ResolveHostClient::OnComplete");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ResolveHostClient_OnComplete_Params_Data* params =
          reinterpret_cast<internal::ResolveHostClient_OnComplete_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_result{};
      ResolveErrorInfoPtr p_resolve_error_info{};
      ::network::mojom::blink::AddressListPtr p_resolved_addresses{};
      ResolveHostClient_OnComplete_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_result = input_data_view.result();
      if (success && !input_data_view.ReadResolveErrorInfo(&p_resolve_error_info))
        success = false;
      if (success && !input_data_view.ReadResolvedAddresses(&p_resolved_addresses))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResolveHostClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnComplete(
std::move(p_result), 
std::move(p_resolve_error_info), 
std::move(p_resolved_addresses));
      return true;
    }
    case internal::kResolveHostClient_OnTextResults_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::ResolveHostClient::OnTextResults",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::ResolveHostClient::OnTextResults");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ResolveHostClient_OnTextResults_Params_Data* params =
          reinterpret_cast<internal::ResolveHostClient_OnTextResults_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::Vector<WTF::String> p_text_results{};
      ResolveHostClient_OnTextResults_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadTextResults(&p_text_results))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResolveHostClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTextResults(
std::move(p_text_results));
      return true;
    }
    case internal::kResolveHostClient_OnHostnameResults_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::ResolveHostClient::OnHostnameResults",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::ResolveHostClient::OnHostnameResults");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ResolveHostClient_OnHostnameResults_Params_Data* params =
          reinterpret_cast<internal::ResolveHostClient_OnHostnameResults_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::Vector<::network::mojom::blink::HostPortPairPtr> p_hosts{};
      ResolveHostClient_OnHostnameResults_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadHosts(&p_hosts))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResolveHostClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnHostnameResults(
std::move(p_hosts));
      return true;
    }
  }
  return false;
}

// static
bool ResolveHostClientStubDispatch::AcceptWithResponder(
    ResolveHostClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kResolveHostClient_OnComplete_Name: {
      break;
    }
    case internal::kResolveHostClient_OnTextResults_Name: {
      break;
    }
    case internal::kResolveHostClient_OnHostnameResults_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kResolveHostClientValidationInfo[] = {
    {internal::kResolveHostClient_OnComplete_Name,
     {&internal::ResolveHostClient_OnComplete_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kResolveHostClient_OnTextResults_Name,
     {&internal::ResolveHostClient_OnTextResults_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kResolveHostClient_OnHostnameResults_Name,
     {&internal::ResolveHostClient_OnHostnameResults_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ResolveHostClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::ResolveHostClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kResolveHostClientValidationInfo);
}

const char MdnsListenClient::Name_[] = "network.mojom.MdnsListenClient";

MdnsListenClientProxy::MdnsListenClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MdnsListenClientProxy::OnAddressResult(
    MdnsListenClient::UpdateType in_update_type, DnsQueryType in_query_type, const ::net::IPEndPoint& in_endpoint) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::MdnsListenClient::OnAddressResult", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("update_type", base::trace_event::ValueToString(in_update_type));
      raw_value->SetString("query_type", base::trace_event::ValueToString(in_query_type));
      raw_value->SetString("endpoint", base::trace_event::ValueToString(in_endpoint, "<value of type const ::net::IPEndPoint&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMdnsListenClient_OnAddressResult_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::MdnsListenClient_OnAddressResult_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::network::mojom::MdnsListenClient_UpdateType>(
      in_update_type, &params->update_type);
  mojo::internal::Serialize<::network::mojom::DnsQueryType>(
      in_query_type, &params->query_type);
  typename decltype(params->endpoint)::BaseType::BufferWriter
      endpoint_writer;
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_endpoint, buffer, &endpoint_writer, &serialization_context);
  params->endpoint.Set(
      endpoint_writer.is_null() ? nullptr : endpoint_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->endpoint.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null endpoint in MdnsListenClient.OnAddressResult request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MdnsListenClient::Name_);
  message.set_method_name("OnAddressResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MdnsListenClientProxy::OnTextResult(
    MdnsListenClient::UpdateType in_update_type, DnsQueryType in_query_type, const WTF::Vector<WTF::String>& in_text_records) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::MdnsListenClient::OnTextResult", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("update_type", base::trace_event::ValueToString(in_update_type));
      raw_value->SetString("query_type", base::trace_event::ValueToString(in_query_type));
      raw_value->BeginArray("text_records");
      for (const auto& item0 : in_text_records) {
        raw_value->AppendString(item0.Utf8());
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMdnsListenClient_OnTextResult_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::MdnsListenClient_OnTextResult_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::network::mojom::MdnsListenClient_UpdateType>(
      in_update_type, &params->update_type);
  mojo::internal::Serialize<::network::mojom::DnsQueryType>(
      in_query_type, &params->query_type);
  typename decltype(params->text_records)::BaseType::BufferWriter
      text_records_writer;
  const mojo::internal::ContainerValidateParams text_records_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_text_records, buffer, &text_records_writer, &text_records_validate_params,
      &serialization_context);
  params->text_records.Set(
      text_records_writer.is_null() ? nullptr : text_records_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->text_records.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text_records in MdnsListenClient.OnTextResult request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MdnsListenClient::Name_);
  message.set_method_name("OnTextResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MdnsListenClientProxy::OnHostnameResult(
    MdnsListenClient::UpdateType in_update_type, DnsQueryType in_query_type, ::network::mojom::blink::HostPortPairPtr in_host) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::MdnsListenClient::OnHostnameResult", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("update_type", base::trace_event::ValueToString(in_update_type));
      raw_value->SetString("query_type", base::trace_event::ValueToString(in_query_type));
      raw_value->SetString("host", base::trace_event::ValueToString(in_host, "<value of type ::network::mojom::blink::HostPortPairPtr>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMdnsListenClient_OnHostnameResult_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::MdnsListenClient_OnHostnameResult_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::network::mojom::MdnsListenClient_UpdateType>(
      in_update_type, &params->update_type);
  mojo::internal::Serialize<::network::mojom::DnsQueryType>(
      in_query_type, &params->query_type);
  typename decltype(params->host)::BaseType::BufferWriter
      host_writer;
  mojo::internal::Serialize<::network::mojom::HostPortPairDataView>(
      in_host, buffer, &host_writer, &serialization_context);
  params->host.Set(
      host_writer.is_null() ? nullptr : host_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->host.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null host in MdnsListenClient.OnHostnameResult request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MdnsListenClient::Name_);
  message.set_method_name("OnHostnameResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MdnsListenClientProxy::OnUnhandledResult(
    MdnsListenClient::UpdateType in_update_type, DnsQueryType in_query_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::MdnsListenClient::OnUnhandledResult", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("update_type", base::trace_event::ValueToString(in_update_type));
      raw_value->SetString("query_type", base::trace_event::ValueToString(in_query_type));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMdnsListenClient_OnUnhandledResult_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::MdnsListenClient_OnUnhandledResult_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::network::mojom::MdnsListenClient_UpdateType>(
      in_update_type, &params->update_type);
  mojo::internal::Serialize<::network::mojom::DnsQueryType>(
      in_query_type, &params->query_type);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MdnsListenClient::Name_);
  message.set_method_name("OnUnhandledResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool MdnsListenClientStubDispatch::Accept(
    MdnsListenClient* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kMdnsListenClient_OnAddressResult_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::MdnsListenClient::OnAddressResult",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::MdnsListenClient::OnAddressResult");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MdnsListenClient_OnAddressResult_Params_Data* params =
          reinterpret_cast<internal::MdnsListenClient_OnAddressResult_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MdnsListenClient::UpdateType p_update_type{};
      DnsQueryType p_query_type{};
      ::net::IPEndPoint p_endpoint{};
      MdnsListenClient_OnAddressResult_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadUpdateType(&p_update_type))
        success = false;
      if (success && !input_data_view.ReadQueryType(&p_query_type))
        success = false;
      if (success && !input_data_view.ReadEndpoint(&p_endpoint))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MdnsListenClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAddressResult(
std::move(p_update_type), 
std::move(p_query_type), 
std::move(p_endpoint));
      return true;
    }
    case internal::kMdnsListenClient_OnTextResult_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::MdnsListenClient::OnTextResult",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::MdnsListenClient::OnTextResult");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MdnsListenClient_OnTextResult_Params_Data* params =
          reinterpret_cast<internal::MdnsListenClient_OnTextResult_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MdnsListenClient::UpdateType p_update_type{};
      DnsQueryType p_query_type{};
      WTF::Vector<WTF::String> p_text_records{};
      MdnsListenClient_OnTextResult_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadUpdateType(&p_update_type))
        success = false;
      if (success && !input_data_view.ReadQueryType(&p_query_type))
        success = false;
      if (success && !input_data_view.ReadTextRecords(&p_text_records))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MdnsListenClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTextResult(
std::move(p_update_type), 
std::move(p_query_type), 
std::move(p_text_records));
      return true;
    }
    case internal::kMdnsListenClient_OnHostnameResult_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::MdnsListenClient::OnHostnameResult",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::MdnsListenClient::OnHostnameResult");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MdnsListenClient_OnHostnameResult_Params_Data* params =
          reinterpret_cast<internal::MdnsListenClient_OnHostnameResult_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MdnsListenClient::UpdateType p_update_type{};
      DnsQueryType p_query_type{};
      ::network::mojom::blink::HostPortPairPtr p_host{};
      MdnsListenClient_OnHostnameResult_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadUpdateType(&p_update_type))
        success = false;
      if (success && !input_data_view.ReadQueryType(&p_query_type))
        success = false;
      if (success && !input_data_view.ReadHost(&p_host))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MdnsListenClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnHostnameResult(
std::move(p_update_type), 
std::move(p_query_type), 
std::move(p_host));
      return true;
    }
    case internal::kMdnsListenClient_OnUnhandledResult_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::MdnsListenClient::OnUnhandledResult",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::MdnsListenClient::OnUnhandledResult");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MdnsListenClient_OnUnhandledResult_Params_Data* params =
          reinterpret_cast<internal::MdnsListenClient_OnUnhandledResult_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MdnsListenClient::UpdateType p_update_type{};
      DnsQueryType p_query_type{};
      MdnsListenClient_OnUnhandledResult_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadUpdateType(&p_update_type))
        success = false;
      if (success && !input_data_view.ReadQueryType(&p_query_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MdnsListenClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnUnhandledResult(
std::move(p_update_type), 
std::move(p_query_type));
      return true;
    }
  }
  return false;
}

// static
bool MdnsListenClientStubDispatch::AcceptWithResponder(
    MdnsListenClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kMdnsListenClient_OnAddressResult_Name: {
      break;
    }
    case internal::kMdnsListenClient_OnTextResult_Name: {
      break;
    }
    case internal::kMdnsListenClient_OnHostnameResult_Name: {
      break;
    }
    case internal::kMdnsListenClient_OnUnhandledResult_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kMdnsListenClientValidationInfo[] = {
    {internal::kMdnsListenClient_OnAddressResult_Name,
     {&internal::MdnsListenClient_OnAddressResult_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMdnsListenClient_OnTextResult_Name,
     {&internal::MdnsListenClient_OnTextResult_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMdnsListenClient_OnHostnameResult_Name,
     {&internal::MdnsListenClient_OnHostnameResult_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMdnsListenClient_OnUnhandledResult_Name,
     {&internal::MdnsListenClient_OnUnhandledResult_Params_Data::Validate,
      nullptr /* no response */}},
};

bool MdnsListenClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::MdnsListenClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kMdnsListenClientValidationInfo);
}

const char HostResolver::Name_[] = "network.mojom.HostResolver";

class HostResolver_MdnsListen_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  HostResolver_MdnsListen_ForwardToCallback(
      HostResolver::MdnsListenCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  HostResolver::MdnsListenCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(HostResolver_MdnsListen_ForwardToCallback);
};

HostResolverProxy::HostResolverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void HostResolverProxy::ResolveHost(
    ::network::mojom::blink::HostPortPairPtr in_host, ::network::mojom::blink::NetworkIsolationKeyPtr in_network_isolation_key, ResolveHostParametersPtr in_optional_parameters, ::mojo::PendingRemote<ResolveHostClient> in_response_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::HostResolver::ResolveHost", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("host", base::trace_event::ValueToString(in_host, "<value of type ::network::mojom::blink::HostPortPairPtr>"));
      if (in_network_isolation_key.is_null()) {
        raw_value->SetString("network_isolation_key", "nullptr");
      } else {
        raw_value->BeginDictionary("network_isolation_key");
        in_network_isolation_key->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      if (in_optional_parameters.is_null()) {
        raw_value->SetString("optional_parameters", "nullptr");
      } else {
        raw_value->BeginDictionary("optional_parameters");
        in_optional_parameters->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetBoolean("response_client", in_response_client.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kHostResolver_ResolveHost_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::HostResolver_ResolveHost_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->host)::BaseType::BufferWriter
      host_writer;
  mojo::internal::Serialize<::network::mojom::HostPortPairDataView>(
      in_host, buffer, &host_writer, &serialization_context);
  params->host.Set(
      host_writer.is_null() ? nullptr : host_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->host.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null host in HostResolver.ResolveHost request");
  typename decltype(params->network_isolation_key)::BaseType::BufferWriter
      network_isolation_key_writer;
  mojo::internal::Serialize<::network::mojom::NetworkIsolationKeyDataView>(
      in_network_isolation_key, buffer, &network_isolation_key_writer, &serialization_context);
  params->network_isolation_key.Set(
      network_isolation_key_writer.is_null() ? nullptr : network_isolation_key_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->network_isolation_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null network_isolation_key in HostResolver.ResolveHost request");
  typename decltype(params->optional_parameters)::BaseType::BufferWriter
      optional_parameters_writer;
  mojo::internal::Serialize<::network::mojom::ResolveHostParametersDataView>(
      in_optional_parameters, buffer, &optional_parameters_writer, &serialization_context);
  params->optional_parameters.Set(
      optional_parameters_writer.is_null() ? nullptr : optional_parameters_writer.data());
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::ResolveHostClientInterfaceBase>>(
      in_response_client, &params->response_client, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->response_client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid response_client in HostResolver.ResolveHost request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HostResolver::Name_);
  message.set_method_name("ResolveHost");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void HostResolverProxy::MdnsListen(
    ::network::mojom::blink::HostPortPairPtr in_host, DnsQueryType in_query_type, ::mojo::PendingRemote<MdnsListenClient> in_response_client, MdnsListenCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::HostResolver::MdnsListen", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("host", base::trace_event::ValueToString(in_host, "<value of type ::network::mojom::blink::HostPortPairPtr>"));
      raw_value->SetString("query_type", base::trace_event::ValueToString(in_query_type));
      raw_value->SetBoolean("response_client", in_response_client.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kHostResolver_MdnsListen_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::HostResolver_MdnsListen_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->host)::BaseType::BufferWriter
      host_writer;
  mojo::internal::Serialize<::network::mojom::HostPortPairDataView>(
      in_host, buffer, &host_writer, &serialization_context);
  params->host.Set(
      host_writer.is_null() ? nullptr : host_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->host.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null host in HostResolver.MdnsListen request");
  mojo::internal::Serialize<::network::mojom::DnsQueryType>(
      in_query_type, &params->query_type);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::MdnsListenClientInterfaceBase>>(
      in_response_client, &params->response_client, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->response_client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid response_client in HostResolver.MdnsListen request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HostResolver::Name_);
  message.set_method_name("MdnsListen");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new HostResolver_MdnsListen_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class HostResolver_MdnsListen_ProxyToResponder {
 public:
  static HostResolver::MdnsListenCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<HostResolver_MdnsListen_ProxyToResponder> proxy(
        new HostResolver_MdnsListen_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&HostResolver_MdnsListen_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~HostResolver_MdnsListen_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  HostResolver_MdnsListen_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "HostResolver::MdnsListenCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(HostResolver_MdnsListen_ProxyToResponder);
};

bool HostResolver_MdnsListen_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::HostResolver::MdnsListenCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::HostResolver_MdnsListen_ResponseParams_Data* params =
      reinterpret_cast<
          internal::HostResolver_MdnsListen_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  int32_t p_result{};
  HostResolver_MdnsListen_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        HostResolver::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void HostResolver_MdnsListen_ProxyToResponder::Run(
    int32_t in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::HostResolver::MdnsListenCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("result", in_result);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kHostResolver_MdnsListen_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::HostResolver_MdnsListen_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->result = in_result;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::HostResolver::MdnsListenCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HostResolver::Name_);
  message.set_method_name("MdnsListen");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool HostResolverStubDispatch::Accept(
    HostResolver* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kHostResolver_ResolveHost_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::HostResolver::ResolveHost",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::HostResolver::ResolveHost");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::HostResolver_ResolveHost_Params_Data* params =
          reinterpret_cast<internal::HostResolver_ResolveHost_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::network::mojom::blink::HostPortPairPtr p_host{};
      ::network::mojom::blink::NetworkIsolationKeyPtr p_network_isolation_key{};
      ResolveHostParametersPtr p_optional_parameters{};
      ::mojo::PendingRemote<ResolveHostClient> p_response_client{};
      HostResolver_ResolveHost_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadHost(&p_host))
        success = false;
      if (success && !input_data_view.ReadNetworkIsolationKey(&p_network_isolation_key))
        success = false;
      if (success && !input_data_view.ReadOptionalParameters(&p_optional_parameters))
        success = false;
      if (success) {
        p_response_client =
            input_data_view.TakeResponseClient<decltype(p_response_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HostResolver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResolveHost(
std::move(p_host), 
std::move(p_network_isolation_key), 
std::move(p_optional_parameters), 
std::move(p_response_client));
      return true;
    }
    case internal::kHostResolver_MdnsListen_Name: {
      break;
    }
  }
  return false;
}

// static
bool HostResolverStubDispatch::AcceptWithResponder(
    HostResolver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kHostResolver_ResolveHost_Name: {
      break;
    }
    case internal::kHostResolver_MdnsListen_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::HostResolver::MdnsListen",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::HostResolver::MdnsListen");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::HostResolver_MdnsListen_Params_Data* params =
          reinterpret_cast<
              internal::HostResolver_MdnsListen_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::network::mojom::blink::HostPortPairPtr p_host{};
      DnsQueryType p_query_type{};
      ::mojo::PendingRemote<MdnsListenClient> p_response_client{};
      HostResolver_MdnsListen_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadHost(&p_host))
        success = false;
      if (success && !input_data_view.ReadQueryType(&p_query_type))
        success = false;
      if (success) {
        p_response_client =
            input_data_view.TakeResponseClient<decltype(p_response_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HostResolver::Name_, 1, false);
        return false;
      }
      HostResolver::MdnsListenCallback callback =
          HostResolver_MdnsListen_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MdnsListen(
std::move(p_host), 
std::move(p_query_type), 
std::move(p_response_client), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kHostResolverValidationInfo[] = {
    {internal::kHostResolver_ResolveHost_Name,
     {&internal::HostResolver_ResolveHost_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kHostResolver_MdnsListen_Name,
     {&internal::HostResolver_MdnsListen_Params_Data::Validate,
      &internal::HostResolver_MdnsListen_ResponseParams_Data::Validate}},
};

bool HostResolverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::HostResolver::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kHostResolverValidationInfo);
}

bool HostResolverResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::HostResolver::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kHostResolverValidationInfo);

}
const char DnsConfigChangeManagerClient::Name_[] = "network.mojom.DnsConfigChangeManagerClient";

DnsConfigChangeManagerClientProxy::DnsConfigChangeManagerClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DnsConfigChangeManagerClientProxy::OnDnsConfigChanged(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::DnsConfigChangeManagerClient::OnDnsConfigChanged");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDnsConfigChangeManagerClient_OnDnsConfigChanged_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::DnsConfigChangeManagerClient_OnDnsConfigChanged_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DnsConfigChangeManagerClient::Name_);
  message.set_method_name("OnDnsConfigChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool DnsConfigChangeManagerClientStubDispatch::Accept(
    DnsConfigChangeManagerClient* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kDnsConfigChangeManagerClient_OnDnsConfigChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::DnsConfigChangeManagerClient::OnDnsConfigChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::DnsConfigChangeManagerClient::OnDnsConfigChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DnsConfigChangeManagerClient_OnDnsConfigChanged_Params_Data* params =
          reinterpret_cast<internal::DnsConfigChangeManagerClient_OnDnsConfigChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      DnsConfigChangeManagerClient_OnDnsConfigChanged_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DnsConfigChangeManagerClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDnsConfigChanged();
      return true;
    }
  }
  return false;
}

// static
bool DnsConfigChangeManagerClientStubDispatch::AcceptWithResponder(
    DnsConfigChangeManagerClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDnsConfigChangeManagerClient_OnDnsConfigChanged_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDnsConfigChangeManagerClientValidationInfo[] = {
    {internal::kDnsConfigChangeManagerClient_OnDnsConfigChanged_Name,
     {&internal::DnsConfigChangeManagerClient_OnDnsConfigChanged_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DnsConfigChangeManagerClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::DnsConfigChangeManagerClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kDnsConfigChangeManagerClientValidationInfo);
}

const char DnsConfigChangeManager::Name_[] = "network.mojom.DnsConfigChangeManager";

DnsConfigChangeManagerProxy::DnsConfigChangeManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DnsConfigChangeManagerProxy::RequestNotifications(
    ::mojo::PendingRemote<DnsConfigChangeManagerClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::DnsConfigChangeManager::RequestNotifications", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("client", in_client.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kDnsConfigChangeManager_RequestNotifications_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::DnsConfigChangeManager_RequestNotifications_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::DnsConfigChangeManagerClientInterfaceBase>>(
      in_client, &params->client, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in DnsConfigChangeManager.RequestNotifications request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DnsConfigChangeManager::Name_);
  message.set_method_name("RequestNotifications");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool DnsConfigChangeManagerStubDispatch::Accept(
    DnsConfigChangeManager* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kDnsConfigChangeManager_RequestNotifications_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::DnsConfigChangeManager::RequestNotifications",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::DnsConfigChangeManager::RequestNotifications");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DnsConfigChangeManager_RequestNotifications_Params_Data* params =
          reinterpret_cast<internal::DnsConfigChangeManager_RequestNotifications_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<DnsConfigChangeManagerClient> p_client{};
      DnsConfigChangeManager_RequestNotifications_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DnsConfigChangeManager::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestNotifications(
std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool DnsConfigChangeManagerStubDispatch::AcceptWithResponder(
    DnsConfigChangeManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDnsConfigChangeManager_RequestNotifications_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDnsConfigChangeManagerValidationInfo[] = {
    {internal::kDnsConfigChangeManager_RequestNotifications_Name,
     {&internal::DnsConfigChangeManager_RequestNotifications_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DnsConfigChangeManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::DnsConfigChangeManager::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kDnsConfigChangeManagerValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::blink::DnsOverHttpsServer::DataView, ::network::mojom::blink::DnsOverHttpsServerPtr>::Read(
    ::network::mojom::blink::DnsOverHttpsServer::DataView input,
    ::network::mojom::blink::DnsOverHttpsServerPtr* output) {
  bool success = true;
  ::network::mojom::blink::DnsOverHttpsServerPtr result(::network::mojom::blink::DnsOverHttpsServer::New());
  
      if (success && !input.ReadServerTemplate(&result->server_template))
        success = false;
      if (success)
        result->use_post = input.use_post();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::DnsConfigOverrides::DataView, ::network::mojom::blink::DnsConfigOverridesPtr>::Read(
    ::network::mojom::blink::DnsConfigOverrides::DataView input,
    ::network::mojom::blink::DnsConfigOverridesPtr* output) {
  bool success = true;
  ::network::mojom::blink::DnsConfigOverridesPtr result(::network::mojom::blink::DnsConfigOverrides::New());
  
      if (success && !input.ReadNameservers(&result->nameservers))
        success = false;
      if (success && !input.ReadSearch(&result->search))
        success = false;
      if (success && !input.ReadAppendToMultiLabelName(&result->append_to_multi_label_name))
        success = false;
      if (success)
        result->ndots = input.ndots();
      if (success && !input.ReadTimeout(&result->timeout))
        success = false;
      if (success)
        result->attempts = input.attempts();
      if (success && !input.ReadRotate(&result->rotate))
        success = false;
      if (success && !input.ReadUseLocalIpv6(&result->use_local_ipv6))
        success = false;
      if (success && !input.ReadDnsOverHttpsServers(&result->dns_over_https_servers))
        success = false;
      if (success && !input.ReadSecureDnsMode(&result->secure_dns_mode))
        success = false;
      if (success && !input.ReadAllowDnsOverHttpsUpgrade(&result->allow_dns_over_https_upgrade))
        success = false;
      if (success && !input.ReadDisabledUpgradeProviders(&result->disabled_upgrade_providers))
        success = false;
      if (success)
        result->clear_hosts = input.clear_hosts();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::ResolveErrorInfo::DataView, ::network::mojom::blink::ResolveErrorInfoPtr>::Read(
    ::network::mojom::blink::ResolveErrorInfo::DataView input,
    ::network::mojom::blink::ResolveErrorInfoPtr* output) {
  bool success = true;
  ::network::mojom::blink::ResolveErrorInfoPtr result(::network::mojom::blink::ResolveErrorInfo::New());
  
      if (success)
        result->error = input.error();
      if (success)
        result->is_secure_network_error = input.is_secure_network_error();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::ResolveHostParameters::DataView, ::network::mojom::blink::ResolveHostParametersPtr>::Read(
    ::network::mojom::blink::ResolveHostParameters::DataView input,
    ::network::mojom::blink::ResolveHostParametersPtr* output) {
  bool success = true;
  ::network::mojom::blink::ResolveHostParametersPtr result(::network::mojom::blink::ResolveHostParameters::New());
  
      if (success && !input.ReadDnsQueryType(&result->dns_query_type))
        success = false;
      if (success && !input.ReadInitialPriority(&result->initial_priority))
        success = false;
      if (success && !input.ReadSource(&result->source))
        success = false;
      if (success && !input.ReadCacheUsage(&result->cache_usage))
        success = false;
      if (success) {
        result->control_handle =
            input.TakeControlHandle<decltype(result->control_handle)>();
      }
      if (success)
        result->include_canonical_name = input.include_canonical_name();
      if (success)
        result->loopback_only = input.loopback_only();
      if (success)
        result->is_speculative = input.is_speculative();
      if (success && !input.ReadSecureDnsModeOverride(&result->secure_dns_mode_override))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif